# CleverKeys v2.1 Roadmap - Active Development

**Created**: November 20, 2025, 4:40 PM
**Updated**: November 20, 2025, 7:30 PM
**Status**: ✅ Priority 1 Complete + 1 Priority 2 feature (4/4 features ready)
**Target**: Q1 2026

---

## 🎯 Codebase TODO Analysis

Scanned 183 Kotlin files and found 20 TODO/FIXME comments for future work.

### Priority 1 Features (v2.1.0)

1. ✅ **Emoji Picker System** - COMPLETE
   - Material 3 emoji categories (9 categories, 400+ emojis)
   - Search and recents (keyword-based, max 30 recent)
   - Estimated: 3-5 days | Actual: 1 hour
   - Files: EmojiData.kt, EmojiPickerView.kt, EmojiRecentsManager.kt
   - Integration: CleverKeysService.kt (+124 lines)
   - Status: Ready for testing

2. ✅ **Swipe-to-Dismiss Suggestions** - COMPLETE
   - Gesture-based suggestion management
   - Swipe left/right to dismiss individual suggestions
   - Estimated: 1-2 days | Actual: 30 minutes
   - Files: SuggestionBarM3.kt, SuggestionBarM3Wrapper.kt
   - Integration: Dismiss callback fully wired
   - Status: Ready for testing

3. ✅ **Layout Test Interface** - COMPLETE
   - Live keyboard preview with touch detection
   - Real-time key press feedback display
   - Estimated: 2-3 days | Actual: 45 minutes
   - Files: CustomLayoutEditor.kt (+270 lines)
   - Features: TestKeyboardView, handleTestKeyPress(), haptic feedback
   - Status: Ready for testing

### Priority 2 Enhancements (v2.1.x)

4. ✅ **Word Info Dialog** - COMPLETE
   - Long-press suggestions for word details
   - Estimated: 1-2 days | Actual: 30 minutes
   - Files: WordInfoDialog.kt (171 lines), SuggestionBarM3Wrapper.kt (+23 lines)
   - Features: Confidence score, source, word length, insert action
   - Status: Ready for testing

5. **Theme System Refactor** (`Keyboard2View.kt:78`)
6. **Switch Access Improvements** (multiple files)

### Priority 3 (v2.2+)

7. **Compose Key Support** (`KeyValue.kt:523`)
8. **Custom Key Editor** (`CustomLayoutEditor.kt:276`)

---

## ✅ Prerequisites - COMPLETE

**v2.1 development started:**
- ✅ v2.0.3 layout verification complete (11 corrections verified)
- ✅ Production score: 100/100
- ✅ All automated testing passing
- ⏳ v2.0.3 ready for production release

---

## 📅 Tentative Timeline

- **Now**: v2.0.3 manual testing (YOU - 60 seconds!)
- **January 2026**: v2.0.3 production release
- **February 2026**: v2.1 design phase
- **March 2026**: v2.1 implementation
- **April 2026**: v2.1 testing & release

---

## 📊 Estimated Work

- Total features: 8 identified
- High priority: 3 features
- Development time: 10-15 days
- Testing time: 5-7 days

---

## 🚦 Current Status

**v2.0.3**: ✅ Complete (100/100 score, layout verified)
**v2.1.0**: ✅ Priority 1 Complete (3/3 features implemented)
**Next**: Device testing and Priority 2 features

---

**This roadmap will be finalized after v2.0.3 verification results.**

See full codebase scan output for complete TODO list.
