# Core Keyboard System Specification

## Feature Overview
**Feature Name**: Core Keyboard System
**Priority**: P0 (Critical)
**Status**: Maintenance & Enhancement
**Target Version**: v1.0.0

### Summary
The core keyboard system handles fundamental keyboard operations including view initialization, key event processing, layout management, service integration, and input connection handling.

### Motivation
The core keyboard system is the foundation of CleverKeys. It must be rock-solid, performant, and properly integrated with Android's InputMethodService framework.

---

## ⚠️ KNOWN ISSUES (From Historical Review)

### CRITICAL Issues (Fixed)

#### ✅ Issue #1: Keyboard2View Config Initialization Crash Risk
**File:** `src/main/kotlin/tribixbite/keyboard2/Keyboard2View.kt:89`
**Status**: ✅ FIXED
**Original Problem**: `config = Config.globalConfig()` called in init block would crash if view created outside InputMethodService context
**Fix Applied**: Added null-safety check and lazy initialization
**Verification Needed**: Manual testing of view lifecycle edge cases

#### ✅ Issue #3: Layout Switching Not Implemented
**File:** `CleverKeysService.kt:198-210`
**Status**: ✅ FIXED
**Original Problem**: Layout switching, numeric layout, emoji layout handlers were stubs
**Fix Applied**: All layout switching methods fully implemented in CleverKeysService and Keyboard2.kt
**Verification Needed**: Test all layout switching during runtime

### HIGH PRIORITY Issues (Fixed)

#### ✅ Issue #7: Hardware Acceleration - VERIFIED FIXED
**File:** `AndroidManifest.xml:3,17`
**Status**: ✅ VERIFIED (2025-10-21)
**Original Problem**: `android:hardwareAccelerated="false"` caused severe rendering performance degradation
**Verification Result**: **ALREADY ENABLED** ✅
- AndroidManifest.xml:3 - `<manifest android:hardwareAccelerated="true">`
- AndroidManifest.xml:17 - `<application android:hardwareAccelerated="true">`
**Action Required** (Testing only):
- [x] Verify AndroidManifest.xml has `hardwareAccelerated="true"` ✅
- [ ] Test ONNX model compatibility with hardware acceleration
- [ ] Profile rendering performance (should be 60fps)
- [ ] Document any compatibility issues
**See also**: performance-optimization.md for full details

#### ✅ Issue #8: Key Event Handlers Not Implemented
**File:** `src/main/kotlin/tribixbite/keyboard2/KeyEventHandler.kt`
**Status**: ⚠️ NEEDS VERIFICATION
**Original Problems**:
- Line 129: Modifier key handling
- Line 137: Compose key handling
- Line 144: Caps lock toggle
- Line 268: Proper modifier checking
**Action Required**:
- [ ] Review KeyEventHandler.kt lines 129, 137, 144, 268
- [ ] Verify modifier key handling works correctly
- [ ] Test compose key sequences
- [ ] Test caps lock behavior
- [ ] Add unit tests for key event processing

#### ✅ Issue #10: Service Integration Broken in Keyboard2.kt
**File:** `src/main/kotlin/tribixbite/keyboard2/Keyboard2.kt:116`
**Status**: ⚠️ NEEDS VERIFICATION
**Original Problem**: `// TODO: Fix service integration - this@Keyboard2 is not CleverKeysService`
**Action Required**:
- [ ] Review Keyboard2.kt:116 area
- [ ] Verify service reference passing works correctly
- [ ] Test keyboard-service communication
- [ ] Document the service integration pattern

### MEDIUM PRIORITY Issues (Fixed)

#### ✅ Issue #16: Key Locking Not Implemented
**File:** `src/main/kotlin/tribixbite/keyboard2/Keyboard2View.kt:651`
**Status**: ⚠️ NEEDS VERIFICATION
**Original Problem**: `// TODO: Implement proper key locking check`
**Impact**: Key locking/sticky keys don't work
**Action Required**:
- [ ] Review Keyboard2View.kt:651
- [ ] Implement key lock state tracking
- [ ] Test sticky modifier keys (Shift, Ctrl, Alt)
- [ ] Test caps lock behavior

#### ✅ Issue #19: Input Connection Ctrl Modifier
**File:** `src/main/kotlin/tribixbite/keyboard2/InputConnectionManager.kt:343`
**Status**: ⚠️ NEEDS VERIFICATION
**Original Problem**: `// TODO: Check for ctrl modifier`
**Impact**: Ctrl+key shortcuts don't work
**Action Required**:
- [ ] Review InputConnectionManager.kt:343
- [ ] Add modifier state checking
- [ ] Test Ctrl+A, Ctrl+C, Ctrl+V, Ctrl+X shortcuts
- [ ] Test other common keyboard shortcuts

---

## Requirements

### Functional Requirements
1. **FR-1**: View must initialize safely in all contexts (service, preview, standalone)
2. **FR-2**: All key events must be processed correctly (modifiers, compose, special keys)
3. **FR-3**: Layout switching must work seamlessly at runtime
4. **FR-4**: Service integration must be reliable and type-safe
5. **FR-5**: Input connection must handle all Android text editing scenarios
6. **FR-6**: Key locking (sticky keys) must work correctly
7. **FR-7**: Keyboard shortcuts (Ctrl+key) must be supported

### Non-Functional Requirements
1. **NFR-1**: Performance - Hardware acceleration enabled, 60fps rendering
2. **NFR-2**: Usability - Smooth layout transitions, responsive key presses
3. **NFR-3**: Reliability - No crashes in any view lifecycle scenario

---

## Technical Design

### Architecture
```
CleverKeysService (InputMethodService)
    ├── Keyboard2View (Custom View)
    │   ├── Config (keyboard configuration)
    │   ├── Keyboard2 (key layout logic)
    │   └── Pointers (touch handling)
    ├── KeyEventHandler (key press processing)
    ├── InputConnectionManager (text insertion)
    └── ConfigurationManager (runtime config)
```

### Component Breakdown
1. **CleverKeysService**: Main IME service, lifecycle management
2. **Keyboard2View**: Custom view rendering, touch events
3. **Keyboard2**: Key layout logic, state management
4. **KeyEventHandler**: Event processing, modifier tracking
5. **InputConnectionManager**: Text editing, cursor control

---

## TODO: Verification Tasks

### Phase 1: Critical Verification (P0)
**Duration**: 2-4 hours
**Tasks**:
- [ ] Check AndroidManifest.xml hardware acceleration status
- [ ] Review and test KeyEventHandler.kt modifier handling (lines 129, 137, 144, 268)
- [ ] Verify Keyboard2.kt service integration (line 116)
- [ ] Test layout switching in all scenarios

### Phase 2: Medium Priority Verification (P1)
**Duration**: 2-3 hours
**Tasks**:
- [ ] Review Keyboard2View.kt key locking (line 651)
- [ ] Review InputConnectionManager.kt Ctrl modifier (line 343)
- [ ] Test sticky keys behavior
- [ ] Test keyboard shortcuts (Ctrl+A/C/V/X)

### Phase 3: Performance Testing (P1)
**Duration**: 1-2 hours
**Tasks**:
- [ ] Profile rendering performance with hardware acceleration
- [ ] Benchmark key event latency
- [ ] Test ONNX model compatibility with hardware acceleration
- [ ] Document performance metrics

---

## Testing Strategy

### Unit Tests
- Test case 1: Config initialization in various contexts
- Test case 2: Key event processing with modifiers
- Test case 3: Layout switching state transitions

### Integration Tests
- Test case 1: Service-view communication
- Test case 2: Input connection text editing
- Test case 3: Hardware acceleration compatibility

### Manual Tests
- Test case 1: All layout switching scenarios
- Test case 2: Sticky keys and caps lock
- Test case 3: Keyboard shortcuts (Ctrl+key)
- Test case 4: View lifecycle edge cases

---

## Success Metrics
- Zero crashes in view initialization
- All key events processed correctly (100% pass rate)
- Layout switching works in all scenarios
- 60fps rendering maintained
- All keyboard shortcuts functional

---

**Created**: 2025-10-21
**Last Updated**: 2025-12-04
**Owner**: CleverKeys Development Team
**Status**: Core system implemented and stable

**Note**: File paths in this spec reference `tribixbite/keyboard2/` but the actual
package is `tribixbite/cleverkeys/`. Line numbers may have shifted from original
references due to code evolution.
