"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IonitronCommand = void 0;
const command_1 = require("../lib/command");
class IonitronCommand extends command_1.Command {
    async getMetadata() {
        return {
            name: 'ionitron',
            type: 'global',
            summary: 'Print random ionitron messages',
            options: [
                {
                    name: 'es',
                    summary: 'Print in spanish',
                    type: Boolean,
                },
            ],
            groups: ["hidden" /* MetadataGroup.HIDDEN */],
        };
    }
    async run(inputs, options) {
        const { getIonitronString, ionitronStatements } = await Promise.resolve().then(() => __importStar(require('../lib/ionitron')));
        const locale = options['es'] ? 'es' : 'en';
        const localeStatements = ionitronStatements[locale];
        const statement = localeStatements[Math.floor(Math.random() * (localeStatements.length))];
        this.env.log.rawmsg(getIonitronString(statement));
    }
}
exports.IonitronCommand = IonitronCommand;
