import { CommonModule, DOCUMENT } from '@angular/common';
import { APP_INITIALIZER, NgModule, NgZone } from '@angular/core';
import { ConfigToken, AngularDelegate, provideComponentInputBinding } from '@ionic/angular/common';
import { appInitialize } from './app-initialize';
import { BooleanValueAccessorDirective, NumericValueAccessorDirective, SelectValueAccessorDirective, TextValueAccessorDirective, } from './directives/control-value-accessors';
import { IonBackButton } from './directives/navigation/ion-back-button';
import { IonNav } from './directives/navigation/ion-nav';
import { IonRouterOutlet } from './directives/navigation/ion-router-outlet';
import { IonTabs } from './directives/navigation/ion-tabs';
import { RouterLinkDelegateDirective, RouterLinkWithHrefDelegateDirective, } from './directives/navigation/router-link-delegate';
import { IonModal } from './directives/overlays/modal';
import { IonPopover } from './directives/overlays/popover';
import { DIRECTIVES } from './directives/proxies-list';
import { IonMaxValidator, IonMinValidator } from './directives/validators';
import { ModalController } from './providers/modal-controller';
import { PopoverController } from './providers/popover-controller';
import * as i0 from "@angular/core";
import * as i1 from "./directives/proxies";
const DECLARATIONS = [
    // generated proxies
    ...DIRECTIVES,
    // manual proxies
    IonModal,
    IonPopover,
    // ngModel accessors
    BooleanValueAccessorDirective,
    NumericValueAccessorDirective,
    SelectValueAccessorDirective,
    TextValueAccessorDirective,
    // navigation
    IonTabs,
    IonRouterOutlet,
    IonBackButton,
    IonNav,
    RouterLinkDelegateDirective,
    RouterLinkWithHrefDelegateDirective,
    // validators
    IonMinValidator,
    IonMaxValidator,
];
export class IonicModule {
    static forRoot(config = {}) {
        return {
            ngModule: IonicModule,
            providers: [
                {
                    provide: ConfigToken,
                    useValue: config,
                },
                {
                    provide: APP_INITIALIZER,
                    useFactory: appInitialize,
                    multi: true,
                    deps: [ConfigToken, DOCUMENT, NgZone],
                },
                AngularDelegate,
                provideComponentInputBinding(),
            ],
        };
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonicModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
    /** @nocollapse */ static ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "16.2.12", ngImport: i0, type: IonicModule, declarations: [i1.IonAccordion, i1.IonAccordionGroup, i1.IonActionSheet, i1.IonAlert, i1.IonApp, i1.IonAvatar, i1.IonBackdrop, i1.IonBadge, i1.IonBreadcrumb, i1.IonBreadcrumbs, i1.IonButton, i1.IonButtons, i1.IonCard, i1.IonCardContent, i1.IonCardHeader, i1.IonCardSubtitle, i1.IonCardTitle, i1.IonCheckbox, i1.IonChip, i1.IonCol, i1.IonContent, i1.IonDatetime, i1.IonDatetimeButton, i1.IonFab, i1.IonFabButton, i1.IonFabList, i1.IonFooter, i1.IonGrid, i1.IonHeader, i1.IonIcon, i1.IonImg, i1.IonInfiniteScroll, i1.IonInfiniteScrollContent, i1.IonInput, i1.IonInputOtp, i1.IonInputPasswordToggle, i1.IonItem, i1.IonItemDivider, i1.IonItemGroup, i1.IonItemOption, i1.IonItemOptions, i1.IonItemSliding, i1.IonLabel, i1.IonList, i1.IonListHeader, i1.IonLoading, i1.IonMenu, i1.IonMenuButton, i1.IonMenuToggle, i1.IonNavLink, i1.IonNote, i1.IonPicker, i1.IonPickerColumn, i1.IonPickerColumnOption, i1.IonPickerLegacy, i1.IonProgressBar, i1.IonRadio, i1.IonRadioGroup, i1.IonRange, i1.IonRefresher, i1.IonRefresherContent, i1.IonReorder, i1.IonReorderGroup, i1.IonRippleEffect, i1.IonRow, i1.IonSearchbar, i1.IonSegment, i1.IonSegmentButton, i1.IonSegmentContent, i1.IonSegmentView, i1.IonSelect, i1.IonSelectModal, i1.IonSelectOption, i1.IonSkeletonText, i1.IonSpinner, i1.IonSplitPane, i1.IonTab, i1.IonTabBar, i1.IonTabButton, i1.IonText, i1.IonTextarea, i1.IonThumbnail, i1.IonTitle, i1.IonToast, i1.IonToggle, i1.IonToolbar, 
            // manual proxies
            IonModal,
            IonPopover,
            // ngModel accessors
            BooleanValueAccessorDirective,
            NumericValueAccessorDirective,
            SelectValueAccessorDirective,
            TextValueAccessorDirective,
            // navigation
            IonTabs,
            IonRouterOutlet,
            IonBackButton,
            IonNav,
            RouterLinkDelegateDirective,
            RouterLinkWithHrefDelegateDirective,
            // validators
            IonMinValidator,
            IonMaxValidator], imports: [CommonModule], exports: [i1.IonAccordion, i1.IonAccordionGroup, i1.IonActionSheet, i1.IonAlert, i1.IonApp, i1.IonAvatar, i1.IonBackdrop, i1.IonBadge, i1.IonBreadcrumb, i1.IonBreadcrumbs, i1.IonButton, i1.IonButtons, i1.IonCard, i1.IonCardContent, i1.IonCardHeader, i1.IonCardSubtitle, i1.IonCardTitle, i1.IonCheckbox, i1.IonChip, i1.IonCol, i1.IonContent, i1.IonDatetime, i1.IonDatetimeButton, i1.IonFab, i1.IonFabButton, i1.IonFabList, i1.IonFooter, i1.IonGrid, i1.IonHeader, i1.IonIcon, i1.IonImg, i1.IonInfiniteScroll, i1.IonInfiniteScrollContent, i1.IonInput, i1.IonInputOtp, i1.IonInputPasswordToggle, i1.IonItem, i1.IonItemDivider, i1.IonItemGroup, i1.IonItemOption, i1.IonItemOptions, i1.IonItemSliding, i1.IonLabel, i1.IonList, i1.IonListHeader, i1.IonLoading, i1.IonMenu, i1.IonMenuButton, i1.IonMenuToggle, i1.IonNavLink, i1.IonNote, i1.IonPicker, i1.IonPickerColumn, i1.IonPickerColumnOption, i1.IonPickerLegacy, i1.IonProgressBar, i1.IonRadio, i1.IonRadioGroup, i1.IonRange, i1.IonRefresher, i1.IonRefresherContent, i1.IonReorder, i1.IonReorderGroup, i1.IonRippleEffect, i1.IonRow, i1.IonSearchbar, i1.IonSegment, i1.IonSegmentButton, i1.IonSegmentContent, i1.IonSegmentView, i1.IonSelect, i1.IonSelectModal, i1.IonSelectOption, i1.IonSkeletonText, i1.IonSpinner, i1.IonSplitPane, i1.IonTab, i1.IonTabBar, i1.IonTabButton, i1.IonText, i1.IonTextarea, i1.IonThumbnail, i1.IonTitle, i1.IonToast, i1.IonToggle, i1.IonToolbar, 
            // manual proxies
            IonModal,
            IonPopover,
            // ngModel accessors
            BooleanValueAccessorDirective,
            NumericValueAccessorDirective,
            SelectValueAccessorDirective,
            TextValueAccessorDirective,
            // navigation
            IonTabs,
            IonRouterOutlet,
            IonBackButton,
            IonNav,
            RouterLinkDelegateDirective,
            RouterLinkWithHrefDelegateDirective,
            // validators
            IonMinValidator,
            IonMaxValidator] });
    /** @nocollapse */ static ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonicModule, providers: [ModalController, PopoverController], imports: [CommonModule] });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonicModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: DECLARATIONS,
                    exports: DECLARATIONS,
                    providers: [ModalController, PopoverController],
                    imports: [CommonModule],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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