import { ApplicationRef, createComponent, inject, Injectable, InjectionToken, Injector, NgZone, } from '@angular/core';
import { LIFECYCLE_DID_ENTER, LIFECYCLE_DID_LEAVE, LIFECYCLE_WILL_ENTER, LIFECYCLE_WILL_LEAVE, LIFECYCLE_WILL_UNLOAD, } from '@ionic/core/components';
import { NavParams } from '../directives/navigation/nav-params';
import { ConfigToken } from './config';
import * as i0 from "@angular/core";
// Token for injecting the modal element
export const IonModalToken = new InjectionToken('IonModalToken');
// TODO(FW-2827): types
export class AngularDelegate {
    zone = inject(NgZone);
    applicationRef = inject(ApplicationRef);
    config = inject(ConfigToken);
    create(environmentInjector, injector, elementReferenceKey) {
        return new AngularFrameworkDelegate(environmentInjector, injector, this.applicationRef, this.zone, elementReferenceKey, this.config.useSetInputAPI ?? false);
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: AngularDelegate, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
    /** @nocollapse */ static ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: AngularDelegate });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: AngularDelegate, decorators: [{
            type: Injectable
        }] });
export class AngularFrameworkDelegate {
    environmentInjector;
    injector;
    applicationRef;
    zone;
    elementReferenceKey;
    enableSignalsSupport;
    elRefMap = new WeakMap();
    elEventsMap = new WeakMap();
    constructor(environmentInjector, injector, applicationRef, zone, elementReferenceKey, enableSignalsSupport) {
        this.environmentInjector = environmentInjector;
        this.injector = injector;
        this.applicationRef = applicationRef;
        this.zone = zone;
        this.elementReferenceKey = elementReferenceKey;
        this.enableSignalsSupport = enableSignalsSupport;
    }
    attachViewToDom(container, component, params, cssClasses) {
        return this.zone.run(() => {
            return new Promise((resolve) => {
                const componentProps = {
                    ...params,
                };
                /**
                 * Ionic Angular passes a reference to a modal
                 * or popover that can be accessed using a
                 * variable in the overlay component. If
                 * elementReferenceKey is defined, then we should
                 * pass a reference to the component using
                 * elementReferenceKey as the key.
                 */
                if (this.elementReferenceKey !== undefined) {
                    componentProps[this.elementReferenceKey] = container;
                }
                const el = attachView(this.zone, this.environmentInjector, this.injector, this.applicationRef, this.elRefMap, this.elEventsMap, container, component, componentProps, cssClasses, this.elementReferenceKey, this.enableSignalsSupport);
                resolve(el);
            });
        });
    }
    removeViewFromDom(_container, component) {
        return this.zone.run(() => {
            return new Promise((resolve) => {
                const componentRef = this.elRefMap.get(component);
                if (componentRef) {
                    componentRef.destroy();
                    this.elRefMap.delete(component);
                    const unbindEvents = this.elEventsMap.get(component);
                    if (unbindEvents) {
                        unbindEvents();
                        this.elEventsMap.delete(component);
                    }
                }
                resolve();
            });
        });
    }
}
export const attachView = (zone, environmentInjector, injector, applicationRef, elRefMap, elEventsMap, container, component, params, cssClasses, elementReferenceKey, enableSignalsSupport) => {
    /**
     * Wraps the injector with a custom injector that
     * provides NavParams to the component.
     *
     * NavParams is a legacy feature from Ionic v3 that allows
     * Angular developers to provide data to a component
     * and access it by providing NavParams as a dependency
     * in the constructor.
     *
     * The modern approach is to access the data directly
     * from the component's class instance.
     */
    const providers = getProviders(params);
    // If this is an ion-modal, provide the modal element as an injectable
    // so components inside the modal can inject it directly
    if (container.tagName.toLowerCase() === 'ion-modal') {
        providers.push({
            provide: IonModalToken,
            useValue: container,
        });
    }
    const childInjector = Injector.create({
        providers,
        parent: injector,
    });
    const componentRef = createComponent(component, {
        environmentInjector,
        elementInjector: childInjector,
    });
    const instance = componentRef.instance;
    const hostElement = componentRef.location.nativeElement;
    if (params) {
        /**
         * For modals and popovers, a reference to the component is
         * added to `params` during the call to attachViewToDom. If
         * a reference using this name is already set, this means
         * the app is trying to use the name as a component prop,
         * which will cause collisions.
         */
        if (elementReferenceKey && instance[elementReferenceKey] !== undefined) {
            console.error(`[Ionic Error]: ${elementReferenceKey} is a reserved property when using ${container.tagName.toLowerCase()}. Rename or remove the "${elementReferenceKey}" property from ${component.name}.`);
        }
        /**
         * Angular 14.1 added support for setInput
         * so we need to fall back to Object.assign
         * for Angular 14.0.
         */
        if (enableSignalsSupport === true && componentRef.setInput !== undefined) {
            const { modal, popover, ...otherParams } = params;
            /**
             * Any key/value pairs set in componentProps
             * must be set as inputs on the component instance.
             */
            for (const key in otherParams) {
                componentRef.setInput(key, otherParams[key]);
            }
            /**
             * Using setInput will cause an error when
             * setting modal/popover on a component that
             * does not define them as an input. For backwards
             * compatibility purposes we fall back to using
             * Object.assign for these properties.
             */
            if (modal !== undefined) {
                Object.assign(instance, { modal });
            }
            if (popover !== undefined) {
                Object.assign(instance, { popover });
            }
        }
        else {
            Object.assign(instance, params);
        }
    }
    if (cssClasses) {
        for (const cssClass of cssClasses) {
            hostElement.classList.add(cssClass);
        }
    }
    const unbindEvents = bindLifecycleEvents(zone, instance, hostElement);
    container.appendChild(hostElement);
    applicationRef.attachView(componentRef.hostView);
    elRefMap.set(hostElement, componentRef);
    elEventsMap.set(hostElement, unbindEvents);
    return hostElement;
};
const LIFECYCLES = [
    LIFECYCLE_WILL_ENTER,
    LIFECYCLE_DID_ENTER,
    LIFECYCLE_WILL_LEAVE,
    LIFECYCLE_DID_LEAVE,
    LIFECYCLE_WILL_UNLOAD,
];
export const bindLifecycleEvents = (zone, instance, element) => {
    return zone.run(() => {
        const unregisters = LIFECYCLES.filter((eventName) => typeof instance[eventName] === 'function').map((eventName) => {
            const handler = (ev) => instance[eventName](ev.detail);
            element.addEventListener(eventName, handler);
            return () => element.removeEventListener(eventName, handler);
        });
        return () => unregisters.forEach((fn) => fn());
    });
};
const NavParamsToken = new InjectionToken('NavParamsToken');
const getProviders = (params) => {
    return [
        {
            provide: NavParamsToken,
            useValue: params,
        },
        {
            provide: NavParams,
            useFactory: provideNavParamsInjectable,
            deps: [NavParamsToken],
        },
    ];
};
const provideNavParamsInjectable = (params) => {
    return new NavParams(params);
};
//# sourceMappingURL=data:application/json;base64,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