import { Directive, HostListener } from '@angular/core';
import { NgControl } from '@angular/forms';
import { raf } from '../../utils/util';
import * as i0 from "@angular/core";
// TODO(FW-2827): types
export class ValueAccessor {
    injector;
    elementRef;
    onChange = () => {
        /**/
    };
    onTouched = () => {
        /**/
    };
    lastValue;
    statusChanges;
    constructor(injector, elementRef) {
        this.injector = injector;
        this.elementRef = elementRef;
    }
    writeValue(value) {
        this.elementRef.nativeElement.value = this.lastValue = value;
        setIonicClasses(this.elementRef);
    }
    /**
     * Notifies the ControlValueAccessor of a change in the value of the control.
     *
     * This is called by each of the ValueAccessor directives when we want to update
     * the status and validity of the form control. For example with text components this
     * is called when the ionInput event is fired. For select components this is called
     * when the ionChange event is fired.
     *
     * This also updates the Ionic form status classes on the element.
     *
     * @param el The component element.
     * @param value The new value of the control.
     */
    handleValueChange(el, value) {
        if (el === this.elementRef.nativeElement) {
            if (value !== this.lastValue) {
                this.lastValue = value;
                this.onChange(value);
            }
            setIonicClasses(this.elementRef);
        }
    }
    _handleBlurEvent(el) {
        if (el === this.elementRef.nativeElement) {
            this.onTouched();
            setIonicClasses(this.elementRef);
            // When ion-radio is blurred, el and this.elementRef.nativeElement are
            // different so we need to check if the closest ion-radio-group is the same
            // as this.elementRef.nativeElement and if so, we need to mark the radio group
            // as touched
        }
        else if (el.closest('ion-radio-group') === this.elementRef.nativeElement) {
            this.onTouched();
        }
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setDisabledState(isDisabled) {
        this.elementRef.nativeElement.disabled = isDisabled;
    }
    ngOnDestroy() {
        if (this.statusChanges) {
            this.statusChanges.unsubscribe();
        }
    }
    ngAfterViewInit() {
        let ngControl;
        try {
            ngControl = this.injector.get(NgControl);
        }
        catch {
            /* No FormControl or ngModel binding */
        }
        if (!ngControl) {
            return;
        }
        // Listen for changes in validity, disabled, or pending states
        if (ngControl.statusChanges) {
            this.statusChanges = ngControl.statusChanges.subscribe(() => setIonicClasses(this.elementRef));
        }
        /**
         * TODO FW-2787: Remove this in favor of https://github.com/angular/angular/issues/10887
         * whenever it is implemented.
         */
        const formControl = ngControl.control;
        if (formControl) {
            const methodsToPatch = ['markAsTouched', 'markAllAsTouched', 'markAsUntouched', 'markAsDirty', 'markAsPristine'];
            methodsToPatch.forEach((method) => {
                if (typeof formControl[method] !== 'undefined') {
                    const oldFn = formControl[method].bind(formControl);
                    formControl[method] = (...params) => {
                        oldFn(...params);
                        setIonicClasses(this.elementRef);
                    };
                }
            });
        }
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: ValueAccessor, deps: [{ token: i0.Injector }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
    /** @nocollapse */ static ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "16.2.12", type: ValueAccessor, host: { listeners: { "ionBlur": "_handleBlurEvent($event.target)" } }, ngImport: i0 });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: ValueAccessor, decorators: [{
            type: Directive
        }], ctorParameters: function () { return [{ type: i0.Injector }, { type: i0.ElementRef }]; }, propDecorators: { _handleBlurEvent: [{
                type: HostListener,
                args: ['ionBlur', ['$event.target']]
            }] } });
export const setIonicClasses = (element) => {
    raf(() => {
        const input = element.nativeElement;
        const hasValue = input.value != null && input.value.toString().length > 0;
        const classes = getClasses(input);
        setClasses(input, classes);
        const item = input.closest('ion-item');
        if (item) {
            if (hasValue) {
                setClasses(item, [...classes, 'item-has-value']);
            }
            else {
                setClasses(item, classes);
            }
        }
    });
};
const getClasses = (element) => {
    const classList = element.classList;
    const classes = [];
    for (let i = 0; i < classList.length; i++) {
        const item = classList.item(i);
        if (item !== null && startsWith(item, 'ng-')) {
            classes.push(`ion-${item.substring(3)}`);
        }
    }
    return classes;
};
const setClasses = (element, classes) => {
    const classList = element.classList;
    classList.remove('ion-valid', 'ion-invalid', 'ion-touched', 'ion-untouched', 'ion-dirty', 'ion-pristine');
    classList.add(...classes);
};
const startsWith = (input, search) => {
    return input.substring(0, search.length) === search;
};
//# sourceMappingURL=data:application/json;base64,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