import { raf } from '@ionic/angular/common';
import { setupConfig } from '@ionic/core';
import { defineCustomElements } from '@ionic/core/loader';
// TODO(FW-2827): types
export const appInitialize = (config, doc, zone) => {
    return () => {
        const win = doc.defaultView;
        if (win && typeof window !== 'undefined') {
            setupConfig({
                ...config,
                _zoneGate: (h) => zone.run(h),
            });
            const aelFn = '__zone_symbol__addEventListener' in doc.body ? '__zone_symbol__addEventListener' : 'addEventListener';
            return defineCustomElements(win, {
                exclude: ['ion-tabs'],
                syncQueue: true,
                raf,
                jmp: (h) => zone.runOutsideAngular(h),
                ael(elm, eventName, cb, opts) {
                    elm[aelFn](eventName, cb, opts);
                },
                rel(elm, eventName, cb, opts) {
                    elm.removeEventListener(eventName, cb, opts);
                },
            });
        }
    };
};
//# sourceMappingURL=data:application/json;base64,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