import { ChangeDetectorRef, Component, Injector } from '@angular/core';
import { Router } from '@angular/router';
import { IonRouterOutlet, IonSegment, IonSegmentButton } from '@ionic/angular/standalone';
import { HeaderComponent } from 'src/app/components/header/header.component';
import { I18nAdminService } from '../../services/i18n-admin.service';
import { I18nPipe } from 'src/app/services/i18n/i18n-string';
import { AbstractPage } from 'src/app/utils/component-utils';
import { MessagesService } from '../../services/messages.service';

@Component({
  selector: 'app-admin-page',
  templateUrl: './admin.page.html',
  styleUrl: './admin.page.scss',
  imports: [
    HeaderComponent,
    I18nPipe,
    IonRouterOutlet, IonSegment, IonSegmentButton,
  ]
})
export class AdminPage extends AbstractPage {

  ready = false;
  unreadMessagesCount?: number;

  constructor(
    injector: Injector,
    private readonly router: Router,
    private readonly i18nAdmin: I18nAdminService,
    private readonly changeDetector: ChangeDetectorRef,
    private readonly messagesService: MessagesService,
  ) {
    super(injector);
  }

  protected override initComponent(): void {
    this.i18nAdmin.ready$.subscribe(r => {
      this.ready = r;
      this.changeDetector.detectChanges();
    });
    this.whenVisible.subscribe(this.messagesService.unreadCount$, nb => this.unreadMessagesCount = nb)
  }

  getCurrentPage(): string {
    let url = this.router.url;
    if (!url.startsWith('/admin/')) return '';
    url = url.substring(7);
    const i = url.indexOf('/');
    if (i > 0) url = url.substring(0, i);
    return url;
  }

  goToPage(page: any): void {
    this.router.navigateByUrl('/admin/' + page);
  }
}
