/**
 * Viewer control to display a sidebar with resizer functionality.
 */
export class Sidebar {
    /**
     * @typedef {Object} SidebarElements
     * @property {HTMLElement} sidebar - The sidebar element.
     * @property {HTMLElement} resizer - The sidebar resizer element.
     * @property {HTMLElement} toggleButton - The button used to toggle the
     *   sidebar.
     */
    /**
     * Create a sidebar with resizer functionality.
     * @param {SidebarElements} sidebarElements
     * @param {boolean} ltr
     * @param {boolean} isResizerOnTheLeft
     */
    constructor({ sidebar, resizer, toggleButton }: {
        /**
         * - The sidebar element.
         */
        sidebar: HTMLElement;
        /**
         * - The sidebar resizer element.
         */
        resizer: HTMLElement;
        /**
         * - The button used to toggle the
         * sidebar.
         */
        toggleButton: HTMLElement;
    }, ltr: boolean, isResizerOnTheLeft: boolean);
    _sidebar: HTMLElement;
    /**
     * Toggle the sidebar's visibility.
     */
    toggle(): void;
    #private;
}
