import { JestFacade } from '../jest-facade';
import { createJestPuppeteerEnvironment } from './jest-environment';
import { createTestRunner } from './jest-runner';
import { runJest } from './jest-runner';
import { runJestScreenshot } from './jest-screenshot';
import { jestSetupTestFramework } from './jest-setup-test-framework';
/**
 * `JestFacade` implementation for communicating between this directory's version of Jest and Stencil
 */
export declare class Jest27Stencil implements JestFacade {
    getJestCliRunner(): typeof runJest;
    getRunJestScreenshot(): typeof runJestScreenshot;
    getDefaultJestRunner(): string;
    getCreateJestPuppeteerEnvironment(): typeof createJestPuppeteerEnvironment;
    getJestPreprocessor(): {
        process(sourceText: string, sourcePath: string, jestConfig: {
            instrument: boolean;
            rootDir: string;
        } | {
            config: {
                instrument: boolean;
                rootDir: string;
            };
        }, transformOptions?: {
            instrument: boolean;
            rootDir: string;
        }): string;
        getCacheKey(sourceText: string, sourcePath: string, jestConfigStr: string | {
            config: {
                instrument: boolean;
                rootDir: string;
            };
        }, transformOptions?: {
            instrument: boolean;
            rootDir: string;
        }): string;
    };
    getCreateJestTestRunner(): typeof createTestRunner;
    getJestSetupTestFramework(): typeof jestSetupTestFramework;
    getJestPreset(): Partial<{
        automock: boolean;
        bail: boolean | number;
        cache: boolean;
        cacheDirectory: import("node_modules/@jest/types/build/Config").Path;
        ci: boolean;
        clearMocks: boolean;
        changedFilesWithAncestor: boolean;
        changedSince: string;
        collectCoverage: boolean;
        collectCoverageFrom: Array<import("node_modules/@jest/types/build/Config").Glob>;
        collectCoverageOnlyFrom: {
            [key: string]: boolean;
        };
        coverageDirectory: string;
        coveragePathIgnorePatterns: Array<string>;
        coverageProvider: "babel" | "v8";
        coverageReporters: import("node_modules/@jest/types/build/Config").CoverageReporters;
        coverageThreshold: {
            [path: string]: import("node_modules/@jest/types/build/Config").CoverageThresholdValue;
            global: import("node_modules/@jest/types/build/Config").CoverageThresholdValue;
        };
        dependencyExtractor: string;
        detectLeaks: boolean;
        detectOpenHandles: boolean;
        displayName: string | import("node_modules/@jest/types/build/Config").DisplayName;
        expand: boolean;
        extensionsToTreatAsEsm: Array<import("node_modules/@jest/types/build/Config").Path>;
        extraGlobals: Array<string>;
        filter: import("node_modules/@jest/types/build/Config").Path;
        findRelatedTests: boolean;
        forceCoverageMatch: Array<import("node_modules/@jest/types/build/Config").Glob>;
        forceExit: boolean;
        json: boolean;
        globals: import("node_modules/@jest/types/build/Config").ConfigGlobals;
        globalSetup: string | null | undefined;
        globalTeardown: string | null | undefined;
        haste: import("node_modules/@jest/types/build/Config").HasteConfig;
        injectGlobals: boolean;
        reporters: Array<string | import("node_modules/@jest/types/build/Config").ReporterConfig>;
        logHeapUsage: boolean;
        lastCommit: boolean;
        listTests: boolean;
        maxConcurrency: number;
        maxWorkers: number | string;
        moduleDirectories: Array<string>;
        moduleFileExtensions: Array<string>;
        moduleLoader: import("node_modules/@jest/types/build/Config").Path;
        moduleNameMapper: {
            [key: string]: string | Array<string>;
        };
        modulePathIgnorePatterns: Array<string>;
        modulePaths: Array<string>;
        name: string;
        noStackTrace: boolean;
        notify: boolean;
        notifyMode: string;
        onlyChanged: boolean;
        onlyFailures: boolean;
        outputFile: import("node_modules/@jest/types/build/Config").Path;
        passWithNoTests: boolean;
        preprocessorIgnorePatterns: Array<import("node_modules/@jest/types/build/Config").Glob>;
        preset: string | null | undefined;
        prettierPath: string | null | undefined;
        projects: Array<import("node_modules/@jest/types/build/Config").Glob | import("node_modules/@jest/types/build/Config").InitialProjectOptions>;
        replname: string | null | undefined;
        resetMocks: boolean;
        resetModules: boolean;
        resolver: import("node_modules/@jest/types/build/Config").Path | null | undefined;
        restoreMocks: boolean;
        rootDir: import("node_modules/@jest/types/build/Config").Path;
        roots: Array<import("node_modules/@jest/types/build/Config").Path>;
        runner: string;
        runTestsByPath: boolean;
        scriptPreprocessor: string;
        setupFiles: Array<import("node_modules/@jest/types/build/Config").Path>;
        setupTestFrameworkScriptFile: import("node_modules/@jest/types/build/Config").Path;
        setupFilesAfterEnv: Array<import("node_modules/@jest/types/build/Config").Path>;
        silent: boolean;
        skipFilter: boolean;
        skipNodeResolution: boolean;
        slowTestThreshold: number;
        snapshotResolver: import("node_modules/@jest/types/build/Config").Path;
        snapshotSerializers: Array<import("node_modules/@jest/types/build/Config").Path>;
        snapshotFormat: import("node_modules/@jest/types/build/Config").PrettyFormatOptions;
        errorOnDeprecated: boolean;
        testEnvironment: string;
        testEnvironmentOptions: Record<string, unknown>;
        testFailureExitCode: string | number;
        testLocationInResults: boolean;
        testMatch: Array<import("node_modules/@jest/types/build/Config").Glob>;
        testNamePattern: string;
        testPathDirs: Array<import("node_modules/@jest/types/build/Config").Path>;
        testPathIgnorePatterns: Array<string>;
        testRegex: string | Array<string>;
        testResultsProcessor: string;
        testRunner: string;
        testSequencer: string;
        testURL: string;
        testTimeout: number;
        timers: "real" | "fake" | "modern" | "legacy";
        transform: {
            [regex: string]: import("node_modules/@jest/types/build/Config").Path | import("node_modules/@jest/types/build/Config").TransformerConfig;
        };
        transformIgnorePatterns: Array<import("node_modules/@jest/types/build/Config").Glob>;
        watchPathIgnorePatterns: Array<string>;
        unmockedModulePathPatterns: Array<string>;
        updateSnapshot: boolean;
        useStderr: boolean;
        verbose?: boolean;
        watch: boolean;
        watchAll: boolean;
        watchman: boolean;
        watchPlugins: Array<string | [string, Record<string, unknown>]>;
    }>;
}
