import { ViewChild, ViewContainerRef, Component, Attribute, Optional, SkipSelf, } from '@angular/core';
import { IonRouterOutlet as IonRouterOutletBase } from '@ionic/angular/common';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/router";
// eslint-disable-next-line @angular-eslint/directive-class-suffix
export class IonRouterOutlet extends IonRouterOutletBase {
    parentOutlet;
    /**
     * `static: true` must be set so the query results are resolved
     * before change detection runs. Otherwise, the view container
     * ref will be ion-router-outlet instead of ng-container, and
     * the first view will be added as a sibling of ion-router-outlet
     * instead of a child.
     */
    outletContent;
    /**
     * We need to pass in the correct instance of IonRouterOutlet
     * otherwise parentOutlet will be null in a nested outlet context.
     * This results in APIs such as NavController.pop not working
     * in nested outlets because the parent outlet cannot be found.
     */
    constructor(name, tabs, commonLocation, elementRef, router, zone, activatedRoute, parentOutlet) {
        super(name, tabs, commonLocation, elementRef, router, zone, activatedRoute, parentOutlet);
        this.parentOutlet = parentOutlet;
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonRouterOutlet, deps: [{ token: 'name', attribute: true }, { token: 'tabs', attribute: true, optional: true }, { token: i1.Location }, { token: i0.ElementRef }, { token: i2.Router }, { token: i0.NgZone }, { token: i2.ActivatedRoute }, { token: IonRouterOutlet, optional: true, skipSelf: true }], target: i0.ɵɵFactoryTarget.Component });
    /** @nocollapse */ static ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "16.2.12", type: IonRouterOutlet, selector: "ion-router-outlet", viewQueries: [{ propertyName: "outletContent", first: true, predicate: ["outletContent"], descendants: true, read: ViewContainerRef, static: true }], usesInheritance: true, ngImport: i0, template: '<ng-container #outletContent><ng-content></ng-content></ng-container>', isInline: true });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonRouterOutlet, decorators: [{
            type: Component,
            args: [{
                    selector: 'ion-router-outlet',
                    template: '<ng-container #outletContent><ng-content></ng-content></ng-container>',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Attribute,
                    args: ['name']
                }] }, { type: undefined, decorators: [{
                    type: Optional
                }, {
                    type: Attribute,
                    args: ['tabs']
                }] }, { type: i1.Location }, { type: i0.ElementRef }, { type: i2.Router }, { type: i0.NgZone }, { type: i2.ActivatedRoute }, { type: IonRouterOutlet, decorators: [{
                    type: SkipSelf
                }, {
                    type: Optional
                }] }]; }, propDecorators: { outletContent: [{
                type: ViewChild,
                args: ['outletContent', { read: ViewContainerRef, static: true }]
            }] } });
//# sourceMappingURL=data:application/json;base64,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