import { Directive, HostListener } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { ValueAccessor } from '@ionic/angular/common';
import * as i0 from "@angular/core";
export class NumericValueAccessorDirective extends ValueAccessor {
    el;
    constructor(injector, el) {
        super(injector, el);
        this.el = el;
    }
    handleInputEvent(el) {
        this.handleValueChange(el, el.value);
    }
    registerOnChange(fn) {
        if (this.el.nativeElement.tagName === 'ION-INPUT' || this.el.nativeElement.tagName === 'ION-INPUT-OTP') {
            super.registerOnChange((value) => {
                fn(value === '' ? null : parseFloat(value));
            });
        }
        else {
            super.registerOnChange(fn);
        }
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: NumericValueAccessorDirective, deps: [{ token: i0.Injector }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
    /** @nocollapse */ static ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "16.2.12", type: NumericValueAccessorDirective, selector: "ion-input[type=number],ion-input-otp:not([type=text]),ion-range", host: { listeners: { "ionInput": "handleInputEvent($event.target)" } }, providers: [
            {
                provide: NG_VALUE_ACCESSOR,
                useExisting: NumericValueAccessorDirective,
                multi: true,
            },
        ], usesInheritance: true, ngImport: i0 });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: NumericValueAccessorDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: 'ion-input[type=number],ion-input-otp:not([type=text]),ion-range',
                    providers: [
                        {
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: NumericValueAccessorDirective,
                            multi: true,
                        },
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }, { type: i0.ElementRef }]; }, propDecorators: { handleInputEvent: [{
                type: HostListener,
                args: ['ionInput', ['$event.target']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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