import { __decorate } from "tslib";
import { ContentChild, Directive, TemplateRef, } from '@angular/core';
import { ProxyCmp, proxyOutputs } from '../utils/proxy';
import * as i0 from "@angular/core";
const POPOVER_INPUTS = [
    'alignment',
    'animated',
    'arrow',
    'keepContentsMounted',
    'backdropDismiss',
    'cssClass',
    'dismissOnSelect',
    'enterAnimation',
    'event',
    'focusTrap',
    'isOpen',
    'keyboardClose',
    'leaveAnimation',
    'mode',
    'showBackdrop',
    'translucent',
    'trigger',
    'triggerAction',
    'reference',
    'size',
    'side',
];
const POPOVER_METHODS = ['present', 'dismiss', 'onDidDismiss', 'onWillDismiss'];
let IonPopover = class IonPopover {
    z;
    // TODO(FW-2827): type
    template;
    isCmpOpen = false;
    el;
    constructor(c, r, z) {
        this.z = z;
        this.el = r.nativeElement;
        this.el.addEventListener('ionMount', () => {
            this.isCmpOpen = true;
            c.detectChanges();
        });
        this.el.addEventListener('didDismiss', () => {
            this.isCmpOpen = false;
            c.detectChanges();
        });
        proxyOutputs(this, this.el, [
            'ionPopoverDidPresent',
            'ionPopoverWillPresent',
            'ionPopoverWillDismiss',
            'ionPopoverDidDismiss',
            'didPresent',
            'willPresent',
            'willDismiss',
            'didDismiss',
        ]);
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonPopover, deps: [{ token: i0.ChangeDetectorRef }, { token: i0.ElementRef }, { token: i0.NgZone }], target: i0.ɵɵFactoryTarget.Directive });
    /** @nocollapse */ static ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "16.2.12", type: IonPopover, selector: "ion-popover", inputs: { alignment: "alignment", animated: "animated", arrow: "arrow", keepContentsMounted: "keepContentsMounted", backdropDismiss: "backdropDismiss", cssClass: "cssClass", dismissOnSelect: "dismissOnSelect", enterAnimation: "enterAnimation", event: "event", focusTrap: "focusTrap", isOpen: "isOpen", keyboardClose: "keyboardClose", leaveAnimation: "leaveAnimation", mode: "mode", showBackdrop: "showBackdrop", translucent: "translucent", trigger: "trigger", triggerAction: "triggerAction", reference: "reference", size: "size", side: "side" }, queries: [{ propertyName: "template", first: true, predicate: TemplateRef, descendants: true }], ngImport: i0 });
};
IonPopover = __decorate([
    ProxyCmp({
        inputs: POPOVER_INPUTS,
        methods: POPOVER_METHODS,
    })
    /**
     * @Component extends from @Directive
     * so by defining the inputs here we
     * do not need to re-define them for the
     * lazy loaded popover.
     */
], IonPopover);
export { IonPopover };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonPopover, decorators: [{
            type: Directive,
            args: [{
                    selector: 'ion-popover',
                    // eslint-disable-next-line @angular-eslint/no-inputs-metadata-property
                    inputs: POPOVER_INPUTS,
                }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }, { type: i0.ElementRef }, { type: i0.NgZone }]; }, propDecorators: { template: [{
                type: ContentChild,
                args: [TemplateRef, { static: false }]
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9wb3Zlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL2NvbW1vbi9zcmMvb3ZlcmxheXMvcG9wb3Zlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsT0FBTyxFQUVMLFlBQVksRUFDWixTQUFTLEVBSVQsV0FBVyxHQUNaLE1BQU0sZUFBZSxDQUFDO0FBR3ZCLE9BQU8sRUFBRSxRQUFRLEVBQUUsWUFBWSxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7O0FBcUN4RCxNQUFNLGNBQWMsR0FBRztJQUNyQixXQUFXO0lBQ1gsVUFBVTtJQUNWLE9BQU87SUFDUCxxQkFBcUI7SUFDckIsaUJBQWlCO0lBQ2pCLFVBQVU7SUFDVixpQkFBaUI7SUFDakIsZ0JBQWdCO0lBQ2hCLE9BQU87SUFDUCxXQUFXO0lBQ1gsUUFBUTtJQUNSLGVBQWU7SUFDZixnQkFBZ0I7SUFDaEIsTUFBTTtJQUNOLGNBQWM7SUFDZCxhQUFhO0lBQ2IsU0FBUztJQUNULGVBQWU7SUFDZixXQUFXO0lBQ1gsTUFBTTtJQUNOLE1BQU07Q0FDUCxDQUFDO0FBRUYsTUFBTSxlQUFlLEdBQUcsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLGNBQWMsRUFBRSxlQUFlLENBQUMsQ0FBQztBQW1CekUsSUFBTSxVQUFVLEdBQWhCLE1BQU0sVUFBVTtJQVFzQztJQVAzRCxzQkFBc0I7SUFDd0IsUUFBUSxDQUFtQjtJQUV6RSxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBRVIsRUFBRSxDQUFjO0lBRTFCLFlBQVksQ0FBb0IsRUFBRSxDQUFhLEVBQVksQ0FBUztRQUFULE1BQUMsR0FBRCxDQUFDLENBQVE7UUFDbEUsSUFBSSxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUMsYUFBYSxDQUFDO1FBRTFCLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxFQUFFLEdBQUcsRUFBRTtZQUN4QyxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQztZQUN0QixDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7UUFDcEIsQ0FBQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixDQUFDLFlBQVksRUFBRSxHQUFHLEVBQUU7WUFDMUMsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7WUFDdkIsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3BCLENBQUMsQ0FBQyxDQUFDO1FBQ0gsWUFBWSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsRUFBRSxFQUFFO1lBQzFCLHNCQUFzQjtZQUN0Qix1QkFBdUI7WUFDdkIsdUJBQXVCO1lBQ3ZCLHNCQUFzQjtZQUN0QixZQUFZO1lBQ1osYUFBYTtZQUNiLGFBQWE7WUFDYixZQUFZO1NBQ2IsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzsySEE3QlUsVUFBVTsrR0FBVixVQUFVLDJuQkFFUCxXQUFXOztBQUZkLFVBQVU7SUFqQnRCLFFBQVEsQ0FBQztRQUNSLE1BQU0sRUFBRSxjQUFjO1FBQ3RCLE9BQU8sRUFBRSxlQUFlO0tBQ3pCLENBQUM7SUFDRjs7Ozs7T0FLRztHQVFVLFVBQVUsQ0E4QnRCO1NBOUJZLFVBQVU7NEZBQVYsVUFBVTtrQkFQdEIsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUsYUFBYTtvQkFDdkIsdUVBQXVFO29CQUN2RSxNQUFNLEVBQUUsY0FBYztpQkFDdkI7c0pBSytDLFFBQVE7c0JBQXJELFlBQVk7dUJBQUMsV0FBVyxFQUFFLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBRSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIENoYW5nZURldGVjdG9yUmVmLFxuICBDb250ZW50Q2hpbGQsXG4gIERpcmVjdGl2ZSxcbiAgRWxlbWVudFJlZixcbiAgRXZlbnRFbWl0dGVyLFxuICBOZ1pvbmUsXG4gIFRlbXBsYXRlUmVmLFxufSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB0eXBlIHsgQ29tcG9uZW50cyB9IGZyb20gJ0Bpb25pYy9jb3JlL2NvbXBvbmVudHMnO1xuXG5pbXBvcnQgeyBQcm94eUNtcCwgcHJveHlPdXRwdXRzIH0gZnJvbSAnLi4vdXRpbHMvcHJveHknO1xuXG5leHBvcnQgZGVjbGFyZSBpbnRlcmZhY2UgSW9uUG9wb3ZlciBleHRlbmRzIENvbXBvbmVudHMuSW9uUG9wb3ZlciB7XG4gIC8qKlxuICAgKiBFbWl0dGVkIGFmdGVyIHRoZSBwb3BvdmVyIGhhcyBwcmVzZW50ZWQuXG4gICAqL1xuICBpb25Qb3BvdmVyRGlkUHJlc2VudDogRXZlbnRFbWl0dGVyPEN1c3RvbUV2ZW50PjtcbiAgLyoqXG4gICAqIEVtaXR0ZWQgYmVmb3JlIHRoZSBwb3BvdmVyIGhhcyBwcmVzZW50ZWQuXG4gICAqL1xuICBpb25Qb3BvdmVyV2lsbFByZXNlbnQ6IEV2ZW50RW1pdHRlcjxDdXN0b21FdmVudD47XG4gIC8qKlxuICAgKiBFbWl0dGVkIGFmdGVyIHRoZSBwb3BvdmVyIGhhcyBkaXNtaXNzZWQuXG4gICAqL1xuICBpb25Qb3BvdmVyV2lsbERpc21pc3M6IEV2ZW50RW1pdHRlcjxDdXN0b21FdmVudD47XG4gIC8qKlxuICAgKiBFbWl0dGVkIGFmdGVyIHRoZSBwb3BvdmVyIGhhcyBkaXNtaXNzZWQuXG4gICAqL1xuICBpb25Qb3BvdmVyRGlkRGlzbWlzczogRXZlbnRFbWl0dGVyPEN1c3RvbUV2ZW50PjtcbiAgLyoqXG4gICAqIEVtaXR0ZWQgYWZ0ZXIgdGhlIHBvcG92ZXIgaGFzIHByZXNlbnRlZC4gU2hvcnRoYW5kIGZvciBpb25Qb3BvdmVyRGlkUHJlc2VudC5cbiAgICovXG4gIGRpZFByZXNlbnQ6IEV2ZW50RW1pdHRlcjxDdXN0b21FdmVudD47XG4gIC8qKlxuICAgKiBFbWl0dGVkIGJlZm9yZSB0aGUgcG9wb3ZlciBoYXMgcHJlc2VudGVkLiBTaG9ydGhhbmQgZm9yIGlvblBvcG92ZXJXaWxsUHJlc2VudC5cbiAgICovXG4gIHdpbGxQcmVzZW50OiBFdmVudEVtaXR0ZXI8Q3VzdG9tRXZlbnQ+O1xuICAvKipcbiAgICogRW1pdHRlZCBhZnRlciB0aGUgcG9wb3ZlciBoYXMgcHJlc2VudGVkLiBTaG9ydGhhbmQgZm9yIGlvblBvcG92ZXJXaWxsRGlzbWlzcy5cbiAgICovXG4gIHdpbGxEaXNtaXNzOiBFdmVudEVtaXR0ZXI8Q3VzdG9tRXZlbnQ+O1xuICAvKipcbiAgICogRW1pdHRlZCBhZnRlciB0aGUgcG9wb3ZlciBoYXMgZGlzbWlzc2VkLiBTaG9ydGhhbmQgZm9yIGlvblBvcG92ZXJEaWREaXNtaXNzLlxuICAgKi9cbiAgZGlkRGlzbWlzczogRXZlbnRFbWl0dGVyPEN1c3RvbUV2ZW50Pjtcbn1cblxuY29uc3QgUE9QT1ZFUl9JTlBVVFMgPSBbXG4gICdhbGlnbm1lbnQnLFxuICAnYW5pbWF0ZWQnLFxuICAnYXJyb3cnLFxuICAna2VlcENvbnRlbnRzTW91bnRlZCcsXG4gICdiYWNrZHJvcERpc21pc3MnLFxuICAnY3NzQ2xhc3MnLFxuICAnZGlzbWlzc09uU2VsZWN0JyxcbiAgJ2VudGVyQW5pbWF0aW9uJyxcbiAgJ2V2ZW50JyxcbiAgJ2ZvY3VzVHJhcCcsXG4gICdpc09wZW4nLFxuICAna2V5Ym9hcmRDbG9zZScsXG4gICdsZWF2ZUFuaW1hdGlvbicsXG4gICdtb2RlJyxcbiAgJ3Nob3dCYWNrZHJvcCcsXG4gICd0cmFuc2x1Y2VudCcsXG4gICd0cmlnZ2VyJyxcbiAgJ3RyaWdnZXJBY3Rpb24nLFxuICAncmVmZXJlbmNlJyxcbiAgJ3NpemUnLFxuICAnc2lkZScsXG5dO1xuXG5jb25zdCBQT1BPVkVSX01FVEhPRFMgPSBbJ3ByZXNlbnQnLCAnZGlzbWlzcycsICdvbkRpZERpc21pc3MnLCAnb25XaWxsRGlzbWlzcyddO1xuXG5AUHJveHlDbXAoe1xuICBpbnB1dHM6IFBPUE9WRVJfSU5QVVRTLFxuICBtZXRob2RzOiBQT1BPVkVSX01FVEhPRFMsXG59KVxuLyoqXG4gKiBAQ29tcG9uZW50IGV4dGVuZHMgZnJvbSBARGlyZWN0aXZlXG4gKiBzbyBieSBkZWZpbmluZyB0aGUgaW5wdXRzIGhlcmUgd2VcbiAqIGRvIG5vdCBuZWVkIHRvIHJlLWRlZmluZSB0aGVtIGZvciB0aGVcbiAqIGxhenkgbG9hZGVkIHBvcG92ZXIuXG4gKi9cbkBEaXJlY3RpdmUoe1xuICBzZWxlY3RvcjogJ2lvbi1wb3BvdmVyJyxcbiAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIEBhbmd1bGFyLWVzbGludC9uby1pbnB1dHMtbWV0YWRhdGEtcHJvcGVydHlcbiAgaW5wdXRzOiBQT1BPVkVSX0lOUFVUUyxcbn0pXG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBAYW5ndWxhci1lc2xpbnQvZGlyZWN0aXZlLWNsYXNzLXN1ZmZpeFxuZXhwb3J0IGNsYXNzIElvblBvcG92ZXIge1xuICAvLyBUT0RPKEZXLTI4MjcpOiB0eXBlXG4gIEBDb250ZW50Q2hpbGQoVGVtcGxhdGVSZWYsIHsgc3RhdGljOiBmYWxzZSB9KSB0ZW1wbGF0ZTogVGVtcGxhdGVSZWY8YW55PjtcblxuICBpc0NtcE9wZW4gPSBmYWxzZTtcblxuICBwcm90ZWN0ZWQgZWw6IEhUTUxFbGVtZW50O1xuXG4gIGNvbnN0cnVjdG9yKGM6IENoYW5nZURldGVjdG9yUmVmLCByOiBFbGVtZW50UmVmLCBwcm90ZWN0ZWQgejogTmdab25lKSB7XG4gICAgdGhpcy5lbCA9IHIubmF0aXZlRWxlbWVudDtcblxuICAgIHRoaXMuZWwuYWRkRXZlbnRMaXN0ZW5lcignaW9uTW91bnQnLCAoKSA9PiB7XG4gICAgICB0aGlzLmlzQ21wT3BlbiA9IHRydWU7XG4gICAgICBjLmRldGVjdENoYW5nZXMoKTtcbiAgICB9KTtcbiAgICB0aGlzLmVsLmFkZEV2ZW50TGlzdGVuZXIoJ2RpZERpc21pc3MnLCAoKSA9PiB7XG4gICAgICB0aGlzLmlzQ21wT3BlbiA9IGZhbHNlO1xuICAgICAgYy5kZXRlY3RDaGFuZ2VzKCk7XG4gICAgfSk7XG4gICAgcHJveHlPdXRwdXRzKHRoaXMsIHRoaXMuZWwsIFtcbiAgICAgICdpb25Qb3BvdmVyRGlkUHJlc2VudCcsXG4gICAgICAnaW9uUG9wb3ZlcldpbGxQcmVzZW50JyxcbiAgICAgICdpb25Qb3BvdmVyV2lsbERpc21pc3MnLFxuICAgICAgJ2lvblBvcG92ZXJEaWREaXNtaXNzJyxcbiAgICAgICdkaWRQcmVzZW50JyxcbiAgICAgICd3aWxsUHJlc2VudCcsXG4gICAgICAnd2lsbERpc21pc3MnLFxuICAgICAgJ2RpZERpc21pc3MnLFxuICAgIF0pO1xuICB9XG59XG4iXX0=