import { AfterViewInit, ElementRef, Injector, OnDestroy } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import * as i0 from "@angular/core";
export declare class ValueAccessor implements ControlValueAccessor, AfterViewInit, OnDestroy {
    protected injector: Injector;
    protected elementRef: ElementRef;
    private onChange;
    private onTouched;
    protected lastValue: any;
    private statusChanges?;
    constructor(injector: Injector, elementRef: ElementRef);
    writeValue(value: any): void;
    /**
     * Notifies the ControlValueAccessor of a change in the value of the control.
     *
     * This is called by each of the ValueAccessor directives when we want to update
     * the status and validity of the form control. For example with text components this
     * is called when the ionInput event is fired. For select components this is called
     * when the ionChange event is fired.
     *
     * This also updates the Ionic form status classes on the element.
     *
     * @param el The component element.
     * @param value The new value of the control.
     */
    handleValueChange(el: HTMLElement, value: any): void;
    _handleBlurEvent(el: any): void;
    registerOnChange(fn: (value: any) => void): void;
    registerOnTouched(fn: () => void): void;
    setDisabledState(isDisabled: boolean): void;
    ngOnDestroy(): void;
    ngAfterViewInit(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ValueAccessor, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<ValueAccessor, never, never, {}, {}, never, never, false, never>;
}
export declare const setIonicClasses: (element: ElementRef) => void;
