import { of } from 'rxjs';
import { TrackEditTool, TrackEditToolContext } from '../tool.interface';
import { copyPoint, PointDescriptor } from 'src/app/model/point-descriptor';
import { TrackUtils } from 'src/app/utils/track-utils';

export class ArrivalToStart implements TrackEditTool {

  labelKey(ctx: TrackEditToolContext) {
    return 'arrival_to_start';
  }

  isAvailable(ctx: TrackEditToolContext): boolean {
    const track = ctx.currentTrack$.value;
    if (!track) return false;
    if (!track.departurePoint || !track.arrivalPoint || track.departurePoint.distanceTo(track.arrivalPoint.pos) < 100) return false;
    return !!TrackUtils.findPath(track, track.departurePoint.pos, track.arrivalPoint.pos);
  }

  execute(ctx: TrackEditToolContext) {
    ctx.modifyTrack(track => {
      if (track.arrivalPoint && track.departurePoint) {
        const path = TrackUtils.findPath(track, track.departurePoint.pos, track.arrivalPoint.pos);
        if (path)
          track.segments.at(-1)?.appendMany(path.reverse().map(p => this.copy(p)));
      }
      return of(true);
    }, false, false).subscribe(() => ctx.refreshTools());
  }

  private copy(pt: PointDescriptor): PointDescriptor {
    return {...copyPoint(pt), time: undefined, speed: undefined, heading: undefined};
  }

}
