import { Injectable } from '@angular/core';
import { createAnimation, getTimeGivenProgression } from '@ionic/core/components';
import * as i0 from "@angular/core";
export class AnimationController {
    /**
     * Create a new animation
     */
    create(animationId) {
        return createAnimation(animationId);
    }
    /**
     * EXPERIMENTAL
     *
     * Given a progression and a cubic bezier function,
     * this utility returns the time value(s) at which the
     * cubic bezier reaches the given time progression.
     *
     * If the cubic bezier never reaches the progression
     * the result will be an empty array.
     *
     * This is most useful for switching between easing curves
     * when doing a gesture animation (i.e. going from linear easing
     * during a drag, to another easing when `progressEnd` is called)
     */
    easingTime(p0, p1, p2, p3, progression) {
        return getTimeGivenProgression(p0, p1, p2, p3, progression);
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: AnimationController, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
    /** @nocollapse */ static ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: AnimationController, providedIn: 'root' });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: AnimationController, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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