import { __decorate } from "tslib";
import { ChangeDetectionStrategy, Component, HostListener, forwardRef, } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { ValueAccessor } from '@ionic/angular/common';
import { defineCustomElement } from '@ionic/core/components/ion-input-otp.js';
import { ProxyCmp, proxyOutputs } from './angular-component-lib/utils';
import * as i0 from "@angular/core";
const INPUT_OTP_INPUTS = [
    'autocapitalize',
    'color',
    'disabled',
    'fill',
    'inputmode',
    'length',
    'pattern',
    'readonly',
    'separators',
    'shape',
    'size',
    'type',
    'value',
];
/**
 * Pulling the provider into an object and using PURE works
 * around an ng-packagr issue that causes
 * components with multiple decorators and
 * a provider to be re-assigned. This re-assignment
 * is not supported by Webpack and causes treeshaking
 * to not work on these kinds of components.
 */
const accessorProvider = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ forwardRef(() => IonInputOtp),
    multi: true,
};
let IonInputOtp = class IonInputOtp extends ValueAccessor {
    z;
    el;
    constructor(c, r, z, injector) {
        super(injector, r);
        this.z = z;
        c.detach();
        this.el = r.nativeElement;
        proxyOutputs(this, this.el, ['ionInput', 'ionChange', 'ionComplete', 'ionBlur', 'ionFocus']);
    }
    handleIonInput(el) {
        this.handleValueChange(el, el.value);
    }
    registerOnChange(fn) {
        super.registerOnChange((value) => {
            if (this.type === 'number') {
                /**
                 * If the input type is `number`, we need to convert the value to a number
                 * when the value is not empty. If the value is empty, we want to treat
                 * the value as null.
                 */
                fn(value === '' ? null : parseFloat(value));
            }
            else {
                fn(value);
            }
        });
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonInputOtp, deps: [{ token: i0.ChangeDetectorRef }, { token: i0.ElementRef }, { token: i0.NgZone }, { token: i0.Injector }], target: i0.ɵɵFactoryTarget.Component });
    /** @nocollapse */ static ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "16.2.12", type: IonInputOtp, isStandalone: true, selector: "ion-input-otp", inputs: { autocapitalize: "autocapitalize", color: "color", disabled: "disabled", fill: "fill", inputmode: "inputmode", length: "length", pattern: "pattern", readonly: "readonly", separators: "separators", shape: "shape", size: "size", type: "type", value: "value" }, host: { listeners: { "ionInput": "handleIonInput($event.target)" } }, providers: [accessorProvider], usesInheritance: true, ngImport: i0, template: '<ng-content></ng-content>', isInline: true, changeDetection: i0.ChangeDetectionStrategy.OnPush });
};
IonInputOtp = __decorate([
    ProxyCmp({
        defineCustomElementFn: defineCustomElement,
        inputs: INPUT_OTP_INPUTS,
        methods: ['setFocus'],
    })
], IonInputOtp);
export { IonInputOtp };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonInputOtp, decorators: [{
            type: Component,
            args: [{
                    selector: 'ion-input-otp',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    template: '<ng-content></ng-content>',
                    // eslint-disable-next-line @angular-eslint/no-inputs-metadata-property
                    inputs: INPUT_OTP_INPUTS,
                    providers: [accessorProvider],
                    standalone: true,
                }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }, { type: i0.ElementRef }, { type: i0.NgZone }, { type: i0.Injector }]; }, propDecorators: { handleIonInput: [{
                type: HostListener,
                args: ['ionInput', ['$event.target']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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