/*
 * Copyright (C) 2026 yztz
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package top.yztz.msggo.data;

import java.io.Serializable;

import top.yztz.msggo.activities.SendingActivity;

public class Message implements Serializable {
    private String phone;
    private String content;

    private SendingActivity.MessageState state = SendingActivity.MessageState.PENDING;

    public Message(String phone, String content) {
        this.phone = phone;
        this.content = content;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public String toString() {
        return "Message{phone='" + phone + "', content='" + content + "'}";
    }

    public SendingActivity.MessageState getState() {
        return state;
    }

    public void setState(SendingActivity.MessageState state) {
        this.state = state;
    }
}

