package top.kagg886.pmf.ui.component

import androidx.compose.foundation.layout.*
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material.icons.filled.ArrowBack
import androidx.compose.material.icons.filled.Refresh
import androidx.compose.material3.FloatingActionButton
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import cafe.adriel.voyager.navigator.LocalNavigator
import cafe.adriel.voyager.navigator.currentOrThrow

@Composable
fun ErrorPage(
    modifier: Modifier = Modifier,
    showBackButton: Boolean = false,
    text: String,
    onClick: () -> Unit,
) {
    Box(modifier.fillMaxSize(), contentAlignment = Alignment.Center) {
        Column(modifier = Modifier.fillMaxWidth(), horizontalAlignment = Alignment.CenterHorizontally) {
            Text(text)
            Spacer(Modifier.height(16.dp))
            FloatingActionButton(onClick = onClick) {
                Icon(imageVector = Icons.Default.Refresh, contentDescription = null)
            }
        }

        if (showBackButton) {
            val nav = LocalNavigator.currentOrThrow
            IconButton(
                onClick = {
                    nav.pop()
                },
                modifier = Modifier.align(Alignment.TopStart).padding(16.dp),
            ) {
                Icon(imageVector = Icons.AutoMirrored.Filled.ArrowBack, contentDescription = null)
            }
        }
    }
}
