#!/bin/bash
# ProseReader for Android build script
#
# To build this app you need: Android SDK, JDK 17, Gradle 8.0.2 and Go 1.25.4
#
# Golang:
# When building for the very first time, it may be useful to build the Go code in isolation,
# to make sure the environment is set up correctly. To do so, execute the following three 
# commands by hand. If everything goes well, you will only see a version string on screen.
# And your src/main/assets/ folder will contain a new file named 'prose.wasn'.
rm -f src/main/assets/prose.wasm
cd src/main/go/
./gobuild
cd ../../..
#
# Gradle:
# You need to add a local.properties file with a sdk.dir=... entry pointing to your android-sdk folder.
# You also need to add your own keystore.properties and releasekey.keystore files.
# Alternatively you can outcomment the keystore entries in build.gradle.
# Note: This apk does not generate network trafic. It does not request android.permission.INTERNET, see manifest.
# Or check 'Mobile Data & Wi-Fi' under Settings/Apps  always saying 'No data used'.
# baseUrlRel (below) is a purely virtual URL. It is only used for localstorage.
rm gradle.propertie*
rm -f build/outputs/apk/release/Prose*.apk
rm -f build/outputs/apk/debug/Prose*.apk
rm -f gradle.propertie*
./proppatch.sh gradle.properties appVersionName "1.7.3"
./proppatch.sh gradle.properties appVersionCode 10703
./proppatch.sh gradle.properties baseUrlRel "https://timur.mobi/prose/"
./proppatch.sh gradle.properties android.useAndroidX true
./proppatch.sh gradle.properties android.defaults.buildfeatures.buildconfig true
#./proppatch.sh gradle.properties org.gradle.console verbose
#./proppatch.sh gradle.properties org.gradle.caching true
#gradle -b build.gradle build --info
gradle build --info

