# ProseReader for Android

Ebook/EPUB Reader for small screens

# Building

To build ProseReader for Android you need: Android SDK, JDK 17, Gradle 8.0.4 and Go 1.25.x installed on your system.

The script ./gradle-build.sh" builds the ProseReader app. Please read the comments for additional instructions.

# Features

ProseReader renders pages that are shorter and have bigger fonts,
which can be consumed even on the smallest screen.
ProseReader pages can be looked at in full, without a need to move the text around on the screen.
ProseReader pages praktically always end with a finished sentence.
This way, each page delivers a complete thought or scenery.
You absorb these screens as an entity, before you go on to the next page.
Text becomes more effortless to read. And more immersive.

The following functionality is exclusive to ProseReader for Android:

- App works without a single permission and completely offline
- Immersive fullscreen mode
- File open handler for EPUB documents
- Direct access to list of recently viewed documents (essential comfort feature)
- Deep bookmarks pointing to selected pages in your EPUB files
- Control screen brightness via 2-finger swipe
- Quick Load

Android OS expects EPUB files stored in the "Documents" folder.
ProseReader for Android can process: files from the "Documents" and "Download" folders, files opened by 
other apps as well as files selected by the user via the file picker widget. When you download an 
EPUB file via web browser, ProseReader app will offer to open it on the fly.

The 'List of recently viewed documents' feature can be enabled inside the (i)nfo tab.

More info: https://timur.mobi/prose/doc/android

# Screenshots

F. Scott Fitzgerald (5 inch screen):

![ProseReader for Android](fastlane/screenshot.png)

Marcel Proust (10-inch screen):

![ProseReader for Android](fastlane/metadata/android/en-US/images/tenInchScreenshots/2.png)

ProseReader Settings (10-inch screen):

![ProseReader for Android](fastlane/settings.png)

# Download

ProseReader on [F-Droid](https://f-droid.org/en/packages/timur.prose/)

# License

GPL3.0 - see: [LICENSE](LICENSE)

## 3rd party code

- github.com/JohannesKaufmann/html-to-markdown (MIT)
- github.com/taylorskalyo/goreader (MIT)
- github.com/ItzNotABug/DocumentFileCompat (apk-only)(Apache 2.0)
- Extended screen timeout code by Trevor Carothers (apk-only)

## 3rd party assets

- github.com/SebastienRousseau/open-sans (Apache 2.0)
- fonts.google.com/noto/specimen/Noto+Serif (CC 4.0 BY)
- fonts.google.com/specimen/Merriweather (OFL 1.0)
- fonts.google.com/specimen/Lora (OFL 1.0)
- fonts.google.com/specimen/Atkinson+Hyperlegible+Next (OFL 1.0)

