// ProseReader Copyright 2025 timur.mobi. All rights reserved.
package timur.prose;

import android.app.Activity;
import android.app.AlertDialog;
//import android.app.PendingIntent;
//import android.app.AlarmManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.Display;
import android.view.ViewGroup;
import android.view.KeyEvent;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebChromeClient;
import android.webkit.ConsoleMessage;
import android.webkit.ValueCallback;
import android.webkit.WebResourceResponse;
import android.webkit.WebResourceError;
import android.webkit.SslErrorHandler;
import android.util.Log;
import android.util.DisplayMetrics;
import android.util.Base64;
import android.content.Context;
import android.content.ClipboardManager;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.content.Intent;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.res.Configuration;
import android.content.DialogInterface;
import android.content.res.AssetFileDescriptor;
import android.content.pm.PackageManager;
import android.content.ContentValues;
import android.content.ComponentName;
import android.widget.Toast;
import android.net.Uri;
import android.net.http.SslError;
import android.preference.PreferenceManager;
import android.database.Cursor;
import android.provider.OpenableColumns;
import android.provider.MediaStore;
import android.provider.DocumentsContract;
import android.Manifest;

//import androidx.documentfile.provider.DocumentFile;
import com.lazygeniouz.dfc.file.DocumentFileCompat;

import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.ViewCompat;

import java.util.Locale;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.StringJoiner;
import java.util.zip.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.io.File;
import java.io.InputStream;
import java.io.IOException;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.FileNotFoundException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
//import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;

//import org.json.JSONObject;
//import org.json.JSONArray;

import timur.prose.BuildConfig;

public class ProseActivity extends Activity {
	private static final String TAG = "ProseActivity";
	private static final String xxx = BuildConfig.VERSION_NAME;
	private static final String baseUrlString = BuildConfig.BASE_URL_STRING; // emulated
	private static final int FILE_REQ_CODE = 1341;	// used to return results from file-picker; see: onActivityResult
	private static final int DIR_REQ_CODE = 1342;
	private static final int DISABLE_KEEP_SCREEN_ON = 1343;
	private static final int MY_PERMISSIONS_READ_EXTERNAL_STORAGE = 1;
	private static volatile Uri documentTreeUri = null;

	static private volatile Activity activity = null;
	static private volatile boolean dbg = false;
	static private volatile WebView myWebView = null;
	static private volatile String cachePath = null;
	static private volatile long renderstartMS = 0;
//	static private volatile boolean acceptRemoteIntents = false;
	static private volatile int extScreenTimeout = 1; // in minutes
	static private volatile boolean disableBrightnessControl = false;
	static private volatile int textActionID = 0;
	static private volatile String docLang = "";
	static private Handler handler = null;

	private volatile Uri getChunkDataUri = null;
	private volatile boolean getChunkDataViaDocumentFile = false;
	private volatile Uri lastLoadedUri = null;
	private volatile int textLen = 0;
	private volatile int subviewOpenId = 0;
	private ValueCallback<Uri[]> myFilePathCallback = null; // for file selector
	private Intent onCreateIntent = null;
	private volatile ProseJSInterface proseJSInterface = new ProseJSInterface();
	private volatile boolean fullscreenFlag = false;
	private volatile View decorView = null;
	static private SharedPreferences prefs = null;
	private volatile long onStartMS = 0;
	private static String userAgentString = null;
	private static volatile String contentSecurityPolicy = "";
	private volatile int onKeyDownKeyCode = -1;
	private volatile long onKeyDownMS = 0;
	private volatile double brightness = 1.0;
	private volatile String filePickerPath = "";
	private volatile boolean inPortrait = false;
	private volatile boolean inPortraitLast = false;
	private volatile InputStream chunkInput = null;
	private volatile byte[] fontBytes = null;
	private volatile int fontBytesOffset = 0;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		Log.d(TAG, "onCreate "+BuildConfig.VERSION_NAME);
		activity = this;
		cachePath = activity.getCacheDir().getAbsolutePath();
		handler = new Handler(Looper.getMainLooper());

		if(BuildConfig.DEBUG) {
			dbg = true;
			Log.d(TAG, "onCreate dbg="+dbg);
		}

		if(prefs==null) {
			Log.d(TAG, "onCreate getDefaultSharedPreferences()");
			prefs = PreferenceManager.getDefaultSharedPreferences(this);
			if(prefs==null) {
				Log.d(TAG, "# onCreate getDefaultSharedPreferences() fail");
				finish();
				return;
			}
		}

		PackageInfo webviewPackageInfo = getCurrentWebViewPackageInfo();
		if(webviewPackageInfo != null) {
			if(dbg) Log.d(TAG, "onCreate webview packageInfo "+
				webviewPackageInfo.packageName+" "+webviewPackageInfo.versionName);
		} else {
			Log.d(TAG, "onCreate webviewPackageInfo not set");
			webviewPackageInfo = getCurrentWebViewPackageInfo();
			if(webviewPackageInfo != null) {
				Log.d(TAG, "onCreate webview packageInfo "+
					webviewPackageInfo.packageName+" "+webviewPackageInfo.versionName);
			}
		}
		try {
			if(dbg) Log.d(TAG, "onCreate setContentView(R.layout.activity_main)");
			setContentView(R.layout.activity_main);
		} catch(Exception ex) {
			Log.d(TAG, "# onCreate setContentView ex="+ex);
			Toast.makeText(activity, "WebView problem. ProseReader failed to start.", Toast.LENGTH_LONG).show();
			finish();
			return;
		}

		myWebView = (WebView)findViewById(R.id.webview);
		if(myWebView==null) {
			Log.d(TAG,"# onCreate myWebView==null");
			finish();
			return;
		}
		myWebView.setBackgroundColor(0xff000000);

		inPortrait = getScreenOrientation()>0;
		inPortraitLast = inPortrait;

		decorView = getWindow().getDecorView();

//		if(android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.Q) {
//			// Android 10+
//		if(android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.R) {
//			// Android 11+
		if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
			// Android 12+ / API level 31+ (look for: should be the same (3x): Build.VERSION_CODES.S)
			Log.d(TAG, "onCreate setOnApplyWindowInsetsListener");
			ViewCompat.setOnApplyWindowInsetsListener(decorView, (v, insets) -> {
				boolean sysBarsVisible = insets.isVisible(WindowInsetsCompat.Type.systemBars());
				boolean navBarsVisible = insets.isVisible(WindowInsetsCompat.Type.navigationBars());
				boolean statBarsVisible = insets.isVisible(WindowInsetsCompat.Type.statusBars());
				fullscreenFlag = !navBarsVisible;
				Log.d(TAG, "windowInsetsListener sysBars="+sysBarsVisible+" navBars="+navBarsVisible+" statBars="+statBarsVisible+" fullscreen="+fullscreenFlag+" OS="+Build.VERSION.SDK_INT);
				return insets;
			});
		} else {
			// Android 11-
			decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener() {
				@Override
				public void onSystemUiVisibilityChange(int visibility) {
					if((visibility & View.SYSTEM_UI_FLAG_FULLSCREEN) == 0) {
						fullscreenFlag = false;
					} else {
						fullscreenFlag = true;
					}
					Log.d(TAG, "onSystemUiVisibilityChange FULLSCREEN="+fullscreenFlag+" OS="+Build.VERSION.SDK_INT);
				}
			});
		}

		onCreateIntent = getIntent();
	}

	@Override
	public void onTrimMemory(int level) {
		if(dbg) Log.d(TAG, "onTrimMemory level="+level);
		super.onTrimMemory(level);
	}

	@Override
	public void onStart() {
		super.onStart();
		if(dbg) Log.d(TAG, "onStart");
		onStartMS = (new Date()).getTime();

		if(!disableBrightnessControl) {
			int brightnessInt = 0;
			try {
				brightnessInt = android.provider.Settings.System.getInt(
					getContentResolver(), android.provider.Settings.System.SCREEN_BRIGHTNESS);
				brightness = (double)brightnessInt/(double)255;
			} catch (Exception e){
				Log.e("# onStart Exception", e.toString());
			}
			if(dbg) Log.d(TAG, "onStart brightness="+brightness+" int="+brightnessInt);
		}

		boolean apkVersionHasChanged = false;
		String lastVersion = prefs.getString("lastversion","");
		if(!BuildConfig.VERSION_NAME.equals(lastVersion)) {
			if(dbg) Log.d(TAG, "onStart apk vers="+BuildConfig.VERSION_NAME+" differs from lastVersion="+lastVersion);
			apkVersionHasChanged = true;
		}

		if(onCreateIntent!=null) {
			if(dbg) Log.d(TAG, "onStart with onCreateIntent "+onCreateIntent);

			if(android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.Q) {
				String documentTreeString = prefs.getString("documentTreeString", "");
				if(documentTreeString!="") {
					// we already have documentTreeUri permission
					if(dbg) Log.d(TAG, "onStart documentTreeString="+documentTreeString);
					documentTreeUri = Uri.parse(documentTreeString);
				} else {
					// if documentTreeUri is null, JS code will offer [Recent Documents] button to enable it
					// see: DIR_REQ_CODE
				}
			}

// TODO cannot outcomment ?av= - will cause exception
			String uriString = baseUrlString+"?av="+BuildConfig.VERSION_NAME;
			if(dbg) {
				uriString += "&dbg";
			}
			if(apkVersionHasChanged) {
				SharedPreferences.Editor prefed = prefs.edit();
				prefed.putString("lastversion", BuildConfig.VERSION_NAME);
				prefed.apply();
			}

//			final Handler handler = new Handler(Looper.getMainLooper());
			final String finalUriString = uriString;
			handler.postDelayed(new Runnable() {
				@Override
				public void run() {
					String myUriString = finalUriString;
					long nowMS = (new Date()).getTime();
					if(onKeyDownMS>0 && nowMS-onKeyDownMS<300) {
						if(dbg) Log.d(TAG, "onStart (delayed) with recent KeyCode");
						if(onKeyDownKeyCode==KeyEvent.KEYCODE_VOLUME_DOWN) {
							dbg = true;
							if(dbg) Log.d(TAG, "onStart (delayed) with recent KEYCODE_VOLUME_DOWN");
							Toast.makeText(activity, "Clearing Webview cache", Toast.LENGTH_SHORT).show();
							myUriString += "&rl";
							clearWebviewCache(myWebView);
						}
					}

					if(dbg) Log.d(TAG, "onStart (delayed) with onCreateIntent render uriString="+myUriString);
					if(Intent.ACTION_MAIN.equals(onCreateIntent.getAction())) {
						render(Uri.parse(myUriString));
					} else {
						render(Uri.parse(myUriString+"&norecents"));
						onNewIntent(onCreateIntent);
					}
				}
			}, 300);
		}
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		Log.d(TAG, "onKeyDown "+keyCode);
		onKeyDownKeyCode = keyCode;
		onKeyDownMS = (new Date()).getTime();
		return super.onKeyDown(keyCode, event);
	}

	@Override
	public void onNewIntent(Intent intent) {
		if(intent==null) {
			Log.d(TAG, "# onNewIntent intent==null");
			return;
		}
		if(onCreateIntent!=null && onCreateIntent.ACTION_MAIN.equals(intent.getAction())) {
			Log.d(TAG, "! onNewIntent abort on intent ACTION MAIN");
			return;
		}

		if(dbg) Log.d(TAG, "onNewIntent intent="+intent);
		String action = intent.getAction();
		String type = intent.getType();
		if(Intent.ACTION_SEND.equals(action) && type!=null) {
			if(dbg) Log.d(TAG, "onNewIntent ACTION_SEND");
			if("text/plain".equals(type)) {
				if(dbg) Log.d(TAG, "onNewIntent ACTION_SEND text/plain");
				// handleSendText(intent); // Handle text being sent
				// call wikipedia in a browser
				String sharedText = intent.getStringExtra(Intent.EXTRA_TEXT);
				if(sharedText!=null && sharedText!="") {
					if(dbg) Log.d(TAG, "onNewIntent sharedText="+sharedText);
					useSelectedText(sharedText);
				}
			}
			return;
		}

		Uri uri = intent.getData();
		if(dbg) Log.d(TAG, "onNewIntent intent.getData() uri="+uri);
		if(uri!=null) {
			openUriString(uri,false);
		}
	}

	@Override
	public void onRestart() {
		if(dbg) Log.d(TAG, "onRestart");
		super.onRestart();
	}

	@Override
	public void onResume() {
		super.onResume();
		if(dbg) Log.d(TAG,"onResume");
		// if fullscreen should be active, but is not
		if(myWebView!=null) {
			if(dbg) Log.d(TAG,"onResume -> JS:onResume()");
			try {
				myWebView.evaluateJavascript("onResume()", null);
			} catch(Exception ex) {
				Log.d(TAG,"# onResume evalJS onResume() ex="+ex);
			}
		}
		setScreenOn(true);
	}

	@Override
	public void onPause() {
		super.onPause();
		if(dbg) Log.d(TAG,"onPause");
		if(myWebView!=null) {
			if(dbg) Log.d(TAG,"onPause -> JS:transitionStop()");
			try {
				myWebView.evaluateJavascript("transitionStop()", null);
			} catch(Exception ex) {
				Log.d(TAG,"# onPause evalJS transitionStop() ex="+ex);
			}
		}
		setScreenOn(false);
	}

	@Override
	public void onUserInteraction() {
		super.onUserInteraction();
		//if(dbg) Log.d(TAG,"onUserInteraction");
		setScreenOn(true);
	}

	@Override
	public void onStop() {
		if(dbg) Log.d(TAG,"onStop");
		super.onStop();
	}

	@Override
	protected void onDestroy() {
		Log.d(TAG,"onDestroy");
		if(myWebView!=null) {
			if(dbg) Log.d(TAG, "onDestroy myWebView.destroy()");
			try {
				myWebView.stopLoading();
				myWebView.onPause();
				final ViewGroup parent = (ViewGroup)myWebView.getParent();
				if(parent != null) {
					parent.removeView(myWebView);
				}
				myWebView.removeAllViews();
				myWebView.destroy();
			} catch(Exception ex) {
				Log.d(TAG, "# onDestroy myWebView.destroy ex="+ex);
			}
			myWebView=null;
		}
		activity = null;
		super.onDestroy();
	}

	@Override
	public void onWindowAttributesChanged(WindowManager.LayoutParams params) {
		super.onWindowAttributesChanged(params);
	}

	@Override
	public void onBackPressed() {
		if(dbg) Log.d(TAG, "onBackPressed subviewOpenId="+subviewOpenId);
		if(subviewOpenId>0 && myWebView!=null) {
			try {
				myWebView.evaluateJavascript("closeTopSubview(-1)", null);
			} catch(Exception ex) {
				Log.d(TAG,"# onBackPressed evalJS closeTopSubview ex="+ex);
			}
			return;
		}

		if(dbg) Log.d(TAG, "onBackPressed textLen="+textLen);
		if(textLen>0) {
			AlertDialog.Builder alertbox = new AlertDialog.Builder(activity);
			alertbox.setMessage("Exit ProseReader?");
			alertbox.setOnCancelListener(new DialogInterface.OnCancelListener() {
				// calling JS:onResume() will fix status-bar hanging over icongrid
				@Override
				public void onCancel(DialogInterface dialog) {
					if(myWebView!=null) {
						if(dbg) Log.d(TAG,"onBackPressed -> JS:onResume()");
						try {
							myWebView.evaluateJavascript("onResume()", null);
						} catch(Exception ex) {
							Log.d(TAG,"# onBackPressed evalJS onResume() ex="+ex);
						}
					}
				}
			});
			alertbox.setNegativeButton("Abort", new DialogInterface.OnClickListener() {
				// calling JS:onResume() will fix status-bar hanging over icongrid
				@Override
				public void onClick(DialogInterface dialog, int which) {
					if(myWebView!=null) {
						if(dbg) Log.d(TAG,"onBackPressed -> JS:onResume()");
						try {
							myWebView.evaluateJavascript("onResume()", null);
						} catch(Exception ex) {
							Log.d(TAG,"# onBackPressed evalJS onResume() ex="+ex);
						}
					}
				}
			});
			alertbox.setPositiveButton("Exit", new DialogInterface.OnClickListener() {
				@Override
				public void onClick(DialogInterface dialog, int which) {
					finish();
				}
			});
			alertbox.show();
			return;
		}

		super.onBackPressed();
	}

	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		// accept all changes (for instance orientation) without restarting the activity
		super.onConfigurationChanged(newConfig);

		DisplayMetrics dpM = Resources.getSystem().getDisplayMetrics();
		if(dbg) Log.d(TAG, "onConfigurationChanged "+dpM.widthPixels+"x"+dpM.heightPixels+" "+newConfig);

		inPortrait = newConfig.orientation!=Configuration.ORIENTATION_LANDSCAPE;
		if(inPortrait!=inPortraitLast) {
/*
			// forward landscape/portrait to js
			if(myWebView==null) {
				Log.d(TAG, "# onConfigurationChanged myWebView==null");
			} else {
				try {
					if(dbg) Log.d(TAG, "onConfigurationChanged call setOrientation("+inPortrait+")");
					myWebView.evaluateJavascript("setOrientation("+inPortrait+")", null);
				} catch(Exception ex) {
					Log.d(TAG,"# onConfigurationChanged evalJS ex="+ex);
				}
			}
*/
			inPortraitLast = inPortrait;
		}
	}

	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		if(requestCode==FILE_REQ_CODE) {
			if(dbg) Log.d(TAG, "onActivityResult FILE_REQ_CODE resultCode="+resultCode);
			Uri[] results = null;
			filePickerPath = "";
			if(resultCode == Activity.RESULT_OK) { // Activity.RESULT_OK = -1
				ClipData clipData = null;
				String stringData = null;
				try {
					clipData = data.getClipData();
					stringData = data.getDataString();
					if(dbg) Log.d(TAG, "onActivityResult clipData="+clipData+" stringData="+stringData);
				} catch(Exception ex) {
					clipData = null;
					stringData = null;
					Log.d(TAG, "# onActivityResult ex="+ex);
				}

				if(clipData != null) {
					if(dbg) Log.d(TAG, "onActivityResult multiple files clipData+"+clipData);
					final int numSelectedFiles = clipData.getItemCount();
					results = new Uri[numSelectedFiles];
					for(int i=0; i<clipData.getItemCount(); i++) {
						results[i] = clipData.getItemAt(i).getUri();
					}
				} else if(stringData!=null) {
					Log.d(TAG, "onActivityResult single file stringData="+stringData);
					filePickerPath = stringData;
					Uri uri = Uri.parse(stringData);
					results = new Uri[]{uri};
				}
			} else {
				Log.d(TAG, "! onActivityResult no file selected");
			}

			if(myFilePathCallback!=null) {
				if(results!=null) {
					if(dbg) Log.d(TAG, "onActivityResult send selected file data to JS:openFile() "+results.length);
					lastLoadedUri = results[0];
				}

				myFilePathCallback.onReceiveValue(results);
				myFilePathCallback = null;
			}
		} else if(requestCode==DIR_REQ_CODE) {
			Uri myDocumentTreeUri = null;
			if(resultCode == Activity.RESULT_OK) { // Activity.RESULT_OK = -1
				myDocumentTreeUri = data.getData();
				if(dbg) Log.d(TAG, "onActivityResult documentTreeUri="+myDocumentTreeUri);

				if(myDocumentTreeUri!=null) {
					if(!myDocumentTreeUri.toString().endsWith("Documents")) {
						myDocumentTreeUri = null;
					}
				}

				if(myDocumentTreeUri!=null) {
					if(documentTreeUri!=null) {
						getContentResolver().releasePersistableUriPermission(documentTreeUri,
							Intent.FLAG_GRANT_READ_URI_PERMISSION);
					}

					getContentResolver().takePersistableUriPermission(myDocumentTreeUri,
						Intent.FLAG_GRANT_READ_URI_PERMISSION);

					SharedPreferences.Editor prefed = prefs.edit();
					prefed.putString("documentTreeString", myDocumentTreeUri.toString());
					prefed.apply();

					documentTreeUri = myDocumentTreeUri;
					if(dbg) Log.d(TAG, "onActivityResult documentTreeUri stored");

					if(myWebView!=null) {
						try {
							myWebView.evaluateJavascript("disableRecentsButton()", null);
							Toast.makeText(activity, "Access to Documents granted", Toast.LENGTH_SHORT).show();
						} catch(Exception ex) {
							Log.d(TAG,"# onActivityResult evalJS disableRecentsButton() ex="+ex);
							myDocumentTreeUri = null;
							prefed = prefs.edit();
							prefed.putString("documentTreeString", "");
							prefed.apply();
						}
					}
				}
			}
			if(myDocumentTreeUri==null) {
				AlertDialog.Builder alertbox = new AlertDialog.Builder(activity);
				alertbox.setMessage("Access to Documents folder has failed (code="+resultCode+")");
				alertbox.setPositiveButton("OK", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
					}
				});
				alertbox.show();
			}
		} else {
			Log.d(TAG,"! onActivityResult requestCode="+requestCode);
		}
		super.onActivityResult(requestCode, resultCode, data);
	}

	//////////////////////////////////////

	public class ProseJSInterface {
		static final String TAG = "ProseJSInterface";
		static final String cacheFolderName = "pr-cache";

		ProseJSInterface() {
			if(dbg) Log.d(TAG, "instantiate");
			chunkInput = null;
		}

		@android.webkit.JavascriptInterface
		public void appRestart() {
			PackageManager packageManager = activity.getPackageManager();
			Intent intent = packageManager.getLaunchIntentForPackage(activity.getPackageName());
			ComponentName componentName = intent.getComponent();
			Intent mainIntent = Intent.makeRestartActivityTask(componentName);
			mainIntent.setPackage(activity.getPackageName());
			activity.startActivity(mainIntent);
			Runtime.getRuntime().exit(0);
		}

		@android.webkit.JavascriptInterface
		public void metaContent(boolean allow) {
			if(dbg) Log.d(TAG, "metaContent "+allow);
			myWebView.post(new Runnable() {
				@Override
				public void run() {
					if(myWebView!=null) {
						WebSettings webSettings = myWebView.getSettings();
						if(webSettings!=null) {
							if(dbg) Log.d(TAG, "metaContent zooming="+allow);
							if(allow) {
								//!!! webSettings.setTextZoom(0); // use device/OS user-setting
								myWebView.zoomBy(2f);
							} else {
								//!!! webSettings.setTextZoom(100); // do NOT use device/OS user-setting
								//!!! strange but this is how to reset the zoom set by user back to default/no-zoom
								myWebView.zoomBy(0.1f);
							}
							webSettings.setSupportZoom(allow);
							webSettings.setBuiltInZoomControls(allow);
						}
						myWebView.setHorizontalScrollBarEnabled(allow);
					}
				}
			});
		}

		@android.webkit.JavascriptInterface
		public int deleteAllCachedFiles() {
			String filename2 = getFilesDir().getPath()+"/"+cacheFolderName;
			File startFolder = new File(filename2);
			return deleteRecursive(startFolder);
		}

		@android.webkit.JavascriptInterface
		public int deleteCachedFile(String filename) {
			String filename2 = getFilesDir().getPath()+"/"+cacheFolderName+"/"+filename+".mz";
			File file = new File(filename2);
			if(file==null) {
				Log.d(TAG,"# deleteCachedFile file==null for filename="+filename2);
			} else if(!file.exists()) {
				//Log.d(TAG,"# deleteCachedFile does not exist filename="+filename2);
			} else {
				Log.d(TAG,"deleteCachedFile filename="+filename2);
				try {
					file.delete();
				} catch(Exception ex) {
					Log.d(TAG,"# deleteCachedFile filename="+filename2+" ex="+ex);
				}
			}
			// must also delete all subbooks (...-1.mz, ...-2.mz)
			for(int i=0; i<40; i++) {
				filename2 = getFilesDir().getPath()+"/"+cacheFolderName+"/"+filename+"-"+i+".mz";
				file = new File(filename2);
				if(file==null) {
					Log.d(TAG,"# deleteCachedFile file==null for filename="+filename2);
				} else if(!file.exists()) {
					//Log.d(TAG,"# deleteCachedFile does not exist filename="+filename2);
				} else {
					Log.d(TAG,"deleteCachedFile filename="+filename2);
					try {
						file.delete();
					} catch(Exception ex) {
						Log.d(TAG,"# deleteCachedFile filename="+filename2+" ex="+ex);
					}
				}
			}
			return -1;
		}

		@android.webkit.JavascriptInterface
		public int storeCachedFile(String filename, String mdText) {
			return storeFile(cacheFolderName, filename, mdText, null);
/*
			try {
				String cacheFolderPath = getFilesDir().getPath()+"/"+cacheFolderName;
	  			File folder = new File(cacheFolderPath);
				if(!folder.exists()) {
					Log.d(TAG,"storeCachedFile create cacheFolderName: "+cacheFolderPath);
					folder.mkdir();
				}
				if(!folder.exists()) {
					Log.d(TAG,"# storeCachedFile cacheFolderName does not exist: "+cacheFolderPath);
					return -2;
				}
				try {
		  			filename = filename+".mz";
					FileOutputStream fos = new FileOutputStream(new File(folder, filename));
					OutputStream dfos = new DeflaterOutputStream(fos);
					dfos.write(mdText.getBytes());
					dfos.flush();
					dfos.close();
					fos.close();
					Log.d(TAG,"storeCachedFile done filename="+filename+" in folder="+folder+" len="+mdText.length());
					return 0;
				} catch(Exception ex) {
					// should never happen: activity fetches WRITE_EXTERNAL_STORAGE permission up front
					Log.d(TAG,"# storeCachedFile filename="+filename+" folder="+folder+" len="+mdText.length()+" ex="+ex);
					return -3;
				}
			} catch(Exception ex) {
				// should never happen: activity fetches WRITE_EXTERNAL_STORAGE permission up front
				Log.d(TAG,"# storeCachedFile cacheFolderName="+cacheFolderName+" ex="+ex);
			}
			return -1;
*/
		}
		
		@android.webkit.JavascriptInterface
		public String loadCachedFile(String filename) {
			try {
				filename = filename+".mz";
				String cacheFolderPath = getFilesDir().getPath()+"/"+cacheFolderName;
	  			File folder = new File(cacheFolderPath);
				if(!folder.exists()) {
					Log.d(TAG,"# loadCachedFile cacheFolderName does not exist: "+cacheFolderPath);
					return "";
				}

				byte[] bytes = new byte[6*1024*1024];
				FileInputStream fis = new FileInputStream(new File(folder, filename));
		        InputStream dfis = new InflaterInputStream(fis);
				int len, offset=0, chunks=0;
				while(true) {
					byte[] chunk = new byte[4*1024];
					len = dfis.read(chunk);
					if(len<=0) {
						break;
					}
					//Log.d(TAG,"loadCachedFile filename="+filename+" offset="+offset+" len="+len+" chunk="+chunks);
					int i=0;
					while(i<len) {
						bytes[offset++] = chunk[i++];
					}
					chunks++;
				}
				dfis.close();
				fis.close();
				byte[] sub = java.util.Arrays.copyOfRange(bytes, 0, offset);
				String mdText = new String(sub);
				Log.d(TAG,"loadCachedFile done filename="+filename+" offset="+offset+" len="+mdText.length()+" chunks="+chunks);
				return mdText;
			} catch(Exception ex) {
				String exStr = ex.toString();
				Log.d(TAG,"! loadCachedFile filename="+filename+" ex="+exStr);
				//!!! we do NOT show FileNotFound as an (alarming) error msg
				if(exStr.indexOf("FileNotFoundException")<0) {
					Toast.makeText(activity, "Error loading from cache: "+ex, Toast.LENGTH_SHORT).show();
				}
			}
			return "";
		}

		@android.webkit.JavascriptInterface
		public void setDbg(boolean flag) {
			dbg = flag;
			Log.d(TAG, "webView.setDbg("+flag+")");
		}

		@android.webkit.JavascriptInterface
		public void setLang(String setLang) {
			docLang = setLang;
			Log.d(TAG, "webView.setLang("+docLang+")");
		}

		@android.webkit.JavascriptInterface
		public String getVersionName() {
			if(dbg) Log.d(TAG, "webView.getVersionName()");
			return BuildConfig.VERSION_NAME;
		}

		@android.webkit.JavascriptInterface
		public void useSelectedString(String sharedText) {
			useSelectedText(sharedText);
		}

		@android.webkit.JavascriptInterface
		public boolean fullscreen(int mode) {
			// mode  0 = off, 1 = on, -1 = toggle, 2=reinforceFS
			if(myWebView==null) {
				Log.d(TAG, "! webView.fullscreen() no myWebView state="+fullscreenFlag+" mode="+mode);
				return false;
			}
			if(dbg) Log.d(TAG, "webView.fullscreen() state="+fullscreenFlag+" mode="+mode+" OS="+Build.VERSION.SDK_INT);
			if(!fullscreenFlag || mode==2) {
				// fullscreenFlag was cleared by onSystemUiVisibilityChange()
				if(mode==0) {
					// fullscreenFlag is aleady OFF, do nothing
					return false;
				}
				// fullscreenFlag is OFF but we want it ON: so we turn into fullscreen now
				// hide navigation and status bars
				if(dbg) Log.d(TAG, "webView.fullscreen() go fullscreen: hide navigation + status bars");
				myWebView.post(new Runnable() {
					@Override
					public void run() {
						if(decorView!=null) {
							if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
								// Android 12+ / API level 31+ (look for: should be the same: Build.VERSION_CODES.S)
								WindowCompat.setDecorFitsSystemWindows(getWindow(), false);
								WindowInsetsControllerCompat windowInsetsController =
									new WindowInsetsControllerCompat(getWindow(), decorView);
								//windowInsetsController.setAppearanceLightNavigationBars(false);
								windowInsetsController.hide(WindowInsetsCompat.Type.systemBars());
								windowInsetsController.hide(WindowInsetsCompat.Type.statusBars());
								windowInsetsController.hide(WindowInsetsCompat.Type.navigationBars());
							} else {
								// Android 11- / API level 30-
								decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
															  | View.SYSTEM_UI_FLAG_FULLSCREEN
															  | View.SYSTEM_UI_FLAG_IMMERSIVE);
							}
						}
					}
				});
				// fullscreenReqFlag = true;
				// all cases where fullscreenFlag was off have been taken care of
				// fullscreen will be ON when Runnable run() is finished
				return true;
			}

			// fullscreenFlag is currently ON

			if(mode==1) {
				// device is already in fullscreen mode: do nothing
				return true;
			}

			// mode is -1 or 0: so we turn fullscreen OFF now

			if(dbg) Log.d(TAG, "webView.fullscreen() leave fullscreen: show navigation bar + status bar");
			if(decorView!=null) {
				myWebView.post(new Runnable() {
					@Override
					public void run() {
						if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
							// Android 12+ / API level 31+ (look for: should be the same: Build.VERSION_CODES.S)
							WindowCompat.setDecorFitsSystemWindows(getWindow(), true);
							WindowInsetsControllerCompat windowInsetsController =
								new WindowInsetsControllerCompat(getWindow(), decorView);
							//windowInsetsController.setAppearanceLightNavigationBars(true);
							windowInsetsController.show(WindowInsetsCompat.Type.systemBars());
							windowInsetsController.show(WindowInsetsCompat.Type.statusBars());
							windowInsetsController.show(WindowInsetsCompat.Type.navigationBars());
						} else {
							// Android 11- / API level 30-
							decorView.setSystemUiVisibility(0);
						}
					}
				});
			}
			//fullscreenReqFlag = false;
			// fullscreen will be OFF when Runnable run() is finished
			return false;
		}

		@android.webkit.JavascriptInterface
		public void clearCache() {
			if(myWebView==null) {
				if(dbg) Log.d(TAG, "# webView.clearCache abort myWebView==null");
			} else {
				if(dbg) Log.d(TAG, "webView.clearCache");
				myWebView.post(new Runnable() {
					@Override
					public void run() {
						clearWebviewCache(myWebView);
					}
				});
			}
		}

		@android.webkit.JavascriptInterface
		public void setTextLen(int len) {
			textLen = len;
			if(dbg) Log.d(TAG, "webView.setTextLen() textLen="+textLen);
		}

		@android.webkit.JavascriptInterface
		public void subviewVisible(int id) {
			if(dbg) Log.d(TAG, "webView.subviewVisible() id="+id);
			subviewOpenId = id;
		}

		@android.webkit.JavascriptInterface
		public String getChunkData(Uri uri) {
			// NOTE: getChunkData() does NOT use uri, but getChunkDataUri, set by java:openUriString()
			if(chunkInput==null) {
				if(getChunkDataUri==null) {
					Log.d(TAG, "# getChunkData() getChunkDataUri==null");
					return null;
				}

				try {
					if(getChunkDataViaDocumentFile) {
						String filename = getChunkDataUri.getPath();

						Log.d(TAG, "getChunkData() filename1="+filename);
						int idxDocument = filename.indexOf(":Documents/");
						if(idxDocument>=0) {
							filename = filename.substring(idxDocument+11);
						}
						// these 15 lines may not be needed anymore
						idxDocument = filename.indexOf("/document/home:");   	    // old assumtion
						if(idxDocument>=0) {
							filename = filename.substring(idxDocument+15);
						}
						idxDocument = filename.indexOf("/tree/home:");				// documentTreeString on p9
						if(idxDocument>=0) {
							filename = filename.substring(idxDocument+11);
						}
						idxDocument = filename.indexOf("/tree/primary:Documents"); // documentTreeString on sam
						if(idxDocument>=0) {
							filename = filename.substring(idxDocument+23);
						}
						if(filename.startsWith("/")) {
							filename = filename.substring(1);
						}
						// decode all '&apos;' to apostrophes
						filename = filename.replace("&apos;","'");
						Log.d(TAG, "getChunkData() filename2="+filename);
						DocumentFileCompat documentDir = DocumentFileCompat.fromTreeUri(activity, documentTreeUri);
						if(documentDir==null) {
							Log.d(TAG, "# getChunkData() documentDir is null");
						} else {
							// support for deep subfolders
							int idxSlash = filename.indexOf("/");
							while(idxSlash>=0) {
								// the file is in a subfolder of Documents
								Log.d(TAG, "getChunkData() subfolder idxSlash="+idxSlash);
								String subFolder = filename.substring(0,idxSlash);
								Log.d(TAG, "getChunkData() subFolder="+subFolder);
								documentDir = documentDir.findFile(subFolder);
								if(documentDir==null) {
									break;
								}
								filename = filename.substring(idxSlash+1);
								Log.d(TAG, "getChunkData() filename2b="+filename);
								idxSlash = filename.indexOf("/");
							}
							
							if(documentDir==null) {
								Log.d(TAG, "# getChunkData() documentDir is null (2nd stage)");
							} else {
								Log.d(TAG, "getChunkData() documentDir.findFile "+filename);
								DocumentFileCompat documentFile = documentDir.findFile(filename);
								if(documentFile==null) {
									Log.d(TAG, "# getChunkData() documentFile is null (file not found)");
								} else {
									Log.d(TAG, "getChunkData() documentFile="+documentFile);
									chunkInput = getContentResolver().openInputStream(documentFile.getUri());
								}
							}
						}
					} else {
						//Log.d(TAG, "getChunkData() openInputStream("+getChunkDataUri+")");
						chunkInput = getContentResolver().openInputStream(getChunkDataUri);
					}
				} catch(Exception ex) {
					Log.d(TAG, "# getChunkData() ex="+ex);
					chunkInput = null;
				}
			}

			if(chunkInput!=null) {
				try {
					int nRead;
					byte[] data = new byte[1024*1024];
					nRead = chunkInput.read(data, 0, data.length);
					//if(dbg) Log.d(TAG, "getChunkData() nRead="+nRead);
					if(nRead>0) {
						if(nRead < data.length) {
							if(dbg) Log.d(TAG, "getChunkData() data2 nRead="+nRead);
							byte[] data2 = new byte[nRead];
							for(int i=0;i<nRead;i++) {
								data2[i] = data[i];
							}
							String b64str = Base64.encodeToString(data2, Base64.DEFAULT);
							//if(dbg) Log.d(TAG, "getChunkData() b64str.len="+b64str.length()+" from="+nRead);
							return b64str;
						}
						String b64str = Base64.encodeToString(data, Base64.DEFAULT);
						//if(dbg) Log.d(TAG, "getChunkData() b64str.len="+b64str.length()+" from="+nRead);
						return b64str;
					}
					lastLoadedUri = getChunkDataUri;
					chunkInput.close();
				} catch(Exception ex) {
					Log.d(TAG, "# getChunkData() ex="+ex);
				}
				chunkInput = null;
				getChunkDataViaDocumentFile = false;
				getChunkDataUri = null;
				if(dbg) Log.d(TAG, "getChunkData() finished");
			}
			return null;
		}

		@android.webkit.JavascriptInterface
		public String onStartUrl() {
			String uriPath = "";
			if(onCreateIntent!=null) {
				if(onCreateIntent.getAction().equals(Intent.ACTION_VIEW)) {
					Uri uri = onCreateIntent.getData();
					uriPath = uri.getPath();
					if(dbg) Log.d(TAG, "onStartUrl() "+uriPath);
					onNewIntent(onCreateIntent);
				}
				onCreateIntent = null;
			}
			return uriPath;
		}

		@android.webkit.JavascriptInterface
		public String getLastUri() {
			if(lastLoadedUri!=null) {
				return lastLoadedUri.toString();
			}
			return "";
		}

		@android.webkit.JavascriptInterface
		public Uri getDocumentTreeUri() {
			if(android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.Q) {
				return documentTreeUri;
			}
			return null;
		}

		@android.webkit.JavascriptInterface
		public String getFilePickerPath() {
			return filePickerPath;
		}

		@android.webkit.JavascriptInterface
		public String getDocumentTreeString() {
			if(documentTreeUri!=null) {
				if(android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.Q) {
					return documentTreeUri.toString();
				}
			}
			return "";
		}

		@android.webkit.JavascriptInterface
		public boolean getDocumentTreeSupported() {
			if(android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.Q) {
				return true;
			}
			return false;
		}

		@android.webkit.JavascriptInterface
		public void enableDocumentTreeUri() {
			if(dbg) Log.d(TAG, "enableDocumentTreeUri()");
			if(android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.Q) {
				//!!! Q = Android 10 (API level 29)
				if(dbg) Log.d(TAG, "enableDocumentTreeUri() ACTION_OPEN_DOCUMENT_TREE to get documentTreeUri");
				Intent intent = new Intent(Intent.ACTION_OPEN_DOCUMENT_TREE);
				Uri uri = Uri.parse("content://com.android.externalstorage.documents/");
				intent.putExtra(DocumentsContract.EXTRA_INITIAL_URI, uri);
				startActivityForResult(intent, DIR_REQ_CODE);
			} else {
				Log.d(TAG, "# enableDocumentTreeUri() ACTION_OPEN_DOCUMENT_TREE only for API 29+ / OS Q+");
			}
		}

		@android.webkit.JavascriptInterface
		public void loadDocument(String uriString) {
			if(uriString==null || uriString=="") {
				Log.d(TAG, "# loadDocument no uriString ("+uriString+")");
				return;
			}
			if(documentTreeUri==null) {
				Log.d(TAG, "# loadDocument no documentTreeUri");
				return;
			}
			Log.d(TAG, "loadDocument("+uriString+")");

			getChunkDataUri = documentTreeUri;
			getChunkDataViaDocumentFile = true;
			Uri uri = Uri.parse(uriString);
			openUriString(uri,true);
		}

		@android.webkit.JavascriptInterface
		public void toast(String message, int durationMs) {
			if(message!=null && !message.equals("")) {
				Log.d(TAG, "toast '"+message+"'");
				Toast.makeText(activity, message, durationMs).show();
				return;
			}
		}

		@android.webkit.JavascriptInterface
		public float getScreenInches() {
			DisplayMetrics dm = new DisplayMetrics();
			getWindowManager().getDefaultDisplay().getMetrics(dm);
			double x = Math.pow(dm.widthPixels/dm.xdpi,2);
			double y = Math.pow(dm.heightPixels/dm.ydpi,2);
			double screenInches = Math.sqrt(x+y);
			if(dbg) Log.d(TAG, "getScreenInches " + screenInches);
			return (float)screenInches;
		}

		@android.webkit.JavascriptInterface
		public int getPixForDp(float dp) {
			// dp = 16.0f means 16dp			DisplayMetrics
			// Convert the dps to pixels, based on density scale
			int pixelDistance = (int)android.util.TypedValue.applyDimension(
					android.util.TypedValue.COMPLEX_UNIT_DIP,  dp + 0.5f, getResources().getDisplayMetrics());
			// Use pixelDistance as a distance in pixels...
			return pixelDistance;
		}

		@android.webkit.JavascriptInterface
		public int getDpi() {
			DisplayMetrics dpM = Resources.getSystem().getDisplayMetrics();
			if(dbg) Log.d(TAG, "getDpi xdpi="+dpM.xdpi+" ydpi="+dpM.ydpi);
			return (int)dpM.xdpi;
		}

		@android.webkit.JavascriptInterface
		public double getScreenBrightness() {
			// NOTE: does not dynamically update; is only retrieved onStart() (this is all we need)
			if(dbg) Log.d(TAG, "getScreenBrightness "+brightness);
			return brightness;
		}

		@android.webkit.JavascriptInterface
		public void disableBrightnessControl(boolean val) {
			if(dbg) Log.d(TAG, "disableBrightnessControl "+val);
			disableBrightnessControl = val;
			myWebView.post(new Runnable() {
				@Override
				public void run() {
					if(dbg) Log.d(TAG, "setScreenBrightness "+brightness);
					WindowManager.LayoutParams layout = getWindow().getAttributes();
					if(disableBrightnessControl==true) {
						// set NOT OVERRIDDEN
						layout.screenBrightness = WindowManager.LayoutParams.BRIGHTNESS_OVERRIDE_NONE;
					} else {
						layout.screenBrightness = (float)brightness;
					}
					getWindow().setAttributes(layout);
				}
			});
		}

		@android.webkit.JavascriptInterface
		public void setScreenBrightness(double val) {
//			if(dbg) Log.d(TAG, "setScreenBrightness "+val);
//			if(val<WindowManager.LayoutParams.BRIGHTNESS_OVERRIDE_OFF) {
//				val = WindowManager.LayoutParams.BRIGHTNESS_OVERRIDE_OFF;
//			}
			if(disableBrightnessControl) {
				return;
			}
			if(val<0.004) {
				// a lower brightness will turn the screen brighter!!!
				val = 0.004;
			} else if(val>1) {
				val = 1.0;
			}
			brightness = val;
			myWebView.post(new Runnable() {
				@Override
				public void run() {
					if(dbg) Log.d(TAG, "setScreenBrightness "+brightness);
					WindowManager.LayoutParams layout = getWindow().getAttributes();
					layout.screenBrightness = (float)brightness;
					getWindow().setAttributes(layout);
				}
			});
		}
/*
		@android.webkit.JavascriptInterface
		public void setAcceptRemoteIntents(boolean val) {
			if(dbg) Log.d(TAG, "setAcceptRemoteIntents "+val);
			acceptRemoteIntents = val;
		}
*/
		@android.webkit.JavascriptInterface
		public void setExtScreenTimeout(int val) {
			if(dbg) Log.d(TAG, "setExtScreenTimeout "+val+" minutes");
			extScreenTimeout = val;
		}

		@android.webkit.JavascriptInterface
		public boolean getOrientation() {
			if(dbg) Log.d(TAG, "getOrientation portrait="+inPortrait);
			return inPortrait;
		}

		@android.webkit.JavascriptInterface
		public void resetDocumentTree() {
			SharedPreferences.Editor prefed = prefs.edit();
			prefed.putString("documentTreeString", "");
			prefed.apply();
			documentTreeUri = null;
		}

		@android.webkit.JavascriptInterface
		public String getFontArchive(int loop, String b64, int size, String fontName, int fileSize) {
			// unzip fontArchive encoded in b64
			if(dbg) Log.d(TAG, "getFontArchive loop="+loop+" font="+fontName+" encoded.len="+size);
			byte[] decoded = null;

			if(loop==0) {
				// init alloc fileSize
				fontBytes = new byte[fileSize];
				fontBytesOffset = 0;
			}

			// note: 'decoded.length' must be same as 'fileSize' in js:readFont()

			if(loop >= 0) {
				decoded = Base64.decode(b64,Base64.DEFAULT);
				if(dbg) Log.d(TAG, "getFontArchive loop="+loop+" decoded.len="+decoded.length+" (stored size)");
// TODO copy decoded into flat memory
// ArrayIndexOutOfBoundsException: src.length=2796204 srcPos=0 dst.length=22166212 dstPos=19573428 length=2796204
				System.arraycopy(decoded, 0, fontBytes, fontBytesOffset, decoded.length);
				fontBytesOffset += decoded.length;
				if(dbg) Log.d(TAG, "getFontArchive continue fontBytesOffset="+fontBytesOffset);
				return "";
			}

			// last chunk was received, fontBytes now contains the compete original data (base64 decoded)
			// we can now unzip fontBytes and storeFile() each font-file in our internal font folder
			// when we are finished, we return a pipe | separated string with all fontnames
			size = fontBytesOffset;
			if(dbg) Log.d(TAG, "getFontArchive start decode zip, size="+size);
			ZipInputStream zi = null;
			try {
				if(dbg) Log.d(TAG, "getFontArchive ZipInputStream(new ByteArrayInputStream(fontBytes))");
				zi = new ZipInputStream(new ByteArrayInputStream(fontBytes));
				if(dbg) Log.d(TAG, "getFontArchive zf.entries()");
				StringJoiner strj = new StringJoiner("|");
				ZipEntry zipEntry = null;
				if(dbg) Log.d(TAG, "getFontArchive zi.getNextEntry() loop");
				while((zipEntry = zi.getNextEntry()) != null) {
//!!! NOTE: on Android O zipEntry.getSize() may return -1 (unless we read from a file via ZipFile("file.zip")
					int filesize = (int)zipEntry.getSize();
					if(dbg) Log.d(TAG, "getFontArchive entry='"+zipEntry.getName()+"' filesize="+filesize);
					if(zipEntry.isDirectory()) {
						continue;
					}

					// here we can copy all .ttf' and .woff files to app-home/font/
					String localFilename = zipEntry.getName();
					if(localFilename.endsWith(".ttf") ||
						localFilename.endsWith(".woff") ||
						localFilename.endsWith(".woff2")) {
						if(dbg) Log.d(TAG, "getFontArchive localFilename='"+localFilename+"'");
/*
						int idxLastSlash = localFilename.lastIndexOf("/");
						if(idxLastSlash>0) {
							localFilename = localFilename.substring(idxLastSlash+1);
						}
*/
if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
						storeFile("font", localFilename, "", zi.readAllBytes());
} else {
						//!!! Android Q and older do NOT support readAllBytes()
						if(filesize<=0) {
							filesize = 1000000;
						}
						byte[] buffer = new byte[filesize];
						int filled = 0;
						while(true) {
							int len = zi.read(buffer,filled,filesize-filled);
							if(len<=0) {
								break;
							}
							filled += len;
						}

						byte[] wrBuffer = java.util.Arrays.copyOfRange(buffer, 0, filled);
						Log.d(TAG, "getFontArchive API"+Build.VERSION.SDK_INT+"<Q "+
							"read="+filled+"/"+wrBuffer.length+" sz="+filesize);
						storeFile("font", localFilename, "", wrBuffer);
}
						strj.add(localFilename);
					} else {
						if(dbg) Log.d(TAG, "! getFontArchive skip localFilename='"+localFilename+"'");
					}
				}
				// return an array to JS with all zipEntries (so JS can create the CSS for font-import)
				if (zi != null) {
					try {
						zi.close();
					} catch(Exception ex) {
					}
				}
				// free memory
				fontBytes=null;
				Log.d(TAG, "getFontArchive strj.toStr()="+strj.toString());
				return strj.toString();

			} catch(Exception ex) {
				Log.d(TAG, "# getFontArchive FileInputStream() ex",ex);
			}
			Log.d(TAG, "! getFontArchive return=''");
			// free memory
			fontBytes=null;
			return "";
		}

		@android.webkit.JavascriptInterface
		public int fontDelete(String fontName) {
			//!!! delete $HOME/font/fontName
			return deleteFile("font", fontName);
		}
	}

	////////// private functions //////////////////////////////////////

	private final int deleteFile(String folderName, String filename) {
		try {
			String folderPath = getFilesDir().getPath()+"/"+folderName;
  			File folder = new File(folderPath);
			if(!folder.exists()) {
				Log.d(TAG,"# deleteFile folder does not exist: "+folderPath);
				return -1;
			}
			File file = new File(folder, filename);
			boolean ok = file.delete();
			Log.d(TAG,"deleteFile="+folderPath+" filename="+filename+" ok="+ok);
			if(ok) {
				return 0;
			}
			return -2;
		} catch(Exception ex) {
			Log.d(TAG,"# deleteFile folderName="+folderName+" filename="+filename+" ex="+ex);
		}
		return -3;
	}

	private final int storeFile(String folderName, String filename, String stringData, byte[] byteData) {
		try {
			String folderPath = getFilesDir().getPath()+"/"+folderName;
  			File folder = new File(folderPath);
			if(!folder.exists()) {
				Log.d(TAG,"storeFile create folderName: "+folderPath);
				folder.mkdir();
			}
			if(!folder.exists()) {
				Log.d(TAG,"# storeFile folderName does not exist: "+folderPath);
				return -2;
			}

			int idxLastSlash = filename.lastIndexOf("/");
			if(idxLastSlash>0) {
				filename = filename.substring(idxLastSlash+1);
			}

			try {
				FileOutputStream fos;
				if(stringData!="") {
// TODO get the file '.ext' via function parameter
		  			filename = filename+".mz";
					fos = new FileOutputStream(new File(folder, filename));
					if(fos!=null) {
						byte[] data = stringData.getBytes();
						OutputStream dfos = new DeflaterOutputStream(fos);
						if(dfos!=null) {
							Log.d(TAG,"storeFile done filename="+filename+" folder="+folder+" len="+data.length);
							dfos.write(data);
							dfos.flush();
							dfos.close();
						} else {
							Log.d(TAG,"! storeFile no dfos, filename="+filename+" folder="+folder+" len="+data.length);
						}
					} else {
						Log.d(TAG,"! storeFile no fos, filename="+filename+" folder="+folder);
					}
				} else {
					fos = new FileOutputStream(new File(folder, filename));
					if(fos!=null) {
						fos.write(byteData);
						Log.d(TAG,"storeFile done filename="+filename+" folder="+folder+" bytelen="+byteData.length);
					} else {
						Log.d(TAG,"! storeFile no fos, filename="+filename+" folder="+folder+" bytelen="+byteData.length);
					}
				}
				if(fos!=null) {
					Log.d(TAG,"storeFile flush+close");
					fos.flush();
					fos.close();
				}
				return 0;
			} catch(Exception ex) {
				// should never happen: activity fetches WRITE_EXTERNAL_STORAGE permission up front
				Log.d(TAG,"# storeFile filename="+filename+" folder="+folder+" len="+stringData.length()+" ex="+ex);
				Toast.makeText(activity, "storeFile "+filename+" ex="+ex, Toast.LENGTH_LONG).show();
				return -3;
			}
		} catch(Exception ex) {
			// should never happen: activity fetches WRITE_EXTERNAL_STORAGE permission up front
			Log.d(TAG,"# storeFile folderName="+folderName+" ex="+ex);
			Toast.makeText(activity, "storeFile "+filename+" ex="+ex, Toast.LENGTH_LONG).show();
		} catch(OutOfMemoryError ex) {
			Toast.makeText(activity, "storeFile "+filename+" ex="+ex, Toast.LENGTH_LONG).show();
		}
		return -1;
	}

	private final Handler mHandler = new Handler() {
		@Override
		public void handleMessage(android.os.Message msg) {
			Log.d(TAG, "handleMessage "+msg.what);
			if(msg.what==DISABLE_KEEP_SCREEN_ON) {
				Log.d(TAG, "handleMessage setKeepScreenOn(false)");
				myWebView.setKeepScreenOn(false);
			}
		}
	};

	private void setScreenOn(boolean enabled) {
		// code by Trevor Carothers
		//if(dbg) Log.d(TAG, "setScreenOn=" + enabled);
		// Remove any previous delayed messages
		mHandler.removeMessages(DISABLE_KEEP_SCREEN_ON);
		if(enabled && extScreenTimeout>0) {
			// Send a new delayed message to disable the screen on
			// NOTE: After we call setKeepScreenOn(false) the screen will still stay on for
			// the system systemScreenTimeout. Thus, we subtract it out from our desired time.
			int SCREEN_ON_TIME_MS = extScreenTimeout*60*1000;
			int systemScreenTimeout = android.provider.Settings.System.getInt(getContentResolver(),
				android.provider.Settings.System.SCREEN_OFF_TIMEOUT, 0);
			int totalDelay = SCREEN_ON_TIME_MS; // - systemScreenTimeout;
			if(totalDelay > 0) {
				myWebView.setKeepScreenOn(true);
//!!!			Log.d(TAG, "setScreenOn send msg DISABLE_KEEP_SCREEN_ON delayed by "+totalDelay+" "+systemScreenTimeout);
				mHandler.sendEmptyMessageDelayed(DISABLE_KEEP_SCREEN_ON, totalDelay);
			}
		} else {
//!!!		Log.d(TAG, "setScreenOn off (enabled="+enabled+", extScreenTimeout="+extScreenTimeout+")");
			myWebView.setKeepScreenOn(false);
		}
	}

	static private int deleteRecursive(File fileOrDirectory) {
		if(fileOrDirectory.isDirectory()) {
			for(File child : fileOrDirectory.listFiles()) {
				if(child!=null) {
					deleteRecursive(child);
				}
			}
		}
		fileOrDirectory.delete();
		return 0;
	}

	static private void useSelectedText(final String sharedText) {
		// called by: onNewIntent() (from onStart() or js:onStartUrl()) and by: js:useSelectedString()
		AlertDialog.Builder alertbox = new AlertDialog.Builder(activity);
		String mySharedText = sharedText.replace("\n", " ");
		alertbox.setTitle("Text: '"+mySharedText+"'");
		//alertbox.setMessage("Search Wikipedia results for '"+mySharedText+"'?");
		if(dbg) Log.d(TAG, "useSelectedText setSingleChoiceItems "+textActionID);

		Locale locale;
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
			locale = Resources.getSystem().getConfiguration().getLocales().get(0);
		} else {
			//noinspection deprecation
			locale = Resources.getSystem().getConfiguration().locale;
		}
		String myLocal = locale.toString();
		Log.d(TAG, "useSelectedText locale="+myLocal);

		String[] choices = {"Search Wikipedia",
							"Search DDG", 
							"Translate DpL", 
							"Store Bookmark"};
		alertbox.setSingleChoiceItems(choices, textActionID, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
				// textActionID will be used below in setPositiveButton()
				textActionID = which;
				if(dbg) Log.d(TAG, "useSelectedText setSingleChoiceItems textActionID="+textActionID);
            }
        });
		alertbox.setNegativeButton("Abort", new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
			}
		});
		alertbox.setPositiveButton("OK", new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				if(textActionID==0) {
					if(activity!=null) {
						// search wikipedia
						if(docLang.equals("")) {
							docLang = myLocal.substring(0,2);
						}
						if(docLang.equals("")) {
							docLang = "en";
						}
						String urlStr =
							"https://"+docLang+".wikipedia.org/wiki/Special:Search?search="+mySharedText;
						if(dbg) Log.d(TAG, "useSelectedText wiki url="+urlStr);
						Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(urlStr));
						activity.startActivity(browserIntent);
					} else {
						Log.d(TAG, "# useSelectedText wikipedia activity=null");
					}
				} else if(textActionID==1) {
					if(activity!=null) {
						// search DDG
						String urlStr = "https://duckduckgo.com/html/?q="+mySharedText;
						if(dbg) Log.d(TAG, "useSelectedText ddg url="+urlStr);
						Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(urlStr));
						activity.startActivity(browserIntent);
					} else {
						Log.d(TAG, "# useSelectedText DDG activity=null");
					}
				} else if(textActionID==2) {
					if(activity!=null) {
						// translate via DL
						if(docLang.equals("")) {
							docLang = myLocal.substring(0,2);
						}
						if(docLang.equals("")) {
							docLang = "en";
						}
						String urlStr = "https://www.deepl.com/"+myLocal.substring(0,2)+"/translator#"+ docLang+"/"+myLocal.substring(0,2)+ "/"+mySharedText;
						if(dbg) Log.d(TAG, "useSelectedText deepl url="+urlStr);
						Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(urlStr));
						activity.startActivity(browserIntent);
					} else {
						Log.d(TAG, "# useSelectedText deepl activity=null");
					}
				} else if(textActionID==3) {
					if(myWebView!=null) {
						// store Bookmark
						// encode apostrophe to %26 
						final String encodedSharedText = mySharedText.replace("'", "%26");
						if(dbg) Log.d(TAG,"useSelectedText bookmarkThis(("+encodedSharedText+")");
						try {
							myWebView.evaluateJavascript("bookmarkThis('"+encodedSharedText+"')", null);
						} catch(Exception ex) {
							Log.d(TAG,"# useSelectedText store bookmark ex="+ex);
						}
					}
				}
			}
		});
		alertbox.show();
	}

	static private void clearWebviewCache(WebView webView) {
		if(webView==null) {
			if(dbg) Log.d(TAG, "# clearWebviewCache abort webView==null");
		} else {
			if(dbg) Log.d(TAG, "clearWebviewCache");
			renderstartMS = (new Date()).getTime();	// ???
			webView.clearCache(true);
			webView.clearHistory();

			webView = new WebView(activity);
			webView.clearCache(true);
			webView.clearHistory();
			webView = null;

			if(cachePath==null || cachePath=="") {
				if(dbg) Log.d(TAG, "# clearWebviewCache cachePath not set");
			} else {
				String path = cachePath+"/prose.wasm";
				File file = new File(path);
				if(file!=null && file.exists()) {
					file.delete();
					if(dbg) Log.d(TAG, "clearWebviewCache delete path="+path);
				} else {
					if(dbg) Log.d(TAG, "! clearWebviewCache delete path="+path+" does not exist");
				}
			}

			if(dbg) Log.d(TAG, "clearWebviewCache done");
		}
	}

	private void openUriString(Uri uri, boolean loadDirect) {
		// called by onNewIntent() and JS:loadDocument() (menuShowRecentsClicked(), openBookmark())
		String uriPath = uri.getPath();
		if(uriPath.startsWith("/document/home:")) {
			uriPath = uriPath.substring(15);
		}
		if(uriPath.startsWith("/tree/home:")) {
			uriPath = uriPath.substring(11);
		}
		if(uriPath.startsWith("/")) {
			uriPath = uriPath.substring(1);
		}

		if(dbg) Log.d(TAG, "openUriString scheme="+uri.getScheme()+" authority="+uri.getAuthority()+" uriPath="+uriPath);

			String filename = uriPath;

			Uri uriForChunkData = uri;
			int idxDotEPUB = filename.indexOf(".epub");
			if(idxDotEPUB>=0) {
				boolean hasSubBookAttached = filename.length()>idxDotEPUB+5;
				if(dbg) Log.d(TAG, "openUriString subBookAttached="+hasSubBookAttached+
					" "+filename.length()+" "+(idxDotEPUB+5));
				if(hasSubBookAttached) {
					// uri has a subbookname attached, we must cut it off to load the subbook list
					filename = filename.substring(0,idxDotEPUB+5);
					if(dbg) Log.d(TAG, "openUriString filenameFor:UriForChunkData="+filename);
					Uri.Builder builder = new Uri.Builder();
					builder.scheme(uri.getScheme())
					       .authority(uri.getAuthority())
					       .path(filename);
					uriForChunkData = builder.build();
				} else {
					uriForChunkData = uri;
				}
				if(dbg) Log.d(TAG, "openUriString uriForChunkData="+uriForChunkData);
			}
			int idxDoc = filename.indexOf(":Documents/");
			if(idxDoc>=0) {
				filename = filename.substring(idxDoc+11);
			}

			// encode apostrophes in filenameFinal
			final String filenameFinal = filename.replace("'", "&apos;");
			final Uri uriForChunkDataFinal = uriForChunkData;
			if(dbg) Log.d(TAG, "openUriString filename ("+filenameFinal+")");

			if(textLen<=0 || loadDirect) {
				getChunkDataUri = uriForChunkData; // for getChunkData()
				getChunkDataViaDocumentFile = loadDirect;
				if(dbg) Log.d(TAG, "openUriString getChunkDataUri.getPath(2)="+getChunkDataUri.getPath());

				lastLoadedUri = uri;

				if(!myWebView.post(new Runnable() {
					@Override
					public void run() {
						if(myWebView==null) {
							Log.d(TAG,"# openUriString evalJS but no myWebView");
						} else {
							myWebView.removeCallbacks(this);
							try {
								// encode apostrophes in uriEsc to &apos;
								final String uriPath = uri.getPath();
								final String uriPathEsc = uriPath.replace("'", "&apos;");
								Uri.Builder builder = new Uri.Builder();
								builder.scheme(uri.getScheme())
									   .authority(uri.getAuthority())
									   .path(uriPathEsc);
								final Uri uriEsc = builder.build();

								Log.d(TAG,"openUriString evalJS filenameFinal=("+filenameFinal+") uriEsc=("+uriEsc+")");
								chunkInput = null;
								myWebView.evaluateJavascript("readLocalFile('"+filenameFinal+"','"+uriEsc+"')", null);
							} catch(Exception ex) {
								Log.d(TAG,"# openUriString evalJS readLocalFile() ex="+ex);
							}
						}
					}
				})) {
					Log.d(TAG,"# openUriString post runnable failed");
				}
			} else {
				AlertDialog.Builder alertbox = new AlertDialog.Builder(activity);
				alertbox.setTitle("ProseReader");
				alertbox.setMessage("Load file?\n"+filenameFinal);
				alertbox.setNegativeButton("No", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						// do nothing
					}
				});
				alertbox.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						getChunkDataUri = uriForChunkDataFinal; // for getChunkData()
						getChunkDataViaDocumentFile = loadDirect;
						lastLoadedUri = uri;

						if(!myWebView.post(new Runnable() {
							@Override
							public void run() {
								if(myWebView==null) {
									Log.d(TAG,"# openUriString evalJS but no myWebView");
								} else {
									myWebView.removeCallbacks(this);
									try {
										myWebView.evaluateJavascript(
											"readLocalFile('"+filenameFinal+"','"+uri+"')", null);
									} catch(Exception ex) {
										Log.d(TAG,"# openUriString evalJS readLocalFile() ex="+ex);
									}
								}
							}
						})) {
							Log.d(TAG,"# openUriString post runnable failed");
						}
					}
				});
				alertbox.show();
			}
	}

	private int getScreenOrientation() {
		int	orientation = 0; // landscape (as used by setRequestedOrientation())
		Display display = getWindowManager().getDefaultDisplay();
		if(display.getWidth() < display.getHeight())
			orientation = 1; // portrait
		if(dbg) Log.d(TAG, "getScreenOrientation "+orientation);
		return orientation;
	}


	private void render(Uri uri) {
		if(dbg) Log.d(TAG, "render("+uri+")");
		renderstartMS = (new Date()).getTime();

		try {
			WebSettings webSettings = myWebView.getSettings();
			webSettings.setJavaScriptEnabled(true);
			webSettings.setLightTouchEnabled(true);
			//webSettings.setCacheMode(WebSettings.LOAD_CACHE_ELSE_NETWORK);
			webSettings.setCacheMode(WebSettings.LOAD_NO_CACHE);
			webSettings.setDomStorageEnabled(true); // localstorage
			webSettings.setMediaPlaybackRequiresUserGesture(false);
			webSettings.setTextZoom(100); // do NOT use device/OS user-setting
			//webSettings.setWebContentsDebuggingEnabled(true);

			myWebView.setInitialScale(0); // default 0
//			webSettings.setUseWideViewPort(true);
			webSettings.setSupportZoom(false);
			webSettings.setBuiltInZoomControls(false);
			webSettings.setDisplayZoomControls(false);

			myWebView.setVerticalScrollBarEnabled(true);
			myWebView.setHorizontalScrollBarEnabled(true);
			myWebView.setScrollBarStyle(WebView.SCROLLBARS_INSIDE_OVERLAY);
//			myWebView.setScrollBarStyle(WebView.SCROLLBARS_OUTSIDE_OVERLAY);
			myWebView.setScrollbarFadingEnabled(true);

			userAgentString = webSettings.getUserAgentString();

			myWebView.setWebChromeClient(new WebChromeClient() {
				@Override
				public boolean onConsoleMessage(ConsoleMessage cm) {
					String msg = cm.message();
					if(dbg) Log.d(TAG,"WV "+msg + " L"+cm.lineNumber());
					if(msg.indexOf("wasmLoaded done")>=0) {
						long currentMS = (new Date()).getTime();
						long sinceStartRenderMS = currentMS - renderstartMS;
						if(dbg) Log.d(TAG,"wasmLoaded sinceStartRenderMS="+sinceStartRenderMS);
						return true;
					}
					if(msg.indexOf("runtime: out of memory")>=0) {
						Toast.makeText(activity, "Out of memory", Toast.LENGTH_LONG).show();
						return true;
					}
					return true;
				}

				@Override
				public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback,
						FileChooserParams fileChooserParams) {
					Intent contentSelectionIntent = new Intent(Intent.ACTION_GET_CONTENT);
					String file_type = "application/epub+zip";
					String[] acceptTypeArray = fileChooserParams.getAcceptTypes();
					if(acceptTypeArray!=null && acceptTypeArray.length>0) {
						for(int i=0; i<acceptTypeArray.length; i++) {
							if(i==0) {
								file_type = acceptTypeArray[0];
							} else {
								file_type = file_type+"|"+acceptTypeArray[i];
							}
						}
						if(dbg) Log.d(TAG, "onShowFileChooser "+file_type);
//						contentSelectionIntent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
						contentSelectionIntent.putExtra(Intent.EXTRA_MIME_TYPES, file_type);

						contentSelectionIntent.setType(acceptTypeArray.length == 1 ? acceptTypeArray[0] : "*/*");
						if(acceptTypeArray.length > 0) {
							contentSelectionIntent.putExtra(Intent.EXTRA_MIME_TYPES, acceptTypeArray);
						}

						if(dbg) Log.d(TAG, "onShowFileChooser");
					}
					myFilePathCallback = filePathCallback;

					contentSelectionIntent.addCategory(Intent.CATEGORY_OPENABLE);
					contentSelectionIntent.setType(file_type);

					Intent chooserIntent = new Intent(Intent.ACTION_CHOOSER);
					chooserIntent.putExtra(Intent.EXTRA_INTENT, contentSelectionIntent);
					chooserIntent.putExtra(Intent.EXTRA_TITLE, "EPUB File chooser");
					startActivityForResult(chooserIntent, FILE_REQ_CODE);
					return true;
				}

				@Override
				public void onProgressChanged(WebView view, int progress) {
					if(dbg) Log.d(TAG, "onProgressChanged progress="+progress);
				}
			});

			myWebView.setWebViewClient(new WebViewClient() {
				/*
				public void onDownloadStart(String url, String userAgent, String contentDisposition,
											String mimetype, long contentLength) {
					Log.i(TAG, "onDownloadStart url=" + url);
					Log.i(TAG, "onDownloadStart len=" + contentLength);
				}
				*/

				@SuppressWarnings("deprecation")
				@Override
				public boolean shouldOverrideUrlLoading(WebView view, String url) {
					final Uri uri = Uri.parse(url);
					boolean override = handleUri(uri);
					/*
					view.setDownloadListener(new DownloadListener() {
						@Override
						public void onDownloadStart(String url, String userAgent, String contentDisposition,
													String mimeType, long contentLength) {
							if(dbg) Log.d(TAG, "onDownloadStart url="+url+" mime="+mimeType+" len="+contentLength);
						}
					});
					*/
					return override;
				}

				//@TargetApi(Build.VERSION_CODES.LOLLIPOP)
				@Override
				public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
					final Uri uri = request.getUrl();
					boolean override = handleUri(uri);
					/*
					view.setDownloadListener(new DownloadListener() {
						@Override
						public void onDownloadStart(String url, String userAgent, String contentDisposition,
													String mimeType, long contentLength) {
							if(dbg) Log.d(TAG, "onDownloadStart url="+url+" mime="+mimeType+" len="+contentLength);
							DownloadManager.Request request = new
									DownloadManager.Request(Uri.parse(url));

							request.setMimeType(mimeType);
							//------------------------COOKIE!!------------------------
							String cookies = CookieManager.getInstance().getCookie(url);
							request.addRequestHeader("cookie", cookies);
							//------------------------COOKIE!!------------------------
							request.addRequestHeader("User-Agent", userAgent);
							request.setDescription("Downloaded from <ANY NAME>");
							request.setTitle(URLUtil.guessFileName(url, contentDisposition, mimeType));
							request.allowScanningByMediaScanner();

							request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED);
							request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, URLUtil.guessFileName(url, contentDisposition, mimeType));
							DownloadManager dm = (DownloadManager) context.getSystemService(DOWNLOAD_SERVICE);

							dm.enqueue(request);

							Toast.makeText(context.getApplicationContext(), "Downloading File", Toast.LENGTH_LONG).show();
						}
					});
*/
					return override;
				}

				private boolean handleUri(final Uri uri) {
					final String path = uri.getPath();

					boolean apkHandleUri = true; // apk will handle this, not the webview
					if((uri.getHost().equals("timur.mobi") || uri.getHost().startsWith("192.168.")) &&
							path.startsWith("/prose")) {
						apkHandleUri = false; // let myWebView handle this
						if(path.endsWith("/")) {
							renderstartMS = (new Date()).getTime();
						}
					}
					if(path.indexOf("/doc")>0) {
						apkHandleUri = true; // DO NOT let myWebView handle this
					}
					if(path.equals("/favicon.ico")) {
						apkHandleUri = false; // let myWebView handle this
					}
					if(dbg) Log.d(TAG, "handleUri path="+path+" apkHandleUri="+apkHandleUri);

					if(apkHandleUri) {
						Intent browserIntent = new Intent(Intent.ACTION_VIEW, uri);
						try {
							startActivity(browserIntent);
						} catch(Exception ex) {
							Toast.makeText(activity, "Error: browserIntent "+ex, Toast.LENGTH_LONG).show();
							ex.printStackTrace();
						}
					}

					return apkHandleUri;
				}

				@SuppressWarnings("deprecation")
				@Override
				public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
					if(errorCode==ERROR_HOST_LOOKUP) {
						Log.d(TAG, "# onReceivedError HOST_LOOKUP "+description+" "+failingUrl);
						Toast.makeText(activity, "HOST LOOKUP err "+failingUrl+" "+description, Toast.LENGTH_LONG).show();
						super.onReceivedError(view, errorCode, description, failingUrl);
					} else if(errorCode==ERROR_UNKNOWN) {
						Log.d(TAG, "! onReceivedError ERROR_UNKNOWN "+description+" "+failingUrl);
						//Toast.makeText(activity, "Unknown error "+failingUrl+" "+description, Toast.LENGTH_LONG).show();
						//not calling super.onReceivedError()
					} else {
						Log.d(TAG, "# onReceivedError "+errorCode+" "+description+" "+failingUrl);
						Toast.makeText(activity, "Network error code="+errorCode+" url="+failingUrl,
							Toast.LENGTH_LONG).show();
						super.onReceivedError(view, errorCode, description, failingUrl);
					}
				}

				//@TargetApi(android.os.Build.VERSION_CODES.M)
				@Override
				public void onReceivedError(WebView view, WebResourceRequest req, WebResourceError err) {
					super.onReceivedError(view, req, err);
					onReceivedError(view, err.getErrorCode(), err.getDescription().toString(),
						req.getUrl().toString());
				}

				@Override
				public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
					Log.d(TAG, "# onReceivedSslError "+error);
					super.onReceivedSslError(view, handler, error);
				}


				//@TargetApi(Build.VERSION_CODES.LOLLIPOP)
				@Override
				public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest wvRequest) {
					final Uri wvRequestUri = wvRequest.getUrl();
					String path = wvRequestUri.getPath();
					String host = wvRequestUri.getHost();
					if(dbg) Log.d(TAG, "shouldInterceptRequest host='"+host+"' path='"+path+"'");
					if(path.equals("/favicon.ico")) {
						path = "favicon.ico";
					} else if(path.startsWith("/prose")) {
						int idx2ndSlash = path.substring(1).indexOf("/");
						if(idx2ndSlash<0) {
							Log.d(TAG, "# shouldInterceptRequest path='"+path+"' has no 2nd /");
							return null;
						}
						if(dbg) Log.d(TAG, "shouldInterceptRequest path='"+path+"' idx2ndSlash="+idx2ndSlash);
						path = path.substring(idx2ndSlash+2);
						if(path.equals("")) {
							path="index.html";
						}
					}
					if(dbg) Log.d(TAG, "shouldInterceptRequest work path='"+path+"'");

					InputStream is = null;
/*
					if(path.startsWith("/system/fonts/")) {
						try {
							is = new FileInputStream(new File(path));
						} catch(Exception ex) {
							Log.d(TAG, "# shouldInterceptRequest path='"+path+"' FileInputStream() ex="+ex);
							is = null;
						}
					} else 
*/
					if(path.startsWith("/font/")) {
						String fontFolderPath = getFilesDir().getPath()+"/font";
						File folder = new File(fontFolderPath);
						if(!folder.exists()) {
							Log.d(TAG,"# shouldInterceptRequest fontFolderPath does not exist: "+fontFolderPath);
							return null;
						}
						Log.d(TAG,"shouldInterceptRequest open font "+fontFolderPath+" | "+path.substring(6));
						try {
							is = new FileInputStream(new File(folder, path.substring(6)));
						} catch(Exception ex) {
							Log.d(TAG, "! shouldInterceptRequest path='"+path+"' createInputStream() ex="+ex);
							return null;
						}

					} else {
						AssetFileDescriptor fileDescriptor = null;
						try {
							fileDescriptor = getAssets().openFd(path);
						} catch(Exception ex) {
							Log.d(TAG, "# shouldInterceptRequest path='"+path+"' getAssets().openFd() ex="+ex);
							return null;
						}
						if(fileDescriptor==null) {
							Log.d(TAG, "# shouldInterceptRequest path='"+path+"' fileDescriptor==null");
							return null;
						}

						long contentLength = fileDescriptor.getLength();
						if(dbg) Log.d(TAG, "shouldInterceptRequest path='"+path+"' fileLen="+contentLength);

						try {
							is = fileDescriptor.createInputStream();
						} catch(Exception ex) {
							Log.d(TAG, "# shouldInterceptRequest path='"+path+"' createInputStream() ex="+ex);
							return null;
						}
					}
					if(is==null) {
						Log.d(TAG, "# shouldInterceptRequest path='"+path+"' is==null");
						return null;
					}

					String mime = "";
					String encoding = null;
					if(path.endsWith(".svg")) {
						mime = "image/svg+xml";
						encoding = "utf-8";
					} else if(path.endsWith(".html")) {
						mime = "text/html";
						encoding = "utf-8";
					} else if(path.endsWith(".css")) {
						mime = "text/css";
						encoding = "utf-8";
					} else if(path.endsWith(".ico")) {
						mime = "image/x-icon";
					} else if(path.endsWith(".js")) {
						mime = "application/javascript";
						encoding = "utf-8";
					} else if(path.endsWith(".ttf")) {
						mime = "font/ttf";
					} else if(path.endsWith(".woff")) {
						mime = "font/woff";
					} else if(path.endsWith(".woff2")) {
						mime = "font/woff2";
					} else if(path.endsWith(".properties")) {
						mime = "text/plain";
						encoding = "utf-8";
					} else if(path.endsWith(".wasm")) {
						mime = "application/wasm";
						//encoding = "gzip";
					}
					if(dbg) Log.d(TAG, "shouldInterceptRequest path='"+path+"' mime="+mime+" encoding="+encoding);

					int status = 200;
					String statusMsg = "OK";
					WebResourceResponse response = new WebResourceResponse(mime, encoding, is);
					if(response==null) {
						Log.d(TAG, "# shouldInterceptRequest path='"+path+"' response==null");
					} else {
						Log.d(TAG, "shouldInterceptRequest path='"+path+"' status="+status+" statusMsg="+statusMsg);
						//response.setStatusCodeAndReasonPhrase(status,statusMsg);
					}
					return response;
				}
			});

			myWebView.addJavascriptInterface(proseJSInterface, "Android");
			String urlString = uri.toString();
			int idxArgs = urlString.indexOf("?");
			if(idxArgs>=0) {
				urlString = urlString.substring(0,idxArgs);
			}
			if(dbg) Log.d(TAG, "render loadUrl(urlString="+urlString+")");
//			final Handler handler = new Handler(Looper.getMainLooper());
			final Uri finalUrl = uri;
			handler.postDelayed(new Runnable() {
				@Override
				public void run() {
					if(myWebView==null) {
						if(dbg) Log.e(TAG, "# render load myWebView==null "+finalUrl.toString());
					} else {
						if(dbg) Log.d(TAG, "render load "+finalUrl.toString());
						myWebView.loadUrl(finalUrl.toString());

						handler.postDelayed(new Runnable() {
							@Override
							public void run() {
								if(myWebView!=null) {
									myWebView.setFocusable(true);
								}
							}
						}, 700);
					}
				}
			}, 200);
		} catch(Exception ex) {
			Log.d(TAG, "# render myWebView ex="+ex);
		}
	}

	@SuppressWarnings({"unchecked", "JavaReflectionInvocation"})
	private PackageInfo getCurrentWebViewPackageInfo() {
		PackageInfo pInfo = null;
		if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
			if(dbg) Log.d(TAG, "getCurrentWebViewPackageInfo for O+");
			pInfo = WebView.getCurrentWebViewPackage();
		} else {
			try {
				if(dbg) Log.d(TAG, "getCurrentWebViewPackageInfo for M+");
				Class webViewFactory = Class.forName("android.webkit.WebViewFactory");
				Method method = webViewFactory.getMethod("getLoadedPackageInfo");
				pInfo = (PackageInfo)method.invoke(null);
			} catch(Exception e) {
				//Log.d(TAG, "getCurrentWebViewPackageInfo for M+ ex="+e);
			}
			if(pInfo==null) {
				try {
					if(dbg) Log.d(TAG, "getCurrentWebViewPackageInfo for M+ (2)");
					Class webViewFactory = Class.forName("com.google.android.webview.WebViewFactory");
					Method method = webViewFactory.getMethod("getLoadedPackageInfo");
					pInfo = (PackageInfo) method.invoke(null);
				} catch(Exception e2) {
					//Log.d(TAG, "getCurrentWebViewPackageInfo for M+ (2) ex="+e2);
				}
			}
			if(pInfo==null) {
				try {
					if(dbg) Log.d(TAG, "getCurrentWebViewPackageInfo for M+ (3)");
					Class webViewFactory = Class.forName("com.android.webview.WebViewFactory");
					Method method = webViewFactory.getMethod("getLoadedPackageInfo");
					pInfo = (PackageInfo)method.invoke(null);
				} catch(Exception e2) {
					//Log.d(TAG, "getCurrentWebViewPackageInfo for M+ (3) ex="+e2);
				}
			}
		}
		if(pInfo!=null) {
			if(dbg) Log.d(TAG, "getCurrentWebViewPackageInfo pInfo set");
		}
		return pInfo;
	}

	private String getWebviewVersion() {
		String webviewVersionString = "";
		PackageInfo webviewPackageInfo = getCurrentWebViewPackageInfo();
		if(webviewPackageInfo != null) {
			webviewVersionString = webviewPackageInfo.versionName;
		}
		return webviewVersionString;
	}

/*
	static public class IntentReceiver extends BroadcastReceiver {
		static final String TAG = "ProseIntentReceiver";

		@Override
		public void onReceive(Context context, Intent intent) {
			if(activity==null) {
				Log.d(TAG, "# no activity context");
				return;
			}
			if(acceptRemoteIntents==false) {
				Log.d(TAG, "acceptRemoteIntents is false");
				return;
			}
			Log.d(TAG, "activity context is set");

			try {
				String cmd = intent.getStringExtra("msg");
				if(cmd.equals("dbg=true")) {
					Log.d(TAG, "dbg set true");
					dbg=true;
					if(myWebView==null) {
						Log.d(TAG, "# dbg=true myWebView==null");
					} else {
						try {
							myWebView.evaluateJavascript("setDbg("+dbg+")", null);
						} catch(Exception ex) {
							Log.d(TAG,"# dbg=true evalJS ex="+ex);
						}
					}
				} else if(cmd.equals("dbg=false")) {
					Log.d(TAG, "dbg set false");
					dbg=false;
					if(myWebView==null) {
						Log.d(TAG, "# dbg=false myWebView==null");
					} else {
						try {
							myWebView.evaluateJavascript("setDbg("+dbg+")", null);
						} catch(Exception ex) {
							Log.d(TAG,"# dbg=false evalJS ex="+ex);
						}
					}
				} else if(cmd.equals("page=back")) {
					if(myWebView==null) {
						Log.d(TAG, "# page=back myWebView==null");
					} else {
						try {
							Log.d(TAG, "page=back -> js:touchLeft()");
							myWebView.evaluateJavascript("touchLeft()", null);
						} catch(Exception ex) {
							Log.d(TAG,"# page=back evalJS ex="+ex);
						}
					}
				} else if(cmd.equals("page=fw")) {
					Log.d(TAG, "page=fw");
					if(myWebView==null) {
						Log.d(TAG, "# page=fw myWebView==null");
					} else {
						try {
							Log.d(TAG, "page=fw -> js:touchRight()");
							myWebView.evaluateJavascript("touchRight()", null);
						} catch(Exception ex) {
							Log.d(TAG,"# page=fw evalJS ex="+ex);
						}
					}
/ *
				} else if(cmd.equals("clearWebviewCache")) {
					Log.d(TAG, "clearWebviewCache");
					clearWebviewCache(myWebView);

				} else if(cmd.equals("resetdocumentTree")) {
					if(prefs==null) {
						Log.d(TAG, "# resetdocumentTree prefs==null");
					} else {
						Log.d(TAG, "resetdocumentTree");
						SharedPreferences.Editor prefed = prefs.edit();
						prefed.putString("documentTreeString", "");
						prefed.apply();
						documentTreeUri = null;
						if(myWebView==null) {
							Log.d(TAG, "# resetdocumentTree myWebView==null");
						} else {
							try {
								myWebView.evaluateJavascript("enableRecentsButton()", null);
							} catch(Exception ex) {
								Log.d(TAG,"# resetdocumentTree evalJS ex="+ex);
							}
						}
					}
* /
				} else {
					Log.d(TAG, "# unknown cmd: "+cmd);
				}
			} catch(Exception ex) {
				Log.d(TAG, "ex:"+ex.toString());
			}
		}
	}
*/
}

