// Copyright (c) 2018, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
//
// VMOptions=--async-debugger --verbose-debug

import 'dart:developer';
import 'package:test/test.dart';
import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/awaiter_async_stack_contents_2_test.dart
//
const LINE_0 = 35;
const LINE_A = 36;
const LINE_B = 42;
const LINE_C = 46;
// AUTOGENERATED END

Future<void> notCalled() async {
  await null;
  await null;
  await null;
  await null;
}

Future<void> foobar() async {
  await null;
  debugger(); // LINE_0.
  print('foobar'); // LINE_A.
}

Future<void> helper() async {
  await null;
  print('helper');
  await foobar(); // LINE_B.
}

Future<void> testMain() async {
  await helper(); // LINE_C.
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_0),
  stepOver,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  (VmService service, IsolateRef isolate) async {
    final isolateId = isolate.id!;
    // Verify awaiter stack trace is the current frame + the awaiter.
    final Stack stack = await service.getStack(isolateId);
    expect(stack.asyncCausalFrames, isNotNull);
    final List<Frame> asyncCausalFrames = stack.asyncCausalFrames!;
    expect(asyncCausalFrames.length, greaterThanOrEqualTo(4));
    expect(asyncCausalFrames[0].function!.name, 'foobar');
    expect(asyncCausalFrames[1].kind, FrameKind.kAsyncSuspensionMarker);
    expect(asyncCausalFrames[2].function!.name, 'helper');
    expect(asyncCausalFrames[3].kind, FrameKind.kAsyncSuspensionMarker);
  },
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'awaiter_async_stack_contents_2_test.dart',
      testeeConcurrent: testMain,
      extraArgs: extraDebuggingArgs,
    );
