/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'package:test/expect.dart';
import 'package:test/scaffolding.dart';
import 'package:zxing_lib/client.dart';
import 'package:zxing_lib/zxing.dart';

/// Tests [TelParsedResult].
///
void main() {
  void doTest(String contents, String number, String? title) {
    final fakeResult = Result(contents, null, null, BarcodeFormat.qrCode);
    final result = ResultParser.parseResult(fakeResult);
    expect(ParsedResultType.tel, result.type);
    final telResult = result as TelParsedResult;
    expect(number, telResult.number);
    expect(title, telResult.title);
    expect('tel:$number', telResult.telURI);
  }

  test('testTel', () {
    doTest('tel:+15551212', '+15551212', null);
    doTest('tel:2125551212', '2125551212', null);
  });
}
