/// Locale names of Chinese
const names = {
  "001": "世界",
  "002": "非洲",
  "003": "北美洲",
  "005": "南美洲",
  "009": "大洋洲",
  "011": "西非",
  "013": "中美洲",
  "014": "东非",
  "015": "北非",
  "017": "中非",
  "018": "南部非洲",
  "019": "美洲",
  "021": "美洲北部",
  "029": "加勒比地区",
  "030": "东亚",
  "034": "南亚",
  "035": "东南亚",
  "039": "南欧",
  "053": "大洋洲",
  "054": "美拉尼西亚",
  "057": "密克罗尼西亚地区",
  "061": "玻利尼西亚",
  "062": "中南亚",
  "142": "亚洲",
  "143": "中亚",
  "145": "西亚",
  "150": "欧洲",
  "151": "东欧",
  "154": "北欧",
  "155": "西欧",
  "172": "独立国家联合体",
  "200": "捷克斯洛伐克",
  "202": "撒哈拉以南非洲",
  "419": "拉丁美洲",
  "830": "海峡群岛",
  "AC": "阿森松岛",
  "AD": "安道尔",
  "AE": "阿拉伯联合酋长国",
  "AF": "阿富汗",
  "AG": "安提瓜和巴布达",
  "AI": "安圭拉",
  "AL": "阿尔巴尼亚",
  "AM": "亚美尼亚",
  "AN": "荷属安的列斯群岛",
  "AO": "安哥拉",
  "AQ": "南极洲",
  "AR": "阿根廷",
  "AS": "美属萨摩亚",
  "AT": "奥地利",
  "AU": "澳大利亚",
  "AW": "阿鲁巴",
  "AX": "奥兰群岛",
  "AZ": "阿塞拜疆",
  "Adlm": "阿德拉姆文",
  "Afak": "阿法卡文",
  "Aghb": "高加索阿尔巴尼亚文",
  "Ahom": "阿洪姆文",
  "Arab": "阿拉伯文",
  "Aran": "波斯体",
  "Armi": "皇室亚拉姆文",
  "Armn": "亚美尼亚文",
  "Avst": "阿维斯陀文",
  "BA": "波斯尼亚和黑塞哥维那",
  "BB": "巴巴多斯",
  "BD": "孟加拉国",
  "BE": "比利时",
  "BF": "布基纳法索",
  "BG": "保加利亚",
  "BH": "巴林",
  "BI": "布隆迪",
  "BJ": "贝宁",
  "BL": "圣巴泰勒米",
  "BM": "百慕大",
  "BN": "文莱",
  "BO": "玻利维亚",
  "BQ": "荷属加勒比区",
  "BR": "巴西",
  "BS": "巴哈马",
  "BT": "不丹",
  "BV": "布韦岛",
  "BW": "博茨瓦纳",
  "BY": "白俄罗斯",
  "BZ": "伯利兹",
  "Bali": "巴厘文",
  "Bamu": "巴姆穆文",
  "Bass": "巴萨文",
  "Batk": "巴塔克文",
  "Beng": "孟加拉文",
  "Bhks": "拜克舒克文",
  "Blis": "布列斯符号",
  "Bopo": "汉语拼音",
  "Brah": "婆罗米文字",
  "Brai": "盲文",
  "Bugi": "布吉文",
  "Buhd": "布希德文",
  "CA": "加拿大",
  "CC": "科科斯（基林）群岛",
  "CD": "刚果民主共和国",
  "CF": "中非共和国",
  "CG": "刚果共和国",
  "CH": "瑞士",
  "CI": "科特迪瓦",
  "CK": "库克群岛",
  "CL": "智利",
  "CM": "喀麦隆",
  "CN": "中国",
  "CO": "哥伦比亚",
  "CP": "克利珀顿岛",
  "CR": "哥斯达黎加",
  "CS": "塞尔维亚和黑山",
  "CU": "古巴",
  "CV": "佛得角",
  "CW": "库拉索",
  "CX": "圣诞岛",
  "CY": "塞浦路斯",
  "CZ": "捷克",
  "Cakm": "查克马文",
  "Cans": "加拿大土著统一音节",
  "Cari": "卡里亚文",
  "Cham": "占文",
  "Cher": "切罗基文",
  "Chrs": "花拉子模文",
  "Cirt": "色斯文",
  "Copt": "克普特文",
  "Cprt": "塞浦路斯文",
  "Cyrl": "西里尔文",
  "Cyrs": "西里尔文字（古教会斯拉夫文的变体）",
  "DD": "东德",
  "DE": "德国",
  "DG": "迪戈加西亚岛",
  "DJ": "吉布提",
  "DK": "丹麦",
  "DM": "多米尼克",
  "DO": "多米尼加共和国",
  "DZ": "阿尔及利亚",
  "Deva": "天城文",
  "Diak": "迪维西阿库鲁文",
  "Dogr": "多格拉文",
  "Dsrt": "德塞莱特文",
  "Dupl": "杜普洛伊速记",
  "EA": "休达及梅利利亚",
  "EC": "厄瓜多尔",
  "EE": "爱沙尼亚",
  "EG": "埃及",
  "EH": "西撒哈拉",
  "ER": "厄立特里亚",
  "ES": "西班牙",
  "ET": "埃塞俄比亚",
  "EU": "欧盟",
  "EZ": "欧元区",
  "Egyd": "后期埃及文",
  "Egyh": "古埃及僧侣书写体",
  "Egyp": "古埃及象形文",
  "Elba": "爱尔巴桑文",
  "Elym": "埃利迈文",
  "Ethi": "埃塞俄比亚文",
  "FI": "芬兰",
  "FJ": "斐济",
  "FK": "福克兰群岛",
  "FM": "密克罗尼西亚联邦",
  "FO": "法罗群岛",
  "FR": "法国",
  "FX": "法国本土",
  "GA": "加蓬",
  "GB": "英国",
  "GD": "格林纳达",
  "GE": "格鲁吉亚",
  "GF": "法属圭亚那",
  "GG": "根西岛",
  "GH": "加纳",
  "GI": "直布罗陀",
  "GL": "格陵兰",
  "GM": "冈比亚",
  "GN": "几内亚",
  "GP": "瓜德罗普",
  "GQ": "赤道几内亚",
  "GR": "希腊",
  "GS": "南乔治亚和南桑威奇群岛",
  "GT": "危地马拉",
  "GU": "关岛",
  "GW": "几内亚比绍",
  "GY": "圭亚那",
  "Geok": "格鲁吉亚文（教堂体）",
  "Geor": "格鲁吉亚文",
  "Glag": "格拉哥里文",
  "Gong": "贡贾拉贡德文",
  "Gonm": "马萨拉姆冈德文",
  "Goth": "哥特文",
  "Gran": "格兰塔文",
  "Grek": "希腊文",
  "Gujr": "古吉拉特文",
  "Guru": "果鲁穆奇文",
  "HK": "中国香港特别行政区",
  "HM": "赫德岛和麦克唐纳群岛",
  "HN": "洪都拉斯",
  "HR": "克罗地亚",
  "HT": "海地",
  "HU": "匈牙利",
  "Hanb": "汉语注音",
  "Hang": "谚文",
  "Hani": "汉字",
  "Hano": "汉奴罗文",
  "Hans": "简体",
  "Hant": "繁体",
  "Hatr": "哈特兰文",
  "Hebr": "希伯来文",
  "Hira": "平假名",
  "Hluw": "安那托利亚象形文字",
  "Hmng": "杨松录苗文",
  "Hmnp": "尼亚肯蒲丘苗文",
  "Hrkt": "假名",
  "Hung": "古匈牙利文",
  "IC": "加纳利群岛",
  "ID": "印度尼西亚",
  "IE": "爱尔兰",
  "IL": "以色列",
  "IM": "马恩岛",
  "IN": "印度",
  "IO": "英属印度洋领地",
  "IQ": "伊拉克",
  "IR": "伊朗",
  "IS": "冰岛",
  "IT": "意大利",
  "Inds": "印度河文字",
  "Ital": "古意大利文",
  "JE": "泽西岛",
  "JM": "牙买加",
  "JO": "约旦",
  "JP": "日本",
  "Jamo": "韩文字母",
  "Java": "爪哇文",
  "Jpan": "日文",
  "Jurc": "女真文",
  "KE": "肯尼亚",
  "KG": "吉尔吉斯斯坦",
  "KH": "柬埔寨",
  "KI": "基里巴斯",
  "KM": "科摩罗",
  "KN": "圣基茨和尼维斯",
  "KP": "朝鲜",
  "KR": "韩国",
  "KW": "科威特",
  "KY": "开曼群岛",
  "KZ": "哈萨克斯坦",
  "Kali": "克耶李文字",
  "Kana": "片假名",
  "Khar": "卡罗须提文",
  "Khmr": "高棉文",
  "Khoj": "克吉奇文字",
  "Kits": "契丹小字",
  "Knda": "卡纳达文",
  "Kore": "韩文",
  "Kpel": "克佩列文",
  "Kthi": "凯提文",
  "LA": "老挝",
  "LB": "黎巴嫩",
  "LC": "圣卢西亚",
  "LI": "列支敦士登",
  "LK": "斯里兰卡",
  "LR": "利比里亚",
  "LS": "莱索托",
  "LT": "立陶宛",
  "LU": "卢森堡",
  "LV": "拉脱维亚",
  "LY": "利比亚",
  "Lana": "兰拿文",
  "Laoo": "老挝文",
  "Latf": "拉丁文（哥特式字体变体）",
  "Latg": "拉丁文（盖尔文变体）",
  "Latn": "拉丁文",
  "Lepc": "雷布查文",
  "Limb": "林布文",
  "Lina": "线形文字（A）",
  "Linb": "线形文字（B）",
  "Lisu": "傈僳文",
  "Loma": "洛马文",
  "Lyci": "利西亚文",
  "Lydi": "吕底亚文",
  "MA": "摩洛哥",
  "MC": "摩纳哥",
  "MD": "摩尔多瓦",
  "ME": "黑山",
  "MF": "法属圣马丁",
  "MG": "马达加斯加",
  "MH": "马绍尔群岛",
  "MI": "中途岛",
  "MK": "北马其顿",
  "ML": "马里",
  "MM": "缅甸",
  "MN": "蒙古",
  "MO": "中国澳门特别行政区",
  "MP": "北马里亚纳群岛",
  "MQ": "马提尼克",
  "MR": "毛里塔尼亚",
  "MS": "蒙特塞拉特",
  "MT": "马耳他",
  "MU": "毛里求斯",
  "MV": "马尔代夫",
  "MW": "马拉维",
  "MX": "墨西哥",
  "MY": "马来西亚",
  "MZ": "莫桑比克",
  "Mahj": "默哈金文",
  "Maka": "望加锡文",
  "Mand": "阿拉米文",
  "Mani": "摩尼教文",
  "Marc": "大玛尔文",
  "Maya": "玛雅圣符文",
  "Medf": "梅德法伊德林文",
  "Mend": "门迪文",
  "Merc": "麦罗埃草书",
  "Mero": "麦若提克文",
  "Mlym": "马拉雅拉姆文",
  "Modi": "莫迪文",
  "Mong": "蒙古文",
  "Moon": "韩文语系",
  "Mroo": "谬文",
  "Mtei": "曼尼普尔文",
  "Mult": "穆尔坦文",
  "Mymr": "缅甸文",
  "NA": "纳米比亚",
  "NC": "新喀里多尼亚",
  "NE": "尼日尔",
  "NF": "诺福克岛",
  "NG": "尼日利亚",
  "NI": "尼加拉瓜",
  "NL": "荷兰",
  "NO": "挪威",
  "NP": "尼泊尔",
  "NR": "瑙鲁",
  "NT": "中立区",
  "NU": "纽埃",
  "NZ": "新西兰",
  "Nand": "楠迪梵文",
  "Narb": "古北方阿拉伯文",
  "Nbat": "纳巴泰文",
  "Newa": "尼瓦文",
  "Nkgb": "纳西格巴文",
  "Nkoo": "西非书面文字（N’Ko）",
  "Nshu": "女书",
  "OM": "阿曼",
  "Ogam": "欧甘文",
  "Olck": "桑塔利文",
  "Orkh": "鄂尔浑文",
  "Orya": "奥里亚文",
  "Osge": "欧塞奇文",
  "Osma": "奥斯曼亚文",
  "PA": "巴拿马",
  "PC": "太平洋群岛托管地",
  "PE": "秘鲁",
  "PF": "法属波利尼西亚",
  "PG": "巴布亚新几内亚",
  "PH": "菲律宾",
  "PK": "巴基斯坦",
  "PL": "波兰",
  "PM": "圣皮埃尔和密克隆",
  "PN": "皮特凯恩群岛",
  "PR": "波多黎各",
  "PS": "巴勒斯坦领土",
  "PT": "葡萄牙",
  "PU": "美国其他太平洋岛屿",
  "PW": "帕劳",
  "PY": "巴拉圭",
  "PZ": "巴拿马运河区",
  "Palm": "帕尔迈拉文",
  "Pauc": "包金豪文",
  "Perm": "古彼尔姆文",
  "Phag": "八思巴文",
  "Phli": "巴列维文碑铭体",
  "Phlp": "巴列维文（圣诗体）",
  "Phlv": "巴列维文（书体）",
  "Phnx": "腓尼基文",
  "Plrd": "波拉德音标文字",
  "Prti": "帕提亚文碑铭体",
  "QA": "卡塔尔",
  "QO": "大洋洲边远群岛",
  "Qaag": "佐基文",
  "RE": "留尼汪",
  "RO": "罗马尼亚",
  "RS": "塞尔维亚",
  "RU": "俄罗斯",
  "RW": "卢旺达",
  "Rjng": "拉让文",
  "Rohg": "哈乃斐罗兴亚文",
  "Roro": "朗格朗格文",
  "Runr": "古代北欧文",
  "SA": "沙特阿拉伯",
  "SB": "所罗门群岛",
  "SC": "塞舌尔",
  "SD": "苏丹",
  "SE": "瑞典",
  "SG": "新加坡",
  "SH": "圣赫勒拿",
  "SI": "斯洛文尼亚",
  "SJ": "斯瓦尔巴和扬马延",
  "SK": "斯洛伐克",
  "SL": "塞拉利昂",
  "SM": "圣马力诺",
  "SN": "塞内加尔",
  "SO": "索马里",
  "SR": "苏里南",
  "SS": "南苏丹",
  "ST": "圣多美和普林西比",
  "SU": "苏维埃社会主义共和国联盟",
  "SV": "萨尔瓦多",
  "SX": "荷属圣马丁",
  "SY": "叙利亚",
  "SZ": "斯威士兰",
  "Samr": "撒马利亚文",
  "Sara": "沙拉堤文",
  "Sarb": "古南阿拉伯文",
  "Saur": "索拉什特拉文",
  "Sgnw": "书写符号",
  "Shaw": "萧伯纳式文",
  "Shrd": "夏拉达文",
  "Sidd": "悉昙",
  "Sind": "信德文",
  "Sinh": "僧伽罗文",
  "Sogd": "粟特文",
  "Sogo": "古粟特文",
  "Sora": "索朗桑朋文",
  "Soyo": "索永布文",
  "Sund": "巽他文",
  "Sylo": "锡尔赫特文",
  "Syrc": "叙利亚文",
  "Syre": "福音体叙利亚文",
  "Syrj": "西叙利亚文",
  "Syrn": "东叙利亚文",
  "TA": "特里斯坦-达库尼亚群岛",
  "TC": "特克斯和凯科斯群岛",
  "TD": "乍得",
  "TF": "法属南部领地",
  "TG": "多哥",
  "TH": "泰国",
  "TJ": "塔吉克斯坦",
  "TK": "托克劳",
  "TL": "东帝汶",
  "TM": "土库曼斯坦",
  "TN": "突尼斯",
  "TO": "汤加",
  "TR": "土耳其",
  "TT": "特立尼达和多巴哥",
  "TV": "图瓦卢",
  "TW": "台湾",
  "TZ": "坦桑尼亚",
  "Tagb": "塔格班瓦文",
  "Takr": "泰克里文",
  "Tale": "泰乐文",
  "Talu": "新傣文",
  "Taml": "泰米尔文",
  "Tang": "唐古特文",
  "Tavt": "越南傣文",
  "Telu": "泰卢固文",
  "Teng": "腾格瓦文字",
  "Tfng": "提非纳文",
  "Tglg": "塔加路文",
  "Thaa": "塔安那文",
  "Thai": "泰文",
  "Tibt": "藏文",
  "Tirh": "迈蒂利文",
  "UA": "乌克兰",
  "UG": "乌干达",
  "UM": "美国本土外小岛屿",
  "UN": "联合国",
  "US": "美国",
  "UY": "乌拉圭",
  "UZ": "乌兹别克斯坦",
  "Ugar": "乌加里特文",
  "VA": "梵蒂冈",
  "VC": "圣文森特和格林纳丁斯",
  "VD": "北越",
  "VE": "委内瑞拉",
  "VG": "英属维尔京群岛",
  "VI": "美属维尔京群岛",
  "VN": "越南",
  "VU": "瓦努阿图",
  "Vaii": "瓦依文",
  "Visp": "可见语言",
  "WF": "瓦利斯和富图纳",
  "WK": "威克岛",
  "WS": "萨摩亚",
  "Wara": "瓦郎奇蒂文字",
  "Wcho": "万秋文",
  "Wole": "沃莱艾文",
  "XA": "伪地区",
  "XB": "伪双向语言地区",
  "XK": "科索沃",
  "Xpeo": "古波斯文",
  "Xsux": "苏美尔-阿卡德楔形文字",
  "YD": "也门人民民主共和国",
  "YE": "也门",
  "YT": "马约特",
  "Yezi": "雅兹迪文",
  "Yiii": "彝文",
  "ZA": "南非",
  "ZM": "赞比亚",
  "ZW": "津巴布韦",
  "ZZ": "未知地区",
  "Zanb": "札那巴札尔方块文字",
  "Zinh": "遗传学术语",
  "Zmth": "数学符号",
  "Zsye": "表情符号",
  "Zsym": "符号",
  "Zxxx": "非书面文字",
  "Zyyy": "通用",
  "Zzzz": "未知文字",
  "aa": "阿法尔语",
  "ab": "阿布哈西亚语",
  "ace": "亚齐语",
  "ach": "阿乔利语",
  "ada": "阿当梅语",
  "ady": "阿迪格语",
  "ae": "阿维斯塔语",
  "aeb": "突尼斯阿拉伯语",
  "af": "南非荷兰语",
  "af_NA": "南非荷兰文（纳米比亚）",
  "af_ZA": "南非荷兰文（南非）",
  "afa": "其他亚非语系",
  "afh": "阿弗里希利语",
  "agq": "亚罕语",
  "ain": "阿伊努语",
  "ak": "阿肯语",
  "ak_GH": "阿肯文（加纳）",
  "akk": "阿卡德语",
  "akz": "阿拉巴马语",
  "ale": "阿留申语",
  "alg": "其他阿尔贡语系",
  "aln": "盖格阿尔巴尼亚语",
  "alt": "南阿尔泰语",
  "am": "阿姆哈拉语",
  "am_ET": "阿姆哈拉文（埃塞俄比亚）",
  "an": "阿拉贡语",
  "ang": "古英语",
  "anp": "昂加语",
  "apa": "阿帕切语",
  "ar": "阿拉伯语",
  "ar_001": "现代标准阿拉伯语",
  "ar_AE": "阿拉伯文（阿拉伯联合酋长国）",
  "ar_BH": "阿拉伯文（巴林）",
  "ar_DJ": "阿拉伯文（吉布提）",
  "ar_DZ": "阿拉伯文（阿尔及利亚）",
  "ar_EG": "阿拉伯文（埃及）",
  "ar_EH": "阿拉伯文（西撒哈拉）",
  "ar_ER": "阿拉伯文（厄立特里亚）",
  "ar_IL": "阿拉伯文（以色列）",
  "ar_IQ": "阿拉伯文（伊拉克）",
  "ar_JO": "阿拉伯文（约旦）",
  "ar_KM": "阿拉伯文（科摩罗）",
  "ar_KW": "阿拉伯文（科威特）",
  "ar_LB": "阿拉伯文（黎巴嫩）",
  "ar_LY": "阿拉伯文（利比亚）",
  "ar_MA": "阿拉伯文（摩洛哥）",
  "ar_MR": "阿拉伯文（毛里塔尼亚）",
  "ar_OM": "阿拉伯文（阿曼）",
  "ar_PS": "阿拉伯文（巴勒斯坦领土）",
  "ar_QA": "阿拉伯文（卡塔尔）",
  "ar_SA": "阿拉伯文（沙特阿拉伯）",
  "ar_SD": "阿拉伯文（苏丹）",
  "ar_SO": "阿拉伯文（索马里）",
  "ar_SS": "阿拉伯文（南苏丹）",
  "ar_SY": "阿拉伯文（叙利亚）",
  "ar_TD": "阿拉伯文（乍得）",
  "ar_TN": "阿拉伯文（突尼斯）",
  "ar_YE": "阿拉伯文（也门）",
  "arc": "阿拉米语",
  "arn": "阿劳坎语",
  "aro": "阿拉奥纳语",
  "arp": "阿拉帕霍语",
  "arq": "阿尔及利亚阿拉伯语",
  "ars": "纳吉迪阿拉伯语",
  "art": "其他人工语系",
  "arw": "阿拉瓦克语",
  "ary": "摩洛哥阿拉伯语",
  "arz": "埃及阿拉伯语",
  "as": "阿萨姆语",
  "as_IN": "阿萨姆文（印度）",
  "asa": "帕雷语",
  "ase": "美国手语",
  "ast": "阿斯图里亚斯语",
  "ath": "阿萨帕斯坎语系",
  "aus": "澳大利亚语系",
  "av": "阿瓦尔语",
  "avk": "科塔瓦语",
  "awa": "阿瓦德语",
  "ay": "艾马拉语",
  "az": "阿塞拜疆语",
  "az_AZ": "阿塞拜疆文（阿塞拜疆）",
  "az_Arab": "阿塞拜疆语（阿拉伯文）",
  "az_Cyrl": "阿塞拜疆文（西里尔文）",
  "az_Cyrl_AZ": "阿塞拜疆文（西里尔文, 阿塞拜疆）",
  "az_Latn": "阿塞拜疆文（拉丁文）",
  "az_Latn_AZ": "阿塞拜疆文（拉丁文, 阿塞拜疆）",
  "azb": "South Azerbaijani",
  "ba": "巴什基尔语",
  "bad": "班达语",
  "bai": "巴米累克语系",
  "bal": "俾路支语",
  "ban": "巴厘语",
  "bar": "奥地利-巴伐利亚语",
  "bas": "巴萨语",
  "bat": "其他波罗的语系",
  "bax": "巴姆穆语",
  "bbc": "巴塔克托巴语",
  "bbj": "戈马拉语",
  "be": "白俄罗斯语",
  "be_BY": "白俄罗斯文（白俄罗斯）",
  "bej": "别札语",
  "bem": "本巴语",
  "ber": "柏柏尔语",
  "bew": "贝塔维语",
  "bez": "贝纳语",
  "bfd": "巴非特语",
  "bfq": "巴达加语",
  "bg": "保加利亚语",
  "bg_BG": "保加利亚文（保加利亚）",
  "bgn": "西俾路支语",
  "bh": "比哈尔语",
  "bho": "博杰普尔语",
  "bi": "比斯拉马语",
  "bik": "比科尔语",
  "bin": "比尼语",
  "bjn": "班亚尔语",
  "bkm": "科姆语",
  "bla": "西克西卡语",
  "bm": "班巴拉语",
  "bm_Latn": "班巴拉文（拉丁文）",
  "bm_Latn_ML": "班巴拉文（拉丁文, 马里）",
  "bn": "孟加拉语",
  "bn_BD": "孟加拉文（孟加拉国）",
  "bn_IN": "孟加拉文（印度）",
  "bnt": "班图语",
  "bo": "藏语",
  "bo_CN": "藏文（中国）",
  "bo_IN": "藏文（印度）",
  "bpy": "比什奴普莱利亚语",
  "bqi": "巴赫蒂亚里语",
  "br": "布列塔尼语",
  "br_FR": "布里多尼文（法国）",
  "bra": "布拉杰语",
  "brh": "布拉维语",
  "brx": "博多语",
  "bs": "波斯尼亚语",
  "bs_BA": "波斯尼亚文（波斯尼亚和黑塞哥维那）",
  "bs_Cyrl": "波斯尼亚文（西里尔文）",
  "bs_Cyrl_BA": "波斯尼亚文（西里尔文, 波斯尼亚和黑塞哥维那）",
  "bs_Latn": "波斯尼亚文（拉丁文）",
  "bs_Latn_BA": "波斯尼亚文（拉丁文, 波斯尼亚和黑塞哥维那）",
  "bss": "阿库色语",
  "btk": "巴塔克语",
  "bua": "布里亚特语",
  "bug": "布吉语",
  "bum": "布鲁语",
  "byn": "比林语",
  "byv": "梅敦巴语",
  "ca": "加泰罗尼亚语",
  "ca_AD": "加泰罗尼亚文（安道尔）",
  "ca_ES": "加泰罗尼亚文（西班牙）",
  "ca_FR": "加泰罗尼亚文（法国）",
  "ca_IT": "加泰罗尼亚文（意大利）",
  "cad": "卡多语",
  "cai": "其他中美印第安语系",
  "car": "加勒比语",
  "cau": "其他高加索语系",
  "cay": "卡尤加语",
  "cch": "阿灿语",
  "ccp": "查克玛语",
  "ce": "车臣语",
  "ceb": "宿务语",
  "cel": "其他凯尔特语系",
  "cgg": "奇加语",
  "ch": "查莫罗语",
  "chb": "奇布查语",
  "chg": "察合台语",
  "chk": "丘克语",
  "chm": "马里语",
  "chn": "奇努克混合语",
  "cho": "乔克托语",
  "chp": "奇佩维安语",
  "chr": "切罗基语",
  "chy": "夏延语",
  "cic": "奇克索语",
  "ckb": "中库尔德语",
  "cmc": "查米克语",
  "co": "科西嘉语",
  "cop": "科普特语",
  "cpe": "其他以英语为基础的克里奥尔混合语系",
  "cpf": "其他以法语为基础的克里奥尔混合语系",
  "cpp": "其他以葡萄牙语为基础的克里奥尔混合语系",
  "cps": "卡皮兹语",
  "cr": "克里族语",
  "crh": "克里米亚鞑靼语",
  "crp": "其他克里奥尔混合语系",
  "crs": "塞舌尔克里奥尔语",
  "cs": "捷克语",
  "cs_CZ": "捷克文（捷克共和国）",
  "csb": "卡舒比语",
  "cu": "教会斯拉夫语",
  "cus": "其他库施特语系",
  "cv": "楚瓦什语",
  "cy": "威尔士语",
  "cy_GB": "威尔士文（英国）",
  "da": "丹麦语",
  "da_DK": "丹麦文（丹麦）",
  "da_GL": "丹麦文（格陵兰）",
  "dak": "达科他语",
  "dar": "达尔格瓦语",
  "dav": "台塔语",
  "day": "达雅克语",
  "de": "德语",
  "de_AT": "德语（奥地利）",
  "de_BE": "德文（比利时）",
  "de_CH": "高地德语（瑞士）",
  "de_DE": "德文（德国）",
  "de_LI": "德文（列支敦士登）",
  "de_LU": "德文（卢森堡）",
  "del": "特拉华语",
  "den": "史拉维语",
  "dgr": "多格里布语",
  "din": "丁卡语",
  "dje": "哲尔马语",
  "doi": "多格拉语",
  "dra": "其他德拉维语系",
  "dsb": "下索布语",
  "dtp": "中部杜顺语",
  "dua": "都阿拉语",
  "dum": "中古荷兰语",
  "dv": "迪维希语",
  "dyo": "朱拉语",
  "dyu": "迪尤拉语",
  "dz": "宗喀语",
  "dz_BT": "不丹文（不丹）",
  "dzg": "达扎葛语",
  "ebu": "恩布语",
  "ee": "埃维语",
  "ee_GH": "埃维文（加纳）",
  "ee_TG": "埃维文（多哥）",
  "efi": "埃菲克语",
  "egl": "埃米利安语",
  "egy": "古埃及语",
  "eka": "艾卡朱克语",
  "el": "希腊语",
  "el_CY": "希腊文（塞浦路斯）",
  "el_GR": "希腊文（希腊）",
  "elx": "埃兰语",
  "en": "英语",
  "en_AG": "英文（安提瓜和巴布达）",
  "en_AI": "英文（安圭拉）",
  "en_AS": "英文（美属萨摩亚）",
  "en_AU": "英语（澳大利亚）",
  "en_BB": "英文（巴巴多斯）",
  "en_BE": "英文（比利时）",
  "en_BM": "英文（百慕大）",
  "en_BS": "英文（巴哈马）",
  "en_BW": "英文（博茨瓦纳）",
  "en_BZ": "英文（伯利兹）",
  "en_CA": "英语（加拿大）",
  "en_CC": "英文（科科斯（基林）群岛）",
  "en_CK": "英文（库克群岛）",
  "en_CM": "英文（喀麦隆）",
  "en_CX": "英文（圣诞岛）",
  "en_DG": "英文（迪戈加西亚岛）",
  "en_DM": "英文（多米尼克）",
  "en_ER": "英文（厄立特里亚）",
  "en_FJ": "英文（斐济）",
  "en_FK": "英文（福克兰群岛）",
  "en_FM": "英文（密克罗尼西亚）",
  "en_GB": "英语（英国）",
  "en_GD": "英文（格林纳达）",
  "en_GG": "英文（根西岛）",
  "en_GH": "英文（加纳）",
  "en_GI": "英文（直布罗陀）",
  "en_GM": "英文（冈比亚）",
  "en_GU": "英文（关岛）",
  "en_GY": "英文（圭亚那）",
  "en_HK": "英文（中国香港特别行政区）",
  "en_IE": "英文（爱尔兰）",
  "en_IM": "英文（曼岛）",
  "en_IN": "英文（印度）",
  "en_IO": "英文（英属印度洋领地）",
  "en_JE": "英文（泽西岛）",
  "en_JM": "英文（牙买加）",
  "en_KE": "英文（肯尼亚）",
  "en_KI": "英文（基里巴斯）",
  "en_KN": "英文（圣基茨和尼维斯）",
  "en_KY": "英文（开曼群岛）",
  "en_LC": "英文（圣卢西亚）",
  "en_LR": "英文（利比里亚）",
  "en_LS": "英文（莱索托）",
  "en_MG": "英文（马达加斯加）",
  "en_MH": "英文（马绍尔群岛）",
  "en_MO": "英文（中国澳门特别行政区）",
  "en_MP": "英文（北马里亚纳群岛）",
  "en_MS": "英文（蒙特塞拉特）",
  "en_MT": "英文（马耳他）",
  "en_MU": "英文（毛里求斯）",
  "en_MW": "英文（马拉维）",
  "en_MY": "英文（马来西亚）",
  "en_NA": "英文（纳米比亚）",
  "en_NF": "英文（诺福克岛）",
  "en_NG": "英文（尼日利亚）",
  "en_NR": "英文（瑙鲁）",
  "en_NU": "英文（纽埃）",
  "en_NZ": "英文（新西兰）",
  "en_PG": "英文（巴布亚新几内亚）",
  "en_PH": "英文（菲律宾）",
  "en_PK": "英文（巴基斯坦）",
  "en_PN": "英文（皮特凯恩群岛）",
  "en_PR": "英文（波多黎各）",
  "en_PW": "英文（帕劳）",
  "en_RW": "英文（卢旺达）",
  "en_SB": "英文（所罗门群岛）",
  "en_SC": "英文（塞舌尔）",
  "en_SD": "英文（苏丹）",
  "en_SG": "英文（新加坡）",
  "en_SH": "英文（圣赫勒拿）",
  "en_SL": "英文（塞拉利昂）",
  "en_SS": "英文（南苏丹）",
  "en_SX": "英文（荷属圣马丁）",
  "en_SZ": "英文（斯威士兰）",
  "en_TC": "英文（特克斯和凯科斯群岛）",
  "en_TK": "英文（托克劳）",
  "en_TO": "英文（汤加）",
  "en_TT": "英文（特立尼达和多巴哥）",
  "en_TV": "英文（图瓦卢）",
  "en_TZ": "英文（坦桑尼亚）",
  "en_UG": "英文（乌干达）",
  "en_UM": "英文（美国本土外小岛屿）",
  "en_US": "英语（美国）",
  "en_VC": "英文（圣文森特和格林纳丁斯）",
  "en_VG": "英文（英属维京群岛）",
  "en_VI": "英文（美属维京群岛）",
  "en_VU": "英文（瓦努阿图）",
  "en_WS": "英文（萨摩亚）",
  "en_ZA": "英文（南非）",
  "en_ZM": "英文（赞比亚）",
  "en_ZW": "英文（津巴布韦）",
  "enm": "中古英语",
  "eo": "世界语",
  "es": "西班牙语",
  "es_419": "西班牙语（拉丁美洲）",
  "es_AR": "西班牙文（阿根廷）",
  "es_BO": "西班牙文（玻利维亚）",
  "es_CL": "西班牙文（智利）",
  "es_CO": "西班牙文（哥伦比亚）",
  "es_CR": "西班牙文（哥斯达黎加）",
  "es_CU": "西班牙文（古巴）",
  "es_DO": "西班牙文（多米尼加共和国）",
  "es_EA": "西班牙文（休达及梅利利亚）",
  "es_EC": "西班牙文（厄瓜多尔）",
  "es_ES": "西班牙语（西班牙）",
  "es_GQ": "西班牙文（赤道几内亚）",
  "es_GT": "西班牙文（危地马拉）",
  "es_HN": "西班牙文（洪都拉斯）",
  "es_IC": "西班牙文（加纳利群岛）",
  "es_MX": "西班牙语（墨西哥）",
  "es_NI": "西班牙文（尼加拉瓜）",
  "es_PA": "西班牙文（巴拿马）",
  "es_PE": "西班牙文（秘鲁）",
  "es_PH": "西班牙文（菲律宾）",
  "es_PR": "西班牙文（波多黎各）",
  "es_PY": "西班牙文（巴拉圭）",
  "es_SV": "西班牙文（萨尔瓦多）",
  "es_US": "西班牙文（美国）",
  "es_UY": "西班牙文（乌拉圭）",
  "es_VE": "西班牙文（委内瑞拉）",
  "esu": "中尤皮克语",
  "et": "爱沙尼亚语",
  "et_EE": "爱沙尼亚文（爱沙尼亚）",
  "eu": "巴斯克语",
  "eu_ES": "巴斯克文（西班牙）",
  "ewo": "旺杜语",
  "ext": "埃斯特雷马杜拉语",
  "fa": "波斯语",
  "fa_AF": "波斯语（阿富汗）",
  "fa_IR": "波斯文（伊朗）",
  "fan": "芳格语",
  "fat": "芳蒂语",
  "ff": "富拉语",
  "ff_CM": "夫拉文（喀麦隆）",
  "ff_GN": "夫拉文（几内亚）",
  "ff_MR": "夫拉文（毛里塔尼亚）",
  "ff_SN": "夫拉文（塞内加尔）",
  "fi": "芬兰语",
  "fi_FI": "芬兰文（芬兰）",
  "fil": "菲律宾语",
  "fit": "托尔讷芬兰语",
  "fiu": "其他芬兰乌戈尔语系",
  "fj": "斐济语",
  "fo": "法罗语",
  "fo_FO": "法罗文（法罗群岛）",
  "fon": "丰语",
  "fr": "法语",
  "fr_BE": "法文（比利时）",
  "fr_BF": "法文（布基纳法索）",
  "fr_BI": "法文（布隆迪）",
  "fr_BJ": "法文（贝宁）",
  "fr_BL": "法文（圣巴泰勒米）",
  "fr_CA": "法语（加拿大）",
  "fr_CD": "法文（刚果（金））",
  "fr_CF": "法文（中非共和国）",
  "fr_CG": "法文（刚果（布））",
  "fr_CH": "法语（瑞士）",
  "fr_CI": "法文（科特迪瓦）",
  "fr_CM": "法文（喀麦隆）",
  "fr_DJ": "法文（吉布提）",
  "fr_DZ": "法文（阿尔及利亚）",
  "fr_FR": "法文（法国）",
  "fr_GA": "法文（加蓬）",
  "fr_GF": "法文（法属圭亚那）",
  "fr_GN": "法文（几内亚）",
  "fr_GP": "法文（瓜德罗普）",
  "fr_GQ": "法文（赤道几内亚）",
  "fr_HT": "法文（海地）",
  "fr_KM": "法文（科摩罗）",
  "fr_LU": "法文（卢森堡）",
  "fr_MA": "法文（摩洛哥）",
  "fr_MC": "法文（摩纳哥）",
  "fr_MF": "法文（法属圣马丁）",
  "fr_MG": "法文（马达加斯加）",
  "fr_ML": "法文（马里）",
  "fr_MQ": "法文（马提尼克）",
  "fr_MR": "法文（毛里塔尼亚）",
  "fr_MU": "法文（毛里求斯）",
  "fr_NC": "法文（新喀里多尼亚）",
  "fr_NE": "法文（尼日尔）",
  "fr_PF": "法文（法属波利尼西亚）",
  "fr_PM": "法文（圣皮埃尔和密克隆群岛）",
  "fr_RE": "法文（留尼汪）",
  "fr_RW": "法文（卢旺达）",
  "fr_SC": "法文（塞舌尔）",
  "fr_SN": "法文（塞内加尔）",
  "fr_SY": "法文（叙利亚）",
  "fr_TD": "法文（乍得）",
  "fr_TG": "法文（多哥）",
  "fr_TN": "法文（突尼斯）",
  "fr_VU": "法文（瓦努阿图）",
  "fr_WF": "法文（瓦利斯和富图纳）",
  "fr_YT": "法文（马约特）",
  "frc": "卡真法语",
  "frm": "中古法语",
  "fro": "古法语",
  "frp": "法兰克-普罗旺斯语",
  "frr": "北弗里西亚语",
  "frs": "东弗里西亚语",
  "fur": "弗留利语",
  "fy": "西弗里西亚语",
  "fy_NL": "西弗里西亚文（荷兰）",
  "ga": "爱尔兰语",
  "ga_IE": "爱尔兰文（爱尔兰）",
  "gaa": "加族语",
  "gag": "加告兹语",
  "gan": "赣语",
  "gay": "迦约语",
  "gba": "格巴亚语",
  "gbz": "索罗亚斯德教达里语",
  "gd": "苏格兰盖尔语",
  "gd_GB": "苏格兰盖尔文（英国）",
  "gem": "其他日尔曼语系",
  "gez": "吉兹语",
  "gil": "吉尔伯特语",
  "gl": "加利西亚语",
  "gl_ES": "加利西亚文（西班牙）",
  "glk": "吉拉基语",
  "gmh": "中古高地德语",
  "gn": "瓜拉尼语",
  "goh": "古高地德语",
  "gom": "孔卡尼语",
  "gon": "冈德语",
  "gor": "哥伦打洛语",
  "got": "哥特语",
  "grb": "格列博语",
  "grc": "古希腊语",
  "gsw": "瑞士德语",
  "gu": "古吉拉特语",
  "gu_IN": "古吉拉特文（印度）",
  "guc": "瓦尤语",
  "gur": "弗拉弗拉语",
  "guz": "古西语",
  "gv": "马恩语",
  "gv_IM": "马恩岛文（曼岛）",
  "gwi": "哥威迅语",
  "ha": "豪萨语",
  "ha_GH": "豪萨文（加纳）",
  "ha_Latn": "豪萨文（拉丁文）",
  "ha_Latn_GH": "豪萨文（拉丁文, 加纳）",
  "ha_Latn_NE": "豪萨文（拉丁文, 尼日尔）",
  "ha_Latn_NG": "豪萨文（拉丁文, 尼日利亚）",
  "ha_NE": "豪萨文（尼日尔）",
  "ha_NG": "豪萨文（尼日利亚）",
  "hai": "海达语",
  "hak": "客家语",
  "haw": "夏威夷语",
  "he": "希伯来语",
  "he_IL": "希伯来文（以色列）",
  "hi": "印地语",
  "hi_IN": "印地文（印度）",
  "hif": "斐济印地语",
  "hil": "希利盖农语",
  "him": "赫马查利语",
  "hit": "赫梯语",
  "hmn": "苗语",
  "ho": "希里莫图语",
  "hr": "克罗地亚语",
  "hr_BA": "克罗地亚文（波斯尼亚和黑塞哥维那）",
  "hr_HR": "克罗地亚文（克罗地亚）",
  "hsb": "上索布语",
  "hsn": "湘语",
  "ht": "海地克里奥尔语",
  "hu": "匈牙利语",
  "hu_HU": "匈牙利文（匈牙利）",
  "hup": "胡帕语",
  "hy": "亚美尼亚语",
  "hy_AM": "亚美尼亚文（亚美尼亚）",
  "hz": "赫雷罗语",
  "ia": "国际语",
  "iba": "伊班语",
  "ibb": "伊比比奥语",
  "id": "印度尼西亚语",
  "id_ID": "印度尼西亚文（印度尼西亚）",
  "ie": "西方国际语",
  "ig": "伊博语",
  "ig_NG": "伊布文（尼日利亚）",
  "ii": "四川彝语",
  "ii_CN": "四川彝文（中国）",
  "ijo": "伊乔语",
  "ik": "伊努皮克语",
  "ilo": "伊洛卡诺语",
  "inc": "其他印度语系",
  "ine": "其他印欧语系",
  "inh": "印古什语",
  "io": "伊多语",
  "ira": "伊朗语",
  "iro": "伊洛魁语系",
  "is": "冰岛语",
  "is_IS": "冰岛文（冰岛）",
  "it": "意大利语",
  "it_CH": "意大利文（瑞士）",
  "it_IT": "意大利文（意大利）",
  "it_SM": "意大利文（圣马力诺）",
  "iu": "伊努克提图特语",
  "izh": "伊乔里亚语",
  "ja": "日语",
  "ja_JP": "日文（日本）",
  "jam": "牙买加克里奥尔英语",
  "jbo": "逻辑语",
  "jgo": "恩艮巴语",
  "jmc": "马切姆语",
  "jpr": "犹太波斯语",
  "jrb": "犹太阿拉伯语",
  "jut": "日德兰语",
  "jv": "爪哇语",
  "ka": "格鲁吉亚语",
  "ka_GE": "格鲁吉亚文（格鲁吉亚）",
  "kaa": "卡拉卡尔帕克语",
  "kab": "卡拜尔语",
  "kac": "景颇语",
  "kaj": "卡捷语",
  "kam": "卡姆巴语",
  "kar": "喀伦语",
  "kaw": "卡威语",
  "kbd": "卡巴尔达语",
  "kbl": "加涅姆布语",
  "kcg": "卡塔布语",
  "kde": "马孔德语",
  "kea": "卡布佛得鲁语",
  "ken": "肯扬语",
  "kfo": "克罗语",
  "kg": "刚果语",
  "kgp": "坎刚语",
  "kha": "卡西语",
  "khi": "其他科伊桑语系",
  "kho": "和田语",
  "khq": "西桑海语",
  "khw": "科瓦语",
  "ki": "吉库尤语",
  "ki_KE": "吉库尤文（肯尼亚）",
  "kiu": "北扎扎其语",
  "kj": "宽亚玛语",
  "kk": "哈萨克语",
  "kk_Cyrl": "哈萨克文（西里尔文）",
  "kk_Cyrl_KZ": "哈萨克文（西里尔文, 哈萨克斯坦）",
  "kk_KZ": "哈萨克文（哈萨克斯坦）",
  "kkj": "卡库语",
  "kl": "格陵兰语",
  "kl_GL": "格陵兰文（格陵兰）",
  "kln": "卡伦金语",
  "km": "高棉语",
  "km_KH": "高棉文（柬埔寨）",
  "kmb": "金邦杜语",
  "kn": "卡纳达语",
  "kn_IN": "卡纳达文（印度）",
  "ko": "韩语",
  "ko_KP": "韩文（朝鲜）",
  "ko_KR": "韩文（韩国）",
  "koi": "科米-彼尔米亚克语",
  "kok": "孔卡尼语",
  "kos": "科斯拉伊语",
  "kpe": "克佩列语",
  "kr": "卡努里语",
  "krc": "卡拉恰伊巴尔卡尔语",
  "kri": "塞拉利昂克里奥尔语",
  "krj": "基那来阿语",
  "krl": "卡累利阿语",
  "kro": "克鲁语",
  "kru": "库鲁克语",
  "ks": "克什米尔语",
  "ks_Arab": "克什米尔文（阿拉伯文）",
  "ks_Arab_IN": "克什米尔文（阿拉伯文, 印度）",
  "ks_IN": "克什米尔文（印度）",
  "ksb": "香巴拉语",
  "ksf": "巴菲亚语",
  "ksh": "科隆语",
  "ku": "库尔德语",
  "kum": "库梅克语",
  "kut": "库特内语",
  "kv": "科米语",
  "kw": "康沃尔语",
  "kw_GB": "凯尔特文（英国）",
  "ky": "柯尔克孜语",
  "ky_Cyrl": "吉尔吉斯文（西里尔文）",
  "ky_Cyrl_KG": "吉尔吉斯文（西里尔文, 吉尔吉斯斯坦）",
  "ky_KG": "吉尔吉斯文（吉尔吉斯斯坦）",
  "la": "拉丁语",
  "lad": "拉迪诺语",
  "lag": "朗吉语",
  "lah": "拉亨达语",
  "lam": "兰巴语",
  "lb": "卢森堡语",
  "lb_LU": "卢森堡文（卢森堡）",
  "lez": "列兹金语",
  "lfn": "新通用语",
  "lg": "卢干达语",
  "lg_UG": "卢干达文（乌干达）",
  "li": "林堡语",
  "lij": "利古里亚语",
  "liv": "利伏尼亚语",
  "lkt": "拉科塔语",
  "lmo": "伦巴第语",
  "ln": "林加拉语",
  "ln_AO": "林加拉文（安哥拉）",
  "ln_CD": "林加拉文（刚果（金））",
  "ln_CF": "林加拉文（中非共和国）",
  "ln_CG": "林加拉文（刚果（布））",
  "lo": "老挝语",
  "lo_LA": "老挝文（老挝）",
  "lol": "芒戈语",
  "lou": "路易斯安那克里奥尔语",
  "loz": "洛齐语",
  "lrc": "北卢尔语",
  "lt": "立陶宛语",
  "lt_LT": "立陶宛文（立陶宛）",
  "ltg": "拉特加莱语",
  "lu": "鲁巴加丹加语",
  "lu_CD": "鲁巴加丹加文（刚果（金））",
  "lua": "卢巴-卢拉语",
  "lui": "卢伊塞诺语",
  "lun": "隆达语",
  "luo": "卢奥语",
  "lus": "米佐语",
  "luy": "卢雅语",
  "lv": "拉脱维亚语",
  "lv_LV": "拉脱维亚文（拉脱维亚）",
  "lzh": "文言文",
  "lzz": "拉兹语",
  "mad": "马都拉语",
  "maf": "马法语",
  "mag": "摩揭陀语",
  "mai": "迈蒂利语",
  "mak": "望加锡语",
  "man": "曼丁哥语",
  "map": "澳斯特罗尼西亚语系",
  "mas": "萨伊语",
  "mde": "马坝语",
  "mdf": "莫克沙语",
  "mdr": "曼达尔语",
  "men": "门德语",
  "mer": "梅鲁语",
  "mfe": "毛里求斯克里奥尔语",
  "mg": "马达加斯加语",
  "mg_MG": "马尔加什文（马达加斯加）",
  "mga": "中古爱尔兰语",
  "mgh": "马库阿语",
  "mgo": "梅塔语",
  "mh": "马绍尔语",
  "mi": "毛利语",
  "mic": "米克马克语",
  "min": "米南佳保语",
  "mis": "各种不同语系",
  "mk": "马其顿语",
  "mk_MK": "马其顿文（马其顿）",
  "mkh": "其他孟高棉语系",
  "ml": "马拉雅拉姆语",
  "ml_IN": "马拉雅拉姆文（印度）",
  "mn": "蒙古语",
  "mn_Cyrl": "蒙古文（西里尔文）",
  "mn_Cyrl_MN": "蒙古文（西里尔文, 蒙古）",
  "mn_MN": "蒙古文（蒙古）",
  "mnc": "满语",
  "mni": "曼尼普尔语",
  "mno": "马诺博语系",
  "mo": "摩尔多瓦语",
  "moh": "摩霍克语",
  "mos": "莫西语",
  "mr": "马拉地语",
  "mr_IN": "马拉地文（印度）",
  "mrj": "西马里语",
  "ms": "马来语",
  "ms_BN": "马来文（文莱）",
  "ms_Latn": "马来文（拉丁文）",
  "ms_Latn_BN": "马来文（拉丁文, 文莱）",
  "ms_Latn_MY": "马来文（拉丁文, 马来西亚）",
  "ms_Latn_SG": "马来文（拉丁文, 新加坡）",
  "ms_MY": "马来文（马来西亚）",
  "ms_SG": "马来文（新加坡）",
  "mt": "马耳他语",
  "mt_MT": "马耳他文（马耳他）",
  "mua": "蒙当语",
  "mul": "多语种",
  "mun": "蒙达语系",
  "mus": "克里克语",
  "mwl": "米兰德斯语",
  "mwr": "马尔瓦利语",
  "mwv": "明打威语",
  "my": "缅甸语",
  "my_MM": "缅甸文（缅甸）",
  "mye": "姆耶内语",
  "myn": "玛雅语系",
  "myv": "厄尔兹亚语",
  "mzn": "马赞德兰语",
  "na": "瑙鲁语",
  "nah": "纳瓦特尔语",
  "nai": "其他北美印第安语系",
  "nan": "闽南语",
  "nap": "那不勒斯语",
  "naq": "纳马语",
  "nb": "书面挪威语",
  "nb_NO": "挪威博克马尔文（挪威）",
  "nb_SJ": "挪威博克马尔文（斯瓦尔巴特和扬马延）",
  "nd": "北恩德贝勒语",
  "nd_ZW": "北恩德贝勒文（津巴布韦）",
  "nds": "低地德语",
  "nds_NL": "低地德语（荷兰）",
  "ne": "尼泊尔语",
  "ne_IN": "尼泊尔文（印度）",
  "ne_NP": "尼泊尔文（尼泊尔）",
  "new": "尼瓦尔语",
  "ng": "恩东加语",
  "nia": "尼亚斯语",
  "nic": "其他尼日尔科尔多凡语系",
  "niu": "纽埃语",
  "njo": "阿沃那加语",
  "nl": "荷兰语",
  "nl_AW": "荷兰文（阿鲁巴）",
  "nl_BE": "荷兰语（比利时）",
  "nl_BQ": "荷兰文（荷兰加勒比区）",
  "nl_CW": "荷兰文（库拉索）",
  "nl_NL": "荷兰文（荷兰）",
  "nl_SR": "荷兰文（苏里南）",
  "nl_SX": "荷兰文（荷属圣马丁）",
  "nmg": "夸西奥语",
  "nn": "挪威尼诺斯克语",
  "nn_NO": "挪威尼诺斯克文（挪威）",
  "nnh": "恩甘澎语",
  "no": "挪威语",
  "no_NO": "挪威文（挪威）",
  "nog": "诺盖语",
  "non": "古诺尔斯语",
  "nov": "诺维亚语",
  "nqo": "西非书面语",
  "nr": "南恩德贝勒语",
  "nso": "北索托语",
  "nub": "努比亚语系",
  "nus": "努埃尔语",
  "nv": "纳瓦霍语",
  "nwc": "古典尼瓦尔语",
  "ny": "齐切瓦语",
  "nym": "尼扬韦齐语",
  "nyn": "尼昂科勒语",
  "nyo": "尼奥罗语",
  "nzi": "恩济马语",
  "oc": "奥克语",
  "oj": "奥吉布瓦语",
  "om": "奥罗莫语",
  "om_ET": "奥洛莫文（埃塞俄比亚）",
  "om_KE": "奥洛莫文（肯尼亚）",
  "or": "奥里亚语",
  "or_IN": "奥里亚文（印度）",
  "os": "奥塞梯语",
  "os_GE": "奥塞梯文（格鲁吉亚）",
  "os_RU": "奥塞梯文（俄罗斯）",
  "osa": "奥萨格语",
  "ota": "奥斯曼土耳其语",
  "oto": "奥托米语系",
  "pa": "旁遮普语",
  "pa_Arab": "旁遮普文（阿拉伯文）",
  "pa_Arab_PK": "旁遮普文（阿拉伯文, 巴基斯坦）",
  "pa_Guru": "旁遮普文（果鲁穆奇文）",
  "pa_Guru_IN": "旁遮普文（果鲁穆奇文, 印度）",
  "pa_IN": "旁遮普文（印度）",
  "pa_PK": "旁遮普文（巴基斯坦）",
  "paa": "其他巴布亚语",
  "pag": "邦阿西楠语",
  "pal": "帕拉维语",
  "pam": "邦板牙语",
  "pap": "帕皮亚门托语",
  "pau": "帕劳语",
  "pcd": "皮卡第语",
  "pcm": "尼日利亚皮钦语",
  "pdc": "宾夕法尼亚德语",
  "pdt": "门诺低地德语",
  "peo": "古波斯语",
  "pfl": "普法尔茨德语",
  "phi": "其他菲律宾语系",
  "phn": "腓尼基语",
  "pi": "巴利语",
  "pl": "波兰语",
  "pl_PL": "波兰文（波兰）",
  "pms": "皮埃蒙特语",
  "pnt": "本都希腊语",
  "pon": "波纳佩语",
  "pra": "普拉克里特诸语言",
  "prg": "普鲁士语",
  "pro": "古普罗文斯语",
  "ps": "普什图语",
  "ps_AF": "普什图文（阿富汗）",
  "pt": "葡萄牙语",
  "pt_AO": "葡萄牙文（安哥拉）",
  "pt_BR": "葡萄牙语（巴西）",
  "pt_CV": "葡萄牙文（佛得角）",
  "pt_GW": "葡萄牙文（几内亚比绍）",
  "pt_MO": "葡萄牙文（中国澳门特别行政区）",
  "pt_MZ": "葡萄牙文（莫桑比克）",
  "pt_PT": "葡萄牙语（葡萄牙）",
  "pt_ST": "葡萄牙文（圣多美和普林西比）",
  "pt_TL": "葡萄牙文（东帝汶）",
  "qu": "克丘亚语",
  "qu_BO": "盖丘亚文（玻利维亚）",
  "qu_EC": "盖丘亚文（厄瓜多尔）",
  "qu_PE": "盖丘亚文（秘鲁）",
  "quc": "基切语",
  "qug": "钦博拉索海兰盖丘亚语",
  "raj": "拉贾斯坦语",
  "rap": "拉帕努伊语",
  "rar": "拉罗汤加语",
  "rgn": "罗马格诺里语",
  "rif": "里菲亚诺语",
  "rm": "罗曼什语",
  "rm_CH": "罗曼什文（瑞士）",
  "rn": "基隆迪语",
  "rn_BI": "基隆迪文（布隆迪）",
  "ro": "罗马尼亚语",
  "ro_MD": "罗马尼亚语（摩尔多瓦）",
  "ro_RO": "罗马尼亚文（罗马尼亚）",
  "roa": "其他拉丁语系",
  "rof": "兰博语",
  "rom": "吉普赛语",
  "root": "根语言",
  "rtm": "罗图马岛语",
  "ru": "俄语",
  "ru_BY": "俄文（白俄罗斯）",
  "ru_KG": "俄文（吉尔吉斯斯坦）",
  "ru_KZ": "俄文（哈萨克斯坦）",
  "ru_MD": "俄文（摩尔多瓦）",
  "ru_RU": "俄文（俄罗斯）",
  "ru_UA": "俄文（乌克兰）",
  "rue": "卢森尼亚语",
  "rug": "罗维阿纳语",
  "rup": "阿罗马尼亚语",
  "rw": "卢旺达语",
  "rw_RW": "卢旺达文（卢旺达）",
  "rwk": "罗瓦语",
  "sa": "梵语",
  "sad": "桑达韦语",
  "sah": "雅库特语",
  "sai": "其他南美印第安语",
  "sal": "萨利什语",
  "sam": "萨马利亚阿拉姆语",
  "saq": "桑布鲁语",
  "sas": "萨萨克语",
  "sat": "桑塔利语",
  "saz": "索拉什特拉语",
  "sba": "甘拜语",
  "sbp": "桑古语",
  "sc": "萨丁语",
  "scn": "西西里语",
  "sco": "苏格兰语",
  "sd": "信德语",
  "sdc": "萨丁尼亚-萨萨里语",
  "sdh": "南库尔德语",
  "se": "北萨米语",
  "se_FI": "北萨米文（芬兰）",
  "se_NO": "北萨米文（挪威）",
  "se_SE": "北萨米文（瑞典）",
  "see": "塞内卡语",
  "seh": "塞纳语",
  "sei": "瑟里语",
  "sel": "塞尔库普语",
  "sem": "其他闪族语系",
  "ses": "东桑海语",
  "sg": "桑戈语",
  "sg_CF": "桑戈文（中非共和国）",
  "sga": "古爱尔兰语",
  "sgn": "手语",
  "sgs": "萨莫吉提亚语",
  "sh": "塞尔维亚-克罗地亚语",
  "sh_BA": "塞尔维亚-克罗地亚文（波斯尼亚和黑塞哥维那）",
  "shi": "希尔哈语",
  "shn": "掸语",
  "shu": "乍得阿拉伯语",
  "si": "僧伽罗语",
  "si_LK": "僧伽罗文（斯里兰卡）",
  "sid": "悉达摩语",
  "sio": "苏语诸语言",
  "sit": "其他汉藏语系",
  "sk": "斯洛伐克语",
  "sk_SK": "斯洛伐克文（斯洛伐克）",
  "sl": "斯洛文尼亚语",
  "sl_SI": "斯洛文尼亚文（斯洛文尼亚）",
  "sla": "其他斯拉夫语系",
  "sli": "下西利西亚语",
  "sly": "塞拉亚语",
  "sm": "萨摩亚语",
  "sma": "南萨米语",
  "smi": "其他萨米语",
  "smj": "吕勒萨米语",
  "smn": "伊纳里萨米语",
  "sms": "斯科特萨米语",
  "sn": "绍纳语",
  "sn_ZW": "绍纳文（津巴布韦）",
  "snk": "索宁克语",
  "so": "索马里语",
  "so_DJ": "索马里文（吉布提）",
  "so_ET": "索马里文（埃塞俄比亚）",
  "so_KE": "索马里文（肯尼亚）",
  "so_SO": "索马里文（索马里）",
  "sog": "粟特语",
  "son": "桑海语",
  "sq": "阿尔巴尼亚语",
  "sq_AL": "阿尔巴尼亚文（阿尔巴尼亚）",
  "sq_MK": "阿尔巴尼亚文（马其顿）",
  "sq_XK": "阿尔巴尼亚文（科索沃）",
  "sr": "塞尔维亚语",
  "sr_BA": "塞尔维亚文（波斯尼亚和黑塞哥维那）",
  "sr_Cyrl": "塞尔维亚文（西里尔文）",
  "sr_Cyrl_BA": "塞尔维亚文（西里尔文, 波斯尼亚和黑塞哥维那）",
  "sr_Cyrl_ME": "塞尔维亚文（西里尔文, 黑山共和国）",
  "sr_Cyrl_RS": "塞尔维亚文（西里尔文, 塞尔维亚）",
  "sr_Cyrl_XK": "塞尔维亚文（西里尔文, 科索沃）",
  "sr_Latn": "塞尔维亚文（拉丁文）",
  "sr_Latn_BA": "塞尔维亚文（拉丁文, 波斯尼亚和黑塞哥维那）",
  "sr_Latn_ME": "塞尔维亚文（拉丁文, 黑山共和国）",
  "sr_Latn_RS": "塞尔维亚文（拉丁文, 塞尔维亚）",
  "sr_Latn_XK": "塞尔维亚文（拉丁文, 科索沃）",
  "sr_ME": "塞尔维亚语（黑山）",
  "sr_RS": "塞尔维亚文（塞尔维亚）",
  "sr_XK": "塞尔维亚文（科索沃）",
  "srn": "苏里南汤加语",
  "srr": "塞雷尔语",
  "ss": "斯威士语",
  "ssa": "非洲撒哈拉沙漠边缘地带语言",
  "ssy": "萨霍语",
  "st": "南索托语",
  "stq": "萨特弗里斯兰语",
  "su": "巽他语",
  "suk": "苏库马语",
  "sus": "苏苏语",
  "sux": "苏美尔语",
  "sv": "瑞典语",
  "sv_AX": "瑞典文（奥兰群岛）",
  "sv_FI": "瑞典文（芬兰）",
  "sv_SE": "瑞典文（瑞典）",
  "sw": "斯瓦希里语",
  "sw_CD": "斯瓦希里语（刚果民主共和国）",
  "sw_KE": "斯瓦希里文（肯尼亚）",
  "sw_TZ": "斯瓦希里文（坦桑尼亚）",
  "sw_UG": "斯瓦希里文（乌干达）",
  "swb": "科摩罗语",
  "swc": "刚果斯瓦希里语",
  "syc": "古典叙利亚语",
  "syr": "叙利亚语",
  "szl": "西利西亚语",
  "ta": "泰米尔语",
  "ta_IN": "泰米尔文（印度）",
  "ta_LK": "泰米尔文（斯里兰卡）",
  "ta_MY": "泰米尔文（马来西亚）",
  "ta_SG": "泰米尔文（新加坡）",
  "tai": "傣语诸语言（其他）",
  "tcy": "图卢语",
  "te": "泰卢固语",
  "te_IN": "泰卢固文（印度）",
  "tem": "滕内语",
  "teo": "特索语",
  "ter": "特列纳语",
  "tet": "特塔姆语",
  "tg": "塔吉克语",
  "th": "泰语",
  "th_TH": "泰文（泰国）",
  "ti": "提格利尼亚语",
  "ti_ER": "提格里尼亚文（厄立特里亚）",
  "ti_ET": "提格里尼亚文（埃塞俄比亚）",
  "tig": "提格雷语",
  "tiv": "蒂夫语",
  "tk": "土库曼语",
  "tkl": "托克劳语",
  "tkr": "查库尔语",
  "tl": "他加禄语",
  "tl_PH": "塔加洛文（菲律宾）",
  "tlh": "克林贡语",
  "tli": "特林吉特语",
  "tly": "塔里什语",
  "tmh": "塔马奇克语",
  "tn": "茨瓦纳语",
  "to": "汤加语",
  "to_TO": "汤加文（汤加）",
  "tog": "汤加语（尼亚萨地区）",
  "tpi": "托克皮辛语",
  "tr": "土耳其语",
  "tr_CY": "土耳其文（塞浦路斯）",
  "tr_TR": "土耳其文（土耳其）",
  "tru": "图罗尤语",
  "trv": "赛德克语",
  "ts": "聪加语",
  "tsd": "特萨克尼恩语",
  "tsi": "钦西安语",
  "tt": "鞑靼语",
  "ttt": "穆斯林塔特语",
  "tum": "通布卡语",
  "tup": "图皮语系",
  "tut": "阿尔泰诸语言（其他）",
  "tvl": "图瓦卢语",
  "tw": "契维语",
  "twq": "北桑海语",
  "ty": "塔希提语",
  "tyv": "图瓦语",
  "tzm": "塔马齐格特语",
  "udm": "乌德穆尔特语",
  "ug": "维吾尔语",
  "ug_Arab": "维吾尔文（阿拉伯文）",
  "ug_Arab_CN": "维吾尔文（阿拉伯文, 中国）",
  "ug_CN": "维吾尔文（中国）",
  "uga": "乌加里特语",
  "uk": "乌克兰语",
  "uk_UA": "乌克兰文（乌克兰）",
  "umb": "翁本杜语",
  "und": "未知语言",
  "ur": "乌尔都语",
  "ur_IN": "乌尔都文（印度）",
  "ur_PK": "乌尔都文（巴基斯坦）",
  "uz": "乌兹别克语",
  "uz_AF": "乌兹别克文（阿富汗）",
  "uz_Arab": "乌兹别克文（阿拉伯文）",
  "uz_Arab_AF": "乌兹别克文（阿拉伯文, 阿富汗）",
  "uz_Cyrl": "乌兹别克文（西里尔文）",
  "uz_Cyrl_UZ": "乌兹别克文（西里尔文, 乌兹别克斯坦）",
  "uz_Latn": "乌兹别克文（拉丁文）",
  "uz_Latn_UZ": "乌兹别克文（拉丁文, 乌兹别克斯坦）",
  "uz_UZ": "乌兹别克文（乌兹别克斯坦）",
  "vai": "瓦伊语",
  "ve": "文达语",
  "vec": "威尼斯语",
  "vep": "维普森语",
  "vi": "越南语",
  "vi_VN": "越南文（越南）",
  "vls": "西弗拉芒方言",
  "vmf": "美茵-法兰克尼亚语",
  "vo": "沃拉普克语",
  "vot": "沃提克语",
  "vro": "沃罗语",
  "vun": "温旧语",
  "wa": "瓦隆语",
  "wae": "瓦尔瑟语",
  "wak": "瓦卡什诸语言",
  "wal": "瓦拉莫语",
  "war": "瓦赖语",
  "was": "瓦绍语",
  "wbp": "瓦尔皮瑞语",
  "wen": "索布诸语言",
  "wo": "沃洛夫语",
  "wuu": "吴语",
  "xal": "卡尔梅克语",
  "xh": "科萨语",
  "xmf": "明格列尔语",
  "xog": "索加语",
  "yao": "瑶族语",
  "yap": "雅浦语",
  "yav": "洋卞语",
  "ybb": "耶姆巴语",
  "yi": "意第绪语",
  "yo": "约鲁巴语",
  "yo_BJ": "约鲁巴文（贝宁）",
  "yo_NG": "约鲁巴文（尼日利亚）",
  "ypk": "尤皮克诸语言",
  "yrl": "奈恩加图语",
  "yue": "粤语",
  "za": "壮语",
  "zap": "萨波蒂克语",
  "zbl": "布里斯符号",
  "zea": "泽兰语",
  "zen": "泽纳加语",
  "zgh": "标准摩洛哥塔马塞特语",
  "zh": "中文",
  "zh_CN": "中文（中国）",
  "zh_HK": "中文（中国香港特别行政区）",
  "zh_Hans": "中文（简体）",
  "zh_Hans_CN": "中文（简体中文, 中国）",
  "zh_Hans_HK": "中文（简体中文, 中国香港特别行政区）",
  "zh_Hans_MO": "中文（简体中文, 中国澳门特别行政区）",
  "zh_Hans_SG": "中文（简体中文, 新加坡）",
  "zh_Hant": "中文（繁体）",
  "zh_Hant_HK": "中文（繁体中文, 中国香港特别行政区）",
  "zh_Hant_MO": "中文（繁体中文, 中国澳门特别行政区）",
  "zh_Hant_TW": "中文（繁体中文, 台湾）",
  "zh_MO": "中文（中国澳门特别行政区）",
  "zh_SG": "中文（新加坡）",
  "zh_TW": "中文（台湾）",
  "znd": "赞德语",
  "zu": "祖鲁语",
  "zu_ZA": "祖鲁文（南非）",
  "zun": "祖尼语",
  "zxx": "无语言内容",
  "zza": "扎扎语"
};
