// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'lib_l10n.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class LibLocalizationsTr extends LibLocalizations {
  LibLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get about => 'Hakkında';

  @override
  String actionAndAction(Object action1, Object action2) {
    return '$action1, sonra $action2?';
  }

  @override
  String get add => 'Ekle';

  @override
  String get all => 'Tümü';

  @override
  String get anonLoseDataTip =>
      'Şu anda anonim olarak giriş yapılmış, işlemlere devam edilmesi veri kaybına neden olacaktır.';

  @override
  String get app => 'Uygulama';

  @override
  String askContinue(Object msg) {
    return '$msg. Devam edilsin mi?';
  }

  @override
  String get attention => 'Dikkat';

  @override
  String get authRequired => 'Kimlik doğrulaması gerekiyor';

  @override
  String get auto => 'Otomatik';

  @override
  String get background => 'Arka Plan';

  @override
  String get backup => 'Yedekleme';

  @override
  String get bioAuth => 'Biyometrik doğrulama';

  @override
  String get blurRadius => 'Bulanıklık Yarıçapı';

  @override
  String get bright => 'Açık';

  @override
  String get cancel => 'İptal';

  @override
  String get checkUpdate => 'Güncellemeleri kontrol et';

  @override
  String get clear => 'Temizle';

  @override
  String get click => 'Tıkla';

  @override
  String get clipboard => 'Pano';

  @override
  String get close => 'Kapat';

  @override
  String get content => 'İçerik';

  @override
  String get copy => 'Kopyala';

  @override
  String get custom => 'Özel';

  @override
  String get cut => 'Kes';

  @override
  String get dark => 'Koyu';

  @override
  String get day => 'gün';

  @override
  String delFmt(Object id, Object type) {
    return '$type ($id) silinsin mi?';
  }

  @override
  String get delay => 'Gecikme';

  @override
  String get delete => 'Sil';

  @override
  String get device => 'Cihaz';

  @override
  String get disabled => 'Devre dışı';

  @override
  String get doc => 'Dokümantasyon';

  @override
  String get dontShowAgain => 'Bir daha gösterme';

  @override
  String get download => 'İndir';

  @override
  String get duration => 'Süre';

  @override
  String get edit => 'Düzenle';

  @override
  String get editor => 'Düzenleyici';

  @override
  String get empty => 'Boş';

  @override
  String get error => 'Hata';

  @override
  String get example => 'Örnek';

  @override
  String get execute => 'Yürüt';

  @override
  String get exit => 'Çıkış';

  @override
  String get exitConfirmTip => 'Çıkmak için tekrar geri basın';

  @override
  String get exitDirectly => 'Doğrudan çık';

  @override
  String get export => 'Dışa aktar';

  @override
  String get fail => 'Başarısız';

  @override
  String get feedback => 'Geri bildirim';

  @override
  String get file => 'Dosya';

  @override
  String get fold => 'Katmak';

  @override
  String get folder => 'Klasör';

  @override
  String get font => 'Yazı Tipi';

  @override
  String get found => 'Bulundu';

  @override
  String get hideTitleBar => 'Başlık çubuğunu gizle';

  @override
  String get hour => 'saat';

  @override
  String get image => 'Resim';

  @override
  String get import => 'İçe Aktar';

  @override
  String get init => 'Başlat';

  @override
  String get key => 'Anahtar';

  @override
  String get language => 'Dil';

  @override
  String get license => 'Lisans';

  @override
  String get log => 'Kayıt';

  @override
  String get login => 'Giriş yap';

  @override
  String get loginTip => 'Kayıt gerekmez, ücretsiz kullanım.';

  @override
  String get logout => 'Çıkış yap';

  @override
  String get manual => 'Kılavuz';

  @override
  String get migrateCfg => 'Yapılandırma geçişi';

  @override
  String get migrateCfgTip => 'Gerekli yeni yapılandırmaya uyum sağlamak için';

  @override
  String get minute => 'dakika';

  @override
  String get moveDown => 'Aşağı Taşı';

  @override
  String get moveUp => 'Yukarı Taşı';

  @override
  String get name => 'Ad';

  @override
  String get network => 'Ağ';

  @override
  String get next => 'Sonraki';

  @override
  String notExistFmt(Object file) {
    return '$file mevcut değil';
  }

  @override
  String get note => 'Not';

  @override
  String get ok => 'Tamam';

  @override
  String get opacity => 'Opaklık';

  @override
  String get open => 'Aç';

  @override
  String get paste => 'Yapıştır';

  @override
  String get path => 'Yol';

  @override
  String get preview => 'Önizleme';

  @override
  String get previous => 'Önceki';

  @override
  String get primaryColorSeed => 'Ana renk';

  @override
  String get pwd => 'Şifre';

  @override
  String get pwdTip =>
      'Uzunluk 6-32, İngilizce harfler, rakamlar ve noktalama işaretleri olabilir';

  @override
  String get redo => 'Yeniden Yap';

  @override
  String get refresh => 'Yenile';

  @override
  String get register => 'Kaydol';

  @override
  String get rename => 'Yeniden adlandır';

  @override
  String get replace => 'Değiştir';

  @override
  String get replaceAll => 'Tümünü değiştir';

  @override
  String get reset => 'Sıfırla';

  @override
  String get restore => 'Geri Yükleme';

  @override
  String get result => 'Sonuç';

  @override
  String get retry => 'Yeniden Dene';

  @override
  String get save => 'Kaydet';

  @override
  String get search => 'Ara';

  @override
  String get second => 'saniye';

  @override
  String get select => 'Seç';

  @override
  String get setting => 'Ayarlar';

  @override
  String get share => 'Paylaş';

  @override
  String get size => 'Boyut';

  @override
  String sizeTooLargeOnlyPrefix(Object bytes) {
    return 'İçerik çok büyük, yalnızca ilk $bytes gösteriliyor';
  }

  @override
  String get start => 'Başlat';

  @override
  String get stop => 'Durdur';

  @override
  String get success => 'Başarılı';

  @override
  String get switch_ => 'Geçiş';

  @override
  String get switcher => 'Değiştirici';

  @override
  String get sync => 'Senkronize et';

  @override
  String get system => 'Sistem';

  @override
  String get tag => 'Etiket';

  @override
  String get tapToAuth => 'Doğrulamak için dokunun';

  @override
  String get themeMode => 'Tema modu';

  @override
  String get thinking => 'Düşünüyor';

  @override
  String get timeout => 'Zaman Aşımı';

  @override
  String get undo => 'Geri Al';

  @override
  String get unknown => 'Bilinmiyor';

  @override
  String get unsupported => 'Desteklenmiyor';

  @override
  String get update => 'Güncelle';

  @override
  String get upload => 'Yükle';

  @override
  String get user => 'Kullanıcı';

  @override
  String get value => 'Değer';

  @override
  String versionHasUpdate(Object build) {
    return 'Bulundu: v1.0.$build, güncellemek için tıklayın';
  }

  @override
  String versionUnknownUpdate(Object build) {
    return 'Mevcut: v1.0.$build, güncellemeleri kontrol etmek için tıklayın';
  }

  @override
  String versionUpdated(Object build) {
    return 'Mevcut: v1.0.$build, güncel';
  }

  @override
  String get yesterday => 'Dün';

  @override
  String get addr => 'Adres';

  @override
  String get available => 'Mevcut';

  @override
  String get convert => 'Dönüştür';

  @override
  String get experimentalFeature => 'Deneysel Özellik';

  @override
  String get foregroundService => 'Önplan Hizmeti';

  @override
  String get goto => 'Git';

  @override
  String get invalid => 'Geçersiz';

  @override
  String get valid => 'Geçerli';

  @override
  String get max => 'Maksimum';

  @override
  String get min => 'Minimum';

  @override
  String get more => 'Daha fazla';

  @override
  String get milliseconds => 'Milisaniye';

  @override
  String get permission => 'İzin';

  @override
  String get read => 'Oku';

  @override
  String get write => 'Yaz';

  @override
  String get done => 'Tamam';

  @override
  String get speed => 'Hız';

  @override
  String get stat => 'İstatistik';

  @override
  String get time => 'Zaman';

  @override
  String get times => 'Kez';

  @override
  String get used => 'Kullanıldı';

  @override
  String get view => 'Görüntüle';
}
