// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'lib_l10n.dart';

// ignore_for_file: type=lint

/// The translations for Dutch Flemish (`nl`).
class LibLocalizationsNl extends LibLocalizations {
  LibLocalizationsNl([String locale = 'nl']) : super(locale);

  @override
  String get about => 'Over';

  @override
  String actionAndAction(Object action1, Object action2) {
    return '$action1 en dan $action2?';
  }

  @override
  String get add => 'Toevoegen';

  @override
  String get all => 'Alle';

  @override
  String get anonLoseDataTip =>
      'Momenteel anoniem ingelogd, verdere handelingen zullen leiden tot gegevensverlies.';

  @override
  String get app => 'Applicatie';

  @override
  String askContinue(Object msg) {
    return '$msg. Doorgaan?';
  }

  @override
  String get attention => 'Aandacht';

  @override
  String get authRequired => 'Authenticatie vereist';

  @override
  String get auto => 'Auto';

  @override
  String get background => 'Achtergrond';

  @override
  String get backup => 'Back-up';

  @override
  String get bioAuth => 'Biometrische authenticatie';

  @override
  String get blurRadius => 'Vervagingradius';

  @override
  String get bright => 'Helder';

  @override
  String get cancel => 'Annuleren';

  @override
  String get checkUpdate => 'Controleren op updates';

  @override
  String get clear => 'Leegmaken';

  @override
  String get click => 'Klik';

  @override
  String get clipboard => 'Klembord';

  @override
  String get close => 'Sluiten';

  @override
  String get content => 'Inhoud';

  @override
  String get copy => 'Kopiëren';

  @override
  String get custom => 'Aangepast';

  @override
  String get cut => 'Knippen';

  @override
  String get dark => 'Donker';

  @override
  String get day => 'Dagen';

  @override
  String delFmt(Object id, Object type) {
    return '$type ($id) echt verwijderen?';
  }

  @override
  String get delay => 'Vertraging';

  @override
  String get delete => 'Verwijderen';

  @override
  String get device => 'Apparaat';

  @override
  String get disabled => 'Uitgeschakeld';

  @override
  String get doc => 'Documentatie';

  @override
  String get dontShowAgain => 'Niet meer tonen';

  @override
  String get download => 'Downloaden';

  @override
  String get duration => 'Duur';

  @override
  String get edit => 'Bewerken';

  @override
  String get editor => 'Editor';

  @override
  String get empty => 'Leeg';

  @override
  String get error => 'Fout';

  @override
  String get example => 'Voorbeeld';

  @override
  String get execute => 'Uitvoeren';

  @override
  String get exit => 'Afsluiten';

  @override
  String get exitConfirmTip => 'Druk nogmaals op terug om te sluiten';

  @override
  String get exitDirectly => 'Direct afsluiten';

  @override
  String get export => 'Exporteren';

  @override
  String get fail => 'Mislukt';

  @override
  String get feedback => 'Feedback';

  @override
  String get file => 'Bestand';

  @override
  String get fold => 'Invouwen';

  @override
  String get folder => 'Map';

  @override
  String get font => 'Lettertype';

  @override
  String get found => 'Gevonden';

  @override
  String get hideTitleBar => 'Titelbalk verbergen';

  @override
  String get hour => 'Uren';

  @override
  String get image => 'Afbeelding';

  @override
  String get import => 'Importeren';

  @override
  String get init => 'Initialiseren';

  @override
  String get key => 'Sleutel';

  @override
  String get language => 'Taal';

  @override
  String get license => 'Licentie';

  @override
  String get log => 'Logboek';

  @override
  String get login => 'Inloggen';

  @override
  String get loginTip => 'Geen registratie vereist, gratis te gebruiken.';

  @override
  String get logout => 'Uitloggen';

  @override
  String get manual => 'Handleiding';

  @override
  String get migrateCfg => 'Configuratiemigratie';

  @override
  String get migrateCfgTip =>
      'Om aan te passen aan de vereiste nieuwe configuratie';

  @override
  String get minute => 'Minuten';

  @override
  String get moveDown => 'Omlaag';

  @override
  String get moveUp => 'Omhoog';

  @override
  String get name => 'Naam';

  @override
  String get network => 'Netwerk';

  @override
  String get next => 'Volgende';

  @override
  String notExistFmt(Object file) {
    return '$file bestaat niet';
  }

  @override
  String get note => 'Opmerking';

  @override
  String get ok => 'Goed';

  @override
  String get opacity => 'Transparantie';

  @override
  String get open => 'Openen';

  @override
  String get paste => 'Plakken';

  @override
  String get path => 'Pad';

  @override
  String get preview => 'Voorbeeld';

  @override
  String get previous => 'Vorige';

  @override
  String get primaryColorSeed => 'Basiskleur';

  @override
  String get pwd => 'Wachtwoord';

  @override
  String get pwdTip =>
      'Lengte 6-32, kan Engelse letters, cijfers en leestekens bevatten';

  @override
  String get redo => 'Opnieuw';

  @override
  String get refresh => 'Vernieuwen';

  @override
  String get register => 'Registreren';

  @override
  String get rename => 'Hernoemen';

  @override
  String get replace => 'Vervangen';

  @override
  String get replaceAll => 'Alles vervangen';

  @override
  String get reset => 'Reset';

  @override
  String get restore => 'Herstellen';

  @override
  String get result => 'Resultaat';

  @override
  String get retry => 'Opnieuw proberen';

  @override
  String get save => 'Opslaan';

  @override
  String get search => 'Zoeken';

  @override
  String get second => 'Seconden';

  @override
  String get select => 'Selecteren';

  @override
  String get setting => 'Instellingen';

  @override
  String get share => 'Delen';

  @override
  String get size => 'Grootte';

  @override
  String sizeTooLargeOnlyPrefix(Object bytes) {
    return 'Inhoud te groot, alleen de eerste $bytes worden weergegeven';
  }

  @override
  String get start => 'Start';

  @override
  String get stop => 'Stop';

  @override
  String get success => 'Succes';

  @override
  String get switch_ => 'Schakelaar';

  @override
  String get switcher => 'Omschakelaar';

  @override
  String get sync => 'Synchroniseren';

  @override
  String get system => 'Systeem';

  @override
  String get tag => 'Tag';

  @override
  String get tapToAuth => 'Tik om te authentiseren';

  @override
  String get themeMode => 'Themamodus';

  @override
  String get thinking => 'Aan het nadenken';

  @override
  String get timeout => 'Timeout';

  @override
  String get undo => 'Ongedaan maken';

  @override
  String get unknown => 'Onbekend';

  @override
  String get unsupported => 'Niet ondersteund';

  @override
  String get update => 'Bijwerken';

  @override
  String get upload => 'Uploaden';

  @override
  String get user => 'Gebruiker';

  @override
  String get value => 'Waarde';

  @override
  String versionHasUpdate(Object build) {
    return 'Nieuwe versie gevonden: v1.0.$build, tik om bij te werken';
  }

  @override
  String versionUnknownUpdate(Object build) {
    return 'Huidige versie: v1.0.$build, tik om te controleren op updates';
  }

  @override
  String versionUpdated(Object build) {
    return 'Huidige versie: v1.0.$build, is al bijgewerkt';
  }

  @override
  String get yesterday => 'Gisteren';

  @override
  String get addr => 'Adres';

  @override
  String get available => 'Beschikbaar';

  @override
  String get convert => 'Converteren';

  @override
  String get experimentalFeature => 'Experimentele functie';

  @override
  String get foregroundService => 'Voorgrondservice';

  @override
  String get goto => 'Ga naar';

  @override
  String get invalid => 'Ongeldig';

  @override
  String get valid => 'Geldig';

  @override
  String get max => 'Maximum';

  @override
  String get min => 'Minimum';

  @override
  String get more => 'Meer';

  @override
  String get milliseconds => 'Milliseconden';

  @override
  String get permission => 'Toestemming';

  @override
  String get read => 'Lezen';

  @override
  String get write => 'Schrijven';

  @override
  String get done => 'Klaar';

  @override
  String get speed => 'Snelheid';

  @override
  String get stat => 'Statistieken';

  @override
  String get time => 'Tijd';

  @override
  String get times => 'Keren';

  @override
  String get used => 'Gebruikt';

  @override
  String get view => 'Bekijken';
}
