// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v22.4.2), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#import "./include/camera_avfoundation/messages.g.h"

#if TARGET_OS_OSX
#import <FlutterMacOS/FlutterMacOS.h>
#else
#import <Flutter/Flutter.h>
#endif

#if !__has_feature(objc_arc)
#error File requires ARC to be enabled.
#endif

static NSArray<id> *wrapResult(id result, FlutterError *error) {
  if (error) {
    return @[
      error.code ?: [NSNull null], error.message ?: [NSNull null], error.details ?: [NSNull null]
    ];
  }
  return @[ result ?: [NSNull null] ];
}

static FlutterError *createConnectionError(NSString *channelName) {
  return [FlutterError
      errorWithCode:@"channel-error"
            message:[NSString stringWithFormat:@"%@/%@/%@",
                                               @"Unable to establish connection on channel: '",
                                               channelName, @"'."]
            details:@""];
}

static id GetNullableObjectAtIndex(NSArray<id> *array, NSInteger key) {
  id result = array[key];
  return (result == [NSNull null]) ? nil : result;
}

@implementation FCPPlatformCameraLensDirectionBox
- (instancetype)initWithValue:(FCPPlatformCameraLensDirection)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformDeviceOrientationBox
- (instancetype)initWithValue:(FCPPlatformDeviceOrientation)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformExposureModeBox
- (instancetype)initWithValue:(FCPPlatformExposureMode)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformFlashModeBox
- (instancetype)initWithValue:(FCPPlatformFlashMode)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformFocusModeBox
- (instancetype)initWithValue:(FCPPlatformFocusMode)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

/// Pigeon version of ImageFileFormat.
@implementation FCPPlatformImageFileFormatBox
- (instancetype)initWithValue:(FCPPlatformImageFileFormat)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformImageFormatGroupBox
- (instancetype)initWithValue:(FCPPlatformImageFormatGroup)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformResolutionPresetBox
- (instancetype)initWithValue:(FCPPlatformResolutionPreset)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@interface FCPPlatformCameraDescription ()
+ (FCPPlatformCameraDescription *)fromList:(NSArray<id> *)list;
+ (nullable FCPPlatformCameraDescription *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface FCPPlatformCameraState ()
+ (FCPPlatformCameraState *)fromList:(NSArray<id> *)list;
+ (nullable FCPPlatformCameraState *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface FCPPlatformMediaSettings ()
+ (FCPPlatformMediaSettings *)fromList:(NSArray<id> *)list;
+ (nullable FCPPlatformMediaSettings *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface FCPPlatformPoint ()
+ (FCPPlatformPoint *)fromList:(NSArray<id> *)list;
+ (nullable FCPPlatformPoint *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface FCPPlatformSize ()
+ (FCPPlatformSize *)fromList:(NSArray<id> *)list;
+ (nullable FCPPlatformSize *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@implementation FCPPlatformCameraDescription
+ (instancetype)makeWithName:(NSString *)name
               lensDirection:(FCPPlatformCameraLensDirection)lensDirection {
  FCPPlatformCameraDescription *pigeonResult = [[FCPPlatformCameraDescription alloc] init];
  pigeonResult.name = name;
  pigeonResult.lensDirection = lensDirection;
  return pigeonResult;
}
+ (FCPPlatformCameraDescription *)fromList:(NSArray<id> *)list {
  FCPPlatformCameraDescription *pigeonResult = [[FCPPlatformCameraDescription alloc] init];
  pigeonResult.name = GetNullableObjectAtIndex(list, 0);
  FCPPlatformCameraLensDirectionBox *boxedFCPPlatformCameraLensDirection =
      GetNullableObjectAtIndex(list, 1);
  pigeonResult.lensDirection = boxedFCPPlatformCameraLensDirection.value;
  return pigeonResult;
}
+ (nullable FCPPlatformCameraDescription *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FCPPlatformCameraDescription fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.name ?: [NSNull null],
    [[FCPPlatformCameraLensDirectionBox alloc] initWithValue:self.lensDirection],
  ];
}
@end

@implementation FCPPlatformCameraState
+ (instancetype)makeWithPreviewSize:(FCPPlatformSize *)previewSize
                       exposureMode:(FCPPlatformExposureMode)exposureMode
                          focusMode:(FCPPlatformFocusMode)focusMode
             exposurePointSupported:(BOOL)exposurePointSupported
                focusPointSupported:(BOOL)focusPointSupported {
  FCPPlatformCameraState *pigeonResult = [[FCPPlatformCameraState alloc] init];
  pigeonResult.previewSize = previewSize;
  pigeonResult.exposureMode = exposureMode;
  pigeonResult.focusMode = focusMode;
  pigeonResult.exposurePointSupported = exposurePointSupported;
  pigeonResult.focusPointSupported = focusPointSupported;
  return pigeonResult;
}
+ (FCPPlatformCameraState *)fromList:(NSArray<id> *)list {
  FCPPlatformCameraState *pigeonResult = [[FCPPlatformCameraState alloc] init];
  pigeonResult.previewSize = GetNullableObjectAtIndex(list, 0);
  FCPPlatformExposureModeBox *boxedFCPPlatformExposureMode = GetNullableObjectAtIndex(list, 1);
  pigeonResult.exposureMode = boxedFCPPlatformExposureMode.value;
  FCPPlatformFocusModeBox *boxedFCPPlatformFocusMode = GetNullableObjectAtIndex(list, 2);
  pigeonResult.focusMode = boxedFCPPlatformFocusMode.value;
  pigeonResult.exposurePointSupported = [GetNullableObjectAtIndex(list, 3) boolValue];
  pigeonResult.focusPointSupported = [GetNullableObjectAtIndex(list, 4) boolValue];
  return pigeonResult;
}
+ (nullable FCPPlatformCameraState *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FCPPlatformCameraState fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.previewSize ?: [NSNull null],
    [[FCPPlatformExposureModeBox alloc] initWithValue:self.exposureMode],
    [[FCPPlatformFocusModeBox alloc] initWithValue:self.focusMode],
    @(self.exposurePointSupported),
    @(self.focusPointSupported),
  ];
}
@end

@implementation FCPPlatformMediaSettings
+ (instancetype)makeWithResolutionPreset:(FCPPlatformResolutionPreset)resolutionPreset
                         framesPerSecond:(nullable NSNumber *)framesPerSecond
                            videoBitrate:(nullable NSNumber *)videoBitrate
                            audioBitrate:(nullable NSNumber *)audioBitrate
                             enableAudio:(BOOL)enableAudio {
  FCPPlatformMediaSettings *pigeonResult = [[FCPPlatformMediaSettings alloc] init];
  pigeonResult.resolutionPreset = resolutionPreset;
  pigeonResult.framesPerSecond = framesPerSecond;
  pigeonResult.videoBitrate = videoBitrate;
  pigeonResult.audioBitrate = audioBitrate;
  pigeonResult.enableAudio = enableAudio;
  return pigeonResult;
}
+ (FCPPlatformMediaSettings *)fromList:(NSArray<id> *)list {
  FCPPlatformMediaSettings *pigeonResult = [[FCPPlatformMediaSettings alloc] init];
  FCPPlatformResolutionPresetBox *boxedFCPPlatformResolutionPreset =
      GetNullableObjectAtIndex(list, 0);
  pigeonResult.resolutionPreset = boxedFCPPlatformResolutionPreset.value;
  pigeonResult.framesPerSecond = GetNullableObjectAtIndex(list, 1);
  pigeonResult.videoBitrate = GetNullableObjectAtIndex(list, 2);
  pigeonResult.audioBitrate = GetNullableObjectAtIndex(list, 3);
  pigeonResult.enableAudio = [GetNullableObjectAtIndex(list, 4) boolValue];
  return pigeonResult;
}
+ (nullable FCPPlatformMediaSettings *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FCPPlatformMediaSettings fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    [[FCPPlatformResolutionPresetBox alloc] initWithValue:self.resolutionPreset],
    self.framesPerSecond ?: [NSNull null],
    self.videoBitrate ?: [NSNull null],
    self.audioBitrate ?: [NSNull null],
    @(self.enableAudio),
  ];
}
@end

@implementation FCPPlatformPoint
+ (instancetype)makeWithX:(double)x y:(double)y {
  FCPPlatformPoint *pigeonResult = [[FCPPlatformPoint alloc] init];
  pigeonResult.x = x;
  pigeonResult.y = y;
  return pigeonResult;
}
+ (FCPPlatformPoint *)fromList:(NSArray<id> *)list {
  FCPPlatformPoint *pigeonResult = [[FCPPlatformPoint alloc] init];
  pigeonResult.x = [GetNullableObjectAtIndex(list, 0) doubleValue];
  pigeonResult.y = [GetNullableObjectAtIndex(list, 1) doubleValue];
  return pigeonResult;
}
+ (nullable FCPPlatformPoint *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FCPPlatformPoint fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    @(self.x),
    @(self.y),
  ];
}
@end

@implementation FCPPlatformSize
+ (instancetype)makeWithWidth:(double)width height:(double)height {
  FCPPlatformSize *pigeonResult = [[FCPPlatformSize alloc] init];
  pigeonResult.width = width;
  pigeonResult.height = height;
  return pigeonResult;
}
+ (FCPPlatformSize *)fromList:(NSArray<id> *)list {
  FCPPlatformSize *pigeonResult = [[FCPPlatformSize alloc] init];
  pigeonResult.width = [GetNullableObjectAtIndex(list, 0) doubleValue];
  pigeonResult.height = [GetNullableObjectAtIndex(list, 1) doubleValue];
  return pigeonResult;
}
+ (nullable FCPPlatformSize *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FCPPlatformSize fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    @(self.width),
    @(self.height),
  ];
}
@end

@interface FCPMessagesPigeonCodecReader : FlutterStandardReader
@end
@implementation FCPMessagesPigeonCodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 129: {
      NSNumber *enumAsNumber = [self readValue];
      return enumAsNumber == nil ? nil
                                 : [[FCPPlatformCameraLensDirectionBox alloc]
                                       initWithValue:[enumAsNumber integerValue]];
    }
    case 130: {
      NSNumber *enumAsNumber = [self readValue];
      return enumAsNumber == nil ? nil
                                 : [[FCPPlatformDeviceOrientationBox alloc]
                                       initWithValue:[enumAsNumber integerValue]];
    }
    case 131: {
      NSNumber *enumAsNumber = [self readValue];
      return enumAsNumber == nil
                 ? nil
                 : [[FCPPlatformExposureModeBox alloc] initWithValue:[enumAsNumber integerValue]];
    }
    case 132: {
      NSNumber *enumAsNumber = [self readValue];
      return enumAsNumber == nil
                 ? nil
                 : [[FCPPlatformFlashModeBox alloc] initWithValue:[enumAsNumber integerValue]];
    }
    case 133: {
      NSNumber *enumAsNumber = [self readValue];
      return enumAsNumber == nil
                 ? nil
                 : [[FCPPlatformFocusModeBox alloc] initWithValue:[enumAsNumber integerValue]];
    }
    case 134: {
      NSNumber *enumAsNumber = [self readValue];
      return enumAsNumber == nil ? nil
                                 : [[FCPPlatformImageFileFormatBox alloc]
                                       initWithValue:[enumAsNumber integerValue]];
    }
    case 135: {
      NSNumber *enumAsNumber = [self readValue];
      return enumAsNumber == nil ? nil
                                 : [[FCPPlatformImageFormatGroupBox alloc]
                                       initWithValue:[enumAsNumber integerValue]];
    }
    case 136: {
      NSNumber *enumAsNumber = [self readValue];
      return enumAsNumber == nil ? nil
                                 : [[FCPPlatformResolutionPresetBox alloc]
                                       initWithValue:[enumAsNumber integerValue]];
    }
    case 137:
      return [FCPPlatformCameraDescription fromList:[self readValue]];
    case 138:
      return [FCPPlatformCameraState fromList:[self readValue]];
    case 139:
      return [FCPPlatformMediaSettings fromList:[self readValue]];
    case 140:
      return [FCPPlatformPoint fromList:[self readValue]];
    case 141:
      return [FCPPlatformSize fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface FCPMessagesPigeonCodecWriter : FlutterStandardWriter
@end
@implementation FCPMessagesPigeonCodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[FCPPlatformCameraLensDirectionBox class]]) {
    FCPPlatformCameraLensDirectionBox *box = (FCPPlatformCameraLensDirectionBox *)value;
    [self writeByte:129];
    [self writeValue:(value == nil ? [NSNull null] : [NSNumber numberWithInteger:box.value])];
  } else if ([value isKindOfClass:[FCPPlatformDeviceOrientationBox class]]) {
    FCPPlatformDeviceOrientationBox *box = (FCPPlatformDeviceOrientationBox *)value;
    [self writeByte:130];
    [self writeValue:(value == nil ? [NSNull null] : [NSNumber numberWithInteger:box.value])];
  } else if ([value isKindOfClass:[FCPPlatformExposureModeBox class]]) {
    FCPPlatformExposureModeBox *box = (FCPPlatformExposureModeBox *)value;
    [self writeByte:131];
    [self writeValue:(value == nil ? [NSNull null] : [NSNumber numberWithInteger:box.value])];
  } else if ([value isKindOfClass:[FCPPlatformFlashModeBox class]]) {
    FCPPlatformFlashModeBox *box = (FCPPlatformFlashModeBox *)value;
    [self writeByte:132];
    [self writeValue:(value == nil ? [NSNull null] : [NSNumber numberWithInteger:box.value])];
  } else if ([value isKindOfClass:[FCPPlatformFocusModeBox class]]) {
    FCPPlatformFocusModeBox *box = (FCPPlatformFocusModeBox *)value;
    [self writeByte:133];
    [self writeValue:(value == nil ? [NSNull null] : [NSNumber numberWithInteger:box.value])];
  } else if ([value isKindOfClass:[FCPPlatformImageFileFormatBox class]]) {
    FCPPlatformImageFileFormatBox *box = (FCPPlatformImageFileFormatBox *)value;
    [self writeByte:134];
    [self writeValue:(value == nil ? [NSNull null] : [NSNumber numberWithInteger:box.value])];
  } else if ([value isKindOfClass:[FCPPlatformImageFormatGroupBox class]]) {
    FCPPlatformImageFormatGroupBox *box = (FCPPlatformImageFormatGroupBox *)value;
    [self writeByte:135];
    [self writeValue:(value == nil ? [NSNull null] : [NSNumber numberWithInteger:box.value])];
  } else if ([value isKindOfClass:[FCPPlatformResolutionPresetBox class]]) {
    FCPPlatformResolutionPresetBox *box = (FCPPlatformResolutionPresetBox *)value;
    [self writeByte:136];
    [self writeValue:(value == nil ? [NSNull null] : [NSNumber numberWithInteger:box.value])];
  } else if ([value isKindOfClass:[FCPPlatformCameraDescription class]]) {
    [self writeByte:137];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FCPPlatformCameraState class]]) {
    [self writeByte:138];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FCPPlatformMediaSettings class]]) {
    [self writeByte:139];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FCPPlatformPoint class]]) {
    [self writeByte:140];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FCPPlatformSize class]]) {
    [self writeByte:141];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface FCPMessagesPigeonCodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation FCPMessagesPigeonCodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[FCPMessagesPigeonCodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[FCPMessagesPigeonCodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *FCPGetMessagesCodec(void) {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    FCPMessagesPigeonCodecReaderWriter *readerWriter =
        [[FCPMessagesPigeonCodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}
void SetUpFCPCameraApi(id<FlutterBinaryMessenger> binaryMessenger, NSObject<FCPCameraApi> *api) {
  SetUpFCPCameraApiWithSuffix(binaryMessenger, api, @"");
}

void SetUpFCPCameraApiWithSuffix(id<FlutterBinaryMessenger> binaryMessenger,
                                 NSObject<FCPCameraApi> *api, NSString *messageChannelSuffix) {
  messageChannelSuffix = messageChannelSuffix.length > 0
                             ? [NSString stringWithFormat:@".%@", messageChannelSuffix]
                             : @"";
  /// Returns the list of available cameras.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.getAvailableCameras",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(availableCamerasWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(availableCamerasWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api availableCamerasWithCompletion:^(
                 NSArray<FCPPlatformCameraDescription *> *_Nullable output,
                 FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Create a new camera with the given settings, and returns its ID.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:
                                      @"%@%@",
                                      @"dev.flutter.pigeon.camera_avfoundation.CameraApi.create",
                                      messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(createCameraWithName:settings:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(createCameraWithName:settings:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        NSString *arg_cameraName = GetNullableObjectAtIndex(args, 0);
        FCPPlatformMediaSettings *arg_settings = GetNullableObjectAtIndex(args, 1);
        [api createCameraWithName:arg_cameraName
                         settings:arg_settings
                       completion:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
                         callback(wrapResult(output, error));
                       }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Initializes the camera with the given ID.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:
               [NSString
                   stringWithFormat:@"%@%@",
                                    @"dev.flutter.pigeon.camera_avfoundation.CameraApi.initialize",
                                    messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(initializeCamera:withImageFormat:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(initializeCamera:withImageFormat:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        NSInteger arg_cameraId = [GetNullableObjectAtIndex(args, 0) integerValue];
        FCPPlatformImageFormatGroupBox *boxedFCPPlatformImageFormatGroup =
            GetNullableObjectAtIndex(args, 1);
        FCPPlatformImageFormatGroup arg_imageFormat = boxedFCPPlatformImageFormatGroup.value;
        [api initializeCamera:arg_cameraId
              withImageFormat:arg_imageFormat
                   completion:^(FlutterError *_Nullable error) {
                     callback(wrapResult(nil, error));
                   }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Begins streaming frames from the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.startImageStream",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(startImageStreamWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(startImageStreamWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api startImageStreamWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Stops streaming frames from the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.stopImageStream",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(stopImageStreamWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(stopImageStreamWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api stopImageStreamWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Called by the Dart side of the plugin when it has received the last image
  /// frame sent.
  ///
  /// This is used to throttle sending frames across the channel.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.receivedImageStreamData",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(receivedImageStreamDataWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(receivedImageStreamDataWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api receivedImageStreamDataWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Indicates that the given camera is no longer being used on the Dart side,
  /// and any associated resources can be cleaned up.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:
                                      @"%@%@",
                                      @"dev.flutter.pigeon.camera_avfoundation.CameraApi.dispose",
                                      messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(disposeCamera:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(disposeCamera:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        NSInteger arg_cameraId = [GetNullableObjectAtIndex(args, 0) integerValue];
        [api disposeCamera:arg_cameraId
                completion:^(FlutterError *_Nullable error) {
                  callback(wrapResult(nil, error));
                }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Locks the camera capture to the current device orientation.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.lockCaptureOrientation",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(lockCaptureOrientation:completion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(lockCaptureOrientation:completion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FCPPlatformDeviceOrientationBox *boxedFCPPlatformDeviceOrientation =
            GetNullableObjectAtIndex(args, 0);
        FCPPlatformDeviceOrientation arg_orientation = boxedFCPPlatformDeviceOrientation.value;
        [api lockCaptureOrientation:arg_orientation
                         completion:^(FlutterError *_Nullable error) {
                           callback(wrapResult(nil, error));
                         }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Unlocks camera capture orientation, allowing it to automatically adapt to
  /// device orientation.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.unlockCaptureOrientation",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(unlockCaptureOrientationWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(unlockCaptureOrientationWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api unlockCaptureOrientationWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Takes a picture with the current settings, and returns the path to the
  /// resulting file.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:
               [NSString
                   stringWithFormat:@"%@%@",
                                    @"dev.flutter.pigeon.camera_avfoundation.CameraApi.takePicture",
                                    messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(takePictureWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(takePictureWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api
            takePictureWithCompletion:^(NSString *_Nullable output, FlutterError *_Nullable error) {
              callback(wrapResult(output, error));
            }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Does any preprocessing necessary before beginning to record video.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.prepareForVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(prepareForVideoRecordingWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(prepareForVideoRecordingWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api prepareForVideoRecordingWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Begins recording video, optionally enabling streaming to Dart at the same
  /// time.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.startVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startVideoRecordingWithStreaming:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(startVideoRecordingWithStreaming:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BOOL arg_enableStream = [GetNullableObjectAtIndex(args, 0) boolValue];
        [api startVideoRecordingWithStreaming:arg_enableStream
                                   completion:^(FlutterError *_Nullable error) {
                                     callback(wrapResult(nil, error));
                                   }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Stops recording video, and results the path to the resulting file.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.stopVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(stopVideoRecordingWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(stopVideoRecordingWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api stopVideoRecordingWithCompletion:^(NSString *_Nullable output,
                                                FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Pauses video recording.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.pauseVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(pauseVideoRecordingWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(pauseVideoRecordingWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api pauseVideoRecordingWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Resumes a previously paused video recording.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.resumeVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumeVideoRecordingWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(resumeVideoRecordingWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api resumeVideoRecordingWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Switches the camera to the given flash mode.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setFlashMode",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setFlashMode:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setFlashMode:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FCPPlatformFlashModeBox *boxedFCPPlatformFlashMode = GetNullableObjectAtIndex(args, 0);
        FCPPlatformFlashMode arg_mode = boxedFCPPlatformFlashMode.value;
        [api setFlashMode:arg_mode
               completion:^(FlutterError *_Nullable error) {
                 callback(wrapResult(nil, error));
               }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Switches the camera to the given exposure mode.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setExposureMode",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setExposureMode:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setExposureMode:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FCPPlatformExposureModeBox *boxedFCPPlatformExposureMode =
            GetNullableObjectAtIndex(args, 0);
        FCPPlatformExposureMode arg_mode = boxedFCPPlatformExposureMode.value;
        [api setExposureMode:arg_mode
                  completion:^(FlutterError *_Nullable error) {
                    callback(wrapResult(nil, error));
                  }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Anchors auto-exposure to the given point in (0,1) coordinate space.
  ///
  /// A null value resets to the default exposure point.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.setExposurePoint",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setExposurePoint:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setExposurePoint:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FCPPlatformPoint *arg_point = GetNullableObjectAtIndex(args, 0);
        [api setExposurePoint:arg_point
                   completion:^(FlutterError *_Nullable error) {
                     callback(wrapResult(nil, error));
                   }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Returns the minimum exposure offset supported by the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.getMinExposureOffset",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getMinimumExposureOffset:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(getMinimumExposureOffset:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api getMinimumExposureOffset:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Returns the maximum exposure offset supported by the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.getMaxExposureOffset",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getMaximumExposureOffset:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(getMaximumExposureOffset:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api getMaximumExposureOffset:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Sets the exposure offset manually to the given value.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.setExposureOffset",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(setExposureOffset:completion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(setExposureOffset:completion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        double arg_offset = [GetNullableObjectAtIndex(args, 0) doubleValue];
        [api setExposureOffset:arg_offset
                    completion:^(FlutterError *_Nullable error) {
                      callback(wrapResult(nil, error));
                    }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Switches the camera to the given focus mode.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setFocusMode",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setFocusMode:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setFocusMode:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FCPPlatformFocusModeBox *boxedFCPPlatformFocusMode = GetNullableObjectAtIndex(args, 0);
        FCPPlatformFocusMode arg_mode = boxedFCPPlatformFocusMode.value;
        [api setFocusMode:arg_mode
               completion:^(FlutterError *_Nullable error) {
                 callback(wrapResult(nil, error));
               }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Anchors auto-focus to the given point in (0,1) coordinate space.
  ///
  /// A null value resets to the default focus point.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setFocusPoint",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setFocusPoint:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setFocusPoint:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FCPPlatformPoint *arg_point = GetNullableObjectAtIndex(args, 0);
        [api setFocusPoint:arg_point
                completion:^(FlutterError *_Nullable error) {
                  callback(wrapResult(nil, error));
                }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Returns the minimum zoom level supported by the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.getMinZoomLevel",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getMinimumZoomLevel:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(getMinimumZoomLevel:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api getMinimumZoomLevel:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Returns the maximum zoom level supported by the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.getMaxZoomLevel",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getMaximumZoomLevel:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(getMaximumZoomLevel:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api getMaximumZoomLevel:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Sets the zoom factor.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setZoomLevel",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setZoomLevel:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setZoomLevel:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        double arg_zoom = [GetNullableObjectAtIndex(args, 0) doubleValue];
        [api setZoomLevel:arg_zoom
               completion:^(FlutterError *_Nullable error) {
                 callback(wrapResult(nil, error));
               }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Pauses streaming of preview frames.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.pausePreview",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(pausePreviewWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(pausePreviewWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api pausePreviewWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Resumes a previously paused preview stream.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.resumePreview",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumePreviewWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(resumePreviewWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api resumePreviewWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Changes the camera used while recording video.
  ///
  /// This should only be called while video recording is active.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.updateDescriptionWhileRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(updateDescriptionWhileRecordingCameraName:
                                                                                 completion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(updateDescriptionWhileRecordingCameraName:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        NSString *arg_cameraName = GetNullableObjectAtIndex(args, 0);
        [api updateDescriptionWhileRecordingCameraName:arg_cameraName
                                            completion:^(FlutterError *_Nullable error) {
                                              callback(wrapResult(nil, error));
                                            }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Sets the file format used for taking pictures.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.setImageFileFormat",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPGetMessagesCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(setImageFileFormat:completion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(setImageFileFormat:completion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FCPPlatformImageFileFormatBox *boxedFCPPlatformImageFileFormat =
            GetNullableObjectAtIndex(args, 0);
        FCPPlatformImageFileFormat arg_format = boxedFCPPlatformImageFileFormat.value;
        [api setImageFileFormat:arg_format
                     completion:^(FlutterError *_Nullable error) {
                       callback(wrapResult(nil, error));
                     }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
@interface FCPCameraGlobalEventApi ()
@property(nonatomic, strong) NSObject<FlutterBinaryMessenger> *binaryMessenger;
@property(nonatomic, strong) NSString *messageChannelSuffix;
@end

@implementation FCPCameraGlobalEventApi

- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger {
  return [self initWithBinaryMessenger:binaryMessenger messageChannelSuffix:@""];
}
- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger
                   messageChannelSuffix:(nullable NSString *)messageChannelSuffix {
  self = [self init];
  if (self) {
    _binaryMessenger = binaryMessenger;
    _messageChannelSuffix = [messageChannelSuffix length] == 0
                                ? @""
                                : [NSString stringWithFormat:@".%@", messageChannelSuffix];
  }
  return self;
}
- (void)deviceOrientationChangedOrientation:(FCPPlatformDeviceOrientation)arg_orientation
                                 completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString
      stringWithFormat:
          @"%@%@",
          @"dev.flutter.pigeon.camera_avfoundation.CameraGlobalEventApi.deviceOrientationChanged",
          _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
      [FlutterBasicMessageChannel messageChannelWithName:channelName
                                         binaryMessenger:self.binaryMessenger
                                                   codec:FCPGetMessagesCodec()];
  [channel sendMessage:@[ [[FCPPlatformDeviceOrientationBox alloc] initWithValue:arg_orientation] ]
                 reply:^(NSArray<id> *reply) {
                   if (reply != nil) {
                     if (reply.count > 1) {
                       completion([FlutterError errorWithCode:reply[0]
                                                      message:reply[1]
                                                      details:reply[2]]);
                     } else {
                       completion(nil);
                     }
                   } else {
                     completion(createConnectionError(channelName));
                   }
                 }];
}
@end

@interface FCPCameraEventApi ()
@property(nonatomic, strong) NSObject<FlutterBinaryMessenger> *binaryMessenger;
@property(nonatomic, strong) NSString *messageChannelSuffix;
@end

@implementation FCPCameraEventApi

- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger {
  return [self initWithBinaryMessenger:binaryMessenger messageChannelSuffix:@""];
}
- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger
                   messageChannelSuffix:(nullable NSString *)messageChannelSuffix {
  self = [self init];
  if (self) {
    _binaryMessenger = binaryMessenger;
    _messageChannelSuffix = [messageChannelSuffix length] == 0
                                ? @""
                                : [NSString stringWithFormat:@".%@", messageChannelSuffix];
  }
  return self;
}
- (void)initializedWithState:(FCPPlatformCameraState *)arg_initialState
                  completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString
      stringWithFormat:@"%@%@",
                       @"dev.flutter.pigeon.camera_avfoundation.CameraEventApi.initialized",
                       _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
      [FlutterBasicMessageChannel messageChannelWithName:channelName
                                         binaryMessenger:self.binaryMessenger
                                                   codec:FCPGetMessagesCodec()];
  [channel sendMessage:@[ arg_initialState ?: [NSNull null] ]
                 reply:^(NSArray<id> *reply) {
                   if (reply != nil) {
                     if (reply.count > 1) {
                       completion([FlutterError errorWithCode:reply[0]
                                                      message:reply[1]
                                                      details:reply[2]]);
                     } else {
                       completion(nil);
                     }
                   } else {
                     completion(createConnectionError(channelName));
                   }
                 }];
}
- (void)reportError:(NSString *)arg_message
         completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString
      stringWithFormat:@"%@%@", @"dev.flutter.pigeon.camera_avfoundation.CameraEventApi.error",
                       _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
      [FlutterBasicMessageChannel messageChannelWithName:channelName
                                         binaryMessenger:self.binaryMessenger
                                                   codec:FCPGetMessagesCodec()];
  [channel sendMessage:@[ arg_message ?: [NSNull null] ]
                 reply:^(NSArray<id> *reply) {
                   if (reply != nil) {
                     if (reply.count > 1) {
                       completion([FlutterError errorWithCode:reply[0]
                                                      message:reply[1]
                                                      details:reply[2]]);
                     } else {
                       completion(nil);
                     }
                   } else {
                     completion(createConnectionError(channelName));
                   }
                 }];
}
@end
