/*
 * Copyright 2020 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'package:image/image.dart';
import 'package:test/expect.dart';
import 'package:test/scaffolding.dart';
import 'package:zxing_lib/zxing.dart';

import 'buffered_image_luminance_source.dart';

/// Tests [InvertedLuminanceSource].
void main() {
  test('testInverted', () async {
    final image = Image(width: 2, height: 1, numChannels: 4);
    image
        .map((e) => image.setPixel(e.x, e.y, ColorInt32.rgba(0, 0, 0, 255)))
        .toList();

    image.setPixel(0, 0, ColorInt32.rgba(255, 255, 255, 255));

    final source = BufferedImageLuminanceSource(image);

    expect(source.getRow(0, null), [0xFF, 0]);
    final inverted = InvertedLuminanceSource(source);
    expect(inverted.getRow(0, null), [0, 0xFF]);
  });
}
