/*
 * Copyright 2006 Jeremias Maerki
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'package:test/expect.dart';
import 'package:test/scaffolding.dart';
import 'package:zxing_lib/datamatrix.dart';
import 'package:zxing_lib/zxing.dart';

/// Tests the SymbolInfo class.
void main() {
  test('testSymbolInfo', () {
    SymbolInfo? info = SymbolInfo.lookup(3)!;
    expect(5, info.errorCodewords);
    expect(8, info.matrixWidth);
    expect(8, info.matrixHeight);
    expect(10, info.symbolWidth);
    expect(10, info.symbolHeight);

    info = SymbolInfo.lookup(3, SymbolShapeHint.forceRectangle)!;
    expect(7, info.errorCodewords);
    expect(16, info.matrixWidth);
    expect(6, info.matrixHeight);
    expect(18, info.symbolWidth);
    expect(8, info.symbolHeight);

    info = SymbolInfo.lookup(9)!;
    expect(11, info.errorCodewords);
    expect(14, info.matrixWidth);
    expect(6, info.matrixHeight);
    expect(32, info.symbolWidth);
    expect(8, info.symbolHeight);

    info = SymbolInfo.lookup(9, SymbolShapeHint.forceSquare)!;
    expect(12, info.errorCodewords);
    expect(14, info.matrixWidth);
    expect(14, info.matrixHeight);
    expect(16, info.symbolWidth);
    expect(16, info.symbolHeight);
    expect(
      () => SymbolInfo.lookup(1559),
      throwsArgumentError,
      reason:
          'There\'s no rectangular symbol for more than 1558 data codewords',
    );

    expect(
      () => SymbolInfo.lookup(50, SymbolShapeHint.forceRectangle),
      throwsArgumentError,
      reason: 'There\'s no rectangular symbol for 50 data codewords',
    );

    info = SymbolInfo.lookup(35)!;
    expect(24, info.symbolWidth);
    expect(24, info.symbolHeight);

    final fixedSize = Dimension(26, 26);
    info = SymbolInfo.lookup(
      35,
      SymbolShapeHint.forceNone,
      fixedSize,
      fixedSize,
      false,
    )!;
    expect(26, info.symbolWidth);
    expect(26, info.symbolHeight);

    info = SymbolInfo.lookup(
      45,
      SymbolShapeHint.forceNone,
      fixedSize,
      fixedSize,
      false,
    );
    expect(null, info);

    final minSize = fixedSize;
    final maxSize = Dimension(32, 32);

    info = SymbolInfo.lookup(
      35,
      SymbolShapeHint.forceNone,
      minSize,
      maxSize,
      false,
    )!;
    //assertNotNull(info);
    expect(26, info.symbolWidth);
    expect(26, info.symbolHeight);

    info = SymbolInfo.lookup(
      40,
      SymbolShapeHint.forceNone,
      minSize,
      maxSize,
      false,
    )!;
    //assertNotNull(info);
    expect(26, info.symbolWidth);
    expect(26, info.symbolHeight);

    info = SymbolInfo.lookup(
      45,
      SymbolShapeHint.forceNone,
      minSize,
      maxSize,
      false,
    )!;
    //assertNotNull(info);
    expect(32, info.symbolWidth);
    expect(32, info.symbolHeight);

    info = SymbolInfo.lookup(
      63,
      SymbolShapeHint.forceNone,
      minSize,
      maxSize,
      false,
    );
    expect(null, info);
  });
}
