/// Locale names of Korean
const names = {
  "001": "세계",
  "002": "아프리카",
  "003": "북아메리카",
  "005": "남아메리카(남미)",
  "009": "오세아니아",
  "011": "서부 아프리카",
  "013": "중앙 아메리카",
  "014": "동부 아프리카",
  "015": "북부 아프리카",
  "017": "중부 아프리카",
  "018": "남부 아프리카",
  "019": "아메리카 대륙",
  "021": "북부 아메리카",
  "029": "카리브 제도",
  "030": "동아시아",
  "034": "남아시아",
  "035": "동남아시아",
  "039": "남유럽",
  "053": "오스트랄라시아",
  "054": "멜라네시아",
  "057": "미크로네시아 지역",
  "061": "폴리네시아",
  "142": "아시아",
  "143": "중앙 아시아",
  "145": "서아시아",
  "150": "유럽",
  "151": "동유럽",
  "154": "북유럽",
  "155": "서유럽",
  "202": "사하라 사막 이남 아프리카",
  "419": "라틴 아메리카",
  "AC": "어센션 섬",
  "AD": "안도라",
  "AE": "아랍에미리트",
  "AF": "아프가니스탄",
  "AG": "앤티가 바부다",
  "AI": "앵귈라",
  "AL": "알바니아",
  "AM": "아르메니아",
  "AN": "네덜란드령 안틸레스",
  "AO": "앙골라",
  "AQ": "남극 대륙",
  "AR": "아르헨티나",
  "AS": "아메리칸 사모아",
  "AT": "오스트리아",
  "AU": "오스트레일리아",
  "AW": "아루바",
  "AX": "올란드 제도",
  "AZ": "아제르바이잔",
  "Afak": "아파카 문자",
  "Aghb": "코카시안 알바니아 문자",
  "Arab": "아랍 문자",
  "Aran": "나스탈리크체",
  "Armi": "아랍제국 문자",
  "Armn": "아르메니아 문자",
  "Avst": "아베스타 문자",
  "BA": "보스니아 헤르체고비나",
  "BB": "바베이도스",
  "BD": "방글라데시",
  "BE": "벨기에",
  "BF": "부르키나파소",
  "BG": "불가리아",
  "BH": "바레인",
  "BI": "부룬디",
  "BJ": "베냉",
  "BL": "생바르텔레미",
  "BM": "버뮤다",
  "BN": "브루나이",
  "BO": "볼리비아",
  "BQ": "네덜란드령 카리브",
  "BR": "브라질",
  "BS": "바하마",
  "BT": "부탄",
  "BV": "부베섬",
  "BW": "보츠와나",
  "BY": "벨라루스",
  "BZ": "벨리즈",
  "Bali": "발리 문자",
  "Bamu": "바뭄 문자",
  "Bass": "바사바흐 문자",
  "Batk": "바타크 문자",
  "Beng": "벵골 문자",
  "Blis": "블리스기호 문자",
  "Bopo": "주음부호",
  "Brah": "브라미",
  "Brai": "브라유 점자",
  "Bugi": "부기 문자",
  "Buhd": "부히드 문자",
  "CA": "캐나다",
  "CC": "코코스 제도",
  "CD": "콩고-킨샤사",
  "CF": "중앙 아프리카 공화국",
  "CG": "콩고-브라자빌",
  "CH": "스위스",
  "CI": "코트디부아르",
  "CK": "쿡 제도",
  "CL": "칠레",
  "CM": "카메룬",
  "CN": "중국",
  "CO": "콜롬비아",
  "CP": "클립퍼튼 섬",
  "CR": "코스타리카",
  "CS": "세르비아 및 몬테네그로",
  "CU": "쿠바",
  "CV": "카보베르데",
  "CW": "퀴라소",
  "CX": "크리스마스섬",
  "CY": "키프로스",
  "CZ": "체코",
  "Cakm": "차크마 문자",
  "Cans": "통합 캐나다 토착어",
  "Cari": "카리 문자",
  "Cham": "칸 고어",
  "Cher": "체로키 문자",
  "Cirt": "키르쓰",
  "Copt": "콥트 문자",
  "Cprt": "키프로스 문자",
  "Cyrl": "키릴 문자",
  "Cyrs": "고대교회슬라브어 키릴문자",
  "DE": "독일",
  "DG": "디에고 가르시아",
  "DJ": "지부티",
  "DK": "덴마크",
  "DM": "도미니카",
  "DO": "도미니카 공화국",
  "DZ": "알제리",
  "Deva": "데바나가리 문자",
  "Dsrt": "디저렛 문자",
  "Dupl": "듀플로이안 문자",
  "EA": "세우타 및 멜리야",
  "EC": "에콰도르",
  "EE": "에스토니아",
  "EG": "이집트",
  "EH": "서사하라",
  "ER": "에리트리아",
  "ES": "스페인",
  "ET": "에티오피아",
  "EU": "유럽 연합",
  "EZ": "유로존",
  "Egyd": "고대 이집트 민중문자",
  "Egyh": "고대 이집트 신관문자",
  "Egyp": "고대 이집트 신성문자",
  "Elba": "엘바산 문자",
  "Ethi": "에티오피아 문자",
  "FI": "핀란드",
  "FJ": "피지",
  "FK": "포클랜드 제도",
  "FM": "미크로네시아",
  "FO": "페로 제도",
  "FR": "프랑스",
  "GA": "가봉",
  "GB": "영국",
  "GD": "그레나다",
  "GE": "조지아",
  "GF": "프랑스령 기아나",
  "GG": "건지",
  "GH": "가나",
  "GI": "지브롤터",
  "GL": "그린란드",
  "GM": "감비아",
  "GN": "기니",
  "GP": "과들루프",
  "GQ": "적도 기니",
  "GR": "그리스",
  "GS": "사우스조지아 사우스샌드위치 제도",
  "GT": "과테말라",
  "GU": "괌",
  "GW": "기니비사우",
  "GY": "가이아나",
  "Geok": "그루지야 쿠츠리 문자",
  "Geor": "조지아 문자",
  "Glag": "글라골 문자",
  "Goth": "고트 문자",
  "Gran": "그란타 문자",
  "Grek": "그리스 문자",
  "Gujr": "구자라트 문자",
  "Guru": "구르무키 문자",
  "HK": "홍콩(중국 특별행정구)",
  "HM": "허드 맥도널드 제도",
  "HN": "온두라스",
  "HR": "크로아티아",
  "HT": "아이티",
  "HU": "헝가리",
  "Hanb": "주음 자모",
  "Hang": "한글",
  "Hani": "한자",
  "Hano": "하누누 문자",
  "Hans": "간체",
  "Hant": "번체",
  "Hebr": "히브리 문자",
  "Hira": "히라가나",
  "Hluw": "아나톨리아 상형문자",
  "Hmng": "파하우 몽 문자",
  "Hrkt": "가나",
  "Hung": "고대 헝가리 문자",
  "IC": "카나리아 제도",
  "ID": "인도네시아",
  "IE": "아일랜드",
  "IL": "이스라엘",
  "IM": "맨 섬",
  "IN": "인도",
  "IO": "영국령 인도양 식민지",
  "IQ": "이라크",
  "IR": "이란",
  "IS": "아이슬란드",
  "IT": "이탈리아",
  "Inds": "인더스 문자",
  "Ital": "고대 이탈리아 문자",
  "JE": "저지",
  "JM": "자메이카",
  "JO": "요르단",
  "JP": "일본",
  "Jamo": "자모",
  "Java": "자바 문자",
  "Jpan": "일본 문자",
  "Jurc": "줄첸 문자",
  "KE": "케냐",
  "KG": "키르기스스탄",
  "KH": "캄보디아",
  "KI": "키리바시",
  "KM": "코모로",
  "KN": "세인트키츠 네비스",
  "KP": "북한",
  "KR": "대한민국",
  "KW": "쿠웨이트",
  "KY": "케이맨 제도",
  "KZ": "카자흐스탄",
  "Kali": "카야 리 문자",
  "Kana": "가타카나",
  "Khar": "카로슈티 문자",
  "Khmr": "크메르 문자",
  "Khoj": "코즈키 문자",
  "Knda": "칸나다 문자",
  "Kore": "한국어",
  "Kpel": "크펠레 문자",
  "Kthi": "카이시 문자",
  "LA": "라오스",
  "LB": "레바논",
  "LC": "세인트루시아",
  "LI": "리히텐슈타인",
  "LK": "스리랑카",
  "LR": "라이베리아",
  "LS": "레소토",
  "LT": "리투아니아",
  "LU": "룩셈부르크",
  "LV": "라트비아",
  "LY": "리비아",
  "Lana": "란나 문자",
  "Laoo": "라오 문자",
  "Latf": "독일식 로마자",
  "Latg": "아일랜드식 로마자",
  "Latn": "로마자",
  "Lepc": "렙차 문자",
  "Limb": "림부 문자",
  "Lina": "선형 문자(A)",
  "Linb": "선형 문자(B)",
  "Lisu": "프레이저 문자",
  "Loma": "로마 문자",
  "Lyci": "리키아 문자",
  "Lydi": "리디아 문자",
  "MA": "모로코",
  "MC": "모나코",
  "MD": "몰도바",
  "ME": "몬테네그로",
  "MF": "생마르탱",
  "MG": "마다가스카르",
  "MH": "마셜 제도",
  "MK": "북마케도니아",
  "ML": "말리",
  "MM": "미얀마",
  "MN": "몽골",
  "MO": "마카오(중국 특별행정구)",
  "MP": "북마리아나제도",
  "MQ": "마르티니크",
  "MR": "모리타니",
  "MS": "몬트세라트",
  "MT": "몰타",
  "MU": "모리셔스",
  "MV": "몰디브",
  "MW": "말라위",
  "MX": "멕시코",
  "MY": "말레이시아",
  "MZ": "모잠비크",
  "Mahj": "마하자니 문자",
  "Mand": "만다이아 문자",
  "Mani": "마니교 문자",
  "Maya": "마야 상형 문자",
  "Mend": "멘데 문자",
  "Merc": "메로에 필기체",
  "Mero": "메로에 문자",
  "Mlym": "말라얄람 문자",
  "Mong": "몽골 문자",
  "Moon": "문 문자",
  "Mroo": "므로 문자",
  "Mtei": "메이테이 마옉 문자",
  "Mymr": "미얀마 문자",
  "NA": "나미비아",
  "NC": "뉴칼레도니아",
  "NE": "니제르",
  "NF": "노퍽섬",
  "NG": "나이지리아",
  "NI": "니카라과",
  "NL": "네덜란드",
  "NO": "노르웨이",
  "NP": "네팔",
  "NR": "나우루",
  "NU": "니우에",
  "NZ": "뉴질랜드",
  "Narb": "옛 북부 아라비아 문자",
  "Nbat": "나바테아 문자",
  "Nkgb": "나시 게바 문자",
  "Nkoo": "응코 문자",
  "Nshu": "누슈 문자",
  "OM": "오만",
  "Ogam": "오검 문자",
  "Olck": "올 치키 문자",
  "Orkh": "오르혼어",
  "Orya": "오리야 문자",
  "Osma": "오스마니아 문자",
  "PA": "파나마",
  "PE": "페루",
  "PF": "프랑스령 폴리네시아",
  "PG": "파푸아뉴기니",
  "PH": "필리핀",
  "PK": "파키스탄",
  "PL": "폴란드",
  "PM": "생피에르 미클롱",
  "PN": "핏케언 섬",
  "PR": "푸에르토리코",
  "PS": "팔레스타인 지구",
  "PT": "포르투갈",
  "PW": "팔라우",
  "PY": "파라과이",
  "Palm": "팔미라 문자",
  "Perm": "고대 페름 문자",
  "Phag": "파스파 문자",
  "Phli": "명문 팔라비 문자",
  "Phlp": "솔터 팔라비 문자",
  "Phlv": "북 팔라비 문자",
  "Phnx": "페니키아 문자",
  "Plrd": "폴라드 표음 문자",
  "Prti": "명문 파라티아 문자",
  "QA": "카타르",
  "QO": "오세아니아 외곽",
  "Qaag": "저지 문자",
  "RE": "리유니온",
  "RO": "루마니아",
  "RS": "세르비아",
  "RU": "러시아",
  "RW": "르완다",
  "Rjng": "레장 문자",
  "Roro": "롱고롱고",
  "Runr": "룬 문자",
  "SA": "사우디아라비아",
  "SB": "솔로몬 제도",
  "SC": "세이셸",
  "SD": "수단",
  "SE": "스웨덴",
  "SG": "싱가포르",
  "SH": "세인트헬레나",
  "SI": "슬로베니아",
  "SJ": "스발바르제도-얀마웬섬",
  "SK": "슬로바키아",
  "SL": "시에라리온",
  "SM": "산마리노",
  "SN": "세네갈",
  "SO": "소말리아",
  "SR": "수리남",
  "SS": "남수단",
  "ST": "상투메 프린시페",
  "SV": "엘살바도르",
  "SX": "신트마르턴",
  "SY": "시리아",
  "SZ": "에스와티니",
  "Samr": "사마리아 문자",
  "Sara": "사라티",
  "Sarb": "옛 남부 아라비아 문자",
  "Saur": "사우라슈트라 문자",
  "Sgnw": "수화 문자",
  "Shaw": "샤비안 문자",
  "Shrd": "사라다 문자",
  "Sidd": "실담자",
  "Sind": "쿠다와디 문자",
  "Sinh": "신할라 문자",
  "Sora": "소라 솜펭 문자",
  "Sund": "순다 문자",
  "Sylo": "실헤티 나가리",
  "Syrc": "시리아 문자",
  "Syre": "에스트랑겔로식 시리아 문자",
  "Syrj": "서부 시리아 문자",
  "Syrn": "동부 시리아 문자",
  "TA": "트리스탄다쿠나",
  "TC": "터크스 케이커스 제도",
  "TD": "차드",
  "TF": "프랑스 남부 지방",
  "TG": "토고",
  "TH": "태국",
  "TJ": "타지키스탄",
  "TK": "토켈라우",
  "TL": "동티모르",
  "TM": "투르크메니스탄",
  "TN": "튀니지",
  "TO": "통가",
  "TR": "터키",
  "TT": "트리니다드 토바고",
  "TV": "투발루",
  "TW": "대만",
  "TZ": "탄자니아",
  "Tagb": "타그반와 문자",
  "Takr": "타크리 문자",
  "Tale": "타이 레 문자",
  "Talu": "신 타이 루에",
  "Taml": "타밀 문자",
  "Tang": "탕구트 문자",
  "Tavt": "태국 베트남 문자",
  "Telu": "텔루구 문자",
  "Teng": "텡과르 문자",
  "Tfng": "티피나그 문자",
  "Tglg": "타갈로그 문자",
  "Thaa": "타나 문자",
  "Thai": "타이 문자",
  "Tibt": "티베트 문자",
  "Tirh": "티르후타 문자",
  "UA": "우크라이나",
  "UG": "우간다",
  "UM": "미국령 해외 제도",
  "UN": "유엔",
  "US": "미국",
  "UY": "우루과이",
  "UZ": "우즈베키스탄",
  "Ugar": "우가리트 문자",
  "VA": "바티칸 시국",
  "VC": "세인트빈센트그레나딘",
  "VE": "베네수엘라",
  "VG": "영국령 버진아일랜드",
  "VI": "미국령 버진아일랜드",
  "VN": "베트남",
  "VU": "바누아투",
  "Vaii": "바이 문자",
  "Visp": "시화법",
  "WF": "왈리스-푸투나 제도",
  "WS": "사모아",
  "Wara": "바랑 크시티 문자",
  "Wole": "울레아이",
  "XA": "유사 억양",
  "XB": "유사 양방향",
  "XK": "코소보",
  "Xpeo": "고대 페르시아 문자",
  "Xsux": "수메르-아카드어 설형문자",
  "YE": "예멘",
  "YT": "마요트",
  "Yiii": "이 문자",
  "ZA": "남아프리카",
  "ZM": "잠비아",
  "ZW": "짐바브웨",
  "ZZ": "알려지지 않은 지역",
  "Zinh": "구전 문자",
  "Zmth": "수학 기호",
  "Zsye": "이모티콘",
  "Zsym": "기호",
  "Zxxx": "구전",
  "Zyyy": "일반 문자",
  "Zzzz": "알 수 없는 문자",
  "aa": "아파르어",
  "ab": "압카즈어",
  "ace": "아체어",
  "ach": "아콜리어",
  "ada": "아당메어",
  "ady": "아디게어",
  "ae": "아베스타어",
  "aeb": "튀니지 아랍어",
  "af": "아프리칸스어",
  "af_NA": "아프리칸스어 (나미비아)",
  "af_ZA": "아프리칸스어 (남아프리카)",
  "afa": "아시아-아프리카어 (기타)",
  "afh": "아프리힐리어",
  "agq": "아그햄어",
  "ain": "아이누어",
  "ak": "아칸어",
  "ak_GH": "아칸어 (가나)",
  "akk": "아카드어",
  "akz": "Alabama",
  "ale": "알류트어",
  "alg": "알공킨어족",
  "aln": "Gheg Albanian",
  "alt": "남부 알타이어",
  "am": "암하라어",
  "am_ET": "암하라어 (이디오피아)",
  "an": "아라곤어",
  "ang": "고대 영어",
  "anp": "앙가어",
  "apa": "아파치어",
  "ar": "아랍어",
  "ar_001": "현대 표준 아랍어",
  "ar_AE": "아랍어 (아랍에미리트 연합)",
  "ar_BH": "아랍어 (바레인)",
  "ar_DJ": "아랍어 (지부티)",
  "ar_DZ": "아랍어 (알제리)",
  "ar_EG": "아랍어 (이집트)",
  "ar_EH": "아랍어 (서사하라)",
  "ar_ER": "아랍어 (에리트리아)",
  "ar_IL": "아랍어 (이스라엘)",
  "ar_IQ": "아랍어 (이라크)",
  "ar_JO": "아랍어 (요르단)",
  "ar_KM": "아랍어 (코모로스)",
  "ar_KW": "아랍어 (쿠웨이트)",
  "ar_LB": "아랍어 (레바논)",
  "ar_LY": "아랍어 (리비아)",
  "ar_MA": "아랍어 (모로코)",
  "ar_MR": "아랍어 (모리타니)",
  "ar_OM": "아랍어 (오만)",
  "ar_PS": "아랍어 (팔레스타인 지구)",
  "ar_QA": "아랍어 (카타르)",
  "ar_SA": "아랍어 (사우디아라비아)",
  "ar_SD": "아랍어 (수단)",
  "ar_SO": "아랍어 (소말리아)",
  "ar_SS": "아랍어 (남수단)",
  "ar_SY": "아랍어 (시리아)",
  "ar_TD": "아랍어 (차드)",
  "ar_TN": "아랍어 (튀니지)",
  "ar_YE": "아랍어 (예멘)",
  "arc": "아람어",
  "arn": "마푸둥군어",
  "aro": "Araona",
  "arp": "아라파호어",
  "arq": "알제리 아랍어",
  "ars": "아랍어(나즈디)",
  "art": "기계어 (기타)",
  "arw": "아라와크어",
  "ary": "모로코 아랍어",
  "arz": "이집트 아랍어",
  "as": "아삼어",
  "as_IN": "아샘어 (인도)",
  "asa": "아수어",
  "ase": "American Sign Language",
  "ast": "아스투리아어",
  "ath": "아타파스카어군",
  "aus": "오스트레일리아어족",
  "av": "아바릭어",
  "avk": "Kotava",
  "awa": "아와히어",
  "ay": "아이마라어",
  "az": "아제르바이잔어",
  "az_AZ": "아제르바이잔어 (아제르바이잔)",
  "az_Cyrl": "아제르바이잔어 (키릴 문자)",
  "az_Cyrl_AZ": "아제르바이잔어 (키릴 문자, 아제르바이잔)",
  "az_Latn": "아제르바이잔어 (로마자)",
  "az_Latn_AZ": "아제르바이잔어 (로마자, 아제르바이잔)",
  "azb": "남아제르바이잔어",
  "ba": "바슈키르어",
  "bad": "반다어",
  "bai": "바밀레케어족",
  "bal": "발루치어",
  "ban": "발리어",
  "bar": "Bavarian",
  "bas": "바사어",
  "bat": "발트어 (기타)",
  "bax": "바문어",
  "bbc": "Batak Toba",
  "bbj": "고말라어",
  "be": "벨라루스어",
  "be_BY": "벨라루스어 (벨라루스)",
  "bej": "베자어",
  "bem": "벰바어",
  "ber": "베르베르어",
  "bew": "Betawi",
  "bez": "베나어",
  "bfd": "바푸트어",
  "bfq": "Badaga",
  "bg": "불가리아어",
  "bg_BG": "불가리아어 (불가리아)",
  "bgn": "서부 발로치어",
  "bh": "비하르어",
  "bho": "호즈푸리어",
  "bi": "비슬라마어",
  "bik": "비콜어",
  "bin": "비니어",
  "bjn": "Banjar",
  "bkm": "콤어",
  "bla": "식시카어",
  "bm": "밤바라어",
  "bm_Latn": "밤바라어 (로마자)",
  "bm_Latn_ML": "밤바라어 (로마자, 말리)",
  "bn": "벵골어",
  "bn_BD": "벵골어 (방글라데시)",
  "bn_IN": "벵골어 (인도)",
  "bnt": "반투어",
  "bo": "티베트어",
  "bo_CN": "티베트어 (중국)",
  "bo_IN": "티베트어 (인도)",
  "bpy": "Bishnupriya",
  "bqi": "Bakhtiari",
  "br": "브르타뉴어",
  "br_FR": "브르타뉴어 (프랑스)",
  "bra": "브라지어",
  "brh": "브라후이어",
  "brx": "보도어",
  "bs": "보스니아어",
  "bs_BA": "보스니아어 (보스니아 헤르체고비나)",
  "bs_Cyrl": "보스니아어 (키릴 문자)",
  "bs_Cyrl_BA": "보스니아어 (키릴 문자, 보스니아 헤르체고비나)",
  "bs_Latn": "보스니아어 (로마자)",
  "bs_Latn_BA": "보스니아어 (로마자, 보스니아 헤르체고비나)",
  "bss": "아쿠즈어",
  "btk": "바타크어",
  "bua": "부리아타",
  "bug": "부기어",
  "bum": "불루어",
  "byn": "브린어",
  "byv": "메둠바어",
  "ca": "카탈로니아어",
  "ca_AD": "카탈로니아어 (안도라)",
  "ca_ES": "카탈로니아어 (스페인)",
  "ca_FR": "카탈로니아어 (프랑스)",
  "ca_IT": "카탈로니아어 (이탈리아)",
  "cad": "카도어",
  "cai": "중앙 아메리카 인디안어 (기타)",
  "car": "카리브어",
  "cau": "카프카스어 (기타)",
  "cay": "카유가어",
  "cch": "앗삼어",
  "ccp": "차크마어",
  "ce": "체첸어",
  "ceb": "세부아노어",
  "cel": "켈트어 (기타)",
  "cgg": "치가어",
  "ch": "차모로어",
  "chb": "치브차어",
  "chg": "차가타이어",
  "chk": "추크어",
  "chm": "마리어",
  "chn": "치누크 자곤",
  "cho": "촉토어",
  "chp": "치페우얀",
  "chr": "체로키어",
  "chy": "샤이엔어",
  "ckb": "소라니 쿠르드어",
  "cmc": "참어군",
  "co": "코르시카어",
  "cop": "콥트어",
  "cpe": "크리올어 및 피진어 (영어를 기반으로 한 기타)",
  "cpf": "크리올어 및 피진어 (프랑스어를 기반으로 한 기타)",
  "cpp": "크리올어 및 피진어 (포르투갈어를 기반으로 한 기타)",
  "cps": "Capiznon",
  "cr": "크리어",
  "crh": "크리민 터키어; 크리민 타타르어",
  "crp": "크리올어 및 피진어 (기타)",
  "crs": "세이셸 크리올 프랑스어",
  "cs": "체코어",
  "cs_CZ": "체코어 (체코)",
  "csb": "카슈비아어",
  "cu": "교회 슬라브어",
  "cus": "쿠시어족",
  "cv": "추바시어",
  "cy": "웨일스어",
  "cy_GB": "웨일스어 (영국)",
  "da": "덴마크어",
  "da_DK": "덴마크어 (덴마크)",
  "da_GL": "덴마크어 (그린란드)",
  "dak": "다코타어",
  "dar": "다르그와어",
  "dav": "타이타어",
  "day": "다야크어",
  "de": "독일어",
  "de_AT": "독일어 (오스트리아)",
  "de_BE": "독일어 (벨기에)",
  "de_CH": "고지 독일어(스위스)",
  "de_DE": "독일어 (독일)",
  "de_LI": "독일어 (리히텐슈타인)",
  "de_LU": "독일어 (룩셈부르크)",
  "del": "델라웨어어",
  "den": "슬라브어",
  "dgr": "도그리브어",
  "din": "딩카어",
  "dje": "자르마어",
  "doi": "도그리어",
  "dra": "드라비다어 (기타)",
  "dsb": "저지 소르비아어",
  "dtp": "Central Dusun",
  "dua": "두알라어",
  "dum": "중세 네덜란드어",
  "dv": "디베히어",
  "dyo": "졸라 포니어",
  "dyu": "드율라어",
  "dz": "종카어",
  "dz_BT": "종카어 (부탄)",
  "dzg": "다장가어",
  "ebu": "엠부어",
  "ee": "에웨어",
  "ee_GH": "에웨어 (가나)",
  "ee_TG": "에웨어 (토고)",
  "efi": "이픽어",
  "egl": "Emilian",
  "egy": "고대 이집트어",
  "eka": "이카죽어",
  "el": "그리스어",
  "el_CY": "그리스어 (사이프러스)",
  "el_GR": "그리스어 (그리스)",
  "elx": "엘람어",
  "en": "영어",
  "en_AG": "영어 (앤티가 바부다)",
  "en_AI": "영어 (안길라)",
  "en_AS": "영어 (아메리칸 사모아)",
  "en_AU": "영어 (오스트레일리아)",
  "en_BB": "영어 (바베이도스)",
  "en_BE": "영어 (벨기에)",
  "en_BM": "영어 (버뮤다)",
  "en_BS": "영어 (바하마)",
  "en_BW": "영어 (보츠와나)",
  "en_BZ": "영어 (벨리즈)",
  "en_CA": "영어 (캐나다)",
  "en_CC": "영어 (코코스제도)",
  "en_CK": "영어 (쿡제도)",
  "en_CM": "영어 (카메룬)",
  "en_CX": "영어 (크리스마스섬)",
  "en_DG": "영어 (디에고 가르시아)",
  "en_DM": "영어 (도미니카)",
  "en_ER": "영어 (에리트리아)",
  "en_FJ": "영어 (피지)",
  "en_FK": "영어 (포클랜드 제도)",
  "en_FM": "영어 (미크로네시아)",
  "en_GB": "영어 (영국식)",
  "en_GD": "영어 (그레나다)",
  "en_GG": "영어 (건지)",
  "en_GH": "영어 (가나)",
  "en_GI": "영어 (지브롤터)",
  "en_GM": "영어 (감비아)",
  "en_GU": "영어 (괌)",
  "en_GY": "영어 (가이아나)",
  "en_HK": "영어 (홍콩, 중국 특별행정구)",
  "en_IE": "영어 (아일랜드)",
  "en_IM": "영어 (맨 섬)",
  "en_IN": "영어 (인도)",
  "en_IO": "영어 (영국령인도양식민지)",
  "en_JE": "영어 (저지)",
  "en_JM": "영어 (자메이카)",
  "en_KE": "영어 (케냐)",
  "en_KI": "영어 (키리바시)",
  "en_KN": "영어 (세인트 키츠 네비스)",
  "en_KY": "영어 (케이맨제도)",
  "en_LC": "영어 (세인트루시아)",
  "en_LR": "영어 (라이베리아)",
  "en_LS": "영어 (레소토)",
  "en_MG": "영어 (마다가스카르)",
  "en_MH": "영어 (마샬 군도)",
  "en_MO": "영어 (마카오, 중국 특별행정구)",
  "en_MP": "영어 (북마리아나제도)",
  "en_MS": "영어 (몬트세라트)",
  "en_MT": "영어 (몰타)",
  "en_MU": "영어 (모리셔스)",
  "en_MW": "영어 (말라위)",
  "en_MY": "영어 (말레이시아)",
  "en_NA": "영어 (나미비아)",
  "en_NF": "영어 (노퍽섬)",
  "en_NG": "영어 (나이지리아)",
  "en_NR": "영어 (나우루)",
  "en_NU": "영어 (니우에)",
  "en_NZ": "영어 (뉴질랜드)",
  "en_PG": "영어 (파푸아뉴기니)",
  "en_PH": "영어 (필리핀)",
  "en_PK": "영어 (파키스탄)",
  "en_PN": "영어 (핏케언 섬)",
  "en_PR": "영어 (푸에르토리코)",
  "en_PW": "영어 (팔라우)",
  "en_RW": "영어 (르완다)",
  "en_SB": "영어 (솔로몬 제도)",
  "en_SC": "영어 (쉐이쉘)",
  "en_SD": "영어 (수단)",
  "en_SG": "영어 (싱가포르)",
  "en_SH": "영어 (세인트헬레나)",
  "en_SL": "영어 (시에라리온)",
  "en_SS": "영어 (남수단)",
  "en_SX": "영어 (신트마르턴)",
  "en_SZ": "영어 (스와질랜드)",
  "en_TC": "영어 (터크스케이커스제도)",
  "en_TK": "영어 (토켈라우)",
  "en_TO": "영어 (통가)",
  "en_TT": "영어 (트리니다드 토바고)",
  "en_TV": "영어 (투발루)",
  "en_TZ": "영어 (탄자니아)",
  "en_UG": "영어 (우간다)",
  "en_UM": "영어 (미국령 해외 제도)",
  "en_US": "영어 (미국식)",
  "en_VC": "영어 (세인트빈센트그레나딘)",
  "en_VG": "영어 (영국령 버진 아일랜드)",
  "en_VI": "영어 (미국령 버진 아일랜드)",
  "en_VU": "영어 (바누아투)",
  "en_WS": "영어 (사모아)",
  "en_ZA": "영어 (남아프리카)",
  "en_ZM": "영어 (잠비아)",
  "en_ZW": "영어 (짐바브웨)",
  "enm": "중세 영어",
  "eo": "에스페란토어",
  "es": "스페인어",
  "es_419": "중남미 스페인어",
  "es_AR": "스페인어 (아르헨티나)",
  "es_BO": "스페인어 (볼리비아)",
  "es_CL": "스페인어 (칠레)",
  "es_CO": "스페인어 (콜롬비아)",
  "es_CR": "스페인어 (코스타리카)",
  "es_CU": "스페인어 (쿠바)",
  "es_DO": "스페인어 (도미니카 공화국)",
  "es_EA": "스페인어 (세우타 및 멜리야)",
  "es_EC": "스페인어 (에콰도르)",
  "es_ES": "스페인어 (스페인)",
  "es_GQ": "스페인어 (적도 기니)",
  "es_GT": "스페인어 (과테말라)",
  "es_HN": "스페인어 (온두라스)",
  "es_IC": "스페인어 (카나리아 제도)",
  "es_MX": "스페인어 (멕시코)",
  "es_NI": "스페인어 (니카라과)",
  "es_PA": "스페인어 (파나마)",
  "es_PE": "스페인어 (페루)",
  "es_PH": "스페인어 (필리핀)",
  "es_PR": "스페인어 (푸에르토리코)",
  "es_PY": "스페인어 (파라과이)",
  "es_SV": "스페인어 (엘살바도르)",
  "es_US": "스페인어 (미국)",
  "es_UY": "스페인어 (우루과이)",
  "es_VE": "스페인어 (베네수엘라)",
  "esu": "Central Yupik",
  "et": "에스토니아어",
  "et_EE": "에스토니아어 (에스토니아)",
  "eu": "바스크어",
  "eu_ES": "바스크어 (스페인)",
  "ewo": "이원도어",
  "ext": "Extremaduran",
  "fa": "페르시아어",
  "fa_AF": "페르시아어 (아프가니스탄)",
  "fa_IR": "페르시아어 (이란)",
  "fan": "팡그어",
  "fat": "판티어",
  "ff": "풀라어",
  "ff_CM": "풀라어 (카메룬)",
  "ff_GN": "풀라어 (기니)",
  "ff_MR": "풀라어 (모리타니)",
  "ff_SN": "풀라어 (세네갈)",
  "fi": "핀란드어",
  "fi_FI": "핀란드어 (핀란드)",
  "fil": "필리핀어",
  "fit": "Tornedalen Finnish",
  "fiu": "피노우그리아어 (기타)",
  "fj": "피지어",
  "fo": "페로어",
  "fo_FO": "페로어 (페로제도)",
  "fon": "폰어",
  "fr": "프랑스어",
  "fr_BE": "프랑스어 (벨기에)",
  "fr_BF": "프랑스어 (부르키나파소)",
  "fr_BI": "프랑스어 (부룬디)",
  "fr_BJ": "프랑스어 (베냉)",
  "fr_BL": "프랑스어 (생 바르텔르미)",
  "fr_CA": "프랑스어 (캐나다)",
  "fr_CD": "프랑스어 (콩고-킨샤사)",
  "fr_CF": "프랑스어 (중앙 아프리카 공화국)",
  "fr_CG": "프랑스어 (콩고)",
  "fr_CH": "프랑스어 (스위스)",
  "fr_CI": "프랑스어 (코트디부아르)",
  "fr_CM": "프랑스어 (카메룬)",
  "fr_DJ": "프랑스어 (지부티)",
  "fr_DZ": "프랑스어 (알제리)",
  "fr_FR": "프랑스어 (프랑스)",
  "fr_GA": "프랑스어 (가봉)",
  "fr_GF": "프랑스어 (프랑스령 기아나)",
  "fr_GN": "프랑스어 (기니)",
  "fr_GP": "프랑스어 (과들루프)",
  "fr_GQ": "프랑스어 (적도 기니)",
  "fr_HT": "프랑스어 (아이티)",
  "fr_KM": "프랑스어 (코모로스)",
  "fr_LU": "프랑스어 (룩셈부르크)",
  "fr_MA": "프랑스어 (모로코)",
  "fr_MC": "프랑스어 (모나코)",
  "fr_MF": "프랑스어 (생 마르탱)",
  "fr_MG": "프랑스어 (마다가스카르)",
  "fr_ML": "프랑스어 (말리)",
  "fr_MQ": "프랑스어 (말티니크)",
  "fr_MR": "프랑스어 (모리타니)",
  "fr_MU": "프랑스어 (모리셔스)",
  "fr_NC": "프랑스어 (뉴 칼레도니아)",
  "fr_NE": "프랑스어 (니제르)",
  "fr_PF": "프랑스어 (프랑스령 폴리네시아)",
  "fr_PM": "프랑스어 (생피에르 미클롱)",
  "fr_RE": "프랑스어 (리유니온)",
  "fr_RW": "프랑스어 (르완다)",
  "fr_SC": "프랑스어 (쉐이쉘)",
  "fr_SN": "프랑스어 (세네갈)",
  "fr_SY": "프랑스어 (시리아)",
  "fr_TD": "프랑스어 (차드)",
  "fr_TG": "프랑스어 (토고)",
  "fr_TN": "프랑스어 (튀니지)",
  "fr_VU": "프랑스어 (바누아투)",
  "fr_WF": "프랑스어 (왈리스-푸투나 제도)",
  "fr_YT": "프랑스어 (마요티)",
  "frc": "케이준 프랑스어",
  "frm": "중세 프랑스어",
  "fro": "고대 프랑스어",
  "frp": "Arpitan",
  "frr": "북부 프리지아어",
  "frs": "동부 프리슬란드어",
  "fur": "프리울리어",
  "fy": "서부 프리지아어",
  "fy_NL": "프리지아어 (네덜란드)",
  "ga": "아일랜드어",
  "ga_IE": "아일랜드어 (아일랜드)",
  "gaa": "가어",
  "gag": "가가우스어",
  "gan": "간어",
  "gay": "가요어",
  "gba": "그바야어",
  "gbz": "조로아스터 다리어",
  "gd": "스코틀랜드 게일어",
  "gd_GB": "스코틀랜드 게일어 (영국)",
  "gem": "독일어 (기타)",
  "gez": "게이즈어",
  "gil": "키리바시어",
  "gl": "갈리시아어",
  "gl_ES": "갈리시아어 (스페인)",
  "glk": "길라키어",
  "gmh": "중세 고지 독일어",
  "gn": "과라니어",
  "goh": "고대 고지 독일어",
  "gom": "고아 콘칸어",
  "gon": "곤디어",
  "gor": "고론탈로어",
  "got": "고트어",
  "grb": "게르보어",
  "grc": "고대 그리스어",
  "gsw": "독일어(스위스)",
  "gu": "구자라트어",
  "gu_IN": "구자라트어 (인도)",
  "guc": "Wayuu",
  "gur": "Frafra",
  "guz": "구시어",
  "gv": "맹크스어",
  "gv_IM": "맹크스어 (맨 섬)",
  "gwi": "그위친어",
  "ha": "하우사어",
  "ha_GH": "하우사어 (가나)",
  "ha_Latn": "하우사어 (로마자)",
  "ha_Latn_GH": "하우사어 (로마자, 가나)",
  "ha_Latn_NE": "하우사어 (로마자, 니제르)",
  "ha_Latn_NG": "하우사어 (로마자, 나이지리아)",
  "ha_NE": "하우사어 (니제르)",
  "ha_NG": "하우사어 (나이지리아)",
  "hai": "하이다어",
  "hak": "하카어",
  "haw": "하와이어",
  "he": "히브리어",
  "he_IL": "히브리어 (이스라엘)",
  "hi": "힌디어",
  "hi_IN": "힌디어 (인도)",
  "hif": "피지 힌디어",
  "hil": "헤리가뇬어",
  "him": "히마차리어",
  "hit": "하타이트어",
  "hmn": "히몸어",
  "ho": "히리 모투어",
  "hr": "크로아티아어",
  "hr_BA": "크로아티아어 (보스니아 헤르체고비나)",
  "hr_HR": "크로아티아어 (크로아티아)",
  "hsb": "고지 소르비아어",
  "hsn": "샹어",
  "ht": "아이티어",
  "hu": "헝가리어",
  "hu_HU": "헝가리어 (헝가리)",
  "hup": "후파어",
  "hy": "아르메니아어",
  "hy_AM": "아르메니아어 (아르메니아)",
  "hz": "헤레로어",
  "ia": "인터링구아",
  "iba": "이반어",
  "ibb": "이비비오어",
  "id": "인도네시아어",
  "id_ID": "인도네시아어 (인도네시아)",
  "ie": "인테르링구에",
  "ig": "이그보어",
  "ig_NG": "이그보어 (나이지리아)",
  "ii": "쓰촨 이어",
  "ii_CN": "쓰촨 이어 (중국)",
  "ijo": "이조어",
  "ik": "이누피아크어",
  "ilo": "이로코어",
  "inc": "인도어 (기타)",
  "ine": "인도유럽어 (기타)",
  "inh": "인귀시어",
  "io": "이도어",
  "ira": "이란어",
  "iro": "이러쿼이어",
  "is": "아이슬란드어",
  "is_IS": "아이슬란드어 (아이슬란드)",
  "it": "이탈리아어",
  "it_CH": "이탈리아어 (스위스)",
  "it_IT": "이탈리아어 (이탈리아)",
  "it_SM": "이탈리아어 (산마리노)",
  "iu": "이눅티투트어",
  "izh": "Ingrian",
  "ja": "일본어",
  "ja_JP": "일본어 (일본)",
  "jam": "Jamaican Creole English",
  "jbo": "로반어",
  "jgo": "응곰바어",
  "jmc": "마차메어",
  "jpr": "유대-페르시아어",
  "jrb": "유대-아라비아어",
  "jut": "Jutish",
  "jv": "자바어",
  "ka": "조지아어",
  "ka_GE": "조지아어 (조지아)",
  "kaa": "카라칼파크어",
  "kab": "커바일어",
  "kac": "카친어",
  "kaj": "까꼬토끄어",
  "kam": "캄바어",
  "kar": "카렌어",
  "kaw": "카위어",
  "kbd": "카바르디어",
  "kbl": "카넴부어",
  "kcg": "티얍어",
  "kde": "마콘데어",
  "kea": "크리올어",
  "ken": "Kenyang",
  "kfo": "코로어",
  "kg": "콩고어",
  "kgp": "Kaingang",
  "kha": "카시어",
  "khi": "코이산어 (기타)",
  "kho": "호탄어",
  "khq": "코이라 친니어",
  "khw": "코와르어",
  "ki": "키쿠유어",
  "ki_KE": "키쿠유어 (케냐)",
  "kiu": "Kirmanjki",
  "kj": "쿠안야마어",
  "kk": "카자흐어",
  "kk_Cyrl": "카자흐어 (키릴 문자)",
  "kk_Cyrl_KZ": "카자흐어 (키릴 문자, 카자흐스탄)",
  "kk_KZ": "카자흐어 (카자흐스탄)",
  "kkj": "카코어",
  "kl": "그린란드어",
  "kl_GL": "그린란드어 (그린란드)",
  "kln": "칼렌진어",
  "km": "크메르어",
  "km_KH": "캄보디아어 (캄보디아)",
  "kmb": "킴분두어",
  "kn": "칸나다어",
  "kn_IN": "칸나다어 (인도)",
  "ko": "한국어",
  "ko_KP": "한국어 (조선 민주주의 인민 공화국)",
  "ko_KR": "한국어 (대한민국)",
  "koi": "코미페르먀크어",
  "kok": "코카니어",
  "kos": "코스라이엔어",
  "kpe": "크펠레어",
  "kr": "칸누리어",
  "krc": "카라챠이-발카르어",
  "kri": "Krio",
  "krj": "Kinaray-a",
  "krl": "카렐리야어",
  "kro": "크루어",
  "kru": "쿠르크어",
  "ks": "카슈미르어",
  "ks_Arab": "카슈미르어 (아랍 문자)",
  "ks_Arab_IN": "카슈미르어 (아랍 문자, 인도)",
  "ks_IN": "카슈미르어 (인도)",
  "ksb": "샴발라어",
  "ksf": "바피아어",
  "ksh": "콜로그니안어",
  "ku": "쿠르드어",
  "kum": "쿠믹어",
  "kut": "쿠테네어",
  "kv": "코미어",
  "kw": "콘월어",
  "kw_GB": "콘월어 (영국)",
  "ky": "키르기스어",
  "ky_Cyrl": "키르기스어 (키릴 문자)",
  "ky_Cyrl_KG": "키르기스어 (키릴 문자, 키르기스스탄)",
  "ky_KG": "키르기스어 (키르기스스탄)",
  "la": "라틴어",
  "lad": "라디노어",
  "lag": "랑기어",
  "lah": "라한다어",
  "lam": "람바어",
  "lb": "룩셈부르크어",
  "lb_LU": "룩셈부르크어 (룩셈부르크)",
  "lez": "레즈기안어",
  "lfn": "링구아 프랑카 노바",
  "lg": "간다어",
  "lg_UG": "간다어 (우간다)",
  "li": "림버거어",
  "lij": "Ligurian",
  "liv": "Livonian",
  "lkt": "라코타어",
  "lmo": "Lombard",
  "ln": "링갈라어",
  "ln_AO": "링갈라어 (앙골라)",
  "ln_CD": "링갈라어 (콩고-킨샤사)",
  "ln_CF": "링갈라어 (중앙 아프리카 공화국)",
  "ln_CG": "링갈라어 (콩고)",
  "lo": "라오어",
  "lo_LA": "라오어 (라오스)",
  "lol": "몽고어",
  "lou": "루이지애나 크리올어",
  "loz": "로지어",
  "lrc": "북부 루리어",
  "lt": "리투아니아어",
  "lt_LT": "리투아니아어 (리투아니아)",
  "ltg": "Latgalian",
  "lu": "루바-카탄가어",
  "lu_CD": "루바-카탄가어 (콩고-킨샤사)",
  "lua": "루바-룰루아어",
  "lui": "루이세노어",
  "lun": "룬다어",
  "luo": "루오어",
  "lus": "루샤이어",
  "luy": "루야어",
  "lv": "라트비아어",
  "lv_LV": "라트비아어 (라트비아)",
  "lzh": "Literary Chinese",
  "lzz": "Laz",
  "mad": "마두라어",
  "maf": "마파어",
  "mag": "마가히어",
  "mai": "마이틸리어",
  "mak": "마카사어",
  "man": "만딩고어",
  "map": "남도어",
  "mas": "마사이어",
  "mde": "마바어",
  "mdf": "모크샤어",
  "mdr": "만다르어",
  "men": "멘데어",
  "mer": "메루어",
  "mfe": "모리스얀어",
  "mg": "말라가시어",
  "mg_MG": "말라가시어 (마다가스카르)",
  "mga": "중세 아일랜드어",
  "mgh": "마크후와-메토어",
  "mgo": "메타어",
  "mh": "마셜어",
  "mi": "마오리어",
  "mic": "미크맥어",
  "min": "미낭카바우어",
  "mis": "기타 언어",
  "mk": "마케도니아어",
  "mk_MK": "마케도니아어 (마케도니아)",
  "mkh": "몬크메르어 (기타)",
  "ml": "말라얄람어",
  "ml_IN": "말라얄람어 (인도)",
  "mn": "몽골어",
  "mn_Cyrl": "몽고어 (키릴 문자)",
  "mn_Cyrl_MN": "몽고어 (키릴 문자, 몽골)",
  "mn_MN": "몽고어 (몽골)",
  "mnc": "만주어",
  "mni": "마니푸리어",
  "mno": "마노보어",
  "mo": "몰도바어",
  "moh": "모호크어",
  "mos": "모시어",
  "mr": "마라티어",
  "mr_IN": "마라티어 (인도)",
  "mrj": "서부 마리어",
  "ms": "말레이어",
  "ms_BN": "말레이어 (브루나이)",
  "ms_Latn": "말레이어 (로마자)",
  "ms_Latn_BN": "말레이어 (로마자, 브루나이)",
  "ms_Latn_MY": "말레이어 (로마자, 말레이시아)",
  "ms_Latn_SG": "말레이어 (로마자, 싱가포르)",
  "ms_MY": "말레이어 (말레이시아)",
  "ms_SG": "말레이어 (싱가포르)",
  "mt": "몰타어",
  "mt_MT": "몰타어 (몰타)",
  "mua": "문당어",
  "mul": "다중 언어",
  "mun": "문다어",
  "mus": "크리크어",
  "mwl": "미란데어",
  "mwr": "마르와리어",
  "mwv": "Mentawai",
  "my": "버마어",
  "my_MM": "버마어 (미얀마)",
  "mye": "미예네어",
  "myn": "마야어",
  "myv": "엘즈야어",
  "mzn": "마잔데라니어",
  "na": "나우루어",
  "nah": "나우아틀어",
  "nai": "북아메리카 인디언어 (기타)",
  "nan": "민난어",
  "nap": "나폴리어",
  "naq": "나마어",
  "nb": "노르웨이어(보크말)",
  "nb_NO": "노르웨이어(보크말) (노르웨이)",
  "nb_SJ": "노르웨이어(보크말) (스발바르제도-얀마웬섬)",
  "nd": "북부 은데벨레어",
  "nd_ZW": "북부 은데벨레어 (짐바브웨)",
  "nds": "저지 독일어",
  "nds_NL": "저지 색슨어",
  "ne": "네팔어",
  "ne_IN": "네팔어 (인도)",
  "ne_NP": "네팔어 (네팔)",
  "new": "네와르어",
  "ng": "느동가어",
  "nia": "니아스어",
  "nic": "니제르 - 코르도파니아어 (기타)",
  "niu": "니웨언어",
  "njo": "Ao Naga",
  "nl": "네덜란드어",
  "nl_AW": "네덜란드어 (아루바)",
  "nl_BE": "네덜란드어 (벨기에)",
  "nl_BQ": "네덜란드어 (네덜란드령 카리브)",
  "nl_CW": "네덜란드어 (퀴라소)",
  "nl_NL": "네덜란드어 (네덜란드)",
  "nl_SR": "네덜란드어 (수리남)",
  "nl_SX": "네덜란드어 (신트마르턴)",
  "nmg": "크와시오어",
  "nn": "노르웨이어(니노르스크)",
  "nn_NO": "노르웨이어(니노르스크) (노르웨이)",
  "nnh": "느기엠본어",
  "no": "노르웨이어",
  "no_NO": "노르웨이어 (노르웨이)",
  "nog": "노가이어",
  "non": "고대 노르웨이어",
  "nov": "Novial",
  "nqo": "응코어",
  "nr": "남부 은데벨레어",
  "nso": "북부 소토어",
  "nub": "누비안어",
  "nus": "누에르어",
  "nv": "나바호어",
  "nwc": "고전 네와르어",
  "ny": "냔자어",
  "nym": "니암웨지어",
  "nyn": "니안콜어",
  "nyo": "뉴로어",
  "nzi": "느지마어",
  "oc": "오크어",
  "oj": "오지브와어",
  "om": "오로모어",
  "om_ET": "오로모어 (이디오피아)",
  "om_KE": "오로모어 (케냐)",
  "or": "오리야어",
  "or_IN": "오리야어 (인도)",
  "os": "오세트어",
  "os_GE": "오세트어 (조지아)",
  "os_RU": "오세트어 (러시아)",
  "osa": "오세이지어",
  "ota": "오스만 터키어",
  "oto": "오토미안어",
  "pa": "펀잡어",
  "pa_Arab": "펀잡어 (아랍 문자)",
  "pa_Arab_PK": "펀잡어 (아랍 문자, 파키스탄)",
  "pa_Guru": "펀잡어 (구르무키 문자)",
  "pa_Guru_IN": "펀잡어 (구르무키 문자, 인도)",
  "pa_IN": "펀잡어 (인도)",
  "pa_PK": "펀잡어 (파키스탄)",
  "paa": "파푸아어 (기타)",
  "pag": "판가시난어",
  "pal": "팔레비어",
  "pam": "팜팡가어",
  "pap": "파피아먼토어",
  "pau": "팔라우어",
  "pcd": "Picard",
  "pcm": "나이지리아 피진어",
  "pdc": "Pennsylvania German",
  "pdt": "Plautdietsch",
  "peo": "고대 페르시아어",
  "pfl": "Palatine German",
  "phi": "필리핀어 (기타)",
  "phn": "페니키아어",
  "pi": "팔리어",
  "pl": "폴란드어",
  "pl_PL": "폴란드어 (폴란드)",
  "pms": "Piedmontese",
  "pnt": "폰틱어",
  "pon": "폼페이어",
  "pra": "프라크리트어",
  "prg": "프러시아어",
  "pro": "고대 프로방스어",
  "ps": "파슈토어",
  "ps_AF": "파슈토어 (아프가니스탄)",
  "pt": "포르투갈어",
  "pt_AO": "포르투갈어 (앙골라)",
  "pt_BR": "포르투갈어 (브라질)",
  "pt_CV": "포르투갈어 (까뽀베르데)",
  "pt_GW": "포르투갈어 (기네비쏘)",
  "pt_MO": "포르투갈어 (마카오, 중국 특별행정구)",
  "pt_MZ": "포르투갈어 (모잠비크)",
  "pt_PT": "포르투갈어 (포르투갈)",
  "pt_ST": "포르투갈어 (상투메 프린시페)",
  "pt_TL": "포르투갈어 (동티모르)",
  "qu": "케추아어",
  "qu_BO": "케추아어 (볼리비아)",
  "qu_EC": "케추아어 (에콰도르)",
  "qu_PE": "케추아어 (페루)",
  "quc": "키체어",
  "qug": "Chimborazo Highland Quichua",
  "raj": "라자스탄어",
  "rap": "라파뉴이",
  "rar": "라로통가어",
  "rgn": "Romagnol",
  "rif": "Riffian",
  "rm": "로만시어",
  "rm_CH": "레토로만어 (스위스)",
  "rn": "룬디어",
  "rn_BI": "룬디어 (부룬디)",
  "ro": "루마니아어",
  "ro_MD": "루마니아어 (몰도바)",
  "ro_RO": "루마니아어 (루마니아)",
  "roa": "로망스어 (기타)",
  "rof": "롬보어",
  "rom": "집시어",
  "root": "어근",
  "rtm": "Rotuman",
  "ru": "러시아어",
  "ru_BY": "러시아어 (벨라루스)",
  "ru_KG": "러시아어 (키르기스스탄)",
  "ru_KZ": "러시아어 (카자흐스탄)",
  "ru_MD": "러시아어 (몰도바)",
  "ru_RU": "러시아어 (러시아)",
  "ru_UA": "러시아어 (우크라이나)",
  "rue": "루신어",
  "rug": "Roviana",
  "rup": "아로마니아어",
  "rw": "르완다어",
  "rw_RW": "르완다어 (르완다)",
  "rwk": "르와어",
  "sa": "산스크리트어",
  "sad": "산다웨어",
  "sah": "야쿠트어",
  "sai": "남아메리카 인디언어 (기타)",
  "sal": "샐리시어어",
  "sam": "사마리아 아랍어",
  "saq": "삼부루어",
  "sas": "사사크어",
  "sat": "산탈리어",
  "saz": "Saurashtra",
  "sba": "느감바이어",
  "sbp": "상구어",
  "sc": "사르디니아어",
  "scn": "시칠리아어",
  "sco": "스코틀랜드어",
  "sd": "신디어",
  "sdc": "Sassarese Sardinian",
  "sdh": "남부 쿠르드어",
  "se": "북부 사미어",
  "se_FI": "북부 사미어 (핀란드)",
  "se_NO": "북부 사미어 (노르웨이)",
  "se_SE": "북부 사미어 (스웨덴)",
  "see": "세네카어",
  "seh": "세나어",
  "sei": "Seri",
  "sel": "셀쿠프어",
  "sem": "셈어 (기타)",
  "ses": "코이야보로 세니어",
  "sg": "산고어",
  "sg_CF": "산고어 (중앙 아프리카 공화국)",
  "sga": "고대 아일랜드어",
  "sgn": "수화",
  "sgs": "Samogitian",
  "sh": "세르비아-크로아티아어",
  "sh_BA": "세르비아-크로아티아어 (보스니아 헤르체고비나)",
  "shi": "타셸히트어",
  "shn": "샨어",
  "shu": "차디언 아라비아어",
  "si": "스리랑카어",
  "si_LK": "스리랑카어 (스리랑카)",
  "sid": "시다모어",
  "sio": "수족어",
  "sit": "중국 티베트 어족",
  "sk": "슬로바키아어",
  "sk_SK": "슬로바키아어 (슬로바키아)",
  "sl": "슬로베니아어",
  "sl_SI": "슬로베니아어 (슬로베니아)",
  "sla": "슬라브어 (기타)",
  "sli": "Lower Silesian",
  "sly": "Selayar",
  "sm": "사모아어",
  "sma": "남부 사미어",
  "smi": "사미어 (기타)",
  "smj": "룰레 사미어",
  "smn": "이나리 사미어",
  "sms": "스콜트 사미어",
  "sn": "쇼나어",
  "sn_ZW": "쇼나어 (짐바브웨)",
  "snk": "소닌케어",
  "so": "소말리아어",
  "so_DJ": "소말리아어 (지부티)",
  "so_ET": "소말리아어 (이디오피아)",
  "so_KE": "소말리아어 (케냐)",
  "so_SO": "소말리아어 (소말리아)",
  "sog": "소그디엔어",
  "son": "송가이족어",
  "sq": "알바니아어",
  "sq_AL": "알바니아어 (알바니아)",
  "sq_MK": "알바니아어 (마케도니아)",
  "sq_XK": "알바니아어 (코소보)",
  "sr": "세르비아어",
  "sr_BA": "세르비아어 (보스니아 헤르체고비나)",
  "sr_Cyrl": "세르비아어 (키릴 문자)",
  "sr_Cyrl_BA": "세르비아어 (키릴 문자, 보스니아 헤르체고비나)",
  "sr_Cyrl_ME": "세르비아어 (키릴 문자, 몬테네그로)",
  "sr_Cyrl_RS": "세르비아어 (키릴 문자, 세르비아)",
  "sr_Cyrl_XK": "세르비아어 (키릴 문자, 코소보)",
  "sr_Latn": "세르비아어 (로마자)",
  "sr_Latn_BA": "세르비아어 (로마자, 보스니아 헤르체고비나)",
  "sr_Latn_ME": "세르비아어 (로마자, 몬테네그로)",
  "sr_Latn_RS": "세르비아어 (로마자, 세르비아)",
  "sr_Latn_XK": "세르비아어 (로마자, 코소보)",
  "sr_ME": "세르비아어 (몬테네그로)",
  "sr_RS": "세르비아어 (세르비아)",
  "sr_XK": "세르비아어 (코소보)",
  "srn": "스라난 통가어",
  "srr": "세레르어",
  "ss": "시스와티어",
  "ssa": "니로-사하람어 (기타)",
  "ssy": "사호어",
  "st": "남부 소토어",
  "stq": "Saterland Frisian",
  "su": "순다어",
  "suk": "수쿠마어",
  "sus": "수수어",
  "sux": "수메르어",
  "sv": "스웨덴어",
  "sv_AX": "스웨덴어 (올란드 제도)",
  "sv_FI": "스웨덴어 (핀란드)",
  "sv_SE": "스웨덴어 (스웨덴)",
  "sw": "스와힐리어",
  "sw_CD": "콩고 스와힐리어",
  "sw_KE": "스와힐리어 (케냐)",
  "sw_TZ": "스와힐리어 (탄자니아)",
  "sw_UG": "스와힐리어 (우간다)",
  "swb": "코모로어",
  "swc": "콩고 스와힐리어",
  "syc": "고전 시리아어",
  "syr": "시리아어",
  "szl": "Silesian",
  "ta": "타밀어",
  "ta_IN": "타밀어 (인도)",
  "ta_LK": "타밀어 (스리랑카)",
  "ta_MY": "타밀어 (말레이시아)",
  "ta_SG": "타밀어 (싱가포르)",
  "tai": "태국어 (기타)",
  "tcy": "Tulu",
  "te": "텔루구어",
  "te_IN": "텔루구어 (인도)",
  "tem": "팀니어",
  "teo": "테조어",
  "ter": "테레노어",
  "tet": "테툼어",
  "tg": "타지크어",
  "th": "태국어",
  "th_TH": "태국어 (태국)",
  "ti": "티그리냐어",
  "ti_ER": "티그리냐어 (에리트리아)",
  "ti_ET": "티그리냐어 (이디오피아)",
  "tig": "티그레어",
  "tiv": "티브어",
  "tk": "투르크멘어",
  "tkl": "토켈라우제도어",
  "tkr": "차후르어",
  "tl": "타갈로그어",
  "tl_PH": "타갈로그어 (필리핀)",
  "tlh": "클링온어",
  "tli": "틀링깃족어",
  "tly": "탈리쉬어",
  "tmh": "타마섹어",
  "tn": "츠와나어",
  "to": "통가어",
  "to_TO": "통가어 (통가)",
  "tog": "통가어 (니아살랜드)",
  "tpi": "토크 피신어",
  "tr": "터키어",
  "tr_CY": "터키어 (사이프러스)",
  "tr_TR": "터키어 (터키)",
  "tru": "Turoyo",
  "trv": "타로코어",
  "ts": "총가어",
  "tsd": "Tsakonian",
  "tsi": "트심시안어",
  "tt": "타타르어",
  "ttt": "Muslim Tat",
  "tum": "툼부카어",
  "tup": "투피어",
  "tut": "알타이제어 (기타)",
  "tvl": "투발루어",
  "tw": "트위어",
  "twq": "타사와크어",
  "ty": "타히티어",
  "tyv": "투비니안어",
  "tzm": "중앙모로코 타마지트어",
  "udm": "우드말트어",
  "ug": "위구르어",
  "ug_Arab": "위구르어 (아랍 문자)",
  "ug_Arab_CN": "위구르어 (아랍 문자, 중국)",
  "ug_CN": "위구르어 (중국)",
  "uga": "유가리틱어",
  "uk": "우크라이나어",
  "uk_UA": "우크라이나어 (우크라이나)",
  "umb": "움분두어",
  "und": "알 수 없는 언어",
  "ur": "우르두어",
  "ur_IN": "우르두어 (인도)",
  "ur_PK": "우르두어 (파키스탄)",
  "uz": "우즈베크어",
  "uz_AF": "우즈베크어 (아프가니스탄)",
  "uz_Arab": "우즈베크어 (아랍 문자)",
  "uz_Arab_AF": "우즈베크어 (아랍 문자, 아프가니스탄)",
  "uz_Cyrl": "우즈베크어 (키릴 문자)",
  "uz_Cyrl_UZ": "우즈베크어 (키릴 문자, 우즈베키스탄)",
  "uz_Latn": "우즈베크어 (로마자)",
  "uz_Latn_UZ": "우즈베크어 (로마자, 우즈베키스탄)",
  "uz_UZ": "우즈베크어 (우즈베키스탄)",
  "vai": "바이어",
  "ve": "벤다어",
  "vec": "Venetian",
  "vep": "Veps",
  "vi": "베트남어",
  "vi_VN": "베트남어 (베트남)",
  "vls": "West Flemish",
  "vmf": "Main-Franconian",
  "vo": "볼라퓌크어",
  "vot": "보틱어",
  "vro": "Võro",
  "vun": "분조어",
  "wa": "왈론어",
  "wae": "월저어",
  "wak": "와카샨어",
  "wal": "와라모어",
  "war": "와라이어",
  "was": "와쇼어",
  "wbp": "왈피리어",
  "wen": "소르브어",
  "wo": "월로프어",
  "wuu": "우어",
  "xal": "칼미크어",
  "xh": "코사어",
  "xmf": "Mingrelian",
  "xog": "소가어",
  "yao": "야오족어",
  "yap": "얍페세어",
  "yav": "양본어",
  "ybb": "옘바어",
  "yi": "이디시어",
  "yo": "요루바어",
  "yo_BJ": "요루바어 (베냉)",
  "yo_NG": "요루바어 (나이지리아)",
  "ypk": "야픽어",
  "yrl": "Nheengatu",
  "yue": "광둥어",
  "za": "주앙어",
  "zap": "사포테크어",
  "zbl": "블리스 심볼",
  "zea": "Zeelandic",
  "zen": "제나가어",
  "zgh": "표준 모로코 타마지트어",
  "zh": "중국어",
  "zh_CN": "중국어 (중국)",
  "zh_HK": "중국어 (홍콩, 중국 특별행정구)",
  "zh_Hans": "중국어(간체)",
  "zh_Hans_CN": "중국어 (한자(간체), 중국)",
  "zh_Hans_HK": "중국어 (한자(간체), 홍콩, 중국 특별행정구)",
  "zh_Hans_MO": "중국어 (한자(간체), 마카오, 중국 특별행정구)",
  "zh_Hans_SG": "중국어 (한자(간체), 싱가포르)",
  "zh_Hant": "중국어(번체)",
  "zh_Hant_HK": "중국어 (한자(번체), 홍콩, 중국 특별행정구)",
  "zh_Hant_MO": "중국어 (한자(번체), 마카오, 중국 특별행정구)",
  "zh_Hant_TW": "중국어 (한자(번체), 대만)",
  "zh_MO": "중국어 (마카오, 중국 특별행정구)",
  "zh_SG": "중국어 (싱가포르)",
  "zh_TW": "중국어 (대만)",
  "znd": "아잔데족어",
  "zu": "줄루어",
  "zu_ZA": "줄루어 (남아프리카)",
  "zun": "주니어",
  "zxx": "언어 관련 내용 없음",
  "zza": "자자어"
};
