/// Locale names of Japanese
const names = {
  "001": "世界",
  "002": "アフリカ",
  "003": "北アメリカ大陸",
  "005": "南アメリカ",
  "009": "オセアニア",
  "011": "西アフリカ",
  "013": "中央アメリカ",
  "014": "東アフリカ",
  "015": "北アフリカ",
  "017": "中部アフリカ",
  "018": "南部アフリカ",
  "019": "アメリカ大陸",
  "021": "北アメリカ",
  "029": "カリブ",
  "030": "東アジア",
  "034": "南アジア",
  "035": "東南アジア",
  "039": "南ヨーロッパ",
  "053": "オーストララシア",
  "054": "メラネシア",
  "057": "ミクロネシア",
  "061": "ポリネシア",
  "062": "南中央アジア",
  "142": "アジア",
  "143": "中央アジア",
  "145": "西アジア",
  "150": "ヨーロッパ",
  "151": "東ヨーロッパ",
  "154": "北ヨーロッパ",
  "155": "西ヨーロッパ",
  "172": "独立国家共同体",
  "200": "チェコスロバキア",
  "202": "サブサハラアフリカ",
  "419": "ラテンアメリカ",
  "830": "チャネル諸島",
  "AC": "アセンション島",
  "AD": "アンドラ",
  "AE": "アラブ首長国連邦",
  "AF": "アフガニスタン",
  "AG": "アンティグア・バーブーダ",
  "AI": "アンギラ",
  "AL": "アルバニア",
  "AM": "アルメニア",
  "AN": "オランダ領アンティル諸島",
  "AO": "アンゴラ",
  "AQ": "南極",
  "AR": "アルゼンチン",
  "AS": "米領サモア",
  "AT": "オーストリア",
  "AU": "オーストラリア",
  "AW": "アルバ",
  "AX": "オーランド諸島",
  "AZ": "アゼルバイジャン",
  "Adlm": "アドラム",
  "Afak": "アファカ文字",
  "Aghb": "カフカス・アルバニア文字",
  "Ahom": "アホム",
  "Arab": "アラビア文字",
  "Aran": "ナスタアリーク体",
  "Armi": "帝国アラム文字",
  "Armn": "アルメニア文字",
  "Avst": "アヴェスター文字",
  "BA": "ボスニア・ヘルツェゴビナ",
  "BB": "バルバドス",
  "BD": "バングラデシュ",
  "BE": "ベルギー",
  "BF": "ブルキナファソ",
  "BG": "ブルガリア",
  "BH": "バーレーン",
  "BI": "ブルンジ",
  "BJ": "ベナン",
  "BL": "サン・バルテルミー",
  "BM": "バミューダ",
  "BN": "ブルネイ",
  "BO": "ボリビア",
  "BQ": "オランダ領カリブ",
  "BR": "ブラジル",
  "BS": "バハマ",
  "BT": "ブータン",
  "BV": "ブーベ島",
  "BW": "ボツワナ",
  "BY": "ベラルーシ",
  "BZ": "ベリーズ",
  "Bali": "バリ文字",
  "Bamu": "バムン文字",
  "Bass": "バサ文字",
  "Batk": "バタク文字",
  "Beng": "ベンガル文字",
  "Bhks": "バイクスキ",
  "Blis": "ブリスシンボル",
  "Bopo": "注音字母",
  "Brah": "ブラーフミー文字",
  "Brai": "ブライユ点字",
  "Bugi": "ブギス文字",
  "Buhd": "ブヒッド文字",
  "CA": "カナダ",
  "CC": "ココス(キーリング)諸島",
  "CD": "コンゴ民主共和国(キンシャサ)",
  "CF": "中央アフリカ共和国",
  "CG": "コンゴ共和国(ブラザビル)",
  "CH": "スイス",
  "CI": "コートジボワール",
  "CK": "クック諸島",
  "CL": "チリ",
  "CM": "カメルーン",
  "CN": "中国",
  "CO": "コロンビア",
  "CP": "クリッパートン島",
  "CR": "コスタリカ",
  "CS": "セルビア・モンテネグロ",
  "CU": "キューバ",
  "CV": "カーボベルデ",
  "CW": "キュラソー",
  "CX": "クリスマス島",
  "CY": "キプロス",
  "CZ": "チェコ",
  "Cakm": "チャクマ文字",
  "Cans": "統合カナダ先住民音節文字",
  "Cari": "カリア文字",
  "Cham": "チャム文字",
  "Cher": "チェロキー文字",
  "Chrs": "ホラズム語",
  "Cirt": "キアス文字",
  "Copt": "コプト文字",
  "Cprt": "キプロス文字",
  "Cyrl": "キリル文字",
  "Cyrs": "古代教会スラブ語キリル文字",
  "DD": "東ドイツ",
  "DE": "ドイツ",
  "DG": "ディエゴガルシア島",
  "DJ": "ジブチ",
  "DK": "デンマーク",
  "DM": "ドミニカ国",
  "DO": "ドミニカ共和国",
  "DZ": "アルジェリア",
  "Deva": "デーバナーガリー文字",
  "Diak": "ダイブアクル",
  "Dogr": "ドーグラー",
  "Dsrt": "デセレット文字",
  "Dupl": "デュプロワエ式速記",
  "EA": "セウタ・メリリャ",
  "EC": "エクアドル",
  "EE": "エストニア",
  "EG": "エジプト",
  "EH": "西サハラ",
  "ER": "エリトリア",
  "ES": "スペイン",
  "ET": "エチオピア",
  "EU": "欧州連合",
  "EZ": "ユーロ圏",
  "Egyd": "エジプト民衆文字",
  "Egyh": "エジプト神官文字",
  "Egyp": "エジプト聖刻文字",
  "Elba": "エルバサン文字",
  "Elym": "エリマイク",
  "Ethi": "エチオピア文字",
  "FI": "フィンランド",
  "FJ": "フィジー",
  "FK": "フォークランド諸島",
  "FM": "ミクロネシア連邦",
  "FO": "フェロー諸島",
  "FR": "フランス",
  "FX": "メトロポリタンフランス",
  "GA": "ガボン",
  "GB": "イギリス",
  "GD": "グレナダ",
  "GE": "ジョージア",
  "GF": "仏領ギアナ",
  "GG": "ガーンジー",
  "GH": "ガーナ",
  "GI": "ジブラルタル",
  "GL": "グリーンランド",
  "GM": "ガンビア",
  "GN": "ギニア",
  "GP": "グアドループ",
  "GQ": "赤道ギニア",
  "GR": "ギリシャ",
  "GS": "サウスジョージア・サウスサンドウィッチ諸島",
  "GT": "グアテマラ",
  "GU": "グアム",
  "GW": "ギニアビサウ",
  "GY": "ガイアナ",
  "Geok": "ジョージア文字(フツリ)",
  "Geor": "ジョージア文字",
  "Glag": "グラゴル文字",
  "Gong": "グンジャラ・ゴーンディー",
  "Gonm": "マサラムゴンディ",
  "Goth": "ゴート文字",
  "Gran": "グランタ文字",
  "Grek": "ギリシャ文字",
  "Gujr": "グジャラート文字",
  "Guru": "グルムキー文字",
  "HK": "中華人民共和国香港特別行政区",
  "HM": "ハード島・マクドナルド諸島",
  "HN": "ホンジュラス",
  "HR": "クロアチア",
  "HT": "ハイチ",
  "HU": "ハンガリー",
  "Hanb": "漢語注音字母",
  "Hang": "ハングル",
  "Hani": "漢字",
  "Hano": "ハヌノオ文字",
  "Hans": "簡体字",
  "Hant": "繁体字",
  "Hatr": "ハトラ文字",
  "Hebr": "ヘブライ文字",
  "Hira": "ひらがな",
  "Hluw": "アナトリア象形文字",
  "Hmng": "パハウ・フモン文字",
  "Hmnp": "Nyiakeng Puachue Hmong",
  "Hrkt": "仮名",
  "Hung": "古代ハンガリー文字",
  "IC": "カナリア諸島",
  "ID": "インドネシア",
  "IE": "アイルランド",
  "IL": "イスラエル",
  "IM": "マン島",
  "IN": "インド",
  "IO": "英領インド洋地域",
  "IQ": "イラク",
  "IR": "イラン",
  "IS": "アイスランド",
  "IT": "イタリア",
  "Inds": "インダス文字",
  "Ital": "古イタリア文字",
  "JE": "ジャージー",
  "JM": "ジャマイカ",
  "JO": "ヨルダン",
  "JP": "日本",
  "Jamo": "字母",
  "Java": "ジャワ文字",
  "Jpan": "日本語の文字",
  "Jurc": "女真文字",
  "KE": "ケニア",
  "KG": "キルギス",
  "KH": "カンボジア",
  "KI": "キリバス",
  "KM": "コモロ",
  "KN": "セントクリストファー・ネーヴィス",
  "KP": "北朝鮮",
  "KR": "韓国",
  "KW": "クウェート",
  "KY": "ケイマン諸島",
  "KZ": "カザフスタン",
  "Kali": "カヤー文字",
  "Kana": "カタカナ",
  "Khar": "カローシュティー文字",
  "Khmr": "クメール文字",
  "Khoj": "ホジャ文字",
  "Kits": "Khitan小さなスクリプト",
  "Knda": "カンナダ文字",
  "Kore": "韓国語の文字",
  "Kpel": "クペレ文字",
  "Kthi": "カイティ文字",
  "LA": "ラオス",
  "LB": "レバノン",
  "LC": "セントルシア",
  "LI": "リヒテンシュタイン",
  "LK": "スリランカ",
  "LR": "リベリア",
  "LS": "レソト",
  "LT": "リトアニア",
  "LU": "ルクセンブルク",
  "LV": "ラトビア",
  "LY": "リビア",
  "Lana": "ラーンナー文字",
  "Laoo": "ラオ文字",
  "Latf": "ラテン文字(ドイツ文字)",
  "Latg": "ラテン文字 (ゲール文字)",
  "Latn": "ラテン文字",
  "Lepc": "レプチャ文字",
  "Limb": "リンブ文字",
  "Lina": "線文字A",
  "Linb": "線文字B",
  "Lisu": "フレイザー文字",
  "Loma": "ロマ文字",
  "Lyci": "リキア文字",
  "Lydi": "リディア文字",
  "MA": "モロッコ",
  "MC": "モナコ",
  "MD": "モルドバ",
  "ME": "モンテネグロ",
  "MF": "サン・マルタン",
  "MG": "マダガスカル",
  "MH": "マーシャル諸島",
  "MI": "ミッドウェー島",
  "MK": "北マケドニア",
  "ML": "マリ",
  "MM": "ミャンマー (ビルマ)",
  "MN": "モンゴル",
  "MO": "中華人民共和国マカオ特別行政区",
  "MP": "北マリアナ諸島",
  "MQ": "マルティニーク",
  "MR": "モーリタニア",
  "MS": "モントセラト",
  "MT": "マルタ",
  "MU": "モーリシャス",
  "MV": "モルディブ",
  "MW": "マラウイ",
  "MX": "メキシコ",
  "MY": "マレーシア",
  "MZ": "モザンビーク",
  "Mahj": "マハージャニー文字",
  "Maka": "マカッサル",
  "Mand": "マンダ文字",
  "Mani": "マニ文字",
  "Marc": "マルケン",
  "Maya": "マヤ象形文字",
  "Medf": "メデファイドリン",
  "Mend": "メンデ文字",
  "Merc": "メロエ文字草書体",
  "Mero": "メロエ文字",
  "Mlym": "マラヤーラム文字",
  "Modi": "モーディー文字",
  "Mong": "モンゴル文字",
  "Moon": "ムーン文字",
  "Mroo": "ムロ文字",
  "Mtei": "メイテイ文字",
  "Mult": "ムルタニ",
  "Mymr": "ミャンマー文字",
  "NA": "ナミビア",
  "NC": "ニューカレドニア",
  "NE": "ニジェール",
  "NF": "ノーフォーク島",
  "NG": "ナイジェリア",
  "NI": "ニカラグア",
  "NL": "オランダ",
  "NO": "ノルウェー",
  "NP": "ネパール",
  "NR": "ナウル",
  "NT": "ニュートラルゾーン",
  "NU": "ニウエ",
  "NZ": "ニュージーランド",
  "Nand": "ナンディナガリ",
  "Narb": "古代北アラビア文字",
  "Nbat": "ナバテア文字",
  "Newa": "ニューア",
  "Nkgb": "ナシ族ゲバ文字",
  "Nkoo": "ンコ文字",
  "Nshu": "女書",
  "OM": "オマーン",
  "Ogam": "オガム文字",
  "Olck": "オルチキ文字",
  "Orkh": "オルホン文字",
  "Orya": "オディア文字",
  "Osge": "オセージ",
  "Osma": "オスマニア文字",
  "PA": "パナマ",
  "PC": "太平洋諸島信託統治領",
  "PE": "ペルー",
  "PF": "仏領ポリネシア",
  "PG": "パプアニューギニア",
  "PH": "フィリピン",
  "PK": "パキスタン",
  "PL": "ポーランド",
  "PM": "サンピエール島・ミクロン島",
  "PN": "ピトケアン諸島",
  "PR": "プエルトリコ",
  "PS": "パレスチナ自治区",
  "PT": "ポルトガル",
  "PU": "米国のその他の太平洋諸島",
  "PW": "パラオ",
  "PY": "パラグアイ",
  "PZ": "パナマ運河地帯",
  "Palm": "パルミラ文字",
  "Pauc": "パウ・チン・ハウ文字",
  "Perm": "古ぺルム文字",
  "Phag": "パスパ文字",
  "Phli": "碑文パフラヴィー文字",
  "Phlp": "詩編用パフラヴィー文字",
  "Phlv": "書物用パフラヴィー文字",
  "Phnx": "フェニキア文字",
  "Plrd": "ポラード音声記号",
  "Prti": "碑文パルティア文字",
  "QA": "カタール",
  "QO": "オセアニア周辺地域",
  "Qaag": "Zawgyi",
  "RE": "レユニオン",
  "RO": "ルーマニア",
  "RS": "セルビア",
  "RU": "ロシア",
  "RW": "ルワンダ",
  "Rjng": "ルジャン文字",
  "Rohg": "ハニーフィー・ロヒンギャ",
  "Roro": "ロンゴロンゴ文字",
  "Runr": "ルーン文字",
  "SA": "サウジアラビア",
  "SB": "ソロモン諸島",
  "SC": "セーシェル",
  "SD": "スーダン",
  "SE": "スウェーデン",
  "SG": "シンガポール",
  "SH": "セントヘレナ",
  "SI": "スロベニア",
  "SJ": "スバールバル諸島・ヤンマイエン島",
  "SK": "スロバキア",
  "SL": "シエラレオネ",
  "SM": "サンマリノ",
  "SN": "セネガル",
  "SO": "ソマリア",
  "SR": "スリナム",
  "SS": "南スーダン",
  "ST": "サントメ・プリンシペ",
  "SU": "ソビエト社会主義共和国連合",
  "SV": "エルサルバドル",
  "SX": "シント・マールテン",
  "SY": "シリア",
  "SZ": "エスワティニ",
  "Samr": "サマリア文字",
  "Sara": "サラティ文字",
  "Sarb": "古代南アラビア文字",
  "Saur": "サウラーシュトラ文字",
  "Sgnw": "手話文字",
  "Shaw": "ショー文字",
  "Shrd": "シャーラダー文字",
  "Sidd": "梵字",
  "Sind": "クダワディ文字",
  "Sinh": "シンハラ文字",
  "Sogd": "ソグド語",
  "Sogo": "古いソグド文字",
  "Sora": "ソラング・ソンペング文字",
  "Soyo": "ソヨンボ",
  "Sund": "スンダ文字",
  "Sylo": "シロティ・ナグリ文字",
  "Syrc": "シリア文字",
  "Syre": "シリア文字(エストランゲロ文字)",
  "Syrj": "シリア文字(西方シリア文字)",
  "Syrn": "シリア文字(東方シリア文字)",
  "TA": "トリスタン・ダ・クーニャ",
  "TC": "タークス・カイコス諸島",
  "TD": "チャド",
  "TF": "仏領極南諸島",
  "TG": "トーゴ",
  "TH": "タイ",
  "TJ": "タジキスタン",
  "TK": "トケラウ",
  "TL": "東ティモール",
  "TM": "トルクメニスタン",
  "TN": "チュニジア",
  "TO": "トンガ",
  "TR": "トルコ",
  "TT": "トリニダード・トバゴ",
  "TV": "ツバル",
  "TW": "台湾",
  "TZ": "タンザニア",
  "Tagb": "タグバンワ文字",
  "Takr": "タークリー文字",
  "Tale": "タイ・レ文字",
  "Talu": "新タイ・ルー文字",
  "Taml": "タミル文字",
  "Tang": "西夏文字",
  "Tavt": "タイ・ヴェト文字",
  "Telu": "テルグ文字",
  "Teng": "テングワール文字",
  "Tfng": "ティフナグ文字",
  "Tglg": "タガログ文字",
  "Thaa": "ターナ文字",
  "Thai": "タイ文字",
  "Tibt": "チベット文字",
  "Tirh": "ティルフータ文字",
  "UA": "ウクライナ",
  "UG": "ウガンダ",
  "UM": "合衆国領有小離島",
  "UN": "国際連合",
  "US": "アメリカ合衆国",
  "UY": "ウルグアイ",
  "UZ": "ウズベキスタン",
  "Ugar": "ウガリット文字",
  "VA": "バチカン市国",
  "VC": "セントビンセント及びグレナディーン諸島",
  "VD": "北ベトナム",
  "VE": "ベネズエラ",
  "VG": "英領ヴァージン諸島",
  "VI": "米領ヴァージン諸島",
  "VN": "ベトナム",
  "VU": "バヌアツ",
  "Vaii": "ヴァイ文字",
  "Visp": "視話法",
  "WF": "ウォリス・フツナ",
  "WK": "ウェーク島",
  "WS": "サモア",
  "Wara": "バラン・クシティ文字",
  "Wcho": "わんちょ",
  "Wole": "ウォレアイ文字",
  "XA": "疑似アクセント",
  "XB": "疑似 BIDI",
  "XK": "コソボ",
  "Xpeo": "古代ペルシア文字",
  "Xsux": "シュメール＝アッカド語楔形文字",
  "YD": "イエメン人民民主共和国",
  "YE": "イエメン",
  "YT": "マヨット",
  "Yezi": "ヤズィーディー",
  "Yiii": "イ文字",
  "ZA": "南アフリカ",
  "ZM": "ザンビア",
  "ZW": "ジンバブエ",
  "ZZ": "不明な地域",
  "Zanb": "ザナバザールスクエア",
  "Zinh": "基底文字の種別を継承する結合文字",
  "Zmth": "数学記号",
  "Zsye": "絵文字",
  "Zsym": "記号文字",
  "Zxxx": "非表記",
  "Zyyy": "共通文字",
  "Zzzz": "不明な文字",
  "aa": "アファル語",
  "ab": "アブハズ語",
  "ace": "アチェ語",
  "ach": "アチョリ語",
  "ada": "アダングメ語",
  "ady": "アディゲ語",
  "ae": "アヴェスタ語",
  "aeb": "チュニジア・アラビア語",
  "af": "アフリカーンス語",
  "af_NA": "アフリカーンス語 (ナミビア)",
  "af_ZA": "アフリカーンス語 (南アフリカ)",
  "afa": "セム・ハム諸語",
  "afh": "アフリヒリ語",
  "agq": "アゲム語",
  "ain": "アイヌ語",
  "ak": "アカン語",
  "ak_GH": "アカン語 (ガーナ)",
  "akk": "アッカド語",
  "akz": "アラバマ語",
  "ale": "アレウト語",
  "alg": "アルゴンキアン語族",
  "aln": "ゲグ・アルバニア語",
  "alt": "南アルタイ語",
  "am": "アムハラ語",
  "am_ET": "アムハラ語 (エチオピア)",
  "an": "アラゴン語",
  "ang": "古英語",
  "anp": "アンギカ語",
  "apa": "アパッチ語族",
  "ar": "アラビア語",
  "ar_001": "現代標準アラビア語",
  "ar_AE": "アラビア語 (アラブ首長国連邦)",
  "ar_BH": "アラビア語 (バーレーン)",
  "ar_DJ": "アラビア語 (ジブチ)",
  "ar_DZ": "アラビア語 (アルジェリア)",
  "ar_EG": "アラビア語 (エジプト)",
  "ar_EH": "アラビア語 (西サハラ)",
  "ar_ER": "アラビア語 (エリトリア)",
  "ar_IL": "アラビア語 (イスラエル)",
  "ar_IQ": "アラビア語 (イラク)",
  "ar_JO": "アラビア語 (ヨルダン)",
  "ar_KM": "アラビア語 (コモロ)",
  "ar_KW": "アラビア語 (クウェート)",
  "ar_LB": "アラビア語 (レバノン)",
  "ar_LY": "アラビア語 (リビア)",
  "ar_MA": "アラビア語 (モロッコ)",
  "ar_MR": "アラビア語 (モーリタニア)",
  "ar_OM": "アラビア語 (オマーン)",
  "ar_PS": "アラビア語 (パレスチナ)",
  "ar_QA": "アラビア語 (カタール)",
  "ar_SA": "アラビア語 (サウジアラビア)",
  "ar_SD": "アラビア語 (スーダン)",
  "ar_SO": "アラビア語 (ソマリア)",
  "ar_SS": "アラビア語 (南スーダン)",
  "ar_SY": "アラビア語 (シリア)",
  "ar_TD": "アラビア語 (チャド)",
  "ar_TN": "アラビア語 (チュニジア)",
  "ar_YE": "アラビア語 (イエメン)",
  "arc": "アラム語",
  "arn": "マプチェ語",
  "aro": "アラオナ語",
  "arp": "アラパホー語",
  "arq": "アルジェリア・アラビア語",
  "ars": "ナジュド地方・アラビア語",
  "art": "人工諸語",
  "arw": "アラワク語",
  "ary": "モロッコ・アラビア語",
  "arz": "エジプト・アラビア語",
  "as": "アッサム語",
  "as_IN": "アッサム語 (インド)",
  "asa": "アス語",
  "ase": "アメリカ手話",
  "ast": "アストゥリアス語",
  "ath": "アサパスカン語族",
  "aus": "オーストラリア語族",
  "av": "アヴァル語",
  "avk": "コタヴァ",
  "awa": "アワディー語",
  "ay": "アイマラ語",
  "az": "アゼルバイジャン語",
  "az_AZ": "アゼルバイジャン語 (アゼルバイジャン)",
  "az_Arab": "アゼルバイジャン語（アラビア語）",
  "az_Cyrl": "アゼルバイジャン語 (キリル文字)",
  "az_Cyrl_AZ": "アゼルバイジャン語 (キリル文字, アゼルバイジャン)",
  "az_Latn": "アゼルバイジャン語 (ラテン文字)",
  "az_Latn_AZ": "アゼルバイジャン語 (ラテン文字, アゼルバイジャン)",
  "azb": "南アゼルバイジャン語",
  "ba": "バシキール語",
  "bad": "バンダ語",
  "bai": "バミレケ語族",
  "bal": "バルーチー語",
  "ban": "バリ語",
  "bar": "バイエルン・オーストリア語",
  "bas": "バサ語",
  "bat": "バルト諸語",
  "bax": "バムン語",
  "bbc": "トバ・バタク語",
  "bbj": "ゴーマラ語",
  "be": "ベラルーシ語",
  "be_BY": "ベラルーシ語 (ベラルーシ)",
  "bej": "ベジャ語",
  "bem": "ベンバ語",
  "ber": "ベルベル諸語",
  "bew": "ベタウィ語",
  "bez": "ベナ語",
  "bfd": "バフット語",
  "bfq": "バダガ語",
  "bg": "ブルガリア語",
  "bg_BG": "ブルガリア語 (ブルガリア)",
  "bgn": "西バローチー語",
  "bh": "ビハール語",
  "bho": "ボージュプリー語",
  "bi": "ビスラマ語",
  "bik": "ビコル語",
  "bin": "ビニ語",
  "bjn": "バンジャル語",
  "bkm": "コム語",
  "bla": "シクシカ語",
  "bm": "バンバラ語",
  "bm_Latn": "バンバラ語 (ラテン文字)",
  "bm_Latn_ML": "バンバラ語 (ラテン文字, マリ)",
  "bn": "ベンガル語",
  "bn_BD": "ベンガル語 (バングラデシュ)",
  "bn_IN": "ベンガル語 (インド)",
  "bnt": "バントゥ諸語",
  "bo": "チベット語",
  "bo_CN": "チベット語 (中国)",
  "bo_IN": "チベット語 (インド)",
  "bpy": "ビシュヌプリヤ・マニプリ語",
  "bqi": "バフティヤーリー語",
  "br": "ブルトン語",
  "br_FR": "ブルトン語 (フランス)",
  "bra": "ブラジ語",
  "brh": "ブラフイ語",
  "brx": "ボド語",
  "bs": "ボスニア語",
  "bs_BA": "ボスニア語 (ボスニア・ヘルツェゴビナ)",
  "bs_Cyrl": "ボスニア語 (キリル文字)",
  "bs_Cyrl_BA": "ボスニア語 (キリル文字, ボスニア・ヘルツェゴビナ)",
  "bs_Latn": "ボスニア語 (ラテン文字)",
  "bs_Latn_BA": "ボスニア語 (ラテン文字, ボスニア・ヘルツェゴビナ)",
  "bss": "アコース語",
  "btk": "バタク語",
  "bua": "ブリヤート語",
  "bug": "ブギ語",
  "bum": "ブル語",
  "byn": "ビリン語",
  "byv": "メドゥンバ語",
  "ca": "カタロニア語",
  "ca_AD": "カタロニア語 (アンドラ)",
  "ca_ES": "カタロニア語 (スペイン)",
  "ca_FR": "カタロニア語 (フランス)",
  "ca_IT": "カタロニア語 (イタリア)",
  "cad": "カドー語",
  "cai": "中米インディアン諸語",
  "car": "カリブ語",
  "cau": "コーカサス諸語",
  "cay": "カユーガ語",
  "cch": "チャワイ語",
  "ccp": "チャクマ語",
  "ce": "チェチェン語",
  "ceb": "セブアノ語",
  "cel": "ケルト諸語",
  "cgg": "チガ語",
  "ch": "チャモロ語",
  "chb": "チブチャ語",
  "chg": "チャガタイ語",
  "chk": "チューク語",
  "chm": "マリ語",
  "chn": "チヌーク混成語",
  "cho": "チョクトー語",
  "chp": "チペワイアン語",
  "chr": "チェロキー語",
  "chy": "シャイアン語",
  "cic": "チカソー",
  "ckb": "中央クルド語",
  "cmc": "チャム語族",
  "co": "コルシカ語",
  "cop": "コプト語",
  "cpe": "英語が基盤の混成語・混合語",
  "cpf": "フランス語が基盤の混成語・混合語",
  "cpp": "ポルトガル語が基盤の混成語・混合語",
  "cps": "カピス語",
  "cr": "クリー語",
  "crh": "クリミア・タタール語",
  "crp": "その他の混成語・混合語",
  "crs": "セーシェル・クレオール語",
  "cs": "チェコ語",
  "cs_CZ": "チェコ語 (チェコ共和国)",
  "csb": "カシューブ語",
  "cu": "教会スラブ語",
  "cus": "クシュ諸語",
  "cv": "チュヴァシ語",
  "cy": "ウェールズ語",
  "cy_GB": "ウェールズ語 (イギリス)",
  "da": "デンマーク語",
  "da_DK": "デンマーク語 (デンマーク)",
  "da_GL": "デンマーク語 (グリーンランド)",
  "dak": "ダコタ語",
  "dar": "ダルグワ語",
  "dav": "タイタ語",
  "day": "ダヤク語",
  "de": "ドイツ語",
  "de_AT": "ドイツ語 (オーストリア)",
  "de_BE": "ドイツ語 (ベルギー)",
  "de_CH": "ドイツ語 (スイス)",
  "de_DE": "ドイツ語 (ドイツ)",
  "de_LI": "ドイツ語 (リヒテンシュタイン)",
  "de_LU": "ドイツ語 (ルクセンブルグ)",
  "del": "デラウェア語",
  "den": "スレイビー語",
  "dgr": "ドグリブ語",
  "din": "ディンカ語",
  "dje": "ザルマ語",
  "doi": "ドーグリー語",
  "dra": "ドラヴィダ諸語",
  "dsb": "低地ソルブ語",
  "dtp": "中央ドゥスン語",
  "dua": "ドゥアラ語",
  "dum": "中世オランダ語",
  "dv": "ディベヒ語",
  "dyo": "ジョラ＝フォニィ語",
  "dyu": "ジュラ語",
  "dz": "ゾンカ語",
  "dz_BT": "ゾンカ語 (ブータン)",
  "dzg": "ダザガ語",
  "ebu": "エンブ語",
  "ee": "エウェ語",
  "ee_GH": "エウェ語 (ガーナ)",
  "ee_TG": "エウェ語 (トーゴ)",
  "efi": "エフィク語",
  "egl": "エミリア語",
  "egy": "古代エジプト語",
  "eka": "エカジュク語",
  "el": "ギリシャ語",
  "el_CY": "ギリシャ語 (キプロス)",
  "el_GR": "ギリシャ語 (ギリシャ)",
  "elx": "エラム語",
  "en": "英語",
  "en_AG": "英語 (アンティグア・バーブーダ)",
  "en_AI": "英語 (アンギラ)",
  "en_AS": "英語 (米領サモア)",
  "en_AU": "英語 (オーストラリア)",
  "en_BB": "英語 (バルバドス)",
  "en_BE": "英語 (ベルギー)",
  "en_BM": "英語 (バミューダ)",
  "en_BS": "英語 (バハマ)",
  "en_BW": "英語 (ボツワナ)",
  "en_BZ": "英語 (ベリーズ)",
  "en_CA": "英語 (カナダ)",
  "en_CC": "英語 (ココス(キーリング)諸島)",
  "en_CK": "英語 (クック諸島)",
  "en_CM": "英語 (カメルーン)",
  "en_CX": "英語 (クリスマス島)",
  "en_DG": "英語 (ディエゴガルシア島)",
  "en_DM": "英語 (ドミニカ国)",
  "en_Dsrt": "英語（Deseret）",
  "en_ER": "英語 (エリトリア)",
  "en_FJ": "英語 (フィジー)",
  "en_FK": "英語 (フォークランド諸島)",
  "en_FM": "英語 (ミクロネシア連邦)",
  "en_GB": "英語 (イギリス)",
  "en_GD": "英語 (グレナダ)",
  "en_GG": "英語 (ガーンジー)",
  "en_GH": "英語 (ガーナ)",
  "en_GI": "英語 (ジブラルタル)",
  "en_GM": "英語 (ガンビア)",
  "en_GU": "英語 (グアム)",
  "en_GY": "英語 (ガイアナ)",
  "en_HK": "英語 (中華人民共和国香港特別行政区)",
  "en_IE": "英語 (アイルランド)",
  "en_IM": "英語 (マン島)",
  "en_IN": "英語 (インド)",
  "en_IO": "英語 (英領インド洋地域)",
  "en_JE": "英語 (ジャージー)",
  "en_JM": "英語 (ジャマイカ)",
  "en_KE": "英語 (ケニア)",
  "en_KI": "英語 (キリバス)",
  "en_KN": "英語 (セントクリストファー・ネイビス)",
  "en_KY": "英語 (ケイマン諸島)",
  "en_LC": "英語 (セントルシア)",
  "en_LR": "英語 (リベリア)",
  "en_LS": "英語 (レソト)",
  "en_MG": "英語 (マダガスカル)",
  "en_MH": "英語 (マーシャル諸島)",
  "en_MO": "英語 (中華人民共和国マカオ特別行政区)",
  "en_MP": "英語 (北マリアナ諸島)",
  "en_MS": "英語 (モントセラト)",
  "en_MT": "英語 (マルタ)",
  "en_MU": "英語 (モーリシャス)",
  "en_MW": "英語 (マラウイ)",
  "en_MY": "英語 (マレーシア)",
  "en_NA": "英語 (ナミビア)",
  "en_NF": "英語 (ノーフォーク島)",
  "en_NG": "英語 (ナイジェリア)",
  "en_NR": "英語 (ナウル)",
  "en_NU": "英語 (ニウエ島)",
  "en_NZ": "英語 (ニュージーランド)",
  "en_PG": "英語 (パプアニューギニア)",
  "en_PH": "英語 (フィリピン)",
  "en_PK": "英語 (パキスタン)",
  "en_PN": "英語 (ピトケアン諸島)",
  "en_PR": "英語 (プエルトリコ)",
  "en_PW": "英語 (パラオ)",
  "en_RW": "英語 (ルワンダ)",
  "en_SB": "英語 (ソロモン諸島)",
  "en_SC": "英語 (セーシェル)",
  "en_SD": "英語 (スーダン)",
  "en_SG": "英語 (シンガポール)",
  "en_SH": "英語 (セントヘレナ)",
  "en_SL": "英語 (シエラレオネ)",
  "en_SS": "英語 (南スーダン)",
  "en_SX": "英語 (シント・マールテン)",
  "en_SZ": "英語 (スワジランド)",
  "en_TC": "英語 (タークス・カイコス諸島)",
  "en_TK": "英語 (トケラウ)",
  "en_TO": "英語 (トンガ)",
  "en_TT": "英語 (トリニダード・トバゴ)",
  "en_TV": "英語 (ツバル)",
  "en_TZ": "英語 (タンザニア)",
  "en_UG": "英語 (ウガンダ)",
  "en_UM": "英語 (米領太平洋諸島)",
  "en_US": "英語 (アメリカ合衆国)",
  "en_VC": "英語 (セントビンセント・グレナディーン諸島)",
  "en_VG": "英語 (英領ヴァージン諸島)",
  "en_VI": "英語 (米領ヴァージン諸島)",
  "en_VU": "英語 (バヌアツ)",
  "en_WS": "英語 (サモア)",
  "en_ZA": "英語 (南アフリカ)",
  "en_ZM": "英語 (ザンビア)",
  "en_ZW": "英語 (ジンバブエ)",
  "enm": "中英語",
  "eo": "エスペラント語",
  "es": "スペイン語",
  "es_419": "スペイン語[ラテンアメリカ]",
  "es_AR": "スペイン語 (アルゼンチン)",
  "es_BO": "スペイン語 (ボリビア)",
  "es_CL": "スペイン語 (チリ)",
  "es_CO": "スペイン語 (コロンビア)",
  "es_CR": "スペイン語 (コスタリカ)",
  "es_CU": "スペイン語 (キューバ)",
  "es_DO": "スペイン語 (ドミニカ共和国)",
  "es_EA": "スペイン語 (セウタ・メリリャ)",
  "es_EC": "スペイン語 (エクアドル)",
  "es_ES": "スペイン語 (スペイン)",
  "es_GQ": "スペイン語 (赤道ギニア)",
  "es_GT": "スペイン語 (グアテマラ)",
  "es_HN": "スペイン語 (ホンジュラス)",
  "es_IC": "スペイン語 (カナリア諸島)",
  "es_MX": "スペイン語 (メキシコ)",
  "es_NI": "スペイン語 (ニカラグア)",
  "es_PA": "スペイン語 (パナマ)",
  "es_PE": "スペイン語 (ペルー)",
  "es_PH": "スペイン語 (フィリピン)",
  "es_PR": "スペイン語 (プエルトリコ)",
  "es_PY": "スペイン語 (パラグアイ)",
  "es_SV": "スペイン語 (エルサルバドル)",
  "es_US": "スペイン語 (アメリカ合衆国)",
  "es_UY": "スペイン語 (ウルグアイ)",
  "es_VE": "スペイン語 (ベネズエラ)",
  "esu": "中央アラスカ・ユピック語",
  "et": "エストニア語",
  "et_EE": "エストニア語 (エストニア)",
  "eu": "バスク語",
  "eu_ES": "バスク語 (スペイン)",
  "ewo": "エウォンド語",
  "ext": "エストレマドゥーラ語",
  "fa": "ペルシア語",
  "fa_AF": "ペルシア語 (アフガニスタン)",
  "fa_IR": "ペルシア語 (イラン)",
  "fan": "ファング語",
  "fat": "ファンティー語",
  "ff": "フラ語",
  "ff_Adlm": "フラニ語（アドラム）",
  "ff_CM": "フラニ語 (カメルーン)",
  "ff_GN": "フラニ語 (ギニア)",
  "ff_MR": "フラニ語 (モーリタニア)",
  "ff_SN": "フラニ語 (セネガル)",
  "fi": "フィンランド語",
  "fi_FI": "フィンランド語 (フィンランド)",
  "fil": "フィリピノ語",
  "fit": "トルネダール・フィンランド語",
  "fiu": "フィン・ウゴル諸語",
  "fj": "フィジー語",
  "fo": "フェロー語",
  "fo_FO": "フェロー語 (フェロー諸島)",
  "fon": "フォン語",
  "fr": "フランス語",
  "fr_BE": "フランス語 (ベルギー)",
  "fr_BF": "フランス語 (ブルキナファソ)",
  "fr_BI": "フランス語 (ブルンジ)",
  "fr_BJ": "フランス語 (ベナン)",
  "fr_BL": "フランス語 (サン・バルテルミー島)",
  "fr_CA": "フランス語 (カナダ)",
  "fr_CD": "フランス語 (コンゴ民主共和国(キンシャサ))",
  "fr_CF": "フランス語 (中央アフリカ共和国)",
  "fr_CG": "フランス語 (コンゴ共和国(ブラザビル))",
  "fr_CH": "フランス語 (スイス)",
  "fr_CI": "フランス語 (コートジボワール)",
  "fr_CM": "フランス語 (カメルーン)",
  "fr_DJ": "フランス語 (ジブチ)",
  "fr_DZ": "フランス語 (アルジェリア)",
  "fr_FR": "フランス語 (フランス)",
  "fr_GA": "フランス語 (ガボン)",
  "fr_GF": "フランス語 (仏領ギアナ)",
  "fr_GN": "フランス語 (ギニア)",
  "fr_GP": "フランス語 (グアドループ)",
  "fr_GQ": "フランス語 (赤道ギニア)",
  "fr_HT": "フランス語 (ハイチ)",
  "fr_KM": "フランス語 (コモロ)",
  "fr_LU": "フランス語 (ルクセンブルグ)",
  "fr_MA": "フランス語 (モロッコ)",
  "fr_MC": "フランス語 (モナコ)",
  "fr_MF": "フランス語 (サン・マルタン)",
  "fr_MG": "フランス語 (マダガスカル)",
  "fr_ML": "フランス語 (マリ)",
  "fr_MQ": "フランス語 (マルティニーク)",
  "fr_MR": "フランス語 (モーリタニア)",
  "fr_MU": "フランス語 (モーリシャス)",
  "fr_NC": "フランス語 (ニューカレドニア)",
  "fr_NE": "フランス語 (ニジェール)",
  "fr_PF": "フランス語 (仏領ポリネシア)",
  "fr_PM": "フランス語 (サンピエール島・ミクロン島)",
  "fr_RE": "フランス語 (レユニオン島)",
  "fr_RW": "フランス語 (ルワンダ)",
  "fr_SC": "フランス語 (セーシェル)",
  "fr_SN": "フランス語 (セネガル)",
  "fr_SY": "フランス語 (シリア)",
  "fr_TD": "フランス語 (チャド)",
  "fr_TG": "フランス語 (トーゴ)",
  "fr_TN": "フランス語 (チュニジア)",
  "fr_VU": "フランス語 (バヌアツ)",
  "fr_WF": "フランス語 (ウォリス・フツナ)",
  "fr_YT": "フランス語 (マヨット島)",
  "frc": "ケイジャン・フランス語",
  "frm": "中期フランス語",
  "fro": "古フランス語",
  "frp": "アルピタン語",
  "frr": "北フリジア語",
  "frs": "東フリジア語",
  "fur": "フリウリ語",
  "fy": "西フリジア語",
  "fy_NL": "西フリジア語 (オランダ)",
  "ga": "アイルランド語",
  "ga_IE": "アイルランド語 (アイルランド)",
  "gaa": "ガ語",
  "gag": "ガガウズ語",
  "gan": "贛語",
  "gay": "ガヨ語",
  "gba": "バヤ語",
  "gbz": "ダリー語(ゾロアスター教)",
  "gd": "スコットランド・ゲール語",
  "gd_GB": "スコットランド・ゲール語 (イギリス)",
  "gem": "ゲルマン諸語",
  "gez": "ゲエズ語",
  "gil": "キリバス語",
  "gl": "ガリシア語",
  "gl_ES": "ガリシア語 (スペイン)",
  "glk": "ギラキ語",
  "gmh": "中高ドイツ語",
  "gn": "グアラニー語",
  "goh": "古高ドイツ語",
  "gom": "ゴア・コンカニ語",
  "gon": "ゴーンディー語",
  "gor": "ゴロンタロ語",
  "got": "ゴート語",
  "grb": "グレボ語",
  "grc": "古代ギリシャ語",
  "gsw": "スイスドイツ語",
  "gu": "グジャラート語",
  "gu_IN": "グジャラート語 (インド)",
  "guc": "ワユ語",
  "gur": "フラフラ語",
  "guz": "グシイ語",
  "gv": "マン島語",
  "gv_IM": "マン島語 (マン島)",
  "gwi": "グウィッチン語",
  "ha": "ハウサ語",
  "ha_GH": "ハウサ語 (ガーナ)",
  "ha_Latn": "ハウサ語 (ラテン文字)",
  "ha_Latn_GH": "ハウサ語 (ラテン文字, ガーナ)",
  "ha_Latn_NE": "ハウサ語 (ラテン文字, ニジェール)",
  "ha_Latn_NG": "ハウサ語 (ラテン文字, ナイジェリア)",
  "ha_NE": "ハウサ語 (ニジェール)",
  "ha_NG": "ハウサ語 (ナイジェリア)",
  "hai": "ハイダ語",
  "hak": "客家語",
  "haw": "ハワイ語",
  "he": "ヘブライ語",
  "he_IL": "ヘブライ語 (イスラエル)",
  "hi": "ヒンディー語",
  "hi_IN": "ヒンディー語 (インド)",
  "hif": "フィジー・ヒンディー語",
  "hil": "ヒリガイノン語",
  "him": "ヒマチャル語",
  "hit": "ヒッタイト語",
  "hmn": "フモン語",
  "ho": "ヒリモツ語",
  "hr": "クロアチア語",
  "hr_BA": "クロアチア語 (ボスニア・ヘルツェゴビナ)",
  "hr_HR": "クロアチア語 (クロアチア)",
  "hsb": "高地ソルブ語",
  "hsn": "湘語",
  "ht": "ハイチ・クレオール語",
  "hu": "ハンガリー語",
  "hu_HU": "ハンガリー語 (ハンガリー)",
  "hup": "フパ語",
  "hy": "アルメニア語",
  "hy_AM": "アルメニア語 (アルメニア)",
  "hz": "ヘレロ語",
  "ia": "インターリングア",
  "iba": "イバン語",
  "ibb": "イビビオ語",
  "id": "インドネシア語",
  "id_ID": "インドネシア語 (インドネシア)",
  "ie": "インターリング",
  "ig": "イボ語",
  "ig_NG": "イボ語 (ナイジェリア)",
  "ii": "四川イ語",
  "ii_CN": "四川イ語 (中国)",
  "ijo": "イジョー語",
  "ik": "イヌピアック語",
  "ilo": "イロカノ語",
  "inc": "インド諸語",
  "ine": "印欧諸語",
  "inh": "イングーシ語",
  "io": "イド語",
  "ira": "イラン語",
  "iro": "イロコイ語族",
  "is": "アイスランド語",
  "is_IS": "アイスランド語 (アイスランド)",
  "it": "イタリア語",
  "it_CH": "イタリア語 (スイス)",
  "it_IT": "イタリア語 (イタリア)",
  "it_SM": "イタリア語 (サンマリノ)",
  "iu": "イヌクティトット語",
  "izh": "イングリア語",
  "ja": "日本語",
  "ja_JP": "日本語 (日本)",
  "jam": "ジャマイカ・クレオール語",
  "jbo": "ロジバン語",
  "jgo": "ンゴンバ語",
  "jmc": "マチャメ語",
  "jpr": "ユダヤ・ペルシア語",
  "jrb": "ユダヤ・アラビア語",
  "jut": "ユトランド語",
  "jv": "ジャワ語",
  "ka": "ジョージア語",
  "ka_GE": "グルジア語 (グルジア)",
  "kaa": "カラカルパク語",
  "kab": "カビル語",
  "kac": "カチン語",
  "kaj": "カジェ語",
  "kam": "カンバ語",
  "kar": "カレン語",
  "kaw": "カウィ語",
  "kbd": "カバルド語",
  "kbl": "カネンブ語",
  "kcg": "カタブ語",
  "kde": "マコンデ語",
  "kea": "カーボベルデ・クレオール語",
  "ken": "ニャン語",
  "kfo": "コロ語",
  "kg": "コンゴ語",
  "kgp": "カインガング語",
  "kha": "カシ語",
  "khi": "コイサン諸語",
  "kho": "コータン語",
  "khq": "コイラ・チーニ語",
  "khw": "コワール語",
  "ki": "キクユ語",
  "ki_KE": "キクユ語 (ケニア)",
  "kiu": "キルマンジュキ語",
  "kj": "クワニャマ語",
  "kk": "カザフ語",
  "kk_Cyrl": "カザフ語 (キリル文字)",
  "kk_Cyrl_KZ": "カザフ語 (キリル文字, カザフスタン)",
  "kk_KZ": "カザフ語 (カザフスタン)",
  "kkj": "カコ語",
  "kl": "グリーンランド語",
  "kl_GL": "グリーンランド語 (グリーンランド)",
  "kln": "カレンジン語",
  "km": "クメール語",
  "km_KH": "クメール語 (カンボジア)",
  "kmb": "キンブンド語",
  "kn": "カンナダ語",
  "kn_IN": "カンナダ語 (インド)",
  "ko": "韓国語",
  "ko_KP": "韓国語 (朝鮮民主主義人民共和国)",
  "ko_KR": "韓国語 (大韓民国)",
  "koi": "コミ・ペルミャク語",
  "kok": "コンカニ語",
  "kos": "コスラエ語",
  "kpe": "クペレ語",
  "kr": "カヌリ語",
  "krc": "カラチャイ・バルカル語",
  "kri": "クリオ語",
  "krj": "キナライア語",
  "krl": "カレリア語",
  "kro": "クルー語",
  "kru": "クルク語",
  "ks": "カシミール語",
  "ks_Arab": "カシミール語 (アラビア文字)",
  "ks_Arab_IN": "カシミール語 (アラビア文字, インド)",
  "ks_IN": "カシミール語 (インド)",
  "ksb": "サンバー語",
  "ksf": "バフィア語",
  "ksh": "ケルン語",
  "ku": "クルド語",
  "kum": "クムク語",
  "kut": "クテナイ語",
  "kv": "コミ語",
  "kw": "コーンウォール語",
  "kw_GB": "コーンウォール語 (イギリス)",
  "ky": "キルギス語",
  "ky_Cyrl": "キルギス語 (キリル文字)",
  "ky_Cyrl_KG": "キルギス語 (キリル文字, キルギス)",
  "ky_KG": "キルギス語 (キルギス)",
  "la": "ラテン語",
  "lad": "ラディノ語",
  "lag": "ランギ語",
  "lah": "ラフンダー語",
  "lam": "ランバ語",
  "lb": "ルクセンブルク語",
  "lb_LU": "ルクセンブルク語 (ルクセンブルグ)",
  "lez": "レズギ語",
  "lfn": "リングア・フランカ・ノバ",
  "lg": "ガンダ語",
  "lg_UG": "ガンダ語 (ウガンダ)",
  "li": "リンブルフ語",
  "lij": "リグリア語",
  "liv": "リヴォニア語",
  "lkt": "ラコタ語",
  "lmo": "ロンバルド語",
  "ln": "リンガラ語",
  "ln_AO": "リンガラ語 (アンゴラ)",
  "ln_CD": "リンガラ語 (コンゴ民主共和国(キンシャサ))",
  "ln_CF": "リンガラ語 (中央アフリカ共和国)",
  "ln_CG": "リンガラ語 (コンゴ共和国(ブラザビル))",
  "lo": "ラオ語",
  "lo_LA": "ラオ語 (ラオス)",
  "lol": "モンゴ語",
  "lou": "ルイジアナ・クレオール語",
  "loz": "ロジ語",
  "lrc": "北ロル語",
  "lt": "リトアニア語",
  "lt_LT": "リトアニア語 (リトアニア)",
  "ltg": "ラトガリア語",
  "lu": "ルバ・カタンガ語",
  "lu_CD": "ルバ・カタンガ語 (コンゴ民主共和国(キンシャサ))",
  "lua": "ルバ・ルルア語",
  "lui": "ルイセーニョ語",
  "lun": "ルンダ語",
  "luo": "ルオ語",
  "lus": "ミゾ語",
  "luy": "ルヒヤ語",
  "lv": "ラトビア語",
  "lv_LV": "ラトビア語 (ラトビア)",
  "lzh": "漢文",
  "lzz": "ラズ語",
  "mad": "マドゥラ語",
  "maf": "マファ語",
  "mag": "マガヒー語",
  "mai": "マイティリー語",
  "mak": "マカッサル語",
  "man": "マンディンゴ語",
  "map": "オーストロネシア諸語",
  "mas": "マサイ語",
  "mde": "マバ語",
  "mdf": "モクシャ語",
  "mdr": "マンダル語",
  "men": "メンデ語",
  "mer": "メル語",
  "mfe": "モーリシャス・クレオール語",
  "mg": "マダガスカル語",
  "mg_MG": "マダガスカル語 (マダガスカル)",
  "mga": "中期アイルランド語",
  "mgh": "マクア・ミート語",
  "mgo": "メタ語",
  "mh": "マーシャル語",
  "mi": "マオリ語",
  "mic": "ミクマク語",
  "min": "ミナンカバウ語",
  "mis": "その他の言語",
  "mk": "マケドニア語",
  "mk_MK": "マケドニア語 (マケドニア)",
  "mkh": "モン・クメール諸語",
  "ml": "マラヤーラム語",
  "ml_IN": "マラヤーラム語 (インド)",
  "mn": "モンゴル語",
  "mn_Cyrl": "モンゴル語 (キリル文字)",
  "mn_Cyrl_MN": "モンゴル語 (キリル文字, モンゴル)",
  "mn_MN": "モンゴル語 (モンゴル)",
  "mnc": "満州語",
  "mni": "マニプリ語",
  "mno": "マノボ語族",
  "mo": "モルダビア語",
  "moh": "モーホーク語",
  "mos": "モシ語",
  "mr": "マラーティー語",
  "mr_IN": "マラーティー語 (インド)",
  "mrj": "山地マリ語",
  "ms": "マレー語",
  "ms_BN": "マレー語 (ブルネイ)",
  "ms_Latn": "マレー語 (ラテン文字)",
  "ms_Latn_BN": "マレー語 (ラテン文字, ブルネイ)",
  "ms_Latn_MY": "マレー語 (ラテン文字, マレーシア)",
  "ms_Latn_SG": "マレー語 (ラテン文字, シンガポール)",
  "ms_MY": "マレー語 (マレーシア)",
  "ms_SG": "マレー語 (シンガポール)",
  "mt": "マルタ語",
  "mt_MT": "マルタ語 (マルタ)",
  "mua": "ムンダン語",
  "mul": "複数言語",
  "mun": "ムンダ語族",
  "mus": "クリーク語",
  "mwl": "ミランダ語",
  "mwr": "マールワーリー語",
  "mwv": "メンタワイ語",
  "my": "ミャンマー語",
  "my_MM": "ビルマ語 (ミャンマー)",
  "mye": "ミエネ語",
  "myn": "マヤ語族",
  "myv": "エルジャ語",
  "mzn": "マーザンダラーン語",
  "na": "ナウル語",
  "nah": "ナワトル語",
  "nai": "北米インディアン諸語",
  "nan": "閩南語",
  "nap": "ナポリ語",
  "naq": "ナマ語",
  "nb": "ノルウェー語(ブークモール)",
  "nb_NO": "ノルウェー語(ブークモール) (ノルウェー)",
  "nb_SJ": "ノルウェー語(ブークモール) (スバールバル諸島・ヤンマイエン島)",
  "nd": "北ンデベレ語",
  "nd_ZW": "北ンデベレ語 (ジンバブエ)",
  "nds": "低地ドイツ語",
  "nds_NL": "オランダ低ザクセン",
  "ne": "ネパール語",
  "ne_IN": "ネパール語 (インド)",
  "ne_NP": "ネパール語 (ネパール)",
  "new": "ネワール語",
  "ng": "ンドンガ語",
  "nia": "ニアス語",
  "nic": "ニジェール・コルドファン諸語",
  "niu": "ニウーエイ語",
  "njo": "アオ・ナガ語",
  "nl": "オランダ語",
  "nl_AW": "オランダ語 (アルバ)",
  "nl_BE": "オランダ語 (ベルギー)",
  "nl_BQ": "オランダ語 (オランダ領カリブ)",
  "nl_CW": "オランダ語 (キュラソー)",
  "nl_NL": "オランダ語 (オランダ)",
  "nl_SR": "オランダ語 (スリナム)",
  "nl_SX": "オランダ語 (シント・マールテン)",
  "nmg": "クワシオ語",
  "nn": "ノルウェー語(ニーノシュク)",
  "nn_NO": "ノルウェー語(ニーノシュク) (ノルウェー)",
  "nnh": "ンジエムブーン語",
  "no": "ノルウェー語",
  "no_NO": "ノルウェー語 (ノルウェー)",
  "nog": "ノガイ語",
  "non": "古ノルド語",
  "nov": "ノヴィアル",
  "nqo": "ンコ語",
  "nr": "南ンデベレ語",
  "nso": "北部ソト語",
  "nub": "ヌビア語族",
  "nus": "ヌエル語",
  "nv": "ナバホ語",
  "nwc": "古典ネワール語",
  "ny": "ニャンジャ語",
  "nym": "ニャムウェジ語",
  "nyn": "ニャンコレ語",
  "nyo": "ニョロ語",
  "nzi": "ンゼマ語",
  "oc": "オック語",
  "oj": "オジブウェー語",
  "om": "オロモ語",
  "om_ET": "オロモ語 (エチオピア)",
  "om_KE": "オロモ語 (ケニア)",
  "or": "オディア語",
  "or_IN": "オリヤー語 (インド)",
  "os": "オセット語",
  "os_GE": "オセット語 (グルジア)",
  "os_RU": "オセット語 (ロシア)",
  "osa": "オセージ語",
  "ota": "オスマントルコ語",
  "oto": "オトミ語族",
  "pa": "パンジャブ語",
  "pa_Arab": "パンジャブ語 (アラビア文字)",
  "pa_Arab_PK": "パンジャブ語 (アラビア文字, パキスタン)",
  "pa_Guru": "パンジャブ語 (グルムキー文字)",
  "pa_Guru_IN": "パンジャブ語 (グルムキー文字, インド)",
  "pa_IN": "パンジャブ語 (インド)",
  "pa_PK": "パンジャブ語 (パキスタン)",
  "paa": "パプア諸語",
  "pag": "パンガシナン語",
  "pal": "パフラヴィー語",
  "pam": "パンパンガ語",
  "pap": "パピアメント語",
  "pau": "パラオ語",
  "pcd": "ピカルディ語",
  "pcm": "ナイジェリア・ピジン語",
  "pdc": "ペンシルベニア・ドイツ語",
  "pdt": "メノナイト低地ドイツ語",
  "peo": "古代ペルシア語",
  "pfl": "プファルツ語",
  "phi": "フィリピン諸語",
  "phn": "フェニキア語",
  "pi": "パーリ語",
  "pl": "ポーランド語",
  "pl_PL": "ポーランド語 (ポーランド)",
  "pms": "ピエモンテ語",
  "pnt": "ポントス・ギリシャ語",
  "pon": "ポンペイ語",
  "pra": "プラークリット語族",
  "prg": "プロシア語",
  "pro": "古期プロバンス語",
  "ps": "パシュトゥー語",
  "ps_AF": "パシュトゥー語 (アフガニスタン)",
  "pt": "ポルトガル語",
  "pt_AO": "ポルトガル語 (アンゴラ)",
  "pt_BR": "ポルトガル語 (ブラジル)",
  "pt_CV": "ポルトガル語 (カーボベルデ)",
  "pt_GW": "ポルトガル語 (ギニアビサウ)",
  "pt_MO": "ポルトガル語 (中華人民共和国マカオ特別行政区)",
  "pt_MZ": "ポルトガル語 (モザンビーク)",
  "pt_PT": "ポルトガル語 (ポルトガル)",
  "pt_ST": "ポルトガル語 (サントメ・プリンシペ)",
  "pt_TL": "ポルトガル語 (東ティモール)",
  "qu": "ケチュア語",
  "qu_BO": "ケチュア語 (ボリビア)",
  "qu_EC": "ケチュア語 (エクアドル)",
  "qu_PE": "ケチュア語 (ペルー)",
  "quc": "キチェ語",
  "qug": "チンボラソ高地ケチュア語",
  "raj": "ラージャスターン語",
  "rap": "ラパヌイ語",
  "rar": "ラロトンガ語",
  "rgn": "ロマーニャ語",
  "rif": "リーフ語",
  "rm": "ロマンシュ語",
  "rm_CH": "ロマンシュ語 (スイス)",
  "rn": "ルンディ語",
  "rn_BI": "ルンディ語 (ブルンジ)",
  "ro": "ルーマニア語",
  "ro_MD": "ルーマニア語 (モルドバ)",
  "ro_RO": "ルーマニア語 (ルーマニア)",
  "roa": "ロマンス諸語",
  "rof": "ロンボ語",
  "rom": "ロマーニー語",
  "root": "ルート",
  "rtm": "ロツマ語",
  "ru": "ロシア語",
  "ru_BY": "ロシア語 (ベラルーシ)",
  "ru_KG": "ロシア語 (キルギス)",
  "ru_KZ": "ロシア語 (カザフスタン)",
  "ru_MD": "ロシア語 (モルドバ)",
  "ru_RU": "ロシア語 (ロシア)",
  "ru_UA": "ロシア語 (ウクライナ)",
  "rue": "ルシン語",
  "rug": "ロヴィアナ語",
  "rup": "アルーマニア語",
  "rw": "キニアルワンダ語",
  "rw_RW": "ルワンダ語 (ルワンダ)",
  "rwk": "ルワ語",
  "sa": "サンスクリット語",
  "sad": "サンダウェ語",
  "sah": "サハ語",
  "sai": "南米インディアン諸語",
  "sal": "セイリッシュ語族",
  "sam": "サマリア・アラム語",
  "saq": "サンブル語",
  "sas": "ササク語",
  "sat": "サンターリー語",
  "saz": "サウラーシュトラ語",
  "sba": "ンガムバイ語",
  "sbp": "サング語",
  "sc": "サルデーニャ語",
  "scn": "シチリア語",
  "sco": "スコットランド語",
  "sd": "シンド語",
  "sd_Deva": "シンド語（デーヴァナーガリー）",
  "sdc": "サッサリ・サルデーニャ語",
  "sdh": "南部クルド語",
  "se": "北サーミ語",
  "se_FI": "北サーミ語 (フィンランド)",
  "se_NO": "北サーミ語 (ノルウェー)",
  "se_SE": "北サーミ語 (スウェーデン)",
  "see": "セネカ語",
  "seh": "セナ語",
  "sei": "セリ語",
  "sel": "セリクプ語",
  "sem": "セム諸語",
  "ses": "コイラボロ・センニ語",
  "sg": "サンゴ語",
  "sg_CF": "サンゴ語 (中央アフリカ共和国)",
  "sga": "古アイルランド語",
  "sgn": "手まね言語",
  "sgs": "サモギティア語",
  "sh": "セルボ・クロアチア語",
  "sh_BA": "セルボ・クロアチア語 (ボスニア・ヘルツェゴビナ)",
  "shi": "タシルハイト語",
  "shi_Latn": "シルハ語（ラテン語）",
  "shi_Tfng": "シルハ語（ティフィナグ文字）",
  "shn": "シャン語",
  "shu": "チャド・アラビア語",
  "si": "シンハラ語",
  "si_LK": "シンハラ語 (スリランカ)",
  "sid": "シダモ語",
  "sio": "スー語族",
  "sit": "シナ・チベット諸語",
  "sk": "スロバキア語",
  "sk_SK": "スロバキア語 (スロバキア)",
  "sl": "スロベニア語",
  "sl_SI": "スロベニア語 (スロベニア)",
  "sla": "スラブ諸語",
  "sli": "低シレジア語",
  "sly": "スラヤール語",
  "sm": "サモア語",
  "sma": "南サーミ語",
  "smi": "サーミ諸語",
  "smj": "ルレ・サーミ語",
  "smn": "イナリ・サーミ語",
  "sms": "スコルト・サーミ語",
  "sn": "ショナ語",
  "sn_ZW": "ショナ語 (ジンバブエ)",
  "snk": "ソニンケ語",
  "so": "ソマリ語",
  "so_DJ": "ソマリ語 (ジブチ)",
  "so_ET": "ソマリ語 (エチオピア)",
  "so_KE": "ソマリ語 (ケニア)",
  "so_SO": "ソマリ語 (ソマリア)",
  "sog": "ソグド語",
  "son": "ソンガイ語",
  "sq": "アルバニア語",
  "sq_AL": "アルバニア語 (アルバニア)",
  "sq_MK": "アルバニア語 (マケドニア)",
  "sq_XK": "アルバニア語 (コソボ)",
  "sr": "セルビア語",
  "sr_BA": "セルビア語 (ボスニア・ヘルツェゴビナ)",
  "sr_Cyrl": "セルビア語 (キリル文字)",
  "sr_Cyrl_BA": "セルビア語 (キリル文字, ボスニア・ヘルツェゴビナ)",
  "sr_Cyrl_ME": "セルビア語 (キリル文字, モンテネグロ)",
  "sr_Cyrl_RS": "セルビア語 (キリル文字, セルビア)",
  "sr_Cyrl_XK": "セルビア語 (キリル文字, コソボ)",
  "sr_Latn": "セルビア語 (ラテン文字)",
  "sr_Latn_BA": "セルビア語 (ラテン文字, ボスニア・ヘルツェゴビナ)",
  "sr_Latn_ME": "セルビア語 (ラテン文字, モンテネグロ)",
  "sr_Latn_RS": "セルビア語 (ラテン文字, セルビア)",
  "sr_Latn_XK": "セルビア語 (ラテン文字, コソボ)",
  "sr_ME": "セルビア語 (モンテネグロ)",
  "sr_RS": "セルビア語 (セルビア)",
  "sr_XK": "セルビア語 (コソボ)",
  "srn": "スリナム語",
  "srr": "セレル語",
  "ss": "スワジ語",
  "ssa": "ナイル・サハラ諸語",
  "ssy": "サホ語",
  "st": "南部ソト語",
  "stq": "ザーターフリジア語",
  "su": "スンダ語",
  "suk": "スクマ語",
  "sus": "スス語",
  "sux": "シュメール語",
  "sv": "スウェーデン語",
  "sv_AX": "スウェーデン語 (オーランド諸島)",
  "sv_FI": "スウェーデン語 (フィンランド)",
  "sv_SE": "スウェーデン語 (スウェーデン)",
  "sw": "スワヒリ語",
  "sw_CD": "コンゴ・スワヒリ語",
  "sw_KE": "スワヒリ語 (ケニア)",
  "sw_TZ": "スワヒリ語 (タンザニア)",
  "sw_UG": "スワヒリ語 (ウガンダ)",
  "swb": "コモロ語",
  "swc": "コンゴ・スワヒリ語",
  "syc": "古典シリア語",
  "syr": "シリア語",
  "szl": "シレジア語",
  "ta": "タミル語",
  "ta_IN": "タミル語 (インド)",
  "ta_LK": "タミル語 (スリランカ)",
  "ta_MY": "タミル語 (マレーシア)",
  "ta_SG": "タミル語 (シンガポール)",
  "tai": "タイ諸語",
  "tcy": "トゥル語",
  "te": "テルグ語",
  "te_IN": "テルグ語 (インド)",
  "tem": "テムネ語",
  "teo": "テソ語",
  "ter": "テレーノ語",
  "tet": "テトゥン語",
  "tg": "タジク語",
  "th": "タイ語",
  "th_TH": "タイ語 (タイ)",
  "ti": "ティグリニア語",
  "ti_ER": "ティグリニア語 (エリトリア)",
  "ti_ET": "ティグリニア語 (エチオピア)",
  "tig": "ティグレ語",
  "tiv": "ティブ語",
  "tk": "トルクメン語",
  "tkl": "トケラウ語",
  "tkr": "ツァフル語",
  "tl": "タガログ語",
  "tl_PH": "タガログ語 (フィリピン)",
  "tlh": "クリンゴン語",
  "tli": "トリンギット語",
  "tly": "タリシュ語",
  "tmh": "タマシェク語",
  "tn": "ツワナ語",
  "to": "トンガ語",
  "to_TO": "トンガ語 (トンガ)",
  "tog": "トンガ語(ニアサ)",
  "tpi": "トク・ピシン語",
  "tr": "トルコ語",
  "tr_CY": "トルコ語 (キプロス)",
  "tr_TR": "トルコ語 (トルコ)",
  "tru": "トゥロヨ語",
  "trv": "タロコ語",
  "ts": "ツォンガ語",
  "tsd": "ツァコン語",
  "tsi": "チムシュ語",
  "tt": "タタール語",
  "ttt": "ムスリム・タタール語",
  "tum": "トゥンブカ語",
  "tup": "トゥピ語族",
  "tut": "アルタイ諸語",
  "tvl": "ツバル語",
  "tw": "トウィ語",
  "twq": "タサワク語",
  "ty": "タヒチ語",
  "tyv": "トゥヴァ語",
  "tzm": "中央アトラス・タマジクト語",
  "udm": "ウドムルト語",
  "ug": "ウイグル語",
  "ug_Arab": "ウイグル語 (アラビア文字)",
  "ug_Arab_CN": "ウイグル語 (アラビア文字, 中国)",
  "ug_CN": "ウイグル語 (中国)",
  "uga": "ウガリト語",
  "uk": "ウクライナ語",
  "uk_UA": "ウクライナ語 (ウクライナ)",
  "umb": "ムブンドゥ語",
  "und": "言語不明",
  "ur": "ウルドゥー語",
  "ur_IN": "ウルドゥー語 (インド)",
  "ur_PK": "ウルドゥー語 (パキスタン)",
  "uz": "ウズベク語",
  "uz_AF": "ウズベク語 (アフガニスタン)",
  "uz_Arab": "ウズベク語 (アラビア文字)",
  "uz_Arab_AF": "ウズベク語 (アラビア文字, アフガニスタン)",
  "uz_Cyrl": "ウズベク語 (キリル文字)",
  "uz_Cyrl_UZ": "ウズベク語 (キリル文字, ウズベキスタン)",
  "uz_Latn": "ウズベク語 (ラテン文字)",
  "uz_Latn_UZ": "ウズベク語 (ラテン文字, ウズベキスタン)",
  "uz_UZ": "ウズベク語 (ウズベキスタン)",
  "vai": "ヴァイ語",
  "vai_Latn": "ヴァイ（ラテン）",
  "ve": "ベンダ語",
  "vec": "ヴェネト語",
  "vep": "ヴェプス語",
  "vi": "ベトナム語",
  "vi_VN": "ベトナム語 (ベトナム)",
  "vls": "西フラマン語",
  "vmf": "マインフランク語",
  "vo": "ヴォラピュク語",
  "vot": "ヴォート語",
  "vro": "ヴォロ語",
  "vun": "ヴンジョ語",
  "wa": "ワロン語",
  "wae": "ヴァリス語",
  "wak": "ワカシ語族",
  "wal": "ウォライタ語",
  "war": "ワライ語",
  "was": "ワショ語",
  "wbp": "ワルピリ語",
  "wen": "ソルビア語族",
  "wo": "ウォロフ語",
  "wuu": "呉語",
  "xal": "カルムイク語",
  "xh": "コサ語",
  "xmf": "メグレル語",
  "xog": "ソガ語",
  "yao": "ヤオ語",
  "yap": "ヤップ語",
  "yav": "ヤンベン語",
  "ybb": "イエンバ語",
  "yi": "イディッシュ語",
  "yo": "ヨルバ語",
  "yo_BJ": "ヨルバ語 (ベナン)",
  "yo_NG": "ヨルバ語 (ナイジェリア)",
  "ypk": "ユピック語族",
  "yrl": "ニェエンガトゥ語",
  "yue": "広東語",
  "yue_Hans": "広東語（簡体字中国語）",
  "yue_Hant": "広東語（繁体字中国語）",
  "za": "チワン語",
  "zap": "サポテカ語",
  "zbl": "ブリスシンボル",
  "zea": "ゼーラント語",
  "zen": "ゼナガ語",
  "zgh": "標準モロッコ タマジクト語",
  "zh": "中国語",
  "zh_CN": "中国語 (中国)",
  "zh_HK": "中国語 (中華人民共和国香港特別行政区)",
  "zh_Hans": "中国語 (簡体字)",
  "zh_Hans_CN": "中国語 (簡体字, 中国)",
  "zh_Hans_HK": "中国語 (簡体字, 中華人民共和国香港特別行政区)",
  "zh_Hans_MO": "中国語 (簡体字, 中華人民共和国マカオ特別行政区)",
  "zh_Hans_SG": "中国語 (簡体字, シンガポール)",
  "zh_Hant": "中国語 (繁体字)",
  "zh_Hant_HK": "中国語 (繁体字, 中華人民共和国香港特別行政区)",
  "zh_Hant_MO": "中国語 (繁体字, 中華人民共和国マカオ特別行政区)",
  "zh_Hant_TW": "中国語 (繁体字, 台湾)",
  "zh_MO": "中国語 (中華人民共和国マカオ特別行政区)",
  "zh_SG": "中国語 (シンガポール)",
  "zh_TW": "中国語 (台湾)",
  "znd": "ザンデ語",
  "zu": "ズールー語",
  "zu_ZA": "ズールー語 (南アフリカ)",
  "zun": "ズニ語",
  "zxx": "言語的内容なし",
  "zza": "ザザ語"
};
