// This file is generated by automated scripts. Please do not leave your
// modification here.

// The MIT License (MIT)
//
// Copyright (c) 2013-2019 Khan Academy and other contributors
// Copyright (c) 2020 znjameswu <znjameswu@gmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

// This file is transfromed from KaTeX/src/symbols.js

import 'dart:ui';

import '../../ast/options.dart';
import '../../ast/syntax_tree.dart';
import '../../ast/types.dart';
import 'symbols_extra.dart';

class TexSymbolConfig {
  final String symbol;
  final bool variantForm;
  final AtomType? type;
  final FontOptions? font;

  const TexSymbolConfig(
    this.symbol, {
    this.variantForm = false,
    this.type,
    this.font,
  });
}

const mainrm = FontOptions();
const amsrm = FontOptions(fontFamily: 'AMS');
const mathdefault = FontOptions(
  fontFamily: 'Math',
  fontShape: FontStyle.italic,
);

const texSymbolCommandConfigs = {
  Mode.math: {
    '0': TexSymbolConfig('0'),
    '1': TexSymbolConfig('1'),
    '2': TexSymbolConfig('2'),
    '3': TexSymbolConfig('3'),
    '4': TexSymbolConfig('4'),
    '5': TexSymbolConfig('5'),
    '6': TexSymbolConfig('6'),
    '7': TexSymbolConfig('7'),
    '8': TexSymbolConfig('8'),
    '9': TexSymbolConfig('9'),
    '\u2261': TexSymbolConfig('\u2261'),
    '\u227A': TexSymbolConfig('\u227A'),
    '\u227B': TexSymbolConfig('\u227B'),
    '\u223C': TexSymbolConfig('\u223C'),
    '\u2AAF': TexSymbolConfig('\u2AAF'),
    '\u2AB0': TexSymbolConfig('\u2AB0'),
    '\u2243': TexSymbolConfig('\u2243'),
    '\u2223': TexSymbolConfig('\u2223'),
    '\u226A': TexSymbolConfig('\u226A'),
    '\u226B': TexSymbolConfig('\u226B'),
    '\u224D': TexSymbolConfig('\u224D'),
    '\u22C8': TexSymbolConfig('\u22C8'),
    '\u2323': TexSymbolConfig('\u2323'),
    '\u2291': TexSymbolConfig('\u2291'),
    '\u2292': TexSymbolConfig('\u2292'),
    '\u2250': TexSymbolConfig('\u2250'),
    '\u2322': TexSymbolConfig('\u2322'),
    '\u220B': TexSymbolConfig('\u220B'),
    '\u221D': TexSymbolConfig('\u221D'),
    '\u22A2': TexSymbolConfig('\u22A2'),
    '\u22A3': TexSymbolConfig('\u22A3'),
    '\u2135': TexSymbolConfig('\u2135'),
    '\u2200': TexSymbolConfig('\u2200'),
    '\u210F': TexSymbolConfig('\u210F'),
    '\u2203': TexSymbolConfig('\u2203'),
    '\u2207': TexSymbolConfig('\u2207'),
    '\u266D': TexSymbolConfig('\u266D'),
    '\u2113': TexSymbolConfig('\u2113'),
    '\u266E': TexSymbolConfig('\u266E'),
    '\u2663': TexSymbolConfig('\u2663'),
    '\u2118': TexSymbolConfig('\u2118'),
    '\u266F': TexSymbolConfig('\u266F'),
    '\u2662': TexSymbolConfig('\u2662'),
    '\u211C': TexSymbolConfig('\u211C'),
    '\u2661': TexSymbolConfig('\u2661'),
    '\u2111': TexSymbolConfig('\u2111'),
    '\u2660': TexSymbolConfig('\u2660'),
    '\u23B1': TexSymbolConfig('\u23B1'),
    '\u23B0': TexSymbolConfig('\u23B0'),
    '\u27EF': TexSymbolConfig('\u27EF'),
    '\u27EE': TexSymbolConfig('\u27EE'),
    '\u2213': TexSymbolConfig('\u2213'),
    '\u2296': TexSymbolConfig('\u2296'),
    '\u228E': TexSymbolConfig('\u228E'),
    '\u2293': TexSymbolConfig('\u2293'),
    '\u2294': TexSymbolConfig('\u2294'),
    '\u2240': TexSymbolConfig('\u2240'),
    '\u27F5': TexSymbolConfig('\u27F5'),
    '\u21D0': TexSymbolConfig('\u21D0'),
    '\u27F8': TexSymbolConfig('\u27F8'),
    '\u27F6': TexSymbolConfig('\u27F6'),
    '\u21D2': TexSymbolConfig('\u21D2'),
    '\u27F9': TexSymbolConfig('\u27F9'),
    '\u2194': TexSymbolConfig('\u2194'),
    '\u27F7': TexSymbolConfig('\u27F7'),
    '\u21D4': TexSymbolConfig('\u21D4'),
    '\u27FA': TexSymbolConfig('\u27FA'),
    '\u21A6': TexSymbolConfig('\u21A6'),
    '\u27FC': TexSymbolConfig('\u27FC'),
    '\u2197': TexSymbolConfig('\u2197'),
    '\u21A9': TexSymbolConfig('\u21A9'),
    '\u21AA': TexSymbolConfig('\u21AA'),
    '\u2198': TexSymbolConfig('\u2198'),
    '\u21BC': TexSymbolConfig('\u21BC'),
    '\u21C0': TexSymbolConfig('\u21C0'),
    '\u2199': TexSymbolConfig('\u2199'),
    '\u21BD': TexSymbolConfig('\u21BD'),
    '\u21C1': TexSymbolConfig('\u21C1'),
    '\u2196': TexSymbolConfig('\u2196'),
    '\u21CC': TexSymbolConfig('\u21CC'),
    '\u226E': TexSymbolConfig('\u226E'),
    '\u2A87': TexSymbolConfig('\u2A87'),
    '\u2268': TexSymbolConfig('\u2268'),
    '\u22E6': TexSymbolConfig('\u22E6'),
    '\u2A89': TexSymbolConfig('\u2A89'),
    '\u2280': TexSymbolConfig('\u2280'),
    '\u22E0': TexSymbolConfig('\u22E0'),
    '\u22E8': TexSymbolConfig('\u22E8'),
    '\u2AB9': TexSymbolConfig('\u2AB9'),
    '\u2241': TexSymbolConfig('\u2241'),
    '\u2224': TexSymbolConfig('\u2224'),
    '\u22AC': TexSymbolConfig('\u22AC'),
    '\u22AD': TexSymbolConfig('\u22AD'),
    '\u22EC': TexSymbolConfig('\u22EC'),
    '\u228A': TexSymbolConfig('\u228A'),
    '\u2ACB': TexSymbolConfig('\u2ACB'),
    '\u226F': TexSymbolConfig('\u226F'),
    '\u2A88': TexSymbolConfig('\u2A88'),
    '\u2269': TexSymbolConfig('\u2269'),
    '\u22E7': TexSymbolConfig('\u22E7'),
    '\u2A8A': TexSymbolConfig('\u2A8A'),
    '\u2281': TexSymbolConfig('\u2281'),
    '\u22E1': TexSymbolConfig('\u22E1'),
    '\u22E9': TexSymbolConfig('\u22E9'),
    '\u2ABA': TexSymbolConfig('\u2ABA'),
    '\u2246': TexSymbolConfig('\u2246'),
    '\u2226': TexSymbolConfig('\u2226'),
    '\u22AF': TexSymbolConfig('\u22AF'),
    '\u22ED': TexSymbolConfig('\u22ED'),
    '\u228B': TexSymbolConfig('\u228B'),
    '\u2ACC': TexSymbolConfig('\u2ACC'),
    '\u22AE': TexSymbolConfig('\u22AE'),
    '\u2AB5': TexSymbolConfig('\u2AB5'),
    '\u2AB6': TexSymbolConfig('\u2AB6'),
    '\u219A': TexSymbolConfig('\u219A'),
    '\u219B': TexSymbolConfig('\u219B'),
    '\u21CD': TexSymbolConfig('\u21CD'),
    '\u21CF': TexSymbolConfig('\u21CF'),
    '\u21AE': TexSymbolConfig('\u21AE'),
    '\u21CE': TexSymbolConfig('\u21CE'),
    '\u2221': TexSymbolConfig('\u2221'),
    '\u2132': TexSymbolConfig('\u2132'),
    '\u2141': TexSymbolConfig('\u2141'),
    '\u2222': TexSymbolConfig('\u2222'),
    '\u2201': TexSymbolConfig('\u2201'),
    '\u00F0': TexSymbolConfig('\u00F0'),
    '\u00A5': TexSymbolConfig('\u00A5'),
    '\u2713': TexSymbolConfig('\u2713'),
    '\u2136': TexSymbolConfig('\u2136'),
    '\u2138': TexSymbolConfig('\u2138'),
    '\u2137': TexSymbolConfig('\u2137'),
    '\u03DD': TexSymbolConfig('\u03DD'),
    '\u250C': TexSymbolConfig('\u250C'),
    '\u2510': TexSymbolConfig('\u2510'),
    '\u2514': TexSymbolConfig('\u2514'),
    '\u2518': TexSymbolConfig('\u2518'),
    '\u2266': TexSymbolConfig('\u2266'),
    '\u2A7D': TexSymbolConfig('\u2A7D'),
    '\u2A95': TexSymbolConfig('\u2A95'),
    '\u2272': TexSymbolConfig('\u2272'),
    '\u2A85': TexSymbolConfig('\u2A85'),
    '\u224A': TexSymbolConfig('\u224A'),
    '\u22D8': TexSymbolConfig('\u22D8'),
    '\u2276': TexSymbolConfig('\u2276'),
    '\u22DA': TexSymbolConfig('\u22DA'),
    '\u2A8B': TexSymbolConfig('\u2A8B'),
    '\u2253': TexSymbolConfig('\u2253'),
    '\u2252': TexSymbolConfig('\u2252'),
    '\u223D': TexSymbolConfig('\u223D'),
    '\u22CD': TexSymbolConfig('\u22CD'),
    '\u2AC5': TexSymbolConfig('\u2AC5'),
    '\u22D0': TexSymbolConfig('\u22D0'),
    '\u228F': TexSymbolConfig('\u228F'),
    '\u227C': TexSymbolConfig('\u227C'),
    '\u22DE': TexSymbolConfig('\u22DE'),
    '\u227E': TexSymbolConfig('\u227E'),
    '\u2AB7': TexSymbolConfig('\u2AB7'),
    '\u22A8': TexSymbolConfig('\u22A8'),
    '\u22AA': TexSymbolConfig('\u22AA'),
    '\u224F': TexSymbolConfig('\u224F'),
    '\u224E': TexSymbolConfig('\u224E'),
    '\u2267': TexSymbolConfig('\u2267'),
    '\u2A7E': TexSymbolConfig('\u2A7E'),
    '\u2A96': TexSymbolConfig('\u2A96'),
    '\u2273': TexSymbolConfig('\u2273'),
    '\u2A86': TexSymbolConfig('\u2A86'),
    '\u22D9': TexSymbolConfig('\u22D9'),
    '\u2277': TexSymbolConfig('\u2277'),
    '\u22DB': TexSymbolConfig('\u22DB'),
    '\u2A8C': TexSymbolConfig('\u2A8C'),
    '\u2256': TexSymbolConfig('\u2256'),
    '\u2257': TexSymbolConfig('\u2257'),
    '\u225C': TexSymbolConfig('\u225C'),
    '\u2AC6': TexSymbolConfig('\u2AC6'),
    '\u22D1': TexSymbolConfig('\u22D1'),
    '\u2290': TexSymbolConfig('\u2290'),
    '\u227D': TexSymbolConfig('\u227D'),
    '\u22DF': TexSymbolConfig('\u22DF'),
    '\u227F': TexSymbolConfig('\u227F'),
    '\u2AB8': TexSymbolConfig('\u2AB8'),
    '\u22A9': TexSymbolConfig('\u22A9'),
    '\u226C': TexSymbolConfig('\u226C'),
    '\u22D4': TexSymbolConfig('\u22D4'),
    '\u2234': TexSymbolConfig('\u2234'),
    '\u2235': TexSymbolConfig('\u2235'),
    '\u2242': TexSymbolConfig('\u2242'),
    '\u2251': TexSymbolConfig('\u2251'),
    '\u2214': TexSymbolConfig('\u2214'),
    '\u22D2': TexSymbolConfig('\u22D2'),
    '\u22D3': TexSymbolConfig('\u22D3'),
    '\u2A5E': TexSymbolConfig('\u2A5E'),
    '\u229F': TexSymbolConfig('\u229F'),
    '\u229E': TexSymbolConfig('\u229E'),
    '\u22C7': TexSymbolConfig('\u22C7'),
    '\u22C9': TexSymbolConfig('\u22C9'),
    '\u22CA': TexSymbolConfig('\u22CA'),
    '\u22CB': TexSymbolConfig('\u22CB'),
    '\u22CC': TexSymbolConfig('\u22CC'),
    '\u22CF': TexSymbolConfig('\u22CF'),
    '\u22CE': TexSymbolConfig('\u22CE'),
    '\u229D': TexSymbolConfig('\u229D'),
    '\u229B': TexSymbolConfig('\u229B'),
    '\u22BA': TexSymbolConfig('\u22BA'),
    '\u22A0': TexSymbolConfig('\u22A0'),
    '\u21E2': TexSymbolConfig('\u21E2'),
    '\u21E0': TexSymbolConfig('\u21E0'),
    '\u21C7': TexSymbolConfig('\u21C7'),
    '\u21C6': TexSymbolConfig('\u21C6'),
    '\u21DA': TexSymbolConfig('\u21DA'),
    '\u219E': TexSymbolConfig('\u219E'),
    '\u21A2': TexSymbolConfig('\u21A2'),
    '\u21AB': TexSymbolConfig('\u21AB'),
    '\u21CB': TexSymbolConfig('\u21CB'),
    '\u21B6': TexSymbolConfig('\u21B6'),
    '\u21BA': TexSymbolConfig('\u21BA'),
    '\u21B0': TexSymbolConfig('\u21B0'),
    '\u21C8': TexSymbolConfig('\u21C8'),
    '\u21BF': TexSymbolConfig('\u21BF'),
    '\u21C3': TexSymbolConfig('\u21C3'),
    '\u22B8': TexSymbolConfig('\u22B8'),
    '\u21AD': TexSymbolConfig('\u21AD'),
    '\u21C9': TexSymbolConfig('\u21C9'),
    '\u21C4': TexSymbolConfig('\u21C4'),
    '\u21A0': TexSymbolConfig('\u21A0'),
    '\u21A3': TexSymbolConfig('\u21A3'),
    '\u21AC': TexSymbolConfig('\u21AC'),
    '\u21B7': TexSymbolConfig('\u21B7'),
    '\u21BB': TexSymbolConfig('\u21BB'),
    '\u21B1': TexSymbolConfig('\u21B1'),
    '\u21CA': TexSymbolConfig('\u21CA'),
    '\u21BE': TexSymbolConfig('\u21BE'),
    '\u21C2': TexSymbolConfig('\u21C2'),
    '\u21DD': TexSymbolConfig('\u21DD'),
    '\u21DB': TexSymbolConfig('\u21DB'),
    '`': TexSymbolConfig('`'),
    '\u2220': TexSymbolConfig('\u2220'),
    '\u221E': TexSymbolConfig('\u221E'),
    '\u0393': TexSymbolConfig('\u0393'),
    '\u0394': TexSymbolConfig('\u0394'),
    '\u0398': TexSymbolConfig('\u0398'),
    '\u039B': TexSymbolConfig('\u039B'),
    '\u039E': TexSymbolConfig('\u039E'),
    '\u03A0': TexSymbolConfig('\u03A0'),
    '\u03A3': TexSymbolConfig('\u03A3'),
    '\u03A5': TexSymbolConfig('\u03A5'),
    '\u03A6': TexSymbolConfig('\u03A6'),
    '\u03A8': TexSymbolConfig('\u03A8'),
    '\u03A9': TexSymbolConfig('\u03A9'),
    '\u0391': TexSymbolConfig('\u0391'),
    '\u0392': TexSymbolConfig('\u0392'),
    '\u0395': TexSymbolConfig('\u0395'),
    '\u0396': TexSymbolConfig('\u0396'),
    '\u0397': TexSymbolConfig('\u0397'),
    '\u0399': TexSymbolConfig('\u0399'),
    '\u039A': TexSymbolConfig('\u039A'),
    '\u039C': TexSymbolConfig('\u039C'),
    '\u039D': TexSymbolConfig('\u039D'),
    '\u039F': TexSymbolConfig('\u039F'),
    '\u03A1': TexSymbolConfig('\u03A1'),
    '\u03A4': TexSymbolConfig('\u03A4'),
    '\u03A7': TexSymbolConfig('\u03A7'),
    '\u00AC': TexSymbolConfig('\u00AC'),
    '\u03B1': TexSymbolConfig('\u03B1'),
    '\u03B2': TexSymbolConfig('\u03B2'),
    '\u03B3': TexSymbolConfig('\u03B3'),
    '\u03B4': TexSymbolConfig('\u03B4'),
    '\u03F5': TexSymbolConfig('\u03F5'),
    '\u03B6': TexSymbolConfig('\u03B6'),
    '\u03B7': TexSymbolConfig('\u03B7'),
    '\u03B8': TexSymbolConfig('\u03B8'),
    '\u03B9': TexSymbolConfig('\u03B9'),
    '\u03BA': TexSymbolConfig('\u03BA'),
    '\u03BB': TexSymbolConfig('\u03BB'),
    '\u03BC': TexSymbolConfig('\u03BC'),
    '\u03BD': TexSymbolConfig('\u03BD'),
    '\u03BE': TexSymbolConfig('\u03BE'),
    '\u03BF': TexSymbolConfig('\u03BF'),
    '\u03C0': TexSymbolConfig('\u03C0'),
    '\u03C1': TexSymbolConfig('\u03C1'),
    '\u03C3': TexSymbolConfig('\u03C3'),
    '\u03C4': TexSymbolConfig('\u03C4'),
    '\u03C5': TexSymbolConfig('\u03C5'),
    '\u03D5': TexSymbolConfig('\u03D5'),
    '\u03C7': TexSymbolConfig('\u03C7'),
    '\u03C8': TexSymbolConfig('\u03C8'),
    '\u03C9': TexSymbolConfig('\u03C9'),
    '\u03B5': TexSymbolConfig('\u03B5'),
    '\u03D1': TexSymbolConfig('\u03D1'),
    '\u03D6': TexSymbolConfig('\u03D6'),
    '\u03F1': TexSymbolConfig('\u03F1'),
    '\u03C2': TexSymbolConfig('\u03C2'),
    '\u03C6': TexSymbolConfig('\u03C6'),
    '*': TexSymbolConfig('*'),
    '+': TexSymbolConfig('+'),
    '-': TexSymbolConfig('-'),
    '\u22C5': TexSymbolConfig('\u22C5'),
    '\u00F7': TexSymbolConfig('\u00F7'),
    '\u00B1': TexSymbolConfig('\u00B1'),
    '\u00D7': TexSymbolConfig('\u00D7'),
    '\u2229': TexSymbolConfig('\u2229'),
    '\u222A': TexSymbolConfig('\u222A'),
    '\u2227': TexSymbolConfig('\u2227'),
    '\u2228': TexSymbolConfig('\u2228'),
    '(': TexSymbolConfig('('),
    '[': TexSymbolConfig('['),
    '\u27E8': TexSymbolConfig('\u27E8'),
    ')': TexSymbolConfig(')'),
    ']': TexSymbolConfig(']'),
    '?': TexSymbolConfig('?'),
    '!': TexSymbolConfig('!'),
    '\u27E9': TexSymbolConfig('\u27E9'),
    '=': TexSymbolConfig('='),
    '<': TexSymbolConfig('<'),
    '>': TexSymbolConfig('>'),
    ':': TexSymbolConfig(':'),
    '\u2248': TexSymbolConfig('\u2248'),
    '\u2245': TexSymbolConfig('\u2245'),
    '\u2265': TexSymbolConfig('\u2265'),
    '\u2208': TexSymbolConfig('\u2208'),
    '\u2282': TexSymbolConfig('\u2282'),
    '\u2283': TexSymbolConfig('\u2283'),
    '\u2286': TexSymbolConfig('\u2286'),
    '\u2287': TexSymbolConfig('\u2287'),
    '\u2288': TexSymbolConfig('\u2288'),
    '\u2289': TexSymbolConfig('\u2289'),
    '\u2190': TexSymbolConfig('\u2190'),
    '\u2264': TexSymbolConfig('\u2264'),
    '\u2192': TexSymbolConfig('\u2192'),
    '\u2271': TexSymbolConfig('\u2271'),
    '\u2270': TexSymbolConfig('\u2270'),
    ',': TexSymbolConfig(','),
    ';': TexSymbolConfig(';'),
    '\u22BC': TexSymbolConfig('\u22BC'),
    '\u22BB': TexSymbolConfig('\u22BB'),
    '\u2299': TexSymbolConfig('\u2299'),
    '\u2295': TexSymbolConfig('\u2295'),
    '\u2297': TexSymbolConfig('\u2297'),
    '\u2202': TexSymbolConfig('\u2202'),
    '\u2298': TexSymbolConfig('\u2298'),
    '\u229A': TexSymbolConfig('\u229A'),
    '\u22A1': TexSymbolConfig('\u22A1'),
    '\u230A': TexSymbolConfig('\u230A'),
    '\u230B': TexSymbolConfig('\u230B'),
    '\u2308': TexSymbolConfig('\u2308'),
    '\u2309': TexSymbolConfig('\u2309'),
    '|': TexSymbolConfig('|'),
    '\u2191': TexSymbolConfig('\u2191'),
    '\u21D1': TexSymbolConfig('\u21D1'),
    '\u2193': TexSymbolConfig('\u2193'),
    '\u21D3': TexSymbolConfig('\u21D3'),
    '\u2195': TexSymbolConfig('\u2195'),
    '\u21D5': TexSymbolConfig('\u21D5'),
    '\u2026': TexSymbolConfig('\u2026'),
    '\u22EF': TexSymbolConfig('\u22EF'),
    '\u22F1': TexSymbolConfig('\u22F1'),
    '\u0131': TexSymbolConfig('\u0131'),
    '\u0237': TexSymbolConfig('\u0237'),
    '\u00B0': TexSymbolConfig('\u00B0'),
    '\u00A3': TexSymbolConfig('\u00A3'),
    '/': TexSymbolConfig('/'),
    '@': TexSymbolConfig('@'),
    '.': TexSymbolConfig('.'),
    '\"': TexSymbolConfig('\"'),
    'A': TexSymbolConfig('A'),
    'B': TexSymbolConfig('B'),
    'C': TexSymbolConfig('C'),
    'D': TexSymbolConfig('D'),
    'E': TexSymbolConfig('E'),
    'F': TexSymbolConfig('F'),
    'G': TexSymbolConfig('G'),
    'H': TexSymbolConfig('H'),
    'I': TexSymbolConfig('I'),
    'J': TexSymbolConfig('J'),
    'K': TexSymbolConfig('K'),
    'L': TexSymbolConfig('L'),
    'M': TexSymbolConfig('M'),
    'N': TexSymbolConfig('N'),
    'O': TexSymbolConfig('O'),
    'P': TexSymbolConfig('P'),
    'Q': TexSymbolConfig('Q'),
    'R': TexSymbolConfig('R'),
    'S': TexSymbolConfig('S'),
    'T': TexSymbolConfig('T'),
    'U': TexSymbolConfig('U'),
    'V': TexSymbolConfig('V'),
    'W': TexSymbolConfig('W'),
    'X': TexSymbolConfig('X'),
    'Y': TexSymbolConfig('Y'),
    'Z': TexSymbolConfig('Z'),
    'a': TexSymbolConfig('a'),
    'b': TexSymbolConfig('b'),
    'c': TexSymbolConfig('c'),
    'd': TexSymbolConfig('d'),
    'e': TexSymbolConfig('e'),
    'f': TexSymbolConfig('f'),
    'g': TexSymbolConfig('g'),
    'h': TexSymbolConfig('h'),
    'i': TexSymbolConfig('i'),
    'j': TexSymbolConfig('j'),
    'k': TexSymbolConfig('k'),
    'l': TexSymbolConfig('l'),
    'm': TexSymbolConfig('m'),
    'n': TexSymbolConfig('n'),
    'o': TexSymbolConfig('o'),
    'p': TexSymbolConfig('p'),
    'q': TexSymbolConfig('q'),
    'r': TexSymbolConfig('r'),
    's': TexSymbolConfig('s'),
    't': TexSymbolConfig('t'),
    'u': TexSymbolConfig('u'),
    'v': TexSymbolConfig('v'),
    'w': TexSymbolConfig('w'),
    'x': TexSymbolConfig('x'),
    'y': TexSymbolConfig('y'),
    'z': TexSymbolConfig('z'),
    '\u2102': TexSymbolConfig('\u2102'),
    '\u210D': TexSymbolConfig('\u210D'),
    '\u2115': TexSymbolConfig('\u2115'),
    '\u2119': TexSymbolConfig('\u2119'),
    '\u211A': TexSymbolConfig('\u211A'),
    '\u211D': TexSymbolConfig('\u211D'),
    '\u2124': TexSymbolConfig('\u2124'),
    '\u210E': TexSymbolConfig('\u210E'),
    '\uD835\uDC00': TexSymbolConfig('\uD835\uDC00'),
    '\uD835\uDC34': TexSymbolConfig('\uD835\uDC34'),
    '\uD835\uDC68': TexSymbolConfig('\uD835\uDC68'),
    '\uD835\uDD04': TexSymbolConfig('\uD835\uDD04'),
    '\uD835\uDDA0': TexSymbolConfig('\uD835\uDDA0'),
    '\uD835\uDDD4': TexSymbolConfig('\uD835\uDDD4'),
    '\uD835\uDE08': TexSymbolConfig('\uD835\uDE08'),
    '\uD835\uDE70': TexSymbolConfig('\uD835\uDE70'),
    '\uD835\uDD38': TexSymbolConfig('\uD835\uDD38'),
    '\uD835\uDC9C': TexSymbolConfig('\uD835\uDC9C'),
    '\uD835\uDC01': TexSymbolConfig('\uD835\uDC01'),
    '\uD835\uDC35': TexSymbolConfig('\uD835\uDC35'),
    '\uD835\uDC69': TexSymbolConfig('\uD835\uDC69'),
    '\uD835\uDD05': TexSymbolConfig('\uD835\uDD05'),
    '\uD835\uDDA1': TexSymbolConfig('\uD835\uDDA1'),
    '\uD835\uDDD5': TexSymbolConfig('\uD835\uDDD5'),
    '\uD835\uDE09': TexSymbolConfig('\uD835\uDE09'),
    '\uD835\uDE71': TexSymbolConfig('\uD835\uDE71'),
    '\uD835\uDD39': TexSymbolConfig('\uD835\uDD39'),
    '\uD835\uDC9D': TexSymbolConfig('\uD835\uDC9D'),
    '\uD835\uDC02': TexSymbolConfig('\uD835\uDC02'),
    '\uD835\uDC36': TexSymbolConfig('\uD835\uDC36'),
    '\uD835\uDC6A': TexSymbolConfig('\uD835\uDC6A'),
    '\uD835\uDD06': TexSymbolConfig('\uD835\uDD06'),
    '\uD835\uDDA2': TexSymbolConfig('\uD835\uDDA2'),
    '\uD835\uDDD6': TexSymbolConfig('\uD835\uDDD6'),
    '\uD835\uDE0A': TexSymbolConfig('\uD835\uDE0A'),
    '\uD835\uDE72': TexSymbolConfig('\uD835\uDE72'),
    '\uD835\uDD3A': TexSymbolConfig('\uD835\uDD3A'),
    '\uD835\uDC9E': TexSymbolConfig('\uD835\uDC9E'),
    '\uD835\uDC03': TexSymbolConfig('\uD835\uDC03'),
    '\uD835\uDC37': TexSymbolConfig('\uD835\uDC37'),
    '\uD835\uDC6B': TexSymbolConfig('\uD835\uDC6B'),
    '\uD835\uDD07': TexSymbolConfig('\uD835\uDD07'),
    '\uD835\uDDA3': TexSymbolConfig('\uD835\uDDA3'),
    '\uD835\uDDD7': TexSymbolConfig('\uD835\uDDD7'),
    '\uD835\uDE0B': TexSymbolConfig('\uD835\uDE0B'),
    '\uD835\uDE73': TexSymbolConfig('\uD835\uDE73'),
    '\uD835\uDD3B': TexSymbolConfig('\uD835\uDD3B'),
    '\uD835\uDC9F': TexSymbolConfig('\uD835\uDC9F'),
    '\uD835\uDC04': TexSymbolConfig('\uD835\uDC04'),
    '\uD835\uDC38': TexSymbolConfig('\uD835\uDC38'),
    '\uD835\uDC6C': TexSymbolConfig('\uD835\uDC6C'),
    '\uD835\uDD08': TexSymbolConfig('\uD835\uDD08'),
    '\uD835\uDDA4': TexSymbolConfig('\uD835\uDDA4'),
    '\uD835\uDDD8': TexSymbolConfig('\uD835\uDDD8'),
    '\uD835\uDE0C': TexSymbolConfig('\uD835\uDE0C'),
    '\uD835\uDE74': TexSymbolConfig('\uD835\uDE74'),
    '\uD835\uDD3C': TexSymbolConfig('\uD835\uDD3C'),
    '\uD835\uDCA0': TexSymbolConfig('\uD835\uDCA0'),
    '\uD835\uDC05': TexSymbolConfig('\uD835\uDC05'),
    '\uD835\uDC39': TexSymbolConfig('\uD835\uDC39'),
    '\uD835\uDC6D': TexSymbolConfig('\uD835\uDC6D'),
    '\uD835\uDD09': TexSymbolConfig('\uD835\uDD09'),
    '\uD835\uDDA5': TexSymbolConfig('\uD835\uDDA5'),
    '\uD835\uDDD9': TexSymbolConfig('\uD835\uDDD9'),
    '\uD835\uDE0D': TexSymbolConfig('\uD835\uDE0D'),
    '\uD835\uDE75': TexSymbolConfig('\uD835\uDE75'),
    '\uD835\uDD3D': TexSymbolConfig('\uD835\uDD3D'),
    '\uD835\uDCA1': TexSymbolConfig('\uD835\uDCA1'),
    '\uD835\uDC06': TexSymbolConfig('\uD835\uDC06'),
    '\uD835\uDC3A': TexSymbolConfig('\uD835\uDC3A'),
    '\uD835\uDC6E': TexSymbolConfig('\uD835\uDC6E'),
    '\uD835\uDD0A': TexSymbolConfig('\uD835\uDD0A'),
    '\uD835\uDDA6': TexSymbolConfig('\uD835\uDDA6'),
    '\uD835\uDDDA': TexSymbolConfig('\uD835\uDDDA'),
    '\uD835\uDE0E': TexSymbolConfig('\uD835\uDE0E'),
    '\uD835\uDE76': TexSymbolConfig('\uD835\uDE76'),
    '\uD835\uDD3E': TexSymbolConfig('\uD835\uDD3E'),
    '\uD835\uDCA2': TexSymbolConfig('\uD835\uDCA2'),
    '\uD835\uDC07': TexSymbolConfig('\uD835\uDC07'),
    '\uD835\uDC3B': TexSymbolConfig('\uD835\uDC3B'),
    '\uD835\uDC6F': TexSymbolConfig('\uD835\uDC6F'),
    '\uD835\uDD0B': TexSymbolConfig('\uD835\uDD0B'),
    '\uD835\uDDA7': TexSymbolConfig('\uD835\uDDA7'),
    '\uD835\uDDDB': TexSymbolConfig('\uD835\uDDDB'),
    '\uD835\uDE0F': TexSymbolConfig('\uD835\uDE0F'),
    '\uD835\uDE77': TexSymbolConfig('\uD835\uDE77'),
    '\uD835\uDD3F': TexSymbolConfig('\uD835\uDD3F'),
    '\uD835\uDCA3': TexSymbolConfig('\uD835\uDCA3'),
    '\uD835\uDC08': TexSymbolConfig('\uD835\uDC08'),
    '\uD835\uDC3C': TexSymbolConfig('\uD835\uDC3C'),
    '\uD835\uDC70': TexSymbolConfig('\uD835\uDC70'),
    '\uD835\uDD0C': TexSymbolConfig('\uD835\uDD0C'),
    '\uD835\uDDA8': TexSymbolConfig('\uD835\uDDA8'),
    '\uD835\uDDDC': TexSymbolConfig('\uD835\uDDDC'),
    '\uD835\uDE10': TexSymbolConfig('\uD835\uDE10'),
    '\uD835\uDE78': TexSymbolConfig('\uD835\uDE78'),
    '\uD835\uDD40': TexSymbolConfig('\uD835\uDD40'),
    '\uD835\uDCA4': TexSymbolConfig('\uD835\uDCA4'),
    '\uD835\uDC09': TexSymbolConfig('\uD835\uDC09'),
    '\uD835\uDC3D': TexSymbolConfig('\uD835\uDC3D'),
    '\uD835\uDC71': TexSymbolConfig('\uD835\uDC71'),
    '\uD835\uDD0D': TexSymbolConfig('\uD835\uDD0D'),
    '\uD835\uDDA9': TexSymbolConfig('\uD835\uDDA9'),
    '\uD835\uDDDD': TexSymbolConfig('\uD835\uDDDD'),
    '\uD835\uDE11': TexSymbolConfig('\uD835\uDE11'),
    '\uD835\uDE79': TexSymbolConfig('\uD835\uDE79'),
    '\uD835\uDD41': TexSymbolConfig('\uD835\uDD41'),
    '\uD835\uDCA5': TexSymbolConfig('\uD835\uDCA5'),
    '\uD835\uDC0A': TexSymbolConfig('\uD835\uDC0A'),
    '\uD835\uDC3E': TexSymbolConfig('\uD835\uDC3E'),
    '\uD835\uDC72': TexSymbolConfig('\uD835\uDC72'),
    '\uD835\uDD0E': TexSymbolConfig('\uD835\uDD0E'),
    '\uD835\uDDAA': TexSymbolConfig('\uD835\uDDAA'),
    '\uD835\uDDDE': TexSymbolConfig('\uD835\uDDDE'),
    '\uD835\uDE12': TexSymbolConfig('\uD835\uDE12'),
    '\uD835\uDE7A': TexSymbolConfig('\uD835\uDE7A'),
    '\uD835\uDD42': TexSymbolConfig('\uD835\uDD42'),
    '\uD835\uDCA6': TexSymbolConfig('\uD835\uDCA6'),
    '\uD835\uDC0B': TexSymbolConfig('\uD835\uDC0B'),
    '\uD835\uDC3F': TexSymbolConfig('\uD835\uDC3F'),
    '\uD835\uDC73': TexSymbolConfig('\uD835\uDC73'),
    '\uD835\uDD0F': TexSymbolConfig('\uD835\uDD0F'),
    '\uD835\uDDAB': TexSymbolConfig('\uD835\uDDAB'),
    '\uD835\uDDDF': TexSymbolConfig('\uD835\uDDDF'),
    '\uD835\uDE13': TexSymbolConfig('\uD835\uDE13'),
    '\uD835\uDE7B': TexSymbolConfig('\uD835\uDE7B'),
    '\uD835\uDD43': TexSymbolConfig('\uD835\uDD43'),
    '\uD835\uDCA7': TexSymbolConfig('\uD835\uDCA7'),
    '\uD835\uDC0C': TexSymbolConfig('\uD835\uDC0C'),
    '\uD835\uDC40': TexSymbolConfig('\uD835\uDC40'),
    '\uD835\uDC74': TexSymbolConfig('\uD835\uDC74'),
    '\uD835\uDD10': TexSymbolConfig('\uD835\uDD10'),
    '\uD835\uDDAC': TexSymbolConfig('\uD835\uDDAC'),
    '\uD835\uDDE0': TexSymbolConfig('\uD835\uDDE0'),
    '\uD835\uDE14': TexSymbolConfig('\uD835\uDE14'),
    '\uD835\uDE7C': TexSymbolConfig('\uD835\uDE7C'),
    '\uD835\uDD44': TexSymbolConfig('\uD835\uDD44'),
    '\uD835\uDCA8': TexSymbolConfig('\uD835\uDCA8'),
    '\uD835\uDC0D': TexSymbolConfig('\uD835\uDC0D'),
    '\uD835\uDC41': TexSymbolConfig('\uD835\uDC41'),
    '\uD835\uDC75': TexSymbolConfig('\uD835\uDC75'),
    '\uD835\uDD11': TexSymbolConfig('\uD835\uDD11'),
    '\uD835\uDDAD': TexSymbolConfig('\uD835\uDDAD'),
    '\uD835\uDDE1': TexSymbolConfig('\uD835\uDDE1'),
    '\uD835\uDE15': TexSymbolConfig('\uD835\uDE15'),
    '\uD835\uDE7D': TexSymbolConfig('\uD835\uDE7D'),
    '\uD835\uDD45': TexSymbolConfig('\uD835\uDD45'),
    '\uD835\uDCA9': TexSymbolConfig('\uD835\uDCA9'),
    '\uD835\uDC0E': TexSymbolConfig('\uD835\uDC0E'),
    '\uD835\uDC42': TexSymbolConfig('\uD835\uDC42'),
    '\uD835\uDC76': TexSymbolConfig('\uD835\uDC76'),
    '\uD835\uDD12': TexSymbolConfig('\uD835\uDD12'),
    '\uD835\uDDAE': TexSymbolConfig('\uD835\uDDAE'),
    '\uD835\uDDE2': TexSymbolConfig('\uD835\uDDE2'),
    '\uD835\uDE16': TexSymbolConfig('\uD835\uDE16'),
    '\uD835\uDE7E': TexSymbolConfig('\uD835\uDE7E'),
    '\uD835\uDD46': TexSymbolConfig('\uD835\uDD46'),
    '\uD835\uDCAA': TexSymbolConfig('\uD835\uDCAA'),
    '\uD835\uDC0F': TexSymbolConfig('\uD835\uDC0F'),
    '\uD835\uDC43': TexSymbolConfig('\uD835\uDC43'),
    '\uD835\uDC77': TexSymbolConfig('\uD835\uDC77'),
    '\uD835\uDD13': TexSymbolConfig('\uD835\uDD13'),
    '\uD835\uDDAF': TexSymbolConfig('\uD835\uDDAF'),
    '\uD835\uDDE3': TexSymbolConfig('\uD835\uDDE3'),
    '\uD835\uDE17': TexSymbolConfig('\uD835\uDE17'),
    '\uD835\uDE7F': TexSymbolConfig('\uD835\uDE7F'),
    '\uD835\uDD47': TexSymbolConfig('\uD835\uDD47'),
    '\uD835\uDCAB': TexSymbolConfig('\uD835\uDCAB'),
    '\uD835\uDC10': TexSymbolConfig('\uD835\uDC10'),
    '\uD835\uDC44': TexSymbolConfig('\uD835\uDC44'),
    '\uD835\uDC78': TexSymbolConfig('\uD835\uDC78'),
    '\uD835\uDD14': TexSymbolConfig('\uD835\uDD14'),
    '\uD835\uDDB0': TexSymbolConfig('\uD835\uDDB0'),
    '\uD835\uDDE4': TexSymbolConfig('\uD835\uDDE4'),
    '\uD835\uDE18': TexSymbolConfig('\uD835\uDE18'),
    '\uD835\uDE80': TexSymbolConfig('\uD835\uDE80'),
    '\uD835\uDD48': TexSymbolConfig('\uD835\uDD48'),
    '\uD835\uDCAC': TexSymbolConfig('\uD835\uDCAC'),
    '\uD835\uDC11': TexSymbolConfig('\uD835\uDC11'),
    '\uD835\uDC45': TexSymbolConfig('\uD835\uDC45'),
    '\uD835\uDC79': TexSymbolConfig('\uD835\uDC79'),
    '\uD835\uDD15': TexSymbolConfig('\uD835\uDD15'),
    '\uD835\uDDB1': TexSymbolConfig('\uD835\uDDB1'),
    '\uD835\uDDE5': TexSymbolConfig('\uD835\uDDE5'),
    '\uD835\uDE19': TexSymbolConfig('\uD835\uDE19'),
    '\uD835\uDE81': TexSymbolConfig('\uD835\uDE81'),
    '\uD835\uDD49': TexSymbolConfig('\uD835\uDD49'),
    '\uD835\uDCAD': TexSymbolConfig('\uD835\uDCAD'),
    '\uD835\uDC12': TexSymbolConfig('\uD835\uDC12'),
    '\uD835\uDC46': TexSymbolConfig('\uD835\uDC46'),
    '\uD835\uDC7A': TexSymbolConfig('\uD835\uDC7A'),
    '\uD835\uDD16': TexSymbolConfig('\uD835\uDD16'),
    '\uD835\uDDB2': TexSymbolConfig('\uD835\uDDB2'),
    '\uD835\uDDE6': TexSymbolConfig('\uD835\uDDE6'),
    '\uD835\uDE1A': TexSymbolConfig('\uD835\uDE1A'),
    '\uD835\uDE82': TexSymbolConfig('\uD835\uDE82'),
    '\uD835\uDD4A': TexSymbolConfig('\uD835\uDD4A'),
    '\uD835\uDCAE': TexSymbolConfig('\uD835\uDCAE'),
    '\uD835\uDC13': TexSymbolConfig('\uD835\uDC13'),
    '\uD835\uDC47': TexSymbolConfig('\uD835\uDC47'),
    '\uD835\uDC7B': TexSymbolConfig('\uD835\uDC7B'),
    '\uD835\uDD17': TexSymbolConfig('\uD835\uDD17'),
    '\uD835\uDDB3': TexSymbolConfig('\uD835\uDDB3'),
    '\uD835\uDDE7': TexSymbolConfig('\uD835\uDDE7'),
    '\uD835\uDE1B': TexSymbolConfig('\uD835\uDE1B'),
    '\uD835\uDE83': TexSymbolConfig('\uD835\uDE83'),
    '\uD835\uDD4B': TexSymbolConfig('\uD835\uDD4B'),
    '\uD835\uDCAF': TexSymbolConfig('\uD835\uDCAF'),
    '\uD835\uDC14': TexSymbolConfig('\uD835\uDC14'),
    '\uD835\uDC48': TexSymbolConfig('\uD835\uDC48'),
    '\uD835\uDC7C': TexSymbolConfig('\uD835\uDC7C'),
    '\uD835\uDD18': TexSymbolConfig('\uD835\uDD18'),
    '\uD835\uDDB4': TexSymbolConfig('\uD835\uDDB4'),
    '\uD835\uDDE8': TexSymbolConfig('\uD835\uDDE8'),
    '\uD835\uDE1C': TexSymbolConfig('\uD835\uDE1C'),
    '\uD835\uDE84': TexSymbolConfig('\uD835\uDE84'),
    '\uD835\uDD4C': TexSymbolConfig('\uD835\uDD4C'),
    '\uD835\uDCB0': TexSymbolConfig('\uD835\uDCB0'),
    '\uD835\uDC15': TexSymbolConfig('\uD835\uDC15'),
    '\uD835\uDC49': TexSymbolConfig('\uD835\uDC49'),
    '\uD835\uDC7D': TexSymbolConfig('\uD835\uDC7D'),
    '\uD835\uDD19': TexSymbolConfig('\uD835\uDD19'),
    '\uD835\uDDB5': TexSymbolConfig('\uD835\uDDB5'),
    '\uD835\uDDE9': TexSymbolConfig('\uD835\uDDE9'),
    '\uD835\uDE1D': TexSymbolConfig('\uD835\uDE1D'),
    '\uD835\uDE85': TexSymbolConfig('\uD835\uDE85'),
    '\uD835\uDD4D': TexSymbolConfig('\uD835\uDD4D'),
    '\uD835\uDCB1': TexSymbolConfig('\uD835\uDCB1'),
    '\uD835\uDC16': TexSymbolConfig('\uD835\uDC16'),
    '\uD835\uDC4A': TexSymbolConfig('\uD835\uDC4A'),
    '\uD835\uDC7E': TexSymbolConfig('\uD835\uDC7E'),
    '\uD835\uDD1A': TexSymbolConfig('\uD835\uDD1A'),
    '\uD835\uDDB6': TexSymbolConfig('\uD835\uDDB6'),
    '\uD835\uDDEA': TexSymbolConfig('\uD835\uDDEA'),
    '\uD835\uDE1E': TexSymbolConfig('\uD835\uDE1E'),
    '\uD835\uDE86': TexSymbolConfig('\uD835\uDE86'),
    '\uD835\uDD4E': TexSymbolConfig('\uD835\uDD4E'),
    '\uD835\uDCB2': TexSymbolConfig('\uD835\uDCB2'),
    '\uD835\uDC17': TexSymbolConfig('\uD835\uDC17'),
    '\uD835\uDC4B': TexSymbolConfig('\uD835\uDC4B'),
    '\uD835\uDC7F': TexSymbolConfig('\uD835\uDC7F'),
    '\uD835\uDD1B': TexSymbolConfig('\uD835\uDD1B'),
    '\uD835\uDDB7': TexSymbolConfig('\uD835\uDDB7'),
    '\uD835\uDDEB': TexSymbolConfig('\uD835\uDDEB'),
    '\uD835\uDE1F': TexSymbolConfig('\uD835\uDE1F'),
    '\uD835\uDE87': TexSymbolConfig('\uD835\uDE87'),
    '\uD835\uDD4F': TexSymbolConfig('\uD835\uDD4F'),
    '\uD835\uDCB3': TexSymbolConfig('\uD835\uDCB3'),
    '\uD835\uDC18': TexSymbolConfig('\uD835\uDC18'),
    '\uD835\uDC4C': TexSymbolConfig('\uD835\uDC4C'),
    '\uD835\uDC80': TexSymbolConfig('\uD835\uDC80'),
    '\uD835\uDD1C': TexSymbolConfig('\uD835\uDD1C'),
    '\uD835\uDDB8': TexSymbolConfig('\uD835\uDDB8'),
    '\uD835\uDDEC': TexSymbolConfig('\uD835\uDDEC'),
    '\uD835\uDE20': TexSymbolConfig('\uD835\uDE20'),
    '\uD835\uDE88': TexSymbolConfig('\uD835\uDE88'),
    '\uD835\uDD50': TexSymbolConfig('\uD835\uDD50'),
    '\uD835\uDCB4': TexSymbolConfig('\uD835\uDCB4'),
    '\uD835\uDC19': TexSymbolConfig('\uD835\uDC19'),
    '\uD835\uDC4D': TexSymbolConfig('\uD835\uDC4D'),
    '\uD835\uDC81': TexSymbolConfig('\uD835\uDC81'),
    '\uD835\uDD1D': TexSymbolConfig('\uD835\uDD1D'),
    '\uD835\uDDB9': TexSymbolConfig('\uD835\uDDB9'),
    '\uD835\uDDED': TexSymbolConfig('\uD835\uDDED'),
    '\uD835\uDE21': TexSymbolConfig('\uD835\uDE21'),
    '\uD835\uDE89': TexSymbolConfig('\uD835\uDE89'),
    '\uD835\uDD51': TexSymbolConfig('\uD835\uDD51'),
    '\uD835\uDCB5': TexSymbolConfig('\uD835\uDCB5'),
    '\uD835\uDC1A': TexSymbolConfig('\uD835\uDC1A'),
    '\uD835\uDC4E': TexSymbolConfig('\uD835\uDC4E'),
    '\uD835\uDC82': TexSymbolConfig('\uD835\uDC82'),
    '\uD835\uDD1E': TexSymbolConfig('\uD835\uDD1E'),
    '\uD835\uDDBA': TexSymbolConfig('\uD835\uDDBA'),
    '\uD835\uDDEE': TexSymbolConfig('\uD835\uDDEE'),
    '\uD835\uDE22': TexSymbolConfig('\uD835\uDE22'),
    '\uD835\uDE8A': TexSymbolConfig('\uD835\uDE8A'),
    '\uD835\uDC1B': TexSymbolConfig('\uD835\uDC1B'),
    '\uD835\uDC4F': TexSymbolConfig('\uD835\uDC4F'),
    '\uD835\uDC83': TexSymbolConfig('\uD835\uDC83'),
    '\uD835\uDD1F': TexSymbolConfig('\uD835\uDD1F'),
    '\uD835\uDDBB': TexSymbolConfig('\uD835\uDDBB'),
    '\uD835\uDDEF': TexSymbolConfig('\uD835\uDDEF'),
    '\uD835\uDE23': TexSymbolConfig('\uD835\uDE23'),
    '\uD835\uDE8B': TexSymbolConfig('\uD835\uDE8B'),
    '\uD835\uDC1C': TexSymbolConfig('\uD835\uDC1C'),
    '\uD835\uDC50': TexSymbolConfig('\uD835\uDC50'),
    '\uD835\uDC84': TexSymbolConfig('\uD835\uDC84'),
    '\uD835\uDD20': TexSymbolConfig('\uD835\uDD20'),
    '\uD835\uDDBC': TexSymbolConfig('\uD835\uDDBC'),
    '\uD835\uDDF0': TexSymbolConfig('\uD835\uDDF0'),
    '\uD835\uDE24': TexSymbolConfig('\uD835\uDE24'),
    '\uD835\uDE8C': TexSymbolConfig('\uD835\uDE8C'),
    '\uD835\uDC1D': TexSymbolConfig('\uD835\uDC1D'),
    '\uD835\uDC51': TexSymbolConfig('\uD835\uDC51'),
    '\uD835\uDC85': TexSymbolConfig('\uD835\uDC85'),
    '\uD835\uDD21': TexSymbolConfig('\uD835\uDD21'),
    '\uD835\uDDBD': TexSymbolConfig('\uD835\uDDBD'),
    '\uD835\uDDF1': TexSymbolConfig('\uD835\uDDF1'),
    '\uD835\uDE25': TexSymbolConfig('\uD835\uDE25'),
    '\uD835\uDE8D': TexSymbolConfig('\uD835\uDE8D'),
    '\uD835\uDC1E': TexSymbolConfig('\uD835\uDC1E'),
    '\uD835\uDC52': TexSymbolConfig('\uD835\uDC52'),
    '\uD835\uDC86': TexSymbolConfig('\uD835\uDC86'),
    '\uD835\uDD22': TexSymbolConfig('\uD835\uDD22'),
    '\uD835\uDDBE': TexSymbolConfig('\uD835\uDDBE'),
    '\uD835\uDDF2': TexSymbolConfig('\uD835\uDDF2'),
    '\uD835\uDE26': TexSymbolConfig('\uD835\uDE26'),
    '\uD835\uDE8E': TexSymbolConfig('\uD835\uDE8E'),
    '\uD835\uDC1F': TexSymbolConfig('\uD835\uDC1F'),
    '\uD835\uDC53': TexSymbolConfig('\uD835\uDC53'),
    '\uD835\uDC87': TexSymbolConfig('\uD835\uDC87'),
    '\uD835\uDD23': TexSymbolConfig('\uD835\uDD23'),
    '\uD835\uDDBF': TexSymbolConfig('\uD835\uDDBF'),
    '\uD835\uDDF3': TexSymbolConfig('\uD835\uDDF3'),
    '\uD835\uDE27': TexSymbolConfig('\uD835\uDE27'),
    '\uD835\uDE8F': TexSymbolConfig('\uD835\uDE8F'),
    '\uD835\uDC20': TexSymbolConfig('\uD835\uDC20'),
    '\uD835\uDC54': TexSymbolConfig('\uD835\uDC54'),
    '\uD835\uDC88': TexSymbolConfig('\uD835\uDC88'),
    '\uD835\uDD24': TexSymbolConfig('\uD835\uDD24'),
    '\uD835\uDDC0': TexSymbolConfig('\uD835\uDDC0'),
    '\uD835\uDDF4': TexSymbolConfig('\uD835\uDDF4'),
    '\uD835\uDE28': TexSymbolConfig('\uD835\uDE28'),
    '\uD835\uDE90': TexSymbolConfig('\uD835\uDE90'),
    '\uD835\uDC21': TexSymbolConfig('\uD835\uDC21'),
    '\uD835\uDC55': TexSymbolConfig('\uD835\uDC55'),
    '\uD835\uDC89': TexSymbolConfig('\uD835\uDC89'),
    '\uD835\uDD25': TexSymbolConfig('\uD835\uDD25'),
    '\uD835\uDDC1': TexSymbolConfig('\uD835\uDDC1'),
    '\uD835\uDDF5': TexSymbolConfig('\uD835\uDDF5'),
    '\uD835\uDE29': TexSymbolConfig('\uD835\uDE29'),
    '\uD835\uDE91': TexSymbolConfig('\uD835\uDE91'),
    '\uD835\uDC22': TexSymbolConfig('\uD835\uDC22'),
    '\uD835\uDC56': TexSymbolConfig('\uD835\uDC56'),
    '\uD835\uDC8A': TexSymbolConfig('\uD835\uDC8A'),
    '\uD835\uDD26': TexSymbolConfig('\uD835\uDD26'),
    '\uD835\uDDC2': TexSymbolConfig('\uD835\uDDC2'),
    '\uD835\uDDF6': TexSymbolConfig('\uD835\uDDF6'),
    '\uD835\uDE2A': TexSymbolConfig('\uD835\uDE2A'),
    '\uD835\uDE92': TexSymbolConfig('\uD835\uDE92'),
    '\uD835\uDC23': TexSymbolConfig('\uD835\uDC23'),
    '\uD835\uDC57': TexSymbolConfig('\uD835\uDC57'),
    '\uD835\uDC8B': TexSymbolConfig('\uD835\uDC8B'),
    '\uD835\uDD27': TexSymbolConfig('\uD835\uDD27'),
    '\uD835\uDDC3': TexSymbolConfig('\uD835\uDDC3'),
    '\uD835\uDDF7': TexSymbolConfig('\uD835\uDDF7'),
    '\uD835\uDE2B': TexSymbolConfig('\uD835\uDE2B'),
    '\uD835\uDE93': TexSymbolConfig('\uD835\uDE93'),
    '\uD835\uDC24': TexSymbolConfig('\uD835\uDC24'),
    '\uD835\uDC58': TexSymbolConfig('\uD835\uDC58'),
    '\uD835\uDC8C': TexSymbolConfig('\uD835\uDC8C'),
    '\uD835\uDD28': TexSymbolConfig('\uD835\uDD28'),
    '\uD835\uDDC4': TexSymbolConfig('\uD835\uDDC4'),
    '\uD835\uDDF8': TexSymbolConfig('\uD835\uDDF8'),
    '\uD835\uDE2C': TexSymbolConfig('\uD835\uDE2C'),
    '\uD835\uDE94': TexSymbolConfig('\uD835\uDE94'),
    '\uD835\uDC25': TexSymbolConfig('\uD835\uDC25'),
    '\uD835\uDC59': TexSymbolConfig('\uD835\uDC59'),
    '\uD835\uDC8D': TexSymbolConfig('\uD835\uDC8D'),
    '\uD835\uDD29': TexSymbolConfig('\uD835\uDD29'),
    '\uD835\uDDC5': TexSymbolConfig('\uD835\uDDC5'),
    '\uD835\uDDF9': TexSymbolConfig('\uD835\uDDF9'),
    '\uD835\uDE2D': TexSymbolConfig('\uD835\uDE2D'),
    '\uD835\uDE95': TexSymbolConfig('\uD835\uDE95'),
    '\uD835\uDC26': TexSymbolConfig('\uD835\uDC26'),
    '\uD835\uDC5A': TexSymbolConfig('\uD835\uDC5A'),
    '\uD835\uDC8E': TexSymbolConfig('\uD835\uDC8E'),
    '\uD835\uDD2A': TexSymbolConfig('\uD835\uDD2A'),
    '\uD835\uDDC6': TexSymbolConfig('\uD835\uDDC6'),
    '\uD835\uDDFA': TexSymbolConfig('\uD835\uDDFA'),
    '\uD835\uDE2E': TexSymbolConfig('\uD835\uDE2E'),
    '\uD835\uDE96': TexSymbolConfig('\uD835\uDE96'),
    '\uD835\uDC27': TexSymbolConfig('\uD835\uDC27'),
    '\uD835\uDC5B': TexSymbolConfig('\uD835\uDC5B'),
    '\uD835\uDC8F': TexSymbolConfig('\uD835\uDC8F'),
    '\uD835\uDD2B': TexSymbolConfig('\uD835\uDD2B'),
    '\uD835\uDDC7': TexSymbolConfig('\uD835\uDDC7'),
    '\uD835\uDDFB': TexSymbolConfig('\uD835\uDDFB'),
    '\uD835\uDE2F': TexSymbolConfig('\uD835\uDE2F'),
    '\uD835\uDE97': TexSymbolConfig('\uD835\uDE97'),
    '\uD835\uDC28': TexSymbolConfig('\uD835\uDC28'),
    '\uD835\uDC5C': TexSymbolConfig('\uD835\uDC5C'),
    '\uD835\uDC90': TexSymbolConfig('\uD835\uDC90'),
    '\uD835\uDD2C': TexSymbolConfig('\uD835\uDD2C'),
    '\uD835\uDDC8': TexSymbolConfig('\uD835\uDDC8'),
    '\uD835\uDDFC': TexSymbolConfig('\uD835\uDDFC'),
    '\uD835\uDE30': TexSymbolConfig('\uD835\uDE30'),
    '\uD835\uDE98': TexSymbolConfig('\uD835\uDE98'),
    '\uD835\uDC29': TexSymbolConfig('\uD835\uDC29'),
    '\uD835\uDC5D': TexSymbolConfig('\uD835\uDC5D'),
    '\uD835\uDC91': TexSymbolConfig('\uD835\uDC91'),
    '\uD835\uDD2D': TexSymbolConfig('\uD835\uDD2D'),
    '\uD835\uDDC9': TexSymbolConfig('\uD835\uDDC9'),
    '\uD835\uDDFD': TexSymbolConfig('\uD835\uDDFD'),
    '\uD835\uDE31': TexSymbolConfig('\uD835\uDE31'),
    '\uD835\uDE99': TexSymbolConfig('\uD835\uDE99'),
    '\uD835\uDC2A': TexSymbolConfig('\uD835\uDC2A'),
    '\uD835\uDC5E': TexSymbolConfig('\uD835\uDC5E'),
    '\uD835\uDC92': TexSymbolConfig('\uD835\uDC92'),
    '\uD835\uDD2E': TexSymbolConfig('\uD835\uDD2E'),
    '\uD835\uDDCA': TexSymbolConfig('\uD835\uDDCA'),
    '\uD835\uDDFE': TexSymbolConfig('\uD835\uDDFE'),
    '\uD835\uDE32': TexSymbolConfig('\uD835\uDE32'),
    '\uD835\uDE9A': TexSymbolConfig('\uD835\uDE9A'),
    '\uD835\uDC2B': TexSymbolConfig('\uD835\uDC2B'),
    '\uD835\uDC5F': TexSymbolConfig('\uD835\uDC5F'),
    '\uD835\uDC93': TexSymbolConfig('\uD835\uDC93'),
    '\uD835\uDD2F': TexSymbolConfig('\uD835\uDD2F'),
    '\uD835\uDDCB': TexSymbolConfig('\uD835\uDDCB'),
    '\uD835\uDDFF': TexSymbolConfig('\uD835\uDDFF'),
    '\uD835\uDE33': TexSymbolConfig('\uD835\uDE33'),
    '\uD835\uDE9B': TexSymbolConfig('\uD835\uDE9B'),
    '\uD835\uDC2C': TexSymbolConfig('\uD835\uDC2C'),
    '\uD835\uDC60': TexSymbolConfig('\uD835\uDC60'),
    '\uD835\uDC94': TexSymbolConfig('\uD835\uDC94'),
    '\uD835\uDD30': TexSymbolConfig('\uD835\uDD30'),
    '\uD835\uDDCC': TexSymbolConfig('\uD835\uDDCC'),
    '\uD835\uDE00': TexSymbolConfig('\uD835\uDE00'),
    '\uD835\uDE34': TexSymbolConfig('\uD835\uDE34'),
    '\uD835\uDE9C': TexSymbolConfig('\uD835\uDE9C'),
    '\uD835\uDC2D': TexSymbolConfig('\uD835\uDC2D'),
    '\uD835\uDC61': TexSymbolConfig('\uD835\uDC61'),
    '\uD835\uDC95': TexSymbolConfig('\uD835\uDC95'),
    '\uD835\uDD31': TexSymbolConfig('\uD835\uDD31'),
    '\uD835\uDDCD': TexSymbolConfig('\uD835\uDDCD'),
    '\uD835\uDE01': TexSymbolConfig('\uD835\uDE01'),
    '\uD835\uDE35': TexSymbolConfig('\uD835\uDE35'),
    '\uD835\uDE9D': TexSymbolConfig('\uD835\uDE9D'),
    '\uD835\uDC2E': TexSymbolConfig('\uD835\uDC2E'),
    '\uD835\uDC62': TexSymbolConfig('\uD835\uDC62'),
    '\uD835\uDC96': TexSymbolConfig('\uD835\uDC96'),
    '\uD835\uDD32': TexSymbolConfig('\uD835\uDD32'),
    '\uD835\uDDCE': TexSymbolConfig('\uD835\uDDCE'),
    '\uD835\uDE02': TexSymbolConfig('\uD835\uDE02'),
    '\uD835\uDE36': TexSymbolConfig('\uD835\uDE36'),
    '\uD835\uDE9E': TexSymbolConfig('\uD835\uDE9E'),
    '\uD835\uDC2F': TexSymbolConfig('\uD835\uDC2F'),
    '\uD835\uDC63': TexSymbolConfig('\uD835\uDC63'),
    '\uD835\uDC97': TexSymbolConfig('\uD835\uDC97'),
    '\uD835\uDD33': TexSymbolConfig('\uD835\uDD33'),
    '\uD835\uDDCF': TexSymbolConfig('\uD835\uDDCF'),
    '\uD835\uDE03': TexSymbolConfig('\uD835\uDE03'),
    '\uD835\uDE37': TexSymbolConfig('\uD835\uDE37'),
    '\uD835\uDE9F': TexSymbolConfig('\uD835\uDE9F'),
    '\uD835\uDC30': TexSymbolConfig('\uD835\uDC30'),
    '\uD835\uDC64': TexSymbolConfig('\uD835\uDC64'),
    '\uD835\uDC98': TexSymbolConfig('\uD835\uDC98'),
    '\uD835\uDD34': TexSymbolConfig('\uD835\uDD34'),
    '\uD835\uDDD0': TexSymbolConfig('\uD835\uDDD0'),
    '\uD835\uDE04': TexSymbolConfig('\uD835\uDE04'),
    '\uD835\uDE38': TexSymbolConfig('\uD835\uDE38'),
    '\uD835\uDEA0': TexSymbolConfig('\uD835\uDEA0'),
    '\uD835\uDC31': TexSymbolConfig('\uD835\uDC31'),
    '\uD835\uDC65': TexSymbolConfig('\uD835\uDC65'),
    '\uD835\uDC99': TexSymbolConfig('\uD835\uDC99'),
    '\uD835\uDD35': TexSymbolConfig('\uD835\uDD35'),
    '\uD835\uDDD1': TexSymbolConfig('\uD835\uDDD1'),
    '\uD835\uDE05': TexSymbolConfig('\uD835\uDE05'),
    '\uD835\uDE39': TexSymbolConfig('\uD835\uDE39'),
    '\uD835\uDEA1': TexSymbolConfig('\uD835\uDEA1'),
    '\uD835\uDC32': TexSymbolConfig('\uD835\uDC32'),
    '\uD835\uDC66': TexSymbolConfig('\uD835\uDC66'),
    '\uD835\uDC9A': TexSymbolConfig('\uD835\uDC9A'),
    '\uD835\uDD36': TexSymbolConfig('\uD835\uDD36'),
    '\uD835\uDDD2': TexSymbolConfig('\uD835\uDDD2'),
    '\uD835\uDE06': TexSymbolConfig('\uD835\uDE06'),
    '\uD835\uDE3A': TexSymbolConfig('\uD835\uDE3A'),
    '\uD835\uDEA2': TexSymbolConfig('\uD835\uDEA2'),
    '\uD835\uDC33': TexSymbolConfig('\uD835\uDC33'),
    '\uD835\uDC67': TexSymbolConfig('\uD835\uDC67'),
    '\uD835\uDC9B': TexSymbolConfig('\uD835\uDC9B'),
    '\uD835\uDD37': TexSymbolConfig('\uD835\uDD37'),
    '\uD835\uDDD3': TexSymbolConfig('\uD835\uDDD3'),
    '\uD835\uDE07': TexSymbolConfig('\uD835\uDE07'),
    '\uD835\uDE3B': TexSymbolConfig('\uD835\uDE3B'),
    '\uD835\uDEA3': TexSymbolConfig('\uD835\uDEA3'),
    '\uD835\uDD5C': TexSymbolConfig('\uD835\uDD5C'),
    '\uD835\uDFCE': TexSymbolConfig('\uD835\uDFCE'),
    '\uD835\uDFE2': TexSymbolConfig('\uD835\uDFE2'),
    '\uD835\uDFEC': TexSymbolConfig('\uD835\uDFEC'),
    '\uD835\uDFF6': TexSymbolConfig('\uD835\uDFF6'),
    '\uD835\uDFCF': TexSymbolConfig('\uD835\uDFCF'),
    '\uD835\uDFE3': TexSymbolConfig('\uD835\uDFE3'),
    '\uD835\uDFED': TexSymbolConfig('\uD835\uDFED'),
    '\uD835\uDFF7': TexSymbolConfig('\uD835\uDFF7'),
    '\uD835\uDFD0': TexSymbolConfig('\uD835\uDFD0'),
    '\uD835\uDFE4': TexSymbolConfig('\uD835\uDFE4'),
    '\uD835\uDFEE': TexSymbolConfig('\uD835\uDFEE'),
    '\uD835\uDFF8': TexSymbolConfig('\uD835\uDFF8'),
    '\uD835\uDFD1': TexSymbolConfig('\uD835\uDFD1'),
    '\uD835\uDFE5': TexSymbolConfig('\uD835\uDFE5'),
    '\uD835\uDFEF': TexSymbolConfig('\uD835\uDFEF'),
    '\uD835\uDFF9': TexSymbolConfig('\uD835\uDFF9'),
    '\uD835\uDFD2': TexSymbolConfig('\uD835\uDFD2'),
    '\uD835\uDFE6': TexSymbolConfig('\uD835\uDFE6'),
    '\uD835\uDFF0': TexSymbolConfig('\uD835\uDFF0'),
    '\uD835\uDFFA': TexSymbolConfig('\uD835\uDFFA'),
    '\uD835\uDFD3': TexSymbolConfig('\uD835\uDFD3'),
    '\uD835\uDFE7': TexSymbolConfig('\uD835\uDFE7'),
    '\uD835\uDFF1': TexSymbolConfig('\uD835\uDFF1'),
    '\uD835\uDFFB': TexSymbolConfig('\uD835\uDFFB'),
    '\uD835\uDFD4': TexSymbolConfig('\uD835\uDFD4'),
    '\uD835\uDFE8': TexSymbolConfig('\uD835\uDFE8'),
    '\uD835\uDFF2': TexSymbolConfig('\uD835\uDFF2'),
    '\uD835\uDFFC': TexSymbolConfig('\uD835\uDFFC'),
    '\uD835\uDFD5': TexSymbolConfig('\uD835\uDFD5'),
    '\uD835\uDFE9': TexSymbolConfig('\uD835\uDFE9'),
    '\uD835\uDFF3': TexSymbolConfig('\uD835\uDFF3'),
    '\uD835\uDFFD': TexSymbolConfig('\uD835\uDFFD'),
    '\uD835\uDFD6': TexSymbolConfig('\uD835\uDFD6'),
    '\uD835\uDFEA': TexSymbolConfig('\uD835\uDFEA'),
    '\uD835\uDFF4': TexSymbolConfig('\uD835\uDFF4'),
    '\uD835\uDFFE': TexSymbolConfig('\uD835\uDFFE'),
    '\uD835\uDFD7': TexSymbolConfig('\uD835\uDFD7'),
    '\uD835\uDFEB': TexSymbolConfig('\uD835\uDFEB'),
    '\uD835\uDFF5': TexSymbolConfig('\uD835\uDFF5'),
    '\uD835\uDFFF': TexSymbolConfig('\uD835\uDFFF'),
    '\u00C7': TexSymbolConfig('\u00C7'),
    '\u00D0': TexSymbolConfig('\u00D0'),
    '\u00DE': TexSymbolConfig('\u00DE'),
    '\u00E7': TexSymbolConfig('\u00E7'),
    '\u00FE': TexSymbolConfig('\u00FE'),
    '\u00A0': TexSymbolConfig('\u00A0'),
    ' ': TexSymbolConfig(' '),
    '\\equiv': TexSymbolConfig('\u2261'),
    '\\prec': TexSymbolConfig('\u227A'),
    '\\succ': TexSymbolConfig('\u227B'),
    '\\sim': TexSymbolConfig('\u223C'),
    '\\preceq': TexSymbolConfig('\u2AAF'),
    '\\succeq': TexSymbolConfig('\u2AB0'),
    '\\simeq': TexSymbolConfig('\u2243'),
    '\\mid': TexSymbolConfig('\u2223'),
    '\\ll': TexSymbolConfig('\u226A'),
    '\\gg': TexSymbolConfig('\u226B'),
    '\\asymp': TexSymbolConfig('\u224D'),
    '\\bowtie': TexSymbolConfig('\u22C8'),
    '\\smile': TexSymbolConfig('\u2323'),
    '\\sqsubseteq': TexSymbolConfig('\u2291'),
    '\\sqsupseteq': TexSymbolConfig('\u2292'),
    '\\doteq': TexSymbolConfig('\u2250'),
    '\\frown': TexSymbolConfig('\u2322'),
    '\\ni': TexSymbolConfig('\u220B'),
    '\\propto': TexSymbolConfig('\u221D'),
    '\\vdash': TexSymbolConfig('\u22A2'),
    '\\dashv': TexSymbolConfig('\u22A3'),
    '\\owns': TexSymbolConfig('\u220B'),
    '\\ldotp': TexSymbolConfig('.', type: AtomType.punct),
    '\\cdotp': TexSymbolConfig('\u22C5', type: AtomType.punct),
    '\\aleph': TexSymbolConfig('\u2135'),
    '\\forall': TexSymbolConfig('\u2200'),
    '\\hbar': TexSymbolConfig('\u210F'),
    '\\exists': TexSymbolConfig('\u2203'),
    '\\nabla': TexSymbolConfig('\u2207'),
    '\\flat': TexSymbolConfig('\u266D'),
    '\\ell': TexSymbolConfig('\u2113'),
    '\\natural': TexSymbolConfig('\u266E'),
    '\\clubsuit': TexSymbolConfig('\u2663'),
    '\\wp': TexSymbolConfig('\u2118'),
    '\\sharp': TexSymbolConfig('\u266F'),
    '\\diamondsuit': TexSymbolConfig('\u2662'),
    '\\Re': TexSymbolConfig('\u211C'),
    '\\heartsuit': TexSymbolConfig('\u2661'),
    '\\Im': TexSymbolConfig('\u2111'),
    '\\spadesuit': TexSymbolConfig('\u2660'),
    '\\rmoustache': TexSymbolConfig('\u23B1'),
    '\\lmoustache': TexSymbolConfig('\u23B0'),
    '\\rgroup': TexSymbolConfig('\u27EF'),
    '\\lgroup': TexSymbolConfig('\u27EE'),
    '\\mp': TexSymbolConfig('\u2213'),
    '\\ominus': TexSymbolConfig('\u2296'),
    '\\uplus': TexSymbolConfig('\u228E'),
    '\\sqcap': TexSymbolConfig('\u2293'),
    '\\ast': TexSymbolConfig('*'),
    '\\sqcup': TexSymbolConfig('\u2294'),
    '\\wr': TexSymbolConfig('\u2240'),
    '\\longleftarrow': TexSymbolConfig('\u27F5'),
    '\\Leftarrow': TexSymbolConfig('\u21D0'),
    '\\Longleftarrow': TexSymbolConfig('\u27F8'),
    '\\longrightarrow': TexSymbolConfig('\u27F6'),
    '\\Rightarrow': TexSymbolConfig('\u21D2'),
    '\\Longrightarrow': TexSymbolConfig('\u27F9'),
    '\\leftrightarrow': TexSymbolConfig('\u2194'),
    '\\longleftrightarrow': TexSymbolConfig('\u27F7'),
    '\\Leftrightarrow': TexSymbolConfig('\u21D4'),
    '\\Longleftrightarrow': TexSymbolConfig('\u27FA'),
    '\\mapsto': TexSymbolConfig('\u21A6'),
    '\\longmapsto': TexSymbolConfig('\u27FC'),
    '\\nearrow': TexSymbolConfig('\u2197'),
    '\\hookleftarrow': TexSymbolConfig('\u21A9'),
    '\\hookrightarrow': TexSymbolConfig('\u21AA'),
    '\\searrow': TexSymbolConfig('\u2198'),
    '\\leftharpoonup': TexSymbolConfig('\u21BC'),
    '\\rightharpoonup': TexSymbolConfig('\u21C0'),
    '\\swarrow': TexSymbolConfig('\u2199'),
    '\\leftharpoondown': TexSymbolConfig('\u21BD'),
    '\\rightharpoondown': TexSymbolConfig('\u21C1'),
    '\\nwarrow': TexSymbolConfig('\u2196'),
    '\\rightleftharpoons': TexSymbolConfig('\u21CC'),
    '\\nless': TexSymbolConfig('\u226E'),
    '\\nleqslant': TexSymbolConfig('\u2A87', variantForm: true),
    '\\nleqq': TexSymbolConfig('\u2270', variantForm: true),
    '\\lneq': TexSymbolConfig('\u2A87'),
    '\\lneqq': TexSymbolConfig('\u2268'),
    '\\lvertneqq': TexSymbolConfig('\u2268', variantForm: true),
    '\\lnsim': TexSymbolConfig('\u22E6'),
    '\\lnapprox': TexSymbolConfig('\u2A89'),
    '\\nprec': TexSymbolConfig('\u2280'),
    '\\npreceq': TexSymbolConfig('\u22E0'),
    '\\precnsim': TexSymbolConfig('\u22E8'),
    '\\precnapprox': TexSymbolConfig('\u2AB9'),
    '\\nsim': TexSymbolConfig('\u2241'),
    '\\nshortmid': TexSymbolConfig('\u2224', variantForm: true),
    '\\nmid': TexSymbolConfig('\u2224'),
    '\\nvdash': TexSymbolConfig('\u22AC'),
    '\\nvDash': TexSymbolConfig('\u22AD'),
    '\\ntrianglelefteq': TexSymbolConfig('\u22EC'),
    '\\subsetneq': TexSymbolConfig('\u228A'),
    '\\varsubsetneq': TexSymbolConfig('\u228A', variantForm: true),
    '\\subsetneqq': TexSymbolConfig('\u2ACB'),
    '\\varsubsetneqq': TexSymbolConfig('\u2ACB', variantForm: true),
    '\\ngtr': TexSymbolConfig('\u226F'),
    '\\ngeqslant': TexSymbolConfig('\u2A88', variantForm: true),
    '\\ngeqq': TexSymbolConfig('\u2271', variantForm: true),
    '\\gneq': TexSymbolConfig('\u2A88'),
    '\\gneqq': TexSymbolConfig('\u2269'),
    '\\gvertneqq': TexSymbolConfig('\u2269', variantForm: true),
    '\\gnsim': TexSymbolConfig('\u22E7'),
    '\\gnapprox': TexSymbolConfig('\u2A8A'),
    '\\nsucc': TexSymbolConfig('\u2281'),
    '\\nsucceq': TexSymbolConfig('\u22E1'),
    '\\succnsim': TexSymbolConfig('\u22E9'),
    '\\succnapprox': TexSymbolConfig('\u2ABA'),
    '\\ncong': TexSymbolConfig('\u2246'),
    '\\nshortparallel': TexSymbolConfig('\u2226', variantForm: true),
    '\\nparallel': TexSymbolConfig('\u2226'),
    '\\nVDash': TexSymbolConfig('\u22AF'),
    '\\ntrianglerighteq': TexSymbolConfig('\u22ED'),
    '\\nsupseteqq': TexSymbolConfig('\u2289', variantForm: true),
    '\\supsetneq': TexSymbolConfig('\u228B'),
    '\\varsupsetneq': TexSymbolConfig('\u228B', variantForm: true),
    '\\supsetneqq': TexSymbolConfig('\u2ACC'),
    '\\varsupsetneqq': TexSymbolConfig('\u2ACC', variantForm: true),
    '\\nVdash': TexSymbolConfig('\u22AE'),
    '\\precneqq': TexSymbolConfig('\u2AB5'),
    '\\succneqq': TexSymbolConfig('\u2AB6'),
    '\\nsubseteqq': TexSymbolConfig('\u2288', variantForm: true),
    '\\nleftarrow': TexSymbolConfig('\u219A'),
    '\\nrightarrow': TexSymbolConfig('\u219B'),
    '\\nLeftarrow': TexSymbolConfig('\u21CD'),
    '\\nRightarrow': TexSymbolConfig('\u21CF'),
    '\\nleftrightarrow': TexSymbolConfig('\u21AE'),
    '\\nLeftrightarrow': TexSymbolConfig('\u21CE'),
    '\\hslash': TexSymbolConfig('\u210F', variantForm: true),
    '\\measuredangle': TexSymbolConfig('\u2221'),
    '\\Finv': TexSymbolConfig('\u2132'),
    '\\Game': TexSymbolConfig('\u2141'),
    '\\sphericalangle': TexSymbolConfig('\u2222'),
    '\\complement': TexSymbolConfig('\u2201'),
    '\\eth': TexSymbolConfig('\u00F0'),
    '\\yen': TexSymbolConfig('\u00A5'),
    '\\checkmark': TexSymbolConfig('\u2713'),
    '\\beth': TexSymbolConfig('\u2136'),
    '\\daleth': TexSymbolConfig('\u2138'),
    '\\gimel': TexSymbolConfig('\u2137'),
    '\\digamma': TexSymbolConfig('\u03DD'),
    '\\@ulcorner': TexSymbolConfig('\u231C'),
    '\\@urcorner': TexSymbolConfig('\u231D'),
    '\\@llcorner': TexSymbolConfig('\u231E'),
    '\\@lrcorner': TexSymbolConfig('\u231F'),
    '\\leqq': TexSymbolConfig('\u2266'),
    '\\leqslant': TexSymbolConfig('\u2A7D'),
    '\\eqslantless': TexSymbolConfig('\u2A95'),
    '\\lesssim': TexSymbolConfig('\u2272'),
    '\\lessapprox': TexSymbolConfig('\u2A85'),
    '\\approxeq': TexSymbolConfig('\u224A'),
    '\\lll': TexSymbolConfig('\u22D8'),
    '\\lessgtr': TexSymbolConfig('\u2276'),
    '\\lesseqgtr': TexSymbolConfig('\u22DA'),
    '\\lesseqqgtr': TexSymbolConfig('\u2A8B'),
    '\\doteqdot': TexSymbolConfig('\u2251'),
    '\\risingdotseq': TexSymbolConfig('\u2253'),
    '\\fallingdotseq': TexSymbolConfig('\u2252'),
    '\\backsim': TexSymbolConfig('\u223D'),
    '\\backsimeq': TexSymbolConfig('\u22CD'),
    '\\subseteqq': TexSymbolConfig('\u2AC5'),
    '\\Subset': TexSymbolConfig('\u22D0'),
    '\\sqsubset': TexSymbolConfig('\u228F'),
    '\\preccurlyeq': TexSymbolConfig('\u227C'),
    '\\curlyeqprec': TexSymbolConfig('\u22DE'),
    '\\precsim': TexSymbolConfig('\u227E'),
    '\\precapprox': TexSymbolConfig('\u2AB7'),
    '\\vDash': TexSymbolConfig('\u22A8'),
    '\\Vvdash': TexSymbolConfig('\u22AA'),
    '\\smallsmile': TexSymbolConfig('\u2323', variantForm: true),
    '\\smallfrown': TexSymbolConfig('\u2322', variantForm: true),
    '\\bumpeq': TexSymbolConfig('\u224F'),
    '\\Bumpeq': TexSymbolConfig('\u224E'),
    '\\geqq': TexSymbolConfig('\u2267'),
    '\\geqslant': TexSymbolConfig('\u2A7E'),
    '\\eqslantgtr': TexSymbolConfig('\u2A96'),
    '\\gtrsim': TexSymbolConfig('\u2273'),
    '\\gtrapprox': TexSymbolConfig('\u2A86'),
    '\\ggg': TexSymbolConfig('\u22D9'),
    '\\gtrless': TexSymbolConfig('\u2277'),
    '\\gtreqless': TexSymbolConfig('\u22DB'),
    '\\gtreqqless': TexSymbolConfig('\u2A8C'),
    '\\eqcirc': TexSymbolConfig('\u2256'),
    '\\circeq': TexSymbolConfig('\u2257'),
    '\\triangleq': TexSymbolConfig('\u225C'),
    '\\thicksim': TexSymbolConfig('\u223C', variantForm: true),
    '\\thickapprox': TexSymbolConfig('\u2248', variantForm: true),
    '\\supseteqq': TexSymbolConfig('\u2AC6'),
    '\\Supset': TexSymbolConfig('\u22D1'),
    '\\sqsupset': TexSymbolConfig('\u2290'),
    '\\succcurlyeq': TexSymbolConfig('\u227D'),
    '\\curlyeqsucc': TexSymbolConfig('\u22DF'),
    '\\succsim': TexSymbolConfig('\u227F'),
    '\\succapprox': TexSymbolConfig('\u2AB8'),
    '\\Vdash': TexSymbolConfig('\u22A9'),
    '\\shortmid': TexSymbolConfig('\u2223', variantForm: true),
    '\\between': TexSymbolConfig('\u226C'),
    '\\pitchfork': TexSymbolConfig('\u22D4'),
    '\\varpropto': TexSymbolConfig('\u221D', variantForm: true),
    '\\therefore': TexSymbolConfig('\u2234'),
    '\\because': TexSymbolConfig('\u2235'),
    '\\llless': TexSymbolConfig('\u22D8'),
    '\\gggtr': TexSymbolConfig('\u22D9'),
    '\\eqsim': TexSymbolConfig('\u2242'),
    '\\Join': TexSymbolConfig('\u22C8'),
    '\\Doteq': TexSymbolConfig('\u2251'),
    '\\dotplus': TexSymbolConfig('\u2214'),
    '\\Cap': TexSymbolConfig('\u22D2'),
    '\\Cup': TexSymbolConfig('\u22D3'),
    '\\doublebarwedge': TexSymbolConfig('\u2A5E'),
    '\\boxminus': TexSymbolConfig('\u229F'),
    '\\boxplus': TexSymbolConfig('\u229E'),
    '\\divideontimes': TexSymbolConfig('\u22C7'),
    '\\ltimes': TexSymbolConfig('\u22C9'),
    '\\rtimes': TexSymbolConfig('\u22CA'),
    '\\leftthreetimes': TexSymbolConfig('\u22CB'),
    '\\rightthreetimes': TexSymbolConfig('\u22CC'),
    '\\curlywedge': TexSymbolConfig('\u22CF'),
    '\\curlyvee': TexSymbolConfig('\u22CE'),
    '\\circleddash': TexSymbolConfig('\u229D'),
    '\\circledast': TexSymbolConfig('\u229B'),
    '\\centerdot': TexSymbolConfig('\u22C5', variantForm: true),
    '\\intercal': TexSymbolConfig('\u22BA'),
    '\\doublecap': TexSymbolConfig('\u22D2'),
    '\\doublecup': TexSymbolConfig('\u22D3'),
    '\\boxtimes': TexSymbolConfig('\u22A0'),
    '\\dashrightarrow': TexSymbolConfig('\u21E2'),
    '\\dashleftarrow': TexSymbolConfig('\u21E0'),
    '\\leftleftarrows': TexSymbolConfig('\u21C7'),
    '\\leftrightarrows': TexSymbolConfig('\u21C6'),
    '\\Lleftarrow': TexSymbolConfig('\u21DA'),
    '\\twoheadleftarrow': TexSymbolConfig('\u219E'),
    '\\leftarrowtail': TexSymbolConfig('\u21A2'),
    '\\looparrowleft': TexSymbolConfig('\u21AB'),
    '\\leftrightharpoons': TexSymbolConfig('\u21CB'),
    '\\curvearrowleft': TexSymbolConfig('\u21B6'),
    '\\circlearrowleft': TexSymbolConfig('\u21BA'),
    '\\Lsh': TexSymbolConfig('\u21B0'),
    '\\upuparrows': TexSymbolConfig('\u21C8'),
    '\\upharpoonleft': TexSymbolConfig('\u21BF'),
    '\\downharpoonleft': TexSymbolConfig('\u21C3'),
    '\\multimap': TexSymbolConfig('\u22B8'),
    '\\leftrightsquigarrow': TexSymbolConfig('\u21AD'),
    '\\rightrightarrows': TexSymbolConfig('\u21C9'),
    '\\rightleftarrows': TexSymbolConfig('\u21C4'),
    '\\twoheadrightarrow': TexSymbolConfig('\u21A0'),
    '\\rightarrowtail': TexSymbolConfig('\u21A3'),
    '\\looparrowright': TexSymbolConfig('\u21AC'),
    '\\curvearrowright': TexSymbolConfig('\u21B7'),
    '\\circlearrowright': TexSymbolConfig('\u21BB'),
    '\\Rsh': TexSymbolConfig('\u21B1'),
    '\\downdownarrows': TexSymbolConfig('\u21CA'),
    '\\upharpoonright': TexSymbolConfig('\u21BE'),
    '\\downharpoonright': TexSymbolConfig('\u21C2'),
    '\\rightsquigarrow': TexSymbolConfig('\u21DD'),
    '\\leadsto': TexSymbolConfig('\u21DD'),
    '\\Rrightarrow': TexSymbolConfig('\u21DB'),
    '\\restriction': TexSymbolConfig('\u21BE'),
    '\\angle': TexSymbolConfig('\u2220'),
    '\\infty': TexSymbolConfig('\u221E'),
    '\\Gamma': TexSymbolConfig('\u0393'),
    '\\Delta': TexSymbolConfig('\u0394'),
    '\\Theta': TexSymbolConfig('\u0398'),
    '\\Lambda': TexSymbolConfig('\u039B'),
    '\\Xi': TexSymbolConfig('\u039E'),
    '\\Pi': TexSymbolConfig('\u03A0'),
    '\\Sigma': TexSymbolConfig('\u03A3'),
    '\\Upsilon': TexSymbolConfig('\u03A5'),
    '\\Phi': TexSymbolConfig('\u03A6'),
    '\\Psi': TexSymbolConfig('\u03A8'),
    '\\Omega': TexSymbolConfig('\u03A9'),
    '\\neg': TexSymbolConfig('\u00AC'),
    '\\lnot': TexSymbolConfig('\u00AC'),
    '\\alpha': TexSymbolConfig('\u03B1'),
    '\\beta': TexSymbolConfig('\u03B2'),
    '\\gamma': TexSymbolConfig('\u03B3'),
    '\\delta': TexSymbolConfig('\u03B4'),
    '\\epsilon': TexSymbolConfig('\u03F5'),
    '\\zeta': TexSymbolConfig('\u03B6'),
    '\\eta': TexSymbolConfig('\u03B7'),
    '\\theta': TexSymbolConfig('\u03B8'),
    '\\iota': TexSymbolConfig('\u03B9'),
    '\\kappa': TexSymbolConfig('\u03BA'),
    '\\lambda': TexSymbolConfig('\u03BB'),
    '\\mu': TexSymbolConfig('\u03BC'),
    '\\nu': TexSymbolConfig('\u03BD'),
    '\\xi': TexSymbolConfig('\u03BE'),
    '\\omicron': TexSymbolConfig('\u03BF'),
    '\\pi': TexSymbolConfig('\u03C0'),
    '\\rho': TexSymbolConfig('\u03C1'),
    '\\sigma': TexSymbolConfig('\u03C3'),
    '\\tau': TexSymbolConfig('\u03C4'),
    '\\upsilon': TexSymbolConfig('\u03C5'),
    '\\phi': TexSymbolConfig('\u03D5'),
    '\\chi': TexSymbolConfig('\u03C7'),
    '\\psi': TexSymbolConfig('\u03C8'),
    '\\omega': TexSymbolConfig('\u03C9'),
    '\\varepsilon': TexSymbolConfig('\u03B5'),
    '\\vartheta': TexSymbolConfig('\u03D1'),
    '\\varpi': TexSymbolConfig('\u03D6'),
    '\\varrho': TexSymbolConfig('\u03F1'),
    '\\varsigma': TexSymbolConfig('\u03C2'),
    '\\varphi': TexSymbolConfig('\u03C6'),
    '\\cdot': TexSymbolConfig('\u22C5'),
    '\\div': TexSymbolConfig('\u00F7'),
    '\\pm': TexSymbolConfig('\u00B1'),
    '\\times': TexSymbolConfig('\u00D7'),
    '\\cap': TexSymbolConfig('\u2229'),
    '\\cup': TexSymbolConfig('\u222A'),
    '\\land': TexSymbolConfig('\u2227'),
    '\\lor': TexSymbolConfig('\u2228'),
    '\\wedge': TexSymbolConfig('\u2227'),
    '\\vee': TexSymbolConfig('\u2228'),
    '\\langle': TexSymbolConfig('\u27E8'),
    '\\lvert': TexSymbolConfig('\u2223', type: AtomType.open),
    '\\rangle': TexSymbolConfig('\u27E9'),
    '\\rvert': TexSymbolConfig('\u2223', type: AtomType.close),
    '\\approx': TexSymbolConfig('\u2248'),
    '\\cong': TexSymbolConfig('\u2245'),
    '\\ge': TexSymbolConfig('\u2265'),
    '\\geq': TexSymbolConfig('\u2265'),
    '\\gets': TexSymbolConfig('\u2190'),
    '\\gt': TexSymbolConfig('>'),
    '\\in': TexSymbolConfig('\u2208'),
    '\\subset': TexSymbolConfig('\u2282'),
    '\\supset': TexSymbolConfig('\u2283'),
    '\\subseteq': TexSymbolConfig('\u2286'),
    '\\supseteq': TexSymbolConfig('\u2287'),
    '\\nsubseteq': TexSymbolConfig('\u2288'),
    '\\nsupseteq': TexSymbolConfig('\u2289'),
    '\\models': TexSymbolConfig('\u22A8', variantForm: true),
    '\\leftarrow': TexSymbolConfig('\u2190'),
    '\\le': TexSymbolConfig('\u2264'),
    '\\leq': TexSymbolConfig('\u2264'),
    '\\lt': TexSymbolConfig('<'),
    '\\rightarrow': TexSymbolConfig('\u2192'),
    '\\to': TexSymbolConfig('\u2192'),
    '\\ngeq': TexSymbolConfig('\u2271'),
    '\\nleq': TexSymbolConfig('\u2270'),
    '\\ ': TexSymbolConfig(' '),
    '~': TexSymbolConfig('\u00A0'),
    '\\space': TexSymbolConfig(' '),
    '\\nobreakspace': TexSymbolConfig('\u00A0'),
    '\\barwedge': TexSymbolConfig('\u22BC'),
    '\\veebar': TexSymbolConfig('\u22BB'),
    '\\odot': TexSymbolConfig('\u2299'),
    '\\oplus': TexSymbolConfig('\u2295'),
    '\\otimes': TexSymbolConfig('\u2297'),
    '\\partial': TexSymbolConfig('\u2202'),
    '\\oslash': TexSymbolConfig('\u2298'),
    '\\circledcirc': TexSymbolConfig('\u229A'),
    '\\boxdot': TexSymbolConfig('\u22A1'),
    '\\lbrack': TexSymbolConfig('['),
    '\\rbrack': TexSymbolConfig(']'),
    '\\lparen': TexSymbolConfig('('),
    '\\rparen': TexSymbolConfig(')'),
    '\\lfloor': TexSymbolConfig('\u230A'),
    '\\rfloor': TexSymbolConfig('\u230B'),
    '\\lceil': TexSymbolConfig('\u2308'),
    '\\rceil': TexSymbolConfig('\u2309'),
    '\\vert': TexSymbolConfig('\u2223', type: AtomType.ord),
    '\\uparrow': TexSymbolConfig('\u2191'),
    '\\Uparrow': TexSymbolConfig('\u21D1'),
    '\\downarrow': TexSymbolConfig('\u2193'),
    '\\Downarrow': TexSymbolConfig('\u21D3'),
    '\\updownarrow': TexSymbolConfig('\u2195'),
    '\\Updownarrow': TexSymbolConfig('\u21D5'),
    '\\mathellipsis': TexSymbolConfig('\u2026'),
    '\\ldots': TexSymbolConfig('\u2026'),
    '\\@cdots': TexSymbolConfig('\u22EF'),
    '\\ddots': TexSymbolConfig('\u22F1'),
    '\\imath': TexSymbolConfig('\u0131'),
    '\\jmath': TexSymbolConfig('\u0237'),
    '\\degree': TexSymbolConfig('\u00B0'),
    '\\pounds': TexSymbolConfig('\u00A3'),
    '\\mathsterling': TexSymbolConfig('\u00A3'),
    '\\perp': TexSymbolConfig('\u22A5'),
    '\\bot': TexSymbolConfig('\u22A5', type: AtomType.ord),
    '\\parallel': TexSymbolConfig('\u2225'),
    '\\shortparallel': TexSymbolConfig('\u2225', variantForm: true),
    '\\lVert': TexSymbolConfig('\u2225', type: AtomType.open),
    '\\rVert': TexSymbolConfig('\u2225', type: AtomType.close),
    '\\|': TexSymbolConfig('\u2225', type: AtomType.ord),
    '\\Vert': TexSymbolConfig('\u2225', type: AtomType.ord),
    '\\#': TexSymbolConfig('#'),
    '\\&': TexSymbolConfig('&'),
    '\\And': TexSymbolConfig('&', type: AtomType.bin),
    '\\dagger': TexSymbolConfig('\u2020'),
    '\\dag': TexSymbolConfig('\u2020', type: AtomType.ord),
    '\\ddagger': TexSymbolConfig('\u2021'),
    '\\ddag': TexSymbolConfig('\u2021', type: AtomType.ord),
    '\\bigcirc': TexSymbolConfig('\u25EF'),
    '\\bullet': TexSymbolConfig('\u2219'),
    '\\amalg': TexSymbolConfig('\u2A3F'),
    '\\ntriangleleft': TexSymbolConfig('\u22EA'),
    '\\ntriangleright': TexSymbolConfig('\u22EB'),
    '\\trianglelefteq': TexSymbolConfig('\u22B4'),
    '\\unlhd': TexSymbolConfig('\u22B4', type: AtomType.bin),
    '\\trianglerighteq': TexSymbolConfig('\u22B5'),
    '\\unrhd': TexSymbolConfig('\u22B5', type: AtomType.bin),
    '\\bigtriangleup': TexSymbolConfig('\u25B3'),
    '\\vartriangle': TexSymbolConfig('\u25B3', variantForm: true),
    '\\triangle': TexSymbolConfig('\u25B3', type: AtomType.ord),
    '\\bigtriangledown': TexSymbolConfig('\u25BD'),
    '\\triangledown': TexSymbolConfig('\u25BD', variantForm: true),
    '\\lozenge': TexSymbolConfig('\u25CA'),
    '\\Diamond': TexSymbolConfig('\u25CA'),
    '\\circledS': TexSymbolConfig('\u24C8'),
    '\\circledR': TexSymbolConfig('\u00AE'),
    '\\nexists': TexSymbolConfig('\u2204'),
    '\\mho': TexSymbolConfig('\u2127'),
    '\\backprime': TexSymbolConfig('\u2035'),
    '\\blacktriangle': TexSymbolConfig('\u25B2'),
    '\\blacktriangledown': TexSymbolConfig('\u25BC'),
    '\\blacksquare': TexSymbolConfig('\u25A0'),
    '\\blacklozenge': TexSymbolConfig('\u29EB'),
    '\\bigstar': TexSymbolConfig('\u2605'),
    '\\diagup': TexSymbolConfig('\u2571'),
    '\\diagdown': TexSymbolConfig('\u2572'),
    '\\square': TexSymbolConfig('\u25A1'),
    '\\Box': TexSymbolConfig('\u25A1'),
    '\\varkappa': TexSymbolConfig('\u03F0'),
    '\\lessdot': TexSymbolConfig('\u22D6'),
    '\\lhd': TexSymbolConfig('\u22B2'),
    '\\vartriangleleft': TexSymbolConfig('\u22B2', variantForm: true),
    '\\gtrdot': TexSymbolConfig('\u22D7'),
    '\\vartriangleright': TexSymbolConfig('\u22B3'),
    '\\rhd': TexSymbolConfig('\u22B3', type: AtomType.bin),
    '\\blacktriangleleft': TexSymbolConfig('\u25C0'),
    '\\backepsilon': TexSymbolConfig('\u220D'),
    '\\blacktriangleright': TexSymbolConfig('\u25B6'),
    '\\setminus': TexSymbolConfig('\u2216'),
    '\\smallsetminus': TexSymbolConfig('\u2216', variantForm: true),
    '\\\$': TexSymbolConfig('\$'),
    '\\%': TexSymbolConfig('%'),
    '\\_': TexSymbolConfig('_'),
    '\\prime': TexSymbolConfig('\u2032'),
    '\\top': TexSymbolConfig('\u22A4'),
    '\\emptyset': TexSymbolConfig('\u2205'),
    '\\varnothing': TexSymbolConfig('\u2205', variantForm: true),
    '\\circ': TexSymbolConfig('\u2218'),
    '\\surd': TexSymbolConfig('\u221A'),
    '\\not': TexSymbolConfig('\u0338'),
    '\\diamond': TexSymbolConfig('\u22C4'),
    '\\star': TexSymbolConfig('\u22C6'),
    '\\triangleleft': TexSymbolConfig('\u25C3'),
    '\\triangleright': TexSymbolConfig('\u25B9'),
    '\\{': TexSymbolConfig('{'),
    '\\lbrace': TexSymbolConfig('{'),
    '\\}': TexSymbolConfig('}'),
    '\\rbrace': TexSymbolConfig('}'),
    '\\backslash': TexSymbolConfig('\\'),
    '\\coprod': TexSymbolConfig('\u2210'),
    '\\bigvee': TexSymbolConfig('\u22C1'),
    '\\bigwedge': TexSymbolConfig('\u22C0'),
    '\\biguplus': TexSymbolConfig('\u2A04'),
    '\\bigcap': TexSymbolConfig('\u22C2'),
    '\\bigcup': TexSymbolConfig('\u22C3'),
    '\\int': TexSymbolConfig('\u222B'),
    '\\intop': TexSymbolConfig('\u222B'),
    '\\smallint': TexSymbolConfig('\u222B'),
    '\\iint': TexSymbolConfig('\u222C'),
    '\\iiint': TexSymbolConfig('\u222D'),
    '\\prod': TexSymbolConfig('\u220F'),
    '\\sum': TexSymbolConfig('\u2211'),
    '\\bigotimes': TexSymbolConfig('\u2A02'),
    '\\bigoplus': TexSymbolConfig('\u2A01'),
    '\\bigodot': TexSymbolConfig('\u2A00'),
    '\\oint': TexSymbolConfig('\u222E'),
    '\\oiint': TexSymbolConfig('\u222F'),
    '\\oiiint': TexSymbolConfig('\u2230'),
    '\\bigsqcup': TexSymbolConfig('\u2A06'),
    '\\varvdots': TexSymbolConfig('\u22EE'),
    '\\acute': TexSymbolConfig('\u02CA'),
    '\\grave': TexSymbolConfig('\u02CB'),
    '\\ddot': TexSymbolConfig('\u00A8'),
    '\\tilde': TexSymbolConfig('~'),
    '\\bar': TexSymbolConfig('\u02C9'),
    '\\breve': TexSymbolConfig('\u02D8'),
    '\\check': TexSymbolConfig('\u02C7'),
    '\\hat': TexSymbolConfig('^'),
    '\\vec': TexSymbolConfig('\u20D7'),
    '\\dot': TexSymbolConfig('\u02D9'),
    '\\mathring': TexSymbolConfig('\u02DA'),
    '\\maltese': TexSymbolConfig('\u2720'),
    ...extraTexMathSymbolCommandConfigs
  },
  Mode.text: {
    '0': TexSymbolConfig('0'),
    '1': TexSymbolConfig('1'),
    '2': TexSymbolConfig('2'),
    '3': TexSymbolConfig('3'),
    '4': TexSymbolConfig('4'),
    '5': TexSymbolConfig('5'),
    '6': TexSymbolConfig('6'),
    '7': TexSymbolConfig('7'),
    '8': TexSymbolConfig('8'),
    '9': TexSymbolConfig('9'),
    '\u00A7': TexSymbolConfig('\u00A7'),
    '\u00B6': TexSymbolConfig('\u00B6'),
    '\u00A5': TexSymbolConfig('\u00A5'),
    '\u2026': TexSymbolConfig('\u2026'),
    '\u0131': TexSymbolConfig('\u0131'),
    '\u0237': TexSymbolConfig('\u0237'),
    '\u00DF': TexSymbolConfig('\u00DF'),
    '\u00E6': TexSymbolConfig('\u00E6'),
    '\u0153': TexSymbolConfig('\u0153'),
    '\u00F8': TexSymbolConfig('\u00F8'),
    '\u00C6': TexSymbolConfig('\u00C6'),
    '\u0152': TexSymbolConfig('\u0152'),
    '\u00D8': TexSymbolConfig('\u00D8'),
    '`': TexSymbolConfig('`'),
    '\'': TexSymbolConfig('\''),
    '\u00B0': TexSymbolConfig('\u00B0'),
    '\u00A3': TexSymbolConfig('\u00A3'),
    ' ': TexSymbolConfig(' '),
    '!': TexSymbolConfig('!'),
    '@': TexSymbolConfig('@'),
    '*': TexSymbolConfig('*'),
    '(': TexSymbolConfig('('),
    ')': TexSymbolConfig(')'),
    '-': TexSymbolConfig('-'),
    '=': TexSymbolConfig('='),
    '+': TexSymbolConfig('+'),
    '[': TexSymbolConfig('['),
    ']': TexSymbolConfig(']'),
    '<': TexSymbolConfig('<'),
    '>': TexSymbolConfig('>'),
    '|': TexSymbolConfig('|'),
    '\"': TexSymbolConfig('\"'),
    ';': TexSymbolConfig(';'),
    ':': TexSymbolConfig(':'),
    '?': TexSymbolConfig('?'),
    '/': TexSymbolConfig('/'),
    '.': TexSymbolConfig('.'),
    ',': TexSymbolConfig(','),
    'A': TexSymbolConfig('A'),
    'B': TexSymbolConfig('B'),
    'C': TexSymbolConfig('C'),
    'D': TexSymbolConfig('D'),
    'E': TexSymbolConfig('E'),
    'F': TexSymbolConfig('F'),
    'G': TexSymbolConfig('G'),
    'H': TexSymbolConfig('H'),
    'I': TexSymbolConfig('I'),
    'J': TexSymbolConfig('J'),
    'K': TexSymbolConfig('K'),
    'L': TexSymbolConfig('L'),
    'M': TexSymbolConfig('M'),
    'N': TexSymbolConfig('N'),
    'O': TexSymbolConfig('O'),
    'P': TexSymbolConfig('P'),
    'Q': TexSymbolConfig('Q'),
    'R': TexSymbolConfig('R'),
    'S': TexSymbolConfig('S'),
    'T': TexSymbolConfig('T'),
    'U': TexSymbolConfig('U'),
    'V': TexSymbolConfig('V'),
    'W': TexSymbolConfig('W'),
    'X': TexSymbolConfig('X'),
    'Y': TexSymbolConfig('Y'),
    'Z': TexSymbolConfig('Z'),
    'a': TexSymbolConfig('a'),
    'b': TexSymbolConfig('b'),
    'c': TexSymbolConfig('c'),
    'd': TexSymbolConfig('d'),
    'e': TexSymbolConfig('e'),
    'f': TexSymbolConfig('f'),
    'g': TexSymbolConfig('g'),
    'h': TexSymbolConfig('h'),
    'i': TexSymbolConfig('i'),
    'j': TexSymbolConfig('j'),
    'k': TexSymbolConfig('k'),
    'l': TexSymbolConfig('l'),
    'm': TexSymbolConfig('m'),
    'n': TexSymbolConfig('n'),
    'o': TexSymbolConfig('o'),
    'p': TexSymbolConfig('p'),
    'q': TexSymbolConfig('q'),
    'r': TexSymbolConfig('r'),
    's': TexSymbolConfig('s'),
    't': TexSymbolConfig('t'),
    'u': TexSymbolConfig('u'),
    'v': TexSymbolConfig('v'),
    'w': TexSymbolConfig('w'),
    'x': TexSymbolConfig('x'),
    'y': TexSymbolConfig('y'),
    'z': TexSymbolConfig('z'),
    '\u2102': TexSymbolConfig('\u2102'),
    '\u210D': TexSymbolConfig('\u210D'),
    '\u2115': TexSymbolConfig('\u2115'),
    '\u2119': TexSymbolConfig('\u2119'),
    '\u211A': TexSymbolConfig('\u211A'),
    '\u211D': TexSymbolConfig('\u211D'),
    '\u2124': TexSymbolConfig('\u2124'),
    '\u210E': TexSymbolConfig('\u210E'),
    '\uD835\uDC00': TexSymbolConfig('\uD835\uDC00'),
    '\uD835\uDC34': TexSymbolConfig('\uD835\uDC34'),
    '\uD835\uDC68': TexSymbolConfig('\uD835\uDC68'),
    '\uD835\uDD04': TexSymbolConfig('\uD835\uDD04'),
    '\uD835\uDDA0': TexSymbolConfig('\uD835\uDDA0'),
    '\uD835\uDDD4': TexSymbolConfig('\uD835\uDDD4'),
    '\uD835\uDE08': TexSymbolConfig('\uD835\uDE08'),
    '\uD835\uDE70': TexSymbolConfig('\uD835\uDE70'),
    '\uD835\uDD38': TexSymbolConfig('\uD835\uDD38'),
    '\uD835\uDC9C': TexSymbolConfig('\uD835\uDC9C'),
    '\uD835\uDC01': TexSymbolConfig('\uD835\uDC01'),
    '\uD835\uDC35': TexSymbolConfig('\uD835\uDC35'),
    '\uD835\uDC69': TexSymbolConfig('\uD835\uDC69'),
    '\uD835\uDD05': TexSymbolConfig('\uD835\uDD05'),
    '\uD835\uDDA1': TexSymbolConfig('\uD835\uDDA1'),
    '\uD835\uDDD5': TexSymbolConfig('\uD835\uDDD5'),
    '\uD835\uDE09': TexSymbolConfig('\uD835\uDE09'),
    '\uD835\uDE71': TexSymbolConfig('\uD835\uDE71'),
    '\uD835\uDD39': TexSymbolConfig('\uD835\uDD39'),
    '\uD835\uDC9D': TexSymbolConfig('\uD835\uDC9D'),
    '\uD835\uDC02': TexSymbolConfig('\uD835\uDC02'),
    '\uD835\uDC36': TexSymbolConfig('\uD835\uDC36'),
    '\uD835\uDC6A': TexSymbolConfig('\uD835\uDC6A'),
    '\uD835\uDD06': TexSymbolConfig('\uD835\uDD06'),
    '\uD835\uDDA2': TexSymbolConfig('\uD835\uDDA2'),
    '\uD835\uDDD6': TexSymbolConfig('\uD835\uDDD6'),
    '\uD835\uDE0A': TexSymbolConfig('\uD835\uDE0A'),
    '\uD835\uDE72': TexSymbolConfig('\uD835\uDE72'),
    '\uD835\uDD3A': TexSymbolConfig('\uD835\uDD3A'),
    '\uD835\uDC9E': TexSymbolConfig('\uD835\uDC9E'),
    '\uD835\uDC03': TexSymbolConfig('\uD835\uDC03'),
    '\uD835\uDC37': TexSymbolConfig('\uD835\uDC37'),
    '\uD835\uDC6B': TexSymbolConfig('\uD835\uDC6B'),
    '\uD835\uDD07': TexSymbolConfig('\uD835\uDD07'),
    '\uD835\uDDA3': TexSymbolConfig('\uD835\uDDA3'),
    '\uD835\uDDD7': TexSymbolConfig('\uD835\uDDD7'),
    '\uD835\uDE0B': TexSymbolConfig('\uD835\uDE0B'),
    '\uD835\uDE73': TexSymbolConfig('\uD835\uDE73'),
    '\uD835\uDD3B': TexSymbolConfig('\uD835\uDD3B'),
    '\uD835\uDC9F': TexSymbolConfig('\uD835\uDC9F'),
    '\uD835\uDC04': TexSymbolConfig('\uD835\uDC04'),
    '\uD835\uDC38': TexSymbolConfig('\uD835\uDC38'),
    '\uD835\uDC6C': TexSymbolConfig('\uD835\uDC6C'),
    '\uD835\uDD08': TexSymbolConfig('\uD835\uDD08'),
    '\uD835\uDDA4': TexSymbolConfig('\uD835\uDDA4'),
    '\uD835\uDDD8': TexSymbolConfig('\uD835\uDDD8'),
    '\uD835\uDE0C': TexSymbolConfig('\uD835\uDE0C'),
    '\uD835\uDE74': TexSymbolConfig('\uD835\uDE74'),
    '\uD835\uDD3C': TexSymbolConfig('\uD835\uDD3C'),
    '\uD835\uDCA0': TexSymbolConfig('\uD835\uDCA0'),
    '\uD835\uDC05': TexSymbolConfig('\uD835\uDC05'),
    '\uD835\uDC39': TexSymbolConfig('\uD835\uDC39'),
    '\uD835\uDC6D': TexSymbolConfig('\uD835\uDC6D'),
    '\uD835\uDD09': TexSymbolConfig('\uD835\uDD09'),
    '\uD835\uDDA5': TexSymbolConfig('\uD835\uDDA5'),
    '\uD835\uDDD9': TexSymbolConfig('\uD835\uDDD9'),
    '\uD835\uDE0D': TexSymbolConfig('\uD835\uDE0D'),
    '\uD835\uDE75': TexSymbolConfig('\uD835\uDE75'),
    '\uD835\uDD3D': TexSymbolConfig('\uD835\uDD3D'),
    '\uD835\uDCA1': TexSymbolConfig('\uD835\uDCA1'),
    '\uD835\uDC06': TexSymbolConfig('\uD835\uDC06'),
    '\uD835\uDC3A': TexSymbolConfig('\uD835\uDC3A'),
    '\uD835\uDC6E': TexSymbolConfig('\uD835\uDC6E'),
    '\uD835\uDD0A': TexSymbolConfig('\uD835\uDD0A'),
    '\uD835\uDDA6': TexSymbolConfig('\uD835\uDDA6'),
    '\uD835\uDDDA': TexSymbolConfig('\uD835\uDDDA'),
    '\uD835\uDE0E': TexSymbolConfig('\uD835\uDE0E'),
    '\uD835\uDE76': TexSymbolConfig('\uD835\uDE76'),
    '\uD835\uDD3E': TexSymbolConfig('\uD835\uDD3E'),
    '\uD835\uDCA2': TexSymbolConfig('\uD835\uDCA2'),
    '\uD835\uDC07': TexSymbolConfig('\uD835\uDC07'),
    '\uD835\uDC3B': TexSymbolConfig('\uD835\uDC3B'),
    '\uD835\uDC6F': TexSymbolConfig('\uD835\uDC6F'),
    '\uD835\uDD0B': TexSymbolConfig('\uD835\uDD0B'),
    '\uD835\uDDA7': TexSymbolConfig('\uD835\uDDA7'),
    '\uD835\uDDDB': TexSymbolConfig('\uD835\uDDDB'),
    '\uD835\uDE0F': TexSymbolConfig('\uD835\uDE0F'),
    '\uD835\uDE77': TexSymbolConfig('\uD835\uDE77'),
    '\uD835\uDD3F': TexSymbolConfig('\uD835\uDD3F'),
    '\uD835\uDCA3': TexSymbolConfig('\uD835\uDCA3'),
    '\uD835\uDC08': TexSymbolConfig('\uD835\uDC08'),
    '\uD835\uDC3C': TexSymbolConfig('\uD835\uDC3C'),
    '\uD835\uDC70': TexSymbolConfig('\uD835\uDC70'),
    '\uD835\uDD0C': TexSymbolConfig('\uD835\uDD0C'),
    '\uD835\uDDA8': TexSymbolConfig('\uD835\uDDA8'),
    '\uD835\uDDDC': TexSymbolConfig('\uD835\uDDDC'),
    '\uD835\uDE10': TexSymbolConfig('\uD835\uDE10'),
    '\uD835\uDE78': TexSymbolConfig('\uD835\uDE78'),
    '\uD835\uDD40': TexSymbolConfig('\uD835\uDD40'),
    '\uD835\uDCA4': TexSymbolConfig('\uD835\uDCA4'),
    '\uD835\uDC09': TexSymbolConfig('\uD835\uDC09'),
    '\uD835\uDC3D': TexSymbolConfig('\uD835\uDC3D'),
    '\uD835\uDC71': TexSymbolConfig('\uD835\uDC71'),
    '\uD835\uDD0D': TexSymbolConfig('\uD835\uDD0D'),
    '\uD835\uDDA9': TexSymbolConfig('\uD835\uDDA9'),
    '\uD835\uDDDD': TexSymbolConfig('\uD835\uDDDD'),
    '\uD835\uDE11': TexSymbolConfig('\uD835\uDE11'),
    '\uD835\uDE79': TexSymbolConfig('\uD835\uDE79'),
    '\uD835\uDD41': TexSymbolConfig('\uD835\uDD41'),
    '\uD835\uDCA5': TexSymbolConfig('\uD835\uDCA5'),
    '\uD835\uDC0A': TexSymbolConfig('\uD835\uDC0A'),
    '\uD835\uDC3E': TexSymbolConfig('\uD835\uDC3E'),
    '\uD835\uDC72': TexSymbolConfig('\uD835\uDC72'),
    '\uD835\uDD0E': TexSymbolConfig('\uD835\uDD0E'),
    '\uD835\uDDAA': TexSymbolConfig('\uD835\uDDAA'),
    '\uD835\uDDDE': TexSymbolConfig('\uD835\uDDDE'),
    '\uD835\uDE12': TexSymbolConfig('\uD835\uDE12'),
    '\uD835\uDE7A': TexSymbolConfig('\uD835\uDE7A'),
    '\uD835\uDD42': TexSymbolConfig('\uD835\uDD42'),
    '\uD835\uDCA6': TexSymbolConfig('\uD835\uDCA6'),
    '\uD835\uDC0B': TexSymbolConfig('\uD835\uDC0B'),
    '\uD835\uDC3F': TexSymbolConfig('\uD835\uDC3F'),
    '\uD835\uDC73': TexSymbolConfig('\uD835\uDC73'),
    '\uD835\uDD0F': TexSymbolConfig('\uD835\uDD0F'),
    '\uD835\uDDAB': TexSymbolConfig('\uD835\uDDAB'),
    '\uD835\uDDDF': TexSymbolConfig('\uD835\uDDDF'),
    '\uD835\uDE13': TexSymbolConfig('\uD835\uDE13'),
    '\uD835\uDE7B': TexSymbolConfig('\uD835\uDE7B'),
    '\uD835\uDD43': TexSymbolConfig('\uD835\uDD43'),
    '\uD835\uDCA7': TexSymbolConfig('\uD835\uDCA7'),
    '\uD835\uDC0C': TexSymbolConfig('\uD835\uDC0C'),
    '\uD835\uDC40': TexSymbolConfig('\uD835\uDC40'),
    '\uD835\uDC74': TexSymbolConfig('\uD835\uDC74'),
    '\uD835\uDD10': TexSymbolConfig('\uD835\uDD10'),
    '\uD835\uDDAC': TexSymbolConfig('\uD835\uDDAC'),
    '\uD835\uDDE0': TexSymbolConfig('\uD835\uDDE0'),
    '\uD835\uDE14': TexSymbolConfig('\uD835\uDE14'),
    '\uD835\uDE7C': TexSymbolConfig('\uD835\uDE7C'),
    '\uD835\uDD44': TexSymbolConfig('\uD835\uDD44'),
    '\uD835\uDCA8': TexSymbolConfig('\uD835\uDCA8'),
    '\uD835\uDC0D': TexSymbolConfig('\uD835\uDC0D'),
    '\uD835\uDC41': TexSymbolConfig('\uD835\uDC41'),
    '\uD835\uDC75': TexSymbolConfig('\uD835\uDC75'),
    '\uD835\uDD11': TexSymbolConfig('\uD835\uDD11'),
    '\uD835\uDDAD': TexSymbolConfig('\uD835\uDDAD'),
    '\uD835\uDDE1': TexSymbolConfig('\uD835\uDDE1'),
    '\uD835\uDE15': TexSymbolConfig('\uD835\uDE15'),
    '\uD835\uDE7D': TexSymbolConfig('\uD835\uDE7D'),
    '\uD835\uDD45': TexSymbolConfig('\uD835\uDD45'),
    '\uD835\uDCA9': TexSymbolConfig('\uD835\uDCA9'),
    '\uD835\uDC0E': TexSymbolConfig('\uD835\uDC0E'),
    '\uD835\uDC42': TexSymbolConfig('\uD835\uDC42'),
    '\uD835\uDC76': TexSymbolConfig('\uD835\uDC76'),
    '\uD835\uDD12': TexSymbolConfig('\uD835\uDD12'),
    '\uD835\uDDAE': TexSymbolConfig('\uD835\uDDAE'),
    '\uD835\uDDE2': TexSymbolConfig('\uD835\uDDE2'),
    '\uD835\uDE16': TexSymbolConfig('\uD835\uDE16'),
    '\uD835\uDE7E': TexSymbolConfig('\uD835\uDE7E'),
    '\uD835\uDD46': TexSymbolConfig('\uD835\uDD46'),
    '\uD835\uDCAA': TexSymbolConfig('\uD835\uDCAA'),
    '\uD835\uDC0F': TexSymbolConfig('\uD835\uDC0F'),
    '\uD835\uDC43': TexSymbolConfig('\uD835\uDC43'),
    '\uD835\uDC77': TexSymbolConfig('\uD835\uDC77'),
    '\uD835\uDD13': TexSymbolConfig('\uD835\uDD13'),
    '\uD835\uDDAF': TexSymbolConfig('\uD835\uDDAF'),
    '\uD835\uDDE3': TexSymbolConfig('\uD835\uDDE3'),
    '\uD835\uDE17': TexSymbolConfig('\uD835\uDE17'),
    '\uD835\uDE7F': TexSymbolConfig('\uD835\uDE7F'),
    '\uD835\uDD47': TexSymbolConfig('\uD835\uDD47'),
    '\uD835\uDCAB': TexSymbolConfig('\uD835\uDCAB'),
    '\uD835\uDC10': TexSymbolConfig('\uD835\uDC10'),
    '\uD835\uDC44': TexSymbolConfig('\uD835\uDC44'),
    '\uD835\uDC78': TexSymbolConfig('\uD835\uDC78'),
    '\uD835\uDD14': TexSymbolConfig('\uD835\uDD14'),
    '\uD835\uDDB0': TexSymbolConfig('\uD835\uDDB0'),
    '\uD835\uDDE4': TexSymbolConfig('\uD835\uDDE4'),
    '\uD835\uDE18': TexSymbolConfig('\uD835\uDE18'),
    '\uD835\uDE80': TexSymbolConfig('\uD835\uDE80'),
    '\uD835\uDD48': TexSymbolConfig('\uD835\uDD48'),
    '\uD835\uDCAC': TexSymbolConfig('\uD835\uDCAC'),
    '\uD835\uDC11': TexSymbolConfig('\uD835\uDC11'),
    '\uD835\uDC45': TexSymbolConfig('\uD835\uDC45'),
    '\uD835\uDC79': TexSymbolConfig('\uD835\uDC79'),
    '\uD835\uDD15': TexSymbolConfig('\uD835\uDD15'),
    '\uD835\uDDB1': TexSymbolConfig('\uD835\uDDB1'),
    '\uD835\uDDE5': TexSymbolConfig('\uD835\uDDE5'),
    '\uD835\uDE19': TexSymbolConfig('\uD835\uDE19'),
    '\uD835\uDE81': TexSymbolConfig('\uD835\uDE81'),
    '\uD835\uDD49': TexSymbolConfig('\uD835\uDD49'),
    '\uD835\uDCAD': TexSymbolConfig('\uD835\uDCAD'),
    '\uD835\uDC12': TexSymbolConfig('\uD835\uDC12'),
    '\uD835\uDC46': TexSymbolConfig('\uD835\uDC46'),
    '\uD835\uDC7A': TexSymbolConfig('\uD835\uDC7A'),
    '\uD835\uDD16': TexSymbolConfig('\uD835\uDD16'),
    '\uD835\uDDB2': TexSymbolConfig('\uD835\uDDB2'),
    '\uD835\uDDE6': TexSymbolConfig('\uD835\uDDE6'),
    '\uD835\uDE1A': TexSymbolConfig('\uD835\uDE1A'),
    '\uD835\uDE82': TexSymbolConfig('\uD835\uDE82'),
    '\uD835\uDD4A': TexSymbolConfig('\uD835\uDD4A'),
    '\uD835\uDCAE': TexSymbolConfig('\uD835\uDCAE'),
    '\uD835\uDC13': TexSymbolConfig('\uD835\uDC13'),
    '\uD835\uDC47': TexSymbolConfig('\uD835\uDC47'),
    '\uD835\uDC7B': TexSymbolConfig('\uD835\uDC7B'),
    '\uD835\uDD17': TexSymbolConfig('\uD835\uDD17'),
    '\uD835\uDDB3': TexSymbolConfig('\uD835\uDDB3'),
    '\uD835\uDDE7': TexSymbolConfig('\uD835\uDDE7'),
    '\uD835\uDE1B': TexSymbolConfig('\uD835\uDE1B'),
    '\uD835\uDE83': TexSymbolConfig('\uD835\uDE83'),
    '\uD835\uDD4B': TexSymbolConfig('\uD835\uDD4B'),
    '\uD835\uDCAF': TexSymbolConfig('\uD835\uDCAF'),
    '\uD835\uDC14': TexSymbolConfig('\uD835\uDC14'),
    '\uD835\uDC48': TexSymbolConfig('\uD835\uDC48'),
    '\uD835\uDC7C': TexSymbolConfig('\uD835\uDC7C'),
    '\uD835\uDD18': TexSymbolConfig('\uD835\uDD18'),
    '\uD835\uDDB4': TexSymbolConfig('\uD835\uDDB4'),
    '\uD835\uDDE8': TexSymbolConfig('\uD835\uDDE8'),
    '\uD835\uDE1C': TexSymbolConfig('\uD835\uDE1C'),
    '\uD835\uDE84': TexSymbolConfig('\uD835\uDE84'),
    '\uD835\uDD4C': TexSymbolConfig('\uD835\uDD4C'),
    '\uD835\uDCB0': TexSymbolConfig('\uD835\uDCB0'),
    '\uD835\uDC15': TexSymbolConfig('\uD835\uDC15'),
    '\uD835\uDC49': TexSymbolConfig('\uD835\uDC49'),
    '\uD835\uDC7D': TexSymbolConfig('\uD835\uDC7D'),
    '\uD835\uDD19': TexSymbolConfig('\uD835\uDD19'),
    '\uD835\uDDB5': TexSymbolConfig('\uD835\uDDB5'),
    '\uD835\uDDE9': TexSymbolConfig('\uD835\uDDE9'),
    '\uD835\uDE1D': TexSymbolConfig('\uD835\uDE1D'),
    '\uD835\uDE85': TexSymbolConfig('\uD835\uDE85'),
    '\uD835\uDD4D': TexSymbolConfig('\uD835\uDD4D'),
    '\uD835\uDCB1': TexSymbolConfig('\uD835\uDCB1'),
    '\uD835\uDC16': TexSymbolConfig('\uD835\uDC16'),
    '\uD835\uDC4A': TexSymbolConfig('\uD835\uDC4A'),
    '\uD835\uDC7E': TexSymbolConfig('\uD835\uDC7E'),
    '\uD835\uDD1A': TexSymbolConfig('\uD835\uDD1A'),
    '\uD835\uDDB6': TexSymbolConfig('\uD835\uDDB6'),
    '\uD835\uDDEA': TexSymbolConfig('\uD835\uDDEA'),
    '\uD835\uDE1E': TexSymbolConfig('\uD835\uDE1E'),
    '\uD835\uDE86': TexSymbolConfig('\uD835\uDE86'),
    '\uD835\uDD4E': TexSymbolConfig('\uD835\uDD4E'),
    '\uD835\uDCB2': TexSymbolConfig('\uD835\uDCB2'),
    '\uD835\uDC17': TexSymbolConfig('\uD835\uDC17'),
    '\uD835\uDC4B': TexSymbolConfig('\uD835\uDC4B'),
    '\uD835\uDC7F': TexSymbolConfig('\uD835\uDC7F'),
    '\uD835\uDD1B': TexSymbolConfig('\uD835\uDD1B'),
    '\uD835\uDDB7': TexSymbolConfig('\uD835\uDDB7'),
    '\uD835\uDDEB': TexSymbolConfig('\uD835\uDDEB'),
    '\uD835\uDE1F': TexSymbolConfig('\uD835\uDE1F'),
    '\uD835\uDE87': TexSymbolConfig('\uD835\uDE87'),
    '\uD835\uDD4F': TexSymbolConfig('\uD835\uDD4F'),
    '\uD835\uDCB3': TexSymbolConfig('\uD835\uDCB3'),
    '\uD835\uDC18': TexSymbolConfig('\uD835\uDC18'),
    '\uD835\uDC4C': TexSymbolConfig('\uD835\uDC4C'),
    '\uD835\uDC80': TexSymbolConfig('\uD835\uDC80'),
    '\uD835\uDD1C': TexSymbolConfig('\uD835\uDD1C'),
    '\uD835\uDDB8': TexSymbolConfig('\uD835\uDDB8'),
    '\uD835\uDDEC': TexSymbolConfig('\uD835\uDDEC'),
    '\uD835\uDE20': TexSymbolConfig('\uD835\uDE20'),
    '\uD835\uDE88': TexSymbolConfig('\uD835\uDE88'),
    '\uD835\uDD50': TexSymbolConfig('\uD835\uDD50'),
    '\uD835\uDCB4': TexSymbolConfig('\uD835\uDCB4'),
    '\uD835\uDC19': TexSymbolConfig('\uD835\uDC19'),
    '\uD835\uDC4D': TexSymbolConfig('\uD835\uDC4D'),
    '\uD835\uDC81': TexSymbolConfig('\uD835\uDC81'),
    '\uD835\uDD1D': TexSymbolConfig('\uD835\uDD1D'),
    '\uD835\uDDB9': TexSymbolConfig('\uD835\uDDB9'),
    '\uD835\uDDED': TexSymbolConfig('\uD835\uDDED'),
    '\uD835\uDE21': TexSymbolConfig('\uD835\uDE21'),
    '\uD835\uDE89': TexSymbolConfig('\uD835\uDE89'),
    '\uD835\uDD51': TexSymbolConfig('\uD835\uDD51'),
    '\uD835\uDCB5': TexSymbolConfig('\uD835\uDCB5'),
    '\uD835\uDC1A': TexSymbolConfig('\uD835\uDC1A'),
    '\uD835\uDC4E': TexSymbolConfig('\uD835\uDC4E'),
    '\uD835\uDC82': TexSymbolConfig('\uD835\uDC82'),
    '\uD835\uDD1E': TexSymbolConfig('\uD835\uDD1E'),
    '\uD835\uDDBA': TexSymbolConfig('\uD835\uDDBA'),
    '\uD835\uDDEE': TexSymbolConfig('\uD835\uDDEE'),
    '\uD835\uDE22': TexSymbolConfig('\uD835\uDE22'),
    '\uD835\uDE8A': TexSymbolConfig('\uD835\uDE8A'),
    '\uD835\uDC1B': TexSymbolConfig('\uD835\uDC1B'),
    '\uD835\uDC4F': TexSymbolConfig('\uD835\uDC4F'),
    '\uD835\uDC83': TexSymbolConfig('\uD835\uDC83'),
    '\uD835\uDD1F': TexSymbolConfig('\uD835\uDD1F'),
    '\uD835\uDDBB': TexSymbolConfig('\uD835\uDDBB'),
    '\uD835\uDDEF': TexSymbolConfig('\uD835\uDDEF'),
    '\uD835\uDE23': TexSymbolConfig('\uD835\uDE23'),
    '\uD835\uDE8B': TexSymbolConfig('\uD835\uDE8B'),
    '\uD835\uDC1C': TexSymbolConfig('\uD835\uDC1C'),
    '\uD835\uDC50': TexSymbolConfig('\uD835\uDC50'),
    '\uD835\uDC84': TexSymbolConfig('\uD835\uDC84'),
    '\uD835\uDD20': TexSymbolConfig('\uD835\uDD20'),
    '\uD835\uDDBC': TexSymbolConfig('\uD835\uDDBC'),
    '\uD835\uDDF0': TexSymbolConfig('\uD835\uDDF0'),
    '\uD835\uDE24': TexSymbolConfig('\uD835\uDE24'),
    '\uD835\uDE8C': TexSymbolConfig('\uD835\uDE8C'),
    '\uD835\uDC1D': TexSymbolConfig('\uD835\uDC1D'),
    '\uD835\uDC51': TexSymbolConfig('\uD835\uDC51'),
    '\uD835\uDC85': TexSymbolConfig('\uD835\uDC85'),
    '\uD835\uDD21': TexSymbolConfig('\uD835\uDD21'),
    '\uD835\uDDBD': TexSymbolConfig('\uD835\uDDBD'),
    '\uD835\uDDF1': TexSymbolConfig('\uD835\uDDF1'),
    '\uD835\uDE25': TexSymbolConfig('\uD835\uDE25'),
    '\uD835\uDE8D': TexSymbolConfig('\uD835\uDE8D'),
    '\uD835\uDC1E': TexSymbolConfig('\uD835\uDC1E'),
    '\uD835\uDC52': TexSymbolConfig('\uD835\uDC52'),
    '\uD835\uDC86': TexSymbolConfig('\uD835\uDC86'),
    '\uD835\uDD22': TexSymbolConfig('\uD835\uDD22'),
    '\uD835\uDDBE': TexSymbolConfig('\uD835\uDDBE'),
    '\uD835\uDDF2': TexSymbolConfig('\uD835\uDDF2'),
    '\uD835\uDE26': TexSymbolConfig('\uD835\uDE26'),
    '\uD835\uDE8E': TexSymbolConfig('\uD835\uDE8E'),
    '\uD835\uDC1F': TexSymbolConfig('\uD835\uDC1F'),
    '\uD835\uDC53': TexSymbolConfig('\uD835\uDC53'),
    '\uD835\uDC87': TexSymbolConfig('\uD835\uDC87'),
    '\uD835\uDD23': TexSymbolConfig('\uD835\uDD23'),
    '\uD835\uDDBF': TexSymbolConfig('\uD835\uDDBF'),
    '\uD835\uDDF3': TexSymbolConfig('\uD835\uDDF3'),
    '\uD835\uDE27': TexSymbolConfig('\uD835\uDE27'),
    '\uD835\uDE8F': TexSymbolConfig('\uD835\uDE8F'),
    '\uD835\uDC20': TexSymbolConfig('\uD835\uDC20'),
    '\uD835\uDC54': TexSymbolConfig('\uD835\uDC54'),
    '\uD835\uDC88': TexSymbolConfig('\uD835\uDC88'),
    '\uD835\uDD24': TexSymbolConfig('\uD835\uDD24'),
    '\uD835\uDDC0': TexSymbolConfig('\uD835\uDDC0'),
    '\uD835\uDDF4': TexSymbolConfig('\uD835\uDDF4'),
    '\uD835\uDE28': TexSymbolConfig('\uD835\uDE28'),
    '\uD835\uDE90': TexSymbolConfig('\uD835\uDE90'),
    '\uD835\uDC21': TexSymbolConfig('\uD835\uDC21'),
    '\uD835\uDC55': TexSymbolConfig('\uD835\uDC55'),
    '\uD835\uDC89': TexSymbolConfig('\uD835\uDC89'),
    '\uD835\uDD25': TexSymbolConfig('\uD835\uDD25'),
    '\uD835\uDDC1': TexSymbolConfig('\uD835\uDDC1'),
    '\uD835\uDDF5': TexSymbolConfig('\uD835\uDDF5'),
    '\uD835\uDE29': TexSymbolConfig('\uD835\uDE29'),
    '\uD835\uDE91': TexSymbolConfig('\uD835\uDE91'),
    '\uD835\uDC22': TexSymbolConfig('\uD835\uDC22'),
    '\uD835\uDC56': TexSymbolConfig('\uD835\uDC56'),
    '\uD835\uDC8A': TexSymbolConfig('\uD835\uDC8A'),
    '\uD835\uDD26': TexSymbolConfig('\uD835\uDD26'),
    '\uD835\uDDC2': TexSymbolConfig('\uD835\uDDC2'),
    '\uD835\uDDF6': TexSymbolConfig('\uD835\uDDF6'),
    '\uD835\uDE2A': TexSymbolConfig('\uD835\uDE2A'),
    '\uD835\uDE92': TexSymbolConfig('\uD835\uDE92'),
    '\uD835\uDC23': TexSymbolConfig('\uD835\uDC23'),
    '\uD835\uDC57': TexSymbolConfig('\uD835\uDC57'),
    '\uD835\uDC8B': TexSymbolConfig('\uD835\uDC8B'),
    '\uD835\uDD27': TexSymbolConfig('\uD835\uDD27'),
    '\uD835\uDDC3': TexSymbolConfig('\uD835\uDDC3'),
    '\uD835\uDDF7': TexSymbolConfig('\uD835\uDDF7'),
    '\uD835\uDE2B': TexSymbolConfig('\uD835\uDE2B'),
    '\uD835\uDE93': TexSymbolConfig('\uD835\uDE93'),
    '\uD835\uDC24': TexSymbolConfig('\uD835\uDC24'),
    '\uD835\uDC58': TexSymbolConfig('\uD835\uDC58'),
    '\uD835\uDC8C': TexSymbolConfig('\uD835\uDC8C'),
    '\uD835\uDD28': TexSymbolConfig('\uD835\uDD28'),
    '\uD835\uDDC4': TexSymbolConfig('\uD835\uDDC4'),
    '\uD835\uDDF8': TexSymbolConfig('\uD835\uDDF8'),
    '\uD835\uDE2C': TexSymbolConfig('\uD835\uDE2C'),
    '\uD835\uDE94': TexSymbolConfig('\uD835\uDE94'),
    '\uD835\uDC25': TexSymbolConfig('\uD835\uDC25'),
    '\uD835\uDC59': TexSymbolConfig('\uD835\uDC59'),
    '\uD835\uDC8D': TexSymbolConfig('\uD835\uDC8D'),
    '\uD835\uDD29': TexSymbolConfig('\uD835\uDD29'),
    '\uD835\uDDC5': TexSymbolConfig('\uD835\uDDC5'),
    '\uD835\uDDF9': TexSymbolConfig('\uD835\uDDF9'),
    '\uD835\uDE2D': TexSymbolConfig('\uD835\uDE2D'),
    '\uD835\uDE95': TexSymbolConfig('\uD835\uDE95'),
    '\uD835\uDC26': TexSymbolConfig('\uD835\uDC26'),
    '\uD835\uDC5A': TexSymbolConfig('\uD835\uDC5A'),
    '\uD835\uDC8E': TexSymbolConfig('\uD835\uDC8E'),
    '\uD835\uDD2A': TexSymbolConfig('\uD835\uDD2A'),
    '\uD835\uDDC6': TexSymbolConfig('\uD835\uDDC6'),
    '\uD835\uDDFA': TexSymbolConfig('\uD835\uDDFA'),
    '\uD835\uDE2E': TexSymbolConfig('\uD835\uDE2E'),
    '\uD835\uDE96': TexSymbolConfig('\uD835\uDE96'),
    '\uD835\uDC27': TexSymbolConfig('\uD835\uDC27'),
    '\uD835\uDC5B': TexSymbolConfig('\uD835\uDC5B'),
    '\uD835\uDC8F': TexSymbolConfig('\uD835\uDC8F'),
    '\uD835\uDD2B': TexSymbolConfig('\uD835\uDD2B'),
    '\uD835\uDDC7': TexSymbolConfig('\uD835\uDDC7'),
    '\uD835\uDDFB': TexSymbolConfig('\uD835\uDDFB'),
    '\uD835\uDE2F': TexSymbolConfig('\uD835\uDE2F'),
    '\uD835\uDE97': TexSymbolConfig('\uD835\uDE97'),
    '\uD835\uDC28': TexSymbolConfig('\uD835\uDC28'),
    '\uD835\uDC5C': TexSymbolConfig('\uD835\uDC5C'),
    '\uD835\uDC90': TexSymbolConfig('\uD835\uDC90'),
    '\uD835\uDD2C': TexSymbolConfig('\uD835\uDD2C'),
    '\uD835\uDDC8': TexSymbolConfig('\uD835\uDDC8'),
    '\uD835\uDDFC': TexSymbolConfig('\uD835\uDDFC'),
    '\uD835\uDE30': TexSymbolConfig('\uD835\uDE30'),
    '\uD835\uDE98': TexSymbolConfig('\uD835\uDE98'),
    '\uD835\uDC29': TexSymbolConfig('\uD835\uDC29'),
    '\uD835\uDC5D': TexSymbolConfig('\uD835\uDC5D'),
    '\uD835\uDC91': TexSymbolConfig('\uD835\uDC91'),
    '\uD835\uDD2D': TexSymbolConfig('\uD835\uDD2D'),
    '\uD835\uDDC9': TexSymbolConfig('\uD835\uDDC9'),
    '\uD835\uDDFD': TexSymbolConfig('\uD835\uDDFD'),
    '\uD835\uDE31': TexSymbolConfig('\uD835\uDE31'),
    '\uD835\uDE99': TexSymbolConfig('\uD835\uDE99'),
    '\uD835\uDC2A': TexSymbolConfig('\uD835\uDC2A'),
    '\uD835\uDC5E': TexSymbolConfig('\uD835\uDC5E'),
    '\uD835\uDC92': TexSymbolConfig('\uD835\uDC92'),
    '\uD835\uDD2E': TexSymbolConfig('\uD835\uDD2E'),
    '\uD835\uDDCA': TexSymbolConfig('\uD835\uDDCA'),
    '\uD835\uDDFE': TexSymbolConfig('\uD835\uDDFE'),
    '\uD835\uDE32': TexSymbolConfig('\uD835\uDE32'),
    '\uD835\uDE9A': TexSymbolConfig('\uD835\uDE9A'),
    '\uD835\uDC2B': TexSymbolConfig('\uD835\uDC2B'),
    '\uD835\uDC5F': TexSymbolConfig('\uD835\uDC5F'),
    '\uD835\uDC93': TexSymbolConfig('\uD835\uDC93'),
    '\uD835\uDD2F': TexSymbolConfig('\uD835\uDD2F'),
    '\uD835\uDDCB': TexSymbolConfig('\uD835\uDDCB'),
    '\uD835\uDDFF': TexSymbolConfig('\uD835\uDDFF'),
    '\uD835\uDE33': TexSymbolConfig('\uD835\uDE33'),
    '\uD835\uDE9B': TexSymbolConfig('\uD835\uDE9B'),
    '\uD835\uDC2C': TexSymbolConfig('\uD835\uDC2C'),
    '\uD835\uDC60': TexSymbolConfig('\uD835\uDC60'),
    '\uD835\uDC94': TexSymbolConfig('\uD835\uDC94'),
    '\uD835\uDD30': TexSymbolConfig('\uD835\uDD30'),
    '\uD835\uDDCC': TexSymbolConfig('\uD835\uDDCC'),
    '\uD835\uDE00': TexSymbolConfig('\uD835\uDE00'),
    '\uD835\uDE34': TexSymbolConfig('\uD835\uDE34'),
    '\uD835\uDE9C': TexSymbolConfig('\uD835\uDE9C'),
    '\uD835\uDC2D': TexSymbolConfig('\uD835\uDC2D'),
    '\uD835\uDC61': TexSymbolConfig('\uD835\uDC61'),
    '\uD835\uDC95': TexSymbolConfig('\uD835\uDC95'),
    '\uD835\uDD31': TexSymbolConfig('\uD835\uDD31'),
    '\uD835\uDDCD': TexSymbolConfig('\uD835\uDDCD'),
    '\uD835\uDE01': TexSymbolConfig('\uD835\uDE01'),
    '\uD835\uDE35': TexSymbolConfig('\uD835\uDE35'),
    '\uD835\uDE9D': TexSymbolConfig('\uD835\uDE9D'),
    '\uD835\uDC2E': TexSymbolConfig('\uD835\uDC2E'),
    '\uD835\uDC62': TexSymbolConfig('\uD835\uDC62'),
    '\uD835\uDC96': TexSymbolConfig('\uD835\uDC96'),
    '\uD835\uDD32': TexSymbolConfig('\uD835\uDD32'),
    '\uD835\uDDCE': TexSymbolConfig('\uD835\uDDCE'),
    '\uD835\uDE02': TexSymbolConfig('\uD835\uDE02'),
    '\uD835\uDE36': TexSymbolConfig('\uD835\uDE36'),
    '\uD835\uDE9E': TexSymbolConfig('\uD835\uDE9E'),
    '\uD835\uDC2F': TexSymbolConfig('\uD835\uDC2F'),
    '\uD835\uDC63': TexSymbolConfig('\uD835\uDC63'),
    '\uD835\uDC97': TexSymbolConfig('\uD835\uDC97'),
    '\uD835\uDD33': TexSymbolConfig('\uD835\uDD33'),
    '\uD835\uDDCF': TexSymbolConfig('\uD835\uDDCF'),
    '\uD835\uDE03': TexSymbolConfig('\uD835\uDE03'),
    '\uD835\uDE37': TexSymbolConfig('\uD835\uDE37'),
    '\uD835\uDE9F': TexSymbolConfig('\uD835\uDE9F'),
    '\uD835\uDC30': TexSymbolConfig('\uD835\uDC30'),
    '\uD835\uDC64': TexSymbolConfig('\uD835\uDC64'),
    '\uD835\uDC98': TexSymbolConfig('\uD835\uDC98'),
    '\uD835\uDD34': TexSymbolConfig('\uD835\uDD34'),
    '\uD835\uDDD0': TexSymbolConfig('\uD835\uDDD0'),
    '\uD835\uDE04': TexSymbolConfig('\uD835\uDE04'),
    '\uD835\uDE38': TexSymbolConfig('\uD835\uDE38'),
    '\uD835\uDEA0': TexSymbolConfig('\uD835\uDEA0'),
    '\uD835\uDC31': TexSymbolConfig('\uD835\uDC31'),
    '\uD835\uDC65': TexSymbolConfig('\uD835\uDC65'),
    '\uD835\uDC99': TexSymbolConfig('\uD835\uDC99'),
    '\uD835\uDD35': TexSymbolConfig('\uD835\uDD35'),
    '\uD835\uDDD1': TexSymbolConfig('\uD835\uDDD1'),
    '\uD835\uDE05': TexSymbolConfig('\uD835\uDE05'),
    '\uD835\uDE39': TexSymbolConfig('\uD835\uDE39'),
    '\uD835\uDEA1': TexSymbolConfig('\uD835\uDEA1'),
    '\uD835\uDC32': TexSymbolConfig('\uD835\uDC32'),
    '\uD835\uDC66': TexSymbolConfig('\uD835\uDC66'),
    '\uD835\uDC9A': TexSymbolConfig('\uD835\uDC9A'),
    '\uD835\uDD36': TexSymbolConfig('\uD835\uDD36'),
    '\uD835\uDDD2': TexSymbolConfig('\uD835\uDDD2'),
    '\uD835\uDE06': TexSymbolConfig('\uD835\uDE06'),
    '\uD835\uDE3A': TexSymbolConfig('\uD835\uDE3A'),
    '\uD835\uDEA2': TexSymbolConfig('\uD835\uDEA2'),
    '\uD835\uDC33': TexSymbolConfig('\uD835\uDC33'),
    '\uD835\uDC67': TexSymbolConfig('\uD835\uDC67'),
    '\uD835\uDC9B': TexSymbolConfig('\uD835\uDC9B'),
    '\uD835\uDD37': TexSymbolConfig('\uD835\uDD37'),
    '\uD835\uDDD3': TexSymbolConfig('\uD835\uDDD3'),
    '\uD835\uDE07': TexSymbolConfig('\uD835\uDE07'),
    '\uD835\uDE3B': TexSymbolConfig('\uD835\uDE3B'),
    '\uD835\uDEA3': TexSymbolConfig('\uD835\uDEA3'),
    '\uD835\uDD5C': TexSymbolConfig('\uD835\uDD5C'),
    '\uD835\uDFCE': TexSymbolConfig('\uD835\uDFCE'),
    '\uD835\uDFE2': TexSymbolConfig('\uD835\uDFE2'),
    '\uD835\uDFEC': TexSymbolConfig('\uD835\uDFEC'),
    '\uD835\uDFF6': TexSymbolConfig('\uD835\uDFF6'),
    '\uD835\uDFCF': TexSymbolConfig('\uD835\uDFCF'),
    '\uD835\uDFE3': TexSymbolConfig('\uD835\uDFE3'),
    '\uD835\uDFED': TexSymbolConfig('\uD835\uDFED'),
    '\uD835\uDFF7': TexSymbolConfig('\uD835\uDFF7'),
    '\uD835\uDFD0': TexSymbolConfig('\uD835\uDFD0'),
    '\uD835\uDFE4': TexSymbolConfig('\uD835\uDFE4'),
    '\uD835\uDFEE': TexSymbolConfig('\uD835\uDFEE'),
    '\uD835\uDFF8': TexSymbolConfig('\uD835\uDFF8'),
    '\uD835\uDFD1': TexSymbolConfig('\uD835\uDFD1'),
    '\uD835\uDFE5': TexSymbolConfig('\uD835\uDFE5'),
    '\uD835\uDFEF': TexSymbolConfig('\uD835\uDFEF'),
    '\uD835\uDFF9': TexSymbolConfig('\uD835\uDFF9'),
    '\uD835\uDFD2': TexSymbolConfig('\uD835\uDFD2'),
    '\uD835\uDFE6': TexSymbolConfig('\uD835\uDFE6'),
    '\uD835\uDFF0': TexSymbolConfig('\uD835\uDFF0'),
    '\uD835\uDFFA': TexSymbolConfig('\uD835\uDFFA'),
    '\uD835\uDFD3': TexSymbolConfig('\uD835\uDFD3'),
    '\uD835\uDFE7': TexSymbolConfig('\uD835\uDFE7'),
    '\uD835\uDFF1': TexSymbolConfig('\uD835\uDFF1'),
    '\uD835\uDFFB': TexSymbolConfig('\uD835\uDFFB'),
    '\uD835\uDFD4': TexSymbolConfig('\uD835\uDFD4'),
    '\uD835\uDFE8': TexSymbolConfig('\uD835\uDFE8'),
    '\uD835\uDFF2': TexSymbolConfig('\uD835\uDFF2'),
    '\uD835\uDFFC': TexSymbolConfig('\uD835\uDFFC'),
    '\uD835\uDFD5': TexSymbolConfig('\uD835\uDFD5'),
    '\uD835\uDFE9': TexSymbolConfig('\uD835\uDFE9'),
    '\uD835\uDFF3': TexSymbolConfig('\uD835\uDFF3'),
    '\uD835\uDFFD': TexSymbolConfig('\uD835\uDFFD'),
    '\uD835\uDFD6': TexSymbolConfig('\uD835\uDFD6'),
    '\uD835\uDFEA': TexSymbolConfig('\uD835\uDFEA'),
    '\uD835\uDFF4': TexSymbolConfig('\uD835\uDFF4'),
    '\uD835\uDFFE': TexSymbolConfig('\uD835\uDFFE'),
    '\uD835\uDFD7': TexSymbolConfig('\uD835\uDFD7'),
    '\uD835\uDFEB': TexSymbolConfig('\uD835\uDFEB'),
    '\uD835\uDFF5': TexSymbolConfig('\uD835\uDFF5'),
    '\uD835\uDFFF': TexSymbolConfig('\uD835\uDFFF'),
    '\u00C7': TexSymbolConfig('\u00C7'),
    '\u00D0': TexSymbolConfig('\u00D0'),
    '\u00DE': TexSymbolConfig('\u00DE'),
    '\u00E7': TexSymbolConfig('\u00E7'),
    '\u00FE': TexSymbolConfig('\u00FE'),
    '\u00F0': TexSymbolConfig('\u00F0'),
    '\u2013': TexSymbolConfig('\u2013'),
    '\u2014': TexSymbolConfig('\u2014'),
    '\u2018': TexSymbolConfig('\u2018'),
    '\u2019': TexSymbolConfig('\u2019'),
    '\u201C': TexSymbolConfig('\u201C'),
    '\u201D': TexSymbolConfig('\u201D'),
    '\u00A0': TexSymbolConfig('\u00A0'),
    '\\S': TexSymbolConfig('\u00A7'),
    '\\P': TexSymbolConfig('\u00B6'),
    '\\yen': TexSymbolConfig('\u00A5'),
    '\\ ': TexSymbolConfig(' '),
    '~': TexSymbolConfig('\u00A0'),
    '\\space': TexSymbolConfig(' '),
    '\\nobreakspace': TexSymbolConfig('\u00A0'),
    '\\lbrack': TexSymbolConfig('['),
    '\\rbrack': TexSymbolConfig(']'),
    '\\textless': TexSymbolConfig('<'),
    '\\textgreater': TexSymbolConfig('>'),
    '\\textbar': TexSymbolConfig('|'),
    '\\textellipsis': TexSymbolConfig('\u2026'),
    '\\ldots': TexSymbolConfig('\u2026'),
    '\\i': TexSymbolConfig('\u0131'),
    '\\j': TexSymbolConfig('\u0237'),
    '\\ss': TexSymbolConfig('\u00DF'),
    '\\ae': TexSymbolConfig('\u00E6'),
    '\\oe': TexSymbolConfig('\u0153'),
    '\\o': TexSymbolConfig('\u00F8'),
    '\\AE': TexSymbolConfig('\u00C6'),
    '\\OE': TexSymbolConfig('\u0152'),
    '\\O': TexSymbolConfig('\u00D8'),
    '--': TexSymbolConfig('\u2013'),
    '\\textendash': TexSymbolConfig('\u2013'),
    '---': TexSymbolConfig('\u2014'),
    '\\textemdash': TexSymbolConfig('\u2014'),
    '\\textquoteleft': TexSymbolConfig('\u2018'),
    '\\textquoteright': TexSymbolConfig('\u2019'),
    '``': TexSymbolConfig('\u201C'),
    '\\textquotedblleft': TexSymbolConfig('\u201C'),
    '\'\'': TexSymbolConfig('\u201D'),
    '\\textquotedblright': TexSymbolConfig('\u201D'),
    '\\degree': TexSymbolConfig('\u00B0'),
    '\\textdegree': TexSymbolConfig('\u00B0'),
    '\\pounds': TexSymbolConfig('\u00A3'),
    '\\textsterling': TexSymbolConfig('\u00A3'),
    '\\textbardbl': TexSymbolConfig('\u2225'),
    '\\#': TexSymbolConfig('#'),
    '\\&': TexSymbolConfig('&'),
    '\\textdagger': TexSymbolConfig('\u2020'),
    '\\dag': TexSymbolConfig('\u2020'),
    '\\textdaggerdbl': TexSymbolConfig('\u2021'),
    '\\ddag': TexSymbolConfig('\u2021'),
    '\\textcircled': TexSymbolConfig('\u25EF'),
    '\\circledR': TexSymbolConfig('\u00AE'),
    '\\\$': TexSymbolConfig('\$'),
    '\\textdollar': TexSymbolConfig('\$'),
    '\\%': TexSymbolConfig('%'),
    '\\_': TexSymbolConfig('_'),
    '\\textunderscore': TexSymbolConfig('_'),
    '\\{': TexSymbolConfig('{'),
    '\\textbraceleft': TexSymbolConfig('{'),
    '\\}': TexSymbolConfig('}'),
    '\\textbraceright': TexSymbolConfig('}'),
    '\\textbackslash': TexSymbolConfig('\\'),
    '\\\'': TexSymbolConfig('\u02CA'),
    '\\`': TexSymbolConfig('\u02CB'),
    '\\\"': TexSymbolConfig('\u00A8'),
    '\\textasciitilde': TexSymbolConfig('~'),
    '\\=': TexSymbolConfig('\u02C9'),
    '\\u': TexSymbolConfig('\u02D8'),
    '\\v': TexSymbolConfig('\u02C7'),
    '\\textasciicircum': TexSymbolConfig('^'),
    '\\.': TexSymbolConfig('\u02D9'),
    '\\r': TexSymbolConfig('\u02DA'),
    '\\maltese': TexSymbolConfig('\u2720'),
    '\\checkmark': TexSymbolConfig('\u2713'),
    '\\^': TexSymbolConfig('\u02C6'),
    '\\~': TexSymbolConfig('\u02DC'),
    '\\H': TexSymbolConfig('\u02DD'),
    ...extraTexTextSymbolCommandConfigs
  },
};

const extraLatin = {'Ç', 'Ð', 'Þ', 'ç', 'þ'};

const ligatures = {
  '–': '--',
  '—': '---',
  '“': '``',
  '”': "''",
};
