// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v25.5.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:io' show Platform;
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart'
    show ReadBuffer, WriteBuffer, immutable, protected;
import 'package:flutter/services.dart';
import 'package:flutter/widgets.dart' show WidgetsFlutterBinding;

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

List<Object?> wrapResponse({
  Object? result,
  PlatformException? error,
  bool empty = false,
}) {
  if (empty) {
    return <Object?>[];
  }
  if (error == null) {
    return <Object?>[result];
  }
  return <Object?>[error.code, error.message, error.details];
}

/// An immutable object that serves as the base class for all ProxyApis and
/// can provide functional copies of itself.
///
/// All implementers are expected to be [immutable] as defined by the annotation
/// and override [pigeon_copy] returning an instance of itself.
@immutable
abstract class PigeonInternalProxyApiBaseClass {
  /// Construct a [PigeonInternalProxyApiBaseClass].
  PigeonInternalProxyApiBaseClass({
    this.pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) : pigeon_instanceManager =
           pigeon_instanceManager ?? PigeonInstanceManager.instance;

  /// Sends and receives binary data across the Flutter platform barrier.
  ///
  /// If it is null, the default BinaryMessenger will be used, which routes to
  /// the host platform.
  @protected
  final BinaryMessenger? pigeon_binaryMessenger;

  /// Maintains instances stored to communicate with native language objects.
  final PigeonInstanceManager pigeon_instanceManager;

  /// Instantiates and returns a functionally identical object to oneself.
  ///
  /// Outside of tests, this method should only ever be called by
  /// [PigeonInstanceManager].
  ///
  /// Subclasses should always override their parent's implementation of this
  /// method.
  @protected
  PigeonInternalProxyApiBaseClass pigeon_copy();
}

/// Maintains instances used to communicate with the native objects they
/// represent.
///
/// Added instances are stored as weak references and their copies are stored
/// as strong references to maintain access to their variables and callback
/// methods. Both are stored with the same identifier.
///
/// When a weak referenced instance becomes inaccessible,
/// [onWeakReferenceRemoved] is called with its associated identifier.
///
/// If an instance is retrieved and has the possibility to be used,
/// (e.g. calling [getInstanceWithWeakReference]) a copy of the strong reference
/// is added as a weak reference with the same identifier. This prevents a
/// scenario where the weak referenced instance was released and then later
/// returned by the host platform.
class PigeonInstanceManager {
  /// Constructs a [PigeonInstanceManager].
  PigeonInstanceManager({required void Function(int) onWeakReferenceRemoved}) {
    this.onWeakReferenceRemoved = (int identifier) {
      _weakInstances.remove(identifier);
      onWeakReferenceRemoved(identifier);
    };
    _finalizer = Finalizer<int>(this.onWeakReferenceRemoved);
  }

  // Identifiers are locked to a specific range to avoid collisions with objects
  // created simultaneously by the host platform.
  // Host uses identifiers >= 2^16 and Dart is expected to use values n where,
  // 0 <= n < 2^16.
  static const int _maxDartCreatedIdentifier = 65536;

  /// The default [PigeonInstanceManager] used by ProxyApis.
  ///
  /// On creation, this manager makes a call to clear the native
  /// InstanceManager. This is to prevent identifier conflicts after a host
  /// restart.
  static final PigeonInstanceManager instance = _initInstance();

  // Expando is used because it doesn't prevent its keys from becoming
  // inaccessible. This allows the manager to efficiently retrieve an identifier
  // of an instance without holding a strong reference to that instance.
  //
  // It also doesn't use `==` to search for identifiers, which would lead to an
  // infinite loop when comparing an object to its copy. (i.e. which was caused
  // by calling instanceManager.getIdentifier() inside of `==` while this was a
  // HashMap).
  final Expando<int> _identifiers = Expando<int>();
  final Map<int, WeakReference<PigeonInternalProxyApiBaseClass>>
  _weakInstances = <int, WeakReference<PigeonInternalProxyApiBaseClass>>{};
  final Map<int, PigeonInternalProxyApiBaseClass> _strongInstances =
      <int, PigeonInternalProxyApiBaseClass>{};
  late final Finalizer<int> _finalizer;
  int _nextIdentifier = 0;

  /// Called when a weak referenced instance is removed by [removeWeakReference]
  /// or becomes inaccessible.
  late final void Function(int) onWeakReferenceRemoved;

  static PigeonInstanceManager _initInstance() {
    if (Platform.environment['FLUTTER_TEST'] == 'true') {
      return PigeonInstanceManager(onWeakReferenceRemoved: (_) {});
    }
    WidgetsFlutterBinding.ensureInitialized();
    final _PigeonInternalInstanceManagerApi api =
        _PigeonInternalInstanceManagerApi();
    // Clears the native `PigeonInstanceManager` on the initial use of the Dart one.
    api.clear();
    final PigeonInstanceManager instanceManager = PigeonInstanceManager(
      onWeakReferenceRemoved: (int identifier) {
        api.removeStrongReference(identifier);
      },
    );
    _PigeonInternalInstanceManagerApi.setUpMessageHandlers(
      instanceManager: instanceManager,
    );
    CameraSize.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ResolutionInfo.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CameraIntegerRange.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    VideoRecordEvent.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    VideoRecordEventStart.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    VideoRecordEventFinalize.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    MeteringPoint.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    Observer.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CameraInfo.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CameraSelector.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ProcessCameraProvider.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    UseCase.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    Camera.pigeon_setUpMessageHandlers(pigeon_instanceManager: instanceManager);
    SystemServicesManager.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CameraPermissionsError.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    DeviceOrientationManager.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    Preview.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    VideoCapture.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    VideoOutput.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    Recorder.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    VideoRecordEventListener.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    PendingRecording.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    Recording.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ImageCapture.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ResolutionStrategy.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ResolutionSelector.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    AspectRatioStrategy.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CameraState.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ExposureState.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ZoomState.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ImageAnalysis.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    Analyzer.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CameraStateStateError.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    LiveData.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ImageProxy.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    PlaneProxy.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    QualitySelector.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    FallbackStrategy.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CameraControl.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    FocusMeteringActionBuilder.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    FocusMeteringAction.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    FocusMeteringResult.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CaptureRequest.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CaptureRequestKey.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CaptureRequestOptions.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    Camera2CameraControl.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    ResolutionFilter.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CameraCharacteristicsKey.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    CameraCharacteristics.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    Camera2CameraInfo.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    MeteringPointFactory.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    DisplayOrientedMeteringPointFactory.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    return instanceManager;
  }

  /// Adds a new instance that was instantiated by Dart.
  ///
  /// In other words, Dart wants to add a new instance that will represent
  /// an object that will be instantiated on the host platform.
  ///
  /// Throws assertion error if the instance has already been added.
  ///
  /// Returns the randomly generated id of the [instance] added.
  int addDartCreatedInstance(PigeonInternalProxyApiBaseClass instance) {
    assert(getIdentifier(instance) == null);

    final int identifier = _nextUniqueIdentifier();
    _identifiers[instance] = identifier;
    _weakInstances[identifier] = WeakReference<PigeonInternalProxyApiBaseClass>(
      instance,
    );
    _finalizer.attach(instance, identifier, detach: instance);

    final PigeonInternalProxyApiBaseClass copy = instance.pigeon_copy();
    _identifiers[copy] = identifier;
    _strongInstances[identifier] = copy;
    return identifier;
  }

  /// Removes the instance, if present, and call [onWeakReferenceRemoved] with
  /// its identifier.
  ///
  /// Returns the identifier associated with the removed instance. Otherwise,
  /// `null` if the instance was not found in this manager.
  ///
  /// This does not remove the strong referenced instance associated with
  /// [instance]. This can be done with [remove].
  int? removeWeakReference(PigeonInternalProxyApiBaseClass instance) {
    final int? identifier = getIdentifier(instance);
    if (identifier == null) {
      return null;
    }

    _identifiers[instance] = null;
    _finalizer.detach(instance);
    onWeakReferenceRemoved(identifier);

    return identifier;
  }

  /// Removes [identifier] and its associated strongly referenced instance, if
  /// present, from the manager.
  ///
  /// Returns the strong referenced instance associated with [identifier] before
  /// it was removed. Returns `null` if [identifier] was not associated with
  /// any strong reference.
  ///
  /// Throws an `AssertionError` if the weak referenced instance associated with
  /// [identifier] is not removed first. This can be done with
  /// [removeWeakReference].
  T? remove<T extends PigeonInternalProxyApiBaseClass>(int identifier) {
    final T? instance = _weakInstances[identifier]?.target as T?;
    assert(
      instance == null,
      'A strong instance with identifier $identifier is being removed despite the weak reference still existing: $instance',
    );
    return _strongInstances.remove(identifier) as T?;
  }

  /// Retrieves the instance associated with identifier.
  ///
  /// The value returned is chosen from the following order:
  ///
  /// 1. A weakly referenced instance associated with identifier.
  /// 2. If the only instance associated with identifier is a strongly
  /// referenced instance, a copy of the instance is added as a weak reference
  /// with the same identifier. Returning the newly created copy.
  /// 3. If no instance is associated with identifier, returns null.
  ///
  /// This method also expects the host `InstanceManager` to have a strong
  /// reference to the instance the identifier is associated with.
  T? getInstanceWithWeakReference<T extends PigeonInternalProxyApiBaseClass>(
    int identifier,
  ) {
    final PigeonInternalProxyApiBaseClass? weakInstance =
        _weakInstances[identifier]?.target;

    if (weakInstance == null) {
      final PigeonInternalProxyApiBaseClass? strongInstance =
          _strongInstances[identifier];
      if (strongInstance != null) {
        final PigeonInternalProxyApiBaseClass copy = strongInstance
            .pigeon_copy();
        _identifiers[copy] = identifier;
        _weakInstances[identifier] =
            WeakReference<PigeonInternalProxyApiBaseClass>(copy);
        _finalizer.attach(copy, identifier, detach: copy);
        return copy as T;
      }
      return strongInstance as T?;
    }

    return weakInstance as T;
  }

  /// Retrieves the identifier associated with instance.
  int? getIdentifier(PigeonInternalProxyApiBaseClass instance) {
    return _identifiers[instance];
  }

  /// Adds a new instance that was instantiated by the host platform.
  ///
  /// In other words, the host platform wants to add a new instance that
  /// represents an object on the host platform. Stored with [identifier].
  ///
  /// Throws assertion error if the instance or its identifier has already been
  /// added.
  void addHostCreatedInstance(
    PigeonInternalProxyApiBaseClass instance,
    int identifier,
  ) {
    assert(!containsIdentifier(identifier));
    assert(getIdentifier(instance) == null);
    assert(identifier >= 0);

    _identifiers[instance] = identifier;
    _strongInstances[identifier] = instance;
  }

  /// Whether this manager contains the given [identifier].
  bool containsIdentifier(int identifier) {
    return _weakInstances.containsKey(identifier) ||
        _strongInstances.containsKey(identifier);
  }

  int _nextUniqueIdentifier() {
    late int identifier;
    do {
      identifier = _nextIdentifier;
      _nextIdentifier = (_nextIdentifier + 1) % _maxDartCreatedIdentifier;
    } while (containsIdentifier(identifier));
    return identifier;
  }
}

/// Generated API for managing the Dart and native `PigeonInstanceManager`s.
class _PigeonInternalInstanceManagerApi {
  /// Constructor for [_PigeonInternalInstanceManagerApi].
  _PigeonInternalInstanceManagerApi({BinaryMessenger? binaryMessenger})
    : pigeonVar_binaryMessenger = binaryMessenger;

  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  static void setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? binaryMessenger,
    PigeonInstanceManager? instanceManager,
  }) {
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.PigeonInternalInstanceManager.removeStrongReference',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.PigeonInternalInstanceManager.removeStrongReference was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_identifier = (args[0] as int?);
          assert(
            arg_identifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.PigeonInternalInstanceManager.removeStrongReference was null, expected non-null int.',
          );
          try {
            (instanceManager ?? PigeonInstanceManager.instance).remove(
              arg_identifier!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  Future<void> removeStrongReference(int identifier) async {
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.PigeonInternalInstanceManager.removeStrongReference';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[identifier],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Clear the native `PigeonInstanceManager`.
  ///
  /// This is typically called after a hot restart.
  Future<void> clear() async {
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.PigeonInternalInstanceManager.clear';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class _PigeonInternalProxyApiBaseCodec extends _PigeonCodec {
  const _PigeonInternalProxyApiBaseCodec(this.instanceManager);
  final PigeonInstanceManager instanceManager;
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is PigeonInternalProxyApiBaseClass) {
      buffer.putUint8(128);
      writeValue(buffer, instanceManager.getIdentifier(value));
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 128:
        return instanceManager.getInstanceWithWeakReference(
          readValue(buffer)! as int,
        );
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

/// Generally classifies the overall set of the camera device functionality.
///
/// See https://developer.android.com/reference/android/hardware/camera2/CameraMetadata#INFO_SUPPORTED_HARDWARE_LEVEL_3.
enum InfoSupportedHardwareLevel {
  /// This camera device is capable of YUV reprocessing and RAW data capture, in
  /// addition to FULL-level capabilities.
  level3,

  /// This camera device is backed by an external camera connected to this
  /// Android device.
  external,

  /// This camera device is capable of supporting advanced imaging applications.
  full,

  /// This camera device is running in backward compatibility mode.
  legacy,

  /// This camera device does not have enough capabilities to qualify as a FULL
  /// device or better.
  limited,
}

/// The aspect ratio of the use case.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/AspectRatio.
enum AspectRatio {
  /// 16:9 standard aspect ratio.
  ratio16To9,

  /// 4:3 standard aspect ratio.
  ratio4To3,

  /// The aspect ratio representing no preference for aspect ratio.
  ratioDefault,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// The states the camera can be in.
///
/// See https://developer.android.com/reference/androidx/camera/core/CameraState.Type.
enum CameraStateType {
  /// Represents a state where the camera device is closed.
  closed,

  /// Represents a state where the camera device is currently closing.
  closing,

  /// Represents a state where the camera device is open.
  open,

  /// Represents a state where the camera device is currently opening.
  opening,

  /// Represents a state where the camera is waiting for a signal to attempt to
  /// open the camera device.
  pendingOpen,

  /// This value is not recognized by this wrapper.
  unknown,
}

/// The types (T) properly wrapped to be used as a LiveData<T>.
enum LiveDataSupportedType { cameraState, zoomState }

/// Video quality constraints that will be used by a QualitySelector to choose
/// an appropriate video resolution.
///
/// These are pre-defined quality constants that are universally used for video.
///
/// See https://developer.android.com/reference/androidx/camera/video/Quality.
enum VideoQuality {
  /// Standard Definition (SD) 480p video quality.
  SD,

  /// High Definition (HD) 720p video quality.
  HD,

  /// Full High Definition (FHD) 1080p video quality.
  FHD,

  /// Ultra High Definition (UHD) 2160p video quality.
  UHD,

  /// The lowest video quality supported by the video frame producer.
  lowest,

  /// The highest video quality supported by the video frame producer.
  highest,
}

/// A flag used for indicating metering mode regions.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/FocusMeteringAction#FLAG_AF().
enum MeteringMode {
  /// A flag used in metering mode indicating the AE (Auto Exposure) region is
  /// enabled.
  ae,

  /// A flag used in metering mode indicating the AF (Auto Focus) region is
  /// enabled.
  af,

  /// A flag used in metering mode indicating the AWB (Auto White Balance)
  /// region is enabled.
  awb,
}

/// Direction of lens of a camera.
///
/// See https://developer.android.com/reference/androidx/camera/core/CameraSelector#LENS_FACING_BACK().
enum LensFacing {
  /// A camera on the device facing the same direction as the device's screen.
  front,

  /// A camera on the device facing the opposite direction as the device's
  /// screen.
  back,

  /// An external camera that has no fixed facing relative to the device's
  /// screen.
  external,

  /// A camera on the devices that its lens facing is resolved.
  unknown,
}

/// FlashModes for image capture.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageCapture#FLASH_MODE_AUTO().
enum CameraXFlashMode {
  /// Auto flash.
  ///
  /// The flash will be used according to the camera system's determination when
  /// taking a picture.
  auto,

  /// No flash.
  ///
  /// The flash will never be used when taking a picture.
  off,

  /// Always flash.
  ///
  /// The flash will always be used when taking a picture.
  on,
}

/// Fallback rule for choosing an alternate size when the specified bound size
/// is unavailable.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/ResolutionStrategy.
enum ResolutionStrategyFallbackRule {
  /// When the specified bound size is unavailable, CameraX falls back to the
  /// closest higher resolution size.
  closestHigher,

  /// When the specified bound size is unavailable, CameraX falls back to select
  /// the closest higher resolution size.
  closestHigherThenLower,

  /// When the specified bound size is unavailable, CameraX falls back to the
  /// closest lower resolution size.
  closestLower,

  /// When the specified bound size is unavailable, CameraX falls back to select
  /// the closest lower resolution size.
  ///
  /// If CameraX still cannot find any available resolution, it will fallback to
  /// select other higher resolutions.
  closestLowerThenHigher,

  /// CameraX doesn't select an alternate size when the specified bound size is
  /// unavailable.
  none,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// Fallback rule for choosing the aspect ratio when the preferred aspect ratio
/// is not available.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/AspectRatioStrategy#FALLBACK_RULE_AUTO().
enum AspectRatioStrategyFallbackRule {
  /// CameraX automatically chooses the next best aspect ratio which contains
  /// the closest field of view (FOV) of the camera sensor, from the remaining
  /// options.
  auto,

  /// CameraX doesn't fall back to select sizes of any other aspect ratio when
  /// this fallback rule is used.
  none,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// Code for a `CameraState` error.
///
/// https://developer.android.com/reference/androidx/camera/core/CameraState#ERROR_CAMERA_DISABLED()
enum CameraStateErrorCode {
  /// An error indicating that the camera device could not be opened due to a
  /// device policy.
  cameraDisabled,

  /// An error indicating that the camera device was closed due to a fatal
  /// error.
  cameraFatalError,

  /// An error indicating that the camera device is already in use.
  cameraInUse,

  /// An error indicating that the camera could not be opened because "Do Not
  /// Disturb" mode is enabled on devices affected by a bug in Android 9 (API
  /// level 28).
  doNotDisturbModeEnabled,

  /// An error indicating that the limit number of open cameras has been
  /// reached, and more cameras cannot be opened until other instances are
  /// closed.
  maxCamerasInUse,

  /// An error indicating that the camera device has encountered a recoverable
  /// error.
  otherRecoverableError,

  /// An error indicating that configuring the camera has failed.
  streamConfig,

  /// The value is not recognized by this wrapper.
  unknown,
}

class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    } else if (value is InfoSupportedHardwareLevel) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    } else if (value is AspectRatio) {
      buffer.putUint8(130);
      writeValue(buffer, value.index);
    } else if (value is CameraStateType) {
      buffer.putUint8(131);
      writeValue(buffer, value.index);
    } else if (value is LiveDataSupportedType) {
      buffer.putUint8(132);
      writeValue(buffer, value.index);
    } else if (value is VideoQuality) {
      buffer.putUint8(133);
      writeValue(buffer, value.index);
    } else if (value is MeteringMode) {
      buffer.putUint8(134);
      writeValue(buffer, value.index);
    } else if (value is LensFacing) {
      buffer.putUint8(135);
      writeValue(buffer, value.index);
    } else if (value is CameraXFlashMode) {
      buffer.putUint8(136);
      writeValue(buffer, value.index);
    } else if (value is ResolutionStrategyFallbackRule) {
      buffer.putUint8(137);
      writeValue(buffer, value.index);
    } else if (value is AspectRatioStrategyFallbackRule) {
      buffer.putUint8(138);
      writeValue(buffer, value.index);
    } else if (value is CameraStateErrorCode) {
      buffer.putUint8(139);
      writeValue(buffer, value.index);
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : InfoSupportedHardwareLevel.values[value];
      case 130:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : AspectRatio.values[value];
      case 131:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : CameraStateType.values[value];
      case 132:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : LiveDataSupportedType.values[value];
      case 133:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : VideoQuality.values[value];
      case 134:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MeteringMode.values[value];
      case 135:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : LensFacing.values[value];
      case 136:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : CameraXFlashMode.values[value];
      case 137:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : ResolutionStrategyFallbackRule.values[value];
      case 138:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : AspectRatioStrategyFallbackRule.values[value];
      case 139:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : CameraStateErrorCode.values[value];
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

/// Immutable class for describing width and height dimensions in pixels.
///
/// See https://developer.android.com/reference/android/util/Size.html.
class CameraSize extends PigeonInternalProxyApiBaseClass {
  CameraSize({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.width,
    required this.height,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraSize;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraSize.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, width, height],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [CameraSize] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraSize.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.width,
    required this.height,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecCameraSize =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// The width of the size (in pixels).
  final int width;

  /// The height of the size (in pixels).
  final int height;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraSize Function(int width, int height)? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraSize.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraSize.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraSize.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_width = (args[1] as int?);
          assert(
            arg_width != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraSize.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_height = (args[2] as int?);
          assert(
            arg_height != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraSize.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_width!, arg_height!) ??
                      CameraSize.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        width: arg_width!,
                        height: arg_height!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  CameraSize pigeon_copy() {
    return CameraSize.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      width: width,
      height: height,
    );
  }
}

/// A `ResolutionInfo` allows the application to know the resolution information
/// of a specific use case.
///
/// See https://developer.android.com/reference/androidx/camera/core/ResolutionInfo.
class ResolutionInfo extends PigeonInternalProxyApiBaseClass {
  /// Constructs [ResolutionInfo] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ResolutionInfo.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.resolution,
  });

  /// Returns the output resolution used for the use case.
  final CameraSize resolution;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ResolutionInfo Function(CameraSize resolution)? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ResolutionInfo.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ResolutionInfo.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ResolutionInfo.pigeon_newInstance was null, expected non-null int.',
          );
          final CameraSize? arg_resolution = (args[1] as CameraSize?);
          assert(
            arg_resolution != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ResolutionInfo.pigeon_newInstance was null, expected non-null CameraSize.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_resolution!) ??
                      ResolutionInfo.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        resolution: arg_resolution!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  ResolutionInfo pigeon_copy() {
    return ResolutionInfo.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      resolution: resolution,
    );
  }
}

/// Immutable class for describing the range of two integer values.
///
/// This is the equivalent to `android.util.Range<Integer>`.
///
/// See https://developer.android.com/reference/android/util/Range.html.
class CameraIntegerRange extends PigeonInternalProxyApiBaseClass {
  CameraIntegerRange({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.lower,
    required this.upper,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraIntegerRange;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraIntegerRange.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, lower, upper],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [CameraIntegerRange] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraIntegerRange.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.lower,
    required this.upper,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecCameraIntegerRange = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// The lower endpoint.
  final int lower;

  /// The upper endpoint.
  final int upper;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraIntegerRange Function(int lower, int upper)? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraIntegerRange.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraIntegerRange.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraIntegerRange.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_lower = (args[1] as int?);
          assert(
            arg_lower != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraIntegerRange.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_upper = (args[2] as int?);
          assert(
            arg_upper != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraIntegerRange.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_lower!, arg_upper!) ??
                      CameraIntegerRange.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        lower: arg_lower!,
                        upper: arg_upper!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  CameraIntegerRange pigeon_copy() {
    return CameraIntegerRange.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      lower: lower,
      upper: upper,
    );
  }
}

/// VideoRecordEvent is used to report video recording events and status.
///
/// See https://developer.android.com/reference/androidx/camera/video/VideoRecordEvent.
class VideoRecordEvent extends PigeonInternalProxyApiBaseClass {
  /// Constructs [VideoRecordEvent] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  VideoRecordEvent.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    VideoRecordEvent Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.VideoRecordEvent.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoRecordEvent.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoRecordEvent.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      VideoRecordEvent.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  VideoRecordEvent pigeon_copy() {
    return VideoRecordEvent.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// Indicates the start of recording.
///
/// See https://developer.android.com/reference/androidx/camera/video/VideoRecordEvent.Start.
class VideoRecordEventStart extends VideoRecordEvent {
  /// Constructs [VideoRecordEventStart] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  VideoRecordEventStart.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  }) : super.pigeon_detached();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    VideoRecordEventStart Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.VideoRecordEventStart.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoRecordEventStart.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoRecordEventStart.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      VideoRecordEventStart.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  VideoRecordEventStart pigeon_copy() {
    return VideoRecordEventStart.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// Indicates the finalization of recording.
///
/// See https://developer.android.com/reference/androidx/camera/video/VideoRecordEvent.Finalize.
class VideoRecordEventFinalize extends VideoRecordEvent {
  /// Constructs [VideoRecordEventFinalize] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  VideoRecordEventFinalize.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  }) : super.pigeon_detached();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    VideoRecordEventFinalize Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.VideoRecordEventFinalize.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoRecordEventFinalize.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoRecordEventFinalize.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      VideoRecordEventFinalize.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  VideoRecordEventFinalize pigeon_copy() {
    return VideoRecordEventFinalize.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A MeteringPoint is used to specify a region which can then be converted to
/// sensor coordinate system for focus and metering purpose.
///
/// See https://developer.android.com/reference/androidx/camera/core/MeteringPoint.
class MeteringPoint extends PigeonInternalProxyApiBaseClass {
  /// Constructs [MeteringPoint] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  MeteringPoint.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecMeteringPoint =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    MeteringPoint Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.MeteringPoint.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.MeteringPoint.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.MeteringPoint.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      MeteringPoint.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Size of the MeteringPoint width and height (ranging from 0 to 1).
  ///
  /// It is the percentage of the sensor width/height (or crop region
  /// width/height if crop region is set).
  Future<double> getSize() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecMeteringPoint;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.MeteringPoint.getSize';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as double?)!;
    }
  }

  @override
  MeteringPoint pigeon_copy() {
    return MeteringPoint.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A simple callback that can receive from LiveData.
///
/// See https://developer.android.com/reference/androidx/lifecycle/Observer.
class Observer extends PigeonInternalProxyApiBaseClass {
  Observer({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.onChanged,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecObserver;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Observer.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [Observer] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  Observer.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.onChanged,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecObserver =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// Called when the data is changed to value.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final Observer instance = Observer(
  ///  onChanged: (Observer pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(Observer pigeon_instance, Object value) onChanged;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    void Function(Observer pigeon_instance, Object value)? onChanged,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            'dev.flutter.pigeon.camera_android_camerax.Observer.onChanged',
            pigeonChannelCodec,
            binaryMessenger: binaryMessenger,
          );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Observer.onChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final Observer? arg_pigeon_instance = (args[0] as Observer?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Observer.onChanged was null, expected non-null Observer.',
          );
          final Object? arg_value = (args[1] as Object?);
          assert(
            arg_value != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Observer.onChanged was null, expected non-null Object.',
          );
          try {
            (onChanged ?? arg_pigeon_instance!.onChanged).call(
              arg_pigeon_instance!,
              arg_value!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  Observer pigeon_copy() {
    return Observer.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      onChanged: onChanged,
    );
  }
}

/// An interface for retrieving camera information.
///
/// See https://developer.android.com/reference/androidx/camera/core/CameraInfo.
class CameraInfo extends PigeonInternalProxyApiBaseClass {
  /// Constructs [CameraInfo] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraInfo.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.sensorRotationDegrees,
    required this.exposureState,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecCameraInfo =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// Returns the sensor rotation in degrees, relative to the device's "natural"
  /// (default) orientation.
  final int sensorRotationDegrees;

  /// Returns a ExposureState.
  final ExposureState exposureState;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraInfo Function(int sensorRotationDegrees, ExposureState exposureState)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraInfo.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraInfo.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraInfo.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_sensorRotationDegrees = (args[1] as int?);
          assert(
            arg_sensorRotationDegrees != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraInfo.pigeon_newInstance was null, expected non-null int.',
          );
          final ExposureState? arg_exposureState = (args[2] as ExposureState?);
          assert(
            arg_exposureState != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraInfo.pigeon_newInstance was null, expected non-null ExposureState.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_sensorRotationDegrees!,
                        arg_exposureState!,
                      ) ??
                      CameraInfo.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        sensorRotationDegrees: arg_sensorRotationDegrees!,
                        exposureState: arg_exposureState!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// A LiveData of the camera's state.
  Future<LiveData> getCameraState() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraInfo;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraInfo.getCameraState';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as LiveData?)!;
    }
  }

  /// A LiveData of ZoomState.
  Future<LiveData> getZoomState() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraInfo;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraInfo.getZoomState';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as LiveData?)!;
    }
  }

  @override
  CameraInfo pigeon_copy() {
    return CameraInfo.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      sensorRotationDegrees: sensorRotationDegrees,
      exposureState: exposureState,
    );
  }
}

/// A set of requirements and priorities used to select a camera or return a
/// filtered set of cameras.
///
/// See https://developer.android.com/reference/androidx/camera/core/CameraSelector.
class CameraSelector extends PigeonInternalProxyApiBaseClass {
  CameraSelector({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    LensFacing? requireLensFacing,
    CameraInfo? cameraInfoForFilter,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraSelector;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraSelector.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[
        pigeonVar_instanceIdentifier,
        requireLensFacing,
        cameraInfoForFilter,
      ],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [CameraSelector] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraSelector.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecCameraSelector =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// A static `CameraSelector` that selects the default back facing camera.
  static final CameraSelector defaultBackCamera = pigeonVar_defaultBackCamera();

  /// A static `CameraSelector` that selects the default front facing camera.
  static final CameraSelector defaultFrontCamera =
      pigeonVar_defaultFrontCamera();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraSelector Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraSelector.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraSelector.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraSelector.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      CameraSelector.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  static CameraSelector pigeonVar_defaultBackCamera() {
    final CameraSelector pigeonVar_instance = CameraSelector.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.camera_android_camerax.CameraSelector.defaultBackCamera';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  static CameraSelector pigeonVar_defaultFrontCamera() {
    final CameraSelector pigeonVar_instance = CameraSelector.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.camera_android_camerax.CameraSelector.defaultFrontCamera';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  /// Filters the input `CameraInfo`s using the `CameraFilter`s assigned to the
  /// selector.
  Future<List<CameraInfo>> filter(List<CameraInfo> cameraInfos) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraSelector;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraSelector.filter';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, cameraInfos],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<CameraInfo>();
    }
  }

  @override
  CameraSelector pigeon_copy() {
    return CameraSelector.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A singleton which can be used to bind the lifecycle of cameras to any
/// `LifecycleOwner` within an application's process.
///
/// See https://developer.android.com/reference/androidx/camera/lifecycle/ProcessCameraProvider.
class ProcessCameraProvider extends PigeonInternalProxyApiBaseClass {
  /// Constructs [ProcessCameraProvider] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ProcessCameraProvider.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecProcessCameraProvider = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ProcessCameraProvider Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      ProcessCameraProvider.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Retrieves the ProcessCameraProvider associated with the current process.
  static Future<ProcessCameraProvider> getInstance({
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.getInstance';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ProcessCameraProvider?)!;
    }
  }

  /// The `CameraInfo` instances of the available cameras.
  Future<List<CameraInfo>> getAvailableCameraInfos() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProcessCameraProvider;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.getAvailableCameraInfos';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<CameraInfo>();
    }
  }

  /// Binds the collection of `UseCase` to a `LifecycleOwner`.
  Future<Camera> bindToLifecycle(
    CameraSelector cameraSelector,
    List<UseCase> useCases,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProcessCameraProvider;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.bindToLifecycle';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, cameraSelector, useCases],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Camera?)!;
    }
  }

  /// Returns true if the `UseCase` is bound to a lifecycle.
  Future<bool> isBound(UseCase useCase) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProcessCameraProvider;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.isBound';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, useCase],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// Unbinds all specified use cases from the lifecycle provider.
  Future<void> unbind(List<UseCase> useCases) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProcessCameraProvider;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.unbind';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, useCases],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Unbinds all use cases from the lifecycle provider and removes them from
  /// CameraX.
  Future<void> unbindAll() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecProcessCameraProvider;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.unbindAll';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  ProcessCameraProvider pigeon_copy() {
    return ProcessCameraProvider.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// The use case which all other use cases are built on top of.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/UseCase.
class UseCase extends PigeonInternalProxyApiBaseClass {
  /// Constructs [UseCase] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  UseCase.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    UseCase Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.UseCase.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.UseCase.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.UseCase.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      UseCase.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  UseCase pigeon_copy() {
    return UseCase.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// The camera interface is used to control the flow of data to use cases,
/// control the camera via the `CameraControl`, and publish the state of the
/// camera via CameraInfo.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/Camera.
class Camera extends PigeonInternalProxyApiBaseClass {
  /// Constructs [Camera] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  Camera.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.cameraControl,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecCamera =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// The `CameraControl` for the Camera.
  final CameraControl cameraControl;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    Camera Function(CameraControl cameraControl)? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.Camera.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Camera.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Camera.pigeon_newInstance was null, expected non-null int.',
          );
          final CameraControl? arg_cameraControl = (args[1] as CameraControl?);
          assert(
            arg_cameraControl != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Camera.pigeon_newInstance was null, expected non-null CameraControl.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_cameraControl!) ??
                      Camera.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        cameraControl: arg_cameraControl!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Returns information about this camera.
  Future<CameraInfo> getCameraInfo() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCamera;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Camera.getCameraInfo';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as CameraInfo?)!;
    }
  }

  @override
  Camera pigeon_copy() {
    return Camera.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      cameraControl: cameraControl,
    );
  }
}

/// Convenience class for accessing system resources.
class SystemServicesManager extends PigeonInternalProxyApiBaseClass {
  SystemServicesManager({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.onCameraError,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecSystemServicesManager;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [SystemServicesManager] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  SystemServicesManager.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.onCameraError,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecSystemServicesManager = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// Callback method.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final SystemServicesManager instance = SystemServicesManager(
  ///  onCameraError: (SystemServicesManager pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    SystemServicesManager pigeon_instance,
    String errorDescription,
  )
  onCameraError;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    void Function(
      SystemServicesManager pigeon_instance,
      String errorDescription,
    )?
    onCameraError,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.onCameraError',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.onCameraError was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final SystemServicesManager? arg_pigeon_instance =
              (args[0] as SystemServicesManager?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.onCameraError was null, expected non-null SystemServicesManager.',
          );
          final String? arg_errorDescription = (args[1] as String?);
          assert(
            arg_errorDescription != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.onCameraError was null, expected non-null String.',
          );
          try {
            (onCameraError ?? arg_pigeon_instance!.onCameraError).call(
              arg_pigeon_instance!,
              arg_errorDescription!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  Future<CameraPermissionsError?> requestCameraPermissions(
    bool enableAudio,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecSystemServicesManager;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.requestCameraPermissions';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, enableAudio],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as CameraPermissionsError?);
    }
  }

  /// Returns a path to be used to create a temp file in the current cache
  /// directory.
  Future<String> getTempFilePath(String prefix, String suffix) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecSystemServicesManager;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.getTempFilePath';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, prefix, suffix],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  @override
  SystemServicesManager pigeon_copy() {
    return SystemServicesManager.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      onCameraError: onCameraError,
    );
  }
}

/// Contains data when an attempt to retrieve camera permissions fails.
class CameraPermissionsError extends PigeonInternalProxyApiBaseClass {
  /// Constructs [CameraPermissionsError] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraPermissionsError.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.errorCode,
    required this.description,
  });

  final String errorCode;

  final String description;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraPermissionsError Function(String errorCode, String description)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraPermissionsError.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraPermissionsError.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraPermissionsError.pigeon_newInstance was null, expected non-null int.',
          );
          final String? arg_errorCode = (args[1] as String?);
          assert(
            arg_errorCode != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraPermissionsError.pigeon_newInstance was null, expected non-null String.',
          );
          final String? arg_description = (args[2] as String?);
          assert(
            arg_description != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraPermissionsError.pigeon_newInstance was null, expected non-null String.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_errorCode!, arg_description!) ??
                      CameraPermissionsError.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        errorCode: arg_errorCode!,
                        description: arg_description!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  CameraPermissionsError pigeon_copy() {
    return CameraPermissionsError.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      errorCode: errorCode,
      description: description,
    );
  }
}

/// Support class to help to determine the media orientation based on the
/// orientation of the device.
class DeviceOrientationManager extends PigeonInternalProxyApiBaseClass {
  DeviceOrientationManager({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.onDeviceOrientationChanged,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecDeviceOrientationManager;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [DeviceOrientationManager] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  DeviceOrientationManager.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.onDeviceOrientationChanged,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecDeviceOrientationManager = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// Callback method.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final DeviceOrientationManager instance = DeviceOrientationManager(
  ///  onDeviceOrientationChanged: (DeviceOrientationManager pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    DeviceOrientationManager pigeon_instance,
    String orientation,
  )
  onDeviceOrientationChanged;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    void Function(DeviceOrientationManager pigeon_instance, String orientation)?
    onDeviceOrientationChanged,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.onDeviceOrientationChanged',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.onDeviceOrientationChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final DeviceOrientationManager? arg_pigeon_instance =
              (args[0] as DeviceOrientationManager?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.onDeviceOrientationChanged was null, expected non-null DeviceOrientationManager.',
          );
          final String? arg_orientation = (args[1] as String?);
          assert(
            arg_orientation != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.onDeviceOrientationChanged was null, expected non-null String.',
          );
          try {
            (onDeviceOrientationChanged ??
                    arg_pigeon_instance!.onDeviceOrientationChanged)
                .call(arg_pigeon_instance!, arg_orientation!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  Future<void> startListeningForDeviceOrientationChange() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecDeviceOrientationManager;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.startListeningForDeviceOrientationChange';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> stopListeningForDeviceOrientationChange() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecDeviceOrientationManager;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.stopListeningForDeviceOrientationChange';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<int> getDefaultDisplayRotation() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecDeviceOrientationManager;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.getDefaultDisplayRotation';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<String> getUiOrientation() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecDeviceOrientationManager;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.getUiOrientation';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  @override
  DeviceOrientationManager pigeon_copy() {
    return DeviceOrientationManager.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      onDeviceOrientationChanged: onDeviceOrientationChanged,
    );
  }
}

/// A use case that provides a camera preview stream for displaying on-screen.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/Preview.
class Preview extends UseCase {
  Preview({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.resolutionSelector,
    int? targetRotation,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecPreview;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Preview.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[
        pigeonVar_instanceIdentifier,
        resolutionSelector,
        targetRotation,
      ],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [Preview] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  Preview.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.resolutionSelector,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecPreview =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  final ResolutionSelector? resolutionSelector;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    Preview Function(ResolutionSelector? resolutionSelector)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.Preview.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Preview.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Preview.pigeon_newInstance was null, expected non-null int.',
          );
          final ResolutionSelector? arg_resolutionSelector =
              (args[1] as ResolutionSelector?);
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_resolutionSelector) ??
                      Preview.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        resolutionSelector: arg_resolutionSelector,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Sets a SurfaceProvider to provide a Surface for Preview.
  ///
  /// This is a convenience function that
  /// 1. Creates a `SurfaceProvider` using the `SurfaceProducer` provided by the
  /// Flutter engine.
  /// 2. Sets this method with the created `SurfaceProvider`.
  /// 3. Returns the texture id of the `TextureEntry` that provided the
  /// `SurfaceProducer`.
  Future<int> setSurfaceProvider(
    SystemServicesManager systemServicesManager,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecPreview;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Preview.setSurfaceProvider';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, systemServicesManager],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  /// Releases the `SurfaceProducer` created in `setSurfaceProvider` if one was
  /// created.
  Future<void> releaseSurfaceProvider() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecPreview;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Preview.releaseSurfaceProvider';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Gets selected resolution information of the `Preview`.
  Future<ResolutionInfo?> getResolutionInfo() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecPreview;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Preview.getResolutionInfo';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as ResolutionInfo?);
    }
  }

  /// Sets the target rotation.
  Future<void> setTargetRotation(int rotation) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecPreview;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Preview.setTargetRotation';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, rotation],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Returns whether or not the preview's surface producer handles correctly
  /// rotating the camera preview automatically.
  Future<bool> surfaceProducerHandlesCropAndRotation() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecPreview;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Preview.surfaceProducerHandlesCropAndRotation';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  @override
  Preview pigeon_copy() {
    return Preview.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      resolutionSelector: resolutionSelector,
    );
  }
}

/// A use case that provides camera stream suitable for video application.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/video/VideoCapture.
class VideoCapture extends UseCase {
  /// Create a `VideoCapture` associated with the given `VideoOutput`.
  VideoCapture.withOutput({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required VideoOutput videoOutput,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecVideoCapture;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.VideoCapture.withOutput';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, videoOutput],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [VideoCapture] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  VideoCapture.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecVideoCapture =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    VideoCapture Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.VideoCapture.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoCapture.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoCapture.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      VideoCapture.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Gets the VideoOutput associated with this VideoCapture.
  Future<VideoOutput> getOutput() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecVideoCapture;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.VideoCapture.getOutput';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as VideoOutput?)!;
    }
  }

  /// Sets the desired rotation of the output video.
  Future<void> setTargetRotation(int rotation) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecVideoCapture;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.VideoCapture.setTargetRotation';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, rotation],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  VideoCapture pigeon_copy() {
    return VideoCapture.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A class that will produce video data from a Surface.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/video/VideoOutput.
class VideoOutput extends PigeonInternalProxyApiBaseClass {
  /// Constructs [VideoOutput] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  VideoOutput.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    VideoOutput Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.VideoOutput.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoOutput.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoOutput.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      VideoOutput.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  VideoOutput pigeon_copy() {
    return VideoOutput.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// An implementation of `VideoOutput` for starting video recordings that are
/// saved to a File, ParcelFileDescriptor, or MediaStore.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/video/Recorder.
class Recorder extends PigeonInternalProxyApiBaseClass implements VideoOutput {
  Recorder({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    int? aspectRatio,
    int? targetVideoEncodingBitRate,
    QualitySelector? qualitySelector,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecRecorder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Recorder.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel
        .send(<Object?>[
          pigeonVar_instanceIdentifier,
          aspectRatio,
          targetVideoEncodingBitRate,
          qualitySelector,
        ]);
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [Recorder] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  Recorder.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecRecorder =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    Recorder Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.Recorder.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Recorder.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Recorder.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      Recorder.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Gets the aspect ratio of this Recorder.
  Future<int> getAspectRatio() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecRecorder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Recorder.getAspectRatio';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  /// Gets the target video encoding bitrate of this Recorder.
  Future<int> getTargetVideoEncodingBitRate() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecRecorder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Recorder.getTargetVideoEncodingBitRate';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  /// The quality selector of this Recorder.
  Future<QualitySelector> getQualitySelector() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecRecorder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Recorder.getQualitySelector';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as QualitySelector?)!;
    }
  }

  /// Prepares a recording that will be saved to a File.
  Future<PendingRecording> prepareRecording(String path) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecRecorder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Recorder.prepareRecording';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, path],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as PendingRecording?)!;
    }
  }

  @override
  Recorder pigeon_copy() {
    return Recorder.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// Listens for `VideoRecordEvent`s from a `PendingRecording`.
class VideoRecordEventListener extends PigeonInternalProxyApiBaseClass {
  VideoRecordEventListener({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.onEvent,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecVideoRecordEventListener;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.VideoRecordEventListener.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [VideoRecordEventListener] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  VideoRecordEventListener.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.onEvent,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecVideoRecordEventListener = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// Callback method.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final VideoRecordEventListener instance = VideoRecordEventListener(
  ///  onEvent: (VideoRecordEventListener pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    VideoRecordEventListener pigeon_instance,
    VideoRecordEvent event,
  )
  onEvent;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    void Function(
      VideoRecordEventListener pigeon_instance,
      VideoRecordEvent event,
    )?
    onEvent,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.VideoRecordEventListener.onEvent',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoRecordEventListener.onEvent was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final VideoRecordEventListener? arg_pigeon_instance =
              (args[0] as VideoRecordEventListener?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoRecordEventListener.onEvent was null, expected non-null VideoRecordEventListener.',
          );
          final VideoRecordEvent? arg_event = (args[1] as VideoRecordEvent?);
          assert(
            arg_event != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.VideoRecordEventListener.onEvent was null, expected non-null VideoRecordEvent.',
          );
          try {
            (onEvent ?? arg_pigeon_instance!.onEvent).call(
              arg_pigeon_instance!,
              arg_event!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  VideoRecordEventListener pigeon_copy() {
    return VideoRecordEventListener.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      onEvent: onEvent,
    );
  }
}

/// A recording that can be started at a future time.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/video/PendingRecording.
class PendingRecording extends PigeonInternalProxyApiBaseClass {
  /// Constructs [PendingRecording] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  PendingRecording.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecPendingRecording =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    PendingRecording Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.PendingRecording.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.PendingRecording.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.PendingRecording.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      PendingRecording.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Enables/disables audio to be recorded for this recording.
  Future<PendingRecording> withAudioEnabled(bool initialMuted) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecPendingRecording;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.PendingRecording.withAudioEnabled';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, initialMuted],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as PendingRecording?)!;
    }
  }

  /// Starts the recording, making it an active recording.
  Future<Recording> start(VideoRecordEventListener listener) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecPendingRecording;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.PendingRecording.start';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, listener],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Recording?)!;
    }
  }

  @override
  PendingRecording pigeon_copy() {
    return PendingRecording.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// Provides controls for the currently active recording.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/video/Recording.
class Recording extends PigeonInternalProxyApiBaseClass {
  /// Constructs [Recording] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  Recording.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecRecording =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    Recording Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.Recording.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Recording.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Recording.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      Recording.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Close this recording.
  Future<void> close() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecRecording;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Recording.close';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Pauses the current recording if active.
  Future<void> pause() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecRecording;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Recording.pause';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Resumes the current recording if paused.
  Future<void> resume() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecRecording;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Recording.resume';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Stops the recording, as if calling `close`.
  ///
  /// This method is equivalent to calling `close`.
  Future<void> stop() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecRecording;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Recording.stop';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  Recording pigeon_copy() {
    return Recording.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A use case for taking a picture.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageCapture.
class ImageCapture extends UseCase {
  ImageCapture({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.resolutionSelector,
    int? targetRotation,
    CameraXFlashMode? flashMode,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageCapture;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageCapture.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[
        pigeonVar_instanceIdentifier,
        resolutionSelector,
        targetRotation,
        flashMode,
      ],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [ImageCapture] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ImageCapture.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.resolutionSelector,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecImageCapture =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  final ResolutionSelector? resolutionSelector;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ImageCapture Function(ResolutionSelector? resolutionSelector)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ImageCapture.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ImageCapture.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ImageCapture.pigeon_newInstance was null, expected non-null int.',
          );
          final ResolutionSelector? arg_resolutionSelector =
              (args[1] as ResolutionSelector?);
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_resolutionSelector) ??
                      ImageCapture.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        resolutionSelector: arg_resolutionSelector,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Set the flash mode.
  Future<void> setFlashMode(CameraXFlashMode flashMode) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageCapture;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageCapture.setFlashMode';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, flashMode],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Captures a new still image for in memory access.
  Future<String> takePicture() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageCapture;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageCapture.takePicture';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  /// Sets the desired rotation of the output image.
  Future<void> setTargetRotation(int rotation) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageCapture;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageCapture.setTargetRotation';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, rotation],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  ImageCapture pigeon_copy() {
    return ImageCapture.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      resolutionSelector: resolutionSelector,
    );
  }
}

/// The resolution strategy defines the resolution selection sequence to select
/// the best size.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/ResolutionStrategy.
class ResolutionStrategy extends PigeonInternalProxyApiBaseClass {
  ResolutionStrategy({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required CameraSize boundSize,
    required ResolutionStrategyFallbackRule fallbackRule,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecResolutionStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, boundSize, fallbackRule],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [ResolutionStrategy] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ResolutionStrategy.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecResolutionStrategy = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// A resolution strategy chooses the highest available resolution.
  static final ResolutionStrategy highestAvailableStrategy =
      pigeonVar_highestAvailableStrategy();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ResolutionStrategy Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      ResolutionStrategy.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  static ResolutionStrategy pigeonVar_highestAvailableStrategy() {
    final ResolutionStrategy pigeonVar_instance =
        ResolutionStrategy.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.highestAvailableStrategy';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  /// The specified bound size.
  Future<CameraSize?> getBoundSize() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecResolutionStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.getBoundSize';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as CameraSize?);
    }
  }

  /// The fallback rule for choosing an alternate size when the specified bound
  /// size is unavailable.
  Future<ResolutionStrategyFallbackRule> getFallbackRule() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecResolutionStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.getFallbackRule';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ResolutionStrategyFallbackRule?)!;
    }
  }

  @override
  ResolutionStrategy pigeon_copy() {
    return ResolutionStrategy.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A set of requirements and priorities used to select a resolution for the
/// `UseCase`.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/ResolutionSelector.
class ResolutionSelector extends PigeonInternalProxyApiBaseClass {
  ResolutionSelector({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.resolutionFilter,
    this.resolutionStrategy,
    AspectRatioStrategy? aspectRatioStrategy,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecResolutionSelector;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ResolutionSelector.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel
        .send(<Object?>[
          pigeonVar_instanceIdentifier,
          resolutionFilter,
          resolutionStrategy,
          aspectRatioStrategy,
        ]);
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [ResolutionSelector] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ResolutionSelector.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.resolutionFilter,
    this.resolutionStrategy,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecResolutionSelector = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// The resolution filter to output the final desired sizes list.
  final ResolutionFilter? resolutionFilter;

  /// The resolution selection strategy for the `UseCase`.
  final ResolutionStrategy? resolutionStrategy;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ResolutionSelector Function(
      ResolutionFilter? resolutionFilter,
      ResolutionStrategy? resolutionStrategy,
    )?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ResolutionSelector.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ResolutionSelector.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ResolutionSelector.pigeon_newInstance was null, expected non-null int.',
          );
          final ResolutionFilter? arg_resolutionFilter =
              (args[1] as ResolutionFilter?);
          final ResolutionStrategy? arg_resolutionStrategy =
              (args[2] as ResolutionStrategy?);
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_resolutionFilter,
                        arg_resolutionStrategy,
                      ) ??
                      ResolutionSelector.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        resolutionFilter: arg_resolutionFilter,
                        resolutionStrategy: arg_resolutionStrategy,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Returns the specified `AspectRatioStrategy`, or
  /// `AspectRatioStrategy.ratio_4_3FallbackAutoStrategy` if none is specified
  /// when creating the ResolutionSelector.
  Future<AspectRatioStrategy> getAspectRatioStrategy() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecResolutionSelector;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ResolutionSelector.getAspectRatioStrategy';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as AspectRatioStrategy?)!;
    }
  }

  @override
  ResolutionSelector pigeon_copy() {
    return ResolutionSelector.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      resolutionFilter: resolutionFilter,
      resolutionStrategy: resolutionStrategy,
    );
  }
}

/// The aspect ratio strategy defines the sequence of aspect ratios that are
/// used to select the best size for a particular image.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/AspectRatioStrategy.
class AspectRatioStrategy extends PigeonInternalProxyApiBaseClass {
  /// Creates a new AspectRatioStrategy instance, configured with the specified
  /// preferred aspect ratio and fallback rule.
  AspectRatioStrategy({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required AspectRatio preferredAspectRatio,
    required AspectRatioStrategyFallbackRule fallbackRule,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecAspectRatioStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[
        pigeonVar_instanceIdentifier,
        preferredAspectRatio,
        fallbackRule,
      ],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [AspectRatioStrategy] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  AspectRatioStrategy.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecAspectRatioStrategy = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// The pre-defined aspect ratio strategy that selects sizes with RATIO_16_9
  /// in priority.
  static final AspectRatioStrategy ratio_16_9FallbackAutoStrategy =
      pigeonVar_ratio_16_9FallbackAutoStrategy();

  /// The pre-defined default aspect ratio strategy that selects sizes with
  /// RATIO_4_3 in priority.
  static final AspectRatioStrategy ratio_4_3FallbackAutoStrategy =
      pigeonVar_ratio_4_3FallbackAutoStrategy();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    AspectRatioStrategy Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      AspectRatioStrategy.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  static AspectRatioStrategy pigeonVar_ratio_16_9FallbackAutoStrategy() {
    final AspectRatioStrategy pigeonVar_instance =
        AspectRatioStrategy.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.ratio_16_9FallbackAutoStrategy';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  static AspectRatioStrategy pigeonVar_ratio_4_3FallbackAutoStrategy() {
    final AspectRatioStrategy pigeonVar_instance =
        AspectRatioStrategy.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.ratio_4_3FallbackAutoStrategy';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  /// The specified fallback rule for choosing the aspect ratio when the
  /// preferred aspect ratio is not available.
  Future<AspectRatioStrategyFallbackRule> getFallbackRule() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecAspectRatioStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.getFallbackRule';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as AspectRatioStrategyFallbackRule?)!;
    }
  }

  /// The specified preferred aspect ratio.
  Future<AspectRatio> getPreferredAspectRatio() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecAspectRatioStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.getPreferredAspectRatio';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as AspectRatio?)!;
    }
  }

  @override
  AspectRatioStrategy pigeon_copy() {
    return AspectRatioStrategy.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// Represents the different states the camera can be in.
///
/// See https://developer.android.com/reference/androidx/camera/core/CameraState.
class CameraState extends PigeonInternalProxyApiBaseClass {
  /// Constructs [CameraState] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraState.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.type,
    this.error,
  });

  /// The camera's state.
  final CameraStateType type;

  /// Potentially returns an error the camera encountered.
  final CameraStateStateError? error;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraState Function(CameraStateType type, CameraStateStateError? error)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraState.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraState.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraState.pigeon_newInstance was null, expected non-null int.',
          );
          final CameraStateType? arg_type = (args[1] as CameraStateType?);
          assert(
            arg_type != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraState.pigeon_newInstance was null, expected non-null CameraStateType.',
          );
          final CameraStateStateError? arg_error =
              (args[2] as CameraStateStateError?);
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_type!, arg_error) ??
                      CameraState.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        type: arg_type!,
                        error: arg_error,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  CameraState pigeon_copy() {
    return CameraState.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      type: type,
      error: error,
    );
  }
}

/// An interface which contains the camera exposure related information.
///
/// See https://developer.android.com/reference/androidx/camera/core/ExposureState.
class ExposureState extends PigeonInternalProxyApiBaseClass {
  /// Constructs [ExposureState] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ExposureState.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.exposureCompensationRange,
    required this.exposureCompensationStep,
  });

  /// Get the maximum and minimum exposure compensation values for
  /// `CameraControl.setExposureCompensationIndex`.
  final CameraIntegerRange exposureCompensationRange;

  /// Get the smallest step by which the exposure compensation can be changed.
  final double exposureCompensationStep;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ExposureState Function(
      CameraIntegerRange exposureCompensationRange,
      double exposureCompensationStep,
    )?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ExposureState.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ExposureState.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ExposureState.pigeon_newInstance was null, expected non-null int.',
          );
          final CameraIntegerRange? arg_exposureCompensationRange =
              (args[1] as CameraIntegerRange?);
          assert(
            arg_exposureCompensationRange != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ExposureState.pigeon_newInstance was null, expected non-null CameraIntegerRange.',
          );
          final double? arg_exposureCompensationStep = (args[2] as double?);
          assert(
            arg_exposureCompensationStep != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ExposureState.pigeon_newInstance was null, expected non-null double.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_exposureCompensationRange!,
                        arg_exposureCompensationStep!,
                      ) ??
                      ExposureState.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        exposureCompensationRange:
                            arg_exposureCompensationRange!,
                        exposureCompensationStep: arg_exposureCompensationStep!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  ExposureState pigeon_copy() {
    return ExposureState.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      exposureCompensationRange: exposureCompensationRange,
      exposureCompensationStep: exposureCompensationStep,
    );
  }
}

/// An interface which contains the zoom related information from a camera.
///
/// See https://developer.android.com/reference/androidx/camera/core/ZoomState.
class ZoomState extends PigeonInternalProxyApiBaseClass {
  /// Constructs [ZoomState] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ZoomState.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.minZoomRatio,
    required this.maxZoomRatio,
  });

  /// The minimum zoom ratio.
  final double minZoomRatio;

  /// The maximum zoom ratio.
  final double maxZoomRatio;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ZoomState Function(double minZoomRatio, double maxZoomRatio)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ZoomState.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ZoomState.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ZoomState.pigeon_newInstance was null, expected non-null int.',
          );
          final double? arg_minZoomRatio = (args[1] as double?);
          assert(
            arg_minZoomRatio != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ZoomState.pigeon_newInstance was null, expected non-null double.',
          );
          final double? arg_maxZoomRatio = (args[2] as double?);
          assert(
            arg_maxZoomRatio != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ZoomState.pigeon_newInstance was null, expected non-null double.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_minZoomRatio!,
                        arg_maxZoomRatio!,
                      ) ??
                      ZoomState.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        minZoomRatio: arg_minZoomRatio!,
                        maxZoomRatio: arg_maxZoomRatio!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  ZoomState pigeon_copy() {
    return ZoomState.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      minZoomRatio: minZoomRatio,
      maxZoomRatio: maxZoomRatio,
    );
  }
}

/// A use case providing CPU accessible images for an app to perform image
/// analysis on.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageAnalysis.
class ImageAnalysis extends UseCase {
  ImageAnalysis({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.resolutionSelector,
    int? targetRotation,
    int? outputImageFormat,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageAnalysis;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel
        .send(<Object?>[
          pigeonVar_instanceIdentifier,
          resolutionSelector,
          targetRotation,
          outputImageFormat,
        ]);
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [ImageAnalysis] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ImageAnalysis.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.resolutionSelector,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecImageAnalysis =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  final ResolutionSelector? resolutionSelector;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ImageAnalysis Function(ResolutionSelector? resolutionSelector)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.pigeon_newInstance was null, expected non-null int.',
          );
          final ResolutionSelector? arg_resolutionSelector =
              (args[1] as ResolutionSelector?);
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_resolutionSelector) ??
                      ImageAnalysis.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        resolutionSelector: arg_resolutionSelector,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Sets an analyzer to receive and analyze images.
  Future<void> setAnalyzer(Analyzer analyzer) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageAnalysis;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.setAnalyzer';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, analyzer],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Removes a previously set analyzer.
  Future<void> clearAnalyzer() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageAnalysis;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.clearAnalyzer';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Sets the target rotation.
  Future<void> setTargetRotation(int rotation) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageAnalysis;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.setTargetRotation';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, rotation],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  ImageAnalysis pigeon_copy() {
    return ImageAnalysis.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      resolutionSelector: resolutionSelector,
    );
  }
}

/// Interface for analyzing images.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageAnalysis.Analyzer.
class Analyzer extends PigeonInternalProxyApiBaseClass {
  Analyzer({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.analyze,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecAnalyzer;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Analyzer.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [Analyzer] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  Analyzer.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.analyze,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecAnalyzer =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// Analyzes an image to produce a result.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final Analyzer instance = Analyzer(
  ///  analyze: (Analyzer pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(Analyzer pigeon_instance, ImageProxy image) analyze;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    void Function(Analyzer pigeon_instance, ImageProxy image)? analyze,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            'dev.flutter.pigeon.camera_android_camerax.Analyzer.analyze',
            pigeonChannelCodec,
            binaryMessenger: binaryMessenger,
          );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Analyzer.analyze was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final Analyzer? arg_pigeon_instance = (args[0] as Analyzer?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Analyzer.analyze was null, expected non-null Analyzer.',
          );
          final ImageProxy? arg_image = (args[1] as ImageProxy?);
          assert(
            arg_image != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Analyzer.analyze was null, expected non-null ImageProxy.',
          );
          try {
            (analyze ?? arg_pigeon_instance!.analyze).call(
              arg_pigeon_instance!,
              arg_image!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  Analyzer pigeon_copy() {
    return Analyzer.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      analyze: analyze,
    );
  }
}

/// Error that the camera has encountered.
///
/// See https://developer.android.com/reference/androidx/camera/core/CameraState.StateError.
class CameraStateStateError extends PigeonInternalProxyApiBaseClass {
  /// Constructs [CameraStateStateError] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraStateStateError.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.code,
  });

  /// The code of this error.
  final CameraStateErrorCode code;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraStateStateError Function(CameraStateErrorCode code)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraStateStateError.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraStateStateError.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraStateStateError.pigeon_newInstance was null, expected non-null int.',
          );
          final CameraStateErrorCode? arg_code =
              (args[1] as CameraStateErrorCode?);
          assert(
            arg_code != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraStateStateError.pigeon_newInstance was null, expected non-null CameraStateErrorCode.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_code!) ??
                      CameraStateStateError.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        code: arg_code!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  CameraStateStateError pigeon_copy() {
    return CameraStateStateError.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      code: code,
    );
  }
}

/// LiveData is a data holder class that can be observed within a given
/// lifecycle.
///
/// This is a wrapper around the native class to better support the generic
/// type. Java has type erasure;
///
/// See https://developer.android.com/reference/androidx/lifecycle/LiveData.
class LiveData extends PigeonInternalProxyApiBaseClass {
  /// Constructs [LiveData] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  LiveData.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.type,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecLiveData =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// The generic type used by this instance.
  final LiveDataSupportedType type;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    LiveData Function(LiveDataSupportedType type)? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.LiveData.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.LiveData.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.LiveData.pigeon_newInstance was null, expected non-null int.',
          );
          final LiveDataSupportedType? arg_type =
              (args[1] as LiveDataSupportedType?);
          assert(
            arg_type != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.LiveData.pigeon_newInstance was null, expected non-null LiveDataSupportedType.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_type!) ??
                      LiveData.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        type: arg_type!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Adds the given observer to the observers list within the lifespan of the
  /// given owner.
  Future<void> observe(Observer observer) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecLiveData;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.LiveData.observe';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, observer],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Removes all observers that are tied to the given `LifecycleOwner`.
  Future<void> removeObservers() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecLiveData;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.LiveData.removeObservers';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Returns the current value.
  Future<Object?> getValue() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecLiveData;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.LiveData.getValue';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  @override
  LiveData pigeon_copy() {
    return LiveData.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      type: type,
    );
  }
}

/// An image proxy which has a similar interface as `android.media.Image`.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageProxy.
class ImageProxy extends PigeonInternalProxyApiBaseClass {
  /// Constructs [ImageProxy] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ImageProxy.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.format,
    required this.width,
    required this.height,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecImageProxy =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// The image format.
  final int format;

  /// The image width.
  final int width;

  /// The image height.
  final int height;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ImageProxy Function(int format, int width, int height)? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ImageProxy.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ImageProxy.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ImageProxy.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_format = (args[1] as int?);
          assert(
            arg_format != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ImageProxy.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_width = (args[2] as int?);
          assert(
            arg_width != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ImageProxy.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_height = (args[3] as int?);
          assert(
            arg_height != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ImageProxy.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_format!,
                        arg_width!,
                        arg_height!,
                      ) ??
                      ImageProxy.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        format: arg_format!,
                        width: arg_width!,
                        height: arg_height!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Returns the array of planes.
  Future<List<PlaneProxy>> getPlanes() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageProxy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageProxy.getPlanes';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<PlaneProxy>();
    }
  }

  /// Closes the underlying `android.media.Image`.
  Future<void> close() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecImageProxy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ImageProxy.close';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  ImageProxy pigeon_copy() {
    return ImageProxy.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      format: format,
      width: width,
      height: height,
    );
  }
}

/// A plane proxy which has an analogous interface as
/// `android.media.Image.Plane`.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageProxy.PlaneProxy.
class PlaneProxy extends PigeonInternalProxyApiBaseClass {
  /// Constructs [PlaneProxy] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  PlaneProxy.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.buffer,
    required this.pixelStride,
    required this.rowStride,
  });

  /// The pixels buffer.
  final Uint8List buffer;

  /// The pixel stride.
  final int pixelStride;

  /// The row stride.
  final int rowStride;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    PlaneProxy Function(Uint8List buffer, int pixelStride, int rowStride)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.PlaneProxy.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.PlaneProxy.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.PlaneProxy.pigeon_newInstance was null, expected non-null int.',
          );
          final Uint8List? arg_buffer = (args[1] as Uint8List?);
          assert(
            arg_buffer != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.PlaneProxy.pigeon_newInstance was null, expected non-null Uint8List.',
          );
          final int? arg_pixelStride = (args[2] as int?);
          assert(
            arg_pixelStride != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.PlaneProxy.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_rowStride = (args[3] as int?);
          assert(
            arg_rowStride != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.PlaneProxy.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_buffer!,
                        arg_pixelStride!,
                        arg_rowStride!,
                      ) ??
                      PlaneProxy.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        buffer: arg_buffer!,
                        pixelStride: arg_pixelStride!,
                        rowStride: arg_rowStride!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  PlaneProxy pigeon_copy() {
    return PlaneProxy.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      buffer: buffer,
      pixelStride: pixelStride,
      rowStride: rowStride,
    );
  }
}

/// Defines a desired quality setting that can be used to configure components
/// with quality setting requirements such as creating a Recorder.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/video/QualitySelector.
class QualitySelector extends PigeonInternalProxyApiBaseClass {
  /// Gets an instance of QualitySelector with a desired quality.
  QualitySelector.from({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required VideoQuality quality,
    FallbackStrategy? fallbackStrategy,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecQualitySelector;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.QualitySelector.from';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, quality, fallbackStrategy],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Gets an instance of QualitySelector with ordered desired qualities.
  QualitySelector.fromOrderedList({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required List<VideoQuality> qualities,
    FallbackStrategy? fallbackStrategy,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecQualitySelector;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.QualitySelector.fromOrderedList';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, qualities, fallbackStrategy],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [QualitySelector] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  QualitySelector.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecQualitySelector =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    QualitySelector Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.QualitySelector.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.QualitySelector.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.QualitySelector.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      QualitySelector.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Gets the corresponding resolution from the input quality.
  static Future<CameraSize?> getResolution(
    CameraInfo cameraInfo,
    VideoQuality quality, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.QualitySelector.getResolution';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[cameraInfo, quality],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as CameraSize?);
    }
  }

  @override
  QualitySelector pigeon_copy() {
    return QualitySelector.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A class represents the strategy that will be adopted when the device does
/// not support all the desired Quality in QualitySelector in order to select
/// the quality as possible.
///
/// See https://developer.android.com/reference/androidx/camera/video/FallbackStrategy.
class FallbackStrategy extends PigeonInternalProxyApiBaseClass {
  /// Returns a fallback strategy that will choose the quality that is closest
  /// to and higher than the input quality.
  FallbackStrategy.higherQualityOrLowerThan({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required VideoQuality quality,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFallbackStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.higherQualityOrLowerThan';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, quality],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Returns a fallback strategy that will choose the quality that is closest
  /// to and higher than the input quality.
  FallbackStrategy.higherQualityThan({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required VideoQuality quality,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFallbackStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.higherQualityThan';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, quality],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Returns a fallback strategy that will choose the quality that is closest
  /// to and lower than the input quality.
  FallbackStrategy.lowerQualityOrHigherThan({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required VideoQuality quality,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFallbackStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.lowerQualityOrHigherThan';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, quality],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Returns a fallback strategy that will choose the quality that is closest
  /// to and lower than the input quality.
  FallbackStrategy.lowerQualityThan({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required VideoQuality quality,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFallbackStrategy;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.lowerQualityThan';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, quality],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [FallbackStrategy] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  FallbackStrategy.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecFallbackStrategy =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    FallbackStrategy Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      FallbackStrategy.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  FallbackStrategy pigeon_copy() {
    return FallbackStrategy.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// The CameraControl provides various asynchronous operations like zoom, focus
/// and metering which affects output of all UseCases currently bound to that
/// camera.
///
/// See https://developer.android.com/reference/androidx/camera/core/CameraControl.
class CameraControl extends PigeonInternalProxyApiBaseClass {
  /// Constructs [CameraControl] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraControl.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecCameraControl =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraControl Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraControl.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraControl.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraControl.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      CameraControl.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Enable the torch or disable the torch.
  Future<void> enableTorch(bool torch) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraControl;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraControl.enableTorch';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, torch],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Sets current zoom by ratio.
  Future<void> setZoomRatio(double ratio) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraControl;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraControl.setZoomRatio';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, ratio],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Starts a focus and metering action configured by the
  /// `FocusMeteringAction`.
  Future<FocusMeteringResult?> startFocusAndMetering(
    FocusMeteringAction action,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraControl;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraControl.startFocusAndMetering';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, action],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as FocusMeteringResult?);
    }
  }

  /// Cancels current FocusMeteringAction and clears AF/AE/AWB regions.
  Future<void> cancelFocusAndMetering() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraControl;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraControl.cancelFocusAndMetering';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Set the exposure compensation value for the camera.
  Future<int?> setExposureCompensationIndex(int index) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCameraControl;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CameraControl.setExposureCompensationIndex';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, index],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as int?);
    }
  }

  @override
  CameraControl pigeon_copy() {
    return CameraControl.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// The builder used to create the `FocusMeteringAction`.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/FocusMeteringAction.Builder.
class FocusMeteringActionBuilder extends PigeonInternalProxyApiBaseClass {
  /// Creates a Builder from a `MeteringPoint` with default mode FLAG_AF |
  /// FLAG_AE | FLAG_AWB.
  FocusMeteringActionBuilder({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required MeteringPoint point,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFocusMeteringActionBuilder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, point],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Creates a Builder from a `MeteringPoint` and `MeteringMode`.
  FocusMeteringActionBuilder.withMode({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required MeteringPoint point,
    required MeteringMode mode,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFocusMeteringActionBuilder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.withMode';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, point, mode],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [FocusMeteringActionBuilder] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  FocusMeteringActionBuilder.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecFocusMeteringActionBuilder = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    FocusMeteringActionBuilder Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      FocusMeteringActionBuilder.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Adds another MeteringPoint with default metering mode.
  Future<void> addPoint(MeteringPoint point) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFocusMeteringActionBuilder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.addPoint';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, point],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Adds another MeteringPoint with specified meteringMode.
  Future<void> addPointWithMode(MeteringPoint point, MeteringMode mode) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFocusMeteringActionBuilder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.addPointWithMode';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, point, mode],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Disables the auto-cancel.
  Future<void> disableAutoCancel() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFocusMeteringActionBuilder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.disableAutoCancel';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Builds the `FocusMeteringAction` instance.
  Future<FocusMeteringAction> build() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecFocusMeteringActionBuilder;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.build';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as FocusMeteringAction?)!;
    }
  }

  @override
  FocusMeteringActionBuilder pigeon_copy() {
    return FocusMeteringActionBuilder.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A configuration used to trigger a focus and/or metering action.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/FocusMeteringAction.
class FocusMeteringAction extends PigeonInternalProxyApiBaseClass {
  /// Constructs [FocusMeteringAction] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  FocusMeteringAction.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.meteringPointsAe,
    required this.meteringPointsAf,
    required this.meteringPointsAwb,
    required this.isAutoCancelEnabled,
  });

  /// All MeteringPoints used for AE regions.
  final List<MeteringPoint> meteringPointsAe;

  /// All MeteringPoints used for AF regions.
  final List<MeteringPoint> meteringPointsAf;

  /// All MeteringPoints used for AWB regions.
  final List<MeteringPoint> meteringPointsAwb;

  /// If auto-cancel is enabled or not.
  final bool isAutoCancelEnabled;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    FocusMeteringAction Function(
      List<MeteringPoint> meteringPointsAe,
      List<MeteringPoint> meteringPointsAf,
      List<MeteringPoint> meteringPointsAwb,
      bool isAutoCancelEnabled,
    )?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.FocusMeteringAction.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringAction.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringAction.pigeon_newInstance was null, expected non-null int.',
          );
          final List<MeteringPoint>? arg_meteringPointsAe =
              (args[1] as List<Object?>?)?.cast<MeteringPoint>();
          assert(
            arg_meteringPointsAe != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringAction.pigeon_newInstance was null, expected non-null List<MeteringPoint>.',
          );
          final List<MeteringPoint>? arg_meteringPointsAf =
              (args[2] as List<Object?>?)?.cast<MeteringPoint>();
          assert(
            arg_meteringPointsAf != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringAction.pigeon_newInstance was null, expected non-null List<MeteringPoint>.',
          );
          final List<MeteringPoint>? arg_meteringPointsAwb =
              (args[3] as List<Object?>?)?.cast<MeteringPoint>();
          assert(
            arg_meteringPointsAwb != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringAction.pigeon_newInstance was null, expected non-null List<MeteringPoint>.',
          );
          final bool? arg_isAutoCancelEnabled = (args[4] as bool?);
          assert(
            arg_isAutoCancelEnabled != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringAction.pigeon_newInstance was null, expected non-null bool.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_meteringPointsAe!,
                        arg_meteringPointsAf!,
                        arg_meteringPointsAwb!,
                        arg_isAutoCancelEnabled!,
                      ) ??
                      FocusMeteringAction.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        meteringPointsAe: arg_meteringPointsAe!,
                        meteringPointsAf: arg_meteringPointsAf!,
                        meteringPointsAwb: arg_meteringPointsAwb!,
                        isAutoCancelEnabled: arg_isAutoCancelEnabled!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  FocusMeteringAction pigeon_copy() {
    return FocusMeteringAction.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      meteringPointsAe: meteringPointsAe,
      meteringPointsAf: meteringPointsAf,
      meteringPointsAwb: meteringPointsAwb,
      isAutoCancelEnabled: isAutoCancelEnabled,
    );
  }
}

/// Result of the `CameraControl.startFocusAndMetering`.
///
/// See https://developer.android.com/reference/androidx/camera/core/FocusMeteringResult.
class FocusMeteringResult extends PigeonInternalProxyApiBaseClass {
  /// Constructs [FocusMeteringResult] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  FocusMeteringResult.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.isFocusSuccessful,
  });

  /// If auto focus is successful.
  final bool isFocusSuccessful;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    FocusMeteringResult Function(bool isFocusSuccessful)? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.FocusMeteringResult.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringResult.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringResult.pigeon_newInstance was null, expected non-null int.',
          );
          final bool? arg_isFocusSuccessful = (args[1] as bool?);
          assert(
            arg_isFocusSuccessful != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.FocusMeteringResult.pigeon_newInstance was null, expected non-null bool.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_isFocusSuccessful!) ??
                      FocusMeteringResult.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        isFocusSuccessful: arg_isFocusSuccessful!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  FocusMeteringResult pigeon_copy() {
    return FocusMeteringResult.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      isFocusSuccessful: isFocusSuccessful,
    );
  }
}

/// An immutable package of settings and outputs needed to capture a single
/// image from the camera device.
///
/// See https://developer.android.com/reference/android/hardware/camera2/CaptureRequest.
class CaptureRequest extends PigeonInternalProxyApiBaseClass {
  /// Constructs [CaptureRequest] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CaptureRequest.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  /// Whether auto-exposure (AE) is currently locked to its latest calculated
  /// values.
  ///
  /// Value is boolean.
  ///
  /// This key is available on all devices.
  static final CaptureRequestKey controlAELock = pigeonVar_controlAELock();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CaptureRequest Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CaptureRequest.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CaptureRequest.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CaptureRequest.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      CaptureRequest.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  static CaptureRequestKey pigeonVar_controlAELock() {
    final CaptureRequestKey pigeonVar_instance =
        CaptureRequestKey.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.camera_android_camerax.CaptureRequest.controlAELock';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  @override
  CaptureRequest pigeon_copy() {
    return CaptureRequest.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A Key is used to do capture request field lookups with CaptureRequest.get or
/// to set fields with `CaptureRequest.Builder.set`.
///
/// See https://developer.android.com/reference/android/hardware/camera2/CaptureRequest.Key.html.
class CaptureRequestKey extends PigeonInternalProxyApiBaseClass {
  /// Constructs [CaptureRequestKey] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CaptureRequestKey.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CaptureRequestKey Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CaptureRequestKey.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CaptureRequestKey.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CaptureRequestKey.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      CaptureRequestKey.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  CaptureRequestKey pigeon_copy() {
    return CaptureRequestKey.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A bundle of Camera2 capture request options.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/camera2/interop/CaptureRequestOptions.
class CaptureRequestOptions extends PigeonInternalProxyApiBaseClass {
  CaptureRequestOptions({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required Map<CaptureRequestKey, Object?> options,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCaptureRequestOptions;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CaptureRequestOptions.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, options],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [CaptureRequestOptions] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CaptureRequestOptions.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecCaptureRequestOptions = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CaptureRequestOptions Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CaptureRequestOptions.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CaptureRequestOptions.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CaptureRequestOptions.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      CaptureRequestOptions.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Returns a value for the given CaptureRequestKey or null if it hasn't been
  /// set.
  Future<Object?> getCaptureRequestOption(CaptureRequestKey key) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCaptureRequestOptions;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.CaptureRequestOptions.getCaptureRequestOption';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, key],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  @override
  CaptureRequestOptions pigeon_copy() {
    return CaptureRequestOptions.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// An class that provides ability to interoperate with the
/// 1android.hardware.camera21 APIs.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/camera2/interop/Camera2CameraControl.
class Camera2CameraControl extends PigeonInternalProxyApiBaseClass {
  /// Gets the `Camera2CameraControl` from a `CameraControl`.
  Camera2CameraControl.from({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required CameraControl cameraControl,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCamera2CameraControl;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Camera2CameraControl.from';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, cameraControl],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [Camera2CameraControl] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  Camera2CameraControl.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecCamera2CameraControl = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    Camera2CameraControl Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.Camera2CameraControl.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Camera2CameraControl.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Camera2CameraControl.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      Camera2CameraControl.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Adds a `CaptureRequestOptions` updates the session with the options it
  /// contains.
  Future<void> addCaptureRequestOptions(CaptureRequestOptions bundle) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCamera2CameraControl;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Camera2CameraControl.addCaptureRequestOptions';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, bundle],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  Camera2CameraControl pigeon_copy() {
    return Camera2CameraControl.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// Applications can filter out unsuitable sizes and sort the resolution list in
/// the preferred order by implementing the resolution filter interface.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/ResolutionFilter.
class ResolutionFilter extends PigeonInternalProxyApiBaseClass {
  ResolutionFilter.createWithOnePreferredSize({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required CameraSize preferredSize,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecResolutionFilter;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.ResolutionFilter.createWithOnePreferredSize';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, preferredSize],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [ResolutionFilter] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  ResolutionFilter.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecResolutionFilter =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    ResolutionFilter Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.ResolutionFilter.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ResolutionFilter.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.ResolutionFilter.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      ResolutionFilter.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  ResolutionFilter pigeon_copy() {
    return ResolutionFilter.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A Key is used to do camera characteristics field lookups with
/// `CameraCharacteristics.get`.
///
/// See https://developer.android.com/reference/android/hardware/camera2/CameraCharacteristics.Key.html.
class CameraCharacteristicsKey extends PigeonInternalProxyApiBaseClass {
  /// Constructs [CameraCharacteristicsKey] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraCharacteristicsKey.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraCharacteristicsKey Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraCharacteristicsKey.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraCharacteristicsKey.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraCharacteristicsKey.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      CameraCharacteristicsKey.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  CameraCharacteristicsKey pigeon_copy() {
    return CameraCharacteristicsKey.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// The properties describing a `CameraDevice`.
///
/// See https://developer.android.com/reference/android/hardware/camera2/CameraCharacteristics.
class CameraCharacteristics extends PigeonInternalProxyApiBaseClass {
  /// Constructs [CameraCharacteristics] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  CameraCharacteristics.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  /// Generally classifies the overall set of the camera device functionality.
  ///
  /// Value is `InfoSupportedHardwareLevel`.
  ///
  /// This key is available on all devices.
  static final CameraCharacteristicsKey infoSupportedHardwareLevel =
      pigeonVar_infoSupportedHardwareLevel();

  /// Clockwise angle through which the output image needs to be rotated to be
  /// upright on the device screen in its native orientation..
  ///
  /// Value is int.
  ///
  /// This key is available on all devices.
  static final CameraCharacteristicsKey sensorOrientation =
      pigeonVar_sensorOrientation();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    CameraCharacteristics Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.CameraCharacteristics.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraCharacteristics.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.CameraCharacteristics.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      CameraCharacteristics.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  static CameraCharacteristicsKey pigeonVar_infoSupportedHardwareLevel() {
    final CameraCharacteristicsKey pigeonVar_instance =
        CameraCharacteristicsKey.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.camera_android_camerax.CameraCharacteristics.infoSupportedHardwareLevel';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  static CameraCharacteristicsKey pigeonVar_sensorOrientation() {
    final CameraCharacteristicsKey pigeonVar_instance =
        CameraCharacteristicsKey.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.camera_android_camerax.CameraCharacteristics.sensorOrientation';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  @override
  CameraCharacteristics pigeon_copy() {
    return CameraCharacteristics.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// An interface for retrieving Camera2-related camera information.
///
/// See https://developer.android.com/reference/kotlin/androidx/camera/camera2/interop/Camera2CameraInfo.
class Camera2CameraInfo extends PigeonInternalProxyApiBaseClass {
  /// Gets the `Camera2CameraInfo` from a `CameraInfo`.
  Camera2CameraInfo.from({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required CameraInfo cameraInfo,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCamera2CameraInfo;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.from';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, cameraInfo],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [Camera2CameraInfo] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  Camera2CameraInfo.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecCamera2CameraInfo = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    Camera2CameraInfo Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      Camera2CameraInfo.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Gets the string camera ID.
  Future<String> getCameraId() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCamera2CameraInfo;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.getCameraId';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  /// Gets a camera characteristic value.
  Future<Object?> getCameraCharacteristic(CameraCharacteristicsKey key) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecCamera2CameraInfo;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.getCameraCharacteristic';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, key],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  @override
  Camera2CameraInfo pigeon_copy() {
    return Camera2CameraInfo.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A factory to create a MeteringPoint.
///
/// See https://developer.android.com/reference/androidx/camera/core/MeteringPointFactory.
class MeteringPointFactory extends PigeonInternalProxyApiBaseClass {
  /// Constructs [MeteringPointFactory] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  MeteringPointFactory.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecMeteringPointFactory = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    MeteringPointFactory Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.MeteringPointFactory.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.MeteringPointFactory.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.MeteringPointFactory.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      MeteringPointFactory.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Creates a MeteringPoint by x, y.
  Future<MeteringPoint> createPoint(double x, double y) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecMeteringPointFactory;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.MeteringPointFactory.createPoint';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, x, y],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MeteringPoint?)!;
    }
  }

  /// Creates a MeteringPoint by x, y, size.
  Future<MeteringPoint> createPointWithSize(
    double x,
    double y,
    double size,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecMeteringPointFactory;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.MeteringPointFactory.createPointWithSize';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, x, y, size],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MeteringPoint?)!;
    }
  }

  @override
  MeteringPointFactory pigeon_copy() {
    return MeteringPointFactory.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}

/// A MeteringPointFactory that can convert a View (x, y) into a MeteringPoint
/// which can then be used to construct a FocusMeteringAction to start a focus
/// and metering action.
///
/// See https://developer.android.com/reference/androidx/camera/core/DisplayOrientedMeteringPointFactory.
class DisplayOrientedMeteringPointFactory extends MeteringPointFactory {
  /// Creates a DisplayOrientedMeteringPointFactory for converting View (x, y)
  /// into a MeteringPoint based on the current display's rotation and
  /// CameraInfo.
  DisplayOrientedMeteringPointFactory({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required CameraInfo cameraInfo,
    required double width,
    required double height,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecDisplayOrientedMeteringPointFactory;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.camera_android_camerax.DisplayOrientedMeteringPointFactory.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, cameraInfo, width, height],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [DisplayOrientedMeteringPointFactory] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  DisplayOrientedMeteringPointFactory.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecDisplayOrientedMeteringPointFactory =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    DisplayOrientedMeteringPointFactory Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.camera_android_camerax.DisplayOrientedMeteringPointFactory.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.DisplayOrientedMeteringPointFactory.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.camera_android_camerax.DisplayOrientedMeteringPointFactory.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      DisplayOrientedMeteringPointFactory.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  DisplayOrientedMeteringPointFactory pigeon_copy() {
    return DisplayOrientedMeteringPointFactory.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
  }
}
