// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v25.5.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package io.flutter.plugins.camerax

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer

private object CameraXLibraryPigeonUtils {

  fun createConnectionError(channelName: String): CameraXError {
    return CameraXError(
        "channel-error", "Unable to establish connection on channel: '$channelName'.", "")
  }

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is CameraXError) {
      listOf(exception.code, exception.message, exception.details)
    } else {
      listOf(
          exception.javaClass.simpleName,
          exception.toString(),
          "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception))
    }
  }
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 *
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class CameraXError(
    val code: String,
    override val message: String? = null,
    val details: Any? = null
) : Throwable()
/**
 * Maintains instances used to communicate with the corresponding objects in Dart.
 *
 * Objects stored in this container are represented by an object in Dart that is also stored in an
 * InstanceManager with the same identifier.
 *
 * When an instance is added with an identifier, either can be used to retrieve the other.
 *
 * Added instances are added as a weak reference and a strong reference. When the strong reference
 * is removed with [remove] and the weak reference is deallocated, the
 * `finalizationListener.onFinalize` is called with the instance's identifier. However, if the
 * strong reference is removed and then the identifier is retrieved with the intention to pass the
 * identifier to Dart (e.g. calling [getIdentifierForStrongReference]), the strong reference to the
 * instance is recreated. The strong reference will then need to be removed manually again.
 */
@Suppress("UNCHECKED_CAST", "MemberVisibilityCanBePrivate")
class CameraXLibraryPigeonInstanceManager(
    private val finalizationListener: PigeonFinalizationListener
) {
  /** Interface for listening when a weak reference of an instance is removed from the manager. */
  interface PigeonFinalizationListener {
    fun onFinalize(identifier: Long)
  }

  private val identifiers = java.util.WeakHashMap<Any, Long>()
  private val weakInstances = HashMap<Long, java.lang.ref.WeakReference<Any>>()
  private val strongInstances = HashMap<Long, Any>()
  private val referenceQueue = java.lang.ref.ReferenceQueue<Any>()
  private val weakReferencesToIdentifiers = HashMap<java.lang.ref.WeakReference<Any>, Long>()
  private val handler = android.os.Handler(android.os.Looper.getMainLooper())
  private val releaseAllFinalizedInstancesRunnable = Runnable {
    this.releaseAllFinalizedInstances()
  }
  private var nextIdentifier: Long = minHostCreatedIdentifier
  private var hasFinalizationListenerStopped = false

  /**
   * Modifies the time interval used to define how often this instance removes garbage collected
   * weak references to native Android objects that this instance was managing.
   */
  var clearFinalizedWeakReferencesInterval: Long = 3000
    set(value) {
      handler.removeCallbacks(releaseAllFinalizedInstancesRunnable)
      field = value
      releaseAllFinalizedInstances()
    }

  init {
    handler.postDelayed(releaseAllFinalizedInstancesRunnable, clearFinalizedWeakReferencesInterval)
  }

  companion object {
    // Identifiers are locked to a specific range to avoid collisions with objects
    // created simultaneously from Dart.
    // Host uses identifiers >= 2^16 and Dart is expected to use values n where,
    // 0 <= n < 2^16.
    private const val minHostCreatedIdentifier: Long = 65536
    private const val tag = "PigeonInstanceManager"

    /**
     * Instantiate a new manager with a listener for garbage collected weak references.
     *
     * When the manager is no longer needed, [stopFinalizationListener] must be called.
     */
    fun create(
        finalizationListener: PigeonFinalizationListener
    ): CameraXLibraryPigeonInstanceManager {
      return CameraXLibraryPigeonInstanceManager(finalizationListener)
    }
  }

  /**
   * Removes `identifier` and return its associated strongly referenced instance, if present, from
   * the manager.
   */
  fun <T> remove(identifier: Long): T? {
    logWarningIfFinalizationListenerHasStopped()
    return strongInstances.remove(identifier) as T?
  }

  /**
   * Retrieves the identifier paired with an instance, if present, otherwise `null`.
   *
   * If the manager contains a strong reference to `instance`, it will return the identifier
   * associated with `instance`. If the manager contains only a weak reference to `instance`, a new
   * strong reference to `instance` will be added and will need to be removed again with [remove].
   *
   * If this method returns a nonnull identifier, this method also expects the Dart
   * `CameraXLibraryPigeonInstanceManager` to have, or recreate, a weak reference to the Dart
   * instance the identifier is associated with.
   */
  fun getIdentifierForStrongReference(instance: Any?): Long? {
    logWarningIfFinalizationListenerHasStopped()
    val identifier = identifiers[instance]
    if (identifier != null) {
      strongInstances[identifier] = instance!!
    }
    return identifier
  }

  /**
   * Adds a new instance that was instantiated from Dart.
   *
   * The same instance can be added multiple times, but each identifier must be unique. This allows
   * two objects that are equivalent (e.g. the `equals` method returns true and their hashcodes are
   * equal) to both be added.
   *
   * [identifier] must be >= 0 and unique.
   */
  fun addDartCreatedInstance(instance: Any, identifier: Long) {
    logWarningIfFinalizationListenerHasStopped()
    addInstance(instance, identifier)
  }

  /**
   * Adds a new unique instance that was instantiated from the host platform.
   *
   * If the manager contains [instance], this returns the corresponding identifier. If the manager
   * does not contain [instance], this adds the instance and returns a unique identifier for that
   * [instance].
   */
  fun addHostCreatedInstance(instance: Any): Long {
    logWarningIfFinalizationListenerHasStopped()
    require(!containsInstance(instance)) {
      "Instance of ${instance.javaClass} has already been added."
    }
    val identifier = nextIdentifier++
    addInstance(instance, identifier)
    return identifier
  }

  /** Retrieves the instance associated with identifier, if present, otherwise `null`. */
  fun <T> getInstance(identifier: Long): T? {
    logWarningIfFinalizationListenerHasStopped()
    val instance = weakInstances[identifier] as java.lang.ref.WeakReference<T>?
    return instance?.get()
  }

  /** Returns whether this manager contains the given `instance`. */
  fun containsInstance(instance: Any?): Boolean {
    logWarningIfFinalizationListenerHasStopped()
    return identifiers.containsKey(instance)
  }

  /**
   * Stops the periodic run of the [PigeonFinalizationListener] for instances that have been garbage
   * collected.
   *
   * The InstanceManager can continue to be used, but the [PigeonFinalizationListener] will no
   * longer be called and methods will log a warning.
   */
  fun stopFinalizationListener() {
    handler.removeCallbacks(releaseAllFinalizedInstancesRunnable)
    hasFinalizationListenerStopped = true
  }

  /**
   * Removes all of the instances from this manager.
   *
   * The manager will be empty after this call returns.
   */
  fun clear() {
    identifiers.clear()
    weakInstances.clear()
    strongInstances.clear()
    weakReferencesToIdentifiers.clear()
  }

  /**
   * Whether the [PigeonFinalizationListener] is still being called for instances that are garbage
   * collected.
   *
   * See [stopFinalizationListener].
   */
  fun hasFinalizationListenerStopped(): Boolean {
    return hasFinalizationListenerStopped
  }

  private fun releaseAllFinalizedInstances() {
    if (hasFinalizationListenerStopped()) {
      return
    }
    var reference: java.lang.ref.WeakReference<Any>?
    while ((referenceQueue.poll() as java.lang.ref.WeakReference<Any>?).also { reference = it } !=
        null) {
      val identifier = weakReferencesToIdentifiers.remove(reference)
      if (identifier != null) {
        weakInstances.remove(identifier)
        strongInstances.remove(identifier)
        finalizationListener.onFinalize(identifier)
      }
    }
    handler.postDelayed(releaseAllFinalizedInstancesRunnable, clearFinalizedWeakReferencesInterval)
  }

  private fun addInstance(instance: Any, identifier: Long) {
    require(identifier >= 0) { "Identifier must be >= 0: $identifier" }
    require(!weakInstances.containsKey(identifier)) {
      "Identifier has already been added: $identifier"
    }
    val weakReference = java.lang.ref.WeakReference(instance, referenceQueue)
    identifiers[instance] = identifier
    weakInstances[identifier] = weakReference
    weakReferencesToIdentifiers[weakReference] = identifier
    strongInstances[identifier] = instance
  }

  private fun logWarningIfFinalizationListenerHasStopped() {
    if (hasFinalizationListenerStopped()) {
      Log.w(
          tag,
          "The manager was used after calls to the PigeonFinalizationListener has been stopped.")
    }
  }
}

/** Generated API for managing the Dart and native `InstanceManager`s. */
private class CameraXLibraryPigeonInstanceManagerApi(val binaryMessenger: BinaryMessenger) {
  companion object {
    /** The codec used by CameraXLibraryPigeonInstanceManagerApi. */
    val codec: MessageCodec<Any?> by lazy { CameraXLibraryPigeonCodec() }

    /**
     * Sets up an instance of `CameraXLibraryPigeonInstanceManagerApi` to handle messages from the
     * `binaryMessenger`.
     */
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        instanceManager: CameraXLibraryPigeonInstanceManager?
    ) {
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.PigeonInternalInstanceManager.removeStrongReference",
                codec)
        if (instanceManager != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  instanceManager.remove<Any?>(identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.PigeonInternalInstanceManager.clear",
                codec)
        if (instanceManager != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  instanceManager.clear()
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  fun removeStrongReference(identifierArg: Long, callback: (Result<Unit>) -> Unit) {
    val channelName =
        "dev.flutter.pigeon.camera_android_camerax.PigeonInternalInstanceManager.removeStrongReference"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(identifierArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}
/**
 * Provides implementations for each ProxyApi implementation and provides access to resources needed
 * by any implementation.
 */
abstract class CameraXLibraryPigeonProxyApiRegistrar(val binaryMessenger: BinaryMessenger) {
  /** Whether APIs should ignore calling to Dart. */
  public var ignoreCallsToDart = false
  val instanceManager: CameraXLibraryPigeonInstanceManager
  private var _codec: MessageCodec<Any?>? = null
  val codec: MessageCodec<Any?>
    get() {
      if (_codec == null) {
        _codec = CameraXLibraryPigeonProxyApiBaseCodec(this)
      }
      return _codec!!
    }

  init {
    val api = CameraXLibraryPigeonInstanceManagerApi(binaryMessenger)
    instanceManager =
        CameraXLibraryPigeonInstanceManager.create(
            object : CameraXLibraryPigeonInstanceManager.PigeonFinalizationListener {
              override fun onFinalize(identifier: Long) {
                api.removeStrongReference(identifier) {
                  if (it.isFailure) {
                    Log.e(
                        "PigeonProxyApiRegistrar",
                        "Failed to remove Dart strong reference with identifier: $identifier")
                  }
                }
              }
            })
  }
  /**
   * An implementation of [PigeonApiCameraSize] used to add a new Dart instance of `CameraSize` to
   * the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCameraSize(): PigeonApiCameraSize

  /**
   * An implementation of [PigeonApiResolutionInfo] used to add a new Dart instance of
   * `ResolutionInfo` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiResolutionInfo(): PigeonApiResolutionInfo

  /**
   * An implementation of [PigeonApiCameraIntegerRange] used to add a new Dart instance of
   * `CameraIntegerRange` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCameraIntegerRange(): PigeonApiCameraIntegerRange

  /**
   * An implementation of [PigeonApiVideoRecordEvent] used to add a new Dart instance of
   * `VideoRecordEvent` to the Dart `InstanceManager`.
   */
  open fun getPigeonApiVideoRecordEvent(): PigeonApiVideoRecordEvent {
    return PigeonApiVideoRecordEvent(this)
  }

  /**
   * An implementation of [PigeonApiVideoRecordEventStart] used to add a new Dart instance of
   * `VideoRecordEventStart` to the Dart `InstanceManager`.
   */
  open fun getPigeonApiVideoRecordEventStart(): PigeonApiVideoRecordEventStart {
    return PigeonApiVideoRecordEventStart(this)
  }

  /**
   * An implementation of [PigeonApiVideoRecordEventFinalize] used to add a new Dart instance of
   * `VideoRecordEventFinalize` to the Dart `InstanceManager`.
   */
  open fun getPigeonApiVideoRecordEventFinalize(): PigeonApiVideoRecordEventFinalize {
    return PigeonApiVideoRecordEventFinalize(this)
  }

  /**
   * An implementation of [PigeonApiMeteringPoint] used to add a new Dart instance of
   * `MeteringPoint` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiMeteringPoint(): PigeonApiMeteringPoint

  /**
   * An implementation of [PigeonApiObserver] used to add a new Dart instance of `Observer` to the
   * Dart `InstanceManager`.
   */
  abstract fun getPigeonApiObserver(): PigeonApiObserver

  /**
   * An implementation of [PigeonApiCameraInfo] used to add a new Dart instance of `CameraInfo` to
   * the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCameraInfo(): PigeonApiCameraInfo

  /**
   * An implementation of [PigeonApiCameraSelector] used to add a new Dart instance of
   * `CameraSelector` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCameraSelector(): PigeonApiCameraSelector

  /**
   * An implementation of [PigeonApiProcessCameraProvider] used to add a new Dart instance of
   * `ProcessCameraProvider` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiProcessCameraProvider(): PigeonApiProcessCameraProvider

  /**
   * An implementation of [PigeonApiUseCase] used to add a new Dart instance of `UseCase` to the
   * Dart `InstanceManager`.
   */
  open fun getPigeonApiUseCase(): PigeonApiUseCase {
    return PigeonApiUseCase(this)
  }

  /**
   * An implementation of [PigeonApiCamera] used to add a new Dart instance of `Camera` to the Dart
   * `InstanceManager`.
   */
  abstract fun getPigeonApiCamera(): PigeonApiCamera

  /**
   * An implementation of [PigeonApiSystemServicesManager] used to add a new Dart instance of
   * `SystemServicesManager` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiSystemServicesManager(): PigeonApiSystemServicesManager

  /**
   * An implementation of [PigeonApiCameraPermissionsError] used to add a new Dart instance of
   * `CameraPermissionsError` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCameraPermissionsError(): PigeonApiCameraPermissionsError

  /**
   * An implementation of [PigeonApiDeviceOrientationManager] used to add a new Dart instance of
   * `DeviceOrientationManager` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiDeviceOrientationManager(): PigeonApiDeviceOrientationManager

  /**
   * An implementation of [PigeonApiPreview] used to add a new Dart instance of `Preview` to the
   * Dart `InstanceManager`.
   */
  abstract fun getPigeonApiPreview(): PigeonApiPreview

  /**
   * An implementation of [PigeonApiVideoCapture] used to add a new Dart instance of `VideoCapture`
   * to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiVideoCapture(): PigeonApiVideoCapture

  /**
   * An implementation of [PigeonApiVideoOutput] used to add a new Dart instance of `VideoOutput` to
   * the Dart `InstanceManager`.
   */
  open fun getPigeonApiVideoOutput(): PigeonApiVideoOutput {
    return PigeonApiVideoOutput(this)
  }

  /**
   * An implementation of [PigeonApiRecorder] used to add a new Dart instance of `Recorder` to the
   * Dart `InstanceManager`.
   */
  abstract fun getPigeonApiRecorder(): PigeonApiRecorder

  /**
   * An implementation of [PigeonApiVideoRecordEventListener] used to add a new Dart instance of
   * `VideoRecordEventListener` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiVideoRecordEventListener(): PigeonApiVideoRecordEventListener

  /**
   * An implementation of [PigeonApiPendingRecording] used to add a new Dart instance of
   * `PendingRecording` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiPendingRecording(): PigeonApiPendingRecording

  /**
   * An implementation of [PigeonApiRecording] used to add a new Dart instance of `Recording` to the
   * Dart `InstanceManager`.
   */
  abstract fun getPigeonApiRecording(): PigeonApiRecording

  /**
   * An implementation of [PigeonApiImageCapture] used to add a new Dart instance of `ImageCapture`
   * to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiImageCapture(): PigeonApiImageCapture

  /**
   * An implementation of [PigeonApiResolutionStrategy] used to add a new Dart instance of
   * `ResolutionStrategy` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiResolutionStrategy(): PigeonApiResolutionStrategy

  /**
   * An implementation of [PigeonApiResolutionSelector] used to add a new Dart instance of
   * `ResolutionSelector` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiResolutionSelector(): PigeonApiResolutionSelector

  /**
   * An implementation of [PigeonApiAspectRatioStrategy] used to add a new Dart instance of
   * `AspectRatioStrategy` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiAspectRatioStrategy(): PigeonApiAspectRatioStrategy

  /**
   * An implementation of [PigeonApiCameraState] used to add a new Dart instance of `CameraState` to
   * the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCameraState(): PigeonApiCameraState

  /**
   * An implementation of [PigeonApiExposureState] used to add a new Dart instance of
   * `ExposureState` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiExposureState(): PigeonApiExposureState

  /**
   * An implementation of [PigeonApiZoomState] used to add a new Dart instance of `ZoomState` to the
   * Dart `InstanceManager`.
   */
  abstract fun getPigeonApiZoomState(): PigeonApiZoomState

  /**
   * An implementation of [PigeonApiImageAnalysis] used to add a new Dart instance of
   * `ImageAnalysis` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiImageAnalysis(): PigeonApiImageAnalysis

  /**
   * An implementation of [PigeonApiAnalyzer] used to add a new Dart instance of `Analyzer` to the
   * Dart `InstanceManager`.
   */
  abstract fun getPigeonApiAnalyzer(): PigeonApiAnalyzer

  /**
   * An implementation of [PigeonApiCameraStateStateError] used to add a new Dart instance of
   * `CameraStateStateError` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCameraStateStateError(): PigeonApiCameraStateStateError

  /**
   * An implementation of [PigeonApiLiveData] used to add a new Dart instance of `LiveData` to the
   * Dart `InstanceManager`.
   */
  abstract fun getPigeonApiLiveData(): PigeonApiLiveData

  /**
   * An implementation of [PigeonApiImageProxy] used to add a new Dart instance of `ImageProxy` to
   * the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiImageProxy(): PigeonApiImageProxy

  /**
   * An implementation of [PigeonApiPlaneProxy] used to add a new Dart instance of `PlaneProxy` to
   * the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiPlaneProxy(): PigeonApiPlaneProxy

  /**
   * An implementation of [PigeonApiQualitySelector] used to add a new Dart instance of
   * `QualitySelector` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiQualitySelector(): PigeonApiQualitySelector

  /**
   * An implementation of [PigeonApiFallbackStrategy] used to add a new Dart instance of
   * `FallbackStrategy` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiFallbackStrategy(): PigeonApiFallbackStrategy

  /**
   * An implementation of [PigeonApiCameraControl] used to add a new Dart instance of
   * `CameraControl` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCameraControl(): PigeonApiCameraControl

  /**
   * An implementation of [PigeonApiFocusMeteringActionBuilder] used to add a new Dart instance of
   * `FocusMeteringActionBuilder` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiFocusMeteringActionBuilder(): PigeonApiFocusMeteringActionBuilder

  /**
   * An implementation of [PigeonApiFocusMeteringAction] used to add a new Dart instance of
   * `FocusMeteringAction` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiFocusMeteringAction(): PigeonApiFocusMeteringAction

  /**
   * An implementation of [PigeonApiFocusMeteringResult] used to add a new Dart instance of
   * `FocusMeteringResult` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiFocusMeteringResult(): PigeonApiFocusMeteringResult

  /**
   * An implementation of [PigeonApiCaptureRequest] used to add a new Dart instance of
   * `CaptureRequest` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCaptureRequest(): PigeonApiCaptureRequest

  /**
   * An implementation of [PigeonApiCaptureRequestKey] used to add a new Dart instance of
   * `CaptureRequestKey` to the Dart `InstanceManager`.
   */
  open fun getPigeonApiCaptureRequestKey(): PigeonApiCaptureRequestKey {
    return PigeonApiCaptureRequestKey(this)
  }

  /**
   * An implementation of [PigeonApiCaptureRequestOptions] used to add a new Dart instance of
   * `CaptureRequestOptions` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCaptureRequestOptions(): PigeonApiCaptureRequestOptions

  /**
   * An implementation of [PigeonApiCamera2CameraControl] used to add a new Dart instance of
   * `Camera2CameraControl` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCamera2CameraControl(): PigeonApiCamera2CameraControl

  /**
   * An implementation of [PigeonApiResolutionFilter] used to add a new Dart instance of
   * `ResolutionFilter` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiResolutionFilter(): PigeonApiResolutionFilter

  /**
   * An implementation of [PigeonApiCameraCharacteristicsKey] used to add a new Dart instance of
   * `CameraCharacteristicsKey` to the Dart `InstanceManager`.
   */
  open fun getPigeonApiCameraCharacteristicsKey(): PigeonApiCameraCharacteristicsKey {
    return PigeonApiCameraCharacteristicsKey(this)
  }

  /**
   * An implementation of [PigeonApiCameraCharacteristics] used to add a new Dart instance of
   * `CameraCharacteristics` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCameraCharacteristics(): PigeonApiCameraCharacteristics

  /**
   * An implementation of [PigeonApiCamera2CameraInfo] used to add a new Dart instance of
   * `Camera2CameraInfo` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiCamera2CameraInfo(): PigeonApiCamera2CameraInfo

  /**
   * An implementation of [PigeonApiMeteringPointFactory] used to add a new Dart instance of
   * `MeteringPointFactory` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiMeteringPointFactory(): PigeonApiMeteringPointFactory

  /**
   * An implementation of [PigeonApiDisplayOrientedMeteringPointFactory] used to add a new Dart
   * instance of `DisplayOrientedMeteringPointFactory` to the Dart `InstanceManager`.
   */
  abstract fun getPigeonApiDisplayOrientedMeteringPointFactory():
      PigeonApiDisplayOrientedMeteringPointFactory

  fun setUp() {
    CameraXLibraryPigeonInstanceManagerApi.setUpMessageHandlers(binaryMessenger, instanceManager)
    PigeonApiCameraSize.setUpMessageHandlers(binaryMessenger, getPigeonApiCameraSize())
    PigeonApiCameraIntegerRange.setUpMessageHandlers(
        binaryMessenger, getPigeonApiCameraIntegerRange())
    PigeonApiMeteringPoint.setUpMessageHandlers(binaryMessenger, getPigeonApiMeteringPoint())
    PigeonApiObserver.setUpMessageHandlers(binaryMessenger, getPigeonApiObserver())
    PigeonApiCameraInfo.setUpMessageHandlers(binaryMessenger, getPigeonApiCameraInfo())
    PigeonApiCameraSelector.setUpMessageHandlers(binaryMessenger, getPigeonApiCameraSelector())
    PigeonApiProcessCameraProvider.setUpMessageHandlers(
        binaryMessenger, getPigeonApiProcessCameraProvider())
    PigeonApiCamera.setUpMessageHandlers(binaryMessenger, getPigeonApiCamera())
    PigeonApiSystemServicesManager.setUpMessageHandlers(
        binaryMessenger, getPigeonApiSystemServicesManager())
    PigeonApiDeviceOrientationManager.setUpMessageHandlers(
        binaryMessenger, getPigeonApiDeviceOrientationManager())
    PigeonApiPreview.setUpMessageHandlers(binaryMessenger, getPigeonApiPreview())
    PigeonApiVideoCapture.setUpMessageHandlers(binaryMessenger, getPigeonApiVideoCapture())
    PigeonApiRecorder.setUpMessageHandlers(binaryMessenger, getPigeonApiRecorder())
    PigeonApiVideoRecordEventListener.setUpMessageHandlers(
        binaryMessenger, getPigeonApiVideoRecordEventListener())
    PigeonApiPendingRecording.setUpMessageHandlers(binaryMessenger, getPigeonApiPendingRecording())
    PigeonApiRecording.setUpMessageHandlers(binaryMessenger, getPigeonApiRecording())
    PigeonApiImageCapture.setUpMessageHandlers(binaryMessenger, getPigeonApiImageCapture())
    PigeonApiResolutionStrategy.setUpMessageHandlers(
        binaryMessenger, getPigeonApiResolutionStrategy())
    PigeonApiResolutionSelector.setUpMessageHandlers(
        binaryMessenger, getPigeonApiResolutionSelector())
    PigeonApiAspectRatioStrategy.setUpMessageHandlers(
        binaryMessenger, getPigeonApiAspectRatioStrategy())
    PigeonApiImageAnalysis.setUpMessageHandlers(binaryMessenger, getPigeonApiImageAnalysis())
    PigeonApiAnalyzer.setUpMessageHandlers(binaryMessenger, getPigeonApiAnalyzer())
    PigeonApiLiveData.setUpMessageHandlers(binaryMessenger, getPigeonApiLiveData())
    PigeonApiImageProxy.setUpMessageHandlers(binaryMessenger, getPigeonApiImageProxy())
    PigeonApiQualitySelector.setUpMessageHandlers(binaryMessenger, getPigeonApiQualitySelector())
    PigeonApiFallbackStrategy.setUpMessageHandlers(binaryMessenger, getPigeonApiFallbackStrategy())
    PigeonApiCameraControl.setUpMessageHandlers(binaryMessenger, getPigeonApiCameraControl())
    PigeonApiFocusMeteringActionBuilder.setUpMessageHandlers(
        binaryMessenger, getPigeonApiFocusMeteringActionBuilder())
    PigeonApiCaptureRequest.setUpMessageHandlers(binaryMessenger, getPigeonApiCaptureRequest())
    PigeonApiCaptureRequestOptions.setUpMessageHandlers(
        binaryMessenger, getPigeonApiCaptureRequestOptions())
    PigeonApiCamera2CameraControl.setUpMessageHandlers(
        binaryMessenger, getPigeonApiCamera2CameraControl())
    PigeonApiResolutionFilter.setUpMessageHandlers(binaryMessenger, getPigeonApiResolutionFilter())
    PigeonApiCameraCharacteristics.setUpMessageHandlers(
        binaryMessenger, getPigeonApiCameraCharacteristics())
    PigeonApiCamera2CameraInfo.setUpMessageHandlers(
        binaryMessenger, getPigeonApiCamera2CameraInfo())
    PigeonApiMeteringPointFactory.setUpMessageHandlers(
        binaryMessenger, getPigeonApiMeteringPointFactory())
    PigeonApiDisplayOrientedMeteringPointFactory.setUpMessageHandlers(
        binaryMessenger, getPigeonApiDisplayOrientedMeteringPointFactory())
  }

  fun tearDown() {
    CameraXLibraryPigeonInstanceManagerApi.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCameraSize.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCameraIntegerRange.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiMeteringPoint.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiObserver.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCameraInfo.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCameraSelector.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiProcessCameraProvider.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCamera.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiSystemServicesManager.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiDeviceOrientationManager.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiPreview.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiVideoCapture.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiRecorder.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiVideoRecordEventListener.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiPendingRecording.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiRecording.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiImageCapture.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiResolutionStrategy.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiResolutionSelector.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiAspectRatioStrategy.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiImageAnalysis.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiAnalyzer.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiLiveData.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiImageProxy.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiQualitySelector.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiFallbackStrategy.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCameraControl.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiFocusMeteringActionBuilder.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCaptureRequest.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCaptureRequestOptions.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCamera2CameraControl.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiResolutionFilter.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCameraCharacteristics.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiCamera2CameraInfo.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiMeteringPointFactory.setUpMessageHandlers(binaryMessenger, null)
    PigeonApiDisplayOrientedMeteringPointFactory.setUpMessageHandlers(binaryMessenger, null)
  }
}

private class CameraXLibraryPigeonProxyApiBaseCodec(
    val registrar: CameraXLibraryPigeonProxyApiRegistrar
) : CameraXLibraryPigeonCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      128.toByte() -> {
        val identifier: Long = readValue(buffer) as Long
        val instance: Any? = registrar.instanceManager.getInstance(identifier)
        if (instance == null) {
          Log.e("PigeonProxyApiBaseCodec", "Failed to find instance with identifier: $identifier")
        }
        return instance
      }
      else -> super.readValueOfType(type, buffer)
    }
  }

  override fun writeValue(stream: ByteArrayOutputStream, value: Any?) {
    if (value is Boolean ||
        value is ByteArray ||
        value is Double ||
        value is DoubleArray ||
        value is FloatArray ||
        value is Int ||
        value is IntArray ||
        value is List<*> ||
        value is Long ||
        value is LongArray ||
        value is Map<*, *> ||
        value is String ||
        value is InfoSupportedHardwareLevel ||
        value is AspectRatio ||
        value is CameraStateType ||
        value is LiveDataSupportedType ||
        value is VideoQuality ||
        value is MeteringMode ||
        value is LensFacing ||
        value is CameraXFlashMode ||
        value is ResolutionStrategyFallbackRule ||
        value is AspectRatioStrategyFallbackRule ||
        value is CameraStateErrorCode ||
        value == null) {
      super.writeValue(stream, value)
      return
    }

    if (value is android.util.Size) {
      registrar.getPigeonApiCameraSize().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.ResolutionInfo) {
      registrar.getPigeonApiResolutionInfo().pigeon_newInstance(value) {}
    } else if (value is android.util.Range<*>) {
      registrar.getPigeonApiCameraIntegerRange().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.VideoRecordEvent.Start) {
      registrar.getPigeonApiVideoRecordEventStart().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.VideoRecordEvent.Finalize) {
      registrar.getPigeonApiVideoRecordEventFinalize().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.VideoRecordEvent) {
      registrar.getPigeonApiVideoRecordEvent().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.MeteringPoint) {
      registrar.getPigeonApiMeteringPoint().pigeon_newInstance(value) {}
    } else if (value is androidx.lifecycle.Observer<*>) {
      registrar.getPigeonApiObserver().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.CameraInfo) {
      registrar.getPigeonApiCameraInfo().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.CameraSelector) {
      registrar.getPigeonApiCameraSelector().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.lifecycle.ProcessCameraProvider) {
      registrar.getPigeonApiProcessCameraProvider().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.Camera) {
      registrar.getPigeonApiCamera().pigeon_newInstance(value) {}
    } else if (value is SystemServicesManager) {
      registrar.getPigeonApiSystemServicesManager().pigeon_newInstance(value) {}
    } else if (value is CameraPermissionsError) {
      registrar.getPigeonApiCameraPermissionsError().pigeon_newInstance(value) {}
    } else if (value is DeviceOrientationManager) {
      registrar.getPigeonApiDeviceOrientationManager().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.Preview) {
      registrar.getPigeonApiPreview().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.VideoCapture<*>) {
      registrar.getPigeonApiVideoCapture().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.Recorder) {
      registrar.getPigeonApiRecorder().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.VideoOutput) {
      registrar.getPigeonApiVideoOutput().pigeon_newInstance(value) {}
    } else if (value is VideoRecordEventListener) {
      registrar.getPigeonApiVideoRecordEventListener().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.PendingRecording) {
      registrar.getPigeonApiPendingRecording().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.Recording) {
      registrar.getPigeonApiRecording().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.ImageCapture) {
      registrar.getPigeonApiImageCapture().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.resolutionselector.ResolutionStrategy) {
      registrar.getPigeonApiResolutionStrategy().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.resolutionselector.ResolutionSelector) {
      registrar.getPigeonApiResolutionSelector().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.resolutionselector.AspectRatioStrategy) {
      registrar.getPigeonApiAspectRatioStrategy().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.CameraState) {
      registrar.getPigeonApiCameraState().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.ExposureState) {
      registrar.getPigeonApiExposureState().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.ZoomState) {
      registrar.getPigeonApiZoomState().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.ImageAnalysis) {
      registrar.getPigeonApiImageAnalysis().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.UseCase) {
      registrar.getPigeonApiUseCase().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.ImageAnalysis.Analyzer) {
      registrar.getPigeonApiAnalyzer().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.CameraState.StateError) {
      registrar.getPigeonApiCameraStateStateError().pigeon_newInstance(value) {}
    } else if (value is io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper) {
      registrar.getPigeonApiLiveData().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.ImageProxy) {
      registrar.getPigeonApiImageProxy().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.ImageProxy.PlaneProxy) {
      registrar.getPigeonApiPlaneProxy().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.QualitySelector) {
      registrar.getPigeonApiQualitySelector().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.video.FallbackStrategy) {
      registrar.getPigeonApiFallbackStrategy().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.CameraControl) {
      registrar.getPigeonApiCameraControl().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.FocusMeteringAction.Builder) {
      registrar.getPigeonApiFocusMeteringActionBuilder().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.FocusMeteringAction) {
      registrar.getPigeonApiFocusMeteringAction().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.FocusMeteringResult) {
      registrar.getPigeonApiFocusMeteringResult().pigeon_newInstance(value) {}
    } else if (value is android.hardware.camera2.CaptureRequest) {
      registrar.getPigeonApiCaptureRequest().pigeon_newInstance(value) {}
    } else if (value is android.hardware.camera2.CaptureRequest.Key<*>) {
      registrar.getPigeonApiCaptureRequestKey().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.camera2.interop.CaptureRequestOptions) {
      registrar.getPigeonApiCaptureRequestOptions().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.camera2.interop.Camera2CameraControl) {
      registrar.getPigeonApiCamera2CameraControl().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.resolutionselector.ResolutionFilter) {
      registrar.getPigeonApiResolutionFilter().pigeon_newInstance(value) {}
    } else if (value is android.hardware.camera2.CameraCharacteristics.Key<*>) {
      registrar.getPigeonApiCameraCharacteristicsKey().pigeon_newInstance(value) {}
    } else if (value is android.hardware.camera2.CameraCharacteristics) {
      registrar.getPigeonApiCameraCharacteristics().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.camera2.interop.Camera2CameraInfo) {
      registrar.getPigeonApiCamera2CameraInfo().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.DisplayOrientedMeteringPointFactory) {
      registrar.getPigeonApiDisplayOrientedMeteringPointFactory().pigeon_newInstance(value) {}
    } else if (value is androidx.camera.core.MeteringPointFactory) {
      registrar.getPigeonApiMeteringPointFactory().pigeon_newInstance(value) {}
    }

    when {
      registrar.instanceManager.containsInstance(value) -> {
        stream.write(128)
        writeValue(stream, registrar.instanceManager.getIdentifierForStrongReference(value))
      }
      else ->
          throw IllegalArgumentException(
              "Unsupported value: '$value' of type '${value.javaClass.name}'")
    }
  }
}

/**
 * Generally classifies the overall set of the camera device functionality.
 *
 * See
 * https://developer.android.com/reference/android/hardware/camera2/CameraMetadata#INFO_SUPPORTED_HARDWARE_LEVEL_3.
 */
enum class InfoSupportedHardwareLevel(val raw: Int) {
  /**
   * This camera device is capable of YUV reprocessing and RAW data capture, in addition to
   * FULL-level capabilities.
   */
  LEVEL3(0),
  /** This camera device is backed by an external camera connected to this Android device. */
  EXTERNAL(1),
  /** This camera device is capable of supporting advanced imaging applications. */
  FULL(2),
  /** This camera device is running in backward compatibility mode. */
  LEGACY(3),
  /** This camera device does not have enough capabilities to qualify as a FULL device or better. */
  LIMITED(4);

  companion object {
    fun ofRaw(raw: Int): InfoSupportedHardwareLevel? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * The aspect ratio of the use case.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/AspectRatio.
 */
enum class AspectRatio(val raw: Int) {
  /** 16:9 standard aspect ratio. */
  RATIO16TO9(0),
  /** 4:3 standard aspect ratio. */
  RATIO4TO3(1),
  /** The aspect ratio representing no preference for aspect ratio. */
  RATIO_DEFAULT(2),
  /** The value is not recognized by the wrapper. */
  UNKNOWN(3);

  companion object {
    fun ofRaw(raw: Int): AspectRatio? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * The states the camera can be in.
 *
 * See https://developer.android.com/reference/androidx/camera/core/CameraState.Type.
 */
enum class CameraStateType(val raw: Int) {
  /** Represents a state where the camera device is closed. */
  CLOSED(0),
  /** Represents a state where the camera device is currently closing. */
  CLOSING(1),
  /** Represents a state where the camera device is open. */
  OPEN(2),
  /** Represents a state where the camera device is currently opening. */
  OPENING(3),
  /**
   * Represents a state where the camera is waiting for a signal to attempt to open the camera
   * device.
   */
  PENDING_OPEN(4),
  /** This value is not recognized by this wrapper. */
  UNKNOWN(5);

  companion object {
    fun ofRaw(raw: Int): CameraStateType? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/** The types (T) properly wrapped to be used as a LiveData<T>. */
enum class LiveDataSupportedType(val raw: Int) {
  CAMERA_STATE(0),
  ZOOM_STATE(1);

  companion object {
    fun ofRaw(raw: Int): LiveDataSupportedType? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * Video quality constraints that will be used by a QualitySelector to choose an appropriate video
 * resolution.
 *
 * These are pre-defined quality constants that are universally used for video.
 *
 * See https://developer.android.com/reference/androidx/camera/video/Quality.
 */
enum class VideoQuality(val raw: Int) {
  /** Standard Definition (SD) 480p video quality. */
  SD(0),
  /** High Definition (HD) 720p video quality. */
  HD(1),
  /** Full High Definition (FHD) 1080p video quality. */
  FHD(2),
  /** Ultra High Definition (UHD) 2160p video quality. */
  UHD(3),
  /** The lowest video quality supported by the video frame producer. */
  LOWEST(4),
  /** The highest video quality supported by the video frame producer. */
  HIGHEST(5);

  companion object {
    fun ofRaw(raw: Int): VideoQuality? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * A flag used for indicating metering mode regions.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/core/FocusMeteringAction#FLAG_AF().
 */
enum class MeteringMode(val raw: Int) {
  /** A flag used in metering mode indicating the AE (Auto Exposure) region is enabled. */
  AE(0),
  /** A flag used in metering mode indicating the AF (Auto Focus) region is enabled. */
  AF(1),
  /** A flag used in metering mode indicating the AWB (Auto White Balance) region is enabled. */
  AWB(2);

  companion object {
    fun ofRaw(raw: Int): MeteringMode? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * Direction of lens of a camera.
 *
 * See
 * https://developer.android.com/reference/androidx/camera/core/CameraSelector#LENS_FACING_BACK().
 */
enum class LensFacing(val raw: Int) {
  /** A camera on the device facing the same direction as the device's screen. */
  FRONT(0),
  /** A camera on the device facing the opposite direction as the device's screen. */
  BACK(1),
  /** An external camera that has no fixed facing relative to the device's screen. */
  EXTERNAL(2),
  /** A camera on the devices that its lens facing is resolved. */
  UNKNOWN(3);

  companion object {
    fun ofRaw(raw: Int): LensFacing? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * FlashModes for image capture.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/core/ImageCapture#FLASH_MODE_AUTO().
 */
enum class CameraXFlashMode(val raw: Int) {
  /**
   * Auto flash.
   *
   * The flash will be used according to the camera system's determination when taking a picture.
   */
  AUTO(0),
  /**
   * No flash.
   *
   * The flash will never be used when taking a picture.
   */
  OFF(1),
  /**
   * Always flash.
   *
   * The flash will always be used when taking a picture.
   */
  ON(2);

  companion object {
    fun ofRaw(raw: Int): CameraXFlashMode? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * Fallback rule for choosing an alternate size when the specified bound size is unavailable.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/ResolutionStrategy.
 */
enum class ResolutionStrategyFallbackRule(val raw: Int) {
  /**
   * When the specified bound size is unavailable, CameraX falls back to the closest higher
   * resolution size.
   */
  CLOSEST_HIGHER(0),
  /**
   * When the specified bound size is unavailable, CameraX falls back to select the closest higher
   * resolution size.
   */
  CLOSEST_HIGHER_THEN_LOWER(1),
  /**
   * When the specified bound size is unavailable, CameraX falls back to the closest lower
   * resolution size.
   */
  CLOSEST_LOWER(2),
  /**
   * When the specified bound size is unavailable, CameraX falls back to select the closest lower
   * resolution size.
   *
   * If CameraX still cannot find any available resolution, it will fallback to select other higher
   * resolutions.
   */
  CLOSEST_LOWER_THEN_HIGHER(3),
  /** CameraX doesn't select an alternate size when the specified bound size is unavailable. */
  NONE(4),
  /** The value is not recognized by the wrapper. */
  UNKNOWN(5);

  companion object {
    fun ofRaw(raw: Int): ResolutionStrategyFallbackRule? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * Fallback rule for choosing the aspect ratio when the preferred aspect ratio is not available.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/AspectRatioStrategy#FALLBACK_RULE_AUTO().
 */
enum class AspectRatioStrategyFallbackRule(val raw: Int) {
  /**
   * CameraX automatically chooses the next best aspect ratio which contains the closest field of
   * view (FOV) of the camera sensor, from the remaining options.
   */
  AUTO(0),
  /**
   * CameraX doesn't fall back to select sizes of any other aspect ratio when this fallback rule is
   * used.
   */
  NONE(1),
  /** The value is not recognized by the wrapper. */
  UNKNOWN(2);

  companion object {
    fun ofRaw(raw: Int): AspectRatioStrategyFallbackRule? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * Code for a `CameraState` error.
 *
 * https://developer.android.com/reference/androidx/camera/core/CameraState#ERROR_CAMERA_DISABLED()
 */
enum class CameraStateErrorCode(val raw: Int) {
  /** An error indicating that the camera device could not be opened due to a device policy. */
  CAMERA_DISABLED(0),
  /** An error indicating that the camera device was closed due to a fatal error. */
  CAMERA_FATAL_ERROR(1),
  /** An error indicating that the camera device is already in use. */
  CAMERA_IN_USE(2),
  /**
   * An error indicating that the camera could not be opened because "Do Not Disturb" mode is
   * enabled on devices affected by a bug in Android 9 (API level 28).
   */
  DO_NOT_DISTURB_MODE_ENABLED(3),
  /**
   * An error indicating that the limit number of open cameras has been reached, and more cameras
   * cannot be opened until other instances are closed.
   */
  MAX_CAMERAS_IN_USE(4),
  /** An error indicating that the camera device has encountered a recoverable error. */
  OTHER_RECOVERABLE_ERROR(5),
  /** An error indicating that configuring the camera has failed. */
  STREAM_CONFIG(6),
  /** The value is not recognized by this wrapper. */
  UNKNOWN(7);

  companion object {
    fun ofRaw(raw: Int): CameraStateErrorCode? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

private open class CameraXLibraryPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as Long?)?.let { InfoSupportedHardwareLevel.ofRaw(it.toInt()) }
      }
      130.toByte() -> {
        return (readValue(buffer) as Long?)?.let { AspectRatio.ofRaw(it.toInt()) }
      }
      131.toByte() -> {
        return (readValue(buffer) as Long?)?.let { CameraStateType.ofRaw(it.toInt()) }
      }
      132.toByte() -> {
        return (readValue(buffer) as Long?)?.let { LiveDataSupportedType.ofRaw(it.toInt()) }
      }
      133.toByte() -> {
        return (readValue(buffer) as Long?)?.let { VideoQuality.ofRaw(it.toInt()) }
      }
      134.toByte() -> {
        return (readValue(buffer) as Long?)?.let { MeteringMode.ofRaw(it.toInt()) }
      }
      135.toByte() -> {
        return (readValue(buffer) as Long?)?.let { LensFacing.ofRaw(it.toInt()) }
      }
      136.toByte() -> {
        return (readValue(buffer) as Long?)?.let { CameraXFlashMode.ofRaw(it.toInt()) }
      }
      137.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          ResolutionStrategyFallbackRule.ofRaw(it.toInt())
        }
      }
      138.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          AspectRatioStrategyFallbackRule.ofRaw(it.toInt())
        }
      }
      139.toByte() -> {
        return (readValue(buffer) as Long?)?.let { CameraStateErrorCode.ofRaw(it.toInt()) }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }

  override fun writeValue(stream: ByteArrayOutputStream, value: Any?) {
    when (value) {
      is InfoSupportedHardwareLevel -> {
        stream.write(129)
        writeValue(stream, value.raw)
      }
      is AspectRatio -> {
        stream.write(130)
        writeValue(stream, value.raw)
      }
      is CameraStateType -> {
        stream.write(131)
        writeValue(stream, value.raw)
      }
      is LiveDataSupportedType -> {
        stream.write(132)
        writeValue(stream, value.raw)
      }
      is VideoQuality -> {
        stream.write(133)
        writeValue(stream, value.raw)
      }
      is MeteringMode -> {
        stream.write(134)
        writeValue(stream, value.raw)
      }
      is LensFacing -> {
        stream.write(135)
        writeValue(stream, value.raw)
      }
      is CameraXFlashMode -> {
        stream.write(136)
        writeValue(stream, value.raw)
      }
      is ResolutionStrategyFallbackRule -> {
        stream.write(137)
        writeValue(stream, value.raw)
      }
      is AspectRatioStrategyFallbackRule -> {
        stream.write(138)
        writeValue(stream, value.raw)
      }
      is CameraStateErrorCode -> {
        stream.write(139)
        writeValue(stream, value.raw)
      }
      else -> super.writeValue(stream, value)
    }
  }
}

/**
 * Immutable class for describing width and height dimensions in pixels.
 *
 * See https://developer.android.com/reference/android/util/Size.html.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCameraSize(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(width: Long, height: Long): android.util.Size

  /** The width of the size (in pixels). */
  abstract fun width(pigeon_instance: android.util.Size): Long

  /** The height of the size (in pixels). */
  abstract fun height(pigeon_instance: android.util.Size): Long

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiCameraSize?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraSize.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val widthArg = args[1] as Long
            val heightArg = args[2] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(widthArg, heightArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CameraSize and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(pigeon_instanceArg: android.util.Size, callback: (Result<Unit>) -> Unit) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val widthArg = width(pigeon_instanceArg)
      val heightArg = height(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.CameraSize.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, widthArg, heightArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A `ResolutionInfo` allows the application to know the resolution information of a specific use
 * case.
 *
 * See https://developer.android.com/reference/androidx/camera/core/ResolutionInfo.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiResolutionInfo(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Returns the output resolution used for the use case. */
  abstract fun resolution(pigeon_instance: androidx.camera.core.ResolutionInfo): android.util.Size

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ResolutionInfo and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.ResolutionInfo,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val resolutionArg = resolution(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.ResolutionInfo.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, resolutionArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * Immutable class for describing the range of two integer values.
 *
 * This is the equivalent to `android.util.Range<Integer>`.
 *
 * See https://developer.android.com/reference/android/util/Range.html.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCameraIntegerRange(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(lower: Long, upper: Long): android.util.Range<*>

  /** The lower endpoint. */
  abstract fun lower(pigeon_instance: android.util.Range<*>): Long

  /** The upper endpoint. */
  abstract fun upper(pigeon_instance: android.util.Range<*>): Long

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiCameraIntegerRange?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraIntegerRange.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val lowerArg = args[1] as Long
            val upperArg = args[2] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(lowerArg, upperArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CameraIntegerRange and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: android.util.Range<*>,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val lowerArg = lower(pigeon_instanceArg)
      val upperArg = upper(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.CameraIntegerRange.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, lowerArg, upperArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * VideoRecordEvent is used to report video recording events and status.
 *
 * See https://developer.android.com/reference/androidx/camera/video/VideoRecordEvent.
 */
@Suppress("UNCHECKED_CAST")
open class PigeonApiVideoRecordEvent(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of VideoRecordEvent and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.VideoRecordEvent,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.VideoRecordEvent.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * Indicates the start of recording.
 *
 * See https://developer.android.com/reference/androidx/camera/video/VideoRecordEvent.Start.
 */
@Suppress("UNCHECKED_CAST")
open class PigeonApiVideoRecordEventStart(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of VideoRecordEventStart and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.VideoRecordEvent.Start,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.VideoRecordEventStart.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiVideoRecordEvent] used to access callback methods */
  fun pigeon_getPigeonApiVideoRecordEvent(): PigeonApiVideoRecordEvent {
    return pigeonRegistrar.getPigeonApiVideoRecordEvent()
  }
}
/**
 * Indicates the finalization of recording.
 *
 * See https://developer.android.com/reference/androidx/camera/video/VideoRecordEvent.Finalize.
 */
@Suppress("UNCHECKED_CAST")
open class PigeonApiVideoRecordEventFinalize(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  @Suppress("LocalVariableName", "FunctionName")
  /**
   * Creates a Dart instance of VideoRecordEventFinalize and attaches it to [pigeon_instanceArg].
   */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.VideoRecordEvent.Finalize,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.VideoRecordEventFinalize.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiVideoRecordEvent] used to access callback methods */
  fun pigeon_getPigeonApiVideoRecordEvent(): PigeonApiVideoRecordEvent {
    return pigeonRegistrar.getPigeonApiVideoRecordEvent()
  }
}
/**
 * A MeteringPoint is used to specify a region which can then be converted to sensor coordinate
 * system for focus and metering purpose.
 *
 * See https://developer.android.com/reference/androidx/camera/core/MeteringPoint.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiMeteringPoint(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /**
   * Size of the MeteringPoint width and height (ranging from 0 to 1).
   *
   * It is the percentage of the sensor width/height (or crop region width/height if crop region is
   * set).
   */
  abstract fun getSize(pigeon_instance: androidx.camera.core.MeteringPoint): Double

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiMeteringPoint?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.MeteringPoint.getSize",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.MeteringPoint
            val wrapped: List<Any?> =
                try {
                  listOf(api.getSize(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of MeteringPoint and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.MeteringPoint,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.MeteringPoint.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A simple callback that can receive from LiveData.
 *
 * See https://developer.android.com/reference/androidx/lifecycle/Observer.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiObserver(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  abstract fun pigeon_defaultConstructor(): androidx.lifecycle.Observer<*>

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiObserver?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Observer.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of Observer and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.lifecycle.Observer<*>,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      callback(
          Result.failure(
              CameraXError(
                  "new-instance-error",
                  "Attempting to create a new Dart instance of Observer, but the class has a nonnull callback method.",
                  "")))
    }
  }

  /** Called when the data is changed to value. */
  fun onChanged(
      pigeon_instanceArg: androidx.lifecycle.Observer<*>,
      valueArg: Any,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName = "dev.flutter.pigeon.camera_android_camerax.Observer.onChanged"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, valueArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}
/**
 * An interface for retrieving camera information.
 *
 * See https://developer.android.com/reference/androidx/camera/core/CameraInfo.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCameraInfo(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /**
   * Returns the sensor rotation in degrees, relative to the device's "natural" (default)
   * orientation.
   */
  abstract fun sensorRotationDegrees(pigeon_instance: androidx.camera.core.CameraInfo): Long

  /** Returns a ExposureState. */
  abstract fun exposureState(
      pigeon_instance: androidx.camera.core.CameraInfo
  ): androidx.camera.core.ExposureState

  /** A LiveData of the camera's state. */
  abstract fun getCameraState(
      pigeon_instance: androidx.camera.core.CameraInfo
  ): io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper

  /** A LiveData of ZoomState. */
  abstract fun getZoomState(
      pigeon_instance: androidx.camera.core.CameraInfo
  ): io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiCameraInfo?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraInfo.getCameraState",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.CameraInfo
            val wrapped: List<Any?> =
                try {
                  listOf(api.getCameraState(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraInfo.getZoomState",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.CameraInfo
            val wrapped: List<Any?> =
                try {
                  listOf(api.getZoomState(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CameraInfo and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.CameraInfo,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val sensorRotationDegreesArg = sensorRotationDegrees(pigeon_instanceArg)
      val exposureStateArg = exposureState(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.CameraInfo.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, sensorRotationDegreesArg, exposureStateArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A set of requirements and priorities used to select a camera or return a filtered set of cameras.
 *
 * See https://developer.android.com/reference/androidx/camera/core/CameraSelector.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCameraSelector(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(
      requireLensFacing: LensFacing?,
      cameraInfoForFilter: androidx.camera.core.CameraInfo?
  ): androidx.camera.core.CameraSelector

  /** A static `CameraSelector` that selects the default back facing camera. */
  abstract fun defaultBackCamera(): androidx.camera.core.CameraSelector

  /** A static `CameraSelector` that selects the default front facing camera. */
  abstract fun defaultFrontCamera(): androidx.camera.core.CameraSelector

  /** Filters the input `CameraInfo`s using the `CameraFilter`s assigned to the selector. */
  abstract fun filter(
      pigeon_instance: androidx.camera.core.CameraSelector,
      cameraInfos: List<androidx.camera.core.CameraInfo>
  ): List<androidx.camera.core.CameraInfo>

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiCameraSelector?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraSelector.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val requireLensFacingArg = args[1] as LensFacing?
            val cameraInfoForFilterArg = args[2] as androidx.camera.core.CameraInfo?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(requireLensFacingArg, cameraInfoForFilterArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraSelector.defaultBackCamera",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.defaultBackCamera(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraSelector.defaultFrontCamera",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.defaultFrontCamera(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraSelector.filter",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.CameraSelector
            val cameraInfosArg = args[1] as List<androidx.camera.core.CameraInfo>
            val wrapped: List<Any?> =
                try {
                  listOf(api.filter(pigeon_instanceArg, cameraInfosArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CameraSelector and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.CameraSelector,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.CameraSelector.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A singleton which can be used to bind the lifecycle of cameras to any `LifecycleOwner` within an
 * application's process.
 *
 * See https://developer.android.com/reference/androidx/camera/lifecycle/ProcessCameraProvider.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiProcessCameraProvider(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Retrieves the ProcessCameraProvider associated with the current process. */
  abstract fun getInstance(
      callback: (Result<androidx.camera.lifecycle.ProcessCameraProvider>) -> Unit
  )

  /** The `CameraInfo` instances of the available cameras. */
  abstract fun getAvailableCameraInfos(
      pigeon_instance: androidx.camera.lifecycle.ProcessCameraProvider
  ): List<androidx.camera.core.CameraInfo>

  /** Binds the collection of `UseCase` to a `LifecycleOwner`. */
  abstract fun bindToLifecycle(
      pigeon_instance: androidx.camera.lifecycle.ProcessCameraProvider,
      cameraSelector: androidx.camera.core.CameraSelector,
      useCases: List<androidx.camera.core.UseCase>
  ): androidx.camera.core.Camera

  /** Returns true if the `UseCase` is bound to a lifecycle. */
  abstract fun isBound(
      pigeon_instance: androidx.camera.lifecycle.ProcessCameraProvider,
      useCase: androidx.camera.core.UseCase
  ): Boolean

  /** Unbinds all specified use cases from the lifecycle provider. */
  abstract fun unbind(
      pigeon_instance: androidx.camera.lifecycle.ProcessCameraProvider,
      useCases: List<androidx.camera.core.UseCase>
  )

  /** Unbinds all use cases from the lifecycle provider and removes them from CameraX. */
  abstract fun unbindAll(pigeon_instance: androidx.camera.lifecycle.ProcessCameraProvider)

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiProcessCameraProvider?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.getInstance",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.getInstance { result: Result<androidx.camera.lifecycle.ProcessCameraProvider> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CameraXLibraryPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CameraXLibraryPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.getAvailableCameraInfos",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.lifecycle.ProcessCameraProvider
            val wrapped: List<Any?> =
                try {
                  listOf(api.getAvailableCameraInfos(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.bindToLifecycle",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.lifecycle.ProcessCameraProvider
            val cameraSelectorArg = args[1] as androidx.camera.core.CameraSelector
            val useCasesArg = args[2] as List<androidx.camera.core.UseCase>
            val wrapped: List<Any?> =
                try {
                  listOf(api.bindToLifecycle(pigeon_instanceArg, cameraSelectorArg, useCasesArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.isBound",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.lifecycle.ProcessCameraProvider
            val useCaseArg = args[1] as androidx.camera.core.UseCase
            val wrapped: List<Any?> =
                try {
                  listOf(api.isBound(pigeon_instanceArg, useCaseArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.unbind",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.lifecycle.ProcessCameraProvider
            val useCasesArg = args[1] as List<androidx.camera.core.UseCase>
            val wrapped: List<Any?> =
                try {
                  api.unbind(pigeon_instanceArg, useCasesArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.unbindAll",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.lifecycle.ProcessCameraProvider
            val wrapped: List<Any?> =
                try {
                  api.unbindAll(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ProcessCameraProvider and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.lifecycle.ProcessCameraProvider,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.ProcessCameraProvider.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * The use case which all other use cases are built on top of.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/UseCase.
 */
@Suppress("UNCHECKED_CAST")
open class PigeonApiUseCase(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of UseCase and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.UseCase,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.UseCase.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * The camera interface is used to control the flow of data to use cases, control the camera via the
 * `CameraControl`, and publish the state of the camera via CameraInfo.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/Camera.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCamera(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  /** The `CameraControl` for the Camera. */
  abstract fun cameraControl(
      pigeon_instance: androidx.camera.core.Camera
  ): androidx.camera.core.CameraControl

  /** Returns information about this camera. */
  abstract fun getCameraInfo(
      pigeon_instance: androidx.camera.core.Camera
  ): androidx.camera.core.CameraInfo

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiCamera?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Camera.getCameraInfo",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.Camera
            val wrapped: List<Any?> =
                try {
                  listOf(api.getCameraInfo(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of Camera and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.Camera,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val cameraControlArg = cameraControl(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.Camera.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, cameraControlArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/** Convenience class for accessing system resources. */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiSystemServicesManager(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(): SystemServicesManager

  abstract fun requestCameraPermissions(
      pigeon_instance: SystemServicesManager,
      enableAudio: Boolean,
      callback: (Result<CameraPermissionsError?>) -> Unit
  )

  /** Returns a path to be used to create a temp file in the current cache directory. */
  abstract fun getTempFilePath(
      pigeon_instance: SystemServicesManager,
      prefix: String,
      suffix: String
  ): String

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiSystemServicesManager?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.requestCameraPermissions",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as SystemServicesManager
            val enableAudioArg = args[1] as Boolean
            api.requestCameraPermissions(pigeon_instanceArg, enableAudioArg) {
                result: Result<CameraPermissionsError?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CameraXLibraryPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CameraXLibraryPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.getTempFilePath",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as SystemServicesManager
            val prefixArg = args[1] as String
            val suffixArg = args[2] as String
            val wrapped: List<Any?> =
                try {
                  listOf(api.getTempFilePath(pigeon_instanceArg, prefixArg, suffixArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of SystemServicesManager and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: SystemServicesManager,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      callback(
          Result.failure(
              CameraXError(
                  "new-instance-error",
                  "Attempting to create a new Dart instance of SystemServicesManager, but the class has a nonnull callback method.",
                  "")))
    }
  }

  fun onCameraError(
      pigeon_instanceArg: SystemServicesManager,
      errorDescriptionArg: String,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.camera_android_camerax.SystemServicesManager.onCameraError"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, errorDescriptionArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}
/** Contains data when an attempt to retrieve camera permissions fails. */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCameraPermissionsError(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun errorCode(pigeon_instance: CameraPermissionsError): String

  abstract fun description(pigeon_instance: CameraPermissionsError): String

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CameraPermissionsError and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: CameraPermissionsError,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val errorCodeArg = errorCode(pigeon_instanceArg)
      val descriptionArg = description(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.CameraPermissionsError.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, errorCodeArg, descriptionArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * Support class to help to determine the media orientation based on the orientation of the device.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiDeviceOrientationManager(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(): DeviceOrientationManager

  abstract fun startListeningForDeviceOrientationChange(pigeon_instance: DeviceOrientationManager)

  abstract fun stopListeningForDeviceOrientationChange(pigeon_instance: DeviceOrientationManager)

  abstract fun getDefaultDisplayRotation(pigeon_instance: DeviceOrientationManager): Long

  abstract fun getUiOrientation(pigeon_instance: DeviceOrientationManager): String

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiDeviceOrientationManager?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.startListeningForDeviceOrientationChange",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as DeviceOrientationManager
            val wrapped: List<Any?> =
                try {
                  api.startListeningForDeviceOrientationChange(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.stopListeningForDeviceOrientationChange",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as DeviceOrientationManager
            val wrapped: List<Any?> =
                try {
                  api.stopListeningForDeviceOrientationChange(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.getDefaultDisplayRotation",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as DeviceOrientationManager
            val wrapped: List<Any?> =
                try {
                  listOf(api.getDefaultDisplayRotation(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.getUiOrientation",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as DeviceOrientationManager
            val wrapped: List<Any?> =
                try {
                  listOf(api.getUiOrientation(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /**
   * Creates a Dart instance of DeviceOrientationManager and attaches it to [pigeon_instanceArg].
   */
  fun pigeon_newInstance(
      pigeon_instanceArg: DeviceOrientationManager,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      callback(
          Result.failure(
              CameraXError(
                  "new-instance-error",
                  "Attempting to create a new Dart instance of DeviceOrientationManager, but the class has a nonnull callback method.",
                  "")))
    }
  }

  fun onDeviceOrientationChanged(
      pigeon_instanceArg: DeviceOrientationManager,
      orientationArg: String,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName =
        "dev.flutter.pigeon.camera_android_camerax.DeviceOrientationManager.onDeviceOrientationChanged"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, orientationArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}
/**
 * A use case that provides a camera preview stream for displaying on-screen.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/Preview.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiPreview(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  abstract fun pigeon_defaultConstructor(
      resolutionSelector: androidx.camera.core.resolutionselector.ResolutionSelector?,
      targetRotation: Long?
  ): androidx.camera.core.Preview

  abstract fun resolutionSelector(
      pigeon_instance: androidx.camera.core.Preview
  ): androidx.camera.core.resolutionselector.ResolutionSelector?

  /**
   * Sets a SurfaceProvider to provide a Surface for Preview.
   *
   * This is a convenience function that
   * 1. Creates a `SurfaceProvider` using the `SurfaceProducer` provided by the Flutter engine.
   * 2. Sets this method with the created `SurfaceProvider`.
   * 3. Returns the texture id of the `TextureEntry` that provided the `SurfaceProducer`.
   */
  abstract fun setSurfaceProvider(
      pigeon_instance: androidx.camera.core.Preview,
      systemServicesManager: SystemServicesManager
  ): Long

  /** Releases the `SurfaceProducer` created in `setSurfaceProvider` if one was created. */
  abstract fun releaseSurfaceProvider(pigeon_instance: androidx.camera.core.Preview)

  /** Gets selected resolution information of the `Preview`. */
  abstract fun getResolutionInfo(
      pigeon_instance: androidx.camera.core.Preview
  ): androidx.camera.core.ResolutionInfo?

  /** Sets the target rotation. */
  abstract fun setTargetRotation(pigeon_instance: androidx.camera.core.Preview, rotation: Long)

  /**
   * Returns whether or not the preview's surface producer handles correctly rotating the camera
   * preview automatically.
   */
  abstract fun surfaceProducerHandlesCropAndRotation(
      pigeon_instance: androidx.camera.core.Preview
  ): Boolean

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiPreview?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Preview.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val resolutionSelectorArg =
                args[1] as androidx.camera.core.resolutionselector.ResolutionSelector?
            val targetRotationArg = args[2] as Long?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(resolutionSelectorArg, targetRotationArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Preview.setSurfaceProvider",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.Preview
            val systemServicesManagerArg = args[1] as SystemServicesManager
            val wrapped: List<Any?> =
                try {
                  listOf(api.setSurfaceProvider(pigeon_instanceArg, systemServicesManagerArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Preview.releaseSurfaceProvider",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.Preview
            val wrapped: List<Any?> =
                try {
                  api.releaseSurfaceProvider(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Preview.getResolutionInfo",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.Preview
            val wrapped: List<Any?> =
                try {
                  listOf(api.getResolutionInfo(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Preview.setTargetRotation",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.Preview
            val rotationArg = args[1] as Long
            val wrapped: List<Any?> =
                try {
                  api.setTargetRotation(pigeon_instanceArg, rotationArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Preview.surfaceProducerHandlesCropAndRotation",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.Preview
            val wrapped: List<Any?> =
                try {
                  listOf(api.surfaceProducerHandlesCropAndRotation(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of Preview and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.Preview,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val resolutionSelectorArg = resolutionSelector(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.Preview.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, resolutionSelectorArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiUseCase] used to access callback methods */
  fun pigeon_getPigeonApiUseCase(): PigeonApiUseCase {
    return pigeonRegistrar.getPigeonApiUseCase()
  }
}
/**
 * A use case that provides camera stream suitable for video application.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/video/VideoCapture.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiVideoCapture(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Create a `VideoCapture` associated with the given `VideoOutput`. */
  abstract fun withOutput(
      videoOutput: androidx.camera.video.VideoOutput
  ): androidx.camera.video.VideoCapture<*>

  /** Gets the VideoOutput associated with this VideoCapture. */
  abstract fun getOutput(
      pigeon_instance: androidx.camera.video.VideoCapture<*>
  ): androidx.camera.video.VideoOutput

  /** Sets the desired rotation of the output video. */
  abstract fun setTargetRotation(
      pigeon_instance: androidx.camera.video.VideoCapture<*>,
      rotation: Long
  )

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiVideoCapture?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.VideoCapture.withOutput",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val videoOutputArg = args[1] as androidx.camera.video.VideoOutput
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.withOutput(videoOutputArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.VideoCapture.getOutput",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.VideoCapture<*>
            val wrapped: List<Any?> =
                try {
                  listOf(api.getOutput(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.VideoCapture.setTargetRotation",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.VideoCapture<*>
            val rotationArg = args[1] as Long
            val wrapped: List<Any?> =
                try {
                  api.setTargetRotation(pigeon_instanceArg, rotationArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of VideoCapture and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.VideoCapture<*>,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.VideoCapture.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiUseCase] used to access callback methods */
  fun pigeon_getPigeonApiUseCase(): PigeonApiUseCase {
    return pigeonRegistrar.getPigeonApiUseCase()
  }
}
/**
 * A class that will produce video data from a Surface.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/video/VideoOutput.
 */
@Suppress("UNCHECKED_CAST")
open class PigeonApiVideoOutput(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of VideoOutput and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.VideoOutput,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.VideoOutput.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * An implementation of `VideoOutput` for starting video recordings that are saved to a File,
 * ParcelFileDescriptor, or MediaStore.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/video/Recorder.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiRecorder(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  abstract fun pigeon_defaultConstructor(
      aspectRatio: Long?,
      targetVideoEncodingBitRate: Long?,
      qualitySelector: androidx.camera.video.QualitySelector?
  ): androidx.camera.video.Recorder

  /** Gets the aspect ratio of this Recorder. */
  abstract fun getAspectRatio(pigeon_instance: androidx.camera.video.Recorder): Long

  /** Gets the target video encoding bitrate of this Recorder. */
  abstract fun getTargetVideoEncodingBitRate(pigeon_instance: androidx.camera.video.Recorder): Long

  /** The quality selector of this Recorder. */
  abstract fun getQualitySelector(
      pigeon_instance: androidx.camera.video.Recorder
  ): androidx.camera.video.QualitySelector

  /** Prepares a recording that will be saved to a File. */
  abstract fun prepareRecording(
      pigeon_instance: androidx.camera.video.Recorder,
      path: String
  ): androidx.camera.video.PendingRecording

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiRecorder?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Recorder.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val aspectRatioArg = args[1] as Long?
            val targetVideoEncodingBitRateArg = args[2] as Long?
            val qualitySelectorArg = args[3] as androidx.camera.video.QualitySelector?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(
                          aspectRatioArg, targetVideoEncodingBitRateArg, qualitySelectorArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Recorder.getAspectRatio",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.Recorder
            val wrapped: List<Any?> =
                try {
                  listOf(api.getAspectRatio(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Recorder.getTargetVideoEncodingBitRate",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.Recorder
            val wrapped: List<Any?> =
                try {
                  listOf(api.getTargetVideoEncodingBitRate(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Recorder.getQualitySelector",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.Recorder
            val wrapped: List<Any?> =
                try {
                  listOf(api.getQualitySelector(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Recorder.prepareRecording",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.Recorder
            val pathArg = args[1] as String
            val wrapped: List<Any?> =
                try {
                  listOf(api.prepareRecording(pigeon_instanceArg, pathArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of Recorder and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.Recorder,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.Recorder.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiVideoOutput] used to access callback methods */
  fun pigeon_getPigeonApiVideoOutput(): PigeonApiVideoOutput {
    return pigeonRegistrar.getPigeonApiVideoOutput()
  }
}
/** Listens for `VideoRecordEvent`s from a `PendingRecording`. */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiVideoRecordEventListener(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(): VideoRecordEventListener

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiVideoRecordEventListener?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.VideoRecordEventListener.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /**
   * Creates a Dart instance of VideoRecordEventListener and attaches it to [pigeon_instanceArg].
   */
  fun pigeon_newInstance(
      pigeon_instanceArg: VideoRecordEventListener,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      callback(
          Result.failure(
              CameraXError(
                  "new-instance-error",
                  "Attempting to create a new Dart instance of VideoRecordEventListener, but the class has a nonnull callback method.",
                  "")))
    }
  }

  fun onEvent(
      pigeon_instanceArg: VideoRecordEventListener,
      eventArg: androidx.camera.video.VideoRecordEvent,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName = "dev.flutter.pigeon.camera_android_camerax.VideoRecordEventListener.onEvent"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, eventArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}
/**
 * A recording that can be started at a future time.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/video/PendingRecording.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiPendingRecording(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Enables/disables audio to be recorded for this recording. */
  abstract fun withAudioEnabled(
      pigeon_instance: androidx.camera.video.PendingRecording,
      initialMuted: Boolean
  ): androidx.camera.video.PendingRecording

  /** Starts the recording, making it an active recording. */
  abstract fun start(
      pigeon_instance: androidx.camera.video.PendingRecording,
      listener: VideoRecordEventListener
  ): androidx.camera.video.Recording

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiPendingRecording?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.PendingRecording.withAudioEnabled",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.PendingRecording
            val initialMutedArg = args[1] as Boolean
            val wrapped: List<Any?> =
                try {
                  listOf(api.withAudioEnabled(pigeon_instanceArg, initialMutedArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.PendingRecording.start",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.PendingRecording
            val listenerArg = args[1] as VideoRecordEventListener
            val wrapped: List<Any?> =
                try {
                  listOf(api.start(pigeon_instanceArg, listenerArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of PendingRecording and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.PendingRecording,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.PendingRecording.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * Provides controls for the currently active recording.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/video/Recording.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiRecording(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  /** Close this recording. */
  abstract fun close(pigeon_instance: androidx.camera.video.Recording)

  /** Pauses the current recording if active. */
  abstract fun pause(pigeon_instance: androidx.camera.video.Recording)

  /** Resumes the current recording if paused. */
  abstract fun resume(pigeon_instance: androidx.camera.video.Recording)

  /**
   * Stops the recording, as if calling `close`.
   *
   * This method is equivalent to calling `close`.
   */
  abstract fun stop(pigeon_instance: androidx.camera.video.Recording)

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiRecording?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger, "dev.flutter.pigeon.camera_android_camerax.Recording.close", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.Recording
            val wrapped: List<Any?> =
                try {
                  api.close(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger, "dev.flutter.pigeon.camera_android_camerax.Recording.pause", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.Recording
            val wrapped: List<Any?> =
                try {
                  api.pause(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Recording.resume",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.Recording
            val wrapped: List<Any?> =
                try {
                  api.resume(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger, "dev.flutter.pigeon.camera_android_camerax.Recording.stop", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.video.Recording
            val wrapped: List<Any?> =
                try {
                  api.stop(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of Recording and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.Recording,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.Recording.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A use case for taking a picture.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageCapture.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiImageCapture(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(
      resolutionSelector: androidx.camera.core.resolutionselector.ResolutionSelector?,
      targetRotation: Long?,
      flashMode: CameraXFlashMode?
  ): androidx.camera.core.ImageCapture

  abstract fun resolutionSelector(
      pigeon_instance: androidx.camera.core.ImageCapture
  ): androidx.camera.core.resolutionselector.ResolutionSelector?

  /** Set the flash mode. */
  abstract fun setFlashMode(
      pigeon_instance: androidx.camera.core.ImageCapture,
      flashMode: CameraXFlashMode
  )

  /** Captures a new still image for in memory access. */
  abstract fun takePicture(
      pigeon_instance: androidx.camera.core.ImageCapture,
      callback: (Result<String>) -> Unit
  )

  /** Sets the desired rotation of the output image. */
  abstract fun setTargetRotation(pigeon_instance: androidx.camera.core.ImageCapture, rotation: Long)

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiImageCapture?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageCapture.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val resolutionSelectorArg =
                args[1] as androidx.camera.core.resolutionselector.ResolutionSelector?
            val targetRotationArg = args[2] as Long?
            val flashModeArg = args[3] as CameraXFlashMode?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(
                          resolutionSelectorArg, targetRotationArg, flashModeArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageCapture.setFlashMode",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.ImageCapture
            val flashModeArg = args[1] as CameraXFlashMode
            val wrapped: List<Any?> =
                try {
                  api.setFlashMode(pigeon_instanceArg, flashModeArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageCapture.takePicture",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.ImageCapture
            api.takePicture(pigeon_instanceArg) { result: Result<String> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CameraXLibraryPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CameraXLibraryPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageCapture.setTargetRotation",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.ImageCapture
            val rotationArg = args[1] as Long
            val wrapped: List<Any?> =
                try {
                  api.setTargetRotation(pigeon_instanceArg, rotationArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ImageCapture and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.ImageCapture,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val resolutionSelectorArg = resolutionSelector(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.ImageCapture.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, resolutionSelectorArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiUseCase] used to access callback methods */
  fun pigeon_getPigeonApiUseCase(): PigeonApiUseCase {
    return pigeonRegistrar.getPigeonApiUseCase()
  }
}
/**
 * The resolution strategy defines the resolution selection sequence to select the best size.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/ResolutionStrategy.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiResolutionStrategy(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(
      boundSize: android.util.Size,
      fallbackRule: ResolutionStrategyFallbackRule
  ): androidx.camera.core.resolutionselector.ResolutionStrategy

  /** A resolution strategy chooses the highest available resolution. */
  abstract fun highestAvailableStrategy():
      androidx.camera.core.resolutionselector.ResolutionStrategy

  /** The specified bound size. */
  abstract fun getBoundSize(
      pigeon_instance: androidx.camera.core.resolutionselector.ResolutionStrategy
  ): android.util.Size?

  /**
   * The fallback rule for choosing an alternate size when the specified bound size is unavailable.
   */
  abstract fun getFallbackRule(
      pigeon_instance: androidx.camera.core.resolutionselector.ResolutionStrategy
  ): ResolutionStrategyFallbackRule

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiResolutionStrategy?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val boundSizeArg = args[1] as android.util.Size
            val fallbackRuleArg = args[2] as ResolutionStrategyFallbackRule
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(boundSizeArg, fallbackRuleArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.highestAvailableStrategy",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.highestAvailableStrategy(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.getBoundSize",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg =
                args[0] as androidx.camera.core.resolutionselector.ResolutionStrategy
            val wrapped: List<Any?> =
                try {
                  listOf(api.getBoundSize(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.getFallbackRule",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg =
                args[0] as androidx.camera.core.resolutionselector.ResolutionStrategy
            val wrapped: List<Any?> =
                try {
                  listOf(api.getFallbackRule(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ResolutionStrategy and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.resolutionselector.ResolutionStrategy,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.ResolutionStrategy.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A set of requirements and priorities used to select a resolution for the `UseCase`.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/ResolutionSelector.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiResolutionSelector(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(
      resolutionFilter: androidx.camera.core.resolutionselector.ResolutionFilter?,
      resolutionStrategy: androidx.camera.core.resolutionselector.ResolutionStrategy?,
      aspectRatioStrategy: androidx.camera.core.resolutionselector.AspectRatioStrategy?
  ): androidx.camera.core.resolutionselector.ResolutionSelector

  /** The resolution filter to output the final desired sizes list. */
  abstract fun resolutionFilter(
      pigeon_instance: androidx.camera.core.resolutionselector.ResolutionSelector
  ): androidx.camera.core.resolutionselector.ResolutionFilter?

  /** The resolution selection strategy for the `UseCase`. */
  abstract fun resolutionStrategy(
      pigeon_instance: androidx.camera.core.resolutionselector.ResolutionSelector
  ): androidx.camera.core.resolutionselector.ResolutionStrategy?

  /**
   * Returns the specified `AspectRatioStrategy`, or
   * `AspectRatioStrategy.ratio_4_3FallbackAutoStrategy` if none is specified when creating the
   * ResolutionSelector.
   */
  abstract fun getAspectRatioStrategy(
      pigeon_instance: androidx.camera.core.resolutionselector.ResolutionSelector
  ): androidx.camera.core.resolutionselector.AspectRatioStrategy

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiResolutionSelector?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ResolutionSelector.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val resolutionFilterArg =
                args[1] as androidx.camera.core.resolutionselector.ResolutionFilter?
            val resolutionStrategyArg =
                args[2] as androidx.camera.core.resolutionselector.ResolutionStrategy?
            val aspectRatioStrategyArg =
                args[3] as androidx.camera.core.resolutionselector.AspectRatioStrategy?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(
                          resolutionFilterArg, resolutionStrategyArg, aspectRatioStrategyArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ResolutionSelector.getAspectRatioStrategy",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg =
                args[0] as androidx.camera.core.resolutionselector.ResolutionSelector
            val wrapped: List<Any?> =
                try {
                  listOf(api.getAspectRatioStrategy(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ResolutionSelector and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.resolutionselector.ResolutionSelector,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val resolutionFilterArg = resolutionFilter(pigeon_instanceArg)
      val resolutionStrategyArg = resolutionStrategy(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.ResolutionSelector.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, resolutionFilterArg, resolutionStrategyArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * The aspect ratio strategy defines the sequence of aspect ratios that are used to select the best
 * size for a particular image.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/AspectRatioStrategy.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiAspectRatioStrategy(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /**
   * Creates a new AspectRatioStrategy instance, configured with the specified preferred aspect
   * ratio and fallback rule.
   */
  abstract fun pigeon_defaultConstructor(
      preferredAspectRatio: AspectRatio,
      fallbackRule: AspectRatioStrategyFallbackRule
  ): androidx.camera.core.resolutionselector.AspectRatioStrategy

  /** The pre-defined aspect ratio strategy that selects sizes with RATIO_16_9 in priority. */
  abstract fun ratio_16_9FallbackAutoStrategy():
      androidx.camera.core.resolutionselector.AspectRatioStrategy

  /**
   * The pre-defined default aspect ratio strategy that selects sizes with RATIO_4_3 in priority.
   */
  abstract fun ratio_4_3FallbackAutoStrategy():
      androidx.camera.core.resolutionselector.AspectRatioStrategy

  /**
   * The specified fallback rule for choosing the aspect ratio when the preferred aspect ratio is
   * not available.
   */
  abstract fun getFallbackRule(
      pigeon_instance: androidx.camera.core.resolutionselector.AspectRatioStrategy
  ): AspectRatioStrategyFallbackRule

  /** The specified preferred aspect ratio. */
  abstract fun getPreferredAspectRatio(
      pigeon_instance: androidx.camera.core.resolutionselector.AspectRatioStrategy
  ): AspectRatio

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiAspectRatioStrategy?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val preferredAspectRatioArg = args[1] as AspectRatio
            val fallbackRuleArg = args[2] as AspectRatioStrategyFallbackRule
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(preferredAspectRatioArg, fallbackRuleArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.ratio_16_9FallbackAutoStrategy",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.ratio_16_9FallbackAutoStrategy(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.ratio_4_3FallbackAutoStrategy",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.ratio_4_3FallbackAutoStrategy(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.getFallbackRule",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg =
                args[0] as androidx.camera.core.resolutionselector.AspectRatioStrategy
            val wrapped: List<Any?> =
                try {
                  listOf(api.getFallbackRule(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.getPreferredAspectRatio",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg =
                args[0] as androidx.camera.core.resolutionselector.AspectRatioStrategy
            val wrapped: List<Any?> =
                try {
                  listOf(api.getPreferredAspectRatio(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of AspectRatioStrategy and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.resolutionselector.AspectRatioStrategy,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.AspectRatioStrategy.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * Represents the different states the camera can be in.
 *
 * See https://developer.android.com/reference/androidx/camera/core/CameraState.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCameraState(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** The camera's state. */
  abstract fun type(pigeon_instance: androidx.camera.core.CameraState): CameraStateType

  /** Potentially returns an error the camera encountered. */
  abstract fun error(
      pigeon_instance: androidx.camera.core.CameraState
  ): androidx.camera.core.CameraState.StateError?

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CameraState and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.CameraState,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val typeArg = type(pigeon_instanceArg)
      val errorArg = error(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.CameraState.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, typeArg, errorArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * An interface which contains the camera exposure related information.
 *
 * See https://developer.android.com/reference/androidx/camera/core/ExposureState.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiExposureState(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /**
   * Get the maximum and minimum exposure compensation values for
   * `CameraControl.setExposureCompensationIndex`.
   */
  abstract fun exposureCompensationRange(
      pigeon_instance: androidx.camera.core.ExposureState
  ): android.util.Range<*>

  /** Get the smallest step by which the exposure compensation can be changed. */
  abstract fun exposureCompensationStep(pigeon_instance: androidx.camera.core.ExposureState): Double

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ExposureState and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.ExposureState,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val exposureCompensationRangeArg = exposureCompensationRange(pigeon_instanceArg)
      val exposureCompensationStepArg = exposureCompensationStep(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.ExposureState.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(
          listOf(pigeon_identifierArg, exposureCompensationRangeArg, exposureCompensationStepArg)) {
            if (it is List<*>) {
              if (it.size > 1) {
                callback(
                    Result.failure(
                        CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
              } else {
                callback(Result.success(Unit))
              }
            } else {
              callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
            }
          }
    }
  }
}
/**
 * An interface which contains the zoom related information from a camera.
 *
 * See https://developer.android.com/reference/androidx/camera/core/ZoomState.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiZoomState(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  /** The minimum zoom ratio. */
  abstract fun minZoomRatio(pigeon_instance: androidx.camera.core.ZoomState): Double

  /** The maximum zoom ratio. */
  abstract fun maxZoomRatio(pigeon_instance: androidx.camera.core.ZoomState): Double

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ZoomState and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.ZoomState,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val minZoomRatioArg = minZoomRatio(pigeon_instanceArg)
      val maxZoomRatioArg = maxZoomRatio(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.ZoomState.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, minZoomRatioArg, maxZoomRatioArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A use case providing CPU accessible images for an app to perform image analysis on.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageAnalysis.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiImageAnalysis(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(
      resolutionSelector: androidx.camera.core.resolutionselector.ResolutionSelector?,
      targetRotation: Long?,
      outputImageFormat: Long?
  ): androidx.camera.core.ImageAnalysis

  abstract fun resolutionSelector(
      pigeon_instance: androidx.camera.core.ImageAnalysis
  ): androidx.camera.core.resolutionselector.ResolutionSelector?

  /** Sets an analyzer to receive and analyze images. */
  abstract fun setAnalyzer(
      pigeon_instance: androidx.camera.core.ImageAnalysis,
      analyzer: androidx.camera.core.ImageAnalysis.Analyzer
  )

  /** Removes a previously set analyzer. */
  abstract fun clearAnalyzer(pigeon_instance: androidx.camera.core.ImageAnalysis)

  /** Sets the target rotation. */
  abstract fun setTargetRotation(
      pigeon_instance: androidx.camera.core.ImageAnalysis,
      rotation: Long
  )

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiImageAnalysis?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val resolutionSelectorArg =
                args[1] as androidx.camera.core.resolutionselector.ResolutionSelector?
            val targetRotationArg = args[2] as Long?
            val outputImageFormatArg = args[3] as Long?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(
                          resolutionSelectorArg, targetRotationArg, outputImageFormatArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.setAnalyzer",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.ImageAnalysis
            val analyzerArg = args[1] as androidx.camera.core.ImageAnalysis.Analyzer
            val wrapped: List<Any?> =
                try {
                  api.setAnalyzer(pigeon_instanceArg, analyzerArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.clearAnalyzer",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.ImageAnalysis
            val wrapped: List<Any?> =
                try {
                  api.clearAnalyzer(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.setTargetRotation",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.ImageAnalysis
            val rotationArg = args[1] as Long
            val wrapped: List<Any?> =
                try {
                  api.setTargetRotation(pigeon_instanceArg, rotationArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ImageAnalysis and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.ImageAnalysis,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val resolutionSelectorArg = resolutionSelector(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.ImageAnalysis.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, resolutionSelectorArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiUseCase] used to access callback methods */
  fun pigeon_getPigeonApiUseCase(): PigeonApiUseCase {
    return pigeonRegistrar.getPigeonApiUseCase()
  }
}
/**
 * Interface for analyzing images.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageAnalysis.Analyzer.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiAnalyzer(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  abstract fun pigeon_defaultConstructor(): androidx.camera.core.ImageAnalysis.Analyzer

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiAnalyzer?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Analyzer.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of Analyzer and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.ImageAnalysis.Analyzer,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      callback(
          Result.failure(
              CameraXError(
                  "new-instance-error",
                  "Attempting to create a new Dart instance of Analyzer, but the class has a nonnull callback method.",
                  "")))
    }
  }

  /** Analyzes an image to produce a result. */
  fun analyze(
      pigeon_instanceArg: androidx.camera.core.ImageAnalysis.Analyzer,
      imageArg: androidx.camera.core.ImageProxy,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
      return
    }
    val binaryMessenger = pigeonRegistrar.binaryMessenger
    val codec = pigeonRegistrar.codec
    val channelName = "dev.flutter.pigeon.camera_android_camerax.Analyzer.analyze"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(pigeon_instanceArg, imageArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
      }
    }
  }
}
/**
 * Error that the camera has encountered.
 *
 * See https://developer.android.com/reference/androidx/camera/core/CameraState.StateError.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCameraStateStateError(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** The code of this error. */
  abstract fun code(
      pigeon_instance: androidx.camera.core.CameraState.StateError
  ): CameraStateErrorCode

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CameraStateStateError and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.CameraState.StateError,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val codeArg = code(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.CameraStateStateError.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, codeArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * LiveData is a data holder class that can be observed within a given lifecycle.
 *
 * This is a wrapper around the native class to better support the generic type. Java has type
 * erasure;
 *
 * See https://developer.android.com/reference/androidx/lifecycle/LiveData.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiLiveData(open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar) {
  /** The generic type used by this instance. */
  abstract fun type(
      pigeon_instance: io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper
  ): LiveDataSupportedType

  /** Adds the given observer to the observers list within the lifespan of the given owner. */
  abstract fun observe(
      pigeon_instance: io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper,
      observer: androidx.lifecycle.Observer<*>
  )

  /** Removes all observers that are tied to the given `LifecycleOwner`. */
  abstract fun removeObservers(
      pigeon_instance: io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper
  )

  /** Returns the current value. */
  abstract fun getValue(
      pigeon_instance: io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper
  ): Any?

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiLiveData?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.LiveData.observe",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg =
                args[0] as io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper
            val observerArg = args[1] as androidx.lifecycle.Observer<*>
            val wrapped: List<Any?> =
                try {
                  api.observe(pigeon_instanceArg, observerArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.LiveData.removeObservers",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg =
                args[0] as io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper
            val wrapped: List<Any?> =
                try {
                  api.removeObservers(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.LiveData.getValue",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg =
                args[0] as io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper
            val wrapped: List<Any?> =
                try {
                  listOf(api.getValue(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of LiveData and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: io.flutter.plugins.camerax.LiveDataProxyApi.LiveDataWrapper,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val typeArg = type(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.LiveData.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, typeArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * An image proxy which has a similar interface as `android.media.Image`.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageProxy.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiImageProxy(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** The image format. */
  abstract fun format(pigeon_instance: androidx.camera.core.ImageProxy): Long

  /** The image width. */
  abstract fun width(pigeon_instance: androidx.camera.core.ImageProxy): Long

  /** The image height. */
  abstract fun height(pigeon_instance: androidx.camera.core.ImageProxy): Long

  /** Returns the array of planes. */
  abstract fun getPlanes(
      pigeon_instance: androidx.camera.core.ImageProxy
  ): List<androidx.camera.core.ImageProxy.PlaneProxy>

  /** Closes the underlying `android.media.Image`. */
  abstract fun close(pigeon_instance: androidx.camera.core.ImageProxy)

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiImageProxy?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageProxy.getPlanes",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.ImageProxy
            val wrapped: List<Any?> =
                try {
                  listOf(api.getPlanes(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ImageProxy.close",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.ImageProxy
            val wrapped: List<Any?> =
                try {
                  api.close(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ImageProxy and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.ImageProxy,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val formatArg = format(pigeon_instanceArg)
      val widthArg = width(pigeon_instanceArg)
      val heightArg = height(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.ImageProxy.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, formatArg, widthArg, heightArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A plane proxy which has an analogous interface as `android.media.Image.Plane`.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/ImageProxy.PlaneProxy.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiPlaneProxy(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** The pixels buffer. */
  abstract fun buffer(pigeon_instance: androidx.camera.core.ImageProxy.PlaneProxy): ByteArray

  /** The pixel stride. */
  abstract fun pixelStride(pigeon_instance: androidx.camera.core.ImageProxy.PlaneProxy): Long

  /** The row stride. */
  abstract fun rowStride(pigeon_instance: androidx.camera.core.ImageProxy.PlaneProxy): Long

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of PlaneProxy and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.ImageProxy.PlaneProxy,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val bufferArg = buffer(pigeon_instanceArg)
      val pixelStrideArg = pixelStride(pigeon_instanceArg)
      val rowStrideArg = rowStride(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.PlaneProxy.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, bufferArg, pixelStrideArg, rowStrideArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * Defines a desired quality setting that can be used to configure components with quality setting
 * requirements such as creating a Recorder.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/video/QualitySelector.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiQualitySelector(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Gets an instance of QualitySelector with a desired quality. */
  abstract fun from(
      quality: VideoQuality,
      fallbackStrategy: androidx.camera.video.FallbackStrategy?
  ): androidx.camera.video.QualitySelector

  /** Gets an instance of QualitySelector with ordered desired qualities. */
  abstract fun fromOrderedList(
      qualities: List<VideoQuality>,
      fallbackStrategy: androidx.camera.video.FallbackStrategy?
  ): androidx.camera.video.QualitySelector

  /** Gets the corresponding resolution from the input quality. */
  abstract fun getResolution(
      cameraInfo: androidx.camera.core.CameraInfo,
      quality: VideoQuality
  ): android.util.Size?

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiQualitySelector?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.QualitySelector.from",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val qualityArg = args[1] as VideoQuality
            val fallbackStrategyArg = args[2] as androidx.camera.video.FallbackStrategy?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.from(qualityArg, fallbackStrategyArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.QualitySelector.fromOrderedList",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val qualitiesArg = args[1] as List<VideoQuality>
            val fallbackStrategyArg = args[2] as androidx.camera.video.FallbackStrategy?
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.fromOrderedList(qualitiesArg, fallbackStrategyArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.QualitySelector.getResolution",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val cameraInfoArg = args[0] as androidx.camera.core.CameraInfo
            val qualityArg = args[1] as VideoQuality
            val wrapped: List<Any?> =
                try {
                  listOf(api.getResolution(cameraInfoArg, qualityArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of QualitySelector and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.QualitySelector,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.QualitySelector.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A class represents the strategy that will be adopted when the device does not support all the
 * desired Quality in QualitySelector in order to select the quality as possible.
 *
 * See https://developer.android.com/reference/androidx/camera/video/FallbackStrategy.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiFallbackStrategy(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /**
   * Returns a fallback strategy that will choose the quality that is closest to and higher than the
   * input quality.
   */
  abstract fun higherQualityOrLowerThan(
      quality: VideoQuality
  ): androidx.camera.video.FallbackStrategy

  /**
   * Returns a fallback strategy that will choose the quality that is closest to and higher than the
   * input quality.
   */
  abstract fun higherQualityThan(quality: VideoQuality): androidx.camera.video.FallbackStrategy

  /**
   * Returns a fallback strategy that will choose the quality that is closest to and lower than the
   * input quality.
   */
  abstract fun lowerQualityOrHigherThan(
      quality: VideoQuality
  ): androidx.camera.video.FallbackStrategy

  /**
   * Returns a fallback strategy that will choose the quality that is closest to and lower than the
   * input quality.
   */
  abstract fun lowerQualityThan(quality: VideoQuality): androidx.camera.video.FallbackStrategy

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiFallbackStrategy?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.higherQualityOrLowerThan",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val qualityArg = args[1] as VideoQuality
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.higherQualityOrLowerThan(qualityArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.higherQualityThan",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val qualityArg = args[1] as VideoQuality
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.higherQualityThan(qualityArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.lowerQualityOrHigherThan",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val qualityArg = args[1] as VideoQuality
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.lowerQualityOrHigherThan(qualityArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.lowerQualityThan",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val qualityArg = args[1] as VideoQuality
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.lowerQualityThan(qualityArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of FallbackStrategy and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.video.FallbackStrategy,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.FallbackStrategy.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * The CameraControl provides various asynchronous operations like zoom, focus and metering which
 * affects output of all UseCases currently bound to that camera.
 *
 * See https://developer.android.com/reference/androidx/camera/core/CameraControl.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCameraControl(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Enable the torch or disable the torch. */
  abstract fun enableTorch(
      pigeon_instance: androidx.camera.core.CameraControl,
      torch: Boolean,
      callback: (Result<Unit>) -> Unit
  )

  /** Sets current zoom by ratio. */
  abstract fun setZoomRatio(
      pigeon_instance: androidx.camera.core.CameraControl,
      ratio: Double,
      callback: (Result<Unit>) -> Unit
  )

  /** Starts a focus and metering action configured by the `FocusMeteringAction`. */
  abstract fun startFocusAndMetering(
      pigeon_instance: androidx.camera.core.CameraControl,
      action: androidx.camera.core.FocusMeteringAction,
      callback: (Result<androidx.camera.core.FocusMeteringResult?>) -> Unit
  )

  /** Cancels current FocusMeteringAction and clears AF/AE/AWB regions. */
  abstract fun cancelFocusAndMetering(
      pigeon_instance: androidx.camera.core.CameraControl,
      callback: (Result<Unit>) -> Unit
  )

  /** Set the exposure compensation value for the camera. */
  abstract fun setExposureCompensationIndex(
      pigeon_instance: androidx.camera.core.CameraControl,
      index: Long,
      callback: (Result<Long?>) -> Unit
  )

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiCameraControl?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraControl.enableTorch",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.CameraControl
            val torchArg = args[1] as Boolean
            api.enableTorch(pigeon_instanceArg, torchArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CameraXLibraryPigeonUtils.wrapError(error))
              } else {
                reply.reply(CameraXLibraryPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraControl.setZoomRatio",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.CameraControl
            val ratioArg = args[1] as Double
            api.setZoomRatio(pigeon_instanceArg, ratioArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CameraXLibraryPigeonUtils.wrapError(error))
              } else {
                reply.reply(CameraXLibraryPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraControl.startFocusAndMetering",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.CameraControl
            val actionArg = args[1] as androidx.camera.core.FocusMeteringAction
            api.startFocusAndMetering(pigeon_instanceArg, actionArg) {
                result: Result<androidx.camera.core.FocusMeteringResult?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CameraXLibraryPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CameraXLibraryPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraControl.cancelFocusAndMetering",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.CameraControl
            api.cancelFocusAndMetering(pigeon_instanceArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CameraXLibraryPigeonUtils.wrapError(error))
              } else {
                reply.reply(CameraXLibraryPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraControl.setExposureCompensationIndex",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.CameraControl
            val indexArg = args[1] as Long
            api.setExposureCompensationIndex(pigeon_instanceArg, indexArg) { result: Result<Long?>
              ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CameraXLibraryPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(CameraXLibraryPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CameraControl and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.CameraControl,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName = "dev.flutter.pigeon.camera_android_camerax.CameraControl.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * The builder used to create the `FocusMeteringAction`.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/core/FocusMeteringAction.Builder.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiFocusMeteringActionBuilder(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Creates a Builder from a `MeteringPoint` with default mode FLAG_AF | FLAG_AE | FLAG_AWB. */
  abstract fun pigeon_defaultConstructor(
      point: androidx.camera.core.MeteringPoint
  ): androidx.camera.core.FocusMeteringAction.Builder

  /** Creates a Builder from a `MeteringPoint` and `MeteringMode`. */
  abstract fun withMode(
      point: androidx.camera.core.MeteringPoint,
      mode: MeteringMode
  ): androidx.camera.core.FocusMeteringAction.Builder

  /** Adds another MeteringPoint with default metering mode. */
  abstract fun addPoint(
      pigeon_instance: androidx.camera.core.FocusMeteringAction.Builder,
      point: androidx.camera.core.MeteringPoint
  )

  /** Adds another MeteringPoint with specified meteringMode. */
  abstract fun addPointWithMode(
      pigeon_instance: androidx.camera.core.FocusMeteringAction.Builder,
      point: androidx.camera.core.MeteringPoint,
      mode: MeteringMode
  )

  /** Disables the auto-cancel. */
  abstract fun disableAutoCancel(pigeon_instance: androidx.camera.core.FocusMeteringAction.Builder)

  /** Builds the `FocusMeteringAction` instance. */
  abstract fun build(
      pigeon_instance: androidx.camera.core.FocusMeteringAction.Builder
  ): androidx.camera.core.FocusMeteringAction

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiFocusMeteringActionBuilder?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val pointArg = args[1] as androidx.camera.core.MeteringPoint
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(pointArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.withMode",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val pointArg = args[1] as androidx.camera.core.MeteringPoint
            val modeArg = args[2] as MeteringMode
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.withMode(pointArg, modeArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.addPoint",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.FocusMeteringAction.Builder
            val pointArg = args[1] as androidx.camera.core.MeteringPoint
            val wrapped: List<Any?> =
                try {
                  api.addPoint(pigeon_instanceArg, pointArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.addPointWithMode",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.FocusMeteringAction.Builder
            val pointArg = args[1] as androidx.camera.core.MeteringPoint
            val modeArg = args[2] as MeteringMode
            val wrapped: List<Any?> =
                try {
                  api.addPointWithMode(pigeon_instanceArg, pointArg, modeArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.disableAutoCancel",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.FocusMeteringAction.Builder
            val wrapped: List<Any?> =
                try {
                  api.disableAutoCancel(pigeon_instanceArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.build",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.FocusMeteringAction.Builder
            val wrapped: List<Any?> =
                try {
                  listOf(api.build(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /**
   * Creates a Dart instance of FocusMeteringActionBuilder and attaches it to [pigeon_instanceArg].
   */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.FocusMeteringAction.Builder,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.FocusMeteringActionBuilder.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A configuration used to trigger a focus and/or metering action.
 *
 * See https://developer.android.com/reference/kotlin/androidx/camera/core/FocusMeteringAction.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiFocusMeteringAction(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** All MeteringPoints used for AE regions. */
  abstract fun meteringPointsAe(
      pigeon_instance: androidx.camera.core.FocusMeteringAction
  ): List<androidx.camera.core.MeteringPoint>

  /** All MeteringPoints used for AF regions. */
  abstract fun meteringPointsAf(
      pigeon_instance: androidx.camera.core.FocusMeteringAction
  ): List<androidx.camera.core.MeteringPoint>

  /** All MeteringPoints used for AWB regions. */
  abstract fun meteringPointsAwb(
      pigeon_instance: androidx.camera.core.FocusMeteringAction
  ): List<androidx.camera.core.MeteringPoint>

  /** If auto-cancel is enabled or not. */
  abstract fun isAutoCancelEnabled(
      pigeon_instance: androidx.camera.core.FocusMeteringAction
  ): Boolean

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of FocusMeteringAction and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.FocusMeteringAction,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val meteringPointsAeArg = meteringPointsAe(pigeon_instanceArg)
      val meteringPointsAfArg = meteringPointsAf(pigeon_instanceArg)
      val meteringPointsAwbArg = meteringPointsAwb(pigeon_instanceArg)
      val isAutoCancelEnabledArg = isAutoCancelEnabled(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.FocusMeteringAction.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(
          listOf(
              pigeon_identifierArg,
              meteringPointsAeArg,
              meteringPointsAfArg,
              meteringPointsAwbArg,
              isAutoCancelEnabledArg)) {
            if (it is List<*>) {
              if (it.size > 1) {
                callback(
                    Result.failure(
                        CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
              } else {
                callback(Result.success(Unit))
              }
            } else {
              callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
            }
          }
    }
  }
}
/**
 * Result of the `CameraControl.startFocusAndMetering`.
 *
 * See https://developer.android.com/reference/androidx/camera/core/FocusMeteringResult.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiFocusMeteringResult(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** If auto focus is successful. */
  abstract fun isFocusSuccessful(pigeon_instance: androidx.camera.core.FocusMeteringResult): Boolean

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of FocusMeteringResult and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.FocusMeteringResult,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val isFocusSuccessfulArg = isFocusSuccessful(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.FocusMeteringResult.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg, isFocusSuccessfulArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * An immutable package of settings and outputs needed to capture a single image from the camera
 * device.
 *
 * See https://developer.android.com/reference/android/hardware/camera2/CaptureRequest.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCaptureRequest(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /**
   * Whether auto-exposure (AE) is currently locked to its latest calculated values.
   *
   * Value is boolean.
   *
   * This key is available on all devices.
   */
  abstract fun controlAELock(): android.hardware.camera2.CaptureRequest.Key<*>

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiCaptureRequest?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CaptureRequest.controlAELock",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.controlAELock(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CaptureRequest and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: android.hardware.camera2.CaptureRequest,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.CaptureRequest.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A Key is used to do capture request field lookups with CaptureRequest.get or to set fields with
 * `CaptureRequest.Builder.set`.
 *
 * See https://developer.android.com/reference/android/hardware/camera2/CaptureRequest.Key.html.
 */
@Suppress("UNCHECKED_CAST")
open class PigeonApiCaptureRequestKey(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CaptureRequestKey and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: android.hardware.camera2.CaptureRequest.Key<*>,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.CaptureRequestKey.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A bundle of Camera2 capture request options.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/camera2/interop/CaptureRequestOptions.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCaptureRequestOptions(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun pigeon_defaultConstructor(
      options: Map<android.hardware.camera2.CaptureRequest.Key<*>, Any?>
  ): androidx.camera.camera2.interop.CaptureRequestOptions

  /** Returns a value for the given CaptureRequestKey or null if it hasn't been set. */
  abstract fun getCaptureRequestOption(
      pigeon_instance: androidx.camera.camera2.interop.CaptureRequestOptions,
      key: android.hardware.camera2.CaptureRequest.Key<*>
  ): Any?

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiCaptureRequestOptions?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CaptureRequestOptions.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val optionsArg = args[1] as Map<android.hardware.camera2.CaptureRequest.Key<*>, Any?>
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(optionsArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CaptureRequestOptions.getCaptureRequestOption",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg =
                args[0] as androidx.camera.camera2.interop.CaptureRequestOptions
            val keyArg = args[1] as android.hardware.camera2.CaptureRequest.Key<*>
            val wrapped: List<Any?> =
                try {
                  listOf(api.getCaptureRequestOption(pigeon_instanceArg, keyArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CaptureRequestOptions and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.camera2.interop.CaptureRequestOptions,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.CaptureRequestOptions.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * An class that provides ability to interoperate with the 1android.hardware.camera21 APIs.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/camera2/interop/Camera2CameraControl.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCamera2CameraControl(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Gets the `Camera2CameraControl` from a `CameraControl`. */
  abstract fun from(
      cameraControl: androidx.camera.core.CameraControl
  ): androidx.camera.camera2.interop.Camera2CameraControl

  /** Adds a `CaptureRequestOptions` updates the session with the options it contains. */
  abstract fun addCaptureRequestOptions(
      pigeon_instance: androidx.camera.camera2.interop.Camera2CameraControl,
      bundle: androidx.camera.camera2.interop.CaptureRequestOptions,
      callback: (Result<Unit>) -> Unit
  )

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiCamera2CameraControl?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Camera2CameraControl.from",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val cameraControlArg = args[1] as androidx.camera.core.CameraControl
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.from(cameraControlArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Camera2CameraControl.addCaptureRequestOptions",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.camera2.interop.Camera2CameraControl
            val bundleArg = args[1] as androidx.camera.camera2.interop.CaptureRequestOptions
            api.addCaptureRequestOptions(pigeon_instanceArg, bundleArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(CameraXLibraryPigeonUtils.wrapError(error))
              } else {
                reply.reply(CameraXLibraryPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of Camera2CameraControl and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.camera2.interop.Camera2CameraControl,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.Camera2CameraControl.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * Applications can filter out unsuitable sizes and sort the resolution list in the preferred order
 * by implementing the resolution filter interface.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/core/resolutionselector/ResolutionFilter.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiResolutionFilter(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  abstract fun createWithOnePreferredSize(
      preferredSize: android.util.Size
  ): androidx.camera.core.resolutionselector.ResolutionFilter

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiResolutionFilter?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.ResolutionFilter.createWithOnePreferredSize",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val preferredSizeArg = args[1] as android.util.Size
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.createWithOnePreferredSize(preferredSizeArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of ResolutionFilter and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.resolutionselector.ResolutionFilter,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.ResolutionFilter.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A Key is used to do camera characteristics field lookups with `CameraCharacteristics.get`.
 *
 * See
 * https://developer.android.com/reference/android/hardware/camera2/CameraCharacteristics.Key.html.
 */
@Suppress("UNCHECKED_CAST")
open class PigeonApiCameraCharacteristicsKey(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  @Suppress("LocalVariableName", "FunctionName")
  /**
   * Creates a Dart instance of CameraCharacteristicsKey and attaches it to [pigeon_instanceArg].
   */
  fun pigeon_newInstance(
      pigeon_instanceArg: android.hardware.camera2.CameraCharacteristics.Key<*>,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.CameraCharacteristicsKey.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * The properties describing a `CameraDevice`.
 *
 * See https://developer.android.com/reference/android/hardware/camera2/CameraCharacteristics.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCameraCharacteristics(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /**
   * Generally classifies the overall set of the camera device functionality.
   *
   * Value is `InfoSupportedHardwareLevel`.
   *
   * This key is available on all devices.
   */
  abstract fun infoSupportedHardwareLevel(): android.hardware.camera2.CameraCharacteristics.Key<*>

  /**
   * Clockwise angle through which the output image needs to be rotated to be upright on the device
   * screen in its native orientation..
   *
   * Value is int.
   *
   * This key is available on all devices.
   */
  abstract fun sensorOrientation(): android.hardware.camera2.CameraCharacteristics.Key<*>

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiCameraCharacteristics?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraCharacteristics.infoSupportedHardwareLevel",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.infoSupportedHardwareLevel(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.CameraCharacteristics.sensorOrientation",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.sensorOrientation(), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of CameraCharacteristics and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: android.hardware.camera2.CameraCharacteristics,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.CameraCharacteristics.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * An interface for retrieving Camera2-related camera information.
 *
 * See
 * https://developer.android.com/reference/kotlin/androidx/camera/camera2/interop/Camera2CameraInfo.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiCamera2CameraInfo(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Gets the `Camera2CameraInfo` from a `CameraInfo`. */
  abstract fun from(
      cameraInfo: androidx.camera.core.CameraInfo
  ): androidx.camera.camera2.interop.Camera2CameraInfo

  /** Gets the string camera ID. */
  abstract fun getCameraId(
      pigeon_instance: androidx.camera.camera2.interop.Camera2CameraInfo
  ): String

  /** Gets a camera characteristic value. */
  abstract fun getCameraCharacteristic(
      pigeon_instance: androidx.camera.camera2.interop.Camera2CameraInfo,
      key: android.hardware.camera2.CameraCharacteristics.Key<*>
  ): Any?

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(binaryMessenger: BinaryMessenger, api: PigeonApiCamera2CameraInfo?) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.from",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val cameraInfoArg = args[1] as androidx.camera.core.CameraInfo
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.from(cameraInfoArg), pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.getCameraId",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.camera2.interop.Camera2CameraInfo
            val wrapped: List<Any?> =
                try {
                  listOf(api.getCameraId(pigeon_instanceArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.getCameraCharacteristic",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.camera2.interop.Camera2CameraInfo
            val keyArg = args[1] as android.hardware.camera2.CameraCharacteristics.Key<*>
            val wrapped: List<Any?> =
                try {
                  listOf(api.getCameraCharacteristic(pigeon_instanceArg, keyArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of Camera2CameraInfo and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.camera2.interop.Camera2CameraInfo,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.Camera2CameraInfo.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A factory to create a MeteringPoint.
 *
 * See https://developer.android.com/reference/androidx/camera/core/MeteringPointFactory.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiMeteringPointFactory(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /** Creates a MeteringPoint by x, y. */
  abstract fun createPoint(
      pigeon_instance: androidx.camera.core.MeteringPointFactory,
      x: Double,
      y: Double
  ): androidx.camera.core.MeteringPoint

  /** Creates a MeteringPoint by x, y, size. */
  abstract fun createPointWithSize(
      pigeon_instance: androidx.camera.core.MeteringPointFactory,
      x: Double,
      y: Double,
      size: Double
  ): androidx.camera.core.MeteringPoint

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiMeteringPointFactory?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.MeteringPointFactory.createPoint",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.MeteringPointFactory
            val xArg = args[1] as Double
            val yArg = args[2] as Double
            val wrapped: List<Any?> =
                try {
                  listOf(api.createPoint(pigeon_instanceArg, xArg, yArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.MeteringPointFactory.createPointWithSize",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_instanceArg = args[0] as androidx.camera.core.MeteringPointFactory
            val xArg = args[1] as Double
            val yArg = args[2] as Double
            val sizeArg = args[3] as Double
            val wrapped: List<Any?> =
                try {
                  listOf(api.createPointWithSize(pigeon_instanceArg, xArg, yArg, sizeArg))
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /** Creates a Dart instance of MeteringPointFactory and attaches it to [pigeon_instanceArg]. */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.MeteringPointFactory,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.MeteringPointFactory.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }
}
/**
 * A MeteringPointFactory that can convert a View (x, y) into a MeteringPoint which can then be used
 * to construct a FocusMeteringAction to start a focus and metering action.
 *
 * See
 * https://developer.android.com/reference/androidx/camera/core/DisplayOrientedMeteringPointFactory.
 */
@Suppress("UNCHECKED_CAST")
abstract class PigeonApiDisplayOrientedMeteringPointFactory(
    open val pigeonRegistrar: CameraXLibraryPigeonProxyApiRegistrar
) {
  /**
   * Creates a DisplayOrientedMeteringPointFactory for converting View (x, y) into a MeteringPoint
   * based on the current display's rotation and CameraInfo.
   */
  abstract fun pigeon_defaultConstructor(
      cameraInfo: androidx.camera.core.CameraInfo,
      width: Double,
      height: Double
  ): androidx.camera.core.DisplayOrientedMeteringPointFactory

  companion object {
    @Suppress("LocalVariableName")
    fun setUpMessageHandlers(
        binaryMessenger: BinaryMessenger,
        api: PigeonApiDisplayOrientedMeteringPointFactory?
    ) {
      val codec = api?.pigeonRegistrar?.codec ?: CameraXLibraryPigeonCodec()
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.camera_android_camerax.DisplayOrientedMeteringPointFactory.pigeon_defaultConstructor",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val pigeon_identifierArg = args[0] as Long
            val cameraInfoArg = args[1] as androidx.camera.core.CameraInfo
            val widthArg = args[2] as Double
            val heightArg = args[3] as Double
            val wrapped: List<Any?> =
                try {
                  api.pigeonRegistrar.instanceManager.addDartCreatedInstance(
                      api.pigeon_defaultConstructor(cameraInfoArg, widthArg, heightArg),
                      pigeon_identifierArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  CameraXLibraryPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }

  @Suppress("LocalVariableName", "FunctionName")
  /**
   * Creates a Dart instance of DisplayOrientedMeteringPointFactory and attaches it to
   * [pigeon_instanceArg].
   */
  fun pigeon_newInstance(
      pigeon_instanceArg: androidx.camera.core.DisplayOrientedMeteringPointFactory,
      callback: (Result<Unit>) -> Unit
  ) {
    if (pigeonRegistrar.ignoreCallsToDart) {
      callback(
          Result.failure(
              CameraXError("ignore-calls-error", "Calls to Dart are being ignored.", "")))
    } else if (pigeonRegistrar.instanceManager.containsInstance(pigeon_instanceArg)) {
      callback(Result.success(Unit))
    } else {
      val pigeon_identifierArg =
          pigeonRegistrar.instanceManager.addHostCreatedInstance(pigeon_instanceArg)
      val binaryMessenger = pigeonRegistrar.binaryMessenger
      val codec = pigeonRegistrar.codec
      val channelName =
          "dev.flutter.pigeon.camera_android_camerax.DisplayOrientedMeteringPointFactory.pigeon_newInstance"
      val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
      channel.send(listOf(pigeon_identifierArg)) {
        if (it is List<*>) {
          if (it.size > 1) {
            callback(
                Result.failure(CameraXError(it[0] as String, it[1] as String, it[2] as String?)))
          } else {
            callback(Result.success(Unit))
          }
        } else {
          callback(Result.failure(CameraXLibraryPigeonUtils.createConnectionError(channelName)))
        }
      }
    }
  }

  @Suppress("FunctionName")
  /** An implementation of [PigeonApiMeteringPointFactory] used to access callback methods */
  fun pigeon_getPigeonApiMeteringPointFactory(): PigeonApiMeteringPointFactory {
    return pigeonRegistrar.getPigeonApiMeteringPointFactory()
  }
}
