// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'lib_l10n.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class LibLocalizationsDe extends LibLocalizations {
  LibLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get about => 'Über';

  @override
  String actionAndAction(Object action1, Object action2) {
    return '$action1 und dann $action2?';
  }

  @override
  String get add => 'Hinzufügen';

  @override
  String get all => 'Alle';

  @override
  String get anonLoseDataTip =>
      'Sie sind derzeit anonym angemeldet. Bei Fortsetzung der Aktion gehen Daten verloren.';

  @override
  String get app => 'Anwendung';

  @override
  String askContinue(Object msg) {
    return '$msg. Möchten Sie fortfahren?';
  }

  @override
  String get attention => 'Achtung';

  @override
  String get authRequired => 'Authentifizierung erforderlich';

  @override
  String get auto => 'Auto';

  @override
  String get background => 'Hintergrund';

  @override
  String get backup => 'Sichern';

  @override
  String get bioAuth => 'Biometrische Authentifizierung';

  @override
  String get blurRadius => 'Unschärferadius';

  @override
  String get bright => 'Hell';

  @override
  String get cancel => 'Abbrechen';

  @override
  String get checkUpdate => 'Nach Updates suchen';

  @override
  String get clear => 'Löschen';

  @override
  String get click => 'Klicken';

  @override
  String get clipboard => 'Zwischenablage';

  @override
  String get close => 'Schließen';

  @override
  String get content => 'Inhalt';

  @override
  String get copy => 'Kopieren';

  @override
  String get custom => 'Benutzerdefiniert';

  @override
  String get cut => 'Ausschneiden';

  @override
  String get dark => 'Dunkel';

  @override
  String get day => 'Tage';

  @override
  String delFmt(Object id, Object type) {
    return '$type ($id) wirklich löschen?';
  }

  @override
  String get delay => 'Verzögerung';

  @override
  String get delete => 'Löschen';

  @override
  String get device => 'Gerät';

  @override
  String get disabled => 'Deaktiviert';

  @override
  String get doc => 'Dokumentation';

  @override
  String get dontShowAgain => 'Nicht erneut anzeigen';

  @override
  String get download => 'Download';

  @override
  String get duration => 'Dauer';

  @override
  String get edit => 'Bearbeiten';

  @override
  String get editor => 'Editor';

  @override
  String get empty => 'Leer';

  @override
  String get error => 'Fehler';

  @override
  String get example => 'Beispiel';

  @override
  String get execute => 'Ausführen';

  @override
  String get exit => 'Beenden';

  @override
  String get exitConfirmTip => 'Erneut Zurück drücken, um die App zu beenden';

  @override
  String get exitDirectly => 'Direkt beenden';

  @override
  String get export => 'Export';

  @override
  String get fail => 'Fehlschlag';

  @override
  String get feedback => 'Feedback';

  @override
  String get file => 'Datei';

  @override
  String get fold => 'Einklappen';

  @override
  String get folder => 'Ordner';

  @override
  String get font => 'Schriftart';

  @override
  String get found => 'Gefunden';

  @override
  String get hideTitleBar => 'Titelleiste ausblenden';

  @override
  String get hour => 'Stunden';

  @override
  String get image => 'Bild';

  @override
  String get import => 'Importieren';

  @override
  String get init => 'Initialisieren';

  @override
  String get key => 'Schlüssel';

  @override
  String get language => 'Sprache';

  @override
  String get license => 'Lizenz';

  @override
  String get log => 'Log';

  @override
  String get login => 'Anmelden';

  @override
  String get loginTip =>
      'Keine Registrierung erforderlich, kostenlose Nutzung.';

  @override
  String get logout => 'Abmelden';

  @override
  String get manual => 'Manuell';

  @override
  String get migrateCfg => 'Konfigurationsmigration';

  @override
  String get migrateCfgTip =>
      'Um die neue Konfiguration zu übernehmen und anzupassen';

  @override
  String get minute => 'Minuten';

  @override
  String get moveDown => 'Nach unten';

  @override
  String get moveUp => 'Nach oben';

  @override
  String get name => 'Name';

  @override
  String get network => 'Netzwerk';

  @override
  String get next => 'Weiter';

  @override
  String notExistFmt(Object file) {
    return '$file existiert nicht';
  }

  @override
  String get note => 'Hinweis';

  @override
  String get ok => 'OK';

  @override
  String get opacity => 'Transparenz';

  @override
  String get open => 'Öffnen';

  @override
  String get paste => 'Einfügen';

  @override
  String get path => 'Pfad';

  @override
  String get preview => 'Vorschau';

  @override
  String get previous => 'Zurück';

  @override
  String get primaryColorSeed => 'Grundfarbe';

  @override
  String get pwd => 'Passwort';

  @override
  String get pwdTip =>
      'Länge 6-32 Zeichen, kann englische Buchstaben, Zahlen und Satzzeichen enthalten';

  @override
  String get redo => 'Wiederholen';

  @override
  String get refresh => 'Aktualisieren';

  @override
  String get register => 'Registrieren';

  @override
  String get rename => 'Umbenennen';

  @override
  String get replace => 'Ersetzen';

  @override
  String get replaceAll => 'Alle ersetzen';

  @override
  String get reset => 'Zurücksetzen';

  @override
  String get restore => 'Wiederherstellen';

  @override
  String get result => 'Ergebnis';

  @override
  String get retry => 'Erneut versuchen';

  @override
  String get save => 'Speichern';

  @override
  String get search => 'Suchen';

  @override
  String get second => 'Sekunden';

  @override
  String get select => 'Auswählen';

  @override
  String get setting => 'Einstellungen';

  @override
  String get share => 'Teilen';

  @override
  String get size => 'Größe';

  @override
  String sizeTooLargeOnlyPrefix(Object bytes) {
    return 'Inhalt zu groß, es werden nur die ersten $bytes angezeigt';
  }

  @override
  String get start => 'Start';

  @override
  String get stop => 'Stop';

  @override
  String get success => 'Erfolg';

  @override
  String get switch_ => 'Schalter';

  @override
  String get switcher => 'Umschalter';

  @override
  String get sync => 'Synchronisieren';

  @override
  String get system => 'System';

  @override
  String get tag => 'Etikett';

  @override
  String get tapToAuth => 'Tippen zur Authentifizierung';

  @override
  String get themeMode => 'Themen-Modus';

  @override
  String get thinking => 'Denkt nach';

  @override
  String get timeout => 'Zeitüberschreitung';

  @override
  String get undo => 'Rückgängig';

  @override
  String get unknown => 'Unbekannt';

  @override
  String get unsupported => 'Nicht unterstützt';

  @override
  String get update => 'Aktualisieren';

  @override
  String get upload => 'Hochladen';

  @override
  String get user => 'Benutzer';

  @override
  String get value => 'Wert';

  @override
  String versionHasUpdate(Object build) {
    return 'Gefunden: v1.0.$build, klicke zum Aktualisieren';
  }

  @override
  String versionUnknownUpdate(Object build) {
    return 'Aktuelle Version: v1.0.$build. Tippen, um nach Updates zu suchen';
  }

  @override
  String versionUpdated(Object build) {
    return 'v1.0.$build ist bereits die aktuellste Version';
  }

  @override
  String get yesterday => 'Gestern';

  @override
  String get addr => 'Adresse';

  @override
  String get available => 'Verfügbar';

  @override
  String get convert => 'Konvertieren';

  @override
  String get experimentalFeature => 'Experimentelle Funktion';

  @override
  String get foregroundService => 'Vordergrunddienst';

  @override
  String get goto => 'Gehe zu';

  @override
  String get invalid => 'Ungültig';

  @override
  String get valid => 'Gültig';

  @override
  String get max => 'Maximum';

  @override
  String get min => 'Minimum';

  @override
  String get more => 'Mehr';

  @override
  String get milliseconds => 'Millisekunden';

  @override
  String get permission => 'Berechtigung';

  @override
  String get read => 'Lesen';

  @override
  String get write => 'Schreiben';

  @override
  String get done => 'Fertig';

  @override
  String get speed => 'Geschwindigkeit';

  @override
  String get stat => 'Statistiken';

  @override
  String get time => 'Zeit';

  @override
  String get times => 'Mal';

  @override
  String get used => 'Verwendet';

  @override
  String get view => 'Anzeigen';
}
