// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'lib_l10n.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class LibLocalizationsPt extends LibLocalizations {
  LibLocalizationsPt([String locale = 'pt']) : super(locale);

  @override
  String get about => 'Sobre';

  @override
  String actionAndAction(Object action1, Object action2) {
    return '$action1 e depois $action2?';
  }

  @override
  String get add => 'Adicionar';

  @override
  String get all => 'Todos';

  @override
  String get anonLoseDataTip =>
      'Atualmente conectado anonimamente, continuar as operações resultará em perda de dados.';

  @override
  String get app => 'Aplicação';

  @override
  String askContinue(Object msg) {
    return '$msg, continuar?';
  }

  @override
  String get attention => 'Atenção';

  @override
  String get authRequired => 'Autenticação necessária';

  @override
  String get auto => 'Auto';

  @override
  String get background => 'Plano de Fundo';

  @override
  String get backup => 'Backup';

  @override
  String get bioAuth => 'Autenticação biométrica';

  @override
  String get blurRadius => 'Raio de Desfoque';

  @override
  String get bright => 'Claro';

  @override
  String get cancel => 'Cancelar';

  @override
  String get checkUpdate => 'Verificar atualizações';

  @override
  String get clear => 'Limpar';

  @override
  String get click => 'Clique';

  @override
  String get clipboard => 'Área de transferência';

  @override
  String get close => 'Fechar';

  @override
  String get content => 'Conteúdo';

  @override
  String get copy => 'Copiar';

  @override
  String get custom => 'Personalizado';

  @override
  String get cut => 'Cortar';

  @override
  String get dark => 'Escuro';

  @override
  String get day => 'Dias';

  @override
  String delFmt(Object id, Object type) {
    return 'Excluir $type ($id)?';
  }

  @override
  String get delay => 'Atraso';

  @override
  String get delete => 'Excluir';

  @override
  String get device => 'Dispositivo';

  @override
  String get disabled => 'Desativado';

  @override
  String get doc => 'Documentação';

  @override
  String get dontShowAgain => 'Não mostrar novamente';

  @override
  String get download => 'Baixar';

  @override
  String get duration => 'Duração';

  @override
  String get edit => 'Editar';

  @override
  String get editor => 'Editor';

  @override
  String get empty => 'Vazio';

  @override
  String get error => 'Erro';

  @override
  String get example => 'Exemplo';

  @override
  String get execute => 'Executar';

  @override
  String get exit => 'Sair';

  @override
  String get exitConfirmTip => 'Pressione voltar novamente para sair';

  @override
  String get exitDirectly => 'Sair diretamente';

  @override
  String get export => 'Exportar';

  @override
  String get fail => 'Falha';

  @override
  String get feedback => 'Feedback';

  @override
  String get file => 'Arquivo';

  @override
  String get fold => 'Dobrar';

  @override
  String get folder => 'Pasta';

  @override
  String get font => 'Fonte';

  @override
  String get found => 'Encontrado';

  @override
  String get hideTitleBar => 'Ocultar barra de título';

  @override
  String get hour => 'Horas';

  @override
  String get image => 'Imagem';

  @override
  String get import => 'Importar';

  @override
  String get init => 'Inicializar';

  @override
  String get key => 'Chave';

  @override
  String get language => 'Idioma';

  @override
  String get license => 'Licença';

  @override
  String get log => 'Log';

  @override
  String get login => 'Entrar';

  @override
  String get loginTip => 'Sem necessidade de registro, uso gratuito.';

  @override
  String get logout => 'Sair';

  @override
  String get manual => 'Manual';

  @override
  String get migrateCfg => 'Migração de configuração';

  @override
  String get migrateCfgTip => 'Para se adaptar à nova configuração necessária';

  @override
  String get minute => 'Minutos';

  @override
  String get moveDown => 'Descer';

  @override
  String get moveUp => 'Subir';

  @override
  String get name => 'Nome';

  @override
  String get network => 'Rede';

  @override
  String get next => 'Próximo';

  @override
  String notExistFmt(Object file) {
    return '$file não existe';
  }

  @override
  String get note => 'Nota';

  @override
  String get ok => 'Ok';

  @override
  String get opacity => 'Opacidade';

  @override
  String get open => 'Abrir';

  @override
  String get paste => 'Colar';

  @override
  String get path => 'Caminho';

  @override
  String get preview => 'Visualização';

  @override
  String get previous => 'Anterior';

  @override
  String get primaryColorSeed => 'Semente da cor primária';

  @override
  String get pwd => 'Senha';

  @override
  String get pwdTip =>
      'Comprimento de 6 a 32, pode conter letras em inglês, números e pontuação';

  @override
  String get redo => 'Refazer';

  @override
  String get refresh => 'Atualizar';

  @override
  String get register => 'Cadastrar';

  @override
  String get rename => 'Renomear';

  @override
  String get replace => 'Substituir';

  @override
  String get replaceAll => 'Substituir tudo';

  @override
  String get reset => 'Redefinir';

  @override
  String get restore => 'Restaurar';

  @override
  String get result => 'Resultado';

  @override
  String get retry => 'Tentar novamente';

  @override
  String get save => 'Salvar';

  @override
  String get search => 'Pesquisar';

  @override
  String get second => 'Segundos';

  @override
  String get select => 'Selecionar';

  @override
  String get setting => 'Configurações';

  @override
  String get share => 'Compartilhar';

  @override
  String get size => 'Tamanho';

  @override
  String sizeTooLargeOnlyPrefix(Object bytes) {
    return 'Conteúdo muito grande, exibindo apenas os primeiros $bytes';
  }

  @override
  String get start => 'Iniciar';

  @override
  String get stop => 'Parar';

  @override
  String get success => 'Sucesso';

  @override
  String get switch_ => 'Interruptor';

  @override
  String get switcher => 'Comutador';

  @override
  String get sync => 'Sincronizar';

  @override
  String get system => 'Sistema';

  @override
  String get tag => 'Etiqueta';

  @override
  String get tapToAuth => 'Clique para verificar';

  @override
  String get themeMode => 'Modo do tema';

  @override
  String get thinking => 'Pensando';

  @override
  String get timeout => 'Timeout';

  @override
  String get undo => 'Desfazer';

  @override
  String get unknown => 'Desconhecido';

  @override
  String get unsupported => 'Não suportado';

  @override
  String get update => 'Atualizar';

  @override
  String get upload => 'Enviar';

  @override
  String get user => 'Usuário';

  @override
  String get value => 'Valor';

  @override
  String versionHasUpdate(Object build) {
    return 'Nova versão encontrada: v1.0.$build, clique para atualizar';
  }

  @override
  String versionUnknownUpdate(Object build) {
    return 'Versão atual: v1.0.$build, clique para verificar atualizações';
  }

  @override
  String versionUpdated(Object build) {
    return 'Versão atual: v1.0.$build, já está atualizado';
  }

  @override
  String get yesterday => 'Ontem';

  @override
  String get addr => 'Endereço';

  @override
  String get available => 'Disponível';

  @override
  String get convert => 'Converter';

  @override
  String get experimentalFeature => 'Recurso experimental';

  @override
  String get foregroundService => 'Serviço em primeiro plano';

  @override
  String get goto => 'Ir para';

  @override
  String get invalid => 'Inválido';

  @override
  String get valid => 'Válido';

  @override
  String get max => 'Máximo';

  @override
  String get min => 'Mínimo';

  @override
  String get more => 'Mais';

  @override
  String get milliseconds => 'Milissegundos';

  @override
  String get permission => 'Permissão';

  @override
  String get read => 'Ler';

  @override
  String get write => 'Escrever';

  @override
  String get done => 'Concluído';

  @override
  String get speed => 'Velocidade';

  @override
  String get stat => 'Estatísticas';

  @override
  String get time => 'Tempo';

  @override
  String get times => 'Vezes';

  @override
  String get used => 'Usado';

  @override
  String get view => 'Ver';
}
