/* Copyright 2018 Conny Duck
 *
 * This file is a part of Tusky.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * Tusky is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with Tusky; if not,
 * see <http://www.gnu.org/licenses>. */

package com.keylesspalace.tusky.components.instance.data.database

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import com.keylesspalace.tusky.components.instance.data.models.entity.InstanceEntity
import io.reactivex.Single

@Dao
interface InstanceDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertOrReplace(instance: InstanceEntity)

    // TODO: Merge both methods in one not returning a Single
    @Query("SELECT * FROM InstanceEntity WHERE instance = :instance LIMIT 1")
    fun loadMetadataForInstance(instance: String): Single<InstanceEntity>

    @Query("SELECT * FROM InstanceEntity WHERE instance = :instance LIMIT 1")
    fun loadFromCache(instance: String): InstanceEntity
}
