/*
 *   Copyright 2019 Jeffrey Liu (scubajeffrey@protonmail.ch)
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package site.leos.apps.lespas.gpx

object TimezoneMapper {
    fun latLngToTimezoneString(lat: Double, lng: Double): String {
        return timezoneStrings[getTzInt(lat.toFloat(), lng.toFloat())]
    }

    var timezoneStrings = arrayOf(
        "unknown",
        "Africa/Abidjan",
        "Africa/Accra",
        "Africa/Addis_Ababa",
        "Africa/Algiers",
        "Africa/Asmara",
        "Africa/Bamako",
        "Africa/Bangui",
        "Africa/Banjul",
        "Africa/Bissau",
        "Africa/Blantyre",
        "Africa/Brazzaville",
        "Africa/Bujumbura",
        "Africa/Cairo",
        "Africa/Casablanca",
        "Africa/Ceuta",
        "Africa/Conakry",
        "Africa/Dakar",
        "Africa/Dar_es_Salaam",
        "Africa/Djibouti",
        "Africa/Douala",
        "Africa/El_Aaiun",
        "Africa/Freetown",
        "Africa/Gaborone",
        "Africa/Harare",
        "Africa/Johannesburg",
        "Africa/Juba",
        "Africa/Kampala",
        "Africa/Khartoum",
        "Africa/Kigali",
        "Africa/Kinshasa",
        "Africa/Lagos",
        "Africa/Libreville",
        "Africa/Lome",
        "Africa/Luanda",
        "Africa/Lubumbashi",
        "Africa/Lusaka",
        "Africa/Malabo",
        "Africa/Maputo",
        "Africa/Maseru",
        "Africa/Mbabane",
        "Africa/Mogadishu",
        "Africa/Monrovia",
        "Africa/Nairobi",
        "Africa/Ndjamena",
        "Africa/Niamey",
        "Africa/Nouakchott",
        "Africa/Ouagadougou",
        "Africa/Porto-Novo",
        "Africa/Sao_Tome",
        "Africa/Tripoli",
        "Africa/Tunis",
        "Africa/Windhoek",
        "America/Adak",
        "America/Anchorage",
        "America/Anguilla",
        "America/Antigua",
        "America/Aruba",
        "America/Araguaina",
        "America/Argentina/Buenos_Aires",
        "America/Argentina/Catamarca",
        "America/Argentina/Cordoba",
        "America/Argentina/Jujuy",
        "America/Argentina/La_Rioja",
        "America/Argentina/Mendoza",
        "America/Argentina/Rio_Gallegos",
        "America/Argentina/Salta",
        "America/Argentina/San_Juan",
        "America/Argentina/San_Luis",
        "America/Argentina/Tucuman",
        "America/Argentina/Ushuaia",
        "America/Asuncion",
        "America/Atikokan",
        "America/Bahia",
        "America/Bahia_Banderas",
        "America/Barbados",
        "America/Belem",
        "America/Belize",
        "America/Blanc-Sablon",
        "America/Boa_Vista",
        "America/Bogota",
        "America/Boise",
        "America/Cambridge_Bay",
        "America/Campo_Grande",
        "America/Cancun",
        "America/Caracas",
        "America/Cayenne",
        "America/Cayman",
        "America/Chicago",
        "America/Chihuahua",
        "America/Costa_Rica",
        "America/Creston",
        "America/Cuiaba",
        "America/Curacao",
        "America/Danmarkshavn",
        "America/Dawson",
        "America/Dawson_Creek",
        "America/Denver",
        "America/Detroit",
        "America/Dominica",
        "America/Edmonton",
        "America/Eirunepe",
        "America/El_Salvador",
        "America/Fort_Nelson",
        "America/Fortaleza",
        "America/Glace_Bay",
        "America/Godthab",
        "America/Goose_Bay",
        "America/Grand_Turk",
        "America/Grenada",
        "America/Guadeloupe",
        "America/Guatemala",
        "America/Guayaquil",
        "America/Guyana",
        "America/Halifax",
        "America/Havana",
        "America/Hermosillo",
        "America/Indiana/Indianapolis",
        "America/Indiana/Knox",
        "America/Indiana/Marengo",
        "America/Indiana/Petersburg",
        "America/Indiana/Tell_City",
        "America/Indiana/Vevay",
        "America/Indiana/Vincennes",
        "America/Indiana/Winamac",
        "America/Inuvik",
        "America/Iqaluit",
        "America/Jamaica",
        "America/Juneau",
        "America/Kentucky/Louisville",
        "America/Kentucky/Monticello",
        "America/Kralendijk",
        "America/La_Paz",
        "America/Lima",
        "America/Los_Angeles",
        "America/Lower_Princes",
        "America/Maceio",
        "America/Managua",
        "America/Manaus",
        "America/Marigot",
        "America/Martinique",
        "America/Matamoros",
        "America/Mazatlan",
        "America/Miquelon",
        "America/Menominee",
        "America/Merida",
        "America/Metlakatla",
        "America/Mexico_City",
        "America/Moncton",
        "America/Monterrey",
        "America/Montevideo",
        "America/Montserrat",
        "America/Nassau",
        "America/New_York",
        "America/Nipigon",
        "America/Nome",
        "America/Noronha",
        "America/North_Dakota/Beulah",
        "America/North_Dakota/Center",
        "America/North_Dakota/New_Salem",
        "America/Ojinaga",
        "America/Panama",
        "America/Pangnirtung",
        "America/Paramaribo",
        "America/Phoenix",
        "America/Port-au-Prince",
        "America/Port_of_Spain",
        "America/Porto_Velho",
        "America/Puerto_Rico",
        "America/Punta_Arenas",
        "America/Rainy_River",
        "America/Rankin_Inlet",
        "America/Recife",
        "America/Regina",
        "America/Resolute",
        "America/Rio_Branco",
        "America/Santarem",
        "America/Santiago",
        "America/Santo_Domingo",
        "America/Sao_Paulo",
        "America/Scoresbysund",
        "America/Sitka",
        "America/St_Barthelemy",
        "America/St_Johns",
        "America/St_Kitts",
        "America/St_Lucia",
        "America/St_Thomas",
        "America/St_Vincent",
        "America/Swift_Current",
        "America/Tegucigalpa",
        "America/Thule",
        "America/Thunder_Bay",
        "America/Tijuana",
        "America/Toronto",
        "America/Tortola",
        "America/Vancouver",
        "America/Whitehorse",
        "America/Winnipeg",
        "America/Yakutat",
        "America/Yellowknife",
        "Antarctica/Casey",
        "Antarctica/Davis",
        "Antarctica/DumontDUrville",
        "Antarctica/Macquarie",
        "Antarctica/Mawson",
        "Antarctica/McMurdo",
        "Antarctica/Palmer",
        "Antarctica/Rothera",
        "Antarctica/Syowa",
        "Antarctica/Troll",
        "Antarctica/Vostok",
        "Arctic/Longyearbyen",
        "Asia/Aden",
        "Asia/Almaty",
        "Asia/Amman",
        "Asia/Anadyr",
        "Asia/Aqtau",
        "Asia/Aqtobe",
        "Asia/Ashgabat",
        "Asia/Atyrau",
        "Asia/Baghdad",
        "Asia/Bahrain",
        "Asia/Baku",
        "Asia/Bangkok",
        "Asia/Barnaul",
        "Asia/Beirut",
        "Asia/Bishkek",
        "Asia/Brunei",
        "Asia/Chita",
        "Asia/Choibalsan",
        "Asia/Colombo",
        "Asia/Damascus",
        "Asia/Dhaka",
        "Asia/Dili",
        "Asia/Dubai",
        "Asia/Dushanbe",
        "Asia/Famagusta",
        "Asia/Gaza",
        "Asia/Hebron",
        "Asia/Ho_Chi_Minh",
        "Asia/Hong_Kong",
        "Asia/Hovd",
        "Asia/Irkutsk",
        "Asia/Jakarta",
        "Asia/Jayapura",
        "Asia/Jerusalem",
        "Asia/Kabul",
        "Asia/Kamchatka",
        "Asia/Karachi",
        "Asia/Kathmandu",
        "Asia/Khandyga",
        "Asia/Kolkata",
        "Asia/Krasnoyarsk",
        "Asia/Kuala_Lumpur",
        "Asia/Kuching",
        "Asia/Kuwait",
        "Asia/Macau",
        "Asia/Magadan",
        "Asia/Makassar",
        "Asia/Manila",
        "Asia/Muscat",
        "Asia/Nicosia",
        "Asia/Novokuznetsk",
        "Asia/Novosibirsk",
        "Asia/Omsk",
        "Asia/Oral",
        "Asia/Phnom_Penh",
        "Asia/Pontianak",
        "Asia/Pyongyang",
        "Asia/Qatar",
        "Asia/Qostanay",
        "Asia/Qyzylorda",
        "Asia/Riyadh",
        "Asia/Samarkand",
        "Asia/Sakhalin",
        "Asia/Seoul",
        "Asia/Shanghai",
        "Asia/Singapore",
        "Asia/Srednekolymsk",
        "Asia/Taipei",
        "Asia/Tashkent",
        "Asia/Tbilisi",
        "Asia/Tehran",
        "Asia/Thimphu",
        "Asia/Tokyo",
        "Asia/Tomsk",
        "Asia/Ulaanbaatar",
        "Asia/Shanghai",
        "Asia/Ust-Nera",
        "Asia/Vientiane",
        "Asia/Vladivostok",
        "Asia/Yakutsk",
        "Asia/Yangon",
        "Asia/Yekaterinburg",
        "Asia/Yerevan",
        "Atlantic/Azores",
        "Atlantic/Bermuda",
        "Atlantic/Canary",
        "Atlantic/Cape_Verde",
        "Atlantic/Faroe",
        "Atlantic/Madeira",
        "Atlantic/Reykjavik",
        "Atlantic/South_Georgia",
        "Atlantic/St_Helena",
        "Atlantic/Stanley",
        "Australia/Adelaide",
        "Australia/Brisbane",
        "Australia/Broken_Hill",
        "Australia/Currie",
        "Australia/Darwin",
        "Australia/Eucla",
        "Australia/Hobart",
        "Australia/Lindeman",
        "Australia/Lord_Howe",
        "Australia/Melbourne",
        "Australia/Perth",
        "Australia/Sydney",
        "Etc/UTC",
        "Europe/Amsterdam",
        "Europe/Andorra",
        "Europe/Astrakhan",
        "Europe/Athens",
        "Europe/Belgrade",
        "Europe/Berlin",
        "Europe/Bratislava",
        "Europe/Brussels",
        "Europe/Bucharest",
        "Europe/Budapest",
        "Europe/Busingen",
        "Europe/Chisinau",
        "Europe/Copenhagen",
        "Europe/Dublin",
        "Europe/Gibraltar",
        "Europe/Guernsey",
        "Europe/Helsinki",
        "Europe/Isle_of_Man",
        "Europe/Istanbul",
        "Europe/Jersey",
        "Europe/Kaliningrad",
        "Europe/Kiev",
        "Europe/Kirov",
        "Europe/Lisbon",
        "Europe/Ljubljana",
        "Europe/London",
        "Europe/Luxembourg",
        "Europe/Madrid",
        "Europe/Malta",
        "Europe/Mariehamn",
        "Europe/Minsk",
        "Europe/Monaco",
        "Europe/Moscow",
        "Europe/Oslo",
        "Europe/Paris",
        "Europe/Podgorica",
        "Europe/Prague",
        "Europe/Riga",
        "Europe/Rome",
        "Europe/Samara",
        "Europe/San_Marino",
        "Europe/Sarajevo",
        "Europe/Saratov",
        "Europe/Simferopol",
        "Europe/Skopje",
        "Europe/Sofia",
        "Europe/Stockholm",
        "Europe/Tallinn",
        "Europe/Tirane",
        "Europe/Ulyanovsk",
        "Europe/Uzhgorod",
        "Europe/Vaduz",
        "Europe/Vatican",
        "Europe/Vienna",
        "Europe/Vilnius",
        "Europe/Volgograd",
        "Europe/Warsaw",
        "Europe/Zagreb",
        "Europe/Zaporozhye",
        "Europe/Zurich",
        "Indian/Antananarivo",
        "Indian/Chagos",
        "Indian/Christmas",
        "Indian/Cocos",
        "Indian/Comoro",
        "Indian/Kerguelen",
        "Indian/Mahe",
        "Indian/Maldives",
        "Indian/Mauritius",
        "Indian/Mayotte",
        "Indian/Reunion",
        "Pacific/Apia",
        "Pacific/Auckland",
        "Pacific/Bougainville",
        "Pacific/Chatham",
        "Pacific/Chuuk",
        "Pacific/Easter",
        "Pacific/Efate",
        "Pacific/Enderbury",
        "Pacific/Fakaofo",
        "Pacific/Fiji",
        "Pacific/Funafuti",
        "Pacific/Galapagos",
        "Pacific/Gambier",
        "Pacific/Guadalcanal",
        "Pacific/Guam",
        "Pacific/Honolulu",
        "Pacific/Kiritimati",
        "Pacific/Kosrae",
        "Pacific/Kwajalein",
        "Pacific/Majuro",
        "Pacific/Marquesas",
        "Pacific/Midway",
        "Pacific/Nauru",
        "Pacific/Niue",
        "Pacific/Norfolk",
        "Pacific/Noumea",
        "Pacific/Pago_Pago",
        "Pacific/Palau",
        "Pacific/Pitcairn",
        "Pacific/Pohnpei",
        "Pacific/Port_Moresby",
        "Pacific/Rarotonga",
        "Pacific/Saipan",
        "Pacific/Tahiti",
        "Pacific/Tarawa",
        "Pacific/Tongatapu",
        "Pacific/Wake",
        "Pacific/Wallis"
    )

    private fun getTzInt(lat: Float, lng: Float): Int {
        return if (lng < 40.227580f) if (lng < -74.790449f) if (lat < 11.948729f) if (lng < -148.915052f) if (lat < -15.365572f) if (lng < -162.907168f) if (lat < -22.132469f) if (lat < -31.152578f) if (lat < -75.000000f) 205 else if (lat < -37.433796f) 390 else 392 else if (lat < -29.030330f) 390 else 424 else if (lat < -18.370291f) if (lat < -19.391686f) if (lng < -178.018393f) 398 else 424 else if (lng < -174.409124f) if (lng < -176.450182f) 398 else 424 else if (lng < -171.934489f) 412 else 424 else if (lng < -175.393670f) if (lng < -176.944457f) 398 else 424 else if (lng < -173.529546f) 424 else 420 else if (lat < -18.624323f) if (lat < -21.595903f) if (lat < -23.126466f) if (lat < -49.301828f) 205 else 422 else if (lng < -157.667741f) 420 else 422 else 420 else 422 else if (lng < -170.339391f) if (lat < -8.332863f) if (lat < -12.982796f) if (lng < -175.919039f) 426 else if (lng < -171.122917f) 389 else 415 else if (lng < -172.263966f) if (lat < -9.006964f) 397 else 399 else if (lat < -10.844975f) 415 else 397 else 396 else if (lat < -8.716879f) if (lng < -162.837703f) if (lng < -169.212472f) 415 else 420 else if (lng < -157.674746f) 420 else if (lng < -149.992536f) 405 else 422 else 405 else if (lat < -19.605166f) if (lat < -24.280320f) if (lat < -33.406000f) if (lat < -48.582229f) if (lat < -66.000000f) {
            if (poly[0]!!.contains(lat, lng)) 207 else 205
        } else if (lng < -74.972849f) {
            if (poly[1]!!.contains(lat, lng)) 177 else 169
        } else {
            if (poly[2]!!.contains(lat, lng)) 177 else 169
        } else 177 else if (lat < -26.087000f) if (lng < -143.258327f) 422 else if (lat < -26.702500f) 177 else 394 else 417 else if (lng < -138.293890f) 422 else if (lng < -134.244799f) 401 else 417 else if (lng < -140.967399f) 422 else if (lng < -138.120374f) if (lat < -14.596066f) 422 else 409 else if (lng < -86.850836f) if (lng < -136.083016f) 422 else if (lat < 3.608283f) 90 else 400 else if (lat < 4.215425f) if (lat < 1.469581f) if (lat < -8.981652f) 133 else if (lat < -3.756035f) if (lng < -79.713051f) {
            if (poly[3]!!.contains(lat, lng)) 112 else 133
        } else {
            if (poly[4]!!.contains(lat, lng)) 112 else 133
        } else if (lng < -79.655334f) {
            if (poly[5]!!.contains(lat, lng)) 133 else 112
        } else if (lat < -1.143227f) {
            if (poly[6]!!.contains(lat, lng)) 133 else 112
        } else if (lng < -77.222892f) {
            if (poly[7]!!.contains(lat, lng)) 80 else 112
        } else if (lat < 0.163177f) if (lng < -76.006670f) 112 else if (lat < -0.490025f) {
            if (poly[8]!!.contains(lat, lng)) 133 else 112
        } else {
            if (poly[9]!!.contains(lat, lng)) return 80
            if (poly[10]!!.contains(lat, lng)) 133 else 112
        } else {
            if (poly[11]!!.contains(lat, lng)) 112 else 80
        } else 80 else if (lng < -83.545675f) {
            if (poly[12]!!.contains(lat, lng)) 137 else 90
        } else if (lng < -82.506021f) {
            if (poly[13]!!.contains(lat, lng)) 161 else 90
        } else if (lng < -78.648235f) 161 else if (lat < 7.779632f) {
            if (poly[14]!!.contains(lat, lng)) 161 else 80
        } else {
            if (poly[15]!!.contains(lat, lng)) 161 else 80
        } else call5(lat, lng) else if (lat < 27.433543f) if (lng < -34.628225f) call18(lat, lng) else call19(lat, lng) else if (lng < 4.940364f) call25(lat, lng) else call26(
            lat,
            lng
        ) else if (lat < 6.459000f) if (lat < -13.507685f) call28(lat, lng) else if (lng < 137.031744f) if (lng < 79.769537f) if (lng < 51.396615f) if (lat < -9.003195f) if (lng < 45.507035f) if (lng < 40.934512f) {
            if (poly[16]!!.contains(lat, lng)) 18 else 38
        } else {
            if (poly[17]!!.contains(lat, lng)) 387 else 382
        } else if (lat < -11.732889f) 378 else 384 else if (lat < 1.448202f) {
            if (poly[18]!!.contains(lat, lng)) 43 else 41
        } else if (lng < 44.770743f) {
            if (poly[19]!!.contains(lat, lng)) return 41
            if (poly[20]!!.contains(lat, lng)) 43 else 3
        } else {
            if (poly[21]!!.contains(lat, lng)) 3 else 41
        } else if (lng < 56.153431f) 384 else if (lat < -6.892368f) if (lng < 56.907685f) if (lat < -8.768959f) 384 else 386 else 379 else if (lat < -5.037066f) 379 else 385 else call27(
            lat,
            lng
        ) else if (lng < 158.980861f) if (lat < -9.690684f) if (lng < 144.157024f) 306 else 419 else if (lng < 143.966337f) if (lat < -9.484383f) 306 else if (lng < 142.851886f) if (lng < 141.647501f) if (lat < -9.445798f) 306 else {
            if (poly[22]!!.contains(lat, lng)) 419 else 244
        } else if (lng < 142.345755f) {
            if (poly[23]!!.contains(lat, lng)) 306 else 419
        } else {
            if (poly[24]!!.contains(lat, lng)) 306 else 419
        } else if (lng < 143.653847f) if (lng < 143.338933f) {
            if (poly[25]!!.contains(lat, lng)) 306 else 419
        } else if (lat < -9.389158f) 306 else 419 else if (lat < -9.088012f) 306 else 419 else if (lat < -0.557358f) if (lng < 144.296103f) if (lat < -9.305249f) 306 else 419 else if (lng < 154.622311f) {
            if (poly[26]!!.contains(lat, lng)) 391 else 419
        } else if (lat < -6.377546f) {
            if (poly[27]!!.contains(lat, lng)) 391 else 402
        } else 391 else if (lng < 154.023397f) 393 else 418 else if (lat < -4.810850f) if (lng < 169.050657f) if (lat < -12.871378f) if (lng < 163.592134f) 395 else 402 else 402 else if (lat < -11.406307f) if (lng < 170.396467f) 402 else 398 else 399 else if (lng < 172.373701f) if (lng < 168.336144f) if (lng < 160.917151f) if (lat < 0.877112f) 391 else 418 else if (lng < 163.236405f) 406 else if (lat < 2.544000f) 408 else 411 else if (lat < -0.645000f) 423 else 408 else 423 else if (lng < 115.212170f) if (lat < 28.246987f) call43(
            lat,
            lng
        ) else if (lng < 69.957225f) if (lat < 43.586429f) if (lng < 51.009030f) call32(lat, lng) else call33(lat, lng) else if (lat < 54.891446f) call36(
            lat,
            lng
        ) else if (lat < 55.442170f) if (lng < 53.915395f) {
            if (poly[28]!!.contains(lat, lng)) 293 else 350
        } else if (lng < 59.172064f) {
            if (poly[29]!!.contains(lat, lng)) 350 else 293
        } else {
            if (poly[30]!!.contains(lat, lng)) 293 else 213
        } else if (lat < 73.603159f) call35(lat, lng) else 350 else call42(lat, lng) else call46(lat, lng)
    }

    private fun call0(lat: Float, lng: Float): Int {
        return if (lat < 31.541963f) if (lng < -105.630949f) if (lat < 28.333599f) if (lng < -107.815375f) if (lat < 26.729418f) {
            if (poly[31]!!.contains(lat, lng)) return 89
            if (poly[32]!!.contains(lat, lng)) 116 else 142
        } else if (lng < -108.907589f) {
            if (poly[33]!!.contains(lat, lng)) return 89
            if (poly[34]!!.contains(lat, lng)) 89 else 116
        } else if (lat < 27.531508f) {
            if (poly[35]!!.contains(lat, lng)) return 116
            if (poly[36]!!.contains(lat, lng)) 142 else 89
        } else {
            if (poly[37]!!.contains(lat, lng)) return 116
            if (poly[38]!!.contains(lat, lng)) return 116
            if (poly[39]!!.contains(lat, lng)) return 116
            if (poly[40]!!.contains(lat, lng)) 116 else 89
        } else if (lat < 26.729418f) if (lng < -106.723162f) {
            if (poly[41]!!.contains(lat, lng)) return 89
            if (poly[42]!!.contains(lat, lng)) 149 else 142
        } else {
            if (poly[43]!!.contains(lat, lng)) 149 else 89
        } else {
            if (poly[44]!!.contains(lat, lng)) 149 else 89
        } else if (lng < -107.815375f) if (lat < 29.937781f) {
            if (poly[45]!!.contains(lat, lng)) 116 else 89
        } else if (lng < -108.907589f) {
            if (poly[46]!!.contains(lat, lng)) return 97
            if (poly[47]!!.contains(lat, lng)) return 160
            if (poly[48]!!.contains(lat, lng)) 164 else 116
        } else if (lat < 30.739872f) {
            if (poly[49]!!.contains(lat, lng)) return 89
            if (poly[50]!!.contains(lat, lng)) 116 else 160
        } else {
            if (poly[51]!!.contains(lat, lng)) return 89
            if (poly[52]!!.contains(lat, lng)) return 97
            if (poly[53]!!.contains(lat, lng)) 116 else 160
        } else if (lat < 29.937781f) {
            if (poly[54]!!.contains(lat, lng)) 160 else 89
        } else if (lng < -106.723162f) {
            if (poly[55]!!.contains(lat, lng)) 160 else 89
        } else {
            if (poly[56]!!.contains(lat, lng)) return 89
            if (poly[57]!!.contains(lat, lng)) 97 else 160
        } else if (lat < 28.333599f) if (lng < -103.446522f) if (lat < 26.729418f) {
            if (poly[58]!!.contains(lat, lng)) return 89
            if (poly[59]!!.contains(lat, lng)) 89 else 149
        } else if (lng < -104.538735f) 89 else if (lat < 27.531508f) {
            if (poly[60]!!.contains(lat, lng)) return 89
            if (poly[61]!!.contains(lat, lng)) return 141
            if (poly[62]!!.contains(lat, lng)) 141 else 149
        } else {
            if (poly[63]!!.contains(lat, lng)) return 89
            if (poly[64]!!.contains(lat, lng)) return 141
            if (poly[65]!!.contains(lat, lng)) 141 else 149
        } else if (lat < 26.729418f) 149 else if (lng < -102.354308f) {
            if (poly[66]!!.contains(lat, lng)) 141 else 149
        } else {
            if (poly[67]!!.contains(lat, lng)) return 141
            if (poly[68]!!.contains(lat, lng)) 141 else 149
        } else if (lng < -103.446522f) if (lat < 29.937781f) if (lng < -104.538735f) {
            if (poly[69]!!.contains(lat, lng)) return 88
            if (poly[70]!!.contains(lat, lng)) 89 else 160
        } else if (lat < 29.135690f) if (lng < -103.992628f) {
            if (poly[71]!!.contains(lat, lng)) 160 else 89
        } else {
            if (poly[72]!!.contains(lat, lng)) return 88
            if (poly[73]!!.contains(lat, lng)) return 89
            if (poly[74]!!.contains(lat, lng)) return 141
            if (poly[75]!!.contains(lat, lng)) return 141
            if (poly[76]!!.contains(lat, lng)) 149 else 160
        } else {
            if (poly[77]!!.contains(lat, lng)) 160 else 88
        } else {
            if (poly[78]!!.contains(lat, lng)) return 88
            if (poly[79]!!.contains(lat, lng)) return 89
            if (poly[80]!!.contains(lat, lng)) return 89
            if (poly[81]!!.contains(lat, lng)) 97 else 160
        } else if (lat < 29.937781f) if (lng < -102.354308f) if (lat < 29.135690f) {
            if (poly[82]!!.contains(lat, lng)) return 88
            if (poly[83]!!.contains(lat, lng)) return 149
            if (poly[84]!!.contains(lat, lng)) return 149
            if (poly[85]!!.contains(lat, lng)) 160 else 141
        } else {
            if (poly[86]!!.contains(lat, lng)) 141 else 88
        } else {
            if (poly[87]!!.contains(lat, lng)) return 88
            if (poly[88]!!.contains(lat, lng)) 149 else 141
        } else 88 else {
            if (poly[89]!!.contains(lat, lng)) return 88
            if (poly[90]!!.contains(lat, lng)) return 160
            if (poly[91]!!.contains(lat, lng)) 164 else 97
        }
    }

    private fun call1(lat: Float, lng: Float): Int {
        return if (lng < -109.999802f) if (lat < 19.534042f) 147 else if (lat < 32.494077f) if (lat < 28.000000f) if (lng < -115.528715f) 142 else {
            if (poly[92]!!.contains(lat, lng)) 116 else 142
        } else if (lng < -117.990989f) 192 else {
            if (poly[93]!!.contains(lat, lng)) return 116
            if (poly[94]!!.contains(lat, lng)) 164 else 192
        } else if (lng < -111.320808f) if (lng < -117.338623f) {
            if (poly[95]!!.contains(lat, lng)) 192 else 134
        } else if (lng < -114.329716f) if (lat < 35.226383f) if (lng < -115.834170f) {
            if (poly[96]!!.contains(lat, lng)) 192 else 134
        } else if (lat < 33.860230f) {
            if (poly[97]!!.contains(lat, lng)) return 134
            if (poly[98]!!.contains(lat, lng)) 192 else 164
        } else {
            if (poly[99]!!.contains(lat, lng)) return 164
            if (poly[100]!!.contains(lat, lng)) 164 else 134
        } else {
            if (poly[101]!!.contains(lat, lng)) 164 else 134
        } else if (lat < 35.226383f) {
            if (poly[102]!!.contains(lat, lng)) 134 else 164
        } else if (lng < -112.825262f) {
            if (poly[103]!!.contains(lat, lng)) return 97
            if (poly[104]!!.contains(lat, lng)) 134 else 164
        } else {
            if (poly[105]!!.contains(lat, lng)) 164 else 97
        } else if (lat < 36.430649f) {
            if (poly[106]!!.contains(lat, lng)) return 97
            if (poly[107]!!.contains(lat, lng)) 97 else 164
        } else {
            if (poly[108]!!.contains(lat, lng)) 164 else 97
        } else if (lat < 25.125236f) if (lng < -102.295513f) if (lng < -109.196542f) 142 else if (lat < 21.436715f) if (lng < -104.519534f) if (lat < 20.163373f) 147 else {
            if (poly[109]!!.contains(lat, lng)) return 74
            if (poly[110]!!.contains(lat, lng)) 147 else 142
        } else {
            if (poly[111]!!.contains(lat, lng)) 142 else 147
        } else if (lng < -105.473049f) if (lat < 23.280975f) {
            if (poly[112]!!.contains(lat, lng)) 149 else 142
        } else if (lng < -107.061817f) {
            if (poly[113]!!.contains(lat, lng)) 149 else 142
        } else if (lat < 24.203106f) {
            if (poly[114]!!.contains(lat, lng)) 149 else 142
        } else {
            if (poly[115]!!.contains(lat, lng)) 142 else 149
        } else if (lat < 23.280975f) if (lng < -103.884281f) if (lat < 22.358845f) {
            if (poly[116]!!.contains(lat, lng)) return 147
            if (poly[117]!!.contains(lat, lng)) 149 else 142
        } else if (lng < -104.678665f) {
            if (poly[118]!!.contains(lat, lng)) 149 else 142
        } else {
            if (poly[119]!!.contains(lat, lng)) return 142
            if (poly[120]!!.contains(lat, lng)) return 142
            if (poly[121]!!.contains(lat, lng)) 147 else 149
        } else {
            if (poly[122]!!.contains(lat, lng)) 142 else 147
        } else if (lng < -103.884281f) {
            if (poly[123]!!.contains(lat, lng)) 147 else 149
        } else {
            if (poly[124]!!.contains(lat, lng)) 149 else 147
        } else if (lat < 19.829871f) 147 else if (lng < -99.252157f) if (lat < 22.477554f) {
            if (poly[125]!!.contains(lat, lng)) 149 else 147
        } else if (lng < -100.773835f) {
            if (poly[126]!!.contains(lat, lng)) 149 else 147
        } else if (lat < 23.801395f) if (lng < -100.012996f) {
            if (poly[127]!!.contains(lat, lng)) return 149
            if (poly[128]!!.contains(lat, lng)) 149 else 147
        } else {
            if (poly[129]!!.contains(lat, lng)) return 147
            if (poly[130]!!.contains(lat, lng)) 147 else 149
        } else {
            if (poly[131]!!.contains(lat, lng)) 147 else 149
        } else {
            if (poly[132]!!.contains(lat, lng)) return 141
            if (poly[133]!!.contains(lat, lng)) 149 else 147
        } else if (lng < -101.262095f) call0(lat, lng) else if (lat < 31.541963f) if (lng < -96.893242f) if (lat < 28.333599f) if (lng < -99.077668f) if (lat < 26.729418f) {
            if (poly[134]!!.contains(lat, lng)) return 88
            if (poly[135]!!.contains(lat, lng)) 149 else 141
        } else if (lng < -100.169882f) {
            if (poly[136]!!.contains(lat, lng)) return 88
            if (poly[137]!!.contains(lat, lng)) 149 else 141
        } else if (lat < 27.531508f) {
            if (poly[138]!!.contains(lat, lng)) return 88
            if (poly[139]!!.contains(lat, lng)) 149 else 141
        } else {
            if (poly[140]!!.contains(lat, lng)) 141 else 88
        } else if (lat < 26.729418f) if (lng < -97.999794f) if (lat < 25.927327f) {
            if (poly[141]!!.contains(lat, lng)) 141 else 149
        } else {
            if (poly[142]!!.contains(lat, lng)) return 88
            if (poly[143]!!.contains(lat, lng)) 149 else 141
        } else {
            if (poly[144]!!.contains(lat, lng)) return 88
            if (poly[145]!!.contains(lat, lng)) 149 else 141
        } else 88 else {
            if (poly[146]!!.contains(lat, lng)) return 88
            if (poly[147]!!.contains(lat, lng)) 149 else 141
        } else 88 else 88
    }

    private fun call2(lat: Float, lng: Float): Int {
        return if (lat < 53.016461f) if (lng < -111.043564f) if (lat < 46.037723f) if (lng < -117.975222f) {
            if (poly[148]!!.contains(lat, lng)) 81 else 134
        } else if (lat < 41.998206f) {
            if (poly[149]!!.contains(lat, lng)) return 81
            if (poly[150]!!.contains(lat, lng)) 97 else 134
        } else if (lng < -114.509393f) if (lat < 44.017964f) {
            if (poly[151]!!.contains(lat, lng)) 134 else 81
        } else if (lng < -116.242308f) if (lat < 45.027844f) {
            if (poly[152]!!.contains(lat, lng)) 134 else 81
        } else {
            if (poly[153]!!.contains(lat, lng)) 81 else 134
        } else {
            if (poly[154]!!.contains(lat, lng)) return 81
            if (poly[155]!!.contains(lat, lng)) return 97
            if (poly[156]!!.contains(lat, lng)) 97 else 134
        } else if (lat < 44.017964f) {
            if (poly[157]!!.contains(lat, lng)) 97 else 81
        } else if (lng < -112.776478f) if (lat < 45.027844f) {
            if (poly[158]!!.contains(lat, lng)) 97 else 81
        } else {
            if (poly[159]!!.contains(lat, lng)) return 81
            if (poly[160]!!.contains(lat, lng)) return 134
            if (poly[161]!!.contains(lat, lng)) 134 else 97
        } else {
            if (poly[162]!!.contains(lat, lng)) 81 else 97
        } else if (lng < -120.508865f) {
            if (poly[163]!!.contains(lat, lng)) 134 else 195
        } else if (lng < -115.776215f) if (lat < 49.527092f) if (lng < -118.142540f) {
            if (poly[164]!!.contains(lat, lng)) 195 else 134
        } else if (lat < 47.782407f) {
            if (poly[165]!!.contains(lat, lng)) 97 else 134
        } else {
            if (poly[166]!!.contains(lat, lng)) return 97
            if (poly[167]!!.contains(lat, lng)) return 100
            if (poly[168]!!.contains(lat, lng)) return 100
            if (poly[169]!!.contains(lat, lng)) return 134
            if (poly[170]!!.contains(lat, lng)) 195 else 91
        } else if (lng < -118.142540f) {
            if (poly[171]!!.contains(lat, lng)) return 100
            if (poly[172]!!.contains(lat, lng)) 100 else 195
        } else if (lat < 51.271777f) if (lng < -116.959377f) {
            if (poly[173]!!.contains(lat, lng)) 100 else 195
        } else {
            if (poly[174]!!.contains(lat, lng)) return 91
            if (poly[175]!!.contains(lat, lng)) return 91
            if (poly[176]!!.contains(lat, lng)) 195 else 100
        } else {
            if (poly[177]!!.contains(lat, lng)) return 195
            if (poly[178]!!.contains(lat, lng)) 195 else 100
        } else {
            if (poly[179]!!.contains(lat, lng)) return 100
            if (poly[180]!!.contains(lat, lng)) 134 else 97
        } else {
            if (poly[181]!!.contains(lat, lng)) return 97
            if (poly[182]!!.contains(lat, lng)) 173 else 100
        } else if (lat < 63.201980f) if (lng < -129.932869f) if (lat < 60.001555f) {
            if (poly[183]!!.contains(lat, lng)) 196 else 195
        } else {
            if (poly[184]!!.contains(lat, lng)) 199 else 196
        } else if (lng < -118.648599f) if (lat < 58.000000f) if (lng < -124.290734f) {
            if (poly[185]!!.contains(lat, lng)) 96 else 195
        } else if (lng < -121.469667f) if (lat < 55.508230f) {
            if (poly[186]!!.contains(lat, lng)) 96 else 195
        } else if (lng < -122.880200f) if (lat < 56.754115f) {
            if (poly[187]!!.contains(lat, lng)) 195 else 96
        } else {
            if (poly[188]!!.contains(lat, lng)) 195 else 96
        } else 96 else if (lat < 55.508230f) if (lng < -120.059133f) {
            if (poly[189]!!.contains(lat, lng)) 195 else 96
        } else {
            if (poly[190]!!.contains(lat, lng)) return 96
            if (poly[191]!!.contains(lat, lng)) 100 else 195
        } else {
            if (poly[192]!!.contains(lat, lng)) 100 else 96
        } else if (lng < -124.290734f) if (lng < -127.111802f) if (lat < 60.600990f) {
            if (poly[193]!!.contains(lat, lng)) return 103
            if (poly[194]!!.contains(lat, lng)) 196 else 195
        } else if (lng < -128.522335f) {
            if (poly[195]!!.contains(lat, lng)) 199 else 196
        } else {
            if (poly[196]!!.contains(lat, lng)) return 199
            if (poly[197]!!.contains(lat, lng)) 199 else 196
        } else if (lat < 60.600990f) if (lng < -125.701268f) {
            if (poly[198]!!.contains(lat, lng)) return 195
            if (poly[199]!!.contains(lat, lng)) 196 else 103
        } else {
            if (poly[200]!!.contains(lat, lng)) return 195
            if (poly[201]!!.contains(lat, lng)) return 196
            if (poly[202]!!.contains(lat, lng)) 199 else 103
        } else if (lng < -125.701268f) {
            if (poly[203]!!.contains(lat, lng)) 199 else 196
        } else {
            if (poly[204]!!.contains(lat, lng)) 199 else 196
        } else {
            if (poly[205]!!.contains(lat, lng)) return 100
            if (poly[206]!!.contains(lat, lng)) return 103
            if (poly[207]!!.contains(lat, lng)) 196 else 199
        } else {
            if (poly[208]!!.contains(lat, lng)) return 173
            if (poly[209]!!.contains(lat, lng)) 199 else 100
        } else if (lng < -129.812706f) if (lat < 63.573302f) {
            if (poly[210]!!.contains(lat, lng)) 196 else 199
        } else {
            if (poly[211]!!.contains(lat, lng)) 196 else 199
        } else {
            if (poly[212]!!.contains(lat, lng)) 82 else 199
        }
    }

    private fun call3(lat: Float, lng: Float): Int {
        return if (lng < -88.500000f) if (lat < 53.375000f) if (lng < -107.756288f) {
            if (poly[213]!!.contains(lat, lng)) 173 else 188
        } else if (lng < -101.392420f) {
            if (poly[214]!!.contains(lat, lng)) 197 else 173
        } else {
            if (poly[215]!!.contains(lat, lng)) 193 else 197
        } else if (lat < 59.999511f) if (lng < -101.735099f) if (lat < 53.710706f) {
            if (poly[216]!!.contains(lat, lng)) 197 else 173
        } else {
            if (poly[217]!!.contains(lat, lng)) return 197
            if (poly[218]!!.contains(lat, lng)) 199 else 173
        } else if (lng < -95.117549f) 197 else if (lat < 56.687256f) {
            if (poly[219]!!.contains(lat, lng)) return 171
            if (poly[220]!!.contains(lat, lng)) 193 else 197
        } else if (lng < -91.808775f) if (lat < 58.343286f) {
            if (poly[221]!!.contains(lat, lng)) 171 else 197
        } else {
            if (poly[222]!!.contains(lat, lng)) 197 else 171
        } else {
            if (poly[223]!!.contains(lat, lng)) return 193
            if (poly[224]!!.contains(lat, lng)) 197 else 171
        } else {
            if (poly[225]!!.contains(lat, lng)) return 82
            if (poly[226]!!.contains(lat, lng)) return 171
            if (poly[227]!!.contains(lat, lng)) 199 else 174
        } else if (lat < 62.989698f) if (lng < -81.645224f) if (lat < 56.187094f) if (lng < -85.072612f) {
            if (poly[228]!!.contains(lat, lng)) 193 else 171
        } else if (lat < 52.785792f) {
            if (poly[229]!!.contains(lat, lng)) 126 else 193
        } else {
            if (poly[230]!!.contains(lat, lng)) return 126
            if (poly[231]!!.contains(lat, lng)) 171 else 193
        } else {
            if (poly[232]!!.contains(lat, lng)) return 126
            if (poly[233]!!.contains(lat, lng)) return 171
            if (poly[234]!!.contains(lat, lng)) 193 else 72
        } else if (lat < 56.187094f) if (lng < -78.217837f) if (lat < 52.785792f) if (lng < -79.931531f) {
            if (poly[235]!!.contains(lat, lng)) 193 else 126
        } else if (lat < 51.085141f) 193 else if (lng < -79.074684f) {
            if (poly[236]!!.contains(lat, lng)) 193 else 126
        } else {
            if (poly[237]!!.contains(lat, lng)) 126 else 193
        } else if (lng < -79.931531f) 126 else if (lat < 54.486443f) if (lng < -79.074684f) {
            if (poly[238]!!.contains(lat, lng)) return 193
            if (poly[239]!!.contains(lat, lng)) return 193
            if (poly[240]!!.contains(lat, lng)) return 193
            if (poly[241]!!.contains(lat, lng)) return 193
            if (poly[242]!!.contains(lat, lng)) return 193
            if (poly[243]!!.contains(lat, lng)) return 193
            if (poly[244]!!.contains(lat, lng)) return 193
            if (poly[245]!!.contains(lat, lng)) return 193
            if (poly[246]!!.contains(lat, lng)) return 193
            if (poly[247]!!.contains(lat, lng)) 193 else 126
        } else if (lat < 53.636117f) {
            if (poly[248]!!.contains(lat, lng)) 193 else 126
        } else {
            if (poly[249]!!.contains(lat, lng)) return 126
            if (poly[250]!!.contains(lat, lng)) return 126
            if (poly[251]!!.contains(lat, lng)) return 126
            if (poly[252]!!.contains(lat, lng)) return 126
            if (poly[253]!!.contains(lat, lng)) return 126
            if (poly[254]!!.contains(lat, lng)) return 126
            if (poly[255]!!.contains(lat, lng)) return 126
            if (poly[256]!!.contains(lat, lng)) return 126
            if (poly[257]!!.contains(lat, lng)) 126 else 193
        } else {
            if (poly[258]!!.contains(lat, lng)) 193 else 126
        } else {
            if (poly[259]!!.contains(lat, lng)) 126 else 193
        } else if (lng < -78.217837f) {
            if (poly[260]!!.contains(lat, lng)) return 193
            if (poly[261]!!.contains(lat, lng)) 193 else 126
        } else if (lat < 59.588396f) {
            if (poly[262]!!.contains(lat, lng)) 193 else 126
        } else if (lng < -76.504143f) if (lat < 61.289047f) {
            if (poly[263]!!.contains(lat, lng)) 193 else 126
        } else {
            if (poly[264]!!.contains(lat, lng)) 193 else 126
        } else {
            if (poly[265]!!.contains(lat, lng)) 193 else 126
        } else if (lat < 73.157443f) if (lng < -81.645224f) if (lat < 68.073571f) if (lng < -85.072612f) if (lat < 65.531634f) {
            if (poly[266]!!.contains(lat, lng)) 72 else 171
        } else {
            if (poly[267]!!.contains(lat, lng)) return 72
            if (poly[268]!!.contains(lat, lng)) 72 else 171
        } else if (lat < 65.531634f) if (lng < -83.358918f) if (lat < 64.260666f) {
            if (poly[269]!!.contains(lat, lng)) return 126
            if (poly[270]!!.contains(lat, lng)) 171 else 72
        } else {
            if (poly[271]!!.contains(lat, lng)) return 126
            if (poly[272]!!.contains(lat, lng)) 171 else 72
        } else if (lat < 64.260666f) {
            if (poly[273]!!.contains(lat, lng)) 72 else 126
        } else {
            if (poly[274]!!.contains(lat, lng)) 72 else 126
        } else {
            if (poly[275]!!.contains(lat, lng)) return 72
            if (poly[276]!!.contains(lat, lng)) return 72
            if (poly[277]!!.contains(lat, lng)) return 171
            if (poly[278]!!.contains(lat, lng)) 171 else 126
        } else {
            if (poly[279]!!.contains(lat, lng)) 171 else 126
        } else {
            if (poly[280]!!.contains(lat, lng)) return 72
            if (poly[281]!!.contains(lat, lng)) 72 else 126
        } else {
            if (poly[282]!!.contains(lat, lng)) 171 else 126
        }
    }

    private fun call4(lat: Float, lng: Float): Int {
        return if (lat < 47.575298f) if (lng < -100.260872f) if (lng < -102.432684f) if (lng < -103.434273f) {
            if (poly[283]!!.contains(lat, lng)) 88 else 97
        } else if (lng < -103.093448f) {
            if (poly[284]!!.contains(lat, lng)) 88 else 97
        } else {
            if (poly[285]!!.contains(lat, lng)) 88 else 97
        } else if (lat < 42.766993f) {
            if (poly[286]!!.contains(lat, lng)) 97 else 88
        } else if (lat < 45.171146f) {
            if (poly[287]!!.contains(lat, lng)) 97 else 88
        } else if (lat < 46.373222f) {
            if (poly[288]!!.contains(lat, lng)) return 88
            if (poly[289]!!.contains(lat, lng)) 159 else 97
        } else if (lng < -101.346778f) {
            if (poly[290]!!.contains(lat, lng)) return 88
            if (poly[291]!!.contains(lat, lng)) return 97
            if (poly[292]!!.contains(lat, lng)) return 158
            if (poly[293]!!.contains(lat, lng)) 159 else 157
        } else {
            if (poly[294]!!.contains(lat, lng)) return 97
            if (poly[295]!!.contains(lat, lng)) return 157
            if (poly[296]!!.contains(lat, lng)) return 158
            if (poly[297]!!.contains(lat, lng)) 159 else 88
        } else if (lat < 38.929415f) if (lng < -86.679886f) if (lng < -93.470379f) 88 else if (lng < -90.075132f) 88 else if (lng < -88.377509f) 88 else if (lng < -87.528698f) {
            if (poly[298]!!.contains(lat, lng)) return 123
            if (poly[299]!!.contains(lat, lng)) 123 else 88
        } else if (lat < 38.444052f) {
            if (poly[300]!!.contains(lat, lng)) return 117
            if (poly[301]!!.contains(lat, lng)) return 119
            if (poly[302]!!.contains(lat, lng)) return 120
            if (poly[303]!!.contains(lat, lng)) return 121
            if (poly[304]!!.contains(lat, lng)) 123 else 88
        } else {
            if (poly[305]!!.contains(lat, lng)) return 88
            if (poly[306]!!.contains(lat, lng)) return 88
            if (poly[307]!!.contains(lat, lng)) return 88
            if (poly[308]!!.contains(lat, lng)) return 117
            if (poly[309]!!.contains(lat, lng)) 120 else 123
        } else if (lng < -85.405100f) if (lng < -86.042493f) if (lat < 38.444045f) if (lng < -86.361189f) {
            if (poly[310]!!.contains(lat, lng)) return 88
            if (poly[311]!!.contains(lat, lng)) return 117
            if (poly[312]!!.contains(lat, lng)) return 121
            if (poly[313]!!.contains(lat, lng)) return 153
            if (poly[314]!!.contains(lat, lng)) 153 else 119
        } else {
            if (poly[315]!!.contains(lat, lng)) return 117
            if (poly[316]!!.contains(lat, lng)) return 129
            if (poly[317]!!.contains(lat, lng)) 153 else 119
        } else 117 else {
            if (poly[318]!!.contains(lat, lng)) return 117
            if (poly[319]!!.contains(lat, lng)) return 153
            if (poly[320]!!.contains(lat, lng)) 153 else 129
        } else {
            if (poly[321]!!.contains(lat, lng)) return 117
            if (poly[322]!!.contains(lat, lng)) 122 else 153
        } else if (lat < 41.433800f) if (lng < -86.466347f) {
            if (poly[323]!!.contains(lat, lng)) return 117
            if (poly[324]!!.contains(lat, lng)) return 118
            if (poly[325]!!.contains(lat, lng)) 124 else 88
        } else {
            if (poly[326]!!.contains(lat, lng)) 153 else 117
        } else if (lng < -87.263670f) if (lng < -93.762271f) 88 else if (lng < -90.512970f) 88 else if (lat < 44.504549f) 88 else if (lng < -88.888320f) {
            if (poly[327]!!.contains(lat, lng)) return 88
            if (poly[328]!!.contains(lat, lng)) 98 else 144
        } else if (lat < 46.039924f) if (lng < -88.075995f) {
            if (poly[329]!!.contains(lat, lng)) return 144
            if (poly[330]!!.contains(lat, lng)) 144 else 88
        } else {
            if (poly[331]!!.contains(lat, lng)) return 88
            if (poly[332]!!.contains(lat, lng)) return 88
            if (poly[333]!!.contains(lat, lng)) return 98
            if (poly[334]!!.contains(lat, lng)) 98 else 144
        } else {
            if (poly[335]!!.contains(lat, lng)) return 88
            if (poly[336]!!.contains(lat, lng)) 144 else 98
        } else if (lng < -81.027060f) if (lng < -84.145365f) {
            if (poly[337]!!.contains(lat, lng)) return 88
            if (poly[338]!!.contains(lat, lng)) return 117
            if (poly[339]!!.contains(lat, lng)) return 153
            if (poly[340]!!.contains(lat, lng)) 193 else 98
        } else {
            if (poly[341]!!.contains(lat, lng)) return 98
            if (poly[342]!!.contains(lat, lng)) return 98
            if (poly[343]!!.contains(lat, lng)) 153 else 193
        } else {
            if (poly[344]!!.contains(lat, lng)) 193 else 153
        } else if (lat < 49.384490f) if (lng < -95.153150f) if (lng < -102.711964f) {
            if (poly[345]!!.contains(lat, lng)) return 97
            if (poly[346]!!.contains(lat, lng)) return 97
            if (poly[347]!!.contains(lat, lng)) 173 else 88
        } else if (lat < 47.615253f) if (lng < -102.250025f) {
            if (poly[348]!!.contains(lat, lng)) 97 else 88
        } else {
            if (poly[349]!!.contains(lat, lng)) 97 else 88
        } else {
            if (poly[350]!!.contains(lat, lng)) return 88
            if (poly[351]!!.contains(lat, lng)) 197 else 173
        } else if (lng < -90.000000f) if (lng < -92.576575f) {
            if (poly[352]!!.contains(lat, lng)) return 88
            if (poly[353]!!.contains(lat, lng)) 170 else 197
        } else if (lng < -91.288287f) {
            if (poly[354]!!.contains(lat, lng)) return 88
            if (poly[355]!!.contains(lat, lng)) 197 else 72
        } else {
            if (poly[356]!!.contains(lat, lng)) return 88
            if (poly[357]!!.contains(lat, lng)) return 193
            if (poly[358]!!.contains(lat, lng)) 197 else 72
        } else if (lat < 48.515693f) {
            if (poly[359]!!.contains(lat, lng)) return 88
            if (poly[360]!!.contains(lat, lng)) return 98
            if (poly[361]!!.contains(lat, lng)) 191 else 193
        } else {
            if (poly[362]!!.contains(lat, lng)) 193 else 154
        } else call3(lat, lng)
    }

    private fun call5(lat: Float, lng: Float): Int {
        return if (lat < 37.958689f) if (lng < -92.524388f) if (lng < -154.592785f) if (lng < -177.116176f) 410 else 404 else call1(lat, lng) else if (lat < 18.851981f) if (lng < -82.172962f) if (lng < -87.101885f) if (lat < 16.298406f) if (lng < -90.424127f) if (lat < 16.259052f) {
            if (poly[363]!!.contains(lat, lng)) 147 else 111
        } else {
            if (poly[364]!!.contains(lat, lng)) 111 else 147
        } else if (lat < 14.277527f) if (lng < -88.763006f) {
            if (poly[365]!!.contains(lat, lng)) return 111
            if (poly[366]!!.contains(lat, lng)) 189 else 102
        } else {
            if (poly[367]!!.contains(lat, lng)) return 102
            if (poly[368]!!.contains(lat, lng)) 137 else 189
        } else if (lng < -88.763006f) if (lat < 15.287966f) {
            if (poly[369]!!.contains(lat, lng)) return 102
            if (poly[370]!!.contains(lat, lng)) 189 else 111
        } else {
            if (poly[371]!!.contains(lat, lng)) 77 else 111
        } else {
            if (poly[372]!!.contains(lat, lng)) return 77
            if (poly[373]!!.contains(lat, lng)) 111 else 189
        } else if (lng < -90.371441f) if (lat < 17.575193f) {
            if (poly[374]!!.contains(lat, lng)) 111 else 147
        } else {
            if (poly[375]!!.contains(lat, lng)) return 111
            if (poly[376]!!.contains(lat, lng)) 147 else 145
        } else if (lng < -88.736663f) {
            if (poly[377]!!.contains(lat, lng)) return 77
            if (poly[378]!!.contains(lat, lng)) return 111
            if (poly[379]!!.contains(lat, lng)) 145 else 84
        } else {
            if (poly[380]!!.contains(lat, lng)) 84 else 77
        } else if (lat < 15.033118f) if (lat < 12.408226f) 137 else if (lng < -83.042535f) if (lng < -85.072210f) if (lat < 13.720672f) {
            if (poly[381]!!.contains(lat, lng)) 189 else 137
        } else if (lng < -86.087047f) {
            if (poly[382]!!.contains(lat, lng)) 137 else 189
        } else {
            if (poly[383]!!.contains(lat, lng)) 189 else 137
        } else if (lat < 13.720672f) 137 else if (lng < -84.057372f) {
            if (poly[384]!!.contains(lat, lng)) 189 else 137
        } else {
            if (poly[385]!!.contains(lat, lng)) 189 else 137
        } else if (lat < 14.688147f) 137 else 189 else 189 else if (lat < 16.057127f) 80 else if (lng < -75.496288f) 127 else 165 else if (lng < -86.493266f) if (lat < 21.830571f) if (lng < -91.750739f) 145 else if (lng < -89.122003f) {
            if (poly[386]!!.contains(lat, lng)) return 84
            if (poly[387]!!.contains(lat, lng)) 84 else 145
        } else {
            if (poly[388]!!.contains(lat, lng)) return 145
            if (poly[389]!!.contains(lat, lng)) 145 else 84
        } else if (lat < 22.783270f) 145 else {
            if (poly[390]!!.contains(lat, lng)) 121 else 88
        } else if (lat < 23.481697f) if (lat < 19.596903f) 87 else if (lat < 19.973824f) if (lng < -79.511095f) 87 else {
            if (poly[391]!!.contains(lat, lng)) 153 else 115
        } else {
            if (poly[392]!!.contains(lat, lng)) 152 else 115
        } else if (lng < -84.575844f) if (lat < 33.673127f) if (lat < 31.530347f) {
            if (poly[393]!!.contains(lat, lng)) 88 else 153
        } else {
            if (poly[394]!!.contains(lat, lng)) 153 else 88
        } else if (lat < 35.815908f) {
            if (poly[395]!!.contains(lat, lng)) 153 else 88
        } else if (lat < 36.887299f) {
            if (poly[396]!!.contains(lat, lng)) return 88
            if (poly[397]!!.contains(lat, lng)) 130 else 153
        } else {
            if (poly[398]!!.contains(lat, lng)) return 88
            if (poly[399]!!.contains(lat, lng)) return 130
            if (poly[400]!!.contains(lat, lng)) 130 else 153
        } else if (lng < -82.585009f) 153 else {
            if (poly[401]!!.contains(lat, lng)) 152 else 153
        } else if (lng < -108.824497f) if (lng < -141.000000f) if (lat < 57.465233f) if (lng < -162.000000f) if (lng < -171.954674f) 53 else if (lat < 53.299009f) {
            if (poly[402]!!.contains(lat, lng)) 155 else 53
        } else 155 else 54 else if (lng < -174.939411f) 215 else if (lng < -162.000000f) if (lat < 64.008111f) 155 else if (lng < -168.924586f) {
            if (poly[403]!!.contains(lat, lng)) 155 else 215
        } else 155 else if (lng < -145.834392f) 54 else {
            if (poly[404]!!.contains(lat, lng)) 196 else 54
        } else if (lng < -129.974167f) if (lat < 60.352505f) if (lat < 55.300967f) if (lat < 54.456000f) 195 else {
            if (poly[405]!!.contains(lat, lng)) return 146
            if (poly[406]!!.contains(lat, lng)) return 195
            if (poly[407]!!.contains(lat, lng)) 195 else 181
        } else if (lat < 59.798041f) if (lng < -135.487083f) {
            if (poly[408]!!.contains(lat, lng)) return 181
            if (poly[409]!!.contains(lat, lng)) return 195
            if (poly[410]!!.contains(lat, lng)) 198 else 128
        } else if (lng < -132.730625f) if (lat < 57.549504f) {
            if (poly[411]!!.contains(lat, lng)) 128 else 181
        } else {
            if (poly[412]!!.contains(lat, lng)) return 181
            if (poly[413]!!.contains(lat, lng)) return 195
            if (poly[414]!!.contains(lat, lng)) 195 else 128
        } else {
            if (poly[415]!!.contains(lat, lng)) return 128
            if (poly[416]!!.contains(lat, lng)) 195 else 181
        } else {
            if (poly[417]!!.contains(lat, lng)) return 195
            if (poly[418]!!.contains(lat, lng)) 198 else 196
        } else if (lat < 63.588796f) if (lat < 63.337384f) {
            if (poly[419]!!.contains(lat, lng)) 199 else 196
        } else {
            if (poly[420]!!.contains(lat, lng)) 199 else 196
        } else if (lng < -139.277500f) {
            if (poly[421]!!.contains(lat, lng)) 196 else 95
        } else if (lng < -134.625833f) {
            if (poly[422]!!.contains(lat, lng)) 199 else 196
        } else if (lat < 67.027228f) if (lng < -132.300000f) if (lat < 65.308012f) {
            if (poly[423]!!.contains(lat, lng)) 199 else 196
        } else if (lng < -133.462917f) {
            if (poly[424]!!.contains(lat, lng)) 199 else 196
        } else {
            if (poly[425]!!.contains(lat, lng)) 196 else 199
        } else if (lat < 65.308012f) {
            if (poly[426]!!.contains(lat, lng)) 199 else 196
        } else {
            if (poly[427]!!.contains(lat, lng)) return 196
            if (poly[428]!!.contains(lat, lng)) 196 else 199
        } else {
            if (poly[429]!!.contains(lat, lng)) 125 else 199
        } else call2(lat, lng) else call4(lat, lng)
    }

    private fun call6(lat: Float, lng: Float): Int {
        return if (lng < -62.609179f) if (lat < -41.992126f) if (lng < -69.048916f) if (lng < -71.919683f) {
            if (poly[430]!!.contains(lat, lng)) return 60
            if (poly[431]!!.contains(lat, lng)) return 60
            if (poly[432]!!.contains(lat, lng)) return 60
            if (poly[433]!!.contains(lat, lng)) 60 else 177
        } else if (lat < -43.996000f) if (lng < -70.484300f) if (lat < -44.997937f) {
            if (poly[434]!!.contains(lat, lng)) 60 else 177
        } else {
            if (poly[435]!!.contains(lat, lng)) 60 else 177
        } else 60 else {
            if (poly[436]!!.contains(lat, lng)) return 60
            if (poly[437]!!.contains(lat, lng)) 66 else 177
        } else {
            if (poly[438]!!.contains(lat, lng)) 66 else 60
        } else if (lng < -64.780716f) if (lat < -35.192695f) if (lng < -69.592084f) if (lat < -38.592410f) if (lng < -71.997768f) 177 else if (lat < -40.292268f) {
            if (poly[439]!!.contains(lat, lng)) return 66
            if (poly[440]!!.contains(lat, lng)) 66 else 177
        } else if (lng < -70.794926f) if (lat < -39.442339f) {
            if (poly[441]!!.contains(lat, lng)) return 177
            if (poly[442]!!.contains(lat, lng)) 177 else 66
        } else {
            if (poly[443]!!.contains(lat, lng)) 177 else 66
        } else 66 else if (lng < -71.900482f) 177 else if (lat < -36.892553f) {
            if (poly[444]!!.contains(lat, lng)) return 64
            if (poly[445]!!.contains(lat, lng)) 177 else 66
        } else if (lng < -70.746283f) {
            if (poly[446]!!.contains(lat, lng)) 66 else 177
        } else if (lat < -36.042624f) {
            if (poly[447]!!.contains(lat, lng)) return 64
            if (poly[448]!!.contains(lat, lng)) 177 else 66
        } else {
            if (poly[449]!!.contains(lat, lng)) 64 else 177
        } else {
            if (poly[450]!!.contains(lat, lng)) return 66
            if (poly[451]!!.contains(lat, lng)) 68 else 64
        } else if (lng < -68.711575f) if (lat < -31.792980f) if (lng < -70.677005f) 177 else if (lat < -33.492837f) {
            if (poly[452]!!.contains(lat, lng)) 177 else 64
        } else if (lng < -69.694290f) if (lat < -32.642908f) {
            if (poly[453]!!.contains(lat, lng)) 64 else 177
        } else {
            if (poly[454]!!.contains(lat, lng)) return 64
            if (poly[455]!!.contains(lat, lng)) return 64
            if (poly[456]!!.contains(lat, lng)) 177 else 67
        } else {
            if (poly[457]!!.contains(lat, lng)) 64 else 67
        } else if (lat < -30.093122f) {
            if (poly[458]!!.contains(lat, lng)) 67 else 177
        } else if (lng < -70.265666f) 177 else if (lat < -29.243193f) {
            if (poly[459]!!.contains(lat, lng)) return 63
            if (poly[460]!!.contains(lat, lng)) 177 else 67
        } else {
            if (poly[461]!!.contains(lat, lng)) return 63
            if (poly[462]!!.contains(lat, lng)) 177 else 67
        } else if (lat < -31.792980f) if (lng < -66.746146f) if (lat < -33.492837f) {
            if (poly[463]!!.contains(lat, lng)) return 68
            if (poly[464]!!.contains(lat, lng)) 68 else 64
        } else if (lng < -67.728860f) {
            if (poly[465]!!.contains(lat, lng)) 67 else 64
        } else {
            if (poly[466]!!.contains(lat, lng)) return 63
            if (poly[467]!!.contains(lat, lng)) return 64
            if (poly[468]!!.contains(lat, lng)) 67 else 68
        } else if (lat < -33.492837f) {
            if (poly[469]!!.contains(lat, lng)) return 61
            if (poly[470]!!.contains(lat, lng)) return 64
            if (poly[471]!!.contains(lat, lng)) return 64
            if (poly[472]!!.contains(lat, lng)) 66 else 68
        } else {
            if (poly[473]!!.contains(lat, lng)) return 61
            if (poly[474]!!.contains(lat, lng)) return 63
            if (poly[475]!!.contains(lat, lng)) 67 else 68
        } else if (lng < -66.746146f) {
            if (poly[476]!!.contains(lat, lng)) 67 else 63
        } else {
            if (poly[477]!!.contains(lat, lng)) return 61
            if (poly[478]!!.contains(lat, lng)) return 61
            if (poly[479]!!.contains(lat, lng)) 63 else 60
        } else {
            if (poly[480]!!.contains(lat, lng)) return 59
            if (poly[481]!!.contains(lat, lng)) 61 else 66
        } else if (lat < -30.085396f) if (lat < -33.261612f) if (lng < -60.260223f) {
            if (poly[482]!!.contains(lat, lng)) 61 else 59
        } else if (lng < -55.703699f) {
            if (poly[483]!!.contains(lat, lng)) return 61
            if (poly[484]!!.contains(lat, lng)) 150 else 59
        } else {
            if (poly[485]!!.contains(lat, lng)) 179 else 150
        } else if (lng < -58.087644f) {
            if (poly[486]!!.contains(lat, lng)) 61 else 150
        } else if (lng < -54.005825f) if (lng < -56.046735f) if (lat < -31.673504f) {
            if (poly[487]!!.contains(lat, lng)) return 61
            if (poly[488]!!.contains(lat, lng)) 61 else 150
        } else if (lng < -57.067189f) {
            if (poly[489]!!.contains(lat, lng)) return 61
            if (poly[490]!!.contains(lat, lng)) 179 else 150
        } else {
            if (poly[491]!!.contains(lat, lng)) 150 else 179
        } else {
            if (poly[492]!!.contains(lat, lng)) 150 else 179
        } else {
            if (poly[493]!!.contains(lat, lng)) 150 else 179
        } else if (lng < -55.883574f) if (lat < -28.479231f) {
            if (poly[494]!!.contains(lat, lng)) 179 else 61
        } else {
            if (poly[495]!!.contains(lat, lng)) 179 else 61
        } else {
            if (poly[496]!!.contains(lat, lng)) 61 else 179
        }
    }

    private fun call7(lat: Float, lng: Float): Int {
        return if (lat < -24.971517f) if (lng < -57.554695f) if (lat < -27.256324f) {
            if (poly[497]!!.contains(lat, lng)) 71 else 61
        } else if (lat < -25.443098f) {
            if (poly[498]!!.contains(lat, lng)) 61 else 71
        } else {
            if (poly[499]!!.contains(lat, lng)) 71 else 61
        } else if (lng < -55.859440f) {
            if (poly[500]!!.contains(lat, lng)) 61 else 71
        } else if (lng < -51.466260f) if (lng < -53.662850f) if (lat < -26.177634f) if (lng < -54.761145f) {
            if (poly[501]!!.contains(lat, lng)) 61 else 71
        } else if (lat < -26.780692f) {
            if (poly[502]!!.contains(lat, lng)) 61 else 179
        } else {
            if (poly[503]!!.contains(lat, lng)) return 71
            if (poly[504]!!.contains(lat, lng)) return 179
            if (poly[505]!!.contains(lat, lng)) 179 else 61
        } else if (lng < -54.761145f) 71 else if (lat < -25.574576f) if (lng < -54.211998f) {
            if (poly[506]!!.contains(lat, lng)) return 71
            if (poly[507]!!.contains(lat, lng)) return 179
            if (poly[508]!!.contains(lat, lng)) 179 else 61
        } else {
            if (poly[509]!!.contains(lat, lng)) return 179
            if (poly[510]!!.contains(lat, lng)) return 179
            if (poly[511]!!.contains(lat, lng)) return 179
            if (poly[512]!!.contains(lat, lng)) 179 else 61
        } else {
            if (poly[513]!!.contains(lat, lng)) return 61
            if (poly[514]!!.contains(lat, lng)) return 61
            if (poly[515]!!.contains(lat, lng)) return 61
            if (poly[516]!!.contains(lat, lng)) return 61
            if (poly[517]!!.contains(lat, lng)) return 61
            if (poly[518]!!.contains(lat, lng)) 71 else 179
        } else {
            if (poly[519]!!.contains(lat, lng)) return 61
            if (poly[520]!!.contains(lat, lng)) 61 else 179
        } else 179 else if (lng < -50.805843f) if (lat < -19.331948f) if (lng < -54.488672f) if (lat < -22.151733f) if (lng < -56.330086f) {
            if (poly[521]!!.contains(lat, lng)) return 83
            if (poly[522]!!.contains(lat, lng)) 83 else 71
        } else if (lat < -23.561625f) {
            if (poly[523]!!.contains(lat, lng)) 83 else 71
        } else {
            if (poly[524]!!.contains(lat, lng)) 71 else 83
        } else if (lng < -56.330086f) if (lat < -20.741840f) if (lng < -57.250793f) {
            if (poly[525]!!.contains(lat, lng)) 83 else 71
        } else {
            if (poly[526]!!.contains(lat, lng)) 71 else 83
        } else {
            if (poly[527]!!.contains(lat, lng)) return 71
            if (poly[528]!!.contains(lat, lng)) return 71
            if (poly[529]!!.contains(lat, lng)) 132 else 83
        } else 83 else if (lat < -22.151733f) {
            if (poly[530]!!.contains(lat, lng)) return 71
            if (poly[531]!!.contains(lat, lng)) 83 else 179
        } else {
            if (poly[532]!!.contains(lat, lng)) 179 else 83
        } else if (lng < -54.488672f) if (lat < -16.512163f) if (lng < -56.330086f) if (lat < -17.922055f) {
            if (poly[533]!!.contains(lat, lng)) 132 else 83
        } else if (lng < -57.250793f) {
            if (poly[534]!!.contains(lat, lng)) return 92
            if (poly[535]!!.contains(lat, lng)) 132 else 83
        } else {
            if (poly[536]!!.contains(lat, lng)) return 92
            if (poly[537]!!.contains(lat, lng)) 92 else 83
        } else if (lat < -17.922055f) 83 else if (lng < -55.409379f) {
            if (poly[538]!!.contains(lat, lng)) 92 else 83
        } else {
            if (poly[539]!!.contains(lat, lng)) 92 else 83
        } else 92 else if (lat < -16.512163f) if (lng < -52.647375f) if (lat < -17.922055f) {
            if (poly[540]!!.contains(lat, lng)) return 92
            if (poly[541]!!.contains(lat, lng)) return 92
            if (poly[542]!!.contains(lat, lng)) 179 else 83
        } else if (lng < -53.568023f) {
            if (poly[543]!!.contains(lat, lng)) 92 else 83
        } else {
            if (poly[544]!!.contains(lat, lng)) 179 else 92
        } else {
            if (poly[545]!!.contains(lat, lng)) return 83
            if (poly[546]!!.contains(lat, lng)) 92 else 179
        } else if (lng < -52.647258f) {
            if (poly[547]!!.contains(lat, lng)) 179 else 92
        } else if (lat < -15.102270f) {
            if (poly[548]!!.contains(lat, lng)) 179 else 92
        } else {
            if (poly[549]!!.contains(lat, lng)) 179 else 92
        } else if (lng < -44.648778f) if (lat < -19.331948f) 179 else if (lng < -47.727311f) 179 else if (lat < -16.512163f) 179 else if (lng < -46.188044f) {
            if (poly[550]!!.contains(lat, lng)) 73 else 179
        } else if (lat < -15.102270f) {
            if (poly[551]!!.contains(lat, lng)) 73 else 179
        } else {
            if (poly[552]!!.contains(lat, lng)) return 179
            if (poly[553]!!.contains(lat, lng)) 179 else 73
        } else if (lat < -18.741865f) 179 else if (lng < -41.570246f) if (lat < -16.217122f) 179 else if (lng < -43.109512f) {
            if (poly[554]!!.contains(lat, lng)) 179 else 73
        } else {
            if (poly[555]!!.contains(lat, lng)) 179 else 73
        } else if (lat < -16.217122f) if (lng < -40.030979f) {
            if (poly[556]!!.contains(lat, lng)) 73 else 179
        } else {
            if (poly[557]!!.contains(lat, lng)) return 179
            if (poly[558]!!.contains(lat, lng)) 179 else 73
        } else {
            if (poly[559]!!.contains(lat, lng)) 179 else 73
        }
    }

    private fun call8(lat: Float, lng: Float): Int {
        return if (lng < -64.150670f) if (lat < -25.168567f) if (lng < -66.537674f) if (lng < -69.003680f) {
            if (poly[560]!!.contains(lat, lng)) return 60
            if (poly[561]!!.contains(lat, lng)) 63 else 177
        } else if (lat < -26.780915f) if (lng < -67.770677f) if (lat < -27.587090f) {
            if (poly[562]!!.contains(lat, lng)) 63 else 60
        } else {
            if (poly[563]!!.contains(lat, lng)) 177 else 60
        } else {
            if (poly[564]!!.contains(lat, lng)) 63 else 60
        } else {
            if (poly[565]!!.contains(lat, lng)) return 66
            if (poly[566]!!.contains(lat, lng)) return 66
            if (poly[567]!!.contains(lat, lng)) 177 else 60
        } else if (lat < -25.700714f) if (lng < -64.268303f) if (lat < -27.046989f) {
            if (poly[568]!!.contains(lat, lng)) return 60
            if (poly[569]!!.contains(lat, lng)) 61 else 69
        } else if (lng < -65.402989f) {
            if (poly[570]!!.contains(lat, lng)) return 60
            if (poly[571]!!.contains(lat, lng)) 66 else 69
        } else {
            if (poly[572]!!.contains(lat, lng)) return 61
            if (poly[573]!!.contains(lat, lng)) 66 else 69
        } else {
            if (poly[574]!!.contains(lat, lng)) 66 else 61
        } else {
            if (poly[575]!!.contains(lat, lng)) 60 else 66
        } else if (lat < -19.430473f) if (lng < -69.470560f) {
            if (poly[576]!!.contains(lat, lng)) 133 else 177
        } else if (lat < -22.299520f) if (lng < -66.810615f) if (lat < -23.734043f) {
            if (poly[577]!!.contains(lat, lng)) return 62
            if (poly[578]!!.contains(lat, lng)) 177 else 66
        } else {
            if (poly[579]!!.contains(lat, lng)) return 62
            if (poly[580]!!.contains(lat, lng)) return 66
            if (poly[581]!!.contains(lat, lng)) 177 else 132
        } else if (lat < -23.734043f) if (lng < -65.480642f) {
            if (poly[582]!!.contains(lat, lng)) 66 else 62
        } else {
            if (poly[583]!!.contains(lat, lng)) 66 else 62
        } else if (lng < -65.480642f) {
            if (poly[584]!!.contains(lat, lng)) return 66
            if (poly[585]!!.contains(lat, lng)) 132 else 62
        } else if (lat < -23.016782f) {
            if (poly[586]!!.contains(lat, lng)) 66 else 62
        } else {
            if (poly[587]!!.contains(lat, lng)) return 62
            if (poly[588]!!.contains(lat, lng)) 132 else 66
        } else if (lng < -66.810615f) {
            if (poly[589]!!.contains(lat, lng)) 177 else 132
        } else {
            if (poly[590]!!.contains(lat, lng)) return 62
            if (poly[591]!!.contains(lat, lng)) 66 else 132
        } else if (lng < -69.470560f) {
            if (poly[592]!!.contains(lat, lng)) return 132
            if (poly[593]!!.contains(lat, lng)) 177 else 133
        } else if (lat < -16.561425f) {
            if (poly[594]!!.contains(lat, lng)) return 133
            if (poly[595]!!.contains(lat, lng)) return 133
            if (poly[596]!!.contains(lat, lng)) 177 else 132
        } else if (lng < -66.810615f) if (lat < -15.126902f) {
            if (poly[597]!!.contains(lat, lng)) 133 else 132
        } else {
            if (poly[598]!!.contains(lat, lng)) 133 else 132
        } else 132 else if (lat < -26.358070f) {
            if (poly[599]!!.contains(lat, lng)) 71 else 61
        } else if (lat < -19.287647f) if (lng < -59.068928f) if (lat < -22.822858f) if (lng < -61.609799f) {
            if (poly[600]!!.contains(lat, lng)) return 66
            if (poly[601]!!.contains(lat, lng)) 71 else 61
        } else {
            if (poly[602]!!.contains(lat, lng)) 71 else 61
        } else if (lng < -61.609799f) if (lat < -21.055253f) if (lng < -62.880235f) {
            if (poly[603]!!.contains(lat, lng)) 132 else 66
        } else if (lat < -21.939056f) if (lng < -62.245017f) {
            if (poly[604]!!.contains(lat, lng)) return 61
            if (poly[605]!!.contains(lat, lng)) return 71
            if (poly[606]!!.contains(lat, lng)) return 71
            if (poly[607]!!.contains(lat, lng)) 132 else 66
        } else {
            if (poly[608]!!.contains(lat, lng)) return 61
            if (poly[609]!!.contains(lat, lng)) return 61
            if (poly[610]!!.contains(lat, lng)) 61 else 71
        } else {
            if (poly[611]!!.contains(lat, lng)) 132 else 71
        } else {
            if (poly[612]!!.contains(lat, lng)) 71 else 132
        } else {
            if (poly[613]!!.contains(lat, lng)) 132 else 71
        } else if (lat < -24.634697f) {
            if (poly[614]!!.contains(lat, lng)) 71 else 61
        } else if (lat < -19.834362f) {
            if (poly[615]!!.contains(lat, lng)) 132 else 71
        } else {
            if (poly[616]!!.contains(lat, lng)) 132 else 71
        } else if (lng < -61.161085f) 132 else if (lat < -16.490012f) {
            if (poly[617]!!.contains(lat, lng)) 92 else 132
        } else {
            if (poly[618]!!.contains(lat, lng)) 92 else 132
        }
    }

    private fun call9(lat: Float, lng: Float): Int {
        return if (lat < 0.627796f) if (lng < -61.358472f) if (lat < -3.360249f) 138 else if (lng < -63.989208f) 138 else if (lat < -1.366227f) {
            if (poly[619]!!.contains(lat, lng)) 79 else 138
        } else if (lng < -62.673840f) 138 else if (lat < -0.369216f) {
            if (poly[620]!!.contains(lat, lng)) 79 else 138
        } else {
            if (poly[621]!!.contains(lat, lng)) 138 else 79
        } else if (lat < -3.360249f) {
            if (poly[622]!!.contains(lat, lng)) 176 else 138
        } else if (lng < -58.727736f) if (lat < -1.366227f) 138 else if (lng < -60.043104f) if (lat < -0.369216f) {
            if (poly[623]!!.contains(lat, lng)) 79 else 138
        } else {
            if (poly[624]!!.contains(lat, lng)) 138 else 79
        } else {
            if (poly[625]!!.contains(lat, lng)) return 79
            if (poly[626]!!.contains(lat, lng)) return 176
            if (poly[627]!!.contains(lat, lng)) return 176
            if (poly[628]!!.contains(lat, lng)) 176 else 138
        } else if (lat < -1.366227f) if (lng < -57.412368f) {
            if (poly[629]!!.contains(lat, lng)) 176 else 138
        } else {
            if (poly[630]!!.contains(lat, lng)) 138 else 176
        } else {
            if (poly[631]!!.contains(lat, lng)) return 138
            if (poly[632]!!.contains(lat, lng)) return 138
            if (poly[633]!!.contains(lat, lng)) 138 else 176
        } else if (lng < -61.358472f) if (lat < 4.615840f) if (lng < -63.989208f) if (lat < 2.621818f) if (lng < -65.304576f) {
            if (poly[634]!!.contains(lat, lng)) 138 else 85
        } else if (lat < 1.624807f) {
            if (poly[635]!!.contains(lat, lng)) 138 else 85
        } else {
            if (poly[636]!!.contains(lat, lng)) return 79
            if (poly[637]!!.contains(lat, lng)) 138 else 85
        } else {
            if (poly[638]!!.contains(lat, lng)) return 79
            if (poly[639]!!.contains(lat, lng)) return 79
            if (poly[640]!!.contains(lat, lng)) 79 else 85
        } else if (lat < 2.621818f) if (lng < -62.673840f) if (lat < 1.624807f) {
            if (poly[641]!!.contains(lat, lng)) 79 else 138
        } else if (lng < -63.331524f) {
            if (poly[642]!!.contains(lat, lng)) return 79
            if (poly[643]!!.contains(lat, lng)) 138 else 85
        } else {
            if (poly[644]!!.contains(lat, lng)) 138 else 79
        } else {
            if (poly[645]!!.contains(lat, lng)) 138 else 79
        } else if (lng < -62.673840f) if (lat < 3.618829f) {
            if (poly[646]!!.contains(lat, lng)) return 85
            if (poly[647]!!.contains(lat, lng)) return 85
            if (poly[648]!!.contains(lat, lng)) 85 else 79
        } else {
            if (poly[649]!!.contains(lat, lng)) 85 else 79
        } else {
            if (poly[650]!!.contains(lat, lng)) 85 else 79
        } else {
            if (poly[651]!!.contains(lat, lng)) 113 else 85
        } else if (lat < 4.615840f) if (lng < -58.727736f) if (lat < 2.621818f) if (lng < -60.043104f) 79 else if (lat < 1.624807f) {
            if (poly[652]!!.contains(lat, lng)) return 113
            if (poly[653]!!.contains(lat, lng)) 176 else 79
        } else {
            if (poly[654]!!.contains(lat, lng)) 113 else 79
        } else if (lng < -60.043104f) {
            if (poly[655]!!.contains(lat, lng)) return 85
            if (poly[656]!!.contains(lat, lng)) 113 else 79
        } else if (lat < 3.618829f) {
            if (poly[657]!!.contains(lat, lng)) 113 else 79
        } else {
            if (poly[658]!!.contains(lat, lng)) 79 else 113
        } else if (lat < 2.621818f) if (lng < -57.412368f) {
            if (poly[659]!!.contains(lat, lng)) 113 else 176
        } else if (lat < 1.624807f) 176 else if (lng < -56.754684f) {
            if (poly[660]!!.contains(lat, lng)) return 163
            if (poly[661]!!.contains(lat, lng)) 176 else 113
        } else {
            if (poly[662]!!.contains(lat, lng)) return 113
            if (poly[663]!!.contains(lat, lng)) 163 else 176
        } else {
            if (poly[664]!!.contains(lat, lng)) 163 else 113
        } else if (lng < -58.727736f) if (lat < 6.609862f) if (lng < -60.043104f) if (lat < 5.612851f) {
            if (poly[665]!!.contains(lat, lng)) return 85
            if (poly[666]!!.contains(lat, lng)) return 113
            if (poly[667]!!.contains(lat, lng)) 113 else 79
        } else {
            if (poly[668]!!.contains(lat, lng)) 113 else 85
        } else {
            if (poly[669]!!.contains(lat, lng)) 79 else 113
        } else if (lng < -60.043104f) if (lat < 7.606873f) {
            if (poly[670]!!.contains(lat, lng)) 85 else 113
        } else {
            if (poly[671]!!.contains(lat, lng)) 113 else 85
        } else {
            if (poly[672]!!.contains(lat, lng)) 85 else 113
        } else {
            if (poly[673]!!.contains(lat, lng)) 163 else 113
        }
    }

    private fun call10(lat: Float, lng: Float): Int {
        return if (lat < -9.893535f) if (lng < -71.171189f) {
            if (poly[674]!!.contains(lat, lng)) 175 else 133
        } else if (lng < -68.895567f) if (lat < -11.792956f) {
            if (poly[675]!!.contains(lat, lng)) 133 else 132
        } else {
            if (poly[676]!!.contains(lat, lng)) return 132
            if (poly[677]!!.contains(lat, lng)) 133 else 175
        } else if (lat < -11.792956f) {
            if (poly[678]!!.contains(lat, lng)) 133 else 132
        } else {
            if (poly[679]!!.contains(lat, lng)) 132 else 175
        } else if (lat < -0.193865f) if (lng < -67.558582f) if (lat < -5.043700f) if (lng < -71.174515f) if (lat < -7.468617f) if (lng < -72.982482f) if (lat < -8.681076f) {
            if (poly[680]!!.contains(lat, lng)) return 175
            if (poly[681]!!.contains(lat, lng)) 175 else 133
        } else {
            if (poly[682]!!.contains(lat, lng)) 175 else 133
        } else {
            if (poly[683]!!.contains(lat, lng)) return 101
            if (poly[684]!!.contains(lat, lng)) return 133
            if (poly[685]!!.contains(lat, lng)) 133 else 175
        } else if (lng < -72.982482f) {
            if (poly[686]!!.contains(lat, lng)) return 101
            if (poly[687]!!.contains(lat, lng)) 175 else 133
        } else {
            if (poly[688]!!.contains(lat, lng)) return 133
            if (poly[689]!!.contains(lat, lng)) 175 else 101
        } else {
            if (poly[690]!!.contains(lat, lng)) return 101
            if (poly[691]!!.contains(lat, lng)) return 133
            if (poly[692]!!.contains(lat, lng)) 138 else 175
        } else if (lng < -71.174515f) if (lat < -2.618782f) if (lng < -72.982482f) 133 else if (lat < -3.831241f) if (lng < -72.078499f) {
            if (poly[693]!!.contains(lat, lng)) 101 else 133
        } else {
            if (poly[694]!!.contains(lat, lng)) 133 else 101
        } else 133 else if (lng < -72.982482f) if (lat < -1.406323f) {
            if (poly[695]!!.contains(lat, lng)) 80 else 133
        } else if (lng < -73.886466f) {
            if (poly[696]!!.contains(lat, lng)) 80 else 133
        } else {
            if (poly[697]!!.contains(lat, lng)) 133 else 80
        } else if (lat < -1.406323f) if (lng < -72.078499f) {
            if (poly[698]!!.contains(lat, lng)) 133 else 80
        } else {
            if (poly[699]!!.contains(lat, lng)) 133 else 80
        } else 80 else if (lat < -2.618782f) if (lng < -69.366549f) if (lat < -3.831241f) if (lng < -70.270532f) if (lat < -4.437470f) 101 else if (lng < -70.722524f) {
            if (poly[700]!!.contains(lat, lng)) 133 else 101
        } else {
            if (poly[701]!!.contains(lat, lng)) return 80
            if (poly[702]!!.contains(lat, lng)) return 80
            if (poly[703]!!.contains(lat, lng)) return 80
            if (poly[704]!!.contains(lat, lng)) 101 else 133
        } else {
            if (poly[705]!!.contains(lat, lng)) return 80
            if (poly[706]!!.contains(lat, lng)) return 101
            if (poly[707]!!.contains(lat, lng)) 138 else 133
        } else {
            if (poly[708]!!.contains(lat, lng)) return 80
            if (poly[709]!!.contains(lat, lng)) 138 else 133
        } else 138 else if (lng < -69.366549f) if (lat < -1.406323f) {
            if (poly[710]!!.contains(lat, lng)) return 133
            if (poly[711]!!.contains(lat, lng)) 138 else 80
        } else {
            if (poly[712]!!.contains(lat, lng)) 138 else 80
        } else 138 else {
            if (poly[713]!!.contains(lat, lng)) return 167
            if (poly[714]!!.contains(lat, lng)) 175 else 138
        } else if (lat < 4.205010f) if (lng < -70.705196f) 80 else if (lat < 2.005573f) if (lng < -68.662570f) if (lat < 0.905854f) {
            if (poly[715]!!.contains(lat, lng)) 80 else 138
        } else {
            if (poly[716]!!.contains(lat, lng)) 138 else 80
        } else if (lat < 0.905854f) 138 else if (lng < -67.641257f) {
            if (poly[717]!!.contains(lat, lng)) return 80
            if (poly[718]!!.contains(lat, lng)) 80 else 138
        } else {
            if (poly[719]!!.contains(lat, lng)) return 85
            if (poly[720]!!.contains(lat, lng)) 138 else 80
        } else if (lng < -68.662570f) 80 else if (lat < 3.105291f) {
            if (poly[721]!!.contains(lat, lng)) return 85
            if (poly[722]!!.contains(lat, lng)) return 138
            if (poly[723]!!.contains(lat, lng)) 138 else 80
        } else {
            if (poly[724]!!.contains(lat, lng)) 85 else 80
        } else if (lng < -70.705196f) {
            if (poly[725]!!.contains(lat, lng)) 85 else 80
        } else if (lat < 6.404447f) if (lng < -68.662570f) {
            if (poly[726]!!.contains(lat, lng)) 85 else 80
        } else {
            if (poly[727]!!.contains(lat, lng)) 80 else 85
        } else {
            if (poly[728]!!.contains(lat, lng)) 80 else 85
        }
    }

    private fun call11(lat: Float, lng: Float): Int {
        return if (lng < -45.696978f) if (lat < -4.509060f) if (lat < -9.100719f) if (lng < -48.633171f) if (lat < -11.396548f) if (lng < -50.101268f) if (lat < -12.544463f) if (lng < -50.835316f) 92 else if (lat < -13.118421f) {
            if (poly[729]!!.contains(lat, lng)) 179 else 92
        } else if (lng < -50.468292f) {
            if (poly[730]!!.contains(lat, lng)) return 58
            if (poly[731]!!.contains(lat, lng)) return 179
            if (poly[732]!!.contains(lat, lng)) return 179
            if (poly[733]!!.contains(lat, lng)) 179 else 92
        } else {
            if (poly[734]!!.contains(lat, lng)) return 58
            if (poly[735]!!.contains(lat, lng)) return 58
            if (poly[736]!!.contains(lat, lng)) 58 else 179
        } else {
            if (poly[737]!!.contains(lat, lng)) return 92
            if (poly[738]!!.contains(lat, lng)) 179 else 58
        } else {
            if (poly[739]!!.contains(lat, lng)) 58 else 179
        } else {
            if (poly[740]!!.contains(lat, lng)) return 76
            if (poly[741]!!.contains(lat, lng)) 92 else 58
        } else if (lat < -11.396548f) if (lng < -47.165075f) if (lat < -12.544463f) if (lng < -47.899123f) {
            if (poly[742]!!.contains(lat, lng)) 179 else 58
        } else {
            if (poly[743]!!.contains(lat, lng)) 179 else 58
        } else 58 else if (lat < -12.544463f) if (lng < -46.431026f) {
            if (poly[744]!!.contains(lat, lng)) 179 else 58
        } else {
            if (poly[745]!!.contains(lat, lng)) return 58
            if (poly[746]!!.contains(lat, lng)) 179 else 73
        } else {
            if (poly[747]!!.contains(lat, lng)) 73 else 58
        } else if (lng < -47.165075f) 58 else if (lat < -10.248634f) {
            if (poly[748]!!.contains(lat, lng)) return 73
            if (poly[749]!!.contains(lat, lng)) return 104
            if (poly[750]!!.contains(lat, lng)) 104 else 58
        } else if (lng < -46.431026f) {
            if (poly[751]!!.contains(lat, lng)) 104 else 58
        } else {
            if (poly[752]!!.contains(lat, lng)) return 73
            if (poly[753]!!.contains(lat, lng)) 104 else 58
        } else if (lng < -48.633171f) {
            if (poly[754]!!.contains(lat, lng)) return 58
            if (poly[755]!!.contains(lat, lng)) return 58
            if (poly[756]!!.contains(lat, lng)) 104 else 76
        } else if (lat < -6.804889f) if (lng < -47.165075f) {
            if (poly[757]!!.contains(lat, lng)) 104 else 58
        } else {
            if (poly[758]!!.contains(lat, lng)) 58 else 104
        } else if (lng < -47.165075f) if (lat < -5.656975f) {
            if (poly[759]!!.contains(lat, lng)) return 76
            if (poly[760]!!.contains(lat, lng)) 104 else 58
        } else {
            if (poly[761]!!.contains(lat, lng)) return 58
            if (poly[762]!!.contains(lat, lng)) return 76
            if (poly[763]!!.contains(lat, lng)) 76 else 104
        } else 104 else if (lat < 0.082599f) if (lng < -48.633171f) 76 else if (lat < -2.213230f) if (lng < -47.165075f) {
            if (poly[764]!!.contains(lat, lng)) 104 else 76
        } else if (lat < -3.361145f) {
            if (poly[765]!!.contains(lat, lng)) 76 else 104
        } else if (lng < -46.431026f) {
            if (poly[766]!!.contains(lat, lng)) return 104
            if (poly[767]!!.contains(lat, lng)) return 104
            if (poly[768]!!.contains(lat, lng)) 104 else 76
        } else {
            if (poly[769]!!.contains(lat, lng)) return 76
            if (poly[770]!!.contains(lat, lng)) return 76
            if (poly[771]!!.contains(lat, lng)) return 76
            if (poly[772]!!.contains(lat, lng)) 76 else 104
        } else {
            if (poly[773]!!.contains(lat, lng)) 104 else 76
        } else 76 else if (lat < -7.262677f) if (lng < -40.162602f) if (lat < -10.477527f) {
            if (poly[774]!!.contains(lat, lng)) 104 else 73
        } else if (lng < -42.929790f) {
            if (poly[775]!!.contains(lat, lng)) 104 else 73
        } else if (lat < -8.870102f) if (lng < -41.546196f) {
            if (poly[776]!!.contains(lat, lng)) 73 else 104
        } else {
            if (poly[777]!!.contains(lat, lng)) return 104
            if (poly[778]!!.contains(lat, lng)) 172 else 73
        } else if (lng < -41.546196f) 104 else if (lat < -8.066389f) {
            if (poly[779]!!.contains(lat, lng)) return 73
            if (poly[780]!!.contains(lat, lng)) 104 else 172
        } else {
            if (poly[781]!!.contains(lat, lng)) 172 else 104
        } else if (lat < -10.477527f) if (lng < -38.150959f) {
            if (poly[782]!!.contains(lat, lng)) 136 else 73
        } else {
            if (poly[783]!!.contains(lat, lng)) return 73
            if (poly[784]!!.contains(lat, lng)) 73 else 136
        } else if (lng < -37.395413f) if (lat < -8.870102f) if (lng < -38.779007f) {
            if (poly[785]!!.contains(lat, lng)) 172 else 73
        } else if (lat < -9.673815f) {
            if (poly[786]!!.contains(lat, lng)) 136 else 73
        } else if (lng < -38.087210f) {
            if (poly[787]!!.contains(lat, lng)) return 136
            if (poly[788]!!.contains(lat, lng)) return 172
            if (poly[789]!!.contains(lat, lng)) 172 else 73
        } else {
            if (poly[790]!!.contains(lat, lng)) return 73
            if (poly[791]!!.contains(lat, lng)) return 172
            if (poly[792]!!.contains(lat, lng)) 172 else 136
        } else if (lng < -38.779007f) if (lat < -8.066389f) {
            if (poly[793]!!.contains(lat, lng)) 73 else 172
        } else {
            if (poly[794]!!.contains(lat, lng)) 172 else 104
        } else {
            if (poly[795]!!.contains(lat, lng)) return 73
            if (poly[796]!!.contains(lat, lng)) return 73
            if (poly[797]!!.contains(lat, lng)) return 104
            if (poly[798]!!.contains(lat, lng)) 136 else 172
        } else if (lat < -8.870102f) {
            if (poly[799]!!.contains(lat, lng)) return 172
            if (poly[800]!!.contains(lat, lng)) return 172
            if (poly[801]!!.contains(lat, lng)) return 172
            if (poly[802]!!.contains(lat, lng)) 172 else 136
        } else if (lng < -36.011819f) if (lat < -8.066389f) {
            if (poly[803]!!.contains(lat, lng)) 104 else 172
        } else {
            if (poly[804]!!.contains(lat, lng)) return 172
            if (poly[805]!!.contains(lat, lng)) 172 else 104
        } else {
            if (poly[806]!!.contains(lat, lng)) return 104
            if (poly[807]!!.contains(lat, lng)) return 136
            if (poly[808]!!.contains(lat, lng)) return 136
            if (poly[809]!!.contains(lat, lng)) 136 else 172
        } else 104
    }

    private fun call12(lat: Float, lng: Float): Int {
        return if (lat < 8.603884f) if (lng < -51.569364f) if (lng < -66.619944f) call10(lat, lng) else if (lat < -7.348293f) if (lng < -58.136618f) if (lng < -62.378281f) if (lat < -10.520335f) if (lng < -64.499112f) if (lat < -12.106357f) {
            if (poly[810]!!.contains(lat, lng)) return 167
            if (poly[811]!!.contains(lat, lng)) return 167
            if (poly[812]!!.contains(lat, lng)) 167 else 132
        } else {
            if (poly[813]!!.contains(lat, lng)) 167 else 132
        } else if (lat < -12.106357f) if (lng < -63.438697f) {
            if (poly[814]!!.contains(lat, lng)) return 167
            if (poly[815]!!.contains(lat, lng)) 167 else 132
        } else {
            if (poly[816]!!.contains(lat, lng)) 167 else 132
        } else 167 else if (lng < -64.499112f) if (lat < -8.934314f) if (lng < -65.559528f) if (lat < -9.727325f) {
            if (poly[817]!!.contains(lat, lng)) 167 else 132
        } else {
            if (poly[818]!!.contains(lat, lng)) 167 else 138
        } else {
            if (poly[819]!!.contains(lat, lng)) return 132
            if (poly[820]!!.contains(lat, lng)) 138 else 167
        } else 138 else {
            if (poly[821]!!.contains(lat, lng)) 167 else 138
        } else if (lat < -10.520335f) if (lng < -60.257449f) if (lat < -12.106357f) if (lng < -61.317865f) {
            if (poly[822]!!.contains(lat, lng)) 167 else 132
        } else {
            if (poly[823]!!.contains(lat, lng)) return 92
            if (poly[824]!!.contains(lat, lng)) 132 else 167
        } else {
            if (poly[825]!!.contains(lat, lng)) 92 else 167
        } else {
            if (poly[826]!!.contains(lat, lng)) 167 else 92
        } else if (lng < -60.257449f) if (lat < -8.934314f) {
            if (poly[827]!!.contains(lat, lng)) 167 else 92
        } else {
            if (poly[828]!!.contains(lat, lng)) return 92
            if (poly[829]!!.contains(lat, lng)) 138 else 167
        } else {
            if (poly[830]!!.contains(lat, lng)) 138 else 92
        } else if (lng < -54.852991f) {
            if (poly[831]!!.contains(lat, lng)) 176 else 92
        } else {
            if (poly[832]!!.contains(lat, lng)) return 92
            if (poly[833]!!.contains(lat, lng)) 176 else 76
        } else if (lng < -56.097000f) call9(lat, lng) else if (lat < -0.579146f) if (lat < -3.963720f) if (lng < -53.833182f) 176 else if (lat < -5.656006f) {
            if (poly[834]!!.contains(lat, lng)) 176 else 76
        } else {
            if (poly[835]!!.contains(lat, lng)) 176 else 76
        } else if (lng < -53.833182f) 176 else if (lat < -2.271433f) {
            if (poly[836]!!.contains(lat, lng)) 176 else 76
        } else {
            if (poly[837]!!.contains(lat, lng)) 176 else 76
        } else if (lat < 2.805427f) if (lng < -53.833182f) if (lat < 1.113140f) 176 else if (lng < -54.965091f) {
            if (poly[838]!!.contains(lat, lng)) 176 else 163
        } else if (lat < 1.959283f) {
            if (poly[839]!!.contains(lat, lng)) 76 else 176
        } else if (lng < -54.399136f) {
            if (poly[840]!!.contains(lat, lng)) return 86
            if (poly[841]!!.contains(lat, lng)) return 163
            if (poly[842]!!.contains(lat, lng)) 176 else 76
        } else {
            if (poly[843]!!.contains(lat, lng)) return 76
            if (poly[844]!!.contains(lat, lng)) 163 else 86
        } else if (lat < 1.113140f) {
            if (poly[845]!!.contains(lat, lng)) return 176
            if (poly[846]!!.contains(lat, lng)) 176 else 76
        } else if (lng < -52.701273f) {
            if (poly[847]!!.contains(lat, lng)) return 86
            if (poly[848]!!.contains(lat, lng)) 176 else 76
        } else {
            if (poly[849]!!.contains(lat, lng)) 86 else 76
        } else if (lng < -53.833182f) if (lat < 4.497713f) {
            if (poly[850]!!.contains(lat, lng)) 163 else 86
        } else {
            if (poly[851]!!.contains(lat, lng)) 86 else 163
        } else {
            if (poly[852]!!.contains(lat, lng)) 76 else 86
        } else call11(lat, lng) else if (lng < -67.990797f) if (lng < -69.661226f) if (lng < -70.927056f) if (lat < 11.961238f) if (lng < -72.858752f) {
            if (poly[853]!!.contains(lat, lng)) 85 else 80
        } else {
            if (poly[854]!!.contains(lat, lng)) 85 else 80
        } else {
            if (poly[855]!!.contains(lat, lng)) 85 else 80
        } else {
            if (poly[856]!!.contains(lat, lng)) 85 else 57
        } else {
            if (poly[857]!!.contains(lat, lng)) return 85
            if (poly[858]!!.contains(lat, lng)) 93 else 131
        } else if (lat < 12.324735f) if (lat < 11.562837f) {
            if (poly[859]!!.contains(lat, lng)) 85 else 166
        } else if (lng < -62.404854f) 85 else 109 else if (lng < -60.791134f) if (lng < -61.173214f) {
            if (poly[860]!!.contains(lat, lng)) 109 else 187
        } else {
            if (poly[861]!!.contains(lat, lng)) 185 else 187
        } else 75
    }

    private fun call13(lat: Float, lng: Float): Int {
        return if (lat < -15.609703f) if (lng < 29.455710f) if (lat < -28.570615f) if (lng < 16.475659f) {
            if (poly[862]!!.contains(lat, lng)) 52 else 25
        } else if (lng < 19.544312f) {
            if (poly[863]!!.contains(lat, lng)) 52 else 25
        } else {
            if (poly[864]!!.contains(lat, lng)) 25 else 39
        } else if (lng < 17.410000f) if (lat < -28.032820f) if (lng < 17.080560f) {
            if (poly[865]!!.contains(lat, lng)) 25 else 52
        } else if (lat < -28.399580f) {
            if (poly[866]!!.contains(lat, lng)) 52 else 25
        } else {
            if (poly[867]!!.contains(lat, lng)) 52 else 25
        } else {
            if (poly[868]!!.contains(lat, lng)) 34 else 52
        } else if (lat < -22.090159f) if (lng < 23.432855f) if (lat < -25.330387f) if (lng < 20.421428f) {
            if (poly[869]!!.contains(lat, lng)) 25 else 52
        } else if (lat < -26.950501f) 25 else if (lng < 21.927141f) if (lat < -26.140444f) {
            if (poly[870]!!.contains(lat, lng)) 23 else 25
        } else {
            if (poly[871]!!.contains(lat, lng)) 25 else 23
        } else {
            if (poly[872]!!.contains(lat, lng)) return 23
            if (poly[873]!!.contains(lat, lng)) 23 else 25
        } else {
            if (poly[874]!!.contains(lat, lng)) return 25
            if (poly[875]!!.contains(lat, lng)) return 25
            if (poly[876]!!.contains(lat, lng)) return 25
            if (poly[877]!!.contains(lat, lng)) 52 else 23
        } else if (lat < -25.330387f) {
            if (poly[878]!!.contains(lat, lng)) 23 else 25
        } else if (lng < 26.444282f) {
            if (poly[879]!!.contains(lat, lng)) return 25
            if (poly[880]!!.contains(lat, lng)) 25 else 23
        } else if (lat < -23.710273f) {
            if (poly[881]!!.contains(lat, lng)) 23 else 25
        } else if (lng < 27.949996f) {
            if (poly[882]!!.contains(lat, lng)) 25 else 23
        } else {
            if (poly[883]!!.contains(lat, lng)) return 23
            if (poly[884]!!.contains(lat, lng)) 24 else 25
        } else if (lng < 23.432855f) if (lat < -18.849931f) {
            if (poly[885]!!.contains(lat, lng)) 52 else 23
        } else if (lng < 20.421428f) {
            if (poly[886]!!.contains(lat, lng)) 52 else 34
        } else if (lat < -17.229817f) {
            if (poly[887]!!.contains(lat, lng)) return 23
            if (poly[888]!!.contains(lat, lng)) return 36
            if (poly[889]!!.contains(lat, lng)) 52 else 34
        } else {
            if (poly[890]!!.contains(lat, lng)) 36 else 34
        } else if (lat < -18.849931f) if (lng < 26.444282f) {
            if (poly[891]!!.contains(lat, lng)) 24 else 23
        } else {
            if (poly[892]!!.contains(lat, lng)) 23 else 24
        } else if (lng < 26.444282f) if (lat < -17.229817f) if (lng < 24.938569f) if (lat < -18.039874f) {
            if (poly[893]!!.contains(lat, lng)) return 52
            if (poly[894]!!.contains(lat, lng)) 52 else 23
        } else {
            if (poly[895]!!.contains(lat, lng)) return 23
            if (poly[896]!!.contains(lat, lng)) return 23
            if (poly[897]!!.contains(lat, lng)) return 34
            if (poly[898]!!.contains(lat, lng)) 36 else 52
        } else if (lat < -18.039874f) {
            if (poly[899]!!.contains(lat, lng)) 24 else 23
        } else if (lng < 25.691426f) {
            if (poly[900]!!.contains(lat, lng)) return 23
            if (poly[901]!!.contains(lat, lng)) return 24
            if (poly[902]!!.contains(lat, lng)) 36 else 52
        } else {
            if (poly[903]!!.contains(lat, lng)) 36 else 24
        } else 36 else {
            if (poly[904]!!.contains(lat, lng)) 36 else 24
        } else if (lng < 33.102357f) if (lat < -23.805513f) {
            if (poly[905]!!.contains(lat, lng)) return 38
            if (poly[906]!!.contains(lat, lng)) 40 else 25
        } else if (lat < -19.707608f) if (lat < -21.756560f) {
            if (poly[907]!!.contains(lat, lng)) return 24
            if (poly[908]!!.contains(lat, lng)) 38 else 25
        } else {
            if (poly[909]!!.contains(lat, lng)) 38 else 24
        } else if (lat < -17.658655f) {
            if (poly[910]!!.contains(lat, lng)) 38 else 24
        } else if (lng < 31.279033f) {
            if (poly[911]!!.contains(lat, lng)) return 36
            if (poly[912]!!.contains(lat, lng)) 38 else 24
        } else {
            if (poly[913]!!.contains(lat, lng)) 24 else 38
        } else if (lat < -21.265323f) 38 else if (lng < 36.664969f) if (lat < -18.437513f) 38 else if (lng < 34.883663f) {
            if (poly[914]!!.contains(lat, lng)) 10 else 38
        } else {
            if (poly[915]!!.contains(lat, lng)) 10 else 38
        } else 38 else if (lng < 24.087886f) if (lat < -11.404498f) {
            if (poly[916]!!.contains(lat, lng)) 36 else 34
        } else if (lng < 17.967785f) if (lat < -8.276794f) 34 else if (lng < 14.907735f) {
            if (poly[917]!!.contains(lat, lng)) 30 else 34
        } else if (lat < -6.712941f) {
            if (poly[918]!!.contains(lat, lng)) 30 else 34
        } else {
            if (poly[919]!!.contains(lat, lng)) 34 else 30
        } else if (lat < -8.276794f) if (lng < 21.027836f) 34 else if (lat < -9.840646f) if (lng < 22.557861f) {
            if (poly[920]!!.contains(lat, lng)) 35 else 34
        } else {
            if (poly[921]!!.contains(lat, lng)) return 35
            if (poly[922]!!.contains(lat, lng)) 36 else 34
        } else {
            if (poly[923]!!.contains(lat, lng)) 35 else 34
        } else if (lng < 21.027836f) if (lat < -6.712941f) {
            if (poly[924]!!.contains(lat, lng)) return 30
            if (poly[925]!!.contains(lat, lng)) 35 else 34
        } else {
            if (poly[926]!!.contains(lat, lng)) 35 else 30
        } else {
            if (poly[927]!!.contains(lat, lng)) 34 else 35
        } else if (lng < 33.701099f) if (lat < -13.998540f) if (lng < 33.239352f) {
            if (poly[928]!!.contains(lat, lng)) return 10
            if (poly[929]!!.contains(lat, lng)) return 10
            if (poly[930]!!.contains(lat, lng)) 38 else 36
        } else {
            if (poly[931]!!.contains(lat, lng)) 10 else 38
        } else if (lng < 30.792749f) if (lat < -8.271282f) if (lng < 27.440317f) if (lat < -11.134911f) if (lng < 25.764102f) {
            if (poly[932]!!.contains(lat, lng)) 35 else 36
        } else {
            if (poly[933]!!.contains(lat, lng)) 36 else 35
        } else {
            if (poly[934]!!.contains(lat, lng)) 36 else 35
        } else if (lat < -11.134911f) if (lng < 29.116533f) if (lat < -12.566726f) {
            if (poly[935]!!.contains(lat, lng)) 35 else 36
        } else if (lng < 28.278425f) {
            if (poly[936]!!.contains(lat, lng)) 36 else 35
        } else {
            if (poly[937]!!.contains(lat, lng)) return 36
            if (poly[938]!!.contains(lat, lng)) 36 else 35
        } else {
            if (poly[939]!!.contains(lat, lng)) 35 else 36
        } else {
            if (poly[940]!!.contains(lat, lng)) 36 else 35
        } else {
            if (poly[941]!!.contains(lat, lng)) 18 else 35
        } else if (lat < -9.573815f) if (lat < -11.786177f) {
            if (poly[942]!!.contains(lat, lng)) return 36
            if (poly[943]!!.contains(lat, lng)) 36 else 10
        } else {
            if (poly[944]!!.contains(lat, lng)) return 18
            if (poly[945]!!.contains(lat, lng)) 36 else 10
        } else {
            if (poly[946]!!.contains(lat, lng)) return 10
            if (poly[947]!!.contains(lat, lng)) 36 else 18
        } else if (lat < -14.386368f) if (lng < 34.358479f) {
            if (poly[948]!!.contains(lat, lng)) 10 else 38
        } else if (lng < 34.622374f) if (lat < -15.002667f) {
            if (poly[949]!!.contains(lat, lng)) 38 else 10
        } else {
            if (poly[950]!!.contains(lat, lng)) 10 else 38
        } else {
            if (poly[951]!!.contains(lat, lng)) 38 else 10
        } else if (lat < -9.767729f) if (lng < 36.964340f) if (lat < -12.077048f) {
            if (poly[952]!!.contains(lat, lng)) 38 else 10
        } else if (lng < 35.332719f) {
            if (poly[953]!!.contains(lat, lng)) return 18
            if (poly[954]!!.contains(lat, lng)) 38 else 10
        } else {
            if (poly[955]!!.contains(lat, lng)) 38 else 18
        } else {
            if (poly[956]!!.contains(lat, lng)) 38 else 18
        } else {
            if (poly[957]!!.contains(lat, lng)) 10 else 18
        }
    }

    private fun call14(lat: Float, lng: Float): Int {
        return if (lat < 15.084000f) if (lng < -0.723987f) if (lat < 9.636901f) if (lng < -4.045655f) {
            if (poly[958]!!.contains(lat, lng)) 47 else 1
        } else if (lat < 7.088077f) {
            if (poly[959]!!.contains(lat, lng)) 1 else 2
        } else {
            if (poly[960]!!.contains(lat, lng)) return 2
            if (poly[961]!!.contains(lat, lng)) 47 else 1
        } else if (lng < -4.045655f) if (lat < 12.360451f) if (lng < -5.706489f) if (lat < 10.998676f) if (lng < -6.536906f) {
            if (poly[962]!!.contains(lat, lng)) 6 else 1
        } else {
            if (poly[963]!!.contains(lat, lng)) 1 else 6
        } else 6 else if (lat < 10.998676f) if (lng < -4.876072f) if (lat < 10.317788f) {
            if (poly[964]!!.contains(lat, lng)) return 47
            if (poly[965]!!.contains(lat, lng)) return 47
            if (poly[966]!!.contains(lat, lng)) 47 else 1
        } else {
            if (poly[967]!!.contains(lat, lng)) return 1
            if (poly[968]!!.contains(lat, lng)) return 1
            if (poly[969]!!.contains(lat, lng)) return 1
            if (poly[970]!!.contains(lat, lng)) 6 else 47
        } else {
            if (poly[971]!!.contains(lat, lng)) 47 else 1
        } else {
            if (poly[972]!!.contains(lat, lng)) 47 else 6
        } else {
            if (poly[973]!!.contains(lat, lng)) 47 else 6
        } else if (lat < 12.360451f) if (lng < -2.384821f) {
            if (poly[974]!!.contains(lat, lng)) return 1
            if (poly[975]!!.contains(lat, lng)) 2 else 47
        } else {
            if (poly[976]!!.contains(lat, lng)) 47 else 2
        } else {
            if (poly[977]!!.contains(lat, lng)) 6 else 47
        } else if (lng < 2.408972f) if (lat < 11.895485f) if (lat < 8.466663f) if (lat < 6.752252f) {
            if (poly[978]!!.contains(lat, lng)) return 2
            if (poly[979]!!.contains(lat, lng)) 48 else 33
        } else if (lng < 0.842492f) {
            if (poly[980]!!.contains(lat, lng)) 33 else 2
        } else {
            if (poly[981]!!.contains(lat, lng)) 48 else 33
        } else if (lat < 10.181074f) if (lng < 0.842492f) if (lat < 9.323868f) {
            if (poly[982]!!.contains(lat, lng)) 33 else 2
        } else {
            if (poly[983]!!.contains(lat, lng)) 33 else 2
        } else {
            if (poly[984]!!.contains(lat, lng)) 48 else 33
        } else if (lng < 0.842492f) if (lat < 11.038280f) if (lng < 0.059253f) {
            if (poly[985]!!.contains(lat, lng)) return 33
            if (poly[986]!!.contains(lat, lng)) 47 else 2
        } else {
            if (poly[987]!!.contains(lat, lng)) return 2
            if (poly[988]!!.contains(lat, lng)) return 47
            if (poly[989]!!.contains(lat, lng)) 48 else 33
        } else {
            if (poly[990]!!.contains(lat, lng)) return 33
            if (poly[991]!!.contains(lat, lng)) 47 else 2
        } else if (lat < 11.038280f) {
            if (poly[992]!!.contains(lat, lng)) return 33
            if (poly[993]!!.contains(lat, lng)) return 33
            if (poly[994]!!.contains(lat, lng)) return 47
            if (poly[995]!!.contains(lat, lng)) 47 else 48
        } else {
            if (poly[996]!!.contains(lat, lng)) return 48
            if (poly[997]!!.contains(lat, lng)) 48 else 47
        } else if (lat < 13.489743f) {
            if (poly[998]!!.contains(lat, lng)) return 47
            if (poly[999]!!.contains(lat, lng)) return 48
            if (poly[1000]!!.contains(lat, lng)) 48 else 45
        } else {
            if (poly[1001]!!.contains(lat, lng)) return 6
            if (poly[1002]!!.contains(lat, lng)) 47 else 45
        } else if (lat < 9.576548f) if (lat < 6.822822f) {
            if (poly[1003]!!.contains(lat, lng)) 48 else 31
        } else {
            if (poly[1004]!!.contains(lat, lng)) 48 else 31
        } else if (lat < 12.330274f) if (lng < 5.039725f) if (lat < 10.953411f) {
            if (poly[1005]!!.contains(lat, lng)) 48 else 31
        } else if (lng < 3.724348f) {
            if (poly[1006]!!.contains(lat, lng)) return 31
            if (poly[1007]!!.contains(lat, lng)) return 45
            if (poly[1008]!!.contains(lat, lng)) return 45
            if (poly[1009]!!.contains(lat, lng)) 45 else 48
        } else {
            if (poly[1010]!!.contains(lat, lng)) 48 else 31
        } else 31 else {
            if (poly[1011]!!.contains(lat, lng)) return 31
            if (poly[1012]!!.contains(lat, lng)) 48 else 45
        } else if (lng < 0.151578f) {
            if (poly[1013]!!.contains(lat, lng)) return 4
            if (poly[1014]!!.contains(lat, lng)) 46 else 6
        } else if (lat < 21.258772f) if (lng < 3.911028f) if (lat < 18.171386f) {
            if (poly[1015]!!.contains(lat, lng)) 45 else 6
        } else if (lng < 2.031303f) {
            if (poly[1016]!!.contains(lat, lng)) 4 else 6
        } else {
            if (poly[1017]!!.contains(lat, lng)) 4 else 6
        } else {
            if (poly[1018]!!.contains(lat, lng)) return 4
            if (poly[1019]!!.contains(lat, lng)) 6 else 45
        } else {
            if (poly[1020]!!.contains(lat, lng)) 6 else 4
        }
    }

    private fun call15(lat: Float, lng: Float): Int {
        return if (lng < 18.643611f) if (lat < 3.989000f) if (lat < -4.388063f) if (lng < 14.197547f) if (lng < 12.745379f) {
            if (poly[1021]!!.contains(lat, lng)) return 11
            if (poly[1022]!!.contains(lat, lng)) 30 else 34
        } else if (lng < 13.471463f) {
            if (poly[1023]!!.contains(lat, lng)) return 30
            if (poly[1024]!!.contains(lat, lng)) 34 else 11
        } else {
            if (poly[1025]!!.contains(lat, lng)) 11 else 30
        } else {
            if (poly[1026]!!.contains(lat, lng)) 11 else 30
        } else if (lng < 14.539444f) if (lat < -0.589167f) if (lat < -4.278450f) {
            if (poly[1027]!!.contains(lat, lng)) 30 else 11
        } else if (lng < 11.519834f) {
            if (poly[1028]!!.contains(lat, lng)) 11 else 32
        } else if (lat < -2.433809f) {
            if (poly[1029]!!.contains(lat, lng)) return 32
            if (poly[1030]!!.contains(lat, lng)) return 32
            if (poly[1031]!!.contains(lat, lng)) return 32
            if (poly[1032]!!.contains(lat, lng)) 32 else 11
        } else if (lng < 13.029639f) {
            if (poly[1033]!!.contains(lat, lng)) return 11
            if (poly[1034]!!.contains(lat, lng)) 11 else 32
        } else if (lat < -1.511488f) {
            if (poly[1035]!!.contains(lat, lng)) 32 else 11
        } else {
            if (poly[1036]!!.contains(lat, lng)) 11 else 32
        } else if (lat < 2.449845f) if (lng < 11.529307f) {
            if (poly[1037]!!.contains(lat, lng)) return 20
            if (poly[1038]!!.contains(lat, lng)) 32 else 37
        } else if (lat < 0.930339f) {
            if (poly[1039]!!.contains(lat, lng)) 32 else 11
        } else if (lng < 13.034375f) {
            if (poly[1040]!!.contains(lat, lng)) 32 else 20
        } else if (lat < 1.690092f) {
            if (poly[1041]!!.contains(lat, lng)) 11 else 32
        } else {
            if (poly[1042]!!.contains(lat, lng)) return 11
            if (poly[1043]!!.contains(lat, lng)) 20 else 32
        } else {
            if (poly[1044]!!.contains(lat, lng)) 20 else 37
        } else if (lat < -0.199531f) {
            if (poly[1045]!!.contains(lat, lng)) 30 else 11
        } else if (lat < 1.894734f) {
            if (poly[1046]!!.contains(lat, lng)) return 20
            if (poly[1047]!!.contains(lat, lng)) 30 else 11
        } else if (lng < 16.591527f) if (lat < 2.941867f) if (lng < 15.565486f) {
            if (poly[1048]!!.contains(lat, lng)) 20 else 11
        } else {
            if (poly[1049]!!.contains(lat, lng)) return 7
            if (poly[1050]!!.contains(lat, lng)) return 11
            if (poly[1051]!!.contains(lat, lng)) 11 else 20
        } else {
            if (poly[1052]!!.contains(lat, lng)) return 11
            if (poly[1053]!!.contains(lat, lng)) 20 else 7
        } else if (lat < 2.941867f) {
            if (poly[1054]!!.contains(lat, lng)) 30 else 11
        } else {
            if (poly[1055]!!.contains(lat, lng)) return 7
            if (poly[1056]!!.contains(lat, lng)) 30 else 11
        } else if (lng < 8.831418f) {
            if (poly[1057]!!.contains(lat, lng)) 31 else 20
        } else if (lng < 15.179509f) if (lat < 4.056659f) {
            if (poly[1058]!!.contains(lat, lng)) 7 else 20
        } else {
            if (poly[1059]!!.contains(lat, lng)) 7 else 20
        } else {
            if (poly[1060]!!.contains(lat, lng)) 30 else 7
        } else if (lat < 0.121457f) if (lng < 23.048844f) if (lat < -2.513816f) {
            if (poly[1061]!!.contains(lat, lng)) 35 else 30
        } else {
            if (poly[1062]!!.contains(lat, lng)) return 35
            if (poly[1063]!!.contains(lat, lng)) return 35
            if (poly[1064]!!.contains(lat, lng)) return 35
            if (poly[1065]!!.contains(lat, lng)) 35 else 30
        } else if (lat < -2.513816f) 35 else if (lng < 25.251460f) if (lat < -1.196180f) {
            if (poly[1066]!!.contains(lat, lng)) 30 else 35
        } else {
            if (poly[1067]!!.contains(lat, lng)) 35 else 30
        } else 35 else if (lng < 23.048844f) if (lat < 2.756730f) {
            if (poly[1068]!!.contains(lat, lng)) return 35
            if (poly[1069]!!.contains(lat, lng)) 35 else 30
        } else if (lng < 20.846227f) {
            if (poly[1070]!!.contains(lat, lng)) return 7
            if (poly[1071]!!.contains(lat, lng)) 7 else 30
        } else if (lat < 4.074367f) {
            if (poly[1072]!!.contains(lat, lng)) return 35
            if (poly[1073]!!.contains(lat, lng)) return 35
            if (poly[1074]!!.contains(lat, lng)) 35 else 30
        } else {
            if (poly[1075]!!.contains(lat, lng)) return 30
            if (poly[1076]!!.contains(lat, lng)) 35 else 7
        } else if (lat < 2.756730f) {
            if (poly[1077]!!.contains(lat, lng)) return 30
            if (poly[1078]!!.contains(lat, lng)) 30 else 35
        } else if (lng < 25.251460f) if (lat < 4.074367f) {
            if (poly[1079]!!.contains(lat, lng)) return 30
            if (poly[1080]!!.contains(lat, lng)) 30 else 35
        } else if (lng < 24.150152f) {
            if (poly[1081]!!.contains(lat, lng)) 35 else 7
        } else {
            if (poly[1082]!!.contains(lat, lng)) 35 else 7
        } else if (lat < 4.074367f) 35 else if (lng < 26.352768f) if (lat < 4.733185f) 35 else if (lng < 25.802114f) {
            if (poly[1083]!!.contains(lat, lng)) 35 else 7
        } else {
            if (poly[1084]!!.contains(lat, lng)) return 35
            if (poly[1085]!!.contains(lat, lng)) 35 else 7
        } else {
            if (poly[1086]!!.contains(lat, lng)) return 26
            if (poly[1087]!!.contains(lat, lng)) 35 else 7
        }
    }

    private fun call16(lat: Float, lng: Float): Int {
        return if (lng < 15.996667f) if (lat < 20.353056f) if (lat < 12.872529f) if (lng < 11.833573f) if (lat < 9.132266f) if (lng < 9.752025f) {
            if (poly[1088]!!.contains(lat, lng)) 20 else 31
        } else if (lat < 7.262135f) if (lng < 10.792799f) {
            if (poly[1089]!!.contains(lat, lng)) 31 else 20
        } else {
            if (poly[1090]!!.contains(lat, lng)) 20 else 31
        } else 31 else {
            if (poly[1091]!!.contains(lat, lng)) 45 else 31
        } else if (lat < 9.132266f) if (lng < 13.915120f) {
            if (poly[1092]!!.contains(lat, lng)) 31 else 20
        } else if (lat < 7.262135f) {
            if (poly[1093]!!.contains(lat, lng)) 7 else 20
        } else {
            if (poly[1094]!!.contains(lat, lng)) return 7
            if (poly[1095]!!.contains(lat, lng)) 20 else 44
        } else if (lng < 13.915120f) {
            if (poly[1096]!!.contains(lat, lng)) 20 else 31
        } else if (lat < 11.002398f) {
            if (poly[1097]!!.contains(lat, lng)) 44 else 20
        } else if (lng < 14.955893f) if (lat < 11.937464f) {
            if (poly[1098]!!.contains(lat, lng)) 31 else 20
        } else {
            if (poly[1099]!!.contains(lat, lng)) return 31
            if (poly[1100]!!.contains(lat, lng)) 44 else 20
        } else {
            if (poly[1101]!!.contains(lat, lng)) 44 else 20
        } else if (lng < 11.833573f) {
            if (poly[1102]!!.contains(lat, lng)) 45 else 31
        } else if (lat < 16.612793f) if (lng < 13.915120f) if (lat < 14.742661f) if (lng < 12.874346f) {
            if (poly[1103]!!.contains(lat, lng)) 45 else 31
        } else {
            if (poly[1104]!!.contains(lat, lng)) return 31
            if (poly[1105]!!.contains(lat, lng)) 44 else 45
        } else {
            if (poly[1106]!!.contains(lat, lng)) 44 else 45
        } else {
            if (poly[1107]!!.contains(lat, lng)) return 20
            if (poly[1108]!!.contains(lat, lng)) return 31
            if (poly[1109]!!.contains(lat, lng)) 45 else 44
        } else {
            if (poly[1110]!!.contains(lat, lng)) 44 else 45
        } else if (lng < 11.833573f) {
            if (poly[1111]!!.contains(lat, lng)) return 45
            if (poly[1112]!!.contains(lat, lng)) 50 else 4
        } else {
            if (poly[1113]!!.contains(lat, lng)) return 4
            if (poly[1114]!!.contains(lat, lng)) return 44
            if (poly[1115]!!.contains(lat, lng)) 50 else 45
        } else if (lat < 11.001389f) if (lng < 21.725372f) if (lng < 18.861019f) if (lat < 8.196696f) if (lng < 17.428843f) {
            if (poly[1116]!!.contains(lat, lng)) 44 else 7
        } else {
            if (poly[1117]!!.contains(lat, lng)) 44 else 7
        } else {
            if (poly[1118]!!.contains(lat, lng)) 7 else 44
        } else if (lat < 8.196696f) 7 else if (lng < 20.293195f) if (lat < 9.599042f) if (lng < 19.577107f) {
            if (poly[1119]!!.contains(lat, lng)) 44 else 7
        } else {
            if (poly[1120]!!.contains(lat, lng)) 44 else 7
        } else 44 else {
            if (poly[1121]!!.contains(lat, lng)) 44 else 7
        } else if (lng < 24.589724f) if (lat < 8.196696f) 7 else if (lng < 23.157548f) {
            if (poly[1122]!!.contains(lat, lng)) return 28
            if (poly[1123]!!.contains(lat, lng)) return 44
            if (poly[1124]!!.contains(lat, lng)) 44 else 7
        } else if (lat < 9.599042f) if (lng < 23.873636f) {
            if (poly[1125]!!.contains(lat, lng)) return 26
            if (poly[1126]!!.contains(lat, lng)) 28 else 7
        } else {
            if (poly[1127]!!.contains(lat, lng)) return 7
            if (poly[1128]!!.contains(lat, lng)) 26 else 28
        } else {
            if (poly[1129]!!.contains(lat, lng)) return 7
            if (poly[1130]!!.contains(lat, lng)) 28 else 26
        } else if (lat < 8.196696f) if (lng < 26.021900f) {
            if (poly[1131]!!.contains(lat, lng)) 26 else 7
        } else {
            if (poly[1132]!!.contains(lat, lng)) 7 else 26
        } else if (lng < 26.021900f) if (lat < 9.599042f) {
            if (poly[1133]!!.contains(lat, lng)) return 7
            if (poly[1134]!!.contains(lat, lng)) 26 else 28
        } else if (lng < 25.305812f) {
            if (poly[1135]!!.contains(lat, lng)) 28 else 26
        } else {
            if (poly[1136]!!.contains(lat, lng)) 28 else 26
        } else {
            if (poly[1137]!!.contains(lat, lng)) 28 else 26
        } else if (lat < 19.217466f) if (lng < 21.725372f) 44 else if (lat < 15.109428f) if (lng < 24.589724f) if (lat < 13.055408f) {
            if (poly[1138]!!.contains(lat, lng)) 28 else 44
        } else {
            if (poly[1139]!!.contains(lat, lng)) 44 else 28
        } else 28 else {
            if (poly[1140]!!.contains(lat, lng)) 44 else 28
        } else {
            if (poly[1141]!!.contains(lat, lng)) return 13
            if (poly[1142]!!.contains(lat, lng)) return 28
            if (poly[1143]!!.contains(lat, lng)) 44 else 50
        }
    }

    private fun call17(lat: Float, lng: Float): Int {
        return if (lat < 5.002966f) if (lng < 31.305676f) if (lat < 2.156907f) if (lat < -1.496091f) if (lng < 29.379876f) if (lat < -3.322590f) {
            if (poly[1144]!!.contains(lat, lng)) return 12
            if (poly[1145]!!.contains(lat, lng)) 18 else 35
        } else if (lng < 28.416976f) 35 else if (lat < -2.409340f) {
            if (poly[1146]!!.contains(lat, lng)) return 29
            if (poly[1147]!!.contains(lat, lng)) 35 else 12
        } else {
            if (poly[1148]!!.contains(lat, lng)) 29 else 35
        } else if (lat < -3.322590f) {
            if (poly[1149]!!.contains(lat, lng)) return 12
            if (poly[1150]!!.contains(lat, lng)) return 35
            if (poly[1151]!!.contains(lat, lng)) 35 else 18
        } else if (lng < 30.342776f) {
            if (poly[1152]!!.contains(lat, lng)) return 12
            if (poly[1153]!!.contains(lat, lng)) 35 else 29
        } else if (lat < -2.409340f) {
            if (poly[1154]!!.contains(lat, lng)) return 12
            if (poly[1155]!!.contains(lat, lng)) return 29
            if (poly[1156]!!.contains(lat, lng)) 29 else 18
        } else {
            if (poly[1157]!!.contains(lat, lng)) return 12
            if (poly[1158]!!.contains(lat, lng)) return 18
            if (poly[1159]!!.contains(lat, lng)) 18 else 29
        } else if (lng < 29.379876f) 35 else if (lat < 0.330408f) if (lng < 30.342776f) {
            if (poly[1160]!!.contains(lat, lng)) return 29
            if (poly[1161]!!.contains(lat, lng)) 35 else 27
        } else {
            if (poly[1162]!!.contains(lat, lng)) return 27
            if (poly[1163]!!.contains(lat, lng)) 29 else 18
        } else {
            if (poly[1164]!!.contains(lat, lng)) 27 else 35
        } else if (lng < 29.379876f) {
            if (poly[1165]!!.contains(lat, lng)) 35 else 26
        } else if (lat < 3.579937f) {
            if (poly[1166]!!.contains(lat, lng)) return 26
            if (poly[1167]!!.contains(lat, lng)) 27 else 35
        } else if (lng < 30.342776f) {
            if (poly[1168]!!.contains(lat, lng)) 35 else 26
        } else {
            if (poly[1169]!!.contains(lat, lng)) return 27
            if (poly[1170]!!.contains(lat, lng)) 35 else 26
        } else if (lat < -0.998942f) {
            if (poly[1171]!!.contains(lat, lng)) return 27
            if (poly[1172]!!.contains(lat, lng)) return 27
            if (poly[1173]!!.contains(lat, lng)) 43 else 18
        } else if (lng < 35.766628f) if (lat < 2.002012f) {
            if (poly[1174]!!.contains(lat, lng)) 43 else 27
        } else if (lng < 33.536152f) {
            if (poly[1175]!!.contains(lat, lng)) 27 else 26
        } else {
            if (poly[1176]!!.contains(lat, lng)) return 26
            if (poly[1177]!!.contains(lat, lng)) 27 else 43
        } else {
            if (poly[1178]!!.contains(lat, lng)) return 3
            if (poly[1179]!!.contains(lat, lng)) 26 else 43
        } else if (lat < 18.070992f) if (lat < 11.536979f) if (lng < 33.840828f) if (lat < 8.269973f) {
            if (poly[1180]!!.contains(lat, lng)) 26 else 3
        } else if (lng < 30.647452f) {
            if (poly[1181]!!.contains(lat, lng)) 26 else 28
        } else {
            if (poly[1182]!!.contains(lat, lng)) return 3
            if (poly[1183]!!.contains(lat, lng)) return 28
            if (poly[1184]!!.contains(lat, lng)) 28 else 26
        } else if (lat < 8.269973f) if (lng < 37.034204f) if (lat < 6.636469f) {
            if (poly[1185]!!.contains(lat, lng)) 26 else 3
        } else {
            if (poly[1186]!!.contains(lat, lng)) 26 else 3
        } else 3 else if (lng < 37.034204f) if (lat < 9.903476f) {
            if (poly[1187]!!.contains(lat, lng)) return 26
            if (poly[1188]!!.contains(lat, lng)) 28 else 3
        } else {
            if (poly[1189]!!.contains(lat, lng)) return 3
            if (poly[1190]!!.contains(lat, lng)) 26 else 28
        } else 3 else if (lng < 33.840828f) {
            if (poly[1191]!!.contains(lat, lng)) 26 else 28
        } else if (lat < 14.803986f) if (lng < 37.034204f) {
            if (poly[1192]!!.contains(lat, lng)) return 5
            if (poly[1193]!!.contains(lat, lng)) 28 else 3
        } else if (lat < 13.170482f) 3 else if (lng < 38.630892f) {
            if (poly[1194]!!.contains(lat, lng)) return 5
            if (poly[1195]!!.contains(lat, lng)) 5 else 3
        } else {
            if (poly[1196]!!.contains(lat, lng)) 5 else 3
        } else if (lng < 37.034204f) {
            if (poly[1197]!!.contains(lat, lng)) 5 else 28
        } else {
            if (poly[1198]!!.contains(lat, lng)) return 3
            if (poly[1199]!!.contains(lat, lng)) 28 else 5
        } else if (lng < 33.840828f) {
            if (poly[1200]!!.contains(lat, lng)) 28 else 13
        } else if (lat < 22.752268f) {
            if (poly[1201]!!.contains(lat, lng)) return 13
            if (poly[1202]!!.contains(lat, lng)) 272 else 28
        } else {
            if (poly[1203]!!.contains(lat, lng)) 272 else 13
        }
    }

    private fun call18(lat: Float, lng: Float): Int {
        return if (lat < -13.692378f) if (lat < -28.393264f) if (lat < -45.999874f) if (lat < -56.248000f) if (lat < -61.600000f) if (lat < -66.000000f) if (lat < -86.000000f) 205 else if (lng < -67.500000f) 207 else {
            if (poly[1204]!!.contains(lat, lng)) 207 else 70
        } else if (lat < -64.000000f) {
            if (poly[1205]!!.contains(lat, lng)) 206 else 70
        } else {
            if (poly[1206]!!.contains(lat, lng)) 169 else 70
        } else if (lat < -58.362500f) 70 else 169 else if (lng < -63.453630f) if (lng < -69.122039f) if (lat < -50.972131f) {
            if (poly[1207]!!.contains(lat, lng)) 65 else 169
        } else if (lng < -71.956244f) if (lat < -48.486002f) if (lng < -73.373347f) {
            if (poly[1208]!!.contains(lat, lng)) return 65
            if (poly[1209]!!.contains(lat, lng)) return 65
            if (poly[1210]!!.contains(lat, lng)) 177 else 169
        } else if (lat < -49.729067f) {
            if (poly[1211]!!.contains(lat, lng)) 65 else 169
        } else {
            if (poly[1212]!!.contains(lat, lng)) return 169
            if (poly[1213]!!.contains(lat, lng)) return 177
            if (poly[1214]!!.contains(lat, lng)) 177 else 65
        } else {
            if (poly[1215]!!.contains(lat, lng)) return 65
            if (poly[1216]!!.contains(lat, lng)) return 65
            if (poly[1217]!!.contains(lat, lng)) return 65
            if (poly[1218]!!.contains(lat, lng)) 65 else 177
        } else {
            if (poly[1219]!!.contains(lat, lng)) return 60
            if (poly[1220]!!.contains(lat, lng)) return 177
            if (poly[1221]!!.contains(lat, lng)) return 177
            if (poly[1222]!!.contains(lat, lng)) 177 else 65
        } else if (lat < -51.089499f) {
            if (poly[1223]!!.contains(lat, lng)) return 65
            if (poly[1224]!!.contains(lat, lng)) 169 else 70
        } else {
            if (poly[1225]!!.contains(lat, lng)) 60 else 65
        } else if (lng < -57.366237f) 304 else 302 else call6(lat, lng) else if (lng < -58.171500f) call8(lat, lng) else if (lat < -27.383750f) if (lng < -56.929806f) if (lng < -57.411484f) {
            if (poly[1226]!!.contains(lat, lng)) 71 else 61
        } else {
            if (poly[1227]!!.contains(lat, lng)) 71 else 61
        } else if (lng < -56.217655f) {
            if (poly[1228]!!.contains(lat, lng)) 71 else 61
        } else if (lng < -52.173129f) if (lng < -54.195392f) if (lng < -55.206523f) {
            if (poly[1229]!!.contains(lat, lng)) return 71
            if (poly[1230]!!.contains(lat, lng)) return 179
            if (poly[1231]!!.contains(lat, lng)) 179 else 61
        } else {
            if (poly[1232]!!.contains(lat, lng)) 61 else 179
        } else 179 else 179 else call7(lat, lng) else if (lat < 13.583000f) call12(lat, lng) else if (lng < -64.059729f) if (lng < -70.864359f) if (lat < 20.888781f) if (lng < -72.827404f) {
            if (poly[1233]!!.contains(lat, lng)) return 115
            if (poly[1234]!!.contains(lat, lng)) 152 else 165
        } else if (lat < 19.079476f) {
            if (poly[1235]!!.contains(lat, lng)) 165 else 178
        } else {
            if (poly[1236]!!.contains(lat, lng)) 178 else 165
        } else {
            if (poly[1237]!!.contains(lat, lng)) return 152
            if (poly[1238]!!.contains(lat, lng)) 178 else 108
        } else if (lng < -67.633762f) if (lng < -68.110146f) {
            if (poly[1239]!!.contains(lat, lng)) 168 else 178
        } else 168 else if (lat < 17.995840f) if (lng < -65.116124f) 168 else 186 else if (lng < -65.040186f) {
            if (poly[1240]!!.contains(lat, lng)) 186 else 168
        } else {
            if (poly[1241]!!.contains(lat, lng)) 186 else 194
        } else if (lng < -62.584402f) if (lat < 17.615815f) if (lat < 15.915843f) 85 else {
            if (poly[1242]!!.contains(lat, lng)) 131 else 184
        } else {
            if (poly[1243]!!.contains(lat, lng)) return 131
            if (poly[1244]!!.contains(lat, lng)) return 135
            if (poly[1245]!!.contains(lat, lng)) return 139
            if (poly[1246]!!.contains(lat, lng)) 182 else 55
        } else if (lat < 15.787222f) if (lat < 15.079510f) if (lat < 14.272500f) if (lng < -61.003889f) {
            if (poly[1247]!!.contains(lat, lng)) 140 else 185
        } else {
            if (poly[1248]!!.contains(lat, lng)) 140 else 185
        } else {
            if (poly[1249]!!.contains(lat, lng)) 99 else 140
        } else if (lng < -61.442500f) {
            if (poly[1250]!!.contains(lat, lng)) 110 else 99
        } else {
            if (poly[1251]!!.contains(lat, lng)) 110 else 99
        } else if (lng < -62.140067f) {
            if (poly[1252]!!.contains(lat, lng)) return 56
            if (poly[1253]!!.contains(lat, lng)) 184 else 151
        } else if (lat < 16.714000f) {
            if (poly[1254]!!.contains(lat, lng)) 151 else 110
        } else {
            if (poly[1255]!!.contains(lat, lng)) 151 else 56
        }
    }

    private fun call19(lat: Float, lng: Float): Int {
        return if (lat < -5.149089f) if (lat < -36.862000f) if (lat < -58.803000f) if (lat < -65.969656f) if (lng < -5.500000f) if (lat < -86.000000f) 205 else {
            if (poly[1256]!!.contains(lat, lng)) 317 else 207
        } else if (lat < -86.000000f) 205 else if (lng < 0.000000f) 25 else {
            if (poly[1257]!!.contains(lat, lng)) 209 else 208
        } else 302 else if (lng < -25.846830f) 302 else if (lng < -9.611753f) 303 else 25 else if (lng < -5.423415f) if (lng < -34.599531f) 104 else 303 else call13(
            lat,
            lng
        ) else if (lng < 7.670478f) if (lng < -7.367323f) if (lat < 10.462040f) if (lng < -15.238664f) if (lat < 3.393091f) 16 else 156 else if (lat < 9.999973f) if (lng < -10.881472f) if (lat < 8.056728f) {
            if (poly[1258]!!.contains(lat, lng)) 42 else 22
        } else if (lng < -12.638547f) {
            if (poly[1259]!!.contains(lat, lng)) 22 else 16
        } else {
            if (poly[1260]!!.contains(lat, lng)) 22 else 16
        } else if (lat < 7.077782f) if (lng < -9.124398f) 42 else if (lat < 5.616687f) {
            if (poly[1261]!!.contains(lat, lng)) 1 else 42
        } else if (lng < -8.245860f) {
            if (poly[1262]!!.contains(lat, lng)) 1 else 42
        } else {
            if (poly[1263]!!.contains(lat, lng)) 42 else 1
        } else if (lng < -9.124398f) if (lat < 8.538878f) if (lng < -10.002935f) {
            if (poly[1264]!!.contains(lat, lng)) return 16
            if (poly[1265]!!.contains(lat, lng)) 42 else 22
        } else {
            if (poly[1266]!!.contains(lat, lng)) 42 else 16
        } else {
            if (poly[1267]!!.contains(lat, lng)) return 22
            if (poly[1268]!!.contains(lat, lng)) 42 else 16
        } else if (lat < 8.538878f) if (lng < -8.245860f) {
            if (poly[1269]!!.contains(lat, lng)) return 1
            if (poly[1270]!!.contains(lat, lng)) 16 else 42
        } else {
            if (poly[1271]!!.contains(lat, lng)) 16 else 1
        } else {
            if (poly[1272]!!.contains(lat, lng)) 16 else 1
        } else {
            if (poly[1273]!!.contains(lat, lng)) return 1
            if (poly[1274]!!.contains(lat, lng)) 16 else 6
        } else if (lat < 17.407117f) if (lng < -22.454775f) 298 else if (lat < 12.686238f) if (lng < -12.180100f) if (lng < -14.586488f) {
            if (poly[1275]!!.contains(lat, lng)) return 16
            if (poly[1276]!!.contains(lat, lng)) return 17
            if (poly[1277]!!.contains(lat, lng)) 17 else 9
        } else if (lng < -13.383294f) {
            if (poly[1278]!!.contains(lat, lng)) return 9
            if (poly[1279]!!.contains(lat, lng)) 17 else 16
        } else {
            if (poly[1280]!!.contains(lat, lng)) 17 else 16
        } else if (lng < -9.773711f) if (lng < -10.976906f) if (lat < 11.574139f) 16 else if (lng < -11.578503f) {
            if (poly[1281]!!.contains(lat, lng)) 17 else 16
        } else {
            if (poly[1282]!!.contains(lat, lng)) return 16
            if (poly[1283]!!.contains(lat, lng)) 17 else 6
        } else {
            if (poly[1284]!!.contains(lat, lng)) 16 else 6
        } else if (lng < -8.570517f) {
            if (poly[1285]!!.contains(lat, lng)) 16 else 6
        } else {
            if (poly[1286]!!.contains(lat, lng)) return 16
            if (poly[1287]!!.contains(lat, lng)) 16 else 6
        } else if (lng < -12.576783f) if (lng < -15.181512f) if (lat < 15.046677f) {
            if (poly[1288]!!.contains(lat, lng)) 8 else 17
        } else {
            if (poly[1289]!!.contains(lat, lng)) 46 else 17
        } else if (lat < 15.046677f) {
            if (poly[1290]!!.contains(lat, lng)) return 8
            if (poly[1291]!!.contains(lat, lng)) 46 else 17
        } else if (lng < -13.879147f) {
            if (poly[1292]!!.contains(lat, lng)) 46 else 17
        } else {
            if (poly[1293]!!.contains(lat, lng)) 46 else 17
        } else if (lng < -9.972053f) if (lat < 15.046677f) if (lng < -11.274418f) if (lat < 13.866458f) {
            if (poly[1294]!!.contains(lat, lng)) 17 else 6
        } else if (lng < -11.925600f) {
            if (poly[1295]!!.contains(lat, lng)) return 6
            if (poly[1296]!!.contains(lat, lng)) 46 else 17
        } else {
            if (poly[1297]!!.contains(lat, lng)) 46 else 6
        } else 6 else {
            if (poly[1298]!!.contains(lat, lng)) 6 else 46
        } else {
            if (poly[1299]!!.contains(lat, lng)) 46 else 6
        } else {
            if (poly[1300]!!.contains(lat, lng)) return 4
            if (poly[1301]!!.contains(lat, lng)) 46 else 21
        } else if (lat < 1.925760f) if (lat < -0.707757f) 37 else 49 else call14(lat, lng) else if (lng < 27.454076f) if (lat < 5.392003f) call15(lat, lng) else call16(lat, lng) else call17(lat, lng)
    }

    private fun call20(lat: Float, lng: Float): Int {
        return if (lat < 53.363782f) if (lng < -61.250000f) if (lat < 32.591369f) 296 else if (lat < 48.481700f) if (lng < -68.020224f) if (lat < 43.613186f) 153 else if (lng < -71.405337f) {
            if (poly[1302]!!.contains(lat, lng)) 193 else 153
        } else if (lat < 46.047443f) {
            if (poly[1303]!!.contains(lat, lng)) return 193
            if (poly[1304]!!.contains(lat, lng)) 193 else 153
        } else {
            if (poly[1305]!!.contains(lat, lng)) return 148
            if (poly[1306]!!.contains(lat, lng)) 153 else 193
        } else if (lng < -64.635112f) if (lat < 45.838850f) if (lng < -66.327668f) {
            if (poly[1307]!!.contains(lat, lng)) return 114
            if (poly[1308]!!.contains(lat, lng)) 148 else 153
        } else {
            if (poly[1309]!!.contains(lat, lng)) 148 else 114
        } else {
            if (poly[1310]!!.contains(lat, lng)) return 153
            if (poly[1311]!!.contains(lat, lng)) 193 else 148
        } else {
            if (poly[1312]!!.contains(lat, lng)) return 148
            if (poly[1313]!!.contains(lat, lng)) 193 else 114
        } else if (lng < -68.020224f) 193 else if (lng < -64.635112f) if (lat < 50.922741f) 193 else if (lng < -66.327668f) if (lat < 52.143261f) {
            if (poly[1314]!!.contains(lat, lng)) 107 else 193
        } else if (lng < -67.173946f) {
            if (poly[1315]!!.contains(lat, lng)) 107 else 193
        } else if (lat < 52.753522f) {
            if (poly[1316]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1317]!!.contains(lat, lng)) return 107
            if (poly[1318]!!.contains(lat, lng)) 107 else 193
        } else if (lat < 52.143261f) {
            if (poly[1319]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1320]!!.contains(lat, lng)) return 193
            if (poly[1321]!!.contains(lat, lng)) return 193
            if (poly[1322]!!.contains(lat, lng)) return 193
            if (poly[1323]!!.contains(lat, lng)) 193 else 107
        } else if (lat < 50.922741f) 193 else if (lng < -62.942556f) if (lat < 52.143261f) {
            if (poly[1324]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1325]!!.contains(lat, lng)) return 193
            if (poly[1326]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1327]!!.contains(lat, lng)) 193 else 107
        } else if (lat < 44.250090f) 114 else if (lat < 47.365000f) if (lng < -59.345249f) if (lat < 46.471002f) {
            if (poly[1328]!!.contains(lat, lng)) 105 else 114
        } else {
            if (poly[1329]!!.contains(lat, lng)) 183 else 114
        } else if (lng < -57.161134f) 183 else if (lng < -56.678682f) if (lat < 47.171604f) 143 else 183 else {
            if (poly[1330]!!.contains(lat, lng)) 143 else 183
        } else {
            if (poly[1331]!!.contains(lat, lng)) return 78
            if (poly[1332]!!.contains(lat, lng)) return 107
            if (poly[1333]!!.contains(lat, lng)) 114 else 183
        } else if (lat < 72.644741f) if (lng < -60.758360f) if (lat < 63.004262f) if (lng < -67.774405f) if (lat < 58.184022f) {
            if (poly[1334]!!.contains(lat, lng)) return 107
            if (poly[1335]!!.contains(lat, lng)) 107 else 193
        } else if (lng < -71.282427f) {
            if (poly[1336]!!.contains(lat, lng)) 193 else 126
        } else if (lat < 60.594142f) if (lng < -69.528416f) {
            if (poly[1337]!!.contains(lat, lng)) return 126
            if (poly[1338]!!.contains(lat, lng)) 126 else 193
        } else {
            if (poly[1339]!!.contains(lat, lng)) return 126
            if (poly[1340]!!.contains(lat, lng)) 162 else 193
        } else {
            if (poly[1341]!!.contains(lat, lng)) return 162
            if (poly[1342]!!.contains(lat, lng)) 193 else 126
        } else if (lat < 58.184022f) if (lng < -64.266382f) if (lat < 55.773902f) if (lng < -66.020393f) if (lat < 54.568842f) if (lng < -66.897399f) if (lat < 53.966312f) {
            if (poly[1343]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1344]!!.contains(lat, lng)) return 193
            if (poly[1345]!!.contains(lat, lng)) return 193
            if (poly[1346]!!.contains(lat, lng)) return 193
            if (poly[1347]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1348]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1349]!!.contains(lat, lng)) return 107
            if (poly[1350]!!.contains(lat, lng)) 107 else 193
        } else {
            if (poly[1351]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1352]!!.contains(lat, lng)) 107 else 193
        } else if (lat < 55.773902f) if (lng < -62.512371f) if (lat < 54.568842f) 107 else if (lng < -63.389377f) if (lat < 55.171372f) {
            if (poly[1353]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1354]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1355]!!.contains(lat, lng)) 193 else 107
        } else 107 else if (lng < -62.512371f) if (lat < 56.978962f) if (lng < -63.389377f) if (lat < 56.376432f) {
            if (poly[1356]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1357]!!.contains(lat, lng)) 193 else 107
        } else 107 else {
            if (poly[1358]!!.contains(lat, lng)) 193 else 107
        } else 107 else if (lng < -64.742671f) if (lat < 60.594142f) if (lng < -66.258538f) {
            if (poly[1359]!!.contains(lat, lng)) 193 else 162
        } else if (lat < 59.389082f) {
            if (poly[1360]!!.contains(lat, lng)) return 107
            if (poly[1361]!!.contains(lat, lng)) 162 else 193
        } else {
            if (poly[1362]!!.contains(lat, lng)) return 107
            if (poly[1363]!!.contains(lat, lng)) return 107
            if (poly[1364]!!.contains(lat, lng)) return 107
            if (poly[1365]!!.contains(lat, lng)) return 107
            if (poly[1366]!!.contains(lat, lng)) return 107
            if (poly[1367]!!.contains(lat, lng)) 162 else 193
        } else 162 else if (lat < 60.594142f) if (lng < -63.226804f) if (lat < 59.389082f) if (lng < -63.984737f) {
            if (poly[1368]!!.contains(lat, lng)) return 193
            if (poly[1369]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1370]!!.contains(lat, lng)) return 193
            if (poly[1371]!!.contains(lat, lng)) 193 else 107
        } else {
            if (poly[1372]!!.contains(lat, lng)) return 162
            if (poly[1373]!!.contains(lat, lng)) return 193
            if (poly[1374]!!.contains(lat, lng)) return 193
            if (poly[1375]!!.contains(lat, lng)) return 193
            if (poly[1376]!!.contains(lat, lng)) return 193
            if (poly[1377]!!.contains(lat, lng)) return 193
            if (poly[1378]!!.contains(lat, lng)) 193 else 107
        } else 107 else 162 else {
            if (poly[1379]!!.contains(lat, lng)) 126 else 162
        } else if (lat < 60.352065f) 106 else 107 else if (lng < -63.556823f) {
            if (poly[1380]!!.contains(lat, lng)) return 106
            if (poly[1381]!!.contains(lat, lng)) return 126
            if (poly[1382]!!.contains(lat, lng)) 162 else 190
        } else {
            if (poly[1383]!!.contains(lat, lng)) return 162
            if (poly[1384]!!.contains(lat, lng)) 190 else 106
        }
    }

    private fun call21(lat: Float, lng: Float): Int {
        return if (lng < 20.356164f) if (lng < 12.516067f) if (lng < 7.718044f) if (lat < 44.084297f) {
            if (poly[1385]!!.contains(lat, lng)) return 349
            if (poly[1386]!!.contains(lat, lng)) 356 else 352
        } else {
            if (poly[1387]!!.contains(lat, lng)) 356 else 352
        } else if (lat < 38.311983f) 356 else if (lng < 10.095160f) if (lat < 41.434667f) {
            if (poly[1388]!!.contains(lat, lng)) 352 else 356
        } else {
            if (poly[1389]!!.contains(lat, lng)) 356 else 352
        } else {
            if (poly[1390]!!.contains(lat, lng)) 358 else 356
        } else if (lat < 39.997858f) if (lng < 18.739011f) 356 else if (lat < 38.441447f) 321 else {
            if (poly[1391]!!.contains(lat, lng)) 366 else 321
        } else if (lng < 16.436115f) if (lat < 42.709641f) {
            if (poly[1392]!!.contains(lat, lng)) 375 else 356
        } else if (lng < 14.476091f) {
            if (poly[1393]!!.contains(lat, lng)) 375 else 356
        } else {
            if (poly[1394]!!.contains(lat, lng)) 359 else 375
        } else if (lat < 42.709641f) if (lng < 18.396140f) {
            if (poly[1395]!!.contains(lat, lng)) return 356
            if (poly[1396]!!.contains(lat, lng)) 359 else 375
        } else if (lat < 41.353750f) {
            if (poly[1397]!!.contains(lat, lng)) 356 else 366
        } else if (lng < 19.376152f) {
            if (poly[1398]!!.contains(lat, lng)) return 359
            if (poly[1399]!!.contains(lat, lng)) return 366
            if (poly[1400]!!.contains(lat, lng)) return 366
            if (poly[1401]!!.contains(lat, lng)) return 366
            if (poly[1402]!!.contains(lat, lng)) return 366
            if (poly[1403]!!.contains(lat, lng)) 375 else 353
        } else {
            if (poly[1404]!!.contains(lat, lng)) return 322
            if (poly[1405]!!.contains(lat, lng)) return 353
            if (poly[1406]!!.contains(lat, lng)) return 353
            if (poly[1407]!!.contains(lat, lng)) return 353
            if (poly[1408]!!.contains(lat, lng)) 353 else 366
        } else if (lng < 18.396140f) if (lat < 44.065533f) {
            if (poly[1409]!!.contains(lat, lng)) 375 else 359
        } else {
            if (poly[1410]!!.contains(lat, lng)) 375 else 359
        } else if (lat < 44.065533f) if (lng < 19.376152f) {
            if (poly[1411]!!.contains(lat, lng)) return 322
            if (poly[1412]!!.contains(lat, lng)) return 322
            if (poly[1413]!!.contains(lat, lng)) 353 else 359
        } else {
            if (poly[1414]!!.contains(lat, lng)) return 353
            if (poly[1415]!!.contains(lat, lng)) return 359
            if (poly[1416]!!.contains(lat, lng)) return 359
            if (poly[1417]!!.contains(lat, lng)) 359 else 322
        } else if (lng < 19.376152f) if (lat < 44.743478f) {
            if (poly[1418]!!.contains(lat, lng)) 322 else 359
        } else if (lng < 18.886146f) {
            if (poly[1419]!!.contains(lat, lng)) 375 else 359
        } else {
            if (poly[1420]!!.contains(lat, lng)) return 359
            if (poly[1421]!!.contains(lat, lng)) 375 else 322
        } else {
            if (poly[1422]!!.contains(lat, lng)) return 359
            if (poly[1423]!!.contains(lat, lng)) return 359
            if (poly[1424]!!.contains(lat, lng)) 375 else 322
        } else if (lat < 42.373536f) if (lng < 23.034051f) if (lat < 39.914726f) {
            if (poly[1425]!!.contains(lat, lng)) 366 else 321
        } else if (lng < 21.695107f) if (lat < 41.144131f) if (lng < 21.025636f) {
            if (poly[1426]!!.contains(lat, lng)) return 321
            if (poly[1427]!!.contains(lat, lng)) return 321
            if (poly[1428]!!.contains(lat, lng)) 362 else 366
        } else {
            if (poly[1429]!!.contains(lat, lng)) return 362
            if (poly[1430]!!.contains(lat, lng)) 366 else 321
        } else if (lng < 21.025636f) {
            if (poly[1431]!!.contains(lat, lng)) return 322
            if (poly[1432]!!.contains(lat, lng)) 366 else 362
        } else {
            if (poly[1433]!!.contains(lat, lng)) 362 else 322
        } else if (lat < 41.144131f) {
            if (poly[1434]!!.contains(lat, lng)) return 362
            if (poly[1435]!!.contains(lat, lng)) return 362
            if (poly[1436]!!.contains(lat, lng)) 362 else 321
        } else {
            if (poly[1437]!!.contains(lat, lng)) return 321
            if (poly[1438]!!.contains(lat, lng)) return 321
            if (poly[1439]!!.contains(lat, lng)) return 321
            if (poly[1440]!!.contains(lat, lng)) return 321
            if (poly[1441]!!.contains(lat, lng)) return 322
            if (poly[1442]!!.contains(lat, lng)) return 322
            if (poly[1443]!!.contains(lat, lng)) 363 else 362
        } else if (lng < 31.630816f) if (lng < 27.332433f) if (lat < 40.067370f) {
            if (poly[1444]!!.contains(lat, lng)) 336 else 321
        } else if (lng < 25.183242f) {
            if (poly[1445]!!.contains(lat, lng)) 363 else 321
        } else if (lat < 41.220453f) {
            if (poly[1446]!!.contains(lat, lng)) 336 else 321
        } else if (lng < 26.257838f) {
            if (poly[1447]!!.contains(lat, lng)) 321 else 363
        } else {
            if (poly[1448]!!.contains(lat, lng)) return 321
            if (poly[1449]!!.contains(lat, lng)) 363 else 336
        } else {
            if (poly[1450]!!.contains(lat, lng)) 363 else 336
        } else 336 else if (lng < 30.480486f) if (lng < 29.207957f) if (lng < 24.782060f) if (lng < 22.569112f) if (lat < 43.897480f) {
            if (poly[1451]!!.contains(lat, lng)) return 363
            if (poly[1452]!!.contains(lat, lng)) 363 else 322
        } else {
            if (poly[1453]!!.contains(lat, lng)) return 326
            if (poly[1454]!!.contains(lat, lng)) return 326
            if (poly[1455]!!.contains(lat, lng)) 363 else 322
        } else if (lat < 43.897480f) {
            if (poly[1456]!!.contains(lat, lng)) return 322
            if (poly[1457]!!.contains(lat, lng)) 326 else 363
        } else {
            if (poly[1458]!!.contains(lat, lng)) return 322
            if (poly[1459]!!.contains(lat, lng)) return 322
            if (poly[1460]!!.contains(lat, lng)) 363 else 326
        } else {
            if (poly[1461]!!.contains(lat, lng)) return 339
            if (poly[1462]!!.contains(lat, lng)) 363 else 326
        } else {
            if (poly[1463]!!.contains(lat, lng)) 326 else 339
        } else if (lng < 36.674992f) {
            if (poly[1464]!!.contains(lat, lng)) 350 else 361
        } else {
            if (poly[1465]!!.contains(lat, lng)) 281 else 350
        }
    }

    private fun call22(lat: Float, lng: Float): Int {
        return if (lat < 47.092146f) if (lng < 16.596770f) if (lng < 12.185960f) {
            if (poly[1466]!!.contains(lat, lng)) return 371
            if (poly[1467]!!.contains(lat, lng)) 371 else 356
        } else if (lng < 12.240745f) if (lat < 46.906838f) {
            if (poly[1468]!!.contains(lat, lng)) 371 else 356
        } else if (lat < 47.069168f) {
            if (poly[1469]!!.contains(lat, lng)) 356 else 371
        } else {
            if (poly[1470]!!.contains(lat, lng)) 371 else 356
        } else if (lng < 14.418757f) if (lng < 13.329751f) {
            if (poly[1471]!!.contains(lat, lng)) return 371
            if (poly[1472]!!.contains(lat, lng)) 375 else 356
        } else if (lat < 46.256785f) {
            if (poly[1473]!!.contains(lat, lng)) return 356
            if (poly[1474]!!.contains(lat, lng)) 375 else 342
        } else {
            if (poly[1475]!!.contains(lat, lng)) return 356
            if (poly[1476]!!.contains(lat, lng)) 371 else 342
        } else if (lng < 15.507764f) if (lat < 46.256785f) {
            if (poly[1477]!!.contains(lat, lng)) 375 else 342
        } else {
            if (poly[1478]!!.contains(lat, lng)) 371 else 342
        } else if (lat < 46.256785f) {
            if (poly[1479]!!.contains(lat, lng)) 342 else 375
        } else if (lng < 16.052267f) {
            if (poly[1480]!!.contains(lat, lng)) return 371
            if (poly[1481]!!.contains(lat, lng)) 375 else 342
        } else {
            if (poly[1482]!!.contains(lat, lng)) return 327
            if (poly[1483]!!.contains(lat, lng)) return 371
            if (poly[1484]!!.contains(lat, lng)) 375 else 342
        } else if (lng < 20.611605f) if (lng < 18.604188f) {
            if (poly[1485]!!.contains(lat, lng)) 375 else 327
        } else if (lng < 19.607897f) if (lat < 46.256785f) if (lng < 19.106042f) {
            if (poly[1486]!!.contains(lat, lng)) return 322
            if (poly[1487]!!.contains(lat, lng)) 327 else 375
        } else {
            if (poly[1488]!!.contains(lat, lng)) 322 else 327
        } else 327 else {
            if (poly[1489]!!.contains(lat, lng)) return 326
            if (poly[1490]!!.contains(lat, lng)) 327 else 322
        } else if (lng < 22.619023f) if (lng < 21.615314f) {
            if (poly[1491]!!.contains(lat, lng)) return 322
            if (poly[1492]!!.contains(lat, lng)) 327 else 326
        } else {
            if (poly[1493]!!.contains(lat, lng)) 327 else 326
        } else 326 else if (lng < 18.859216f) if (lat < 49.517291f) if (lng < 14.675755f) if (lng < 12.584024f) {
            if (poly[1494]!!.contains(lat, lng)) 371 else 323
        } else if (lat < 48.304719f) {
            if (poly[1495]!!.contains(lat, lng)) 323 else 371
        } else if (lng < 13.629890f) {
            if (poly[1496]!!.contains(lat, lng)) return 354
            if (poly[1497]!!.contains(lat, lng)) 371 else 323
        } else {
            if (poly[1498]!!.contains(lat, lng)) return 323
            if (poly[1499]!!.contains(lat, lng)) 354 else 371
        } else if (lng < 16.767485f) if (lat < 48.304695f) {
            if (poly[1500]!!.contains(lat, lng)) 327 else 371
        } else {
            if (poly[1501]!!.contains(lat, lng)) 371 else 354
        } else if (lat < 48.304719f) if (lng < 17.813351f) {
            if (poly[1502]!!.contains(lat, lng)) return 324
            if (poly[1503]!!.contains(lat, lng)) 371 else 327
        } else {
            if (poly[1504]!!.contains(lat, lng)) 327 else 324
        } else {
            if (poly[1505]!!.contains(lat, lng)) return 354
            if (poly[1506]!!.contains(lat, lng)) 371 else 324
        } else if (lng < 14.675755f) if (lat < 51.621312f) if (lng < 12.584024f) {
            if (poly[1507]!!.contains(lat, lng)) 354 else 323
        } else {
            if (poly[1508]!!.contains(lat, lng)) 354 else 323
        } else {
            if (poly[1509]!!.contains(lat, lng)) return 374
            if (poly[1510]!!.contains(lat, lng)) 374 else 323
        } else if (lat < 51.621312f) if (lng < 16.767485f) if (lat < 50.569301f) {
            if (poly[1511]!!.contains(lat, lng)) 374 else 354
        } else {
            if (poly[1512]!!.contains(lat, lng)) return 323
            if (poly[1513]!!.contains(lat, lng)) 354 else 374
        } else if (lat < 50.569301f) if (lng < 17.813351f) {
            if (poly[1514]!!.contains(lat, lng)) 374 else 354
        } else {
            if (poly[1515]!!.contains(lat, lng)) 354 else 374
        } else 374 else {
            if (poly[1516]!!.contains(lat, lng)) return 323
            if (poly[1517]!!.contains(lat, lng)) 323 else 374
        } else if (lat < 49.613816f) if (lng < 21.742829f) if (lng < 20.301022f) if (lat < 48.352981f) {
            if (poly[1518]!!.contains(lat, lng)) 324 else 327
        } else {
            if (poly[1519]!!.contains(lat, lng)) 374 else 324
        } else if (lat < 48.352981f) {
            if (poly[1520]!!.contains(lat, lng)) return 324
            if (poly[1521]!!.contains(lat, lng)) return 324
            if (poly[1522]!!.contains(lat, lng)) 326 else 327
        } else {
            if (poly[1523]!!.contains(lat, lng)) return 327
            if (poly[1524]!!.contains(lat, lng)) 374 else 324
        } else if (lng < 23.184635f) if (lat < 48.352981f) if (lng < 22.463732f) {
            if (poly[1525]!!.contains(lat, lng)) return 324
            if (poly[1526]!!.contains(lat, lng)) return 326
            if (poly[1527]!!.contains(lat, lng)) 368 else 327
        } else {
            if (poly[1528]!!.contains(lat, lng)) return 326
            if (poly[1529]!!.contains(lat, lng)) 327 else 368
        } else if (lng < 22.463732f) {
            if (poly[1530]!!.contains(lat, lng)) return 327
            if (poly[1531]!!.contains(lat, lng)) return 368
            if (poly[1532]!!.contains(lat, lng)) 374 else 324
        } else {
            if (poly[1533]!!.contains(lat, lng)) return 324
            if (poly[1534]!!.contains(lat, lng)) return 368
            if (poly[1535]!!.contains(lat, lng)) 374 else 339
        } else if (lat < 48.352981f) {
            if (poly[1536]!!.contains(lat, lng)) return 326
            if (poly[1537]!!.contains(lat, lng)) return 339
            if (poly[1538]!!.contains(lat, lng)) return 339
            if (poly[1539]!!.contains(lat, lng)) 339 else 368
        } else {
            if (poly[1540]!!.contains(lat, lng)) return 368
            if (poly[1541]!!.contains(lat, lng)) 368 else 339
        } else if (lng < 21.742829f) 374 else if (lat < 51.669574f) if (lng < 23.184635f) {
            if (poly[1542]!!.contains(lat, lng)) 339 else 374
        } else if (lat < 50.641695f) {
            if (poly[1543]!!.contains(lat, lng)) 374 else 339
        } else {
            if (poly[1544]!!.contains(lat, lng)) return 348
            if (poly[1545]!!.contains(lat, lng)) 374 else 339
        } else {
            if (poly[1546]!!.contains(lat, lng)) return 339
            if (poly[1547]!!.contains(lat, lng)) 374 else 348
        }
    }

    private fun call23(lat: Float, lng: Float): Int {
        return if (lng < 30.163676f) if (lat < 48.491870f) if (lng < 27.395058f) if (lat < 46.956647f) 326 else if (lng < 26.010750f) {
            if (poly[1548]!!.contains(lat, lng)) 326 else 339
        } else if (lat < 47.724259f) {
            if (poly[1549]!!.contains(lat, lng)) 329 else 326
        } else if (lng < 26.702904f) {
            if (poly[1550]!!.contains(lat, lng)) return 329
            if (poly[1551]!!.contains(lat, lng)) 339 else 326
        } else if (lat < 48.108064f) {
            if (poly[1552]!!.contains(lat, lng)) 329 else 326
        } else {
            if (poly[1553]!!.contains(lat, lng)) return 326
            if (poly[1554]!!.contains(lat, lng)) 339 else 329
        } else if (lat < 46.956647f) if (lng < 28.779367f) if (lat < 46.189036f) {
            if (poly[1555]!!.contains(lat, lng)) return 326
            if (poly[1556]!!.contains(lat, lng)) return 339
            if (poly[1557]!!.contains(lat, lng)) 339 else 329
        } else {
            if (poly[1558]!!.contains(lat, lng)) 329 else 326
        } else if (lat < 46.189036f) {
            if (poly[1559]!!.contains(lat, lng)) return 326
            if (poly[1560]!!.contains(lat, lng)) return 329
            if (poly[1561]!!.contains(lat, lng)) 329 else 339
        } else if (lng < 29.471522f) {
            if (poly[1562]!!.contains(lat, lng)) 339 else 329
        } else {
            if (poly[1563]!!.contains(lat, lng)) 329 else 339
        } else if (lng < 28.779367f) if (lat < 47.724259f) {
            if (poly[1564]!!.contains(lat, lng)) 326 else 329
        } else {
            if (poly[1565]!!.contains(lat, lng)) 339 else 329
        } else {
            if (poly[1566]!!.contains(lat, lng)) 329 else 339
        } else if (lng < 27.395058f) {
            if (poly[1567]!!.contains(lat, lng)) 339 else 348
        } else if (lat < 51.108601f) 339 else if (lng < 28.779367f) {
            if (poly[1568]!!.contains(lat, lng)) 348 else 339
        } else {
            if (poly[1569]!!.contains(lat, lng)) return 348
            if (poly[1570]!!.contains(lat, lng)) 348 else 339
        } else if (lat < 48.144930f) if (lng < 30.351124f) 339 else if (lng < 35.289352f) if (lng < 32.820238f) {
            if (poly[1571]!!.contains(lat, lng)) 361 else 339
        } else if (lat < 46.783177f) {
            if (poly[1572]!!.contains(lat, lng)) return 361
            if (poly[1573]!!.contains(lat, lng)) 376 else 339
        } else {
            if (poly[1574]!!.contains(lat, lng)) 376 else 339
        } else if (lng < 37.758466f) if (lat < 46.783177f) {
            if (poly[1575]!!.contains(lat, lng)) return 339
            if (poly[1576]!!.contains(lat, lng)) return 339
            if (poly[1577]!!.contains(lat, lng)) return 361
            if (poly[1578]!!.contains(lat, lng)) 376 else 350
        } else if (lng < 36.523909f) {
            if (poly[1579]!!.contains(lat, lng)) 376 else 339
        } else {
            if (poly[1580]!!.contains(lat, lng)) return 350
            if (poly[1581]!!.contains(lat, lng)) 376 else 339
        } else {
            if (poly[1582]!!.contains(lat, lng)) 339 else 350
        } else if (lng < 35.195628f) if (lat < 50.935131f) 339 else if (lng < 32.679652f) if (lat < 52.330231f) if (lng < 31.421664f) {
            if (poly[1583]!!.contains(lat, lng)) 339 else 348
        } else {
            if (poly[1584]!!.contains(lat, lng)) return 339
            if (poly[1585]!!.contains(lat, lng)) 348 else 350
        } else if (lng < 31.421664f) {
            if (poly[1586]!!.contains(lat, lng)) 350 else 348
        } else if (lat < 53.027782f) {
            if (poly[1587]!!.contains(lat, lng)) return 339
            if (poly[1588]!!.contains(lat, lng)) 348 else 350
        } else {
            if (poly[1589]!!.contains(lat, lng)) return 350
            if (poly[1590]!!.contains(lat, lng)) return 350
            if (poly[1591]!!.contains(lat, lng)) return 350
            if (poly[1592]!!.contains(lat, lng)) 350 else 348
        } else if (lat < 52.330231f) if (lng < 33.937640f) {
            if (poly[1593]!!.contains(lat, lng)) 339 else 350
        } else if (lat < 51.632681f) {
            if (poly[1594]!!.contains(lat, lng)) 350 else 339
        } else {
            if (poly[1595]!!.contains(lat, lng)) 350 else 339
        } else {
            if (poly[1596]!!.contains(lat, lng)) return 339
            if (poly[1597]!!.contains(lat, lng)) return 339
            if (poly[1598]!!.contains(lat, lng)) return 348
            if (poly[1599]!!.contains(lat, lng)) 348 else 350
        } else if (lat < 50.935131f) if (lng < 37.711604f) {
            if (poly[1600]!!.contains(lat, lng)) 350 else 339
        } else if (lat < 49.540031f) {
            if (poly[1601]!!.contains(lat, lng)) 350 else 339
        } else {
            if (poly[1602]!!.contains(lat, lng)) 339 else 350
        } else {
            if (poly[1603]!!.contains(lat, lng)) 339 else 350
        }
    }

    private fun call24(lat: Float, lng: Float): Int {
        return if (lat < 71.384879f) if (lng < 15.553064f) if (lat < 54.399122f) if (lng < 7.549946f) 323 else {
            if (poly[1604]!!.contains(lat, lng)) 374 else 323
        } else if (lat < 55.099161f) if (lng < 14.078231f) if (lng < 11.529757f) {
            if (poly[1605]!!.contains(lat, lng)) 323 else 330
        } else {
            if (poly[1606]!!.contains(lat, lng)) 330 else 323
        } else 330 else if (lat < 62.278222f) if (lng < 10.246714f) {
            if (poly[1607]!!.contains(lat, lng)) 351 else 330
        } else if (lat < 58.688691f) {
            if (poly[1608]!!.contains(lat, lng)) 364 else 330
        } else {
            if (poly[1609]!!.contains(lat, lng)) 351 else 364
        } else {
            if (poly[1610]!!.contains(lat, lng)) 364 else 351
        } else if (lat < 56.450421f) if (lng < 26.835520f) if (lng < 16.993665f) if (lat < 55.307816f) 364 else 374 else if (lng < 21.914593f) {
            if (poly[1611]!!.contains(lat, lng)) return 355
            if (poly[1612]!!.contains(lat, lng)) return 372
            if (poly[1613]!!.contains(lat, lng)) 374 else 338
        } else if (lng < 24.375056f) if (lat < 55.087877f) if (lng < 23.144825f) {
            if (poly[1614]!!.contains(lat, lng)) return 338
            if (poly[1615]!!.contains(lat, lng)) 374 else 372
        } else {
            if (poly[1616]!!.contains(lat, lng)) return 348
            if (poly[1617]!!.contains(lat, lng)) 374 else 372
        } else {
            if (poly[1618]!!.contains(lat, lng)) 372 else 355
        } else if (lat < 55.087877f) {
            if (poly[1619]!!.contains(lat, lng)) 372 else 348
        } else if (lng < 25.605288f) {
            if (poly[1620]!!.contains(lat, lng)) 372 else 355
        } else {
            if (poly[1621]!!.contains(lat, lng)) return 348
            if (poly[1622]!!.contains(lat, lng)) 355 else 372
        } else if (lng < 32.363125f) if (lng < 29.599322f) {
            if (poly[1623]!!.contains(lat, lng)) return 350
            if (poly[1624]!!.contains(lat, lng)) 355 else 348
        } else if (lng < 30.981224f) {
            if (poly[1625]!!.contains(lat, lng)) return 350
            if (poly[1626]!!.contains(lat, lng)) 350 else 348
        } else {
            if (poly[1627]!!.contains(lat, lng)) return 348
            if (poly[1628]!!.contains(lat, lng)) 348 else 350
        } else {
            if (poly[1629]!!.contains(lat, lng)) 348 else 350
        } else if (lat < 58.599619f) if (lng < 19.734297f) 364 else if (lng < 30.456424f) if (lng < 25.570846f) {
            if (poly[1630]!!.contains(lat, lng)) 365 else 355
        } else if (lng < 28.013635f) if (lng < 26.792240f) {
            if (poly[1631]!!.contains(lat, lng)) 355 else 365
        } else if (lat < 57.525020f) {
            if (poly[1632]!!.contains(lat, lng)) return 355
            if (poly[1633]!!.contains(lat, lng)) 365 else 350
        } else {
            if (poly[1634]!!.contains(lat, lng)) return 350
            if (poly[1635]!!.contains(lat, lng)) return 355
            if (poly[1636]!!.contains(lat, lng)) 355 else 365
        } else {
            if (poly[1637]!!.contains(lat, lng)) 355 else 350
        } else 350 else if (lng < 27.890322f) if (lat < 64.992249f) if (lng < 21.721693f) {
            if (poly[1638]!!.contains(lat, lng)) return 334
            if (poly[1639]!!.contains(lat, lng)) return 347
            if (poly[1640]!!.contains(lat, lng)) 365 else 364
        } else {
            if (poly[1641]!!.contains(lat, lng)) return 350
            if (poly[1642]!!.contains(lat, lng)) return 350
            if (poly[1643]!!.contains(lat, lng)) return 364
            if (poly[1644]!!.contains(lat, lng)) 365 else 334
        } else if (lng < 21.721693f) if (lng < 18.637379f) {
            if (poly[1645]!!.contains(lat, lng)) 364 else 351
        } else {
            if (poly[1646]!!.contains(lat, lng)) return 334
            if (poly[1647]!!.contains(lat, lng)) 351 else 364
        } else if (lat < 68.188564f) {
            if (poly[1648]!!.contains(lat, lng)) 334 else 364
        } else if (lng < 24.806007f) {
            if (poly[1649]!!.contains(lat, lng)) return 351
            if (poly[1650]!!.contains(lat, lng)) 364 else 334
        } else {
            if (poly[1651]!!.contains(lat, lng)) 334 else 351
        } else if (lat < 64.959848f) if (lng < 34.058951f) if (lat < 61.779734f) {
            if (poly[1652]!!.contains(lat, lng)) return 334
            if (poly[1653]!!.contains(lat, lng)) 365 else 350
        } else {
            if (poly[1654]!!.contains(lat, lng)) 350 else 334
        } else 350 else if (lng < 34.058951f) if (lat < 68.139963f) {
            if (poly[1655]!!.contains(lat, lng)) 350 else 334
        } else if (lng < 30.974637f) {
            if (poly[1656]!!.contains(lat, lng)) return 334
            if (poly[1657]!!.contains(lat, lng)) 350 else 351
        } else {
            if (poly[1658]!!.contains(lat, lng)) 351 else 350
        } else 350 else 211
    }

    private fun call25(lat: Float, lng: Float): Int {
        return if (lng < -15.623845f) if (lng < -52.323198f) call20(
            lat,
            lng
        ) else if (lat < 38.109494f) if (lat < 29.059666f) 297 else if (lng < -24.531025f) 295 else 300 else if (lat < 39.926735f) 295 else if (lat < 67.353000f) if (lng < -32.286453f) 106 else 301 else if (lat < 72.400000f) {
            if (poly[1659]!!.contains(lat, lng)) 180 else 106
        } else {
            if (poly[1660]!!.contains(lat, lng)) 94 else 106
        } else if (lat < 43.993309f) if (lat < 36.155038f) if (lat < 35.320152f) if (lng < -15.127390f) 297 else if (lng < -4.897429f) if (lng < -9.816326f) {
            if (poly[1661]!!.contains(lat, lng)) return 21
            if (poly[1662]!!.contains(lat, lng)) 297 else 14
        } else {
            if (poly[1663]!!.contains(lat, lng)) return 4
            if (poly[1664]!!.contains(lat, lng)) 21 else 14
        } else if (lng < 0.021467f) if (lat < 31.376848f) {
            if (poly[1665]!!.contains(lat, lng)) 14 else 4
        } else if (lng < -2.437981f) {
            if (poly[1666]!!.contains(lat, lng)) return 4
            if (poly[1667]!!.contains(lat, lng)) 15 else 14
        } else {
            if (poly[1668]!!.contains(lat, lng)) 14 else 4
        } else 4 else if (lng < -5.048803f) if (lat < 35.917950f) {
            if (poly[1669]!!.contains(lat, lng)) 14 else 15
        } else if (lat < 36.050527f) {
            if (poly[1670]!!.contains(lat, lng)) 345 else 14
        } else {
            if (poly[1671]!!.contains(lat, lng)) 345 else 332
        } else if (lng < -2.811975f) {
            if (poly[1672]!!.contains(lat, lng)) 14 else 345
        } else {
            if (poly[1673]!!.contains(lat, lng)) 14 else 4
        } else if (lat < 42.154311f) if (lng < -6.189159f) if (lat < 41.574832f) if (lat < 38.864935f) {
            if (poly[1674]!!.contains(lat, lng)) 345 else 341
        } else if (lng < -8.003728f) 341 else if (lat < 40.219884f) {
            if (poly[1675]!!.contains(lat, lng)) 345 else 341
        } else {
            if (poly[1676]!!.contains(lat, lng)) 345 else 341
        } else if (lng < -7.685539f) {
            if (poly[1677]!!.contains(lat, lng)) return 345
            if (poly[1678]!!.contains(lat, lng)) 345 else 341
        } else {
            if (poly[1679]!!.contains(lat, lng)) 341 else 345
        } else if (lat < 37.126460f) if (lng < -0.881233f) 4 else 345 else 345 else if (lng < -2.317545f) 345 else if (lng < 1.311409f) if (lng < -0.503068f) {
            if (poly[1680]!!.contains(lat, lng)) 352 else 345
        } else {
            if (poly[1681]!!.contains(lat, lng)) 352 else 345
        } else if (lng < 3.125887f) if (lat < 43.073810f) if (lng < 2.218648f) {
            if (poly[1682]!!.contains(lat, lng)) return 319
            if (poly[1683]!!.contains(lat, lng)) 352 else 345
        } else {
            if (poly[1684]!!.contains(lat, lng)) 352 else 345
        } else 352 else {
            if (poly[1685]!!.contains(lat, lng)) 345 else 352
        } else if (lat < 55.636000f) if (lng < 2.091912f) if (lng < -5.658236f) if (lat < 50.399839f) 343 else if (lat < 51.934425f) if (lng < -6.501750f) 331 else 343 else if (lng < -8.335807f) 331 else if (lat < 53.785212f) 331 else if (lng < -6.997022f) if (lat < 54.710606f) {
            if (poly[1686]!!.contains(lat, lng)) 343 else 331
        } else {
            if (poly[1687]!!.contains(lat, lng)) return 343
            if (poly[1688]!!.contains(lat, lng)) 343 else 331
        } else {
            if (poly[1689]!!.contains(lat, lng)) 343 else 331
        } else if (lat < 51.227462f) if (lng < -1.783162f) if (lat < 48.663863f) 352 else {
            if (poly[1690]!!.contains(lat, lng)) return 333
            if (poly[1691]!!.contains(lat, lng)) return 337
            if (poly[1692]!!.contains(lat, lng)) 352 else 343
        } else {
            if (poly[1693]!!.contains(lat, lng)) 343 else 352
        } else {
            if (poly[1694]!!.contains(lat, lng)) 335 else 343
        } else if (lat < 48.742113f) 352 else if (lat < 51.116515f) if (lng < 3.516138f) {
            if (poly[1695]!!.contains(lat, lng)) return 325
            if (poly[1696]!!.contains(lat, lng)) 325 else 352
        } else {
            if (poly[1697]!!.contains(lat, lng)) return 352
            if (poly[1698]!!.contains(lat, lng)) 352 else 325
        } else {
            if (poly[1699]!!.contains(lat, lng)) return 325
            if (poly[1700]!!.contains(lat, lng)) return 325
            if (poly[1701]!!.contains(lat, lng)) 352 else 318
        } else if (lng < -10.028876f) if (lat < 66.697330f) if (lat < 60.822138f) 301 else 343 else 106 else if (lng < -5.419671f) if (lat < 59.335000f) 343 else if (lat < 66.536849f) 211 else 299 else if (lng < -0.320965f) 343 else 351
    }

    private fun call26(lat: Float, lng: Float): Int {
        return if (lat < 45.421424f) if (lat < 37.761205f) if (lng < 28.374229f) if (lng < 15.587107f) if (lng < 11.880113f) if (lat < 32.597374f) {
            if (poly[1702]!!.contains(lat, lng)) return 4
            if (poly[1703]!!.contains(lat, lng)) 51 else 50
        } else if (lng < 8.410239f) if (lat < 34.946790f) {
            if (poly[1704]!!.contains(lat, lng)) 51 else 4
        } else {
            if (poly[1705]!!.contains(lat, lng)) return 51
            if (poly[1706]!!.contains(lat, lng)) 51 else 4
        } else {
            if (poly[1707]!!.contains(lat, lng)) return 4
            if (poly[1708]!!.contains(lat, lng)) return 4
            if (poly[1709]!!.contains(lat, lng)) return 50
            if (poly[1710]!!.contains(lat, lng)) 356 else 51
        } else if (lat < 36.285271f) if (lat < 33.282408f) 50 else if (lng < 13.530323f) 346 else 356 else 356 else if (lat < 33.140906f) {
            if (poly[1711]!!.contains(lat, lng)) 13 else 50
        } else if (lng < 16.206959f) 356 else if (lng < 24.256735f) 321 else {
            if (poly[1712]!!.contains(lat, lng)) 336 else 321
        } else if (lat < 34.105119f) if (lng < 34.567324f) if (lat < 28.327764f) {
            if (poly[1713]!!.contains(lat, lng)) 272 else 13
        } else {
            if (poly[1714]!!.contains(lat, lng)) return 237
            if (poly[1715]!!.contains(lat, lng)) 245 else 13
        } else if (lat < 30.769331f) if (lng < 37.397452f) {
            if (poly[1716]!!.contains(lat, lng)) return 13
            if (poly[1717]!!.contains(lat, lng)) return 245
            if (poly[1718]!!.contains(lat, lng)) 272 else 214
        } else {
            if (poly[1719]!!.contains(lat, lng)) 214 else 272
        } else if (lng < 37.397452f) if (lat < 32.437225f) if (lng < 35.982388f) {
            if (poly[1720]!!.contains(lat, lng)) return 214
            if (poly[1721]!!.contains(lat, lng)) 245 else 238
        } else {
            if (poly[1722]!!.contains(lat, lng)) return 231
            if (poly[1723]!!.contains(lat, lng)) return 231
            if (poly[1724]!!.contains(lat, lng)) 272 else 214
        } else if (lng < 36.015275f) if (lat < 33.271172f) {
            if (poly[1725]!!.contains(lat, lng)) return 214
            if (poly[1726]!!.contains(lat, lng)) return 225
            if (poly[1727]!!.contains(lat, lng)) return 225
            if (poly[1728]!!.contains(lat, lng)) return 231
            if (poly[1729]!!.contains(lat, lng)) 238 else 245
        } else {
            if (poly[1730]!!.contains(lat, lng)) return 231
            if (poly[1731]!!.contains(lat, lng)) return 231
            if (poly[1732]!!.contains(lat, lng)) return 245
            if (poly[1733]!!.contains(lat, lng)) 245 else 225
        } else {
            if (poly[1734]!!.contains(lat, lng)) return 214
            if (poly[1735]!!.contains(lat, lng)) return 214
            if (poly[1736]!!.contains(lat, lng)) return 214
            if (poly[1737]!!.contains(lat, lng)) return 225
            if (poly[1738]!!.contains(lat, lng)) 225 else 231
        } else {
            if (poly[1739]!!.contains(lat, lng)) return 220
            if (poly[1740]!!.contains(lat, lng)) return 231
            if (poly[1741]!!.contains(lat, lng)) 272 else 214
        } else if (lng < 34.855318f) if (lng < 29.729699f) {
            if (poly[1742]!!.contains(lat, lng)) 321 else 336
        } else if (lat < 35.384917f) {
            if (poly[1743]!!.contains(lat, lng)) 236 else 261
        } else {
            if (poly[1744]!!.contains(lat, lng)) 236 else 336
        } else if (lat < 34.692354f) {
            if (poly[1745]!!.contains(lat, lng)) 231 else 225
        } else if (lng < 37.541449f) if (lat < 36.226779f) {
            if (poly[1746]!!.contains(lat, lng)) return 336
            if (poly[1747]!!.contains(lat, lng)) 336 else 231
        } else {
            if (poly[1748]!!.contains(lat, lng)) return 231
            if (poly[1749]!!.contains(lat, lng)) 231 else 336
        } else {
            if (poly[1750]!!.contains(lat, lng)) 336 else 231
        } else call21(lat, lng) else if (lat < 53.725332f) if (lng < 10.492294f) if (lat < 47.808465f) if (lng < 8.979315f) if (lat < 46.463702f) if (lng < 6.959839f) {
            if (poly[1751]!!.contains(lat, lng)) return 356
            if (poly[1752]!!.contains(lat, lng)) 377 else 352
        } else if (lng < 7.969577f) {
            if (poly[1753]!!.contains(lat, lng)) return 352
            if (poly[1754]!!.contains(lat, lng)) return 352
            if (poly[1755]!!.contains(lat, lng)) 377 else 356
        } else {
            if (poly[1756]!!.contains(lat, lng)) return 377
            if (poly[1757]!!.contains(lat, lng)) 377 else 356
        } else if (lng < 6.959839f) {
            if (poly[1758]!!.contains(lat, lng)) return 377
            if (poly[1759]!!.contains(lat, lng)) 377 else 352
        } else if (lng < 7.969577f) {
            if (poly[1760]!!.contains(lat, lng)) return 323
            if (poly[1761]!!.contains(lat, lng)) return 352
            if (poly[1762]!!.contains(lat, lng)) 352 else 377
        } else {
            if (poly[1763]!!.contains(lat, lng)) return 328
            if (poly[1764]!!.contains(lat, lng)) 377 else 323
        } else if (lat < 46.859075f) if (lng < 9.735805f) {
            if (poly[1765]!!.contains(lat, lng)) 356 else 377
        } else {
            if (poly[1766]!!.contains(lat, lng)) return 356
            if (poly[1767]!!.contains(lat, lng)) return 356
            if (poly[1768]!!.contains(lat, lng)) return 371
            if (poly[1769]!!.contains(lat, lng)) 371 else 377
        } else if (lng < 10.079184f) if (lng < 9.529250f) {
            if (poly[1770]!!.contains(lat, lng)) return 323
            if (poly[1771]!!.contains(lat, lng)) 369 else 377
        } else {
            if (poly[1772]!!.contains(lat, lng)) return 323
            if (poly[1773]!!.contains(lat, lng)) return 323
            if (poly[1774]!!.contains(lat, lng)) return 369
            if (poly[1775]!!.contains(lat, lng)) return 377
            if (poly[1776]!!.contains(lat, lng)) 377 else 371
        } else if (lat < 46.997125f) if (lng < 10.376011f) {
            if (poly[1777]!!.contains(lat, lng)) 377 else 371
        } else {
            if (poly[1778]!!.contains(lat, lng)) 377 else 371
        } else {
            if (poly[1779]!!.contains(lat, lng)) 323 else 371
        } else if (lat < 50.590613f) if (lng < 7.716329f) if (lat < 49.199539f) {
            if (poly[1780]!!.contains(lat, lng)) 352 else 323
        } else if (lng < 6.328347f) if (lat < 49.895076f) if (lng < 5.634355f) {
            if (poly[1781]!!.contains(lat, lng)) 352 else 325
        } else {
            if (poly[1782]!!.contains(lat, lng)) return 323
            if (poly[1783]!!.contains(lat, lng)) return 325
            if (poly[1784]!!.contains(lat, lng)) 352 else 344
        } else {
            if (poly[1785]!!.contains(lat, lng)) return 323
            if (poly[1786]!!.contains(lat, lng)) return 323
            if (poly[1787]!!.contains(lat, lng)) return 323
            if (poly[1788]!!.contains(lat, lng)) 344 else 325
        } else {
            if (poly[1789]!!.contains(lat, lng)) return 325
            if (poly[1790]!!.contains(lat, lng)) return 344
            if (poly[1791]!!.contains(lat, lng)) return 352
            if (poly[1792]!!.contains(lat, lng)) 352 else 323
        } else {
            if (poly[1793]!!.contains(lat, lng)) 352 else 323
        } else if (lng < 7.716329f) if (lat < 52.157972f) if (lng < 6.328347f) if (lat < 51.374293f) if (lng < 5.634355f) {
            if (poly[1794]!!.contains(lat, lng)) 318 else 325
        } else if (lat < 50.982453f) {
            if (poly[1795]!!.contains(lat, lng)) return 318
            if (poly[1796]!!.contains(lat, lng)) 325 else 323
        } else {
            if (poly[1797]!!.contains(lat, lng)) return 323
            if (poly[1798]!!.contains(lat, lng)) 325 else 318
        } else {
            if (poly[1799]!!.contains(lat, lng)) return 323
            if (poly[1800]!!.contains(lat, lng)) 325 else 318
        } else {
            if (poly[1801]!!.contains(lat, lng)) 318 else 323
        } else {
            if (poly[1802]!!.contains(lat, lng)) 318 else 323
        } else 323 else if (lng < 24.626441f) call22(lat, lng) else call23(lat, lng) else call24(lat, lng)
    }

    private fun call27(lat: Float, lng: Float): Int {
        return if (lng < 105.915805f) if (lng < 100.300923f) if (lng < 97.134961f) if (lng < 81.912012f) 230 else if (lat < -5.446921f) 243 else 381 else if (lat < 5.464190f) if (lat < 4.176873f) {
            if (poly[1803]!!.contains(lat, lng)) 243 else 253
        } else if (lng < 99.574355f) 243 else 253 else if (lng < 99.504759f) {
            if (poly[1804]!!.contains(lat, lng)) 253 else 223
        } else {
            if (poly[1805]!!.contains(lat, lng)) 223 else 253
        } else if (lat < 3.527061f) if (lat < -10.211475f) 380 else if (lat < -1.935469f) 243 else {
            if (poly[1806]!!.contains(lat, lng)) return 243
            if (poly[1807]!!.contains(lat, lng)) return 277
            if (poly[1808]!!.contains(lat, lng)) 277 else 253
        } else if (lng < 100.673031f) {
            if (poly[1809]!!.contains(lat, lng)) 223 else 253
        } else {
            if (poly[1810]!!.contains(lat, lng)) 223 else 253
        } else if (lng < 127.805486f) if (lng < 116.484180f) if (lat < 5.101186f) if (lat < -5.413892f) {
            if (poly[1811]!!.contains(lat, lng)) 258 else 243
        } else if (lng < 111.199993f) if (lat < -0.211034f) {
            if (poly[1812]!!.contains(lat, lng)) 267 else 243
        } else if (lng < 108.557899f) {
            if (poly[1813]!!.contains(lat, lng)) 267 else 243
        } else if (lat < 1.983621f) {
            if (poly[1814]!!.contains(lat, lng)) return 243
            if (poly[1815]!!.contains(lat, lng)) 254 else 267
        } else {
            if (poly[1816]!!.contains(lat, lng)) return 243
            if (poly[1817]!!.contains(lat, lng)) 267 else 254
        } else if (lat < -0.156353f) if (lng < 113.842086f) {
            if (poly[1818]!!.contains(lat, lng)) 267 else 243
        } else if (lat < -2.785122f) {
            if (poly[1819]!!.contains(lat, lng)) return 243
            if (poly[1820]!!.contains(lat, lng)) 267 else 258
        } else {
            if (poly[1821]!!.contains(lat, lng)) 267 else 258
        } else if (lng < 113.842086f) if (lat < 2.251313f) if (lng < 112.521039f) {
            if (poly[1822]!!.contains(lat, lng)) 267 else 254
        } else {
            if (poly[1823]!!.contains(lat, lng)) return 254
            if (poly[1824]!!.contains(lat, lng)) 258 else 267
        } else 254 else if (lat < 2.472417f) if (lng < 115.163133f) if (lat < 1.158032f) if (lng < 114.502610f) {
            if (poly[1825]!!.contains(lat, lng)) 258 else 267
        } else {
            if (poly[1826]!!.contains(lat, lng)) return 267
            if (poly[1827]!!.contains(lat, lng)) 267 else 258
        } else if (lng < 114.502610f) {
            if (poly[1828]!!.contains(lat, lng)) return 254
            if (poly[1829]!!.contains(lat, lng)) 267 else 258
        } else {
            if (poly[1830]!!.contains(lat, lng)) 254 else 258
        } else {
            if (poly[1831]!!.contains(lat, lng)) return 254
            if (poly[1832]!!.contains(lat, lng)) 267 else 258
        } else if (lng < 115.163133f) if (lat < 3.786801f) {
            if (poly[1833]!!.contains(lat, lng)) return 258
            if (poly[1834]!!.contains(lat, lng)) 258 else 254
        } else if (lng < 114.502610f) {
            if (poly[1835]!!.contains(lat, lng)) 227 else 254
        } else {
            if (poly[1836]!!.contains(lat, lng)) return 254
            if (poly[1837]!!.contains(lat, lng)) 254 else 227
        } else if (lat < 3.786801f) {
            if (poly[1838]!!.contains(lat, lng)) return 254
            if (poly[1839]!!.contains(lat, lng)) 254 else 258
        } else {
            if (poly[1840]!!.contains(lat, lng)) return 227
            if (poly[1841]!!.contains(lat, lng)) 258 else 254
        } else 254 else if (lat < 3.446428f) if (lat < -3.881070f) if (lng < 122.144833f) 258 else {
            if (poly[1842]!!.contains(lat, lng)) return 244
            if (poly[1843]!!.contains(lat, lng)) 258 else 233
        } else {
            if (poly[1844]!!.contains(lat, lng)) 244 else 258
        } else if (lng < 119.439088f) if (lat < 5.115101f) if (lng < 118.472828f) {
            if (poly[1845]!!.contains(lat, lng)) 258 else 254
        } else if (lat < 4.122173f) 254 else {
            if (poly[1846]!!.contains(lat, lng)) 254 else 259
        } else {
            if (poly[1847]!!.contains(lat, lng)) 259 else 254
        } else {
            if (poly[1848]!!.contains(lat, lng)) 259 else 258
        } else if (lat < -10.852463f) 309 else if (lat < 3.446428f) if (lng < 131.183524f) {
            if (poly[1849]!!.contains(lat, lng)) 416 else 244
        } else if (lat < 2.014817f) 244 else 416 else 416
    }

    private fun call28(lat: Float, lng: Float): Int {
        return if (lat < -25.996391f) if (lat < -39.287226f) if (lat < -47.545812f) if (lat < -64.000000f) if (lng < 86.000000f) if (lat < -86.000000f) 205 else if (lng < 55.000000f) {
            if (poly[1850]!!.contains(lat, lng)) 208 else 205
        } else if (lng < 77.500000f) {
            if (poly[1851]!!.contains(lat, lng)) 204 else 205
        } else {
            if (poly[1852]!!.contains(lat, lng)) 205 else 201
        } else {
            if (poly[1853]!!.contains(lat, lng)) return 200
            if (poly[1854]!!.contains(lat, lng)) return 202
            if (poly[1855]!!.contains(lat, lng)) return 210
            if (poly[1856]!!.contains(lat, lng)) 315 else 205
        } else if (lng < 159.340270f) if (lat < -52.187445f) 203 else 383 else 390 else if (lng < 146.810136f) if (lng < 144.428469f) if (lng < 52.617433f) 383 else if (lat < -40.420775f) 311 else {
            if (poly[1857]!!.contains(lat, lng)) 311 else 308
        } else 311 else if (lng < 148.569095f) 311 else 390 else if (lng < 134.366448f) if (lng < 122.277320f) if (lng < 77.849497f) 383 else 315 else if (lng < 124.235687f) 315 else if (lat < -33.684270f) 305 else {
            if (poly[1858]!!.contains(lat, lng)) return 309
            if (poly[1859]!!.contains(lat, lng)) return 310
            if (poly[1860]!!.contains(lat, lng)) 315 else 305
        } else if (lng < 137.999053f) if (lat < -33.624782f) 305 else {
            if (poly[1861]!!.contains(lat, lng)) 309 else 305
        } else if (lng < 153.695857f) if (lat < -38.854388f) if (lat < -39.198478f) if (lng < 146.594326f) {
            if (poly[1862]!!.contains(lat, lng)) 314 else 311
        } else 311 else 314 else if (lng < 145.847455f) if (lat < -32.425390f) if (lng < 141.923254f) if (lat < -35.454133f) {
            if (poly[1863]!!.contains(lat, lng)) 314 else 305
        } else {
            if (poly[1864]!!.contains(lat, lng)) return 305
            if (poly[1865]!!.contains(lat, lng)) 316 else 314
        } else if (lat < -35.639889f) {
            if (poly[1866]!!.contains(lat, lng)) 316 else 314
        } else if (lng < 143.885355f) if (lat < -34.032639f) if (lng < 142.904304f) if (lat < -34.836264f) 314 else if (lng < 142.413779f) {
            if (poly[1867]!!.contains(lat, lng)) 314 else 316
        } else {
            if (poly[1868]!!.contains(lat, lng)) 316 else 314
        } else {
            if (poly[1869]!!.contains(lat, lng)) 316 else 314
        } else 316 else {
            if (poly[1870]!!.contains(lat, lng)) 314 else 316
        } else {
            if (poly[1871]!!.contains(lat, lng)) return 305
            if (poly[1872]!!.contains(lat, lng)) return 306
            if (poly[1873]!!.contains(lat, lng)) 307 else 316
        } else if (lat < -32.425390f) if (lng < 149.227650f) if (lat < -35.639889f) if (lng < 147.537553f) {
            if (poly[1874]!!.contains(lat, lng)) 316 else 314
        } else {
            if (poly[1875]!!.contains(lat, lng)) 316 else 314
        } else 316 else {
            if (poly[1876]!!.contains(lat, lng)) 314 else 316
        } else if (lng < 149.771656f) {
            if (poly[1877]!!.contains(lat, lng)) 316 else 306
        } else if (lat < -29.210890f) 316 else if (lng < 151.733756f) {
            if (poly[1878]!!.contains(lat, lng)) 316 else 306
        } else if (lat < -27.603641f) if (lng < 152.714807f) {
            if (poly[1879]!!.contains(lat, lng)) 316 else 306
        } else {
            if (poly[1880]!!.contains(lat, lng)) 306 else 316
        } else 306 else if (lng < 168.226126f) if (lat < -30.311389f) 313 else 413 else 390 else if (lng < 147.113234f) if (lng < 123.277466f) if (lng < 63.715132f) if (lng < 56.050791f) if (lng < 41.054591f) 38 else if (lng < 52.838006f) 378 else 388 else 386 else 315 else if (lng < 138.027371f) if (lng < 123.682389f) 315 else if (lng < 129.001483f) {
            if (poly[1881]!!.contains(lat, lng)) 309 else 315
        } else if (lng < 135.982432f) 309 else if (lng < 137.036848f) 309 else {
            if (poly[1882]!!.contains(lat, lng)) 306 else 309
        } else 306 else if (lng < 153.414978f) if (lng < 149.238945f) if (lng < 148.419809f) 306 else {
            if (poly[1883]!!.contains(lat, lng)) 312 else 306
        } else 306 else if (lng < 166.058459f) 414 else if (lat < -22.139087f) 414 else if (lng < 170.449982f) if (lat < -21.090611f) 414 else {
            if (poly[1884]!!.contains(lat, lng)) 414 else 395
        } else 398
    }

    private fun call29(lat: Float, lng: Float): Int {
        return if (lat < 26.335228f) if (lng < 89.060866f) if (lat < 22.121441f) if (lat < 21.923331f) {
            if (poly[1885]!!.contains(lat, lng)) 232 else 251
        } else {
            if (poly[1886]!!.contains(lat, lng)) 232 else 251
        } else if (lng < 84.228394f) 251 else if (lng < 86.644630f) 251 else if (lat < 24.228335f) if (lng < 87.852748f) 251 else if (lat < 23.174888f) {
            if (poly[1887]!!.contains(lat, lng)) 232 else 251
        } else {
            if (poly[1888]!!.contains(lat, lng)) 251 else 232
        } else if (lng < 87.852748f) 251 else if (lat < 25.281781f) {
            if (poly[1889]!!.contains(lat, lng)) 251 else 232
        } else if (lng < 88.456807f) {
            if (poly[1890]!!.contains(lat, lng)) 232 else 251
        } else if (lat < 25.808505f) {
            if (poly[1891]!!.contains(lat, lng)) 251 else 232
        } else {
            if (poly[1892]!!.contains(lat, lng)) return 251
            if (poly[1893]!!.contains(lat, lng)) 251 else 232
        } else if (lat < 15.129296f) 292 else if (lng < 89.139934f) if (lat < 22.048888f) if (lat < 21.738194f) {
            if (poly[1894]!!.contains(lat, lng)) 251 else 232
        } else {
            if (poly[1895]!!.contains(lat, lng)) 251 else 232
        } else if (lat < 22.208629f) {
            if (poly[1896]!!.contains(lat, lng)) 251 else 232
        } else {
            if (poly[1897]!!.contains(lat, lng)) 251 else 232
        } else if (lat < 21.008819f) {
            if (poly[1898]!!.contains(lat, lng)) 232 else 292
        } else if (lng < 91.809154f) if (lat < 23.864359f) {
            if (poly[1899]!!.contains(lat, lng)) 251 else 232
        } else if (lng < 90.474544f) if (lat < 25.099794f) 232 else if (lng < 89.807239f) {
            if (poly[1900]!!.contains(lat, lng)) 251 else 232
        } else {
            if (poly[1901]!!.contains(lat, lng)) 251 else 232
        } else {
            if (poly[1902]!!.contains(lat, lng)) 232 else 251
        } else if (lat < 23.672023f) if (lng < 93.143763f) if (lat < 22.340421f) if (lng < 92.476458f) {
            if (poly[1903]!!.contains(lat, lng)) 292 else 232
        } else {
            if (poly[1904]!!.contains(lat, lng)) return 232
            if (poly[1905]!!.contains(lat, lng)) 251 else 292
        } else {
            if (poly[1906]!!.contains(lat, lng)) return 232
            if (poly[1907]!!.contains(lat, lng)) return 292
            if (poly[1908]!!.contains(lat, lng)) 292 else 251
        } else {
            if (poly[1909]!!.contains(lat, lng)) return 251
            if (poly[1910]!!.contains(lat, lng)) return 251
            if (poly[1911]!!.contains(lat, lng)) return 251
            if (poly[1912]!!.contains(lat, lng)) 251 else 292
        } else if (lng < 93.143763f) {
            if (poly[1913]!!.contains(lat, lng)) return 232
            if (poly[1914]!!.contains(lat, lng)) return 232
            if (poly[1915]!!.contains(lat, lng)) return 232
            if (poly[1916]!!.contains(lat, lng)) 232 else 251
        } else {
            if (poly[1917]!!.contains(lat, lng)) 292 else 251
        } else if (lng < 88.703311f) if (lng < 84.049616f) {
            if (poly[1918]!!.contains(lat, lng)) 249 else 251
        } else if (lng < 86.376464f) if (lng < 85.213040f) {
            if (poly[1919]!!.contains(lat, lng)) 251 else 249
        } else {
            if (poly[1920]!!.contains(lat, lng)) return 251
            if (poly[1921]!!.contains(lat, lng)) 276 else 249
        } else if (lng < 87.539887f) if (lat < 27.291236f) {
            if (poly[1922]!!.contains(lat, lng)) 251 else 249
        } else {
            if (poly[1923]!!.contains(lat, lng)) 276 else 249
        } else if (lat < 27.291108f) if (lng < 88.121599f) {
            if (poly[1924]!!.contains(lat, lng)) 249 else 251
        } else {
            if (poly[1925]!!.contains(lat, lng)) return 232
            if (poly[1926]!!.contains(lat, lng)) return 249
            if (poly[1927]!!.contains(lat, lng)) 249 else 251
        } else if (lng < 88.121599f) {
            if (poly[1928]!!.contains(lat, lng)) return 251
            if (poly[1929]!!.contains(lat, lng)) return 251
            if (poly[1930]!!.contains(lat, lng)) 276 else 249
        } else {
            if (poly[1931]!!.contains(lat, lng)) return 249
            if (poly[1932]!!.contains(lat, lng)) return 276
            if (poly[1933]!!.contains(lat, lng)) 276 else 251
        } else if (lat < 26.458975f) if (lng < 88.746746f) {
            if (poly[1934]!!.contains(lat, lng)) 232 else 251
        } else {
            if (poly[1935]!!.contains(lat, lng)) 232 else 251
        } else if (lng < 91.590842f) if (lng < 90.147077f) if (lat < 27.352981f) {
            if (poly[1936]!!.contains(lat, lng)) return 276
            if (poly[1937]!!.contains(lat, lng)) 283 else 251
        } else {
            if (poly[1938]!!.contains(lat, lng)) return 251
            if (poly[1939]!!.contains(lat, lng)) 283 else 276
        } else if (lat < 27.352981f) {
            if (poly[1940]!!.contains(lat, lng)) 283 else 251
        } else {
            if (poly[1941]!!.contains(lat, lng)) return 251
            if (poly[1942]!!.contains(lat, lng)) return 251
            if (poly[1943]!!.contains(lat, lng)) return 276
            if (poly[1944]!!.contains(lat, lng)) 276 else 283
        } else if (lng < 93.034608f) if (lat < 27.352981f) {
            if (poly[1945]!!.contains(lat, lng)) 283 else 251
        } else if (lng < 92.312725f) {
            if (poly[1946]!!.contains(lat, lng)) return 276
            if (poly[1947]!!.contains(lat, lng)) return 283
            if (poly[1948]!!.contains(lat, lng)) return 283
            if (poly[1949]!!.contains(lat, lng)) 283 else 251
        } else {
            if (poly[1950]!!.contains(lat, lng)) 276 else 251
        } else 251
    }

    private fun call30(lat: Float, lng: Float): Int {
        return if (lat < 18.448556f) if (lng < 102.253288f) if (lat < 8.292758f) 223 else if (lat < 18.219182f) if (lng < 102.082795f) {
            if (poly[1951]!!.contains(lat, lng)) 289 else 223
        } else {
            if (poly[1952]!!.contains(lat, lng)) 289 else 223
        } else {
            if (poly[1953]!!.contains(lat, lng)) 223 else 289
        } else if (lng < 107.634999f) if (lat < 15.319436f) if (lat < 11.749251f) if (lng < 104.944143f) {
            if (poly[1954]!!.contains(lat, lng)) return 223
            if (poly[1955]!!.contains(lat, lng)) 239 else 266
        } else if (lat < 9.969693f) 239 else if (lng < 106.289571f) if (lat < 10.859472f) {
            if (poly[1956]!!.contains(lat, lng)) return 266
            if (poly[1957]!!.contains(lat, lng)) return 266
            if (poly[1958]!!.contains(lat, lng)) 266 else 239
        } else {
            if (poly[1959]!!.contains(lat, lng)) return 239
            if (poly[1960]!!.contains(lat, lng)) return 239
            if (poly[1961]!!.contains(lat, lng)) 239 else 266
        } else {
            if (poly[1962]!!.contains(lat, lng)) 266 else 239
        } else if (lng < 104.944143f) if (lat < 13.534344f) {
            if (poly[1963]!!.contains(lat, lng)) 266 else 223
        } else if (lng < 103.598716f) {
            if (poly[1964]!!.contains(lat, lng)) 266 else 223
        } else {
            if (poly[1965]!!.contains(lat, lng)) 266 else 223
        } else if (lat < 13.534344f) if (lng < 106.289571f) {
            if (poly[1966]!!.contains(lat, lng)) return 239
            if (poly[1967]!!.contains(lat, lng)) 239 else 266
        } else {
            if (poly[1968]!!.contains(lat, lng)) 266 else 239
        } else if (lng < 106.289571f) if (lat < 14.426890f) if (lng < 105.616857f) {
            if (poly[1969]!!.contains(lat, lng)) return 266
            if (poly[1970]!!.contains(lat, lng)) 289 else 223
        } else {
            if (poly[1971]!!.contains(lat, lng)) 289 else 266
        } else {
            if (poly[1972]!!.contains(lat, lng)) return 223
            if (poly[1973]!!.contains(lat, lng)) 266 else 289
        } else if (lat < 14.426890f) {
            if (poly[1974]!!.contains(lat, lng)) return 239
            if (poly[1975]!!.contains(lat, lng)) return 289
            if (poly[1976]!!.contains(lat, lng)) 289 else 266
        } else if (lng < 106.962285f) {
            if (poly[1977]!!.contains(lat, lng)) 266 else 289
        } else {
            if (poly[1978]!!.contains(lat, lng)) return 239
            if (poly[1979]!!.contains(lat, lng)) return 266
            if (poly[1980]!!.contains(lat, lng)) 266 else 289
        } else if (lng < 103.407830f) {
            if (poly[1981]!!.contains(lat, lng)) 289 else 223
        } else if (lng < 105.521414f) if (lat < 16.883996f) {
            if (poly[1982]!!.contains(lat, lng)) return 289
            if (poly[1983]!!.contains(lat, lng)) 289 else 223
        } else {
            if (poly[1984]!!.contains(lat, lng)) return 223
            if (poly[1985]!!.contains(lat, lng)) 239 else 289
        } else if (lat < 16.883996f) if (lng < 106.578207f) {
            if (poly[1986]!!.contains(lat, lng)) return 223
            if (poly[1987]!!.contains(lat, lng)) return 223
            if (poly[1988]!!.contains(lat, lng)) 239 else 289
        } else {
            if (poly[1989]!!.contains(lat, lng)) 289 else 239
        } else {
            if (poly[1990]!!.contains(lat, lng)) 289 else 239
        } else if (lat < 17.561326f) 239 else 276 else if (lng < 108.223287f) if (lng < 101.357205f) if (lat < 19.605225f) if (lat < 19.049923f) {
            if (poly[1991]!!.contains(lat, lng)) 223 else 289
        } else {
            if (poly[1992]!!.contains(lat, lng)) 223 else 289
        } else if (lat < 21.355555f) {
            if (poly[1993]!!.contains(lat, lng)) 289 else 276
        } else {
            if (poly[1994]!!.contains(lat, lng)) 289 else 276
        } else if (lat < 23.347772f) if (lng < 104.790246f) if (lat < 20.898164f) if (lng < 103.073725f) 289 else if (lat < 19.673360f) {
            if (poly[1995]!!.contains(lat, lng)) 239 else 289
        } else if (lng < 103.931986f) {
            if (poly[1996]!!.contains(lat, lng)) return 239
            if (poly[1997]!!.contains(lat, lng)) 239 else 289
        } else {
            if (poly[1998]!!.contains(lat, lng)) 289 else 239
        } else if (lng < 103.073725f) if (lat < 22.122968f) if (lng < 102.215465f) {
            if (poly[1999]!!.contains(lat, lng)) 276 else 289
        } else {
            if (poly[2000]!!.contains(lat, lng)) 239 else 289
        } else if (lng < 102.215465f) {
            if (poly[2001]!!.contains(lat, lng)) return 239
            if (poly[2002]!!.contains(lat, lng)) 289 else 276
        } else {
            if (poly[2003]!!.contains(lat, lng)) return 276
            if (poly[2004]!!.contains(lat, lng)) 289 else 239
        } else if (lat < 22.122968f) {
            if (poly[2005]!!.contains(lat, lng)) return 289
            if (poly[2006]!!.contains(lat, lng)) return 289
            if (poly[2007]!!.contains(lat, lng)) 289 else 239
        } else {
            if (poly[2008]!!.contains(lat, lng)) 276 else 239
        } else if (lat < 20.898164f) {
            if (poly[2009]!!.contains(lat, lng)) return 289
            if (poly[2010]!!.contains(lat, lng)) 289 else 239
        } else if (lng < 106.506766f) {
            if (poly[2011]!!.contains(lat, lng)) return 276
            if (poly[2012]!!.contains(lat, lng)) 276 else 239
        } else if (lat < 22.122968f) {
            if (poly[2013]!!.contains(lat, lng)) 276 else 239
        } else {
            if (poly[2014]!!.contains(lat, lng)) 239 else 276
        } else {
            if (poly[2015]!!.contains(lat, lng)) 239 else 276
        } else 276
    }

    private fun call31(lat: Float, lng: Float): Int {
        return if (lat < 6.726082f) if (lng < 100.205056f) if (lng < 100.004163f) {
            if (poly[2016]!!.contains(lat, lng)) 253 else 223
        } else {
            if (poly[2017]!!.contains(lat, lng)) 253 else 223
        } else if (lng < 100.624518f) {
            if (poly[2018]!!.contains(lat, lng)) 253 else 223
        } else {
            if (poly[2019]!!.contains(lat, lng)) 253 else 223
        } else if (lng < 97.395561f) if (lat < 12.069914f) 292 else if (lat < 18.599493f) {
            if (poly[2020]!!.contains(lat, lng)) 223 else 292
        } else if (lat < 23.423240f) 292 else if (lat < 25.835113f) {
            if (poly[2021]!!.contains(lat, lng)) 251 else 292
        } else if (lng < 95.936967f) {
            if (poly[2022]!!.contains(lat, lng)) 292 else 251
        } else if (lat < 27.041050f) 292 else if (lng < 96.666264f) {
            if (poly[2023]!!.contains(lat, lng)) 292 else 251
        } else {
            if (poly[2024]!!.contains(lat, lng)) return 276
            if (poly[2025]!!.contains(lat, lng)) 292 else 251
        } else if (lng < 101.170080f) if (lat < 18.314450f) if (lng < 99.664904f) if (lat < 11.823147f) {
            if (poly[2026]!!.contains(lat, lng)) 292 else 223
        } else if (lng < 97.548732f) if (lat < 15.337759f) 292 else {
            if (poly[2027]!!.contains(lat, lng)) 223 else 292
        } else if (lat < 15.068799f) if (lat < 13.445973f) {
            if (poly[2028]!!.contains(lat, lng)) 223 else 292
        } else {
            if (poly[2029]!!.contains(lat, lng)) 223 else 292
        } else if (lat < 16.691624f) if (lng < 98.606818f) {
            if (poly[2030]!!.contains(lat, lng)) return 223
            if (poly[2031]!!.contains(lat, lng)) return 223
            if (poly[2032]!!.contains(lat, lng)) 223 else 292
        } else {
            if (poly[2033]!!.contains(lat, lng)) return 292
            if (poly[2034]!!.contains(lat, lng)) 292 else 223
        } else if (lng < 98.606818f) if (lat < 17.503037f) {
            if (poly[2035]!!.contains(lat, lng)) 223 else 292
        } else {
            if (poly[2036]!!.contains(lat, lng)) 292 else 223
        } else 223 else if (lat < 10.556464f) 223 else if (lat < 18.050637f) {
            if (poly[2037]!!.contains(lat, lng)) 289 else 223
        } else if (lat < 18.149411f) {
            if (poly[2038]!!.contains(lat, lng)) 289 else 223
        } else {
            if (poly[2039]!!.contains(lat, lng)) 289 else 223
        } else if (lat < 18.554059f) if (lng < 97.622409f) if (lat < 18.487057f) if (lng < 97.461327f) {
            if (poly[2040]!!.contains(lat, lng)) 292 else 223
        } else {
            if (poly[2041]!!.contains(lat, lng)) 292 else 223
        } else {
            if (poly[2042]!!.contains(lat, lng)) 292 else 223
        } else {
            if (poly[2043]!!.contains(lat, lng)) 289 else 223
        } else if (lng < 97.410440f) {
            if (poly[2044]!!.contains(lat, lng)) 223 else 292
        } else if (lat < 23.400523f) if (lat < 20.977291f) if (lng < 99.290260f) if (lat < 19.765675f) {
            if (poly[2045]!!.contains(lat, lng)) return 292
            if (poly[2046]!!.contains(lat, lng)) return 292
            if (poly[2047]!!.contains(lat, lng)) return 292
            if (poly[2048]!!.contains(lat, lng)) 292 else 223
        } else {
            if (poly[2049]!!.contains(lat, lng)) return 223
            if (poly[2050]!!.contains(lat, lng)) return 223
            if (poly[2051]!!.contains(lat, lng)) return 223
            if (poly[2052]!!.contains(lat, lng)) 223 else 292
        } else if (lat < 19.765675f) {
            if (poly[2053]!!.contains(lat, lng)) 289 else 223
        } else if (lng < 100.230170f) {
            if (poly[2054]!!.contains(lat, lng)) return 289
            if (poly[2055]!!.contains(lat, lng)) 292 else 223
        } else {
            if (poly[2056]!!.contains(lat, lng)) return 223
            if (poly[2057]!!.contains(lat, lng)) 292 else 289
        } else if (lng < 99.290260f) {
            if (poly[2058]!!.contains(lat, lng)) return 276
            if (poly[2059]!!.contains(lat, lng)) 276 else 292
        } else if (lat < 22.188907f) if (lng < 100.230170f) {
            if (poly[2060]!!.contains(lat, lng)) 276 else 292
        } else {
            if (poly[2061]!!.contains(lat, lng)) return 276
            if (poly[2062]!!.contains(lat, lng)) return 276
            if (poly[2063]!!.contains(lat, lng)) 289 else 292
        } else {
            if (poly[2064]!!.contains(lat, lng)) 292 else 276
        } else if (lat < 25.823755f) if (lng < 99.290260f) if (lat < 24.612139f) if (lng < 98.350350f) {
            if (poly[2065]!!.contains(lat, lng)) 276 else 292
        } else {
            if (poly[2066]!!.contains(lat, lng)) 292 else 276
        } else {
            if (poly[2067]!!.contains(lat, lng)) return 292
            if (poly[2068]!!.contains(lat, lng)) 292 else 276
        } else 276 else if (lng < 99.290260f) if (lat < 27.035371f) {
            if (poly[2069]!!.contains(lat, lng)) 292 else 276
        } else {
            if (poly[2070]!!.contains(lat, lng)) 292 else 276
        } else 276 else call30(lat, lng)
    }

    private fun call32(lat: Float, lng: Float): Int {
        return if (lat < 37.380932f) if (lng < 42.791612f) if (lat < 31.979666f) {
            if (poly[2071]!!.contains(lat, lng)) 220 else 272
        } else if (lat < 34.680299f) {
            if (poly[2072]!!.contains(lat, lng)) 231 else 220
        } else {
            if (poly[2073]!!.contains(lat, lng)) return 220
            if (poly[2074]!!.contains(lat, lng)) 336 else 231
        } else if (lat < 32.813960f) if (lng < 46.900321f) {
            if (poly[2075]!!.contains(lat, lng)) return 255
            if (poly[2076]!!.contains(lat, lng)) return 272
            if (poly[2077]!!.contains(lat, lng)) 282 else 220
        } else if (lat < 30.530473f) if (lng < 48.954676f) if (lat < 29.388730f) {
            if (poly[2078]!!.contains(lat, lng)) 272 else 255
        } else {
            if (poly[2079]!!.contains(lat, lng)) return 255
            if (poly[2080]!!.contains(lat, lng)) 282 else 220
        } else {
            if (poly[2081]!!.contains(lat, lng)) return 255
            if (poly[2082]!!.contains(lat, lng)) 272 else 282
        } else {
            if (poly[2083]!!.contains(lat, lng)) 220 else 282
        } else if (lng < 46.900321f) if (lat < 35.097446f) if (lng < 44.845967f) 220 else if (lat < 33.955703f) {
            if (poly[2084]!!.contains(lat, lng)) 282 else 220
        } else {
            if (poly[2085]!!.contains(lat, lng)) 282 else 220
        } else if (lng < 44.845967f) {
            if (poly[2086]!!.contains(lat, lng)) return 282
            if (poly[2087]!!.contains(lat, lng)) return 282
            if (poly[2088]!!.contains(lat, lng)) 336 else 220
        } else if (lat < 36.239189f) {
            if (poly[2089]!!.contains(lat, lng)) 282 else 220
        } else {
            if (poly[2090]!!.contains(lat, lng)) return 220
            if (poly[2091]!!.contains(lat, lng)) 220 else 282
        } else 282 else if (lng < 50.322893f) if (lat < 40.669330f) if (lng < 45.275237f) if (lng < 42.751408f) 336 else if (lat < 39.025131f) {
            if (poly[2092]!!.contains(lat, lng)) 336 else 282
        } else if (lng < 44.013323f) {
            if (poly[2093]!!.contains(lat, lng)) 294 else 336
        } else if (lat < 39.847231f) if (lng < 44.644280f) {
            if (poly[2094]!!.contains(lat, lng)) return 282
            if (poly[2095]!!.contains(lat, lng)) 294 else 336
        } else {
            if (poly[2096]!!.contains(lat, lng)) return 282
            if (poly[2097]!!.contains(lat, lng)) return 294
            if (poly[2098]!!.contains(lat, lng)) 336 else 222
        } else {
            if (poly[2099]!!.contains(lat, lng)) 336 else 294
        } else if (lng < 47.799065f) if (lat < 39.025131f) {
            if (poly[2100]!!.contains(lat, lng)) return 222
            if (poly[2101]!!.contains(lat, lng)) return 222
            if (poly[2102]!!.contains(lat, lng)) 294 else 282
        } else if (lng < 46.537151f) if (lat < 39.847231f) if (lng < 45.906194f) {
            if (poly[2103]!!.contains(lat, lng)) return 282
            if (poly[2104]!!.contains(lat, lng)) 294 else 222
        } else {
            if (poly[2105]!!.contains(lat, lng)) 294 else 222
        } else {
            if (poly[2106]!!.contains(lat, lng)) 222 else 294
        } else {
            if (poly[2107]!!.contains(lat, lng)) return 282
            if (poly[2108]!!.contains(lat, lng)) return 294
            if (poly[2109]!!.contains(lat, lng)) return 294
            if (poly[2110]!!.contains(lat, lng)) 294 else 222
        } else {
            if (poly[2111]!!.contains(lat, lng)) 222 else 282
        } else if (lng < 45.148935f) if (lng < 42.688258f) if (lat < 42.127880f) {
            if (poly[2112]!!.contains(lat, lng)) 281 else 336
        } else {
            if (poly[2113]!!.contains(lat, lng)) 350 else 281
        } else if (lat < 42.127880f) if (lng < 43.918596f) {
            if (poly[2114]!!.contains(lat, lng)) return 294
            if (poly[2115]!!.contains(lat, lng)) 336 else 281
        } else {
            if (poly[2116]!!.contains(lat, lng)) return 222
            if (poly[2117]!!.contains(lat, lng)) return 222
            if (poly[2118]!!.contains(lat, lng)) return 222
            if (poly[2119]!!.contains(lat, lng)) 281 else 294
        } else {
            if (poly[2120]!!.contains(lat, lng)) 350 else 281
        } else if (lng < 47.609613f) if (lat < 42.127880f) if (lng < 46.379274f) if (lat < 41.398605f) {
            if (poly[2121]!!.contains(lat, lng)) return 281
            if (poly[2122]!!.contains(lat, lng)) return 281
            if (poly[2123]!!.contains(lat, lng)) return 294
            if (poly[2124]!!.contains(lat, lng)) 294 else 222
        } else {
            if (poly[2125]!!.contains(lat, lng)) return 222
            if (poly[2126]!!.contains(lat, lng)) return 222
            if (poly[2127]!!.contains(lat, lng)) 350 else 281
        } else if (lat < 41.398605f) {
            if (poly[2128]!!.contains(lat, lng)) return 281
            if (poly[2129]!!.contains(lat, lng)) 350 else 222
        } else {
            if (poly[2130]!!.contains(lat, lng)) return 281
            if (poly[2131]!!.contains(lat, lng)) return 281
            if (poly[2132]!!.contains(lat, lng)) 350 else 222
        } else {
            if (poly[2133]!!.contains(lat, lng)) 281 else 350
        } else {
            if (poly[2134]!!.contains(lat, lng)) 222 else 350
        } else if (lat < 42.071394f) 216 else 222
    }

    private fun call33(lat: Float, lng: Float): Int {
        return if (lat < 38.285000f) if (lat < 34.044171f) if (lng < 60.483127f) 282 else if (lng < 65.220176f) if (lat < 31.145579f) if (lng < 62.851652f) {
            if (poly[2135]!!.contains(lat, lng)) return 246
            if (poly[2136]!!.contains(lat, lng)) 248 else 282
        } else {
            if (poly[2137]!!.contains(lat, lng)) 248 else 246
        } else {
            if (poly[2138]!!.contains(lat, lng)) 282 else 246
        } else if (lat < 31.145579f) {
            if (poly[2139]!!.contains(lat, lng)) 246 else 248
        } else if (lng < 67.588701f) {
            if (poly[2140]!!.contains(lat, lng)) return 248
            if (poly[2141]!!.contains(lat, lng)) 248 else 246
        } else if (lat < 32.594875f) {
            if (poly[2142]!!.contains(lat, lng)) return 246
            if (poly[2143]!!.contains(lat, lng)) 246 else 248
        } else {
            if (poly[2144]!!.contains(lat, lng)) return 248
            if (poly[2145]!!.contains(lat, lng)) 248 else 246
        } else if (lng < 56.756389f) {
            if (poly[2146]!!.contains(lat, lng)) 218 else 282
        } else if (lng < 63.356807f) if (lng < 60.056598f) {
            if (poly[2147]!!.contains(lat, lng)) 218 else 282
        } else if (lat < 36.164585f) if (lng < 61.706702f) if (lat < 35.104378f) {
            if (poly[2148]!!.contains(lat, lng)) 282 else 246
        } else {
            if (poly[2149]!!.contains(lat, lng)) return 218
            if (poly[2150]!!.contains(lat, lng)) 246 else 282
        } else {
            if (poly[2151]!!.contains(lat, lng)) 246 else 218
        } else {
            if (poly[2152]!!.contains(lat, lng)) 282 else 218
        } else if (lng < 66.657016f) if (lat < 36.164585f) {
            if (poly[2153]!!.contains(lat, lng)) 218 else 246
        } else if (lng < 65.006912f) {
            if (poly[2154]!!.contains(lat, lng)) 246 else 218
        } else {
            if (poly[2155]!!.contains(lat, lng)) return 246
            if (poly[2156]!!.contains(lat, lng)) return 273
            if (poly[2157]!!.contains(lat, lng)) 273 else 218
        } else if (lat < 36.164585f) 246 else if (lng < 68.307120f) if (lat < 37.224793f) {
            if (poly[2158]!!.contains(lat, lng)) return 235
            if (poly[2159]!!.contains(lat, lng)) return 273
            if (poly[2160]!!.contains(lat, lng)) return 273
            if (poly[2161]!!.contains(lat, lng)) 273 else 246
        } else {
            if (poly[2162]!!.contains(lat, lng)) return 218
            if (poly[2163]!!.contains(lat, lng)) return 235
            if (poly[2164]!!.contains(lat, lng)) return 235
            if (poly[2165]!!.contains(lat, lng)) return 246
            if (poly[2166]!!.contains(lat, lng)) return 246
            if (poly[2167]!!.contains(lat, lng)) 246 else 273
        } else {
            if (poly[2168]!!.contains(lat, lng)) return 246
            if (poly[2169]!!.contains(lat, lng)) 273 else 235
        } else if (lng < 65.572439f) if (lng < 62.755236f) if (lng < 56.882133f) {
            if (poly[2170]!!.contains(lat, lng)) return 216
            if (poly[2171]!!.contains(lat, lng)) 273 else 218
        } else if (lng < 59.818685f) if (lat < 40.935715f) 218 else if (lng < 58.350409f) {
            if (poly[2172]!!.contains(lat, lng)) 273 else 218
        } else {
            if (poly[2173]!!.contains(lat, lng)) return 273
            if (poly[2174]!!.contains(lat, lng)) 273 else 218
        } else if (lat < 40.935715f) {
            if (poly[2175]!!.contains(lat, lng)) 273 else 218
        } else {
            if (poly[2176]!!.contains(lat, lng)) return 218
            if (poly[2177]!!.contains(lat, lng)) 271 else 273
        } else if (lat < 39.806350f) {
            if (poly[2178]!!.contains(lat, lng)) 273 else 218
        } else if (lng < 64.572848f) {
            if (poly[2179]!!.contains(lat, lng)) 271 else 273
        } else {
            if (poly[2180]!!.contains(lat, lng)) 271 else 273
        } else if (lat < 41.733579f) if (lng < 67.764832f) if (lat < 40.009289f) {
            if (poly[2181]!!.contains(lat, lng)) return 235
            if (poly[2182]!!.contains(lat, lng)) 280 else 273
        } else {
            if (poly[2183]!!.contains(lat, lng)) return 213
            if (poly[2184]!!.contains(lat, lng)) 273 else 280
        } else if (lat < 40.009289f) if (lng < 68.861028f) if (lat < 39.147145f) {
            if (poly[2185]!!.contains(lat, lng)) 235 else 273
        } else {
            if (poly[2186]!!.contains(lat, lng)) 235 else 280
        } else {
            if (poly[2187]!!.contains(lat, lng)) return 226
            if (poly[2188]!!.contains(lat, lng)) 280 else 235
        } else if (lng < 68.861028f) if (lat < 40.871434f) {
            if (poly[2189]!!.contains(lat, lng)) return 213
            if (poly[2190]!!.contains(lat, lng)) return 235
            if (poly[2191]!!.contains(lat, lng)) 235 else 280
        } else {
            if (poly[2192]!!.contains(lat, lng)) return 280
            if (poly[2193]!!.contains(lat, lng)) 280 else 213
        } else if (lat < 40.871434f) if (lng < 69.409127f) {
            if (poly[2194]!!.contains(lat, lng)) return 226
            if (poly[2195]!!.contains(lat, lng)) return 280
            if (poly[2196]!!.contains(lat, lng)) return 280
            if (poly[2197]!!.contains(lat, lng)) 280 else 235
        } else {
            if (poly[2198]!!.contains(lat, lng)) return 226
            if (poly[2199]!!.contains(lat, lng)) 280 else 235
        } else {
            if (poly[2200]!!.contains(lat, lng)) 213 else 280
        } else {
            if (poly[2201]!!.contains(lat, lng)) return 271
            if (poly[2202]!!.contains(lat, lng)) 273 else 213
        }
    }

    private fun call34(lat: Float, lng: Float): Int {
        return if (lng < 49.288299f) if (lat < 52.387711f) if (lng < 45.089563f) if (lng < 43.501662f) if (lng < 43.124133f) {
            if (poly[2203]!!.contains(lat, lng)) 360 else 350
        } else {
            if (poly[2204]!!.contains(lat, lng)) 350 else 360
        } else if (lng < 43.878043f) {
            if (poly[2205]!!.contains(lat, lng)) 350 else 360
        } else if (lng < 44.388141f) {
            if (poly[2206]!!.contains(lat, lng)) 350 else 360
        } else {
            if (poly[2207]!!.contains(lat, lng)) 350 else 360
        } else if (lng < 45.307564f) if (lng < 45.260551f) {
            if (poly[2208]!!.contains(lat, lng)) 350 else 360
        } else {
            if (poly[2209]!!.contains(lat, lng)) 350 else 360
        } else if (lng < 45.360905f) {
            if (poly[2210]!!.contains(lat, lng)) 350 else 360
        } else if (lng < 45.430033f) {
            if (poly[2211]!!.contains(lat, lng)) 350 else 360
        } else {
            if (poly[2212]!!.contains(lat, lng)) 357 else 360
        } else if (lng < 45.273475f) if (lng < 43.925487f) if (lng < 43.344869f) {
            if (poly[2213]!!.contains(lat, lng)) 360 else 350
        } else if (lng < 43.848071f) {
            if (poly[2214]!!.contains(lat, lng)) 360 else 350
        } else {
            if (poly[2215]!!.contains(lat, lng)) 360 else 350
        } else if (lng < 44.892499f) {
            if (poly[2216]!!.contains(lat, lng)) 360 else 350
        } else if (lng < 45.217066f) {
            if (poly[2217]!!.contains(lat, lng)) 360 else 350
        } else {
            if (poly[2218]!!.contains(lat, lng)) 360 else 350
        } else if (lng < 45.426670f) if (lng < 45.355728f) {
            if (poly[2219]!!.contains(lat, lng)) 360 else 350
        } else {
            if (poly[2220]!!.contains(lat, lng)) 360 else 350
        } else if (lng < 47.357484f) if (lat < 53.639578f) if (lng < 46.392077f) {
            if (poly[2221]!!.contains(lat, lng)) 360 else 350
        } else if (lat < 53.013644f) {
            if (poly[2222]!!.contains(lat, lng)) return 350
            if (poly[2223]!!.contains(lat, lng)) 367 else 360
        } else {
            if (poly[2224]!!.contains(lat, lng)) 367 else 350
        } else if (lng < 46.392077f) {
            if (poly[2225]!!.contains(lat, lng)) return 367
            if (poly[2226]!!.contains(lat, lng)) 367 else 350
        } else if (lat < 54.265512f) {
            if (poly[2227]!!.contains(lat, lng)) 367 else 350
        } else {
            if (poly[2228]!!.contains(lat, lng)) return 367
            if (poly[2229]!!.contains(lat, lng)) 367 else 350
        } else if (lat < 53.639578f) if (lng < 48.322892f) if (lat < 53.013644f) {
            if (poly[2230]!!.contains(lat, lng)) return 357
            if (poly[2231]!!.contains(lat, lng)) return 357
            if (poly[2232]!!.contains(lat, lng)) 360 else 367
        } else {
            if (poly[2233]!!.contains(lat, lng)) 357 else 367
        } else {
            if (poly[2234]!!.contains(lat, lng)) return 360
            if (poly[2235]!!.contains(lat, lng)) return 360
            if (poly[2236]!!.contains(lat, lng)) return 367
            if (poly[2237]!!.contains(lat, lng)) return 367
            if (poly[2238]!!.contains(lat, lng)) 367 else 357
        } else if (lng < 48.322892f) {
            if (poly[2239]!!.contains(lat, lng)) 350 else 367
        } else {
            if (poly[2240]!!.contains(lat, lng)) return 350
            if (poly[2241]!!.contains(lat, lng)) return 357
            if (poly[2242]!!.contains(lat, lng)) 357 else 367
        } else if (lat < 52.486204f) if (lng < 53.016204f) if (lng < 51.152252f) if (lng < 50.220275f) {
            if (poly[2243]!!.contains(lat, lng)) return 265
            if (poly[2244]!!.contains(lat, lng)) return 357
            if (poly[2245]!!.contains(lat, lng)) 357 else 360
        } else if (lat < 51.866906f) {
            if (poly[2246]!!.contains(lat, lng)) return 293
            if (poly[2247]!!.contains(lat, lng)) return 357
            if (poly[2248]!!.contains(lat, lng)) 360 else 265
        } else {
            if (poly[2249]!!.contains(lat, lng)) return 293
            if (poly[2250]!!.contains(lat, lng)) return 360
            if (poly[2251]!!.contains(lat, lng)) 360 else 357
        } else if (lng < 52.084228f) {
            if (poly[2252]!!.contains(lat, lng)) return 265
            if (poly[2253]!!.contains(lat, lng)) 357 else 293
        } else {
            if (poly[2254]!!.contains(lat, lng)) 293 else 265
        } else {
            if (poly[2255]!!.contains(lat, lng)) 293 else 265
        } else if (lng < 50.243401f) if (lat < 54.219528f) {
            if (poly[2256]!!.contains(lat, lng)) 367 else 357
        } else {
            if (poly[2257]!!.contains(lat, lng)) return 350
            if (poly[2258]!!.contains(lat, lng)) 357 else 367
        } else if (lng < 53.493755f) if (lng < 51.868578f) {
            if (poly[2259]!!.contains(lat, lng)) return 293
            if (poly[2260]!!.contains(lat, lng)) 350 else 357
        } else if (lat < 53.688825f) {
            if (poly[2261]!!.contains(lat, lng)) 293 else 357
        } else if (lng < 52.681167f) {
            if (poly[2262]!!.contains(lat, lng)) return 293
            if (poly[2263]!!.contains(lat, lng)) 350 else 357
        } else {
            if (poly[2264]!!.contains(lat, lng)) return 293
            if (poly[2265]!!.contains(lat, lng)) 293 else 350
        } else {
            if (poly[2266]!!.contains(lat, lng)) return 350
            if (poly[2267]!!.contains(lat, lng)) 350 else 293
        }
    }

    private fun call35(lat: Float, lng: Float): Int {
        return if (lng < 50.871335f) if (lat < 61.067393f) if (lat < 56.256925f) {
            if (poly[2268]!!.contains(lat, lng)) 340 else 350
        } else if (lng < 45.549458f) 350 else if (lng < 48.210396f) if (lat < 58.662159f) if (lng < 46.879927f) {
            if (poly[2269]!!.contains(lat, lng)) return 340
            if (poly[2270]!!.contains(lat, lng)) 340 else 350
        } else if (lat < 57.459542f) {
            if (poly[2271]!!.contains(lat, lng)) 350 else 340
        } else {
            if (poly[2272]!!.contains(lat, lng)) return 350
            if (poly[2273]!!.contains(lat, lng)) 350 else 340
        } else if (lng < 46.879927f) {
            if (poly[2274]!!.contains(lat, lng)) return 340
            if (poly[2275]!!.contains(lat, lng)) 340 else 350
        } else if (lat < 59.864776f) {
            if (poly[2276]!!.contains(lat, lng)) 350 else 340
        } else {
            if (poly[2277]!!.contains(lat, lng)) 340 else 350
        } else if (lat < 58.662159f) if (lng < 49.540866f) {
            if (poly[2278]!!.contains(lat, lng)) 350 else 340
        } else {
            if (poly[2279]!!.contains(lat, lng)) 350 else 340
        } else {
            if (poly[2280]!!.contains(lat, lng)) 340 else 350
        } else 350 else if (lat < 58.545842f) if (lng < 53.098981f) if (lng < 50.917326f) if (lat < 56.201553f) {
            if (poly[2281]!!.contains(lat, lng)) 350 else 340
        } else if (lat < 56.333988f) {
            if (poly[2282]!!.contains(lat, lng)) 350 else 340
        } else {
            if (poly[2283]!!.contains(lat, lng)) 350 else 340
        } else if (lat < 56.994006f) if (lng < 52.008154f) if (lat < 56.218088f) if (lng < 51.462740f) {
            if (poly[2284]!!.contains(lat, lng)) return 340
            if (poly[2285]!!.contains(lat, lng)) return 357
            if (poly[2286]!!.contains(lat, lng)) return 357
            if (poly[2287]!!.contains(lat, lng)) 357 else 350
        } else {
            if (poly[2288]!!.contains(lat, lng)) return 340
            if (poly[2289]!!.contains(lat, lng)) return 350
            if (poly[2290]!!.contains(lat, lng)) 350 else 357
        } else {
            if (poly[2291]!!.contains(lat, lng)) 357 else 340
        } else if (lat < 56.218088f) {
            if (poly[2292]!!.contains(lat, lng)) return 350
            if (poly[2293]!!.contains(lat, lng)) 350 else 357
        } else {
            if (poly[2294]!!.contains(lat, lng)) 350 else 357
        } else {
            if (poly[2295]!!.contains(lat, lng)) 357 else 340
        } else if (lat < 56.276134f) if (lng < 61.528103f) if (lng < 57.313542f) if (lng < 55.206261f) if (lng < 54.152621f) if (lng < 53.625801f) {
            if (poly[2296]!!.contains(lat, lng)) 350 else 357
        } else {
            if (poly[2297]!!.contains(lat, lng)) return 350
            if (poly[2298]!!.contains(lat, lng)) 357 else 293
        } else {
            if (poly[2299]!!.contains(lat, lng)) return 350
            if (poly[2300]!!.contains(lat, lng)) 357 else 293
        } else 293 else 293 else 293 else if (lng < 61.528103f) if (lng < 57.313542f) if (lng < 55.206261f) if (lat < 57.410988f) {
            if (poly[2301]!!.contains(lat, lng)) return 293
            if (poly[2302]!!.contains(lat, lng)) 350 else 357
        } else {
            if (poly[2303]!!.contains(lat, lng)) return 293
            if (poly[2304]!!.contains(lat, lng)) 340 else 357
        } else 293 else 293 else 293 else if (lng < 60.414280f) if (lat < 66.074501f) if (lng < 55.642808f) if (lat < 62.310171f) if (lng < 53.257071f) {
            if (poly[2305]!!.contains(lat, lng)) return 293
            if (poly[2306]!!.contains(lat, lng)) return 293
            if (poly[2307]!!.contains(lat, lng)) 340 else 350
        } else {
            if (poly[2308]!!.contains(lat, lng)) return 340
            if (poly[2309]!!.contains(lat, lng)) return 340
            if (poly[2310]!!.contains(lat, lng)) 350 else 293
        } else 350 else if (lat < 62.310171f) {
            if (poly[2311]!!.contains(lat, lng)) 350 else 293
        } else {
            if (poly[2312]!!.contains(lat, lng)) 293 else 350
        } else 350 else if (lat < 66.074501f) {
            if (poly[2313]!!.contains(lat, lng)) 350 else 293
        } else if (lng < 65.185752f) {
            if (poly[2314]!!.contains(lat, lng)) return 293
            if (poly[2315]!!.contains(lat, lng)) return 293
            if (poly[2316]!!.contains(lat, lng)) 293 else 350
        } else {
            if (poly[2317]!!.contains(lat, lng)) return 350
            if (poly[2318]!!.contains(lat, lng)) 350 else 293
        }
    }

    private fun call36(lat: Float, lng: Float): Int {
        return if (lng < 56.744109f) if (lat < 51.247608f) if (lng < 50.034781f) if (lat < 45.187282f) if (lng < 48.975853f) 216 else 350 else if (lng < 45.131181f) if (lat < 48.217445f) {
            if (poly[2319]!!.contains(lat, lng)) return 373
            if (poly[2320]!!.contains(lat, lng)) 373 else 350
        } else if (lng < 42.679380f) if (lat < 49.732527f) {
            if (poly[2321]!!.contains(lat, lng)) return 373
            if (poly[2322]!!.contains(lat, lng)) return 373
            if (poly[2323]!!.contains(lat, lng)) 373 else 350
        } else {
            if (poly[2324]!!.contains(lat, lng)) 373 else 350
        } else if (lat < 49.732527f) {
            if (poly[2325]!!.contains(lat, lng)) return 320
            if (poly[2326]!!.contains(lat, lng)) return 350
            if (poly[2327]!!.contains(lat, lng)) return 350
            if (poly[2328]!!.contains(lat, lng)) return 350
            if (poly[2329]!!.contains(lat, lng)) 350 else 373
        } else {
            if (poly[2330]!!.contains(lat, lng)) return 350
            if (poly[2331]!!.contains(lat, lng)) return 350
            if (poly[2332]!!.contains(lat, lng)) 360 else 373
        } else if (lat < 48.217445f) if (lng < 47.582981f) if (lat < 46.702364f) {
            if (poly[2333]!!.contains(lat, lng)) 320 else 350
        } else {
            if (poly[2334]!!.contains(lat, lng)) return 219
            if (poly[2335]!!.contains(lat, lng)) return 265
            if (poly[2336]!!.contains(lat, lng)) 350 else 320
        } else if (lat < 46.702364f) {
            if (poly[2337]!!.contains(lat, lng)) return 219
            if (poly[2338]!!.contains(lat, lng)) 350 else 320
        } else {
            if (poly[2339]!!.contains(lat, lng)) return 265
            if (poly[2340]!!.contains(lat, lng)) 320 else 219
        } else if (lng < 47.582981f) if (lat < 49.732527f) if (lng < 46.357081f) {
            if (poly[2341]!!.contains(lat, lng)) return 350
            if (poly[2342]!!.contains(lat, lng)) 373 else 320
        } else {
            if (poly[2343]!!.contains(lat, lng)) return 219
            if (poly[2344]!!.contains(lat, lng)) return 320
            if (poly[2345]!!.contains(lat, lng)) 373 else 265
        } else if (lng < 46.357081f) {
            if (poly[2346]!!.contains(lat, lng)) 373 else 360
        } else {
            if (poly[2347]!!.contains(lat, lng)) return 265
            if (poly[2348]!!.contains(lat, lng)) 360 else 373
        } else {
            if (poly[2349]!!.contains(lat, lng)) 360 else 265
        } else if (lat < 45.170128f) {
            if (poly[2350]!!.contains(lat, lng)) 273 else 216
        } else if (lat < 46.520131f) if (lng < 50.438264f) if (lat < 45.694299f) 216 else 219 else if (lng < 55.487919f) {
            if (poly[2351]!!.contains(lat, lng)) 219 else 216
        } else {
            if (poly[2352]!!.contains(lat, lng)) return 217
            if (poly[2353]!!.contains(lat, lng)) 219 else 216
        } else if (lng < 53.389445f) {
            if (poly[2354]!!.contains(lat, lng)) 265 else 219
        } else if (lat < 48.883870f) {
            if (poly[2355]!!.contains(lat, lng)) 219 else 217
        } else if (lng < 55.066777f) if (lat < 50.065739f) {
            if (poly[2356]!!.contains(lat, lng)) return 219
            if (poly[2357]!!.contains(lat, lng)) return 265
            if (poly[2358]!!.contains(lat, lng)) 265 else 217
        } else if (lng < 54.228111f) {
            if (poly[2359]!!.contains(lat, lng)) 293 else 265
        } else {
            if (poly[2360]!!.contains(lat, lng)) return 217
            if (poly[2361]!!.contains(lat, lng)) 265 else 293
        } else {
            if (poly[2362]!!.contains(lat, lng)) 293 else 217
        } else call34(lat, lng) else if (lat < 47.827727f) if (lng < 61.924863f) {
            if (poly[2363]!!.contains(lat, lng)) return 217
            if (poly[2364]!!.contains(lat, lng)) 273 else 271
        } else if (lng < 65.941044f) {
            if (poly[2365]!!.contains(lat, lng)) return 213
            if (poly[2366]!!.contains(lat, lng)) return 217
            if (poly[2367]!!.contains(lat, lng)) return 273
            if (poly[2368]!!.contains(lat, lng)) 273 else 271
        } else {
            if (poly[2369]!!.contains(lat, lng)) 271 else 213
        } else if (lng < 63.350667f) if (lat < 51.359587f) if (lng < 60.047388f) if (lat < 49.593657f) 217 else if (lng < 58.395748f) {
            if (poly[2370]!!.contains(lat, lng)) return 293
            if (poly[2371]!!.contains(lat, lng)) 293 else 217
        } else {
            if (poly[2372]!!.contains(lat, lng)) 293 else 217
        } else if (lat < 49.593657f) {
            if (poly[2373]!!.contains(lat, lng)) 270 else 217
        } else if (lng < 61.699027f) {
            if (poly[2374]!!.contains(lat, lng)) return 217
            if (poly[2375]!!.contains(lat, lng)) 270 else 293
        } else {
            if (poly[2376]!!.contains(lat, lng)) 217 else 270
        } else if (lng < 60.047388f) {
            if (poly[2377]!!.contains(lat, lng)) 270 else 293
        } else if (lat < 53.125516f) if (lng < 61.699027f) {
            if (poly[2378]!!.contains(lat, lng)) 270 else 293
        } else {
            if (poly[2379]!!.contains(lat, lng)) 293 else 270
        } else if (lng < 61.699027f) if (lat < 54.008481f) {
            if (poly[2380]!!.contains(lat, lng)) 270 else 293
        } else {
            if (poly[2381]!!.contains(lat, lng)) return 270
            if (poly[2382]!!.contains(lat, lng)) 270 else 293
        } else {
            if (poly[2383]!!.contains(lat, lng)) 270 else 293
        } else if (lat < 51.359587f) if (lng < 66.653946f) if (lat < 49.593657f) {
            if (poly[2384]!!.contains(lat, lng)) return 213
            if (poly[2385]!!.contains(lat, lng)) 217 else 270
        } else {
            if (poly[2386]!!.contains(lat, lng)) 213 else 270
        } else {
            if (poly[2387]!!.contains(lat, lng)) 270 else 213
        } else if (lng < 66.653946f) if (lat < 53.125516f) {
            if (poly[2388]!!.contains(lat, lng)) 270 else 213
        } else if (lng < 65.002307f) {
            if (poly[2389]!!.contains(lat, lng)) 293 else 270
        } else {
            if (poly[2390]!!.contains(lat, lng)) return 213
            if (poly[2391]!!.contains(lat, lng)) 293 else 270
        } else {
            if (poly[2392]!!.contains(lat, lng)) 293 else 213
        }
    }

    private fun call37(lat: Float, lng: Float): Int {
        return if (lat < 33.934308f) if (lng < 74.729730f) if (lat < 31.090648f) {
            if (poly[2393]!!.contains(lat, lng)) return 251
            if (poly[2394]!!.contains(lat, lng)) 251 else 248
        } else if (lng < 72.632080f) 248 else if (lat < 32.512478f) {
            if (poly[2395]!!.contains(lat, lng)) return 251
            if (poly[2396]!!.contains(lat, lng)) 251 else 248
        } else {
            if (poly[2397]!!.contains(lat, lng)) 251 else 248
        } else if (lat < 31.090648f) 251 else if (lng < 76.827381f) {
            if (poly[2398]!!.contains(lat, lng)) 248 else 251
        } else if (lat < 32.512478f) {
            if (poly[2399]!!.contains(lat, lng)) 276 else 251
        } else {
            if (poly[2400]!!.contains(lat, lng)) return 276
            if (poly[2401]!!.contains(lat, lng)) 276 else 251
        } else if (lng < 74.729730f) if (lat < 36.777969f) if (lng < 72.632080f) if (lat < 35.356138f) {
            if (poly[2402]!!.contains(lat, lng)) 246 else 248
        } else if (lng < 71.583255f) {
            if (poly[2403]!!.contains(lat, lng)) return 235
            if (poly[2404]!!.contains(lat, lng)) return 248
            if (poly[2405]!!.contains(lat, lng)) 248 else 246
        } else {
            if (poly[2406]!!.contains(lat, lng)) return 235
            if (poly[2407]!!.contains(lat, lng)) 248 else 246
        } else {
            if (poly[2408]!!.contains(lat, lng)) 251 else 248
        } else if (lng < 72.632080f) if (lat < 38.199799f) {
            if (poly[2409]!!.contains(lat, lng)) return 235
            if (poly[2410]!!.contains(lat, lng)) 248 else 246
        } else if (lng < 71.583255f) {
            if (poly[2411]!!.contains(lat, lng)) return 226
            if (poly[2412]!!.contains(lat, lng)) 246 else 235
        } else {
            if (poly[2413]!!.contains(lat, lng)) 235 else 226
        } else if (lat < 38.199799f) if (lng < 73.680905f) {
            if (poly[2414]!!.contains(lat, lng)) return 235
            if (poly[2415]!!.contains(lat, lng)) return 235
            if (poly[2416]!!.contains(lat, lng)) 248 else 246
        } else if (lat < 37.488884f) if (lng < 74.205318f) {
            if (poly[2417]!!.contains(lat, lng)) return 235
            if (poly[2418]!!.contains(lat, lng)) 248 else 246
        } else if (lat < 37.133426f) {
            if (poly[2419]!!.contains(lat, lng)) return 248
            if (poly[2420]!!.contains(lat, lng)) return 276
            if (poly[2421]!!.contains(lat, lng)) 287 else 246
        } else {
            if (poly[2422]!!.contains(lat, lng)) return 235
            if (poly[2423]!!.contains(lat, lng)) return 276
            if (poly[2424]!!.contains(lat, lng)) 287 else 246
        } else 235 else if (lng < 73.680905f) {
            if (poly[2425]!!.contains(lat, lng)) return 226
            if (poly[2426]!!.contains(lat, lng)) return 276
            if (poly[2427]!!.contains(lat, lng)) 287 else 235
        } else if (lat < 38.910714f) {
            if (poly[2428]!!.contains(lat, lng)) return 276
            if (poly[2429]!!.contains(lat, lng)) 287 else 235
        } else {
            if (poly[2430]!!.contains(lat, lng)) return 226
            if (poly[2431]!!.contains(lat, lng)) return 235
            if (poly[2432]!!.contains(lat, lng)) 287 else 276
        } else if (lat < 36.777969f) if (lng < 76.827381f) if (lat < 35.356138f) {
            if (poly[2433]!!.contains(lat, lng)) 251 else 248
        } else if (lng < 75.778556f) {
            if (poly[2434]!!.contains(lat, lng)) return 276
            if (poly[2435]!!.contains(lat, lng)) 287 else 248
        } else if (lat < 36.067053f) {
            if (poly[2436]!!.contains(lat, lng)) return 251
            if (poly[2437]!!.contains(lat, lng)) return 276
            if (poly[2438]!!.contains(lat, lng)) 287 else 248
        } else {
            if (poly[2439]!!.contains(lat, lng)) return 248
            if (poly[2440]!!.contains(lat, lng)) 287 else 276
        } else if (lat < 35.356138f) if (lng < 77.876206f) {
            if (poly[2441]!!.contains(lat, lng)) 248 else 251
        } else if (lat < 34.645223f) {
            if (poly[2442]!!.contains(lat, lng)) return 276
            if (poly[2443]!!.contains(lat, lng)) return 276
            if (poly[2444]!!.contains(lat, lng)) 287 else 251
        } else {
            if (poly[2445]!!.contains(lat, lng)) return 276
            if (poly[2446]!!.contains(lat, lng)) 287 else 251
        } else if (lng < 77.876206f) {
            if (poly[2447]!!.contains(lat, lng)) return 248
            if (poly[2448]!!.contains(lat, lng)) return 276
            if (poly[2449]!!.contains(lat, lng)) 287 else 251
        } else {
            if (poly[2450]!!.contains(lat, lng)) return 251
            if (poly[2451]!!.contains(lat, lng)) 287 else 276
        } else if (lng < 76.827381f) if (lat < 38.199799f) if (lng < 75.778556f) if (lat < 37.488884f) if (lng < 75.254143f) if (lat < 37.133426f) {
            if (poly[2452]!!.contains(lat, lng)) return 276
            if (poly[2453]!!.contains(lat, lng)) 287 else 248
        } else {
            if (poly[2454]!!.contains(lat, lng)) return 235
            if (poly[2455]!!.contains(lat, lng)) return 246
            if (poly[2456]!!.contains(lat, lng)) 287 else 276
        } else {
            if (poly[2457]!!.contains(lat, lng)) return 248
            if (poly[2458]!!.contains(lat, lng)) 287 else 276
        } else {
            if (poly[2459]!!.contains(lat, lng)) return 276
            if (poly[2460]!!.contains(lat, lng)) 287 else 235
        } else {
            if (poly[2461]!!.contains(lat, lng)) 287 else 276
        } else {
            if (poly[2462]!!.contains(lat, lng)) return 235
            if (poly[2463]!!.contains(lat, lng)) 287 else 276
        } else {
            if (poly[2464]!!.contains(lat, lng)) 287 else 276
        }
    }

    private fun call38(lat: Float, lng: Float): Int {
        return if (lng < 80.227684f) if (lat < 45.885615f) if (lng < 76.683710f) if (lat < 42.753622f) if (lng < 74.911723f) if (lat < 41.187625f) if (lng < 74.025729f) {
            if (poly[2465]!!.contains(lat, lng)) return 276
            if (poly[2466]!!.contains(lat, lng)) 287 else 226
        } else {
            if (poly[2467]!!.contains(lat, lng)) return 276
            if (poly[2468]!!.contains(lat, lng)) 287 else 226
        } else {
            if (poly[2469]!!.contains(lat, lng)) 213 else 226
        } else if (lat < 41.187625f) if (lng < 75.797716f) {
            if (poly[2470]!!.contains(lat, lng)) return 276
            if (poly[2471]!!.contains(lat, lng)) 287 else 226
        } else {
            if (poly[2472]!!.contains(lat, lng)) return 276
            if (poly[2473]!!.contains(lat, lng)) 287 else 226
        } else 226 else {
            if (poly[2474]!!.contains(lat, lng)) 226 else 213
        } else if (lat < 42.753622f) if (lng < 78.455697f) if (lat < 41.187625f) {
            if (poly[2475]!!.contains(lat, lng)) return 226
            if (poly[2476]!!.contains(lat, lng)) 287 else 276
        } else {
            if (poly[2477]!!.contains(lat, lng)) return 276
            if (poly[2478]!!.contains(lat, lng)) 287 else 226
        } else if (lat < 41.187625f) {
            if (poly[2479]!!.contains(lat, lng)) 287 else 276
        } else if (lng < 79.341690f) {
            if (poly[2480]!!.contains(lat, lng)) return 213
            if (poly[2481]!!.contains(lat, lng)) return 276
            if (poly[2482]!!.contains(lat, lng)) 287 else 226
        } else if (lat < 41.970624f) {
            if (poly[2483]!!.contains(lat, lng)) return 226
            if (poly[2484]!!.contains(lat, lng)) 287 else 276
        } else if (lng < 79.784687f) {
            if (poly[2485]!!.contains(lat, lng)) 213 else 226
        } else if (lat < 42.362123f) {
            if (poly[2486]!!.contains(lat, lng)) return 213
            if (poly[2487]!!.contains(lat, lng)) return 276
            if (poly[2488]!!.contains(lat, lng)) 287 else 226
        } else {
            if (poly[2489]!!.contains(lat, lng)) return 226
            if (poly[2490]!!.contains(lat, lng)) return 276
            if (poly[2491]!!.contains(lat, lng)) return 276
            if (poly[2492]!!.contains(lat, lng)) return 287
            if (poly[2493]!!.contains(lat, lng)) 287 else 213
        } else if (lng < 78.455697f) {
            if (poly[2494]!!.contains(lat, lng)) 226 else 213
        } else {
            if (poly[2495]!!.contains(lat, lng)) return 226
            if (poly[2496]!!.contains(lat, lng)) return 276
            if (poly[2497]!!.contains(lat, lng)) 287 else 213
        } else {
            if (poly[2498]!!.contains(lat, lng)) 224 else 213
        } else if (lat < 45.885615f) if (lng < 83.771658f) if (lat < 42.753622f) {
            if (poly[2499]!!.contains(lat, lng)) return 213
            if (poly[2500]!!.contains(lat, lng)) return 213
            if (poly[2501]!!.contains(lat, lng)) return 213
            if (poly[2502]!!.contains(lat, lng)) return 226
            if (poly[2503]!!.contains(lat, lng)) 287 else 276
        } else if (lng < 81.999671f) if (lat < 44.319618f) if (lng < 81.113677f) if (lat < 43.536620f) {
            if (poly[2504]!!.contains(lat, lng)) return 276
            if (poly[2505]!!.contains(lat, lng)) 287 else 213
        } else {
            if (poly[2506]!!.contains(lat, lng)) return 276
            if (poly[2507]!!.contains(lat, lng)) 287 else 213
        } else {
            if (poly[2508]!!.contains(lat, lng)) 287 else 276
        } else if (lng < 81.113677f) {
            if (poly[2509]!!.contains(lat, lng)) return 276
            if (poly[2510]!!.contains(lat, lng)) 287 else 213
        } else {
            if (poly[2511]!!.contains(lat, lng)) return 276
            if (poly[2512]!!.contains(lat, lng)) 287 else 213
        } else {
            if (poly[2513]!!.contains(lat, lng)) return 213
            if (poly[2514]!!.contains(lat, lng)) 287 else 276
        } else {
            if (poly[2515]!!.contains(lat, lng)) 287 else 276
        } else if (lng < 83.771658f) if (lat < 49.017607f) {
            if (poly[2516]!!.contains(lat, lng)) return 276
            if (poly[2517]!!.contains(lat, lng)) 287 else 213
        } else if (lng < 81.999671f) {
            if (poly[2518]!!.contains(lat, lng)) 224 else 213
        } else {
            if (poly[2519]!!.contains(lat, lng)) 224 else 213
        } else if (lat < 49.017607f) if (lng < 85.543645f) if (lat < 47.451611f) if (lng < 84.657652f) {
            if (poly[2520]!!.contains(lat, lng)) return 276
            if (poly[2521]!!.contains(lat, lng)) 287 else 213
        } else {
            if (poly[2522]!!.contains(lat, lng)) return 276
            if (poly[2523]!!.contains(lat, lng)) 287 else 213
        } else {
            if (poly[2524]!!.contains(lat, lng)) return 276
            if (poly[2525]!!.contains(lat, lng)) 287 else 213
        } else if (lat < 47.451611f) {
            if (poly[2526]!!.contains(lat, lng)) return 213
            if (poly[2527]!!.contains(lat, lng)) 287 else 276
        } else {
            if (poly[2528]!!.contains(lat, lng)) return 276
            if (poly[2529]!!.contains(lat, lng)) 287 else 213
        } else if (lng < 85.543645f) {
            if (poly[2530]!!.contains(lat, lng)) 224 else 213
        } else if (lat < 50.583604f) if (lng < 86.429638f) {
            if (poly[2531]!!.contains(lat, lng)) 224 else 213
        } else {
            if (poly[2532]!!.contains(lat, lng)) return 224
            if (poly[2533]!!.contains(lat, lng)) return 276
            if (poly[2534]!!.contains(lat, lng)) 287 else 213
        } else 224
    }

    private fun call39(lat: Float, lng: Float): Int {
        return if (lng < 98.940959f) if (lat < 40.765989f) {
            if (poly[2535]!!.contains(lat, lng)) 276 else 287
        } else if (lng < 93.128295f) if (lat < 46.457794f) if (lng < 90.221964f) {
            if (poly[2536]!!.contains(lat, lng)) 287 else 276
        } else if (lat < 43.611892f) {
            if (poly[2537]!!.contains(lat, lng)) 287 else 276
        } else if (lng < 91.675130f) {
            if (poly[2538]!!.contains(lat, lng)) return 241
            if (poly[2539]!!.contains(lat, lng)) 287 else 276
        } else {
            if (poly[2540]!!.contains(lat, lng)) return 276
            if (poly[2541]!!.contains(lat, lng)) 287 else 241
        } else if (lng < 90.221964f) if (lat < 49.303697f) if (lng < 88.768798f) if (lat < 47.880746f) {
            if (poly[2542]!!.contains(lat, lng)) 287 else 276
        } else if (lng < 88.042215f) if (lat < 48.592222f) {
            if (poly[2543]!!.contains(lat, lng)) return 241
            if (poly[2544]!!.contains(lat, lng)) 287 else 276
        } else if (lng < 87.678923f) {
            if (poly[2545]!!.contains(lat, lng)) return 224
            if (poly[2546]!!.contains(lat, lng)) 276 else 287
        } else {
            if (poly[2547]!!.contains(lat, lng)) return 224
            if (poly[2548]!!.contains(lat, lng)) return 276
            if (poly[2549]!!.contains(lat, lng)) 287 else 241
        } else {
            if (poly[2550]!!.contains(lat, lng)) return 224
            if (poly[2551]!!.contains(lat, lng)) return 276
            if (poly[2552]!!.contains(lat, lng)) return 276
            if (poly[2553]!!.contains(lat, lng)) return 287
            if (poly[2554]!!.contains(lat, lng)) 287 else 241
        } else {
            if (poly[2555]!!.contains(lat, lng)) return 241
            if (poly[2556]!!.contains(lat, lng)) 276 else 287
        } else if (lng < 88.768798f) {
            if (poly[2557]!!.contains(lat, lng)) return 241
            if (poly[2558]!!.contains(lat, lng)) 252 else 224
        } else if (lat < 50.726649f) if (lng < 89.495381f) {
            if (poly[2559]!!.contains(lat, lng)) return 241
            if (poly[2560]!!.contains(lat, lng)) 252 else 224
        } else {
            if (poly[2561]!!.contains(lat, lng)) return 241
            if (poly[2562]!!.contains(lat, lng)) 252 else 224
        } else {
            if (poly[2563]!!.contains(lat, lng)) 224 else 252
        } else if (lat < 49.303697f) {
            if (poly[2564]!!.contains(lat, lng)) return 276
            if (poly[2565]!!.contains(lat, lng)) 287 else 241
        } else {
            if (poly[2566]!!.contains(lat, lng)) 252 else 241
        } else if (lat < 46.457794f) if (lng < 96.034627f) if (lat < 43.611892f) {
            if (poly[2567]!!.contains(lat, lng)) return 241
            if (poly[2568]!!.contains(lat, lng)) 276 else 287
        } else {
            if (poly[2569]!!.contains(lat, lng)) return 276
            if (poly[2570]!!.contains(lat, lng)) 287 else 241
        } else {
            if (poly[2571]!!.contains(lat, lng)) return 276
            if (poly[2572]!!.contains(lat, lng)) return 286
            if (poly[2573]!!.contains(lat, lng)) return 287
            if (poly[2574]!!.contains(lat, lng)) 287 else 241
        } else if (lng < 96.034627f) {
            if (poly[2575]!!.contains(lat, lng)) 252 else 241
        } else if (lat < 49.303697f) {
            if (poly[2576]!!.contains(lat, lng)) return 286
            if (poly[2577]!!.contains(lat, lng)) 286 else 241
        } else if (lng < 97.487793f) {
            if (poly[2578]!!.contains(lat, lng)) return 252
            if (poly[2579]!!.contains(lat, lng)) 286 else 241
        } else {
            if (poly[2580]!!.contains(lat, lng)) 252 else 286
        } else if (lat < 49.113709f) if (lat < 39.248044f) 276 else if (lng < 107.076564f) {
            if (poly[2581]!!.contains(lat, lng)) return 241
            if (poly[2582]!!.contains(lat, lng)) 276 else 286
        } else if (lat < 44.180876f) {
            if (poly[2583]!!.contains(lat, lng)) 286 else 276
        } else if (lng < 111.144367f) 286 else if (lat < 46.647293f) if (lng < 113.178269f) {
            if (poly[2584]!!.contains(lat, lng)) return 229
            if (poly[2585]!!.contains(lat, lng)) 276 else 286
        } else {
            if (poly[2586]!!.contains(lat, lng)) 276 else 229
        } else {
            if (poly[2587]!!.contains(lat, lng)) 286 else 229
        } else if (lng < 107.076564f) if (lng < 103.008762f) if (lng < 100.974860f) {
            if (poly[2588]!!.contains(lat, lng)) 242 else 286
        } else if (lat < 50.631654f) {
            if (poly[2589]!!.contains(lat, lng)) 242 else 286
        } else {
            if (poly[2590]!!.contains(lat, lng)) 286 else 242
        } else {
            if (poly[2591]!!.contains(lat, lng)) 242 else 286
        } else if (lng < 111.144367f) if (lng < 109.110466f) if (lat < 50.631654f) if (lng < 108.093515f) {
            if (poly[2592]!!.contains(lat, lng)) return 242
            if (poly[2593]!!.contains(lat, lng)) 286 else 228
        } else {
            if (poly[2594]!!.contains(lat, lng)) return 242
            if (poly[2595]!!.contains(lat, lng)) 286 else 228
        } else {
            if (poly[2596]!!.contains(lat, lng)) 228 else 242
        } else {
            if (poly[2597]!!.contains(lat, lng)) return 242
            if (poly[2598]!!.contains(lat, lng)) 286 else 228
        } else {
            if (poly[2599]!!.contains(lat, lng)) return 229
            if (poly[2600]!!.contains(lat, lng)) return 242
            if (poly[2601]!!.contains(lat, lng)) 286 else 228
        }
    }

    private fun call40(lat: Float, lng: Float): Int {
        return if (lat < 57.237834f) if (lng < 71.677329f) if (lat < 54.668015f) if (lat < 54.184945f) if (lng < 71.296101f) {
            if (poly[2602]!!.contains(lat, lng)) 264 else 213
        } else {
            if (poly[2603]!!.contains(lat, lng)) 213 else 264
        } else {
            if (poly[2604]!!.contains(lat, lng)) 213 else 264
        } else if (lat < 56.765223f) {
            if (poly[2605]!!.contains(lat, lng)) 293 else 264
        } else {
            if (poly[2606]!!.contains(lat, lng)) 293 else 264
        } else if (lng < 85.115957f) if (lng < 78.396643f) if (lng < 75.036986f) if (lat < 54.693717f) if (lng < 73.357157f) if (lat < 53.421658f) 213 else if (lng < 72.517243f) {
            if (poly[2607]!!.contains(lat, lng)) 264 else 213
        } else {
            if (poly[2608]!!.contains(lat, lng)) return 264
            if (poly[2609]!!.contains(lat, lng)) 264 else 213
        } else {
            if (poly[2610]!!.contains(lat, lng)) 264 else 213
        } else 264 else if (lat < 54.693717f) if (lng < 76.716814f) {
            if (poly[2611]!!.contains(lat, lng)) return 213
            if (poly[2612]!!.contains(lat, lng)) 264 else 263
        } else {
            if (poly[2613]!!.contains(lat, lng)) return 213
            if (poly[2614]!!.contains(lat, lng)) return 213
            if (poly[2615]!!.contains(lat, lng)) 224 else 263
        } else if (lng < 76.716814f) if (lat < 55.965775f) {
            if (poly[2616]!!.contains(lat, lng)) return 264
            if (poly[2617]!!.contains(lat, lng)) 264 else 263
        } else {
            if (poly[2618]!!.contains(lat, lng)) return 264
            if (poly[2619]!!.contains(lat, lng)) 285 else 263
        } else {
            if (poly[2620]!!.contains(lat, lng)) 285 else 263
        } else if (lng < 81.756300f) if (lat < 54.693717f) if (lng < 80.076471f) {
            if (poly[2621]!!.contains(lat, lng)) return 213
            if (poly[2622]!!.contains(lat, lng)) 263 else 224
        } else {
            if (poly[2623]!!.contains(lat, lng)) return 263
            if (poly[2624]!!.contains(lat, lng)) return 263
            if (poly[2625]!!.contains(lat, lng)) 263 else 224
        } else {
            if (poly[2626]!!.contains(lat, lng)) 285 else 263
        } else if (lat < 54.693717f) if (lng < 83.436128f) {
            if (poly[2627]!!.contains(lat, lng)) 263 else 224
        } else {
            if (poly[2628]!!.contains(lat, lng)) return 224
            if (poly[2629]!!.contains(lat, lng)) 262 else 263
        } else if (lng < 83.436128f) {
            if (poly[2630]!!.contains(lat, lng)) 285 else 263
        } else if (lat < 55.965775f) if (lng < 84.276043f) {
            if (poly[2631]!!.contains(lat, lng)) 285 else 263
        } else {
            if (poly[2632]!!.contains(lat, lng)) 263 else 262
        } else {
            if (poly[2633]!!.contains(lat, lng)) return 262
            if (poly[2634]!!.contains(lat, lng)) 263 else 285
        } else if (lat < 55.866563f) if (lng < 87.259300f) {
            if (poly[2635]!!.contains(lat, lng)) 224 else 262
        } else if (lat < 54.008082f) if (lng < 88.330972f) {
            if (poly[2636]!!.contains(lat, lng)) 262 else 224
        } else if (lat < 53.078841f) {
            if (poly[2637]!!.contains(lat, lng)) return 224
            if (poly[2638]!!.contains(lat, lng)) 252 else 262
        } else {
            if (poly[2639]!!.contains(lat, lng)) 262 else 252
        } else {
            if (poly[2640]!!.contains(lat, lng)) 252 else 262
        } else if (lng < 87.259300f) {
            if (poly[2641]!!.contains(lat, lng)) 285 else 262
        } else if (lng < 88.330972f) {
            if (poly[2642]!!.contains(lat, lng)) 285 else 262
        } else {
            if (poly[2643]!!.contains(lat, lng)) return 262
            if (poly[2644]!!.contains(lat, lng)) 285 else 252
        } else if (lat < 73.721756f) if (lng < 80.335949f) if (lat < 65.479795f) if (lng < 75.802602f) {
            if (poly[2645]!!.contains(lat, lng)) return 285
            if (poly[2646]!!.contains(lat, lng)) 293 else 264
        } else if (lat < 61.358814f) if (lng < 78.069276f) {
            if (poly[2647]!!.contains(lat, lng)) return 264
            if (poly[2648]!!.contains(lat, lng)) 293 else 285
        } else {
            if (poly[2649]!!.contains(lat, lng)) 293 else 285
        } else 293 else if (lng < 75.802602f) 293 else if (lat < 69.600775f) {
            if (poly[2650]!!.contains(lat, lng)) 252 else 293
        } else if (lng < 78.069276f) {
            if (poly[2651]!!.contains(lat, lng)) 252 else 293
        } else if (lat < 71.661266f) if (lng < 79.202613f) {
            if (poly[2652]!!.contains(lat, lng)) return 252
            if (poly[2653]!!.contains(lat, lng)) return 252
            if (poly[2654]!!.contains(lat, lng)) 252 else 293
        } else {
            if (poly[2655]!!.contains(lat, lng)) return 293
            if (poly[2656]!!.contains(lat, lng)) return 293
            if (poly[2657]!!.contains(lat, lng)) 293 else 252
        } else {
            if (poly[2658]!!.contains(lat, lng)) 293 else 252
        } else if (lat < 65.479795f) if (lng < 84.869297f) if (lat < 61.358814f) {
            if (poly[2659]!!.contains(lat, lng)) return 252
            if (poly[2660]!!.contains(lat, lng)) 293 else 285
        } else {
            if (poly[2661]!!.contains(lat, lng)) return 252
            if (poly[2662]!!.contains(lat, lng)) 252 else 293
        } else if (lat < 61.358814f) {
            if (poly[2663]!!.contains(lat, lng)) return 285
            if (poly[2664]!!.contains(lat, lng)) 293 else 252
        } else if (lng < 87.135970f) if (lat < 63.419305f) {
            if (poly[2665]!!.contains(lat, lng)) return 293
            if (poly[2666]!!.contains(lat, lng)) 293 else 252
        } else {
            if (poly[2667]!!.contains(lat, lng)) 293 else 252
        } else 252 else if (lng < 84.869297f) if (lat < 69.600775f) if (lng < 82.602623f) if (lat < 67.540285f) {
            if (poly[2668]!!.contains(lat, lng)) return 252
            if (poly[2669]!!.contains(lat, lng)) return 252
            if (poly[2670]!!.contains(lat, lng)) 252 else 293
        } else if (lng < 81.469286f) {
            if (poly[2671]!!.contains(lat, lng)) 293 else 252
        } else {
            if (poly[2672]!!.contains(lat, lng)) return 293
            if (poly[2673]!!.contains(lat, lng)) return 293
            if (poly[2674]!!.contains(lat, lng)) 293 else 252
        } else {
            if (poly[2675]!!.contains(lat, lng)) return 293
            if (poly[2676]!!.contains(lat, lng)) 293 else 252
        } else {
            if (poly[2677]!!.contains(lat, lng)) return 293
            if (poly[2678]!!.contains(lat, lng)) 293 else 252
        } else 252 else 252
    }

    private fun call41(lat: Float, lng: Float): Int {
        return if (lng < 102.307407f) if (lat < 63.521722f) if (lng < 95.855025f) {
            if (poly[2679]!!.contains(lat, lng)) 242 else 252
        } else if (lat < 57.835661f) if (lng < 99.081216f) if (lat < 54.992631f) if (lng < 97.468121f) {
            if (poly[2680]!!.contains(lat, lng)) 242 else 252
        } else {
            if (poly[2681]!!.contains(lat, lng)) 252 else 242
        } else if (lng < 97.468121f) {
            if (poly[2682]!!.contains(lat, lng)) return 242
            if (poly[2683]!!.contains(lat, lng)) 242 else 252
        } else {
            if (poly[2684]!!.contains(lat, lng)) return 252
            if (poly[2685]!!.contains(lat, lng)) 252 else 242
        } else {
            if (poly[2686]!!.contains(lat, lng)) return 252
            if (poly[2687]!!.contains(lat, lng)) return 252
            if (poly[2688]!!.contains(lat, lng)) 252 else 242
        } else {
            if (poly[2689]!!.contains(lat, lng)) 252 else 242
        } else 252 else if (lat < 63.521722f) if (lng < 108.759788f) if (lat < 57.835661f) 242 else if (lng < 105.533598f) if (lat < 60.678692f) if (lng < 103.920502f) {
            if (poly[2690]!!.contains(lat, lng)) 242 else 252
        } else if (lat < 59.257177f) {
            if (poly[2691]!!.contains(lat, lng)) 252 else 242
        } else {
            if (poly[2692]!!.contains(lat, lng)) 252 else 242
        } else {
            if (poly[2693]!!.contains(lat, lng)) 242 else 252
        } else {
            if (poly[2694]!!.contains(lat, lng)) 252 else 242
        } else if (lat < 57.835661f) if (lng < 111.985979f) {
            if (poly[2695]!!.contains(lat, lng)) 228 else 242
        } else if (lat < 54.992631f) if (lng < 113.599075f) {
            if (poly[2696]!!.contains(lat, lng)) 242 else 228
        } else if (lat < 53.571115f) {
            if (poly[2697]!!.contains(lat, lng)) 242 else 228
        } else {
            if (poly[2698]!!.contains(lat, lng)) 228 else 242
        } else 242 else if (lng < 111.985979f) if (lat < 60.678692f) if (lng < 110.372884f) {
            if (poly[2699]!!.contains(lat, lng)) 291 else 242
        } else {
            if (poly[2700]!!.contains(lat, lng)) 291 else 242
        } else if (lng < 110.372884f) if (lat < 62.100207f) {
            if (poly[2701]!!.contains(lat, lng)) return 291
            if (poly[2702]!!.contains(lat, lng)) 291 else 242
        } else {
            if (poly[2703]!!.contains(lat, lng)) 291 else 242
        } else {
            if (poly[2704]!!.contains(lat, lng)) 242 else 291
        } else if (lat < 60.678692f) if (lng < 113.599075f) {
            if (poly[2705]!!.contains(lat, lng)) 291 else 242
        } else {
            if (poly[2706]!!.contains(lat, lng)) return 291
            if (poly[2707]!!.contains(lat, lng)) 291 else 242
        } else 291 else if (lng < 108.759788f) if (lat < 69.207784f) if (lng < 105.533598f) {
            if (poly[2708]!!.contains(lat, lng)) 291 else 252
        } else if (lat < 66.364753f) if (lng < 107.146693f) if (lat < 64.943238f) {
            if (poly[2709]!!.contains(lat, lng)) return 242
            if (poly[2710]!!.contains(lat, lng)) 291 else 252
        } else {
            if (poly[2711]!!.contains(lat, lng)) 291 else 252
        } else if (lat < 64.943238f) if (lng < 107.953241f) {
            if (poly[2712]!!.contains(lat, lng)) return 242
            if (poly[2713]!!.contains(lat, lng)) 291 else 252
        } else {
            if (poly[2714]!!.contains(lat, lng)) return 252
            if (poly[2715]!!.contains(lat, lng)) return 291
            if (poly[2716]!!.contains(lat, lng)) return 291
            if (poly[2717]!!.contains(lat, lng)) 291 else 242
        } else 291 else {
            if (poly[2718]!!.contains(lat, lng)) 291 else 252
        } else {
            if (poly[2719]!!.contains(lat, lng)) 291 else 252
        } else if (lat < 69.207784f) {
            if (poly[2720]!!.contains(lat, lng)) return 242
            if (poly[2721]!!.contains(lat, lng)) return 242
            if (poly[2722]!!.contains(lat, lng)) 242 else 291
        } else if (lng < 111.985979f) if (lat < 72.050814f) {
            if (poly[2723]!!.contains(lat, lng)) 291 else 252
        } else if (lng < 110.372884f) {
            if (poly[2724]!!.contains(lat, lng)) return 291
            if (poly[2725]!!.contains(lat, lng)) 291 else 252
        } else if (lat < 73.472330f) {
            if (poly[2726]!!.contains(lat, lng)) 291 else 252
        } else {
            if (poly[2727]!!.contains(lat, lng)) 291 else 252
        } else {
            if (poly[2728]!!.contains(lat, lng)) return 252
            if (poly[2729]!!.contains(lat, lng)) 252 else 291
        }
    }

    private fun call42(lat: Float, lng: Float): Int {
        return if (lat < 52.149600f) if (lng < 87.315632f) if (lat < 39.621629f) if (lng < 70.534430f) if (lat < 34.047710f) if (lat < 33.798521f) {
            if (poly[2730]!!.contains(lat, lng)) 246 else 248
        } else {
            if (poly[2731]!!.contains(lat, lng)) 248 else 246
        } else if (lat < 38.208711f) {
            if (poly[2732]!!.contains(lat, lng)) 235 else 246
        } else {
            if (poly[2733]!!.contains(lat, lng)) 226 else 235
        } else if (lng < 78.925031f) call37(lat, lng) else if (lat < 33.934308f) if (lng < 83.120331f) if (lat < 31.090648f) if (lng < 81.022681f) if (lat < 29.668817f) {
            if (poly[2734]!!.contains(lat, lng)) 251 else 249
        } else {
            if (poly[2735]!!.contains(lat, lng)) return 249
            if (poly[2736]!!.contains(lat, lng)) 276 else 251
        } else if (lat < 29.668817f) {
            if (poly[2737]!!.contains(lat, lng)) return 251
            if (poly[2738]!!.contains(lat, lng)) return 276
            if (poly[2739]!!.contains(lat, lng)) 276 else 249
        } else if (lng < 82.071506f) {
            if (poly[2740]!!.contains(lat, lng)) return 251
            if (poly[2741]!!.contains(lat, lng)) 276 else 249
        } else {
            if (poly[2742]!!.contains(lat, lng)) return 249
            if (poly[2743]!!.contains(lat, lng)) 249 else 276
        } else {
            if (poly[2744]!!.contains(lat, lng)) return 251
            if (poly[2745]!!.contains(lat, lng)) 251 else 276
        } else if (lat < 31.090648f) if (lng < 85.217982f) if (lat < 29.668817f) if (lng < 84.169157f) {
            if (poly[2746]!!.contains(lat, lng)) return 276
            if (poly[2747]!!.contains(lat, lng)) 276 else 249
        } else {
            if (poly[2748]!!.contains(lat, lng)) 276 else 249
        } else 276 else {
            if (poly[2749]!!.contains(lat, lng)) 249 else 276
        } else 276 else {
            if (poly[2750]!!.contains(lat, lng)) return 251
            if (poly[2751]!!.contains(lat, lng)) 276 else 287
        } else if (lng < 73.139736f) if (lat < 40.785252f) if (lng < 70.983890f) if (lat < 39.891552f) {
            if (poly[2752]!!.contains(lat, lng)) 226 else 235
        } else if (lng < 70.470557f) {
            if (poly[2753]!!.contains(lat, lng)) return 226
            if (poly[2754]!!.contains(lat, lng)) return 280
            if (poly[2755]!!.contains(lat, lng)) 280 else 235
        } else {
            if (poly[2756]!!.contains(lat, lng)) return 226
            if (poly[2757]!!.contains(lat, lng)) return 226
            if (poly[2758]!!.contains(lat, lng)) 280 else 235
        } else if (lng < 71.226069f) if (lat < 40.185134f) {
            if (poly[2759]!!.contains(lat, lng)) 226 else 280
        } else if (lat < 40.267114f) {
            if (poly[2760]!!.contains(lat, lng)) 280 else 226
        } else {
            if (poly[2761]!!.contains(lat, lng)) 280 else 226
        } else if (lat < 40.008003f) {
            if (poly[2762]!!.contains(lat, lng)) 226 else 280
        } else if (lng < 72.182902f) {
            if (poly[2763]!!.contains(lat, lng)) 226 else 280
        } else {
            if (poly[2764]!!.contains(lat, lng)) 280 else 226
        } else if (lat < 46.467426f) if (lat < 43.626339f) if (lng < 71.548480f) if (lat < 42.205796f) if (lng < 70.752853f) if (lat < 41.495524f) {
            if (poly[2765]!!.contains(lat, lng)) return 226
            if (poly[2766]!!.contains(lat, lng)) return 226
            if (poly[2767]!!.contains(lat, lng)) return 235
            if (poly[2768]!!.contains(lat, lng)) 235 else 280
        } else {
            if (poly[2769]!!.contains(lat, lng)) return 213
            if (poly[2770]!!.contains(lat, lng)) 226 else 280
        } else {
            if (poly[2771]!!.contains(lat, lng)) return 213
            if (poly[2772]!!.contains(lat, lng)) return 213
            if (poly[2773]!!.contains(lat, lng)) 226 else 280
        } else {
            if (poly[2774]!!.contains(lat, lng)) return 226
            if (poly[2775]!!.contains(lat, lng)) return 280
            if (poly[2776]!!.contains(lat, lng)) 280 else 213
        } else if (lat < 42.205796f) {
            if (poly[2777]!!.contains(lat, lng)) 280 else 226
        } else {
            if (poly[2778]!!.contains(lat, lng)) 226 else 213
        } else 213 else 213 else call38(lat, lng) else if (lat < 29.382378f) if (lng < 97.274264f) if (lng < 92.294948f) 276 else if (lng < 94.784606f) {
            if (poly[2779]!!.contains(lat, lng)) 251 else 276
        } else if (lng < 96.029435f) {
            if (poly[2780]!!.contains(lat, lng)) 276 else 251
        } else {
            if (poly[2781]!!.contains(lat, lng)) 251 else 276
        } else {
            if (poly[2782]!!.contains(lat, lng)) 292 else 276
        } else call39(lat, lng) else if (lat < 74.893845f) if (lng < 71.269255f) if (lat < 56.046981f) if (lat < 54.609784f) {
            if (poly[2783]!!.contains(lat, lng)) 264 else 213
        } else {
            if (poly[2784]!!.contains(lat, lng)) return 213
            if (poly[2785]!!.contains(lat, lng)) 293 else 264
        } else if (lat < 56.691085f) if (lat < 56.361732f) if (lng < 70.948417f) if (lat < 56.304836f) {
            if (poly[2786]!!.contains(lat, lng)) 264 else 293
        } else {
            if (poly[2787]!!.contains(lat, lng)) 264 else 293
        } else if (lng < 71.092014f) {
            if (poly[2788]!!.contains(lat, lng)) 293 else 264
        } else {
            if (poly[2789]!!.contains(lat, lng)) 293 else 264
        } else {
            if (poly[2790]!!.contains(lat, lng)) return 293
            if (poly[2791]!!.contains(lat, lng)) 293 else 264
        } else {
            if (poly[2792]!!.contains(lat, lng)) 264 else 293
        } else if (lng < 89.402644f) call40(lat, lng) else call41(lat, lng) else 252
    }

    private fun call43(lat: Float, lng: Float): Int {
        return if (lng < 79.395921f) if (lng < 60.054577f) if (lat < 19.000000f) if (lng < 51.617770f) if (lat < 14.411063f) if (lng < 40.259453f) {
            if (poly[2793]!!.contains(lat, lng)) 5 else 3
        } else if (lng < 45.938612f) if (lat < 10.435032f) {
            if (poly[2794]!!.contains(lat, lng)) 41 else 3
        } else if (lng < 43.099032f) if (lat < 12.423047f) {
            if (poly[2795]!!.contains(lat, lng)) return 3
            if (poly[2796]!!.contains(lat, lng)) return 5
            if (poly[2797]!!.contains(lat, lng)) 41 else 19
        } else {
            if (poly[2798]!!.contains(lat, lng)) return 3
            if (poly[2799]!!.contains(lat, lng)) return 19
            if (poly[2800]!!.contains(lat, lng)) return 19
            if (poly[2801]!!.contains(lat, lng)) 212 else 5
        } else {
            if (poly[2802]!!.contains(lat, lng)) return 5
            if (poly[2803]!!.contains(lat, lng)) return 19
            if (poly[2804]!!.contains(lat, lng)) 41 else 212
        } else {
            if (poly[2805]!!.contains(lat, lng)) return 3
            if (poly[2806]!!.contains(lat, lng)) 212 else 41
        } else if (lng < 45.922675f) if (lng < 43.075128f) {
            if (poly[2807]!!.contains(lat, lng)) return 5
            if (poly[2808]!!.contains(lat, lng)) 272 else 212
        } else if (lat < 16.705531f) {
            if (poly[2809]!!.contains(lat, lng)) 272 else 212
        } else {
            if (poly[2810]!!.contains(lat, lng)) 212 else 272
        } else {
            if (poly[2811]!!.contains(lat, lng)) 272 else 212
        } else if (lat < 12.912992f) 212 else if (lng < 52.000000f) {
            if (poly[2812]!!.contains(lat, lng)) 272 else 212
        } else {
            if (poly[2813]!!.contains(lat, lng)) 212 else 260
        } else if (lng < 51.873474f) if (lat < 26.687244f) if (lng < 46.050527f) 272 else if (lat < 22.843622f) 272 else if (lng < 48.962001f) 272 else if (lat < 24.765433f) {
            if (poly[2814]!!.contains(lat, lng)) return 234
            if (poly[2815]!!.contains(lat, lng)) 269 else 272
        } else {
            if (poly[2816]!!.contains(lat, lng)) return 221
            if (poly[2817]!!.contains(lat, lng)) 272 else 269
        } else if (lng < 50.475558f) {
            if (poly[2818]!!.contains(lat, lng)) 282 else 272
        } else 282 else if (lat < 25.008764f) if (lng < 55.964026f) if (lat < 22.004382f) {
            if (poly[2819]!!.contains(lat, lng)) 272 else 260
        } else {
            if (poly[2820]!!.contains(lat, lng)) return 260
            if (poly[2821]!!.contains(lat, lng)) return 260
            if (poly[2822]!!.contains(lat, lng)) return 269
            if (poly[2823]!!.contains(lat, lng)) return 269
            if (poly[2824]!!.contains(lat, lng)) 272 else 234
        } else {
            if (poly[2825]!!.contains(lat, lng)) return 234
            if (poly[2826]!!.contains(lat, lng)) 234 else 260
        } else if (lng < 53.252289f) if (lat < 25.361546f) if (lng < 52.455827f) {
            if (poly[2827]!!.contains(lat, lng)) 234 else 269
        } else 234 else if (lat < 26.221460f) 269 else 282 else if (lng < 54.461109f) if (lat < 25.580043f) 234 else 282 else if (lng < 57.257843f) if (lat < 26.627876f) if (lng < 55.859476f) {
            if (poly[2828]!!.contains(lat, lng)) 282 else 234
        } else {
            if (poly[2829]!!.contains(lat, lng)) return 234
            if (poly[2830]!!.contains(lat, lng)) return 234
            if (poly[2831]!!.contains(lat, lng)) return 282
            if (poly[2832]!!.contains(lat, lng)) 282 else 260
        } else {
            if (poly[2833]!!.contains(lat, lng)) 260 else 282
        } else 282 else if (lat < 12.113083f) if (lat < 7.310625f) 385 else 251 else if (lat < 12.577255f) 251 else if (lng < 63.333270f) if (lat < 26.544310f) {
            if (poly[2834]!!.contains(lat, lng)) 282 else 248
        } else {
            if (poly[2835]!!.contains(lat, lng)) 282 else 248
        } else if (lng < 71.364596f) if (lng < 67.348933f) 248 else if (lat < 24.345118f) {
            if (poly[2836]!!.contains(lat, lng)) return 248
            if (poly[2837]!!.contains(lat, lng)) 248 else 251
        } else if (lng < 69.356764f) 248 else if (lat < 26.296053f) {
            if (poly[2838]!!.contains(lat, lng)) return 251
            if (poly[2839]!!.contains(lat, lng)) 251 else 248
        } else {
            if (poly[2840]!!.contains(lat, lng)) 251 else 248
        } else {
            if (poly[2841]!!.contains(lat, lng)) 248 else 251
        } else if (lng < 109.670985f) if (lng < 94.478373f) if (lat < 14.389697f) if (lng < 82.081014f) if (lat < 9.534601f) {
            if (poly[2842]!!.contains(lat, lng)) 251 else 230
        } else {
            if (poly[2843]!!.contains(lat, lng)) 230 else 251
        } else if (lat < 13.661110f) 251 else {
            if (poly[2844]!!.contains(lat, lng)) 251 else 292
        } else call29(lat, lng) else call31(lat, lng) else if (lat < 10.229958f) if (lng < 112.663898f) 239 else 276 else if (lat < 11.398160f) if (lat < 11.249496f) {
            if (poly[2845]!!.contains(lat, lng)) 276 else 259
        } else 239 else if (lng < 112.952690f) 276 else if (lng < 113.630139f) {
            if (poly[2846]!!.contains(lat, lng)) 276 else 256
        } else {
            if (poly[2847]!!.contains(lat, lng)) 276 else 240
        }
    }

    private fun call44(lat: Float, lng: Float): Int {
        return if (lat < 53.560815f) if (lng < 123.271244f) {
            if (poly[2848]!!.contains(lat, lng)) 291 else 276
        } else if (lat < 43.008964f) if (lng < 128.951950f) if (lng < 126.111597f) if (lat < 40.816221f) {
            if (poly[2849]!!.contains(lat, lng)) 276 else 268
        } else {
            if (poly[2850]!!.contains(lat, lng)) 268 else 276
        } else if (lat < 40.816221f) 268 else if (lng < 127.531774f) {
            if (poly[2851]!!.contains(lat, lng)) 276 else 268
        } else {
            if (poly[2852]!!.contains(lat, lng)) 276 else 268
        } else if (lng < 131.792303f) if (lng < 130.372127f) if (lat < 41.597391f) 268 else if (lng < 129.662038f) {
            if (poly[2853]!!.contains(lat, lng)) 276 else 268
        } else {
            if (poly[2854]!!.contains(lat, lng)) 276 else 268
        } else {
            if (poly[2855]!!.contains(lat, lng)) return 268
            if (poly[2856]!!.contains(lat, lng)) 290 else 276
        } else 290 else if (lng < 130.145337f) if (lat < 48.284889f) 276 else if (lng < 126.708291f) if (lat < 50.922852f) 276 else if (lng < 124.989767f) {
            if (poly[2857]!!.contains(lat, lng)) 291 else 276
        } else {
            if (poly[2858]!!.contains(lat, lng)) return 291
            if (poly[2859]!!.contains(lat, lng)) 291 else 276
        } else if (lat < 50.922852f) if (lng < 128.426814f) {
            if (poly[2860]!!.contains(lat, lng)) 291 else 276
        } else {
            if (poly[2861]!!.contains(lat, lng)) 291 else 276
        } else {
            if (poly[2862]!!.contains(lat, lng)) return 276
            if (poly[2863]!!.contains(lat, lng)) 276 else 291
        } else if (lat < 48.284889f) if (lng < 133.582384f) if (lat < 45.646927f) if (lng < 131.863861f) {
            if (poly[2864]!!.contains(lat, lng)) 290 else 276
        } else {
            if (poly[2865]!!.contains(lat, lng)) 276 else 290
        } else if (lng < 131.863861f) {
            if (poly[2866]!!.contains(lat, lng)) 276 else 290
        } else {
            if (poly[2867]!!.contains(lat, lng)) 276 else 290
        } else if (lat < 45.646927f) 290 else if (lng < 135.300908f) if (lat < 46.965908f) {
            if (poly[2868]!!.contains(lat, lng)) 276 else 290
        } else {
            if (poly[2869]!!.contains(lat, lng)) 276 else 290
        } else 290 else if (lng < 133.582384f) if (lat < 50.922852f) if (lng < 131.863861f) if (lat < 49.603871f) {
            if (poly[2870]!!.contains(lat, lng)) return 276
            if (poly[2871]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2872]!!.contains(lat, lng)) 291 else 290
        } else 290 else if (lng < 131.863861f) {
            if (poly[2873]!!.contains(lat, lng)) return 290
            if (poly[2874]!!.contains(lat, lng)) 290 else 291
        } else if (lat < 52.241834f) {
            if (poly[2875]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2876]!!.contains(lat, lng)) 291 else 290
        } else if (lat < 50.922852f) {
            if (poly[2877]!!.contains(lat, lng)) 276 else 290
        } else if (lng < 135.300908f) if (lat < 52.241834f) 290 else if (lng < 134.441646f) {
            if (poly[2878]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2879]!!.contains(lat, lng)) 291 else 290
        } else 290 else if (lat < 53.619653f) if (lng < 134.441683f) if (lng < 131.491725f) if (lat < 53.600920f) {
            if (poly[2880]!!.contains(lat, lng)) 290 else 291
        } else {
            if (poly[2881]!!.contains(lat, lng)) 290 else 291
        } else {
            if (poly[2882]!!.contains(lat, lng)) 291 else 290
        } else if (lng < 134.521271f) {
            if (poly[2883]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2884]!!.contains(lat, lng)) 290 else 291
        } else if (lat < 62.894403f) if (lng < 129.582626f) 291 else if (lat < 58.257028f) if (lng < 133.301028f) if (lat < 55.938340f) if (lng < 131.441827f) {
            if (poly[2885]!!.contains(lat, lng)) return 290
            if (poly[2886]!!.contains(lat, lng)) return 290
            if (poly[2887]!!.contains(lat, lng)) 290 else 291
        } else if (lat < 54.778997f) {
            if (poly[2888]!!.contains(lat, lng)) return 291
            if (poly[2889]!!.contains(lat, lng)) return 291
            if (poly[2890]!!.contains(lat, lng)) return 291
            if (poly[2891]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2892]!!.contains(lat, lng)) 291 else 290
        } else if (lng < 131.441827f) {
            if (poly[2893]!!.contains(lat, lng)) return 290
            if (poly[2894]!!.contains(lat, lng)) return 290
            if (poly[2895]!!.contains(lat, lng)) 290 else 291
        } else if (lat < 57.097684f) {
            if (poly[2896]!!.contains(lat, lng)) return 291
            if (poly[2897]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2898]!!.contains(lat, lng)) 290 else 291
        } else 290 else if (lng < 133.301028f) if (lat < 60.575716f) if (lng < 131.441827f) 291 else if (lat < 59.416372f) if (lng < 132.371428f) {
            if (poly[2899]!!.contains(lat, lng)) return 250
            if (poly[2900]!!.contains(lat, lng)) return 290
            if (poly[2901]!!.contains(lat, lng)) 290 else 291
        } else {
            if (poly[2902]!!.contains(lat, lng)) return 250
            if (poly[2903]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2904]!!.contains(lat, lng)) 291 else 250
        } else {
            if (poly[2905]!!.contains(lat, lng)) 250 else 291
        } else if (lat < 60.575716f) {
            if (poly[2906]!!.contains(lat, lng)) 290 else 250
        } else if (lng < 135.160230f) {
            if (poly[2907]!!.contains(lat, lng)) 291 else 250
        } else {
            if (poly[2908]!!.contains(lat, lng)) 291 else 250
        } else if (lng < 129.582626f) 291 else if (lat < 67.531778f) if (lng < 133.301028f) if (lat < 65.213090f) if (lng < 131.441827f) 291 else if (lat < 64.053747f) {
            if (poly[2909]!!.contains(lat, lng)) 250 else 291
        } else {
            if (poly[2910]!!.contains(lat, lng)) return 250
            if (poly[2911]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2912]!!.contains(lat, lng)) return 250
            if (poly[2913]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2914]!!.contains(lat, lng)) return 290
            if (poly[2915]!!.contains(lat, lng)) 291 else 250
        } else if (lng < 133.301028f) if (lat < 69.850465f) {
            if (poly[2916]!!.contains(lat, lng)) 291 else 290
        } else {
            if (poly[2917]!!.contains(lat, lng)) 290 else 291
        } else {
            if (poly[2918]!!.contains(lat, lng)) return 291
            if (poly[2919]!!.contains(lat, lng)) return 291
            if (poly[2920]!!.contains(lat, lng)) 291 else 290
        }
    }

    private fun call45(lat: Float, lng: Float): Int {
        return if (lng < 137.019431f) if (lat < 72.169153f) if (lng < 122.145820f) if (lat < 55.396315f) if (lat < 47.009896f) if (lat < 42.816687f) 276 else if (lng < 118.678995f) {
            if (poly[2921]!!.contains(lat, lng)) 276 else 229
        } else {
            if (poly[2922]!!.contains(lat, lng)) 229 else 276
        } else if (lat < 51.203105f) if (lng < 118.678995f) if (lat < 49.106501f) {
            if (poly[2923]!!.contains(lat, lng)) 276 else 229
        } else {
            if (poly[2924]!!.contains(lat, lng)) return 229
            if (poly[2925]!!.contains(lat, lng)) 276 else 228
        } else if (lat < 49.106501f) {
            if (poly[2926]!!.contains(lat, lng)) 229 else 276
        } else {
            if (poly[2927]!!.contains(lat, lng)) 228 else 276
        } else if (lng < 118.678995f) if (lat < 53.299710f) 228 else if (lng < 116.945583f) if (lat < 54.348013f) {
            if (poly[2928]!!.contains(lat, lng)) 242 else 228
        } else {
            if (poly[2929]!!.contains(lat, lng)) 242 else 228
        } else 228 else if (lat < 53.299710f) if (lng < 120.412408f) {
            if (poly[2930]!!.contains(lat, lng)) return 276
            if (poly[2931]!!.contains(lat, lng)) 276 else 228
        } else {
            if (poly[2932]!!.contains(lat, lng)) return 228
            if (poly[2933]!!.contains(lat, lng)) return 228
            if (poly[2934]!!.contains(lat, lng)) 228 else 276
        } else if (lng < 120.412408f) 228 else if (lat < 54.348013f) {
            if (poly[2935]!!.contains(lat, lng)) return 276
            if (poly[2936]!!.contains(lat, lng)) return 276
            if (poly[2937]!!.contains(lat, lng)) 291 else 228
        } else {
            if (poly[2938]!!.contains(lat, lng)) 291 else 228
        } else if (lat < 63.782734f) if (lat < 59.589524f) if (lng < 118.678995f) if (lat < 57.492920f) if (lng < 116.945583f) {
            if (poly[2939]!!.contains(lat, lng)) 242 else 228
        } else {
            if (poly[2940]!!.contains(lat, lng)) 242 else 228
        } else if (lng < 116.945583f) 242 else if (lat < 58.541222f) {
            if (poly[2941]!!.contains(lat, lng)) 242 else 228
        } else {
            if (poly[2942]!!.contains(lat, lng)) return 291
            if (poly[2943]!!.contains(lat, lng)) return 291
            if (poly[2944]!!.contains(lat, lng)) 291 else 242
        } else if (lat < 57.492920f) if (lng < 120.412408f) if (lat < 56.444617f) {
            if (poly[2945]!!.contains(lat, lng)) return 291
            if (poly[2946]!!.contains(lat, lng)) 291 else 228
        } else {
            if (poly[2947]!!.contains(lat, lng)) 228 else 291
        } else {
            if (poly[2948]!!.contains(lat, lng)) return 228
            if (poly[2949]!!.contains(lat, lng)) 228 else 291
        } else if (lng < 120.412408f) if (lat < 58.541222f) {
            if (poly[2950]!!.contains(lat, lng)) return 228
            if (poly[2951]!!.contains(lat, lng)) 242 else 291
        } else {
            if (poly[2952]!!.contains(lat, lng)) return 242
            if (poly[2953]!!.contains(lat, lng)) 242 else 291
        } else 291 else {
            if (poly[2954]!!.contains(lat, lng)) return 242
            if (poly[2955]!!.contains(lat, lng)) 242 else 291
        } else 291 else call44(lat, lng) else if (lng < 130.330840f) 291 else 290 else if (lat < 55.394243f) if (lat < 41.606056f) 284 else if (lng < 145.050145f) if (lat < 48.500150f) if (lng < 141.034788f) {
            if (poly[2956]!!.contains(lat, lng)) return 274
            if (poly[2957]!!.contains(lat, lng)) return 284
            if (poly[2958]!!.contains(lat, lng)) 284 else 290
        } else {
            if (poly[2959]!!.contains(lat, lng)) 284 else 274
        } else if (lng < 141.034788f) 290 else {
            if (poly[2960]!!.contains(lat, lng)) 290 else 274
        } else {
            if (poly[2961]!!.contains(lat, lng)) 284 else 288
        } else if (lat < 56.593646f) 290 else if (lat < 72.761219f) if (lat < 65.575894f) if (lng < 141.011174f) if (lat < 61.084770f) {
            if (poly[2962]!!.contains(lat, lng)) 250 else 290
        } else if (lat < 63.330332f) if (lng < 139.015303f) {
            if (poly[2963]!!.contains(lat, lng)) 290 else 250
        } else if (lat < 62.207551f) {
            if (poly[2964]!!.contains(lat, lng)) 250 else 290
        } else {
            if (poly[2965]!!.contains(lat, lng)) return 288
            if (poly[2966]!!.contains(lat, lng)) 290 else 250
        } else if (lng < 139.015303f) 250 else if (lat < 64.453113f) {
            if (poly[2967]!!.contains(lat, lng)) 288 else 250
        } else {
            if (poly[2968]!!.contains(lat, lng)) return 250
            if (poly[2969]!!.contains(lat, lng)) 278 else 288
        } else if (lng < 146.109588f) if (lat < 61.832713f) {
            if (poly[2970]!!.contains(lat, lng)) return 257
            if (poly[2971]!!.contains(lat, lng)) return 288
            if (poly[2972]!!.contains(lat, lng)) 288 else 290
        } else if (lng < 143.560381f) if (lat < 63.704303f) {
            if (poly[2973]!!.contains(lat, lng)) 290 else 288
        } else {
            if (poly[2974]!!.contains(lat, lng)) 278 else 288
        } else if (lat < 63.704303f) if (lng < 144.834984f) {
            if (poly[2975]!!.contains(lat, lng)) return 257
            if (poly[2976]!!.contains(lat, lng)) return 290
            if (poly[2977]!!.contains(lat, lng)) 290 else 288
        } else if (lat < 62.768508f) if (lng < 145.472286f) {
            if (poly[2978]!!.contains(lat, lng)) return 288
            if (poly[2979]!!.contains(lat, lng)) 290 else 257
        } else {
            if (poly[2980]!!.contains(lat, lng)) return 288
            if (poly[2981]!!.contains(lat, lng)) 290 else 257
        } else {
            if (poly[2982]!!.contains(lat, lng)) 257 else 288
        } else {
            if (poly[2983]!!.contains(lat, lng)) return 257
            if (poly[2984]!!.contains(lat, lng)) 278 else 288
        } else if (lat < 62.117818f) if (lng < 148.658794f) if (lat < 60.532987f) {
            if (poly[2985]!!.contains(lat, lng)) 290 else 257
        } else {
            if (poly[2986]!!.contains(lat, lng)) 290 else 257
        } else 257 else if (lng < 148.658794f) {
            if (poly[2987]!!.contains(lat, lng)) return 278
            if (poly[2988]!!.contains(lat, lng)) 288 else 257
        } else {
            if (poly[2989]!!.contains(lat, lng)) 278 else 257
        } else if (lng < 144.113716f) if (lat < 69.168556f) if (lng < 140.566574f) if (lat < 67.372225f) if (lng < 138.793002f) {
            if (poly[2990]!!.contains(lat, lng)) return 250
            if (poly[2991]!!.contains(lat, lng)) 278 else 290
        } else if (lat < 66.474060f) {
            if (poly[2992]!!.contains(lat, lng)) return 250
            if (poly[2993]!!.contains(lat, lng)) 278 else 290
        } else {
            if (poly[2994]!!.contains(lat, lng)) return 290
            if (poly[2995]!!.contains(lat, lng)) 290 else 278
        } else {
            if (poly[2996]!!.contains(lat, lng)) 278 else 290
        } else {
            if (poly[2997]!!.contains(lat, lng)) 290 else 278
        } else if (lng < 140.566574f) 290 else if (lat < 70.964888f) {
            if (poly[2998]!!.contains(lat, lng)) 290 else 278
        } else {
            if (poly[2999]!!.contains(lat, lng)) 278 else 290
        } else {
            if (poly[3000]!!.contains(lat, lng)) 290 else 278
        } else 290
    }

    private fun call46(lat: Float, lng: Float): Int {
        return if (lat < 21.321781f) if (lng < 147.443035f) if (lng < 143.281718f) if (lng < 136.322421f) if (lng < 126.807256f) if (lng < 116.028859f) if (lat < 10.238836f) 259 else 276 else if (lat < 7.511199f) if (lng < 117.166690f) {
            if (poly[3001]!!.contains(lat, lng)) 259 else 254
        } else {
            if (poly[3002]!!.contains(lat, lng)) 254 else 259
        } else if (lng < 116.978217f) if (lat < 14.517725f) 259 else 279 else {
            if (poly[3003]!!.contains(lat, lng)) 276 else 259
        } else if (lng < 134.771474f) 416 else 284 else 393 else if (lat < 13.857141f) if (lat < 9.427387f) 393 else 403 else 421 else if (lng < 167.976848f) if (lng < 152.946370f) 393 else if (lng < 162.595471f) if (lng < 159.969720f) 418 else 408 else if (lng < 166.231718f) 408 else if (lat < 9.602000f) if (lng < 166.477771f) 408 else if (lat < 8.399960f) 408 else {
            if (poly[3004]!!.contains(lat, lng)) 408 else 407
        } else if (lat < 15.377747f) 408 else 425 else 408 else if (lat < 38.623477f) if (lng < 132.146781f) if (lng < 123.391367f) if (lat < 25.829900f) if (lng < 122.297000f) if (lng < 118.546111f) if (lat < 24.207778f) {
            if (poly[3005]!!.contains(lat, lng)) 279 else 276
        } else {
            if (poly[3006]!!.contains(lat, lng)) 276 else 279
        } else {
            if (poly[3007]!!.contains(lat, lng)) 276 else 279
        } else 284 else if (lng < 120.076944f) if (lat < 26.037778f) {
            if (poly[3008]!!.contains(lat, lng)) 276 else 279
        } else {
            if (poly[3009]!!.contains(lat, lng)) 276 else 279
        } else if (lng < 120.289722f) {
            if (poly[3010]!!.contains(lat, lng)) 276 else 279
        } else {
            if (poly[3011]!!.contains(lat, lng)) 279 else 276
        } else if (lat < 32.448242f) 284 else if (lng < 129.832649f) if (lat < 34.891740f) {
            if (poly[3012]!!.contains(lat, lng)) return 284
            if (poly[3013]!!.contains(lat, lng)) 284 else 275
        } else if (lng < 128.374371f) {
            if (poly[3014]!!.contains(lat, lng)) 268 else 275
        } else {
            if (poly[3015]!!.contains(lat, lng)) 268 else 275
        } else if (lat < 35.229229f) 284 else 275 else 284 else if (lng < 151.208001f) call45(lat, lng) else if (lat < 55.565445f) if (lng < 168.445805f) if (lng < 156.831768f) if (lng < 152.619038f) {
            if (poly[3016]!!.contains(lat, lng)) 278 else 288
        } else {
            if (poly[3017]!!.contains(lat, lng)) 247 else 278
        } else 247 else 53 else if (lat < 71.770077f) if (lng < 174.518872f) if (lng < 162.863436f) if (lat < 63.667761f) if (lng < 157.035719f) {
            if (poly[3018]!!.contains(lat, lng)) 247 else 257
        } else if (lat < 59.616603f) 247 else if (lng < 159.949578f) 257 else if (lat < 61.642182f) {
            if (poly[3019]!!.contains(lat, lng)) 257 else 247
        } else if (lng < 161.406507f) 257 else if (lat < 62.654972f) {
            if (poly[3020]!!.contains(lat, lng)) 257 else 247
        } else {
            if (poly[3021]!!.contains(lat, lng)) 247 else 257
        } else if (lng < 157.035719f) if (lat < 67.718919f) if (lng < 154.121860f) {
            if (poly[3022]!!.contains(lat, lng)) 278 else 257
        } else {
            if (poly[3023]!!.contains(lat, lng)) 257 else 278
        } else 278 else if (lat < 67.471376f) if (lng < 159.949578f) if (lat < 65.569569f) {
            if (poly[3024]!!.contains(lat, lng)) 215 else 257
        } else if (lng < 158.492648f) {
            if (poly[3025]!!.contains(lat, lng)) return 215
            if (poly[3026]!!.contains(lat, lng)) return 215
            if (poly[3027]!!.contains(lat, lng)) return 257
            if (poly[3028]!!.contains(lat, lng)) 257 else 278
        } else {
            if (poly[3029]!!.contains(lat, lng)) return 257
            if (poly[3030]!!.contains(lat, lng)) return 278
            if (poly[3031]!!.contains(lat, lng)) return 278
            if (poly[3032]!!.contains(lat, lng)) 278 else 215
        } else {
            if (poly[3033]!!.contains(lat, lng)) return 215
            if (poly[3034]!!.contains(lat, lng)) return 247
            if (poly[3035]!!.contains(lat, lng)) 247 else 257
        } else if (lng < 159.949578f) {
            if (poly[3036]!!.contains(lat, lng)) 215 else 278
        } else {
            if (poly[3037]!!.contains(lat, lng)) 215 else 278
        } else if (lat < 63.303423f) if (lng < 168.691154f) {
            if (poly[3038]!!.contains(lat, lng)) 215 else 247
        } else if (lng < 171.605013f) if (lat < 61.516254f) 247 else if (lng < 170.148084f) {
            if (poly[3039]!!.contains(lat, lng)) return 215
            if (poly[3040]!!.contains(lat, lng)) 215 else 247
        } else {
            if (poly[3041]!!.contains(lat, lng)) return 247
            if (poly[3042]!!.contains(lat, lng)) 247 else 215
        } else if (lng < 173.061943f) {
            if (poly[3043]!!.contains(lat, lng)) 215 else 247
        } else {
            if (poly[3044]!!.contains(lat, lng)) 215 else 247
        } else if (lng < 168.691154f) if (lat < 67.050994f) if (lng < 165.777295f) if (lat < 65.177208f) if (lng < 164.320366f) {
            if (poly[3045]!!.contains(lat, lng)) return 215
            if (poly[3046]!!.contains(lat, lng)) return 257
            if (poly[3047]!!.contains(lat, lng)) return 257
            if (poly[3048]!!.contains(lat, lng)) 257 else 247
        } else {
            if (poly[3049]!!.contains(lat, lng)) 247 else 215
        } else 215 else {
            if (poly[3050]!!.contains(lat, lng)) 247 else 215
        } else {
            if (poly[3051]!!.contains(lat, lng)) 278 else 215
        } else {
            if (poly[3052]!!.contains(lat, lng)) 247 else 215
        } else 215 else 290
    }

    private var poly = initPolyArray()
    fun initPolyArray(): Array<TzPolygon?> {
        poly = arrayOfNulls(3053)
        Initializer1.init()
        Initializer2.init()
        Initializer3.init()
        Initializer4.init()
        Initializer5.init()
        Initializer6.init()
        Initializer7.init()
        Initializer8.init()
        Initializer9.init()
        Initializer10.init()
        Initializer11.init()
        Initializer12.init()
        Initializer13.init()
        Initializer14.init()
        Initializer15.init()
        Initializer16.init()
        Initializer17.init()
        Initializer18.init()
        Initializer19.init()
        Initializer20.init()
        Initializer21.init()
        Initializer22.init()
        Initializer23.init()
        Initializer24.init()
        Initializer25.init()
        Initializer26.init()
        Initializer27.init()
        Initializer28.init()
        Initializer29.init()
        Initializer30.init()
        Initializer31.init()
        return poly
    }

    class TzPolygon internal constructor(vararg var pts: Float) {
        fun contains(testy: Float, testx: Float): Boolean {
            var inside = false
            val n = pts.size
            var yj = pts[n - 2]
            var xj = pts[n - 1]
            var i = 0
            while (i < n) {
                val yi = pts[i++]
                val xi = pts[i++]
                if (yi > testy != yj > testy && testx < (xj - xi) * (testy - yi) / (yj - yi) + xi - 0.0001f) inside = !inside
                xj = xi
                yj = yi
            }
            return inside
        }
    }

    private object Initializer1 {
        fun init() {
            poly[0] = TzPolygon(-66.000000f, -74.790449f, -86.000000f, -74.790449f, -86.000000f, -80.000000f, -66.000000f, -80.000000f)
            poly[1] = TzPolygon(
                -48.582229f, -76.021890f, -48.582229f, -74.972849f, -48.738531f, -75.261755f, -48.720811f, -75.356684f, -48.784858f, -75.570161f,
                -48.788603f, -76.033525f
            )
            poly[2] = TzPolygon(-48.631255f, -74.790449f, -48.620484f, -74.906588f, -48.582229f, -74.972849f, -48.582229f, -74.790449f)
            poly[3] = TzPolygon(
                -4.463281f, -79.713051f, -4.492013f, -79.812846f, -4.413311f, -79.870644f, -4.386225f, -79.918504f, -4.398133f, -79.952250f,
                -4.380940f, -79.991687f, -4.310753f, -80.061277f, -4.285451f, -80.135403f, -4.304381f, -80.156057f, -4.293735f, -80.176870f,
                -4.334799f, -80.185641f, -4.340057f, -80.206549f, -4.350423f, -80.195138f, -4.353266f, -80.219057f, -4.411501f, -80.263507f,
                -4.406661f, -80.282523f, -4.465321f, -80.329256f, -4.486128f, -80.388354f, -4.448243f, -80.449079f, -4.367830f, -80.445962f,
                -4.199935f, -80.306395f, -4.220630f, -80.353907f, -4.197227f, -80.368469f, -4.218131f, -80.410353f, -4.196347f, -80.432743f,
                -4.209630f, -80.450183f, -4.121701f, -80.446824f, -4.127627f, -80.467175f, -4.054915f, -80.481935f, -3.997205f, -80.445923f,
                -3.980779f, -80.398050f, -4.017149f, -80.300771f, -4.008033f, -80.272693f, -3.948370f, -80.234984f, -3.956656f, -80.216493f,
                -3.895305f, -80.126404f, -3.870365f, -80.159502f, -3.802971f, -80.160109f, -3.775000f, -80.192845f, -3.756035f, -80.192045f,
                -3.756035f, -79.713051f
            )
            poly[4] = TzPolygon(
                -4.463281f, -79.713051f, -3.756035f, -79.713051f, -3.756035f, -78.405503f, -3.782391f, -78.409367f, -3.827533f, -78.465873f,
                -3.933821f, -78.488826f, -3.937264f, -78.524505f, -3.991963f, -78.565713f, -4.045100f, -78.567689f, -4.061588f, -78.537225f,
                -4.134865f, -78.581154f, -4.195549f, -78.577281f, -4.226094f, -78.608955f, -4.257924f, -78.598544f, -4.332513f, -78.652273f,
                -4.415164f, -78.634094f, -4.425148f, -78.600263f, -4.530081f, -78.661123f, -4.584883f, -78.655819f, -4.623949f, -78.706040f,
                -4.638181f, -78.805147f, -4.666990f, -78.855937f, -4.721660f, -78.891204f, -4.765025f, -78.890487f, -4.780080f, -78.914861f,
                -4.808531f, -78.891006f, -4.851854f, -78.915138f, -4.897899f, -78.892858f, -4.894209f, -78.972616f, -5.015931f, -79.015405f,
                -4.969755f, -79.075886f, -4.966255f, -79.266950f, -4.898674f, -79.306087f, -4.880440f, -79.351995f, -4.837345f, -79.365552f,
                -4.832450f, -79.395264f, -4.794079f, -79.421263f, -4.627291f, -79.487973f, -4.530312f, -79.487787f, -4.515554f, -79.562108f,
                -4.439105f, -79.629079f
            )
            poly[5] = TzPolygon(
                -3.756035f, -84.520219f, -3.392125f, -84.439430f, -3.392255f, -80.306572f, -3.438116f, -80.221080f, -3.485750f, -80.245823f,
                -3.500634f, -80.215877f, -3.574856f, -80.218529f, -3.601287f, -80.190584f, -3.756035f, -80.192598f
            )
            poly[6] = TzPolygon(
                -3.756035f, -78.405503f, -3.735388f, -78.402476f, -3.693202f, -78.423437f, -3.677180f, -78.393217f, -3.560102f, -78.391188f,
                -3.529699f, -78.364930f, -3.427103f, -78.341385f, -3.367933f, -78.349831f, -3.395347f, -78.313688f, -3.398582f, -78.246726f,
                -3.502763f, -78.231455f, -3.500079f, -78.187079f, -3.462695f, -78.146753f, -3.362668f, -78.197809f, -3.278806f, -78.108674f,
                -3.216360f, -78.091812f, -3.227392f, -78.064909f, -3.190982f, -78.036072f, -3.190622f, -78.010772f, -3.158505f, -78.011297f,
                -3.069962f, -77.948023f, -3.000373f, -77.843934f, -2.591136f, -76.632708f, -2.124938f, -76.044356f, -1.549618f, -75.584994f,
                -1.562957f, -75.559159f, -1.143227f, -75.442469f, -1.143227f, -74.790449f, -3.756035f, -74.790449f
            )
            poly[7] = TzPolygon(
                0.362697f, -77.222892f, 0.363221f, -77.287580f, 0.400756f, -77.370810f, 0.387642f, -77.389058f, 0.438737f, -77.430783f,
                0.401243f, -77.526461f, 0.530696f, -77.521218f, 0.605000f, -77.480821f, 0.655921f, -77.479623f, 0.650276f, -77.559835f,
                0.705188f, -77.666112f, 0.737207f, -77.675385f, 0.741574f, -77.697898f, 0.814530f, -77.664002f, 0.840051f, -77.694756f,
                0.841134f, -77.774507f, 0.802178f, -77.842696f, 0.823435f, -77.960655f, 0.856020f, -77.988569f, 0.896853f, -78.087861f,
                0.932248f, -78.111768f, 0.925229f, -78.158653f, 0.946954f, -78.199205f, 0.997163f, -78.202313f, 1.055852f, -78.281830f,
                1.099505f, -78.251070f, 1.111425f, -78.282216f, 1.191146f, -78.310583f, 1.160018f, -78.417561f, 1.139925f, -78.429633f,
                1.189810f, -78.432084f, 1.187404f, -78.515771f, 1.212827f, -78.514394f, 1.250518f, -78.552504f, 1.248514f, -78.619176f,
                1.319855f, -78.663472f, 1.469581f, -78.868686f, 1.469581f, -77.222892f
            )
            poly[8] = TzPolygon(
                -1.143227f, -75.442469f, -0.933777f, -75.384239f, -0.984452f, -75.313749f, -0.971293f, -75.192504f, -0.933832f, -75.233515f,
                -0.869167f, -75.221241f, -0.834452f, -75.252397f, -0.800810f, -75.241754f, -0.787322f, -75.268450f, -0.763563f, -75.253256f,
                -0.731465f, -75.276087f, -0.695247f, -75.249136f, -0.664658f, -75.274243f, -0.628358f, -75.223306f, -0.601047f, -75.240701f,
                -0.550304f, -75.227940f, -0.518237f, -75.247103f, -0.530454f, -75.268558f, -0.501426f, -75.270691f, -0.494676f, -75.312973f,
                -0.490025f, -75.314318f, -0.490025f, -74.790449f, -1.143227f, -74.790449f
            )
            poly[9] = TzPolygon(
                0.163177f, -75.899058f, 0.163177f, -74.790449f, -0.193865f, -74.790449f, -0.188798f, -74.793490f, -0.243279f, -74.883279f,
                -0.202360f, -74.912032f, -0.225712f, -74.927919f, -0.154980f, -74.972685f, -0.148687f, -75.011932f, -0.081799f, -75.077451f,
                -0.044719f, -75.162138f, -0.049238f, -75.211292f, -0.125137f, -75.273418f, -0.086488f, -75.428461f, -0.018885f, -75.530051f,
                -0.026579f, -75.574527f, 0.014277f, -75.581909f, 0.047608f, -75.632203f, 0.031271f, -75.652118f, 0.050840f, -75.806614f,
                0.132488f, -75.854585f, 0.118397f, -75.878275f, 0.138809f, -75.881988f, 0.139542f, -75.905475f, 0.162248f, -75.897766f
            )
            poly[10] = TzPolygon(
                -0.490025f, -75.314318f, -0.452706f, -75.325107f, -0.463605f, -75.349219f, -0.434213f, -75.388171f, -0.186747f, -75.535764f,
                -0.190039f, -75.602184f, -0.113675f, -75.615531f, -0.131836f, -75.568956f, -0.114357f, -75.516197f, -0.169952f, -75.406389f,
                -0.146061f, -75.364741f, -0.163719f, -75.353155f, -0.160093f, -75.312890f, -0.126345f, -75.259923f, -0.039282f, -75.192752f,
                -0.081799f, -75.077451f, -0.148687f, -75.011932f, -0.154980f, -74.972685f, -0.225712f, -74.927919f, -0.202360f, -74.912032f,
                -0.243279f, -74.883279f, -0.188798f, -74.793490f, -0.193865f, -74.790449f, -0.490025f, -74.790449f
            )
            poly[11] = TzPolygon(
                0.362697f, -77.222892f, 0.362635f, -77.215207f, 0.389524f, -77.166031f, 0.372330f, -77.113308f, 0.284301f, -77.076109f,
                0.277374f, -77.027441f, 0.294349f, -77.006691f, 0.266003f, -76.985718f, 0.276764f, -76.933267f, 0.246030f, -76.907590f,
                0.238961f, -76.845635f, 0.264371f, -76.797537f, 0.248242f, -76.756071f, 0.263500f, -76.767363f, 0.288619f, -76.732950f,
                0.268980f, -76.712534f, 0.270672f, -76.655712f, 0.251075f, -76.653151f, 0.261912f, -76.625590f, 0.218660f, -76.586342f,
                0.258652f, -76.532835f, 0.236406f, -76.504040f, 0.239446f, -76.446771f, 0.257735f, -76.434586f, 0.234402f, -76.427007f,
                0.240654f, -76.412699f, 0.379616f, -76.411361f, 0.382987f, -76.339841f, 0.433886f, -76.314210f, 0.421223f, -76.296878f,
                0.437080f, -76.278335f, 0.376830f, -76.226437f, 0.388252f, -76.158492f, 0.371158f, -76.132942f, 0.315884f, -76.113372f,
                0.335968f, -76.067882f, 0.296487f, -76.003681f, 0.256318f, -75.982395f, 0.247925f, -76.005430f, 0.238294f, -75.959221f,
                0.203104f, -75.954586f, 0.163177f, -75.899058f, 0.163177f, -77.222892f
            )
            poly[12] = TzPolygon(
                11.948729f, -86.810568f, 11.948729f, -83.615384f, 11.614625f, -83.545675f, 11.505393f, -83.624088f, 11.460968f, -83.697600f,
                11.391315f, -83.718428f, 11.362488f, -83.769886f, 11.283199f, -83.769886f, 11.068048f, -83.695149f, 10.997920f, -83.628370f,
                10.928172f, -83.669225f, 10.939851f, -83.698032f, 10.818222f, -83.660670f, 10.787861f, -83.694237f, 10.770588f, -83.789630f,
                10.717579f, -83.862686f, 10.707657f, -83.931193f, 10.791619f, -84.021017f, 10.759754f, -84.070279f, 10.764361f, -84.125135f,
                10.787002f, -84.136952f, 10.781758f, -84.202708f, 10.815617f, -84.237621f, 10.840680f, -84.214727f, 10.873430f, -84.225262f,
                10.918032f, -84.322876f, 10.995846f, -84.358676f, 10.955404f, -84.420252f, 10.960891f, -84.450192f, 11.051070f, -84.574811f,
                11.038395f, -84.606084f, 11.084402f, -84.680546f, 10.943439f, -84.910233f, 11.126204f, -85.357171f, 11.128836f, -85.423656f,
                11.168113f, -85.523283f, 11.210044f, -85.560395f, 11.219568f, -85.609900f, 11.069014f, -85.706119f, 11.075878f, -85.897878f,
                11.683930f, -86.626954f, 11.923883f, -86.799320f
            )
            poly[13] = TzPolygon(
                7.420856f, -82.506021f, 7.935534f, -82.945565f, 8.051847f, -82.890467f, 8.176042f, -82.902863f, 8.210353f, -82.935811f,
                8.272782f, -82.941755f, 8.289329f, -82.974950f, 8.271259f, -82.989611f, 8.333426f, -83.051724f, 8.372535f, -82.984046f,
                8.435004f, -82.930922f, 8.439673f, -82.868383f, 8.480288f, -82.839579f, 8.635995f, -82.830006f, 8.765126f, -82.919159f,
                8.773740f, -82.885445f, 8.817389f, -82.862470f, 8.829270f, -82.884344f, 8.852720f, -82.860890f, 8.878409f, -82.773262f,
                8.922259f, -82.711897f, 8.985499f, -82.741726f, 9.003611f, -82.801389f, 9.087904f, -82.887118f, 9.078469f, -82.935930f,
                9.473125f, -82.936078f, 9.501413f, -82.842580f, 9.566924f, -82.884793f, 9.621591f, -82.854201f, 9.588903f, -82.743867f,
                9.494122f, -82.671230f, 9.511394f, -82.654801f, 9.493644f, -82.639056f, 9.504265f, -82.605838f, 9.559461f, -82.599976f,
                9.541496f, -82.553144f, 9.571984f, -82.565013f, 9.653892f, -82.506021f
            )
            poly[14] = TzPolygon(
                7.779632f, -78.641949f, 7.779632f, -77.347444f, 7.765696f, -77.342224f, 7.772445f, -77.399046f, 7.725306f, -77.398005f,
                7.658417f, -77.440411f, 7.662741f, -77.465686f, 7.567106f, -77.491171f, 7.582727f, -77.516615f, 7.507785f, -77.564858f,
                7.541663f, -77.612279f, 7.651469f, -77.645202f, 7.700040f, -77.728579f, 7.613535f, -77.748587f, 7.506937f, -77.701464f,
                7.461479f, -77.754389f, 7.472481f, -77.818185f, 7.228372f, -77.889065f, 7.050936f, -78.036406f, 7.404444f, -78.370364f
            )
            poly[15] = TzPolygon(
                7.779632f, -78.641949f, 7.788317f, -78.648235f, 9.802818f, -78.648235f, 9.796949f, -78.571137f, 9.550708f, -78.211930f,
                9.381695f, -77.846530f, 9.122927f, -77.524482f, 8.810513f, -77.324431f, 8.641568f, -77.364481f, 8.645401f, -77.408923f,
                8.588352f, -77.393845f, 8.554959f, -77.444862f, 8.509577f, -77.457435f, 8.472170f, -77.447701f, 8.475002f, -77.411968f,
                8.402126f, -77.358884f, 8.297812f, -77.350241f, 8.266749f, -77.329596f, 8.272291f, -77.301273f, 8.253016f, -77.284217f,
                8.209045f, -77.279740f, 8.175348f, -77.246796f, 8.156526f, -77.258195f, 8.135652f, -77.227087f, 8.037238f, -77.219039f,
                8.025575f, -77.235168f, 7.954198f, -77.139378f, 7.959057f, -77.178952f, 7.929365f, -77.153308f, 7.933343f, -77.177377f,
                7.917464f, -77.178741f, 7.893640f, -77.334815f, 7.830457f, -77.366481f, 7.779632f, -77.347444f
            )
            poly[16] = TzPolygon(
                -9.887332f, 40.227580f, -10.151458f, 40.556614f, -10.318695f, 40.658407f, -10.414722f, 40.492778f, -10.565456f, 40.352060f,
                -10.596228f, 40.233184f, -10.603183f, 40.227580f
            )
            poly[17] = TzPolygon(
                -12.379027f, 45.079938f, -12.410517f, 45.203578f, -12.480122f, 45.314879f, -12.591196f, 45.434785f, -12.663742f, 45.482985f,
                -12.782931f, 45.507035f, -13.072467f, 45.436904f, -13.150354f, 45.395022f, -13.241990f, 45.266931f, -13.273255f, 45.136061f,
                -13.237377f, 44.975470f, -13.110506f, 44.823538f, -12.919092f, 44.749889f, -12.760359f, 44.770136f, -12.661548f, 44.743668f,
                -12.577477f, 44.760477f, -12.496259f, 44.821940f, -12.396000f, 44.990042f
            )
            poly[18] = TzPolygon(
                1.448202f, 40.227580f, 1.448202f, 40.990761f, -0.833975f, 40.993376f, -1.598574f, 41.558912f, -1.662078f, 41.559365f,
                -1.803197f, 41.718166f, -1.912243f, 41.650687f, -2.252429f, 41.345545f, -2.763425f, 40.751201f, -3.085740f, 40.418741f,
                -3.369973f, 40.335936f, -3.562595f, 40.227580f
            )
            poly[19] = TzPolygon(
                1.448202f, 40.990761f, 2.828298f, 40.989180f, 3.141237f, 41.312053f, 4.016664f, 41.943017f, 4.055481f, 41.946277f,
                4.179113f, 42.087372f, 4.202464f, 42.525584f, 4.260387f, 42.702992f, 4.266755f, 42.824904f, 4.380478f, 42.951970f,
                4.559042f, 43.034761f, 4.626329f, 43.115314f, 4.794544f, 43.434687f, 4.902107f, 43.809025f, 4.950439f, 44.153985f,
                4.930188f, 44.770743f, 1.466525f, 44.770743f, 1.448202f, 44.746692f
            )
            poly[20] = TzPolygon(
                4.055009f, 40.227580f, 4.104848f, 40.387772f, 4.245001f, 40.717448f, 4.284943f, 40.759583f, 4.246260f, 40.844100f,
                4.212840f, 40.882380f, 4.154620f, 40.904160f, 4.132070f, 40.965080f, 3.942580f, 41.169266f, 3.958885f, 41.235302f,
                3.938760f, 41.326310f, 3.962760f, 41.391250f, 3.944940f, 41.430190f, 3.954630f, 41.509770f, 3.982140f, 41.545160f,
                3.966667f, 41.566898f, 3.983294f, 41.627705f, 3.959925f, 41.674412f, 3.992460f, 41.720593f, 3.982106f, 41.791788f,
                3.958645f, 41.796766f, 3.946486f, 41.833158f, 3.982684f, 41.906750f, 3.141237f, 41.312053f, 2.828298f, 40.989180f,
                1.448202f, 40.990761f, 1.448202f, 40.227580f
            )
            poly[21] = TzPolygon(
                6.459000f, 46.438637f, 5.956573f, 45.845200f, 5.536382f, 45.410930f, 4.923383f, 44.978011f, 4.927753f, 44.770743f,
                6.459000f, 44.770743f
            )
            poly[22] = TzPolygon(
                -9.403320f, 141.647501f, -9.409858f, 141.592780f, -9.391659f, 141.480826f, -9.351343f, 141.394594f, -9.425916f, 141.241107f,
                -9.426205f, 141.075589f, -9.386877f, 140.998300f, -9.304719f, 140.915152f, -9.135556f, 141.019444f, -6.892357f, 141.020035f,
                -6.904320f, 140.991514f, -6.889404f, 140.966846f, -6.910453f, 140.955612f, -6.891885f, 140.940378f, -6.857220f, 140.953987f,
                -6.872289f, 140.917147f, -6.849062f, 140.900264f, -6.814838f, 140.916903f, -6.792055f, 140.870037f, -6.751125f, 140.899477f,
                -6.719801f, 140.846202f, -6.621837f, 140.877066f, -6.610606f, 140.841655f, -6.605671f, 140.890850f, -6.573283f, 140.911744f,
                -6.561471f, 140.891027f, -6.560800f, 140.937194f, -6.500474f, 140.921753f, -6.487509f, 140.961667f, -6.452098f, 140.955223f,
                -6.467034f, 140.925173f, -6.445165f, 140.938942f, -6.422390f, 140.917346f, -6.434850f, 140.952162f, -6.412401f, 140.942045f,
                -6.390252f, 140.982301f, -6.382644f, 140.941958f, -6.365823f, 140.977049f, -6.325355f, 140.959981f, -6.322308f, 140.999973f,
                -2.387415f, 141.000000f, -2.475376f, 141.366527f, -2.612818f, 141.647501f
            )
            poly[23] = TzPolygon(
                -9.187956f, 142.216109f, -9.266242f, 142.345755f, -9.320820f, 142.329236f, -9.347593f, 142.274239f, -9.317351f, 142.096032f,
                -9.260461f, 142.059440f, -9.212404f, 142.108052f
            )
            poly[24] = TzPolygon(
                -9.484383f, 142.526835f, -9.466246f, 142.490176f, -9.409206f, 142.471923f, -9.366124f, 142.495602f, -9.374335f, 142.558892f,
                -9.322311f, 142.806531f, -9.378369f, 142.851886f, -9.453762f, 142.821507f, -9.482153f, 142.784947f, -9.459837f, 142.585351f,
                -9.484383f, 142.536451f
            )
            poly[25] = TzPolygon(-9.484383f, 143.248626f, -9.474107f, 143.253530f, -9.459675f, 143.297032f, -9.484383f, 143.338933f)
            poly[26] = TzPolygon(
                -6.107149f, 154.622311f, -6.086762f, 154.603872f, -5.931626f, 154.533882f, -5.892219f, 154.450641f, -5.824350f, 154.390926f,
                -5.722738f, 154.366089f, -5.608977f, 154.404508f, -5.531492f, 154.398887f, -5.301336f, 154.333958f, -5.085948f, 153.021059f,
                -5.100781f, 153.369546f, -2.983921f, 154.622311f
            )
            poly[27] = TzPolygon(
                -6.377546f, 154.865967f, -6.377546f, 156.153225f, -6.444858f, 156.173819f, -6.550000f, 156.035833f, -6.658333f, 156.039722f,
                -6.847222f, 155.923056f, -6.925833f, 155.693611f, -6.925833f, 155.593889f, -7.097516f, 155.336184f, -7.017480f, 155.297466f,
                -6.653692f, 155.002257f
            )
            poly[28] = TzPolygon(
                54.891446f, 53.543209f, 54.978258f, 53.475110f, 55.024998f, 53.372300f, 55.021895f, 53.318393f, 55.044701f, 53.317278f,
                55.040976f, 53.276384f, 55.070675f, 53.294045f, 55.102723f, 53.258799f, 55.109103f, 53.164626f, 55.165582f, 53.157844f,
                55.173110f, 53.371333f, 55.191883f, 53.398238f, 55.202065f, 53.362239f, 55.230037f, 53.426972f, 55.214323f, 53.616626f,
                55.262642f, 53.602269f, 55.277042f, 53.685629f, 55.327133f, 53.690385f, 55.365909f, 53.861956f, 55.354651f, 53.895764f,
                55.394366f, 53.872761f, 55.442170f, 53.915395f, 54.891446f, 53.915395f, 54.891446f, 53.639235f, 54.906586f, 53.649304f,
                54.891446f, 53.597580f
            )
            poly[29] = TzPolygon(55.175889f, 59.150751f, 55.162808f, 59.172064f, 55.142427f, 59.158175f, 55.153803f, 59.113569f)
            poly[30] = TzPolygon(
                55.210021f, 69.957225f, 55.210093f, 69.950516f, 55.299966f, 69.862930f, 55.345583f, 69.745073f, 55.342093f, 69.441769f,
                55.352208f, 69.402974f, 55.384553f, 69.411653f, 55.386983f, 69.363908f, 55.351354f, 69.317696f, 55.330115f, 69.199475f,
                55.390437f, 69.160572f, 55.442027f, 68.932686f, 55.365332f, 68.915885f, 55.365765f, 68.983669f, 55.288464f, 69.001168f,
                55.327362f, 68.956225f, 55.318490f, 68.928963f, 55.378842f, 68.748654f, 55.288836f, 68.696868f, 55.265379f, 68.635116f,
                55.235735f, 68.657829f, 55.198213f, 68.619795f, 55.219408f, 68.594980f, 55.196495f, 68.444642f, 55.206463f, 68.358804f,
                55.180954f, 68.353543f, 55.203531f, 68.304201f, 55.187150f, 68.239630f, 55.198793f, 68.177148f, 55.154756f, 68.218666f,
                55.151440f, 68.189505f, 55.076629f, 68.315193f, 55.054098f, 68.237586f, 55.014808f, 68.237811f, 54.990182f, 68.196709f,
                54.968959f, 68.234743f, 54.950457f, 68.032268f, 54.983669f, 67.910619f, 54.971376f, 67.819274f, 54.891446f, 67.776503f,
                54.891446f, 59.172064f, 55.442170f, 59.172064f, 55.442170f, 69.957225f
            )
            poly[31] = TzPolygon(
                26.179962f, -107.815375f, 26.196484f, -107.853967f, 26.438910f, -108.012728f, 26.470118f, -107.969609f, 26.472102f, -107.985476f,
                26.493996f, -107.957081f, 26.526811f, -107.960858f, 26.615880f, -108.031607f, 26.641929f, -108.081652f, 26.689668f, -108.011685f,
                26.729418f, -108.008305f, 26.729418f, -107.815375f
            )
            poly[32] = TzPolygon(
                26.729418f, -109.999802f, 26.729418f, -108.600314f, 26.727223f, -108.601024f, 26.718387f, -108.628385f, 26.676573f, -108.630366f,
                26.642889f, -108.678988f, 26.587015f, -108.678831f, 26.593568f, -108.734293f, 26.551071f, -108.873152f, 26.489595f, -108.891317f,
                26.479540f, -108.914670f, 26.487217f, -108.847480f, 26.472523f, -108.837762f, 26.447576f, -108.876108f, 26.432770f, -108.860339f,
                26.406252f, -108.881392f, 26.421715f, -108.910115f, 26.390180f, -108.936522f, 26.402370f, -109.006443f, 26.297015f, -109.125378f,
                26.344966f, -109.202603f, 26.316185f, -109.246826f, 26.310512f, -109.508033f, 26.403716f, -109.477396f, 26.473497f, -109.534853f,
                26.478136f, -109.728538f, 26.544417f, -109.894124f, 26.634176f, -109.999802f
            )
            poly[33] = TzPolygon(27.764211f, -108.907589f, 27.784752f, -108.920341f, 27.798298f, -108.907589f)
            poly[34] = TzPolygon(
                27.851368f, -108.907589f, 27.853703f, -108.914848f, 27.940495f, -108.926480f, 28.018227f, -109.031995f, 28.148745f, -109.073038f,
                28.272489f, -109.074984f, 28.278261f, -109.022484f, 28.255884f, -108.993813f, 28.298515f, -108.992104f, 28.250867f, -108.921264f,
                28.255657f, -108.907589f
            )
            poly[35] = TzPolygon(
                27.531508f, -108.907589f, 27.531508f, -108.653029f, 27.465206f, -108.661652f, 27.317990f, -108.590990f, 27.220165f, -108.663025f,
                27.177111f, -108.653412f, 27.154082f, -108.611415f, 27.036985f, -108.602179f, 27.045866f, -108.562399f, 27.012599f, -108.571999f,
                26.997077f, -108.551576f, 26.976230f, -108.424271f, 26.970702f, -108.466978f, 26.823753f, -108.557043f, 26.798429f, -108.536912f,
                26.779857f, -108.554034f, 26.789577f, -108.580849f, 26.729418f, -108.600314f, 26.729418f, -108.907589f
            )
            poly[36] = TzPolygon(
                26.729418f, -108.600314f, 26.789577f, -108.580849f, 26.779857f, -108.554034f, 26.798429f, -108.536912f, 26.823753f, -108.557043f,
                26.970702f, -108.466978f, 26.976230f, -108.424271f, 26.987366f, -108.502429f, 27.036581f, -108.486977f, 27.013419f, -108.409530f,
                27.022604f, -108.350083f, 27.004510f, -108.333373f, 27.034043f, -108.317576f, 27.012384f, -108.284344f, 27.042249f, -108.242392f,
                27.034770f, -108.197788f, 27.000149f, -108.180209f, 26.958793f, -108.234966f, 26.905629f, -108.230258f, 26.881351f, -108.174710f,
                26.907204f, -108.142117f, 26.867579f, -108.144261f, 26.870410f, -108.094161f, 26.798426f, -108.026810f, 26.769822f, -108.037698f,
                26.760987f, -108.005620f, 26.729418f, -108.008305f
            )
            poly[37] = TzPolygon(
                28.333599f, -108.636200f, 28.292471f, -108.641052f, 28.303060f, -108.687952f, 28.266951f, -108.797343f, 28.253495f, -108.791585f,
                28.265560f, -108.879318f, 28.255657f, -108.907589f, 28.333599f, -108.907589f
            )
            poly[38] = TzPolygon(27.851368f, -108.907589f, 27.839032f, -108.869241f, 27.798298f, -108.907589f)
            poly[39] = TzPolygon(
                27.764211f, -108.907589f, 27.744740f, -108.895501f, 27.730490f, -108.784424f, 27.601137f, -108.739929f, 27.537834f, -108.652206f,
                27.531508f, -108.653029f, 27.531508f, -108.907589f
            )
            poly[40] = TzPolygon(28.333599f, -108.521428f, 28.317737f, -108.550519f, 28.333599f, -108.579013f)
            poly[41] = TzPolygon(
                25.579947f, -106.723162f, 25.571661f, -106.873310f, 25.644091f, -106.893301f, 25.661685f, -106.994438f, 25.668331f, -106.966940f,
                25.697879f, -106.965323f, 25.714924f, -106.990299f, 25.691459f, -107.010680f, 25.699875f, -107.046144f, 25.757368f, -107.057905f,
                25.924793f, -107.296128f, 26.001977f, -107.276346f, 26.076402f, -107.304890f, 26.109523f, -107.346528f, 26.142860f, -107.431043f,
                26.104227f, -107.520020f, 26.170640f, -107.582027f, 26.154578f, -107.635749f, 26.174413f, -107.711075f, 26.134506f, -107.755043f,
                26.136865f, -107.780674f, 26.168627f, -107.788898f, 26.179962f, -107.815375f, 26.729418f, -107.815375f, 26.729418f, -106.723162f
            )
            poly[42] = TzPolygon(
                25.125236f, -107.127206f, 25.186640f, -107.124918f, 25.224548f, -107.148775f, 25.243111f, -107.121057f, 25.331564f, -107.207816f,
                25.326358f, -107.171551f, 25.417101f, -107.210132f, 25.441992f, -107.158690f, 25.489565f, -107.139295f, 25.515176f, -107.178117f,
                25.556553f, -107.173879f, 25.550414f, -107.124565f, 25.629570f, -106.973290f, 25.661685f, -106.994438f, 25.644091f, -106.893301f,
                25.571661f, -106.873310f, 25.579947f, -106.723162f, 25.125236f, -106.723162f
            )
            poly[43] = TzPolygon(
                25.579947f, -106.723162f, 25.581085f, -106.702539f, 25.597082f, -106.705617f, 25.579332f, -106.681968f, 25.602195f, -106.707722f,
                25.558657f, -106.652569f, 25.647396f, -106.591666f, 25.728722f, -106.463376f, 25.691778f, -106.555806f, 25.952097f, -106.546964f,
                25.972486f, -106.455447f, 26.004822f, -106.444522f, 26.005396f, -106.470406f, 26.027765f, -106.453244f, 26.060420f, -106.471186f,
                26.096989f, -106.455996f, 26.344723f, -106.307962f, 26.334746f, -106.287001f, 26.367243f, -106.275112f, 26.364574f, -106.295961f,
                26.440288f, -106.255964f, 26.531569f, -106.279921f, 26.558754f, -106.233085f, 26.678178f, -106.207824f, 26.674407f, -106.188134f,
                26.705337f, -106.172046f, 26.700708f, -106.130625f, 26.727674f, -106.176449f, 26.729418f, -106.176495f, 26.729418f, -105.846806f,
                26.660915f, -105.775777f, 26.698729f, -105.794199f, 26.713838f, -105.746274f, 26.617649f, -105.674854f, 26.615930f, -105.630949f,
                25.125236f, -105.630949f, 25.125236f, -106.723162f
            )
            poly[44] = TzPolygon(
                26.729418f, -106.176495f, 26.772195f, -106.177626f, 26.779321f, -106.125304f, 26.759285f, -106.100652f, 26.844788f, -106.047366f,
                26.763234f, -105.939209f, 26.747387f, -105.865438f, 26.729418f, -105.846806f
            )
            poly[45] = TzPolygon(
                29.937781f, -109.999802f, 29.937781f, -108.625878f, 29.847115f, -108.607142f, 29.829767f, -108.635880f, 29.800790f, -108.618695f,
                29.796156f, -108.541220f, 29.752337f, -108.534622f, 29.717686f, -108.592385f, 29.716169f, -108.659375f, 29.660587f, -108.618210f,
                29.649450f, -108.655006f, 29.588850f, -108.641317f, 29.584534f, -108.659416f, 29.558283f, -108.638501f, 29.544517f, -108.661996f,
                29.501171f, -108.625259f, 29.466534f, -108.717789f, 29.308136f, -108.669724f, 29.267289f, -108.682081f, 29.254683f, -108.761902f,
                29.218582f, -108.735641f, 29.163668f, -108.746024f, 29.171978f, -108.729462f, 29.128502f, -108.698212f, 29.096232f, -108.729563f,
                29.082692f, -108.708999f, 29.069873f, -108.724498f, 28.889599f, -108.709645f, 28.809963f, -108.657700f, 28.806503f, -108.624062f,
                28.766033f, -108.643456f, 28.740751f, -108.583717f, 28.632463f, -108.580083f, 28.508553f, -108.507500f, 28.426272f, -108.515572f,
                28.369551f, -108.479701f, 28.364595f, -108.521719f, 28.334455f, -108.519859f, 28.333599f, -108.579013f, 28.347390f, -108.603786f,
                28.335144f, -108.636018f, 28.333599f, -108.636200f, 28.333599f, -109.999802f
            )
            poly[46] = TzPolygon(31.541963f, -108.907589f, 31.332579f, -108.907589f, 31.332409f, -109.050040f, 31.541963f, -109.049820f)
            poly[47] = TzPolygon(30.728570f, -108.907589f, 30.739321f, -108.918753f, 30.736901f, -108.948073f, 30.907403f, -108.939335f, 30.906651f, -108.907589f)
            poly[48] = TzPolygon(31.541963f, -109.999802f, 31.541963f, -109.049753f, 31.332409f, -109.050040f, 31.332316f, -109.999802f)
            poly[49] = TzPolygon(
                29.937781f, -108.625878f, 29.952826f, -108.628987f, 30.028856f, -108.606895f, 30.235941f, -108.617516f, 30.179691f, -108.505364f,
                30.264100f, -108.501728f, 30.304283f, -108.475600f, 30.302227f, -108.441409f, 30.343762f, -108.436022f, 30.339935f, -108.383076f,
                30.398221f, -108.343965f, 30.376967f, -108.201381f, 30.415196f, -108.219793f, 30.445844f, -108.173685f, 30.479270f, -108.230143f,
                30.532806f, -108.190001f, 30.529081f, -108.160252f, 30.560915f, -108.171521f, 30.602961f, -108.074088f, 30.675447f, -108.110090f,
                30.680564f, -108.057912f, 30.651517f, -108.038244f, 30.662162f, -107.935088f, 30.739872f, -107.960395f, 30.739872f, -107.815375f,
                29.937781f, -107.815375f
            )
            poly[50] = TzPolygon(
                30.728570f, -108.907589f, 30.689491f, -108.867005f, 30.624622f, -108.876403f, 30.587375f, -108.762111f, 30.594338f, -108.726843f,
                30.556825f, -108.677771f, 30.468183f, -108.664397f, 30.465022f, -108.603785f, 30.416670f, -108.648543f, 30.340095f, -108.622119f,
                30.337395f, -108.580057f, 30.283485f, -108.541986f, 30.266254f, -108.550290f, 30.298292f, -108.620178f, 30.028856f, -108.606895f,
                29.952826f, -108.628987f, 29.937781f, -108.625878f, 29.937781f, -108.907589f
            )
            poly[51] = TzPolygon(
                30.739872f, -107.960395f, 30.811527f, -107.983731f, 30.844713f, -107.912255f, 30.805122f, -107.929070f, 30.853452f, -107.815375f,
                30.739872f, -107.815375f
            )
            poly[52] = TzPolygon(31.541963f, -108.208443f, 31.333416f, -108.208486f, 31.332579f, -108.907589f, 31.541963f, -108.907589f)
            poly[53] = TzPolygon(
                31.332504f, -108.907589f, 31.332522f, -108.756413f, 31.239548f, -108.816833f, 31.239252f, -108.879829f, 31.207691f, -108.906609f,
                31.219437f, -108.860603f, 31.195032f, -108.848264f, 31.192955f, -108.805352f, 31.135466f, -108.845643f, 31.103098f, -108.769974f,
                31.074432f, -108.767906f, 31.052816f, -108.729630f, 31.034138f, -108.752808f, 31.033695f, -108.683968f, 31.006334f, -108.683456f,
                31.004482f, -108.803316f, 30.904154f, -108.802248f, 30.906651f, -108.907589f
            )
            poly[54] = TzPolygon(
                29.504712f, -105.630949f, 29.504744f, -105.633806f, 29.591481f, -105.633176f, 29.591683f, -105.681598f, 29.646829f, -105.679455f,
                29.649659f, -105.848966f, 29.613394f, -105.858715f, 29.654463f, -105.866291f, 29.666227f, -105.909903f, 29.700950f, -105.909055f,
                29.701067f, -105.827056f, 29.747349f, -105.817962f, 29.777500f, -105.879554f, 29.783177f, -105.805710f, 29.881759f, -105.809753f,
                29.881982f, -105.767952f, 29.937781f, -105.769718f, 29.937781f, -105.630949f
            )
            poly[55] = TzPolygon(
                31.163909f, -106.723162f, 31.160276f, -106.745603f, 31.137931f, -106.745776f, 31.119957f, -106.821288f, 31.152077f, -106.894815f,
                31.085365f, -106.894857f, 31.086114f, -107.044916f, 30.954102f, -107.046640f, 30.955263f, -107.073691f, 30.886460f, -107.100737f,
                30.871980f, -107.085933f, 30.864996f, -107.157143f, 30.801074f, -107.189321f, 30.805192f, -107.238520f, 30.756192f, -107.262858f,
                30.836259f, -107.350690f, 30.758402f, -107.399507f, 30.758388f, -107.525538f, 30.782971f, -107.526230f, 30.719639f, -107.615953f,
                30.721180f, -107.634799f, 30.764479f, -107.629097f, 30.805867f, -107.704097f, 30.825616f, -107.695370f, 30.814186f, -107.766258f,
                30.859257f, -107.801720f, 30.853452f, -107.815375f, 31.541963f, -107.815375f, 31.541963f, -106.723162f
            )
            poly[56] = TzPolygon(
                31.163948f, -106.723162f, 31.174292f, -106.659025f, 31.151993f, -106.614689f, 31.152545f, -106.501491f, 31.187330f, -106.507416f,
                31.187602f, -106.390768f, 31.159046f, -106.396831f, 31.154706f, -106.373991f, 31.187146f, -106.366934f, 31.151251f, -106.304914f,
                31.037517f, -106.272760f, 31.000450f, -106.178335f, 30.952941f, -106.193684f, 30.956392f, -106.133256f, 30.985189f, -106.132447f,
                30.985119f, -106.091190f, 30.898958f, -106.075025f, 30.905024f, -106.030028f, 30.896337f, -106.054355f, 30.819754f, -106.053611f,
                30.819615f, -105.880975f, 30.846669f, -105.876796f, 30.846553f, -105.819675f, 30.770464f, -105.709927f, 30.656690f, -105.728331f,
                30.641962f, -105.684838f, 30.505157f, -105.685915f, 30.500295f, -105.630949f, 30.309088f, -105.630949f, 30.281711f, -105.692197f,
                30.239118f, -105.680874f, 30.238848f, -105.630949f, 30.190877f, -105.630949f, 30.219026f, -105.687126f, 30.049876f, -105.905345f,
                30.029513f, -105.900957f, 30.028342f, -105.772584f, 29.937781f, -105.769718f, 29.937781f, -106.723162f
            )
            poly[57] = TzPolygon(
                31.096774f, -105.630949f, 31.166800f, -105.773040f, 31.288640f, -105.868940f, 31.318310f, -105.938190f, 31.364890f, -105.953960f,
                31.398640f, -106.080580f, 31.466260f, -106.206680f, 31.541963f, -106.256292f, 31.541963f, -105.630949f
            )
            poly[58] = TzPolygon(
                26.729418f, -105.630949f, 26.729418f, -104.290028f, 26.725375f, -104.286510f, 26.656494f, -104.330316f, 26.604514f, -104.434783f,
                26.465779f, -104.502852f, 26.414550f, -104.501052f, 26.340468f, -104.574451f, 26.380411f, -104.593865f, 26.368825f, -104.620117f,
                26.391046f, -104.654134f, 26.478283f, -104.727430f, 26.508488f, -104.809174f, 26.510015f, -104.898922f, 26.473341f, -104.963210f,
                26.449248f, -104.963102f, 26.454910f, -105.000564f, 26.419309f, -105.056632f, 26.521373f, -105.101637f, 26.462020f, -105.264634f,
                26.487511f, -105.279249f, 26.462255f, -105.316769f, 26.478864f, -105.352776f, 26.504531f, -105.342611f, 26.534245f, -105.368624f,
                26.517496f, -105.403561f, 26.527937f, -105.470215f, 26.508686f, -105.471556f, 26.542861f, -105.496133f, 26.546552f, -105.548990f,
                26.683504f, -105.619556f, 26.614753f, -105.600891f, 26.615930f, -105.630949f
            )
            poly[59] = TzPolygon(26.729418f, -103.701283f, 26.725256f, -103.699094f, 26.729418f, -103.742509f)
            poly[60] = TzPolygon(
                27.531508f, -104.538735f, 27.531508f, -103.856280f, 27.311592f, -103.876876f, 27.298294f, -103.832123f, 27.213476f, -103.798427f,
                27.124730f, -103.799398f, 27.077920f, -103.752461f, 27.022522f, -103.740834f, 26.934619f, -103.852089f, 26.935813f, -103.835919f,
                26.896134f, -103.851701f, 26.829573f, -103.753968f, 26.729418f, -103.701283f, 26.729418f, -103.742509f, 26.753517f, -103.993921f,
                26.777517f, -103.995129f, 26.774330f, -104.033296f, 26.742827f, -104.045792f, 26.777095f, -104.227863f, 26.842300f, -104.273037f,
                26.799023f, -104.315295f, 26.760715f, -104.317265f, 26.729418f, -104.290028f, 26.729418f, -104.538735f
            )
            poly[61] = TzPolygon(
                27.048310f, -103.446522f, 27.053160f, -103.453794f, 27.182641f, -103.530715f, 27.281639f, -103.521528f, 27.281630f, -103.462132f,
                27.300733f, -103.446522f
            )
            poly[62] = TzPolygon(27.425605f, -103.446522f, 27.435105f, -103.506027f, 27.531508f, -103.496270f, 27.531508f, -103.446522f)
            poly[63] = TzPolygon(
                28.333599f, -103.736782f, 27.971357f, -103.926692f, 27.957490f, -103.877716f, 27.914023f, -103.892886f, 27.950821f, -103.954973f,
                27.835309f, -103.960002f, 27.826857f, -103.900844f, 27.797553f, -103.935650f, 27.739186f, -103.881145f, 27.740557f, -103.896692f,
                27.656549f, -103.897263f, 27.549433f, -103.854601f, 27.531508f, -103.856280f, 27.531508f, -104.538735f, 28.333599f, -104.538735f
            )
            poly[64] = TzPolygon(27.531508f, -103.446522f, 27.531508f, -103.496270f, 27.764753f, -103.472662f, 27.780422f, -103.493997f, 27.828017f, -103.446522f)
            poly[65] = TzPolygon(
                27.857730f, -103.446522f, 27.863472f, -103.449645f, 27.867085f, -103.506989f, 27.907812f, -103.504929f, 27.879970f, -103.537427f,
                27.902833f, -103.604406f, 27.864562f, -103.634013f, 28.333599f, -103.456882f, 28.333592f, -103.446522f
            )
            poly[66] = TzPolygon(
                27.300733f, -103.446522f, 27.411194f, -103.356256f, 27.425605f, -103.446522f, 27.828017f, -103.446522f, 27.838502f, -103.436063f,
                27.857730f, -103.446522f, 28.333592f, -103.446522f, 28.332868f, -102.436574f, 28.289561f, -102.492944f, 28.147617f, -102.412415f,
                28.015507f, -102.384525f, 27.973875f, -102.354308f, 27.256342f, -102.354308f, 27.262001f, -102.365845f, 27.192400f, -102.411886f,
                27.148235f, -102.354308f, 27.017671f, -102.354308f, 27.026899f, -102.442863f, 27.080604f, -102.485629f, 27.160036f, -102.640201f,
                27.064374f, -102.695282f, 27.083463f, -102.728071f, 27.044990f, -102.743664f, 27.048355f, -102.782713f, 27.080955f, -102.808391f,
                26.873131f, -102.799681f, 26.979568f, -102.987568f, 26.963190f, -102.988784f, 26.977935f, -103.027151f, 26.973928f, -103.334998f,
                27.048310f, -103.446522f
            )
            poly[67] = TzPolygon(
                27.973875f, -102.354308f, 27.964631f, -102.347599f, 28.005032f, -102.282384f, 27.947977f, -102.215023f, 27.897244f, -102.254101f,
                27.887145f, -102.300301f, 27.848216f, -102.265327f, 27.863911f, -102.246937f, 27.851511f, -102.201336f, 27.818064f, -102.157031f,
                27.692404f, -102.199515f, 27.657046f, -102.182351f, 27.695147f, -102.136961f, 27.567978f, -102.090081f, 27.420001f, -101.939623f,
                27.316847f, -101.893455f, 27.247850f, -101.971419f, 27.263171f, -102.011111f, 27.236389f, -102.034447f, 27.248705f, -102.124223f,
                27.278843f, -102.144687f, 27.272775f, -102.316681f, 27.231634f, -102.303942f, 27.256342f, -102.354308f
            )
            poly[68] = TzPolygon(27.148235f, -102.354308f, 27.131519f, -102.332516f, 27.011473f, -102.294823f, 27.017671f, -102.354308f)
            poly[69] = TzPolygon(29.705406f, -104.538735f, 29.771360f, -104.565900f, 29.920780f, -104.679970f, 29.937781f, -104.683579f, 29.937781f, -104.538735f)
            poly[70] = TzPolygon(
                29.504712f, -105.630949f, 29.502590f, -105.442803f, 29.463725f, -105.480325f, 29.409735f, -105.454257f, 29.419804f, -105.365860f,
                29.400512f, -105.349754f, 29.376317f, -105.364724f, 29.363606f, -105.320328f, 29.239636f, -105.202371f, 29.204732f, -105.140956f,
                29.212777f, -105.068600f, 29.184177f, -105.045365f, 29.126619f, -105.063648f, 29.101846f, -105.107714f, 29.049377f, -105.132393f,
                28.977980f, -105.061755f, 28.995968f, -105.037765f, 28.983849f, -104.954996f, 29.007072f, -104.916317f, 28.973901f, -104.896897f,
                28.994769f, -104.840074f, 28.776479f, -104.662185f, 28.768787f, -104.685402f, 28.735336f, -104.672181f, 28.755700f, -104.617408f,
                28.726497f, -104.617233f, 28.757786f, -104.538735f, 28.333599f, -104.538735f, 28.333599f, -105.630949f
            )
            poly[71] = TzPolygon(
                28.590302f, -103.992628f, 28.558964f, -104.021831f, 28.600631f, -104.058121f, 28.635285f, -104.050598f, 28.677296f, -104.077218f,
                28.708047f, -104.118999f, 28.678387f, -104.144749f, 28.704321f, -104.172031f, 28.686855f, -104.184089f, 28.707638f, -104.222449f,
                28.648461f, -104.260774f, 28.634995f, -104.243302f, 28.583460f, -104.293057f, 28.617322f, -104.327302f, 28.595588f, -104.348409f,
                28.631426f, -104.419645f, 28.684855f, -104.370940f, 28.689200f, -104.417721f, 28.753239f, -104.465437f, 28.766659f, -104.516474f,
                28.757786f, -104.538735f, 29.135690f, -104.538735f, 29.135690f, -103.992628f
            )
            poly[72] = TzPolygon(29.056642f, -103.446522f, 29.135690f, -103.530062f, 29.135690f, -103.446522f)
            poly[73] = TzPolygon(
                28.590302f, -103.992628f, 28.607326f, -103.976764f, 28.605142f, -103.926493f, 28.577443f, -103.925458f, 28.603799f, -103.841361f,
                28.558061f, -103.722494f, 28.602846f, -103.705747f, 28.592591f, -103.628556f, 28.512462f, -103.643011f, 28.333599f, -103.736782f,
                28.333599f, -103.992628f
            )
            poly[74] = TzPolygon(28.333599f, -103.456882f, 28.361033f, -103.446522f, 28.333599f, -103.446522f)
            poly[75] = TzPolygon(
                28.463727f, -103.446522f, 28.554505f, -103.637501f, 28.590834f, -103.591916f, 28.598195f, -103.616046f, 28.639475f, -103.596374f,
                28.640639f, -103.572659f, 28.611281f, -103.557295f, 28.664998f, -103.514512f, 28.776250f, -103.446522f
            )
            poly[76] = TzPolygon(28.333599f, -103.747051f, 28.554505f, -103.637501f, 28.463727f, -103.446522f, 28.361033f, -103.446522f, 28.333599f, -103.456882f)
            poly[77] = TzPolygon(
                29.705890f, -104.538735f, 29.632490f, -104.508280f, 29.519700f, -104.337460f, 29.532840f, -104.315550f, 29.484720f, -104.213780f,
                29.456250f, -104.217590f, 29.393220f, -104.165840f, 29.319800f, -104.037710f, 29.265453f, -103.783930f, 29.226715f, -103.781918f,
                29.221830f, -103.742320f, 29.180810f, -103.718490f, 29.156680f, -103.650480f, 29.158000f, -103.553640f, 29.135690f, -103.530062f,
                29.135690f, -104.538735f
            )
            poly[78] = TzPolygon(
                29.937781f, -103.446522f, 29.937781f, -104.683579f, 30.049900f, -104.707380f, 30.098380f, -104.684960f, 30.234910f, -104.706290f,
                30.332840f, -104.811610f, 30.375440f, -104.816610f, 30.390310f, -104.859480f, 30.419770f, -104.847780f, 30.570530f, -104.898870f,
                30.605100f, -104.924690f, 30.625300f, -104.980750f, 30.663569f, -104.917229f, 30.836004f, -104.907465f, 31.541963f, -104.914266f,
                31.541963f, -103.446522f
            )
            poly[79] = TzPolygon(
                30.500295f, -105.630949f, 30.497250f, -105.596524f, 30.393175f, -105.607176f, 30.324669f, -105.563671f, 30.331094f, -105.624822f,
                30.311720f, -105.625060f, 30.309088f, -105.630949f
            )
            poly[80] = TzPolygon(30.238848f, -105.630949f, 30.238818f, -105.625328f, 30.188135f, -105.625477f, 30.190877f, -105.630949f)
            poly[81] = TzPolygon(
                31.096774f, -105.630949f, 31.541963f, -105.630949f, 31.541963f, -104.914266f, 30.836004f, -104.907465f, 30.663569f, -104.917229f,
                30.629398f, -104.979553f, 30.686090f, -105.006590f, 30.685870f, -105.061750f, 30.749859f, -105.118055f, 30.752160f, -105.161460f,
                30.769830f, -105.156270f, 30.792300f, -105.195200f, 30.783400f, -105.216410f, 30.805910f, -105.215010f, 30.794280f, -105.257470f,
                30.825850f, -105.290780f, 30.810850f, -105.316670f, 30.840350f, -105.339130f, 30.851990f, -105.399860f, 30.889310f, -105.400040f,
                30.989680f, -105.557190f, 31.083700f, -105.604420f
            )
            poly[82] = TzPolygon(
                29.135690f, -103.446522f, 29.135690f, -103.016866f, 29.101332f, -103.033514f, 29.060690f, -103.100560f, 28.984610f, -103.115960f,
                28.972230f, -103.163880f, 28.996100f, -103.267240f, 28.976780f, -103.285930f, 29.024490f, -103.307560f, 29.020650f, -103.338970f,
                29.043120f, -103.330430f, 29.018470f, -103.360710f, 29.043450f, -103.432580f, 29.056642f, -103.446522f
            )
            poly[83] = TzPolygon(28.463727f, -103.446522f, 28.448098f, -103.413642f, 28.361033f, -103.446522f)
            poly[84] = TzPolygon(
                28.333599f, -102.436717f, 28.590584f, -102.486892f, 28.582313f, -102.505720f, 28.638292f, -102.569600f, 28.670648f, -102.552839f,
                28.696971f, -102.638040f, 29.064056f, -102.404698f, 29.054158f, -102.354308f, 28.333599f, -102.354308f
            )
            poly[85] = TzPolygon(
                29.056642f, -103.446522f, 29.043450f, -103.432580f, 29.018470f, -103.360710f, 29.046290f, -103.342800f, 29.018760f, -103.337160f,
                29.022950f, -103.306690f, 28.869254f, -103.403650f, 28.833529f, -103.396347f, 28.813180f, -103.431663f, 28.786604f, -103.446522f
            )
            poly[86] = TzPolygon(
                29.135690f, -103.016866f, 29.179270f, -102.995750f, 29.173600f, -102.950690f, 29.219420f, -102.912160f, 29.223440f, -102.867660f,
                29.260000f, -102.906350f, 29.347860f, -102.884150f, 29.358940f, -102.839430f, 29.399390f, -102.812750f, 29.410450f, -102.833440f,
                29.486280f, -102.800850f, 29.522900f, -102.808560f, 29.548280f, -102.771280f, 29.595190f, -102.768410f, 29.598250f, -102.740200f,
                29.633090f, -102.742070f, 29.676720f, -102.693660f, 29.743910f, -102.675150f, 29.734130f, -102.630600f, 29.771460f, -102.568660f,
                29.744650f, -102.548180f, 29.783580f, -102.517580f, 29.786640f, -102.487020f, 29.761240f, -102.387640f, 29.845560f, -102.364450f,
                29.852712f, -102.354308f, 29.135690f, -102.354308f
            )
            poly[87] = TzPolygon(
                29.621589f, -101.262095f, 29.619206f, -101.280274f, 29.572092f, -101.289445f, 29.580233f, -101.307423f, 29.653060f, -101.303835f,
                29.650452f, -101.362276f, 29.699634f, -101.371818f, 29.746460f, -101.416220f, 29.771200f, -101.401120f, 29.749890f, -101.447700f,
                29.789970f, -101.461870f, 29.758070f, -101.536210f, 29.812130f, -101.544540f, 29.769680f, -101.574740f, 29.754210f, -101.645040f,
                29.771120f, -101.661680f, 29.780230f, -101.804760f, 29.811750f, -101.818080f, 29.787380f, -101.823810f, 29.807890f, -101.852560f,
                29.782660f, -101.929060f, 29.815910f, -101.976470f, 29.796750f, -101.987530f, 29.786450f, -102.072900f, 29.803220f, -102.143360f,
                29.848520f, -102.186640f, 29.840520f, -102.223340f, 29.880030f, -102.315570f, 29.852712f, -102.354308f, 29.937781f, -102.354308f,
                29.937781f, -101.262095f
            )
            poly[88] = TzPolygon(
                29.054158f, -102.354308f, 28.984014f, -101.997202f, 28.509111f, -101.716974f, 28.388718f, -101.262095f, 28.333599f, -101.262095f,
                28.333599f, -102.354308f
            )
            poly[89] = TzPolygon(
                31.541963f, -104.914266f, 32.000263f, -104.918681f, 32.000391f, -103.064631f, 36.500453f, -103.041654f, 36.500439f, -103.002461f,
                37.000087f, -103.002441f, 36.993128f, -102.042127f, 37.738541f, -102.041990f, 37.736435f, -101.527054f, 37.958689f, -101.536806f,
                37.958689f, -101.262095f, 31.541963f, -101.262095f
            )
            poly[90] = TzPolygon(
                31.541963f, -108.208443f, 31.783627f, -108.208394f, 31.783777f, -106.528064f, 31.748190f, -106.489450f, 31.764530f, -106.452090f,
                31.732710f, -106.382070f, 31.541963f, -106.256511f
            )
            poly[91] = TzPolygon(
                35.167602f, -109.999802f, 35.170948f, -109.625725f, 35.257645f, -109.624168f, 35.231499f, -109.198677f, 35.167481f, -109.199326f,
                35.166000f, -109.046017f, 34.785265f, -109.045316f, 31.541963f, -109.049753f, 31.541963f, -109.999802f
            )
            poly[92] = TzPolygon(
                26.634176f, -109.999802f, 26.654086f, -110.023243f, 26.887078f, -110.138212f, 26.973159f, -110.404644f, 27.085607f, -110.549517f,
                27.161088f, -110.747029f, 27.287664f, -110.826696f, 27.489820f, -110.818454f, 27.639274f, -110.858023f, 27.652650f, -110.972247f,
                27.781493f, -111.250195f, 27.753843f, -111.392089f, 27.808468f, -111.529387f, 27.870635f, -111.584902f, 27.950008f, -111.615637f,
                28.000000f, -111.612786f, 28.000000f, -109.999802f
            )
            poly[93] = TzPolygon(
                28.000000f, -109.999802f, 28.000000f, -111.612786f, 28.036767f, -111.610689f, 28.111808f, -111.567429f, 28.149497f, -111.588820f,
                28.233032f, -111.663923f, 28.313718f, -111.871268f, 28.485754f, -111.967032f, 28.595942f, -112.100765f, 28.532976f, -112.178086f,
                28.463692f, -112.123679f, 28.376445f, -112.104044f, 28.292679f, -112.124144f, 28.221931f, -112.177706f, 28.176310f, -112.255965f,
                28.162148f, -112.345842f, 28.181032f, -112.436117f, 28.230172f, -112.510459f, 28.341794f, -112.568834f, 28.467195f, -112.545488f,
                28.460757f, -112.593460f, 29.400000f, -112.880000f, 31.700000f, -114.623000f, 31.812000f, -114.755000f, 31.819726f, -114.815697f,
                31.864083f, -114.843193f, 31.867601f, -114.910636f, 31.890713f, -114.942025f, 31.921465f, -114.965560f, 32.177995f, -114.975318f,
                32.245174f, -115.053022f, 32.338794f, -114.966592f, 32.481751f, -114.935118f, 32.492249f, -114.881545f, 32.473424f, -114.848304f,
                32.494077f, -114.813581f, 31.332239f, -111.074825f, 31.332370f, -109.999802f
            )
            poly[94] = TzPolygon(32.494077f, -114.802170f, 32.494077f, -109.999802f, 31.332316f, -109.999802f, 31.332214f, -111.044352f)
            poly[95] = TzPolygon(32.494077f, -117.526144f, 32.523540f, -117.519113f, 32.590387f, -117.464899f, 32.567155f, -117.338623f, 32.494077f, -117.338623f)
            poly[96] = TzPolygon(
                32.567155f, -117.338623f, 32.553400f, -117.263858f, 32.527498f, -117.239059f, 32.634105f, -115.834170f, 32.494077f, -115.834170f,
                32.494077f, -117.338623f
            )
            poly[97] = TzPolygon(
                33.860230f, -115.834170f, 33.860230f, -114.521907f, 33.856915f, -114.530169f, 33.814693f, -114.528190f, 33.707365f, -114.494090f,
                33.672877f, -114.531799f, 33.659529f, -114.513934f, 33.590246f, -114.540740f, 33.552743f, -114.524246f, 33.499417f, -114.591601f,
                33.419683f, -114.638815f, 33.404830f, -114.725598f, 33.353167f, -114.698053f, 33.301714f, -114.731136f, 33.259266f, -114.672236f,
                33.088846f, -114.706820f, 33.032735f, -114.661775f, 33.049023f, -114.645142f, 33.026980f, -114.616547f, 33.022000f, -114.509589f,
                32.971920f, -114.493121f, 32.968357f, -114.467703f, 32.844391f, -114.469154f, 32.794697f, -114.530232f, 32.757160f, -114.526846f,
                32.728646f, -114.616324f, 32.745539f, -114.701322f, 32.718655f, -114.719960f, 32.634105f, -115.834170f
            )
            poly[98] = TzPolygon(
                32.634105f, -115.834170f, 32.718655f, -114.719960f, 32.643121f, -114.765186f, 32.622349f, -114.810505f, 32.557377f, -114.812952f,
                32.556393f, -114.791494f, 32.494077f, -114.812235f, 32.494077f, -115.834170f
            )
            poly[99] = TzPolygon(
                33.860230f, -114.521907f, 33.867817f, -114.502999f, 33.900790f, -114.526019f, 33.903155f, -114.508138f, 33.938167f, -114.534388f,
                34.021841f, -114.438544f, 34.107010f, -114.416720f, 34.144165f, -114.329716f, 33.860230f, -114.329716f
            )
        }
    }

    private object Initializer2 {
        fun init() {
            poly[100] = TzPolygon(
                34.446382f, -114.329716f, 34.450197f, -114.335722f, 34.456905f, -114.385776f, 34.528222f, -114.380706f, 34.593823f, -114.435934f,
                34.710430f, -114.469869f, 34.766647f, -114.552212f, 34.874225f, -114.634609f, 35.024760f, -114.637787f, 35.068942f, -114.602813f,
                35.102257f, -114.646277f, 35.128552f, -114.579302f, 35.185522f, -114.569735f, 35.226383f, -114.577646f, 35.226383f, -114.329716f
            )
            poly[101] = TzPolygon(
                35.226383f, -114.329716f, 35.226383f, -114.577646f, 35.341945f, -114.600019f, 35.497924f, -114.678812f, 35.606492f, -114.653150f,
                35.651132f, -114.689197f, 35.806757f, -114.711442f, 35.850909f, -114.705164f, 35.872349f, -114.662208f, 35.943217f, -114.730521f,
                36.008333f, -114.743174f, 36.026910f, -114.723234f, 36.090705f, -114.753638f, 36.142306f, -114.631716f, 36.150956f, -114.511721f,
                36.128796f, -114.502172f, 36.125970f, -114.446605f, 36.147371f, -114.405475f, 36.143114f, -114.372106f, 36.102724f, -114.329716f
            )
            poly[102] = TzPolygon(
                34.446382f, -114.329716f, 34.348447f, -114.175550f, 34.261939f, -114.130782f, 34.259526f, -114.165133f, 34.187081f, -114.229223f,
                34.138304f, -114.329716f
            )
            poly[103] = TzPolygon(37.000667f, -112.825262f, 37.000191f, -114.050052f, 37.958689f, -114.048396f, 37.958689f, -112.825262f)
            poly[104] = TzPolygon(
                37.958689f, -114.043838f, 36.196659f, -114.043982f, 36.111576f, -114.123144f, 36.023862f, -114.154130f, 36.020193f, -114.252651f,
                36.059494f, -114.315557f, 36.082443f, -114.308430f, 36.102724f, -114.329716f, 37.958689f, -114.329716f
            )
            poly[105] = TzPolygon(
                37.000667f, -112.825262f, 37.001241f, -111.350160f, 36.990246f, -111.402107f, 36.933144f, -111.320808f, 36.966995f, -111.376945f,
                36.946236f, -111.395546f, 36.954151f, -111.438675f, 36.874314f, -111.425088f, 36.873032f, -111.557213f, 36.841702f, -111.545898f,
                36.855499f, -111.600449f, 36.714771f, -111.701080f, 36.670296f, -111.685768f, 36.685810f, -111.724724f, 36.613300f, -111.745621f,
                36.565331f, -111.797348f, 36.551251f, -111.784210f, 36.551289f, -111.809410f, 36.519093f, -111.811783f, 36.504170f, -111.841583f,
                36.450172f, -111.819389f, 36.424374f, -111.858337f, 36.393040f, -111.828102f, 36.368607f, -111.873871f, 36.223370f, -111.801117f,
                36.206963f, -111.759529f, 36.008282f, -111.760162f, 35.979126f, -111.705681f, 35.848061f, -111.722649f, 35.825745f, -111.688690f,
                35.746346f, -111.689018f, 35.746018f, -111.741722f, 35.672962f, -111.740837f, 35.672699f, -111.640633f, 35.641388f, -111.640778f,
                35.640183f, -111.553062f, 35.758530f, -111.531952f, 35.758414f, -111.320808f, 35.226383f, -111.320808f, 35.226383f, -112.825262f
            )
            poly[106] = TzPolygon(
                35.809635f, -110.146202f, 35.809341f, -110.100975f, 35.782558f, -110.102875f, 35.792759f, -110.083420f, 35.702568f, -110.081573f,
                35.692028f, -110.213905f, 35.719730f, -110.236206f
            )
            poly[107] = TzPolygon(
                36.430649f, -111.320808f, 36.430649f, -109.999802f, 35.167602f, -109.999802f, 35.156540f, -111.236458f, 35.497009f, -111.242088f,
                35.572510f, -111.268478f, 35.613194f, -111.317871f, 35.758411f, -111.315582f, 35.758414f, -111.320808f
            )
            poly[108] = TzPolygon(36.933975f, -111.320808f, 36.871849f, -111.231049f, 36.905846f, -111.320808f, 36.933144f, -111.320808f)
            poly[109] = TzPolygon(
                21.090935f, -105.533986f, 20.931792f, -105.323035f, 20.870667f, -105.372315f, 20.854136f, -105.350380f, 20.949437f, -105.232058f,
                20.953800f, -105.109835f, 20.973182f, -105.096655f, 20.986428f, -105.001698f, 20.952914f, -104.957415f, 20.909026f, -104.968822f,
                20.909171f, -105.031613f, 20.934386f, -105.047440f, 20.919434f, -105.098641f, 20.857415f, -105.160563f, 20.767711f, -105.173397f,
                20.777171f, -105.196961f, 20.747351f, -105.239916f, 20.703907f, -105.242773f, 20.647539f, -105.300929f, 20.624302f, -105.403923f,
                20.626920f, -105.572490f, 20.685482f, -105.883254f, 20.799501f, -105.835389f, 20.866533f, -105.727601f
            )
            poly[110] = TzPolygon(
                20.163373f, -104.519534f, 20.163373f, -105.788186f, 20.290646f, -105.884183f, 20.410648f, -105.908205f, 20.488740f, -105.891141f,
                20.554270f, -105.843279f, 20.685482f, -105.883254f, 20.626920f, -105.572490f, 20.634775f, -105.330481f, 20.703907f, -105.242773f,
                20.747351f, -105.239916f, 20.777171f, -105.196961f, 20.767711f, -105.173397f, 20.887167f, -105.141857f, 20.931471f, -105.080337f,
                20.909508f, -104.967244f, 20.946341f, -104.900526f, 21.020009f, -104.838099f, 21.012288f, -104.729989f, 20.983154f, -104.729363f,
                20.943841f, -104.681000f, 20.924152f, -104.556922f, 20.867750f, -104.519534f
            )
            poly[111] = TzPolygon(
                20.867750f, -104.519534f, 21.436715f, -104.519534f, 21.436715f, -103.729129f, 21.425431f, -103.720895f, 21.410304f, -103.764403f,
                21.388433f, -103.767333f, 21.374055f, -103.741332f, 21.336709f, -103.749352f, 21.281041f, -103.820346f, 21.248435f, -103.819391f,
                21.226490f, -103.898363f, 21.262547f, -103.931057f, 21.234572f, -103.924020f, 21.256328f, -103.973454f, 21.194673f, -104.027969f,
                21.205413f, -104.052838f, 21.186773f, -104.068586f, 21.205361f, -104.085659f, 21.176611f, -104.219398f, 21.118601f, -104.210860f,
                21.027332f, -104.242713f, 20.936373f, -104.206588f, 20.887796f, -104.290916f, 20.845496f, -104.295416f, 20.840931f, -104.361768f,
                20.811644f, -104.350402f, 20.784073f, -104.375892f, 20.798098f, -104.328322f, 20.770795f, -104.297617f, 20.783481f, -104.282856f,
                20.713434f, -104.241816f, 20.603221f, -104.254146f, 20.628993f, -104.282011f, 20.689157f, -104.288487f, 20.838187f, -104.499938f
            )
            poly[112] = TzPolygon(
                23.280975f, -105.661076f, 23.280975f, -105.473049f, 23.124277f, -105.473049f, 23.128012f, -105.501978f, 23.098887f, -105.554309f,
                23.141768f, -105.643991f, 23.235581f, -105.630317f, 23.276479f, -105.643208f
            )
            poly[113] = TzPolygon(25.020496f, -107.061817f, 25.025255f, -107.063571f, 25.053139f, -107.129892f, 25.125236f, -107.127206f, 25.125236f, -107.061817f)
            poly[114] = TzPolygon(
                23.280975f, -105.661076f, 23.287520f, -105.687084f, 23.340569f, -105.694005f, 23.374897f, -105.730690f, 23.420171f, -105.700289f,
                23.445206f, -105.738865f, 23.474840f, -105.723445f, 23.502959f, -105.760338f, 23.556465f, -105.769302f, 23.611029f, -105.811644f,
                23.603256f, -105.845516f, 23.583695f, -105.845186f, 23.590394f, -105.884318f, 23.552645f, -105.892655f, 23.588270f, -105.908905f,
                23.684136f, -105.926634f, 23.739399f, -105.906093f, 23.840742f, -105.961265f, 23.908585f, -105.953662f, 23.875243f, -105.867241f,
                23.899296f, -105.857588f, 23.943921f, -105.899919f, 23.948026f, -105.945415f, 23.997534f, -105.912136f, 24.043383f, -105.998720f,
                24.114390f, -105.989724f, 24.203106f, -106.034856f, 24.203106f, -105.473049f, 23.280975f, -105.473049f
            )
            poly[115] = TzPolygon(
                25.020496f, -107.061817f, 24.909908f, -107.021053f, 24.928241f, -107.000575f, 24.880536f, -106.934508f, 24.866624f, -106.927080f,
                24.859024f, -106.951418f, 24.820917f, -106.930662f, 24.822955f, -106.865853f, 24.665262f, -106.705948f, 24.528979f, -106.645461f,
                24.524897f, -106.622607f, 24.506503f, -106.630067f, 24.472711f, -106.560016f, 24.414566f, -106.601588f, 24.286984f, -106.517093f,
                24.277857f, -106.469655f, 24.301941f, -106.367545f, 24.355695f, -106.336330f, 24.374755f, -106.268869f, 24.338786f, -106.151760f,
                24.271389f, -106.075843f, 24.220201f, -106.069948f, 24.220850f, -106.043883f, 24.203106f, -106.034856f, 24.203106f, -107.061817f
            )
            poly[116] = TzPolygon(
                21.565542f, -103.884281f, 21.581986f, -103.919235f, 21.618676f, -103.907699f, 21.641914f, -103.930249f, 21.697818f, -103.887725f,
                21.727744f, -103.895913f, 21.743381f, -103.931828f, 21.771802f, -103.923482f, 21.790451f, -104.130382f, 21.809841f, -104.161748f,
                21.850772f, -104.197000f, 21.871319f, -104.172233f, 21.891478f, -104.201041f, 21.963393f, -104.173699f, 21.985420f, -104.193319f,
                21.966938f, -104.246005f, 22.002761f, -104.294077f, 21.975369f, -104.326863f, 21.976038f, -104.371164f, 22.102564f, -104.373191f,
                22.245359f, -104.328679f, 22.298801f, -104.284496f, 22.356366f, -104.285740f, 22.358845f, -104.289479f, 22.358845f, -103.884281f
            )
            poly[117] = TzPolygon(22.358845f, -104.524205f, 22.358845f, -104.485358f, 22.351617f, -104.481210f, 22.345099f, -104.506377f)
            poly[118] = TzPolygon(
                22.565595f, -104.678665f, 22.568718f, -104.759812f, 22.648711f, -104.793992f, 22.634249f, -104.814677f, 22.648327f, -104.858397f,
                22.607070f, -104.862493f, 22.498727f, -104.987912f, 22.585672f, -105.007553f, 22.656498f, -105.072368f, 22.678414f, -105.068422f,
                22.737409f, -104.892720f, 22.748538f, -104.915637f, 22.819781f, -104.918389f, 22.813605f, -104.958967f, 22.836049f, -104.988405f,
                22.976983f, -105.003139f, 22.941330f, -105.323570f, 23.060575f, -105.350471f, 23.116897f, -105.415892f, 23.124277f, -105.473049f,
                23.280975f, -105.473049f, 23.280975f, -104.678665f
            )
            poly[119] = TzPolygon(
                22.564336f, -104.678665f, 22.565262f, -104.669998f, 22.462155f, -104.655292f, 22.460508f, -104.602561f, 22.411955f, -104.593085f,
                22.358845f, -104.524247f, 22.358845f, -104.678665f
            )
            poly[120] = TzPolygon(
                22.358845f, -104.485358f, 22.376324f, -104.495390f, 22.421659f, -104.371512f, 22.386405f, -104.350041f, 22.365131f, -104.293127f,
                22.358845f, -104.292364f
            )
            poly[121] = TzPolygon(
                22.358845f, -103.884281f, 22.358845f, -104.289479f, 22.401315f, -104.353533f, 22.472989f, -104.296126f, 22.537397f, -104.325824f,
                22.586203f, -104.261407f, 22.645610f, -104.289966f, 22.736539f, -104.266344f, 22.779250f, -104.221141f, 22.757995f, -104.181975f,
                22.766617f, -104.080475f, 22.810311f, -104.111485f, 22.905118f, -104.112644f, 22.924830f, -104.153321f, 22.982445f, -104.173614f,
                23.128408f, -104.172132f, 23.182214f, -104.129023f, 23.280975f, -104.118616f, 23.280975f, -103.884281f
            )
            poly[122] = TzPolygon(
                21.565542f, -103.884281f, 21.552365f, -103.856272f, 21.524750f, -103.859925f, 21.493047f, -103.823713f, 21.498381f, -103.774129f,
                21.436715f, -103.729129f, 21.436715f, -103.884281f
            )
            poly[123] = TzPolygon(
                23.280975f, -104.118616f, 23.351205f, -104.111215f, 23.463493f, -104.065977f, 23.556983f, -103.925313f, 23.589175f, -103.921469f,
                23.579828f, -103.890087f, 23.601871f, -103.906867f, 23.592965f, -103.884281f, 23.280975f, -103.884281f
            )
            poly[124] = TzPolygon(
                25.125236f, -102.295513f, 25.115916f, -102.463325f, 24.999515f, -102.446763f, 25.066637f, -102.669694f, 25.008322f, -102.628885f,
                24.978648f, -102.642955f, 24.978818f, -102.672984f, 24.942752f, -102.673061f, 24.902221f, -102.566236f, 24.709721f, -102.512182f,
                24.428014f, -102.480267f, 24.411169f, -102.606593f, 24.373972f, -102.699904f, 24.376983f, -102.756654f, 24.406248f, -102.788852f,
                24.384692f, -102.831736f, 24.461156f, -102.891880f, 24.428500f, -102.900148f, 24.457704f, -102.967440f, 24.433257f, -102.983573f,
                24.466501f, -103.043150f, 24.401627f, -103.098527f, 24.435198f, -103.165259f, 24.417103f, -103.222833f, 24.447254f, -103.253532f,
                24.428837f, -103.282645f, 24.430488f, -103.419332f, 24.332600f, -103.448340f, 24.287964f, -103.506755f, 24.286371f, -103.568350f,
                24.193789f, -103.559536f, 24.117465f, -103.622007f, 24.110293f, -103.635969f, 24.149326f, -103.660361f, 24.021974f, -103.813274f,
                24.007022f, -103.872386f, 23.964909f, -103.818360f, 23.874616f, -103.853112f, 23.807700f, -103.816198f, 23.752679f, -103.862295f,
                23.679570f, -103.850983f, 23.676516f, -103.785059f, 23.630855f, -103.793542f, 23.613649f, -103.811302f, 23.640082f, -103.849178f,
                23.628970f, -103.877429f, 23.592271f, -103.882522f, 23.592965f, -103.884281f, 25.125236f, -103.884281f
            )
            poly[125] = TzPolygon(22.449519f, -99.252157f, 22.477554f, -99.263872f, 22.477554f, -99.252157f)
            poly[126] = TzPolygon(
                24.512808f, -100.773835f, 24.556186f, -100.799934f, 24.583918f, -100.902234f, 24.542684f, -100.958793f, 24.591185f, -101.080495f,
                24.623362f, -101.127620f, 24.775168f, -101.215039f, 24.813353f, -101.342142f, 24.736757f, -101.461639f, 24.758983f, -101.622270f,
                24.800704f, -101.640767f, 24.789664f, -101.609012f, 24.835563f, -101.601261f, 24.860793f, -101.656332f, 24.840013f, -101.685149f,
                24.875535f, -101.773463f, 25.017624f, -101.848810f, 25.125236f, -102.295513f, 25.125236f, -100.773835f
            )
            poly[127] = TzPolygon(
                22.729605f, -100.012996f, 22.725925f, -100.022343f, 22.751265f, -100.094060f, 22.824394f, -100.029384f, 22.917892f, -100.044239f,
                22.916714f, -100.110384f, 22.975719f, -100.110847f, 22.968757f, -100.089421f, 23.013091f, -100.097455f, 22.997357f, -100.071656f,
                23.039844f, -100.062097f, 23.063095f, -100.012996f
            )
            poly[128] = TzPolygon(
                23.064888f, -100.012996f, 23.095942f, -100.069029f, 23.121156f, -100.068743f, 23.125990f, -100.115597f, 23.231532f, -100.103811f,
                23.250443f, -100.228242f, 23.307108f, -100.206322f, 23.310328f, -100.278379f, 23.260916f, -100.306212f, 23.265317f, -100.374235f,
                23.189021f, -100.363793f, 23.195604f, -100.323538f, 23.162665f, -100.331774f, 23.194326f, -100.479881f, 23.366237f, -100.456791f,
                23.421147f, -100.517143f, 23.528028f, -100.494347f, 23.511158f, -100.458950f, 23.567026f, -100.472450f, 23.568178f, -100.491747f,
                23.696636f, -100.446996f, 23.688910f, -100.466503f, 23.736296f, -100.497707f, 23.798710f, -100.497605f, 23.801395f, -100.500858f,
                23.801395f, -100.012996f
            )
            poly[129] = TzPolygon(23.064888f, -100.012996f, 23.063921f, -100.011252f, 23.063095f, -100.012996f)
            poly[130] = TzPolygon(
                22.729605f, -100.012996f, 22.751667f, -99.956958f, 22.749862f, -99.882397f, 22.730557f, -99.842819f, 22.678435f, -99.847923f,
                22.660766f, -99.814029f, 22.659608f, -99.724085f, 22.681125f, -99.682535f, 22.641220f, -99.560638f, 22.612765f, -99.534692f,
                22.620869f, -99.494536f, 22.744140f, -99.544327f, 22.742053f, -99.479220f, 22.663616f, -99.442053f, 22.670268f, -99.385553f,
                22.629078f, -99.373200f, 22.634888f, -99.329618f, 22.477554f, -99.263872f, 22.477554f, -100.012996f
            )
            poly[131] = TzPolygon(
                24.512808f, -100.773835f, 24.460435f, -100.742324f, 24.491517f, -100.711201f, 24.401300f, -100.603533f, 24.225979f, -100.633068f,
                24.223929f, -100.585085f, 24.178193f, -100.593516f, 24.173944f, -100.613400f, 24.139897f, -100.516820f, 24.118521f, -100.538676f,
                24.071443f, -100.523757f, 23.919641f, -100.562411f, 23.888384f, -100.539837f, 23.842200f, -100.550303f, 23.801395f, -100.500858f,
                23.801395f, -100.773835f
            )
            poly[132] = TzPolygon(25.125236f, -97.595507f, 25.125236f, -97.228502f, 24.979410f, -97.305319f, 25.041955f, -97.517400f)
            poly[133] = TzPolygon(
                22.449519f, -99.252157f, 25.125236f, -99.252157f, 25.125236f, -97.595507f, 25.041955f, -97.517400f, 24.979410f, -97.305319f,
                24.662461f, -97.410828f, 24.314511f, -97.486963f, 23.421640f, -97.544067f, 22.877531f, -97.544115f, 22.560543f, -97.636164f,
                22.420218f, -97.621037f, 22.313607f, -97.574497f, 22.260351f, -97.792415f, 22.206966f, -97.844888f, 22.239131f, -97.917282f,
                22.293892f, -97.956708f, 22.297432f, -98.000324f, 22.328050f, -97.970510f, 22.350864f, -97.990020f, 22.347161f, -98.072781f,
                22.395303f, -98.113536f, 22.423869f, -98.187485f, 22.469559f, -98.194995f, 22.471657f, -98.247931f, 22.447291f, -98.272937f,
                22.468562f, -98.316823f, 22.390740f, -98.318781f, 22.388703f, -98.352272f, 22.407446f, -98.355225f, 22.389284f, -98.387809f,
                22.424293f, -98.388644f, 22.399927f, -98.409543f, 22.432864f, -98.433766f, 22.412192f, -98.460959f, 22.429472f, -98.505040f,
                22.393945f, -98.574935f, 22.414524f, -98.638156f, 22.366313f, -98.758935f, 22.355094f, -98.889997f, 22.392775f, -98.931973f,
                22.415269f, -99.060399f, 22.412862f, -99.236839f
            )
            poly[134] = TzPolygon(
                26.729418f, -99.215680f, 26.729418f, -99.077668f, 26.400223f, -99.077668f, 26.397977f, -99.084530f, 26.432890f, -99.113680f,
                26.475480f, -99.091690f, 26.499260f, -99.104380f, 26.541680f, -99.171040f, 26.724800f, -99.208790f
            )
            poly[135] = TzPolygon(
                26.729418f, -101.262095f, 26.729418f, -99.630095f, 26.670365f, -99.659164f, 26.664596f, -99.538335f, 26.596566f, -99.396825f,
                26.351301f, -99.430946f, 26.304799f, -99.401236f, 26.329270f, -99.364150f, 26.306358f, -99.333667f, 26.252822f, -99.332448f,
                26.139388f, -99.401278f, 25.993512f, -99.334251f, 25.914420f, -99.332288f, 25.925399f, -99.312818f, 25.898677f, -99.296170f,
                25.916133f, -99.265911f, 25.887817f, -99.241249f, 25.895526f, -99.191334f, 25.978378f, -99.171397f, 25.999519f, -99.194641f,
                26.073133f, -99.190903f, 26.053597f, -99.128094f, 26.068582f, -99.131355f, 26.071799f, -99.077668f, 25.125236f, -99.077668f,
                25.125236f, -101.262095f
            )
            poly[136] = TzPolygon(
                28.176561f, -100.169882f, 28.190920f, -100.208560f, 28.232910f, -100.220950f, 28.276300f, -100.291990f, 28.311900f, -100.286370f,
                28.333599f, -100.302489f, 28.333599f, -100.169882f
            )
            poly[137] = TzPolygon(
                28.333599f, -101.262095f, 28.333098f, -100.596915f, 28.231953f, -100.629959f, 28.226969f, -100.669642f, 28.134438f, -100.641997f,
                28.119405f, -100.545554f, 28.066741f, -100.591912f, 28.028624f, -100.538123f, 27.998503f, -100.546631f, 28.005144f, -100.571968f,
                27.974393f, -100.580259f, 27.978203f, -100.601954f, 27.821439f, -100.658516f, 27.730947f, -100.286180f, 27.684599f, -100.350610f,
                27.392685f, -100.421909f, 27.371055f, -100.385777f, 27.340108f, -100.399729f, 27.245413f, -100.283131f, 27.245470f, -100.252726f,
                27.218432f, -100.252757f, 27.218465f, -100.182026f, 27.137164f, -100.171862f, 27.137166f, -100.169882f, 26.729418f, -100.169882f,
                26.729418f, -101.262095f
            )
            poly[138] = TzPolygon(
                26.729418f, -99.215680f, 26.745750f, -99.240050f, 26.843320f, -99.268680f, 26.878630f, -99.328470f, 26.919370f, -99.328460f,
                26.937680f, -99.384490f, 27.010210f, -99.408580f, 27.021600f, -99.445830f, 27.175660f, -99.426200f, 27.250230f, -99.441660f,
                27.263230f, -99.491410f, 27.300420f, -99.491570f, 27.316850f, -99.538070f, 27.339220f, -99.504230f, 27.479380f, -99.478720f,
                27.498160f, -99.528100f, 27.531508f, -99.521371f, 27.531508f, -99.077668f, 26.729418f, -99.077668f
            )
            poly[139] = TzPolygon(
                27.137166f, -100.169882f, 27.137215f, -100.121473f, 27.101066f, -100.121314f, 27.101117f, -100.101018f, 27.028904f, -100.121326f,
                27.028914f, -100.090843f, 27.008686f, -100.090800f, 27.024427f, -100.012000f, 27.008824f, -99.959846f, 26.956230f, -100.019211f,
                26.846425f, -99.968660f, 26.873775f, -99.936141f, 26.858309f, -99.929156f, 26.888278f, -99.849232f, 26.871581f, -99.804021f,
                26.886714f, -99.810009f, 26.912156f, -99.744346f, 26.890694f, -99.630806f, 26.829475f, -99.580842f, 26.729418f, -99.630095f,
                26.729418f, -100.169882f
            )
            poly[140] = TzPolygon(
                28.176561f, -100.169882f, 28.144840f, -100.084440f, 27.993510f, -99.990440f, 27.980620f, -99.931380f, 27.941500f, -99.937500f,
                27.899070f, -99.893360f, 27.797560f, -99.876260f, 27.763150f, -99.835870f, 27.774450f, -99.813340f, 27.657690f, -99.710500f,
                27.659220f, -99.667100f, 27.626700f, -99.639120f, 27.639690f, -99.596020f, 27.603060f, -99.583540f, 27.614400f, -99.554800f,
                27.566550f, -99.511810f, 27.531508f, -99.520157f, 27.531508f, -100.169882f
            )
            poly[141] = TzPolygon(
                25.927327f, -98.584548f, 25.927327f, -97.999794f, 25.439381f, -97.999794f, 25.425929f, -98.058666f, 25.446437f, -98.058691f,
                25.445959f, -98.239454f, 25.504373f, -98.262637f, 25.460292f, -98.328027f, 25.458482f, -98.374614f, 25.489787f, -98.377552f,
                25.496790f, -98.432247f, 25.489362f, -98.581751f
            )
            poly[142] = TzPolygon(
                26.060184f, -97.999794f, 26.067050f, -98.027660f, 26.041290f, -98.038840f, 26.036340f, -98.076550f, 26.071180f, -98.080420f,
                26.074200f, -98.132130f, 26.049080f, -98.146520f, 26.075270f, -98.176840f, 26.053390f, -98.194920f, 26.104460f, -98.288210f,
                26.120910f, -98.266400f, 26.103180f, -98.305760f, 26.166160f, -98.335910f, 26.157730f, -98.386520f, 26.200430f, -98.443820f,
                26.224440f, -98.444580f, 26.219890f, -98.481310f, 26.200900f, -98.481830f, 26.235780f, -98.522400f, 26.225440f, -98.534880f,
                26.248120f, -98.556250f, 26.224140f, -98.561470f, 26.256810f, -98.583140f, 26.259950f, -98.622920f, 26.236710f, -98.670100f,
                26.262830f, -98.680990f, 26.272730f, -98.719880f, 26.287280f, -98.702910f, 26.295680f, -98.750560f, 26.330910f, -98.750320f,
                26.330680f, -98.789100f, 26.368080f, -98.805540f, 26.353160f, -98.896530f, 26.394360f, -98.926280f, 26.369380f, -98.943610f,
                26.401170f, -98.973870f, 26.392330f, -99.011250f, 26.413510f, -99.037080f, 26.400223f, -99.077668f, 26.729418f, -99.077668f,
                26.729418f, -97.999794f
            )
            poly[143] = TzPolygon(
                26.071799f, -99.077668f, 26.104057f, -99.023971f, 25.968323f, -98.900752f, 26.047649f, -98.823226f, 26.017918f, -98.585126f,
                25.927327f, -98.584548f, 25.927327f, -99.077668f
            )
            poly[144] = TzPolygon(
                26.060184f, -97.999794f, 26.729418f, -97.999794f, 26.729418f, -97.093120f, 26.333947f, -96.975299f, 26.092049f, -96.924648f,
                25.975653f, -96.924030f, 25.949020f, -97.157130f, 25.965930f, -97.175370f, 25.959430f, -97.284000f, 25.935230f, -97.276660f,
                25.915310f, -97.368890f, 25.867330f, -97.356610f, 25.837060f, -97.394230f, 25.862150f, -97.408600f, 25.840840f, -97.412880f,
                25.853890f, -97.453850f, 25.884230f, -97.455880f, 25.886930f, -97.522270f, 25.930720f, -97.537180f, 25.933020f, -97.582970f,
                25.952440f, -97.567900f, 25.957190f, -97.601940f, 25.990340f, -97.634550f, 26.002720f, -97.618650f, 26.010530f, -97.649240f,
                26.023190f, -97.639030f, 26.019270f, -97.667990f, 26.038150f, -97.662600f, 26.018900f, -97.691520f, 26.037850f, -97.707260f,
                26.025660f, -97.761430f, 26.047320f, -97.767680f, 26.029160f, -97.777450f, 26.060250f, -97.801110f, 26.045850f, -97.834560f,
                26.070160f, -97.861610f, 26.051730f, -97.965480f
            )
            poly[145] = TzPolygon(
                25.439381f, -97.999794f, 25.444071f, -97.979270f, 25.425992f, -97.979277f, 25.425991f, -97.949462f, 25.381327f, -97.949385f,
                25.375792f, -97.899803f, 25.396303f, -97.877987f, 25.346776f, -97.803283f, 25.125236f, -97.595507f, 25.125236f, -97.999794f
            )
            poly[146] = TzPolygon(
                28.333599f, -100.302489f, 28.390140f, -100.344490f, 28.442510f, -100.337440f, 28.476360f, -100.368360f, 28.499290f, -100.333890f,
                28.515280f, -100.388530f, 28.550070f, -100.411090f, 28.585310f, -100.398700f, 28.609380f, -100.447310f, 28.641850f, -100.446460f,
                28.661954f, -100.500474f, 28.805220f, -100.535220f, 28.828190f, -100.574340f, 28.901320f, -100.600700f, 28.914850f, -100.640910f,
                29.100380f, -100.674590f, 29.168350f, -100.772640f, 29.195280f, -100.766820f, 29.263600f, -100.813790f, 29.280580f, -100.877800f,
                29.307590f, -100.886290f, 29.368310f, -101.009890f, 29.458581f, -101.059875f, 29.475390f, -101.148530f, 29.515992f, -101.176844f,
                29.522332f, -101.256804f, 29.623352f, -101.248643f, 29.621589f, -101.262095f, 31.541963f, -101.262095f, 31.541963f, -96.893242f,
                28.333599f, -96.893242f
            )
            poly[147] = TzPolygon(
                28.388718f, -101.262095f, 28.376462f, -101.215787f, 28.400328f, -100.962720f, 28.432214f, -100.938136f, 28.453480f, -100.868834f,
                28.424450f, -100.808265f, 28.380950f, -100.809663f, 28.377465f, -100.612040f, 28.333599f, -100.597086f, 28.333599f, -101.262095f
            )
            poly[148] = TzPolygon(
                42.449100f, -117.975222f, 42.448522f, -118.215030f, 44.212483f, -118.233641f, 44.256083f, -118.232140f, 44.270682f, -118.152639f,
                44.299583f, -118.152340f, 44.328683f, -118.092239f, 44.415183f, -118.031442f, 44.441623f, -117.975222f
            )
            poly[149] = TzPolygon(41.998206f, -117.009258f, 41.998206f, -111.596724f, 41.989104f, -113.796082f, 41.998127f, -117.009255f)
            poly[150] = TzPolygon(
                37.958689f, -114.048396f, 40.726167f, -114.043613f, 40.725489f, -114.112847f, 40.755668f, -114.112976f, 40.755583f, -114.043787f,
                41.993725f, -114.041735f, 41.998206f, -112.055845f, 41.998206f, -111.043564f, 37.958689f, -111.043564f
            )
            poly[151] = TzPolygon(42.449100f, -117.975222f, 42.451386f, -117.026585f, 41.999890f, -117.026197f, 41.998206f, -116.210977f, 41.998206f, -117.975222f)
            poly[152] = TzPolygon(
                45.027844f, -117.975222f, 45.027844f, -116.842641f, 45.022184f, -116.848241f, 44.977287f, -116.857775f, 44.983586f, -116.825925f,
                44.887449f, -116.852490f, 44.783881f, -116.934700f, 44.727143f, -117.062273f, 44.536151f, -117.149242f, 44.482346f, -117.225076f,
                44.427161f, -117.215068f, 44.390974f, -117.243032f, 44.336585f, -117.189769f, 44.313024f, -117.203323f, 44.301420f, -117.486153f,
                44.387696f, -117.485899f, 44.415491f, -117.569880f, 44.444461f, -117.590992f, 44.443328f, -117.971596f, 44.441623f, -117.975222f
            )
            poly[153] = TzPolygon(
                45.027844f, -116.842641f, 45.142091f, -116.729607f, 45.321511f, -116.673793f, 45.602785f, -116.463635f, 45.691734f, -116.535396f,
                45.752735f, -116.549085f, 45.778541f, -116.593004f, 45.781998f, -116.665344f, 45.826267f, -116.711822f, 45.816167f, -116.759787f,
                45.833471f, -116.789066f, 45.897457f, -116.728745f, 45.966591f, -116.744606f, 45.999191f, -116.698494f, 45.995495f, -116.646637f,
                46.037723f, -116.624678f, 46.008703f, -116.618920f, 45.973879f, -116.548728f, 45.965206f, -116.447740f, 45.913085f, -116.428483f,
                45.889411f, -116.329110f, 45.858297f, -116.295897f, 45.743131f, -116.326849f, 45.729009f, -116.302297f, 45.669580f, -116.319038f,
                45.665777f, -116.280340f, 45.624209f, -116.304596f, 45.599579f, -116.272220f, 45.570729f, -116.305819f, 45.411253f, -116.310825f,
                45.422497f, -116.283944f, 45.409289f, -116.242308f, 45.027844f, -116.242308f
            )
            poly[154] = TzPolygon(
                45.409289f, -116.242308f, 45.399042f, -116.210006f, 45.427701f, -116.143235f, 45.403502f, -116.093058f, 45.459824f, -115.929634f,
                45.468106f, -115.801938f, 45.375652f, -115.509351f, 45.456062f, -115.430206f, 45.475202f, -115.354640f, 45.523603f, -115.314175f,
                45.569747f, -115.214077f, 45.492904f, -114.982064f, 45.393282f, -114.813764f, 45.394949f, -114.736576f, 45.440014f, -114.795133f,
                45.512612f, -114.787738f, 45.471015f, -114.664329f, 45.557710f, -114.564936f, 45.562198f, -114.509393f, 44.017964f, -114.509393f,
                44.017964f, -116.242308f
            )
            poly[155] = TzPolygon(45.560021f, -114.509393f, 45.557710f, -114.564936f, 45.606592f, -114.537944f, 45.637621f, -114.563987f, 45.656918f, -114.509393f)
            poly[156] = TzPolygon(45.717820f, -114.509393f, 45.773310f, -114.566465f, 45.845373f, -114.509393f)
            poly[157] = TzPolygon(41.998206f, -112.055845f, 42.000484f, -111.046280f, 44.017964f, -111.048477f, 44.017964f, -111.043564f, 41.998206f, -111.043564f)
            poly[158] = TzPolygon(
                45.027844f, -113.449499f, 45.027844f, -112.776478f, 44.486011f, -112.776478f, 44.484660f, -112.780810f, 44.424714f, -112.839890f,
                44.377142f, -112.812208f, 44.359588f, -112.854267f, 44.405938f, -112.889557f, 44.452827f, -113.004506f, 44.495512f, -113.026824f,
                44.525776f, -113.006530f, 44.599663f, -113.088292f, 44.634542f, -113.050722f, 44.772758f, -113.131459f, 44.822973f, -113.246894f,
                44.784664f, -113.341276f, 44.835239f, -113.377567f, 44.865424f, -113.455071f, 44.942203f, -113.498818f, 44.959380f, -113.443939f
            )
            poly[159] = TzPolygon(
                45.562198f, -114.509393f, 45.565223f, -114.471946f, 45.509911f, -114.424683f, 45.459722f, -114.330047f, 45.484552f, -114.269892f,
                45.545813f, -114.248450f, 45.536372f, -114.193608f, 45.591464f, -114.086102f, 45.652766f, -114.015270f, 45.695901f, -114.015482f,
                45.695565f, -113.937462f, 45.622007f, -113.904691f, 45.601630f, -113.806431f, 45.520657f, -113.834778f, 45.520621f, -113.766022f,
                45.408477f, -113.776043f, 45.390811f, -113.733475f, 45.329409f, -113.738661f, 45.278886f, -113.680279f, 45.262503f, -113.691887f,
                45.184779f, -113.592133f, 45.123851f, -113.569884f, 45.116129f, -113.511249f, 45.091388f, -113.522187f, 45.059174f, -113.452044f,
                45.027844f, -113.449499f, 45.027844f, -114.509393f
            )
            poly[160] = TzPolygon(
                46.037723f, -114.503066f, 46.031464f, -114.507504f, 46.030349f, -114.480347f, 45.992902f, -114.479992f, 45.977870f, -114.411755f,
                45.936040f, -114.431396f, 45.883926f, -114.387868f, 45.851573f, -114.409654f, 45.845373f, -114.509393f, 46.037723f, -114.509393f
            )
            poly[161] = TzPolygon(45.717820f, -114.509393f, 45.703970f, -114.495148f, 45.657535f, -114.507646f, 45.656918f, -114.509393f)
            poly[162] = TzPolygon(
                44.486011f, -112.776478f, 44.504273f, -112.717930f, 44.462766f, -112.500642f, 44.479297f, -112.472687f, 44.447308f, -112.386524f,
                44.538021f, -112.352509f, 44.568559f, -112.286568f, 44.520569f, -112.106400f, 44.566621f, -111.869319f, 44.508941f, -111.821530f,
                44.560148f, -111.703164f, 44.538951f, -111.468002f, 44.604553f, -111.525678f, 44.643997f, -111.516310f, 44.666190f, -111.472483f,
                44.705643f, -111.488784f, 44.710739f, -111.414273f, 44.754954f, -111.384824f, 44.729548f, -111.324378f, 44.667512f, -111.266804f,
                44.651265f, -111.278477f, 44.622521f, -111.219319f, 44.614525f, -111.240889f, 44.576687f, -111.227631f, 44.532429f, -111.131382f,
                44.497620f, -111.127383f, 44.474072f, -111.048974f, 44.017964f, -111.047565f, 44.017964f, -112.776478f
            )
            poly[163] = TzPolygon(
                46.037723f, -124.253042f, 46.069884f, -124.233775f, 46.130190f, -124.314789f, 46.231659f, -124.373345f, 46.543051f, -124.353284f,
                46.789352f, -124.394747f, 46.895178f, -124.469131f, 47.155984f, -124.493524f, 47.381145f, -124.682064f, 47.522715f, -124.680650f,
                47.599851f, -124.767041f, 47.697041f, -124.789722f, 47.775106f, -124.890912f, 47.918860f, -125.008005f, 48.048003f, -125.017077f,
                48.184511f, -125.084094f, 48.307783f, -125.021213f, 48.384212f, -125.046421f, 48.459790f, -125.028928f, 48.495179f, -125.003617f,
                48.503672f, -124.915809f, 48.493444f, -124.727250f, 48.296667f, -124.012056f, 48.240000f, -123.679056f, 48.224556f, -123.541222f,
                48.284028f, -123.248444f, 48.422833f, -123.115139f, 48.548722f, -123.218944f, 48.694000f, -123.267889f, 48.767111f, -123.008500f,
                48.831222f, -123.008500f, 49.002072f, -123.322240f, 49.001597f, -120.508865f, 46.037723f, -120.508865f
            )
            poly[164] = TzPolygon(49.000013f, -118.142540f, 49.000954f, -120.508865f, 49.527092f, -120.508865f, 49.527092f, -118.142540f)
            poly[165] = TzPolygon(47.739643f, -115.776215f, 47.757334f, -115.797498f, 47.755036f, -115.830910f, 47.782407f, -115.838954f, 47.782407f, -115.776215f)
            poly[166] = TzPolygon(
                47.782407f, -115.776215f, 47.782407f, -115.838954f, 47.827857f, -115.852312f, 47.853620f, -115.918885f, 47.976842f, -116.049108f,
                49.000845f, -116.049232f, 49.000823f, -115.776215f
            )
            poly[167] = TzPolygon(
                49.000636f, -115.776215f, 49.000873f, -116.026933f, 49.199791f, -116.027056f, 49.200096f, -116.097580f, 49.260965f, -116.066537f,
                49.292839f, -116.104873f, 49.289447f, -116.168980f, 49.366738f, -116.160073f, 49.421277f, -116.238356f, 49.523009f, -116.297379f,
                49.515337f, -116.361749f, 49.527092f, -116.394144f, 49.527092f, -115.776215f
            )
            poly[168] = TzPolygon(49.527092f, -116.433699f, 49.492916f, -116.465347f, 49.457535f, -116.557321f, 49.472428f, -116.662892f, 49.527092f, -116.627919f)
            poly[169] = TzPolygon(
                49.001198f, -118.142540f, 49.000845f, -116.049232f, 47.976842f, -116.049108f, 47.853620f, -115.918885f, 47.827857f, -115.852312f,
                47.782407f, -115.838954f, 47.782407f, -118.142540f
            )
            poly[170] = TzPolygon(
                49.000013f, -118.142540f, 49.527092f, -118.142540f, 49.527092f, -116.813730f, 49.348400f, -116.760300f, 49.271900f, -116.683700f,
                49.177500f, -116.830200f, 49.213500f, -116.861000f, 49.182600f, -116.940100f, 49.149900f, -116.940200f, 49.167300f, -116.988900f,
                49.155800f, -117.039200f, 49.059400f, -117.038600f, 49.064000f, -116.909500f, 49.037500f, -116.886300f, 48.999528f, -116.921458f
            )
            poly[171] = TzPolygon(51.776200f, -118.142540f, 51.786500f, -118.184600f, 51.852215f, -118.142540f)
            poly[172] = TzPolygon(
                51.896556f, -118.142540f, 51.895800f, -118.159000f, 51.950400f, -118.192600f, 51.986800f, -118.288100f, 51.980800f, -118.389500f,
                52.031100f, -118.400400f, 52.012600f, -118.438900f, 52.054500f, -118.512000f, 52.054100f, -118.588400f, 52.104900f, -118.607000f,
                52.149966f, -118.677906f, 52.189168f, -118.579368f, 52.290461f, -118.544295f, 52.287695f, -118.502246f, 52.310741f, -118.494032f,
                52.334744f, -118.389253f, 52.364032f, -118.357355f, 52.361045f, -118.306694f, 52.332877f, -118.296382f, 52.384621f, -118.219630f,
                52.443856f, -118.252459f, 52.485118f, -118.198350f, 52.504579f, -118.263188f, 52.539208f, -118.290633f, 52.564545f, -118.271993f,
                52.577725f, -118.328762f, 52.615241f, -118.356640f, 52.678963f, -118.288358f, 52.709582f, -118.344445f, 52.737868f, -118.328466f,
                52.773778f, -118.418889f, 52.847163f, -118.384140f, 52.855392f, -118.453112f, 52.886945f, -118.453059f, 52.905830f, -118.498212f,
                52.881268f, -118.615493f, 52.935640f, -118.610602f, 52.978385f, -118.672863f, 52.998701f, -118.640158f, 53.016461f, -118.648599f,
                53.016461f, -118.142540f
            )
            poly[173] = TzPolygon(
                50.808455f, -116.959377f, 50.814770f, -117.039935f, 50.858427f, -117.045993f, 50.861598f, -117.085543f, 50.958134f, -117.039984f,
                50.980840f, -117.167425f, 51.022617f, -117.135796f, 51.066500f, -117.217300f, 51.271777f, -117.326945f, 51.271777f, -116.959377f
            )
            poly[174] = TzPolygon(
                49.527092f, -116.813730f, 49.589200f, -116.832300f, 49.637700f, -116.911100f, 49.809200f, -116.869700f, 49.798000f, -116.719900f,
                49.814500f, -116.705800f, 49.737174f, -116.586983f, 49.696965f, -116.588644f, 49.641902f, -116.677949f, 49.627647f, -116.644628f,
                49.573010f, -116.685648f, 49.536360f, -116.621989f, 49.527092f, -116.627894f
            )
            poly[175] = TzPolygon(49.527092f, -116.433699f, 49.537835f, -116.423751f, 49.527092f, -116.394144f)
            poly[176] = TzPolygon(
                50.808455f, -116.959377f, 50.771388f, -116.884687f, 50.784988f, -116.813401f, 50.735411f, -116.821000f, 50.678786f, -116.749901f,
                50.678398f, -116.657584f, 50.641557f, -116.578436f, 50.597275f, -116.655905f, 50.466497f, -116.718835f, 50.410002f, -116.640500f,
                50.317287f, -116.620543f, 50.319355f, -116.542133f, 50.216599f, -116.561653f, 50.155409f, -116.452936f, 50.065647f, -116.499981f,
                49.987453f, -116.442456f, 49.965879f, -116.461073f, 49.986438f, -116.511892f, 49.953028f, -116.580360f, 49.887545f, -116.633889f,
                49.876084f, -116.695151f, 49.802979f, -116.679400f, 49.809200f, -116.869700f, 49.637700f, -116.911100f, 49.589200f, -116.832300f,
                49.527092f, -116.813730f, 49.527092f, -116.959377f
            )
            poly[177] = TzPolygon(51.896556f, -118.142540f, 51.897900f, -118.113300f, 51.852215f, -118.142540f)
            poly[178] = TzPolygon(
                51.776200f, -118.142540f, 51.773300f, -118.130700f, 51.732600f, -118.109700f, 51.721400f, -118.031700f, 51.748600f, -118.012600f,
                51.722100f, -117.943000f, 51.656000f, -117.913300f, 51.623800f, -117.980100f, 51.530500f, -117.940300f, 51.473200f, -117.976000f,
                51.451400f, -117.923700f, 51.488200f, -117.847500f, 51.453200f, -117.815800f, 51.418300f, -117.717400f, 51.467100f, -117.432000f,
                51.412200f, -117.420400f, 51.401700f, -117.373600f, 51.367700f, -117.361800f, 51.361100f, -117.249300f, 51.329200f, -117.201200f,
                51.300000f, -117.235100f, 51.273500f, -117.217300f, 51.283300f, -117.333100f, 51.271777f, -117.326945f, 51.271777f, -118.142540f
            )
            poly[179] = TzPolygon(49.000636f, -115.776215f, 53.016461f, -115.776215f, 53.016461f, -111.043564f, 48.997664f, -111.043564f, 48.996667f, -111.575694f)
            poly[180] = TzPolygon(
                47.739643f, -115.776215f, 47.695118f, -115.722648f, 47.653811f, -115.736508f, 47.595300f, -115.687758f, 47.547933f, -115.755620f,
                47.531375f, -115.698314f, 47.484940f, -115.686264f, 47.479610f, -115.629488f, 47.423862f, -115.759304f, 47.367404f, -115.577639f,
                47.299244f, -115.528509f, 47.281444f, -115.482264f, 47.256684f, -115.319786f, 47.188334f, -115.300577f, 47.101911f, -115.144130f,
                46.970036f, -115.048789f, 46.971901f, -115.001274f, 46.918681f, -114.925143f, 46.860009f, -114.948261f, 46.801630f, -114.895189f,
                46.814529f, -114.865779f, 46.782711f, -114.829306f, 46.780145f, -114.784904f, 46.696902f, -114.766786f, 46.739234f, -114.665376f,
                46.707262f, -114.620787f, 46.672912f, -114.642563f, 46.635900f, -114.605732f, 46.649992f, -114.541822f, 46.631801f, -114.466834f,
                46.671138f, -114.358224f, 46.653417f, -114.324615f, 46.519652f, -114.342016f, 46.498811f, -114.403184f, 46.436795f, -114.368527f,
                46.387046f, -114.422447f, 46.283766f, -114.427289f, 46.266041f, -114.470720f, 46.169273f, -114.444091f, 46.167680f, -114.514858f,
                46.145411f, -114.527359f, 46.097790f, -114.460475f, 46.037723f, -114.503066f, 46.037723f, -115.776215f
            )
            poly[181] = TzPolygon(49.000441f, -111.043564f, 49.000262f, -108.824497f, 37.958689f, -108.824497f, 37.958689f, -111.043564f)
            poly[182] = TzPolygon(
                48.999483f, -108.824497f, 48.999609f, -110.005078f, 52.667270f, -110.005465f, 52.675360f, -109.440797f, 52.696460f, -109.440597f,
                52.696660f, -109.396297f, 52.739960f, -109.396397f, 52.739860f, -109.312397f, 52.820260f, -109.323897f, 52.820160f, -109.251297f,
                52.929661f, -109.252297f, 52.935861f, -109.130497f, 52.885460f, -109.130797f, 52.885360f, -109.009697f, 52.804660f, -109.009397f,
                52.804260f, -108.888597f, 52.929261f, -108.912897f, 52.929361f, -108.888397f, 53.016461f, -108.888497f, 53.016461f, -108.824497f
            )
            poly[183] = TzPolygon(60.001555f, -129.974167f, 60.001555f, -129.932869f, 59.998637f, -129.932869f, 59.998620f, -129.974167f)
            poly[184] = TzPolygon(63.201980f, -129.932869f, 63.190038f, -129.974167f, 63.201980f, -129.974167f)
            poly[185] = TzPolygon(
                57.500087f, -124.290734f, 57.499693f, -124.309273f, 57.516526f, -124.298417f, 57.551822f, -124.407750f, 57.648435f, -124.449058f,
                57.684766f, -124.592565f, 57.665623f, -124.605847f, 57.739478f, -124.763796f, 57.723380f, -124.790544f, 57.822323f, -124.885614f,
                57.836473f, -124.944816f, 57.979296f, -124.913315f, 58.000000f, -124.942122f, 58.000000f, -124.290734f
            )
            poly[186] = TzPolygon(
                54.609562f, -121.469667f, 54.651573f, -121.531422f, 54.725058f, -121.474411f, 54.796900f, -121.525390f, 54.888683f, -121.731934f,
                54.841374f, -121.783560f, 54.867867f, -121.872446f, 54.927442f, -121.848671f, 55.006678f, -121.945442f, 55.099977f, -122.107156f,
                55.099358f, -122.173484f, 55.137837f, -122.192281f, 55.131633f, -122.265848f, 55.171451f, -122.294529f, 55.191848f, -122.247787f,
                55.210211f, -122.262707f, 55.227090f, -122.332827f, 55.315386f, -122.431956f, 55.315093f, -122.486368f, 55.408543f, -122.595507f,
                55.335409f, -122.677471f, 55.380355f, -122.792078f, 55.378117f, -122.853772f, 55.420145f, -122.890478f, 55.402029f, -122.994077f,
                55.462939f, -122.999615f, 55.460728f, -122.932832f, 55.501073f, -122.966086f, 55.508230f, -122.962461f, 55.508230f, -121.469667f
            )
            poly[187] = TzPolygon(
                56.754115f, -124.290734f, 56.754115f, -123.784835f, 56.740579f, -123.764521f, 56.685251f, -123.761567f, 56.651708f, -123.664181f,
                56.589994f, -123.670062f, 56.569416f, -123.741461f, 56.534067f, -123.678057f, 56.509162f, -123.698476f, 56.512687f, -123.604406f,
                56.463774f, -123.553875f, 56.413104f, -123.559602f, 56.384363f, -123.634151f, 56.352997f, -123.618851f, 56.354077f, -123.568948f,
                56.321116f, -123.529377f, 56.319171f, -123.569541f, 56.258324f, -123.574784f, 56.203269f, -123.487451f, 56.177603f, -123.513816f,
                56.029904f, -123.448476f, 55.968118f, -123.478223f, 55.939265f, -123.428016f, 55.883908f, -123.453080f, 55.860694f, -123.367078f,
                55.835225f, -123.385219f, 55.797587f, -123.316687f, 55.756780f, -123.310986f, 55.742275f, -123.350080f, 55.713065f, -123.330306f,
                55.698971f, -123.259977f, 55.738808f, -123.160278f, 55.693927f, -123.125509f, 55.641474f, -123.150716f, 55.625635f, -123.073132f,
                55.584715f, -123.079741f, 55.559763f, -123.037867f, 55.583635f, -122.967799f, 55.569548f, -122.931404f, 55.508230f, -122.962461f,
                55.508230f, -124.290734f
            )
            poly[188] = TzPolygon(
                57.500087f, -124.290734f, 57.502457f, -124.179184f, 57.455189f, -124.183588f, 57.449636f, -124.122223f, 57.404765f, -124.134182f,
                57.319517f, -124.075250f, 57.294044f, -124.180698f, 57.264720f, -124.188497f, 57.204084f, -124.094305f, 57.163792f, -124.083458f,
                57.163211f, -124.038763f, 57.104594f, -123.940030f, 57.055017f, -123.923670f, 57.045236f, -123.973385f, 57.013821f, -123.983490f,
                56.994375f, -123.898045f, 56.938183f, -123.889162f, 56.925831f, -123.817463f, 56.893254f, -123.852654f, 56.809357f, -123.769783f,
                56.769287f, -123.807603f, 56.754115f, -123.784835f, 56.754115f, -124.290734f
            )
            poly[189] = TzPolygon(
                54.609562f, -121.469667f, 54.566114f, -121.405799f, 54.533009f, -121.398970f, 54.539964f, -121.363540f, 54.512274f, -121.315076f,
                54.517307f, -121.270480f, 54.553350f, -121.251945f, 54.549179f, -121.127353f, 54.484455f, -121.130910f, 54.449283f, -121.075100f,
                54.472775f, -121.066068f, 54.452714f, -121.044504f, 54.465825f, -121.003519f, 54.449591f, -120.935729f, 54.461752f, -120.881575f,
                54.490958f, -120.877018f, 54.493932f, -120.825910f, 54.471601f, -120.792051f, 54.402535f, -120.786132f, 54.409204f, -120.733983f,
                54.358546f, -120.659741f, 54.299221f, -120.729893f, 54.277301f, -120.591339f, 54.212813f, -120.561853f, 54.177733f, -120.587031f,
                54.144836f, -120.551624f, 54.104937f, -120.329175f, 54.116807f, -120.183039f, 54.046444f, -120.176987f, 54.029607f, -120.207310f,
                54.040745f, -120.235835f, 53.981655f, -120.263416f, 53.974365f, -120.207471f, 53.934123f, -120.195457f, 53.978469f, -120.136553f,
                53.979505f, -120.077971f, 53.901899f, -120.068654f, 53.894953f, -120.059133f, 53.016461f, -120.059133f, 53.016461f, -121.469667f
            )
            poly[190] = TzPolygon(
                53.894953f, -120.059133f, 55.508230f, -120.059133f, 55.508230f, -120.005964f, 53.796623f, -120.009187f, 53.826173f, -120.050849f,
                53.863339f, -120.015798f
            )
            poly[191] = TzPolygon(
                53.016461f, -118.648599f, 53.034386f, -118.657119f, 53.058119f, -118.731233f, 53.046366f, -118.778164f, 53.113450f, -118.729147f,
                53.236820f, -118.948138f, 53.223281f, -119.025825f, 53.205269f, -118.993313f, 53.162950f, -119.030079f, 53.141323f, -118.994030f,
                53.123837f, -119.027356f, 53.190957f, -119.147879f, 53.195370f, -119.228791f, 53.176646f, -119.261305f, 53.359374f, -119.390954f,
                53.348927f, -119.447432f, 53.384764f, -119.605757f, 53.363171f, -119.606564f, 53.370171f, -119.680946f, 53.429392f, -119.767044f,
                53.491508f, -119.784937f, 53.518526f, -119.835438f, 53.500232f, -119.865523f, 53.516435f, -119.901082f, 53.553155f, -119.861881f,
                53.614537f, -119.921757f, 53.589973f, -119.770267f, 53.612598f, -119.716458f, 53.703248f, -119.792713f, 53.711566f, -119.912208f,
                53.776398f, -119.888731f, 53.798712f, -120.001273f, 55.508230f, -120.001292f, 55.508230f, -118.648599f
            )
            poly[192] = TzPolygon(55.508230f, -118.648599f, 55.508230f, -120.001292f, 58.000000f, -120.001319f, 58.000000f, -118.648599f)
            poly[193] = TzPolygon(
                59.134960f, -127.111802f, 59.132744f, -127.141734f, 59.197095f, -127.194471f, 59.218994f, -127.164005f, 59.260890f, -127.227862f,
                59.329319f, -127.179103f, 59.342593f, -127.205980f, 59.308087f, -127.310661f, 59.364413f, -127.332888f, 59.354323f, -127.392039f,
                59.408338f, -127.376578f, 59.416795f, -127.465680f, 59.512000f, -127.477920f, 59.524209f, -127.501076f, 59.507448f, -127.540002f,
                59.562730f, -127.553902f, 59.626277f, -127.742770f, 59.758374f, -127.818283f, 59.797371f, -127.813098f, 59.816325f, -127.738828f,
                59.828759f, -127.765922f, 59.839404f, -127.734219f, 60.001447f, -127.734219f, 60.001586f, -127.111802f
            )
            poly[194] = TzPolygon(60.600990f, -129.932869f, 60.600990f, -127.111802f, 59.999812f, -127.111802f, 59.998637f, -129.932869f)
            poly[195] = TzPolygon(
                62.084156f, -128.522335f, 62.141059f, -128.597625f, 62.111014f, -128.632946f, 62.133021f, -128.682743f, 62.101634f, -128.713194f,
                62.099735f, -128.762459f, 62.048279f, -128.774238f, 62.072238f, -128.804039f, 62.058904f, -128.856075f, 62.088321f, -128.825743f,
                62.121495f, -128.893622f, 62.098094f, -128.939848f, 62.128740f, -128.999833f, 62.106751f, -129.137352f, 62.150810f, -129.281073f,
                62.212151f, -129.200479f, 62.269447f, -129.304358f, 62.317173f, -129.316514f, 62.370281f, -129.257695f, 62.369418f, -129.216628f,
                62.396224f, -129.313901f, 62.451104f, -129.268522f, 62.463767f, -129.178176f, 62.487925f, -129.181481f, 62.534214f, -129.356156f,
                62.584692f, -129.426396f, 62.574034f, -129.558339f, 62.633154f, -129.484114f, 62.708855f, -129.621296f, 62.826890f, -129.693888f,
                62.873125f, -129.785333f, 62.895744f, -129.765795f, 62.891367f, -129.710237f, 62.922406f, -129.740677f, 63.043350f, -129.602501f,
                63.079622f, -129.628897f, 63.063638f, -129.709518f, 63.083287f, -129.845781f, 63.128604f, -129.829297f, 63.138125f, -129.888985f,
                63.201980f, -129.932869f, 63.201980f, -128.522335f
            )
            poly[196] = TzPolygon(61.098579f, -127.111802f, 61.128763f, -127.122044f, 61.132862f, -127.111802f)
            poly[197] = TzPolygon(
                61.375065f, -127.111802f, 61.386643f, -127.135873f, 61.462900f, -127.139774f, 61.469889f, -127.222032f, 61.511903f, -127.277600f,
                61.495980f, -127.519343f, 61.539847f, -127.655194f, 61.595701f, -127.697716f, 61.608125f, -127.798063f, 61.685714f, -127.893347f,
                61.750643f, -128.072204f, 61.793776f, -128.053860f, 61.809614f, -127.994068f, 61.844229f, -128.019165f, 61.865864f, -128.073338f,
                61.861287f, -128.158830f, 61.841081f, -128.180799f, 61.854643f, -128.215617f, 61.936793f, -128.256095f, 61.951490f, -128.319803f,
                61.991193f, -128.382488f, 62.024138f, -128.375379f, 62.062202f, -128.493287f, 62.084156f, -128.522335f, 63.201980f, -128.522335f,
                63.201980f, -127.111802f
            )
            poly[198] = TzPolygon(
                59.134960f, -127.111802f, 59.140147f, -127.041720f, 59.121215f, -126.964096f, 59.052940f, -126.979742f, 58.952928f, -126.914871f,
                58.841031f, -127.061170f, 58.789592f, -127.011064f, 58.806974f, -126.920182f, 58.735981f, -126.797325f, 58.680132f, -126.819675f,
                58.682193f, -126.872428f, 58.652628f, -126.932485f, 58.652477f, -126.865450f, 58.628428f, -126.832358f, 58.667150f, -126.795756f,
                58.672062f, -126.738829f, 58.585702f, -126.592079f, 58.581367f, -126.508815f, 58.607309f, -126.482643f, 58.623935f, -126.338791f,
                58.536868f, -126.342991f, 58.545530f, -126.266698f, 58.449588f, -126.092431f, 58.447042f, -125.975342f, 58.395569f, -125.938903f,
                58.413119f, -125.902789f, 58.403543f, -125.853908f, 58.359153f, -125.831458f, 58.349679f, -125.780804f, 58.321222f, -125.787302f,
                58.306566f, -125.701268f, 58.000000f, -125.701268f, 58.000000f, -127.111802f
            )
            poly[199] = TzPolygon(60.600990f, -125.701268f, 60.000400f, -125.701268f, 59.999812f, -127.111802f, 60.600990f, -127.111802f)
        }
    }

    private object Initializer3 {
        fun init() {
            poly[200] = TzPolygon(
                58.306566f, -125.701268f, 58.299330f, -125.658792f, 58.325333f, -125.555207f, 58.291177f, -125.492480f, 58.339250f, -125.443725f,
                58.277112f, -125.335263f, 58.328046f, -125.297529f, 58.282567f, -125.260531f, 58.236740f, -125.143153f, 58.262606f, -125.015366f,
                58.236364f, -124.982126f, 58.228591f, -124.887139f, 58.163701f, -124.880071f, 58.140954f, -124.832919f, 58.059751f, -124.925310f,
                58.029630f, -124.909559f, 58.024265f, -124.967866f, 58.000000f, -124.938431f, 58.000000f, -125.701268f
            )
            poly[201] = TzPolygon(
                60.600990f, -124.526163f, 60.534285f, -124.417930f, 60.465877f, -124.424106f, 60.458380f, -124.290734f, 60.000987f, -124.290734f,
                60.000400f, -125.701268f, 60.600990f, -125.701268f
            )
            poly[202] = TzPolygon(60.458380f, -124.290734f, 60.465877f, -124.424106f, 60.534285f, -124.417930f, 60.600990f, -124.526163f, 60.600990f, -124.290734f)
            poly[203] = TzPolygon(
                60.799632f, -125.701268f, 60.803724f, -125.732209f, 60.910558f, -125.841816f, 60.848800f, -125.976755f, 60.796041f, -126.005355f,
                60.813119f, -126.108151f, 60.865971f, -126.125686f, 60.853459f, -126.268592f, 60.812973f, -126.219674f, 60.780234f, -126.262177f,
                60.788491f, -126.325003f, 60.767920f, -126.375071f, 60.813244f, -126.527952f, 60.767728f, -126.627862f, 60.781473f, -126.735869f,
                60.760727f, -126.848129f, 60.814075f, -126.846336f, 60.861265f, -126.929000f, 60.882574f, -126.897556f, 61.027472f, -126.950669f,
                61.053027f, -126.924797f, 61.065920f, -127.012355f, 61.033035f, -127.028398f, 61.028536f, -127.088034f, 61.098579f, -127.111802f,
                61.132862f, -127.111802f, 61.175393f, -127.005531f, 61.223110f, -126.986682f, 61.230850f, -127.040194f, 61.346055f, -127.051490f,
                61.375065f, -127.111802f, 63.201980f, -127.111802f, 63.201980f, -125.701268f
            )
            poly[204] = TzPolygon(
                60.600990f, -124.526163f, 60.652280f, -124.609385f, 60.702459f, -124.635939f, 60.777842f, -124.482961f, 60.818855f, -124.542906f,
                60.952339f, -124.579364f, 60.947770f, -124.746953f, 60.969209f, -124.824610f, 60.920867f, -124.883331f, 60.855727f, -124.863968f,
                60.854465f, -124.979423f, 60.815728f, -125.050927f, 60.843882f, -125.086084f, 60.847677f, -125.183877f, 60.776801f, -125.325919f,
                60.778620f, -125.439963f, 60.831871f, -125.573393f, 60.795592f, -125.670721f, 60.799632f, -125.701268f, 63.201980f, -125.701268f,
                63.201980f, -124.290734f, 60.600990f, -124.290734f
            )
            poly[205] = TzPolygon(58.000000f, -118.648599f, 58.000000f, -120.001319f, 60.000422f, -120.001341f, 60.000289f, -118.648599f)
            poly[206] = TzPolygon(60.002217f, -124.290734f, 60.000422f, -120.001341f, 58.000000f, -120.001273f, 58.000000f, -124.290734f)
            poly[207] = TzPolygon(
                60.458380f, -124.290734f, 60.453515f, -124.204178f, 60.371080f, -124.232784f, 60.236863f, -124.111698f, 60.198656f, -124.121020f,
                60.146014f, -124.004868f, 60.074828f, -123.992124f, 60.001187f, -123.811471f, 60.000987f, -124.290734f
            )
            poly[208] = TzPolygon(
                53.016461f, -108.824497f, 53.229461f, -109.073097f, 53.279061f, -109.079897f, 53.333061f, -109.241897f, 53.395661f, -109.294297f,
                53.375461f, -109.465697f, 53.429561f, -109.571597f, 53.488761f, -109.549797f, 53.520761f, -109.622297f, 53.587161f, -109.643997f,
                53.599461f, -109.769097f, 53.551761f, -109.839797f, 53.598902f, -110.005616f, 59.999441f, -110.006365f, 59.999511f, -108.824497f
            )
            poly[209] = TzPolygon(59.999412f, -118.648599f, 63.201980f, -118.648599f, 63.201980f, -108.824497f, 59.998641f, -108.824497f, 59.998120f, -114.891600f)
            poly[210] = TzPolygon(
                63.573302f, -129.974167f, 63.561576f, -129.914470f, 63.459813f, -129.812706f, 63.467646f, -129.915012f, 63.425950f, -129.943454f,
                63.381111f, -129.897083f, 63.340261f, -129.939362f, 63.330730f, -129.974167f
            )
            poly[211] = TzPolygon(63.611464f, -129.974167f, 63.610948f, -129.956640f, 63.588796f, -129.974167f)
            poly[212] = TzPolygon(
                64.791916f, -108.824497f, 64.833631f, -109.334405f, 65.500330f, -110.667836f, 65.500314f, -112.501267f, 66.757706f, -116.616223f,
                68.000283f, -120.682778f, 69.558178f, -120.683021f, 69.647998f, -116.836275f, 69.631901f, -116.638083f, 69.889305f, -117.146563f,
                70.000422f, -117.118821f, 70.000460f, -112.885251f, 69.833787f, -112.885242f, 69.833789f, -112.651894f, 69.882660f, -112.633449f,
                69.851674f, -112.613155f, 69.852618f, -112.519225f, 69.877909f, -112.485232f, 69.854287f, -112.507635f, 69.869615f, -112.457630f,
                69.853036f, -112.483153f, 69.849592f, -112.438355f, 69.880621f, -112.342125f, 69.894573f, -112.393529f, 69.896912f, -112.322306f,
                69.899178f, -112.554541f, 69.866361f, -112.563508f, 69.899007f, -112.561049f, 69.910823f, -112.655539f, 69.911882f, -112.501887f,
                70.000463f, -112.501893f, 70.000492f, -110.001642f, 79.129982f, -110.002733f, 79.257032f, -108.824497f
            )
            poly[213] = TzPolygon(53.375000f, -107.756288f, 49.384490f, -107.756288f, 49.384490f, -108.824497f, 53.375000f, -108.824497f)
            poly[214] = TzPolygon(
                49.530211f, -101.392420f, 49.532731f, -101.392564f, 49.532714f, -101.417774f, 49.886670f, -101.417546f, 49.886660f, -101.447198f,
                50.240543f, -101.447153f, 50.240506f, -101.476721f, 50.594388f, -101.476995f, 50.594393f, -101.508729f, 50.948485f, -101.508695f,
                50.948581f, -101.538983f, 51.301712f, -101.539110f, 51.301876f, -101.570544f, 51.968568f, -101.577230f, 51.968581f, -101.609311f,
                52.318158f, -101.609055f, 52.318150f, -101.637813f, 52.667274f, -101.637705f, 52.667261f, -101.671588f, 53.365781f, -101.700606f,
                53.365808f, -101.735544f, 53.375000f, -101.735532f, 53.375000f, -101.392420f
            )
            poly[215] = TzPolygon(
                49.384490f, -90.462040f, 49.500000f, -90.000000f, 50.750000f, -90.000000f, 51.000000f, -90.500000f, 51.250000f, -90.750000f,
                51.500000f, -90.750000f, 51.750000f, -90.500000f, 52.000000f, -90.000000f, 52.750000f, -90.000000f, 52.750000f, -89.000000f,
                53.000000f, -89.000000f, 53.375000f, -88.500000f, 49.384490f, -88.500000f
            )
            poly[216] = TzPolygon(53.375000f, -101.735532f, 53.710706f, -101.735099f, 53.375000f, -101.735099f)
            poly[217] = TzPolygon(
                53.710706f, -101.735099f, 53.710899f, -101.770647f, 54.064403f, -101.771323f, 54.064406f, -101.810434f, 54.096808f, -101.810446f,
                54.259194f, -102.264514f, 54.509138f, -102.514514f, 54.759082f, -102.514514f, 55.009026f, -102.264514f, 55.111547f, -101.924050f,
                55.809401f, -101.963723f, 55.809383f, -102.004034f, 59.999220f, -102.007591f, 59.999217f, -101.735099f
            )
            poly[218] = TzPolygon(59.999511f, -108.824497f, 59.999226f, -102.000476f, 59.998641f, -108.824497f)
            poly[219] = TzPolygon(56.652520f, -88.500000f, 56.687256f, -88.640613f, 56.687256f, -88.500000f)
            poly[220] = TzPolygon(
                53.625000f, -88.500000f, 54.000000f, -89.000000f, 54.000000f, -90.000000f, 56.229664f, -89.999805f, 56.687256f, -89.251433f,
                56.687256f, -88.640613f, 56.652520f, -88.500000f
            )
            poly[221] = TzPolygon(
                58.343286f, -93.017141f, 58.343286f, -91.808775f, 57.089577f, -91.808775f, 57.054292f, -91.966190f, 57.049549f, -92.123103f,
                57.072747f, -92.217068f, 57.047274f, -92.443205f, 56.925189f, -92.735427f, 56.940144f, -92.753898f, 57.107378f, -92.540321f,
                57.237401f, -92.448994f, 57.363230f, -92.426660f, 57.525070f, -92.498610f, 57.541890f, -92.542170f, 57.799665f, -92.728444f,
                58.171787f, -92.864617f, 58.200530f, -92.918490f
            )
            poly[222] = TzPolygon(
                59.999143f, -95.117549f, 59.999140f, -94.826000f, 59.882520f, -94.833267f, 59.787196f, -94.773046f, 59.741779f, -94.827901f,
                59.726902f, -94.788920f, 59.709594f, -94.835799f, 59.700915f, -94.794429f, 59.614267f, -94.837809f, 59.568414f, -94.764675f,
                59.543643f, -94.811212f, 59.383558f, -94.707734f, 59.341757f, -94.728630f, 59.351033f, -94.662928f, 59.266971f, -94.802273f,
                59.008965f, -94.797971f, 59.018478f, -94.757136f, 58.988168f, -94.691164f, 58.946576f, -94.687268f, 58.942458f, -94.596273f,
                58.894701f, -94.585133f, 58.887734f, -94.618200f, 58.792745f, -94.473451f, 58.707081f, -94.430336f, 58.719674f, -94.324465f,
                58.781337f, -94.293490f, 58.817005f, -94.215553f, 58.777255f, -94.146512f, 58.751561f, -93.889687f, 58.763348f, -93.838240f,
                58.799372f, -93.828922f, 58.769313f, -93.813121f, 58.770561f, -93.744063f, 58.800685f, -93.754397f, 58.765807f, -93.592723f,
                58.767452f, -93.529447f, 58.780939f, -93.535915f, 58.754302f, -93.486184f, 58.720328f, -93.495224f, 58.698533f, -93.432278f,
                58.761426f, -93.336548f, 58.756287f, -93.230929f, 58.777508f, -93.241429f, 58.724411f, -93.162284f, 58.476360f, -93.109101f,
                58.343286f, -93.017141f, 58.343286f, -95.117549f
            )
            poly[223] = TzPolygon(
                56.687256f, -89.251433f, 56.846610f, -88.990816f, 56.839485f, -88.912742f, 56.859364f, -88.882881f, 56.827580f, -88.860802f,
                56.838909f, -88.823349f, 56.797432f, -88.831207f, 56.688774f, -88.646759f, 56.687256f, -88.640613f
            )
            poly[224] = TzPolygon(
                57.089577f, -91.808775f, 57.268330f, -91.011308f, 57.231216f, -90.623676f, 57.189723f, -90.517952f, 57.192989f, -90.434857f,
                57.162074f, -90.420956f, 57.002819f, -89.956692f, 56.928488f, -89.385498f, 56.874093f, -89.193315f, 56.846610f, -88.990816f,
                56.687256f, -89.251433f, 56.687256f, -91.808775f
            )
            poly[225] = TzPolygon(
                64.791916f, -108.824497f, 79.257032f, -108.824497f, 79.545902f, -106.145572f, 80.123024f, -102.001012f, 73.429675f, -102.001534f,
                72.242433f, -93.894588f, 71.878142f, -92.166233f, 70.017888f, -89.606081f, 69.260324f, -89.000000f, 67.000000f, -89.000000f,
                67.000000f, -102.000000f, 64.233664f, -102.000596f
            )
            poly[226] = TzPolygon(
                59.999511f, -88.500000f, 59.999511f, -102.000476f, 67.000000f, -102.000000f, 67.000000f, -89.000000f, 69.260324f, -89.000000f,
                70.017888f, -89.606081f, 71.878142f, -92.166233f, 72.242433f, -93.894588f, 73.429675f, -102.001534f, 80.123024f, -102.001012f,
                80.325468f, -100.308415f, 80.513782f, -97.549389f, 80.741941f, -97.269837f, 81.457997f, -95.359116f, 81.860549f, -92.769392f,
                82.090244f, -91.567800f, 82.276869f, -88.777954f, 82.303898f, -88.500000f
            )
            poly[227] = TzPolygon(64.791916f, -108.824497f, 64.233664f, -102.000596f, 59.999511f, -102.000476f, 59.999511f, -108.824497f)
            poly[228] = TzPolygon(
                56.187094f, -87.694290f, 56.095921f, -87.629822f, 56.042232f, -87.480354f, 55.998974f, -87.430969f, 55.939842f, -87.238563f,
                55.916050f, -86.908066f, 55.764652f, -86.372040f, 55.707176f, -86.260002f, 55.662723f, -86.055709f, 55.655434f, -85.902816f,
                55.570255f, -85.652534f, 55.405380f, -85.399285f, 55.375016f, -85.229233f, 55.290497f, -85.072612f, 49.384490f, -85.072612f,
                49.384490f, -88.500000f, 56.187094f, -88.500000f
            )
            poly[229] = TzPolygon(
                52.496773f, -81.645224f, 52.609474f, -81.768943f, 52.664745f, -81.883857f, 52.759502f, -81.951309f, 52.764469f, -82.000000f,
                52.777893f, -81.959579f, 52.785792f, -81.971196f, 52.785792f, -81.645224f
            )
            poly[230] = TzPolygon(
                52.785792f, -81.645224f, 52.785792f, -81.971196f, 52.882942f, -82.114074f, 52.947357f, -82.263153f, 53.117104f, -82.281006f,
                53.193077f, -82.232246f, 53.267982f, -82.112938f, 53.587864f, -82.215851f, 53.819817f, -82.126320f, 54.027718f, -82.232956f,
                54.164105f, -82.394898f, 54.254684f, -82.436592f, 54.508911f, -82.316246f, 54.655407f, -82.288452f, 54.803795f, -82.197815f,
                54.873863f, -82.207588f, 54.860290f, -82.239777f, 54.912853f, -82.267212f, 55.109474f, -82.253173f, 55.159210f, -82.348266f,
                55.054394f, -82.311096f, 55.069969f, -82.404572f, 55.116223f, -82.453315f, 55.090477f, -82.517067f, 55.180107f, -82.680206f,
                55.140431f, -82.708428f, 55.128262f, -82.803322f, 55.146702f, -82.884864f, 55.221966f, -82.958915f, 55.198608f, -83.338745f,
                55.267910f, -83.692787f, 55.212089f, -83.630547f, 55.294983f, -83.886490f, 55.251080f, -84.082718f, 55.278450f, -84.171348f,
                55.278042f, -84.306732f, 55.236660f, -84.550964f, 55.236389f, -84.787575f, 55.271791f, -84.999891f, 56.187094f, -84.999905f,
                56.187094f, -81.645224f
            )
            poly[231] = TzPolygon(55.283933f, -85.072612f, 56.187094f, -85.072612f, 56.187094f, -84.999905f, 55.271791f, -84.999891f, 55.268990f, -85.008796f)
            poly[232] = TzPolygon(56.187094f, -81.645224f, 56.187094f, -84.999905f, 62.989698f, -85.000012f, 62.989698f, -81.645224f)
            poly[233] = TzPolygon(
                56.187094f, -87.694290f, 56.231095f, -87.725403f, 56.389561f, -87.925156f, 56.462406f, -87.972641f, 56.538315f, -88.278473f,
                56.652520f, -88.500000f, 62.989698f, -88.500000f, 62.989698f, -85.000012f, 56.187094f, -84.999905f
            )
            poly[234] = TzPolygon(
                56.652520f, -88.500000f, 56.538315f, -88.278473f, 56.462406f, -87.972641f, 56.389561f, -87.925156f, 56.231095f, -87.725403f,
                56.187094f, -87.694290f, 56.187094f, -88.500000f
            )
            poly[235] = TzPolygon(
                52.496773f, -81.645224f, 52.489052f, -81.636749f, 52.443180f, -81.545707f, 52.351895f, -81.553116f, 52.291229f, -81.478386f,
                52.116081f, -81.384544f, 52.041309f, -81.160148f, 52.037338f, -81.110115f, 52.058304f, -81.080452f, 52.027325f, -81.060181f,
                52.040215f, -81.043808f, 52.011433f, -80.989090f, 51.898689f, -80.881111f, 51.905666f, -80.850395f, 51.880283f, -80.823792f,
                51.892727f, -80.795173f, 51.813232f, -80.708428f, 51.846146f, -80.688545f, 51.805630f, -80.688645f, 51.701687f, -80.565765f,
                51.549820f, -80.513710f, 51.464264f, -80.431786f, 51.382744f, -80.432815f, 51.339314f, -80.384712f, 51.308449f, -80.292457f,
                51.291893f, -80.116425f, 51.243858f, -79.990204f, 51.200288f, -79.931531f, 49.384490f, -79.931531f, 49.384490f, -81.645224f
            )
            poly[236] = TzPolygon(
                51.200288f, -79.931531f, 51.167770f, -79.887741f, 51.157154f, -79.799064f, 51.280308f, -79.686867f, 51.329529f, -79.744552f,
                51.370861f, -79.734863f, 51.380703f, -79.707832f, 51.353138f, -79.722573f, 51.343563f, -79.674132f, 51.403736f, -79.681580f,
                51.416210f, -79.611130f, 51.465935f, -79.573998f, 51.465185f, -79.501413f, 51.561030f, -79.541538f, 51.679863f, -79.329116f,
                51.655965f, -79.217186f, 51.577089f, -79.244534f, 51.534057f, -79.201320f, 51.538646f, -79.103023f, 51.520714f, -79.074684f,
                51.085141f, -79.074684f, 51.085141f, -79.931531f
            )
            poly[237] = TzPolygon(
                52.785792f, -78.756715f, 52.757078f, -78.777712f, 52.775094f, -78.836660f, 52.734555f, -78.875524f, 52.711989f, -78.783749f,
                52.680263f, -78.827034f, 52.669888f, -78.730156f, 52.634225f, -78.819098f, 52.602644f, -78.710368f, 52.551186f, -78.773927f,
                52.491496f, -78.552801f, 52.332117f, -78.521438f, 52.289708f, -78.584187f, 52.177735f, -78.569691f, 52.057764f, -78.673175f,
                52.053581f, -78.724436f, 51.989208f, -78.722474f, 51.925380f, -78.893032f, 51.841019f, -78.862177f, 51.767592f, -79.050736f,
                51.613192f, -78.880770f, 51.516140f, -78.844912f, 51.481797f, -78.795898f, 51.384082f, -78.907835f, 51.333614f, -78.879230f,
                51.248244f, -78.933198f, 51.167462f, -78.867142f, 51.222862f, -78.951008f, 51.286496f, -78.936212f, 51.459908f, -78.978590f,
                51.520714f, -79.074684f, 52.785792f, -79.074684f
            )
            poly[238] = TzPolygon(53.431739f, -79.074684f, 53.500475f, -79.138578f, 53.516867f, -79.074684f)
            poly[239] = TzPolygon(
                53.682954f, -79.074684f, 53.694123f, -79.159220f, 53.716022f, -79.143230f, 53.713831f, -79.090599f, 53.766074f, -79.084248f,
                53.769699f, -79.074684f
            )
            poly[240] = TzPolygon(53.792604f, -79.074684f, 53.795064f, -79.082299f, 53.795765f, -79.074684f)
            poly[241] = TzPolygon(53.858173f, -79.074684f, 53.870221f, -79.083484f, 53.861974f, -79.074684f)
            poly[242] = TzPolygon(53.885670f, -79.074684f, 53.902374f, -79.105364f, 53.898251f, -79.074684f)
            poly[243] = TzPolygon(53.929164f, -79.074684f, 53.948967f, -79.155066f, 53.939203f, -79.074684f)
            poly[244] = TzPolygon(53.942596f, -79.074684f, 53.949705f, -79.107135f, 53.952761f, -79.074684f)
            poly[245] = TzPolygon(53.965376f, -79.074684f, 53.973700f, -79.105658f, 53.977333f, -79.074684f)
            poly[246] = TzPolygon(
                54.026383f, -79.074684f, 54.023992f, -79.103719f, 54.044557f, -79.090647f, 54.080907f, -79.177888f, 54.105004f, -79.163409f,
                54.100495f, -79.074684f
            )
            poly[247] = TzPolygon(
                54.104149f, -79.074684f, 54.130158f, -79.124059f, 54.159808f, -79.090832f, 54.137714f, -79.244784f, 54.152630f, -79.274953f,
                54.174814f, -79.237437f, 54.175454f, -79.401392f, 54.231533f, -79.310222f, 54.300164f, -79.488423f, 54.345332f, -79.470036f,
                54.367055f, -79.521034f, 54.437280f, -79.487026f, 54.460543f, -79.538528f, 54.486443f, -79.509164f, 54.486443f, -79.074684f
            )
            poly[248] = TzPolygon(
                52.785792f, -78.761862f, 52.798727f, -78.757741f, 52.806984f, -78.794238f, 52.845271f, -78.748980f, 52.851152f, -78.834542f,
                52.872690f, -78.841376f, 52.861020f, -78.888206f, 52.906982f, -78.881033f, 52.913341f, -78.921321f, 52.975727f, -78.839387f,
                52.981157f, -78.934591f, 53.013113f, -78.995149f, 53.030630f, -78.955085f, 53.037203f, -78.990952f, 53.055609f, -78.931147f,
                53.072022f, -78.993482f, 53.140181f, -78.946581f, 53.163901f, -78.943088f, 53.169947f, -78.976959f, 53.198555f, -78.915338f,
                53.211446f, -78.944841f, 53.227688f, -78.908604f, 53.232356f, -78.953843f, 53.258470f, -78.918921f, 53.269851f, -78.972079f,
                53.306830f, -78.953331f, 53.327062f, -78.999752f, 53.349197f, -78.941323f, 53.385821f, -78.952611f, 53.399133f, -78.889535f,
                53.410932f, -79.064980f, 53.438931f, -79.043155f, 53.426835f, -79.070125f, 53.431739f, -79.074684f, 53.516867f, -79.074684f,
                53.529227f, -79.026505f, 53.564842f, -79.031348f, 53.552378f, -78.916538f, 53.567090f, -78.985261f, 53.585092f, -78.981675f,
                53.585015f, -79.074351f, 53.636117f, -79.062641f, 53.636117f, -78.217837f, 52.785792f, -78.217837f
            )
            poly[249] = TzPolygon(54.104149f, -79.074684f, 54.100105f, -79.067007f, 54.100495f, -79.074684f)
            poly[250] = TzPolygon(
                54.026383f, -79.074684f, 54.029108f, -79.041584f, 53.995529f, -78.971581f, 54.000023f, -79.068420f, 53.978142f, -79.067791f,
                53.977333f, -79.074684f
            )
            poly[251] = TzPolygon(53.965376f, -79.074684f, 53.956034f, -79.039920f, 53.952761f, -79.074684f)
            poly[252] = TzPolygon(53.942596f, -79.074684f, 53.934980f, -79.039917f, 53.939203f, -79.074684f)
            poly[253] = TzPolygon(53.929501f, -79.074684f, 53.899608f, -78.951247f, 53.884680f, -78.973691f, 53.898071f, -79.074684f)
            poly[254] = TzPolygon(53.885557f, -79.074684f, 53.873662f, -79.052629f, 53.856420f, -79.068757f, 53.861974f, -79.074684f)
            poly[255] = TzPolygon(53.858173f, -79.074684f, 53.842375f, -79.063144f, 53.837120f, -78.948760f, 53.806826f, -78.954581f, 53.795765f, -79.074684f)
            poly[256] = TzPolygon(53.792604f, -79.074684f, 53.782064f, -79.042058f, 53.769699f, -79.074684f)
            poly[257] = TzPolygon(53.682954f, -79.074684f, 53.680034f, -79.052578f, 53.636117f, -79.062641f, 53.636117f, -79.074684f)
            poly[258] = TzPolygon(
                54.486443f, -79.509164f, 54.489501f, -79.505697f, 54.494865f, -79.549013f, 54.523457f, -79.536319f, 54.550978f, -79.592823f,
                54.565808f, -79.530049f, 54.604806f, -79.548519f, 54.624100f, -79.584818f, 54.605398f, -79.645531f, 54.628028f, -79.665656f,
                54.614821f, -79.761573f, 54.635567f, -79.774135f, 54.728733f, -79.554477f, 54.860159f, -78.973520f, 55.000000f, -78.540218f,
                55.043133f, -78.315652f, 55.104528f, -78.217837f, 54.486443f, -78.217837f
            )
            poly[259] = TzPolygon(
                56.187094f, -76.641539f, 56.146650f, -76.642281f, 56.047835f, -76.691017f, 56.000810f, -76.799522f, 55.929778f, -76.830164f,
                55.827933f, -76.978543f, 55.820223f, -76.948683f, 55.822805f, -76.993321f, 55.752620f, -77.076064f, 55.749124f, -77.052486f,
                55.667230f, -77.197289f, 55.719814f, -77.078288f, 55.666792f, -77.114831f, 55.395865f, -77.554265f, 55.357940f, -77.672390f,
                55.271615f, -77.783284f, 55.126956f, -78.182104f, 55.104528f, -78.217837f, 56.187094f, -78.217837f
            )
            poly[260] = TzPolygon(
                58.482664f, -78.217837f, 58.511207f, -78.257790f, 58.520749f, -78.330109f, 58.613431f, -78.392553f, 58.608917f, -78.437192f,
                58.577533f, -78.451993f, 58.568850f, -78.385153f, 58.531613f, -78.371605f, 58.557419f, -78.470689f, 58.630370f, -78.514551f,
                58.670122f, -78.615404f, 58.718865f, -78.520381f, 58.772922f, -78.592399f, 58.819216f, -78.548171f, 58.933493f, -78.599530f,
                58.951266f, -78.558708f, 58.913771f, -78.450987f, 58.925913f, -78.397117f, 58.992424f, -78.302715f, 59.060478f, -78.333443f,
                59.072711f, -78.299118f, 59.047947f, -78.237732f, 59.114693f, -78.270564f, 59.107473f, -78.217837f
            )
            poly[261] = TzPolygon(60.791479f, -78.217837f, 60.789666f, -78.230859f, 60.817553f, -78.217837f)
            poly[262] = TzPolygon(
                56.187094f, -76.641539f, 56.190207f, -76.641482f, 56.193783f, -76.670324f, 56.202846f, -76.615197f, 56.236862f, -76.626536f,
                56.287832f, -76.557255f, 56.379708f, -76.527154f, 56.555942f, -76.556748f, 56.913180f, -76.531624f, 56.924034f, -76.570023f,
                57.094678f, -76.577184f, 57.326327f, -76.669408f, 57.490789f, -76.802190f, 57.705407f, -76.904868f, 58.000000f, -77.213234f,
                58.018617f, -77.198699f, 58.158863f, -77.543660f, 58.217559f, -77.522669f, 58.377964f, -78.071282f, 58.482664f, -78.217837f,
                59.107473f, -78.217837f, 59.097294f, -78.143506f, 59.143958f, -78.206220f, 59.184423f, -78.138085f, 59.208883f, -78.171467f,
                59.236762f, -78.038235f, 59.371311f, -77.868729f, 59.390858f, -77.765021f, 59.421604f, -77.771880f, 59.384612f, -77.927306f,
                59.417150f, -77.974331f, 59.448718f, -77.951112f, 59.438065f, -77.866118f, 59.487791f, -77.937091f, 59.581917f, -77.776548f,
                59.588396f, -77.781198f, 59.588396f, -74.790449f, 56.187094f, -74.790449f
            )
            poly[263] = TzPolygon(
                59.588396f, -77.781198f, 59.679840f, -77.846834f, 59.719928f, -77.835025f, 59.718660f, -77.744044f, 59.691713f, -77.701196f,
                59.708982f, -77.541054f, 59.738460f, -77.601258f, 59.761884f, -77.592001f, 59.759707f, -77.505192f, 59.827796f, -77.377503f,
                59.900326f, -77.418596f, 59.912658f, -77.487471f, 60.000000f, -77.567627f, 60.030820f, -77.519119f, 60.061857f, -77.651135f,
                60.167127f, -77.563688f, 60.313822f, -77.608406f, 60.327766f, -77.660538f, 60.365224f, -77.667988f, 60.386478f, -77.787308f,
                60.531371f, -77.599743f, 60.589748f, -77.799286f, 60.638313f, -77.844850f, 60.701988f, -77.711881f, 60.769083f, -77.680461f,
                60.743406f, -77.789232f, 60.786172f, -77.777507f, 60.749669f, -77.926934f, 60.770647f, -77.892165f, 60.790615f, -77.923515f,
                60.777451f, -77.999847f, 60.803803f, -78.129341f, 60.791479f, -78.217837f, 60.817553f, -78.217837f, 60.862435f, -78.196879f,
                60.931501f, -78.100054f, 61.044457f, -77.916374f, 61.060078f, -77.837189f, 61.150087f, -77.829425f, 61.197063f, -77.723022f,
                61.240859f, -77.800614f, 61.246539f, -77.762456f, 61.289047f, -77.774125f, 61.289047f, -76.504143f, 59.588396f, -76.504143f
            )
            poly[264] = TzPolygon(
                61.289047f, -77.774125f, 61.460909f, -77.821303f, 61.438745f, -77.737902f, 61.466286f, -77.725944f, 61.477650f, -77.573674f,
                61.522204f, -77.716286f, 61.576126f, -77.655797f, 61.601315f, -77.746094f, 61.679934f, -77.798489f, 61.686870f, -77.974057f,
                61.728739f, -78.032375f, 62.013718f, -78.170000f, 62.157075f, -78.204159f, 62.227340f, -78.169823f, 62.258438f, -78.204239f,
                62.356690f, -78.105247f, 62.473114f, -77.725256f, 62.508673f, -77.692929f, 62.517479f, -77.594785f, 62.576849f, -77.523886f,
                62.580486f, -77.430618f, 62.555074f, -77.335162f, 62.516955f, -76.773380f, 62.457502f, -76.504143f, 61.289047f, -76.504143f
            )
            poly[265] = TzPolygon(
                62.457502f, -76.504143f, 62.352392f, -76.028143f, 62.354351f, -75.933517f, 62.266374f, -75.506512f, 62.319052f, -75.363516f,
                62.258424f, -74.916669f, 62.205728f, -74.803039f, 62.208265f, -74.790449f, 59.588396f, -74.790449f, 59.588396f, -76.504143f
            )
            poly[266] = TzPolygon(
                65.531634f, -86.076901f, 65.531634f, -85.256208f, 65.452991f, -85.072612f, 63.144018f, -85.072612f, 63.106410f, -85.211020f,
                63.114330f, -85.369300f, 63.096020f, -85.435830f, 63.128320f, -85.562400f, 63.207040f, -85.632730f, 63.399450f, -85.662680f,
                63.498310f, -85.594500f, 63.546760f, -85.630830f, 63.637670f, -85.588190f, 63.688400f, -85.636100f, 63.682670f, -86.033400f,
                63.632350f, -86.261720f, 63.662600f, -86.559180f, 63.641390f, -86.660190f, 63.574840f, -86.767180f, 63.545730f, -86.935990f,
                63.561420f, -87.130440f, 63.656710f, -87.218660f, 63.714790f, -87.207280f, 63.911330f, -86.900300f, 64.019440f, -86.459100f,
                64.065430f, -86.353080f, 64.091360f, -86.170960f, 64.166890f, -86.183360f, 64.225570f, -86.303820f, 64.260750f, -86.280580f,
                64.303840f, -86.361640f, 64.406260f, -86.329690f, 64.430280f, -86.383260f, 64.579680f, -86.392680f, 64.823390f, -86.177340f,
                64.873610f, -86.195050f, 64.918740f, -86.125310f, 64.985710f, -86.210710f, 65.100830f, -86.126310f, 65.286170f, -86.158060f,
                65.358840f, -86.077620f, 65.373250f, -86.135660f, 65.505980f, -86.093380f
            )
            poly[267] = TzPolygon(
                65.531634f, -86.076901f, 65.764210f, -85.927510f, 65.923670f, -85.515080f, 65.791890f, -85.456630f, 65.794780f, -85.389170f,
                65.814540f, -85.420360f, 65.833550f, -85.354910f, 65.826080f, -85.258070f, 65.761780f, -85.140430f, 65.725650f, -85.114440f,
                65.719940f, -85.171390f, 65.647503f, -85.072612f, 65.570505f, -85.072612f, 65.544510f, -85.196050f, 65.567710f, -85.277210f,
                65.541290f, -85.278750f, 65.531634f, -85.256208f
            )
            poly[268] = TzPolygon(65.735862f, -85.072612f, 65.744510f, -85.099380f, 65.988620f, -85.158770f, 66.030715f, -85.083198f, 66.029979f, -85.072612f)
            poly[269] = TzPolygon(
                62.989698f, -85.000012f, 63.159975f, -85.000015f, 63.227170f, -84.775260f, 63.295750f, -84.647710f, 63.285160f, -84.565580f,
                63.312430f, -84.573510f, 63.371240f, -84.453930f, 63.481820f, -84.440090f, 63.606110f, -84.282290f, 63.633470f, -84.294360f,
                63.592100f, -84.083620f, 63.651760f, -84.003480f, 63.718068f, -83.814951f, 63.773079f, -83.764209f, 63.763943f, -83.605438f,
                63.923014f, -83.593896f, 64.006607f, -83.663054f, 64.033190f, -83.581481f, 64.101868f, -83.532530f, 64.121058f, -83.438072f,
                64.097277f, -83.393315f, 64.111508f, -83.358918f, 62.989698f, -83.358918f
            )
            poly[270] = TzPolygon(63.144078f, -85.072612f, 63.159975f, -85.000015f, 62.989698f, -85.000012f, 62.989698f, -85.072612f)
            poly[271] = TzPolygon(
                65.109593f, -83.358918f, 65.140670f, -83.397030f, 65.166980f, -83.557870f, 65.154600f, -83.690310f, 65.132750f, -83.697890f,
                65.167350f, -83.699680f, 65.161200f, -83.903130f, 65.193320f, -83.872560f, 65.181760f, -84.008530f, 65.207030f, -84.056880f,
                65.202980f, -84.111580f, 65.220610f, -84.084040f, 65.218160f, -84.142850f, 65.270060f, -84.235610f, 65.274360f, -84.185050f,
                65.336130f, -84.128830f, 65.377010f, -84.263010f, 65.374430f, -84.347930f, 65.469880f, -84.467530f, 65.475640f, -84.553180f,
                65.350710f, -84.711860f, 65.213200f, -84.771910f, 65.213600f, -84.906580f, 65.329800f, -84.986110f, 65.531634f, -84.993627f,
                65.531634f, -83.358918f
            )
            poly[272] = TzPolygon(65.531634f, -85.072612f, 65.531634f, -85.000060f, 65.421008f, -85.000094f, 65.452311f, -85.072612f)
            poly[273] = TzPolygon(
                64.260666f, -83.358918f, 64.260666f, -81.718752f, 64.220211f, -81.645224f, 64.104269f, -81.645224f, 64.079860f, -81.706690f,
                64.041490f, -82.010350f, 63.987200f, -82.001400f, 63.979760f, -81.865460f, 64.006527f, -81.645224f, 63.566442f, -81.645224f,
                63.565810f, -81.667540f, 63.591420f, -81.660670f, 63.632890f, -81.756530f, 63.624310f, -81.910980f, 63.642760f, -81.908700f,
                63.686070f, -82.063950f, 63.680660f, -82.199140f, 63.656280f, -82.253380f, 63.668230f, -82.276370f, 63.643650f, -82.293110f,
                63.662670f, -82.470180f, 63.705930f, -82.468100f, 63.737790f, -82.528360f, 63.788820f, -82.491790f, 63.835930f, -82.303370f,
                63.874450f, -82.397110f, 63.864240f, -82.340350f, 63.893760f, -82.356270f, 63.956490f, -82.530380f, 63.955660f, -82.782880f,
                63.981251f, -82.890824f, 63.938755f, -83.064721f, 63.965734f, -83.137686f, 64.007572f, -83.138837f, 64.131145f, -82.933088f,
                64.178801f, -83.002014f, 64.174996f, -83.092989f, 64.149374f, -83.161197f, 64.110323f, -83.165030f, 64.143178f, -83.282370f,
                64.111508f, -83.358918f
            )
            poly[274] = TzPolygon(
                65.109593f, -83.358918f, 65.066500f, -83.306070f, 65.003940f, -83.302910f, 64.932310f, -83.183600f, 64.913440f, -83.001680f,
                64.788010f, -82.725490f, 64.747740f, -82.525900f, 64.735520f, -82.545560f, 64.761240f, -82.346910f, 64.710160f, -82.188920f,
                64.683640f, -82.211060f, 64.676060f, -82.065260f, 64.633540f, -82.038850f, 64.544127f, -81.815612f, 64.461210f, -81.731320f,
                64.436710f, -81.770630f, 64.267350f, -81.730900f, 64.260666f, -81.718752f, 64.260666f, -83.358918f
            )
            poly[275] = TzPolygon(65.647503f, -85.072612f, 65.610130f, -85.021650f, 65.573030f, -85.060620f, 65.570505f, -85.072612f)
            poly[276] = TzPolygon(
                65.735862f, -85.072612f, 66.029979f, -85.072612f, 66.024293f, -84.990774f, 65.990840f, -85.008230f, 66.023677f, -84.983878f,
                66.018781f, -84.915926f, 65.972920f, -84.837040f, 65.941360f, -84.848480f, 65.950770f, -84.899730f, 65.907810f, -84.791200f,
                65.867060f, -84.768460f, 65.869750f, -84.725720f, 65.859730f, -84.810330f, 65.832800f, -84.700900f, 65.787900f, -84.709270f,
                65.767920f, -84.640680f, 65.632450f, -84.551420f, 65.557220f, -84.631370f, 65.540330f, -84.714370f, 65.585620f, -84.819510f,
                65.672380f, -84.876110f
            )
            poly[277] = TzPolygon(68.073571f, -85.000142f, 66.023903f, -85.000090f, 66.024522f, -85.072612f, 68.073571f, -85.072612f)
            poly[278] = TzPolygon(
                65.570505f, -85.072612f, 65.573030f, -85.060620f, 65.610130f, -85.021650f, 65.647503f, -85.072612f, 65.740562f, -85.072612f,
                65.702961f, -85.000008f, 65.531634f, -85.000060f, 65.531634f, -85.072612f
            )
            poly[279] = TzPolygon(73.157443f, -85.000270f, 68.073571f, -85.000142f, 68.073571f, -88.500000f, 73.157443f, -88.500000f)
            poly[280] = TzPolygon(64.220211f, -81.645224f, 64.231510f, -81.628300f, 64.128880f, -81.583250f, 64.104269f, -81.645224f)
            poly[281] = TzPolygon(
                64.006527f, -81.645224f, 64.025380f, -81.490110f, 64.044240f, -81.429160f, 64.074870f, -81.450660f, 64.085030f, -81.389460f,
                64.062430f, -81.418340f, 64.074000f, -81.288230f, 64.041540f, -81.277980f, 64.021070f, -81.074260f, 63.969242f, -80.933669f,
                63.985499f, -80.904690f, 64.047430f, -80.978030f, 64.079642f, -80.912829f, 64.115282f, -80.960017f, 64.119020f, -80.918290f,
                64.059730f, -80.740660f, 64.005170f, -80.695410f, 63.988620f, -80.741600f, 64.001380f, -80.608050f, 63.980200f, -80.536720f,
                63.944830f, -80.513760f, 63.939380f, -80.571410f, 63.911730f, -80.562540f, 63.895590f, -80.475710f, 63.872400f, -80.580260f,
                63.901230f, -80.690530f, 63.875680f, -80.664330f, 63.861120f, -80.494040f, 63.819460f, -80.315310f, 63.791230f, -80.295170f,
                63.800990f, -80.204660f, 63.757900f, -80.183920f, 63.786240f, -80.175010f, 63.768960f, -80.149500f, 63.724550f, -80.212000f,
                63.740140f, -80.208690f, 63.718770f, -80.489660f, 63.633220f, -80.571720f, 63.566440f, -80.791340f, 63.529410f, -80.831150f,
                63.525900f, -80.910820f, 63.457620f, -80.933320f, 63.445600f, -81.048200f, 63.570010f, -81.519280f, 63.566442f, -81.645224f
            )
            poly[282] = TzPolygon(
                82.303898f, -88.500000f, 82.356200f, -87.962165f, 82.594807f, -86.904367f, 82.771835f, -85.000513f, 73.157443f, -85.000270f,
                73.157443f, -88.500000f
            )
            poly[283] = TzPolygon(47.575298f, -103.437448f, 47.527050f, -103.434273f, 47.515476f, -103.609627f, 47.575298f, -103.610132f)
            poly[284] = TzPolygon(47.575298f, -103.093448f, 47.570328f, -103.183258f, 47.575298f, -103.219296f)
            poly[285] = TzPolygon(
                47.575298f, -102.432684f, 47.565319f, -102.444198f, 47.515064f, -102.438293f, 47.511234f, -102.505493f, 47.544117f, -102.599647f,
                47.529018f, -102.678001f, 47.574188f, -102.693779f, 47.575298f, -102.700876f
            )
            poly[286] = TzPolygon(
                42.766993f, -102.432684f, 42.766993f, -100.845588f, 42.755013f, -100.845704f, 42.755328f, -100.890666f, 42.611364f, -100.890920f,
                42.610367f, -100.773315f, 42.438517f, -100.775008f, 42.438502f, -100.829514f, 42.351938f, -100.829514f, 42.352040f, -100.810093f,
                42.205074f, -100.808526f, 42.204855f, -100.750189f, 42.088661f, -100.750147f, 42.089584f, -100.844398f, 41.740372f, -100.843887f,
                41.743195f, -101.404457f, 41.395439f, -101.405487f, 41.395943f, -101.270180f, 41.048794f, -101.268829f, 41.047630f, -101.248695f,
                40.697426f, -101.245575f, 40.697338f, -101.343185f, 40.002728f, -101.322486f, 40.003062f, -102.051756f, 39.568170f, -102.049764f,
                39.568550f, -101.390160f, 39.134537f, -101.391281f, 39.133850f, -101.477890f, 38.700176f, -101.484985f, 38.700375f, -101.569351f,
                37.958689f, -101.536806f, 37.958689f, -102.432684f
            )
            poly[287] = TzPolygon(
                45.171146f, -102.432684f, 45.171146f, -100.292771f, 45.095367f, -100.328568f, 45.023617f, -100.280991f, 45.025558f, -100.371338f,
                44.984058f, -100.426239f, 44.860802f, -100.398048f, 44.759071f, -100.558273f, 44.831036f, -100.691536f, 44.798576f, -100.730042f,
                44.767117f, -100.716438f, 44.722065f, -100.623131f, 44.577450f, -100.637611f, 44.541946f, -100.515800f, 44.493130f, -100.579178f,
                44.449493f, -100.560533f, 44.168328f, -100.848518f, 44.168338f, -101.046893f, 43.846847f, -101.068008f, 43.841442f, -101.136740f,
                43.820253f, -101.141949f, 43.829918f, -101.165590f, 43.808797f, -101.169310f, 43.812404f, -101.206887f, 43.785232f, -101.233552f,
                42.997896f, -101.227692f, 42.997902f, -100.901392f, 42.813727f, -100.899765f, 42.813867f, -100.865008f, 42.784552f, -100.845418f,
                42.766993f, -100.845588f, 42.766993f, -102.432684f
            )
            poly[288] = TzPolygon(
                45.171146f, -100.291356f, 45.233192f, -100.260887f, 45.312309f, -100.316345f, 45.383984f, -100.277863f, 45.499245f, -100.363174f,
                45.536617f, -100.486488f, 45.594879f, -100.430214f, 45.653843f, -100.420937f, 45.654686f, -100.339493f, 45.702648f, -100.298958f,
                45.816643f, -100.387428f, 45.861507f, -100.357803f, 45.878887f, -100.426544f, 45.914410f, -100.423439f, 45.909294f, -100.473274f,
                45.943654f, -100.511793f, 45.944165f, -101.324059f, 46.127716f, -101.310051f, 46.149441f, -101.189552f, 46.186039f, -101.196503f,
                46.215271f, -101.116653f, 46.271698f, -101.096138f, 46.277943f, -101.025177f, 46.303230f, -100.999718f, 46.320118f, -101.017609f,
                46.325314f, -100.974876f, 46.373222f, -100.924683f, 46.373222f, -100.260872f, 45.171146f, -100.260872f
            )
            poly[289] = TzPolygon(
                46.373222f, -101.299215f, 46.373222f, -100.924683f, 46.325314f, -100.974876f, 46.320118f, -101.017609f, 46.303230f, -100.999718f,
                46.275612f, -101.036331f, 46.370392f, -101.048958f, 46.370533f, -101.299210f
            )
            poly[290] = TzPolygon(
                47.300749f, -101.346778f, 47.366879f, -101.362907f, 47.462914f, -101.441185f, 47.519905f, -101.374985f, 47.563206f, -101.435257f,
                47.527866f, -101.611702f, 47.530487f, -101.737099f, 47.495255f, -101.817497f, 47.534542f, -102.022751f, 47.572887f, -102.029465f,
                47.566730f, -102.183136f, 47.575298f, -102.194947f, 47.575298f, -101.346778f
            )
            poly[291] = TzPolygon(
                47.560222f, -102.432684f, 47.575298f, -102.423863f, 47.575298f, -102.205561f, 47.573383f, -102.203430f, 47.329155f, -102.207764f,
                47.327629f, -102.144234f, 46.982182f, -102.144226f, 46.980900f, -102.096992f, 46.717060f, -102.093910f, 46.717266f, -101.715202f,
                46.631027f, -101.716919f, 46.630083f, -101.346778f, 46.373222f, -101.346778f, 46.373222f, -102.432684f
            )
            poly[292] = TzPolygon(47.242036f, -101.346778f, 46.981875f, -101.346778f, 46.982071f, -101.763321f, 47.242020f, -101.763672f)
            poly[293] = TzPolygon(
                46.630083f, -101.346778f, 46.631027f, -101.716919f, 46.717266f, -101.715202f, 46.717060f, -102.093910f, 46.980900f, -102.096992f,
                46.981981f, -101.346778f
            )
            poly[294] = TzPolygon(46.630083f, -101.346778f, 46.629963f, -101.299706f, 46.373222f, -101.299215f, 46.373222f, -101.346778f)
            poly[295] = TzPolygon(47.300749f, -101.346778f, 47.291618f, -101.344551f, 47.268230f, -101.256798f, 47.242039f, -101.257156f, 47.242036f, -101.346778f)
            poly[296] = TzPolygon(
                47.242036f, -101.346778f, 47.242039f, -101.257156f, 47.268230f, -101.256798f, 47.246471f, -101.201141f, 47.278255f, -101.184792f,
                47.295284f, -101.078110f, 47.257961f, -100.985664f, 47.185822f, -100.988464f, 47.025436f, -100.879517f, 46.982574f, -100.935104f,
                46.981875f, -101.346778f
            )
            poly[297] = TzPolygon(
                46.373222f, -101.299215f, 46.629963f, -101.299706f, 46.630083f, -101.346778f, 46.981981f, -101.346778f, 46.982574f, -100.935104f,
                46.904800f, -100.908463f, 46.806805f, -100.817108f, 46.749069f, -100.834251f, 46.731529f, -100.774475f, 46.691620f, -100.788506f,
                46.689583f, -100.742447f, 46.656368f, -100.734642f, 46.677670f, -100.639626f, 46.634357f, -100.661606f, 46.593048f, -100.565109f,
                46.574833f, -100.586197f, 46.531155f, -100.543213f, 46.417394f, -100.608800f, 46.412235f, -100.681858f, 46.380089f, -100.720617f,
                46.400154f, -100.734940f, 46.385326f, -100.815903f, 46.407135f, -100.889153f, 46.373222f, -100.924683f
            )
            poly[298] = TzPolygon(
                38.511610f, -87.528698f, 38.518406f, -87.540489f, 38.491661f, -87.540695f, 38.499451f, -87.583733f, 38.450817f, -87.598877f,
                38.458000f, -87.655998f, 38.432560f, -87.662056f, 38.414097f, -87.744130f, 38.475069f, -87.739522f, 38.511911f, -87.654166f,
                38.568198f, -87.652334f, 38.590988f, -87.613831f, 38.641171f, -87.619362f, 38.682720f, -87.532755f, 38.689590f, -87.528698f
            )
            poly[299] = TzPolygon(38.829184f, -87.528698f, 38.863344f, -87.553384f, 38.895093f, -87.544089f, 38.895871f, -87.528698f)
        }
    }

    private object Initializer4 {
        fun init() {
            poly[300] = TzPolygon(38.397577f, -86.679886f, 38.397579f, -86.681435f, 38.444052f, -86.681713f, 38.444052f, -86.679886f)
            poly[301] = TzPolygon(38.263424f, -86.679886f, 38.397579f, -86.681435f, 38.397577f, -86.679886f)
            poly[302] = TzPolygon(
                38.444052f, -87.444677f, 38.444052f, -87.072437f, 38.232304f, -87.072975f, 38.231949f, -87.298546f, 38.377327f, -87.315987f,
                38.379398f, -87.407593f, 38.436062f, -87.407120f, 38.436230f, -87.444725f
            )
            poly[303] = TzPolygon(
                37.958689f, -86.782360f, 37.998324f, -86.813712f, 38.015083f, -86.797275f, 37.998108f, -86.772720f, 38.029007f, -86.766540f,
                38.040944f, -86.786442f, 38.101456f, -86.769600f, 38.143066f, -86.806618f, 38.249157f, -86.793579f, 38.256984f, -86.679886f,
                37.958689f, -86.679886f
            )
            poly[304] = TzPolygon(
                38.444052f, -87.072377f, 38.444052f, -86.681250f, 38.248470f, -86.679886f, 38.249157f, -86.793579f, 38.207005f, -86.793411f,
                38.206470f, -87.072777f
            )
            poly[305] = TzPolygon(38.929415f, -87.523497f, 38.917917f, -87.528698f, 38.929415f, -87.528698f)
            poly[306] = TzPolygon(38.829184f, -87.528698f, 38.788429f, -87.499245f, 38.743126f, -87.497078f, 38.689590f, -87.528698f)
            poly[307] = TzPolygon(
                38.498743f, -87.528698f, 38.495663f, -87.495476f, 38.532169f, -87.464203f, 38.466904f, -87.463936f, 38.467056f, -87.444534f,
                38.444052f, -87.444677f, 38.444052f, -87.528698f
            )
            poly[308] = TzPolygon(
                38.444052f, -86.679886f, 38.444052f, -86.681713f, 38.907909f, -86.684486f, 38.905399f, -87.528698f, 38.929415f, -87.520966f,
                38.929402f, -86.679886f
            )
            poly[309] = TzPolygon(
                38.444052f, -87.444677f, 38.467056f, -87.444534f, 38.466904f, -87.463936f, 38.532169f, -87.464203f, 38.539093f, -87.387802f,
                38.512032f, -87.369240f, 38.544285f, -87.358444f, 38.510220f, -87.302177f, 38.552521f, -87.203186f, 38.515636f, -87.151665f,
                38.537617f, -87.107735f, 38.514671f, -87.072258f, 38.444052f, -87.072437f
            )
            poly[310] = TzPolygon(37.958689f, -86.512997f, 38.027879f, -86.524969f, 38.045672f, -86.490685f, 37.958689f, -86.371197f)
            poly[311] = TzPolygon(38.397182f, -86.361189f, 38.397577f, -86.679886f, 38.444045f, -86.679886f, 38.444045f, -86.361189f)
            poly[312] = TzPolygon(
                38.256984f, -86.679886f, 38.264446f, -86.571495f, 38.208244f, -86.572021f, 38.208260f, -86.461319f, 38.106781f, -86.466217f,
                38.078303f, -86.430516f, 38.050490f, -86.452192f, 38.038327f, -86.521825f, 37.958689f, -86.511647f, 37.958689f, -86.679886f
            )
            poly[313] = TzPolygon(
                37.958689f, -86.371197f, 38.045672f, -86.490685f, 38.067171f, -86.432789f, 38.124531f, -86.457115f, 38.105040f, -86.401407f,
                38.129274f, -86.379775f, 38.130577f, -86.361189f, 37.958689f, -86.361189f
            )
            poly[314] = TzPolygon(38.166943f, -86.361189f, 38.171395f, -86.375225f, 38.196502f, -86.361189f)
            poly[315] = TzPolygon(
                38.397182f, -86.361189f, 38.444045f, -86.361189f, 38.444045f, -86.042493f, 38.419053f, -86.042493f, 38.422497f, -86.309082f,
                38.397114f, -86.306793f
            )
            poly[316] = TzPolygon(
                37.958689f, -86.043516f, 38.008641f, -86.094663f, 38.011308f, -86.178983f, 38.052721f, -86.261273f, 38.137874f, -86.271802f,
                38.180989f, -86.331092f, 38.201748f, -86.290321f, 38.291420f, -86.253128f, 38.316414f, -86.289413f, 38.361698f, -86.270500f,
                38.360294f, -86.248199f, 38.422401f, -86.254448f, 38.419165f, -86.042493f, 37.960669f, -86.042493f
            )
            poly[317] = TzPolygon(
                38.130577f, -86.361189f, 38.132877f, -86.328398f, 38.156236f, -86.327439f, 38.166943f, -86.361189f, 38.196728f, -86.361063f,
                38.137874f, -86.271802f, 38.052721f, -86.261273f, 38.011308f, -86.178983f, 38.008641f, -86.094663f, 37.958840f, -86.045374f,
                37.963889f, -86.042493f, 37.958689f, -86.042493f, 37.958689f, -86.361189f
            )
            poly[318] = TzPolygon(
                38.929392f, -86.042493f, 38.929382f, -85.405100f, 38.736694f, -85.405100f, 38.736431f, -85.416435f, 38.691794f, -85.456733f,
                38.586773f, -85.428366f, 38.586138f, -85.478087f, 38.606736f, -85.496666f, 38.604641f, -85.793938f, 38.563095f, -85.821411f,
                38.547020f, -85.866867f, 38.503147f, -85.884888f, 38.488686f, -85.993774f, 38.418438f, -85.994843f, 38.419053f, -86.042493f
            )
            poly[319] = TzPolygon(
                37.963889f, -86.042493f, 37.994708f, -86.024907f, 37.997100f, -85.934216f, 38.040669f, -85.882564f, 38.085315f, -85.719773f,
                38.073924f, -85.556654f, 38.118173f, -85.429050f, 38.263586f, -85.405100f, 37.958689f, -85.405100f, 37.958689f, -86.042493f
            )
            poly[320] = TzPolygon(
                38.263586f, -85.405100f, 38.380139f, -85.637879f, 38.440837f, -85.604147f, 38.467992f, -85.499305f, 38.537747f, -85.417766f,
                38.686032f, -85.456647f, 38.727023f, -85.437593f, 38.729917f, -85.405100f
            )
            poly[321] = TzPolygon(38.929382f, -85.405100f, 38.929379f, -85.203407f, 38.691010f, -85.201473f, 38.739879f, -85.267691f, 38.736694f, -85.405100f)
            poly[322] = TzPolygon(
                38.929415f, -85.135857f, 38.903080f, -85.140245f, 38.900969f, -84.870672f, 38.874978f, -84.784609f, 38.830370f, -84.829928f,
                38.783935f, -84.815615f, 38.778147f, -84.992287f, 38.687508f, -85.188442f, 38.929379f, -85.203407f
            )
            poly[323] = TzPolygon(
                38.929415f, -87.520966f, 38.954417f, -87.512187f, 38.988786f, -87.578319f, 39.057286f, -87.572588f, 39.144900f, -87.645990f,
                39.218404f, -87.574558f, 39.282050f, -87.609779f, 39.333649f, -87.588813f, 39.347706f, -87.531375f, 40.736892f, -87.526046f,
                40.736495f, -87.096788f, 40.839874f, -87.099533f, 40.840809f, -86.987160f, 40.913391f, -86.987656f, 40.909332f, -86.467178f,
                41.432968f, -86.466603f, 41.432869f, -86.524672f, 41.433800f, -86.524674f, 41.433800f, -86.466347f, 38.929415f, -86.466347f
            )
            poly[324] = TzPolygon(
                41.433800f, -86.641510f, 41.432968f, -86.466603f, 41.374874f, -86.466347f, 41.171120f, -86.467056f, 41.172207f, -86.930870f,
                41.237099f, -86.930038f, 41.285160f, -86.784241f, 41.400585f, -86.702057f
            )
            poly[325] = TzPolygon(
                41.172783f, -86.698959f, 41.171120f, -86.467056f, 40.997345f, -86.466530f, 40.909332f, -86.467178f, 40.913601f, -86.929291f,
                41.085999f, -86.930954f, 41.172207f, -86.930870f
            )
            poly[326] = TzPolygon(
                38.929415f, -85.135368f, 39.308182f, -85.065224f, 39.305186f, -84.819389f, 41.433800f, -84.807396f, 41.433800f, -74.790449f,
                38.929415f, -74.790449f
            )
            poly[327] = TzPolygon(
                47.575298f, -89.766677f, 46.566360f, -90.418620f, 46.533768f, -90.395069f, 46.553432f, -90.332230f, 46.516896f, -90.316554f,
                46.501768f, -90.216811f, 46.336992f, -90.120263f, 46.138388f, -89.091741f, 46.051242f, -88.888320f, 44.504549f, -88.888320f,
                44.504549f, -90.512970f, 47.575298f, -90.512970f
            )
            poly[328] = TzPolygon(
                46.417681f, -88.888320f, 46.417449f, -88.992379f, 46.330379f, -88.991730f, 46.332202f, -89.365776f, 46.503688f, -89.364647f,
                46.506355f, -89.738465f, 46.591235f, -89.737343f, 46.592727f, -89.865685f, 46.767847f, -89.862763f, 46.671753f, -90.035311f,
                46.608837f, -90.332711f, 46.566360f, -90.418620f, 47.575298f, -89.766677f, 47.575298f, -88.888320f
            )
            poly[329] = TzPolygon(45.782041f, -88.075995f, 45.809708f, -88.130129f, 45.866410f, -88.075995f)
            poly[330] = TzPolygon(
                45.874787f, -88.075995f, 45.882282f, -88.101264f, 45.921546f, -88.102461f, 45.963532f, -88.246894f, 45.955215f, -88.327464f,
                45.991765f, -88.380503f, 45.975092f, -88.416381f, 45.999514f, -88.458672f, 45.991367f, -88.489355f, 46.020019f, -88.514692f,
                46.017770f, -88.601178f, 45.987896f, -88.615957f, 45.988547f, -88.670827f, 46.013699f, -88.679073f, 46.015157f, -88.780220f,
                46.033645f, -88.796557f, 46.020340f, -88.816187f, 46.039924f, -88.861900f, 46.039924f, -88.075995f
            )
            poly[331] = TzPolygon(45.874787f, -88.075995f, 45.872938f, -88.069763f, 45.866410f, -88.075995f)
            poly[332] = TzPolygon(
                45.782041f, -88.075995f, 45.780085f, -88.072167f, 45.795393f, -87.991447f, 45.758220f, -87.963452f, 45.754379f, -87.876898f,
                45.681483f, -87.781419f, 45.652987f, -87.825129f, 45.588498f, -87.777199f, 45.563055f, -87.792372f, 45.561045f, -87.833733f,
                45.499967f, -87.792769f, 45.434473f, -87.861697f, 45.403872f, -87.849322f, 45.354697f, -87.888052f, 45.349442f, -87.754104f,
                45.389893f, -87.693956f, 45.368754f, -87.657350f, 45.339396f, -87.648126f, 45.197469f, -87.741810f, 45.107512f, -87.659952f,
                45.076434f, -87.442508f, 45.201969f, -87.405694f, 45.240657f, -87.315422f, 45.280796f, -87.263670f, 44.504549f, -87.263670f,
                44.504549f, -88.075995f
            )
            poly[333] = TzPolygon(
                45.280796f, -87.263670f, 45.240657f, -87.315422f, 45.201969f, -87.405694f, 45.076434f, -87.442508f, 45.094765f, -87.591660f,
                45.150084f, -87.599895f, 45.293051f, -87.436172f, 45.539402f, -87.263670f
            )
            poly[334] = TzPolygon(
                45.539402f, -87.263670f, 45.549538f, -87.330078f, 45.898045f, -87.329216f, 45.897785f, -87.370407f, 45.984730f, -87.370888f,
                45.985188f, -87.620338f, 46.039924f, -87.620033f, 46.039924f, -87.263670f
            )
            poly[335] = TzPolygon(46.051242f, -88.888320f, 46.039924f, -88.861900f, 46.039924f, -88.888320f)
            poly[336] = TzPolygon(
                46.039924f, -88.861900f, 46.051242f, -88.888320f, 46.417681f, -88.888320f, 46.419403f, -88.117409f, 46.247120f, -88.117798f,
                46.247551f, -87.618874f, 46.039924f, -87.620033f
            )
            poly[337] = TzPolygon(
                45.280796f, -87.263670f, 45.352540f, -87.171170f, 45.444230f, -87.101133f, 45.443610f, -86.754236f, 45.236125f, -86.249548f,
                45.080800f, -86.499930f, 44.881002f, -86.686288f, 44.131905f, -87.013234f, 43.734111f, -87.114102f, 43.379859f, -87.147166f,
                42.493800f, -87.019861f, 41.760956f, -87.207774f, 41.759659f, -86.524217f, 41.650224f, -86.526638f, 41.649516f, -86.487267f,
                41.570473f, -86.486484f, 41.523012f, -86.499957f, 41.519988f, -86.524839f, 41.433800f, -86.524674f, 41.433800f, -87.263670f
            )
            poly[338] = TzPolygon(
                41.433800f, -86.524674f, 41.519988f, -86.524839f, 41.523012f, -86.499957f, 41.577677f, -86.486173f, 41.649516f, -86.487267f,
                41.650224f, -86.526638f, 41.759659f, -86.524217f, 41.760216f, -84.805883f, 41.433800f, -84.804620f
            )
            poly[339] = TzPolygon(41.433800f, -84.807396f, 41.696046f, -84.805919f, 41.713984f, -84.145365f, 41.433800f, -84.145365f)
            poly[340] = TzPolygon(
                46.531101f, -84.145365f, 46.534056f, -84.225889f, 46.492944f, -84.276250f, 46.500583f, -84.421139f, 46.452861f, -84.475639f,
                46.460806f, -84.556833f, 46.634306f, -84.762833f, 46.888917f, -84.860139f, 47.575298f, -86.560039f, 47.575298f, -84.145365f
            )
            poly[341] = TzPolygon(46.531101f, -84.145365f, 46.530500f, -84.129000f, 46.504222f, -84.111139f, 46.420470f, -84.145365f)
            poly[342] = TzPolygon(
                46.415536f, -84.145365f, 46.241444f, -84.108250f, 46.187333f, -84.077139f, 46.149444f, -84.005972f, 46.056750f, -83.955472f,
                46.060444f, -83.903528f, 46.118861f, -83.826333f, 46.105778f, -83.571944f, 45.998167f, -83.433778f, 45.821278f, -83.597167f,
                45.338639f, -82.518611f, 43.591194f, -82.122806f, 42.925812f, -82.456027f, 42.761906f, -82.467667f, 42.609849f, -82.521568f,
                42.550978f, -82.589981f, 42.541746f, -82.661886f, 42.373492f, -82.830250f, 42.308680f, -83.079419f, 42.238412f, -83.126361f,
                42.125263f, -83.119228f, 42.041000f, -83.149694f, 41.959410f, -83.112460f, 41.733794f, -83.415851f, 41.713984f, -84.145365f
            )
            poly[343] = TzPolygon(
                41.713984f, -84.145365f, 41.733794f, -83.415851f, 41.959410f, -83.112460f, 41.863583f, -83.069111f, 41.676556f, -82.679722f,
                41.676556f, -82.397472f, 42.207556f, -81.245722f, 42.242444f, -81.027060f, 41.433800f, -81.027060f, 41.433800f, -84.145365f
            )
            poly[344] = TzPolygon(
                45.006278f, -74.790449f, 45.015861f, -74.826528f, 44.977500f, -74.992806f, 44.772167f, -75.413722f, 44.515278f, -75.766917f,
                44.432056f, -75.821389f, 44.367806f, -75.912833f, 44.280722f, -76.161806f, 44.239833f, -76.164306f, 44.215000f, -76.206833f,
                44.199056f, -76.312722f, 44.134333f, -76.352861f, 44.094056f, -76.438944f, 43.631139f, -76.796694f, 43.631139f, -78.690389f,
                43.450472f, -79.200667f, 43.254667f, -79.055944f, 43.143667f, -79.042333f, 43.077861f, -79.074111f, 43.057885f, -79.000418f,
                42.984056f, -79.016418f, 42.933576f, -78.909411f, 42.828304f, -78.935381f, 42.393556f, -80.079944f, 42.242444f, -81.027060f,
                47.575298f, -81.027060f, 47.575298f, -74.790449f
            )
            poly[345] = TzPolygon(
                49.000262f, -108.824497f, 48.999877f, -104.048736f, 47.997105f, -104.044118f, 47.959892f, -103.965942f, 47.848114f, -103.965576f,
                47.848930f, -103.800613f, 47.675797f, -103.799232f, 47.675842f, -103.738724f, 47.588871f, -103.737091f, 47.589474f, -103.610252f,
                47.575298f, -103.610132f, 47.575298f, -108.824497f
            )
            poly[346] = TzPolygon(
                47.575298f, -103.436537f, 47.591843f, -103.438537f, 47.576626f, -103.069450f, 47.633202f, -103.020645f, 47.669712f, -103.038185f,
                47.674011f, -103.004082f, 47.600971f, -102.865021f, 47.575298f, -102.711964f
            )
            poly[347] = TzPolygon(48.999474f, -102.711964f, 48.999483f, -108.824497f, 49.384490f, -108.824497f, 49.384490f, -102.711964f)
            poly[348] = TzPolygon(47.575298f, -102.423863f, 47.590809f, -102.414787f, 47.615253f, -102.250025f, 47.575298f, -102.250025f)
            poly[349] = TzPolygon(47.615253f, -102.250025f, 47.575298f, -102.205561f, 47.575298f, -102.250025f)
            poly[350] = TzPolygon(48.999891f, -102.711964f, 48.999968f, -95.153150f, 47.615253f, -95.153150f, 47.615253f, -102.711964f)
            poly[351] = TzPolygon(49.384490f, -95.153422f, 48.999968f, -95.153150f, 48.999472f, -101.361990f, 49.384490f, -101.384065f)
            poly[352] = TzPolygon(
                49.384401f, -95.153150f, 49.353250f, -95.058306f, 49.370194f, -94.957389f, 49.321389f, -94.816278f, 48.884111f, -94.683444f,
                48.789444f, -94.694389f, 48.741222f, -94.641278f, 48.692389f, -94.452389f, 48.710972f, -94.415833f, 48.707806f, -94.291194f,
                48.649444f, -94.224194f, 48.630222f, -93.844361f, 48.516306f, -93.793361f, 48.546444f, -93.467389f, 48.591639f, -93.465472f,
                48.642806f, -93.254667f, 48.623250f, -93.178389f, 48.631556f, -92.954778f, 48.608361f, -92.950000f, 48.539389f, -92.728417f,
                48.542556f, -92.634889f, 48.503278f, -92.627028f, 48.494833f, -92.698694f, 48.462972f, -92.712694f, 48.436472f, -92.656222f,
                48.442630f, -92.576575f, 47.575298f, -92.576575f, 47.575298f, -95.153150f
            )
            poly[353] = TzPolygon(48.736900f, -94.540200f, 48.705211f, -94.540403f, 48.736900f, -94.618618f)
            poly[354] = TzPolygon(
                48.442630f, -92.576575f, 48.447972f, -92.507472f, 48.414083f, -92.456444f, 48.352083f, -92.469778f, 48.220278f, -92.369917f,
                48.248194f, -92.269583f, 48.316250f, -92.306167f, 48.354917f, -92.262556f, 48.359361f, -92.055222f, 48.321083f, -92.000111f,
                48.265417f, -92.006528f, 48.252250f, -91.954111f, 48.233139f, -91.958361f, 48.237972f, -91.893111f, 48.206944f, -91.864361f,
                48.199500f, -91.715361f, 48.114639f, -91.711750f, 48.122500f, -91.682111f, 48.097111f, -91.639917f, 48.108583f, -91.559111f,
                48.043778f, -91.567500f, 48.068389f, -91.488194f, 48.048667f, -91.429583f, 48.074848f, -91.288287f, 47.575298f, -91.288287f,
                47.575298f, -92.576575f
            )
            poly[355] = TzPolygon(
                49.384450f, -92.576575f, 49.384474f, -91.288287f, 49.000000f, -91.288287f, 49.000000f, -91.752800f, 48.661400f, -91.752800f,
                48.647400f, -91.924900f, 48.617100f, -92.012400f, 48.560600f, -92.097900f, 48.545500f, -92.178500f, 48.464100f, -92.267200f,
                48.464100f, -92.219900f, 48.405600f, -92.150900f, 48.405600f, -91.955800f, 48.377600f, -91.955800f, 48.353878f, -92.051986f,
                48.354917f, -92.262556f, 48.316250f, -92.306167f, 48.248194f, -92.269583f, 48.220167f, -92.369139f, 48.352083f, -92.469778f,
                48.414083f, -92.456444f, 48.447972f, -92.507472f, 48.442630f, -92.576575f
            )
            poly[356] = TzPolygon(
                48.074848f, -91.288287f, 48.078833f, -91.266778f, 48.181139f, -91.082472f, 48.245944f, -90.885750f, 48.239556f, -90.839306f,
                48.177028f, -90.836389f, 48.163833f, -90.777944f, 48.136889f, -90.798222f, 48.090972f, -90.751583f, 48.123806f, -90.579667f,
                48.095917f, -90.556694f, 48.108750f, -90.467389f, 48.090917f, -90.374278f, 48.112611f, -90.140833f, 48.084833f, -90.023333f,
                48.040013f, -90.000000f, 47.575298f, -90.000000f, 47.575298f, -91.288287f
            )
            poly[357] = TzPolygon(
                48.250000f, -90.000000f, 48.500000f, -90.963900f, 49.000000f, -90.963900f, 49.000000f, -91.000000f, 49.250000f, -91.000000f,
                49.384490f, -90.462040f, 49.384490f, -90.000000f
            )
            poly[358] = TzPolygon(49.384474f, -91.288287f, 49.384490f, -90.462040f, 49.250000f, -91.000000f, 49.000000f, -91.000000f, 49.000000f, -91.288287f)
            poly[359] = TzPolygon(
                48.040013f, -90.000000f, 48.028167f, -89.993833f, 47.987667f, -89.897194f, 48.022944f, -89.775361f, 48.003694f, -89.650861f,
                48.018000f, -89.610694f, 47.996028f, -89.580972f, 48.013716f, -89.483385f, 47.575298f, -89.766677f, 47.575298f, -90.000000f
            )
            poly[360] = TzPolygon(
                47.575298f, -89.766677f, 48.013716f, -89.483385f, 47.974261f, -89.337550f, 48.245397f, -88.677442f, 48.306063f, -88.369862f,
                47.575298f, -86.560039f
            )
            poly[361] = TzPolygon(
                48.515693f, -89.241770f, 48.514520f, -89.182575f, 48.483230f, -89.182238f, 48.498834f, -89.152530f, 48.475771f, -89.151415f,
                48.337464f, -89.203006f, 48.354095f, -89.289440f, 48.289425f, -89.338349f, 48.289522f, -89.388614f, 48.514883f, -89.427850f
            )
            poly[362] = TzPolygon(48.515693f, -74.790449f, 48.515693f, -90.000000f, 49.384490f, -90.000000f, 49.384490f, -74.790449f)
            poly[363] = TzPolygon(
                16.259052f, -92.524388f, 16.259052f, -90.424127f, 16.249459f, -90.456243f, 16.233535f, -90.429012f, 16.208770f, -90.458378f,
                16.163874f, -90.426029f, 16.149302f, -90.452232f, 16.137619f, -90.429320f, 16.111279f, -90.458890f, 16.092712f, -90.454985f,
                16.103160f, -90.426183f, 16.073805f, -90.442155f, 16.073893f, -91.731518f, 15.260624f, -92.210543f, 15.069636f, -92.059330f,
                15.021265f, -92.085653f, 14.989379f, -92.150485f, 14.891650f, -92.136216f, 14.828263f, -92.184847f, 14.690168f, -92.142914f,
                14.575174f, -92.184044f, 14.388624f, -92.374389f, 14.534506f, -92.524388f
            )
            poly[364] = TzPolygon(16.259052f, -90.424127f, 16.298406f, -90.437307f, 16.298406f, -90.424127f)
            poly[365] = TzPolygon(
                14.277527f, -90.424127f, 14.277527f, -89.540646f, 14.219981f, -89.525447f, 14.185392f, -89.666846f, 14.119336f, -89.725527f,
                14.031734f, -89.737473f, 14.058552f, -89.855956f, 13.939036f, -90.023241f, 13.897435f, -90.036101f, 13.834582f, -90.112175f,
                13.782988f, -90.117143f, 13.753666f, -90.093049f, 13.747068f, -90.135096f, 13.634580f, -90.179097f, 13.730129f, -90.424127f
            )
            poly[366] = TzPolygon(
                14.145074f, -88.763006f, 14.164585f, -88.798875f, 14.118432f, -88.807631f, 14.104579f, -88.831290f, 14.178619f, -88.866682f,
                14.205668f, -88.902709f, 14.213175f, -88.972326f, 14.258578f, -88.991514f, 14.271430f, -89.025804f, 14.277527f, -89.025307f,
                14.277527f, -88.763006f
            )
            poly[367] = TzPolygon(
                13.100948f, -88.763006f, 14.145074f, -88.763006f, 14.131238f, -88.737571f, 14.010135f, -88.683569f, 14.022820f, -88.627710f,
                13.978223f, -88.569002f, 13.985429f, -88.528992f, 13.966999f, -88.499758f, 13.910913f, -88.510959f, 13.848557f, -88.468004f,
                13.885732f, -88.418651f, 13.870320f, -88.356406f, 13.896078f, -88.345368f, 13.889904f, -88.317336f, 13.914481f, -88.265897f,
                13.937240f, -88.265183f, 13.937823f, -88.226871f, 13.999938f, -88.230003f, 13.992271f, -88.072735f, 13.871008f, -88.014784f,
                13.902854f, -87.959032f, 13.884478f, -87.922072f, 13.920512f, -87.799886f, 13.892242f, -87.798994f, 13.804020f, -87.708407f,
                13.689278f, -87.755454f, 13.603910f, -87.754399f, 13.524001f, -87.793452f, 13.505334f, -87.720768f, 13.467370f, -87.716363f,
                13.442394f, -87.723823f, 13.405345f, -87.821631f, 13.348959f, -87.743498f, 13.197257f, -87.635139f, 13.127742f, -87.662906f,
                13.055135f, -87.811139f, 12.976046f, -87.901532f, 13.040801f, -88.149177f, 13.028296f, -88.402676f
            )
            poly[368] = TzPolygon(
                12.256649f, -87.101885f, 12.335098f, -87.236893f, 12.676029f, -87.588116f, 12.781743f, -87.741651f, 12.976046f, -87.901532f,
                13.108935f, -87.720047f, 13.167505f, -87.543216f, 13.078127f, -87.479358f, 12.994697f, -87.376361f, 13.001460f, -87.101885f
            )
            poly[369] = TzPolygon(
                14.277527f, -89.540646f, 14.295730f, -89.545454f, 14.311504f, -89.592266f, 14.347040f, -89.587545f, 14.351679f, -89.563425f,
                14.416928f, -89.573916f, 14.416140f, -89.542585f, 14.379612f, -89.529608f, 14.419990f, -89.491408f, 14.412105f, -89.434759f,
                14.451049f, -89.392882f, 14.427541f, -89.385231f, 14.438066f, -89.334515f, 14.364758f, -89.181962f, 14.402375f, -89.097665f,
                14.341079f, -89.082640f, 14.314239f, -89.022311f, 14.277527f, -89.025307f
            )
            poly[370] = TzPolygon(
                14.277527f, -89.025307f, 14.314239f, -89.022311f, 14.341079f, -89.082640f, 14.402375f, -89.097665f, 14.367367f, -89.194944f,
                14.438066f, -89.334515f, 14.420616f, -89.355987f, 14.466834f, -89.356821f, 14.493859f, -89.301905f, 14.584726f, -89.238782f,
                14.584238f, -89.153547f, 14.671379f, -89.157208f, 14.712619f, -89.131294f, 14.731076f, -89.165396f, 14.775031f, -89.168907f,
                14.834737f, -89.223766f, 14.882547f, -89.228084f, 14.928755f, -89.172682f, 14.979754f, -89.156632f, 15.002481f, -89.184430f,
                15.068276f, -89.153596f, 15.136248f, -88.973842f, 15.287732f, -88.763006f, 14.277527f, -88.763006f
            )
            poly[371] = TzPolygon(
                16.298406f, -88.763006f, 15.966730f, -88.763006f, 15.958374f, -88.770630f, 15.887454f, -88.922818f, 15.894432f, -89.019023f,
                15.917339f, -89.054640f, 15.895775f, -89.114966f, 15.913280f, -89.176491f, 15.885729f, -89.222330f, 15.896013f, -89.227325f,
                16.298406f, -89.200533f
            )
            poly[372] = TzPolygon(16.298406f, -88.308067f, 16.069956f, -88.498377f, 16.050990f, -88.686124f, 15.966730f, -88.763006f, 16.298406f, -88.763006f)
            poly[373] = TzPolygon(
                15.966730f, -88.763006f, 16.050990f, -88.686124f, 16.069956f, -88.498377f, 15.907558f, -88.175585f, 15.723487f, -88.221558f,
                15.720511f, -88.250984f, 15.688664f, -88.248414f, 15.672459f, -88.324726f, 15.618539f, -88.344576f, 15.426124f, -88.570391f,
                15.287732f, -88.763006f
            )
            poly[374] = TzPolygon(
                16.298406f, -90.437307f, 16.304503f, -90.439349f, 16.339694f, -90.382597f, 16.363924f, -90.410369f, 16.363477f, -90.372459f,
                16.394145f, -90.403333f, 16.413297f, -90.389878f, 16.423064f, -90.485338f, 16.460803f, -90.479847f, 16.457908f, -90.529304f,
                16.482848f, -90.546729f, 16.478371f, -90.631161f, 16.502727f, -90.605928f, 16.521325f, -90.615713f, 16.517957f, -90.646068f,
                16.560845f, -90.646977f, 16.577744f, -90.626069f, 16.595848f, -90.641200f, 16.581823f, -90.667110f, 16.640335f, -90.658118f,
                16.727064f, -90.714251f, 16.775668f, -90.802141f, 16.798266f, -90.804094f, 16.821935f, -90.921765f, 16.859326f, -90.933639f,
                16.863626f, -90.974055f, 16.884474f, -90.954509f, 16.901500f, -90.965009f, 16.897954f, -90.985063f, 16.863085f, -90.987831f,
                16.902858f, -91.065627f, 17.003384f, -91.122759f, 17.015704f, -91.175253f, 17.095059f, -91.226958f, 17.107878f, -91.266943f,
                17.170133f, -91.266447f, 17.182747f, -91.324450f, 17.160025f, -91.349162f, 17.190517f, -91.354455f, 17.209295f, -91.418817f,
                17.250000f, -91.439759f, 17.251299f, -90.987446f, 17.575193f, -90.987601f, 17.575193f, -90.371441f, 16.298406f, -90.371441f
            )
            poly[375] = TzPolygon(17.575193f, -90.987601f, 17.815344f, -90.987716f, 17.816509f, -90.371441f, 17.575193f, -90.371441f)
            poly[376] = TzPolygon(
                18.849401f, -92.524388f, 18.851981f, -92.511081f, 18.619346f, -92.466890f, 18.561630f, -92.427845f, 18.485672f, -92.412844f,
                18.442230f, -92.353757f, 18.473050f, -92.322530f, 18.455438f, -92.310338f, 18.458227f, -92.176022f, 18.274024f, -92.183284f,
                18.210378f, -92.148868f, 18.155359f, -92.160887f, 18.096940f, -92.127485f, 18.097877f, -92.039638f, 18.077910f, -92.041963f,
                18.015899f, -91.966637f, 18.012147f, -91.900430f, 17.939001f, -91.762300f, 17.957731f, -91.760483f, 17.872736f, -91.638158f,
                17.913322f, -91.614159f, 18.059632f, -91.619246f, 18.109727f, -91.589369f, 18.121264f, -91.604321f, 18.137312f, -91.572335f,
                18.157642f, -91.579693f, 18.170173f, -91.509666f, 18.116099f, -91.504344f, 18.063101f, -91.384947f, 18.061876f, -91.327121f,
                17.974344f, -91.217261f, 17.962393f, -90.987969f, 17.575193f, -90.987684f, 17.575193f, -92.524388f
            )
            poly[377] = TzPolygon(
                16.298406f, -89.200533f, 17.057407f, -89.149998f, 17.939527f, -89.151957f, 17.972034f, -89.132705f, 18.005122f, -89.037521f,
                17.984429f, -89.000621f, 17.947284f, -88.987224f, 17.959130f, -88.944780f, 17.910595f, -88.913682f, 17.894461f, -88.859766f,
                17.925191f, -88.859435f, 17.979861f, -88.784455f, 18.034298f, -88.766652f, 18.050158f, -88.736663f, 16.298406f, -88.736663f
            )
            poly[378] = TzPolygon(17.816509f, -90.371441f, 17.815629f, -89.151901f, 17.057407f, -89.149998f, 16.298406f, -89.198679f, 16.298406f, -90.371441f)
            poly[379] = TzPolygon(
                17.812455f, -90.371441f, 18.851981f, -90.371441f, 18.851981f, -89.148766f, 18.451059f, -89.150238f, 18.450625f, -89.125490f,
                18.385850f, -89.121229f, 18.385544f, -89.138214f, 18.293403f, -89.132359f, 18.293563f, -89.151674f, 18.145820f, -89.143066f,
                18.144629f, -89.200237f, 18.083276f, -89.202458f, 18.082443f, -89.144383f, 18.057699f, -89.144753f, 18.057885f, -89.163361f,
                18.018517f, -89.163004f, 18.021080f, -89.206739f, 17.992649f, -89.207414f, 17.954100f, -89.205872f, 17.953610f, -89.152170f,
                17.815629f, -89.151901f, 17.812425f, -90.365047f
            )
            poly[380] = TzPolygon(
                18.851981f, -87.129834f, 18.770071f, -87.101885f, 18.667023f, -87.124465f, 18.550777f, -87.117376f, 18.439605f, -87.182276f,
                18.377497f, -87.307357f, 18.393330f, -87.441241f, 18.478926f, -87.538576f, 18.351753f, -87.561545f, 18.246657f, -87.620556f,
                18.198073f, -87.384787f, 17.916751f, -87.374960f, 17.924180f, -87.434822f, 18.198662f, -87.864800f, 18.150168f, -87.910739f,
                18.170324f, -87.932531f, 18.167524f, -88.031167f, 18.414794f, -88.030366f, 18.415552f, -88.249634f, 18.473072f, -88.250094f,
                18.490429f, -88.326816f, 18.478804f, -88.380268f, 18.496001f, -88.401988f, 18.475466f, -88.447752f, 18.493721f, -88.477921f,
                18.461118f, -88.519442f, 18.360991f, -88.544032f, 18.291741f, -88.605832f, 18.241034f, -88.604686f, 18.187040f, -88.694135f,
                18.160635f, -88.679938f, 18.108941f, -88.718544f, 18.060831f, -88.716481f, 18.050158f, -88.736663f, 18.851981f, -88.736663f
            )
            poly[381] = TzPolygon(
                13.720672f, -87.101885f, 13.720672f, -86.774558f, 13.662250f, -86.786064f, 13.639266f, -86.748981f, 13.576901f, -86.769896f,
                13.565278f, -86.749444f, 13.456838f, -86.723426f, 13.401947f, -86.744380f, 13.365078f, -86.706584f, 13.302806f, -86.705795f,
                13.267457f, -86.754339f, 13.313278f, -86.829022f, 13.268786f, -86.909146f, 13.179331f, -86.932968f, 13.155258f, -86.913404f,
                13.125607f, -86.934448f, 13.092221f, -86.918100f, 13.030384f, -86.963393f, 12.980849f, -87.050016f, 13.002376f, -87.064708f,
                13.001460f, -87.101885f
            )
            poly[382] = TzPolygon(
                13.720672f, -86.774558f, 13.766650f, -86.765502f, 13.805277f, -86.538446f, 13.769475f, -86.490754f, 13.789847f, -86.453698f,
                13.759092f, -86.416965f, 13.769130f, -86.332264f, 13.816086f, -86.296220f, 13.853328f, -86.298805f, 13.955358f, -86.186003f,
                13.984034f, -86.190698f, 13.999506f, -86.140736f, 14.035004f, -86.152978f, 14.056080f, -86.087047f, 13.720672f, -86.087047f
            )
            poly[383] = TzPolygon(
                14.559175f, -85.072210f, 14.552383f, -85.085021f, 14.585950f, -85.122754f, 14.571808f, -85.151605f, 14.516122f, -85.138886f,
                14.467860f, -85.184048f, 14.428347f, -85.181168f, 14.376760f, -85.220760f, 14.302328f, -85.153396f, 14.250447f, -85.184492f,
                14.248847f, -85.339429f, 14.213072f, -85.360887f, 14.221559f, -85.382688f, 14.182618f, -85.374620f, 14.123121f, -85.404112f,
                14.114386f, -85.453907f, 14.076191f, -85.493674f, 14.087987f, -85.505505f, 14.047456f, -85.519395f, 14.065053f, -85.573277f,
                14.009205f, -85.624677f, 14.012045f, -85.663904f, 13.979960f, -85.676409f, 13.992992f, -85.706770f, 13.967796f, -85.753368f,
                13.884232f, -85.764078f, 13.861490f, -85.733329f, 13.832231f, -85.752179f, 13.849245f, -85.819735f, 13.917630f, -85.845418f,
                13.929565f, -85.881971f, 13.904389f, -85.892264f, 13.908462f, -85.913741f, 13.937596f, -85.918517f, 13.996174f, -86.042070f,
                14.080251f, -86.011436f, 14.056080f, -86.087047f, 15.033118f, -86.087047f, 15.033118f, -85.072210f
            )
            poly[384] = TzPolygon(
                15.033118f, -84.057372f, 14.768870f, -84.057372f, 14.757257f, -84.080363f, 14.786595f, -84.081890f, 14.790840f, -84.109833f,
                14.730143f, -84.095786f, 14.714501f, -84.166838f, 14.733676f, -84.227982f, 14.760610f, -84.235393f, 14.734407f, -84.271861f,
                14.678450f, -84.257886f, 14.662151f, -84.276870f, 14.684466f, -84.309845f, 14.679823f, -84.349403f, 14.716600f, -84.363387f,
                14.641557f, -84.414640f, 14.615845f, -84.468591f, 14.630248f, -84.530006f, 14.656355f, -84.524823f, 14.672595f, -84.665449f,
                14.693937f, -84.671846f, 14.664427f, -84.701532f, 14.692135f, -84.703552f, 14.715354f, -84.744812f, 14.748499f, -84.742977f,
                14.749021f, -84.771452f, 14.769684f, -84.749964f, 14.816129f, -84.790005f, 14.815225f, -84.898119f, 14.758801f, -84.927052f,
                14.756339f, -84.960370f, 14.702999f, -85.028408f, 14.673460f, -85.027047f, 14.660705f, -85.050771f, 14.637776f, -85.024545f,
                14.610495f, -85.043113f, 14.608882f, -85.021580f, 14.574834f, -85.042675f, 14.559175f, -85.072210f, 15.033118f, -85.072210f
            )
            poly[385] = TzPolygon(
                15.033118f, -83.067713f, 14.982508f, -83.232472f, 14.987660f, -83.277698f, 15.005997f, -83.276406f, 15.010115f, -83.344316f,
                14.995260f, -83.348309f, 15.029703f, -83.402169f, 14.990321f, -83.420436f, 14.980954f, -83.461915f, 15.011168f, -83.498172f,
                14.993470f, -83.528232f, 14.950065f, -83.529020f, 14.957165f, -83.548585f, 14.942244f, -83.537973f, 14.939113f, -83.559893f,
                14.912364f, -83.560000f, 14.919717f, -83.598627f, 14.874506f, -83.615744f, 14.880117f, -83.694040f, 14.853365f, -83.722334f,
                14.851292f, -83.700325f, 14.824157f, -83.701593f, 14.841167f, -83.732111f, 14.819170f, -83.732036f, 14.831578f, -83.753157f,
                14.806214f, -83.763669f, 14.823592f, -83.783414f, 14.773029f, -83.843796f, 14.777283f, -83.936435f, 14.747678f, -83.923560f,
                14.760857f, -83.997235f, 14.746565f, -84.033344f, 14.774676f, -84.045877f, 14.768870f, -84.057372f, 15.033118f, -84.057372f
            )
            poly[386] = TzPolygon(
                18.851981f, -89.148766f, 19.423862f, -89.146667f, 19.551174f, -89.296562f, 19.608022f, -89.219556f, 19.636657f, -89.222869f,
                19.644006f, -89.189203f, 19.637399f, -89.144862f, 19.581249f, -89.149521f, 19.581996f, -89.122003f, 18.851981f, -89.122003f
            )
            poly[387] = TzPolygon(19.613575f, -89.122003f, 19.614632f, -89.133641f, 19.703424f, -89.123398f, 19.703018f, -89.122003f)
            poly[388] = TzPolygon(
                21.568334f, -89.122003f, 21.594353f, -88.923560f, 21.622503f, -88.822025f, 21.715895f, -88.686540f, 21.767420f, -88.437039f,
                21.766912f, -88.313606f, 21.817224f, -88.214802f, 21.830571f, -88.137432f, 21.802200f, -87.908309f, 21.736884f, -87.730326f,
                21.690434f, -87.510980f, 21.490226f, -87.534927f, 20.999602f, -87.533145f, 20.653787f, -87.744259f, 20.446706f, -87.962742f,
                20.447316f, -87.995065f, 20.417993f, -87.992960f, 20.281372f, -88.136490f, 20.290342f, -88.264634f, 20.269120f, -88.266815f,
                20.253510f, -88.308788f, 20.252097f, -88.409128f, 20.239489f, -88.402892f, 20.238150f, -88.443426f, 20.192328f, -88.519930f,
                20.190078f, -88.502345f, 20.143391f, -88.507621f, 20.148078f, -88.576681f, 20.089856f, -88.690609f, 20.010357f, -88.700176f,
                20.008180f, -88.783503f, 19.879926f, -88.825926f, 19.861114f, -88.900488f, 19.790949f, -88.929512f, 19.818101f, -88.974452f,
                19.772007f, -89.004087f, 19.776710f, -89.025163f, 19.721493f, -89.048827f, 19.727440f, -88.994741f, 19.704884f, -88.997529f,
                19.708832f, -89.030524f, 19.678040f, -89.036200f, 19.703018f, -89.122003f
            )
            poly[389] = TzPolygon(19.613575f, -89.122003f, 19.612339f, -89.108392f, 19.582349f, -89.109024f, 19.581996f, -89.122003f)
            poly[390] = TzPolygon(
                37.958689f, -86.782360f, 37.958689f, -86.511647f, 37.928829f, -86.507831f, 37.921159f, -86.588581f, 37.858272f, -86.604624f,
                37.841425f, -86.648028f, 37.908621f, -86.647081f, 37.894340f, -86.731460f
            )
            poly[391] = TzPolygon(19.973824f, -75.166823f, 19.973820f, -75.086645f, 19.871762f, -75.086563f, 19.869741f, -75.232488f, 19.934591f, -75.232020f)
            poly[392] = TzPolygon(
                21.151443f, -74.790449f, 22.032971f, -77.214826f, 22.432278f, -77.820528f, 22.596111f, -78.115444f, 22.875357f, -78.790845f,
                23.301043f, -79.595880f, 23.481697f, -80.377255f, 23.481697f, -74.790449f
            )
            poly[393] = TzPolygon(
                31.530347f, -86.493266f, 31.530347f, -85.044373f, 31.364576f, -85.092167f, 31.295026f, -85.089774f, 31.276459f, -85.115002f,
                31.186451f, -85.107516f, 31.108192f, -85.035615f, 30.975908f, -85.005734f, 30.883588f, -84.934424f, 30.765990f, -84.920123f,
                30.696945f, -84.857970f, 30.621382f, -84.905951f, 30.580353f, -84.965686f, 30.476521f, -85.004434f, 30.444532f, -84.980511f,
                30.420581f, -85.032729f, 30.409785f, -85.013683f, 30.338185f, -85.050313f, 30.312492f, -85.034069f, 30.170786f, -85.139824f,
                30.117562f, -85.129544f, 30.095280f, -85.152987f, 30.043015f, -85.135569f, 29.987685f, -85.029921f, 29.950987f, -85.017954f,
                29.910286f, -85.053762f, 29.818844f, -85.019326f, 29.779549f, -85.039964f, 29.774351f, -85.104830f, 29.827949f, -85.190491f,
                29.877006f, -85.210854f, 29.968375f, -85.371508f, 30.027346f, -85.391303f, 29.924309f, -85.388447f, 29.810239f, -85.646555f,
                29.894167f, -85.745172f, 30.094399f, -86.111887f, 30.170999f, -86.366191f, 30.182735f, -86.493266f
            )
            poly[394] = TzPolygon(
                31.530347f, -85.044373f, 31.540987f, -85.041305f, 31.620227f, -85.058169f, 31.694965f, -85.125530f, 31.782181f, -85.141876f,
                31.892160f, -85.134131f, 31.940159f, -85.078930f, 32.021701f, -85.048825f, 32.132486f, -85.062060f, 32.194989f, -84.964281f,
                32.217477f, -84.972658f, 32.219851f, -84.928227f, 32.250149f, -84.924427f, 32.260885f, -84.888417f, 32.324018f, -85.003768f,
                32.356819f, -84.988710f, 32.339000f, -85.031000f, 32.355000f, -85.073000f, 32.444000f, -85.119000f, 32.514000f, -85.214000f,
                32.571000f, -85.182000f, 32.656000f, -85.198000f, 32.847000f, -85.282000f, 32.954000f, -85.237000f, 32.968098f, -85.204399f,
                33.673127f, -85.344545f, 33.673127f, -84.575844f, 31.530347f, -84.575844f
            )
            poly[395] = TzPolygon(
                33.673127f, -85.344545f, 34.984610f, -85.605242f, 34.983184f, -85.473875f, 35.047222f, -85.381691f, 35.087975f, -85.361694f,
                35.109035f, -85.395241f, 35.146053f, -85.388221f, 35.455822f, -85.168365f, 35.446598f, -85.148132f, 35.476330f, -85.117310f,
                35.491520f, -85.146507f, 35.545612f, -85.096718f, 35.571564f, -85.107719f, 35.773621f, -84.905212f, 35.815908f, -84.799654f,
                35.815908f, -84.575844f, 33.673127f, -84.575844f
            )
            poly[396] = TzPolygon(
                36.887299f, -86.493266f, 36.887299f, -85.011997f, 36.858303f, -85.064011f, 36.756046f, -85.003731f, 36.703972f, -85.021294f,
                36.633614f, -85.003380f, 36.616868f, -84.988565f, 36.603372f, -84.785341f, 36.394909f, -84.659531f, 36.376568f, -84.724442f,
                36.336815f, -84.739395f, 36.334450f, -84.774277f, 36.298820f, -84.794266f, 36.289600f, -84.872047f, 36.208321f, -84.912613f,
                36.151085f, -84.903748f, 36.084179f, -84.832413f, 36.090717f, -84.805550f, 35.994560f, -84.720062f, 35.907455f, -84.679497f,
                35.823681f, -84.780251f, 35.815908f, -84.799654f, 35.815908f, -86.493266f
            )
            poly[397] = TzPolygon(
                36.887299f, -85.011997f, 36.887299f, -84.609821f, 36.880714f, -84.604774f, 36.887299f, -84.596516f, 36.887299f, -84.584413f,
                36.847397f, -84.575844f, 36.840290f, -84.595482f, 36.803455f, -84.581558f, 36.809513f, -84.603325f, 36.754250f, -84.674629f,
                36.603205f, -84.778269f, 36.616868f, -84.988565f, 36.693539f, -85.020210f, 36.756046f, -85.003731f, 36.858303f, -85.064011f
            )
            poly[398] = TzPolygon(
                37.958689f, -86.371197f, 37.798916f, -86.151718f, 37.593296f, -86.275375f, 37.556240f, -86.180351f, 37.566570f, -86.113098f,
                37.483006f, -86.051506f, 37.448532f, -86.056473f, 37.422054f, -85.656998f, 37.471039f, -85.633911f, 37.470631f, -85.584618f,
                37.432098f, -85.584579f, 37.363678f, -85.479118f, 37.242134f, -85.388390f, 37.224472f, -85.410957f, 37.221268f, -85.372246f,
                37.192234f, -85.353226f, 37.246124f, -85.312653f, 37.272629f, -85.192299f, 37.312031f, -85.176514f, 37.256798f, -85.056480f,
                37.196941f, -85.053368f, 37.102242f, -84.954109f, 37.116501f, -84.901482f, 37.047607f, -84.905495f, 36.997822f, -84.835594f,
                36.945606f, -84.908035f, 36.960281f, -84.944199f, 36.915924f, -84.960648f, 36.887299f, -85.011997f, 36.887299f, -86.493266f,
                37.958689f, -86.493266f
            )
            poly[399] = TzPolygon(
                36.887299f, -85.011997f, 36.915924f, -84.960648f, 36.960281f, -84.944199f, 36.945606f, -84.908035f, 36.997822f, -84.835594f,
                36.958000f, -84.770294f, 36.982834f, -84.683052f, 36.887299f, -84.609821f
            )
        }
    }

    private object Initializer5 {
        fun init() {
            poly[400] = TzPolygon(36.887299f, -84.596516f, 36.895538f, -84.586182f, 36.887299f, -84.584413f)
            poly[401] = TzPolygon(
                23.481697f, -74.790449f, 23.481697f, -80.377255f, 23.506421f, -80.484193f, 23.592825f, -80.581646f, 23.910715f, -80.700194f,
                24.065363f, -80.633744f, 24.143564f, -80.524446f, 24.247967f, -80.003586f, 25.004520f, -79.363241f, 25.204628f, -79.370973f,
                25.322585f, -79.406819f, 25.520448f, -79.514367f, 25.638981f, -79.536084f, 25.811223f, -79.504861f, 26.091627f, -79.316140f,
                27.020753f, -79.315421f, 27.128711f, -79.210116f, 27.450706f, -78.525181f, 27.473455f, -78.419224f, 27.424560f, -78.182860f,
                27.274784f, -77.906548f, 27.234373f, -77.702998f, 27.140405f, -77.461399f, 26.757829f, -76.863673f, 26.649623f, -76.761429f,
                25.276453f, -75.948835f, 24.821016f, -75.514130f, 24.507391f, -74.790449f
            )
            poly[402] = TzPolygon(
                53.299009f, -169.047661f, 53.299009f, -166.534963f, 53.286358f, -166.560593f, 53.247220f, -166.728682f, 53.238927f, -166.987814f,
                53.099691f, -167.309782f, 53.042476f, -167.563720f, 53.039564f, -167.701567f, 53.088390f, -167.867361f, 53.082363f, -167.959214f,
                53.028831f, -168.052475f, 52.898702f, -168.109744f, 52.822271f, -168.248691f, 52.794237f, -168.360580f, 52.791331f, -168.493636f,
                52.605965f, -169.059824f, 52.575956f, -169.247046f, 52.591763f, -169.375135f, 52.634709f, -169.479863f, 53.098748f, -169.331542f,
                53.128878f, -169.178205f, 53.169365f, -169.122974f, 53.296048f, -169.052268f
            )
            poly[403] = TzPolygon(65.467585f, -168.924586f, 65.480794f, -169.016222f, 65.985947f, -168.924586f)
            poly[404] = TzPolygon(60.306013f, -141.000000f, 60.306369f, -141.001980f, 69.845880f, -141.002750f, 69.845643f, -141.000000f)
            poly[405] = TzPolygon(
                55.300967f, -131.568369f, 55.181496f, -131.293888f, 55.138156f, -131.338965f, 55.028623f, -131.342120f, 54.993297f, -131.375685f,
                55.011397f, -131.539044f, 54.979030f, -131.654746f, 55.040000f, -131.674000f, 55.128513f, -131.614941f, 55.137965f, -131.667861f,
                55.195295f, -131.602997f, 55.272598f, -131.626116f
            )
            poly[406] = TzPolygon(
                54.456000f, -129.974167f, 54.456000f, -131.357994f, 54.475000f, -131.382748f, 54.567000f, -131.435757f, 54.689553f, -131.435100f,
                54.707474f, -130.615673f, 54.763058f, -130.659038f, 54.917729f, -130.345938f, 55.062842f, -130.187563f, 55.192602f, -130.102842f,
                55.281919f, -129.974167f
            )
            poly[407] = TzPolygon(55.281919f, -129.974167f, 55.300967f, -129.983957f, 55.300967f, -129.974167f)
            poly[408] = TzPolygon(
                56.539643f, -135.487083f, 56.624920f, -135.690659f, 56.742436f, -135.856861f, 56.811287f, -135.906463f, 56.847669f, -136.050838f,
                56.911249f, -136.158681f, 56.996578f, -136.210248f, 57.148574f, -136.188711f, 57.347892f, -136.236105f, 57.474854f, -136.497218f,
                57.648721f, -136.628120f, 57.826110f, -136.878354f, 57.835869f, -136.026713f, 58.001387f, -135.899839f, 57.852394f, -135.487083f
            )
            poly[409] = TzPolygon(
                59.798041f, -135.487083f, 59.795767f, -135.487083f, 59.662166f, -135.952645f, 59.640027f, -136.192904f, 59.600556f, -136.346389f,
                59.559413f, -136.239830f, 59.524326f, -136.238504f, 59.464518f, -136.305022f, 59.448960f, -136.368244f, 59.465824f, -136.477156f,
                59.284079f, -136.469247f, 59.165854f, -136.584444f, 59.159960f, -136.828728f, 58.999998f, -137.282847f, 58.908349f, -137.451726f,
                58.906372f, -137.526114f, 58.985395f, -137.500000f, 59.243803f, -137.607356f, 59.768581f, -138.626202f, 59.798041f, -138.643563f
            )
            poly[410] = TzPolygon(
                59.798041f, -141.000000f, 59.798041f, -138.643563f, 59.768581f, -138.626202f, 59.243803f, -137.607356f, 58.985395f, -137.500000f,
                58.906375f, -137.526120f, 58.721171f, -138.269402f, 58.824302f, -138.314402f, 58.893917f, -138.458509f, 58.965197f, -138.784073f,
                59.086790f, -139.084818f, 59.223491f, -139.607996f, 59.518837f, -140.421484f, 59.563240f, -141.000000f
            )
            poly[411] = TzPolygon(
                57.549504f, -134.746823f, 57.549504f, -132.730625f, 57.413174f, -132.730625f, 57.396855f, -132.788898f, 57.360620f, -132.810782f,
                57.368219f, -132.873036f, 57.330823f, -132.986359f, 57.235539f, -133.029298f, 57.191261f, -133.099723f, 57.188390f, -133.155382f,
                57.238076f, -133.292546f, 57.175290f, -133.472112f, 57.152141f, -133.776532f, 57.160638f, -134.048801f, 56.967539f, -134.335319f,
                56.863970f, -134.567591f, 57.005599f, -134.682174f, 57.229242f, -134.744610f, 57.318061f, -134.702750f, 57.456667f, -134.709610f
            )
            poly[412] = TzPolygon(57.852394f, -135.487083f, 57.765158f, -135.245415f, 57.790108f, -134.843268f, 57.549504f, -134.746823f, 57.549504f, -135.487083f)
            poly[413] = TzPolygon(
                57.699405f, -132.730625f, 57.839713f, -132.869368f, 58.000341f, -133.070096f, 58.153676f, -133.172311f, 58.387723f, -133.461504f,
                58.430548f, -133.377303f, 58.612274f, -133.707118f, 58.729444f, -133.840507f, 58.861036f, -134.258074f, 58.923414f, -134.336464f,
                58.962182f, -134.313489f, 58.979210f, -134.407149f, 59.038763f, -134.381877f, 59.131603f, -134.483395f, 59.131124f, -134.565566f,
                59.192275f, -134.679117f, 59.249011f, -134.700716f, 59.280926f, -134.959905f, 59.346348f, -135.030526f, 59.387129f, -134.989744f,
                59.427531f, -135.101019f, 59.474738f, -135.027562f, 59.563659f, -135.028902f, 59.662776f, -135.219845f, 59.696143f, -135.233668f,
                59.798041f, -135.479161f, 59.798041f, -132.730625f
            )
            poly[414] = TzPolygon(59.798041f, -135.479161f, 59.795767f, -135.487083f, 59.798041f, -135.487083f)
            poly[415] = TzPolygon(
                57.684968f, -132.730625f, 57.349747f, -132.369791f, 57.354227f, -132.487307f, 57.400554f, -132.518317f, 57.425137f, -132.687905f,
                57.413174f, -132.730625f
            )
            poly[416] = TzPolygon(
                55.300967f, -129.983957f, 55.581035f, -130.127904f, 55.682902f, -130.111658f, 55.766287f, -130.152406f, 55.907437f, -130.003784f,
                56.008075f, -130.003485f, 56.122798f, -130.103799f, 56.096411f, -130.246219f, 56.141561f, -130.426006f, 56.243053f, -130.467870f,
                56.266878f, -130.623308f, 56.366844f, -130.781981f, 56.406005f, -131.087349f, 56.612232f, -131.581067f, 56.599203f, -131.835327f,
                56.753675f, -131.901072f, 56.805995f, -131.872876f, 56.873648f, -132.123567f, 57.045059f, -132.045191f, 57.091513f, -132.368983f,
                57.211253f, -132.247921f, 57.699405f, -132.730625f, 59.798041f, -132.730625f, 59.798041f, -129.974167f, 55.300967f, -129.974167f
            )
            poly[417] = TzPolygon(
                59.798041f, -135.479161f, 59.798041f, -138.643563f, 59.906325f, -138.707377f, 59.994837f, -139.053671f, 60.001780f, -134.659300f,
                60.001555f, -129.974167f, 59.798041f, -129.974167f
            )
            poly[418] = TzPolygon(
                60.306010f, -141.000000f, 60.219819f, -140.520424f, 60.308085f, -140.458206f, 60.181966f, -139.981094f, 60.335224f, -139.692981f,
                60.352505f, -139.074819f, 60.088296f, -139.198846f, 59.994837f, -139.053671f, 59.906325f, -138.707377f, 59.798041f, -138.643563f,
                59.798041f, -141.000000f
            )
            poly[419] = TzPolygon(
                63.190038f, -129.974167f, 63.188462f, -129.979617f, 63.246923f, -130.038880f, 63.250958f, -130.192256f, 63.274312f, -130.146680f,
                63.305679f, -130.158684f, 63.337384f, -130.078992f, 63.319110f, -130.016604f, 63.330730f, -129.974167f
            )
            poly[420] = TzPolygon(63.573302f, -129.974167f, 63.575386f, -129.984777f, 63.588796f, -129.974167f)
            poly[421] = TzPolygon(69.845643f, -141.000000f, 69.790045f, -140.355601f, 69.833426f, -139.277500f, 63.588796f, -139.277500f, 63.588796f, -141.000000f)
            poly[422] = TzPolygon(
                67.002069f, -134.625833f, 67.006029f, -136.168098f, 67.108444f, -136.229742f, 67.149174f, -136.189630f, 67.181670f, -136.238151f,
                67.234842f, -136.125963f, 67.277941f, -136.145480f, 67.307565f, -136.083943f, 67.360455f, -136.167313f, 67.370146f, -136.132584f,
                67.402233f, -136.221465f, 67.507958f, -136.170255f, 67.532731f, -136.223181f, 67.618359f, -136.227612f, 67.661179f, -136.445060f,
                68.893609f, -136.448351f, 69.403107f, -136.588001f, 69.612833f, -136.287181f, 69.817398f, -135.744358f, 69.882458f, -135.131838f,
                69.965882f, -134.625833f
            )
            poly[423] = TzPolygon(
                64.758700f, -132.300000f, 64.798081f, -132.412569f, 64.782028f, -132.429971f, 64.798076f, -132.515580f, 64.775463f, -132.556591f,
                64.828351f, -132.632429f, 64.905917f, -132.453769f, 64.963457f, -132.519324f, 65.037033f, -132.342518f, 65.073335f, -132.338202f,
                65.090608f, -132.357331f, 65.087625f, -132.528829f, 65.126014f, -132.568842f, 65.162941f, -132.517614f, 65.191932f, -132.547201f,
                65.161913f, -132.736135f, 65.188369f, -132.794449f, 65.208603f, -132.714240f, 65.230638f, -132.788122f, 65.237692f, -132.694163f,
                65.283688f, -132.647805f, 65.286184f, -132.561719f, 65.308012f, -132.551448f, 65.308012f, -132.300000f
            )
            poly[424] = TzPolygon(
                65.946828f, -133.462917f, 65.961271f, -133.513271f, 65.956831f, -133.631821f, 66.007868f, -133.646702f, 66.028727f, -133.563056f,
                66.059295f, -133.621030f, 66.054154f, -133.707154f, 66.086180f, -133.703550f, 66.153550f, -133.560458f, 66.244104f, -133.572204f,
                66.293514f, -133.645711f, 66.291943f, -133.802543f, 66.318045f, -133.847763f, 66.365162f, -133.773507f, 66.405956f, -133.795503f,
                66.469360f, -133.715983f, 66.509433f, -133.728307f, 66.557757f, -133.576743f, 66.624401f, -133.788934f, 66.680806f, -133.879432f,
                66.703954f, -134.012230f, 66.721496f, -133.969848f, 66.711217f, -133.866940f, 66.751234f, -133.772432f, 66.784767f, -133.766112f,
                66.898661f, -133.899261f, 66.910482f, -134.046184f, 66.953285f, -134.103319f, 66.983321f, -134.062184f, 67.000000f, -133.820084f,
                67.002069f, -134.625833f, 67.027228f, -134.625833f, 67.027228f, -133.462917f
            )
            poly[425] = TzPolygon(
                65.946828f, -133.462917f, 65.937353f, -133.429885f, 65.952146f, -133.348015f, 65.990579f, -133.361160f, 65.977454f, -133.245181f,
                66.003503f, -133.252665f, 66.042315f, -132.983071f, 66.004858f, -132.910722f, 65.930263f, -132.996870f, 65.900829f, -132.883580f,
                65.985537f, -132.766081f, 66.022087f, -132.653942f, 66.026617f, -132.555541f, 65.969415f, -132.504177f, 65.993611f, -132.428524f,
                65.989097f, -132.332660f, 65.958445f, -132.321690f, 65.897956f, -132.529776f, 65.841561f, -132.563965f, 65.777356f, -132.367381f,
                65.737327f, -132.300000f, 65.691328f, -132.302510f, 65.689975f, -132.300000f, 65.484842f, -132.300000f, 65.440722f, -132.344745f,
                65.372708f, -132.521007f, 65.308012f, -132.551448f, 65.308012f, -133.462917f
            )
            poly[426] = TzPolygon(
                63.611464f, -129.974167f, 63.615214f, -130.101682f, 63.694346f, -130.143735f, 63.655518f, -130.289682f, 63.704922f, -130.360304f,
                63.734050f, -130.325948f, 63.721008f, -130.251193f, 63.755094f, -130.231241f, 63.752822f, -130.145240f, 63.855361f, -130.133862f,
                63.876849f, -130.257033f, 63.845543f, -130.265736f, 63.823792f, -130.355707f, 63.858328f, -130.392365f, 63.858554f, -130.444751f,
                63.876672f, -130.421266f, 63.912101f, -130.485095f, 63.972067f, -130.773419f, 64.041247f, -130.749978f, 64.037662f, -130.882385f,
                64.093192f, -130.892566f, 64.104755f, -130.967660f, 64.131189f, -130.983478f, 64.181287f, -130.853326f, 64.193824f, -130.947033f,
                64.238210f, -130.946453f, 64.274373f, -131.080527f, 64.324087f, -131.033072f, 64.353567f, -131.107474f, 64.372205f, -131.083249f,
                64.416726f, -131.150320f, 64.463309f, -131.392664f, 64.449366f, -131.457136f, 64.398615f, -131.446325f, 64.397767f, -131.534435f,
                64.381353f, -131.530278f, 64.380663f, -131.851287f, 64.454239f, -131.804679f, 64.489395f, -131.690782f, 64.532855f, -131.691129f,
                64.547372f, -131.796649f, 64.529087f, -131.844544f, 64.559011f, -131.837734f, 64.614157f, -131.975993f, 64.698909f, -132.038756f,
                64.709651f, -132.159794f, 64.758700f, -132.300000f, 65.308012f, -132.300000f, 65.308012f, -129.974167f
            )
            poly[427] = TzPolygon(65.737327f, -132.300000f, 65.731287f, -132.289833f, 65.699239f, -132.300000f)
            poly[428] = TzPolygon(65.689975f, -132.300000f, 65.617466f, -132.165499f, 65.484842f, -132.300000f)
            poly[429] = TzPolygon(
                68.416500f, -133.730000f, 68.346400f, -133.634300f, 68.316600f, -133.388800f, 68.298200f, -133.384300f, 68.290000f, -133.471900f,
                68.317600f, -133.677200f, 68.416100f, -133.799100f
            )
            poly[430] = TzPolygon(
                -44.937760f, -71.919683f, -44.903700f, -71.978940f, -44.901660f, -72.039107f, -44.876883f, -72.064814f, -44.862147f, -72.041330f,
                -44.849365f, -72.069454f, -44.805833f, -72.027225f, -44.780712f, -72.073832f, -44.760691f, -72.066814f, -44.789423f, -71.919683f
            )
            poly[431] = TzPolygon(-43.450540f, -71.919683f, -43.450118f, -71.934083f, -43.426062f, -71.919683f)
            poly[432] = TzPolygon(-43.407818f, -71.919683f, -43.387401f, -71.932538f, -43.384856f, -71.919683f)
            poly[433] = TzPolygon(
                -43.108377f, -71.919683f, -43.102889f, -71.935144f, -43.054373f, -71.934999f, -43.030259f, -72.012970f, -42.900149f, -72.142236f,
                -42.878891f, -72.118163f, -42.800208f, -72.164844f, -42.777249f, -72.130211f, -42.733782f, -72.132065f, -42.696778f, -72.181059f,
                -42.670973f, -72.172841f, -42.672613f, -72.123207f, -42.641728f, -72.100731f, -42.603345f, -72.119550f, -42.569681f, -72.053384f,
                -42.417665f, -72.023000f, -42.386228f, -72.073812f, -42.384200f, -72.133207f, -42.323603f, -72.121135f, -42.260489f, -72.168079f,
                -42.199138f, -72.155889f, -42.165247f, -72.187818f, -42.138140f, -72.168850f, -42.148259f, -72.066025f, -42.114259f, -72.057871f,
                -42.141013f, -71.957761f, -42.189237f, -71.923944f, -42.186256f, -71.919683f
            )
            poly[434] = TzPolygon(
                -45.999874f, -71.647592f, -45.964079f, -71.614162f, -45.889973f, -71.652406f, -45.846380f, -71.769355f, -45.806990f, -71.740723f,
                -45.719439f, -71.801496f, -45.695895f, -71.772534f, -45.666100f, -71.795858f, -45.640808f, -71.772528f, -45.628222f, -71.801670f,
                -45.608035f, -71.741499f, -45.575394f, -71.727421f, -45.560370f, -71.763621f, -45.513821f, -71.681619f, -45.523648f, -71.560532f,
                -45.493948f, -71.469224f, -45.433267f, -71.534182f, -45.396634f, -71.531639f, -45.395827f, -71.438287f, -45.367671f, -71.448474f,
                -45.322056f, -71.336173f, -45.241396f, -71.333005f, -45.157815f, -71.417629f, -45.144106f, -71.487469f, -45.107916f, -71.491583f,
                -45.103136f, -71.526583f, -45.071205f, -71.505133f, -45.032566f, -71.556488f, -44.997937f, -71.559021f, -44.997937f, -70.484300f,
                -45.999874f, -70.484300f
            )
            poly[435] = TzPolygon(
                -44.997937f, -71.559021f, -44.978630f, -71.560434f, -44.969419f, -71.684356f, -44.953635f, -71.741502f, -44.926900f, -71.753607f,
                -44.941353f, -71.778080f, -44.920689f, -71.814042f, -44.960567f, -71.880003f, -44.937760f, -71.919683f, -44.789423f, -71.919683f,
                -44.801768f, -71.856464f, -44.793873f, -71.815151f, -44.774285f, -71.824510f, -44.751000f, -71.783607f, -44.788055f, -71.657045f,
                -44.737528f, -71.469694f, -44.790183f, -71.395839f, -44.813615f, -71.292316f, -44.790817f, -71.237041f, -44.736692f, -71.201928f,
                -44.681534f, -71.197913f, -44.638174f, -71.235040f, -44.591460f, -71.200751f, -44.589879f, -71.100093f, -44.535024f, -71.091156f,
                -44.503523f, -71.158828f, -44.471103f, -71.132255f, -44.440417f, -71.173253f, -44.417687f, -71.239757f, -44.429603f, -71.330812f,
                -44.389504f, -71.364869f, -44.409691f, -71.654704f, -44.379885f, -71.714270f, -44.416558f, -71.814521f, -44.349941f, -71.840270f,
                -44.339507f, -71.798213f, -44.312054f, -71.790529f, -44.268978f, -71.806458f, -44.265162f, -71.833327f, -44.223837f, -71.779062f,
                -44.157109f, -71.850289f, -44.112455f, -71.849623f, -44.096547f, -71.754574f, -43.996000f, -71.684303f, -43.996000f, -70.484300f,
                -44.997937f, -70.484300f
            )
            poly[436] = TzPolygon(
                -43.996000f, -71.684303f, -43.945517f, -71.649021f, -43.901891f, -71.665629f, -43.894048f, -71.706875f, -43.855401f, -71.708285f,
                -43.840936f, -71.762882f, -43.789400f, -71.753917f, -43.703084f, -71.661473f, -43.696297f, -71.599339f, -43.676267f, -71.611322f,
                -43.651773f, -71.580847f, -43.623324f, -71.626241f, -43.624920f, -71.701600f, -43.584148f, -71.707474f, -43.583989f, -71.759675f,
                -43.538705f, -71.776608f, -43.553602f, -71.871443f, -43.510950f, -71.891549f, -43.479397f, -71.850140f, -43.451676f, -71.880868f,
                -43.450540f, -71.919683f, -43.426062f, -71.919683f, -43.416710f, -71.914084f, -43.407818f, -71.919683f, -43.384856f, -71.919683f,
                -43.379790f, -71.894086f, -43.322316f, -71.904845f, -43.335170f, -71.842502f, -43.296951f, -71.786197f, -43.313571f, -71.734554f,
                -43.228069f, -71.757181f, -43.201172f, -71.729822f, -43.164496f, -71.761569f, -43.108377f, -71.919683f, -42.186256f, -71.919683f,
                -42.154558f, -71.874373f, -42.147377f, -71.780778f, -42.110137f, -71.726125f, -42.046242f, -71.728250f, -41.999919f, -71.773859f,
                -41.996752f, -69.048916f, -43.996000f, -69.048916f
            )
            poly[437] = TzPolygon(-42.000147f, -69.048916f, -41.999919f, -71.773859f, -41.992126f, -71.774964f, -41.992126f, -69.048916f)
            poly[438] = TzPolygon(-42.000147f, -69.048916f, -41.992126f, -69.048916f, -41.992126f, -63.307384f, -41.997100f, -63.313482f, -42.000390f, -66.132587f)
            poly[439] = TzPolygon(
                -41.992126f, -71.774964f, -41.841797f, -71.796270f, -41.824908f, -71.751344f, -41.793720f, -71.773993f, -41.787129f, -71.754059f,
                -41.720446f, -71.810346f, -41.694816f, -71.794039f, -41.605156f, -71.885877f, -41.565628f, -71.844851f, -41.575015f, -71.817310f,
                -41.533090f, -71.848952f, -41.433489f, -71.834729f, -41.340735f, -71.912070f, -41.307959f, -71.876051f, -41.255404f, -71.899037f,
                -41.271283f, -71.834181f, -41.161285f, -71.887783f, -41.149792f, -71.840766f, -41.098685f, -71.851529f, -41.060383f, -71.819600f,
                -40.985164f, -71.905199f, -40.960733f, -71.902452f, -40.955989f, -71.857240f, -40.882583f, -71.858421f, -40.857764f, -71.908006f,
                -40.821790f, -71.934099f, -40.783198f, -71.923456f, -40.745139f, -71.966608f, -40.609908f, -71.837613f, -40.578130f, -71.825051f,
                -40.592662f, -71.855085f, -40.556004f, -71.890498f, -40.555364f, -71.859178f, -40.525324f, -71.842910f, -40.420480f, -71.824579f,
                -40.407410f, -71.791620f, -40.434462f, -71.735315f, -40.397606f, -71.687936f, -40.373939f, -71.693601f, -40.364261f, -71.657037f,
                -40.292268f, -71.694585f, -40.292268f, -69.592084f, -41.992126f, -69.592084f
            )
            poly[440] = TzPolygon(-40.292268f, -71.722758f, -40.305599f, -71.751628f, -40.292268f, -71.764493f)
            poly[441] = TzPolygon(
                -39.442339f, -71.997768f, -39.442339f, -71.448113f, -39.450620f, -71.447085f, -39.493267f, -71.472945f, -39.530408f, -71.534381f,
                -39.560380f, -71.503986f, -39.553265f, -71.470769f, -39.583070f, -71.461172f, -39.637216f, -71.503057f, -39.627961f, -71.610174f,
                -39.592122f, -71.624765f, -39.565057f, -71.677809f, -39.587348f, -71.698628f, -39.648336f, -71.715547f, -39.682569f, -71.669381f,
                -39.724555f, -71.712570f, -39.808066f, -71.666822f, -39.842739f, -71.690854f, -39.901234f, -71.592664f, -39.973362f, -71.620473f,
                -39.970337f, -71.645021f, -40.032482f, -71.688575f, -40.104349f, -71.674343f, -40.117153f, -71.699331f, -40.088110f, -71.825609f,
                -40.135898f, -71.799688f, -40.172052f, -71.828818f, -40.187324f, -71.798486f, -40.213284f, -71.829213f, -40.292268f, -71.762832f,
                -40.292268f, -71.997768f
            )
            poly[442] = TzPolygon(-40.292268f, -71.736145f, -40.276651f, -71.718007f, -40.292268f, -71.689459f)
            poly[443] = TzPolygon(
                -38.592410f, -70.828719f, -38.596271f, -70.827741f, -38.666806f, -70.904130f, -38.700038f, -70.884218f, -38.762976f, -70.925245f,
                -38.753867f, -71.095039f, -38.814403f, -71.185219f, -38.801357f, -71.237374f, -38.871179f, -71.296032f, -38.928944f, -71.433604f,
                -38.981027f, -71.441512f, -39.045635f, -71.396008f, -39.151075f, -71.421186f, -39.211327f, -71.381073f, -39.283159f, -71.374093f,
                -39.350604f, -71.400364f, -39.370570f, -71.457023f, -39.442339f, -71.448113f, -39.442339f, -71.997768f, -38.592410f, -71.997768f
            )
            poly[444] = TzPolygon(-37.145169f, -69.592084f, -37.070623f, -69.754073f, -36.964614f, -69.778684f, -36.892553f, -69.763706f, -36.892553f, -69.592084f)
            poly[445] = TzPolygon(
                -36.892553f, -71.900482f, -36.892553f, -71.129248f, -36.929041f, -71.144752f, -36.936060f, -71.087143f, -36.971392f, -71.106434f,
                -36.978198f, -71.222584f, -36.998543f, -71.165024f, -37.069278f, -71.140863f, -37.114556f, -71.092349f, -37.141238f, -71.134576f,
                -37.206543f, -71.114566f, -37.225151f, -71.170163f, -37.276358f, -71.188188f, -37.274983f, -71.220728f, -37.382493f, -71.198138f,
                -37.402646f, -71.149771f, -37.489083f, -71.116255f, -37.539055f, -71.150244f, -37.587738f, -71.127798f, -37.648579f, -71.206464f,
                -37.699197f, -71.209509f, -37.757481f, -71.155998f, -37.784852f, -71.169856f, -37.819789f, -71.123698f, -37.857139f, -71.183413f,
                -37.859489f, -71.140299f, -37.901348f, -71.099198f, -37.953027f, -71.114662f, -37.970444f, -71.061648f, -38.045348f, -71.052981f,
                -38.087883f, -70.988759f, -38.104769f, -70.982923f, -38.123813f, -71.043691f, -38.171872f, -70.996141f, -38.249871f, -71.032228f,
                -38.297540f, -70.997857f, -38.430118f, -70.983953f, -38.538020f, -70.842504f, -38.592410f, -70.828719f, -38.592410f, -71.900482f
            )
            poly[446] = TzPolygon(
                -36.892553f, -71.129248f, -36.869386f, -71.119405f, -36.842014f, -71.180291f, -36.814730f, -71.131786f, -36.679597f, -71.113579f,
                -36.677695f, -71.085840f, -36.714316f, -71.065648f, -36.690988f, -71.009397f, -36.618051f, -71.057355f, -36.475799f, -71.037270f,
                -36.503574f, -70.972881f, -36.493759f, -70.935051f, -36.466067f, -70.888735f, -36.396050f, -70.883911f, -36.416230f, -70.850867f,
                -36.396336f, -70.815848f, -36.428800f, -70.787352f, -36.405731f, -70.747012f, -36.892553f, -70.746283f
            )
            poly[447] = TzPolygon(
                -36.892553f, -69.763706f, -36.870052f, -69.759029f, -36.844760f, -69.851068f, -36.792385f, -69.921661f, -36.720063f, -69.947434f,
                -36.694280f, -70.011634f, -36.571453f, -70.120752f, -36.454693f, -70.200582f, -36.326955f, -70.225365f, -36.338549f, -70.327956f,
                -36.309376f, -70.359017f, -36.126311f, -70.398953f, -36.042624f, -70.383605f, -36.042624f, -69.592084f, -36.892553f, -69.592084f
            )
            poly[448] = TzPolygon(
                -36.042624f, -70.746283f, -36.042624f, -70.376976f, -36.061411f, -70.412772f, -36.155683f, -70.420834f, -36.178934f, -70.490668f,
                -36.142783f, -70.531284f, -36.138486f, -70.577804f, -36.174799f, -70.571281f, -36.217051f, -70.633251f, -36.238653f, -70.632221f,
                -36.272291f, -70.705005f, -36.304669f, -70.684749f, -36.342290f, -70.712336f, -36.389426f, -70.679377f, -36.426866f, -70.712851f,
                -36.429767f, -70.739287f, -36.408000f, -70.746283f
            )
            poly[449] = TzPolygon(
                -36.042624f, -70.383605f, -35.994661f, -70.374808f, -35.972432f, -70.423109f, -35.923763f, -70.366686f, -35.906072f, -70.425712f,
                -35.874225f, -70.420906f, -35.812880f, -70.307611f, -35.787241f, -70.379363f, -35.748938f, -70.358249f, -35.640074f, -70.423773f,
                -35.606864f, -70.386523f, -35.526123f, -70.412155f, -35.521194f, -70.367930f, -35.463523f, -70.446621f, -35.391565f, -70.452286f,
                -35.354411f, -70.418624f, -35.318422f, -70.432013f, -35.322442f, -70.500328f, -35.278311f, -70.583584f, -35.199376f, -70.536720f,
                -35.203077f, -70.470457f, -35.192695f, -70.438253f, -35.192695f, -69.592084f, -36.042624f, -69.592084f
            )
            poly[450] = TzPolygon(
                -37.149128f, -69.592084f, -37.174413f, -69.528537f, -37.144655f, -69.272757f, -37.178046f, -69.215052f, -37.178112f, -69.169509f,
                -37.251359f, -69.038914f, -37.364905f, -69.025673f, -37.374370f, -68.902336f, -37.401370f, -68.862791f, -37.367106f, -68.764790f,
                -37.388558f, -68.722475f, -37.443122f, -68.693162f, -37.456163f, -68.500516f, -37.543807f, -68.438250f, -37.574553f, -68.258624f,
                -36.173761f, -68.250425f, -36.173175f, -68.296416f, -35.997567f, -68.296021f, -35.999085f, -65.107859f, -35.192695f, -65.105515f,
                -35.192695f, -64.780716f, -41.992126f, -64.780716f, -41.992126f, -69.592084f
            )
            poly[451] = TzPolygon(
                -35.192695f, -66.493081f, -35.192695f, -65.101402f, -35.999085f, -65.107859f, -36.000631f, -66.637783f, -35.850454f, -66.622515f,
                -35.638322f, -66.547656f, -35.581173f, -66.570442f, -35.538946f, -66.524995f, -35.311285f, -66.495403f, -35.274264f, -66.519915f,
                -35.240645f, -66.484147f
            )
            poly[452] = TzPolygon(
                -33.492837f, -70.677005f, -33.492837f, -69.831024f, -33.515205f, -69.835131f, -33.539648f, -69.871767f, -33.683244f, -69.884780f,
                -33.717046f, -69.864440f, -33.774146f, -69.904299f, -33.847444f, -69.898932f, -33.892520f, -69.855283f, -33.963630f, -69.905739f,
                -33.962891f, -69.853246f, -34.014171f, -69.822212f, -34.055811f, -69.852897f, -34.085956f, -69.833671f, -34.132561f, -69.873521f,
                -34.208546f, -69.790780f, -34.243036f, -69.795071f, -34.264177f, -69.897038f, -34.291940f, -69.909921f, -34.250105f, -69.970842f,
                -34.288053f, -70.030944f, -34.413892f, -70.010890f, -34.482265f, -70.127276f, -34.611448f, -70.216827f, -34.683329f, -70.215968f,
                -34.746332f, -70.306176f, -34.770308f, -70.307957f, -34.798152f, -70.248756f, -34.937568f, -70.331477f, -34.991588f, -70.334395f,
                -35.005933f, -70.365634f, -35.172661f, -70.376109f, -35.192695f, -70.438253f, -35.192695f, -70.677005f
            )
            poly[453] = TzPolygon(
                -33.492837f, -69.831024f, -33.432467f, -69.819938f, -33.423330f, -69.795747f, -33.396175f, -69.807077f, -33.348334f, -69.771014f,
                -33.287473f, -69.800816f, -33.273438f, -69.903898f, -33.244897f, -69.918237f, -33.266887f, -69.917260f, -33.322926f, -70.001214f,
                -33.286100f, -70.006063f, -33.270107f, -70.038872f, -33.235968f, -70.026222f, -33.201745f, -70.064707f, -33.138333f, -70.049858f,
                -33.052378f, -70.094115f, -33.006253f, -70.019406f, -32.969223f, -70.028604f, -32.900978f, -69.989360f, -32.800298f, -70.108007f,
                -32.728104f, -70.147603f, -32.642908f, -70.157320f, -32.642908f, -69.694290f, -33.492837f, -69.694290f
            )
            poly[454] = TzPolygon(
                -32.642908f, -70.157320f, -32.597133f, -70.162541f, -32.576464f, -70.122556f, -32.625500f, -70.065400f, -32.528300f, -70.004200f,
                -32.570600f, -69.847300f, -32.544000f, -69.821600f, -32.546800f, -69.790900f, -32.509400f, -69.756100f, -32.496400f, -69.705000f,
                -32.451526f, -69.694290f, -32.642908f, -69.694290f
            )
            poly[455] = TzPolygon(-32.425619f, -69.694290f, -32.390600f, -69.733200f, -32.330800f, -69.728900f, -32.305770f, -69.694290f)
            poly[456] = TzPolygon(
                -31.792980f, -70.462729f, -31.844106f, -70.459989f, -31.885702f, -70.375317f, -31.884090f, -70.279949f, -31.957688f, -70.210597f,
                -32.051326f, -70.288532f, -32.025551f, -70.353892f, -32.044032f, -70.388251f, -32.070225f, -70.335379f, -32.109746f, -70.341559f,
                -32.136083f, -70.304072f, -32.267821f, -70.322918f, -32.332929f, -70.217856f, -32.428944f, -70.236390f, -32.487452f, -70.136059f,
                -32.576341f, -70.126033f, -32.621210f, -70.172135f, -32.642908f, -70.153784f, -32.642908f, -70.677005f, -31.792980f, -70.677005f
            )
            poly[457] = TzPolygon(
                -32.451526f, -69.694290f, -32.430200f, -69.689200f, -32.425619f, -69.694290f, -32.305770f, -69.694290f, -32.260000f, -69.631000f,
                -32.143100f, -69.596500f, -32.141000f, -69.531100f, -32.074700f, -69.454800f, -32.066500f, -69.415700f, -32.091100f, -69.314200f,
                -32.016100f, -69.244500f, -31.999400f, -69.128400f, -32.116500f, -69.011600f, -32.114700f, -68.917600f, -32.338000f, -68.917600f,
                -32.337264f, -68.711575f, -33.492837f, -68.711575f, -33.492837f, -69.694290f
            )
            poly[458] = TzPolygon(
                -31.792980f, -70.462962f, -31.700467f, -70.467607f, -31.689659f, -70.513247f, -31.651984f, -70.506949f, -31.600158f, -70.566913f,
                -31.511025f, -70.551812f, -31.474014f, -70.569681f, -31.448298f, -70.548502f, -31.420066f, -70.560293f, -31.407302f, -70.532098f,
                -31.314451f, -70.547065f, -31.122358f, -70.497540f, -31.084345f, -70.456309f, -31.167701f, -70.401453f, -31.135156f, -70.360892f,
                -31.111198f, -70.369315f, -31.044317f, -70.321813f, -31.043402f, -70.269070f, -31.020345f, -70.297286f, -30.970388f, -70.293156f,
                -30.929746f, -70.323277f, -30.831139f, -70.279648f, -30.787889f, -70.288494f, -30.728616f, -70.246190f, -30.634681f, -70.247118f,
                -30.551636f, -70.189708f, -30.491682f, -70.195167f, -30.431020f, -70.117187f, -30.346107f, -70.154266f, -30.352241f, -70.106388f,
                -30.394708f, -70.063151f, -30.385750f, -69.955176f, -30.357675f, -69.934877f, -30.350671f, -69.891951f, -30.319989f, -69.908130f,
                -30.219544f, -69.885365f, -30.219247f, -69.834038f, -30.178744f, -69.816872f, -30.125901f, -69.824940f, -30.105855f, -69.899270f,
                -30.120407f, -69.935662f, -30.093122f, -69.957838f, -30.093122f, -68.711575f, -31.792980f, -68.711575f
            )
            poly[459] = TzPolygon(
                -29.243193f, -68.982018f, -29.243193f, -68.711575f, -29.629941f, -68.711575f, -29.625400f, -68.735100f, -29.635100f, -68.863100f,
                -29.593400f, -68.885500f, -29.619800f, -68.935600f, -29.651600f, -68.938300f, -29.639100f, -69.014100f, -29.533000f, -69.033700f,
                -29.456500f, -68.975200f, -29.399700f, -69.002200f, -29.287300f, -68.956700f, -29.274000f, -68.989100f
            )
            poly[460] = TzPolygon(
                -29.243193f, -70.265666f, -29.243193f, -69.940028f, -29.250524f, -69.938337f, -29.285201f, -69.996486f, -29.330257f, -70.020377f,
                -29.383526f, -70.021589f, -29.414629f, -69.966769f, -29.452154f, -69.981427f, -29.486015f, -69.949034f, -29.653552f, -69.940033f,
                -29.724618f, -69.879718f, -29.806791f, -69.913479f, -29.862028f, -69.875928f, -30.037139f, -69.923156f, -30.084682f, -69.964698f,
                -30.093122f, -69.957838f, -30.093122f, -70.265666f
            )
            poly[461] = TzPolygon(
                -29.243193f, -68.982018f, -29.230500f, -68.979100f, -29.186600f, -69.001200f, -29.146300f, -68.969600f, -29.166400f, -68.935000f,
                -29.128200f, -68.911700f, -29.044900f, -68.908500f, -28.941500f, -68.961300f, -28.861000f, -68.908200f, -28.761100f, -69.162000f,
                -28.681600f, -69.209800f, -28.596172f, -69.203350f, -28.412000f, -69.316300f, -28.448500f, -69.375900f, -28.451800f, -69.425500f,
                -28.415500f, -69.469700f, -28.431900f, -69.516200f, -28.405800f, -69.555200f, -28.419000f, -69.605700f, -28.393264f, -69.642201f,
                -28.393264f, -68.711575f, -29.243193f, -68.711575f
            )
            poly[462] = TzPolygon(
                -28.393264f, -69.639844f, -28.396123f, -69.649809f, -28.430365f, -69.632647f, -28.471286f, -69.680883f, -28.532384f, -69.651206f,
                -28.581472f, -69.664657f, -28.595848f, -69.693449f, -28.685000f, -69.731142f, -28.736055f, -69.729325f, -28.772686f, -69.692879f,
                -28.900330f, -69.765448f, -28.984360f, -69.754620f, -29.050635f, -69.792815f, -29.130055f, -69.787113f, -29.138358f, -69.874577f,
                -29.189048f, -69.952518f, -29.243193f, -69.940028f, -29.243193f, -70.265666f, -28.393264f, -70.265666f
            )
            poly[463] = TzPolygon(
                -34.572276f, -66.746146f, -34.551384f, -66.765254f, -34.442918f, -66.754309f, -34.411427f, -66.795099f, -34.379339f, -66.764022f,
                -34.345083f, -66.812008f, -34.305136f, -66.802346f, -34.298080f, -66.775686f, -34.257298f, -66.801351f, -34.233715f, -66.785475f,
                -34.221414f, -66.746146f
            )
            poly[464] = TzPolygon(
                -33.909971f, -66.746146f, -33.832403f, -66.873865f, -33.769567f, -66.882522f, -33.667774f, -67.004156f, -33.632675f, -66.998327f,
                -33.492837f, -67.112968f, -33.492837f, -66.746146f
            )
            poly[465] = TzPolygon(
                -32.229795f, -67.728860f, -32.222929f, -67.736544f, -32.226135f, -67.831806f, -32.175304f, -67.916499f, -32.113721f, -67.938574f,
                -32.121118f, -67.959774f, -32.096041f, -67.971025f, -32.070956f, -68.052321f, -32.098873f, -68.073004f, -32.084566f, -68.080622f,
                -32.119329f, -68.151981f, -32.109170f, -68.188468f, -32.127798f, -68.206085f, -32.091599f, -68.247830f, -32.137700f, -68.304100f,
                -32.137800f, -68.463000f, -32.237700f, -68.462900f, -32.337100f, -68.665700f, -32.337264f, -68.711575f, -31.792980f, -68.711575f,
                -31.792980f, -67.728860f
            )
            poly[466] = TzPolygon(-31.858814f, -66.746146f, -31.811800f, -66.802400f, -31.792980f, -66.810050f, -31.792980f, -66.746146f)
            poly[467] = TzPolygon(
                -32.229795f, -67.728860f, -32.245914f, -67.710822f, -32.225171f, -67.675937f, -32.246021f, -67.597144f, -32.220883f, -67.523543f,
                -32.306719f, -67.472865f, -32.350470f, -67.331906f, -32.443006f, -67.289186f, -32.536352f, -67.297263f, -32.552589f, -67.262771f,
                -32.625623f, -67.256806f, -32.682074f, -67.225003f, -32.697483f, -67.187776f, -32.758705f, -67.166420f, -32.769350f, -67.185911f,
                -32.820146f, -67.177832f, -32.886632f, -67.232281f, -33.003292f, -67.179549f, -33.043992f, -67.198048f, -33.077062f, -67.174153f,
                -33.252109f, -67.180232f, -33.464962f, -67.135820f, -33.492837f, -67.112968f, -33.492837f, -67.728860f
            )
            poly[468] = TzPolygon(
                -32.229795f, -67.728860f, -31.792980f, -67.728860f, -31.792980f, -66.810050f, -31.811800f, -66.802400f, -31.855347f, -66.746146f,
                -31.912213f, -66.746146f, -31.897700f, -66.885700f, -31.833800f, -67.137000f, -31.880800f, -67.241800f, -31.859900f, -67.467200f,
                -31.941500f, -67.438000f, -32.133000f, -67.471500f, -32.199400f, -67.430100f, -32.292300f, -67.278200f, -32.359800f, -67.265500f,
                -32.318742f, -67.452448f, -32.220883f, -67.523543f, -32.246021f, -67.597144f, -32.225171f, -67.675937f, -32.245914f, -67.710822f
            )
            poly[469] = TzPolygon(-33.492837f, -65.125889f, -33.492837f, -64.780716f, -35.012896f, -64.780716f, -35.015368f, -65.105000f, -34.073550f, -65.092441f)
            poly[470] = TzPolygon(
                -33.909971f, -66.746146f, -33.958553f, -66.666152f, -34.136302f, -66.733531f, -34.147375f, -66.711233f, -34.212982f, -66.719187f,
                -34.221414f, -66.746146f
            )
            poly[471] = TzPolygon(
                -34.572276f, -66.746146f, -34.619559f, -66.702900f, -34.690619f, -66.690698f, -34.719168f, -66.639689f, -34.757754f, -66.650427f,
                -34.774623f, -66.606691f, -34.832940f, -66.561509f, -34.910866f, -66.554941f, -34.943145f, -66.524305f, -35.016032f, -66.539498f,
                -35.140901f, -66.477856f, -35.172705f, -66.496806f, -35.192695f, -66.493081f, -35.192695f, -66.746146f
            )
            poly[472] = TzPolygon(-35.192695f, -65.105515f, -35.015368f, -65.105000f, -35.012896f, -64.780716f, -35.192695f, -64.780716f)
            poly[473] = TzPolygon(
                -33.492837f, -65.125889f, -33.195969f, -65.142988f, -33.135487f, -65.045959f, -33.100020f, -65.059240f, -33.002992f, -64.998826f,
                -32.975542f, -65.022924f, -32.867559f, -64.965825f, -32.805044f, -64.970672f, -32.679179f, -64.916186f, -32.614742f, -64.924121f,
                -32.570774f, -64.882720f, -32.485182f, -64.895502f, -32.466736f, -64.919786f, -32.298352f, -64.941396f, -32.321508f, -64.977267f,
                -32.325382f, -65.211604f, -32.088938f, -65.245786f, -31.898895f, -65.627618f, -31.889084f, -65.769911f, -31.792980f, -65.770147f,
                -31.792980f, -64.780716f, -33.492837f, -64.780716f
            )
            poly[474] = TzPolygon(
                -31.858814f, -66.746146f, -31.792980f, -66.746146f, -31.792980f, -65.770147f, -31.889084f, -65.769911f, -31.910932f, -65.888102f,
                -31.889163f, -65.979249f, -31.936728f, -66.070545f, -31.970135f, -66.078569f, -31.938470f, -66.141267f, -31.939420f, -66.161047f,
                -31.963644f, -66.158434f, -31.930546f, -66.299695f, -31.944018f, -66.337841f, -31.998235f, -66.349970f, -31.898800f, -66.698300f
            )
            poly[475] = TzPolygon(-31.855347f, -66.746146f, -31.921039f, -66.661283f, -31.912213f, -66.746146f)
            poly[476] = TzPolygon(
                -29.629941f, -68.711575f, -29.670546f, -68.501226f, -29.664182f, -68.403665f, -29.746899f, -68.258500f, -29.780700f, -68.253800f,
                -29.781100f, -68.199000f, -29.885400f, -68.158800f, -29.900300f, -68.054300f, -30.074300f, -67.898300f, -30.298100f, -67.590900f,
                -30.403000f, -67.578600f, -30.536300f, -67.494800f, -30.627500f, -67.410100f, -30.695300f, -67.282800f, -30.895600f, -67.128800f,
                -30.914200f, -67.085300f, -31.005600f, -67.112200f, -31.060800f, -67.092200f, -31.160700f, -67.125700f, -31.227400f, -67.075300f,
                -31.382800f, -67.109100f, -31.632700f, -66.958500f, -31.632700f, -66.875200f, -31.792980f, -66.810050f, -31.792980f, -68.711575f
            )
            poly[477] = TzPolygon(
                -31.792980f, -65.770147f, -31.044523f, -65.771984f, -30.485877f, -65.521213f, -30.119411f, -65.422828f, -30.046920f, -65.158100f,
                -29.911402f, -65.008098f, -29.846962f, -64.939024f, -29.596008f, -64.964324f, -29.574265f, -64.824647f, -29.473738f, -64.825969f,
                -29.405442f, -64.786067f, -29.311780f, -64.841868f, -29.274007f, -64.824691f, -29.267794f, -64.780716f, -31.792980f, -64.780716f
            )
            poly[478] = TzPolygon(
                -29.267794f, -64.780716f, -29.198162f, -64.854485f, -29.016049f, -64.863470f, -28.931650f, -64.906800f, -28.838502f, -64.901298f,
                -28.738725f, -65.016846f, -28.716365f, -65.126770f, -28.647445f, -65.136304f, -28.623595f, -65.187454f, -28.600273f, -65.184619f,
                -28.611516f, -65.125641f, -28.471149f, -65.097055f, -28.393264f, -65.101266f, -28.393264f, -64.780716f
            )
            poly[479] = TzPolygon(
                -28.393264f, -66.537674f, -28.468125f, -66.514020f, -28.531510f, -66.530901f, -28.531341f, -66.496285f, -28.621755f, -66.496364f,
                -28.721267f, -66.351460f, -28.814721f, -66.411309f, -28.858168f, -66.402357f, -28.944016f, -66.099378f, -29.180995f, -65.814712f,
                -29.269552f, -65.814566f, -29.269873f, -65.748386f, -29.328488f, -65.717348f, -29.411858f, -65.719177f, -30.119411f, -65.422828f,
                -30.485877f, -65.521213f, -31.044523f, -65.771984f, -31.792980f, -65.770147f, -31.792980f, -66.746146f, -28.393264f, -66.746146f
            )
            poly[480] = TzPolygon(
                -41.422645f, -62.609179f, -40.979576f, -62.803051f, -40.824446f, -62.949850f, -40.722183f, -63.184310f, -40.729561f, -63.285669f,
                -40.707682f, -63.308176f, -40.710189f, -63.379351f, -34.383197f, -63.392673f, -34.384361f, -62.609179f
            )
            poly[481] = TzPolygon(
                -29.267794f, -64.780716f, -28.393264f, -64.780716f, -28.393264f, -62.609179f, -34.384361f, -62.609179f, -34.383197f, -63.392673f,
                -35.002259f, -63.385587f, -35.012896f, -64.780716f
            )
            poly[482] = TzPolygon(
                -33.261612f, -62.609179f, -33.261612f, -60.260223f, -33.350734f, -60.323943f, -33.412296f, -60.335279f, -33.467725f, -60.410192f,
                -33.544790f, -60.413768f, -33.582330f, -60.457442f, -33.634118f, -60.462784f, -33.646610f, -60.557088f, -33.585511f, -60.683778f,
                -33.579018f, -60.781886f, -33.540342f, -60.818173f, -33.554681f, -60.879007f, -33.588514f, -60.918209f, -33.653787f, -60.934192f,
                -34.385686f, -61.717681f, -34.384361f, -62.609179f
            )
            poly[483] = TzPolygon(
                -33.261612f, -58.393042f, -33.279634f, -58.390545f, -33.363561f, -58.431758f, -33.537643f, -58.443426f, -33.583747f, -58.494708f,
                -33.720379f, -58.434701f, -33.916298f, -58.423567f, -33.988897f, -58.389303f, -34.037763f, -58.644680f, -33.946724f, -58.758230f,
                -33.950878f, -58.839899f, -33.890547f, -58.898328f, -33.872694f, -58.972866f, -33.841388f, -58.994148f, -33.847661f, -59.132850f,
                -33.806264f, -59.172134f, -33.811717f, -59.236545f, -33.726239f, -59.246894f, -33.727338f, -59.442301f, -33.631734f, -59.508333f,
                -33.689206f, -59.613589f, -33.619980f, -59.661319f, -33.608489f, -59.776325f, -33.589510f, -59.808616f, -33.531851f, -59.824989f,
                -33.474139f, -59.934303f, -33.448112f, -60.041166f, -33.261612f, -60.260223f
            )
            poly[484] = TzPolygon(
                -35.782448f, -55.703699f, -35.632191f, -55.868778f, -35.173238f, -56.705143f, -35.189034f, -57.000023f, -34.862980f, -57.327981f,
                -34.780799f, -57.508238f, -34.684798f, -57.934353f, -34.451896f, -57.934502f, -34.232874f, -58.180331f, -34.178090f, -58.295066f,
                -34.006821f, -58.344293f, -33.999879f, -58.377075f, -33.916298f, -58.423567f, -33.720379f, -58.434701f, -33.585550f, -58.494773f,
                -33.537643f, -58.443426f, -33.363561f, -58.431758f, -33.279634f, -58.390545f, -33.261612f, -58.393042f, -33.261612f, -55.703699f
            )
            poly[485] = TzPolygon(
                -33.261612f, -53.521037f, -33.261612f, -52.467132f, -33.422913f, -52.615046f, -33.868906f, -53.181090f, -33.743132f, -53.371292f,
                -33.739471f, -53.430525f, -33.693469f, -53.439511f, -33.688801f, -53.532282f
            )
            poly[486] = TzPolygon(
                -30.085396f, -58.087644f, -31.821977f, -58.087644f, -31.871076f, -58.206771f, -32.001816f, -58.138307f, -32.159083f, -58.183411f,
                -32.259358f, -58.099923f, -32.309612f, -58.103217f, -32.375891f, -58.182913f, -32.460549f, -58.204637f, -32.572425f, -58.160297f,
                -32.735830f, -58.149444f, -32.989410f, -58.087644f, -33.004866f, -58.087644f, -33.076862f, -58.175869f, -33.129049f, -58.370649f,
                -33.180003f, -58.404350f, -33.261612f, -58.393042f, -33.261612f, -62.609179f, -30.085396f, -62.609179f
            )
            poly[487] = TzPolygon(-31.673504f, -58.087644f, -31.673504f, -58.010677f, -31.759526f, -58.038331f, -31.821977f, -58.087644f)
            poly[488] = TzPolygon(-32.989410f, -58.087644f, -33.002302f, -58.084502f, -33.004866f, -58.087644f)
            poly[489] = TzPolygon(
                -30.085396f, -57.459256f, -30.144845f, -57.514628f, -30.181515f, -57.644876f, -30.255777f, -57.615244f, -30.341805f, -57.642850f,
                -30.510438f, -57.889465f, -30.587582f, -57.887298f, -30.695359f, -57.809018f, -30.856258f, -57.799648f, -30.916870f, -57.831591f,
                -30.920869f, -57.915001f, -31.034678f, -57.861428f, -31.130403f, -57.919249f, -31.217075f, -57.914210f, -31.320029f, -57.981463f,
                -31.361873f, -57.997148f, -31.390503f, -57.980542f, -31.456470f, -58.082018f, -31.488800f, -58.078247f, -31.531375f, -58.004356f,
                -31.580292f, -57.980711f, -31.673504f, -58.010677f, -31.673504f, -58.087644f, -30.085396f, -58.087644f
            )
            poly[490] = TzPolygon(
                -30.088811f, -57.067189f, -30.086311f, -57.070451f, -30.121088f, -57.090699f, -30.114028f, -57.116121f, -30.135258f, -57.105867f,
                -30.198088f, -57.167975f, -30.234495f, -57.155317f, -30.289278f, -57.220813f, -30.289306f, -57.249536f, -30.267152f, -57.259779f,
                -30.294000f, -57.284000f, -30.257821f, -57.313501f, -30.285000f, -57.353000f, -30.274854f, -57.372651f, -30.304737f, -57.392294f,
                -30.266052f, -57.464850f, -30.285693f, -57.524310f, -30.258991f, -57.566485f, -30.211343f, -57.560874f, -30.193907f, -57.648930f,
                -30.123146f, -57.480465f, -30.085396f, -57.451407f, -30.085396f, -57.067189f
            )
            poly[491] = TzPolygon(
                -30.085816f, -57.067189f, -30.105533f, -57.045369f, -30.085929f, -56.994090f, -30.113550f, -56.904972f, -30.086300f, -56.874611f,
                -30.103859f, -56.807048f, -30.162906f, -56.777510f, -30.176418f, -56.705347f, -30.204946f, -56.697355f, -30.203456f, -56.646280f,
                -30.218447f, -56.667991f, -30.265656f, -56.610565f, -30.300545f, -56.618695f, -30.288816f, -56.576438f, -30.312907f, -56.541147f,
                -30.359455f, -56.547058f, -30.360171f, -56.518673f, -30.398418f, -56.489872f, -30.384864f, -56.461264f, -30.422556f, -56.453448f,
                -30.449495f, -56.397126f, -30.499556f, -56.381765f, -30.491212f, -56.355912f, -30.531342f, -56.322242f, -30.519674f, -56.291926f,
                -30.585086f, -56.260953f, -30.574071f, -56.235674f, -30.607509f, -56.219200f, -30.615174f, -56.170739f, -30.731972f, -56.132185f,
                -30.757247f, -56.088586f, -30.746795f, -56.068270f, -30.775368f, -56.046735f, -31.673504f, -56.046735f, -31.673504f, -57.067189f
            )
            poly[492] = TzPolygon(
                -30.775368f, -56.046735f, -30.848082f, -55.991930f, -30.944896f, -56.015329f, -31.082440f, -56.009655f, -31.076539f, -55.883372f,
                -31.014676f, -55.812486f, -31.015541f, -55.776576f, -30.979391f, -55.728147f, -30.942747f, -55.723757f, -30.953968f, -55.666062f,
                -30.911597f, -55.642266f, -30.863997f, -55.658342f, -30.833089f, -55.577415f, -30.947598f, -55.486825f, -30.959731f, -55.441381f,
                -31.018229f, -55.423056f, -31.039216f, -55.349811f, -31.067541f, -55.359921f, -31.088192f, -55.327731f, -31.131436f, -55.340373f,
                -31.142264f, -55.291184f, -31.260616f, -55.240034f, -31.269459f, -55.169329f, -31.332155f, -55.074459f, -31.269806f, -55.031921f,
                -31.266919f, -55.007233f, -31.331934f, -54.953276f, -31.351489f, -54.960215f, -31.356503f, -54.935218f, -31.380685f, -54.940871f,
                -31.377302f, -54.886225f, -31.442003f, -54.836702f, -31.424458f, -54.752240f, -31.456563f, -54.586765f, -31.510194f, -54.515704f,
                -31.599585f, -54.452798f, -31.651707f, -54.456406f, -31.928245f, -54.100193f, -31.895427f, -54.032779f, -31.904928f, -54.005825f,
                -33.261612f, -54.005825f, -33.261612f, -56.046735f
            )
            poly[493] = TzPolygon(
                -31.904928f, -54.005825f, -31.917655f, -53.969722f, -31.955318f, -53.960733f, -32.000642f, -53.849776f, -32.055240f, -53.833751f,
                -32.096148f, -53.725216f, -32.151877f, -53.735001f, -32.296989f, -53.642800f, -32.383854f, -53.645205f, -32.451918f, -53.583210f,
                -32.488540f, -53.527662f, -32.484461f, -53.464232f, -32.565058f, -53.432604f, -32.581443f, -53.400987f, -32.569735f, -53.370158f,
                -32.621013f, -53.290780f, -32.604096f, -53.249925f, -32.740881f, -53.075583f, -32.788350f, -53.085802f, -32.792023f, -53.145689f,
                -32.850431f, -53.184956f, -32.899314f, -53.294539f, -32.918431f, -53.309312f, -32.934454f, -53.244292f, -33.052961f, -53.444381f,
                -33.153425f, -53.518189f, -33.261612f, -53.521037f, -33.261612f, -54.005825f
            )
            poly[494] = TzPolygon(
                -30.085396f, -57.451407f, -30.036842f, -57.414032f, -29.992845f, -57.337128f, -29.876115f, -57.326184f, -29.787937f, -57.241912f,
                -29.764937f, -57.120912f, -29.641533f, -56.969840f, -29.581211f, -56.951748f, -29.435326f, -56.777379f, -29.377679f, -56.766182f,
                -29.359128f, -56.701637f, -29.258538f, -56.648079f, -29.196069f, -56.643787f, -29.125164f, -56.593147f, -29.075000f, -56.418000f,
                -28.974798f, -56.407753f, -28.896137f, -56.299950f, -28.802720f, -56.296511f, -28.759238f, -56.178580f, -28.687041f, -56.126224f,
                -28.607182f, -56.009843f, -28.508726f, -56.012491f, -28.479231f, -55.883574f, -30.085396f, -55.883574f
            )
            poly[495] = TzPolygon(-28.479231f, -55.883574f, -28.412177f, -55.903229f, -28.393264f, -55.893571f, -28.393264f, -55.883574f)
            poly[496] = TzPolygon(-28.393264f, -55.686687f, -28.422043f, -55.694328f, -28.423401f, -55.717674f, -28.393264f, -55.737148f)
            poly[497] = TzPolygon(
                -27.383750f, -57.601072f, -27.326978f, -57.694530f, -27.334160f, -57.814500f, -27.275266f, -57.874817f, -27.263060f, -57.919449f,
                -27.275954f, -58.171500f, -27.256324f, -58.171500f, -27.256324f, -57.554695f, -27.383750f, -57.554695f
            )
            poly[498] = TzPolygon(
                -25.443098f, -58.171500f, -25.443098f, -57.554695f, -25.559345f, -57.573697f, -25.568896f, -57.604913f, -25.616495f, -57.617611f,
                -25.596409f, -57.674058f, -25.659830f, -57.675280f, -25.653057f, -57.743434f, -25.700523f, -57.767600f, -25.716286f, -57.727301f,
                -25.757760f, -57.773986f, -25.754312f, -57.825696f, -25.822344f, -57.793985f, -25.859709f, -57.866551f, -25.913766f, -57.833879f,
                -25.955799f, -57.894598f, -25.987296f, -57.853409f, -26.009143f, -57.855737f, -26.107376f, -58.024308f, -26.111846f, -58.084733f,
                -26.186362f, -58.119694f, -26.182690f, -58.159751f, -26.228508f, -58.103866f, -26.265295f, -58.164025f, -26.344982f, -58.156659f,
                -26.358070f, -58.171500f
            )
            poly[499] = TzPolygon(
                -25.443098f, -57.554695f, -25.322178f, -57.702950f, -25.285932f, -57.694460f, -25.220289f, -57.759005f, -25.176271f, -57.753587f,
                -25.131514f, -57.836738f, -25.081396f, -57.861350f, -25.086165f, -57.975387f, -25.033567f, -58.008680f, -25.045757f, -58.068912f,
                -25.008685f, -58.090843f, -25.011547f, -58.137737f, -24.975004f, -58.150026f, -24.971517f, -58.171500f, -24.971517f, -57.554695f
            )
        }
    }

    private object Initializer6 {
        fun init() {
            poly[500] = TzPolygon(
                -27.383750f, -56.217655f, -27.341657f, -56.173053f, -27.308452f, -56.087277f, -27.312518f, -56.037036f, -27.355114f, -55.978926f,
                -27.342731f, -55.896275f, -27.383750f, -55.859440f
            )
            poly[501] = TzPolygon(
                -27.383750f, -55.687280f, -27.378466f, -55.683009f, -27.337499f, -55.598931f, -27.279151f, -55.600264f, -27.250778f, -55.575678f,
                -27.182156f, -55.621590f, -27.162407f, -55.605701f, -27.163545f, -55.564983f, -27.108297f, -55.562511f, -27.104263f, -55.454485f,
                -27.017810f, -55.441962f, -26.966312f, -55.378406f, -26.962682f, -55.305832f, -26.936886f, -55.260090f, -26.969489f, -55.203597f,
                -26.948583f, -55.135102f, -26.896237f, -55.150208f, -26.852751f, -55.127892f, -26.797297f, -55.052361f, -26.783279f, -54.958271f,
                -26.682626f, -54.941124f, -26.655576f, -54.869006f, -26.674343f, -54.823364f, -26.631112f, -54.786945f, -26.537220f, -54.801541f,
                -26.498955f, -54.761145f, -27.383750f, -54.761145f
            )
            poly[502] = TzPolygon(
                -26.780692f, -54.761145f, -26.780692f, -53.714771f, -26.782261f, -53.717054f, -26.847212f, -53.694725f, -26.858288f, -53.662850f,
                -26.860147f, -53.696837f, -26.869946f, -53.680010f, -26.887078f, -53.695742f, -26.894434f, -53.670997f, -26.929831f, -53.696783f,
                -26.942484f, -53.671250f, -26.934136f, -53.709196f, -26.960650f, -53.703444f, -26.974462f, -53.737083f, -26.990344f, -53.717999f,
                -26.991551f, -53.743074f, -27.014724f, -53.740819f, -27.008282f, -53.763594f, -27.032184f, -53.747302f, -27.045352f, -53.763900f,
                -27.026738f, -53.785853f, -27.065428f, -53.760874f, -27.040278f, -53.802327f, -27.073971f, -53.771876f, -27.078250f, -53.805549f,
                -27.103307f, -53.776503f, -27.102786f, -53.818939f, -27.122901f, -53.804543f, -27.133247f, -53.824389f, -27.146289f, -53.798789f,
                -27.145887f, -53.828245f, -27.169915f, -53.836237f, -27.127411f, -53.879053f, -27.176463f, -53.909972f, -27.152051f, -53.951170f,
                -27.194912f, -53.960253f, -27.200409f, -54.009892f, -27.248372f, -54.021074f, -27.301126f, -54.088891f, -27.296190f, -54.156185f,
                -27.254000f, -54.172000f, -27.383750f, -54.216578f, -27.383750f, -54.761145f
            )
            poly[503] = TzPolygon(
                -26.177634f, -54.657362f, -26.216938f, -54.618744f, -26.264725f, -54.679579f, -26.311794f, -54.648801f, -26.378675f, -54.697155f,
                -26.446046f, -54.705291f, -26.498955f, -54.761145f, -26.177634f, -54.761145f
            )
            poly[504] = TzPolygon(
                -26.780692f, -53.662850f, -26.780692f, -53.714771f, -26.769594f, -53.698622f, -26.764284f, -53.743730f, -26.750711f, -53.714038f,
                -26.720368f, -53.757889f, -26.717058f, -53.734567f, -26.681349f, -53.743391f, -26.684779f, -53.717338f, -26.650887f, -53.720252f,
                -26.640985f, -53.759459f, -26.644077f, -53.739709f, -26.560856f, -53.707507f, -26.566543f, -53.736356f, -26.545145f, -53.741750f,
                -26.539159f, -53.720189f, -26.500921f, -53.729022f, -26.508924f, -53.704851f, -26.490330f, -53.695893f, -26.470614f, -53.715186f,
                -26.430905f, -53.687262f, -26.387569f, -53.709996f, -26.313342f, -53.662850f
            )
            poly[505] = TzPolygon(-26.192786f, -53.662850f, -26.177634f, -53.678390f, -26.177634f, -53.662850f)
            poly[506] = TzPolygon(
                -25.574576f, -54.761145f, -25.574576f, -54.597496f, -25.662630f, -54.581235f, -25.659618f, -54.640807f, -25.687650f, -54.657778f,
                -25.830428f, -54.587047f, -25.914252f, -54.622306f, -25.978180f, -54.610621f, -25.995239f, -54.679330f, -26.093444f, -54.643010f,
                -26.164874f, -54.669899f, -26.177634f, -54.657362f, -26.177634f, -54.761145f
            )
            poly[507] = TzPolygon(-25.574576f, -54.233143f, -25.593000f, -54.235000f, -25.596189f, -54.255077f, -25.574576f, -54.272006f)
            poly[508] = TzPolygon(
                -25.574576f, -54.332331f, -25.606749f, -54.348221f, -25.597471f, -54.383946f, -25.697560f, -54.432884f, -25.618096f, -54.492703f,
                -25.628665f, -54.526420f, -25.588129f, -54.552575f, -25.592753f, -54.593535f, -25.574576f, -54.596904f
            )
            poly[509] = TzPolygon(
                -26.177634f, -53.678390f, -26.115572f, -53.742040f, -26.043181f, -53.734204f, -25.970178f, -53.836770f, -25.898539f, -53.819509f,
                -25.883663f, -53.850008f, -25.872236f, -53.823501f, -25.839815f, -53.850120f, -25.793767f, -53.822137f, -25.790655f, -53.843452f,
                -25.780858f, -53.830917f, -25.766052f, -53.857018f, -25.751379f, -53.834066f, -25.744423f, -53.866200f, -25.707706f, -53.879314f,
                -25.687327f, -53.842542f, -25.658641f, -53.862687f, -25.661073f, -53.890301f, -25.622236f, -53.892777f, -25.636287f, -53.912308f,
                -25.616174f, -53.916511f, -25.611325f, -53.947738f, -25.643519f, -53.962366f, -25.600909f, -53.970265f, -25.574576f, -54.005036f,
                -25.574576f, -53.662850f, -26.177634f, -53.662850f
            )
            poly[510] = TzPolygon(-25.574576f, -54.034108f, -25.585000f, -54.049000f, -25.574576f, -54.063594f)
            poly[511] = TzPolygon(-25.574576f, -54.087118f, -25.619000f, -54.098000f, -25.574576f, -54.120212f)
            poly[512] = TzPolygon(-25.574576f, -54.184137f, -25.584000f, -54.178000f, -25.574576f, -54.201407f)
            poly[513] = TzPolygon(-25.574576f, -54.332331f, -25.553935f, -54.288173f, -25.574576f, -54.272006f)
            poly[514] = TzPolygon(-25.574576f, -54.233143f, -25.562296f, -54.231905f, -25.574576f, -54.201407f)
            poly[515] = TzPolygon(
                -25.574576f, -54.184137f, -25.541000f, -54.206000f, -25.541000f, -54.161000f, -25.495000f, -54.099000f, -25.567000f, -54.124000f,
                -25.574576f, -54.120212f
            )
            poly[516] = TzPolygon(-25.574576f, -54.082008f, -25.557657f, -54.075917f, -25.574576f, -54.059262f)
            poly[517] = TzPolygon(-25.574576f, -54.026414f, -25.567000f, -54.010000f, -25.574576f, -54.004839f)
            poly[518] = TzPolygon(
                -24.971517f, -54.439441f, -25.084088f, -54.458136f, -25.159149f, -54.429502f, -25.313138f, -54.499111f, -25.454309f, -54.619705f,
                -25.574576f, -54.597496f, -25.574576f, -54.761145f, -24.971517f, -54.761145f
            )
            poly[519] = TzPolygon(-26.183765f, -53.662850f, -26.194481f, -53.650406f, -26.249652f, -53.637451f, -26.297939f, -53.662850f)
            poly[520] = TzPolygon(-26.857392f, -53.662850f, -26.858157f, -53.660456f, -26.858288f, -53.662850f)
            poly[521] = TzPolygon(-22.204843f, -56.330086f, -22.169491f, -56.364855f, -22.151733f, -56.370302f, -22.151733f, -56.330086f)
            poly[522] = TzPolygon(
                -22.151733f, -56.534711f, -22.196549f, -56.556748f, -22.244041f, -56.642261f, -22.263407f, -56.637053f, -22.216928f, -56.703442f,
                -22.264792f, -56.720261f, -22.235719f, -56.746996f, -22.260414f, -56.776571f, -22.242379f, -56.793443f, -22.283327f, -56.802691f,
                -22.301554f, -56.842854f, -22.277699f, -56.879965f, -22.247554f, -56.883430f, -22.266490f, -56.905510f, -22.242727f, -56.987088f,
                -22.222459f, -56.996705f, -22.251128f, -57.082446f, -22.225389f, -57.110259f, -22.236582f, -57.183505f, -22.210984f, -57.201353f,
                -22.251348f, -57.237664f, -22.218526f, -57.294484f, -22.245548f, -57.320437f, -22.232043f, -57.374403f, -22.197581f, -57.407338f,
                -22.191154f, -57.489628f, -22.168151f, -57.522847f, -22.175344f, -57.580396f, -22.151733f, -57.589229f
            )
            poly[523] = TzPolygon(
                -23.561625f, -55.528616f, -23.561625f, -54.488672f, -23.893027f, -54.488672f, -23.874332f, -54.568497f, -23.837194f, -54.584378f,
                -23.851482f, -54.609508f, -23.812615f, -54.669779f, -23.864520f, -54.705325f, -23.856643f, -54.759408f, -23.906000f, -54.849000f,
                -23.898000f, -54.890000f, -23.922000f, -54.925000f, -23.959000f, -54.924000f, -23.956000f, -54.998000f, -23.993353f, -55.062233f,
                -23.961918f, -55.107174f, -24.013828f, -55.229072f, -23.965061f, -55.304168f, -23.994601f, -55.345433f, -23.964524f, -55.414243f,
                -23.916803f, -55.446252f, -23.716646f, -55.436730f, -23.711937f, -55.463962f, -23.640051f, -55.484196f, -23.625015f, -55.539906f,
                -23.567313f, -55.526385f
            )
            poly[524] = TzPolygon(
                -22.204843f, -56.330086f, -22.218290f, -56.316860f, -22.236588f, -56.238030f, -22.278052f, -56.209831f, -22.288342f, -56.165897f,
                -22.270323f, -56.117682f, -22.294616f, -56.010168f, -22.280328f, -55.853190f, -22.384601f, -55.789394f, -22.384393f, -55.746947f,
                -22.459117f, -55.735159f, -22.476824f, -55.752465f, -22.551948f, -55.723408f, -22.655211f, -55.614320f, -22.767498f, -55.618404f,
                -22.791663f, -55.650634f, -22.852446f, -55.665833f, -23.149926f, -55.596348f, -23.156100f, -55.541986f, -23.197334f, -55.523560f,
                -23.220467f, -55.546021f, -23.259790f, -55.522720f, -23.279613f, -55.553132f, -23.316532f, -55.555814f, -23.378879f, -55.504574f,
                -23.477278f, -55.544994f, -23.476213f, -55.562115f, -23.561625f, -55.528616f, -23.561625f, -56.330086f
            )
            poly[525] = TzPolygon(
                -22.151733f, -57.589229f, -22.094620f, -57.610596f, -22.107062f, -57.652655f, -22.091108f, -57.707512f, -22.113653f, -57.716975f,
                -22.102818f, -57.738089f, -22.134756f, -57.739127f, -22.125232f, -57.779792f, -22.150722f, -57.801829f, -22.120511f, -57.827396f,
                -22.135925f, -57.865322f, -22.120213f, -57.929674f, -22.082807f, -57.942248f, -22.090233f, -57.993842f, -22.063451f, -57.984244f,
                -22.040378f, -58.009461f, -22.004996f, -57.965827f, -21.922796f, -57.934951f, -21.901296f, -57.948684f, -21.882660f, -57.912806f,
                -21.850453f, -57.966028f, -21.773548f, -57.908658f, -21.744133f, -57.947143f, -21.689028f, -57.883287f, -21.650365f, -57.934365f,
                -21.622382f, -57.942888f, -21.590213f, -57.913865f, -21.563112f, -57.959699f, -21.524324f, -57.967953f, -21.331091f, -57.853501f,
                -21.280379f, -57.921613f, -21.224075f, -57.850665f, -21.140036f, -57.864535f, -21.097767f, -57.846373f, -21.044168f, -57.868337f,
                -20.979564f, -57.816504f, -20.940665f, -57.819191f, -20.948466f, -57.863820f, -20.906372f, -57.889070f, -20.900364f, -57.928365f,
                -20.834026f, -57.855199f, -20.788720f, -57.898631f, -20.791600f, -57.961828f, -20.745653f, -57.934779f, -20.749987f, -57.868689f,
                -20.741840f, -57.868044f, -20.741840f, -57.250793f, -22.151733f, -57.250793f
            )
            poly[526] = TzPolygon(-22.151733f, -56.534711f, -22.095609f, -56.507114f, -22.074341f, -56.394040f, -22.151733f, -56.370302f)
            poly[527] = TzPolygon(
                -20.015895f, -58.171500f, -20.120085f, -58.137864f, -20.172900f, -58.168832f, -20.192460f, -58.121521f, -20.228588f, -58.164614f,
                -20.259525f, -58.162164f, -20.271832f, -58.143519f, -20.254451f, -58.095960f, -20.355544f, -58.093394f, -20.435512f, -57.998465f,
                -20.515276f, -58.019236f, -20.561592f, -57.995242f, -20.610685f, -58.013809f, -20.642557f, -57.970485f, -20.698787f, -57.988482f,
                -20.704233f, -57.954870f, -20.663920f, -57.924136f, -20.725585f, -57.869891f, -20.741840f, -57.869090f, -20.741840f, -58.171500f
            )
            poly[528] = TzPolygon(-19.822709f, -58.171500f, -19.827268f, -58.163854f, -19.834362f, -58.171500f)
            poly[529] = TzPolygon(
                -19.834362f, -58.171500f, -19.827268f, -58.163854f, -19.822709f, -58.171500f, -19.331948f, -58.171500f, -19.331948f, -57.927083f,
                -19.758000f, -58.131000f, -19.970298f, -57.857957f, -20.042071f, -57.902481f, -20.020944f, -57.953465f, -20.056803f, -57.979452f,
                -20.063580f, -58.032649f, -20.107267f, -58.050440f, -20.108881f, -58.092529f, -20.145690f, -58.115620f, -20.167124f, -58.169687f,
                -20.120085f, -58.137864f, -20.015895f, -58.171500f
            )
            poly[530] = TzPolygon(
                -23.893027f, -54.488672f, -23.904464f, -54.439840f, -23.986686f, -54.383689f, -24.004536f, -54.321982f, -24.073356f, -54.282230f,
                -24.116326f, -54.333898f, -24.154425f, -54.344197f, -24.242406f, -54.324971f, -24.357000f, -54.258000f, -24.470729f, -54.327141f,
                -24.660587f, -54.324373f, -24.802806f, -54.395372f, -24.947694f, -54.435485f, -24.971517f, -54.439441f, -24.971517f, -54.488672f
            )
            poly[531] = TzPolygon(
                -22.151733f, -54.488672f, -22.151733f, -52.422733f, -22.218000f, -52.489000f, -22.343000f, -52.745000f, -22.439000f, -52.854000f,
                -22.493000f, -52.998000f, -22.553000f, -53.077000f, -22.621000f, -53.105000f, -22.728000f, -53.198000f, -22.775000f, -53.352000f,
                -22.890000f, -53.546000f, -22.951000f, -53.607000f, -22.998000f, -53.634000f, -23.125000f, -53.636000f, -23.319000f, -53.730000f,
                -23.372000f, -53.771000f, -23.456000f, -53.981000f, -23.764000f, -54.075000f, -23.951000f, -54.101000f, -24.073356f, -54.282230f,
                -24.004536f, -54.321982f, -24.007722f, -54.351711f, -23.958277f, -54.414604f, -23.904464f, -54.439840f, -23.893027f, -54.488672f
            )
            poly[532] = TzPolygon(
                -22.151733f, -52.422733f, -22.106000f, -52.377000f, -21.942000f, -52.301000f, -21.846000f, -52.190000f, -21.770000f, -52.161000f,
                -21.714000f, -52.076000f, -21.643000f, -52.049000f, -21.570222f, -52.101899f, -21.534828f, -52.094192f, -21.505372f, -52.052602f,
                -21.503978f, -51.970244f, -21.343515f, -51.861946f, -21.266071f, -51.848440f, -21.197840f, -51.880415f, -21.137189f, -51.878549f,
                -21.102000f, -51.789000f, -20.974041f, -51.721317f, -20.942271f, -51.623105f, -20.753127f, -51.634210f, -20.643000f, -51.594000f,
                -20.459000f, -51.409000f, -20.353000f, -51.341000f, -20.295000f, -51.132000f, -20.233189f, -51.058263f, -20.088925f, -50.998257f,
                -19.959000f, -51.020000f, -19.906000f, -50.999000f, -19.729000f, -51.045000f, -19.589000f, -50.987000f, -19.576000f, -50.923000f,
                -19.500000f, -50.962000f, -19.467000f, -50.934000f, -19.398676f, -51.026459f, -19.345499f, -51.044461f, -19.331948f, -51.060215f,
                -19.331948f, -50.806078f, -22.151733f, -50.805961f
            )
            poly[533] = TzPolygon(
                -17.922055f, -58.171500f, -17.922055f, -57.670833f, -18.046000f, -57.600000f, -18.131000f, -57.574000f, -18.231000f, -57.453000f,
                -18.240000f, -57.557000f, -18.797186f, -57.735232f, -18.899000f, -57.766000f, -18.899000f, -57.719000f, -18.978110f, -57.719215f,
                -19.010883f, -57.691608f, -19.034630f, -57.710212f, -19.033000f, -57.784000f, -19.331948f, -57.927083f, -19.331948f, -58.171500f
            )
            poly[534] = TzPolygon(
                -16.512163f, -57.250793f, -17.792638f, -57.250793f, -17.793511f, -57.254453f, -17.796948f, -57.250793f, -17.812406f, -57.250793f,
                -17.810532f, -57.309295f, -17.838163f, -57.345326f, -17.826823f, -57.380877f, -17.903297f, -57.456586f, -17.860189f, -57.477550f,
                -17.863367f, -57.515847f, -17.800217f, -57.577931f, -17.803411f, -57.605243f, -17.717797f, -57.640721f, -17.730895f, -57.664558f,
                -17.716536f, -57.684588f, -17.673987f, -57.668216f, -17.531012f, -57.725031f, -17.550931f, -57.745913f, -17.449000f, -57.883000f,
                -17.515000f, -57.996000f, -17.492000f, -58.043000f, -17.450000f, -58.060000f, -17.447000f, -58.120000f, -17.384000f, -58.151000f,
                -17.388221f, -58.171500f, -16.512163f, -58.171500f
            )
            poly[535] = TzPolygon(
                -17.388221f, -58.171500f, -17.384000f, -58.151000f, -17.451000f, -58.116000f, -17.450000f, -58.060000f, -17.492000f, -58.043000f,
                -17.515000f, -57.996000f, -17.449000f, -57.883000f, -17.550931f, -57.745913f, -17.560008f, -57.795670f, -17.597972f, -57.774028f,
                -17.642698f, -57.782167f, -17.729884f, -57.709642f, -17.774842f, -57.713482f, -17.810412f, -57.684982f, -17.830634f, -57.684920f,
                -17.830740f, -57.723019f, -17.922055f, -57.670833f, -17.922055f, -58.171500f
            )
            poly[536] = TzPolygon(
                -17.286252f, -56.330086f, -17.288908f, -56.339132f, -17.267412f, -56.360492f, -17.331709f, -56.445067f, -17.297111f, -56.492154f,
                -17.332128f, -56.579387f, -17.317294f, -56.647131f, -17.340205f, -56.648235f, -17.321808f, -56.657354f, -17.340703f, -56.663864f,
                -17.317013f, -56.683381f, -17.310246f, -56.735108f, -17.390810f, -56.789239f, -17.392755f, -56.831907f, -17.459604f, -56.826042f,
                -17.465538f, -56.850469f, -17.532183f, -56.875661f, -17.532406f, -56.911001f, -17.580121f, -56.983146f, -17.610696f, -56.982684f,
                -17.614478f, -56.960688f, -17.733244f, -57.048119f, -17.782021f, -57.118695f, -17.768437f, -57.149329f, -17.792638f, -57.250793f,
                -16.512163f, -57.250793f, -16.512163f, -56.330086f
            )
            poly[537] = TzPolygon(-17.796948f, -57.250793f, -17.812952f, -57.233748f, -17.812406f, -57.250793f)
            poly[538] = TzPolygon(
                -17.513359f, -55.409379f, -17.512463f, -55.444798f, -17.479223f, -55.473057f, -17.482895f, -55.525220f, -17.421675f, -55.590446f,
                -17.373521f, -55.586883f, -17.365211f, -55.627677f, -17.340052f, -55.642151f, -17.359681f, -55.647660f, -17.338200f, -55.658584f,
                -17.354321f, -55.704277f, -17.337410f, -55.709644f, -17.329940f, -55.787747f, -17.298000f, -55.806000f, -17.300699f, -55.843553f,
                -17.269039f, -55.875432f, -17.285149f, -55.888516f, -17.273792f, -55.903853f, -17.264107f, -55.888359f, -17.257880f, -55.928746f,
                -17.278610f, -55.942337f, -17.249953f, -55.952470f, -17.257964f, -55.988578f, -17.240256f, -56.011925f, -17.204994f, -56.007192f,
                -17.171000f, -56.045000f, -17.186907f, -56.054462f, -17.167453f, -56.114841f, -17.191339f, -56.140422f, -17.188883f, -56.187843f,
                -17.227306f, -56.211171f, -17.220108f, -56.254994f, -17.277225f, -56.299346f, -17.286252f, -56.330086f, -16.512163f, -56.330086f,
                -16.512163f, -55.409379f
            )
            poly[539] = TzPolygon(
                -17.513359f, -55.409379f, -16.512163f, -55.409379f, -16.512163f, -54.488672f, -17.487529f, -54.488672f, -17.488178f, -54.556466f,
                -17.467265f, -54.581596f, -17.521462f, -54.746686f, -17.567703f, -54.762737f, -17.624247f, -54.861871f, -17.608776f, -54.942455f,
                -17.639097f, -54.991591f, -17.642427f, -55.062736f, -17.626088f, -55.098549f, -17.654082f, -55.125875f, -17.615924f, -55.223875f,
                -17.540589f, -55.294693f, -17.548175f, -55.351021f, -17.514195f, -55.376344f
            )
            poly[540] = TzPolygon(
                -17.922055f, -53.865324f, -17.922055f, -53.121210f, -17.990463f, -53.064478f, -18.034632f, -53.072785f, -18.041560f, -53.173775f,
                -18.007000f, -53.237000f, -18.008000f, -53.380000f, -17.983000f, -53.439000f, -18.039000f, -53.472000f, -18.005000f, -53.557000f,
                -18.012000f, -53.589000f, -17.976000f, -53.616000f, -17.977000f, -53.661000f, -18.013000f, -53.692000f, -17.994000f, -53.786000f
            )
            poly[541] = TzPolygon(-17.922055f, -53.937743f, -17.923000f, -53.948000f, -17.922055f, -53.948127f)
            poly[542] = TzPolygon(
                -17.922055f, -53.121210f, -17.922055f, -52.647375f, -18.690325f, -52.647375f, -18.692000f, -52.747000f, -18.637000f, -52.918000f,
                -18.540000f, -52.962000f, -18.465000f, -52.880000f, -18.426000f, -52.873000f, -18.414000f, -52.798000f, -18.350000f, -52.759000f,
                -18.313000f, -52.805000f, -18.296000f, -52.935000f, -18.303000f, -52.976000f, -18.351000f, -53.027000f, -18.310000f, -53.101000f,
                -18.081000f, -53.143000f, -18.051548f, -53.076822f, -17.990463f, -53.064478f
            )
            poly[543] = TzPolygon(
                -17.922055f, -53.948127f, -17.871000f, -53.955000f, -17.702000f, -53.855000f, -17.672000f, -53.806000f, -17.663000f, -53.704000f,
                -17.254250f, -53.679614f, -17.227590f, -53.705129f, -17.294510f, -53.819352f, -17.355727f, -53.831169f, -17.374013f, -53.877432f,
                -17.458649f, -53.950309f, -17.506048f, -54.054051f, -17.563118f, -54.051916f, -17.618726f, -54.078639f, -17.603664f, -54.181012f,
                -17.653837f, -54.273177f, -17.662472f, -54.336167f, -17.633457f, -54.388019f, -17.572391f, -54.382000f, -17.528627f, -54.466883f,
                -17.487463f, -54.481728f, -17.487529f, -54.488672f, -16.512163f, -54.488672f, -16.512163f, -53.568023f, -17.922055f, -53.568023f,
                -17.922055f, -53.865324f, -17.916000f, -53.872000f
            )
            poly[544] = TzPolygon(
                -17.922055f, -53.121210f, -17.915589f, -53.126573f, -17.835524f, -53.131687f, -17.765526f, -53.164122f, -17.689788f, -53.244229f,
                -17.440000f, -53.233000f, -17.380000f, -53.196000f, -17.298512f, -53.218654f, -17.113281f, -53.118068f, -17.070266f, -53.055208f,
                -17.050489f, -53.071337f, -16.963150f, -53.055882f, -16.861268f, -53.014093f, -16.867190f, -52.963615f, -16.841093f, -52.952854f,
                -16.840394f, -52.926685f, -16.803295f, -52.933357f, -16.818458f, -52.923662f, -16.776455f, -52.884701f, -16.742593f, -52.786521f,
                -16.714075f, -52.785547f, -16.704761f, -52.760051f, -16.672697f, -52.754996f, -16.669686f, -52.771375f, -16.657553f, -52.740419f,
                -16.631082f, -52.746632f, -16.640311f, -52.715364f, -16.589863f, -52.740000f, -16.599613f, -52.705274f, -16.571281f, -52.704770f,
                -16.584674f, -52.672726f, -16.551074f, -52.668255f, -16.562030f, -52.650701f, -16.558407f, -52.647375f, -17.922055f, -52.647375f
            )
            poly[545] = TzPolygon(
                -18.690325f, -52.647375f, -18.689381f, -52.591203f, -18.658000f, -52.531000f, -18.691000f, -52.449000f, -18.822000f, -52.344000f,
                -18.847000f, -52.181000f, -18.888000f, -52.157000f, -18.899000f, -52.111000f, -18.942217f, -52.093024f, -18.962996f, -52.017978f,
                -18.981996f, -52.014978f, -18.969106f, -51.938996f, -19.050484f, -51.857555f, -19.137546f, -51.657844f, -19.126233f, -51.576605f,
                -19.161373f, -51.498006f, -19.166266f, -51.419890f, -19.221444f, -51.369190f, -19.218000f, -51.307000f, -19.239268f, -51.306705f,
                -19.273673f, -51.251378f, -19.260845f, -51.202478f, -19.307639f, -51.088474f, -19.331948f, -51.060215f, -19.331948f, -52.647375f
            )
            poly[546] = TzPolygon(-16.512163f, -52.634540f, -16.536613f, -52.627370f, -16.558407f, -52.647375f, -16.512163f, -52.647375f)
            poly[547] = TzPolygon(-16.411179f, -52.647258f, -16.398783f, -52.687634f, -16.302392f, -52.682701f, -16.284558f, -52.647258f)
            poly[548] = TzPolygon(
                -16.512163f, -52.634540f, -16.502772f, -52.637294f, -16.502464f, -52.613314f, -16.464419f, -52.604659f, -16.412343f, -52.643465f,
                -16.411179f, -52.647258f, -16.284558f, -52.647258f, -16.249429f, -52.577441f, -16.261424f, -52.547034f, -16.229966f, -52.570158f,
                -16.222389f, -52.545170f, -16.165320f, -52.549163f, -16.133644f, -52.515641f, -16.072111f, -52.329673f, -15.891669f, -52.251835f,
                -15.886575f, -52.011033f, -15.845026f, -51.983958f, -15.838689f, -51.954299f, -15.810756f, -51.950499f, -15.828855f, -51.882751f,
                -15.636294f, -51.758111f, -15.538431f, -51.778275f, -15.531099f, -51.760258f, -15.560050f, -51.740094f, -15.509225f, -51.735833f,
                -15.490610f, -51.700465f, -15.410000f, -51.697000f, -15.371000f, -51.671000f, -15.322703f, -51.691462f, -15.263230f, -51.645667f,
                -15.250822f, -51.672313f, -15.176968f, -51.651204f, -15.156079f, -51.596553f, -15.102270f, -51.558619f, -15.102270f, -50.806254f,
                -16.512163f, -50.806196f
            )
            poly[549] = TzPolygon(
                -15.102270f, -51.558619f, -15.062881f, -51.530851f, -15.045546f, -51.457640f, -15.005412f, -51.419805f, -15.009343f, -51.365788f,
                -14.969595f, -51.328306f, -15.037921f, -51.284888f, -15.027660f, -51.227856f, -14.984968f, -51.156704f, -14.944533f, -51.146034f,
                -14.920177f, -51.085964f, -14.840000f, -51.089000f, -14.789864f, -51.042482f, -14.750995f, -51.057154f, -14.524072f, -50.961122f,
                -14.416032f, -50.998238f, -14.326515f, -50.965715f, -14.294160f, -50.978501f, -14.169324f, -50.913568f, -14.114261f, -50.918252f,
                -14.125615f, -50.865533f, -14.089000f, -50.833000f, -13.966628f, -50.867697f, -13.914455f, -50.839952f, -13.733000f, -50.871000f,
                -13.694158f, -50.806313f, -15.102270f, -50.806254f
            )
            poly[550] = TzPolygon(
                -14.163903f, -46.188044f, -14.164359f, -46.190346f, -14.119259f, -46.219416f, -14.098000f, -46.265000f, -14.072912f, -46.226926f,
                -14.056365f, -46.248040f, -14.014522f, -46.210017f, -13.973713f, -46.219008f, -13.945039f, -46.267438f, -13.845046f, -46.233460f,
                -13.796000f, -46.282000f, -13.767154f, -46.223718f, -13.745072f, -46.237194f, -13.740874f, -46.284595f, -13.717227f, -46.238295f,
                -13.692378f, -46.257237f, -13.692378f, -46.188044f
            )
            poly[551] = TzPolygon(
                -15.102270f, -46.029482f, -15.102270f, -45.711891f, -15.112535f, -45.721285f, -15.113383f, -45.818321f, -15.157685f, -45.872560f,
                -15.138779f, -45.954580f, -15.194220f, -45.984762f, -15.199072f, -46.027124f, -15.260701f, -46.054929f, -15.262861f, -46.078810f,
                -15.193932f, -46.120362f, -15.165456f, -46.048563f, -15.118000f, -46.043000f
            )
            poly[552] = TzPolygon(
                -14.163903f, -46.188044f, -14.153000f, -46.133000f, -14.204396f, -46.096657f, -14.194000f, -46.061000f, -14.237967f, -46.054406f,
                -14.257891f, -45.994421f, -14.343453f, -45.942258f, -14.354970f, -45.906633f, -14.415000f, -45.935000f, -14.432994f, -45.978709f,
                -14.406268f, -46.008943f, -14.418405f, -46.016882f, -14.516805f, -46.004082f, -14.537950f, -45.977668f, -14.542956f, -45.996508f,
                -14.626000f, -45.985000f, -14.660318f, -45.990821f, -14.681224f, -46.029448f, -14.711000f, -46.001000f, -14.794000f, -46.008000f,
                -14.831000f, -46.052000f, -14.975295f, -45.965961f, -15.039224f, -45.975302f, -15.102270f, -46.029482f, -15.102270f, -46.188044f
            )
            poly[553] = TzPolygon(
                -15.102270f, -45.711838f, -14.943665f, -45.565870f, -14.953873f, -45.455014f, -14.921417f, -45.435350f, -14.918441f, -45.400226f,
                -14.871816f, -45.365008f, -14.851651f, -45.317438f, -14.831457f, -45.317233f, -14.833255f, -45.285795f, -14.744673f, -45.206240f,
                -14.732347f, -45.164566f, -14.749430f, -45.083684f, -14.679972f, -45.040591f, -14.578955f, -44.843245f, -14.570419f, -44.859403f,
                -14.537801f, -44.824346f, -14.498007f, -44.833433f, -14.448189f, -44.701404f, -14.415356f, -44.689291f, -14.415782f, -44.657995f,
                -14.393708f, -44.658116f, -14.388206f, -44.648778f, -15.102270f, -44.648778f
            )
            poly[554] = TzPolygon(
                -14.388206f, -44.648778f, -14.338780f, -44.564892f, -14.328167f, -44.486893f, -14.238936f, -44.315862f, -14.259006f, -44.246736f,
                -14.231821f, -44.214855f, -14.267655f, -44.170566f, -14.262761f, -44.137111f, -14.281434f, -44.134166f, -14.257371f, -44.113295f,
                -14.288946f, -44.034514f, -14.264585f, -43.997740f, -14.304928f, -43.942296f, -14.292739f, -43.893193f, -14.311868f, -43.881644f,
                -14.311640f, -43.819612f, -14.337740f, -43.777256f, -14.377760f, -43.815158f, -14.525676f, -43.873942f, -14.653924f, -43.884509f,
                -14.675197f, -43.859908f, -14.698811f, -43.725615f, -14.730188f, -43.719516f, -14.722008f, -43.686412f, -14.760473f, -43.615171f,
                -14.750715f, -43.580667f, -14.784546f, -43.535883f, -14.816515f, -43.530319f, -14.787809f, -43.469488f, -14.768151f, -43.481646f,
                -14.723202f, -43.434649f, -14.669957f, -43.311732f, -14.650731f, -43.177183f, -14.684120f, -43.109512f, -16.217122f, -43.109512f,
                -16.217122f, -44.648778f
            )
            poly[555] = TzPolygon(
                -14.684120f, -43.109512f, -14.696519f, -43.084382f, -14.682940f, -43.037621f, -14.707717f, -42.939187f, -14.744336f, -42.927253f,
                -14.764760f, -42.870308f, -14.885865f, -42.722981f, -14.944884f, -42.626253f, -14.923721f, -42.598581f, -15.017000f, -42.476000f,
                -15.022714f, -42.436958f, -15.062776f, -42.440807f, -15.071000f, -42.374000f, -15.098000f, -42.355000f, -15.080000f, -42.331000f,
                -15.125383f, -42.265014f, -15.086086f, -42.173022f, -15.186476f, -42.091443f, -15.158829f, -41.997362f, -15.174000f, -41.932000f,
                -15.115000f, -41.870000f, -15.100254f, -41.801819f, -15.307070f, -41.570246f, -16.217122f, -41.570246f, -16.217122f, -43.109512f
            )
            poly[556] = TzPolygon(
                -18.099873f, -40.030979f, -17.979559f, -40.222818f, -17.922000f, -40.263000f, -17.851000f, -40.174000f, -17.795000f, -40.218000f,
                -17.737604f, -40.219773f, -17.726033f, -40.276257f, -17.619177f, -40.342947f, -17.644276f, -40.355390f, -17.612651f, -40.372507f,
                -17.625000f, -40.396000f, -17.609393f, -40.415076f, -17.567462f, -40.412154f, -17.568525f, -40.460551f, -17.520939f, -40.488961f,
                -17.489472f, -40.482978f, -17.445462f, -40.519939f, -17.406000f, -40.623000f, -17.389631f, -40.598750f, -17.326000f, -40.609000f,
                -17.284202f, -40.547143f, -17.251867f, -40.571343f, -17.199830f, -40.551596f, -17.163427f, -40.578032f, -17.102900f, -40.556944f,
                -17.062101f, -40.570851f, -16.885069f, -40.492081f, -16.899000f, -40.417000f, -16.874000f, -40.366000f, -16.907828f, -40.331036f,
                -16.901000f, -40.281000f, -16.846176f, -40.247825f, -16.805402f, -40.258563f, -16.785793f, -40.345059f, -16.736000f, -40.310000f,
                -16.586744f, -40.283582f, -16.556677f, -40.234308f, -16.579364f, -40.157947f, -16.524098f, -40.170751f, -16.421373f, -40.097901f,
                -16.463845f, -40.083629f, -16.459018f, -40.066769f, -16.390046f, -40.030979f
            )
            poly[557] = TzPolygon(
                -16.217122f, -39.906950f, -16.244563f, -39.936510f, -16.284049f, -39.916383f, -16.327000f, -39.966000f, -16.313000f, -39.991000f,
                -16.390046f, -40.030979f, -16.217122f, -40.030979f
            )
            poly[558] = TzPolygon(
                -18.099873f, -40.030979f, -18.329545f, -39.664770f, -18.348003f, -39.669190f, -18.367914f, -39.471719f, -18.529939f, -39.522997f,
                -18.741865f, -39.541482f, -18.741865f, -40.030979f
            )
            poly[559] = TzPolygon(
                -15.307070f, -41.570246f, -15.498402f, -41.356010f, -15.741560f, -41.329993f, -15.737000f, -41.215000f, -15.770375f, -41.140869f,
                -15.719000f, -41.077000f, -15.712733f, -41.005300f, -15.648000f, -40.963000f, -15.694000f, -40.881000f, -15.683000f, -40.842000f,
                -15.646550f, -40.823399f, -15.714079f, -40.767664f, -15.703647f, -40.739861f, -15.680251f, -40.741362f, -15.668618f, -40.699072f,
                -15.728888f, -40.644889f, -15.716115f, -40.629307f, -15.736542f, -40.606841f, -15.802973f, -40.561329f, -15.797049f, -40.517949f,
                -15.769205f, -40.510730f, -15.774532f, -40.479574f, -15.753304f, -40.460755f, -15.807039f, -40.423885f, -15.823203f, -40.376211f,
                -15.803000f, -40.231000f, -15.861859f, -40.200518f, -15.868317f, -40.164855f, -15.904000f, -40.175000f, -15.912193f, -40.106020f,
                -15.896720f, -40.084818f, -15.921773f, -40.085297f, -15.911452f, -40.065745f, -15.940758f, -40.079607f, -15.989493f, -40.023510f,
                -15.997616f, -39.916689f, -16.025079f, -39.933982f, -16.113385f, -39.856783f, -16.141000f, -39.897000f, -16.195207f, -39.883343f,
                -16.217122f, -39.906950f, -16.217122f, -41.570246f
            )
            poly[560] = TzPolygon(
                -27.782686f, -69.003680f, -27.794759f, -69.095210f, -27.717576f, -69.093372f, -27.696915f, -69.044483f, -27.616953f, -69.053169f,
                -27.580538f, -69.003680f
            )
            poly[561] = TzPolygon(
                -28.393264f, -69.642201f, -28.327687f, -69.522826f, -28.183574f, -69.456789f, -28.226797f, -69.391459f, -28.184372f, -69.383819f,
                -28.128662f, -69.308756f, -28.069677f, -69.299612f, -28.046693f, -69.263974f, -28.010287f, -69.267303f, -27.967557f, -69.236306f,
                -27.972151f, -69.177358f, -27.948475f, -69.155857f, -27.794759f, -69.095210f, -27.782686f, -69.003680f, -28.393264f, -69.003680f
            )
            poly[562] = TzPolygon(
                -27.782686f, -69.003680f, -27.755690f, -68.799005f, -27.788574f, -68.725469f, -27.815204f, -68.716028f, -27.791687f, -68.624253f,
                -27.819721f, -68.582389f, -27.709766f, -68.543315f, -27.838393f, -68.514690f, -27.873642f, -68.440297f, -28.015468f, -68.456798f,
                -28.004064f, -68.396931f, -28.037611f, -68.335776f, -28.026398f, -68.286295f, -28.068440f, -68.295457f, -28.095039f, -68.274729f,
                -28.071128f, -68.246233f, -28.085952f, -68.182998f, -28.110730f, -68.164544f, -28.101796f, -68.141220f, -28.173396f, -68.107445f,
                -28.124791f, -68.022451f, -28.114089f, -67.914895f, -28.172261f, -67.930269f, -28.259096f, -67.894188f, -28.313786f, -67.840776f,
                -28.375508f, -67.846359f, -28.375937f, -67.815551f, -28.348498f, -67.806108f, -28.351398f, -67.770677f, -28.393264f, -67.770677f,
                -28.393264f, -69.003680f
            )
            poly[563] = TzPolygon(
                -26.780915f, -69.003680f, -26.780915f, -68.367225f, -26.916228f, -68.263802f, -26.925767f, -68.291511f, -26.982490f, -68.318325f,
                -27.033590f, -68.295992f, -27.064374f, -68.430905f, -27.094585f, -68.451061f, -27.057879f, -68.483650f, -27.120923f, -68.476926f,
                -27.135139f, -68.496384f, -27.113794f, -68.555859f, -27.175202f, -68.572847f, -27.169898f, -68.618377f, -27.103758f, -68.668674f,
                -27.100259f, -68.703959f, -27.113087f, -68.751080f, -27.098868f, -68.778190f, -27.152634f, -68.806971f, -27.154640f, -68.841202f,
                -27.260622f, -68.868393f, -27.301107f, -68.808478f, -27.317038f, -68.868668f, -27.398370f, -68.887598f, -27.411229f, -68.930027f,
                -27.444406f, -68.936618f, -27.430293f, -68.966849f, -27.446770f, -68.988719f, -27.523250f, -68.942310f, -27.523604f, -68.987525f,
                -27.560637f, -68.976634f, -27.580538f, -69.003680f
            )
            poly[564] = TzPolygon(
                -28.351398f, -67.770677f, -28.352621f, -67.755728f, -28.329947f, -67.760686f, -28.311741f, -67.695856f, -28.384185f, -67.376695f,
                -28.383546f, -67.155801f, -28.270403f, -67.075075f, -28.254312f, -67.015427f, -28.288509f, -66.570774f, -28.393264f, -66.537674f,
                -28.393264f, -67.770677f
            )
            poly[565] = TzPolygon(
                -26.352551f, -66.537674f, -26.352209f, -66.539941f, -26.292376f, -66.560733f, -26.266479f, -66.538503f, -26.248621f, -66.567514f,
                -26.160946f, -66.584423f, -26.107103f, -66.660490f, -26.076675f, -66.660705f, -26.080992f, -66.704221f, -26.048108f, -66.778636f,
                -25.980363f, -66.839408f, -25.916577f, -66.852794f, -25.796273f, -66.847582f, -25.764648f, -66.872170f, -25.712538f, -66.842623f,
                -25.698772f, -66.794708f, -25.711919f, -66.648731f, -25.629397f, -66.606717f, -25.620942f, -66.563845f, -25.585588f, -66.571655f,
                -25.539160f, -66.537674f
            )
            poly[566] = TzPolygon(
                -25.372480f, -66.537674f, -25.362215f, -66.599851f, -25.298643f, -66.559343f, -25.241243f, -66.879499f, -25.237685f, -67.864494f,
                -25.168567f, -68.507223f, -25.168567f, -66.537674f
            )
            poly[567] = TzPolygon(
                -25.168567f, -68.507223f, -25.207084f, -68.501416f, -25.298507f, -68.545775f, -25.314192f, -68.522283f, -25.374353f, -68.522605f,
                -25.414405f, -68.589953f, -25.448390f, -68.589256f, -25.574439f, -68.514951f, -25.630461f, -68.545780f, -25.708099f, -68.478917f,
                -26.178220f, -68.381075f, -26.287103f, -68.557536f, -26.492936f, -68.587336f, -26.780915f, -68.367225f, -26.780915f, -69.003680f,
                -25.168567f, -69.003680f
            )
            poly[568] = TzPolygon(
                -27.046989f, -66.537674f, -27.046989f, -65.958290f, -27.261056f, -66.140793f, -27.333128f, -65.971895f, -27.525227f, -65.970733f,
                -27.669067f, -65.915372f, -27.688848f, -65.865655f, -27.851059f, -65.832287f, -27.806610f, -65.793683f, -27.768394f, -65.802504f,
                -27.768864f, -65.750367f, -27.818009f, -65.702254f, -27.970182f, -65.667817f, -27.971455f, -65.618279f, -28.013268f, -65.569823f,
                -27.929197f, -65.506348f, -27.845797f, -65.365251f, -27.946457f, -65.171045f, -28.186361f, -65.112451f, -28.393264f, -65.101266f,
                -28.393264f, -66.537674f
            )
            poly[569] = TzPolygon(
                -28.393264f, -65.101266f, -28.186361f, -65.112451f, -27.906972f, -65.167722f, -27.879171f, -65.039730f, -27.791474f, -65.016099f,
                -27.739157f, -65.032738f, -27.733876f, -64.988228f, -27.586819f, -65.029798f, -27.546087f, -64.955768f, -27.466251f, -65.012245f,
                -27.344999f, -64.932636f, -27.318417f, -64.854573f, -27.046989f, -64.776507f, -27.046989f, -64.268303f, -28.393264f, -64.268303f
            )
            poly[570] = TzPolygon(
                -26.352551f, -66.537674f, -26.364106f, -66.461085f, -26.416701f, -66.382141f, -26.149217f, -66.230607f, -26.133847f, -66.170712f,
                -26.216600f, -66.099200f, -26.377030f, -66.118984f, -26.401326f, -66.158466f, -26.471495f, -66.177693f, -26.628931f, -66.172285f,
                -26.600379f, -66.042152f, -26.744211f, -65.830078f, -26.863778f, -65.900524f, -26.901214f, -65.857630f, -26.929072f, -65.857759f,
                -27.046989f, -65.958290f, -27.046989f, -66.537674f
            )
            poly[571] = TzPolygon(
                -25.700714f, -65.402989f, -26.091851f, -65.402989f, -26.109000f, -65.424400f, -26.087500f, -65.548100f, -26.123500f, -65.613600f,
                -26.117300f, -65.688500f, -26.352800f, -65.719400f, -26.238700f, -66.071400f, -26.142263f, -66.158509f, -26.130860f, -66.196383f,
                -26.229432f, -66.292427f, -26.416701f, -66.382141f, -26.364106f, -66.461085f, -26.352551f, -66.537674f, -25.700714f, -66.537674f
            )
            poly[572] = TzPolygon(
                -27.046989f, -64.776507f, -26.966038f, -64.753224f, -26.973659f, -64.710900f, -26.800420f, -64.672192f, -26.809138f, -64.622092f,
                -26.660523f, -64.590135f, -26.676681f, -64.504552f, -26.409361f, -64.534125f, -26.307450f, -64.481687f, -26.239168f, -64.502526f,
                -26.113450f, -64.412142f, -26.031169f, -64.403658f, -25.700714f, -64.268303f, -27.046989f, -64.268303f
            )
            poly[573] = TzPolygon(
                -25.700714f, -64.268303f, -26.031169f, -64.403658f, -26.113450f, -64.412142f, -26.219265f, -64.495279f, -26.224100f, -64.622300f,
                -26.244200f, -64.662100f, -26.223700f, -64.790400f, -26.306800f, -64.951200f, -26.276900f, -64.973700f, -26.287542f, -65.040056f,
                -26.229700f, -65.040200f, -26.170876f, -65.275608f, -26.081700f, -65.297900f, -26.058300f, -65.361100f, -26.091851f, -65.402989f,
                -25.700714f, -65.402989f
            )
            poly[574] = TzPolygon(-25.726228f, -64.150670f, -25.700714f, -64.268303f, -25.700714f, -64.150670f)
            poly[575] = TzPolygon(-25.372480f, -66.537674f, -25.436570f, -66.519277f, -25.539160f, -66.537674f)
            poly[576] = TzPolygon(
                -19.430473f, -74.790449f, -19.430473f, -72.976999f, -19.973439f, -73.753272f, -20.198447f, -73.730717f, -19.656660f, -74.263954f,
                -19.558613f, -74.466513f, -19.432884f, -74.790449f
            )
            poly[577] = TzPolygon(
                -24.077061f, -66.810615f, -24.064601f, -66.830268f, -23.972529f, -66.882126f, -23.967109f, -66.949692f, -23.886303f, -66.996817f,
                -23.734043f, -67.168374f, -23.734043f, -66.810615f
            )
            poly[578] = TzPolygon(
                -23.734043f, -69.470560f, -23.734043f, -67.225926f, -24.034400f, -67.322308f, -24.402228f, -68.259580f, -24.491762f, -68.308504f,
                -24.484188f, -68.387240f, -24.606416f, -68.434809f, -24.623236f, -68.468454f, -24.599304f, -68.493270f, -24.617438f, -68.503098f,
                -24.663959f, -68.491838f, -24.724546f, -68.544280f, -24.797393f, -68.567891f, -24.873808f, -68.519556f, -24.905808f, -68.431730f,
                -25.028830f, -68.406908f, -25.034205f, -68.376830f, -25.110627f, -68.343297f, -25.145304f, -68.409274f, -25.125956f, -68.459405f,
                -25.168567f, -68.507223f, -25.168567f, -69.470560f
            )
            poly[579] = TzPolygon(
                -23.734043f, -66.810615f, -23.734043f, -67.168374f, -23.694512f, -67.212916f, -23.000436f, -66.990519f, -22.813803f, -67.180656f,
                -22.722333f, -67.128376f, -22.655016f, -67.013697f, -22.540892f, -67.028274f, -22.540943f, -66.973014f, -22.492479f, -66.927949f,
                -22.448361f, -66.810615f
            )
            poly[580] = TzPolygon(-23.734043f, -67.225639f, -23.694512f, -67.212916f, -23.734043f, -67.168374f)
            poly[581] = TzPolygon(
                -22.299520f, -67.938783f, -22.381526f, -67.942563f, -22.440794f, -67.884638f, -22.508057f, -67.887483f, -22.536328f, -67.839975f,
                -22.557295f, -67.853085f, -22.580914f, -67.833538f, -22.628357f, -67.883389f, -22.666053f, -67.888670f, -22.680214f, -67.867612f,
                -22.719023f, -67.890315f, -22.743450f, -67.867301f, -22.832767f, -67.883268f, -22.845747f, -67.825129f, -22.880826f, -67.798672f,
                -22.898274f, -67.567386f, -22.813803f, -67.180656f, -23.000436f, -66.990519f, -23.734043f, -67.225926f, -23.734043f, -69.470560f,
                -22.299520f, -69.470560f
            )
            poly[582] = TzPolygon(
                -24.077061f, -66.810615f, -24.092795f, -66.785796f, -24.092230f, -66.740709f, -24.173147f, -66.647443f, -24.213219f, -66.483154f,
                -24.182940f, -66.477624f, -24.161790f, -66.420628f, -24.118392f, -66.417934f, -24.116644f, -66.377731f, -23.984214f, -66.339483f,
                -23.971236f, -66.367570f, -23.734043f, -66.370107f, -23.734043f, -66.002629f, -23.921816f, -66.015472f, -23.981704f, -65.991011f,
                -23.969984f, -65.938585f, -24.007483f, -65.946186f, -24.003366f, -65.867307f, -24.060610f, -65.747039f, -24.186886f, -65.725493f,
                -24.251856f, -65.671120f, -24.306585f, -65.682524f, -24.376821f, -65.656936f, -24.380918f, -65.622646f, -24.448646f, -65.543330f,
                -24.456639f, -65.506560f, -24.427423f, -65.486854f, -24.431500f, -65.480642f, -25.168567f, -65.480642f, -25.168567f, -66.810615f
            )
            poly[583] = TzPolygon(
                -24.431500f, -65.480642f, -24.461721f, -65.434596f, -24.462419f, -65.357790f, -24.497258f, -65.346508f, -24.485594f, -65.227311f,
                -24.467885f, -65.228113f, -24.459077f, -65.193704f, -24.562181f, -65.079231f, -24.599575f, -64.927400f, -24.581862f, -64.887918f,
                -24.520592f, -64.885280f, -24.466996f, -64.842861f, -24.529602f, -64.725892f, -24.607830f, -64.664922f, -24.604255f, -64.573233f,
                -24.507952f, -64.536756f, -24.506592f, -64.500085f, -24.400752f, -64.421167f, -24.427212f, -64.318140f, -24.407536f, -64.285151f,
                -24.221540f, -64.162156f, -23.734043f, -64.158059f, -23.734043f, -64.150670f, -25.168567f, -64.150670f, -25.168567f, -65.480642f
            )
            poly[584] = TzPolygon(
                -23.734043f, -66.370107f, -23.694365f, -66.370531f, -23.660197f, -66.333359f, -23.573691f, -66.316807f, -23.556752f, -66.260991f,
                -23.414402f, -66.177146f, -23.509763f, -65.987288f, -23.734043f, -66.002629f
            )
            poly[585] = TzPolygon(-22.299520f, -66.752239f, -22.437778f, -66.782470f, -22.448361f, -66.810615f, -22.299520f, -66.810615f)
            poly[586] = TzPolygon(
                -23.734043f, -64.158059f, -23.518844f, -64.156251f, -23.518502f, -64.358095f, -23.569915f, -64.396397f, -23.606765f, -64.391345f,
                -23.641135f, -64.444824f, -23.520329f, -64.533374f, -23.484739f, -64.654206f, -23.452306f, -64.682720f, -23.495359f, -64.788775f,
                -23.483960f, -64.863831f, -23.446114f, -64.868534f, -23.423052f, -64.906843f, -23.334341f, -64.899479f, -23.269653f, -64.946806f,
                -23.278869f, -65.021934f, -23.227181f, -65.038384f, -23.232009f, -65.077141f, -23.162159f, -65.045770f, -23.138159f, -65.070652f,
                -23.041337f, -65.068223f, -23.016782f, -65.102674f, -23.016782f, -64.150670f, -23.734043f, -64.150670f
            )
            poly[587] = TzPolygon(
                -22.299520f, -65.233489f, -22.319964f, -65.226495f, -22.338963f, -65.263209f, -22.540006f, -65.350277f, -22.602184f, -65.350649f,
                -22.649567f, -65.271318f, -22.723370f, -65.304734f, -22.789876f, -65.274307f, -22.895065f, -65.273441f, -23.016782f, -65.102674f,
                -23.016782f, -65.480642f, -22.299520f, -65.480642f
            )
            poly[588] = TzPolygon(
                -22.444452f, -64.150670f, -22.453911f, -64.152920f, -22.560393f, -64.243321f, -22.848522f, -64.283604f, -22.883319f, -64.337563f,
                -22.749618f, -64.339603f, -22.723634f, -64.362432f, -22.719351f, -64.404070f, -22.689530f, -64.393685f, -22.638778f, -64.441803f,
                -22.634205f, -64.423330f, -22.580247f, -64.432201f, -22.541250f, -64.411857f, -22.480188f, -64.483290f, -22.436528f, -64.491473f,
                -22.446284f, -64.521276f, -22.412671f, -64.513125f, -22.379515f, -64.563966f, -22.323793f, -64.564044f, -22.299520f, -64.542897f,
                -22.299520f, -64.150670f
            )
            poly[589] = TzPolygon(
                -19.430473f, -68.417472f, -19.605476f, -68.572539f, -19.701042f, -68.622898f, -19.738608f, -68.695972f, -19.784349f, -68.625138f,
                -19.828161f, -68.599252f, -19.845412f, -68.528356f, -19.889553f, -68.542671f, -19.924297f, -68.521515f, -20.050071f, -68.566444f,
                -20.078454f, -68.762269f, -20.129665f, -68.773703f, -20.134778f, -68.704422f, -20.178006f, -68.690748f, -20.193747f, -68.712570f,
                -20.246582f, -68.711883f, -20.319119f, -68.660608f, -20.357690f, -68.676166f, -20.368370f, -68.741533f, -20.456822f, -68.738743f,
                -20.572261f, -68.580885f, -20.569618f, -68.534772f, -20.604798f, -68.515007f, -20.635425f, -68.441541f, -20.728351f, -68.553277f,
                -20.907739f, -68.541641f, -20.945975f, -68.493032f, -20.934386f, -68.412277f, -21.302424f, -68.179023f, -21.604440f, -68.180480f,
                -21.779405f, -68.059776f, -21.978756f, -68.071379f, -22.053709f, -67.964668f, -22.107803f, -67.939179f, -22.176829f, -67.955562f,
                -22.272537f, -67.915549f, -22.273550f, -67.937586f, -22.299520f, -67.938783f, -22.299520f, -69.470560f, -19.430473f, -69.470560f
            )
            poly[590] = TzPolygon(
                -22.299520f, -66.752239f, -22.238931f, -66.738991f, -22.209470f, -66.685838f, -22.226261f, -66.638020f, -22.197673f, -66.623098f,
                -22.128252f, -66.347745f, -22.088384f, -66.325189f, -22.087361f, -66.288770f, -21.944643f, -66.274767f, -21.852784f, -66.235983f,
                -21.793512f, -66.242730f, -21.781168f, -66.219601f, -21.834929f, -66.075885f, -21.871931f, -66.043355f, -21.918857f, -66.047693f,
                -21.933078f, -65.924809f, -22.075601f, -65.804134f, -22.109120f, -65.747639f, -22.098643f, -65.589204f, -22.076192f, -65.574395f,
                -22.095662f, -65.483397f, -22.084788f, -65.187155f, -22.279416f, -65.240366f, -22.299520f, -65.233489f
            )
            poly[591] = TzPolygon(
                -22.299520f, -65.233489f, -22.279416f, -65.240366f, -22.149602f, -65.214669f, -22.146733f, -65.193007f, -22.084788f, -65.187155f,
                -22.082389f, -64.993217f, -22.121060f, -64.923784f, -22.121810f, -64.861674f, -22.193896f, -64.736477f, -22.205437f, -64.616719f,
                -22.291366f, -64.535793f, -22.299520f, -64.542897f
            )
            poly[592] = TzPolygon(-17.372583f, -69.470560f, -17.291425f, -69.576246f, -17.281588f, -69.645007f, -17.159275f, -69.556902f, -17.118663f, -69.470560f)
            poly[593] = TzPolygon(
                -19.430473f, -70.457793f, -19.338000f, -70.494553f, -19.170000f, -70.490174f, -18.805000f, -70.571088f, -18.475301f, -70.544414f,
                -18.350117f, -70.590836f, -18.350117f, -70.376316f, -18.308981f, -70.301978f, -18.319383f, -70.149435f, -18.269245f, -70.050462f,
                -18.262180f, -69.965901f, -18.116881f, -69.816359f, -17.989266f, -69.754684f, -17.947296f, -69.750212f, -17.865486f, -69.799199f,
                -17.762180f, -69.800853f, -17.743975f, -69.822199f, -17.646393f, -69.796210f, -17.660275f, -69.666536f, -17.500098f, -69.470560f,
                -19.430473f, -69.470560f
            )
            poly[594] = TzPolygon(
                -16.561425f, -69.470560f, -16.561425f, -69.036328f, -16.572260f, -69.040135f, -16.656576f, -68.996102f, -16.727535f, -69.170014f,
                -16.797555f, -69.186187f, -16.915841f, -69.304675f, -16.980265f, -69.335429f, -17.020568f, -69.393578f, -17.073123f, -69.373739f,
                -17.118663f, -69.470560f
            )
            poly[595] = TzPolygon(-17.372583f, -69.470560f, -17.374129f, -69.468546f, -17.498400f, -69.468482f, -17.500098f, -69.470560f)
            poly[596] = TzPolygon(
                -17.500098f, -69.470560f, -17.498400f, -69.468482f, -17.604902f, -69.467882f, -17.729089f, -69.338005f, -17.967576f, -69.283499f,
                -17.954071f, -69.255892f, -17.988994f, -69.231087f, -18.005083f, -69.121173f, -18.061221f, -69.056633f, -18.163056f, -69.145836f,
                -18.233729f, -69.063270f, -18.292339f, -69.075078f, -18.323380f, -69.037871f, -18.426443f, -69.047454f, -18.483649f, -69.001469f,
                -18.600809f, -69.006764f, -18.600259f, -69.025493f, -18.629068f, -69.032739f, -18.667313f, -68.991002f, -18.890331f, -68.911704f,
                -18.936518f, -68.950333f, -19.060144f, -68.870850f, -19.083672f, -68.805928f, -19.276484f, -68.619797f, -19.296801f, -68.542572f,
                -19.416186f, -68.404813f, -19.430473f, -68.417472f, -19.430473f, -69.470560f
            )
            poly[597] = TzPolygon(
                -15.126902f, -69.470560f, -15.126902f, -69.226735f, -15.158776f, -69.190451f, -15.259031f, -69.119623f, -15.261360f, -69.176296f,
                -15.315039f, -69.194793f, -15.374036f, -69.260329f, -15.460393f, -69.240827f, -15.436880f, -69.290072f, -15.518037f, -69.314461f,
                -15.606007f, -69.401826f, -16.168108f, -69.196402f, -16.225659f, -69.098314f, -16.197362f, -69.055259f, -16.219953f, -69.011519f,
                -16.194424f, -68.961323f, -16.331411f, -68.795489f, -16.349205f, -68.800674f, -16.425356f, -68.988514f, -16.561425f, -69.036328f,
                -16.561425f, -69.470560f
            )
            poly[598] = TzPolygon(
                -13.692378f, -69.055115f, -13.739293f, -69.025947f, -13.760588f, -68.974455f, -13.787004f, -68.994823f, -13.814172f, -68.917236f,
                -13.878670f, -68.950965f, -13.894712f, -68.982528f, -13.948670f, -68.963301f, -13.976530f, -68.978893f, -14.046605f, -68.890320f,
                -14.111057f, -68.871129f, -14.144873f, -68.833289f, -14.162668f, -68.856180f, -14.215607f, -68.826756f, -14.220055f, -68.962406f,
                -14.237115f, -68.985006f, -14.265625f, -68.979249f, -14.314709f, -69.015243f, -14.374663f, -68.985407f, -14.521618f, -69.154032f,
                -14.580314f, -69.150030f, -14.581788f, -69.221352f, -14.654161f, -69.227901f, -14.683977f, -69.258373f, -14.739025f, -69.224871f,
                -14.759474f, -69.239940f, -14.765299f, -69.301204f, -14.801666f, -69.353797f, -14.961061f, -69.360574f, -15.109902f, -69.277285f,
                -15.112206f, -69.243463f, -15.126902f, -69.226735f, -15.126902f, -69.470560f, -13.692378f, -69.470560f
            )
            poly[599] = TzPolygon(
                -27.275954f, -58.171500f, -27.258423f, -58.265314f, -27.299843f, -58.599045f, -27.224191f, -58.594278f, -27.183188f, -58.662932f,
                -27.120433f, -58.641416f, -27.109543f, -58.555318f, -27.037184f, -58.558339f, -27.053219f, -58.500788f, -27.003907f, -58.519555f,
                -26.992541f, -58.468062f, -26.924073f, -58.502427f, -26.930316f, -58.463422f, -26.893179f, -58.386097f, -26.865161f, -58.372597f,
                -26.865100f, -58.322831f, -26.809223f, -58.333850f, -26.796475f, -58.284550f, -26.755903f, -58.290727f, -26.750848f, -58.246533f,
                -26.646407f, -58.261373f, -26.650242f, -58.192021f, -26.620781f, -58.209703f, -26.563218f, -58.198888f, -26.537573f, -58.223435f,
                -26.499634f, -58.206784f, -26.472285f, -58.233907f, -26.456538f, -58.180865f, -26.402963f, -58.222406f, -26.358070f, -58.171500f
            )
        }
    }

    private object Initializer7 {
        fun init() {
            poly[600] = TzPolygon(
                -22.822858f, -64.150670f, -22.822858f, -62.339850f, -24.392029f, -62.342550f, -25.709830f, -63.476092f, -25.673305f, -64.007785f,
                -25.753393f, -64.025421f, -25.726228f, -64.150670f
            )
            poly[601] = TzPolygon(
                -23.283992f, -61.609799f, -23.285982f, -61.670247f, -23.259524f, -61.682731f, -23.241704f, -61.731940f, -23.158105f, -61.765560f,
                -23.156684f, -61.804137f, -23.090000f, -61.855278f, -23.070921f, -61.927299f, -23.025124f, -61.955613f, -23.024627f, -61.979655f,
                -22.995122f, -62.006408f, -22.930366f, -61.998486f, -22.922438f, -62.031331f, -22.888649f, -62.019873f, -22.837876f, -62.058679f,
                -22.850539f, -62.071361f, -22.822858f, -62.080078f, -22.822858f, -61.609799f
            )
            poly[602] = TzPolygon(
                -24.634697f, -59.068928f, -24.617010f, -59.130078f, -24.519732f, -59.257440f, -24.483067f, -59.350429f, -24.422807f, -59.373140f,
                -24.408775f, -59.421626f, -24.335533f, -59.471118f, -24.011556f, -60.039414f, -24.044308f, -60.183953f, -24.037979f, -60.308834f,
                -24.024001f, -60.373532f, -23.994124f, -60.388548f, -23.950938f, -60.477805f, -23.967793f, -60.513667f, -23.958512f, -60.589396f,
                -23.916188f, -60.588872f, -23.901629f, -60.613986f, -23.902871f, -60.692979f, -23.872222f, -60.732222f, -23.873889f, -60.849167f,
                -23.823056f, -60.921389f, -23.818080f, -60.989898f, -23.655600f, -61.099693f, -23.613928f, -61.088235f, -23.554722f, -61.182500f,
                -23.555278f, -61.224722f, -23.487455f, -61.282880f, -23.498656f, -61.294727f, -23.447948f, -61.351702f, -23.460453f, -61.387071f,
                -23.420126f, -61.445123f, -23.423756f, -61.486890f, -23.380556f, -61.520278f, -23.349881f, -61.509387f, -23.340833f, -61.560278f,
                -23.283635f, -61.598948f, -23.283992f, -61.609799f, -22.822858f, -61.609799f, -22.822858f, -59.068928f
            )
            poly[603] = TzPolygon(
                -21.055253f, -62.880235f, -21.999945f, -62.880235f, -21.999362f, -63.665262f, -22.054048f, -63.681019f, -22.000000f, -63.709034f,
                -22.000000f, -63.931395f, -22.085959f, -63.957993f, -22.080671f, -63.978457f, -22.107794f, -64.000351f, -22.242970f, -64.033402f,
                -22.238189f, -64.062247f, -22.257858f, -64.073288f, -22.404860f, -64.117498f, -22.406972f, -64.141755f, -22.444452f, -64.150670f,
                -21.055253f, -64.150670f
            )
            poly[604] = TzPolygon(
                -22.822858f, -62.342080f, -22.477492f, -62.341976f, -22.471414f, -62.327056f, -22.487823f, -62.309576f, -22.473193f, -62.289784f,
                -22.519123f, -62.296320f, -22.539006f, -62.245017f, -22.578156f, -62.245017f, -22.604080f, -62.260934f, -22.610522f, -62.245017f,
                -22.822858f, -62.245017f
            )
            poly[605] = TzPolygon(-22.610522f, -62.245017f, -22.604080f, -62.260934f, -22.578156f, -62.245017f)
            poly[606] = TzPolygon(
                -22.539006f, -62.245017f, -22.519123f, -62.296320f, -22.472757f, -62.290565f, -22.486861f, -62.316745f, -22.457852f, -62.361714f,
                -22.482385f, -62.377845f, -22.421146f, -62.421270f, -22.418333f, -62.453522f, -22.375473f, -62.471972f, -22.374468f, -62.542928f,
                -22.315121f, -62.567664f, -22.305578f, -62.628385f, -22.259003f, -62.621333f, -22.249285f, -62.644204f, -21.939056f, -62.544338f,
                -21.939056f, -62.245017f
            )
            poly[607] = TzPolygon(
                -21.939056f, -62.880235f, -21.939056f, -62.549774f, -22.255576f, -62.653620f, -22.190992f, -62.690657f, -22.211473f, -62.717276f,
                -22.154671f, -62.757694f, -22.175177f, -62.778095f, -22.156169f, -62.795285f, -22.111813f, -62.813562f, -22.000000f, -62.806171f,
                -21.999945f, -62.880235f
            )
            poly[608] = TzPolygon(-22.539006f, -62.245017f, -22.546531f, -62.225599f, -22.578156f, -62.245017f)
            poly[609] = TzPolygon(
                -22.610522f, -62.245017f, -22.614610f, -62.234916f, -22.647081f, -62.237122f, -22.661385f, -62.197413f, -22.704176f, -62.206711f,
                -22.711304f, -62.172490f, -22.761224f, -62.157012f, -22.759870f, -62.130424f, -22.791447f, -62.134790f, -22.822858f, -62.104343f,
                -22.822858f, -62.245017f
            )
            poly[610] = TzPolygon(-22.822858f, -62.102779f, -22.811879f, -62.083536f, -22.822858f, -62.080078f)
            poly[611] = TzPolygon(-21.055253f, -62.260956f, -21.058628f, -62.260919f, -21.939056f, -62.549774f, -21.939056f, -62.880235f, -21.055253f, -62.880235f)
            poly[612] = TzPolygon(
                -21.055253f, -62.260956f, -20.563156f, -62.266342f, -20.089211f, -61.922536f, -19.634406f, -61.735211f, -19.614692f, -61.609799f,
                -21.055253f, -61.609799f
            )
            poly[613] = TzPolygon(-19.287647f, -59.068928f, -19.294686f, -59.977778f, -19.456639f, -60.604325f, -19.614692f, -61.609799f, -19.287647f, -61.609799f)
            poly[614] = TzPolygon(
                -24.634697f, -59.068928f, -24.634697f, -58.171500f, -24.971517f, -58.171500f, -24.967885f, -58.193873f, -24.926937f, -58.225028f,
                -24.998939f, -58.336562f, -24.859956f, -58.475772f, -24.821145f, -58.573077f, -24.831925f, -58.672428f, -24.774619f, -58.726066f,
                -24.772553f, -58.807349f, -24.663181f, -58.970453f
            )
            poly[615] = TzPolygon(-20.015895f, -58.171500f, -19.969757f, -58.186395f, -19.953383f, -58.214042f, -19.862692f, -58.202032f, -19.834362f, -58.171500f)
            poly[616] = TzPolygon(-19.822709f, -58.171500f, -19.287647f, -59.068928f, -19.287647f, -58.171500f)
            poly[617] = TzPolygon(
                -16.490012f, -58.333013f, -16.490012f, -58.171500f, -17.388221f, -58.171500f, -17.391000f, -58.185000f, -17.357000f, -58.202000f,
                -17.352000f, -58.254000f, -17.300000f, -58.276000f, -17.298000f, -58.298000f, -17.270000f, -58.303000f, -17.181000f, -58.396000f,
                -17.111000f, -58.386000f, -17.112000f, -58.425000f, -17.086000f, -58.434000f, -16.989000f, -58.423000f, -16.935000f, -58.474000f,
                -16.703000f, -58.470000f, -16.592000f, -58.436000f
            )
            poly[618] = TzPolygon(
                -16.490012f, -58.333013f, -16.428000f, -58.356000f, -16.389000f, -58.344000f, -16.371723f, -58.307860f, -16.265589f, -58.322265f,
                -16.261849f, -58.389374f, -16.296911f, -58.394969f, -16.322642f, -58.430595f, -16.266729f, -60.173820f, -15.474916f, -60.239205f,
                -15.097731f, -60.575185f, -15.097430f, -60.245003f, -14.620958f, -60.273591f, -14.610391f, -60.322870f, -14.510836f, -60.339543f,
                -14.413522f, -60.407937f, -14.364526f, -60.395794f, -14.314043f, -60.453983f, -14.265170f, -60.467183f, -14.239832f, -60.450148f,
                -14.191783f, -60.472829f, -14.189024f, -60.493331f, -14.095456f, -60.480378f, -14.078328f, -60.440767f, -13.987325f, -60.381705f,
                -13.968806f, -60.423993f, -13.937610f, -60.418394f, -13.936950f, -60.450972f, -13.883367f, -60.450938f, -13.885982f, -60.476060f,
                -13.854459f, -60.456275f, -13.855991f, -60.492913f, -13.794120f, -60.468127f, -13.793774f, -60.526921f, -13.771066f, -60.519104f,
                -13.782221f, -60.549243f, -13.717455f, -60.619710f, -13.736553f, -60.656088f, -13.692378f, -60.703664f, -13.692378f, -58.171500f,
                -16.490012f, -58.171500f
            )
            poly[619] = TzPolygon(
                -1.366227f, -61.909707f, -1.366227f, -61.594025f, -1.402377f, -61.615412f, -1.433000f, -61.538000f, -1.504762f, -61.507665f,
                -1.527000f, -61.473000f, -1.593865f, -61.473624f, -1.448000f, -61.604000f, -1.379000f, -61.790000f, -1.403115f, -61.831168f,
                -1.395000f, -61.896000f
            )
            poly[620] = TzPolygon(
                -1.366227f, -61.909707f, -1.141000f, -62.017000f, -1.099000f, -62.062000f, -1.093264f, -62.103405f, -1.048956f, -62.122674f,
                -0.983000f, -62.203000f, -0.976000f, -62.259000f, -0.948000f, -62.293000f, -0.861650f, -62.380483f, -0.836000f, -62.376000f,
                -0.813599f, -62.399561f, -0.778678f, -62.504653f, -0.710415f, -62.509547f, -0.677902f, -62.488306f, -0.689511f, -62.426989f,
                -0.722672f, -62.403551f, -0.703115f, -62.357128f, -0.667218f, -62.369081f, -0.647664f, -62.292633f, -0.599381f, -62.289916f,
                -0.545005f, -62.318344f, -0.531214f, -62.300139f, -0.511357f, -62.308548f, -0.393000f, -62.202000f, -0.369216f, -62.196715f,
                -0.369216f, -61.358472f, -0.606717f, -61.358472f, -0.634050f, -61.433980f, -0.652760f, -61.430204f, -0.660141f, -61.465738f,
                -0.719189f, -61.486852f, -0.761929f, -61.538865f, -0.848781f, -61.538350f, -0.936661f, -61.582296f, -0.985062f, -61.577661f,
                -0.992958f, -61.542127f, -1.012696f, -61.560151f, -1.068648f, -61.544530f, -1.084438f, -61.579034f, -1.182609f, -61.570794f,
                -1.298723f, -61.629695f, -1.346681f, -61.582462f, -1.366227f, -61.594025f
            )
            poly[621] = TzPolygon(
                0.627796f, -62.524958f, 0.584000f, -62.518000f, 0.509000f, -62.532000f, 0.444000f, -62.518000f, 0.454000f, -62.485000f,
                0.379000f, -62.446000f, 0.276000f, -62.468000f, 0.174000f, -62.428000f, 0.092000f, -62.424000f, 0.031466f, -62.342454f,
                -0.102000f, -62.319000f, -0.181000f, -62.241000f, -0.302000f, -62.248000f, -0.330000f, -62.188000f, -0.369216f, -62.196715f,
                -0.369216f, -62.673840f, 0.627796f, -62.673840f
            )
            poly[622] = TzPolygon(
                -7.348293f, -58.134040f, -7.315468f, -58.171994f, -7.213957f, -58.173580f, -7.130226f, -58.210419f, -7.075617f, -58.279850f,
                -6.976311f, -58.350852f, -6.934052f, -58.415396f, -6.765320f, -58.480628f, -6.699516f, -58.474791f, -6.606761f, -58.424666f,
                -6.466749f, -58.260191f, -3.360249f, -56.820941f, -3.360249f, -56.097000f, -7.348293f, -56.097000f
            )
            poly[623] = TzPolygon(
                -0.369216f, -61.358472f, -0.369216f, -60.332285f, -0.405687f, -60.351627f, -0.437621f, -60.346076f, -0.459581f, -60.382616f,
                -0.514811f, -60.405361f, -0.569483f, -60.376522f, -0.576563f, -60.389225f, -0.632871f, -60.314599f, -0.717102f, -60.309574f,
                -0.743536f, -60.363690f, -0.731435f, -60.374161f, -0.771600f, -60.425960f, -0.761387f, -60.474326f, -0.825711f, -60.518743f,
                -0.840773f, -60.502264f, -0.869523f, -60.535780f, -0.842746f, -60.586463f, -0.866176f, -60.596248f, -0.851157f, -60.619165f,
                -0.887760f, -60.668947f, -0.865489f, -60.683795f, -0.866691f, -60.734994f, -0.853131f, -60.727698f, -0.863644f, -60.760700f,
                -0.792455f, -60.756065f, -0.782027f, -60.787694f, -0.754564f, -60.771944f, -0.740189f, -60.806448f, -0.694187f, -60.807649f,
                -0.685347f, -60.856573f, -0.644838f, -60.861637f, -0.618060f, -60.920173f, -0.547683f, -60.933820f, -0.561758f, -60.982486f,
                -0.545966f, -61.048404f, -0.499000f, -61.096000f, -0.498847f, -61.160327f, -0.516272f, -61.167645f, -0.499560f, -61.220948f,
                -0.560817f, -61.231674f, -0.606717f, -61.358472f
            )
            poly[624] = TzPolygon(
                -0.369216f, -60.332285f, -0.294744f, -60.292790f, -0.210339f, -60.303390f, -0.209996f, -60.280559f, -0.141452f, -60.220349f,
                -0.113471f, -60.239746f, -0.039537f, -60.212924f, 0.027637f, -60.132491f, 0.082084f, -60.116841f, 0.104379f, -60.133974f,
                0.163000f, -60.059000f, 0.235977f, -60.043104f, -0.369216f, -60.043104f
            )
            poly[625] = TzPolygon(0.627796f, -60.043104f, 0.627796f, -58.895329f, 0.263472f, -58.895360f, 0.264000f, -60.037000f, 0.235977f, -60.043104f)
            poly[626] = TzPolygon(-0.638058f, -58.727736f, -0.617468f, -58.737889f, -0.592110f, -58.727736f)
            poly[627] = TzPolygon(-0.495544f, -58.727736f, -0.470858f, -58.737045f, -0.445679f, -58.727736f)
            poly[628] = TzPolygon(
                -0.436739f, -58.727736f, -0.343000f, -58.872000f, -0.196000f, -58.881000f, -0.078000f, -58.863000f, -0.017000f, -58.897000f,
                0.627796f, -58.896108f, 0.627796f, -58.727736f
            )
            poly[629] = TzPolygon(
                -1.679157f, -57.412368f, -1.691837f, -57.435135f, -1.665392f, -57.440393f, -1.679408f, -57.472273f, -1.642286f, -57.505138f,
                -1.656029f, -57.526062f, -1.629638f, -57.521296f, -1.600947f, -57.594531f, -1.572201f, -57.602199f, -1.595253f, -57.677789f,
                -1.576637f, -57.703917f, -1.503593f, -57.712024f, -1.510224f, -57.779572f, -1.485753f, -57.772569f, -1.486656f, -57.795603f,
                -1.438536f, -57.822891f, -1.403253f, -57.958180f, -1.381710f, -57.953525f, -1.366227f, -57.967688f, -1.366227f, -57.412368f
            )
            poly[630] = TzPolygon(
                -1.679157f, -57.412368f, -1.675028f, -57.404954f, -1.724940f, -57.391535f, -1.715060f, -57.370695f, -1.737619f, -57.352739f,
                -1.716048f, -57.328769f, -1.733502f, -57.304717f, -1.708720f, -57.289726f, -1.722964f, -57.263862f, -1.697523f, -57.256613f,
                -1.727327f, -57.232644f, -1.711684f, -57.203485f, -1.736055f, -57.200519f, -1.719588f, -57.165759f, -1.769399f, -57.163700f,
                -1.765200f, -57.129599f, -1.793274f, -57.113949f, -1.779443f, -57.086520f, -1.811817f, -57.060469f, -1.855827f, -57.067342f,
                -1.917416f, -57.029716f, -1.919155f, -56.975094f, -2.025184f, -56.843962f, -2.016952f, -56.748248f, -2.070808f, -56.727491f,
                -2.162767f, -56.764019f, -2.212436f, -56.684748f, -2.210293f, -56.609332f, -2.174588f, -56.599288f, -2.177560f, -56.573280f,
                -2.139280f, -56.526455f, -2.170338f, -56.480104f, -2.153685f, -56.448229f, -2.180459f, -56.396334f, -2.143235f, -56.381742f,
                -2.145636f, -56.323721f, -2.102865f, -56.300666f, -2.056947f, -56.227762f, -2.026784f, -56.121429f, -2.037000f, -56.097000f,
                -2.195000f, -56.220000f, -2.270000f, -56.384000f, -2.423000f, -56.465000f, -2.456000f, -56.402000f, -3.360249f, -56.820941f,
                -3.360249f, -57.412368f
            )
            poly[631] = TzPolygon(-0.436739f, -58.727736f, -0.438471f, -58.725071f, -0.445679f, -58.727736f)
            poly[632] = TzPolygon(-0.495544f, -58.727736f, -0.545273f, -58.708983f, -0.592110f, -58.727736f)
            poly[633] = TzPolygon(
                -0.638058f, -58.727736f, -0.678864f, -58.707615f, -0.719265f, -58.634010f, -0.830798f, -58.533013f, -0.832605f, -58.490268f,
                -0.860142f, -58.489151f, -0.875027f, -58.439229f, -0.924412f, -58.451297f, -0.981398f, -58.410379f, -1.028423f, -58.427164f,
                -1.070662f, -58.364022f, -1.145423f, -58.321541f, -1.131290f, -58.255488f, -1.232774f, -58.154804f, -1.187805f, -58.117596f,
                -1.163623f, -58.123192f, -1.161687f, -58.092947f, -1.105890f, -58.057572f, -1.103964f, -58.017407f, -1.139550f, -58.009262f,
                -1.168897f, -57.966032f, -1.222422f, -57.958287f, -1.332166f, -57.998844f, -1.366227f, -57.967688f, -1.366227f, -58.727736f
            )
            poly[634] = TzPolygon(
                1.022021f, -66.619944f, 0.744944f, -66.310320f, 0.781614f, -66.197375f, 0.747627f, -66.145467f, 0.761742f, -66.077833f,
                0.812300f, -66.070240f, 0.815110f, -65.967121f, 0.890962f, -65.940926f, 0.906682f, -65.889908f, 0.941589f, -65.883691f,
                0.958591f, -65.772612f, 1.001253f, -65.742103f, 1.003858f, -65.696614f, 0.986337f, -65.685226f, 1.012854f, -65.658303f,
                0.988290f, -65.628455f, 1.014253f, -65.626907f, 1.004706f, -65.588935f, 0.980814f, -65.585695f, 0.991692f, -65.557660f,
                0.970345f, -65.564435f, 0.968894f, -65.543116f, 0.874150f, -65.496240f, 0.835078f, -65.504478f, 0.714009f, -65.604905f,
                0.647529f, -65.545664f, 0.668961f, -65.529746f, 0.689212f, -65.444985f, 0.753059f, -65.417190f, 0.756917f, -65.392132f,
                0.824145f, -65.411977f, 0.864883f, -65.355922f, 0.935960f, -65.327341f, 0.931863f, -65.304576f, 0.627796f, -65.304576f,
                0.627796f, -66.619944f
            )
            poly[635] = TzPolygon(
                0.931863f, -65.304576f, 0.912741f, -65.198311f, 1.003139f, -65.149040f, 1.015569f, -65.175308f, 1.050778f, -65.156590f,
                1.121978f, -65.160728f, 1.155616f, -65.106491f, 1.152782f, -65.071857f, 1.111193f, -65.061985f, 1.109051f, -65.013614f,
                1.164238f, -64.975114f, 1.202878f, -64.974445f, 1.218630f, -64.922581f, 1.251532f, -64.904386f, 1.227132f, -64.869656f,
                1.272313f, -64.856395f, 1.315271f, -64.800533f, 1.263669f, -64.786377f, 1.225695f, -64.744461f, 1.284620f, -64.694983f,
                1.340406f, -64.578896f, 1.377408f, -64.578593f, 1.443222f, -64.526079f, 1.470064f, -64.435855f, 1.529006f, -64.393901f,
                1.529209f, -64.351112f, 1.495083f, -64.347774f, 1.403010f, -64.410191f, 1.388532f, -64.356572f, 1.361619f, -64.337527f,
                1.456166f, -64.313597f, 1.502218f, -64.260607f, 1.520713f, -64.197073f, 1.573374f, -64.172984f, 1.578509f, -64.125929f,
                1.624807f, -64.091502f, 1.624807f, -63.989208f, 0.627796f, -63.989208f, 0.627796f, -65.304576f
            )
            poly[636] = TzPolygon(
                2.621818f, -64.005575f, 2.621818f, -63.989208f, 2.474252f, -63.989208f, 2.478498f, -64.001457f, 2.461232f, -64.017998f,
                2.496452f, -64.056427f, 2.572773f, -64.044083f
            )
            poly[637] = TzPolygon(
                1.624807f, -64.091502f, 1.649020f, -64.073497f, 1.703084f, -64.061182f, 1.756558f, -64.079629f, 1.822586f, -64.049933f,
                1.852356f, -64.069413f, 1.924849f, -64.061159f, 1.982990f, -63.991577f, 1.983235f, -63.989208f, 1.624807f, -63.989208f
            )
            poly[638] = TzPolygon(2.621818f, -64.005575f, 2.642662f, -63.989208f, 2.621818f, -63.989208f)
            poly[639] = TzPolygon(2.661162f, -63.989208f, 2.707019f, -64.001671f, 2.716763f, -63.989208f)
            poly[640] = TzPolygon(
                2.729521f, -63.989208f, 2.737009f, -64.000634f, 2.810795f, -64.014519f, 2.872615f, -64.077088f, 2.921416f, -64.071556f,
                2.990477f, -64.123489f, 2.982431f, -64.157540f, 3.034593f, -64.145917f, 3.123560f, -64.226417f, 3.201207f, -64.197945f,
                3.430363f, -64.244400f, 3.506585f, -64.178619f, 3.568408f, -64.174370f, 3.670885f, -64.269570f, 3.709279f, -64.280998f,
                3.783569f, -64.416146f, 3.788714f, -64.470924f, 3.857134f, -64.543565f, 3.918042f, -64.572939f, 3.980677f, -64.648101f,
                4.117745f, -64.722389f, 4.174225f, -64.802033f, 4.235124f, -64.819365f, 4.270475f, -64.811229f, 4.287000f, -64.780000f,
                4.253229f, -64.695220f, 4.135000f, -64.623000f, 4.105295f, -64.556502f, 4.144000f, -64.289000f, 4.116000f, -64.218000f,
                4.127000f, -64.164000f, 4.092000f, -64.112000f, 3.950000f, -64.050000f, 3.933000f, -64.001000f, 3.912284f, -63.989208f
            )
            poly[641] = TzPolygon(
                1.460506f, -62.673840f, 1.489000f, -62.720000f, 1.530000f, -62.736000f, 1.592000f, -62.805000f, 1.624807f, -62.797429f,
                1.624807f, -62.673840f
            )
            poly[642] = TzPolygon(
                2.181656f, -63.331524f, 2.197000f, -63.359000f, 2.226424f, -63.387432f, 2.269454f, -63.367336f, 2.350475f, -63.384354f,
                2.376965f, -63.363266f, 2.410748f, -63.370765f, 2.451019f, -63.421234f, 2.396839f, -63.460358f, 2.430556f, -63.494709f,
                2.418073f, -63.557991f, 2.445727f, -63.563976f, 2.439943f, -63.768047f, 2.477101f, -63.797341f, 2.491598f, -63.843575f,
                2.454598f, -63.932503f, 2.474252f, -63.989208f, 2.621818f, -63.989208f, 2.621818f, -63.331524f
            )
            poly[643] = TzPolygon(
                1.983235f, -63.989208f, 1.993044f, -63.894188f, 1.966443f, -63.835555f, 1.995643f, -63.821943f, 1.979750f, -63.790947f,
                2.000405f, -63.741867f, 2.049404f, -63.699535f, 2.018614f, -63.665009f, 2.065108f, -63.663867f, 2.073436f, -63.635837f,
                2.112221f, -63.626795f, 2.140846f, -63.546560f, 2.111508f, -63.511129f, 2.141322f, -63.473962f, 2.125998f, -63.440594f,
                2.150706f, -63.400852f, 2.197183f, -63.404118f, 2.212712f, -63.378949f, 2.183992f, -63.331524f, 1.624807f, -63.331524f,
                1.624807f, -63.989208f
            )
            poly[644] = TzPolygon(
                2.183992f, -63.331524f, 2.154000f, -63.282000f, 2.182000f, -63.194000f, 2.173000f, -63.141000f, 2.080000f, -63.107000f,
                2.015000f, -63.023000f, 2.031000f, -62.948000f, 2.017000f, -62.838000f, 1.954000f, -62.719000f, 1.912000f, -62.698000f,
                1.819000f, -62.731000f, 1.713000f, -62.723000f, 1.631000f, -62.796000f, 1.624807f, -62.797429f, 1.624807f, -63.331524f
            )
            poly[645] = TzPolygon(
                1.460506f, -62.673840f, 1.439000f, -62.639000f, 1.089000f, -62.529000f, 1.087000f, -62.471000f, 1.028000f, -62.477000f,
                0.959000f, -62.442000f, 0.867000f, -62.486000f, 0.786000f, -62.457000f, 0.691000f, -62.535000f, 0.627796f, -62.524958f,
                0.627796f, -62.673840f
            )
            poly[646] = TzPolygon(3.618829f, -62.997578f, 3.618829f, -62.953170f, 3.608000f, -62.960000f, 3.612000f, -62.990000f)
            poly[647] = TzPolygon(2.729521f, -63.989208f, 2.723703f, -63.980331f, 2.716763f, -63.989208f)
            poly[648] = TzPolygon(2.661162f, -63.989208f, 2.647419f, -63.985473f, 2.642662f, -63.989208f)
            poly[649] = TzPolygon(
                3.618829f, -62.997578f, 3.694000f, -63.081000f, 3.748000f, -63.059000f, 3.794000f, -63.103000f, 3.812000f, -63.204000f,
                3.836000f, -63.226000f, 3.882000f, -63.233000f, 3.952000f, -63.204000f, 3.956000f, -63.280000f, 3.982000f, -63.311000f,
                3.961000f, -63.312000f, 3.957000f, -63.338000f, 3.977000f, -63.428000f, 3.956000f, -63.452000f, 3.912000f, -63.411000f,
                3.865000f, -63.434000f, 3.874000f, -63.489000f, 3.840000f, -63.497000f, 3.865000f, -63.551000f, 3.891000f, -63.554000f,
                3.886000f, -63.591000f, 3.929000f, -63.592000f, 4.019000f, -63.676000f, 3.950000f, -63.700000f, 3.922000f, -63.663000f,
                3.908000f, -63.682000f, 3.915000f, -63.738000f, 3.941000f, -63.755000f, 3.950000f, -63.850000f, 3.925000f, -63.928000f,
                3.868000f, -63.964000f, 3.912284f, -63.989208f, 4.615840f, -63.989208f, 4.615840f, -62.673840f, 4.043097f, -62.673840f,
                4.032000f, -62.753000f, 4.007000f, -62.768000f, 3.975000f, -62.743000f, 3.930000f, -62.786000f, 3.894000f, -62.788000f,
                3.850000f, -62.753000f, 3.834000f, -62.771000f, 3.805000f, -62.729000f, 3.674000f, -62.743000f, 3.739000f, -62.835000f,
                3.673000f, -62.919000f, 3.618829f, -62.953170f
            )
            poly[650] = TzPolygon(
                4.424350f, -61.358472f, 4.439000f, -61.448000f, 4.406000f, -61.513000f, 4.342000f, -61.527000f, 4.322000f, -61.508000f,
                4.252000f, -61.560000f, 4.261000f, -61.608000f, 4.238000f, -61.642000f, 4.263000f, -61.670000f, 4.245000f, -61.725000f,
                4.270000f, -61.724000f, 4.250000f, -61.774000f, 4.232000f, -61.764000f, 4.229000f, -61.802000f, 4.164000f, -61.824000f,
                4.161264f, -61.922128f, 4.120087f, -61.931749f, 4.181000f, -61.982000f, 4.150000f, -62.029000f, 4.154000f, -62.076000f,
                4.126000f, -62.071000f, 4.118000f, -62.117000f, 4.088000f, -62.114000f, 4.077683f, -62.143085f, 4.130000f, -62.252000f,
                4.135000f, -62.329000f, 4.178000f, -62.389000f, 4.178000f, -62.462000f, 4.139000f, -62.465000f, 4.137000f, -62.531000f,
                4.118000f, -62.523000f, 4.109000f, -62.552000f, 4.081000f, -62.558000f, 4.046000f, -62.533000f, 4.037000f, -62.562000f,
                4.019000f, -62.555000f, 4.047000f, -62.646000f, 4.043097f, -62.673840f, 4.615840f, -62.673840f, 4.615840f, -61.358472f
            )
            poly[651] = TzPolygon(5.906735f, -61.358472f, 5.970795f, -61.414905f, 5.968886f, -61.358472f)
            poly[652] = TzPolygon(
                1.624807f, -59.471719f, 1.624807f, -58.727736f, 1.225498f, -58.727736f, 1.199901f, -58.739558f, 1.171002f, -58.821226f,
                1.239000f, -58.912000f, 1.261000f, -58.886000f, 1.290000f, -58.922000f, 1.317000f, -58.918000f, 1.302000f, -58.978000f,
                1.327000f, -58.993000f, 1.323000f, -59.048000f, 1.389000f, -59.253000f, 1.411000f, -59.282000f, 1.450000f, -59.284000f,
                1.464000f, -59.327000f, 1.514000f, -59.329000f, 1.507000f, -59.381000f, 1.556000f, -59.396000f, 1.567000f, -59.431000f,
                1.620000f, -59.447000f
            )
            poly[653] = TzPolygon(
                0.627796f, -58.896108f, 1.227222f, -58.895278f, 1.171002f, -58.821226f, 1.199901f, -58.739558f, 1.225498f, -58.727736f,
                0.627796f, -58.727736f
            )
            poly[654] = TzPolygon(
                1.624807f, -59.471719f, 1.627000f, -59.483000f, 1.674000f, -59.493000f, 1.669000f, -59.511000f, 1.723000f, -59.539000f,
                1.736000f, -59.566000f, 1.716000f, -59.617000f, 1.741000f, -59.632000f, 1.757000f, -59.690000f, 1.844000f, -59.649000f,
                1.871000f, -59.663000f, 1.839000f, -59.677000f, 1.852000f, -59.746000f, 1.901000f, -59.759000f, 2.027253f, -59.720829f,
                2.069024f, -59.742676f, 2.103465f, -59.721762f, 2.162506f, -59.741968f, 2.276153f, -59.723133f, 2.292947f, -59.741033f,
                2.283860f, -59.787475f, 2.360148f, -59.871394f, 2.361454f, -59.898170f, 2.480606f, -59.897068f, 2.551856f, -59.938399f,
                2.569108f, -59.929107f, 2.593102f, -59.972060f, 2.609302f, -59.957947f, 2.621818f, -59.963447f, 2.621818f, -58.727736f,
                1.624807f, -58.727736f
            )
            poly[655] = TzPolygon(
                4.615840f, -61.358472f, 4.615840f, -60.939428f, 4.587000f, -60.932000f, 4.584000f, -60.956000f, 4.544000f, -60.964000f,
                4.519000f, -60.994000f, 4.522000f, -61.095000f, 4.480165f, -61.145587f, 4.536000f, -61.217000f, 4.535000f, -61.323000f,
                4.504000f, -61.322000f, 4.478000f, -61.278000f, 4.458000f, -61.288000f, 4.458000f, -61.313000f, 4.421000f, -61.338000f,
                4.424350f, -61.358472f
            )
            poly[656] = TzPolygon(
                4.489584f, -60.043104f, 4.493306f, -60.070660f, 4.521072f, -60.064533f, 4.517340f, -60.086478f, 4.533560f, -60.087813f,
                4.502028f, -60.117787f, 4.517726f, -60.161141f, 4.572475f, -60.157246f, 4.564866f, -60.136429f, 4.605011f, -60.123420f,
                4.615840f, -60.075142f, 4.615840f, -60.043104f
            )
            poly[657] = TzPolygon(
                2.621818f, -59.963447f, 2.686097f, -59.991696f, 2.834642f, -59.991799f, 2.929589f, -59.984212f, 2.998348f, -59.946973f,
                3.079086f, -59.956466f, 3.121481f, -59.921639f, 3.112883f, -59.908214f, 3.211569f, -59.908379f, 3.224461f, -59.874551f,
                3.241465f, -59.888066f, 3.330522f, -59.827869f, 3.352633f, -59.834000f, 3.360666f, -59.804188f, 3.428356f, -59.813131f,
                3.428754f, -59.841628f, 3.505126f, -59.803358f, 3.563853f, -59.873038f, 3.604489f, -59.850645f, 3.618829f, -59.793717f,
                3.618829f, -58.727736f, 2.621818f, -58.727736f
            )
            poly[658] = TzPolygon(
                4.489584f, -60.043104f, 4.480105f, -59.972916f, 4.509552f, -59.970943f, 4.500043f, -59.935587f, 4.460430f, -59.909406f,
                4.487172f, -59.874831f, 4.452403f, -59.861538f, 4.447086f, -59.812241f, 4.465541f, -59.795027f, 4.448072f, -59.794522f,
                4.376295f, -59.669479f, 4.285869f, -59.731895f, 4.268761f, -59.709454f, 4.233904f, -59.739486f, 4.180764f, -59.730691f,
                4.131660f, -59.618177f, 4.069432f, -59.654058f, 4.051935f, -59.617841f, 4.007373f, -59.607250f, 4.000591f, -59.579431f,
                3.968513f, -59.584169f, 3.979132f, -59.544684f, 3.944925f, -59.515301f, 3.885385f, -59.592788f, 3.817196f, -59.577449f,
                3.814975f, -59.597272f, 3.793864f, -59.596307f, 3.781259f, -59.665547f, 3.702775f, -59.668415f, 3.626282f, -59.764127f,
                3.618829f, -59.793717f, 3.618829f, -60.043104f
            )
            poly[659] = TzPolygon(
                2.621818f, -57.412368f, 1.911660f, -57.412368f, 1.905976f, -57.433428f, 1.826814f, -57.437760f, 1.786088f, -57.501869f,
                1.700495f, -57.537597f, 1.682369f, -57.650421f, 1.730931f, -57.705090f, 1.715455f, -57.718397f, 1.729727f, -57.774307f,
                1.726644f, -57.792257f, 1.685210f, -57.799789f, 1.688899f, -57.844171f, 1.667820f, -57.852056f, 1.680292f, -57.877119f,
                1.644809f, -57.926757f, 1.658439f, -57.990093f, 1.645678f, -58.002615f, 1.633206f, -57.980311f, 1.572779f, -57.978559f,
                1.503026f, -58.004228f, 1.525341f, -58.060927f, 1.507337f, -58.069449f, 1.498895f, -58.129425f, 1.560114f, -58.160643f,
                1.572218f, -58.193035f, 1.546687f, -58.236003f, 1.570732f, -58.262255f, 1.568437f, -58.317139f, 1.597015f, -58.322366f,
                1.538017f, -58.363087f, 1.526512f, -58.394723f, 1.481573f, -58.371754f, 1.469988f, -58.385587f, 1.462946f, -58.508726f,
                1.403166f, -58.505113f, 1.371452f, -58.457871f, 1.267963f, -58.496224f, 1.277631f, -58.512890f, 1.257909f, -58.522891f,
                1.294603f, -58.564559f, 1.262124f, -58.585393f, 1.297324f, -58.694563f, 1.225498f, -58.727736f, 2.621818f, -58.727736f
            )
            poly[660] = TzPolygon(
                2.114745f, -56.754684f, 2.205278f, -56.819451f, 2.265556f, -56.826396f, 2.297222f, -56.884174f, 2.362222f, -56.887507f,
                2.393056f, -56.932229f, 2.436111f, -56.930007f, 2.465000f, -56.956118f, 2.515000f, -56.950007f, 2.509444f, -56.996674f,
                2.555278f, -56.996951f, 2.592222f, -57.027229f, 2.621818f, -57.020653f, 2.621818f, -56.754684f
            )
            poly[661] = TzPolygon(
                1.911660f, -57.412368f, 1.923722f, -57.367678f, 1.956381f, -57.369118f, 1.996653f, -57.307117f, 1.937587f, -57.229228f,
                1.978665f, -57.199895f, 2.026442f, -57.086676f, 1.955966f, -57.063931f, 1.914893f, -57.014207f, 1.902949f, -56.976097f,
                1.930360f, -56.919708f, 1.899327f, -56.893482f, 1.872539f, -56.798850f, 1.853358f, -56.797930f, 1.894066f, -56.754684f,
                1.624807f, -56.754684f, 1.624807f, -57.412368f
            )
            poly[662] = TzPolygon(
                2.114745f, -56.754684f, 2.026667f, -56.691674f, 2.023889f, -56.562785f, 1.949182f, -56.468954f, 1.905880f, -56.579760f,
                1.945878f, -56.621453f, 1.917116f, -56.651043f, 1.925815f, -56.720956f, 1.894066f, -56.754684f
            )
            poly[663] = TzPolygon(
                1.847551f, -56.097000f, 1.850973f, -56.117621f, 1.900481f, -56.170899f, 1.898611f, -56.234460f, 1.878080f, -56.244042f,
                1.937101f, -56.334934f, 1.928265f, -56.411816f, 2.023889f, -56.562785f, 2.026667f, -56.691674f, 2.114745f, -56.754684f,
                2.621818f, -56.754684f, 2.621818f, -56.097000f, 2.317191f, -56.097000f, 2.265745f, -56.138873f, 2.249186f, -56.097000f
            )
            poly[664] = TzPolygon(
                2.621818f, -57.020653f, 2.634722f, -57.017785f, 2.637500f, -57.060285f, 2.687500f, -57.065007f, 2.734722f, -57.102785f,
                2.771667f, -57.090285f, 2.770833f, -57.137785f, 2.826389f, -57.127507f, 2.816111f, -57.182785f, 2.847500f, -57.206118f,
                2.903056f, -57.223896f, 2.951667f, -57.183618f, 2.960556f, -57.228063f, 3.017222f, -57.228063f, 3.025556f, -57.204729f,
                3.070000f, -57.215007f, 3.097500f, -57.250840f, 3.141111f, -57.238340f, 3.139722f, -57.285007f, 3.278611f, -57.294729f,
                3.324444f, -57.278896f, 3.384167f, -57.300007f, 3.358056f, -57.357785f, 3.382778f, -57.421951f, 3.356667f, -57.430285f,
                3.338333f, -57.473340f, 3.364722f, -57.520563f, 3.341667f, -57.597507f, 3.364167f, -57.650278f, 3.395556f, -57.666389f,
                3.461389f, -57.636389f, 3.523611f, -57.656389f, 3.559167f, -57.709722f, 3.610278f, -57.734444f, 3.669167f, -57.838611f,
                3.809444f, -57.876111f, 3.906389f, -57.943333f, 3.998056f, -58.043333f, 4.159444f, -58.070833f, 4.288056f, -57.953611f,
                4.403333f, -57.958611f, 4.615840f, -57.855057f, 4.615840f, -56.097000f, 2.621818f, -56.097000f
            )
            poly[665] = TzPolygon(
                5.612851f, -61.358472f, 5.612851f, -61.103245f, 5.187423f, -60.732828f, 5.189000f, -60.680000f, 5.115000f, -60.656000f,
                5.118000f, -60.642000f, 5.057000f, -60.644000f, 4.956000f, -60.584000f, 4.774000f, -60.726000f, 4.749000f, -60.806000f,
                4.704000f, -60.852000f, 4.704000f, -60.911000f, 4.665000f, -60.917000f, 4.653000f, -60.949000f, 4.615840f, -60.939428f,
                4.615840f, -61.358472f
            )
            poly[666] = TzPolygon(4.615840f, -60.075142f, 4.616881f, -60.070500f, 4.655482f, -60.075425f, 4.688334f, -60.043104f, 4.615840f, -60.043104f)
            poly[667] = TzPolygon(
                5.113468f, -60.043104f, 5.140000f, -60.094000f, 5.249000f, -60.135000f, 5.227000f, -60.172000f, 5.239150f, -60.193167f,
                5.270477f, -60.179332f, 5.283457f, -60.208247f, 5.208000f, -60.319000f, 5.222000f, -60.384000f, 5.182000f, -60.434000f,
                5.203000f, -60.451000f, 5.196000f, -60.569000f, 5.231000f, -60.652000f, 5.201898f, -60.737554f, 5.612851f, -61.099578f,
                5.612851f, -60.043104f
            )
            poly[668] = TzPolygon(
                5.612851f, -60.043104f, 5.612851f, -61.099578f, 5.906735f, -61.358472f, 5.968868f, -61.357940f, 6.109637f, -61.269881f,
                6.126312f, -61.231619f, 6.111978f, -61.209290f, 6.187074f, -61.179252f, 6.176566f, -61.138135f, 6.193698f, -61.124543f,
                6.216256f, -61.142361f, 6.271364f, -61.114036f, 6.271478f, -61.136250f, 6.330127f, -61.184163f, 6.429151f, -61.143160f,
                6.464443f, -61.152354f, 6.471753f, -61.182564f, 6.519451f, -61.172420f, 6.537371f, -61.196469f, 6.525839f, -61.222189f,
                6.549317f, -61.209746f, 6.570472f, -61.231959f, 6.609862f, -61.207568f, 6.609862f, -60.043104f
            )
            poly[669] = TzPolygon(5.121578f, -60.043104f, 5.063345f, -59.969842f, 4.801084f, -60.034442f, 4.706496f, -60.025235f, 4.688334f, -60.043104f)
            poly[670] = TzPolygon(
                7.606873f, -61.358472f, 7.606873f, -60.629404f, 7.577579f, -60.638868f, 7.578202f, -60.689439f, 7.558105f, -60.687675f,
                7.538838f, -60.720363f, 7.479065f, -60.697637f, 7.447242f, -60.639214f, 7.418389f, -60.643110f, 7.393565f, -60.607224f,
                7.314277f, -60.588135f, 7.245995f, -60.637953f, 7.125722f, -60.546525f, 7.188799f, -60.501536f, 7.204774f, -60.459505f,
                7.173308f, -60.409424f, 7.184794f, -60.367115f, 7.133533f, -60.293551f, 7.071217f, -60.289386f, 7.023396f, -60.317861f,
                6.997910f, -60.366295f, 6.941111f, -60.368291f, 6.929940f, -60.380253f, 6.950662f, -60.408802f, 6.859000f, -60.548259f,
                6.829960f, -60.663613f, 6.755505f, -60.718501f, 6.794204f, -60.809728f, 6.782302f, -60.853540f, 6.816601f, -60.913886f,
                6.789455f, -60.925577f, 6.755681f, -60.900600f, 6.719501f, -60.946184f, 6.729470f, -61.075910f, 6.703515f, -61.087913f,
                6.721511f, -61.138434f, 6.609862f, -61.207568f, 6.609862f, -61.358472f
            )
            poly[671] = TzPolygon(
                7.606873f, -60.629404f, 7.642679f, -60.617837f, 7.631478f, -60.590323f, 7.673901f, -60.593377f, 7.705602f, -60.568138f,
                7.734219f, -60.583635f, 7.795094f, -60.532231f, 7.815728f, -60.540174f, 7.838321f, -60.466966f, 7.820792f, -60.404816f,
                7.839812f, -60.379498f, 7.831281f, -60.348252f, 7.910702f, -60.247768f, 7.957744f, -60.219113f, 7.989915f, -60.140796f,
                8.028875f, -60.121934f, 8.032776f, -60.043104f, 7.606873f, -60.043104f
            )
            poly[672] = TzPolygon(
                8.603884f, -59.773739f, 8.528377f, -59.986725f, 8.300833f, -59.809167f, 8.275000f, -59.801389f, 8.236111f, -59.825556f,
                8.213463f, -59.946031f, 8.158201f, -59.993405f, 8.132711f, -59.980625f, 8.033331f, -60.031897f, 8.032776f, -60.043104f,
                8.603884f, -60.043104f
            )
            poly[673] = TzPolygon(
                4.615840f, -57.855057f, 4.643889f, -57.841389f, 4.764722f, -57.884444f, 4.805000f, -57.926389f, 4.924444f, -57.843889f,
                4.925278f, -57.766667f, 4.964167f, -57.749444f, 5.011944f, -57.682500f, 4.991944f, -57.607778f, 5.014800f, -57.532020f,
                4.990503f, -57.475431f, 4.991430f, -57.414780f, 5.037302f, -57.329364f, 5.016247f, -57.290717f, 5.072050f, -57.326120f,
                5.174420f, -57.298400f, 5.187330f, -57.253920f, 5.134100f, -57.223040f, 5.164670f, -57.183960f, 5.262110f, -57.226940f,
                5.269060f, -57.264490f, 5.229880f, -57.251100f, 5.222130f, -57.276560f, 5.252485f, -57.296625f, 5.321587f, -57.291879f,
                5.310301f, -57.329199f, 5.325376f, -57.341382f, 5.390490f, -57.274320f, 5.481500f, -57.264330f, 5.550620f, -57.199000f,
                5.623860f, -57.165060f, 5.699400f, -57.160320f, 5.743740f, -57.183490f, 5.895350f, -57.135010f, 6.051360f, -57.162573f,
                6.084519f, -57.078722f, 6.225000f, -57.014948f, 6.197000f, -56.999074f, 6.172000f, -56.814039f, 6.175000f, -56.621948f,
                6.114000f, -56.485443f, 6.040202f, -56.097000f, 4.615840f, -56.097000f
            )
            poly[674] = TzPolygon(
                -9.893535f, -71.171189f, -9.969890f, -71.220414f, -9.963139f, -71.253107f, -9.992411f, -71.298085f, -9.966986f, -71.342658f,
                -10.000447f, -71.377955f, -10.000447f, -72.181027f, -9.966337f, -72.149987f, -9.930934f, -72.174337f, -9.893535f, -72.148719f
            )
            poly[675] = TzPolygon(
                -11.792956f, -71.171189f, -11.792956f, -69.045107f, -11.912991f, -68.970408f, -12.050486f, -68.895567f, -13.436012f, -68.895567f,
                -13.437068f, -68.905998f, -13.461260f, -68.896076f, -13.525328f, -68.919338f, -13.522282f, -68.940827f, -13.604400f, -68.952473f,
                -13.624119f, -69.005045f, -13.651779f, -68.994666f, -13.640283f, -69.037215f, -13.673305f, -69.066973f, -13.692378f, -69.055115f,
                -13.692378f, -71.171189f
            )
            poly[676] = TzPolygon(
                -11.792956f, -68.895567f, -11.792956f, -69.045025f, -10.945535f, -69.571811f, -10.936061f, -69.501293f, -10.954960f, -69.478218f,
                -10.925411f, -69.417032f, -10.956595f, -69.374900f, -10.936109f, -69.354269f, -10.954965f, -69.274481f, -10.939780f, -69.233539f,
                -10.958306f, -69.215522f, -10.954668f, -69.152192f, -10.981331f, -69.121091f, -10.976506f, -69.038752f, -11.011387f, -68.992406f,
                -10.989628f, -68.952953f, -11.012023f, -68.947901f, -11.022079f, -68.910738f, -11.017936f, -68.895567f
            )
            poly[677] = TzPolygon(
                -9.893535f, -70.623237f, -10.999821f, -70.621025f, -10.934652f, -70.530334f, -10.996571f, -70.452647f, -11.039102f, -70.437674f,
                -11.070776f, -70.308595f, -11.042771f, -70.158254f, -10.985336f, -70.092229f, -10.993700f, -70.064460f, -10.921232f, -69.933490f,
                -10.930320f, -69.769138f, -10.975219f, -69.739438f, -10.976892f, -69.715094f, -10.942590f, -69.574303f, -11.792956f, -69.045107f,
                -11.792956f, -71.171189f, -9.893535f, -71.171189f
            )
            poly[678] = TzPolygon(
                -12.050486f, -68.895567f, -12.497969f, -68.651991f, -12.533810f, -68.655077f, -12.522822f, -68.683331f, -12.552034f, -68.674421f,
                -12.634311f, -68.741917f, -12.680656f, -68.712658f, -12.693365f, -68.736138f, -12.712466f, -68.728794f, -12.756566f, -68.803953f,
                -12.808618f, -68.807631f, -12.823897f, -68.839373f, -12.857839f, -68.834799f, -12.870592f, -68.870701f, -12.947768f, -68.860212f,
                -12.940760f, -68.878171f, -12.957629f, -68.882162f, -12.981303f, -68.861675f, -12.988866f, -68.879776f, -13.046449f, -68.848919f,
                -13.047595f, -68.863877f, -13.113288f, -68.859242f, -13.136203f, -68.878020f, -13.150525f, -68.858089f, -13.181356f, -68.872132f,
                -13.246693f, -68.845287f, -13.329378f, -68.878788f, -13.359242f, -68.868797f, -13.383186f, -68.891678f, -13.435396f, -68.889486f,
                -13.436012f, -68.895567f
            )
            poly[679] = TzPolygon(
                -11.017936f, -68.895567f, -10.989867f, -68.792765f, -11.014583f, -68.788831f, -10.998151f, -68.780276f, -11.009527f, -68.747675f,
                -11.066239f, -68.766218f, -11.109409f, -68.722234f, -11.146802f, -68.716798f, -11.108874f, -68.544474f, -11.036712f, -68.436482f,
                -11.056709f, -68.402229f, -11.020733f, -68.385525f, -11.015862f, -68.331872f, -10.961179f, -68.236716f, -10.859659f, -68.195758f,
                -10.776926f, -68.103738f, -10.715023f, -68.105227f, -10.655779f, -68.033002f, -10.640681f, -67.864593f, -10.710828f, -67.708251f,
                -10.605166f, -67.675718f, -10.615549f, -67.658637f, -10.598069f, -67.640275f, -10.502796f, -67.579247f, -10.454920f, -67.443611f,
                -10.427200f, -67.413252f, -10.373864f, -67.407166f, -10.393682f, -67.355283f, -10.376375f, -67.311168f, -10.319971f, -67.316745f,
                -10.332934f, -67.265323f, -10.315086f, -67.224393f, -10.339232f, -67.177450f, -10.316553f, -67.129032f, -10.290478f, -67.126105f,
                -10.258725f, -67.015759f, -10.221624f, -66.988812f, -10.199018f, -66.996851f, -10.188858f, -66.952801f, -10.082680f, -66.875097f,
                -10.083996f, -66.837600f, -9.999258f, -66.763564f, -9.967507f, -66.675414f, -9.936871f, -66.662925f, -9.950054f, -66.637146f,
                -9.893535f, -66.619944f, -11.792956f, -66.619944f, -11.792956f, -68.895567f
            )
            poly[680] = TzPolygon(
                -9.411841f, -72.982482f, -9.411396f, -73.200439f, -9.363223f, -73.188760f, -9.354101f, -73.148366f, -9.318317f, -73.131406f,
                -9.308117f, -73.101434f, -9.275348f, -73.107328f, -9.234607f, -73.073518f, -9.222365f, -73.009298f, -9.195447f, -73.003343f,
                -9.177857f, -73.026124f, -9.155477f, -72.982482f
            )
            poly[681] = TzPolygon(
                -8.951741f, -72.982482f, -8.917781f, -72.999307f, -8.905774f, -73.058886f, -8.698298f, -73.167241f, -8.690216f, -73.255472f,
                -8.681076f, -73.262825f, -8.681076f, -72.982482f
            )
            poly[682] = TzPolygon(
                -8.681076f, -72.982482f, -8.681076f, -73.262825f, -8.610906f, -73.319275f, -8.616784f, -73.341042f, -8.474035f, -73.331831f,
                -8.470240f, -73.388115f, -8.431291f, -73.406715f, -8.350223f, -73.541908f, -8.270786f, -73.526262f, -8.240861f, -73.587386f,
                -8.223660f, -73.571412f, -8.164561f, -73.595695f, -8.128678f, -73.584471f, -8.057460f, -73.626253f, -8.034250f, -73.616851f,
                -8.006529f, -73.639248f, -8.013148f, -73.668023f, -7.954732f, -73.705605f, -7.965846f, -73.726783f, -7.909164f, -73.772256f,
                -7.860600f, -73.761543f, -7.878811f, -73.735451f, -7.859643f, -73.679223f, -7.781441f, -73.678747f, -7.742386f, -73.714799f,
                -7.715760f, -73.819818f, -7.666871f, -73.839180f, -7.676240f, -73.866539f, -7.640228f, -73.900459f, -7.603553f, -73.889023f,
                -7.561471f, -73.978568f, -7.534734f, -73.983062f, -7.533434f, -73.941711f, -7.472988f, -73.909759f, -7.468617f, -73.911326f,
                -7.468617f, -72.982482f
            )
            poly[683] = TzPolygon(-7.715415f, -71.174515f, -7.552000f, -72.584719f, -7.468617f, -72.815278f, -7.468617f, -71.174515f)
            poly[684] = TzPolygon(
                -8.951741f, -72.982482f, -8.981013f, -72.967980f, -8.984940f, -72.940911f, -9.012099f, -72.963071f, -9.093248f, -72.939994f,
                -9.143024f, -72.958197f, -9.155477f, -72.982482f
            )
            poly[685] = TzPolygon(
                -9.409531f, -72.982482f, -9.412383f, -72.717037f, -9.439365f, -72.695146f, -9.455868f, -72.576780f, -9.491281f, -72.519535f,
                -9.477154f, -72.407492f, -9.494598f, -72.356876f, -9.543794f, -72.318586f, -9.539953f, -72.282898f, -9.603158f, -72.288209f,
                -9.616334f, -72.252818f, -9.750855f, -72.262955f, -9.797416f, -72.151361f, -9.830402f, -72.162833f, -9.874872f, -72.135935f,
                -9.893535f, -72.148719f, -9.893535f, -72.982482f
            )
            poly[686] = TzPolygon(
                -7.408148f, -72.982482f, -7.113061f, -73.798420f, -7.046760f, -73.757100f, -6.977730f, -73.761280f, -6.964160f, -73.743890f,
                -6.935830f, -73.760790f, -6.754150f, -73.638260f, -6.722033f, -73.561792f, -6.676141f, -73.521927f, -6.635760f, -73.379917f,
                -6.593267f, -73.352809f, -6.588843f, -73.227413f, -6.564429f, -73.221791f, -6.577113f, -73.206692f, -6.545779f, -73.181677f,
                -6.523016f, -73.187967f, -6.531325f, -73.163387f, -6.510461f, -73.135226f, -6.406664f, -73.104726f, -6.380259f, -73.135576f,
                -6.276668f, -73.160705f, -6.219577f, -73.220285f, -6.183181f, -73.216272f, -6.149625f, -73.246638f, -6.043992f, -73.238213f,
                -6.005125f, -73.186802f, -5.944716f, -73.186950f, -5.867960f, -73.152068f, -5.864329f, -73.117020f, -5.833184f, -73.114216f,
                -5.795170f, -73.053029f, -5.733411f, -73.027531f, -5.728522f, -73.000465f, -5.661276f, -72.985570f, -5.660764f, -72.982482f
            )
            poly[687] = TzPolygon(
                -7.468617f, -73.911326f, -7.357483f, -73.951172f, -7.389247f, -73.863548f, -7.354310f, -73.853662f, -7.338618f, -73.821097f,
                -7.336904f, -73.761626f, -7.353786f, -73.754640f, -7.322462f, -73.700394f, -7.227558f, -73.716619f, -7.206423f, -73.752076f,
                -7.113061f, -73.798420f, -7.408148f, -72.982482f, -7.468617f, -72.982482f
            )
            poly[688] = TzPolygon(
                -5.043700f, -72.618503f, -5.051804f, -72.621198f, -5.051993f, -72.727648f, -5.088593f, -72.739860f, -5.076617f, -72.756367f,
                -5.113442f, -72.785947f, -5.102776f, -72.818312f, -5.139117f, -72.815473f, -5.136013f, -72.850853f, -5.164011f, -72.887570f,
                -5.179063f, -72.869027f, -5.271167f, -72.860525f, -5.466129f, -72.958885f, -5.521978f, -72.960594f, -5.541280f, -72.938574f,
                -5.612911f, -72.973678f, -5.656891f, -72.959116f, -5.660764f, -72.982482f, -5.043700f, -72.982482f
            )
            poly[689] = TzPolygon(-7.408148f, -72.982482f, -7.468617f, -72.815278f, -7.468617f, -72.982482f)
            poly[690] = TzPolygon(
                -5.043700f, -69.578418f, -9.541382f, -67.558582f, -9.049000f, -68.647000f, -7.845148f, -70.054979f, -7.715415f, -71.174515f,
                -5.043700f, -71.174515f
            )
            poly[691] = TzPolygon(
                -9.893535f, -71.171189f, -9.872365f, -71.157541f, -9.815836f, -71.051225f, -9.817209f, -70.993912f, -9.748912f, -70.963367f,
                -9.741298f, -70.923827f, -9.643235f, -70.836149f, -9.638462f, -70.793319f, -9.604253f, -70.757241f, -9.560426f, -70.750669f,
                -9.570256f, -70.729797f, -9.525963f, -70.662115f, -9.441795f, -70.596273f, -9.424320f, -70.494616f, -9.463667f, -70.503759f,
                -9.467837f, -70.523908f, -9.505566f, -70.505061f, -9.490329f, -70.514887f, -9.518518f, -70.528105f, -9.514688f, -70.546001f,
                -9.536463f, -70.538898f, -9.531469f, -70.567973f, -9.570573f, -70.553318f, -9.568042f, -70.586281f, -9.548644f, -70.590215f,
                -9.560193f, -70.600832f, -9.640840f, -70.584701f, -9.714978f, -70.525230f, -9.765840f, -70.536629f, -9.820545f, -70.623383f,
                -9.893535f, -70.623237f
            )
            poly[692] = TzPolygon(-9.541382f, -67.558582f, -5.043700f, -69.578418f, -5.043700f, -67.558582f)
            poly[693] = TzPolygon(
                -5.043700f, -72.618503f, -4.983427f, -72.598459f, -4.997965f, -72.584674f, -4.955561f, -72.551936f, -4.960019f, -72.522168f,
                -4.932872f, -72.521159f, -4.950802f, -72.482029f, -4.915688f, -72.451348f, -4.891863f, -72.471133f, -4.900978f, -72.415656f,
                -4.875994f, -72.421856f, -4.888655f, -72.406110f, -4.871989f, -72.381433f, -4.833670f, -72.389878f, -4.823771f, -72.359661f,
                -4.805187f, -72.371524f, -4.793564f, -72.339800f, -4.812081f, -72.323540f, -4.780377f, -72.327698f, -4.790807f, -72.307322f,
                -4.771412f, -72.278864f, -4.798737f, -72.271971f, -4.765845f, -72.256540f, -4.781745f, -72.244328f, -4.747845f, -72.210096f,
                -4.763333f, -72.193182f, -4.711893f, -72.141173f, -4.733985f, -72.125928f, -4.669055f, -72.081098f, -4.669646f, -72.078499f,
                -5.043700f, -72.078499f
            )
            poly[694] = TzPolygon(
                -4.399647f, -71.174515f, -4.396812f, -71.185122f, -4.424710f, -71.194220f, -4.379868f, -71.202632f, -4.408622f, -71.226149f,
                -4.385687f, -71.229754f, -4.385003f, -71.269751f, -4.442167f, -71.277819f, -4.420089f, -71.320906f, -4.462876f, -71.307517f,
                -4.427278f, -71.350261f, -4.430932f, -71.395505f, -4.470577f, -71.425620f, -4.449698f, -71.432143f, -4.438402f, -71.412402f,
                -4.428818f, -71.434375f, -4.450211f, -71.436950f, -4.434979f, -71.478663f, -4.458426f, -71.485530f, -4.439087f, -71.507159f,
                -4.487006f, -71.494284f, -4.464416f, -71.537028f, -4.529275f, -71.596251f, -4.515243f, -71.633502f, -4.468695f, -71.615477f,
                -4.503948f, -71.650325f, -4.472460f, -71.654788f, -4.502066f, -71.659079f, -4.511649f, -71.708175f, -4.468866f, -71.751090f,
                -4.504462f, -71.766368f, -4.485295f, -71.796752f, -4.527222f, -71.864215f, -4.516441f, -71.907302f, -4.537473f, -71.885404f,
                -4.529240f, -71.919000f, -4.608216f, -71.947347f, -4.609404f, -71.994551f, -4.626396f, -71.982021f, -4.645667f, -72.006804f,
                -4.623288f, -72.043260f, -4.673738f, -72.060487f, -4.669646f, -72.078499f, -3.831241f, -72.078499f, -3.831241f, -71.174515f
            )
            poly[695] = TzPolygon(
                -1.406323f, -73.556708f, -1.406323f, -72.982482f, -2.350880f, -72.982482f, -2.360334f, -73.002868f, -2.313681f, -73.032737f,
                -2.361020f, -73.058143f, -2.324239f, -73.096201f, -2.327231f, -73.119598f, -2.288982f, -73.115650f, -2.236749f, -73.165279f,
                -2.189651f, -73.170876f, -2.179995f, -73.128718f, -2.130656f, -73.116508f, -2.093259f, -73.069301f, -2.071816f, -73.113590f,
                -2.041623f, -73.092132f, -1.991572f, -73.130061f, -1.885846f, -73.108268f, -1.859253f, -73.152385f, -1.805410f, -73.146250f,
                -1.788564f, -73.194442f, -1.748586f, -73.217788f, -1.802633f, -73.235469f, -1.806408f, -73.256069f, -1.782387f, -73.246627f,
                -1.777476f, -73.299939f, -1.827512f, -73.315120f, -1.772092f, -73.386703f, -1.790505f, -73.427816f, -1.741894f, -73.454338f,
                -1.708092f, -73.531585f, -1.639972f, -73.516307f, -1.575345f, -73.457267f, -1.570809f, -73.490333f, -1.483625f, -73.490870f,
                -1.473274f, -73.524592f, -1.432336f, -73.536049f, -1.428228f, -73.579887f, -1.416935f, -73.552378f
            )
            poly[696] = TzPolygon(
                -1.173431f, -73.886466f, -1.116461f, -73.912072f, -1.131146f, -73.958164f, -1.081770f, -73.964794f, -1.106432f, -73.978420f,
                -1.098880f, -74.006057f, -1.061496f, -74.026829f, -1.005684f, -74.018074f, -1.053569f, -74.064937f, -0.978803f, -74.272582f,
                -0.941148f, -74.262176f, -0.899061f, -74.279334f, -0.880733f, -74.320458f, -0.865144f, -74.301540f, -0.880632f, -74.270255f,
                -0.820764f, -74.243390f, -0.828187f, -74.279471f, -0.779011f, -74.279074f, -0.793354f, -74.312505f, -0.754230f, -74.315735f,
                -0.758349f, -74.344370f, -0.727968f, -74.375129f, -0.677503f, -74.337879f, -0.653729f, -74.373906f, -0.630128f, -74.359508f,
                -0.541905f, -74.392301f, -0.559922f, -74.420448f, -0.499335f, -74.422357f, -0.472673f, -74.473673f, -0.487655f, -74.497009f,
                -0.461907f, -74.497867f, -0.458603f, -74.537143f, -0.407690f, -74.553708f, -0.377606f, -74.616322f, -0.352047f, -74.608074f,
                -0.374482f, -74.660370f, -0.331104f, -74.679142f, -0.342786f, -74.728383f, -0.296944f, -74.728580f, -0.193865f, -74.790449f,
                -0.193865f, -73.886466f
            )
            poly[697] = TzPolygon(
                -1.173431f, -73.886466f, -1.229316f, -73.861347f, -1.239441f, -73.783069f, -1.261580f, -73.770195f, -1.200483f, -73.743930f,
                -1.248366f, -73.726936f, -1.240621f, -73.673925f, -1.267244f, -73.648487f, -1.263779f, -73.619401f, -1.318729f, -73.611065f,
                -1.326609f, -73.567157f, -1.346173f, -73.581254f, -1.406323f, -73.556708f, -1.406323f, -73.886466f
            )
            poly[698] = TzPolygon(
                -2.350880f, -72.982482f, -2.337008f, -72.952572f, -2.457193f, -72.930932f, -2.434744f, -72.895970f, -2.439674f, -72.857277f,
                -2.385305f, -72.777111f, -2.427668f, -72.744495f, -2.386411f, -72.711663f, -2.451965f, -72.681166f, -2.358493f, -72.635193f,
                -2.401084f, -72.566311f, -2.433671f, -72.448551f, -2.414152f, -72.408039f, -2.490781f, -72.368557f, -2.459568f, -72.259208f,
                -2.432243f, -72.259325f, -2.448763f, -72.216476f, -2.426484f, -72.171379f, -2.479944f, -72.157303f, -2.410003f, -72.128917f,
                -2.365397f, -72.078499f, -2.618782f, -72.078499f, -2.618782f, -72.982482f
            )
            poly[699] = TzPolygon(
                -2.365397f, -72.078499f, -2.335737f, -72.044975f, -2.370565f, -72.005417f, -2.355801f, -71.944900f, -2.380674f, -71.922409f,
                -2.316111f, -71.939317f, -2.314149f, -71.887093f, -2.187379f, -71.828935f, -2.204826f, -71.796548f, -2.140985f, -71.734454f,
                -2.230949f, -71.720944f, -2.199914f, -71.652362f, -2.239037f, -71.599166f, -2.249117f, -71.520206f, -2.354049f, -71.493369f,
                -2.334144f, -71.479206f, -2.276206f, -71.495101f, -2.279992f, -71.452743f, -2.355119f, -71.391803f, -2.391994f, -71.406910f,
                -2.410497f, -71.393220f, -2.379474f, -71.353523f, -2.379131f, -71.316616f, -2.336268f, -71.296353f, -2.348429f, -71.275589f,
                -2.389421f, -71.280910f, -2.336793f, -71.231967f, -2.382218f, -71.176197f, -2.376547f, -71.174515f, -2.618782f, -71.174515f,
                -2.618782f, -72.078499f
            )
        }
    }

    private object Initializer8 {
        fun init() {
            poly[700] = TzPolygon(
                -3.831241f, -70.722524f, -4.182248f, -70.722524f, -4.159443f, -70.759012f, -4.218722f, -70.845805f, -4.230047f, -70.816768f,
                -4.254721f, -70.831595f, -4.252452f, -70.864474f, -4.279054f, -70.844829f, -4.293282f, -70.877915f, -4.323554f, -70.876647f,
                -4.359157f, -70.934325f, -4.384318f, -70.935698f, -4.345335f, -70.997411f, -4.386543f, -70.993892f, -4.402118f, -71.037837f,
                -4.369940f, -71.049510f, -4.397668f, -71.076976f, -4.375075f, -71.079894f, -4.377643f, -71.106158f, -4.411189f, -71.114913f,
                -4.381579f, -71.144782f, -4.405713f, -71.151820f, -4.399647f, -71.174515f, -3.831241f, -71.174515f
            )
            poly[701] = TzPolygon(-3.850772f, -70.270532f, -3.831241f, -70.280274f, -3.831241f, -70.270532f)
            poly[702] = TzPolygon(-3.831241f, -70.414129f, -3.880750f, -70.514873f, -3.831241f, -70.563175f)
            poly[703] = TzPolygon(-3.831241f, -70.598734f, -3.843484f, -70.616453f, -3.831241f, -70.633439f)
            poly[704] = TzPolygon(
                -4.182248f, -70.722524f, -4.207908f, -70.681467f, -4.145624f, -70.670715f, -4.163278f, -70.652130f, -4.130113f, -70.647931f,
                -4.126403f, -70.626711f, -4.182852f, -70.632233f, -4.173730f, -70.565433f, -4.211693f, -70.573570f, -4.198921f, -70.552914f,
                -4.137579f, -70.551982f, -4.148242f, -70.510363f, -4.200981f, -70.504167f, -4.161321f, -70.485349f, -4.176260f, -70.466986f,
                -4.161929f, -70.433474f, -4.132082f, -70.436507f, -4.133409f, -70.380232f, -4.179968f, -70.338920f, -4.142062f, -70.322808f,
                -4.165548f, -70.287693f, -4.230233f, -70.278605f, -4.253304f, -70.310002f, -4.287935f, -70.288808f, -4.282352f, -70.270532f,
                -4.437470f, -70.270532f, -4.437470f, -70.722524f
            )
            poly[705] = TzPolygon(
                -3.850772f, -70.270532f, -3.831241f, -70.270532f, -3.831241f, -69.865871f, -4.231687f, -69.947926f, -4.082699f, -70.061874f,
                -4.017346f, -70.140324f, -3.930636f, -70.180320f, -3.896726f, -70.247611f
            )
            poly[706] = TzPolygon(
                -4.282352f, -70.270532f, -4.274836f, -70.245930f, -4.296561f, -70.269516f, -4.309799f, -70.256061f, -4.317158f, -70.224486f,
                -4.298687f, -70.213252f, -4.361791f, -70.191940f, -4.327869f, -70.151365f, -4.306448f, -70.172021f, -4.273079f, -70.155083f,
                -4.285850f, -70.117489f, -4.254540f, -70.108814f, -4.289969f, -70.093941f, -4.294089f, -70.041889f, -4.314275f, -70.079482f,
                -4.332400f, -70.043128f, -4.367283f, -70.049590f, -4.372119f, -70.029160f, -4.330904f, -70.011218f, -4.322103f, -69.985673f,
                -4.347836f, -69.985809f, -4.311148f, -69.951998f, -4.226664f, -69.945336f, -5.043700f, -69.578418f, -5.043700f, -70.270532f
            )
            poly[707] = TzPolygon(-5.043700f, -69.366549f, -5.043700f, -69.578418f, -4.226664f, -69.945336f, -3.831241f, -69.874686f, -3.831241f, -69.366549f)
            poly[708] = TzPolygon(
                -3.831241f, -70.280274f, -3.823764f, -70.284003f, -3.802059f, -70.354747f, -3.831241f, -70.414129f, -3.831241f, -70.563175f,
                -3.816565f, -70.577493f, -3.831241f, -70.598734f, -3.831241f, -70.633439f, -3.793988f, -70.685123f, -3.796515f, -70.713192f,
                -2.757270f, -70.058827f, -2.649478f, -70.084389f, -2.703760f, -70.135544f, -2.690883f, -70.160356f, -2.636548f, -70.165381f,
                -2.658533f, -70.196160f, -2.645342f, -70.219087f, -2.618782f, -70.226957f, -2.618782f, -69.651572f, -3.686152f, -69.836141f,
                -3.831241f, -69.865871f
            )
            poly[709] = TzPolygon(-3.831241f, -69.366549f, -3.831241f, -69.874686f, -2.618782f, -69.658056f, -2.618782f, -69.366549f)
            poly[710] = TzPolygon(
                -2.376547f, -71.174515f, -2.332908f, -71.161577f, -2.338824f, -71.128818f, -2.285882f, -71.132694f, -2.264898f, -71.046077f,
                -2.306579f, -70.993892f, -2.229297f, -71.020411f, -2.210196f, -71.000842f, -2.255293f, -70.941536f, -2.223825f, -70.898111f,
                -2.225961f, -70.863430f, -2.294655f, -70.832486f, -2.297831f, -70.767814f, -2.328755f, -70.750527f, -2.354964f, -70.663394f,
                -2.405389f, -70.677332f, -2.395762f, -70.627168f, -2.474660f, -70.631687f, -2.472088f, -70.557701f, -2.448946f, -70.553166f,
                -2.421737f, -70.597764f, -2.418407f, -70.570404f, -2.476375f, -70.508606f, -2.454072f, -70.471916f, -2.524110f, -70.432971f,
                -2.491761f, -70.367958f, -2.501497f, -70.302945f, -2.520656f, -70.295093f, -2.542641f, -70.348171f, -2.568081f, -70.353510f,
                -2.577189f, -70.314565f, -2.552063f, -70.246726f, -2.618782f, -70.224282f, -2.618782f, -71.174515f
            )
            poly[711] = TzPolygon(
                -2.618782f, -69.658056f, -1.491186f, -69.456589f, -1.454204f, -69.432630f, -1.406323f, -69.435648f, -1.406323f, -69.366549f,
                -2.618782f, -69.366549f
            )
            poly[712] = TzPolygon(
                -1.406323f, -69.435648f, -1.400921f, -69.435989f, -1.365080f, -69.397303f, -1.227562f, -69.430557f, -1.125548f, -69.395234f,
                -1.071399f, -69.432867f, -1.043847f, -69.418584f, -1.024110f, -69.444890f, -0.998273f, -69.418606f, -0.993870f, -69.458816f,
                -0.957450f, -69.471154f, -0.925137f, -69.527995f, -0.867949f, -69.525818f, -0.839166f, -69.572676f, -0.806730f, -69.564087f,
                -0.746671f, -69.624907f, -0.636925f, -69.561785f, -0.595312f, -69.602974f, -0.561210f, -69.591131f, -0.534324f, -69.613651f,
                -0.500798f, -69.607832f, -0.375686f, -69.828161f, -0.337321f, -69.844601f, -0.325734f, -69.920535f, -0.193865f, -70.039716f,
                -0.193865f, -69.366549f, -1.406323f, -69.366549f
            )
            poly[713] = TzPolygon(-9.888653f, -66.619944f, -9.814051f, -66.805868f, -9.753091f, -66.775364f, -9.756072f, -66.725390f, -9.673151f, -66.619944f)
            poly[714] = TzPolygon(-9.541196f, -67.558582f, -9.560000f, -67.517000f, -9.592159f, -67.324086f, -9.893535f, -66.619944f, -9.893535f, -67.558582f)
            poly[715] = TzPolygon(
                0.905854f, -70.705196f, 0.905854f, -69.179018f, 0.872042f, -69.135762f, 0.842691f, -69.166146f, 0.767511f, -69.148809f,
                0.740563f, -69.190007f, 0.644840f, -69.115632f, 0.649818f, -69.194253f, 0.605905f, -69.199748f, 0.603894f, -69.294839f,
                0.649971f, -69.289139f, 0.626157f, -69.319670f, 0.642779f, -69.336054f, 0.614160f, -69.352767f, 0.712581f, -69.433377f,
                0.735768f, -69.480024f, 0.702136f, -69.532043f, 0.678919f, -69.535206f, 0.683962f, -69.561559f, 0.654202f, -69.597007f,
                0.613280f, -69.605289f, 0.667593f, -69.671096f, 0.571624f, -69.802724f, 0.591255f, -69.822683f, 0.576893f, -69.887408f,
                0.590043f, -69.916320f, 0.552661f, -69.935642f, 0.577818f, -69.977812f, 0.573760f, -70.000136f, 0.544125f, -70.005508f,
                0.562842f, -70.047046f, -0.189979f, -70.043228f, -0.193865f, -70.039716f, -0.193865f, -70.705196f
            )
            poly[716] = TzPolygon(
                0.905854f, -69.179018f, 0.913236f, -69.188462f, 0.941556f, -69.164602f, 0.972451f, -69.216787f, 0.999741f, -69.197732f,
                1.056552f, -69.244939f, 1.052433f, -69.287339f, 1.088647f, -69.320298f, 1.087938f, -69.376410f, 1.042650f, -69.423124f,
                1.073887f, -69.439431f, 1.070798f, -69.561998f, 1.098258f, -69.609891f, 1.069939f, -69.677182f, 1.075060f, -69.703862f,
                1.118167f, -69.709626f, 1.103407f, -69.773656f, 1.063625f, -69.806272f, 1.072719f, -69.842658f, 1.718929f, -69.839717f,
                1.692438f, -69.782358f, 1.729548f, -69.745033f, 1.723046f, -69.628558f, 1.776907f, -69.534643f, 1.729351f, -69.391089f,
                1.729409f, -68.662570f, 0.905854f, -68.662570f
            )
            poly[717] = TzPolygon(
                2.005573f, -68.201985f, 1.956761f, -68.212268f, 1.830840f, -68.285547f, 1.829184f, -68.226881f, 1.770444f, -68.239542f,
                1.779700f, -68.192071f, 1.766068f, -68.177758f, 1.737491f, -68.193263f, 1.729448f, -68.164499f, 1.729409f, -68.662570f,
                2.005573f, -68.662570f
            )
            poly[718] = TzPolygon(
                2.005573f, -67.765601f, 1.972597f, -67.813851f, 1.902332f, -67.836638f, 1.862142f, -67.890349f, 1.811652f, -67.901623f,
                1.891214f, -68.033517f, 1.897741f, -68.090429f, 1.978541f, -68.144166f, 1.976705f, -68.180335f, 2.005573f, -68.188036f
            )
            poly[719] = TzPolygon(
                1.022021f, -66.619944f, 1.228959f, -66.851191f, 1.286597f, -66.881212f, 1.321385f, -66.855383f, 1.369762f, -66.854919f,
                1.423585f, -66.911048f, 1.530999f, -66.919057f, 1.591217f, -66.963943f, 1.632035f, -66.959682f, 1.786412f, -67.033072f,
                1.920567f, -67.065320f, 1.976886f, -67.122996f, 2.005573f, -67.113034f, 2.005573f, -66.619944f
            )
            poly[720] = TzPolygon(
                2.005480f, -67.641257f, 2.005265f, -67.352973f, 1.941575f, -67.330830f, 1.841269f, -67.228307f, 1.831497f, -67.153836f,
                1.675037f, -67.159221f, 1.639863f, -67.127255f, 1.603527f, -67.140431f, 1.454411f, -67.082601f, 1.385457f, -67.080170f,
                1.320017f, -67.139231f, 1.258288f, -67.099555f, 1.167036f, -67.086753f, 1.228959f, -66.851191f, 1.022021f, -66.619944f,
                0.905854f, -66.619944f, 0.905854f, -67.641257f
            )
            poly[721] = TzPolygon(
                2.005573f, -67.113034f, 2.051286f, -67.097158f, 2.119304f, -67.108022f, 2.136991f, -67.121726f, 2.132836f, -67.161579f,
                2.254247f, -67.221971f, 2.350310f, -67.187902f, 2.398596f, -67.221757f, 2.441948f, -67.297092f, 2.522512f, -67.342544f,
                2.619430f, -67.467627f, 2.663118f, -67.490134f, 2.656898f, -67.563265f, 2.723099f, -67.563176f, 2.811550f, -67.614386f,
                2.795834f, -67.655755f, 2.837544f, -67.750423f, 2.831265f, -67.815380f, 2.794256f, -67.837145f, 2.789438f, -67.864103f,
                2.866229f, -67.864331f, 3.105291f, -67.595727f, 3.105291f, -66.619944f, 2.005573f, -66.619944f
            )
            poly[722] = TzPolygon(2.005573f, -68.201985f, 2.034791f, -68.195830f, 2.005573f, -68.188036f)
            poly[723] = TzPolygon(
                2.005573f, -67.765601f, 2.028504f, -67.732048f, 2.047692f, -67.550949f, 2.163124f, -67.495186f, 2.169604f, -67.449229f,
                2.221272f, -67.436904f, 2.230110f, -67.400800f, 2.208507f, -67.367659f, 2.156881f, -67.349555f, 2.099980f, -67.358983f,
                2.063872f, -67.326716f, 2.005573f, -67.352835f
            )
            poly[724] = TzPolygon(
                3.105291f, -67.595727f, 3.248472f, -67.434853f, 3.245540f, -67.382722f, 3.292584f, -67.381603f, 3.377893f, -67.310785f,
                3.451022f, -67.339150f, 3.479997f, -67.401468f, 3.585236f, -67.444072f, 3.676484f, -67.447957f, 3.767449f, -67.501286f,
                3.752120f, -67.606820f, 3.785550f, -67.634427f, 4.122886f, -67.733203f, 4.205010f, -67.782280f, 4.205010f, -66.619944f,
                3.105291f, -66.619944f
            )
            poly[725] = TzPolygon(
                7.100381f, -70.705196f, 7.053014f, -70.918155f, 7.023692f, -70.921564f, 7.016364f, -70.969778f, 6.974293f, -71.022217f,
                6.989928f, -71.111671f, 7.008627f, -71.103602f, 7.033085f, -71.130990f, 7.011829f, -71.240949f, 7.032726f, -71.264332f,
                7.015352f, -71.369846f, 7.038959f, -71.424624f, 7.011895f, -71.465137f, 7.035017f, -71.527137f, 7.015544f, -71.588288f,
                7.055197f, -71.587724f, 7.032467f, -71.705005f, 7.066263f, -71.766985f, 7.062664f, -71.814381f, 7.025662f, -71.834959f,
                7.009577f, -71.942171f, 7.039104f, -72.047582f, 7.252104f, -72.173822f, 7.326996f, -72.153844f, 7.384214f, -72.196454f,
                7.375931f, -72.325715f, 7.396781f, -72.353855f, 7.403337f, -72.439423f, 7.461801f, -72.447039f, 7.487851f, -72.475982f,
                7.559729f, -72.452763f, 7.632628f, -72.476482f, 7.758592f, -72.473818f, 7.857611f, -72.444417f, 7.943689f, -72.487692f,
                7.995381f, -72.419223f, 8.033886f, -72.416235f, 8.005170f, -72.349250f, 8.080027f, -72.350903f, 8.105806f, -72.373707f,
                8.157498f, -72.352263f, 8.252426f, -72.393697f, 8.357292f, -72.391599f, 8.603884f, -72.644071f, 8.603884f, -70.705196f
            )
            poly[726] = TzPolygon(
                6.135795f, -68.662570f, 6.152103f, -68.706721f, 6.147410f, -68.792712f, 6.179966f, -68.829880f, 6.167374f, -68.882490f,
                6.192929f, -69.014164f, 6.221698f, -69.046177f, 6.191071f, -69.123509f, 6.079534f, -69.238609f, 6.088653f, -69.308869f,
                6.139971f, -69.342134f, 6.107798f, -69.430461f, 6.404447f, -69.664337f, 6.404447f, -68.662570f
            )
            poly[727] = TzPolygon(
                6.135795f, -68.662570f, 6.129146f, -68.644571f, 6.166326f, -68.588469f, 6.148979f, -68.541996f, 6.179067f, -68.510085f,
                6.187729f, -68.448568f, 6.162990f, -68.306973f, 6.228675f, -68.141854f, 6.227096f, -68.077686f, 6.196109f, -68.027538f,
                6.236215f, -67.930040f, 6.324304f, -67.810260f, 6.291432f, -67.762033f, 6.291350f, -67.625259f, 6.262523f, -67.586635f,
                6.266314f, -67.547452f, 6.209354f, -67.466974f, 6.193307f, -67.456846f, 6.130940f, -67.494642f, 5.994295f, -67.410130f,
                5.904291f, -67.532367f, 5.828245f, -67.597147f, 5.675008f, -67.637930f, 5.565994f, -67.620100f, 5.544089f, -67.598886f,
                5.475957f, -67.624970f, 5.303958f, -67.849507f, 5.196136f, -67.824443f, 5.135225f, -67.854283f, 5.054005f, -67.805927f,
                4.943478f, -67.838732f, 4.707233f, -67.817844f, 4.531179f, -67.857593f, 4.486982f, -67.801068f, 4.437064f, -67.797825f,
                4.418997f, -67.773182f, 4.349345f, -67.761610f, 4.327285f, -67.804012f, 4.229666f, -67.797014f, 4.205010f, -67.782280f,
                4.205010f, -68.662570f
            )
            poly[728] = TzPolygon(
                7.100381f, -70.705196f, 7.104381f, -70.687214f, 7.068769f, -70.641943f, 7.079320f, -70.556335f, 7.005668f, -70.502337f,
                7.007284f, -70.431107f, 6.980871f, -70.416671f, 6.980913f, -70.372112f, 6.934568f, -70.322388f, 6.941242f, -70.265846f,
                6.974720f, -70.224333f, 6.979704f, -70.117865f, 6.404447f, -69.664337f, 6.404447f, -70.705196f
            )
            poly[729] = TzPolygon(
                -13.692378f, -50.805843f, -13.530000f, -50.763000f, -13.442000f, -50.665000f, -13.376000f, -50.665000f, -13.307251f, -50.607191f,
                -13.217988f, -50.584456f, -13.187212f, -50.604685f, -13.118421f, -50.592583f, -13.118421f, -50.101268f, -13.692378f, -50.101268f
            )
            poly[730] = TzPolygon(
                -12.544463f, -50.468292f, -12.706064f, -50.468292f, -12.710000f, -50.478000f, -12.725828f, -50.468292f, -12.733038f, -50.468292f,
                -12.744726f, -50.487505f, -12.755740f, -50.468292f, -12.861631f, -50.509999f, -12.829146f, -50.517369f, -12.845080f, -50.534703f,
                -12.830615f, -50.593800f, -12.798472f, -50.580290f, -12.821762f, -50.623139f, -12.774642f, -50.611026f, -12.775077f, -50.636405f,
                -12.732780f, -50.623559f, -12.679842f, -50.654099f, -12.653363f, -50.645172f, -12.644985f, -50.684379f, -12.607890f, -50.707507f,
                -12.586891f, -50.679523f, -12.567997f, -50.689554f, -12.544463f, -50.676937f
            )
            poly[731] = TzPolygon(
                -13.118421f, -50.592583f, -13.112156f, -50.591481f, -13.064000f, -50.611000f, -13.039000f, -50.569000f, -13.002000f, -50.593000f,
                -12.976000f, -50.525000f, -12.784283f, -50.493323f, -12.755337f, -50.468292f, -13.118421f, -50.468292f
            )
            poly[732] = TzPolygon(-12.754846f, -50.468292f, -12.744726f, -50.487505f, -12.733038f, -50.468292f)
            poly[733] = TzPolygon(-12.725828f, -50.468292f, -12.710000f, -50.478000f, -12.706064f, -50.468292f)
            poly[734] = TzPolygon(
                -12.903812f, -50.101268f, -12.897403f, -50.183773f, -12.853795f, -50.231186f, -12.838560f, -50.292882f, -12.798000f, -50.311000f,
                -12.717862f, -50.283283f, -12.680382f, -50.299023f, -12.682268f, -50.265269f, -12.579000f, -50.238000f, -12.564000f, -50.193000f,
                -12.544463f, -50.214966f, -12.544463f, -50.101268f
            )
            poly[735] = TzPolygon(
                -12.544463f, -50.364278f, -12.545529f, -50.365971f, -12.611371f, -50.390847f, -12.624000f, -50.418000f, -12.650000f, -50.413000f,
                -12.652568f, -50.440568f, -12.691635f, -50.432703f, -12.706064f, -50.468292f, -12.544463f, -50.468292f
            )
            poly[736] = TzPolygon(-12.725828f, -50.468292f, -12.731079f, -50.465071f, -12.733038f, -50.468292f)
            poly[737] = TzPolygon(
                -11.396548f, -50.731113f, -11.444062f, -50.741266f, -11.581178f, -50.717363f, -11.594947f, -50.656029f, -11.671917f, -50.661652f,
                -11.733760f, -50.724586f, -11.855669f, -50.687458f, -11.886264f, -50.637101f, -11.921628f, -50.666557f, -11.974898f, -50.658634f,
                -11.990321f, -50.685454f, -12.091635f, -50.668908f, -12.207605f, -50.686814f, -12.222432f, -50.645252f, -12.249838f, -50.654032f,
                -12.277155f, -50.628237f, -12.302526f, -50.652000f, -12.451132f, -50.619130f, -12.455111f, -50.651143f, -12.478694f, -50.641675f,
                -12.544463f, -50.676937f, -12.544463f, -51.569364f, -11.396548f, -51.569364f
            )
            poly[738] = TzPolygon(
                -12.544463f, -50.364278f, -12.431000f, -50.184000f, -12.413000f, -50.196000f, -12.423000f, -50.175000f, -12.397384f, -50.148585f,
                -12.531378f, -50.229678f, -12.544463f, -50.214966f
            )
            poly[739] = TzPolygon(
                -12.903812f, -50.101268f, -11.396548f, -50.101268f, -11.396548f, -48.633171f, -13.031307f, -48.633171f, -12.994000f, -48.675000f,
                -13.002000f, -48.717000f, -12.921000f, -48.736000f, -12.803221f, -48.870228f, -12.957000f, -48.975000f, -12.907000f, -49.023000f,
                -12.904000f, -49.077000f, -12.847000f, -49.067000f, -12.836000f, -49.106000f, -12.790000f, -49.121000f, -12.884000f, -49.237000f,
                -13.103000f, -49.354000f, -13.253000f, -49.340000f, -13.274000f, -49.369000f, -12.964831f, -49.912520f, -12.935833f, -50.039331f,
                -12.905512f, -50.079382f
            )
            poly[740] = TzPolygon(
                -9.100719f, -51.569364f, -9.100719f, -49.873703f, -9.185186f, -49.910029f, -9.228289f, -49.986131f, -9.308229f, -50.047940f,
                -9.379342f, -50.048412f, -9.439678f, -50.092159f, -9.577659f, -50.105153f, -9.621562f, -50.138851f, -9.702951f, -50.136405f,
                -9.744136f, -50.187627f, -9.839025f, -50.207568f, -9.749611f, -51.569364f
            )
            poly[741] = TzPolygon(
                -9.748706f, -51.569364f, -9.839025f, -50.207568f, -9.897629f, -50.265472f, -10.014416f, -50.291609f, -10.069593f, -50.325337f,
                -10.126163f, -50.388527f, -10.215457f, -50.384970f, -10.354558f, -50.424904f, -10.410928f, -50.475486f, -10.488920f, -50.481633f,
                -10.498349f, -50.509408f, -10.595520f, -50.532919f, -10.662516f, -50.604279f, -10.731887f, -50.574772f, -10.835137f, -50.619708f,
                -10.898648f, -50.602726f, -10.932006f, -50.631639f, -11.073347f, -50.607809f, -11.103888f, -50.644832f, -11.159169f, -50.665274f,
                -11.258700f, -50.660784f, -11.372569f, -50.725989f, -11.396548f, -50.731113f, -11.396548f, -51.569364f
            )
            poly[742] = TzPolygon(
                -13.031307f, -48.633171f, -13.060000f, -48.601000f, -13.123000f, -48.577000f, -13.152000f, -48.596000f, -13.207000f, -48.579000f,
                -13.238000f, -48.600000f, -13.317000f, -48.586000f, -13.302000f, -48.553000f, -13.205000f, -48.554000f, -13.192000f, -48.530000f,
                -13.128000f, -48.508000f, -13.134000f, -48.475000f, -13.234814f, -48.475659f, -13.292320f, -48.441832f, -13.271128f, -48.430019f,
                -13.248304f, -48.340170f, -13.228226f, -48.342154f, -13.236999f, -48.307785f, -13.168814f, -48.230914f, -13.152548f, -48.143361f,
                -13.186969f, -48.165129f, -13.305000f, -48.165000f, -13.288000f, -48.083000f, -13.235000f, -48.062000f, -13.274000f, -48.032000f,
                -13.276000f, -47.986000f, -13.315000f, -47.966000f, -13.290000f, -47.935000f, -13.310698f, -47.899123f, -13.692378f, -47.899123f,
                -13.692378f, -48.633171f
            )
            poly[743] = TzPolygon(
                -13.310698f, -47.899123f, -13.320000f, -47.883000f, -13.311000f, -47.824000f, -13.467000f, -47.679000f, -13.368806f, -47.622118f,
                -13.349036f, -47.650216f, -13.302845f, -47.661556f, -13.264403f, -47.639744f, -13.210806f, -47.667725f, -13.178216f, -47.654164f,
                -13.166202f, -47.668819f, -13.149696f, -47.643778f, -13.102477f, -47.633138f, -13.119460f, -47.564005f, -13.185144f, -47.561570f,
                -13.184793f, -47.478689f, -13.220402f, -47.485932f, -13.233309f, -47.431772f, -13.248632f, -47.454347f, -13.290161f, -47.429135f,
                -13.228877f, -47.376328f, -13.265073f, -47.281528f, -13.194785f, -47.229772f, -13.187514f, -47.183209f, -13.204812f, -47.183917f,
                -13.208176f, -47.165075f, -13.692378f, -47.165075f, -13.692378f, -47.899123f
            )
            poly[744] = TzPolygon(
                -13.208176f, -47.165075f, -13.210202f, -47.153726f, -13.177967f, -47.132268f, -13.181853f, -47.087744f, -13.121655f, -47.002117f,
                -13.131810f, -46.978878f, -13.053000f, -46.892000f, -13.067711f, -46.854772f, -13.002000f, -46.819000f, -12.969000f, -46.750000f,
                -12.971000f, -46.454000f, -12.879016f, -46.431026f, -13.692378f, -46.431026f, -13.692378f, -47.165075f
            )
            poly[745] = TzPolygon(
                -12.544659f, -46.431026f, -12.544706f, -46.256623f, -12.583927f, -46.286191f, -12.636623f, -46.296309f, -12.652466f, -46.260647f,
                -12.691911f, -46.296018f, -12.714567f, -46.267086f, -12.783000f, -46.283000f, -12.833092f, -46.268089f, -12.863353f, -46.300430f,
                -12.949406f, -46.304598f, -12.943699f, -46.216981f, -12.909066f, -46.135060f, -12.921853f, -46.117176f, -12.991000f, -46.364000f,
                -12.863297f, -46.365778f, -12.822720f, -46.416966f, -12.879016f, -46.431026f
            )
            poly[746] = TzPolygon(
                -12.879016f, -46.431026f, -12.822720f, -46.416966f, -12.863297f, -46.365778f, -12.991000f, -46.364000f, -12.956000f, -46.194000f,
                -12.917252f, -46.114515f, -12.960931f, -46.126225f, -13.010559f, -46.275942f, -13.094043f, -46.330551f, -13.139390f, -46.299340f,
                -13.250501f, -46.331131f, -13.255000f, -46.298000f, -13.304257f, -46.315638f, -13.314405f, -46.288966f, -13.347395f, -46.279267f,
                -13.262093f, -46.066965f, -13.277839f, -46.040892f, -13.375547f, -46.134984f, -13.427123f, -46.241372f, -13.465506f, -46.206111f,
                -13.481000f, -46.230000f, -13.560361f, -46.236191f, -13.567620f, -46.184156f, -13.592107f, -46.162055f, -13.687374f, -46.261051f,
                -13.692378f, -46.257237f, -13.692378f, -46.431026f
            )
            poly[747] = TzPolygon(
                -12.544463f, -46.255883f, -12.511466f, -46.155314f, -12.483000f, -46.153000f, -12.500969f, -46.250034f, -12.415971f, -46.269885f,
                -12.406541f, -46.310777f, -12.379000f, -46.285000f, -12.337000f, -46.352000f, -12.303000f, -46.323000f, -12.289000f, -46.374000f,
                -12.247000f, -46.380000f, -12.224000f, -46.359000f, -12.193000f, -46.391000f, -12.111000f, -46.366000f, -12.036639f, -46.397316f,
                -11.958000f, -46.325000f, -11.929000f, -46.192000f, -11.900796f, -46.171040f, -11.883759f, -46.190540f, -11.898000f, -46.318000f,
                -11.872006f, -46.373243f, -11.836000f, -46.373000f, -11.836032f, -46.349033f, -11.770619f, -46.322708f, -11.751000f, -46.373000f,
                -11.737000f, -46.329000f, -11.692000f, -46.294000f, -11.629372f, -46.313570f, -11.621000f, -46.256000f, -11.656607f, -46.154109f,
                -11.636000f, -46.083000f, -11.607222f, -46.114549f, -11.602000f, -46.202000f, -11.567665f, -46.230860f, -11.540957f, -46.305643f,
                -11.541518f, -46.411000f, -11.516339f, -46.479091f, -11.483052f, -46.520390f, -11.396548f, -46.544406f, -11.396548f, -45.696978f,
                -12.544463f, -45.696978f
            )
            poly[748] = TzPolygon(
                -11.396548f, -46.544406f, -11.380000f, -46.549000f, -11.347000f, -46.601000f, -11.289000f, -46.617000f, -11.255000f, -46.609000f,
                -11.191000f, -46.472000f, -10.994000f, -46.399000f, -10.906000f, -46.283000f, -10.867000f, -46.297000f, -10.822576f, -46.281481f,
                -10.797311f, -46.231065f, -10.768737f, -46.228183f, -10.759787f, -46.256394f, -10.718882f, -46.194125f, -10.658943f, -46.207015f,
                -10.487598f, -45.845218f, -10.367447f, -45.827029f, -10.346000f, -45.743000f, -10.263000f, -45.697000f, -11.396548f, -45.696978f
            )
            poly[749] = TzPolygon(-10.248634f, -45.848099f, -10.248634f, -45.764744f, -10.267000f, -45.793000f)
            poly[750] = TzPolygon(-10.248634f, -45.929960f, -10.262038f, -46.003648f, -10.248634f, -46.007856f)
            poly[751] = TzPolygon(
                -10.072974f, -46.431026f, -10.047000f, -46.457000f, -9.988000f, -46.477000f, -9.877000f, -46.472000f, -9.870000f, -46.491000f,
                -9.855000f, -46.480000f, -9.801000f, -46.509000f, -9.805000f, -46.577000f, -9.758000f, -46.575000f, -9.733000f, -46.646000f,
                -9.693000f, -46.653000f, -9.665000f, -46.613000f, -9.587000f, -46.592000f, -9.557000f, -46.536000f, -9.517000f, -46.575000f,
                -9.484000f, -46.561000f, -9.457000f, -46.640000f, -9.411000f, -46.632000f, -9.392000f, -46.666000f, -9.410000f, -46.761000f,
                -9.365000f, -46.768000f, -9.304000f, -46.813000f, -9.292000f, -46.847000f, -9.260000f, -46.819000f, -9.194000f, -46.827000f,
                -9.191000f, -46.850000f, -9.154000f, -46.852000f, -9.122000f, -46.893000f, -9.128000f, -46.931000f, -9.100719f, -46.927536f,
                -9.100719f, -46.431026f
            )
            poly[752] = TzPolygon(-10.248634f, -45.697459f, -10.184369f, -45.699510f, -10.155000f, -45.723000f, -10.144635f, -45.696978f, -10.248634f, -45.696978f)
            poly[753] = TzPolygon(
                -10.248634f, -46.007856f, -10.176344f, -46.030550f, -10.213038f, -46.098648f, -10.214038f, -46.164648f, -10.169000f, -46.210000f,
                -10.183000f, -46.327000f, -10.168000f, -46.367000f, -10.120000f, -46.384000f, -10.072974f, -46.431026f, -9.100719f, -46.431026f,
                -9.100719f, -45.696978f, -10.146481f, -45.696978f, -10.156000f, -45.726000f, -10.228000f, -45.733000f, -10.248634f, -45.764744f,
                -10.248634f, -45.848099f, -10.239000f, -45.877000f, -10.248634f, -45.929960f
            )
            poly[754] = TzPolygon(
                -9.100719f, -49.873703f, -9.027000f, -49.842000f, -8.906170f, -49.745053f, -8.856482f, -49.684323f, -8.839499f, -49.592377f,
                -8.612505f, -49.451439f, -8.580010f, -49.409856f, -8.451000f, -49.374000f, -8.379565f, -49.283292f, -8.175498f, -49.209552f,
                -8.050561f, -49.174851f, -7.976973f, -49.181999f, -7.807000f, -49.148000f, -7.677804f, -49.328050f, -7.546167f, -49.383926f,
                -7.497000f, -49.378000f, -7.325000f, -49.231000f, -7.235182f, -49.185257f, -6.925000f, -49.209000f, -6.784000f, -49.018000f,
                -6.754000f, -48.832000f, -6.678000f, -48.682000f, -6.639963f, -48.651939f, -6.570583f, -48.664336f, -6.507020f, -48.645319f,
                -6.493425f, -48.633171f, -9.100719f, -48.633171f
            )
            poly[755] = TzPolygon(-5.406690f, -48.633171f, -5.352899f, -48.756746f, -5.351000f, -48.708000f, -5.305000f, -48.679000f, -5.324462f, -48.633171f)
            poly[756] = TzPolygon(-5.324462f, -48.633171f, -5.305000f, -48.679000f, -5.351000f, -48.708000f, -5.349680f, -48.756078f, -5.253833f, -48.633171f)
            poly[757] = TzPolygon(
                -7.878427f, -47.165075f, -7.855996f, -47.175725f, -7.816251f, -47.245438f, -7.758117f, -47.246762f, -7.760829f, -47.267205f,
                -7.730288f, -47.275092f, -7.730635f, -47.314195f, -7.690078f, -47.302592f, -7.666745f, -47.338576f, -7.659538f, -47.315140f,
                -7.616037f, -47.358027f, -7.624544f, -47.373729f, -7.648132f, -47.353403f, -7.654268f, -47.382371f, -7.568361f, -47.399248f,
                -7.556380f, -47.439519f, -7.527798f, -47.425125f, -7.518483f, -47.461732f, -7.533825f, -47.475309f, -7.439870f, -47.501588f,
                -7.439316f, -47.591812f, -7.372367f, -47.487733f, -7.298306f, -47.496660f, -7.267826f, -47.532880f, -7.265102f, -47.588670f,
                -7.305968f, -47.647722f, -7.249436f, -47.680166f, -7.202985f, -47.747027f, -7.161428f, -47.742392f, -7.142181f, -47.715956f,
                -7.144396f, -47.643000f, -6.985452f, -47.531935f, -6.907237f, -47.506701f, -6.833442f, -47.529703f, -6.804889f, -47.516896f,
                -6.804889f, -47.165075f
            )
            poly[758] = TzPolygon(
                -7.878427f, -47.165075f, -7.924883f, -47.143017f, -7.937121f, -47.108279f, -7.990091f, -47.107681f, -7.998242f, -47.067543f,
                -8.053163f, -47.045541f, -8.066565f, -46.997502f, -8.005942f, -46.953601f, -7.985700f, -46.895493f, -7.955249f, -46.872846f,
                -7.964359f, -46.830455f, -7.922890f, -46.756394f, -7.896000f, -46.614000f, -7.920000f, -46.562000f, -8.012000f, -46.477000f,
                -8.074000f, -46.467000f, -8.166000f, -46.514000f, -8.200000f, -46.487000f, -8.270000f, -46.507000f, -8.319000f, -46.543000f,
                -8.321000f, -46.641000f, -8.351000f, -46.706000f, -8.383000f, -46.726000f, -8.368000f, -46.782000f, -8.399000f, -46.787000f,
                -8.399000f, -46.806000f, -8.446000f, -46.796000f, -8.476000f, -46.851000f, -8.533000f, -46.846000f, -8.595000f, -46.916000f,
                -8.601000f, -46.897000f, -8.648000f, -46.916000f, -8.686000f, -46.887000f, -8.726000f, -46.931000f, -8.778000f, -46.904000f,
                -8.847000f, -46.913000f, -8.880000f, -46.993000f, -8.914000f, -46.970000f, -8.953000f, -47.018000f, -8.988000f, -47.021000f,
                -8.979000f, -47.035000f, -9.012000f, -47.068000f, -9.026000f, -47.043000f, -9.063000f, -47.068000f, -9.082000f, -47.007000f,
                -9.065000f, -46.923000f, -9.100719f, -46.927536f, -9.100719f, -47.165075f
            )
            poly[759] = TzPolygon(
                -5.656975f, -48.633171f, -5.656975f, -48.156071f, -5.709958f, -48.173579f, -5.725504f, -48.272526f, -5.751209f, -48.293495f,
                -5.839441f, -48.290797f, -5.946152f, -48.231613f, -6.004288f, -48.334699f, -6.038282f, -48.332694f, -6.070405f, -48.285771f,
                -6.116904f, -48.303836f, -6.177306f, -48.431919f, -6.298599f, -48.417104f, -6.328617f, -48.381163f, -6.375638f, -48.381301f,
                -6.350940f, -48.500196f, -6.453741f, -48.613134f, -6.496713f, -48.633171f
            )
            poly[760] = TzPolygon(
                -6.804889f, -47.516896f, -6.753839f, -47.493998f, -6.661265f, -47.496229f, -6.488004f, -47.417265f, -6.429839f, -47.433230f,
                -6.266000f, -47.377000f, -6.112000f, -47.433000f, -6.039000f, -47.428000f, -5.993000f, -47.448000f, -5.869000f, -47.431000f,
                -5.730000f, -47.493000f, -5.662000f, -47.473000f, -5.656975f, -47.473990f, -5.656975f, -47.165075f, -6.804889f, -47.165075f
            )
            poly[761] = TzPolygon(
                -5.656975f, -48.149720f, -5.618144f, -48.132234f, -5.554253f, -48.212586f, -5.523020f, -48.300691f, -5.395996f, -48.381593f,
                -5.429833f, -48.513886f, -5.422558f, -48.596716f, -5.406690f, -48.633171f, -5.324462f, -48.633171f, -5.336000f, -48.606000f,
                -5.283000f, -48.568000f, -5.230000f, -48.561000f, -5.193000f, -48.523000f, -5.168000f, -48.363000f, -5.260000f, -48.178000f,
                -5.275000f, -48.079000f, -5.234000f, -48.004000f, -5.260000f, -47.885000f, -5.376000f, -47.843000f, -5.380000f, -47.744000f,
                -5.459000f, -47.618000f, -5.465000f, -47.555000f, -5.565000f, -47.483000f, -5.656975f, -47.473518f
            )
            poly[762] = TzPolygon(
                -4.509060f, -47.577612f, -4.557372f, -47.611933f, -4.608632f, -47.679948f, -4.586425f, -47.792559f, -5.070390f, -48.396258f,
                -5.073671f, -48.440315f, -5.098137f, -48.433519f, -5.253833f, -48.633171f, -4.509060f, -48.633171f
            )
            poly[763] = TzPolygon(
                -5.397041f, -48.633171f, -5.422558f, -48.596716f, -5.429833f, -48.513886f, -5.395996f, -48.381593f, -5.523020f, -48.300691f,
                -5.602704f, -48.138137f, -5.656975f, -48.156071f, -5.656975f, -48.633171f
            )
            poly[764] = TzPolygon(
                -4.509060f, -47.577612f, -4.403721f, -47.502780f, -4.315058f, -47.474727f, -4.245600f, -47.371761f, -4.048590f, -47.320411f,
                -4.058926f, -47.304202f, -3.997500f, -47.240367f, -3.983435f, -47.188670f, -3.923936f, -47.172673f, -3.918023f, -47.165075f,
                -4.509060f, -47.165075f
            )
            poly[765] = TzPolygon(
                -3.361145f, -47.165075f, -3.361145f, -46.911764f, -3.377694f, -46.943736f, -3.477093f, -46.947728f, -3.494726f, -46.981203f,
                -3.529812f, -46.975664f, -3.562288f, -47.038954f, -3.599278f, -47.027046f, -3.655079f, -47.056735f, -3.668470f, -47.037169f,
                -3.855893f, -47.085241f, -3.918023f, -47.165075f
            )
            poly[766] = TzPolygon(
                -3.361145f, -46.911764f, -3.310148f, -46.813238f, -3.297896f, -46.826665f, -3.243889f, -46.804763f, -3.215703f, -46.754245f,
                -3.178230f, -46.771359f, -3.189384f, -46.750557f, -3.165592f, -46.748191f, -3.157460f, -46.720290f, -3.122403f, -46.747861f,
                -3.109215f, -46.719025f, -3.126579f, -46.705322f, -3.101247f, -46.706478f, -3.094763f, -46.675825f, -3.034810f, -46.677751f,
                -3.012059f, -46.657500f, -2.998650f, -46.672964f, -2.996397f, -46.651171f, -2.970537f, -46.646776f, -2.948735f, -46.670899f,
                -2.931028f, -46.653691f, -2.882774f, -46.679822f, -2.880112f, -46.633950f, -2.851671f, -46.639798f, -2.858185f, -46.612505f,
                -2.829515f, -46.613419f, -2.842045f, -46.574537f, -2.789393f, -46.601788f, -2.805077f, -46.619194f, -2.792297f, -46.637056f,
                -2.754124f, -46.635727f, -2.758107f, -46.650516f, -2.729103f, -46.652260f, -2.733211f, -46.673820f, -2.705767f, -46.669487f,
                -2.684148f, -46.632723f, -2.643855f, -46.616895f, -2.665516f, -46.591347f, -2.633383f, -46.580935f, -2.615871f, -46.505995f,
                -2.536897f, -46.488630f, -2.534345f, -46.431026f, -3.361145f, -46.431026f
            )
            poly[767] = TzPolygon(-2.473229f, -46.431026f, -2.418928f, -46.441536f, -2.403426f, -46.431026f)
            poly[768] = TzPolygon(-2.372118f, -46.431026f, -2.374343f, -46.466752f, -2.332935f, -46.431026f)
            poly[769] = TzPolygon(-2.213230f, -46.344550f, -2.249627f, -46.382844f, -2.237261f, -46.431026f, -2.213230f, -46.431026f)
            poly[770] = TzPolygon(-2.237850f, -46.431026f, -2.270263f, -46.415345f, -2.332935f, -46.431026f)
            poly[771] = TzPolygon(-2.372118f, -46.431026f, -2.370737f, -46.408864f, -2.403426f, -46.431026f)
            poly[772] = TzPolygon(-2.473229f, -46.431026f, -2.533826f, -46.419298f, -2.534345f, -46.431026f)
            poly[773] = TzPolygon(
                -2.213230f, -46.344550f, -2.154732f, -46.283003f, -2.140406f, -46.302664f, -2.119064f, -46.271699f, -2.055695f, -46.274354f,
                -1.914142f, -46.222282f, -1.882624f, -46.244494f, -1.832465f, -46.210261f, -1.795441f, -46.255300f, -1.805730f, -46.311426f,
                -1.761297f, -46.322212f, -1.728546f, -46.303525f, -1.732026f, -46.221973f, -1.681433f, -46.156636f, -1.629189f, -46.164451f,
                -1.579437f, -46.133064f, -1.517989f, -46.143580f, -1.474909f, -46.175964f, -1.441682f, -46.138480f, -1.420988f, -46.153623f,
                -1.337668f, -46.103532f, -1.332389f, -46.130347f, -1.285547f, -46.160436f, -1.247109f, -46.139842f, -1.227820f, -46.151203f,
                -1.201486f, -46.094943f, -0.759383f, -45.943794f, -0.832976f, -45.696978f, -2.213230f, -45.696978f
            )
            poly[774] = TzPolygon(
                -10.477527f, -45.422756f, -10.477527f, -44.026742f, -10.582053f, -44.074150f, -10.644000f, -44.153000f, -10.615000f, -44.208000f,
                -10.624000f, -44.264000f, -10.548000f, -44.333000f, -10.606000f, -44.398000f, -10.606193f, -44.452010f, -10.650000f, -44.504000f,
                -10.626000f, -44.577000f, -10.670695f, -44.617842f, -10.682000f, -44.666000f, -10.761741f, -44.669426f, -10.775770f, -44.743468f,
                -10.804000f, -44.759000f, -10.808000f, -44.788000f, -10.900000f, -44.844000f, -10.883040f, -44.859037f, -10.928056f, -44.931457f,
                -10.840268f, -45.073164f, -10.822000f, -45.248000f, -10.775873f, -45.268381f, -10.732000f, -45.358000f, -10.653676f, -45.382851f,
                -10.629463f, -45.432561f, -10.559340f, -45.446847f, -10.507000f, -45.447000f
            )
            poly[775] = TzPolygon(
                -10.477527f, -45.422756f, -10.445000f, -45.396000f, -10.421081f, -45.426411f, -10.360000f, -45.430000f, -10.281999f, -45.520890f,
                -10.111557f, -45.590503f, -10.146481f, -45.696978f, -7.262677f, -45.696978f, -7.262677f, -42.929790f, -9.521088f, -42.929790f,
                -9.518000f, -42.946000f, -9.405803f, -42.975005f, -9.419000f, -43.057000f, -9.394160f, -43.062035f, -9.371000f, -43.119000f,
                -9.378729f, -43.160720f, -9.420000f, -43.191000f, -9.399618f, -43.213944f, -9.424215f, -43.280005f, -9.356036f, -43.369740f,
                -9.272000f, -43.427000f, -9.265000f, -43.485000f, -9.414411f, -43.680771f, -9.446293f, -43.776005f, -9.550014f, -43.851280f,
                -9.637000f, -43.842000f, -9.692000f, -43.799000f, -9.762000f, -43.785000f, -9.839000f, -43.653000f, -9.913000f, -43.709000f,
                -9.929000f, -43.690000f, -9.966000f, -43.703000f, -10.008968f, -43.661865f, -10.077000f, -43.693000f, -10.079821f, -43.765831f,
                -10.179861f, -43.779005f, -10.250661f, -43.837480f, -10.304000f, -43.838000f, -10.383785f, -43.914419f, -10.428977f, -43.918148f,
                -10.432416f, -43.973781f, -10.407645f, -44.023301f, -10.477527f, -44.026742f
            )
            poly[776] = TzPolygon(
                -9.522465f, -42.929790f, -9.526000f, -42.904000f, -9.563117f, -42.873630f, -9.550000f, -42.837000f, -9.620605f, -42.819823f,
                -9.619662f, -42.771478f, -9.558000f, -42.718000f, -9.531000f, -42.720000f, -9.549000f, -42.680000f, -9.541604f, -42.623740f,
                -9.496000f, -42.586000f, -9.493000f, -42.491000f, -9.462000f, -42.489000f, -9.456000f, -42.440000f, -9.411307f, -42.420782f,
                -9.377000f, -42.359000f, -9.316404f, -42.316777f, -9.283625f, -42.234362f, -9.286630f, -42.132157f, -9.249000f, -42.022000f,
                -9.266000f, -42.000000f, -9.248000f, -41.972000f, -9.278845f, -41.921380f, -9.237000f, -41.870000f, -9.242000f, -41.838000f,
                -9.148000f, -41.800000f, -9.094000f, -41.735000f, -9.016255f, -41.726838f, -9.012000f, -41.680000f, -8.957000f, -41.605000f,
                -8.959892f, -41.546196f, -10.477527f, -41.546196f, -10.477527f, -42.929790f
            )
            poly[777] = TzPolygon(-8.870102f, -41.505075f, -8.960000f, -41.544000f, -8.959892f, -41.546196f, -8.870102f, -41.546196f)
            poly[778] = TzPolygon(
                -8.870102f, -40.899999f, -8.870102f, -40.162602f, -9.087664f, -40.162602f, -9.053620f, -40.226410f, -9.064809f, -40.257343f,
                -9.355719f, -40.340339f, -9.373324f, -40.380828f, -9.353749f, -40.423192f, -9.420253f, -40.466160f, -9.405802f, -40.516439f,
                -9.458309f, -40.555593f, -9.476359f, -40.619373f, -9.444059f, -40.721872f, -9.448434f, -40.775842f, -9.401902f, -40.742315f,
                -9.336000f, -40.737000f, -9.313000f, -40.755000f, -9.278000f, -40.687000f, -9.233162f, -40.694383f, -9.159000f, -40.667000f,
                -9.081863f, -40.819049f, -8.952000f, -40.851000f
            )
            poly[779] = TzPolygon(
                -8.870102f, -41.505075f, -8.863000f, -41.502000f, -8.802000f, -41.424000f, -8.707000f, -41.381000f, -8.736100f, -41.281538f,
                -8.704702f, -41.226978f, -8.703797f, -41.113710f, -8.752674f, -41.124569f, -8.781964f, -41.101761f, -8.785876f, -41.036234f,
                -8.843561f, -41.021241f, -8.823417f, -40.979094f, -8.843379f, -40.955093f, -8.835000f, -40.921000f, -8.870102f, -40.899999f
            )
            poly[780] = TzPolygon(
                -8.066389f, -41.546196f, -8.066389f, -40.590084f, -8.095330f, -40.603123f, -8.138808f, -40.589698f, -8.139449f, -40.633951f,
                -8.223494f, -40.707256f, -8.253304f, -40.782482f, -8.301933f, -40.779880f, -8.321909f, -40.819509f, -8.363494f, -40.820098f,
                -8.380528f, -40.850212f, -8.357310f, -40.893472f, -8.421627f, -40.901535f, -8.446326f, -40.925149f, -8.400300f, -40.999953f,
                -8.436657f, -41.043718f, -8.480474f, -41.051099f, -8.472503f, -41.078927f, -8.518533f, -41.095584f, -8.541956f, -41.126733f,
                -8.533119f, -41.149250f, -8.583091f, -41.168746f, -8.601820f, -41.212288f, -8.644155f, -41.213543f, -8.660839f, -41.287434f,
                -8.708357f, -41.336917f, -8.707000f, -41.381000f, -8.802000f, -41.424000f, -8.863000f, -41.502000f, -8.870102f, -41.505075f,
                -8.870102f, -41.546196f
            )
            poly[781] = TzPolygon(
                -8.066389f, -40.590084f, -7.964597f, -40.544222f, -7.845993f, -40.540459f, -7.808759f, -40.568405f, -7.764829f, -40.672072f,
                -7.651360f, -40.621990f, -7.484437f, -40.715536f, -7.456356f, -40.701201f, -7.392691f, -40.548464f, -7.318450f, -40.523723f,
                -7.368168f, -40.393878f, -7.303000f, -40.318000f, -7.301000f, -40.263000f, -7.358000f, -40.195000f, -7.365500f, -40.162602f,
                -8.066389f, -40.162602f
            )
            poly[782] = TzPolygon(
                -10.996508f, -38.150959f, -10.989100f, -38.169865f, -10.943094f, -38.180882f, -10.915598f, -38.227116f, -10.823000f, -38.245000f,
                -10.760454f, -38.209420f, -10.711876f, -38.209194f, -10.713416f, -38.150959f
            )
            poly[783] = TzPolygon(
                -10.477527f, -37.830002f, -10.507128f, -37.812934f, -10.549990f, -37.840595f, -10.691000f, -37.814000f, -10.759000f, -37.985000f,
                -10.696816f, -38.049217f, -10.715615f, -38.067819f, -10.713416f, -38.150959f, -10.477527f, -38.150959f
            )
            poly[784] = TzPolygon(
                -10.996508f, -38.150959f, -11.015465f, -38.102576f, -11.171866f, -38.062035f, -11.193788f, -37.973766f, -11.271176f, -37.986544f,
                -11.285007f, -38.014922f, -11.374263f, -37.969081f, -11.392738f, -37.977837f, -11.394521f, -37.952903f, -11.424283f, -37.944280f,
                -11.401494f, -37.927887f, -11.407926f, -37.905827f, -11.438341f, -37.898936f, -11.426324f, -37.867360f, -11.433506f, -37.880199f,
                -11.443227f, -37.847884f, -11.466675f, -37.864241f, -11.496979f, -37.808704f, -11.516852f, -37.812183f, -11.525184f, -37.757500f,
                -11.553604f, -37.726724f, -11.540075f, -37.702440f, -11.566795f, -37.689527f, -11.564462f, -37.669953f, -11.516666f, -37.651076f,
                -11.538825f, -37.614597f, -11.531555f, -37.580674f, -11.551977f, -37.578490f, -11.548601f, -37.519892f, -11.443058f, -37.345636f,
                -11.566876f, -37.188891f, -12.342119f, -37.602013f, -12.758442f, -37.896682f, -13.023639f, -38.150959f
            )
            poly[785] = TzPolygon(
                -8.870102f, -39.900631f, -8.946297f, -39.881876f, -9.050080f, -39.960302f, -9.058922f, -40.066717f, -9.104982f, -40.130142f,
                -9.087664f, -40.162602f, -8.870102f, -40.162602f
            )
            poly[786] = TzPolygon(
                -10.477527f, -37.830002f, -10.427441f, -37.858882f, -10.378628f, -37.838096f, -10.332944f, -37.734469f, -10.003340f, -37.827808f,
                -9.971000f, -37.957000f, -9.916000f, -37.997000f, -9.816323f, -37.966554f, -9.770450f, -38.032473f, -9.697284f, -38.045032f,
                -9.673815f, -38.017995f, -9.673815f, -37.395413f, -10.477527f, -37.395413f
            )
            poly[787] = TzPolygon(
                -9.440806f, -38.087210f, -9.441517f, -38.153353f, -9.417717f, -38.204447f, -9.384757f, -38.194388f, -9.329000f, -38.237000f,
                -9.284869f, -38.173426f, -9.217604f, -38.144180f, -9.174213f, -38.093824f, -9.173042f, -38.087210f
            )
            poly[788] = TzPolygon(
                -8.870102f, -38.087210f, -9.173042f, -38.087210f, -9.174213f, -38.093824f, -9.217604f, -38.144180f, -9.284869f, -38.173426f,
                -9.329000f, -38.237000f, -9.141890f, -38.313040f, -9.076336f, -38.318599f, -9.043619f, -38.285984f, -9.013298f, -38.297412f,
                -8.987093f, -38.331130f, -9.044636f, -38.398937f, -9.020046f, -38.472949f, -8.960360f, -38.510792f, -8.870102f, -38.480187f
            )
            poly[789] = TzPolygon(-8.870102f, -38.587455f, -8.936987f, -38.605652f, -8.988009f, -38.647331f, -8.967323f, -38.679775f, -8.870102f, -38.700880f)
            poly[790] = TzPolygon(
                -9.440806f, -38.087210f, -9.440725f, -38.079699f, -9.498061f, -37.999748f, -9.599740f, -38.040243f, -9.647294f, -37.987442f,
                -9.673815f, -38.017995f, -9.673815f, -38.087210f
            )
            poly[791] = TzPolygon(
                -8.870102f, -37.798192f, -8.884960f, -37.825003f, -8.974046f, -37.834476f, -9.154820f, -37.984325f, -9.173042f, -38.087210f,
                -8.870102f, -38.087210f
            )
            poly[792] = TzPolygon(
                -9.025042f, -37.395413f, -9.009283f, -37.410992f, -8.993360f, -37.493205f, -8.968132f, -37.499862f, -8.959930f, -37.531377f,
                -8.969040f, -37.597362f, -9.003746f, -37.637978f, -8.991062f, -37.698244f, -8.974468f, -37.672228f, -8.870102f, -37.739949f,
                -8.870102f, -37.395413f
            )
            poly[793] = TzPolygon(
                -8.870102f, -39.900631f, -8.859220f, -39.903309f, -8.827261f, -39.891612f, -8.785954f, -39.675018f, -8.659776f, -39.694122f,
                -8.656109f, -39.610345f, -8.526006f, -39.383090f, -8.556779f, -39.344434f, -8.568614f, -39.274847f, -8.687226f, -39.216939f,
                -8.681626f, -39.182950f, -8.709840f, -39.146651f, -8.734273f, -39.036960f, -8.798403f, -38.953875f, -8.783810f, -38.793415f,
                -8.796716f, -38.779007f, -8.870102f, -38.779007f
            )
            poly[794] = TzPolygon(
                -7.365500f, -40.162602f, -7.383000f, -40.087000f, -7.325210f, -39.851448f, -7.335000f, -39.715000f, -7.372000f, -39.653000f,
                -7.425000f, -39.629000f, -7.430746f, -39.571274f, -7.483942f, -39.545853f, -7.464000f, -39.502000f, -7.474000f, -39.458000f,
                -7.538000f, -39.485000f, -7.575000f, -39.472000f, -7.573000f, -39.435000f, -7.604000f, -39.419000f, -7.614000f, -39.372000f,
                -7.666000f, -39.305000f, -7.660159f, -39.272504f, -7.705000f, -39.252000f, -7.689000f, -39.208000f, -7.723549f, -39.135682f,
                -7.775792f, -39.099994f, -7.857991f, -39.091019f, -7.819305f, -39.053756f, -7.812238f, -39.015771f, -7.840219f, -39.001137f,
                -7.844007f, -38.961835f, -7.758000f, -38.939000f, -7.747000f, -38.881000f, -7.711000f, -38.869000f, -7.719000f, -38.828000f,
                -7.664000f, -38.819000f, -7.661922f, -38.779007f, -8.066389f, -38.779007f, -8.066389f, -40.162602f
            )
            poly[795] = TzPolygon(-8.796716f, -38.779007f, -8.870102f, -38.697086f, -8.870102f, -38.779007f)
            poly[796] = TzPolygon(
                -8.870102f, -38.596874f, -8.859881f, -38.594353f, -8.821451f, -38.556775f, -8.819460f, -38.526378f, -8.861840f, -38.477386f,
                -8.870102f, -38.481186f
            )
            poly[797] = TzPolygon(
                -7.357409f, -37.395413f, -7.364822f, -37.496038f, -7.395054f, -37.486958f, -7.472953f, -37.533067f, -7.532511f, -37.630378f,
                -7.523137f, -37.659530f, -7.550584f, -37.706506f, -7.619522f, -37.755848f, -7.662889f, -37.750648f, -7.625798f, -37.785828f,
                -7.651969f, -37.857159f, -7.694737f, -37.902747f, -7.713626f, -37.894335f, -7.715112f, -37.923935f, -7.777577f, -37.970600f,
                -7.748000f, -38.039000f, -7.772324f, -38.069478f, -7.830000f, -38.077000f, -7.779909f, -38.164219f, -7.830726f, -38.238571f,
                -7.830922f, -38.285707f, -7.763196f, -38.299817f, -7.764607f, -38.316760f, -7.716313f, -38.312029f, -7.677162f, -38.357496f,
                -7.730493f, -38.409508f, -7.717581f, -38.455018f, -7.751482f, -38.500548f, -7.755681f, -38.589958f, -7.677637f, -38.642084f,
                -7.621919f, -38.715113f, -7.660000f, -38.742000f, -7.661922f, -38.779007f, -7.262677f, -38.779007f, -7.262677f, -37.395413f
            )
            poly[798] = TzPolygon(-8.870102f, -37.798287f, -8.846362f, -37.755354f, -8.870102f, -37.739949f)
            poly[799] = TzPolygon(
                -8.870102f, -37.395413f, -8.870102f, -35.918307f, -8.902397f, -35.963395f, -8.915000f, -36.064000f, -8.955000f, -36.126000f,
                -9.017000f, -36.111000f, -9.044786f, -36.195725f, -9.103490f, -36.236458f, -9.103924f, -36.268391f, -9.171277f, -36.262445f,
                -9.172362f, -36.309791f, -9.220000f, -36.353000f, -9.229569f, -36.419799f, -9.212100f, -36.437004f, -9.262408f, -36.491338f,
                -9.292583f, -36.571840f, -9.332135f, -36.567469f, -9.341508f, -36.605047f, -9.271457f, -36.761772f, -9.288628f, -36.836041f,
                -9.268084f, -36.871259f, -9.299021f, -36.915820f, -9.383022f, -36.946486f, -9.352613f, -37.003364f, -9.315715f, -37.024290f,
                -9.317540f, -37.057584f, -9.281788f, -37.057200f, -9.246362f, -37.090672f, -9.240931f, -37.116475f, -9.275705f, -37.164334f,
                -9.239102f, -37.158947f, -9.215482f, -37.198315f, -9.240000f, -37.234000f, -9.160000f, -37.262000f, -9.025042f, -37.395413f
            )
        }
    }

    private object Initializer9 {
        fun init() {
            poly[800] = TzPolygon(-8.870102f, -34.914857f, -8.989445f, -34.963436f, -8.913959f, -35.154664f, -8.890561f, -35.171232f, -8.870102f, -35.288689f)
            poly[801] = TzPolygon(-8.870102f, -35.614737f, -8.882510f, -35.633650f, -8.916685f, -35.748088f, -8.897076f, -35.782670f, -8.870102f, -35.777838f)
            poly[802] = TzPolygon(-8.870102f, -35.837774f, -8.872459f, -35.842204f, -8.870102f, -35.849200f)
            poly[803] = TzPolygon(
                -8.066389f, -37.146464f, -8.066389f, -36.641486f, -8.079809f, -36.658682f, -8.111050f, -36.628612f, -8.140773f, -36.693862f,
                -8.155679f, -36.687036f, -8.150965f, -36.722810f, -8.167316f, -36.715781f, -8.196294f, -36.761570f, -8.190509f, -36.797395f,
                -8.240820f, -36.895950f, -8.299273f, -36.954629f, -8.302955f, -36.991154f, -8.264560f, -37.043334f, -8.266374f, -37.081202f,
                -8.230102f, -37.067418f, -8.233707f, -37.100428f, -8.209066f, -37.122915f, -8.175352f, -37.118260f, -8.165762f, -37.163616f,
                -8.117945f, -37.142558f
            )
            poly[804] = TzPolygon(
                -7.357409f, -37.395413f, -7.356694f, -37.385714f, -7.337028f, -37.349512f, -7.288283f, -37.330586f, -7.272954f, -37.241907f,
                -7.336595f, -37.165341f, -7.386044f, -37.025623f, -7.440197f, -37.021226f, -7.482262f, -36.984226f, -7.518336f, -37.087455f,
                -7.574715f, -37.163569f, -7.635298f, -37.197946f, -7.741934f, -37.140003f, -7.779844f, -37.151951f, -7.819002f, -37.243656f,
                -7.842250f, -37.222093f, -7.846804f, -37.247150f, -7.874900f, -37.244648f, -7.910502f, -37.322172f, -7.934176f, -37.308976f,
                -7.946644f, -37.349904f, -7.974956f, -37.357368f, -7.960598f, -37.192676f, -7.982867f, -37.193395f, -8.015264f, -37.150338f,
                -8.066389f, -37.146464f, -8.066389f, -37.395413f
            )
            poly[805] = TzPolygon(
                -8.066389f, -36.641486f, -8.055749f, -36.627852f, -7.947897f, -36.611877f, -7.957434f, -36.573482f, -7.900998f, -36.563879f,
                -7.924763f, -36.480136f, -7.915283f, -36.444110f, -7.815778f, -36.424048f, -7.806687f, -36.309131f, -7.832077f, -36.261333f,
                -7.817681f, -36.240012f, -7.792145f, -36.252000f, -7.764104f, -36.216634f, -7.789903f, -36.200958f, -7.779056f, -36.080932f,
                -7.807344f, -36.011819f, -8.066389f, -36.011819f
            )
            poly[806] = TzPolygon(
                -7.500578f, -34.628225f, -7.579204f, -34.634021f, -7.538311f, -34.959296f, -7.461997f, -34.985000f, -7.398000f, -35.070000f,
                -7.397943f, -35.190783f, -7.374681f, -35.248589f, -7.406804f, -35.335021f, -7.440261f, -35.351103f, -7.471900f, -35.414605f,
                -7.453411f, -35.450370f, -7.482206f, -35.494312f, -7.580643f, -35.537272f, -7.585021f, -35.515194f, -7.621666f, -35.531687f,
                -7.643247f, -35.515070f, -7.654818f, -35.532812f, -7.653779f, -35.609662f, -7.695248f, -35.646429f, -7.707551f, -35.683556f,
                -7.691000f, -35.700000f, -7.738000f, -35.780000f, -7.750055f, -35.873721f, -7.792000f, -35.905000f, -7.789000f, -35.970000f,
                -7.813000f, -35.998000f, -7.807344f, -36.011819f, -7.262677f, -36.011819f, -7.262677f, -34.628225f
            )
            poly[807] = TzPolygon(-8.870102f, -35.918555f, -8.854268f, -35.896200f, -8.870102f, -35.849200f)
            poly[808] = TzPolygon(-8.870102f, -35.837928f, -8.846933f, -35.795899f, -8.857991f, -35.775669f, -8.870102f, -35.777838f)
            poly[809] = TzPolygon(-8.870102f, -35.614737f, -8.820224f, -35.538710f, -8.813128f, -35.470125f, -8.841230f, -35.454446f, -8.870102f, -35.288689f)
            poly[810] = TzPolygon(-12.365968f, -64.499112f, -12.352837f, -64.513848f, -12.307635f, -64.499112f)
            poly[811] = TzPolygon(
                -12.271131f, -64.499112f, -12.224617f, -64.512818f, -12.240862f, -64.553698f, -12.209966f, -64.576442f, -12.182029f, -64.704142f,
                -12.106357f, -64.709650f, -12.106357f, -64.499112f
            )
            poly[812] = TzPolygon(-12.106357f, -64.727094f, -12.153883f, -64.762605f, -12.106357f, -64.759576f)
            poly[813] = TzPolygon(
                -12.106357f, -64.499112f, -12.106357f, -64.709650f, -12.085084f, -64.711199f, -12.106357f, -64.727094f, -12.106357f, -64.759576f,
                -12.096270f, -64.758933f, -12.086325f, -64.803680f, -12.009934f, -64.841233f, -12.026686f, -64.917729f, -11.992795f, -64.946952f,
                -12.018429f, -64.977854f, -11.996007f, -65.033496f, -11.962479f, -65.042237f, -11.925706f, -65.020423f, -11.888924f, -65.029705f,
                -11.872954f, -65.070546f, -11.791463f, -65.059477f, -11.708204f, -65.086718f, -11.722659f, -65.189838f, -11.756092f, -65.182161f,
                -11.710531f, -65.259304f, -11.647631f, -65.215687f, -11.604841f, -65.234130f, -11.528565f, -65.211777f, -11.496155f, -65.308524f,
                -11.336877f, -65.332515f, -11.320296f, -65.290214f, -11.304439f, -65.346360f, -11.220303f, -65.359926f, -11.195782f, -65.312944f,
                -11.186160f, -65.352080f, -11.146774f, -65.362137f, -11.115156f, -65.343426f, -11.090091f, -65.282689f, -11.031416f, -65.300713f,
                -10.985063f, -65.250529f, -10.954286f, -65.272973f, -10.873020f, -65.274764f, -10.797576f, -65.366613f, -10.767308f, -65.343226f,
                -10.681551f, -65.346670f, -10.639345f, -65.405689f, -10.574560f, -65.399380f, -10.520335f, -65.417995f, -10.520335f, -64.499112f
            )
            poly[814] = TzPolygon(-12.607694f, -63.438697f, -12.607484f, -63.440830f, -12.580776f, -63.438697f)
            poly[815] = TzPolygon(
                -12.564317f, -63.438697f, -12.565669f, -63.504103f, -12.505207f, -63.556113f, -12.427762f, -63.785395f, -12.462080f, -63.834380f,
                -12.445841f, -63.889051f, -12.503000f, -63.901022f, -12.529773f, -63.955007f, -12.501491f, -63.992648f, -12.516684f, -64.038730f,
                -12.483483f, -64.093717f, -12.505066f, -64.124276f, -12.476336f, -64.132904f, -12.513517f, -64.167248f, -12.466398f, -64.173935f,
                -12.453638f, -64.230675f, -12.501809f, -64.290626f, -12.457403f, -64.294789f, -12.444235f, -64.411279f, -12.365968f, -64.499112f,
                -12.307635f, -64.499112f, -12.290305f, -64.493463f, -12.271131f, -64.499112f, -12.106357f, -64.499112f, -12.106357f, -63.438697f
            )
            poly[816] = TzPolygon(
                -13.137830f, -62.378281f, -13.134210f, -62.392789f, -13.112436f, -62.398914f, -13.127748f, -62.415131f, -13.061647f, -62.458321f,
                -13.082214f, -62.504195f, -13.042912f, -62.609928f, -13.015035f, -62.599686f, -13.014799f, -62.630778f, -12.964470f, -62.648866f,
                -13.002801f, -62.701571f, -13.008484f, -62.780986f, -12.940761f, -62.805431f, -12.948139f, -62.847673f, -12.923906f, -62.843354f,
                -12.908358f, -62.872382f, -12.855820f, -62.894137f, -12.839220f, -62.927814f, -12.859513f, -62.976143f, -12.835793f, -63.011697f,
                -12.741199f, -63.046459f, -12.723104f, -63.081902f, -12.686117f, -63.061626f, -12.682390f, -63.098465f, -12.655099f, -63.084272f,
                -12.624739f, -63.114698f, -12.637820f, -63.146179f, -12.612935f, -63.160901f, -12.642617f, -63.168152f, -12.623117f, -63.193972f,
                -12.657564f, -63.198600f, -12.663512f, -63.248008f, -12.689157f, -63.235712f, -12.682514f, -63.296871f, -12.658589f, -63.374306f,
                -12.610331f, -63.411864f, -12.607694f, -63.438697f, -12.564290f, -63.437380f, -12.564317f, -63.438697f, -12.106357f, -63.438697f,
                -12.106357f, -62.378281f
            )
            poly[817] = TzPolygon(
                -9.727325f, -66.619944f, -9.727325f, -65.559528f, -9.806452f, -65.559528f, -9.811317f, -65.565034f, -9.845653f, -65.560742f,
                -9.843351f, -65.597146f, -9.825378f, -65.599841f, -9.838042f, -65.627003f, -9.781288f, -65.669630f, -9.813695f, -65.688837f,
                -9.808573f, -65.710231f, -9.769413f, -65.708825f, -9.767458f, -65.680474f, -9.749925f, -65.683947f, -9.782964f, -65.743200f,
                -9.734417f, -65.770134f, -9.792952f, -65.794374f, -9.772557f, -65.813511f, -9.757469f, -65.799052f, -9.755513f, -65.816488f,
                -9.791136f, -65.841153f, -9.793231f, -65.870355f, -9.767248f, -65.862487f, -9.752230f, -65.886090f, -9.771736f, -65.968240f,
                -9.803461f, -65.964420f, -9.810112f, -65.982222f, -9.794689f, -66.002436f, -9.813292f, -66.023539f, -9.785443f, -66.036673f,
                -9.782774f, -66.069937f, -9.814000f, -66.093000f, -9.782092f, -66.103191f, -9.784161f, -66.152512f, -9.804644f, -66.195089f,
                -9.835108f, -66.203793f, -9.812807f, -66.235559f, -9.844470f, -66.285110f, -9.838167f, -66.347211f, -9.865348f, -66.358922f,
                -9.863209f, -66.404375f, -9.899325f, -66.427963f, -9.865207f, -66.436588f, -9.879904f, -66.562275f, -9.904283f, -66.580991f,
                -9.888653f, -66.619944f
            )
            poly[818] = TzPolygon(
                -9.673151f, -66.619944f, -9.664898f, -66.609449f, -9.673559f, -66.586307f, -9.633564f, -66.500613f, -9.601583f, -66.494917f,
                -9.500480f, -66.392414f, -9.406947f, -66.408858f, -9.436845f, -66.307497f, -9.409763f, -66.267804f, -9.434419f, -66.173633f,
                -9.408779f, -66.123891f, -9.413160f, -65.970301f, -9.483750f, -65.912634f, -9.530091f, -65.825077f, -9.585644f, -65.791522f,
                -9.553623f, -65.750327f, -9.559057f, -65.723548f, -9.500407f, -65.680998f, -9.451393f, -65.679435f, -9.413865f, -65.596776f,
                -9.427832f, -65.559528f, -9.727325f, -65.559528f, -9.727325f, -66.619944f
            )
            poly[819] = TzPolygon(
                -9.844841f, -65.559528f, -9.844976f, -65.556107f, -9.832076f, -65.559528f, -9.806452f, -65.559528f, -9.782153f, -65.532028f,
                -9.785605f, -65.500489f, -9.730284f, -65.501347f, -9.696275f, -65.446169f, -9.668944f, -65.444294f, -9.700200f, -65.372874f,
                -9.853466f, -65.284297f, -9.965000f, -65.333000f, -10.214544f, -65.288429f, -10.301000f, -65.324000f, -10.372842f, -65.391526f,
                -10.433469f, -65.382564f, -10.485047f, -65.430109f, -10.520335f, -65.417995f, -10.520335f, -65.559528f
            )
            poly[820] = TzPolygon(
                -8.977581f, -64.499112f, -8.978271f, -64.550124f, -9.016452f, -64.611074f, -9.014796f, -64.671376f, -8.988262f, -64.699267f,
                -9.020748f, -64.753570f, -8.986403f, -64.791627f, -8.994111f, -64.839324f, -9.043141f, -64.917267f, -9.124566f, -64.939930f,
                -9.220280f, -64.919683f, -9.255811f, -64.936078f, -9.304614f, -65.000515f, -9.343529f, -65.005847f, -9.432516f, -65.097850f,
                -9.446812f, -65.142881f, -9.427032f, -65.185463f, -9.385448f, -65.173544f, -9.375263f, -65.196158f, -9.285633f, -65.208025f,
                -9.257664f, -65.246661f, -9.338031f, -65.385211f, -9.316376f, -65.447018f, -9.401209f, -65.456600f, -9.466333f, -65.434716f,
                -9.473664f, -65.492801f, -9.447698f, -65.506550f, -9.427832f, -65.559528f, -8.934314f, -65.559528f, -8.934314f, -64.499112f
            )
            poly[821] = TzPolygon(
                -8.977581f, -64.499112f, -8.976870f, -64.446574f, -8.928861f, -64.323400f, -8.996471f, -64.311318f, -8.992308f, -64.233205f,
                -8.958937f, -64.149452f, -8.843167f, -64.158203f, -8.805163f, -64.129459f, -8.776447f, -64.144762f, -8.722160f, -64.130868f,
                -8.715666f, -64.027869f, -8.693558f, -64.035482f, -8.585634f, -63.986210f, -8.609485f, -63.945954f, -8.575525f, -63.924569f,
                -8.487238f, -63.974505f, -8.452264f, -63.940838f, -8.420133f, -63.977895f, -8.387826f, -63.945373f, -8.331188f, -63.944122f,
                -8.328525f, -63.910836f, -8.288820f, -63.870759f, -8.333215f, -63.791231f, -8.320733f, -63.773508f, -8.249499f, -63.722761f,
                -8.198583f, -63.747034f, -8.121743f, -63.669898f, -8.081603f, -63.667000f, -8.029611f, -63.621779f, -7.969294f, -63.620789f,
                -7.975000f, -62.866000f, -8.093000f, -62.692000f, -8.145000f, -62.673000f, -8.173000f, -62.686000f, -8.229000f, -62.654000f,
                -8.284000f, -62.561000f, -8.358000f, -62.551000f, -8.383000f, -62.526000f, -8.339000f, -62.465000f, -8.372000f, -62.432000f,
                -8.387234f, -62.378281f, -10.520335f, -62.378281f, -10.520335f, -64.499112f
            )
            poly[822] = TzPolygon(
                -13.506974f, -61.317865f, -13.554391f, -61.469123f, -13.518000f, -61.572000f, -13.487156f, -61.578408f, -13.516922f, -61.624930f,
                -13.499180f, -61.694920f, -13.527512f, -61.731490f, -13.519548f, -61.754158f, -13.540950f, -61.758579f, -13.516062f, -61.773419f,
                -13.537000f, -61.784000f, -13.521547f, -61.825910f, -13.538209f, -61.856028f, -13.428100f, -61.895816f, -13.407237f, -61.969467f,
                -13.368082f, -61.974567f, -13.357314f, -62.013069f, -13.327000f, -62.017000f, -13.259315f, -62.114773f, -13.157411f, -62.116838f,
                -13.163114f, -62.150019f, -13.113436f, -62.167454f, -13.153345f, -62.193053f, -13.110534f, -62.215510f, -13.157298f, -62.274155f,
                -13.133860f, -62.313733f, -13.151783f, -62.322354f, -13.137830f, -62.378281f, -12.106357f, -62.378281f, -12.106357f, -61.317865f
            )
            poly[823] = TzPolygon(
                -13.692378f, -60.703664f, -13.681474f, -60.715408f, -13.576999f, -60.633702f, -13.561629f, -60.566220f, -13.515625f, -60.527812f,
                -13.449131f, -60.383553f, -13.314490f, -60.371922f, -13.254758f, -60.326648f, -13.178671f, -60.305838f, -13.147531f, -60.269076f,
                -13.080327f, -60.284207f, -13.059614f, -60.257449f, -13.692378f, -60.257449f
            )
            poly[824] = TzPolygon(
                -13.506974f, -61.317865f, -13.503506f, -61.306803f, -13.477885f, -61.299322f, -13.506025f, -61.279501f, -13.496628f, -61.246240f,
                -13.526062f, -61.233959f, -13.536951f, -61.194749f, -13.506021f, -61.183493f, -13.532031f, -61.149166f, -13.531713f, -61.103781f,
                -13.491797f, -61.095334f, -13.512637f, -61.056557f, -13.500042f, -61.035846f, -13.485916f, -61.048506f, -13.488399f, -61.015182f,
                -13.501097f, -60.988398f, -13.509369f, -61.010018f, -13.550627f, -61.007620f, -13.541634f, -60.921551f, -13.619847f, -60.877575f,
                -13.659827f, -60.773806f, -13.683296f, -60.768435f, -13.690981f, -60.707804f, -13.692378f, -60.707010f, -13.692378f, -61.317865f
            )
            poly[825] = TzPolygon(
                -11.099787f, -60.257449f, -11.095172f, -60.277004f, -11.057011f, -60.299105f, -11.074154f, -60.347466f, -11.108762f, -60.348078f,
                -11.092829f, -60.392020f, -11.043414f, -60.414142f, -11.042306f, -60.446343f, -11.018485f, -60.437461f, -10.989132f, -60.459159f,
                -10.986000f, -61.550000f, -10.949000f, -61.519000f, -10.794000f, -61.511000f, -10.797000f, -61.473000f, -10.736000f, -61.488000f,
                -10.715000f, -61.472000f, -10.700000f, -61.498000f, -10.520335f, -61.474259f, -10.520335f, -60.257449f
            )
            poly[826] = TzPolygon(
                -11.099787f, -60.257449f, -11.113682f, -60.198581f, -11.095185f, -60.158166f, -11.110225f, -60.098000f, -11.096554f, -60.083326f,
                -11.124512f, -60.064788f, -11.130166f, -60.024745f, -11.114233f, -59.982762f, -11.155365f, -59.995712f, -11.188908f, -59.963182f,
                -11.234010f, -59.983333f, -11.295597f, -59.958885f, -11.323153f, -59.919644f, -11.398475f, -59.920234f, -11.589060f, -60.113932f,
                -11.713352f, -60.120458f, -11.799353f, -60.095094f, -11.838985f, -60.108377f, -11.895409f, -60.060225f, -11.912337f, -59.983142f,
                -12.027704f, -59.978271f, -12.117000f, -59.899000f, -12.186000f, -59.910000f, -12.245000f, -59.892000f, -12.340956f, -59.774353f,
                -12.401399f, -59.832549f, -12.472052f, -59.847975f, -12.487084f, -59.935226f, -12.613183f, -60.067942f, -12.727950f, -60.090551f,
                -12.889304f, -60.081283f, -12.959556f, -60.117165f, -12.971143f, -60.189278f, -13.026981f, -60.215292f, -13.059614f, -60.257449f
            )
            poly[827] = TzPolygon(
                -8.934314f, -62.378281f, -8.934314f, -61.476608f, -9.092000f, -61.555000f, -9.191000f, -61.520000f, -9.242000f, -61.524000f,
                -9.237000f, -61.575000f, -9.270000f, -61.633000f, -9.279000f, -61.612000f, -9.363017f, -61.625118f, -9.387068f, -61.552081f,
                -9.472912f, -61.578226f, -9.502664f, -61.526441f, -9.515855f, -61.550012f, -9.528991f, -61.513039f, -9.614911f, -61.503290f,
                -9.629468f, -61.476681f, -9.694114f, -61.506750f, -9.720390f, -61.574614f, -9.740763f, -61.530186f, -9.789105f, -61.547923f,
                -9.797984f, -61.524793f, -9.888045f, -61.507478f, -9.989046f, -61.531009f, -10.060565f, -61.584533f, -10.153708f, -61.602022f,
                -10.198264f, -61.551418f, -10.226150f, -61.576724f, -10.307000f, -61.553000f, -10.420000f, -61.461000f, -10.520335f, -61.474259f,
                -10.520335f, -62.378281f
            )
            poly[828] = TzPolygon(
                -8.934314f, -61.476608f, -8.917000f, -61.468000f, -8.818000f, -61.523000f, -8.798000f, -61.583000f, -8.795372f, -60.257449f,
                -8.934314f, -60.257449f
            )
            poly[829] = TzPolygon(
                -7.348293f, -60.257449f, -8.795372f, -60.257449f, -8.798000f, -61.583000f, -8.794000f, -61.606000f, -8.722000f, -61.630000f,
                -8.707000f, -61.705000f, -8.687000f, -61.713000f, -8.695000f, -61.741000f, -8.748000f, -61.774000f, -8.732000f, -61.836000f,
                -8.853000f, -61.860000f, -8.878000f, -61.985000f, -8.799000f, -62.031000f, -8.801000f, -62.124000f, -8.679000f, -62.165000f,
                -8.644000f, -62.200000f, -8.628000f, -62.174000f, -8.590000f, -62.188000f, -8.575000f, -62.268000f, -8.605000f, -62.294000f,
                -8.638000f, -62.281000f, -8.609000f, -62.335000f, -8.563000f, -62.325000f, -8.493000f, -62.366000f, -8.391000f, -62.365000f,
                -8.387234f, -62.378281f, -7.348293f, -62.378281f
            )
            poly[830] = TzPolygon(
                -7.348293f, -58.136618f, -7.433057f, -58.214826f, -7.553880f, -58.220718f, -7.619386f, -58.199253f, -7.699793f, -58.279950f,
                -7.772465f, -58.296936f, -7.840018f, -58.386491f, -7.907399f, -58.376803f, -8.093244f, -58.285527f, -8.130725f, -58.287026f,
                -8.172392f, -58.323713f, -8.321075f, -58.315512f, -8.344705f, -58.349897f, -8.393233f, -58.354812f, -8.490757f, -58.418472f,
                -8.571692f, -58.410872f, -8.600714f, -58.388627f, -8.695925f, -58.440913f, -8.721038f, -58.413618f, -8.704239f, -58.357314f,
                -8.720000f, -58.326000f, -8.791710f, -58.409868f, -8.795372f, -60.257449f, -7.348293f, -60.257449f
            )
            poly[831] = TzPolygon(
                -9.507748f, -54.852991f, -9.367000f, -56.671000f, -9.405829f, -56.760717f, -9.249875f, -56.816135f, -9.218699f, -56.964107f,
                -9.233879f, -56.995826f, -9.185018f, -57.061119f, -9.099051f, -57.037578f, -8.922048f, -57.205291f, -8.913569f, -57.297473f,
                -8.885925f, -57.315498f, -8.875409f, -57.395492f, -8.859975f, -57.417979f, -8.782793f, -57.425704f, -8.784829f, -57.465015f,
                -8.744620f, -57.529388f, -8.761640f, -57.556745f, -8.748818f, -57.615558f, -8.694541f, -57.595336f, -8.640954f, -57.625396f,
                -8.591889f, -57.620883f, -8.576383f, -57.648568f, -8.518282f, -57.633337f, -8.405803f, -57.690749f, -8.211994f, -57.639431f,
                -8.152524f, -57.720447f, -8.095886f, -57.726088f, -7.971690f, -57.832370f, -7.671277f, -57.898862f, -7.652735f, -57.939681f,
                -7.534771f, -57.973042f, -7.422430f, -58.048319f, -7.348293f, -58.134040f, -7.348293f, -54.852991f
            )
            poly[832] = TzPolygon(-9.509851f, -54.852991f, -9.645000f, -53.133000f, -9.748706f, -51.569364f, -13.692378f, -51.569364f, -13.692378f, -54.852991f)
            poly[833] = TzPolygon(
                -9.507748f, -54.852991f, -7.348293f, -54.852991f, -7.348293f, -52.593568f, -7.385987f, -52.644412f, -7.476279f, -52.691968f,
                -7.511084f, -52.665881f, -7.583271f, -52.664690f, -7.648235f, -52.735344f, -7.817867f, -52.755433f, -7.866048f, -52.797975f,
                -8.052924f, -52.698243f, -8.087284f, -52.714635f, -8.201856f, -52.669478f, -8.222074f, -52.626713f, -8.420269f, -52.649199f,
                -8.542102f, -52.547414f, -8.571108f, -52.477278f, -8.566137f, -52.388256f, -8.626850f, -52.294708f, -8.714351f, -52.267517f,
                -8.827187f, -52.277259f, -8.849137f, -52.258365f, -8.854096f, -52.197701f, -8.925626f, -52.108253f, -9.092381f, -52.046481f,
                -9.163788f, -52.071205f, -9.187722f, -52.059151f, -9.189832f, -52.025997f, -9.219322f, -52.034532f, -9.273992f, -52.001480f,
                -9.349514f, -52.085728f, -9.403502f, -52.099967f, -9.427780f, -52.148118f, -9.495018f, -52.147860f, -9.644281f, -52.202728f,
                -9.664709f, -52.255465f, -9.648736f, -52.383533f, -9.587321f, -52.534129f, -9.601578f, -52.568405f, -9.647512f, -52.574291f,
                -9.648147f, -52.603277f, -9.680658f, -52.619543f
            )
            poly[834] = TzPolygon(
                -5.656006f, -53.833182f, -5.656006f, -52.684397f, -5.735777f, -52.658330f, -5.816239f, -52.546868f, -5.871674f, -52.554452f,
                -5.909746f, -52.603296f, -6.024220f, -52.600740f, -6.084128f, -52.566542f, -6.128161f, -52.509823f, -6.276077f, -52.489279f,
                -6.305916f, -52.471132f, -6.323532f, -52.409736f, -6.404354f, -52.350037f, -6.564949f, -52.277660f, -6.591612f, -52.218639f,
                -6.547637f, -52.081771f, -6.710313f, -51.974096f, -6.886320f, -52.023831f, -6.897053f, -52.095773f, -6.935059f, -52.131256f,
                -6.964548f, -52.334717f, -7.001692f, -52.423267f, -7.105024f, -52.459563f, -7.142700f, -52.539952f, -7.206091f, -52.575448f,
                -7.330391f, -52.569421f, -7.348293f, -52.593568f, -7.348293f, -53.833182f
            )
            poly[835] = TzPolygon(
                -3.963720f, -52.599364f, -3.972148f, -52.605578f, -4.083343f, -52.583367f, -4.165500f, -52.634832f, -4.190043f, -52.630723f,
                -4.227341f, -52.695795f, -4.325072f, -52.733871f, -4.364305f, -52.723838f, -4.438751f, -52.652791f, -4.483196f, -52.709086f,
                -4.656596f, -52.724191f, -4.750731f, -52.754854f, -4.825731f, -52.829882f, -4.897750f, -52.837800f, -5.005157f, -52.921855f,
                -5.082516f, -52.929976f, -5.189791f, -52.898913f, -5.377332f, -52.889760f, -5.408598f, -52.864065f, -5.458191f, -52.734948f,
                -5.509346f, -52.678722f, -5.571225f, -52.672022f, -5.617383f, -52.697018f, -5.656006f, -52.684397f, -5.656006f, -53.833182f,
                -3.963720f, -53.833182f
            )
            poly[836] = TzPolygon(
                -2.271433f, -53.833182f, -2.271433f, -52.145543f, -2.565518f, -51.994041f, -2.619703f, -51.991087f, -2.702329f, -52.029778f,
                -2.835458f, -52.011159f, -2.916001f, -51.902196f, -3.101009f, -51.794203f, -3.130921f, -51.657439f, -3.155150f, -51.659226f,
                -3.153172f, -51.608760f, -3.196974f, -51.620406f, -3.242465f, -51.691153f, -3.260383f, -51.678926f, -3.266332f, -51.709922f,
                -3.318269f, -51.715497f, -3.333299f, -51.760567f, -3.358228f, -51.722862f, -3.412265f, -51.743584f, -3.481349f, -51.688111f,
                -3.510755f, -51.745207f, -3.614334f, -51.838303f, -3.528187f, -51.948544f, -3.433605f, -51.945626f, -3.375168f, -52.004348f,
                -3.280065f, -52.029321f, -3.234228f, -52.076816f, -3.216840f, -52.130684f, -3.236033f, -52.189470f, -3.339631f, -52.185738f,
                -3.401562f, -52.210671f, -3.419109f, -52.225259f, -3.410395f, -52.262579f, -3.484153f, -52.264744f, -3.644003f, -52.373578f,
                -3.789506f, -52.578465f, -3.864336f, -52.596051f, -3.941910f, -52.583283f, -3.963720f, -52.599364f, -3.963720f, -53.833182f
            )
            poly[837] = TzPolygon(
                -0.579146f, -52.652003f, -0.593881f, -52.639497f, -0.579146f, -52.591262f, -0.579146f, -52.553743f, -0.592654f, -52.526124f,
                -0.732208f, -52.495204f, -0.787399f, -52.526122f, -0.817069f, -52.514779f, -0.853933f, -52.545021f, -0.826316f, -52.453710f,
                -0.877000f, -52.403000f, -0.914382f, -52.400854f, -0.935710f, -52.437259f, -1.009000f, -52.414000f, -1.050000f, -52.427000f,
                -1.062000f, -52.358000f, -1.116000f, -52.333000f, -1.146000f, -52.120000f, -1.218000f, -52.109000f, -1.236000f, -52.070000f,
                -1.219000f, -52.047000f, -1.186000f, -52.064000f, -1.171000f, -51.991000f, -1.116814f, -51.979523f, -1.167000f, -51.961000f,
                -1.132000f, -51.926000f, -1.166000f, -51.882000f, -1.180968f, -51.909927f, -1.280889f, -51.900380f, -1.434735f, -51.955011f,
                -1.490627f, -51.926051f, -1.516168f, -51.846453f, -1.598946f, -52.024070f, -1.618971f, -52.159274f, -1.661343f, -52.187387f,
                -1.692092f, -52.252444f, -1.734757f, -52.263777f, -1.811579f, -52.230718f, -2.089464f, -52.211863f, -2.192955f, -52.185972f,
                -2.271433f, -52.145543f, -2.271433f, -53.833182f, -0.579146f, -53.833182f
            )
            poly[838] = TzPolygon(
                1.848602f, -56.097000f, 1.835521f, -55.983212f, 1.888028f, -55.903854f, 1.986466f, -55.936349f, 1.990519f, -55.913739f,
                2.041078f, -55.903102f, 2.057741f, -55.932820f, 2.078634f, -55.929095f, 2.088428f, -55.966816f, 2.167602f, -56.003072f,
                2.184641f, -56.055046f, 2.227783f, -56.042880f, 2.249186f, -56.097000f, 2.317191f, -56.097000f, 2.321170f, -56.093761f,
                2.372277f, -56.090122f, 2.334981f, -56.050601f, 2.342469f, -56.021814f, 2.366272f, -56.039965f, 2.420327f, -55.987015f,
                2.452820f, -56.011511f, 2.489609f, -55.977487f, 2.504548f, -55.992877f, 2.527329f, -55.978236f, 2.530541f, -55.924157f,
                2.462176f, -55.838819f, 2.455237f, -55.766629f, 2.410445f, -55.746961f, 2.399167f, -55.716944f, 2.421543f, -55.698344f,
                2.443237f, -55.499712f, 2.418360f, -55.385327f, 2.447988f, -55.345572f, 2.475558f, -55.356155f, 2.515368f, -55.320184f,
                2.503380f, -55.234736f, 2.559342f, -55.172796f, 2.567624f, -55.123404f, 2.525640f, -55.103017f, 2.590930f, -55.003738f,
                2.585203f, -54.965091f, 1.113140f, -54.965091f, 1.113140f, -56.097000f
            )
            poly[839] = TzPolygon(
                1.393358f, -53.833182f, 1.393595f, -53.854160f, 1.408963f, -53.848838f, 1.404903f, -53.888092f, 1.440462f, -53.876888f,
                1.456625f, -53.894259f, 1.437492f, -53.934754f, 1.470758f, -53.922421f, 1.478050f, -53.991568f, 1.523632f, -54.005169f,
                1.493483f, -54.083125f, 1.533970f, -54.082824f, 1.563517f, -54.116933f, 1.598703f, -54.100725f, 1.601860f, -54.135773f,
                1.611747f, -54.120618f, 1.651893f, -54.146340f, 1.664937f, -54.182404f, 1.632608f, -54.190920f, 1.749627f, -54.312001f,
                1.747108f, -54.345319f, 1.773908f, -54.376831f, 1.755641f, -54.387811f, 1.770375f, -54.464637f, 1.754175f, -54.495435f,
                1.795369f, -54.575081f, 1.774899f, -54.670153f, 1.786782f, -54.745970f, 1.809181f, -54.757742f, 1.841569f, -54.736527f,
                1.950768f, -54.777325f, 1.959283f, -54.769780f, 1.959283f, -53.833182f
            )
            poly[840] = TzPolygon(
                2.209549f, -54.399136f, 2.210833f, -54.463889f, 2.265556f, -54.537778f, 2.289722f, -54.515000f, 2.316389f, -54.541944f,
                2.333698f, -54.602780f, 2.354270f, -54.572203f, 2.338536f, -54.505196f, 2.392735f, -54.504504f, 2.433976f, -54.473760f,
                2.436233f, -54.420328f, 2.457414f, -54.399136f
            )
            poly[841] = TzPolygon(
                2.805427f, -54.399136f, 2.461419f, -54.399136f, 2.436233f, -54.420328f, 2.433976f, -54.473760f, 2.392735f, -54.504504f,
                2.338536f, -54.505196f, 2.332285f, -54.526094f, 2.354270f, -54.572203f, 2.321111f, -54.628889f, 2.324722f, -54.688611f,
                2.378611f, -54.712500f, 2.403333f, -54.683889f, 2.453889f, -54.689167f, 2.471667f, -54.753611f, 2.435556f, -54.806389f,
                2.439886f, -54.868459f, 2.518489f, -54.935354f, 2.583595f, -54.954239f, 2.585203f, -54.965091f, 2.805427f, -54.965091f
            )
            poly[842] = TzPolygon(
                2.585203f, -54.965091f, 2.583595f, -54.954239f, 2.518489f, -54.935354f, 2.313064f, -54.793775f, 2.266709f, -54.810946f,
                2.206311f, -54.769949f, 2.150586f, -54.813071f, 2.078793f, -54.818782f, 2.034643f, -54.807204f, 1.976553f, -54.754478f,
                1.959283f, -54.769780f, 1.959283f, -54.965091f
            )
            poly[843] = TzPolygon(
                2.210239f, -54.399136f, 2.208889f, -54.365833f, 2.164444f, -54.328056f, 2.146667f, -54.249167f, 2.172500f, -54.180556f,
                2.113611f, -54.123333f, 2.135556f, -54.079444f, 2.194444f, -54.057500f, 2.181389f, -54.013056f, 2.219167f, -53.940833f,
                2.271944f, -53.931944f, 2.267778f, -53.886667f, 2.302778f, -53.866944f, 2.307330f, -53.833182f, 1.959283f, -53.833182f,
                1.959283f, -54.399136f
            )
            poly[844] = TzPolygon(
                2.805427f, -54.206802f, 2.776701f, -54.205764f, 2.629595f, -54.317442f, 2.521251f, -54.348794f, 2.461419f, -54.399136f,
                2.805427f, -54.399136f
            )
            poly[845] = TzPolygon(
                1.113140f, -53.833182f, 1.113140f, -53.463759f, 1.080004f, -53.460914f, 1.036818f, -53.427382f, 0.930899f, -53.420126f,
                0.854371f, -53.302163f, 0.770775f, -53.200589f, 0.694640f, -53.150290f, 0.679830f, -53.109991f, 0.584389f, -53.155590f,
                0.475490f, -53.159951f, 0.445116f, -53.181115f, 0.391775f, -53.165252f, 0.365235f, -53.184311f, 0.257047f, -53.092774f,
                0.230959f, -53.108450f, 0.193677f, -53.096309f, 0.080780f, -53.005777f, 0.049990f, -53.018130f, 0.018448f, -52.984895f,
                -0.034665f, -52.987842f, -0.144973f, -52.937093f, -0.151066f, -52.841204f, -0.285729f, -52.740119f, -0.315273f, -52.684399f,
                -0.369728f, -52.678157f, -0.385292f, -52.707545f, -0.425759f, -52.677554f, -0.460133f, -52.703562f, -0.549633f, -52.677052f,
                -0.579146f, -52.652003f, -0.579146f, -53.833182f
            )
            poly[846] = TzPolygon(-0.579146f, -52.591262f, -0.572092f, -52.568168f, -0.579146f, -52.553743f)
            poly[847] = TzPolygon(
                2.805427f, -52.701273f, 2.354921f, -52.701273f, 2.281581f, -52.858262f, 2.186179f, -52.902663f, 2.194554f, -52.934445f,
                2.167271f, -52.983894f, 2.222500f, -53.105000f, 2.208333f, -53.239167f, 2.186027f, -53.278992f, 2.253333f, -53.216667f,
                2.353333f, -53.328333f, 2.316389f, -53.352222f, 2.257500f, -53.458611f, 2.249167f, -53.529722f, 2.312222f, -53.733889f,
                2.344444f, -53.719444f, 2.373056f, -53.751111f, 2.350556f, -53.802500f, 2.309444f, -53.817500f, 2.307330f, -53.833182f,
                2.805427f, -53.833182f
            )
            poly[848] = TzPolygon(
                1.393358f, -53.833182f, 1.393107f, -53.810961f, 1.415809f, -53.825925f, 1.425581f, -53.809119f, 1.387243f, -53.738435f,
                1.432833f, -53.723336f, 1.422835f, -53.700326f, 1.383820f, -53.717320f, 1.373071f, -53.682054f, 1.408928f, -53.652728f,
                1.340896f, -53.661150f, 1.358111f, -53.598287f, 1.337633f, -53.578931f, 1.341015f, -53.543594f, 1.320646f, -53.539534f,
                1.301254f, -53.568781f, 1.263370f, -53.528933f, 1.211581f, -53.542918f, 1.250216f, -53.435630f, 1.163398f, -53.406083f,
                1.134909f, -53.465628f, 1.113140f, -53.463759f, 1.113140f, -53.833182f
            )
            poly[849] = TzPolygon(
                2.805427f, -52.460509f, 2.658948f, -52.526181f, 2.636944f, -52.555107f, 2.580248f, -52.526030f, 2.550042f, -52.560563f,
                2.521360f, -52.550583f, 2.474813f, -52.618508f, 2.451998f, -52.609433f, 2.432128f, -52.644964f, 2.373960f, -52.660520f,
                2.354921f, -52.701273f, 2.805427f, -52.701273f
            )
            poly[850] = TzPolygon(
                4.497713f, -56.097000f, 4.497713f, -54.450728f, 4.419722f, -54.440556f, 4.416207f, -54.415744f, 4.377058f, -54.417878f,
                4.350923f, -54.385724f, 4.202654f, -54.396180f, 4.144626f, -54.323096f, 4.049060f, -54.357870f, 4.015002f, -54.318865f,
                3.933333f, -54.289373f, 3.908455f, -54.248859f, 3.860055f, -54.236573f, 3.846573f, -54.191432f, 3.806615f, -54.198437f,
                3.797916f, -54.126840f, 3.715196f, -54.078994f, 3.675445f, -54.083339f, 3.634973f, -54.050979f, 3.649319f, -54.007628f,
                3.607456f, -53.979968f, 3.537236f, -54.009320f, 3.427073f, -54.011871f, 3.383789f, -54.059835f, 3.307490f, -54.066584f,
                3.286256f, -54.128097f, 3.150779f, -54.214045f, 3.126416f, -54.210407f, 3.135435f, -54.183599f, 3.108115f, -54.173808f,
                3.072313f, -54.174362f, 3.064080f, -54.194711f, 3.015218f, -54.169726f, 2.984569f, -54.181711f, 2.968434f, -54.160540f,
                2.920989f, -54.191982f, 2.854723f, -54.179848f, 2.829119f, -54.207658f, 2.805427f, -54.206802f, 2.805427f, -56.097000f
            )
            poly[851] = TzPolygon(
                4.497713f, -54.450728f, 4.509167f, -54.452222f, 4.593333f, -54.420000f, 4.714167f, -54.435833f, 4.747778f, -54.477500f,
                4.898611f, -54.486389f, 4.936571f, -54.445255f, 5.084167f, -54.405556f, 5.240556f, -54.296667f, 5.315000f, -54.193056f,
                5.551073f, -54.007772f, 5.629444f, -54.025278f, 5.688611f, -54.009444f, 5.978000f, -53.843336f, 5.973019f, -53.833182f,
                4.497713f, -53.833182f
            )
            poly[852] = TzPolygon(
                2.805427f, -52.460509f, 2.891049f, -52.422122f, 2.917353f, -52.377061f, 2.947570f, -52.393193f, 3.078800f, -52.325965f,
                3.126440f, -52.352973f, 3.171378f, -52.331107f, 3.173522f, -52.301351f, 3.227270f, -52.292286f, 3.253042f, -52.261923f,
                3.239441f, -52.236381f, 3.298745f, -52.189622f, 3.627774f, -51.988706f, 3.706957f, -51.971035f, 3.724219f, -51.921484f,
                3.781984f, -51.919006f, 3.888877f, -51.797307f, 3.974056f, -51.777827f, 4.052762f, -51.658667f, 4.235524f, -51.614710f,
                4.394939f, -51.645669f, 4.508337f, -51.637160f, 4.587060f, -51.569364f, 2.805427f, -51.569364f
            )
            poly[853] = TzPolygon(
                9.128479f, -72.858752f, 9.132962f, -72.881197f, 9.102942f, -72.887292f, 9.091651f, -72.947697f, 9.142360f, -72.986913f,
                9.181240f, -72.955915f, 9.220787f, -72.996219f, 9.252937f, -72.985821f, 9.291294f, -73.010613f, 9.263387f, -73.073045f,
                9.225558f, -73.090361f, 9.228309f, -73.131298f, 9.177167f, -73.176580f, 9.183647f, -73.213782f, 9.158209f, -73.250146f,
                9.173405f, -73.347262f, 9.217530f, -73.352963f, 9.213054f, -73.333753f, 9.402898f, -73.240894f, 9.445538f, -73.189263f,
                9.469263f, -73.203259f, 9.480631f, -73.172017f, 9.550467f, -73.136668f, 9.556277f, -73.085190f, 9.678263f, -73.054816f,
                9.837627f, -72.945436f, 9.875025f, -72.992808f, 9.888767f, -72.977466f, 9.923865f, -72.999036f, 10.066003f, -72.954089f,
                10.112724f, -72.911633f, 10.446657f, -72.893301f, 10.475010f, -72.858752f
            )
            poly[854] = TzPolygon(
                8.603884f, -72.644071f, 8.614665f, -72.655109f, 9.105581f, -72.766384f, 9.103230f, -72.796340f, 9.140538f, -72.821919f,
                9.121627f, -72.824447f, 9.128479f, -72.858752f, 10.475010f, -72.858752f, 10.485797f, -72.845609f, 10.570206f, -72.820645f,
                10.651463f, -72.735114f, 10.740116f, -72.716567f, 10.763971f, -72.679952f, 10.879546f, -72.648966f, 10.882702f, -72.612404f,
                10.940204f, -72.553774f, 11.059113f, -72.481635f, 11.085886f, -72.497640f, 11.127658f, -72.443589f, 11.151373f, -72.349314f,
                11.140186f, -72.249416f, 11.646267f, -71.971363f, 11.686839f, -71.782694f, 11.812129f, -71.378405f, 11.830439f, -71.386725f,
                11.849232f, -71.341823f, 11.961238f, -70.927056f, 8.603884f, -70.927056f
            )
            poly[855] = TzPolygon(
                12.157405f, -70.927056f, 12.287395f, -71.048794f, 12.401962f, -71.079828f, 12.523406f, -71.146887f, 12.599194f, -71.122362f,
                12.662434f, -71.070873f, 12.702673f, -71.002730f, 12.716034f, -70.927056f
            )
            poly[856] = TzPolygon(
                12.157405f, -70.927056f, 12.716034f, -70.927056f, 12.716688f, -70.923351f, 12.558597f, -70.416674f, 12.350026f, -70.416662f,
                12.350000f, -70.164167f, 12.365000f, -70.140278f, 12.262778f, -69.736667f, 12.218782f, -69.661226f, 8.603884f, -69.661226f,
                8.603884f, -70.927056f, 11.961238f, -70.927056f
            )
            poly[857] = TzPolygon(
                12.218782f, -69.661226f, 11.879296f, -69.079095f, 11.758230f, -68.954252f, 11.741638f, -68.829117f, 11.666679f, -68.600038f,
                11.666678f, -67.990797f, 8.603884f, -67.990797f, 8.603884f, -69.661226f
            )
            poly[858] = TzPolygon(
                12.592000f, -69.147203f, 12.524000f, -68.966469f, 12.466000f, -68.904144f, 12.376000f, -68.857011f, 12.356000f, -68.767062f,
                12.292000f, -68.672990f, 11.932000f, -68.441347f, 11.818000f, -68.518527f, 11.777000f, -68.645296f, 11.864000f, -68.912221f,
                12.043000f, -69.210695f, 12.211000f, -69.342189f, 12.381000f, -69.367349f, 12.463000f, -69.349015f, 12.532000f, -69.300835f,
                12.578000f, -69.229781f
            )
            poly[859] = TzPolygon(
                11.562837f, -67.990797f, 11.562837f, -62.803121f, 10.947917f, -61.729444f, 10.714445f, -61.802778f, 10.588889f, -61.802778f,
                10.588611f, -61.862500f, 10.046111f, -62.083056f, 9.986667f, -61.855000f, 9.970000f, -61.500000f, 9.874531f, -61.207427f,
                9.799487f, -61.093013f, 9.751163f, -60.900960f, 8.685788f, -59.542708f, 8.603884f, -59.773739f, 8.603884f, -67.990797f
            )
            poly[860] = TzPolygon(
                12.324735f, -61.861472f, 12.494000f, -61.702626f, 12.596653f, -61.665747f, 12.530136f, -61.382722f, 12.516655f, -61.173214f,
                12.404000f, -61.207000f, 12.324735f, -61.280369f
            )
            poly[861] = TzPolygon(13.583000f, -61.133776f, 13.583000f, -60.791134f, 13.536000f, -60.837991f, 13.508000f, -60.950006f, 13.580148f, -61.130393f)
            poly[862] = TzPolygon(
                -28.570615f, 16.475659f, -28.572880f, 16.468250f, -28.632768f, 16.453131f, -28.800418f, 16.333521f, -28.685516f, 16.158932f,
                -28.570615f, 16.040387f
            )
            poly[863] = TzPolygon(
                -28.570615f, 17.396573f, -28.570615f, 19.544312f, -28.587130f, 19.536050f, -28.601000f, 19.503870f, -28.706090f, 19.466820f,
                -28.736820f, 19.403650f, -28.743930f, 19.267700f, -28.812590f, 19.239190f, -28.869640f, 19.265030f, -28.885420f, 19.296390f,
                -28.908180f, 19.285380f, -28.902520f, 19.245200f, -28.949980f, 19.191380f, -28.969450f, 19.118470f, -28.929020f, 19.008740f,
                -28.870530f, 18.972240f, -28.844400f, 18.855710f, -28.840450f, 18.632120f, -28.889460f, 18.512180f, -28.900820f, 18.423470f,
                -28.879390f, 18.263490f, -28.916150f, 18.188440f, -28.870650f, 18.083120f, -28.874270f, 18.046070f, -28.809500f, 17.993520f,
                -28.764090f, 17.917600f, -28.739910f, 17.749510f, -28.773690f, 17.647070f, -28.760670f, 17.616110f, -28.694650f, 17.598860f,
                -28.685590f, 17.568380f, -28.722870f, 17.420360f, -28.574220f, 17.431770f
            )
            poly[864] = TzPolygon(
                -34.965818f, 19.544312f, -28.570615f, 19.544312f, -28.570615f, 29.455710f, -32.001322f, 29.455710f, -32.217014f, 29.260385f,
                -32.701593f, 28.732420f, -32.855333f, 28.529802f, -32.957649f, 28.321425f, -33.061846f, 28.238536f, -33.200424f, 28.049854f,
                -33.285753f, 27.878084f, -33.691140f, 27.245590f, -33.747017f, 27.121748f, -34.029603f, 26.372758f, -34.240225f, 25.691531f,
                -34.413295f, 24.856936f, -34.294419f, 22.990015f, -34.378139f, 22.260436f, -34.530805f, 22.031103f, -34.570496f, 21.890081f,
                -34.668559f, 20.916269f, -35.009194f, 20.125081f, -35.033759f, 20.010019f
            )
            poly[865] = TzPolygon(
                -28.570615f, 16.475659f, -28.533880f, 16.595830f, -28.472350f, 16.672430f, -28.499450f, 16.724770f, -28.453020f, 16.768930f,
                -28.396840f, 16.768960f, -28.361950f, 16.808440f, -28.272790f, 16.754490f, -28.269020f, 16.824740f, -28.222020f, 16.803060f,
                -28.211690f, 16.856060f, -28.166680f, 16.831280f, -28.172880f, 16.887930f, -28.074550f, 16.898460f, -28.058730f, 16.973810f,
                -28.075480f, 17.002030f, -28.032820f, 17.078510f, -28.034887f, 17.080560f, -28.570615f, 17.080560f
            )
            poly[866] = TzPolygon(
                -28.570615f, 17.396573f, -28.568940f, 17.380220f, -28.475540f, 17.333100f, -28.439030f, 17.348670f, -28.436960f, 17.384800f,
                -28.399580f, 17.410000f, -28.570615f, 17.410000f
            )
            poly[867] = TzPolygon(
                -28.399580f, 17.410000f, -28.295600f, 17.382140f, -28.225790f, 17.333270f, -28.247790f, 17.214560f, -28.203430f, 17.182450f,
                -28.108230f, 17.191930f, -28.093060f, 17.138230f, -28.032820f, 17.080727f, -28.032820f, 17.410000f
            )
            poly[868] = TzPolygon(
                -17.390082f, 17.410000f, -17.391599f, 14.216120f, -17.410048f, 14.212641f, -17.438732f, 14.102125f, -17.414675f, 14.015962f,
                -17.433032f, 13.955744f, -17.361674f, 13.899746f, -17.141411f, 13.517756f, -17.091584f, 13.521684f, -17.010657f, 13.462121f,
                -16.974122f, 13.352983f, -17.001320f, 13.246339f, -16.963485f, 13.168592f, -16.982309f, 12.983381f, -17.171882f, 12.713012f,
                -17.172918f, 12.672225f, -17.231577f, 12.605614f, -17.247705f, 12.541325f, -17.241959f, 12.478201f, -17.264055f, 12.445918f,
                -17.222583f, 12.436147f, -17.206483f, 12.405918f, -17.233798f, 12.369511f, -17.218725f, 12.351356f, -17.240072f, 12.249843f,
                -17.161959f, 12.161349f, -17.141877f, 12.079883f, -17.181981f, 11.941650f, -17.273769f, 11.794818f, -17.250000f, 11.748939f,
                -17.250000f, 11.542102f, -16.839570f, 11.566921f, -16.681235f, 11.490233f, -16.554324f, 11.460979f, -16.467022f, 11.476127f,
                -16.204559f, 11.589178f, -16.052299f, 11.586924f, -15.948462f, 11.531774f, -15.827162f, 11.531171f, -15.662271f, 11.610470f,
                -15.609703f, 11.702113f, -15.609703f, 17.410000f
            )
            poly[869] = TzPolygon(
                -28.570615f, 19.544312f, -28.527680f, 19.565790f, -28.510930f, 19.625200f, -28.531090f, 19.668340f, -28.485740f, 19.738630f,
                -28.508300f, 19.813250f, -28.442730f, 19.877050f, -28.427820f, 19.999160f, -25.330387f, 19.999077f, -25.330387f, 20.421428f,
                -28.570615f, 20.421428f
            )
            poly[870] = TzPolygon(
                -26.140444f, 20.858664f, -26.140444f, 21.927141f, -26.668094f, 21.927141f, -26.659689f, 21.823459f, -26.675893f, 21.787415f,
                -26.695158f, 21.769098f, -26.770724f, 21.793350f, -26.802320f, 21.780990f, -26.861270f, 21.694700f, -26.866650f, 21.626880f,
                -26.839900f, 21.575570f, -26.861840f, 21.525380f, -26.822130f, 21.404200f, -26.873652f, 21.133666f, -26.796300f, 20.898120f,
                -26.819270f, 20.820700f, -26.841660f, 20.816340f, -26.866350f, 20.763510f, -26.870140f, 20.714980f, -26.905967f, 20.687731f,
                -26.840039f, 20.682511f, -26.828786f, 20.644931f, -26.786523f, 20.621967f, -26.592177f, 20.632371f, -26.514271f, 20.604604f,
                -26.443589f, 20.617644f, -26.397360f, 20.693374f
            )
            poly[871] = TzPolygon(
                -25.330387f, 20.549922f, -25.389223f, 20.562036f, -25.394550f, 20.601450f, -25.428003f, 20.603086f, -25.425072f, 20.630937f,
                -25.461874f, 20.622275f, -25.450100f, 20.672970f, -25.475252f, 20.636163f, -25.519582f, 20.629782f, -25.592363f, 20.698419f,
                -25.635752f, 20.651556f, -25.635006f, 20.687540f, -25.686363f, 20.677122f, -25.716297f, 20.716710f, -25.770017f, 20.730998f,
                -25.780633f, 20.762952f, -25.822917f, 20.739748f, -25.801138f, 20.786729f, -25.853770f, 20.783002f, -25.868332f, 20.812756f,
                -25.920194f, 20.803538f, -25.959447f, 20.840679f, -26.007501f, 20.816594f, -26.081693f, 20.842087f, -26.105367f, 20.821092f,
                -26.133663f, 20.863027f, -26.140444f, 20.858664f, -26.140444f, 20.421428f, -25.330387f, 20.421428f
            )
            poly[872] = TzPolygon(
                -25.330387f, 23.011181f, -25.335860f, 23.011320f, -25.339860f, 22.977940f, -25.381140f, 22.970000f, -25.422310f, 22.909950f,
                -25.468390f, 22.885740f, -25.486850f, 22.900440f, -25.490170f, 22.846370f, -25.533510f, 22.853490f, -25.582420f, 22.814070f,
                -25.615170f, 22.853370f, -25.632770f, 22.800420f, -25.657770f, 22.830210f, -25.690470f, 22.821480f, -25.732840f, 22.769320f,
                -25.788660f, 22.759330f, -25.793660f, 22.734580f, -25.823267f, 22.781717f, -25.892960f, 22.712030f, -25.918000f, 22.749240f,
                -25.950090f, 22.723900f, -26.015240f, 22.724745f, -26.017900f, 22.665710f, -26.073460f, 22.673118f, -26.094500f, 22.631720f,
                -26.149219f, 22.604859f, -26.142098f, 22.578233f, -26.223450f, 22.555180f, -26.199990f, 22.473360f, -26.227900f, 22.454130f,
                -26.224420f, 22.420060f, -26.272700f, 22.402910f, -26.285780f, 22.363110f, -26.325530f, 22.362950f, -26.349940f, 22.242330f,
                -26.401133f, 22.189983f, -26.424780f, 22.200240f, -26.508589f, 22.163480f, -26.581345f, 22.077259f, -26.632661f, 22.051473f,
                -26.669849f, 21.948791f, -26.668094f, 21.927141f, -25.330387f, 21.927141f
            )
            poly[873] = TzPolygon(-25.330387f, 23.080325f, -25.331970f, 23.078690f, -25.330387f, 23.075817f)
            poly[874] = TzPolygon(
                -25.330387f, 19.999077f, -24.763751f, 19.999062f, -24.833057f, 20.090539f, -24.884963f, 20.121596f, -24.923600f, 20.259120f,
                -24.980620f, 20.296510f, -25.034375f, 20.384046f, -25.061750f, 20.378830f, -25.082270f, 20.412355f, -25.154503f, 20.431441f,
                -25.156696f, 20.469348f, -25.199160f, 20.446570f, -25.228420f, 20.498940f, -25.268980f, 20.496440f, -25.286170f, 20.545880f,
                -25.317140f, 20.513900f, -25.320472f, 20.547881f, -25.330387f, 20.549922f
            )
            poly[875] = TzPolygon(
                -25.330387f, 23.011181f, -25.297230f, 23.010340f, -25.312930f, 23.030790f, -25.289940f, 23.058420f, -25.318610f, 23.054440f,
                -25.330387f, 23.075817f
            )
            poly[876] = TzPolygon(
                -25.330387f, 23.080325f, -25.304180f, 23.107390f, -25.317420f, 23.134540f, -25.273420f, 23.212020f, -25.274100f, 23.278050f,
                -25.294090f, 23.295010f, -25.285140f, 23.355550f, -25.315800f, 23.414300f, -25.290004f, 23.432855f, -25.330387f, 23.432855f
            )
            poly[877] = TzPolygon(-22.090159f, 19.999147f, -25.330387f, 19.999154f, -25.330387f, 17.410000f, -22.090159f, 17.410000f)
            poly[878] = TzPolygon(
                -25.330387f, 23.495008f, -25.330387f, 25.692772f, -25.469921f, 25.662603f, -25.637943f, 25.581280f, -25.684239f, 25.513883f,
                -25.771152f, 25.337117f, -25.764394f, 25.121306f, -25.721419f, 25.038116f, -25.811055f, 24.897122f, -25.825693f, 24.794257f,
                -25.803883f, 24.728325f, -25.823921f, 24.683178f, -25.733024f, 24.447024f, -25.762427f, 24.400992f, -25.758313f, 24.357220f,
                -25.711003f, 24.326735f, -25.726032f, 24.285461f, -25.693234f, 24.287879f, -25.706748f, 24.260671f, -25.643839f, 24.226944f,
                -25.620144f, 24.191010f, -25.630058f, 24.160052f, -25.608195f, 24.157015f, -25.643005f, 24.085964f, -25.630771f, 24.067605f,
                -25.651297f, 24.061944f, -25.634072f, 24.030093f, -25.650899f, 24.005307f, -25.624664f, 24.012229f, -25.614548f, 23.969961f,
                -25.638234f, 23.928121f, -25.576443f, 23.879240f, -25.567294f, 23.839465f, -25.540935f, 23.835751f, -25.545718f, 23.809251f,
                -25.511608f, 23.820083f, -25.503013f, 23.762938f, -25.446292f, 23.729332f, -25.462722f, 23.703385f, -25.441387f, 23.666577f,
                -25.416255f, 23.669049f, -25.431580f, 23.637460f, -25.383920f, 23.616000f, -25.396460f, 23.589310f, -25.354660f, 23.559590f,
                -25.351570f, 23.496180f
            )
            poly[879] = TzPolygon(
                -25.290004f, 23.432855f, -25.276970f, 23.442230f, -25.276750f, 23.465790f, -25.297740f, 23.458140f, -25.317950f, 23.494320f,
                -25.330387f, 23.495008f, -25.330387f, 23.432855f
            )
            poly[880] = TzPolygon(
                -25.330387f, 25.692772f, -25.289181f, 25.701681f, -24.924003f, 25.860018f, -24.914933f, 25.882476f, -24.753761f, 25.848101f,
                -24.747680f, 25.955827f, -24.645859f, 26.409067f, -24.614160f, 26.444282f, -25.330387f, 26.444282f
            )
            poly[881] = TzPolygon(
                -23.710273f, 26.444282f, -23.710273f, 26.970650f, -23.830736f, 26.958347f, -23.851342f, 26.932503f, -23.874114f, 26.955132f,
                -24.089470f, 26.884820f, -24.106560f, 26.860200f, -24.160110f, 26.879130f, -24.179130f, 26.864480f, -24.189501f, 26.883142f,
                -24.263576f, 26.856211f, -24.306752f, 26.785935f, -24.304237f, 26.733484f, -24.344145f, 26.675676f, -24.381112f, 26.663636f,
                -24.410788f, 26.587263f, -24.487944f, 26.509944f, -24.590480f, 26.470590f, -24.614160f, 26.444282f
            )
            poly[882] = TzPolygon(
                -23.710273f, 26.970650f, -23.702807f, 26.971413f, -23.688023f, 27.002312f, -23.637959f, 27.010103f, -23.682676f, 27.036909f,
                -23.670908f, 27.070547f, -23.643300f, 27.081145f, -23.612665f, 27.059168f, -23.597763f, 27.105162f, -23.559323f, 27.114118f,
                -23.568466f, 27.154126f, -23.523971f, 27.134548f, -23.534205f, 27.201212f, -23.498038f, 27.192819f, -23.462998f, 27.302833f,
                -23.400352f, 27.337171f, -23.427003f, 27.374634f, -23.399249f, 27.377333f, -23.389208f, 27.408208f, -23.413236f, 27.400950f,
                -23.426753f, 27.421567f, -23.384650f, 27.441615f, -23.385613f, 27.528416f, -23.340585f, 27.567361f, -23.217113f, 27.600830f,
                -23.225453f, 27.649987f, -23.196191f, 27.689376f, -23.229943f, 27.742540f, -23.169113f, 27.785435f, -23.133751f, 27.766923f,
                -23.134732f, 27.809310f, -23.106227f, 27.814230f, -23.051971f, 27.935635f, -22.963211f, 27.935178f, -22.955850f, 27.949996f,
                -23.710273f, 27.949996f
            )
            poly[883] = TzPolygon(
                -22.090159f, 29.275771f, -22.195471f, 29.375304f, -22.178705f, 29.217704f, -22.215824f, 29.150273f, -22.217134f, 29.035870f,
                -22.305773f, 28.967072f, -22.376079f, 28.971935f, -22.460798f, 28.917836f, -22.453557f, 28.849292f, -22.488344f, 28.831407f,
                -22.588510f, 28.514880f, -22.571035f, 28.479876f, -22.574276f, 28.339595f, -22.687179f, 28.180886f, -22.774948f, 28.145566f,
                -22.833355f, 28.041534f, -22.911897f, 28.038480f, -22.954934f, 27.949996f, -22.090159f, 27.949996f
            )
            poly[884] = TzPolygon(-22.090159f, 29.275521f, -22.090159f, 29.455710f, -22.168830f, 29.455710f, -22.195188f, 29.373921f)
            poly[885] = TzPolygon(
                -18.849931f, 17.410000f, -18.849931f, 20.998919f, -22.000342f, 20.998739f, -21.999917f, 19.999147f, -22.090159f, 19.999147f,
                -22.090159f, 17.410000f
            )
            poly[886] = TzPolygon(
                -17.390082f, 17.410000f, -17.389601f, 18.421455f, -17.582071f, 18.562916f, -17.601183f, 18.619015f, -17.635835f, 18.623853f,
                -17.736887f, 18.742493f, -17.735681f, 18.775409f, -17.765779f, 18.789060f, -17.772233f, 18.835955f, -17.819614f, 18.903182f,
                -17.836911f, 19.115675f, -17.808967f, 19.134979f, -17.805992f, 19.173952f, -17.833923f, 19.329107f, -17.854777f, 19.327430f,
                -17.874623f, 19.547385f, -17.849466f, 19.673821f, -17.911057f, 19.756734f, -17.867960f, 19.809121f, -17.883527f, 19.863068f,
                -17.862427f, 19.924904f, -17.905667f, 20.027787f, -17.885410f, 20.057999f, -17.910927f, 20.108000f, -17.876535f, 20.172501f,
                -17.892762f, 20.245282f, -17.866589f, 20.267479f, -17.862287f, 20.326055f, -17.897477f, 20.369971f, -17.907796f, 20.421428f,
                -18.849931f, 20.421428f, -18.849931f, 17.410000f
            )
            poly[887] = TzPolygon(
                -18.849931f, 20.998919f, -18.317569f, 20.998950f, -18.317647f, 21.453045f, -18.000819f, 23.098367f, -18.000786f, 23.296928f,
                -18.051877f, 23.334834f, -18.082758f, 23.324181f, -18.174641f, 23.402951f, -18.208107f, 23.397462f, -18.211625f, 23.432855f,
                -18.849931f, 23.432855f
            )
            poly[888] = TzPolygon(
                -17.229817f, 22.935474f, -17.229817f, 23.432855f, -17.636332f, 23.432855f, -17.636669f, 23.431158f, -17.576314f, 23.393338f,
                -17.546646f, 23.241295f, -17.474858f, 23.177693f, -17.466567f, 23.136133f, -17.422660f, 23.128194f, -17.413513f, 23.087139f,
                -17.337742f, 23.058643f, -17.346696f, 23.043989f, -17.298122f, 22.997069f, -17.284124f, 23.008831f
            )
            poly[889] = TzPolygon(
                -17.907796f, 20.421428f, -17.914814f, 20.456425f, -17.950348f, 20.474354f, -17.981770f, 20.540024f, -17.976794f, 20.645468f,
                -18.037477f, 20.802701f, -18.029747f, 20.866687f, -18.003492f, 20.864135f, -17.957942f, 20.976990f, -17.928941f, 21.210167f,
                -18.026577f, 21.422779f, -17.633635f, 23.432855f, -18.211625f, 23.432855f, -18.208107f, 23.397462f, -18.174641f, 23.402951f,
                -18.082758f, 23.324181f, -18.051877f, 23.334834f, -18.000786f, 23.296928f, -18.000819f, 23.098367f, -18.317647f, 21.453045f,
                -18.317569f, 20.998950f, -18.849931f, 20.998919f, -18.849931f, 20.421428f
            )
            poly[890] = TzPolygon(
                -17.229817f, 22.935474f, -17.201125f, 22.896718f, -17.165340f, 22.801894f, -17.119929f, 22.791612f, -16.835108f, 22.492155f,
                -16.814755f, 22.496796f, -16.698761f, 22.350822f, -16.574116f, 22.252594f, -16.573296f, 22.218053f, -16.489624f, 22.149993f,
                -16.490233f, 22.120844f, -16.475143f, 22.148257f, -16.445372f, 22.125382f, -16.439482f, 22.139753f, -16.348122f, 22.120447f,
                -16.290252f, 22.070685f, -16.260905f, 22.081255f, -16.206397f, 21.999351f, -15.609703f, 22.000165f, -15.609703f, 23.432855f,
                -17.229817f, 23.432855f
            )
            poly[891] = TzPolygon(
                -19.748102f, 26.444282f, -19.744697f, 26.432339f, -19.671146f, 26.391709f, -19.664215f, 26.328035f, -19.614851f, 26.358608f,
                -19.576126f, 26.312335f, -19.585689f, 26.246967f, -19.546352f, 26.170226f, -19.272018f, 26.072390f, -19.107931f, 25.964528f,
                -19.066674f, 25.965343f, -19.031537f, 25.996584f, -18.912961f, 25.951755f, -18.849931f, 25.846455f, -18.849931f, 26.444282f
            )
            poly[892] = TzPolygon(
                -19.748102f, 26.444282f, -19.781724f, 26.562198f, -19.881291f, 26.618882f, -19.887721f, 26.702768f, -19.939910f, 26.726518f,
                -19.961765f, 26.851407f, -20.014502f, 26.978865f, -20.008846f, 27.040349f, -20.079619f, 27.143292f, -20.081983f, 27.205938f,
                -20.296348f, 27.300136f, -20.498942f, 27.288662f, -20.468192f, 27.362311f, -20.482061f, 27.433806f, -20.467510f, 27.471402f,
                -20.494201f, 27.576629f, -20.486707f, 27.683318f, -20.513677f, 27.723918f, -20.652845f, 27.702610f, -20.703761f, 27.733261f,
                -20.759789f, 27.732685f, -20.866187f, 27.693343f, -20.934278f, 27.689445f, -20.957827f, 27.710313f, -21.086888f, 27.693030f,
                -21.153116f, 27.750364f, -21.175350f, 27.805314f, -21.302692f, 27.904565f, -21.456975f, 27.977740f, -21.472804f, 27.957344f,
                -21.484932f, 27.983699f, -21.517502f, 27.970217f, -21.516316f, 28.002192f, -21.573912f, 28.018628f, -21.603347f, 28.199135f,
                -21.589378f, 28.293977f, -21.602516f, 28.365542f, -21.668870f, 28.502779f, -21.629399f, 28.579114f, -21.755742f, 28.862319f,
                -21.771061f, 28.999486f, -21.817848f, 29.076979f, -21.914718f, 29.020665f, -22.022263f, 29.053826f, -22.072104f, 29.139108f,
                -22.059798f, 29.247076f, -22.090159f, 29.275771f, -22.090159f, 26.444282f
            )
            poly[893] = TzPolygon(
                -18.039874f, 23.432855f, -18.039874f, 24.175314f, -18.110516f, 24.108073f, -18.110019f, 24.051326f, -18.138270f, 24.048775f,
                -18.204400f, 23.931496f, -18.250542f, 23.932093f, -18.273432f, 23.876851f, -18.326792f, 23.844551f, -18.339950f, 23.802913f,
                -18.384526f, 23.786992f, -18.435161f, 23.720056f, -18.430790f, 23.686975f, -18.502334f, 23.616093f, -18.480732f, 23.567644f,
                -18.337226f, 23.558774f, -18.321951f, 23.528879f, -18.273114f, 23.525821f, -18.241818f, 23.500418f, -18.236191f, 23.453127f,
                -18.212885f, 23.445530f, -18.211625f, 23.432855f
            )
            poly[894] = TzPolygon(-18.039874f, 24.593143f, -18.073872f, 24.575423f, -18.051251f, 24.522129f, -18.064622f, 24.505998f, -18.039874f, 24.494100f)
            poly[895] = TzPolygon(
                -18.039874f, 24.173869f, -18.019824f, 24.192544f, -18.011292f, 24.268679f, -18.036635f, 24.294548f, -17.949924f, 24.370599f,
                -17.951792f, 24.423463f, -17.963502f, 24.457381f, -18.039874f, 24.494100f
            )
            poly[896] = TzPolygon(
                -18.039874f, 24.593143f, -17.994370f, 24.616861f, -17.942878f, 24.699233f, -17.884268f, 24.739569f, -17.894948f, 24.757183f,
                -17.810075f, 24.911118f, -17.819921f, 24.931953f, -17.812516f, 24.938569f, -18.039874f, 24.938569f
            )
            poly[897] = TzPolygon(-17.635802f, 23.432855f, -17.637867f, 23.434227f, -17.638132f, 23.432855f)
            poly[898] = TzPolygon(
                -17.549689f, 24.938569f, -17.554446f, 24.907727f, -17.527279f, 24.879981f, -17.536660f, 24.794303f, -17.509190f, 24.782527f,
                -17.497208f, 24.708301f, -17.539443f, 24.563933f, -17.509323f, 24.545566f, -17.513252f, 24.512092f, -17.479853f, 24.453040f,
                -17.470193f, 24.387809f, -17.491693f, 24.269802f, -17.474161f, 24.248638f, -17.636332f, 23.432855f, -17.229817f, 23.432855f,
                -17.229817f, 24.938569f
            )
            poly[899] = TzPolygon(
                -18.849931f, 25.846455f, -18.837364f, 25.825460f, -18.624486f, 25.782445f, -18.573010f, 25.692199f, -18.496100f, 25.647495f,
                -18.477895f, 25.603795f, -18.383926f, 25.523552f, -18.152886f, 25.415663f, -18.078031f, 25.319001f, -18.039874f, 25.300513f,
                -18.039874f, 26.444282f, -18.849931f, 26.444282f
            )
        }
    }

    private object Initializer10 {
        fun init() {
            poly[900] = TzPolygon(
                -17.812516f, 24.938569f, -17.788046f, 24.960429f, -17.792741f, 24.982176f, -17.804521f, 24.964545f, -17.825925f, 24.976372f,
                -17.815657f, 25.004148f, -17.838283f, 25.013392f, -17.807759f, 25.054174f, -17.841003f, 25.066116f, -17.807969f, 25.143938f,
                -17.778137f, 25.163303f, -17.791365f, 25.262940f, -17.912609f, 25.237413f, -18.039874f, 25.300155f, -18.039874f, 24.938569f
            )
            poly[901] = TzPolygon(
                -18.039874f, 25.300513f, -17.909412f, 25.237300f, -17.791365f, 25.262940f, -17.852310f, 25.379105f, -17.843568f, 25.455194f,
                -17.865503f, 25.515618f, -17.839720f, 25.546672f, -17.847747f, 25.591566f, -17.809454f, 25.687795f, -17.815563f, 25.691426f,
                -18.039874f, 25.691426f
            )
            poly[902] = TzPolygon(
                -17.811541f, 25.691426f, -17.847747f, 25.591566f, -17.838300f, 25.551086f, -17.865503f, 25.515618f, -17.843568f, 25.455194f,
                -17.852310f, 25.379105f, -17.769096f, 25.227601f, -17.766644f, 25.188462f, -17.693179f, 25.131022f, -17.709795f, 25.095413f,
                -17.665325f, 25.104993f, -17.615653f, 25.065729f, -17.629176f, 25.044002f, -17.589939f, 25.047172f, -17.594884f, 25.001807f,
                -17.553996f, 24.980040f, -17.568836f, 24.944715f, -17.548708f, 24.944930f, -17.549689f, 24.938569f, -17.229817f, 24.938569f,
                -17.229817f, 25.691426f
            )
            poly[903] = TzPolygon(
                -17.811541f, 25.691426f, -17.229817f, 25.691426f, -17.229817f, 26.444282f, -17.957490f, 26.444282f, -17.936171f, 26.402297f,
                -17.917886f, 26.245236f, -17.884155f, 26.219680f, -17.934365f, 26.088939f, -17.950508f, 26.106232f, -17.980926f, 26.091825f,
                -17.976652f, 26.002708f, -18.002807f, 25.970460f, -17.974732f, 25.857411f, -17.911686f, 25.861065f, -17.852037f, 25.771967f,
                -17.838625f, 25.705132f, -17.810851f, 25.693328f
            )
            poly[904] = TzPolygon(
                -17.957490f, 26.444282f, -15.609703f, 26.444282f, -15.609703f, 29.455710f, -15.689937f, 29.455710f, -15.686468f, 29.415739f,
                -15.773155f, 29.213496f, -15.896434f, 29.048008f, -15.946526f, 29.013369f, -15.946578f, 28.928440f, -16.049160f, 28.845647f,
                -16.106913f, 28.869877f, -16.169391f, 28.838791f, -16.244067f, 28.857844f, -16.309486f, 28.820368f, -16.374302f, 28.851126f,
                -16.485549f, 28.815597f, -16.554306f, 28.735598f, -16.571297f, 28.642126f, -16.717970f, 28.269093f, -16.824720f, 28.135280f,
                -16.962498f, 27.829325f, -17.246623f, 27.630024f, -17.332630f, 27.624358f, -17.423784f, 27.543205f, -17.598943f, 27.311201f,
                -17.806452f, 27.144094f, -17.837013f, 27.152956f, -17.960873f, 27.042654f, -17.990846f, 26.836527f, -18.023852f, 26.803076f,
                -18.031394f, 26.732018f, -18.076594f, 26.695784f, -18.048905f, 26.598637f, -17.987772f, 26.563328f, -17.990030f, 26.508368f
            )
            poly[905] = TzPolygon(
                -26.920943f, 33.102357f, -26.857967f, 32.902228f, -26.863920f, 32.331050f, -26.832830f, 32.219200f, -26.863190f, 32.183970f,
                -26.840262f, 32.134622f, -26.527250f, 32.134992f, -26.405646f, 32.077418f, -26.161684f, 32.105350f, -26.008525f, 32.087300f,
                -25.996945f, 32.003050f, -25.840770f, 31.930550f, -25.645194f, 32.006099f, -25.474690f, 31.977400f, -25.382500f, 32.015280f,
                -25.132539f, 32.033716f, -24.302200f, 31.987130f, -24.181792f, 31.908179f, -23.952489f, 31.880591f, -23.884862f, 31.767769f,
                -23.805513f, 31.733502f, -23.805513f, 33.102357f
            )
            poly[906] = TzPolygon(
                -25.718760f, 31.416300f, -25.999600f, 31.867860f, -25.952646f, 31.975191f, -25.996945f, 32.003050f, -26.008525f, 32.087300f,
                -26.161684f, 32.105350f, -26.405646f, 32.077418f, -26.527250f, 32.134992f, -26.840262f, 32.134622f, -26.804590f, 32.098240f,
                -26.810195f, 32.011348f, -27.116410f, 31.974550f, -27.317520f, 31.977760f, -27.315160f, 31.493690f, -27.202080f, 31.150550f,
                -27.036980f, 30.984760f, -26.992129f, 30.958326f, -26.908210f, 30.973560f, -26.859930f, 30.907420f, -26.785060f, 30.891910f,
                -26.844427f, 30.813209f, -26.712290f, 30.790800f, -26.466671f, 30.805060f, -26.320820f, 30.891860f, -26.261732f, 30.961438f,
                -25.921150f, 31.126570f, -25.743040f, 31.315940f
            )
            poly[907] = TzPolygon(
                -21.756560f, 29.455710f, -21.756560f, 31.982437f, -22.181870f, 31.574497f, -22.424110f, 31.307377f, -22.367550f, 31.268500f,
                -22.368690f, 31.213100f, -22.330700f, 31.171570f, -22.349164f, 31.088906f, -22.292080f, 30.839170f, -22.310960f, 30.663260f,
                -22.336290f, 30.631680f, -22.316350f, 30.489390f, -22.356250f, 30.290240f, -22.295860f, 30.231140f, -22.311050f, 30.126170f,
                -22.253630f, 30.025630f, -22.228940f, 30.017600f, -22.224170f, 29.969890f, -22.189930f, 29.925720f, -22.194560f, 29.884530f,
                -22.141420f, 29.773590f, -22.125110f, 29.656710f, -22.155690f, 29.610240f, -22.140900f, 29.580220f, -22.152660f, 29.539250f,
                -22.178000f, 29.527960f, -22.166120f, 29.464120f, -22.168830f, 29.455710f
            )
            poly[908] = TzPolygon(
                -23.805513f, 31.733502f, -23.721890f, 31.697390f, -23.625529f, 31.689984f, -23.481960f, 31.561020f, -23.198230f, 31.563600f,
                -22.424110f, 31.307377f, -22.181870f, 31.574497f, -21.756560f, 31.982437f, -21.756560f, 33.102357f, -23.805513f, 33.102357f
            )
            poly[909] = TzPolygon(
                -21.756560f, 31.982437f, -21.315388f, 32.405591f, -21.328108f, 32.480015f, -21.206570f, 32.399330f, -21.169890f, 32.405830f,
                -21.136680f, 32.366720f, -21.011780f, 32.468410f, -20.914370f, 32.516840f, -20.618550f, 32.492050f, -20.560860f, 32.567070f,
                -20.556175f, 32.668133f, -20.339190f, 32.807845f, -20.287060f, 32.863990f, -20.234604f, 32.871498f, -20.221889f, 32.846421f,
                -20.195573f, 32.847788f, -20.187260f, 32.875544f, -20.124425f, 32.867089f, -20.126717f, 32.923628f, -20.038560f, 32.949518f,
                -20.034564f, 33.028814f, -19.776760f, 33.062782f, -19.723096f, 32.958720f, -19.707608f, 32.962356f, -19.707608f, 33.102357f,
                -21.756560f, 33.102357f
            )
            poly[910] = TzPolygon(
                -19.707608f, 32.962356f, -19.651273f, 32.975583f, -19.684140f, 32.892098f, -19.673529f, 32.834432f, -19.618549f, 32.857374f,
                -19.483646f, 32.845370f, -19.459900f, 32.777187f, -19.361320f, 32.776410f, -19.293630f, 32.849840f, -19.097870f, 32.877400f,
                -19.016390f, 32.833460f, -19.025069f, 32.713745f, -18.938757f, 32.698944f, -18.927924f, 32.735110f, -18.833630f, 32.711910f,
                -18.781340f, 32.813740f, -18.796280f, 32.892420f, -18.766280f, 32.927790f, -18.690190f, 32.954120f, -18.579074f, 32.885902f,
                -18.514440f, 32.887024f, -18.473269f, 32.978940f, -18.503376f, 32.984589f, -18.497591f, 33.020476f, -18.421125f, 33.018644f,
                -18.348660f, 33.068341f, -18.298522f, 33.016154f, -18.228579f, 33.021657f, -18.136801f, 32.972197f, -18.112054f, 32.982062f,
                -18.029428f, 32.950907f, -18.032621f, 32.936014f, -18.000010f, 32.955700f, -17.984939f, 32.937601f, -17.917999f, 32.983420f,
                -17.913181f, 32.953000f, -17.814939f, 32.960563f, -17.802794f, 33.018321f, -17.748261f, 33.029597f, -17.731547f, 33.007278f,
                -17.722220f, 33.029071f, -17.688635f, 33.015737f, -17.658655f, 33.029451f, -17.658655f, 33.102357f, -19.707608f, 33.102357f
            )
            poly[911] = TzPolygon(
                -15.609703f, 30.409697f, -15.622543f, 30.418988f, -15.655607f, 30.354065f, -15.627950f, 30.260218f, -15.668572f, 30.215112f,
                -15.618760f, 30.162200f, -15.643534f, 29.970554f, -15.609937f, 29.824518f, -15.692642f, 29.486878f, -15.689937f, 29.455710f,
                -15.609703f, 29.455710f
            )
            poly[912] = TzPolygon(
                -16.005896f, 31.279033f, -16.007075f, 31.188227f, -15.983640f, 31.140415f, -16.016002f, 31.072365f, -15.996799f, 31.063163f,
                -16.060462f, 30.992286f, -15.999772f, 30.922465f, -15.999772f, 30.424565f, -15.628041f, 30.425125f, -15.609703f, 30.413147f,
                -15.609703f, 31.279033f
            )
            poly[913] = TzPolygon(
                -16.005896f, 31.279033f, -16.047333f, 31.344566f, -16.137150f, 31.404530f, -16.143692f, 31.434638f, -16.160553f, 31.427516f,
                -16.179633f, 31.630136f, -16.236710f, 31.770810f, -16.312560f, 31.835850f, -16.336470f, 31.893790f, -16.412870f, 31.913480f,
                -16.442370f, 32.037540f, -16.449170f, 32.344180f, -16.599970f, 32.709160f, -16.685540f, 32.709180f, -16.719202f, 32.887977f,
                -16.696047f, 32.923133f, -16.706877f, 32.978682f, -16.894220f, 32.912210f, -16.920759f, 32.835674f, -17.179280f, 32.986520f,
                -17.308570f, 32.997410f, -17.342273f, 33.052393f, -17.398695f, 33.004403f, -17.453704f, 33.000103f, -17.479926f, 32.965432f,
                -17.559455f, 32.983556f, -17.604780f, 33.054097f, -17.658655f, 33.029451f, -17.658655f, 31.279033f
            )
            poly[914] = TzPolygon(
                -16.684630f, 34.883663f, -16.675904f, 34.858255f, -16.607233f, 34.842530f, -16.585916f, 34.772473f, -16.549196f, 34.777199f,
                -16.512777f, 34.752435f, -16.502974f, 34.682276f, -16.438471f, 34.681017f, -16.453223f, 34.652059f, -16.417862f, 34.593880f,
                -16.314358f, 34.570420f, -16.279880f, 34.524020f, -16.296385f, 34.490161f, -16.264299f, 34.430902f, -16.185296f, 34.397689f,
                -16.043250f, 34.430168f, -16.026037f, 34.388325f, -15.964151f, 34.355377f, -15.920721f, 34.260136f, -15.896627f, 34.251476f,
                -15.796756f, 34.271990f, -15.744283f, 34.326264f, -15.742514f, 34.364462f, -15.685952f, 34.391429f, -15.664698f, 34.435165f,
                -15.619143f, 34.433392f, -15.609703f, 34.456021f, -15.609703f, 34.883663f
            )
            poly[915] = TzPolygon(
                -16.684630f, 34.883663f, -15.609703f, 34.883663f, -15.609703f, 35.836385f, -15.964683f, 35.805229f, -16.027691f, 35.817639f,
                -16.101207f, 35.712291f, -16.095725f, 35.673002f, -16.133709f, 35.593852f, -16.121635f, 35.557502f, -16.168212f, 35.523250f,
                -16.120582f, 35.486620f, -16.113850f, 35.429637f, -16.229426f, 35.297298f, -16.325814f, 35.278330f, -16.345718f, 35.302873f,
                -16.398664f, 35.263227f, -16.474995f, 35.261919f, -16.562337f, 35.143452f, -16.619576f, 35.166977f, -16.646504f, 35.228464f,
                -16.710325f, 35.288627f, -16.796314f, 35.289518f, -16.830480f, 35.314675f, -16.940035f, 35.263092f, -16.981560f, 35.304862f,
                -17.034534f, 35.291951f, -17.062452f, 35.313826f, -17.123229f, 35.309137f, -17.129603f, 35.097395f, -17.107984f, 35.077968f,
                -17.087249f, 35.108522f, -17.049395f, 35.056540f, -17.010473f, 35.051049f, -16.937869f, 35.171517f, -16.873946f, 35.146241f,
                -16.839772f, 35.157457f, -16.818120f, 35.135828f, -16.828814f, 35.041798f, -16.789006f, 34.990092f, -16.748933f, 34.984715f,
                -16.747367f, 34.919660f, -16.693700f, 34.910070f
            )
            poly[916] = TzPolygon(
                -15.609703f, 22.000165f, -12.999688f, 22.003724f, -13.000767f, 24.058127f, -12.896038f, 23.981923f, -12.893796f, 23.939792f,
                -12.840515f, 23.893522f, -12.761026f, 23.899034f, -12.698194f, 23.932934f, -12.668182f, 23.923162f, -12.593419f, 23.959855f,
                -12.537001f, 23.947902f, -12.424420f, 24.065636f, -12.380775f, 24.077272f, -12.333960f, 24.043014f, -12.310366f, 24.066851f,
                -12.269437f, 24.062446f, -12.208033f, 23.999944f, -12.136440f, 23.980392f, -11.855963f, 23.998018f, -11.829245f, 24.023031f,
                -11.660648f, 23.960555f, -11.531225f, 24.037901f, -11.446033f, 24.024138f, -11.404498f, 24.087886f, -15.609703f, 24.087886f
            )
            poly[917] = TzPolygon(
                -5.867515f, 14.907735f, -5.877845f, 14.699551f, -5.904712f, 14.595772f, -5.891823f, 14.347963f, -5.857074f, 14.282713f,
                -5.880785f, 14.238951f, -5.869412f, 14.197609f, -5.840477f, 14.187767f, -5.852343f, 14.039940f, -5.826426f, 13.999907f,
                -5.850908f, 13.959918f, -5.867939f, 13.587086f, -5.886523f, 13.560470f, -5.862452f, 13.514261f, -5.860113f, 13.430998f,
                -5.872514f, 13.377478f, -5.908990f, 13.354151f, -5.861911f, 13.222670f, -5.903476f, 13.113667f, -5.872514f, 13.088219f,
                -5.863608f, 13.042413f, -5.912383f, 12.951224f, -5.924259f, 12.855794f, -5.998058f, 12.751033f, -6.078219f, 12.444385f,
                -6.068181f, 12.389689f, -6.005789f, 12.312360f, -5.990189f, 12.114648f, -5.889632f, 12.039074f, -5.752477f, 12.219062f,
                -5.742117f, 12.528415f, -5.149089f, 12.533084f, -5.149089f, 14.907735f
            )
            poly[918] = TzPolygon(
                -6.712941f, 16.771898f, -6.712941f, 17.967785f, -8.087427f, 17.967785f, -8.080841f, 17.870074f, -8.113420f, 17.796611f,
                -8.100739f, 17.678324f, -8.131037f, 17.612268f, -8.128663f, 17.566153f, -8.079336f, 17.504682f, -8.045711f, 17.532371f,
                -8.002273f, 17.481941f, -7.949277f, 17.481474f, -7.942796f, 17.450823f, -7.870888f, 17.449754f, -7.866007f, 17.422205f,
                -7.834279f, 17.424047f, -7.840260f, 17.392525f, -7.813750f, 17.395307f, -7.823937f, 17.378225f, -7.776850f, 17.380859f,
                -7.779502f, 17.331442f, -7.752041f, 17.318778f, -7.719129f, 17.333772f, -7.692851f, 17.290026f, -7.622997f, 17.295933f,
                -7.580912f, 17.218914f, -7.497431f, 17.196353f, -7.470029f, 17.150176f, -7.427987f, 17.179530f, -7.403985f, 17.139190f,
                -7.424072f, 17.107089f, -7.349848f, 17.106231f, -7.295705f, 17.026065f, -7.292640f, 16.980403f, -7.233893f, 16.940578f,
                -7.203291f, 16.956607f, -7.105302f, 16.915687f, -7.117396f, 16.951564f, -7.053344f, 16.966670f, -7.021144f, 16.932166f,
                -7.023700f, 16.906074f, -6.909536f, 16.910709f, -6.879201f, 16.879295f, -6.881417f, 16.841014f, -6.824491f, 16.841358f,
                -6.800458f, 16.807712f, -6.731419f, 16.800331f
            )
            poly[919] = TzPolygon(
                -5.867515f, 14.907735f, -5.865682f, 14.944686f, -5.870391f, 16.424045f, -5.844012f, 16.491970f, -5.873342f, 16.577215f,
                -5.941343f, 16.576990f, -5.949734f, 16.603515f, -6.031511f, 16.587894f, -6.037144f, 16.624114f, -6.060165f, 16.599477f,
                -6.065140f, 16.644370f, -6.096889f, 16.636130f, -6.108667f, 16.688315f, -6.165673f, 16.730029f, -6.207245f, 16.703665f,
                -6.331354f, 16.720361f, -6.334030f, 16.676593f, -6.355352f, 16.694567f, -6.386121f, 16.678992f, -6.404484f, 16.723406f,
                -6.424688f, 16.695455f, -6.450201f, 16.718256f, -6.481435f, 16.708492f, -6.522611f, 16.752035f, -6.578477f, 16.731494f,
                -6.602692f, 16.756729f, -6.707211f, 16.763080f, -6.712941f, 16.771898f, -6.712941f, 14.907735f
            )
            poly[920] = TzPolygon(
                -9.840646f, 22.557861f, -11.039479f, 22.557861f, -11.039479f, 22.508930f, -11.064330f, 22.488848f, -11.111912f, 22.502364f,
                -11.167759f, 22.450266f, -11.182424f, 22.346240f, -11.236191f, 22.311464f, -11.264140f, 22.249898f, -11.178218f, 22.268516f,
                -11.109652f, 22.215734f, -10.935395f, 22.204812f, -10.866104f, 22.166880f, -10.809057f, 22.223055f, -10.760136f, 22.328300f,
                -10.665363f, 22.307268f, -10.564175f, 22.316125f, -10.530416f, 22.307143f, -10.507853f, 22.271488f, -10.379555f, 22.326257f,
                -10.157618f, 22.215177f, -10.071112f, 22.221668f, -9.921277f, 22.186838f, -9.869989f, 22.111170f, -9.874921f, 22.069119f,
                -9.840646f, 22.033681f
            )
            poly[921] = TzPolygon(
                -10.901448f, 24.087886f, -10.887911f, 24.061981f, -10.905935f, 23.973169f, -11.035274f, 23.862838f, -10.987303f, 23.759381f,
                -11.003144f, 23.668621f, -10.940670f, 23.514014f, -10.946651f, 23.428588f, -11.108579f, 23.195145f, -11.081545f, 23.152533f,
                -11.113367f, 23.081251f, -11.090637f, 23.040761f, -11.086697f, 22.906682f, -11.062694f, 22.863039f, -11.118398f, 22.773269f,
                -11.113307f, 22.709927f, -11.070574f, 22.633432f, -11.039479f, 22.618339f, -11.039479f, 22.557861f, -9.840646f, 22.557861f,
                -9.840646f, 24.087886f
            )
            poly[922] = TzPolygon(
                -11.404498f, 24.087886f, -11.274737f, 24.031326f, -11.139054f, 24.035376f, -11.117166f, 24.001019f, -11.098018f, 24.021792f,
                -10.984795f, 24.024016f, -10.942299f, 24.018016f, -10.911178f, 23.980528f, -10.889962f, 23.999872f, -10.902345f, 24.087886f
            )
            poly[923] = TzPolygon(
                -9.840646f, 22.033681f, -9.821243f, 22.013620f, -9.749868f, 21.997780f, -9.761299f, 21.977561f, -9.686916f, 21.936724f,
                -9.650331f, 21.874344f, -9.456616f, 21.830953f, -9.417920f, 21.791151f, -9.227482f, 21.859537f, -9.098000f, 21.834214f,
                -9.043972f, 21.856104f, -8.854432f, 21.861063f, -8.785758f, 21.895816f, -8.700399f, 21.892762f, -8.559885f, 21.942593f,
                -8.525983f, 21.930005f, -8.504907f, 21.953438f, -8.440467f, 21.949169f, -8.394006f, 21.918374f, -8.327432f, 21.932700f,
                -8.291163f, 21.892738f, -8.276794f, 21.891596f, -8.276794f, 24.087886f, -9.840646f, 24.087886f
            )
            poly[924] = TzPolygon(
                -6.712941f, 17.967785f, -6.712941f, 19.800099f, -6.769233f, 19.838663f, -6.860497f, 19.931594f, -6.991553f, 19.975228f,
                -7.000000f, 19.547955f, -7.055530f, 19.562227f, -7.167522f, 19.498509f, -7.243994f, 19.507977f, -7.315709f, 19.485356f,
                -7.457670f, 19.544568f, -7.504452f, 19.486200f, -7.571971f, 19.473334f, -7.571945f, 19.383207f, -7.591308f, 19.368572f,
                -7.701570f, 19.412430f, -7.901446f, 19.341656f, -7.909022f, 19.360379f, -8.000000f, 19.381333f, -8.000000f, 18.796451f,
                -7.913366f, 18.767612f, -7.916667f, 18.530592f, -8.000000f, 18.531911f, -8.000000f, 18.407325f, -8.024685f, 18.359153f,
                -7.977444f, 18.213838f, -8.036904f, 18.140164f, -8.029180f, 18.105867f, -8.096584f, 18.103629f, -8.087427f, 17.967785f
            )
            poly[925] = TzPolygon(
                -6.712941f, 19.800099f, -6.712941f, 21.027836f, -7.283333f, 21.027836f, -7.283333f, 20.553021f, -7.166636f, 20.562136f,
                -7.145907f, 20.546096f, -7.062430f, 20.594792f, -6.916668f, 20.627162f, -6.916667f, 20.321995f, -7.000000f, 20.302885f,
                -7.000045f, 19.966205f, -6.860497f, 19.931594f, -6.769233f, 19.838663f
            )
            poly[926] = TzPolygon(
                -6.712941f, 19.800099f, -6.583970f, 19.711743f, -6.529964f, 19.698210f, -6.425275f, 19.720918f, -6.345803f, 19.684782f,
                -6.302101f, 19.698657f, -6.242268f, 19.673775f, -6.164736f, 19.691198f, -6.043719f, 19.871099f, -6.019136f, 19.876593f,
                -6.032623f, 19.892900f, -6.007186f, 19.951952f, -5.955797f, 20.014952f, -5.867806f, 20.049235f, -5.843778f, 20.107026f,
                -5.798180f, 20.117669f, -5.746601f, 20.166421f, -5.631813f, 20.180669f, -5.546353f, 20.130119f, -5.418196f, 20.126857f,
                -5.350347f, 20.137328f, -5.283687f, 20.195693f, -5.187274f, 20.205135f, -5.149089f, 20.196621f, -5.149089f, 21.027836f,
                -6.712941f, 21.027836f
            )
            poly[927] = TzPolygon(
                -7.283333f, 21.027836f, -7.283333f, 21.789226f, -7.374855f, 21.843902f, -7.409034f, 21.835182f, -7.426874f, 21.859344f,
                -7.524345f, 21.842205f, -7.560966f, 21.859528f, -7.775054f, 21.776160f, -7.907684f, 21.777607f, -7.940019f, 21.751542f,
                -8.028953f, 21.776265f, -8.070117f, 21.823821f, -8.143018f, 21.849238f, -8.176350f, 21.883612f, -8.276794f, 21.891596f,
                -8.276794f, 21.027836f
            )
            poly[928] = TzPolygon(-13.998540f, 33.239352f, -14.001513f, 33.205300f, -13.998540f, 33.203646f)
            poly[929] = TzPolygon(-13.998540f, 33.068531f, -14.021592f, 33.065137f, -14.049778f, 33.022606f, -14.018389f, 32.990661f, -13.998540f, 32.992559f)
            poly[930] = TzPolygon(
                -15.609703f, 30.413147f, -15.539029f, 30.366985f, -15.476359f, 30.401596f, -15.437229f, 30.376962f, -15.369604f, 30.384837f,
                -15.322259f, 30.363208f, -15.264305f, 30.283214f, -15.087157f, 30.213820f, -15.035977f, 30.234805f, -14.996583f, 30.216723f,
                -14.959570f, 30.365150f, -14.784650f, 30.796370f, -14.620160f, 31.472610f, -14.506430f, 31.683310f, -14.323340f, 32.241370f,
                -14.282690f, 32.451430f, -13.998540f, 33.220324f, -14.006477f, 33.239352f, -15.609703f, 33.239352f
            )
            poly[931] = TzPolygon(
                -13.998540f, 33.242700f, -13.998540f, 33.701099f, -14.589984f, 33.701099f, -14.615774f, 33.665131f, -14.587152f, 33.634241f,
                -14.492111f, 33.607900f, -14.478512f, 33.562280f, -14.419739f, 33.528445f, -14.400989f, 33.470172f, -14.219747f, 33.385076f,
                -14.216961f, 33.341943f, -14.148215f, 33.298586f, -14.084435f, 33.322230f, -14.031888f, 33.300272f
            )
            poly[932] = TzPolygon(
                -11.823031f, 25.764102f, -11.816750f, 25.714760f, -11.731434f, 25.651065f, -11.734490f, 25.595910f, -11.791291f, 25.505670f,
                -11.682411f, 25.472349f, -11.626927f, 25.331983f, -11.580359f, 25.330556f, -11.519321f, 25.292853f, -11.494546f, 25.332053f,
                -11.487744f, 25.308400f, -11.356714f, 25.280046f, -11.346894f, 25.313482f, -11.305892f, 25.292007f, -11.280765f, 25.338032f,
                -11.259901f, 25.316404f, -11.196125f, 25.352400f, -11.191711f, 25.302179f, -11.254733f, 25.118359f, -11.245046f, 25.027824f,
                -11.274559f, 24.911632f, -11.266343f, 24.870439f, -11.296760f, 24.850607f, -11.303085f, 24.750497f, -11.316402f, 24.728572f,
                -11.331222f, 24.738843f, -11.333118f, 24.694038f, -11.401220f, 24.641617f, -11.419831f, 24.591436f, -11.452883f, 24.584336f,
                -11.467194f, 24.441231f, -11.427029f, 24.419887f, -11.388312f, 24.279586f, -11.353204f, 24.358136f, -11.264614f, 24.401644f,
                -11.199923f, 24.401878f, -11.173626f, 24.377202f, -11.134911f, 24.384727f, -11.134911f, 25.764102f
            )
            poly[933] = TzPolygon(
                -11.823031f, 25.764102f, -11.830624f, 25.823751f, -11.808262f, 25.886943f, -11.868917f, 25.905824f, -11.907207f, 25.992159f,
                -11.947892f, 25.979775f, -11.937984f, 26.185564f, -11.920791f, 26.208133f, -11.963600f, 26.312734f, -11.910467f, 26.428331f,
                -11.918636f, 26.477932f, -11.952005f, 26.499932f, -11.985886f, 26.572340f, -11.967245f, 26.590981f, -12.006384f, 26.709163f,
                -11.955406f, 26.774466f, -11.986999f, 26.819525f, -11.984942f, 26.877597f, -11.919365f, 26.958063f, -11.842405f, 27.006920f,
                -11.749231f, 27.003863f, -11.707180f, 27.047559f, -11.614822f, 27.017862f, -11.593114f, 27.050343f, -11.601346f, 27.159405f,
                -11.563135f, 27.205080f, -11.683375f, 27.235382f, -11.785262f, 27.229350f, -11.830651f, 27.338889f, -11.911020f, 27.440317f,
                -13.998540f, 27.440317f, -13.998540f, 25.764102f
            )
            poly[934] = TzPolygon(
                -10.902345f, 24.087886f, -10.906289f, 24.115917f, -11.041632f, 24.149793f, -11.020549f, 24.186209f, -11.050664f, 24.244839f,
                -11.041385f, 24.301896f, -11.085121f, 24.379338f, -11.121481f, 24.392538f, -11.134911f, 24.388588f, -11.134911f, 24.087886f
            )
            poly[935] = TzPolygon(
                -12.566726f, 28.452285f, -12.566726f, 29.116533f, -13.368983f, 29.116533f, -13.423191f, 29.005688f, -13.389286f, 28.983248f,
                -13.368536f, 28.997128f, -13.375155f, 28.961744f, -13.164316f, 28.903924f, -13.145768f, 28.838489f, -13.005010f, 28.825697f,
                -12.938614f, 28.782722f, -12.941587f, 28.753871f, -12.881256f, 28.728959f, -12.814737f, 28.653806f, -12.832944f, 28.609886f,
                -12.896985f, 28.582595f, -12.897398f, 28.565177f, -12.852727f, 28.536460f, -12.823484f, 28.542954f, -12.731551f, 28.456652f,
                -12.696603f, 28.461419f, -12.686580f, 28.512810f, -12.637666f, 28.534695f
            )
            poly[936] = TzPolygon(
                -11.911020f, 27.440317f, -11.928770f, 27.462719f, -12.052970f, 27.470110f, -12.058726f, 27.497603f, -12.177275f, 27.533615f,
                -12.221871f, 27.616450f, -12.270365f, 27.622486f, -12.293204f, 27.762703f, -12.251378f, 27.814991f, -12.221684f, 27.812213f,
                -12.241167f, 27.931962f, -12.314518f, 27.961017f, -12.359039f, 27.955799f, -12.338543f, 27.990861f, -12.348846f, 28.078981f,
                -12.439015f, 28.122414f, -12.427941f, 28.150155f, -12.398811f, 28.145350f, -12.377714f, 28.170726f, -12.422498f, 28.230338f,
                -12.407943f, 28.257577f, -12.425032f, 28.278425f, -12.566726f, 28.278425f, -12.566726f, 27.440317f
            )
            poly[937] = TzPolygon(
                -12.425032f, 28.278425f, -12.426979f, 28.280801f, -12.419597f, 28.322832f, -12.500387f, 28.399142f, -12.516378f, 28.447980f,
                -12.553842f, 28.437319f, -12.566726f, 28.452285f, -12.566726f, 28.278425f
            )
            poly[938] = TzPolygon(
                -12.386409f, 29.116533f, -12.375373f, 29.107468f, -12.384325f, 29.042280f, -12.285352f, 29.005695f, -12.172418f, 28.917526f,
                -12.147125f, 28.865528f, -12.046430f, 28.776206f, -11.979122f, 28.754472f, -11.984396f, 28.700062f, -11.908313f, 28.615380f,
                -11.883454f, 28.494273f, -11.844988f, 28.493235f, -11.828124f, 28.474798f, -11.840093f, 28.452747f, -11.815959f, 28.435590f,
                -11.775235f, 28.455284f, -11.724293f, 28.418661f, -11.651344f, 28.433904f, -11.591444f, 28.387422f, -11.545145f, 28.385353f,
                -11.391228f, 28.425843f, -11.370566f, 28.456353f, -11.298698f, 28.453816f, -11.240116f, 28.489466f, -11.146942f, 28.499752f,
                -11.134911f, 28.493335f, -11.134911f, 29.116533f
            )
            poly[939] = TzPolygon(
                -13.368983f, 29.116533f, -12.386409f, 29.116533f, -12.396716f, 29.124999f, -12.360570f, 29.269548f, -12.422088f, 29.321749f,
                -12.412663f, 29.373651f, -12.460158f, 29.479430f, -12.405572f, 29.530482f, -12.396720f, 29.488983f, -12.333966f, 29.460594f,
                -12.249399f, 29.482381f, -12.230770f, 29.531333f, -12.181820f, 29.575085f, -12.221337f, 29.616833f, -12.232164f, 29.681504f,
                -12.204092f, 29.737555f, -12.149369f, 29.772546f, -12.149947f, 29.814790f, -13.444499f, 29.814759f, -13.433170f, 29.776424f,
                -13.459035f, 29.726404f, -13.424006f, 29.672409f, -13.433105f, 29.639046f, -13.403673f, 29.613116f, -13.375137f, 29.621703f,
                -13.363390f, 29.604829f, -13.349763f, 29.649939f, -13.294444f, 29.646308f, -13.251555f, 29.682661f, -13.224600f, 29.675014f,
                -13.243567f, 29.640883f, -13.203668f, 29.585563f, -13.247970f, 29.504409f, -13.313285f, 29.441285f, -13.325537f, 29.361616f,
                -13.353148f, 29.351998f, -13.333942f, 29.316159f, -13.374752f, 29.297604f, -13.448835f, 29.178509f, -13.404249f, 29.166373f,
                -13.367511f, 29.119544f
            )
            poly[940] = TzPolygon(
                -11.134911f, 28.493335f, -11.103479f, 28.476571f, -11.020340f, 28.512599f, -10.970210f, 28.510365f, -10.947537f, 28.540304f,
                -10.847130f, 28.549417f, -10.768615f, 28.603769f, -10.724992f, 28.608726f, -10.722300f, 28.662335f, -10.683519f, 28.663692f,
                -10.673800f, 28.697246f, -10.637592f, 28.688393f, -10.626490f, 28.659173f, -10.563421f, 28.673458f, -10.518294f, 28.629829f,
                -10.449687f, 28.647545f, -10.364691f, 28.618374f, -10.299902f, 28.634357f, -10.226195f, 28.575822f, -10.163785f, 28.626856f,
                -10.046194f, 28.644290f, -9.997119f, 28.621223f, -9.944905f, 28.627850f, -9.811769f, 28.675746f, -9.801607f, 28.696679f,
                -9.751002f, 28.668470f, -9.746895f, 28.635796f, -9.718205f, 28.618234f, -9.697828f, 28.631098f, -9.592655f, 28.612234f,
                -9.575947f, 28.581133f, -9.552457f, 28.618911f, -9.557359f, 28.576728f, -9.484813f, 28.571904f, -9.478083f, 28.535243f,
                -9.454917f, 28.537078f, -9.448200f, 28.513287f, -9.358889f, 28.520833f, -9.311667f, 28.402222f, -9.260833f, 28.372222f,
                -9.228889f, 28.395556f, -9.093889f, 28.622500f, -8.840000f, 28.860833f, -8.667778f, 28.961667f, -8.546944f, 28.937500f,
                -8.479167f, 28.896944f, -8.271282f, 30.792749f, -11.134911f, 30.792749f
            )
            poly[941] = TzPolygon(
                -8.265476f, 30.792749f, -7.970278f, 30.696944f, -7.580278f, 30.455833f, -7.356389f, 30.406944f, -7.136944f, 30.311389f,
                -6.962500f, 30.188333f, -6.860278f, 30.082500f, -6.755278f, 29.891389f, -6.627500f, 29.732500f, -6.455556f, 29.661111f,
                -6.300833f, 29.552500f, -5.991389f, 29.495833f, -5.918889f, 29.518889f, -5.798889f, 29.614167f, -5.697222f, 29.628333f,
                -5.184444f, 29.458611f, -5.149089f, 29.440749f, -5.149089f, 30.792749f
            )
            poly[942] = TzPolygon(
                -11.786177f, 30.792749f, -11.786177f, 33.328851f, -11.890052f, 33.327606f, -11.923663f, 33.348439f, -12.140198f, 33.256902f,
                -12.186765f, 33.307413f, -12.248652f, 33.311437f, -12.347920f, 33.376109f, -12.325448f, 33.475501f, -12.363927f, 33.548555f,
                -12.421672f, 33.492002f, -12.417455f, 33.473736f, -12.474728f, 33.458669f, -12.553990f, 33.375399f, -12.532783f, 33.334224f,
                -12.548461f, 33.271888f, -12.637663f, 33.179940f, -12.613542f, 33.181313f, -12.598464f, 33.152817f, -12.599172f, 33.048669f,
                -12.768230f, 32.937075f, -12.860822f, 32.954801f, -12.903850f, 33.020353f, -13.112252f, 32.983961f, -13.210203f, 33.006792f,
                -13.298619f, 32.943391f, -13.405888f, 32.920106f, -13.463110f, 32.887606f, -13.468943f, 32.859828f, -13.525849f, 32.847688f,
                -13.576721f, 32.747328f, -13.559227f, 32.697312f, -13.574746f, 32.670362f, -13.639499f, 32.692606f, -13.649500f, 32.783717f,
                -13.707556f, 32.842050f, -13.785056f, 32.768717f, -13.815889f, 32.809272f, -13.839778f, 32.910384f, -13.883389f, 32.917328f,
                -13.942833f, 32.997884f, -13.998540f, 32.992559f, -13.998540f, 30.792749f
            )
            poly[943] = TzPolygon(-13.998540f, 33.068531f, -13.986615f, 33.070287f, -13.961167f, 33.135384f, -13.922746f, 33.161491f, -13.998540f, 33.215808f)
            poly[944] = TzPolygon(
                -9.573815f, 33.418387f, -9.573815f, 33.701099f, -9.611583f, 33.701099f, -9.614468f, 33.698889f, -9.579288f, 33.586555f,
                -9.625868f, 33.510781f, -9.614252f, 33.443259f
            )
            poly[945] = TzPolygon(
                -9.573815f, 33.004886f, -9.626094f, 32.996071f, -9.616094f, 33.060516f, -9.665816f, 33.099682f, -9.586650f, 33.113571f,
                -9.603039f, 33.206071f, -9.792761f, 33.296904f, -9.823039f, 33.361904f, -9.912205f, 33.391071f, -9.936094f, 33.360238f,
                -10.051111f, 33.315266f, -10.212222f, 33.555266f, -10.341944f, 33.544432f, -10.462500f, 33.636099f, -10.510484f, 33.636934f,
                -10.577446f, 33.676825f, -10.568333f, 33.701099f, -10.702222f, 33.553333f, -10.776389f, 33.510556f, -10.807778f, 33.453611f,
                -10.793056f, 33.413056f, -10.807500f, 33.359722f, -10.861750f, 33.316356f, -10.845556f, 33.280278f, -10.889167f, 33.259167f,
                -10.938889f, 33.305000f, -11.070554f, 33.328029f, -11.158114f, 33.404576f, -11.235912f, 33.379685f, -11.376497f, 33.289405f,
                -11.433939f, 33.292884f, -11.403196f, 33.243757f, -11.417835f, 33.230710f, -11.474773f, 33.255939f, -11.587551f, 33.242884f,
                -11.611996f, 33.330939f, -11.786177f, 33.328851f, -11.786177f, 30.792749f, -9.573815f, 30.792749f
            )
            poly[946] = TzPolygon(
                -9.573815f, 33.002741f, -9.507483f, 33.016071f, -9.415387f, 32.948084f, -9.368326f, 32.992709f, -9.493295f, 33.144293f,
                -9.509750f, 33.212448f, -9.488116f, 33.244833f, -9.500823f, 33.278236f, -9.486112f, 33.326002f, -9.535027f, 33.394529f,
                -9.573815f, 33.418387f
            )
            poly[947] = TzPolygon(
                -8.271282f, 30.792749f, -8.538316f, 30.978071f, -8.621816f, 31.077941f, -8.631390f, 31.149640f, -8.583538f, 31.211052f,
                -8.632150f, 31.278122f, -8.606841f, 31.312361f, -8.617067f, 31.348050f, -8.587210f, 31.375010f, -8.631410f, 31.398140f,
                -8.640340f, 31.458730f, -8.684140f, 31.489520f, -8.683610f, 31.536170f, -8.709550f, 31.570480f, -8.823560f, 31.576390f,
                -8.911260f, 31.679900f, -8.923260f, 31.734750f, -8.895350f, 31.766370f, -8.890280f, 31.821660f, -8.936776f, 31.947051f,
                -9.018010f, 31.936660f, -9.071180f, 31.984380f, -9.051370f, 32.060910f, -9.062930f, 32.164072f, -9.133575f, 32.267020f,
                -9.118255f, 32.431400f, -9.153105f, 32.493520f, -9.172335f, 32.486630f, -9.254665f, 32.540910f, -9.246345f, 32.584490f,
                -9.275765f, 32.648529f, -9.285126f, 32.755682f, -9.323136f, 32.765450f, -9.401161f, 32.954093f, -9.491927f, 32.988849f,
                -9.507483f, 33.016071f, -9.573815f, 33.004886f, -9.573815f, 30.792749f
            )
            poly[948] = TzPolygon(
                -14.386368f, 34.358479f, -14.431277f, 34.264367f, -14.458610f, 34.084883f, -14.489603f, 34.087049f, -14.470590f, 33.936017f,
                -14.549837f, 33.814140f, -14.501344f, 33.716264f, -14.537773f, 33.702650f, -14.577867f, 33.717998f, -14.589984f, 33.701099f,
                -14.386368f, 33.701099f
            )
            poly[949] = TzPolygon(
                -15.002667f, 34.358479f, -15.002667f, 34.622374f, -15.080658f, 34.571439f, -15.096157f, 34.591939f, -15.124790f, 34.568761f,
                -15.265405f, 34.603263f, -15.326200f, 34.574697f, -15.353738f, 34.518884f, -15.414064f, 34.510686f, -15.423293f, 34.441124f,
                -15.493324f, 34.426395f, -15.608898f, 34.457951f, -15.609004f, 34.358479f
            )
            poly[950] = TzPolygon(
                -15.002667f, 34.622374f, -14.898901f, 34.565292f, -14.811327f, 34.584002f, -14.688096f, 34.520733f, -14.646376f, 34.551564f,
                -14.555128f, 34.516104f, -14.519512f, 34.464636f, -14.395707f, 34.393408f, -14.386368f, 34.359039f, -14.386368f, 34.622374f
            )
            poly[951] = TzPolygon(
                -15.609703f, 35.836385f, -15.419138f, 35.853111f, -15.169963f, 35.790065f, -14.895350f, 35.918573f, -14.895363f, 35.872112f,
                -14.675621f, 35.872098f, -14.386368f, 35.627946f, -14.386368f, 40.227580f, -15.609703f, 40.227580f
            )
            poly[952] = TzPolygon(
                -14.386368f, 35.627946f, -14.259227f, 35.520629f, -14.170657f, 35.486785f, -13.699308f, 35.089576f, -13.483110f, 34.866898f,
                -13.483110f, 34.607174f, -13.348167f, 34.561527f, -13.232242f, 34.576116f, -12.907414f, 34.532412f, -12.736354f, 34.535023f,
                -12.570796f, 34.455736f, -12.265443f, 34.417260f, -12.171652f, 34.378231f, -12.077048f, 34.428389f, -12.077048f, 36.964340f,
                -14.386368f, 36.964340f
            )
            poly[953] = TzPolygon(
                -11.569075f, 35.332719f, -11.575345f, 34.960433f, -11.400000f, 34.929000f, -11.324750f, 34.794750f, -11.279111f, 34.800529f,
                -11.211159f, 34.759604f, -11.118500f, 34.638000f, -11.053124f, 34.637388f, -11.045500f, 34.615000f, -11.002750f, 34.622750f,
                -10.939500f, 34.673250f, -10.761000f, 34.683250f, -10.713250f, 34.650000f, -10.688750f, 34.660750f, -10.617250f, 34.617250f,
                -10.597000f, 34.625750f, -10.572250f, 34.584500f, -10.529000f, 34.570000f, -10.485000f, 34.596500f, -10.428500f, 34.559500f,
                -10.308000f, 34.586750f, -10.206500f, 34.570500f, -10.119000f, 34.520500f, -10.067250f, 34.541500f, -9.767729f, 34.333988f,
                -9.767729f, 35.332719f
            )
            poly[954] = TzPolygon(
                -12.077048f, 34.428389f, -11.972391f, 34.483877f, -11.856008f, 34.590756f, -11.739242f, 34.634426f, -11.573566f, 34.636897f,
                -11.568976f, 35.332719f, -12.077048f, 35.332719f
            )
            poly[955] = TzPolygon(
                -11.568976f, 35.332719f, -11.568913f, 35.342316f, -11.585084f, 35.387440f, -11.562091f, 35.415355f, -11.584215f, 35.441946f,
                -11.576507f, 35.478377f, -11.559626f, 35.477888f, -11.582192f, 35.515192f, -11.558688f, 35.528067f, -11.569741f, 35.550137f,
                -11.548838f, 35.574603f, -11.562921f, 35.644761f, -11.506730f, 35.711484f, -11.477472f, 35.711639f, -11.470657f, 35.774572f,
                -11.419842f, 35.810930f, -11.411228f, 35.843352f, -11.438248f, 35.913531f, -11.422892f, 35.943818f, -11.465587f, 35.957946f,
                -11.457663f, 35.985547f, -11.494471f, 36.042192f, -11.540585f, 36.062893f, -11.512823f, 36.120043f, -11.570353f, 36.154096f,
                -11.547985f, 36.183413f, -11.566800f, 36.175360f, -11.582068f, 36.199761f, -11.670874f, 36.183230f, -11.708525f, 36.217465f,
                -11.690431f, 36.270217f, -11.719746f, 36.307039f, -11.713096f, 36.355770f, -11.678515f, 36.386768f, -11.680225f, 36.482846f,
                -11.698283f, 36.517658f, -11.759261f, 36.511461f, -11.698523f, 36.573255f, -11.737779f, 36.627242f, -11.648194f, 36.768322f,
                -11.550491f, 36.814589f, -11.595382f, 36.867529f, -11.589811f, 36.964340f, -12.077048f, 36.964340f, -12.077048f, 35.332719f
            )
            poly[956] = TzPolygon(
                -11.589811f, 36.964340f, -11.586129f, 37.028323f, -11.625113f, 37.080046f, -11.655315f, 37.220281f, -11.634360f, 37.273811f,
                -11.677959f, 37.332265f, -11.691263f, 37.398726f, -11.636313f, 37.445275f, -11.614112f, 37.501854f, -11.626115f, 37.582392f,
                -11.575462f, 37.656892f, -11.546822f, 37.752804f, -11.506450f, 37.786640f, -11.457268f, 37.777250f, -11.372271f, 37.827490f,
                -11.311206f, 37.830280f, -11.260281f, 37.930590f, -11.271239f, 38.215691f, -11.289381f, 38.268840f, -11.328712f, 38.284052f,
                -11.331431f, 38.333561f, -11.373730f, 38.368672f, -11.419405f, 38.470308f, -11.286101f, 38.636391f, -11.273193f, 38.752408f,
                -11.171765f, 38.882995f, -11.143433f, 39.124245f, -11.175432f, 39.246038f, -10.980957f, 39.523081f, -10.914043f, 39.763603f,
                -10.849727f, 39.865150f, -10.806914f, 39.999104f, -10.670602f, 40.173255f, -10.603183f, 40.227580f, -14.386368f, 40.227580f,
                -14.386368f, 36.964340f
            )
            poly[957] = TzPolygon(
                -9.611583f, 33.701099f, -9.583660f, 33.722487f, -9.586363f, 33.773357f, -9.718675f, 33.938925f, -9.619009f, 33.967551f,
                -9.559071f, 33.949536f, -9.493500f, 34.040000f, -9.757889f, 34.327171f, -9.767729f, 34.333988f, -9.767729f, 33.701099f
            )
            poly[958] = TzPolygon(9.636901f, -4.286175f, 9.596716f, -4.312933f, 9.625437f, -4.341473f, 9.596478f, -4.390435f, 9.636901f, -4.413726f)
            poly[959] = TzPolygon(
                7.088077f, -4.045655f, 7.088077f, -3.030016f, 7.071809f, -3.031893f, 7.052705f, -3.087603f, 6.822296f, -3.232027f,
                6.777575f, -3.236115f, 6.731702f, -3.208998f, 6.623015f, -3.260786f, 6.601251f, -3.233268f, 6.252820f, -3.175691f,
                6.251522f, -3.154513f, 6.153126f, -3.102740f, 5.985004f, -3.073809f, 5.856884f, -3.020033f, 5.709230f, -3.026427f,
                5.716022f, -2.953969f, 5.641276f, -2.966448f, 5.619962f, -2.933506f, 5.657319f, -2.857874f, 5.599837f, -2.761294f,
                5.437734f, -2.748967f, 5.387981f, -2.724216f, 5.342807f, -2.724146f, 5.356565f, -2.769282f, 5.304442f, -2.766837f,
                5.289931f, -2.785249f, 5.250691f, -2.753181f, 5.216962f, -2.764245f, 5.140927f, -2.723532f, 5.101642f, -2.757012f,
                5.128030f, -2.876199f, 5.126928f, -2.948670f, 5.103333f, -2.963056f, 5.134464f, -3.068524f, 5.124754f, -3.108305f,
                4.895925f, -3.148288f, 4.994171f, -3.758068f, 5.046503f, -3.965016f, 5.038403f, -4.045655f
            )
            poly[960] = TzPolygon(
                7.088077f, -3.030016f, 7.141769f, -3.023819f, 7.237718f, -2.952799f, 7.269923f, -2.975304f, 7.612207f, -2.922151f,
                7.820013f, -2.831048f, 7.862630f, -2.791195f, 7.952178f, -2.781419f, 7.922653f, -2.746703f, 8.020386f, -2.679616f,
                8.030426f, -2.604682f, 8.123750f, -2.626841f, 8.152074f, -2.608096f, 8.145660f, -2.551387f, 8.206478f, -2.493031f,
                8.786579f, -2.584254f, 8.794263f, -2.630319f, 8.827969f, -2.596807f, 8.878310f, -2.623229f, 8.921731f, -2.618056f,
                8.943087f, -2.651290f, 9.019233f, -2.663835f, 9.032116f, -2.748035f, 9.063156f, -2.780181f, 9.090598f, -2.760830f,
                9.143359f, -2.772785f, 9.158293f, -2.735016f, 9.257247f, -2.657061f, 9.313522f, -2.721153f, 9.372280f, -2.675979f,
                9.486392f, -2.684108f, 9.569059f, -2.768477f, 9.636901f, -2.746990f, 9.636901f, -0.723987f, 7.088077f, -0.723987f
            )
            poly[961] = TzPolygon(
                9.636901f, -2.961019f, 9.636901f, -2.746990f, 9.569059f, -2.768477f, 9.491666f, -2.687203f, 9.410472f, -2.767721f,
                9.575542f, -2.935340f
            )
            poly[962] = TzPolygon(
                10.271946f, -7.367323f, 10.274467f, -7.363089f, 10.332002f, -7.357427f, 10.337964f, -7.367323f, 10.998676f, -7.367323f,
                10.998676f, -6.536906f, 10.591899f, -6.536906f, 10.628390f, -6.595214f, 10.671935f, -6.615223f, 10.673269f, -6.640854f,
                10.634290f, -6.644065f, 10.598677f, -6.676063f, 10.536404f, -6.659395f, 10.526980f, -6.682369f, 10.467694f, -6.676656f,
                10.438694f, -6.625990f, 10.398041f, -6.654553f, 10.364058f, -6.643946f, 10.340825f, -6.698501f, 10.386824f, -6.806505f,
                10.344946f, -6.859148f, 10.354713f, -6.940187f, 10.262254f, -7.011270f, 10.218386f, -6.977491f, 10.172364f, -6.995023f,
                10.147811f, -7.049049f, 10.165190f, -7.086045f, 10.209164f, -7.084597f, 10.251953f, -7.148583f, 10.266040f, -7.278004f,
                10.236172f, -7.337537f, 10.242986f, -7.367323f
            )
            poly[963] = TzPolygon(
                10.591899f, -6.536906f, 10.562645f, -6.427134f, 10.598567f, -6.397501f, 10.700758f, -6.413795f, 10.684025f, -6.320884f,
                10.740197f, -6.246191f, 10.724488f, -6.210674f, 10.660038f, -6.231403f, 10.634245f, -6.183113f, 10.615769f, -6.223228f,
                10.581067f, -6.205066f, 10.529258f, -6.247732f, 10.486274f, -6.160440f, 10.449091f, -6.185643f, 10.418941f, -6.155388f,
                10.387995f, -6.187500f, 10.363453f, -6.159603f, 10.339240f, -6.192515f, 10.302649f, -6.189132f, 10.316304f, -6.206246f,
                10.301972f, -6.233048f, 10.227152f, -6.177825f, 10.197135f, -5.985932f, 10.278032f, -5.954100f, 10.266982f, -5.885976f,
                10.377784f, -5.866918f, 10.379406f, -5.840459f, 10.433439f, -5.785716f, 10.431181f, -5.706489f, 9.636901f, -5.706489f,
                9.636901f, -6.536906f
            )
            poly[964] = TzPolygon(
                10.317788f, -5.197092f, 10.317788f, -4.876072f, 9.881581f, -4.876072f, 9.891179f, -4.912808f, 9.868258f, -4.929519f,
                9.892372f, -4.966957f, 9.946322f, -4.963884f, 9.953859f, -4.940390f, 9.992084f, -4.987612f, 10.023691f, -4.961258f,
                10.072621f, -5.015148f, 10.107264f, -4.999303f, 10.082576f, -5.055264f, 10.108504f, -5.038393f, 10.111259f, -5.073111f,
                10.122127f, -5.036777f, 10.139102f, -5.069697f, 10.180756f, -5.060542f, 10.175528f, -5.104580f, 10.194631f, -5.080255f,
                10.224068f, -5.083159f, 10.204687f, -5.121975f, 10.236970f, -5.105604f, 10.256548f, -5.119517f, 10.272982f, -5.097830f,
                10.283133f, -5.120450f, 10.307651f, -5.110961f, 10.287832f, -5.188943f
            )
            poly[965] = TzPolygon(10.317788f, -5.211651f, 10.305438f, -5.256699f, 10.317788f, -5.284404f)
            poly[966] = TzPolygon(10.317788f, -5.292417f, 10.290359f, -5.322865f, 10.305241f, -5.348741f, 10.282479f, -5.362910f, 10.317788f, -5.429921f)
            poly[967] = TzPolygon(
                10.431181f, -5.706489f, 10.431107f, -5.703907f, 10.468109f, -5.651395f, 10.451180f, -5.617637f, 10.463243f, -5.557725f,
                10.424538f, -5.499865f, 10.321806f, -5.437546f, 10.317788f, -5.429921f, 10.317788f, -5.706489f
            )
            poly[968] = TzPolygon(10.317788f, -5.292417f, 10.320178f, -5.289764f, 10.317788f, -5.284404f)
            poly[969] = TzPolygon(10.317788f, -5.211651f, 10.321503f, -5.198102f, 10.317788f, -5.197092f)
            poly[970] = TzPolygon(
                10.998676f, -5.706489f, 10.998676f, -5.481553f, 10.973614f, -5.492525f, 10.976044f, -5.452003f, 10.901324f, -5.451622f,
                10.854347f, -5.402723f, 10.774869f, -5.432628f, 10.764731f, -5.468008f, 10.643995f, -5.461520f, 10.623197f, -5.478925f,
                10.557722f, -5.456998f, 10.431726f, -5.512140f, 10.463953f, -5.559955f, 10.451180f, -5.617637f, 10.468109f, -5.649571f,
                10.431107f, -5.703907f, 10.431402f, -5.706489f
            )
            poly[971] = TzPolygon(
                9.636901f, -4.413726f, 9.664151f, -4.429427f, 9.646781f, -4.504978f, 9.751433f, -4.515380f, 9.741919f, -4.553703f,
                9.718202f, -4.542943f, 9.693190f, -4.561851f, 9.725141f, -4.612509f, 9.702850f, -4.620837f, 9.713127f, -4.645830f,
                9.686958f, -4.656353f, 9.678492f, -4.690594f, 9.747114f, -4.733283f, 9.755573f, -4.761698f, 9.736792f, -4.774956f,
                9.783664f, -4.816693f, 9.781454f, -4.783853f, 9.835547f, -4.785854f, 9.872090f, -4.839742f, 9.881581f, -4.876072f,
                10.998676f, -4.876072f, 10.998676f, -4.045655f, 9.810969f, -4.045655f, 9.803041f, -4.051230f, 9.847235f, -4.127239f,
                9.773817f, -4.188891f, 9.760091f, -4.266451f, 9.640775f, -4.283595f, 9.636901f, -4.286175f
            )
            poly[972] = TzPolygon(
                10.998676f, -5.481553f, 11.016507f, -5.473747f, 11.083035f, -5.488879f, 11.105675f, -5.382965f, 11.138299f, -5.332996f,
                11.206331f, -5.324420f, 11.249399f, -5.253339f, 11.392515f, -5.244954f, 11.428803f, -5.198715f, 11.579182f, -5.216561f,
                11.615543f, -5.294994f, 11.679406f, -5.265239f, 11.762937f, -5.259327f, 11.830716f, -5.404521f, 11.843171f, -5.378075f,
                11.821165f, -5.354006f, 11.854764f, -5.284959f, 11.833182f, -5.257498f, 11.927671f, -5.172246f, 11.982503f, -5.074635f,
                12.018711f, -4.832580f, 11.999476f, -4.739715f, 12.066080f, -4.700418f, 12.059607f, -4.630051f, 12.139016f, -4.607346f,
                12.141653f, -4.544065f, 12.202869f, -4.579941f, 12.283371f, -4.473276f, 12.331783f, -4.473417f, 12.333753f, -4.439641f,
                12.302590f, -4.418609f, 12.310532f, -4.396295f, 12.360451f, -4.416353f, 12.360451f, -4.045655f, 10.998676f, -4.045655f
            )
            poly[973] = TzPolygon(
                12.360451f, -4.416353f, 12.418755f, -4.439781f, 12.485780f, -4.419907f, 12.533000f, -4.364649f, 12.560397f, -4.402291f,
                12.609841f, -4.411587f, 12.658155f, -4.480677f, 12.722821f, -4.479101f, 12.711044f, -4.431418f, 12.743846f, -4.346758f,
                12.701378f, -4.300473f, 12.726606f, -4.232792f, 12.816605f, -4.208981f, 12.866143f, -4.226150f, 12.960996f, -4.218269f,
                12.990832f, -4.265696f, 13.039498f, -4.274882f, 13.119637f, -4.346929f, 13.189566f, -4.288174f, 13.187061f, -4.225566f,
                13.236763f, -4.258892f, 13.296096f, -4.136759f, 13.396076f, -4.092644f, 13.413022f, -4.045655f, 12.360451f, -4.045655f
            )
            poly[974] = TzPolygon(
                9.810969f, -4.045655f, 9.835245f, -4.028583f, 9.832811f, -3.973394f, 9.874986f, -3.968127f, 9.873779f, -3.931369f,
                9.905731f, -3.895923f, 9.894730f, -3.803282f, 9.926713f, -3.776553f, 9.928406f, -3.667671f, 9.958485f, -3.618287f,
                9.934653f, -3.599631f, 9.910974f, -3.311272f, 9.870566f, -3.317644f, 9.845801f, -3.271703f, 9.935518f, -3.189225f,
                9.840556f, -3.186587f, 9.851391f, -3.153830f, 9.820478f, -3.103454f, 9.725491f, -3.056710f, 9.743046f, -3.005442f,
                9.636901f, -2.961019f, 9.636901f, -4.045655f
            )
            poly[975] = TzPolygon(
                9.636901f, -2.746990f, 9.641285f, -2.745601f, 9.680714f, -2.757614f, 9.697108f, -2.787175f, 9.746514f, -2.790052f,
                9.826363f, -2.726519f, 9.883963f, -2.761897f, 9.960741f, -2.743056f, 10.069591f, -2.790470f, 10.190787f, -2.798259f,
                10.253004f, -2.757624f, 10.318830f, -2.850473f, 10.387842f, -2.831507f, 10.422508f, -2.773343f, 10.454496f, -2.866360f,
                10.614443f, -2.941140f, 10.686122f, -2.905675f, 10.721892f, -2.937987f, 10.764413f, -2.895283f, 10.887705f, -2.864039f,
                10.924999f, -2.817496f, 10.967128f, -2.840803f, 11.006688f, -2.833702f, 10.992322f, -2.384821f, 9.636901f, -2.384821f
            )
            poly[976] = TzPolygon(
                10.995854f, -0.723987f, 11.005831f, -0.807563f, 10.998042f, -0.855074f, 10.962393f, -0.893458f, 11.001978f, -0.916519f,
                10.986350f, -1.387380f, 11.021033f, -1.425245f, 11.021028f, -1.615577f, 10.985086f, -1.616308f, 10.972004f, -1.749934f,
                10.992322f, -2.384821f, 12.360451f, -2.384821f, 12.360451f, -0.723987f
            )
            poly[977] = TzPolygon(
                15.084000f, -0.723987f, 14.785124f, -1.069027f, 14.729800f, -1.318300f, 14.501500f, -1.678000f, 14.475666f, -1.980500f,
                14.191679f, -1.998162f, 14.147003f, -2.103259f, 14.248917f, -2.297285f, 14.299451f, -2.473564f, 14.135172f, -2.676377f,
                14.054385f, -2.838967f, 14.006217f, -2.854854f, 13.992887f, -2.836147f, 13.823712f, -2.908240f, 13.727169f, -2.905943f,
                13.654096f, -2.874002f, 13.624663f, -2.952490f, 13.657017f, -3.001398f, 13.613599f, -3.040313f, 13.688995f, -3.107995f,
                13.677491f, -3.181224f, 13.706131f, -3.212181f, 13.707476f, -3.268807f, 13.683881f, -3.247434f, 13.585730f, -3.250420f,
                13.555871f, -3.278835f, 13.288968f, -3.234142f, 13.276557f, -3.437479f, 13.178668f, -3.422262f, 13.158050f, -3.441779f,
                13.166898f, -3.552322f, 13.196848f, -3.552500f, 13.200016f, -3.586656f, 13.303178f, -3.737571f, 13.372188f, -3.797905f,
                13.377852f, -3.960441f, 13.407634f, -3.963190f, 13.442792f, -3.895670f, 13.452134f, -3.940362f, 13.504436f, -3.967139f,
                13.474288f, -3.982839f, 13.490373f, -3.964923f, 13.472940f, -3.959626f, 13.435086f, -3.984476f, 13.413937f, -4.045655f,
                15.084000f, -4.045655f
            )
            poly[978] = TzPolygon(
                6.752252f, -0.723987f, 6.752252f, 0.607952f, 6.737609f, 0.649959f, 6.641511f, 0.635398f, 6.607584f, 0.657178f,
                6.584151f, 0.741341f, 6.562948f, 0.747563f, 6.529177f, 0.712423f, 6.444123f, 0.749588f, 6.380469f, 0.861879f,
                6.333333f, 0.893104f, 6.335475f, 1.003468f, 6.256126f, 1.024198f, 6.223399f, 1.063258f, 6.169635f, 1.082896f,
                6.169121f, 1.199438f, 6.113160f, 1.199352f, 5.926547f, 1.273294f, 5.866848f, 1.195395f, 5.700248f, 1.127286f,
                5.599666f, 0.995806f, 5.566463f, 0.717362f, 5.580780f, 0.334919f, 5.517259f, 0.186659f, 5.438167f, 0.088537f,
                5.344039f, -0.143586f, 5.314208f, -0.273935f, 5.203790f, -0.400143f, 5.131994f, -0.599363f, 5.037841f, -0.723987f
            )
            poly[979] = TzPolygon(
                6.752252f, 1.619171f, 6.752252f, 2.408972f, 6.151687f, 2.408972f, 6.132875f, 2.171817f, 6.039870f, 1.673024f,
                6.236389f, 1.629444f, 6.288785f, 1.808761f, 6.308161f, 1.787759f, 6.383226f, 1.785142f, 6.413054f, 1.763948f,
                6.427037f, 1.778976f, 6.475095f, 1.752610f, 6.504432f, 1.693843f, 6.555235f, 1.697641f, 6.555580f, 1.671030f,
                6.579723f, 1.667192f, 6.613416f, 1.610160f, 6.650991f, 1.615559f, 6.688464f, 1.575055f
            )
            poly[980] = TzPolygon(
                6.752252f, 0.607952f, 6.761493f, 0.581441f, 6.788668f, 0.566203f, 6.807286f, 0.579840f, 6.828771f, 0.532145f,
                6.921055f, 0.566006f, 6.943217f, 0.522832f, 6.971071f, 0.521241f, 7.022296f, 0.603545f, 7.099326f, 0.614158f,
                7.113836f, 0.591430f, 7.317309f, 0.658271f, 7.401160f, 0.644127f, 7.412817f, 0.618530f, 7.392208f, 0.568686f,
                7.460079f, 0.519535f, 7.592577f, 0.518090f, 7.622082f, 0.586039f, 7.703112f, 0.590358f, 7.704283f, 0.627113f,
                7.753867f, 0.611397f, 7.767771f, 0.631076f, 7.867469f, 0.627453f, 8.093466f, 0.584628f, 8.185035f, 0.613936f,
                8.202469f, 0.588614f, 8.215801f, 0.619290f, 8.260299f, 0.638437f, 8.286651f, 0.731133f, 8.340880f, 0.730040f,
                8.404740f, 0.696493f, 8.422440f, 0.651659f, 8.466663f, 0.647973f, 8.466663f, 0.842492f, 6.752252f, 0.842492f
            )
            poly[981] = TzPolygon(
                6.752252f, 1.619171f, 6.761109f, 1.625297f, 6.799474f, 1.594322f, 6.825103f, 1.612561f, 6.830920f, 1.597624f,
                6.905183f, 1.606130f, 6.919701f, 1.578409f, 6.997177f, 1.559175f, 6.995556f, 1.642500f, 7.532500f, 1.655833f,
                8.357778f, 1.634722f, 8.374722f, 1.613056f, 8.466663f, 1.648996f, 8.466663f, 2.408972f, 6.752252f, 2.408972f
            )
            poly[982] = TzPolygon(
                8.466663f, 0.647973f, 8.493518f, 0.645734f, 8.595649f, 0.469556f, 8.754676f, 0.373824f, 8.756869f, 0.400920f,
                8.792793f, 0.380067f, 8.779136f, 0.427770f, 8.811355f, 0.448214f, 8.791780f, 0.469049f, 8.800359f, 0.491319f,
                8.877826f, 0.527585f, 8.938686f, 0.516568f, 9.043858f, 0.456238f, 9.108665f, 0.486697f, 9.144977f, 0.476761f,
                9.163661f, 0.511570f, 9.209416f, 0.533602f, 9.256413f, 0.505835f, 9.311206f, 0.555794f, 9.323868f, 0.551245f,
                9.323868f, 0.842492f, 8.466663f, 0.842492f
            )
            poly[983] = TzPolygon(
                9.323868f, 0.551245f, 9.340876f, 0.545134f, 9.405926f, 0.567003f, 9.437939f, 0.499967f, 9.474895f, 0.502923f,
                9.499486f, 0.448704f, 9.499213f, 0.359421f, 9.451738f, 0.337541f, 9.427417f, 0.275777f, 9.463508f, 0.229232f,
                9.485950f, 0.229040f, 9.478874f, 0.269704f, 9.506631f, 0.311194f, 9.524532f, 0.243250f, 9.574648f, 0.240063f,
                9.571963f, 0.351337f, 9.591457f, 0.383690f, 9.625075f, 0.356310f, 9.595625f, 0.295852f, 9.657239f, 0.263496f,
                9.686272f, 0.279253f, 9.650912f, 0.322973f, 9.674806f, 0.350878f, 9.717686f, 0.344802f, 9.727898f, 0.318905f,
                9.846696f, 0.357399f, 9.921893f, 0.355176f, 9.937388f, 0.387322f, 10.027509f, 0.360492f, 10.020951f, 0.410229f,
                10.057604f, 0.417747f, 10.098681f, 0.353076f, 10.181074f, 0.357477f, 10.181074f, 0.842492f, 9.323868f, 0.842492f
            )
            poly[984] = TzPolygon(
                8.466663f, 1.648996f, 8.496944f, 1.660833f, 8.548056f, 1.624722f, 9.049722f, 1.617778f, 9.170000f, 1.567222f,
                9.321111f, 1.416667f, 9.487500f, 1.390556f, 9.485556f, 1.361111f, 9.542500f, 1.337500f, 9.646667f, 1.373889f,
                9.995278f, 1.355000f, 10.181074f, 1.073261f, 10.181074f, 2.408972f, 8.466663f, 2.408972f
            )
            poly[985] = TzPolygon(
                10.564411f, 0.059253f, 10.601442f, 0.041287f, 10.632333f, -0.059247f, 10.711561f, -0.090090f, 10.720047f, -0.072346f,
                10.769827f, -0.072847f, 10.818676f, -0.021767f, 10.963250f, -0.006107f, 10.978806f, 0.033526f, 11.038280f, 0.026697f,
                11.038280f, 0.059253f
            )
            poly[986] = TzPolygon(
                11.038280f, -0.723987f, 11.038280f, -0.437025f, 11.030337f, -0.438013f, 11.036049f, -0.474990f, 10.974715f, -0.544792f,
                10.992317f, -0.568294f, 10.923578f, -0.593186f, 10.910424f, -0.618436f, 10.939680f, -0.626796f, 10.958282f, -0.671080f,
                10.987498f, -0.653986f, 10.995854f, -0.723987f
            )
            poly[987] = TzPolygon(
                10.564411f, 0.059253f, 10.560818f, 0.060996f, 10.526270f, 0.142670f, 10.404317f, 0.190356f, 10.426923f, 0.217696f,
                10.407587f, 0.259261f, 10.421586f, 0.285950f, 10.376406f, 0.290316f, 10.325151f, 0.338370f, 10.308640f, 0.318671f,
                10.312484f, 0.396899f, 10.258108f, 0.361591f, 10.181074f, 0.357477f, 10.181074f, 0.059253f
            )
            poly[988] = TzPolygon(
                10.996495f, 0.842492f, 10.997360f, 0.656310f, 10.931000f, 0.494680f, 11.009080f, 0.502850f, 11.038280f, 0.365791f,
                11.038280f, 0.842492f
            )
            poly[989] = TzPolygon(10.333258f, 0.842492f, 10.376667f, 0.776667f, 10.579722f, 0.806944f, 10.714167f, 0.802500f, 10.758635f, 0.842492f)
            poly[990] = TzPolygon(
                11.038280f, 0.026697f, 11.062617f, 0.023902f, 11.114303f, -0.017876f, 11.084144f, -0.081163f, 11.117785f, -0.143975f,
                11.139510f, -0.136231f, 11.038280f, 0.359778f
            )
            poly[991] = TzPolygon(
                11.038280f, 0.842492f, 11.038280f, 0.365791f, 11.174856f, -0.275282f, 11.147961f, -0.289357f, 11.126267f, -0.270947f,
                11.109296f, -0.332746f, 11.069886f, -0.359076f, 11.123257f, -0.372445f, 11.114344f, -0.427566f, 11.038280f, -0.437025f,
                11.038280f, -0.723987f, 11.895485f, -0.723987f, 11.895485f, 0.842492f
            )
            poly[992] = TzPolygon(10.996495f, 0.842492f, 10.996171f, 0.912209f, 10.799722f, 0.879444f, 10.758635f, 0.842492f)
            poly[993] = TzPolygon(10.333258f, 0.842492f, 10.181074f, 1.073261f, 10.181074f, 0.842492f)
            poly[994] = TzPolygon(11.038280f, 0.842492f, 11.038280f, 0.944161f, 10.996171f, 0.912209f, 10.996495f, 0.842492f)
            poly[995] = TzPolygon(11.038280f, 1.112318f, 11.031799f, 1.114305f, 11.038280f, 1.104793f)
            poly[996] = TzPolygon(
                11.038280f, 0.944161f, 11.094434f, 0.986770f, 11.087259f, 1.013535f, 11.052707f, 1.026935f, 11.061870f, 1.070169f,
                11.038280f, 1.105342f
            )
            poly[997] = TzPolygon(
                11.038280f, 1.112661f, 11.121279f, 1.086865f, 11.131734f, 1.049632f, 11.176971f, 1.116670f, 11.169796f, 1.165027f,
                11.235653f, 1.156529f, 11.247964f, 1.129548f, 11.279023f, 1.146164f, 11.250064f, 1.262568f, 11.266082f, 1.283863f,
                11.302564f, 1.259543f, 11.327434f, 1.269131f, 11.298058f, 1.294360f, 11.292693f, 1.333351f, 11.307367f, 1.351690f,
                11.366730f, 1.326673f, 11.368302f, 1.351054f, 11.395803f, 1.359378f, 11.389221f, 1.382343f, 11.444424f, 1.388455f,
                11.481042f, 1.447749f, 11.453317f, 1.484943f, 11.478626f, 1.506247f, 11.459650f, 1.500624f, 11.451143f, 1.530884f,
                11.478057f, 1.553851f, 11.407897f, 1.589215f, 11.393368f, 1.623846f, 11.407960f, 1.699710f, 11.429130f, 1.714140f,
                11.416740f, 1.752390f, 11.444380f, 1.841670f, 11.427710f, 2.019250f, 11.594114f, 2.183972f, 11.679052f, 2.314287f,
                11.734176f, 2.304626f, 11.784253f, 2.340799f, 11.791057f, 2.375653f, 11.856788f, 2.380240f, 11.874474f, 2.404186f,
                11.895485f, 2.408972f, 11.038280f, 2.408972f
            )
            poly[998] = TzPolygon(
                13.489743f, -0.723987f, 13.489743f, 1.022275f, 13.462500f, 1.031667f, 13.396389f, 1.170833f, 13.393056f, 1.244444f,
                13.354469f, 1.284284f, 13.338856f, 1.241580f, 13.380272f, 1.211370f, 13.332141f, 1.202549f, 13.321453f, 1.175468f,
                13.374676f, 0.991913f, 13.007796f, 0.973755f, 13.007276f, 1.159573f, 12.611690f, 1.566306f, 12.605380f, 1.868563f,
                12.700556f, 1.928056f, 12.692222f, 1.950278f, 12.731111f, 1.988889f, 12.725556f, 2.096111f, 12.694444f, 2.142500f,
                12.651499f, 2.154637f, 12.630833f, 2.200833f, 12.593611f, 2.220833f, 12.516389f, 2.225556f, 12.473333f, 2.263889f,
                12.418611f, 2.264167f, 12.390000f, 2.087778f, 12.347350f, 2.065588f, 11.902544f, 2.408972f, 11.895485f, 2.405627f,
                11.895485f, -0.723987f
            )
            poly[999] = TzPolygon(11.909474f, 2.408972f, 11.931259f, 2.391928f, 11.942550f, 2.408972f)
        }
    }

    private object Initializer11 {
        fun init() {
            poly[1000] = TzPolygon(12.079607f, 2.408972f, 12.112624f, 2.390317f, 12.251282f, 2.381540f, 12.251864f, 2.408972f)
            poly[1001] = TzPolygon(
                15.084000f, 1.086532f, 14.981871f, 0.968179f, 14.944581f, 0.701735f, 14.998422f, 0.519270f, 14.963993f, 0.394631f,
                15.001042f, 0.227435f, 14.974683f, 0.061520f, 15.079000f, -0.245750f, 15.004103f, -0.390241f, 15.083284f, -0.431378f,
                15.084000f, -0.723987f
            )
            poly[1002] = TzPolygon(
                15.084000f, -0.455990f, 15.083284f, -0.431378f, 15.004103f, -0.390241f, 15.079000f, -0.245750f, 14.974683f, 0.061520f,
                14.999829f, 0.232230f, 14.914000f, 0.244360f, 14.826320f, 0.196358f, 14.746547f, 0.238139f, 14.522067f, 0.168965f,
                14.050911f, 0.381085f, 14.023056f, 0.417222f, 13.983611f, 0.424167f, 13.955556f, 0.471111f, 13.913611f, 0.465000f,
                13.788611f, 0.582778f, 13.778056f, 0.616667f, 13.717778f, 0.596944f, 13.686944f, 0.620278f, 13.684167f, 0.781111f,
                13.644167f, 0.774444f, 13.622778f, 0.902222f, 13.568056f, 0.995278f, 13.489743f, 1.022275f, 13.489743f, -0.723987f,
                15.084000f, -0.723987f
            )
            poly[1003] = TzPolygon(
                6.822822f, 2.408972f, 6.822822f, 2.736543f, 6.784282f, 2.734515f, 6.747337f, 2.791663f, 6.693531f, 2.783087f,
                6.635420f, 2.730245f, 6.569648f, 2.750632f, 6.512052f, 2.704630f, 6.487045f, 2.724148f, 6.464166f, 2.705186f,
                6.377422f, 2.706714f, 6.177783f, 2.737949f, 6.151687f, 2.408972f
            )
            poly[1004] = TzPolygon(
                9.576548f, 3.223630f, 9.518867f, 3.195059f, 9.496747f, 3.153223f, 9.437560f, 3.132465f, 9.283908f, 3.157868f,
                9.232595f, 3.122794f, 9.101948f, 3.088313f, 9.058787f, 2.890086f, 9.067759f, 2.778543f, 8.992706f, 2.791376f,
                8.962624f, 2.772463f, 8.939759f, 2.782871f, 8.913874f, 2.755129f, 8.901328f, 2.772379f, 8.869428f, 2.754019f,
                8.811296f, 2.766534f, 8.783668f, 2.729577f, 8.708142f, 2.761037f, 8.663585f, 2.734847f, 8.654577f, 2.755364f,
                8.537622f, 2.751669f, 8.524398f, 2.769031f, 8.449759f, 2.748016f, 8.422628f, 2.706912f, 8.387939f, 2.717720f,
                8.321437f, 2.693104f, 8.187122f, 2.754625f, 7.881580f, 2.676932f, 7.766559f, 2.733560f, 7.636474f, 2.716642f,
                7.549986f, 2.734879f, 7.518575f, 2.782252f, 7.479609f, 2.795670f, 7.429746f, 2.793901f, 7.424327f, 2.744840f,
                7.133006f, 2.772804f, 7.104953f, 2.740462f, 7.043364f, 2.761423f, 7.016800f, 2.728928f, 6.951420f, 2.712541f,
                6.926480f, 2.741998f, 6.822822f, 2.736543f, 6.822822f, 2.408972f, 9.576548f, 2.408972f
            )
            poly[1005] = TzPolygon(
                10.953411f, 2.408972f, 10.953411f, 3.764132f, 10.924227f, 3.769666f, 10.817094f, 3.745729f, 10.735134f, 3.780269f,
                10.698861f, 3.834232f, 10.592964f, 3.843343f, 10.409030f, 3.788037f, 10.461647f, 3.683455f, 10.417712f, 3.623735f,
                10.272266f, 3.576600f, 10.211502f, 3.608029f, 10.176823f, 3.679370f, 10.114262f, 3.662747f, 10.078819f, 3.614454f,
                9.968893f, 3.602537f, 9.924857f, 3.560815f, 9.898133f, 3.562172f, 9.861305f, 3.517764f, 9.870738f, 3.462655f,
                9.827444f, 3.352287f, 9.771603f, 3.323478f, 9.703206f, 3.358335f, 9.659431f, 3.313877f, 9.655788f, 3.262879f,
                9.576548f, 3.223630f, 9.576548f, 2.408972f
            )
            poly[1006] = TzPolygon(
                11.028164f, 3.724348f, 11.033867f, 3.715685f, 11.129606f, 3.720315f, 11.295346f, 3.493726f, 11.601921f, 3.549892f,
                11.703094f, 3.593725f, 11.693756f, 3.609500f, 11.754747f, 3.680954f, 11.810683f, 3.669243f, 11.830986f, 3.629341f,
                11.920285f, 3.619786f, 11.976468f, 3.678461f, 12.119320f, 3.631658f, 12.258877f, 3.666685f, 12.330274f, 3.663104f,
                12.330274f, 3.724348f
            )
            poly[1007] = TzPolygon(
                12.330274f, 2.923244f, 12.330274f, 3.663104f, 12.258877f, 3.666685f, 12.119320f, 3.631658f, 11.976468f, 3.678461f,
                11.920285f, 3.619786f, 11.830986f, 3.629341f, 11.810683f, 3.669243f, 11.754747f, 3.680954f, 11.693756f, 3.609500f,
                11.732962f, 3.550077f, 11.774471f, 3.564487f, 11.789583f, 3.520084f, 11.815505f, 3.521887f, 11.860142f, 3.481321f,
                11.858333f, 3.432222f, 11.895278f, 3.378056f, 11.890000f, 3.312222f, 11.993569f, 3.255818f, 12.029326f, 3.257076f
            )
            poly[1008] = TzPolygon(
                12.330274f, 2.717057f, 12.281421f, 2.695105f, 12.306099f, 2.661749f, 12.272019f, 2.543627f, 12.293979f, 2.517246f,
                12.267385f, 2.504335f, 12.274239f, 2.472902f, 12.252995f, 2.462265f, 12.251864f, 2.408972f, 12.330274f, 2.408972f
            )
            poly[1009] = TzPolygon(12.079607f, 2.408972f, 11.979880f, 2.465320f, 11.954690f, 2.408972f)
            poly[1010] = TzPolygon(11.028164f, 3.724348f, 11.008900f, 3.753611f, 10.953411f, 3.764132f, 10.953411f, 3.724348f)
            poly[1011] = TzPolygon(
                12.330274f, 3.663104f, 12.522698f, 3.653454f, 12.746709f, 3.941830f, 12.987683f, 4.103459f, 13.161925f, 4.142085f,
                13.478063f, 4.141604f, 13.477944f, 4.234671f, 13.681421f, 4.465735f, 13.781003f, 4.873818f, 13.734483f, 4.949557f,
                13.742946f, 5.246930f, 13.834558f, 5.350681f, 13.885645f, 5.529830f, 13.644750f, 6.155536f, 13.676514f, 6.277334f,
                13.600376f, 6.427932f, 13.339288f, 6.696697f, 13.143423f, 6.820123f, 13.003533f, 6.942091f, 13.000072f, 7.052867f,
                13.020471f, 7.121574f, 13.129070f, 7.221638f, 13.098325f, 7.388865f, 13.114850f, 7.439373f, 13.256671f, 7.670478f,
                12.330274f, 7.670478f
            )
            poly[1012] = TzPolygon(12.330274f, 2.717057f, 12.364956f, 2.732641f, 12.352390f, 2.765683f, 12.409245f, 2.826144f, 12.330274f, 2.930381f)
            poly[1013] = TzPolygon(21.773345f, 0.151578f, 25.000000f, -4.833334f, 26.529692f, -7.367323f, 27.433543f, -7.367323f, 27.433543f, 0.151578f)
            poly[1014] = TzPolygon(
                26.529692f, -7.367323f, 25.000000f, -4.833334f, 25.000072f, -6.571880f, 16.500149f, -5.609034f, 16.333333f, -5.333333f,
                15.500000f, -5.500000f, 15.500783f, -7.367323f
            )
            poly[1015] = TzPolygon(
                15.084000f, 1.085816f, 15.278128f, 1.311499f, 15.346796f, 2.636366f, 15.338195f, 3.019968f, 15.428574f, 3.031485f,
                15.365330f, 3.507104f, 15.403418f, 3.536306f, 15.485183f, 3.536893f, 15.521040f, 3.595828f, 15.648148f, 3.703728f,
                15.675656f, 3.833681f, 15.715259f, 3.885853f, 15.804220f, 3.911028f, 15.084000f, 3.911028f
            )
            poly[1016] = TzPolygon(
                20.263616f, 2.031303f, 20.242941f, 1.999862f, 20.266976f, 1.978931f, 20.259812f, 1.946854f, 20.224207f, 1.923759f,
                20.297235f, 1.882274f, 20.297876f, 1.797805f, 20.337223f, 1.775031f, 20.406402f, 1.668216f, 20.530003f, 1.667574f,
                20.596081f, 1.599572f, 20.656598f, 1.383804f, 20.740211f, 1.316550f, 20.723745f, 1.229730f, 20.736148f, 1.165150f,
                20.943255f, 1.193591f, 21.116365f, 1.166556f, 21.258772f, 0.946550f, 21.258772f, 2.031303f
            )
            poly[1017] = TzPolygon(
                20.263616f, 2.031303f, 21.258772f, 2.031303f, 21.258772f, 3.911028f, 19.076172f, 3.911028f, 18.968147f, 3.357648f,
                19.125653f, 3.124732f, 19.155678f, 3.114680f, 19.277088f, 3.200581f, 19.359073f, 3.178257f, 19.417037f, 3.200189f,
                19.448499f, 3.266116f, 19.497843f, 3.248110f, 19.526828f, 3.266377f, 19.584463f, 3.231869f, 19.642682f, 3.252191f,
                19.713642f, 3.229954f, 19.834791f, 3.254628f, 19.856724f, 3.149014f, 19.952884f, 2.978123f, 19.962732f, 2.831622f,
                19.993553f, 2.734948f, 20.101169f, 2.684475f, 20.050863f, 2.665264f, 20.053872f, 2.622458f, 20.032098f, 2.595890f,
                20.034096f, 2.560432f, 20.094666f, 2.519918f, 20.098554f, 2.470326f, 20.075615f, 2.412825f, 20.028382f, 2.375423f,
                20.133178f, 2.399822f, 20.218177f, 2.317919f, 20.271115f, 2.312027f, 20.318726f, 2.214543f, 20.313352f, 2.192347f,
                20.277906f, 2.190171f, 20.238254f, 2.120554f, 20.269614f, 2.040424f
            )
            poly[1018] = TzPolygon(
                20.970852f, 7.670478f, 20.842495f, 7.459686f, 19.446978f, 5.810545f, 19.076172f, 3.911028f, 21.258772f, 3.911028f,
                21.258772f, 7.670478f
            )
            poly[1019] = TzPolygon(
                19.075284f, 3.911028f, 19.144146f, 4.266708f, 17.001741f, 4.266669f, 17.000021f, 4.214297f, 16.395069f, 4.199854f,
                16.323219f, 4.097133f, 16.080829f, 3.986066f, 15.940592f, 3.980084f, 15.864421f, 3.928064f, 15.804220f, 3.911028f
            )
            poly[1020] = TzPolygon(21.773345f, 0.151578f, 21.258772f, 0.946550f, 21.258772f, 0.151578f)
            poly[1021] = TzPolygon(
                -5.149089f, 11.847684f, -4.874770f, 11.644011f, -4.706988f, 11.584748f, -4.633875f, 11.583809f, -4.388063f, 11.293210f,
                -4.388063f, 12.745379f, -4.414169f, 12.745379f, -4.407883f, 12.719734f, -4.441421f, 12.745379f, -4.496467f, 12.745379f,
                -4.477842f, 12.699655f, -4.562289f, 12.643761f, -4.563371f, 12.563626f, -4.588848f, 12.537301f, -4.565076f, 12.487110f,
                -4.602876f, 12.451731f, -4.609268f, 12.392913f, -4.665966f, 12.398902f, -4.790460f, 12.331338f, -4.814448f, 12.241248f,
                -4.798189f, 12.242894f, -4.790754f, 12.197593f, -4.896201f, 12.166210f, -5.040742f, 12.016274f
            )
            poly[1022] = TzPolygon(
                -5.149089f, 12.533084f, -5.144820f, 12.533118f, -5.120687f, 12.470483f, -5.080618f, 12.463866f, -5.047521f, 12.503217f,
                -5.058857f, 12.530412f, -5.024048f, 12.608614f, -4.949038f, 12.626596f, -4.949895f, 12.720466f, -4.899734f, 12.745379f,
                -5.149089f, 12.745379f
            )
            poly[1023] = TzPolygon(
                -4.899734f, 12.745379f, -4.869275f, 12.760506f, -4.875021f, 12.786114f, -4.847198f, 12.812569f, -4.750274f, 12.853410f,
                -4.764080f, 12.869003f, -4.735153f, 12.895728f, -4.747564f, 12.922979f, -4.705112f, 12.982428f, -4.715410f, 13.029954f,
                -4.674784f, 13.051325f, -4.691465f, 13.097409f, -4.622012f, 13.095833f, -4.582741f, 13.118355f, -4.758545f, 13.272979f,
                -4.799991f, 13.373495f, -4.858360f, 13.372927f, -4.916029f, 13.430804f, -4.862081f, 13.415055f, -4.853373f, 13.471463f,
                -5.149089f, 13.471463f, -5.149089f, 12.745379f
            )
            poly[1024] = TzPolygon(
                -4.496467f, 12.745379f, -4.505538f, 12.767647f, -4.488432f, 12.781326f, -4.441421f, 12.745379f, -4.414169f, 12.745379f,
                -4.417344f, 12.758331f, -4.388063f, 12.766741f, -4.437732f, 12.816242f, -4.442669f, 12.833333f, -4.415547f, 12.844098f,
                -4.683994f, 13.102718f, -4.674784f, 13.051325f, -4.715410f, 13.029954f, -4.705112f, 12.982428f, -4.747564f, 12.922979f,
                -4.735153f, 12.895728f, -4.764080f, 12.869003f, -4.750274f, 12.853410f, -4.847198f, 12.812569f, -4.875021f, 12.786114f,
                -4.869275f, 12.760506f, -4.899734f, 12.745379f
            )
            poly[1025] = TzPolygon(
                -4.388063f, 14.197547f, -4.397791f, 14.175852f, -4.409904f, 14.050111f, -4.514932f, 13.948758f, -4.495929f, 13.854472f,
                -4.464057f, 13.858552f, -4.425061f, 13.823032f, -4.444752f, 13.731799f, -4.590065f, 13.728810f, -4.612881f, 13.708287f,
                -4.637446f, 13.717559f, -4.653988f, 13.690323f, -4.678746f, 13.723316f, -4.705490f, 13.723580f, -4.712295f, 13.674170f,
                -4.744944f, 13.699284f, -4.768308f, 13.680257f, -4.735604f, 13.619283f, -4.754568f, 13.636220f, -4.805362f, 13.585853f,
                -4.747471f, 13.514756f, -4.853373f, 13.471463f, -4.388063f, 13.471463f
            )
            poly[1026] = TzPolygon(
                -4.388063f, 15.176360f, -4.390785f, 15.175500f, -4.480124f, 15.107523f, -4.688197f, 14.898611f, -4.820605f, 14.836641f,
                -4.913245f, 14.685218f, -4.903668f, 14.590804f, -4.864807f, 14.561732f, -4.845827f, 14.493747f, -4.895497f, 14.415365f,
                -4.860193f, 14.398851f, -4.651476f, 14.419349f, -4.553697f, 14.351302f, -4.511146f, 14.433956f, -4.438226f, 14.480672f,
                -4.388063f, 14.427510f
            )
            poly[1027] = TzPolygon(
                -4.388063f, 14.197547f, -4.363402f, 14.252545f, -4.319722f, 14.288356f, -4.316395f, 14.352523f, -4.295427f, 14.351353f,
                -4.278450f, 14.401526f, -4.355574f, 14.393079f, -4.388063f, 14.427510f
            )
            poly[1028] = TzPolygon(
                -4.278450f, 11.204916f, -4.214785f, 11.164126f, -4.101226f, 11.004821f, -3.923333f, 11.139722f, -3.693611f, 11.225556f,
                -3.604167f, 11.348056f, -3.591111f, 11.431111f, -3.511111f, 11.487222f, -3.507913f, 11.519834f, -4.278450f, 11.519834f
            )
            poly[1029] = TzPolygon(
                -2.433809f, 11.519834f, -2.433809f, 11.601611f, -2.503889f, 11.593333f, -2.550278f, 11.629722f, -2.620833f, 11.647500f,
                -2.715833f, 11.611944f, -2.793889f, 11.546111f, -2.856944f, 11.543333f, -2.867222f, 11.564722f, -2.818056f, 11.642778f,
                -3.013056f, 11.804444f, -3.047222f, 11.766111f, -3.050556f, 11.717500f, -3.178056f, 11.701111f, -3.311389f, 11.972500f,
                -3.351667f, 11.963611f, -3.394167f, 11.910000f, -3.556111f, 11.839444f, -3.589722f, 11.852500f, -3.636944f, 11.925833f,
                -3.710000f, 11.868333f, -3.694444f, 11.683333f, -3.535000f, 11.583889f, -3.506944f, 11.529722f, -3.507913f, 11.519834f
            )
            poly[1030] = TzPolygon(
                -2.433809f, 14.137028f, -2.496111f, 14.107778f, -2.475556f, 14.069167f, -2.499722f, 14.006111f, -2.468889f, 13.991111f,
                -2.490833f, 13.926111f, -2.474167f, 13.873889f, -2.433809f, 13.868495f
            )
            poly[1031] = TzPolygon(-2.433809f, 13.486182f, -2.437500f, 13.482778f, -2.433809f, 13.470937f)
            poly[1032] = TzPolygon(-2.433809f, 11.738223f, -2.436667f, 11.735278f, -2.433809f, 11.734056f)
            poly[1033] = TzPolygon(
                -2.433809f, 11.601611f, -2.333333f, 11.574167f, -2.353889f, 11.676944f, -2.390000f, 11.685278f, -2.398333f, 11.718889f,
                -2.433809f, 11.734056f
            )
            poly[1034] = TzPolygon(
                -2.433809f, 11.738223f, -2.372222f, 11.801667f, -2.357222f, 11.916111f, -2.331389f, 11.951944f, -2.416944f, 12.052500f,
                -2.327222f, 12.478056f, -2.299167f, 12.463611f, -2.226389f, 12.495278f, -2.164167f, 12.484167f, -2.095008f, 12.517193f,
                -2.081944f, 12.478889f, -2.024444f, 12.448056f, -1.895833f, 12.438333f, -1.877222f, 12.452778f, -1.921667f, 12.506944f,
                -1.872500f, 12.520556f, -1.827222f, 12.585000f, -1.822500f, 12.650000f, -1.857222f, 12.724722f, -1.900556f, 12.763889f,
                -1.912778f, 12.821389f, -2.039444f, 12.866667f, -2.074444f, 12.900278f, -2.096944f, 12.888611f, -2.111389f, 12.913889f,
                -2.131389f, 12.899444f, -2.184167f, 12.921389f, -2.182500f, 12.967500f, -2.265556f, 13.007778f, -2.271835f, 13.029639f,
                -2.281579f, 13.029639f, -2.372222f, 12.984444f, -2.336948f, 13.029639f, -2.433809f, 13.029639f
            )
            poly[1035] = TzPolygon(
                -2.433809f, 13.470937f, -2.416111f, 13.414167f, -2.428333f, 13.387500f, -2.360556f, 13.203056f, -2.372222f, 13.141389f,
                -2.327778f, 13.041389f, -2.336948f, 13.029639f, -2.281579f, 13.029639f, -2.273056f, 13.033889f, -2.271835f, 13.029639f,
                -1.511488f, 13.029639f, -1.511488f, 14.463344f, -1.545556f, 14.480556f, -1.610833f, 14.383889f, -1.671667f, 14.424167f,
                -1.686111f, 14.468056f, -1.750556f, 14.416111f, -1.891667f, 14.429722f, -1.973056f, 14.258333f, -2.011389f, 14.248889f,
                -2.039444f, 14.269444f, -2.137500f, 14.250278f, -2.153889f, 14.219444f, -2.190278f, 14.225556f, -2.238889f, 14.155000f,
                -2.292778f, 14.221389f, -2.352500f, 14.252222f, -2.360556f, 14.196667f, -2.391389f, 14.156944f, -2.433809f, 14.137028f,
                -2.433809f, 13.868495f, -2.418056f, 13.866389f, -2.352500f, 13.931667f, -2.318889f, 13.881389f, -2.144444f, 13.809444f,
                -2.088889f, 13.762222f, -2.184167f, 13.727222f, -2.287500f, 13.624444f, -2.321667f, 13.618333f, -2.330556f, 13.581389f,
                -2.433809f, 13.486182f
            )
            poly[1036] = TzPolygon(
                -1.511488f, 14.463344f, -1.492222f, 14.453611f, -1.406667f, 14.505000f, -1.338056f, 14.444722f, -1.283889f, 14.478333f,
                -1.212778f, 14.481944f, -1.166944f, 14.446111f, -1.120833f, 14.453611f, -1.033889f, 14.417500f, -0.906389f, 14.430000f,
                -0.841111f, 14.489167f, -0.785000f, 14.465833f, -0.720000f, 14.474722f, -0.644722f, 14.531944f, -0.589167f, 14.539444f,
                -1.511488f, 14.539444f
            )
            poly[1037] = TzPolygon(
                2.305104f, 11.529307f, 2.294480f, 11.372882f, 2.243097f, 11.376888f, 2.224767f, 11.351751f, 2.171892f, 11.359863f,
                2.161308f, 10.169245f, 2.175300f, 10.157332f, 2.156568f, 10.121555f, 2.197672f, 9.906463f, 2.245694f, 9.848172f,
                2.348858f, 9.822532f, 2.337498f, 9.812204f, 2.390620f, 9.761857f, 2.449845f, 9.621122f, 2.449845f, 11.529307f
            )
            poly[1038] = TzPolygon(
                -0.589167f, 8.519169f, -0.518678f, 8.539267f, 0.366974f, 9.103149f, 0.611238f, 9.109213f, 0.753447f, 9.149294f,
                0.846457f, 9.354785f, 0.962984f, 9.519126f, 1.022618f, 9.547461f, 1.029444f, 9.620000f, 1.066944f, 9.683056f,
                1.064722f, 9.743889f, 1.000989f, 9.796144f, 0.993443f, 9.871259f, 0.953237f, 9.894842f, 0.922017f, 9.952044f,
                0.936378f, 9.993269f, 1.002527f, 9.991876f, 1.002160f, 11.353313f, 2.224767f, 11.351751f, 2.263374f, 11.380278f,
                2.286241f, 11.363444f, 2.304693f, 11.529307f, -0.589167f, 11.529307f
            )
            poly[1039] = TzPolygon(
                0.930339f, 11.529307f, 0.930339f, 14.478687f, 0.909722f, 14.468056f, 0.872500f, 14.483889f, 0.729722f, 14.366944f,
                0.665278f, 14.376389f, 0.566944f, 14.238333f, 0.594167f, 14.143333f, 0.575278f, 14.094444f, 0.537222f, 14.064167f,
                0.508056f, 14.083611f, 0.460556f, 14.055278f, 0.406389f, 13.972778f, 0.360833f, 13.943333f, 0.243611f, 13.880000f,
                0.158611f, 13.910833f, 0.089444f, 13.908889f, 0.072778f, 13.945278f, -0.018056f, 13.952222f, -0.030556f, 13.913056f,
                -0.114167f, 13.876667f, -0.222222f, 13.906667f, -0.220833f, 13.930278f, -0.171667f, 13.965278f, -0.208333f, 14.018889f,
                -0.218056f, 14.085000f, -0.256944f, 14.121944f, -0.252778f, 14.146667f, -0.340000f, 14.190000f, -0.427222f, 14.191389f,
                -0.397500f, 14.226667f, -0.417500f, 14.260278f, -0.405000f, 14.346944f, -0.455000f, 14.435000f, -0.589167f, 14.539444f,
                -0.589167f, 11.529307f
            )
            poly[1040] = TzPolygon(
                2.304693f, 11.529307f, 2.308893f, 11.567060f, 2.295283f, 11.611840f, 2.318217f, 11.667898f, 2.296779f, 11.746886f,
                2.270215f, 11.758190f, 2.290541f, 12.014829f, 2.278983f, 12.109913f, 2.293420f, 12.124026f, 2.272911f, 12.153797f,
                2.278762f, 12.209763f, 2.249284f, 12.246226f, 2.288098f, 12.307963f, 2.252029f, 12.454503f, 2.270253f, 12.574430f,
                2.221089f, 12.745582f, 2.258038f, 12.819520f, 2.227595f, 12.861641f, 2.254427f, 12.919224f, 2.244885f, 13.034375f,
                0.930339f, 13.034375f, 0.930339f, 11.529307f
            )
            poly[1041] = TzPolygon(
                0.930339f, 14.478687f, 0.963056f, 14.495556f, 1.015000f, 14.437778f, 1.143056f, 14.392222f, 1.146389f, 14.344167f,
                1.338333f, 14.300278f, 1.397778f, 14.243056f, 1.363333f, 14.236111f, 1.396667f, 14.147222f, 1.375278f, 14.073889f,
                1.435475f, 14.009031f, 1.414113f, 13.981412f, 1.437290f, 13.804677f, 1.361105f, 13.782488f, 1.347023f, 13.759445f,
                1.370402f, 13.735854f, 1.347467f, 13.704845f, 1.345895f, 13.638278f, 1.277134f, 13.560218f, 1.264157f, 13.494808f,
                1.298083f, 13.413795f, 1.277655f, 13.397414f, 1.288539f, 13.373097f, 1.262936f, 13.370895f, 1.263901f, 13.322883f,
                1.218333f, 13.307858f, 1.215702f, 13.191636f, 1.235743f, 13.151534f, 1.249101f, 13.178621f, 1.290940f, 13.188228f,
                1.283353f, 13.222582f, 1.327751f, 13.262767f, 1.340869f, 13.240600f, 1.386200f, 13.256824f, 1.473796f, 13.219008f,
                1.485380f, 13.189364f, 1.520694f, 13.188392f, 1.522310f, 13.159675f, 1.582230f, 13.125260f, 1.599301f, 13.148658f,
                1.690092f, 13.136769f, 1.690092f, 14.539444f, 0.930339f, 14.539444f
            )
            poly[1042] = TzPolygon(
                1.690092f, 13.136769f, 1.701932f, 13.135219f, 1.758564f, 13.183792f, 1.842958f, 13.204052f, 1.892737f, 13.155383f,
                1.945911f, 13.214721f, 1.986170f, 13.209987f, 2.039972f, 13.288189f, 2.170589f, 13.294224f, 2.162601f, 14.303220f,
                2.187413f, 14.362831f, 2.181393f, 14.413208f, 2.125580f, 14.460679f, 2.162144f, 14.496940f, 2.168588f, 14.539444f,
                1.690092f, 14.539444f
            )
            poly[1043] = TzPolygon(
                2.244885f, 13.034375f, 2.449845f, 13.034375f, 2.449845f, 14.539444f, 2.168588f, 14.539444f, 2.162144f, 14.496940f,
                2.125580f, 14.460679f, 2.181393f, 14.413208f, 2.187413f, 14.362831f, 2.162601f, 14.303220f, 2.170589f, 13.294224f,
                2.189960f, 13.285457f, 2.207781f, 13.305611f, 2.248434f, 13.286230f, 2.286593f, 13.157670f, 2.240710f, 13.084764f
            )
            poly[1044] = TzPolygon(
                2.449845f, 9.621122f, 2.612062f, 9.628621f, 2.968564f, 9.704413f, 3.095473f, 9.753985f, 3.226388f, 9.698765f,
                3.459143f, 9.457561f, 3.551523f, 9.429657f, 3.617881f, 9.437811f, 3.657555f, 9.414185f, 3.770907f, 9.125295f,
                3.905936f, 8.983255f, 3.960447f, 8.831346f, 3.989000f, 8.812720f, 3.989000f, 14.539444f, 2.449845f, 14.539444f
            )
            poly[1045] = TzPolygon(
                -4.388063f, 15.176360f, -4.324801f, 15.196357f, -4.314818f, 15.260017f, -4.269069f, 15.328294f, -4.285389f, 15.403775f,
                -4.234898f, 15.476578f, -4.086742f, 15.513317f, -4.043198f, 15.551151f, -3.971814f, 15.834901f, -3.933267f, 15.905928f,
                -3.768727f, 15.967675f, -3.305540f, 16.213361f, -3.256525f, 16.181260f, -3.117866f, 16.171475f, -3.010600f, 16.191880f,
                -2.891454f, 16.179864f, -2.642222f, 16.237222f, -2.344654f, 16.174668f, -2.175833f, 16.195833f, -2.093611f, 16.265556f,
                -2.027047f, 16.377385f, -1.874722f, 16.519444f, -1.620000f, 16.663056f, -1.428056f, 16.740000f, -1.240000f, 16.875278f,
                -1.108867f, 17.045704f, -0.990099f, 17.343811f, -0.744673f, 17.529677f, -0.669319f, 17.635592f, -0.582347f, 17.686841f,
                -0.365718f, 17.715508f, -0.257402f, 17.664696f, -0.199531f, 17.672457f, -0.199531f, 18.643611f, -4.388063f, 18.643611f
            )
            poly[1046] = TzPolygon(
                1.894734f, 15.770172f, 1.894734f, 16.086057f, 1.893200f, 16.086779f, 1.892054f, 16.109202f, 1.704376f, 16.149758f,
                1.688294f, 16.141673f, 1.696571f, 16.091277f, 1.654666f, 16.056206f, 1.671355f, 16.021178f, 1.765282f, 16.026002f,
                1.766502f, 15.960145f, 1.797557f, 15.905648f, 1.785553f, 15.881105f, 1.829640f, 15.867463f, 1.856241f, 15.805292f
            )
            poly[1047] = TzPolygon(
                -0.199531f, 17.672457f, -0.167795f, 17.676713f, -0.064112f, 17.734219f, 0.122484f, 17.774045f, 0.233377f, 17.821252f,
                0.323333f, 17.931111f, 0.378056f, 17.958056f, 0.477778f, 17.965833f, 0.614040f, 17.868029f, 0.775904f, 17.889144f,
                0.977926f, 17.839877f, 1.028902f, 17.847945f, 1.145610f, 17.926051f, 1.350010f, 17.971026f, 1.528611f, 18.070556f,
                1.855833f, 18.063611f, 1.894734f, 18.072423f, 1.894734f, 18.643611f, -0.199531f, 18.643611f
            )
            poly[1048] = TzPolygon(
                1.950160f, 15.565486f, 1.956340f, 15.528454f, 1.983595f, 15.485659f, 1.912363f, 15.343595f, 1.943548f, 15.334941f,
                1.936956f, 15.305682f, 1.990405f, 15.287792f, 2.008040f, 15.245354f, 2.028165f, 15.249450f, 2.039656f, 15.206576f,
                2.016482f, 15.175517f, 2.039909f, 15.147149f, 1.982831f, 15.105078f, 2.004381f, 15.062587f, 1.978659f, 15.040876f,
                2.036848f, 14.983098f, 2.007908f, 14.968628f, 2.000274f, 14.914725f, 2.021618f, 14.889212f, 2.063766f, 14.911187f,
                2.073285f, 14.877485f, 2.110875f, 14.872987f, 2.106380f, 14.856531f, 2.080327f, 14.860396f, 2.063160f, 14.771696f,
                2.095891f, 14.770254f, 2.092430f, 14.736802f, 2.108435f, 14.751509f, 2.128189f, 14.723248f, 2.105805f, 14.723036f,
                2.135845f, 14.684602f, 2.132700f, 14.644155f, 2.157531f, 14.644020f, 2.206828f, 14.595511f, 2.174433f, 14.577998f,
                2.168588f, 14.539444f, 2.941867f, 14.539444f, 2.941867f, 15.565486f
            )
            poly[1049] = TzPolygon(
                2.941867f, 16.063824f, 2.941867f, 16.468045f, 2.922500f, 16.465833f, 2.849444f, 16.501667f, 2.215655f, 16.192148f,
                2.253401f, 16.159002f, 2.274668f, 16.170339f, 2.352441f, 16.143843f, 2.463001f, 16.073344f, 2.596712f, 16.083097f,
                2.645393f, 16.065506f, 2.701181f, 16.087589f
            )
            poly[1050] = TzPolygon(1.950160f, 15.565486f, 1.919821f, 15.747283f, 1.894734f, 15.770172f, 1.894734f, 15.565486f)
            poly[1051] = TzPolygon(
                1.894734f, 16.086057f, 1.975333f, 16.048118f, 2.046686f, 16.083190f, 2.066028f, 16.058896f, 2.088539f, 16.085516f,
                2.190736f, 16.081278f, 2.198516f, 16.129218f, 2.177135f, 16.144418f, 2.220833f, 16.207222f, 2.849444f, 16.501667f,
                2.922500f, 16.465833f, 2.941867f, 16.468045f, 2.941867f, 16.591527f, 1.894734f, 16.591527f
            )
            poly[1052] = TzPolygon(
                2.941867f, 16.468045f, 3.002778f, 16.475000f, 3.060556f, 16.512222f, 3.156667f, 16.482778f, 3.242222f, 16.534722f,
                3.481944f, 16.588889f, 3.483459f, 16.591527f, 2.941867f, 16.591527f
            )
            poly[1053] = TzPolygon(
                3.989000f, 15.101119f, 3.243641f, 15.733623f, 3.270249f, 15.775423f, 3.020453f, 16.056065f, 2.941867f, 16.063824f,
                2.941867f, 14.539444f, 3.989000f, 14.539444f
            )
            poly[1054] = TzPolygon(
                1.894734f, 18.072423f, 1.956389f, 18.086389f, 2.042500f, 18.071944f, 2.224167f, 18.091944f, 2.288611f, 18.116111f,
                2.413611f, 18.222778f, 2.519167f, 18.233056f, 2.612804f, 18.341960f, 2.941867f, 18.482194f, 2.941867f, 18.643611f,
                1.894734f, 18.643611f
            )
            poly[1055] = TzPolygon(
                3.963134f, 18.643611f, 3.894911f, 18.597684f, 3.776866f, 18.578482f, 3.471247f, 18.625818f, 3.480404f, 18.597423f,
                3.598889f, 18.533333f, 3.641944f, 18.481389f, 3.577500f, 18.398056f, 3.583056f, 18.272500f, 3.499167f, 18.233889f,
                3.482778f, 18.183889f, 3.541111f, 18.154722f, 3.560556f, 18.119444f, 3.565833f, 18.043333f, 3.539167f, 17.988889f,
                3.577500f, 17.938889f, 3.535556f, 17.858889f, 3.618333f, 17.828333f, 3.637500f, 17.739444f, 3.629722f, 17.615278f,
                3.713056f, 17.482222f, 3.679722f, 17.413889f, 3.611111f, 17.346667f, 3.628889f, 17.278056f, 3.584444f, 17.234167f,
                3.576667f, 17.077222f, 3.540278f, 17.033333f, 3.565833f, 16.876667f, 3.523333f, 16.856667f, 3.522222f, 16.807500f,
                3.550556f, 16.761111f, 3.533333f, 16.659722f, 3.473578f, 16.591527f, 3.989000f, 16.591527f, 3.989000f, 18.643611f
            )
            poly[1056] = TzPolygon(
                2.941867f, 18.482194f, 3.075556f, 18.539167f, 3.131944f, 18.611667f, 3.204444f, 18.641389f, 3.450833f, 18.633056f,
                3.525348f, 18.606642f, 3.776866f, 18.578482f, 3.894911f, 18.597684f, 3.963134f, 18.643611f, 2.941867f, 18.643611f
            )
            poly[1057] = TzPolygon(
                5.392003f, 7.670478f, 5.392003f, 8.831418f, 5.184724f, 8.821095f, 5.112839f, 8.783711f, 5.074011f, 8.726946f,
                4.915088f, 8.651601f, 4.885393f, 8.605639f, 4.824472f, 8.629359f, 4.798797f, 8.541861f, 4.745622f, 8.525122f,
                4.701767f, 8.538976f, 4.633333f, 8.464444f, 4.533333f, 8.407500f, 4.367260f, 8.388005f, 4.334996f, 8.291972f,
                4.343220f, 8.047569f, 4.311792f, 7.773734f, 4.273511f, 7.670478f
            )
            poly[1058] = TzPolygon(3.989000f, 15.101119f, 4.020510f, 15.074380f, 4.056659f, 15.179509f, 3.989000f, 15.179509f)
            poly[1059] = TzPolygon(
                4.056659f, 15.179509f, 4.072377f, 15.139940f, 4.140126f, 15.099316f, 4.301683f, 15.086756f, 4.367979f, 15.025842f,
                4.424309f, 15.007932f, 4.528186f, 14.811149f, 4.613343f, 14.730443f, 4.763390f, 14.702060f, 4.787659f, 14.720689f,
                4.868751f, 14.714642f, 4.989378f, 14.676192f, 5.085474f, 14.674379f, 5.099826f, 14.693488f, 5.197609f, 14.664195f,
                5.236790f, 14.569226f, 5.284228f, 14.525659f, 5.392003f, 14.574987f, 5.392003f, 15.179509f
            )
            poly[1060] = TzPolygon(
                4.053118f, 18.643611f, 4.113147f, 18.629967f, 4.321085f, 18.544872f, 4.370924f, 18.601229f, 4.355917f, 18.623726f,
                4.358327f, 18.643611f
            )
            poly[1061] = TzPolygon(
                -5.149089f, 20.196621f, -5.093373f, 20.184198f, -4.962167f, 20.111568f, -4.825026f, 20.084791f, -4.787507f, 20.053543f,
                -4.594667f, 20.060758f, -4.502333f, 20.123901f, -4.472154f, 20.089354f, -4.438080f, 20.092421f, -4.360583f, 20.039462f,
                -4.292114f, 20.028132f, -4.283762f, 20.137767f, -4.337853f, 20.168323f, -4.329015f, 20.205279f, -4.378762f, 20.240936f,
                -4.381734f, 20.321151f, -4.362393f, 20.350162f, -4.300258f, 20.364925f, -4.282112f, 20.398055f, -4.293750f, 20.433715f,
                -4.254549f, 20.453112f, -4.262706f, 20.508213f, -4.220422f, 20.599537f, -4.158245f, 20.634504f, -4.133010f, 20.675140f,
                -3.534440f, 20.641899f, -3.284014f, 20.656448f, -2.766325f, 20.744471f, -2.568229f, 20.862217f, -2.568756f, 20.921967f,
                -2.532577f, 21.005298f, -2.535367f, 21.213981f, -2.513816f, 21.231263f, -2.513816f, 21.349804f, -2.517435f, 21.355610f,
                -2.513816f, 21.426639f, -2.549216f, 21.523458f, -2.612706f, 21.591087f, -2.668791f, 21.697429f, -2.535967f, 21.851638f,
                -2.513816f, 21.870083f, -2.513816f, 23.048844f, -5.149089f, 23.048844f
            )
            poly[1062] = TzPolygon(-2.513816f, 21.231263f, -2.464549f, 21.270770f, -2.513816f, 21.349804f)
            poly[1063] = TzPolygon(-2.513816f, 21.410194f, -2.512893f, 21.424115f, -2.513816f, 21.426639f)
            poly[1064] = TzPolygon(
                -2.513816f, 21.870083f, -2.415560f, 21.951901f, -2.370830f, 22.048599f, -2.276390f, 22.139700f, -2.313330f, 22.190599f,
                -2.434720f, 22.188299f, -2.464720f, 22.264401f, -2.432500f, 22.293301f, -2.395560f, 22.293900f, -1.942220f, 22.166401f,
                -1.903330f, 22.185000f, -1.958890f, 22.509701f, -1.874440f, 22.590000f, -1.801110f, 22.625601f, -1.816940f, 22.642799f,
                -1.806670f, 22.679701f, -1.884170f, 22.870300f, -1.962220f, 22.936701f, -1.931940f, 23.005800f, -1.931940f, 23.048844f,
                -2.513816f, 23.048844f
            )
            poly[1065] = TzPolygon(-0.405810f, 23.048844f, -0.406005f, 22.950006f, -0.301638f, 23.048844f)
            poly[1066] = TzPolygon(
                -1.196180f, 23.048844f, -1.196180f, 23.952777f, -1.245429f, 24.117882f, -1.328410f, 24.148030f, -1.312780f, 24.192542f,
                -1.324276f, 24.315046f, -1.431390f, 24.322201f, -1.538890f, 24.375799f, -1.717948f, 24.412389f, -1.693910f, 24.208231f,
                -1.740866f, 24.212141f, -1.747592f, 24.041633f, -1.762776f, 24.004826f, -1.870604f, 23.988210f, -1.825712f, 23.882300f,
                -1.830967f, 23.839135f, -1.943854f, 23.849276f, -1.956766f, 23.771667f, -2.025066f, 23.669920f, -1.983143f, 23.569383f,
                -1.987646f, 23.532797f, -2.094769f, 23.408106f, -2.076615f, 23.345186f, -2.012034f, 23.265102f, -1.996498f, 23.167227f,
                -1.931940f, 23.073900f, -1.931940f, 23.048844f
            )
            poly[1067] = TzPolygon(
                -1.196180f, 23.952777f, -1.164671f, 23.847147f, -1.106267f, 23.798967f, -1.035631f, 23.629960f, -0.971981f, 23.547773f,
                -0.742023f, 23.479608f, -0.717072f, 23.593020f, -0.644594f, 23.620001f, -0.627671f, 23.669479f, -0.545992f, 23.687649f,
                -0.539820f, 23.606477f, -0.499787f, 23.606666f, -0.440329f, 23.528824f, -0.470058f, 23.479577f, -0.463077f, 23.421659f,
                -0.519498f, 23.250842f, -0.405416f, 23.248982f, -0.405810f, 23.048844f, -0.301638f, 23.048844f, -0.240462f, 23.106779f,
                -0.240600f, 23.413102f, -0.208330f, 23.408300f, -0.105070f, 23.358014f, -0.076116f, 23.313948f, 0.035830f, 23.246401f,
                0.121457f, 23.169407f, 0.121457f, 25.251460f, -1.196180f, 25.251460f
            )
            poly[1068] = TzPolygon(
                0.320278f, 23.048844f, 0.413330f, 22.972500f, 0.559170f, 22.934700f, 0.599999f, 22.979260f, 0.722951f, 22.883378f,
                0.821206f, 22.876812f, 0.902662f, 22.839527f, 0.997360f, 22.842282f, 1.054283f, 22.790428f, 1.111761f, 22.787376f,
                1.123663f, 22.764177f, 1.203480f, 22.743846f, 1.236635f, 22.704166f, 1.282429f, 22.700007f, 1.302658f, 22.667177f,
                1.353510f, 22.654914f, 1.490396f, 22.477126f, 1.483102f, 22.431593f, 1.521444f, 22.377218f, 1.499053f, 22.358775f,
                1.503470f, 22.307403f, 1.531504f, 22.260730f, 1.672559f, 22.289445f, 1.732271f, 22.388322f, 1.790952f, 22.357595f,
                1.807766f, 22.415616f, 1.866444f, 22.425401f, 1.914998f, 22.490461f, 1.984309f, 22.470033f, 2.041094f, 22.412870f,
                2.055333f, 22.363603f, 2.171983f, 22.361200f, 2.109440f, 22.647499f, 2.014271f, 22.779241f, 2.036389f, 22.793194f,
                2.048123f, 22.858602f, 2.100224f, 22.900666f, 2.091718f, 22.922827f, 2.120939f, 22.945653f, 2.142153f, 22.929160f,
                2.158767f, 22.972711f, 2.185767f, 22.972703f, 2.176404f, 23.002694f, 2.219834f, 23.018029f, 2.202753f, 23.048844f
            )
            poly[1069] = TzPolygon(2.574024f, 23.048844f, 2.738620f, 22.887023f, 2.756730f, 22.886339f, 2.756730f, 23.048844f)
            poly[1070] = TzPolygon(
                4.453945f, 20.846227f, 4.454313f, 20.841387f, 4.422090f, 20.792601f, 4.433132f, 20.709684f, 4.411489f, 20.583090f,
                4.518113f, 20.468019f, 4.564489f, 20.446319f, 4.621470f, 20.459608f, 4.666591f, 20.404159f, 4.733572f, 20.385609f,
                4.771574f, 20.343094f, 4.789021f, 20.251046f, 4.890803f, 20.174879f, 4.902764f, 20.104129f, 4.971336f, 20.007547f,
                4.982619f, 19.913455f, 5.107322f, 19.819689f, 5.146298f, 19.679673f, 5.132353f, 19.429713f, 5.055703f, 19.335296f,
                5.008325f, 19.234069f, 4.941531f, 19.196843f, 4.934424f, 19.098873f, 4.767245f, 19.019403f, 4.578829f, 18.829100f,
                4.467970f, 18.805757f, 4.403558f, 18.762713f, 4.365344f, 18.706462f, 4.358183f, 18.643611f, 5.392003f, 18.643611f,
                5.392003f, 20.846227f
            )
            poly[1071] = TzPolygon(4.053118f, 18.643611f, 3.985847f, 18.658901f, 3.963134f, 18.643611f)
            poly[1072] = TzPolygon(
                2.756730f, 23.048844f, 2.756730f, 22.886339f, 2.794769f, 22.884903f, 2.809885f, 22.905816f, 2.774617f, 22.948569f,
                2.852956f, 22.954060f, 3.014839f, 23.048844f
            )
            poly[1073] = TzPolygon(
                3.043771f, 23.048844f, 3.071389f, 23.019725f, 3.053381f, 22.991270f, 3.080576f, 22.921835f, 3.020028f, 22.857884f,
                3.018986f, 22.827751f, 3.040205f, 22.788424f, 3.105730f, 22.781702f, 3.123951f, 22.759748f, 3.169179f, 22.574491f,
                3.283765f, 22.651379f, 3.349625f, 22.615457f, 3.447500f, 22.667500f, 3.507780f, 22.862801f, 3.548050f, 22.928600f,
                3.547500f, 23.037500f, 3.558585f, 23.048844f
            )
            poly[1074] = TzPolygon(
                4.074367f, 22.588140f, 4.074367f, 23.048844f, 3.873493f, 23.048844f, 3.845713f, 22.892980f, 3.874144f, 22.878388f,
                3.864724f, 22.849893f, 3.905000f, 22.765600f, 3.991390f, 22.758600f, 3.998050f, 22.687201f
            )
            poly[1075] = TzPolygon(
                4.453945f, 20.846227f, 4.446182f, 20.948296f, 4.400139f, 21.076638f, 4.342185f, 21.112322f, 4.291088f, 21.213481f,
                4.344795f, 21.281970f, 4.282870f, 21.361989f, 4.292571f, 21.443433f, 4.253588f, 21.539015f, 4.313146f, 21.651111f,
                4.294658f, 21.704006f, 4.312051f, 21.737176f, 4.246735f, 21.859005f, 4.245458f, 22.001897f, 4.215999f, 22.096310f,
                4.154845f, 22.164920f, 4.115013f, 22.258415f, 4.130831f, 22.412604f, 4.113610f, 22.537201f, 4.074367f, 22.588140f,
                4.074367f, 20.846227f
            )
            poly[1076] = TzPolygon(
                4.074367f, 22.588140f, 4.113610f, 22.537201f, 4.128116f, 22.433401f, 4.218712f, 22.549283f, 4.287764f, 22.544191f,
                4.371867f, 22.616653f, 4.393387f, 22.582661f, 4.477131f, 22.592288f, 4.494364f, 22.647461f, 4.466445f, 22.678672f,
                4.477382f, 22.704437f, 4.626855f, 22.734063f, 4.714671f, 22.781843f, 4.728591f, 22.801367f, 4.699666f, 22.840577f,
                4.709639f, 22.860937f, 4.755851f, 22.897627f, 4.791394f, 22.884383f, 4.817068f, 22.903514f, 4.838412f, 22.969425f,
                4.757221f, 23.009905f, 4.735600f, 23.048844f, 4.074367f, 23.048844f
            )
            poly[1077] = TzPolygon(
                2.574024f, 23.048844f, 2.518110f, 23.240267f, 2.476124f, 23.296352f, 2.459083f, 23.287909f, 2.460178f, 23.310973f,
                2.496908f, 23.311656f, 2.495057f, 23.335673f, 2.566399f, 23.360564f, 2.502884f, 23.427261f, 2.511081f, 23.451921f,
                2.451276f, 23.536449f, 2.396540f, 23.572473f, 2.194189f, 23.579607f, 2.183024f, 23.477547f, 2.284941f, 23.321782f,
                2.255936f, 23.307842f, 2.105572f, 23.321880f, 2.089857f, 23.312563f, 2.106118f, 23.271167f, 2.085449f, 23.224255f,
                2.099406f, 23.177406f, 2.171663f, 23.104929f, 2.202753f, 23.048844f
            )
            poly[1078] = TzPolygon(0.320278f, 23.048844f, 0.278890f, 23.082800f, 0.156940f, 23.137501f, 0.121457f, 23.169407f, 0.121457f, 23.048844f)
            poly[1079] = TzPolygon(
                3.873493f, 23.048844f, 3.891806f, 23.151588f, 3.851729f, 23.151588f, 3.869712f, 23.216305f, 3.838541f, 23.329773f,
                3.808224f, 23.364448f, 3.839911f, 23.403072f, 3.819700f, 23.515682f, 3.738330f, 23.486900f, 3.609170f, 23.356100f,
                3.640560f, 23.300600f, 3.641940f, 23.229401f, 3.678060f, 23.171101f, 3.558585f, 23.048844f
            )
            poly[1080] = TzPolygon(3.043771f, 23.048844f, 3.033441f, 23.059735f, 3.014839f, 23.048844f)
            poly[1081] = TzPolygon(
                4.735600f, 23.048844f, 4.719582f, 23.077690f, 4.711563f, 23.110598f, 4.741605f, 23.170339f, 4.675616f, 23.230627f,
                4.671802f, 23.262300f, 4.633541f, 23.275396f, 4.593090f, 23.420547f, 4.652150f, 23.428613f, 4.698666f, 23.534880f,
                4.761270f, 23.591464f, 4.786707f, 23.779477f, 4.834795f, 23.832884f, 4.813071f, 23.854751f, 4.832797f, 23.890871f,
                4.810105f, 23.955909f, 4.874777f, 23.961796f, 4.860875f, 24.032528f, 4.918561f, 24.110923f, 4.893947f, 24.150152f,
                4.074367f, 24.150152f, 4.074367f, 23.048844f
            )
            poly[1082] = TzPolygon(
                4.893947f, 24.150152f, 4.892911f, 24.151802f, 4.957941f, 24.228135f, 4.935432f, 24.267610f, 4.996370f, 24.282078f,
                5.008267f, 24.364835f, 5.034679f, 24.397315f, 5.058355f, 24.340874f, 5.113320f, 24.378017f, 5.055809f, 24.441597f,
                5.094951f, 24.442763f, 5.104278f, 24.462988f, 5.083030f, 24.533753f, 5.033061f, 24.568374f, 5.023353f, 24.618748f,
                4.975240f, 24.631501f, 4.968530f, 24.671286f, 4.918514f, 24.660436f, 4.894933f, 24.723396f, 4.910804f, 24.765870f,
                4.895599f, 24.782145f, 4.925747f, 24.797754f, 4.924248f, 24.847961f, 4.955276f, 24.864712f, 4.951207f, 24.910493f,
                4.987910f, 24.956665f, 4.926366f, 25.063374f, 4.979266f, 25.086679f, 4.987306f, 25.123522f, 5.011455f, 25.120552f,
                5.030072f, 25.149648f, 4.998823f, 25.190979f, 5.018555f, 25.251460f, 4.074367f, 25.251460f, 4.074367f, 24.150152f
            )
            poly[1083] = TzPolygon(
                5.018555f, 25.251460f, 5.042864f, 25.325971f, 5.153051f, 25.348446f, 5.149934f, 25.326214f, 5.191158f, 25.308082f,
                5.207844f, 25.329194f, 5.263261f, 25.335902f, 5.291217f, 25.376497f, 5.309216f, 25.356921f, 5.316116f, 25.385945f,
                5.338343f, 25.390144f, 5.310577f, 25.421530f, 5.340630f, 25.433832f, 5.363830f, 25.478518f, 5.343866f, 25.498601f,
                5.357834f, 25.538647f, 5.392003f, 25.532746f, 5.378271f, 25.578793f, 5.348268f, 25.590020f, 5.349458f, 25.622166f,
                5.325473f, 25.594588f, 5.304153f, 25.630399f, 5.332135f, 25.647912f, 5.307484f, 25.658072f, 5.302535f, 25.706518f,
                5.240455f, 25.739950f, 5.278193f, 25.785064f, 5.240883f, 25.781114f, 5.246614f, 25.802114f, 5.224746f, 25.802114f,
                5.220515f, 25.799912f, 5.218235f, 25.802114f, 4.733185f, 25.802114f, 4.733185f, 25.251460f
            )
            poly[1084] = TzPolygon(5.246614f, 25.802114f, 5.250234f, 25.815378f, 5.224746f, 25.802114f)
            poly[1085] = TzPolygon(
                5.218235f, 25.802114f, 5.190843f, 25.828561f, 5.216922f, 25.842266f, 5.223918f, 25.881028f, 5.168547f, 25.899421f,
                5.205500f, 25.903395f, 5.199552f, 25.962596f, 5.247260f, 25.974660f, 5.225250f, 25.986343f, 5.236148f, 26.004379f,
                5.210426f, 26.007996f, 5.225440f, 26.048613f, 5.194864f, 26.060582f, 5.217588f, 26.066150f, 5.213591f, 26.093918f,
                5.244167f, 26.089516f, 5.261537f, 26.157616f, 5.238789f, 26.156641f, 5.247902f, 26.184837f, 5.223703f, 26.186812f,
                5.242458f, 26.205533f, 5.194898f, 26.214420f, 5.213744f, 26.234497f, 5.188542f, 26.233346f, 5.202200f, 26.249740f,
                5.177549f, 26.248384f, 5.171267f, 26.285194f, 5.141691f, 26.297234f, 5.160798f, 26.348845f, 5.159834f, 26.352768f,
                4.733185f, 26.352768f, 4.733185f, 25.802114f
            )
            poly[1086] = TzPolygon(
                5.002966f, 27.454076f, 5.007201f, 27.448175f, 5.097019f, 27.435464f, 5.258413f, 27.272964f, 5.392003f, 27.236097f,
                5.392003f, 27.454076f
            )
            poly[1087] = TzPolygon(
                5.159834f, 26.352768f, 5.151708f, 26.385822f, 5.123179f, 26.395363f, 5.136004f, 26.412353f, 5.047611f, 26.484716f,
                5.046781f, 26.523045f, 5.074380f, 26.536832f, 5.048710f, 26.536990f, 5.087032f, 26.572786f, 5.094020f, 26.613559f,
                5.067242f, 26.625988f, 5.093511f, 26.637452f, 5.078233f, 26.652760f, 5.101007f, 26.681046f, 5.109124f, 26.767805f,
                5.049289f, 26.802714f, 5.058418f, 26.840721f, 5.035475f, 26.869294f, 5.142063f, 26.933270f, 5.206982f, 27.077302f,
                5.201334f, 27.151226f, 5.075767f, 27.440032f, 5.007201f, 27.448175f, 5.002966f, 27.454076f, 4.074367f, 27.454076f,
                4.074367f, 26.352768f
            )
            poly[1088] = TzPolygon(
                5.392003f, 8.831418f, 5.430745f, 8.833348f, 5.564172f, 8.921486f, 5.625444f, 8.900434f, 5.678747f, 8.838010f,
                5.706214f, 8.832639f, 5.707294f, 8.855352f, 5.775102f, 8.883796f, 5.803268f, 8.874202f, 5.794217f, 8.847305f,
                5.824821f, 8.841134f, 5.862375f, 8.904176f, 5.903398f, 8.912843f, 6.000294f, 9.054520f, 6.094178f, 9.153626f,
                6.133430f, 9.169236f, 6.181325f, 9.264433f, 6.292077f, 9.334492f, 6.352577f, 9.345186f, 6.315655f, 9.432777f,
                6.454097f, 9.465081f, 6.442678f, 9.529238f, 6.473631f, 9.587119f, 6.529572f, 9.596785f, 6.512029f, 9.705982f,
                6.678206f, 9.749897f, 6.678363f, 9.752025f, 5.392003f, 9.752025f
            )
            poly[1089] = TzPolygon(
                6.961340f, 10.792799f, 6.955622f, 10.764739f, 7.016235f, 10.683304f, 7.039739f, 10.678627f, 7.049512f, 10.624648f,
                7.076657f, 10.595640f, 7.146672f, 10.595295f, 7.162243f, 10.571577f, 6.939719f, 10.541417f, 6.899941f, 10.488943f,
                6.916012f, 10.462147f, 6.889346f, 10.215537f, 6.941781f, 10.172182f, 7.013912f, 10.176459f, 7.038377f, 10.150528f,
                6.775934f, 9.863029f, 6.794580f, 9.779489f, 6.679326f, 9.765074f, 6.678363f, 9.752025f, 7.262135f, 9.752025f,
                7.262135f, 10.792799f
            )
            poly[1090] = TzPolygon(
                6.961340f, 10.792799f, 6.962513f, 10.798557f, 6.938316f, 10.838056f, 6.843813f, 10.816285f, 6.765916f, 10.910705f,
                6.709079f, 10.916363f, 6.686980f, 10.993142f, 6.715366f, 11.058039f, 6.681522f, 11.094994f, 6.519909f, 11.097762f,
                6.530142f, 11.137562f, 6.500027f, 11.166624f, 6.512510f, 11.199987f, 6.537612f, 11.197759f, 6.522515f, 11.244520f,
                6.538093f, 11.279235f, 6.500974f, 11.350948f, 6.525443f, 11.356522f, 6.530666f, 11.427773f, 6.598138f, 11.417225f,
                6.599502f, 11.495781f, 6.666728f, 11.553998f, 6.714879f, 11.549956f, 6.733910f, 11.583761f, 6.772828f, 11.569381f,
                6.801428f, 11.595218f, 6.858308f, 11.553336f, 6.901504f, 11.572708f, 6.913591f, 11.606916f, 6.976628f, 11.617487f,
                6.986411f, 11.657511f, 7.047452f, 11.720643f, 7.043025f, 11.774665f, 7.082654f, 11.802519f, 7.080694f, 11.833573f,
                5.392003f, 11.833573f, 5.392003f, 10.792799f
            )
            poly[1091] = TzPolygon(12.872529f, 8.857666f, 12.872529f, 9.712705f, 12.807702f, 9.658716f, 12.807406f, 9.627707f, 12.833601f, 8.977927f)
            poly[1092] = TzPolygon(
                9.132266f, 11.833573f, 9.132266f, 12.897334f, 9.114237f, 12.900960f, 8.919688f, 12.806853f, 8.895645f, 12.818943f,
                8.853946f, 12.800164f, 8.830412f, 12.818942f, 8.745363f, 12.783955f, 8.763102f, 12.720653f, 8.672170f, 12.699898f,
                8.647671f, 12.675707f, 8.648905f, 12.635005f, 8.613785f, 12.575230f, 8.642280f, 12.499621f, 8.620357f, 12.431400f,
                8.544533f, 12.460957f, 8.516146f, 12.446462f, 8.460055f, 12.342126f, 8.430319f, 12.339498f, 8.442073f, 12.259808f,
                8.386559f, 12.243795f, 8.176364f, 12.255934f, 8.097617f, 12.191072f, 7.983271f, 12.214077f, 7.862205f, 12.136106f,
                7.847747f, 12.098059f, 7.735655f, 12.052252f, 7.678969f, 11.999189f, 7.527851f, 12.025096f, 7.478078f, 11.922775f,
                7.393844f, 11.928063f, 7.363311f, 11.883103f, 7.324387f, 11.885816f, 7.269983f, 11.841774f, 7.248357f, 11.880266f,
                7.194597f, 11.855711f, 7.098824f, 11.879740f, 7.071407f, 11.833573f
            )
            poly[1093] = TzPolygon(
                5.392003f, 14.574987f, 5.511907f, 14.629866f, 5.595424f, 14.589785f, 5.710856f, 14.626472f, 5.891273f, 14.618941f,
                5.923172f, 14.599201f, 5.904722f, 14.555833f, 5.920000f, 14.485000f, 6.044679f, 14.415543f, 6.088333f, 14.430000f,
                6.133611f, 14.510000f, 6.193333f, 14.552778f, 6.188889f, 14.580278f, 6.262500f, 14.740278f, 6.340000f, 14.800278f,
                6.390000f, 14.796944f, 6.673611f, 14.932778f, 6.726624f, 14.939015f, 6.756555f, 14.966209f, 6.769601f, 15.055165f,
                6.948624f, 15.139125f, 7.058611f, 15.158333f, 7.115195f, 15.219132f, 7.176829f, 15.206056f, 7.215704f, 15.233621f,
                7.223850f, 15.211156f, 7.241321f, 15.217339f, 7.262135f, 15.241665f, 7.262135f, 15.996667f, 5.392003f, 15.996667f
            )
            poly[1094] = TzPolygon(
                7.262135f, 15.241665f, 7.414492f, 15.419732f, 7.525485f, 15.493321f, 7.519130f, 15.727950f, 7.478530f, 15.742970f,
                7.441070f, 15.809590f, 7.483339f, 15.974811f, 7.500521f, 15.996667f, 7.262135f, 15.996667f
            )
            poly[1095] = TzPolygon(
                9.132266f, 14.441619f, 9.114894f, 14.464023f, 9.059154f, 14.489444f, 8.811848f, 14.843792f, 8.814041f, 14.899255f,
                8.779671f, 14.922836f, 8.763601f, 14.908265f, 8.728469f, 14.989221f, 8.687992f, 14.983649f, 8.659348f, 15.109015f,
                8.512252f, 15.200064f, 8.098412f, 15.393138f, 7.885290f, 15.451778f, 7.792022f, 15.506378f, 7.766291f, 15.591449f,
                7.585324f, 15.561727f, 7.528937f, 15.493325f, 7.414492f, 15.419732f, 7.262135f, 15.241665f, 7.262135f, 13.915120f,
                9.132266f, 13.915120f
            )
            poly[1096] = TzPolygon(
                9.132266f, 12.897334f, 9.178547f, 12.888026f, 9.248589f, 12.917292f, 9.340568f, 12.923826f, 9.371875f, 12.847290f,
                9.414867f, 12.939542f, 9.469123f, 12.975024f, 9.506595f, 13.034673f, 9.555099f, 13.206878f, 9.582523f, 13.227062f,
                9.773330f, 13.259469f, 9.826484f, 13.302024f, 9.863463f, 13.243296f, 9.910132f, 13.236293f, 9.938369f, 13.281755f,
                9.978647f, 13.288065f, 10.002772f, 13.247932f, 10.034623f, 13.246873f, 10.045860f, 13.286351f, 10.085838f, 13.298107f,
                10.116573f, 13.343751f, 10.121517f, 13.412199f, 10.160753f, 13.469917f, 10.196203f, 13.483587f, 10.245853f, 13.465860f,
                10.295020f, 13.490873f, 10.328753f, 13.478605f, 10.334112f, 13.499960f, 10.389463f, 13.496671f, 10.419140f, 13.537292f,
                10.468472f, 13.530610f, 10.536793f, 13.578637f, 10.612438f, 13.547220f, 10.634822f, 13.574636f, 10.697766f, 13.588319f,
                10.711472f, 13.626691f, 10.812922f, 13.650513f, 10.863064f, 13.716762f, 10.923746f, 13.730187f, 10.959892f, 13.710398f,
                10.999965f, 13.731405f, 11.004299f, 13.792378f, 11.066188f, 13.815846f, 11.094977f, 13.859888f, 11.150800f, 13.879275f,
                11.187068f, 13.915120f, 9.132266f, 13.915120f
            )
            poly[1097] = TzPolygon(
                9.132266f, 14.441619f, 9.204332f, 14.348681f, 9.294147f, 14.373162f, 9.309876f, 14.339203f, 9.371684f, 14.304327f,
                9.358180f, 14.268520f, 9.502368f, 14.149818f, 9.517937f, 14.104302f, 9.610980f, 14.038050f, 9.637937f, 13.976605f,
                9.727969f, 14.022445f, 9.820074f, 14.130979f, 10.002114f, 14.206609f, 10.002224f, 14.463358f, 9.935219f, 14.802421f,
                9.982890f, 14.957853f, 9.945692f, 15.059965f, 9.994282f, 15.148312f, 9.989541f, 15.248100f, 9.933482f, 15.413858f,
                9.998714f, 15.688998f, 10.117960f, 15.483668f, 10.244172f, 15.397837f, 10.310357f, 15.304571f, 10.474839f, 15.238535f,
                10.541677f, 15.144980f, 10.621998f, 15.160086f, 10.820320f, 15.067565f, 10.881547f, 15.094511f, 11.002398f, 15.053040f,
                11.002398f, 15.996667f, 9.132266f, 15.996667f
            )
            poly[1098] = TzPolygon(
                11.937464f, 13.915120f, 11.937464f, 14.642571f, 11.869472f, 14.604655f, 11.782511f, 14.615356f, 11.718842f, 14.549128f,
                11.649917f, 14.643853f, 11.574781f, 14.647602f, 11.510238f, 14.617906f, 11.421061f, 14.430362f, 11.240847f, 14.186293f,
                11.311753f, 13.977175f, 11.206429f, 13.934255f, 11.187068f, 13.915120f
            )
            poly[1099] = TzPolygon(
                12.872529f, 14.129703f, 12.538171f, 14.203251f, 12.478988f, 14.176189f, 12.434710f, 14.194740f, 12.410956f, 14.173377f,
                12.362419f, 14.228334f, 12.374688f, 14.326942f, 12.352536f, 14.483277f, 12.326788f, 14.520511f, 12.297068f, 14.511118f,
                12.280388f, 14.547769f, 12.236301f, 14.549615f, 12.227800f, 14.594134f, 12.186001f, 14.613523f, 12.197994f, 14.659307f,
                12.164143f, 14.678014f, 12.092649f, 14.635911f, 12.063839f, 14.653380f, 12.042301f, 14.622308f, 11.962279f, 14.656409f,
                11.937464f, 14.642571f, 11.937464f, 13.915120f, 12.872529f, 13.915120f
            )
        }
    }

    private object Initializer12 {
        fun init() {
            poly[1100] = TzPolygon(
                12.108895f, 14.955893f, 12.165188f, 14.885277f, 12.188180f, 14.911397f, 12.205951f, 14.892183f, 12.383802f, 14.908468f,
                12.463374f, 14.877822f, 12.467729f, 14.843142f, 12.574331f, 14.854745f, 12.633501f, 14.832524f, 12.634693f, 14.772210f,
                12.688671f, 14.745712f, 12.658877f, 14.711764f, 12.722204f, 14.717992f, 12.743415f, 14.616064f, 12.774572f, 14.618811f,
                12.745520f, 14.591111f, 12.783724f, 14.573843f, 12.775860f, 14.555749f, 12.865906f, 14.554379f, 12.872529f, 14.559758f,
                12.872529f, 14.955893f
            )
            poly[1101] = TzPolygon(
                11.002398f, 15.053040f, 11.025200f, 15.045215f, 11.033038f, 15.092464f, 11.088129f, 15.110660f, 11.280581f, 15.048508f,
                11.326734f, 15.073925f, 11.345467f, 15.049283f, 11.365960f, 15.069070f, 11.416938f, 15.059849f, 11.514010f, 15.133320f,
                11.562332f, 15.144898f, 11.587894f, 15.099923f, 11.710911f, 15.064483f, 11.734611f, 15.077358f, 11.731081f, 15.105510f,
                11.765870f, 15.080105f, 11.790909f, 15.122848f, 11.854471f, 15.089623f, 11.857109f, 15.050750f, 11.973675f, 15.050064f,
                11.995740f, 15.085848f, 12.031449f, 15.038651f, 12.057046f, 15.060650f, 12.104072f, 15.037780f, 12.121321f, 15.001408f,
                12.088095f, 14.981985f, 12.108895f, 14.955893f, 12.872529f, 14.955893f, 12.872529f, 15.996667f, 11.002398f, 15.996667f
            )
            poly[1102] = TzPolygon(
                12.872529f, 8.857666f, 12.936997f, 8.658508f, 13.023335f, 8.596764f, 13.074238f, 8.502157f, 13.057199f, 8.416249f,
                13.213942f, 8.249476f, 13.313778f, 8.069222f, 13.341374f, 7.845216f, 13.320420f, 7.774361f, 13.256671f, 7.670478f,
                20.353056f, 7.670478f, 20.353056f, 11.833573f, 13.266334f, 11.833573f, 13.299044f, 11.678427f, 13.346314f, 11.590626f,
                13.380613f, 11.459247f, 13.360672f, 10.656115f, 13.287472f, 10.465271f, 13.270741f, 10.204041f, 13.182376f, 10.011259f,
                13.026595f, 9.841013f, 12.872529f, 9.712705f
            )
            poly[1103] = TzPolygon(
                14.742661f, 12.874346f, 13.500102f, 12.874346f, 13.501053f, 12.871266f, 13.471930f, 12.873402f, 13.476459f, 12.841881f,
                13.440602f, 12.856693f, 13.455282f, 12.835728f, 13.431113f, 12.810600f, 13.402989f, 12.826825f, 13.397517f, 12.782875f,
                13.377112f, 12.792195f, 13.390376f, 12.765511f, 13.326418f, 12.740238f, 13.323252f, 12.709009f, 13.307471f, 12.717431f,
                13.320418f, 12.682299f, 13.275766f, 12.676639f, 13.305766f, 12.644522f, 13.277885f, 12.624021f, 13.283978f, 12.578423f,
                13.268640f, 12.590726f, 13.275445f, 12.577134f, 13.204120f, 12.549516f, 13.198862f, 12.559946f, 13.159584f, 12.550410f,
                13.141504f, 12.538355f, 13.144522f, 12.501728f, 13.055230f, 12.473627f, 13.075263f, 12.449013f, 13.075004f, 12.369504f,
                13.091239f, 12.368913f, 13.071876f, 12.333579f, 13.100217f, 12.295619f, 13.081305f, 12.273966f, 13.114150f, 12.263885f,
                13.106254f, 12.233064f, 13.130334f, 12.199911f, 13.098112f, 12.163721f, 13.114881f, 12.106231f, 13.140983f, 12.038438f,
                13.255907f, 11.883026f, 13.266334f, 11.833573f, 14.742661f, 11.833573f
            )
            poly[1104] = TzPolygon(
                13.500102f, 12.874346f, 13.486962f, 12.916921f, 13.499885f, 12.957689f, 13.521333f, 12.955773f, 13.509280f, 13.002347f,
                13.536645f, 13.021981f, 13.521190f, 13.043633f, 13.543736f, 13.041561f, 13.550016f, 13.063124f, 13.527431f, 13.061055f,
                13.516082f, 13.088528f, 13.539862f, 13.104157f, 13.521731f, 13.125212f, 13.541240f, 13.122518f, 13.550505f, 13.146734f,
                13.517627f, 13.140516f, 13.537532f, 13.181114f, 13.513373f, 13.197761f, 13.549107f, 13.206669f, 13.564915f, 13.239600f,
                13.589331f, 13.226536f, 13.595284f, 13.262657f, 13.616308f, 13.243326f, 13.696249f, 13.309275f, 13.693536f, 13.335389f,
                13.721310f, 13.338365f, 13.708160f, 13.633381f, 13.316923f, 13.915120f, 12.872529f, 13.915120f, 12.872529f, 12.874346f
            )
            poly[1105] = TzPolygon(
                13.316923f, 13.915120f, 13.708160f, 13.633381f, 14.442820f, 13.473480f, 14.477850f, 13.499750f, 14.510480f, 13.633160f,
                14.551120f, 13.696020f, 14.636560f, 13.677310f, 14.698340f, 13.745570f, 14.691970f, 13.768730f, 14.721730f, 13.809960f,
                14.742661f, 13.806960f, 14.742661f, 13.915120f
            )
            poly[1106] = TzPolygon(14.742661f, 13.915120f, 14.742661f, 13.806960f, 14.863210f, 13.789680f, 15.031340f, 13.862210f, 15.102238f, 13.915120f)
            poly[1107] = TzPolygon(12.872529f, 14.129703f, 13.083333f, 14.083333f, 13.083333f, 14.466666f, 12.887574f, 14.571977f, 12.872529f, 14.559758f)
            poly[1108] = TzPolygon(13.316923f, 13.915120f, 13.083333f, 14.083333f, 12.872529f, 14.129703f, 12.872529f, 13.915120f)
            poly[1109] = TzPolygon(16.612793f, 15.231601f, 15.731550f, 14.384760f, 15.102238f, 13.915120f, 16.612793f, 13.915120f)
            poly[1110] = TzPolygon(
                16.612793f, 15.231601f, 16.897870f, 15.505550f, 18.782222f, 15.602500f, 19.932500f, 15.753889f, 20.353056f, 15.996667f,
                16.612793f, 15.996667f
            )
            poly[1111] = TzPolygon(20.970852f, 7.670478f, 21.778590f, 8.996974f, 23.422283f, 11.833573f, 20.353056f, 11.833573f, 20.353056f, 7.670478f)
            poly[1112] = TzPolygon(
                23.828622f, 11.833573f, 24.264727f, 11.604258f, 24.200501f, 11.422523f, 24.392829f, 11.135854f, 24.429783f, 11.044819f,
                24.532734f, 10.949659f, 24.568887f, 10.847256f, 24.564018f, 10.815651f, 24.510391f, 10.766643f, 24.573067f, 10.706074f,
                24.573582f, 10.614730f, 24.541327f, 10.588023f, 24.533881f, 10.545496f, 24.536972f, 10.356677f, 24.599078f, 10.302570f,
                24.650641f, 10.216372f, 24.965634f, 10.037772f, 25.359573f, 10.032093f, 26.195638f, 9.398983f, 26.253330f, 9.455908f,
                26.385101f, 9.512373f, 26.519911f, 9.863299f, 26.646871f, 9.913332f, 26.743180f, 9.902106f, 26.861947f, 9.925362f,
                26.953616f, 9.858083f, 27.256579f, 9.782495f, 27.353630f, 9.783926f, 27.433543f, 9.805519f, 27.433543f, 11.833573f
            )
            poly[1113] = TzPolygon(23.828622f, 11.833573f, 23.517178f, 11.997337f, 23.422283f, 11.833573f)
            poly[1114] = TzPolygon(
                20.353056f, 15.996667f, 20.698889f, 15.673889f, 20.766389f, 15.575833f, 20.884444f, 15.558333f, 20.955278f, 15.627222f,
                21.445278f, 15.284444f, 21.495833f, 15.202500f, 21.998889f, 15.194722f, 23.001239f, 14.998583f, 23.497371f, 15.996667f
            )
            poly[1115] = TzPolygon(
                23.828622f, 11.833573f, 27.433543f, 11.833573f, 27.433543f, 15.996667f, 23.497371f, 15.996667f, 22.613611f, 14.234444f,
                23.168333f, 13.543611f, 23.215556f, 13.410833f, 23.517178f, 11.997337f
            )
            poly[1116] = TzPolygon(
                8.196696f, 17.428843f, 7.871860f, 17.428843f, 7.872390f, 17.399310f, 7.847384f, 17.399210f, 7.856193f, 17.359944f,
                7.826176f, 17.325839f, 7.830490f, 17.295906f, 7.787300f, 17.255291f, 7.752918f, 17.257767f, 7.771177f, 17.223295f,
                7.721758f, 17.201063f, 7.717761f, 17.164024f, 7.670348f, 17.154111f, 7.666109f, 17.121943f, 7.701544f, 17.091505f,
                7.665428f, 17.088388f, 7.658034f, 17.039254f, 7.638880f, 17.035257f, 7.645338f, 16.951193f, 7.609884f, 16.922152f,
                7.620523f, 16.891936f, 7.578910f, 16.886372f, 7.564847f, 16.906428f, 7.561649f, 16.864086f, 7.532831f, 16.837546f,
                7.535694f, 16.809306f, 7.607618f, 16.775954f, 7.639447f, 16.729439f, 7.639546f, 16.684413f, 7.672196f, 16.659600f,
                7.745498f, 16.659909f, 7.774003f, 16.589580f, 7.886645f, 16.591143f, 7.848101f, 16.507650f, 7.790056f, 16.480002f,
                7.787367f, 16.450047f, 7.810242f, 16.432012f, 7.772697f, 16.406016f, 7.715739f, 16.423436f, 7.673210f, 16.384469f,
                7.654743f, 16.295848f, 7.605841f, 16.229791f, 7.614450f, 16.185530f, 7.581909f, 16.066141f, 7.498369f, 15.996667f,
                8.196696f, 15.996667f
            )
            poly[1117] = TzPolygon(
                8.196696f, 18.660934f, 8.194950f, 18.657700f, 8.141190f, 18.628100f, 8.091000f, 18.637050f, 8.052470f, 18.618050f,
                8.009300f, 18.031980f, 7.958610f, 17.921640f, 7.984014f, 17.662215f, 7.945253f, 17.644019f, 7.914910f, 17.563048f,
                7.924120f, 17.533484f, 7.890689f, 17.534868f, 7.872443f, 17.510592f, 7.902096f, 17.461242f, 7.871643f, 17.440967f,
                7.871860f, 17.428843f, 8.196696f, 17.428843f
            )
            poly[1118] = TzPolygon(8.196696f, 18.660934f, 8.289884f, 18.833527f, 8.346026f, 18.848777f, 8.343372f, 18.861019f, 8.196696f, 18.861019f)
            poly[1119] = TzPolygon(
                9.599042f, 19.577107f, 9.035327f, 19.577107f, 9.038653f, 19.560755f, 9.022368f, 19.543786f, 9.040073f, 19.526625f,
                9.019148f, 19.516080f, 9.011778f, 19.479589f, 9.032396f, 19.477734f, 9.007540f, 19.449899f, 9.026554f, 19.443288f,
                9.014694f, 19.390372f, 9.029549f, 19.362199f, 9.012272f, 19.281901f, 9.039143f, 19.219673f, 9.009328f, 19.147155f,
                9.024510f, 19.123737f, 9.006632f, 19.111094f, 9.013097f, 19.052166f, 8.983164f, 19.038248f, 8.972527f, 18.985415f,
                8.940589f, 18.978186f, 8.960803f, 18.956111f, 8.936769f, 18.958238f, 8.880710f, 18.863265f, 8.853199f, 18.863444f,
                8.854292f, 18.902808f, 8.810247f, 18.909474f, 8.810550f, 18.948868f, 8.671659f, 19.124031f, 8.637380f, 19.065840f,
                8.528049f, 19.034826f, 8.516090f, 18.988724f, 8.491714f, 18.992302f, 8.425128f, 18.920336f, 8.387347f, 18.919241f,
                8.341654f, 18.868943f, 8.343372f, 18.861019f, 9.599042f, 18.861019f
            )
            poly[1120] = TzPolygon(
                9.114794f, 20.293195f, 9.139722f, 20.207222f, 9.111944f, 20.141667f, 9.151111f, 20.104722f, 9.127500f, 20.098611f,
                9.134444f, 20.061944f, 9.114444f, 20.033611f, 9.088611f, 20.029167f, 9.106667f, 20.003889f, 9.080000f, 19.988333f,
                9.062500f, 19.909167f, 9.041944f, 19.894722f, 9.047778f, 19.786389f, 9.013611f, 19.683889f, 9.035327f, 19.577107f,
                9.599042f, 19.577107f, 9.599042f, 20.293195f
            )
            poly[1121] = TzPolygon(
                10.641815f, 21.725372f, 10.639444f, 21.719444f, 10.514444f, 21.701389f, 10.458725f, 21.725372f, 10.325926f, 21.725372f,
                10.290556f, 21.715556f, 10.284722f, 21.687778f, 10.238889f, 21.670833f, 10.223056f, 21.638889f, 10.206389f, 21.526944f,
                10.116389f, 21.455278f, 10.045833f, 21.438333f, 9.973889f, 21.371944f, 9.958333f, 21.336111f, 9.973611f, 21.256389f,
                9.883611f, 21.191944f, 9.842778f, 21.130000f, 9.772500f, 21.103056f, 9.752778f, 21.068333f, 9.766667f, 21.042500f,
                9.738611f, 21.015000f, 9.633611f, 20.997222f, 9.628056f, 20.975833f, 9.606111f, 20.985000f, 9.605556f, 20.956389f,
                9.476478f, 20.835708f, 9.415833f, 20.822222f, 9.405556f, 20.774722f, 9.376944f, 20.759722f, 9.359722f, 20.677778f,
                9.338333f, 20.656944f, 9.296389f, 20.662778f, 9.321667f, 20.541389f, 9.281667f, 20.528611f, 9.271944f, 20.496389f,
                9.208889f, 20.515000f, 9.207778f, 20.482778f, 9.138889f, 20.438889f, 9.104444f, 20.328889f, 9.114794f, 20.293195f,
                11.001389f, 20.293195f, 11.001389f, 21.725372f
            )
            poly[1122] = TzPolygon(
                10.594385f, 23.157548f, 10.613611f, 23.136389f, 10.695278f, 23.013056f, 10.899722f, 22.880556f, 11.001389f, 22.911494f,
                11.001389f, 23.157548f
            )
            poly[1123] = TzPolygon(
                11.001389f, 22.904930f, 10.920556f, 22.877778f, 11.000278f, 22.460556f, 10.957778f, 22.406389f, 10.941667f, 22.322778f,
                10.904722f, 22.276667f, 10.910833f, 22.244722f, 10.815833f, 22.180833f, 10.830556f, 22.047500f, 10.799167f, 22.009444f,
                10.728889f, 21.995833f, 10.713889f, 21.907500f, 10.666667f, 21.857500f, 10.678333f, 21.816667f, 10.641815f, 21.725372f,
                11.001389f, 21.725372f
            )
            poly[1124] = TzPolygon(10.458725f, 21.725372f, 10.406667f, 21.747778f, 10.325926f, 21.725372f)
            poly[1125] = TzPolygon(
                8.718677f, 23.873636f, 8.728056f, 23.824167f, 8.705000f, 23.733889f, 8.737500f, 23.633889f, 8.708611f, 23.526389f,
                8.772778f, 23.497500f, 8.901389f, 23.580278f, 8.994722f, 23.582778f, 9.004722f, 23.559722f, 8.960556f, 23.533611f,
                8.959722f, 23.504167f, 9.019444f, 23.447778f, 9.174167f, 23.493333f, 9.184444f, 23.561111f, 9.280000f, 23.652500f,
                9.339722f, 23.639444f, 9.435833f, 23.666111f, 9.445000f, 23.633889f, 9.535278f, 23.623611f, 9.599042f, 23.657601f,
                9.599042f, 23.873636f
            )
            poly[1126] = TzPolygon(
                8.721067f, 23.873636f, 8.728056f, 23.824167f, 8.705000f, 23.733889f, 8.737500f, 23.633889f, 8.705000f, 23.558333f,
                8.717778f, 23.514444f, 8.796389f, 23.502778f, 8.901389f, 23.580278f, 8.994722f, 23.582778f, 9.004722f, 23.559722f,
                8.960556f, 23.533611f, 8.959722f, 23.504167f, 9.019444f, 23.447778f, 9.174167f, 23.493333f, 9.184444f, 23.561111f,
                9.280000f, 23.652500f, 9.339722f, 23.639444f, 9.435833f, 23.666111f, 9.445000f, 23.633889f, 9.535278f, 23.623611f,
                9.599042f, 23.657601f, 9.599042f, 23.873636f
            )
            poly[1127] = TzPolygon(
                8.721067f, 23.873636f, 8.685278f, 24.126944f, 8.694167f, 24.249722f, 8.630278f, 24.228889f, 8.583333f, 24.269167f,
                8.473889f, 24.163333f, 8.382500f, 24.141944f, 8.316667f, 24.177222f, 8.247500f, 24.356667f, 8.273333f, 24.396111f,
                8.271667f, 24.466389f, 8.234722f, 24.483056f, 8.205556f, 24.539167f, 8.211225f, 24.589724f, 8.196696f, 24.589724f,
                8.196696f, 23.873636f
            )
            poly[1128] = TzPolygon(
                8.718677f, 23.873636f, 9.599042f, 23.873636f, 9.599042f, 24.589724f, 8.211225f, 24.589724f, 8.205556f, 24.539167f,
                8.234722f, 24.483056f, 8.271667f, 24.466389f, 8.273333f, 24.396111f, 8.247500f, 24.356667f, 8.316667f, 24.177222f,
                8.382500f, 24.141944f, 8.473889f, 24.163333f, 8.583333f, 24.269167f, 8.630278f, 24.228889f, 8.691111f, 24.253611f,
                8.696667f, 23.989722f
            )
            poly[1129] = TzPolygon(
                10.594385f, 23.157548f, 10.458889f, 23.306667f, 9.867222f, 23.669722f, 9.671553f, 23.696254f, 9.599042f, 23.657601f,
                9.599042f, 23.157548f
            )
            poly[1130] = TzPolygon(
                9.599042f, 23.657601f, 9.671553f, 23.696254f, 9.867222f, 23.669722f, 10.458889f, 23.306667f, 10.594385f, 23.157548f,
                11.001389f, 23.157548f, 11.001389f, 24.589724f, 9.599042f, 24.589724f
            )
            poly[1131] = TzPolygon(
                6.991519f, 26.021900f, 7.010556f, 25.973611f, 7.085278f, 25.920556f, 7.111111f, 25.825833f, 7.168333f, 25.764722f,
                7.175000f, 25.688333f, 7.251944f, 25.567222f, 7.262500f, 25.477222f, 7.348056f, 25.364167f, 7.417500f, 25.352778f,
                7.470556f, 25.294444f, 7.465556f, 25.254722f, 7.494722f, 25.209444f, 7.595000f, 25.210278f, 7.680278f, 25.292500f,
                7.792500f, 25.278333f, 7.882222f, 25.203889f, 7.908056f, 25.151667f, 7.893056f, 25.090000f, 7.972500f, 24.971111f,
                8.038056f, 24.905278f, 8.174167f, 24.856111f, 8.196696f, 24.758207f, 8.196696f, 26.021900f
            )
            poly[1132] = TzPolygon(
                6.991519f, 26.021900f, 6.987778f, 26.031389f, 6.910278f, 26.066944f, 6.706944f, 26.283333f, 6.651944f, 26.425000f,
                6.621111f, 26.422500f, 6.570556f, 26.344722f, 6.517778f, 26.364722f, 6.466389f, 26.323333f, 6.362500f, 26.330833f,
                6.314167f, 26.404444f, 6.280000f, 26.417500f, 6.283889f, 26.485833f, 6.219722f, 26.529444f, 6.202222f, 26.579167f,
                6.153056f, 26.582778f, 6.079167f, 26.504444f, 6.062500f, 26.528333f, 6.077222f, 26.584167f, 5.987222f, 26.669722f,
                5.998889f, 26.761389f, 5.980000f, 26.830556f, 5.888889f, 26.920000f, 5.720833f, 27.206667f, 5.671944f, 27.232222f,
                5.615278f, 27.231389f, 5.555278f, 27.293056f, 5.406492f, 27.232098f, 5.392003f, 27.236097f, 5.392003f, 26.021900f
            )
            poly[1133] = TzPolygon(8.211225f, 24.589724f, 8.219167f, 24.660556f, 8.196696f, 24.758207f, 8.196696f, 24.589724f)
            poly[1134] = TzPolygon(
                8.196696f, 24.758207f, 8.219167f, 24.660556f, 8.211225f, 24.589724f, 9.599042f, 24.589724f, 9.599042f, 26.021900f,
                8.196696f, 26.021900f
            )
            poly[1135] = TzPolygon(
                11.001389f, 25.305812f, 10.355954f, 25.305812f, 10.360057f, 25.275473f, 10.332984f, 25.272514f, 10.359672f, 25.214983f,
                10.318433f, 25.181587f, 10.336449f, 25.144401f, 10.303965f, 25.123346f, 10.307512f, 25.086956f, 10.222866f, 25.048342f,
                10.179928f, 25.055585f, 10.166050f, 25.030793f, 10.113918f, 25.078897f, 10.084626f, 25.076987f, 10.083589f, 25.048914f,
                10.059282f, 25.055414f, 10.054266f, 25.030842f, 10.016881f, 25.047342f, 10.003560f, 25.012913f, 9.969010f, 25.017553f,
                9.959784f, 24.985968f, 9.896904f, 24.980091f, 9.897057f, 24.948369f, 9.871570f, 24.942305f, 9.860802f, 24.902104f,
                9.750510f, 24.788290f, 9.729021f, 24.740164f, 9.599042f, 24.750891f, 9.599042f, 24.589724f, 11.001389f, 24.589724f
            )
            poly[1136] = TzPolygon(
                10.133072f, 26.021900f, 10.179166f, 25.932219f, 10.385162f, 25.930038f, 10.378085f, 25.898870f, 10.411327f, 25.894338f,
                10.391457f, 25.861776f, 10.423889f, 25.838226f, 10.419332f, 25.762328f, 10.439004f, 25.760609f, 10.402683f, 25.691025f,
                10.432663f, 25.662943f, 10.398912f, 25.644014f, 10.406194f, 25.582218f, 10.389111f, 25.573828f, 10.407379f, 25.553143f,
                10.385433f, 25.537337f, 10.395290f, 25.505652f, 10.374544f, 25.498478f, 10.390761f, 25.473263f, 10.372796f, 25.472063f,
                10.396475f, 25.442882f, 10.373087f, 25.396210f, 10.389988f, 25.389097f, 10.371142f, 25.375661f, 10.378903f, 25.339205f,
                10.353653f, 25.322831f, 10.355954f, 25.305812f, 11.001389f, 25.305812f, 11.001389f, 26.021900f
            )
            poly[1137] = TzPolygon(
                9.620707f, 27.454076f, 9.626374f, 27.142360f, 9.488887f, 26.702774f, 9.564064f, 26.393915f, 9.594234f, 26.345882f,
                9.645273f, 26.308283f, 9.916673f, 26.213893f, 10.000001f, 26.116668f, 10.124876f, 26.037846f, 10.133072f, 26.021900f,
                11.001389f, 26.021900f, 11.001389f, 27.454076f
            )
            poly[1138] = TzPolygon(
                11.001389f, 22.911494f, 11.209167f, 22.974722f, 11.415833f, 22.930833f, 11.401667f, 22.791111f, 11.462222f, 22.775556f,
                11.516111f, 22.641944f, 11.621667f, 22.561667f, 11.799167f, 22.572778f, 12.071111f, 22.640833f, 12.030101f, 22.477804f,
                12.176944f, 22.501389f, 12.403333f, 22.432778f, 12.465278f, 22.383889f, 12.621667f, 22.466944f, 12.670278f, 22.335000f,
                12.747222f, 22.223333f, 12.655278f, 22.140556f, 12.643889f, 21.952778f, 12.684722f, 21.893889f, 12.733131f, 21.858107f,
                12.771974f, 21.857763f, 12.806459f, 21.814505f, 13.055408f, 21.954459f, 13.055408f, 24.589724f, 11.001389f, 24.589724f
            )
            poly[1139] = TzPolygon(
                15.109428f, 22.936916f, 15.102479f, 22.937319f, 15.088648f, 22.882233f, 15.034433f, 22.812730f, 14.967999f, 22.750530f,
                14.907796f, 22.760227f, 14.863490f, 22.667249f, 14.691389f, 22.702500f, 14.629444f, 22.470000f, 14.592222f, 22.403333f,
                14.554167f, 22.384167f, 14.523056f, 22.381389f, 14.479722f, 22.445556f, 14.384167f, 22.447500f, 14.344722f, 22.469722f,
                14.315000f, 22.436111f, 14.272222f, 22.443889f, 14.247222f, 22.466389f, 14.231944f, 22.555278f, 14.125556f, 22.555000f,
                14.106389f, 22.485278f, 14.051667f, 22.434444f, 14.052222f, 22.396667f, 13.965833f, 22.233889f, 13.779167f, 22.084444f,
                13.728056f, 22.138611f, 13.669722f, 22.133889f, 13.634444f, 22.153611f, 13.571944f, 22.224722f, 13.478889f, 22.230556f,
                13.358611f, 22.294167f, 13.190278f, 22.159722f, 13.142778f, 22.029444f, 13.087500f, 21.972500f, 13.055408f, 21.956401f,
                13.055408f, 21.725372f, 15.109428f, 21.725372f
            )
            poly[1140] = TzPolygon(
                19.217466f, 23.999543f, 15.697254f, 23.999641f, 15.774693f, 23.663636f, 15.768415f, 23.551884f, 15.697697f, 23.396874f,
                15.717857f, 23.126851f, 15.591077f, 22.997590f, 15.554275f, 22.929672f, 15.482553f, 22.919383f, 15.414963f, 22.988171f,
                15.311621f, 23.004799f, 15.259460f, 22.985058f, 15.231305f, 23.005143f, 15.166578f, 22.933598f, 15.109428f, 22.936916f,
                15.109428f, 21.725372f, 19.217466f, 21.725372f
            )
            poly[1141] = TzPolygon(27.433543f, 27.454076f, 22.000000f, 27.454076f, 22.000000f, 25.000000f, 27.433543f, 24.998334f)
            poly[1142] = TzPolygon(
                19.217466f, 24.000616f, 20.001944f, 24.000833f, 19.999167f, 25.000833f, 22.000000f, 25.000000f, 22.000000f, 27.454076f,
                19.217466f, 27.454076f
            )
            poly[1143] = TzPolygon(
                23.497371f, 15.996667f, 22.562778f, 18.004444f, 21.673611f, 19.826111f, 20.619722f, 21.896111f, 19.500814f, 23.999535f,
                19.217466f, 23.999543f, 19.217466f, 15.996667f
            )
            poly[1144] = TzPolygon(
                -4.112279f, 29.379876f, -3.985271f, 29.313032f, -3.928044f, 29.243925f, -3.858320f, 29.227256f, -3.584886f, 29.250747f,
                -3.322590f, 29.214115f, -3.322590f, 29.379876f
            )
            poly[1145] = TzPolygon(-5.028596f, 29.379876f, -4.995578f, 29.363195f, -4.699707f, 29.326977f, -4.578010f, 29.379876f)
            poly[1146] = TzPolygon(
                -2.409340f, 28.878862f, -2.409340f, 29.379876f, -2.834132f, 29.379876f, -2.839758f, 29.370886f, -2.747156f, 29.333782f,
                -2.702530f, 29.350521f, -2.688654f, 29.327791f, -2.652679f, 29.327224f, -2.618486f, 29.266554f, -2.631760f, 29.220960f,
                -2.595075f, 29.163321f, -2.610244f, 29.127862f, -2.592576f, 29.086228f, -2.623330f, 29.051049f, -2.709943f, 29.057169f,
                -2.743396f, 29.039626f, -2.699244f, 28.994903f, -2.703465f, 28.966964f, -2.660515f, 28.897305f, -2.568082f, 28.895374f,
                -2.525276f, 28.861755f, -2.490957f, 28.893016f, -2.436296f, 28.866510f
            )
            poly[1147] = TzPolygon(
                -2.409340f, 28.416976f, -2.409340f, 28.880369f, -2.428696f, 28.867002f, -2.475765f, 28.892144f, -2.529651f, 28.861809f,
                -2.568082f, 28.895374f, -2.660515f, 28.897305f, -2.733999f, 29.034795f, -2.760993f, 29.038286f, -2.784819f, 29.001089f,
                -2.815846f, 29.005655f, -2.820119f, 29.050933f, -2.875462f, 29.092674f, -2.920532f, 29.096731f, -2.950447f, 29.158236f,
                -2.996028f, 29.167614f, -3.025161f, 29.236978f, -3.067387f, 29.258052f, -3.114764f, 29.260937f, -3.197762f, 29.222627f,
                -3.270027f, 29.240806f, -3.303064f, 29.211388f, -3.322590f, 29.214115f, -3.322590f, 28.416976f
            )
            poly[1148] = TzPolygon(
                -2.409340f, 28.878862f, -2.386951f, 28.889122f, -2.373070f, 28.962045f, -2.293930f, 29.001112f, -2.275534f, 29.095659f,
                -2.252341f, 29.117627f, -2.120628f, 29.174799f, -1.931648f, 29.126828f, -1.861104f, 29.136053f, -1.698129f, 29.244817f,
                -1.629410f, 29.268322f, -1.599725f, 29.310350f, -1.508912f, 29.361813f, -1.508350f, 29.379876f, -2.409340f, 29.379876f
            )
            poly[1149] = TzPolygon(
                -3.322590f, 29.379876f, -3.322590f, 30.664527f, -3.360996f, 30.634596f, -3.398098f, 30.677622f, -3.432569f, 30.662382f,
                -3.559929f, 30.451401f, -3.606082f, 30.457081f, -3.624086f, 30.428390f, -3.714359f, 30.386374f, -3.784147f, 30.409578f,
                -3.784573f, 30.329062f, -3.845313f, 30.308103f, -3.883658f, 30.256327f, -3.940999f, 30.231141f, -4.041431f, 30.221396f,
                -4.045814f, 30.195813f, -4.114930f, 30.158410f, -4.168063f, 30.077929f, -4.276125f, 30.042391f, -4.280263f, 30.003528f,
                -4.380915f, 29.874090f, -4.363846f, 29.814266f, -4.469315f, 29.753756f, -4.446637f, 29.674503f, -4.449006f, 29.435951f,
                -4.249727f, 29.418817f, -4.116871f, 29.382293f, -4.112279f, 29.379876f
            )
            poly[1150] = TzPolygon(-4.112279f, 29.379876f, -4.116871f, 29.382293f, -4.249727f, 29.418817f, -4.445560f, 29.435926f, -4.576309f, 29.379876f)
            poly[1151] = TzPolygon(-5.028981f, 29.379876f, -5.115833f, 29.409722f, -5.149089f, 29.433419f, -5.149089f, 29.379876f)
            poly[1152] = TzPolygon(
                -2.834132f, 29.379876f, -2.797347f, 29.438653f, -2.829977f, 29.521640f, -2.786958f, 29.648746f, -2.819682f, 29.708294f,
                -2.811542f, 29.752950f, -2.764520f, 29.771721f, -2.755145f, 29.801004f, -2.779287f, 29.827833f, -2.759427f, 29.877688f,
                -2.702321f, 29.917858f, -2.641939f, 29.935610f, -2.557056f, 29.920363f, -2.461088f, 29.969950f, -2.370335f, 29.943237f,
                -2.329401f, 29.956090f, -2.347465f, 30.029594f, -2.421248f, 30.094664f, -2.437677f, 30.135094f, -2.428112f, 30.183680f,
                -2.349608f, 30.224453f, -2.372384f, 30.253044f, -2.371958f, 30.301163f, -2.360619f, 30.342776f, -3.322590f, 30.342776f,
                -3.322590f, 29.379876f
            )
            poly[1153] = TzPolygon(-1.496091f, 29.458373f, -1.506156f, 29.450326f, -1.508350f, 29.379876f, -1.496091f, 29.379876f)
            poly[1154] = TzPolygon(
                -2.409340f, 30.342776f, -2.409340f, 30.537875f, -2.413021f, 30.543608f, -2.662540f, 30.419781f, -2.691213f, 30.459301f,
                -2.653976f, 30.526463f, -2.680425f, 30.525230f, -2.745108f, 30.440433f, -2.793847f, 30.442371f, -2.860973f, 30.405949f,
                -2.954394f, 30.502341f, -2.894040f, 30.575670f, -2.993935f, 30.669629f, -2.971804f, 30.703977f, -2.997736f, 30.747555f,
                -2.979518f, 30.849846f, -3.052460f, 30.797595f, -3.094371f, 30.836367f, -3.146625f, 30.817753f, -3.163629f, 30.846193f,
                -3.206975f, 30.847516f, -3.224369f, 30.813241f, -3.253653f, 30.842551f, -3.292129f, 30.758680f, -3.267285f, 30.739660f,
                -3.303037f, 30.718979f, -3.320288f, 30.666321f, -3.322590f, 30.664527f, -3.322590f, 30.342776f
            )
            poly[1155] = TzPolygon(-2.409340f, 30.550759f, -2.409340f, 30.588030f, -2.419407f, 30.569539f)
            poly[1156] = TzPolygon(-2.409340f, 30.661620f, -2.413661f, 30.657208f, -2.409340f, 30.641658f)
            poly[1157] = TzPolygon(
                -2.360619f, 30.342776f, -2.352306f, 30.373286f, -2.309680f, 30.408709f, -2.328820f, 30.430343f, -2.320053f, 30.461492f,
                -2.366533f, 30.471191f, -2.409340f, 30.537875f, -2.409340f, 30.342776f
            )
            poly[1158] = TzPolygon(-2.409340f, 30.561390f, -2.399291f, 30.609942f, -2.409340f, 30.642560f)
            poly[1159] = TzPolygon(
                -2.409340f, 30.661437f, -2.355543f, 30.716561f, -2.390101f, 30.780120f, -2.313268f, 30.856968f, -2.205566f, 30.843626f,
                -2.077515f, 30.899074f, -1.938131f, 30.807827f, -1.814431f, 30.831774f, -1.692822f, 30.821364f, -1.650945f, 30.839878f,
                -1.523392f, 30.745101f, -1.496091f, 30.742638f, -1.496091f, 31.305676f, -2.409340f, 31.305676f
            )
            poly[1160] = TzPolygon(
                -1.496091f, 29.459616f, -1.388132f, 29.559257f, -1.383068f, 29.677643f, -1.340764f, 29.731662f, -1.373239f, 29.796858f,
                -1.308800f, 29.824562f, -1.360952f, 29.861491f, -1.355895f, 29.884447f, -1.423335f, 29.885540f, -1.482318f, 29.915771f,
                -1.447779f, 29.996117f, -1.412901f, 30.021784f, -1.431131f, 30.053745f, -1.378735f, 30.072770f, -1.384247f, 30.122450f,
                -1.345172f, 30.169930f, -1.274416f, 30.169669f, -1.276458f, 30.210858f, -1.189301f, 30.292356f, -1.145096f, 30.307049f,
                -1.132719f, 30.342776f, -1.496091f, 30.342776f
            )
            poly[1161] = TzPolygon(
                0.330408f, 29.379876f, 0.330408f, 29.859437f, 0.171769f, 29.823737f, 0.163856f, 29.769790f, 0.073335f, 29.716295f,
                -0.029610f, 29.745211f, -0.042682f, 29.729236f, -0.496528f, 29.682838f, -0.553532f, 29.653651f, -0.625480f, 29.663467f,
                -0.706251f, 29.626078f, -0.900530f, 29.638262f, -0.906885f, 29.581886f, -0.981221f, 29.602337f, -0.983058f, 29.586848f,
                -1.186269f, 29.573433f, -1.221608f, 29.608584f, -1.392979f, 29.590028f, -1.411051f, 29.526367f, -1.496091f, 29.458373f,
                -1.496091f, 29.379876f
            )
            poly[1162] = TzPolygon(
                -0.999996f, 31.305676f, -0.999995f, 30.799636f, -0.985512f, 30.765330f, -1.015099f, 30.698515f, -1.065887f, 30.649129f,
                -1.076232f, 30.528283f, -1.047408f, 30.447789f, -1.064643f, 30.427456f, -1.062633f, 30.351949f, -1.132111f, 30.344531f,
                -1.132719f, 30.342776f, 0.330408f, 30.342776f, 0.330408f, 31.305676f
            )
            poly[1163] = TzPolygon(
                -1.132719f, 30.342776f, -1.132111f, 30.344531f, -1.062633f, 30.351949f, -1.064643f, 30.427456f, -1.047408f, 30.447789f,
                -1.057457f, 30.473213f, -1.088911f, 30.451274f, -1.121826f, 30.476458f, -1.155549f, 30.470168f, -1.171783f, 30.509316f,
                -1.337142f, 30.568722f, -1.445619f, 30.738084f, -1.496091f, 30.742638f, -1.496091f, 30.342776f
            )
            poly[1164] = TzPolygon(
                0.330408f, 29.859437f, 0.388035f, 29.872405f, 0.516361f, 29.980209f, 0.638924f, 29.954495f, 0.744524f, 29.977882f,
                0.778293f, 29.963447f, 0.846147f, 29.989127f, 0.894375f, 30.104737f, 0.886092f, 30.155449f, 0.963590f, 30.184192f,
                1.000841f, 30.234215f, 1.054157f, 30.220531f, 1.126472f, 30.234646f, 1.162584f, 30.268983f, 1.173364f, 30.292535f,
                1.150328f, 30.336226f, 1.201656f, 30.359956f, 1.187593f, 30.390269f, 1.205700f, 30.495437f, 1.266042f, 30.519726f,
                1.266134f, 30.549684f, 2.116339f, 31.305559f, 0.330408f, 31.305676f
            )
            poly[1165] = TzPolygon(
                5.002966f, 27.454076f, 4.961285f, 27.512156f, 4.921516f, 27.512000f, 4.887752f, 27.573603f, 4.896095f, 27.648306f,
                4.842823f, 27.700356f, 4.794363f, 27.701275f, 4.791322f, 27.771397f, 4.727634f, 27.782334f, 4.691578f, 27.765513f,
                4.608024f, 27.790011f, 4.592507f, 27.839293f, 4.539207f, 27.893383f, 4.537352f, 27.927337f, 4.580188f, 27.948651f,
                4.555898f, 27.979050f, 4.551990f, 28.047620f, 4.479282f, 28.037323f, 4.417538f, 28.080224f, 4.438329f, 28.090624f,
                4.442757f, 28.140454f, 4.401817f, 28.138705f, 4.350832f, 28.207855f, 4.355462f, 28.353098f, 4.285291f, 28.380810f,
                4.292943f, 28.461629f, 4.378574f, 28.515905f, 4.382415f, 28.579437f, 4.420902f, 28.603345f, 4.429361f, 28.669204f,
                4.510695f, 28.697657f, 4.563972f, 28.783521f, 4.480592f, 28.834433f, 4.491327f, 29.035206f, 4.460050f, 29.082616f,
                4.434524f, 29.078743f, 4.431354f, 29.136381f, 4.340702f, 29.217023f, 4.353850f, 29.252090f, 4.398732f, 29.270585f,
                4.382778f, 29.306223f, 4.397281f, 29.346893f, 4.470563f, 29.369115f, 4.475716f, 29.379876f, 2.156907f, 29.379876f,
                2.156907f, 27.454076f
            )
            poly[1166] = TzPolygon(3.579937f, 30.839014f, 3.579937f, 30.908587f, 3.488980f, 30.854388f, 3.571079f, 30.861418f)
            poly[1167] = TzPolygon(
                2.156907f, 31.305676f, 2.220856f, 31.203075f, 2.293214f, 31.203274f, 2.264059f, 31.125475f, 2.302845f, 31.070071f,
                2.309382f, 31.085462f, 2.343626f, 31.074301f, 2.404795f, 30.982844f, 2.393547f, 30.948653f, 2.336641f, 30.936351f,
                2.332281f, 30.904877f, 2.384108f, 30.848439f, 2.426775f, 30.834157f, 2.438698f, 30.777929f, 2.419697f, 30.751643f,
                2.452837f, 30.740202f, 2.510071f, 30.761814f, 2.586277f, 30.750089f, 2.603702f, 30.777963f, 2.749732f, 30.822752f,
                2.773602f, 30.859210f, 2.858263f, 30.890147f, 2.961666f, 30.858003f, 3.051907f, 30.767992f, 3.069111f, 30.794353f,
                3.263285f, 30.838246f, 3.280478f, 30.870670f, 3.341151f, 30.887477f, 3.399167f, 30.936805f, 3.506244f, 30.942020f,
                3.478026f, 30.869568f, 3.496667f, 30.848840f, 3.493664f, 30.866058f, 3.579937f, 30.912603f, 3.579937f, 31.305676f
            )
            poly[1168] = TzPolygon(
                4.475716f, 29.379876f, 4.500143f, 29.430892f, 4.599027f, 29.477133f, 4.668489f, 29.464462f, 4.696338f, 29.493815f,
                4.655050f, 29.534709f, 4.671958f, 29.554791f, 4.659100f, 29.622929f, 4.617015f, 29.710137f, 4.570071f, 29.744887f,
                4.587526f, 29.764057f, 4.560207f, 29.825899f, 4.520152f, 29.799610f, 4.373082f, 29.799910f, 4.335356f, 29.841552f,
                4.347610f, 29.902985f, 4.310150f, 29.954079f, 4.287276f, 29.967528f, 4.243995f, 29.944251f, 4.209946f, 29.973563f,
                4.207765f, 30.026657f, 4.131925f, 30.060529f, 4.119715f, 30.161293f, 4.048870f, 30.161227f, 4.024117f, 30.195046f,
                3.937175f, 30.213043f, 3.956474f, 30.277103f, 3.914312f, 30.296468f, 3.923092f, 30.342776f, 3.579937f, 30.342776f,
                3.579937f, 29.379876f
            )
            poly[1169] = TzPolygon(
                3.579937f, 31.305676f, 3.579937f, 30.912603f, 3.691018f, 30.972532f, 3.707365f, 31.002852f, 3.693630f, 31.022521f,
                3.740399f, 31.065634f, 3.736133f, 31.100463f, 3.790776f, 31.163750f, 3.796602f, 31.289064f, 3.787471f, 31.305676f
            )
            poly[1170] = TzPolygon(
                3.923092f, 30.342776f, 3.923766f, 30.346330f, 3.865622f, 30.410268f, 3.882418f, 30.445983f, 3.832729f, 30.466800f,
                3.855664f, 30.529757f, 3.842681f, 30.551968f, 3.741481f, 30.578780f, 3.619610f, 30.562242f, 3.606296f, 30.626617f,
                3.643371f, 30.685817f, 3.623298f, 30.727272f, 3.636283f, 30.757657f, 3.683461f, 30.775505f, 3.593377f, 30.805019f,
                3.579937f, 30.833804f, 3.579937f, 30.342776f
            )
            poly[1171] = TzPolygon(-0.998942f, 31.831806f, -1.005137f, 31.843944f, -1.028136f, 31.839137f, -1.004433f, 31.823686f)
            poly[1172] = TzPolygon(-0.998942f, 33.933350f, -1.000000f, 33.933361f, -0.999996f, 31.305676f, -0.998942f, 31.305676f)
            poly[1173] = TzPolygon(
                -0.998942f, 33.933350f, -0.998942f, 40.227580f, -3.562595f, 40.227580f, -4.144853f, 39.900042f, -4.681074f, 39.647123f,
                -4.681071f, 39.605154f, -4.891904f, 39.477932f, -4.899520f, 39.441363f, -4.876042f, 39.376929f, -4.680056f, 39.219471f,
                -3.671311f, 37.784089f, -3.535680f, 37.737660f, -3.504560f, 37.678900f, -3.519970f, 37.608390f, -3.480046f, 37.626169f,
                -3.461626f, 37.585614f, -3.440514f, 37.584550f, -3.310335f, 37.711760f, -3.060820f, 37.672770f, -1.028602f, 34.093170f,
                -1.046155f, 34.040899f, -1.000000f, 34.018917f, -1.000000f, 33.933361f
            )
            poly[1174] = TzPolygon(
                -0.998942f, 33.933350f, -0.537005f, 33.928582f, -0.129024f, 33.982769f, 0.102198f, 33.909899f, 0.323793f, 34.056263f,
                0.349777f, 34.098959f, 0.456153f, 34.088414f, 0.483377f, 34.119477f, 0.582873f, 34.138227f, 0.625970f, 34.200325f,
                0.640063f, 34.277696f, 0.679399f, 34.278717f, 0.698018f, 34.314219f, 0.761603f, 34.314840f, 0.808917f, 34.414945f,
                0.825885f, 34.406456f, 0.937520f, 34.479148f, 1.102321f, 34.522304f, 1.098618f, 34.574984f, 1.150042f, 34.579372f,
                1.208067f, 34.669566f, 1.223124f, 34.795183f, 1.269217f, 34.830783f, 1.309730f, 34.829073f, 1.365224f, 34.787095f,
                1.383833f, 34.806498f, 1.413576f, 34.793849f, 1.457112f, 34.844239f, 1.528341f, 34.864077f, 1.576609f, 34.943670f,
                1.664359f, 34.991239f, 1.758546f, 35.000308f, 1.962409f, 35.000205f, 2.002012f, 34.992487f, 2.002012f, 35.766628f,
                -0.998942f, 35.766628f
            )
            poly[1175] = TzPolygon(
                3.787471f, 31.305676f, 3.676319f, 31.507898f, 3.643986f, 31.501771f, 3.638164f, 31.517765f, 3.682357f, 31.575750f,
                3.723992f, 31.707365f, 3.824802f, 31.812757f, 3.784746f, 31.869806f, 3.659903f, 31.957451f, 3.571937f, 31.958118f,
                3.592202f, 32.053057f, 3.560412f, 32.087067f, 3.531521f, 32.086031f, 3.507104f, 32.200844f, 3.563712f, 32.217889f,
                3.600492f, 32.197166f, 3.745619f, 32.415280f, 3.767808f, 32.720234f, 3.815606f, 32.901165f, 3.893614f, 33.027761f,
                3.778745f, 33.178821f, 3.751822f, 33.511075f, 3.777192f, 33.536152f, 2.002012f, 33.536152f, 2.002012f, 31.305676f
            )
            poly[1176] = TzPolygon(4.628582f, 35.766628f, 4.610000f, 34.387500f, 3.776377f, 33.536152f, 5.002966f, 33.536152f, 5.002966f, 35.766628f)
            poly[1177] = TzPolygon(
                3.777192f, 33.536152f, 4.234077f, 33.987762f, 4.144009f, 34.065686f, 4.121119f, 34.049532f, 4.049080f, 34.091356f,
                4.009513f, 34.060052f, 3.961347f, 34.134641f, 3.861269f, 34.088435f, 3.880859f, 34.215572f, 3.831007f, 34.226011f,
                3.831560f, 34.180062f, 3.806967f, 34.153173f, 3.795133f, 34.188647f, 3.767706f, 34.170877f, 3.783891f, 34.245585f,
                3.711388f, 34.307928f, 3.735161f, 34.365072f, 3.669496f, 34.463224f, 3.517132f, 34.451497f, 3.491714f, 34.424775f,
                3.491768f, 34.388971f, 3.450657f, 34.416607f, 3.370584f, 34.400617f, 3.342713f, 34.429958f, 3.181988f, 34.455822f,
                3.141352f, 34.494840f, 3.136529f, 34.545816f, 3.091398f, 34.572301f, 2.924676f, 34.599040f, 2.906730f, 34.639292f,
                2.867562f, 34.652895f, 2.877681f, 34.701746f, 2.854986f, 34.736348f, 2.787792f, 34.775379f, 2.697880f, 34.775411f,
                2.655833f, 34.799190f, 2.570588f, 34.868247f, 2.592857f, 34.893865f, 2.516585f, 34.912996f, 2.515940f, 34.933060f,
                2.472408f, 34.954412f, 2.402942f, 34.914348f, 2.002012f, 34.992487f, 2.002012f, 33.536152f
            )
            poly[1178] = TzPolygon(
                5.002966f, 35.818334f, 5.002966f, 40.227580f, 4.055009f, 40.227580f, 4.043934f, 40.191982f, 3.874727f, 39.869568f,
                3.666064f, 39.773931f, 3.485644f, 39.589727f, 3.397448f, 39.553899f, 3.407031f, 39.514898f, 3.464037f, 39.495489f,
                3.463671f, 39.330938f, 3.500048f, 39.327886f, 3.475024f, 39.298894f, 3.476428f, 39.195501f, 3.539233f, 39.087713f,
                3.509875f, 39.021307f, 3.531054f, 38.968511f, 3.512255f, 38.906316f, 3.572253f, 38.714727f, 3.623644f, 38.687688f,
                3.593249f, 38.665533f, 3.603869f, 38.579900f, 3.654223f, 38.539312f, 3.649035f, 38.516546f, 3.625842f, 38.523138f,
                3.601855f, 38.448492f, 3.619860f, 38.191289f, 3.605822f, 38.129888f, 3.726428f, 38.008733f, 4.292468f, 37.128912f,
                4.373461f, 37.048101f, 4.447253f, 36.844732f, 4.449740f, 36.037285f, 4.534607f, 35.955978f, 4.631039f, 35.948997f,
                4.774210f, 35.817937f
            )
            poly[1179] = TzPolygon(5.002966f, 35.818334f, 4.774210f, 35.817937f, 4.631039f, 35.948997f, 4.628582f, 35.766628f, 5.002966f, 35.766628f)
            poly[1180] = TzPolygon(
                8.269973f, 27.454076f, 8.269973f, 33.173177f, 8.256345f, 33.174860f, 8.238451f, 33.205233f, 8.196093f, 33.166396f,
                8.129026f, 33.192548f, 8.110513f, 33.120518f, 8.062987f, 33.121156f, 8.073386f, 33.084544f, 8.022113f, 33.077460f,
                8.008028f, 33.038974f, 7.968543f, 33.038657f, 7.944053f, 32.997584f, 7.893308f, 33.016513f, 7.858829f, 33.004727f,
                7.789424f, 33.045232f, 7.802884f, 33.092189f, 7.779893f, 33.108420f, 7.803924f, 33.159760f, 7.771995f, 33.208230f,
                7.779003f, 33.246903f, 7.707503f, 33.323200f, 7.756748f, 33.434153f, 7.736665f, 33.517679f, 7.691238f, 33.549334f,
                7.693495f, 33.646854f, 7.663140f, 33.715563f, 7.572843f, 33.804442f, 7.559746f, 33.840828f, 5.002966f, 33.840828f,
                5.002966f, 27.454076f
            )
            poly[1181] = TzPolygon(
                9.620707f, 27.454076f, 9.612500f, 27.905555f, 9.773131f, 27.830588f, 10.166667f, 27.833333f, 10.166667f, 29.000000f,
                9.673558f, 28.999999f, 9.746928f, 29.070488f, 9.750000f, 29.537500f, 10.081953f, 29.537492f, 10.288055f, 29.941108f,
                10.288068f, 29.999998f, 9.960296f, 30.529879f, 9.864292f, 30.647452f, 8.269973f, 30.647452f, 8.269973f, 27.454076f
            )
            poly[1182] = TzPolygon(
                8.269973f, 33.840828f, 8.269973f, 33.173177f, 8.295846f, 33.169982f, 8.300310f, 33.198137f, 8.334549f, 33.191943f,
                8.342271f, 33.217333f, 8.383166f, 33.186892f, 8.435524f, 33.219130f, 8.425251f, 33.235200f, 8.462603f, 33.270932f,
                8.439933f, 33.292584f, 8.467686f, 33.312306f, 8.426404f, 33.397387f, 8.480736f, 33.497324f, 8.473709f, 33.560335f,
                8.442883f, 33.597432f, 8.471763f, 33.618420f, 8.445385f, 33.676366f, 8.377586f, 33.700473f, 8.367764f, 33.769101f,
                8.399381f, 33.801540f, 8.405510f, 33.840828f
            )
            poly[1183] = TzPolygon(
                11.536979f, 32.391111f, 11.180805f, 32.391111f, 11.043305f, 32.469730f, 10.737488f, 32.148885f, 10.650279f, 31.988613f,
                10.288890f, 31.778334f, 9.816197f, 31.364848f, 9.762007f, 31.289791f, 9.750001f, 30.837905f, 9.711747f, 30.834268f,
                9.864292f, 30.647452f, 11.536979f, 30.647452f
            )
            poly[1184] = TzPolygon(
                10.274657f, 33.840828f, 10.335715f, 33.803667f, 10.441809f, 33.668327f, 10.642550f, 33.517171f, 10.777746f, 33.246094f,
                10.827894f, 33.271098f, 11.232722f, 33.202782f, 11.437224f, 33.138323f, 11.536979f, 33.153778f, 11.536979f, 33.840828f
            )
            poly[1185] = TzPolygon(
                6.636469f, 33.840828f, 6.636469f, 34.741684f, 6.594498f, 34.768106f, 6.610790f, 34.864242f, 6.558017f, 34.939003f,
                6.504036f, 34.957689f, 6.447416f, 35.021823f, 6.246949f, 34.950147f, 6.185531f, 34.978937f, 6.089775f, 34.971951f,
                6.075383f, 35.004779f, 5.896967f, 34.997657f, 5.687448f, 35.130149f, 5.624417f, 35.126028f, 5.498190f, 35.314526f,
                5.380840f, 35.288753f, 5.334822f, 35.316011f, 5.364531f, 35.411743f, 5.412733f, 35.473372f, 5.423659f, 35.537765f,
                5.404222f, 35.616755f, 5.381796f, 35.620613f, 5.392173f, 35.717123f, 5.349077f, 35.772102f, 5.320180f, 35.862339f,
                5.249368f, 35.826450f, 5.183881f, 35.865806f, 5.100429f, 35.818503f, 5.002966f, 35.818334f, 5.002966f, 33.840828f
            )
            poly[1186] = TzPolygon(
                7.559746f, 33.840828f, 7.538901f, 33.898742f, 7.474438f, 33.925539f, 7.469004f, 33.957712f, 7.421392f, 34.001949f,
                7.382611f, 34.007229f, 7.356722f, 34.036631f, 7.275899f, 34.041349f, 7.269696f, 34.011778f, 7.245961f, 34.021703f,
                7.193784f, 34.101214f, 7.169813f, 34.104884f, 7.131551f, 34.190213f, 7.041492f, 34.191523f, 6.977913f, 34.305387f,
                6.948005f, 34.293094f, 6.912453f, 34.373271f, 6.918636f, 34.470561f, 6.817106f, 34.543326f, 6.745065f, 34.531284f,
                6.723129f, 34.617537f, 6.740384f, 34.640323f, 6.685173f, 34.711024f, 6.636469f, 34.741684f, 6.636469f, 33.840828f
            )
            poly[1187] = TzPolygon(
                9.903476f, 33.840828f, 9.903476f, 33.986673f, 9.809405f, 33.965672f, 9.730099f, 33.904363f, 9.499999f, 33.877584f,
                9.500001f, 34.106678f, 9.032806f, 34.145517f, 8.607698f, 34.145517f, 8.555785f, 34.100536f, 8.529791f, 34.044935f,
                8.488511f, 34.023590f, 8.503893f, 33.971997f, 8.482808f, 33.897228f, 8.411017f, 33.876133f, 8.405510f, 33.840828f
            )
            poly[1188] = TzPolygon(
                9.903476f, 33.986673f, 9.903476f, 34.206525f, 9.758056f, 34.140000f, 9.553056f, 34.085833f, 9.500001f, 34.106678f,
                9.499999f, 33.877584f, 9.730099f, 33.904363f, 9.809405f, 33.965672f
            )
            poly[1189] = TzPolygon(
                9.903476f, 34.192713f, 10.030278f, 34.231389f, 10.117222f, 34.323056f, 10.231944f, 34.347778f, 10.538579f, 34.280011f,
                10.784444f, 34.439722f, 10.887778f, 34.594444f, 10.745833f, 34.773333f, 10.686944f, 34.773333f, 10.729444f, 34.808611f,
                10.735000f, 34.864444f, 10.785833f, 34.868611f, 10.864444f, 34.975278f, 10.915278f, 34.978611f, 10.956667f, 34.933333f,
                11.198333f, 35.007500f, 11.256944f, 34.963889f, 11.536979f, 35.084642f, 11.536979f, 37.034204f, 9.903476f, 37.034204f
            )
            poly[1190] = TzPolygon(
                10.274657f, 33.840828f, 10.171371f, 33.903690f, 10.145910f, 33.970458f, 10.091990f, 33.971295f, 10.060354f, 33.995551f,
                9.922644f, 33.990952f, 9.903476f, 33.986673f, 9.903476f, 33.840828f
            )
            poly[1191] = TzPolygon(
                11.536979f, 32.391111f, 11.706235f, 32.391111f, 11.951050f, 32.096585f, 11.951051f, 32.745703f, 12.013791f, 32.759488f,
                12.236389f, 32.731580f, 12.218997f, 33.294404f, 12.172075f, 33.252170f, 11.536979f, 33.153778f
            )
            poly[1192] = TzPolygon(
                14.256491f, 37.034204f, 14.252133f, 37.019725f, 14.292728f, 36.971514f, 14.322145f, 36.852891f, 14.322492f, 36.743784f,
                14.300535f, 36.690773f, 14.313503f, 36.633441f, 14.283840f, 36.555588f, 14.257421f, 36.560272f, 14.364444f, 36.523611f,
                14.803986f, 36.474209f, 14.803986f, 37.034204f
            )
            poly[1193] = TzPolygon(
                14.803986f, 33.840828f, 14.803986f, 36.474209f, 14.364444f, 36.523611f, 14.257421f, 36.560272f, 13.956944f, 36.446389f,
                13.839444f, 36.486944f, 13.663056f, 36.410556f, 13.586944f, 36.406389f, 13.368056f, 36.248611f, 13.058611f, 36.163889f,
                12.984167f, 36.169722f, 12.923333f, 36.132778f, 12.875278f, 36.165278f, 12.707574f, 36.142472f, 12.694167f, 36.107778f,
                12.723611f, 36.081111f, 12.724167f, 36.006389f, 12.665833f, 35.699444f, 12.612222f, 35.695278f, 12.594167f, 35.649167f,
                12.250556f, 35.438056f, 12.200556f, 35.432500f, 12.161111f, 35.381111f, 12.032778f, 35.345556f, 11.975556f, 35.271111f,
                11.935795f, 35.267688f, 11.900833f, 35.235556f, 11.863889f, 35.134444f, 11.826944f, 35.096944f, 11.720556f, 35.058056f,
                11.557778f, 35.093611f, 11.536979f, 35.084642f, 11.536979f, 33.840828f
            )
            poly[1194] = TzPolygon(
                14.256491f, 37.034204f, 14.803986f, 37.034204f, 14.803986f, 37.863496f, 14.182380f, 37.523761f, 14.183971f, 37.496295f,
                14.217306f, 37.466286f, 14.254288f, 37.469030f, 14.301437f, 37.393368f, 14.365535f, 37.392685f, 14.447924f, 37.309114f,
                14.444047f, 37.222432f, 14.409566f, 37.135452f, 14.275475f, 37.097270f
            )
            poly[1195] = TzPolygon(
                14.445318f, 38.630892f, 14.407305f, 38.520860f, 14.424554f, 38.485159f, 14.413264f, 38.455297f, 14.469494f, 38.424470f,
                14.512327f, 38.347121f, 14.589744f, 38.312826f, 14.618306f, 38.269395f, 14.680131f, 38.257206f, 14.694873f, 38.191086f,
                14.678617f, 38.187354f, 14.675502f, 38.143277f, 14.716499f, 38.091601f, 14.720204f, 38.044608f, 14.803986f, 37.981050f,
                14.803986f, 38.630892f
            )
            poly[1196] = TzPolygon(
                14.445318f, 38.630892f, 14.803986f, 38.630892f, 14.803986f, 40.227580f, 14.394561f, 40.227580f, 14.387112f, 40.213192f,
                14.546030f, 40.134477f, 14.540404f, 40.069291f, 14.448291f, 40.008617f, 14.454797f, 39.988701f, 14.415153f, 39.930448f,
                14.503208f, 39.794097f, 14.546152f, 39.770087f, 14.555449f, 39.713171f, 14.598341f, 39.669049f, 14.609022f, 39.586794f,
                14.550181f, 39.508106f, 14.514124f, 39.510207f, 14.491425f, 39.538023f, 14.484060f, 39.495864f, 14.505190f, 39.489444f,
                14.539500f, 39.373114f, 14.483310f, 39.360033f, 14.493940f, 39.328644f, 14.466250f, 39.346443f, 14.469920f, 39.301334f,
                14.410326f, 39.250771f, 14.450227f, 39.227767f, 14.484996f, 39.266784f, 14.515458f, 39.261593f, 14.563238f, 39.241032f,
                14.565330f, 39.205283f, 14.608330f, 39.157394f, 14.649190f, 39.168513f, 14.653246f, 39.153878f, 14.638667f, 39.032213f,
                14.544992f, 38.978483f, 14.466903f, 38.797526f, 14.470889f, 38.704908f
            )
            poly[1197] = TzPolygon(
                14.803986f, 36.474209f, 15.167382f, 36.433365f, 15.229299f, 36.534283f, 15.437222f, 36.610556f, 15.449722f, 36.647778f,
                15.489444f, 36.626111f, 15.753056f, 36.697778f, 15.808056f, 36.763611f, 16.215000f, 36.915833f, 16.269444f, 36.973056f,
                16.358333f, 36.947778f, 16.425278f, 36.956944f, 16.517778f, 36.896389f, 16.641111f, 36.912222f, 16.706111f, 36.980556f,
                16.850556f, 37.022778f, 16.943056f, 36.986944f, 17.003611f, 37.018056f, 17.073889f, 36.995833f, 17.065842f, 37.034204f,
                14.803986f, 37.034204f
            )
            poly[1198] = TzPolygon(14.803986f, 37.863496f, 14.894054f, 37.912722f, 14.803986f, 37.981050f)
            poly[1199] = TzPolygon(
                18.070992f, 38.788101f, 18.020698f, 38.582747f, 17.899265f, 38.452055f, 17.644444f, 38.344444f, 17.603056f, 38.273611f,
                17.535278f, 38.261944f, 17.528889f, 38.222500f, 17.562222f, 38.185833f, 17.548611f, 38.133611f, 17.498889f, 38.135556f,
                17.481111f, 38.111389f, 17.496667f, 38.091944f, 17.543889f, 38.095556f, 17.551944f, 38.055833f, 17.447500f, 37.917222f,
                17.445000f, 37.869722f, 17.481389f, 37.818889f, 17.465278f, 37.787500f, 17.376667f, 37.735833f, 17.325833f, 37.516944f,
                17.306892f, 37.498721f, 17.274492f, 37.521624f, 17.254688f, 37.497665f, 17.201053f, 37.505980f, 17.054665f, 37.395797f,
                17.061111f, 37.306944f, 17.025000f, 37.252222f, 17.015556f, 37.151944f, 17.051111f, 37.104444f, 17.065842f, 37.034204f,
                18.070992f, 37.034204f
            )
        }
    }

    private object Initializer13 {
        fun init() {
            poly[1200] = TzPolygon(
                22.000000f, 27.454076f, 22.000000f, 31.315029f, 22.131552f, 31.365019f, 22.224918f, 31.469795f, 22.185232f, 31.506184f,
                22.000000f, 31.398882f, 22.000000f, 33.840828f, 18.070992f, 33.840828f, 18.070992f, 27.454076f
            )
            poly[1201] = TzPolygon(
                22.752268f, 33.840828f, 22.752268f, 36.736511f, 22.708019f, 36.775746f, 22.478471f, 36.844054f, 22.431276f, 36.943900f,
                22.374618f, 37.000446f, 22.065117f, 37.115352f, 22.000000f, 37.106838f, 22.000000f, 33.840828f
            )
            poly[1202] = TzPolygon(
                18.693124f, 40.227580f, 18.893711f, 39.963143f, 19.405013f, 39.822946f, 19.640372f, 39.724062f, 20.181745f, 39.294263f,
                20.650788f, 39.078082f, 21.007849f, 38.837496f, 21.608943f, 38.631753f, 21.801708f, 38.537916f, 22.066339f, 38.543059f,
                22.361175f, 38.635811f, 22.674664f, 38.411313f, 22.752268f, 38.405645f, 22.752268f, 40.227580f
            )
            poly[1203] = TzPolygon(
                22.752268f, 40.227580f, 22.752268f, 38.405645f, 22.978272f, 38.389140f, 23.363728f, 38.087575f, 23.511514f, 37.872612f,
                24.015943f, 37.513185f, 24.155067f, 37.291030f, 24.225199f, 37.038980f, 24.294464f, 36.967298f, 25.124138f, 36.654638f,
                25.272189f, 36.502032f, 25.567847f, 36.273909f, 25.666170f, 36.260581f, 25.820553f, 36.308958f, 25.964505f, 36.277750f,
                26.071918f, 36.172220f, 26.263092f, 36.065695f, 26.548408f, 35.802326f, 26.847968f, 35.589538f, 27.052458f, 35.507182f,
                27.319863f, 35.332708f, 27.433543f, 35.203242f, 27.433543f, 40.227580f
            )
            poly[1204] = TzPolygon(-74.917383f, -34.628225f, -86.000000f, -34.628225f, -86.000000f, -35.000000f, -75.000000f, -35.000000f)
            poly[1205] = TzPolygon(-64.000000f, -64.000000f, -64.800000f, -63.800000f, -65.250000f, -65.500000f, -64.500000f, -65.000000f)
            poly[1206] = TzPolygon(-61.800000f, -59.000000f, -62.250000f, -58.800000f, -63.400000f, -57.300000f, -64.000000f, -64.000000f, -62.700000f, -63.000000f)
            poly[1207] = TzPolygon(
                -52.168257f, -69.122039f, -52.150443f, -69.190145f, -52.151654f, -69.486316f, -52.000744f, -69.995504f, -51.999914f, -71.922586f,
                -51.972131f, -71.965540f, -51.977265f, -72.010316f, -51.958861f, -72.032083f, -51.919754f, -71.931763f, -51.873565f, -71.948770f,
                -51.744052f, -72.121756f, -51.699251f, -72.297230f, -51.638135f, -72.283320f, -51.625427f, -72.319111f, -51.587321f, -72.327058f,
                -51.584547f, -72.441305f, -51.513573f, -72.405165f, -51.520811f, -72.344922f, -51.484526f, -72.351054f, -51.475055f, -72.324087f,
                -51.366104f, -72.308916f, -51.336323f, -72.371600f, -51.283303f, -72.269188f, -51.252599f, -72.259215f, -51.200376f, -72.304678f,
                -51.202595f, -72.346752f, -51.106483f, -72.410394f, -51.080011f, -72.376154f, -51.022385f, -72.373059f, -51.035044f, -72.265599f,
                -50.972131f, -72.258414f, -50.972131f, -69.122039f
            )
            poly[1208] = TzPolygon(-50.373695f, -73.373347f, -50.381667f, -73.416944f, -50.343611f, -73.437778f, -50.307998f, -73.373347f)
            poly[1209] = TzPolygon(
                -50.293629f, -73.373347f, -50.242903f, -73.451511f, -50.182628f, -73.430901f, -50.153689f, -73.521806f, -50.106770f, -73.514484f,
                -50.089282f, -73.475683f, -50.049939f, -73.497465f, -50.053925f, -73.461665f, -50.010242f, -73.435664f, -49.965570f, -73.444526f,
                -49.942466f, -73.560537f, -49.757830f, -73.438495f, -49.705218f, -73.508808f, -49.618914f, -73.463397f, -49.538104f, -73.549396f,
                -49.498248f, -73.539325f, -49.482501f, -73.463520f, -49.428729f, -73.490131f, -49.391924f, -73.425922f, -49.319415f, -73.410297f,
                -49.268328f, -73.496418f, -49.204718f, -73.473070f, -49.229091f, -73.373347f
            )
            poly[1210] = TzPolygon(
                -49.073372f, -73.373347f, -48.716648f, -73.967390f, -48.726341f, -74.027707f, -48.695323f, -74.159088f, -48.724463f, -74.252300f,
                -48.690535f, -74.305429f, -48.681412f, -74.381561f, -48.706587f, -74.557568f, -48.641295f, -74.682194f, -48.631255f, -74.790449f,
                -48.486002f, -74.790449f, -48.486002f, -73.373347f
            )
            poly[1211] = TzPolygon(
                -50.972131f, -72.258414f, -50.876478f, -72.247490f, -50.752742f, -72.349541f, -50.657242f, -72.287850f, -50.649807f, -72.337772f,
                -50.616387f, -72.356772f, -50.637502f, -72.411419f, -50.601685f, -72.494385f, -50.621316f, -72.547016f, -50.681844f, -72.591455f,
                -50.615734f, -72.731788f, -50.671444f, -72.895256f, -50.741236f, -72.954872f, -50.761865f, -73.043148f, -50.788907f, -73.068504f,
                -50.780556f, -73.143889f, -50.820556f, -73.200000f, -50.767778f, -73.149722f, -50.741323f, -73.196293f, -50.652494f, -73.145106f,
                -50.570482f, -73.331530f, -50.534435f, -73.357258f, -50.372778f, -73.368333f, -50.373695f, -73.373347f, -50.307998f, -73.373347f,
                -50.301389f, -73.361389f, -50.293629f, -73.373347f, -49.729067f, -73.373347f, -49.729067f, -71.956244f, -50.972131f, -71.956244f
            )
            poly[1212] = TzPolygon(
                -49.073372f, -73.373347f, -49.211531f, -73.143273f, -49.265847f, -73.134544f, -49.252987f, -73.089363f, -49.272109f, -73.042002f,
                -49.283889f, -73.097513f, -49.338210f, -73.095560f, -49.373236f, -73.133583f, -49.420633f, -73.037109f, -49.516321f, -73.022261f,
                -49.624278f, -73.139591f, -49.676071f, -73.156243f, -49.729067f, -73.294078f, -49.729067f, -73.373347f
            )
            poly[1213] = TzPolygon(
                -49.073372f, -73.373347f, -48.486002f, -73.373347f, -48.486002f, -72.569485f, -48.487366f, -72.585860f, -48.799627f, -72.533240f,
                -48.867375f, -72.640228f, -48.866211f, -72.689366f, -48.968829f, -72.795893f, -48.943008f, -72.942709f, -48.991041f, -72.988221f,
                -49.026108f, -72.977261f, -49.033164f, -73.009969f, -49.059837f, -73.000914f, -49.179147f, -73.140826f, -49.211531f, -73.143273f
            )
            poly[1214] = TzPolygon(-48.486002f, -72.409653f, -48.514964f, -72.440543f, -48.519521f, -72.501370f, -48.486002f, -72.532000f)
            poly[1215] = TzPolygon(-48.486002f, -72.569485f, -48.483102f, -72.534651f, -48.486002f, -72.532000f)
            poly[1216] = TzPolygon(
                -48.486002f, -72.409653f, -48.451306f, -72.372647f, -48.416961f, -72.405593f, -48.391377f, -72.346763f, -48.350902f, -72.379676f,
                -48.363328f, -72.277107f, -48.322420f, -72.225673f, -48.234494f, -72.316137f, -48.160122f, -72.298627f, -48.074376f, -72.359822f,
                -48.065322f, -72.443140f, -47.969140f, -72.424469f, -47.938727f, -72.527184f, -47.813606f, -72.466888f, -47.747154f, -72.523710f,
                -47.747214f, -72.441670f, -47.661172f, -72.420519f, -47.635718f, -72.344622f, -47.592011f, -72.307954f, -47.571453f, -72.327564f,
                -47.498924f, -72.294466f, -47.455519f, -72.343117f, -47.405974f, -72.244262f, -47.416734f, -72.197213f, -47.329625f, -72.130104f,
                -47.340456f, -72.046001f, -47.294770f, -71.996930f, -47.198372f, -72.021783f, -47.211988f, -71.956244f, -48.486002f, -71.956244f
            )
            poly[1217] = TzPolygon(-46.975173f, -71.956244f, -46.974253f, -71.958174f, -46.904758f, -71.970878f, -46.891481f, -71.956244f)
            poly[1218] = TzPolygon(-46.822256f, -71.956244f, -46.816163f, -71.959565f, -46.815647f, -71.956244f)
            poly[1219] = TzPolygon(-45.999874f, -71.647592f, -46.000007f, -69.122039f, -46.000024f, -71.647732f)
            poly[1220] = TzPolygon(
                -45.999874f, -71.643072f, -46.089645f, -71.715576f, -46.139787f, -71.915540f, -46.164399f, -71.901381f, -46.157342f, -71.869104f,
                -46.194966f, -71.860119f, -46.192339f, -71.790144f, -46.228897f, -71.751031f, -46.284685f, -71.723935f, -46.346223f, -71.756790f,
                -46.638954f, -71.646060f, -46.688349f, -71.646749f, -46.765864f, -71.770248f, -46.798850f, -71.839168f, -46.815685f, -71.956244f,
                -45.999874f, -71.956244f
            )
            poly[1221] = TzPolygon(-46.822256f, -71.956244f, -46.868576f, -71.930999f, -46.891481f, -71.956244f)
            poly[1222] = TzPolygon(
                -46.975173f, -71.956244f, -47.011827f, -71.879346f, -47.076828f, -71.955347f, -47.126997f, -71.863246f, -47.162756f, -71.850571f,
                -47.213934f, -71.891140f, -47.231009f, -71.864685f, -47.211988f, -71.956244f
            )
            poly[1223] = TzPolygon(
                -51.089499f, -69.122039f, -51.089499f, -68.799167f, -51.500085f, -68.634973f, -51.607390f, -68.629448f, -51.896129f, -68.415487f,
                -52.270048f, -68.037246f, -52.349500f, -68.026787f, -52.434537f, -68.070925f, -52.523273f, -68.174496f, -52.578244f, -68.307953f,
                -52.522572f, -68.515748f, -52.386402f, -68.418376f, -52.332497f, -68.418688f, -52.277765f, -68.837980f, -52.203612f, -68.986873f,
                -52.168257f, -69.122039f
            )
            poly[1224] = TzPolygon(
                -55.940225f, -69.122039f, -52.168257f, -69.122039f, -52.203612f, -68.986873f, -52.277765f, -68.837980f, -52.332497f, -68.418688f,
                -52.386402f, -68.418376f, -52.659022f, -68.606761f, -54.913692f, -68.609671f, -54.880906f, -68.399190f, -54.873726f, -67.950712f,
                -54.905562f, -67.706496f, -54.894333f, -67.572310f, -54.923486f, -67.476209f, -54.905627f, -67.264616f, -54.929633f, -67.122637f,
                -54.976657f, -67.030228f, -54.997049f, -66.826615f, -55.119059f, -66.670940f, -55.121667f, -66.416667f, -55.183333f, -66.078333f,
                -55.217262f, -66.075347f, -55.306560f, -66.112536f, -55.623486f, -66.429033f, -55.855613f, -66.453857f, -55.937454f, -66.511203f,
                -56.114545f, -66.832094f, -56.179111f, -67.264759f, -56.042972f, -68.003464f, -55.927462f, -68.219511f
            )
            poly[1225] = TzPolygon(-45.999917f, -69.122039f, -45.999981f, -65.401461f, -46.000007f, -69.122039f)
            poly[1226] = TzPolygon(-27.426989f, -57.411484f, -27.441097f, -57.506667f, -27.383750f, -57.601072f, -27.383750f, -57.411484f)
            poly[1227] = TzPolygon(
                -27.565886f, -56.929806f, -27.562194f, -56.937524f, -27.489437f, -56.987878f, -27.466431f, -57.231774f, -27.414530f, -57.327425f,
                -27.426989f, -57.411484f, -27.383750f, -57.411484f, -27.383750f, -56.929806f
            )
            poly[1228] = TzPolygon(
                -27.565886f, -56.929806f, -27.383750f, -56.929806f, -27.383750f, -56.217655f, -27.401206f, -56.236151f, -27.408220f, -56.283768f,
                -27.494085f, -56.293697f, -27.594162f, -56.386292f, -27.569581f, -56.462913f, -27.449462f, -56.530368f, -27.421017f, -56.601169f,
                -27.460740f, -56.649547f, -27.468146f, -56.721080f, -27.548630f, -56.677096f, -27.576937f, -56.685955f, -27.605025f, -56.743305f,
                -27.586888f, -56.793692f, -27.606393f, -56.845127f
            )
            poly[1229] = TzPolygon(-27.383750f, -55.687280f, -27.445158f, -55.736915f, -27.409480f, -55.836335f, -27.383750f, -55.859440f)
            poly[1230] = TzPolygon(-28.393264f, -55.893571f, -28.361586f, -55.877394f, -28.370951f, -55.751566f, -28.393264f, -55.737148f)
            poly[1231] = TzPolygon(
                -28.393264f, -55.686687f, -28.332177f, -55.670467f, -28.274140f, -55.774151f, -28.244807f, -55.775696f, -28.177189f, -55.631672f,
                -28.116039f, -55.607468f, -28.165234f, -55.559574f, -28.076818f, -55.495201f, -28.097869f, -55.446106f, -28.029000f, -55.368000f,
                -27.979478f, -55.382994f, -27.972000f, -55.343000f, -27.926637f, -55.327065f, -27.929692f, -55.265742f, -27.867119f, -55.206523f,
                -28.393264f, -55.206523f
            )
            poly[1232] = TzPolygon(
                -27.383750f, -54.216578f, -27.386035f, -54.217363f, -27.397000f, -54.261000f, -27.448195f, -54.284845f, -27.402263f, -54.337713f,
                -27.467252f, -54.350459f, -27.405000f, -54.410000f, -27.426739f, -54.470814f, -27.472000f, -54.444000f, -27.481000f, -54.503000f,
                -27.505902f, -54.524598f, -27.453000f, -54.574000f, -27.541000f, -54.621000f, -27.508003f, -54.677088f, -27.573936f, -54.679261f,
                -27.561000f, -54.742000f, -27.586000f, -54.775000f, -27.533000f, -54.814000f, -27.624000f, -54.850000f, -27.638708f, -54.906169f,
                -27.726000f, -54.903000f, -27.772000f, -54.936000f, -27.773000f, -54.989000f, -27.797784f, -55.012999f, -27.769321f, -55.050940f,
                -27.779000f, -55.081000f, -27.834000f, -55.024000f, -27.855772f, -55.030303f, -27.846000f, -55.106000f, -27.896061f, -55.132624f,
                -27.856000f, -55.196000f, -27.867119f, -55.206523f, -27.383750f, -55.206523f
            )
            poly[1233] = TzPolygon(
                20.875696f, -74.790449f, 20.786618f, -74.617986f, 20.444741f, -74.047256f, 20.332640f, -73.949476f, 20.216068f, -73.919000f,
                20.067675f, -73.966645f, 19.901473f, -74.146785f, 19.753908f, -74.790449f
            )
            poly[1234] = TzPolygon(
                20.888781f, -74.068076f, 20.888781f, -72.961406f, 20.836151f, -72.993005f, 20.780223f, -73.047057f, 20.747023f, -73.119238f,
                20.705985f, -73.629360f, 20.728948f, -73.746754f, 20.805749f, -73.839721f
            )
            poly[1235] = TzPolygon(
                19.079476f, -72.827404f, 19.079476f, -71.701378f, 19.073210f, -71.701150f, 19.030960f, -71.771424f, 18.993074f, -71.788411f,
                19.005487f, -71.833459f, 18.959283f, -71.886457f, 18.941705f, -71.879738f, 18.970334f, -71.836512f, 18.954721f, -71.781304f,
                18.906876f, -71.768160f, 18.878448f, -71.722298f, 18.722193f, -71.737955f, 18.685288f, -71.804196f, 18.630613f, -71.815352f,
                18.627111f, -71.880535f, 18.649019f, -71.908281f, 18.634797f, -71.925697f, 18.656665f, -71.966361f, 18.625016f, -72.008231f,
                18.603425f, -71.965129f, 18.503719f, -71.880801f, 18.485265f, -71.913721f, 18.457184f, -71.904546f, 18.378810f, -71.795323f,
                18.340637f, -71.696020f, 18.180586f, -71.788066f, 18.148727f, -71.746865f, 18.068456f, -71.738461f, 17.953787f, -71.829509f,
                18.090777f, -71.977204f, 18.100931f, -72.019935f, 18.045224f, -72.827404f
            )
            poly[1236] = TzPolygon(
                19.079476f, -71.701378f, 19.105909f, -71.702341f, 19.115873f, -71.654201f, 19.206655f, -71.621755f, 19.235332f, -71.645568f,
                19.240675f, -71.697080f, 19.278273f, -71.725392f, 19.262319f, -71.731626f, 19.274190f, -71.748093f, 19.329518f, -71.782734f,
                19.371358f, -71.713641f, 19.360122f, -71.693955f, 19.444757f, -71.678286f, 19.512560f, -71.688070f, 19.584680f, -71.743137f,
                19.661530f, -71.734993f, 19.731262f, -71.773662f, 19.796456f, -71.913843f, 19.953058f, -72.057471f, 20.888781f, -71.257498f,
                20.888781f, -70.864359f, 19.079476f, -70.864359f
            )
            poly[1237] = TzPolygon(
                20.888781f, -74.068076f, 21.151443f, -74.790449f, 24.507391f, -74.790449f, 24.305040f, -74.323528f, 23.217770f, -73.441397f,
                22.470244f, -72.526660f, 22.397729f, -72.470202f, 22.325449f, -72.447752f, 21.948685f, -72.549879f, 21.803964f, -72.630110f,
                21.540119f, -72.677290f, 21.134138f, -72.814092f, 20.888781f, -72.961406f
            )
            poly[1238] = TzPolygon(
                20.888781f, -71.257498f, 20.979376f, -71.180046f, 21.013958f, -71.110514f, 21.148919f, -70.979051f, 21.181769f, -70.864359f,
                20.888781f, -70.864359f
            )
            poly[1239] = TzPolygon(17.962145f, -68.110146f, 18.032232f, -68.149209f, 18.159037f, -68.161270f, 18.237614f, -68.145212f, 18.287709f, -68.110146f)
            poly[1240] = TzPolygon(
                18.090418f, -65.040186f, 18.225000f, -65.100000f, 18.250000f, -65.160000f, 18.430000f, -65.108000f, 18.561463f, -65.194611f,
                18.605456f, -65.095175f, 18.607818f, -65.040186f
            )
            poly[1241] = TzPolygon(
                18.090418f, -65.040186f, 18.607818f, -65.040186f, 18.611435f, -64.955961f, 18.397500f, -64.863889f, 18.408056f, -64.799167f,
                18.377222f, -64.755833f, 18.364167f, -64.639444f, 18.321111f, -64.636944f, 18.278611f, -64.661389f, 18.106342f, -64.640138f,
                18.029421f, -64.850254f, 18.047544f, -64.939115f, 18.100478f, -65.012449f
            )
            poly[1242] = TzPolygon(
                17.615815f, -63.467388f, 17.615815f, -62.786255f, 17.279160f, -63.051129f, 17.329000f, -63.130669f, 17.418074f, -63.193474f,
                17.421000f, -63.299959f, 17.465000f, -63.392221f, 17.534000f, -63.448399f
            )
            poly[1243] = TzPolygon(
                17.615815f, -63.467388f, 17.622000f, -63.468824f, 17.706000f, -63.454661f, 17.783000f, -63.404870f, 17.835000f, -63.321523f,
                17.850000f, -63.237785f, 17.814000f, -63.104546f, 17.735835f, -63.019720f, 17.673976f, -62.847226f, 17.615815f, -62.786255f
            )
            poly[1244] = TzPolygon(
                18.063986f, -63.053224f, 18.017220f, -62.949445f, 17.806209f, -63.054445f, 17.851000f, -63.202966f, 17.896354f, -63.267794f,
                18.053210f, -63.138583f
            )
            poly[1245] = TzPolygon(
                18.190278f, -62.876389f, 18.162863f, -62.767393f, 18.137557f, -62.764406f, 18.017220f, -62.949445f, 18.063852f, -63.052330f,
                18.053210f, -63.138583f, 17.896354f, -63.267794f, 17.967190f, -63.335665f, 18.061545f, -63.360564f
            )
            poly[1246] = TzPolygon(
                18.137557f, -62.764406f, 18.102717f, -62.691512f, 18.037377f, -62.623930f, 17.895705f, -62.584402f, 17.801834f, -62.602224f,
                17.733899f, -62.646249f, 17.687045f, -62.716892f, 17.670931f, -62.806973f, 17.735835f, -63.019720f, 17.780835f, -63.066390f,
                18.017220f, -62.949445f
            )
            poly[1247] = TzPolygon(14.272500f, -61.003889f, 14.248663f, -61.096863f, 14.272500f, -61.137076f)
            poly[1248] = TzPolygon(14.272500f, -61.003889f, 14.272500f, -60.694712f, 14.221738f, -60.753188f)
            poly[1249] = TzPolygon(15.079510f, -61.515737f, 15.079246f, -61.158913f, 15.007421f, -61.370245f, 15.042183f, -61.481351f)
            poly[1250] = TzPolygon(15.787222f, -61.850567f, 15.787222f, -61.442500f, 15.644411f, -61.679823f, 15.715000f, -61.806201f)
            poly[1251] = TzPolygon(15.787222f, -61.041043f, 15.746000f, -61.073256f, 15.701667f, -61.138333f, 15.734167f, -61.323611f, 15.787222f, -61.442500f)
            poly[1252] = TzPolygon(
                17.146803f, -62.330352f, 17.108000f, -62.212501f, 17.015298f, -62.140067f, 16.757390f, -62.447583f, 16.818000f, -62.518611f,
                16.899313f, -62.553652f
            )
            poly[1253] = TzPolygon(
                17.503210f, -62.584402f, 17.419000f, -62.513395f, 17.330000f, -62.402047f, 17.250000f, -62.349104f, 17.146803f, -62.330352f,
                16.899313f, -62.553652f, 16.896779f, -62.584402f
            )
            poly[1254] = TzPolygon(
                16.714000f, -62.140067f, 16.714000f, -61.938204f, 16.699000f, -61.935382f, 16.609000f, -61.956662f, 16.530000f, -62.018761f,
                16.487000f, -62.093222f, 16.481245f, -62.140067f
            )
            poly[1255] = TzPolygon(17.015298f, -62.140067f, 17.005619f, -62.109034f, 16.837713f, -61.961479f, 16.714000f, -61.938204f, 16.714000f, -62.140067f)
            poly[1256] = TzPolygon(-69.000000f, -5.500000f, -86.000000f, -5.500000f, -86.000000f, -17.000000f, -71.000000f, -17.000000f)
            poly[1257] = TzPolygon(-68.000000f, 25.000000f, -86.000000f, 25.000000f, -86.000000f, 0.000000f, -68.000000f, 0.000000f)
            poly[1258] = TzPolygon(
                6.113484f, -10.881472f, 6.131467f, -10.911890f, 6.217496f, -10.994758f, 6.323764f, -11.018611f, 6.544761f, -11.478392f,
                6.635449f, -11.556299f, 6.755000f, -11.608076f, 6.929214f, -11.506233f, 6.938163f, -11.418093f, 6.969373f, -11.432173f,
                7.022377f, -11.369220f, 7.071421f, -11.374588f, 7.078700f, -11.332722f, 7.140514f, -11.352486f, 7.148563f, -11.328003f,
                7.210294f, -11.310403f, 7.197447f, -11.291633f, 7.238875f, -11.272552f, 7.230473f, -11.251737f, 7.264953f, -11.181941f,
                7.390724f, -11.102111f, 7.403861f, -11.059504f, 7.513667f, -10.932952f, 7.497456f, -10.922288f, 7.524327f, -10.881472f
            )
            poly[1259] = TzPolygon(
                8.056728f, -13.439885f, 8.124000f, -13.450028f, 8.230000f, -13.399223f, 8.352000f, -13.482388f, 8.494000f, -13.500339f,
                8.568000f, -13.486636f, 8.638000f, -13.444025f, 8.836000f, -13.449651f, 8.966000f, -13.495776f, 9.036079f, -13.301206f,
                9.095863f, -13.199646f, 9.050996f, -13.128106f, 9.048735f, -13.081904f, 9.081216f, -13.072756f, 9.096942f, -13.021877f,
                9.169200f, -12.979297f, 9.180636f, -12.951057f, 9.227069f, -12.971358f, 9.282095f, -12.953768f, 9.288444f, -12.931099f,
                9.261827f, -12.906930f, 9.293538f, -12.879613f, 9.281062f, -12.847149f, 9.303543f, -12.785498f, 9.344635f, -12.774828f,
                9.348647f, -12.746287f, 9.396298f, -12.753743f, 9.389026f, -12.707223f, 9.411733f, -12.703913f, 9.408429f, -12.683117f,
                9.513992f, -12.644625f, 9.538524f, -12.654538f, 9.544659f, -12.638547f, 8.056728f, -12.638547f
            )
            poly[1260] = TzPolygon(
                9.544659f, -12.638547f, 9.548303f, -12.629047f, 9.605798f, -12.615513f, 9.601701f, -12.587666f, 9.703384f, -12.564143f,
                9.721718f, -12.531691f, 9.706567f, -12.518610f, 9.845347f, -12.495655f, 9.880862f, -12.437889f, 9.932905f, -12.222482f,
                9.906727f, -12.218454f, 9.869980f, -12.123623f, 9.940182f, -11.906884f, 9.999944f, -11.894622f, 9.999973f, -11.208071f,
                9.975012f, -11.213198f, 9.960631f, -11.171886f, 9.865509f, -11.155931f, 9.861494f, -11.102933f, 9.813882f, -11.061469f,
                9.818049f, -11.043227f, 9.787408f, -11.039009f, 9.751102f, -10.991321f, 9.663941f, -10.963905f, 9.654848f, -10.917867f,
                9.601756f, -10.910969f, 9.591666f, -10.881472f, 8.056728f, -10.881472f, 8.056728f, -12.638547f
            )
            poly[1261] = TzPolygon(
                5.616687f, -7.386640f, 5.616687f, -7.367323f, 4.189802f, -7.367323f, 4.162121f, -7.509634f, 4.162242f, -7.526990f,
                4.362148f, -7.529589f, 4.393427f, -7.566383f, 4.435477f, -7.539373f, 4.456824f, -7.566897f, 4.511487f, -7.551943f,
                4.583875f, -7.573500f, 4.611906f, -7.547840f, 4.653025f, -7.576169f, 4.668763f, -7.559442f, 4.783194f, -7.560701f,
                4.801640f, -7.594605f, 4.896031f, -7.599211f, 4.920609f, -7.526098f, 4.973483f, -7.558175f, 4.996221f, -7.542109f,
                5.075595f, -7.557050f, 5.107209f, -7.522019f, 5.096323f, -7.506934f, 5.149704f, -7.473951f, 5.278270f, -7.475047f,
                5.298592f, -7.414660f, 5.259243f, -7.415192f, 5.330139f, -7.367758f, 5.386745f, -7.375840f, 5.365021f, -7.400077f,
                5.429648f, -7.449083f, 5.443404f, -7.439925f, 5.429437f, -7.420294f, 5.475940f, -7.422875f, 5.508646f, -7.390725f,
                5.522698f, -7.404398f, 5.526396f, -7.381374f, 5.579458f, -7.395127f, 5.582483f, -7.372480f
            )
            poly[1262] = TzPolygon(
                6.317634f, -8.245860f, 6.323893f, -8.283508f, 6.340861f, -8.271393f, 6.378804f, -8.341246f, 6.354276f, -8.397650f,
                6.370690f, -8.414707f, 6.386010f, -8.384917f, 6.429255f, -8.412565f, 6.443337f, -8.396310f, 6.498406f, -8.443172f,
                6.500669f, -8.466286f, 6.471791f, -8.456529f, 6.434952f, -8.482110f, 6.499477f, -8.550298f, 6.506148f, -8.601725f,
                6.526219f, -8.595998f, 6.523754f, -8.571709f, 6.570854f, -8.563719f, 6.560365f, -8.542026f, 6.576194f, -8.530551f,
                6.609616f, -8.540484f, 6.596376f, -8.511129f, 6.618110f, -8.507667f, 6.614111f, -8.487690f, 6.662446f, -8.453200f,
                6.685466f, -8.404930f, 6.712931f, -8.409556f, 6.767268f, -8.359845f, 6.761819f, -8.342923f, 6.797089f, -8.348472f,
                6.814916f, -8.320354f, 6.837699f, -8.329424f, 6.863647f, -8.309245f, 6.885520f, -8.336588f, 6.912843f, -8.307964f,
                6.970788f, -8.327148f, 7.004484f, -8.274724f, 7.077782f, -8.301022f, 7.077782f, -8.245860f
            )
            poly[1263] = TzPolygon(
                6.317634f, -8.245860f, 6.310042f, -8.200190f, 6.279650f, -8.175297f, 6.322500f, -8.006177f, 6.296536f, -7.993351f,
                6.284795f, -7.902793f, 6.195129f, -7.822580f, 6.191577f, -7.844410f, 6.075621f, -7.851266f, 6.096694f, -7.832424f,
                6.092832f, -7.801545f, 6.055516f, -7.798814f, 6.035948f, -7.769348f, 5.988284f, -7.792358f, 5.932873f, -7.741885f,
                5.897659f, -7.686724f, 5.952739f, -7.663445f, 5.913179f, -7.661012f, 5.896749f, -7.581485f, 5.831155f, -7.549465f,
                5.855846f, -7.516585f, 5.837073f, -7.522310f, 5.811831f, -7.483549f, 5.862119f, -7.465958f, 5.845069f, -7.424365f,
                5.754688f, -7.443774f, 5.616687f, -7.386640f, 5.616687f, -8.245860f
            )
            poly[1264] = TzPolygon(
                8.538878f, -10.002935f, 8.441187f, -10.002935f, 8.427025f, -10.055265f, 8.498696f, -10.045973f, 8.535006f, -10.119289f,
                8.526036f, -10.162251f, 8.479013f, -10.207489f, 8.506361f, -10.323912f, 8.482837f, -10.357294f, 8.490380f, -10.383676f,
                8.411639f, -10.431149f, 8.309204f, -10.542492f, 8.354449f, -10.642650f, 8.280327f, -10.701320f, 8.375577f, -10.676068f,
                8.392305f, -10.639378f, 8.424515f, -10.650757f, 8.538878f, -10.616800f
            )
            poly[1265] = TzPolygon(
                7.524327f, -10.881472f, 7.549146f, -10.843773f, 7.736022f, -10.701644f, 7.774626f, -10.604332f, 8.040542f, -10.605165f,
                8.048099f, -10.575784f, 8.145422f, -10.501112f, 8.147601f, -10.397145f, 8.165673f, -10.377170f, 8.150163f, -10.351673f,
                8.197015f, -10.301531f, 8.284757f, -10.320212f, 8.340018f, -10.288465f, 8.490938f, -10.277130f, 8.479013f, -10.207489f,
                8.526036f, -10.162251f, 8.535006f, -10.119289f, 8.498696f, -10.045973f, 8.427924f, -10.058509f, 8.428238f, -10.040421f,
                8.449289f, -10.002935f, 7.077782f, -10.002935f, 7.077782f, -10.881472f
            )
            poly[1266] = TzPolygon(
                8.449289f, -10.002935f, 8.499477f, -9.913566f, 8.500830f, -9.854315f, 8.483829f, -9.842383f, 8.507753f, -9.790742f,
                8.526469f, -9.800966f, 8.538878f, -9.785231f, 8.538878f, -9.746908f, 8.525612f, -9.724947f, 8.503610f, -9.743872f,
                8.439339f, -9.717750f, 8.484220f, -9.697927f, 8.501782f, -9.663292f, 8.454249f, -9.620021f, 8.405213f, -9.658221f,
                8.404147f, -9.608808f, 8.424864f, -9.590682f, 8.381562f, -9.552117f, 8.373440f, -9.496846f, 8.348558f, -9.477569f,
                8.318344f, -9.518782f, 8.267001f, -9.488971f, 8.241740f, -9.512220f, 8.189326f, -9.515499f, 8.176500f, -9.462251f,
                8.083103f, -9.440836f, 8.043131f, -9.460182f, 8.060909f, -9.409410f, 8.020340f, -9.404725f, 7.976488f, -9.442593f,
                7.890854f, -9.439611f, 7.746473f, -9.349224f, 7.658560f, -9.379831f, 7.613072f, -9.359180f, 7.472894f, -9.424897f,
                7.429783f, -9.468057f, 7.367042f, -9.482319f, 7.426459f, -9.420602f, 7.388434f, -9.403479f, 7.435867f, -9.350814f,
                7.426818f, -9.294154f, 7.375265f, -9.281980f, 7.389297f, -9.206986f, 7.318946f, -9.203205f, 7.271039f, -9.155351f,
                7.273515f, -9.124398f, 7.077782f, -9.124398f, 7.077782f, -10.002935f
            )
            poly[1267] = TzPolygon(
                9.591666f, -10.881472f, 9.528648f, -10.860019f, 9.516090f, -10.824031f, 9.499018f, -10.848523f, 9.455264f, -10.851985f,
                9.412596f, -10.802475f, 9.377810f, -10.810901f, 9.379581f, -10.731523f, 9.328307f, -10.705132f, 9.310683f, -10.663425f,
                9.213131f, -10.656026f, 9.185703f, -10.702634f, 9.200171f, -10.714934f, 9.081140f, -10.730468f, 9.085594f, -10.666421f,
                9.051220f, -10.573873f, 8.986904f, -10.591202f, 8.805366f, -10.561048f, 8.782636f, -10.519816f, 8.672920f, -10.464359f,
                8.625686f, -10.492699f, 8.598731f, -10.574771f, 8.573390f, -10.574422f, 8.542202f, -10.615813f, 8.538878f, -10.616800f,
                8.538878f, -10.881472f
            )
            poly[1268] = TzPolygon(8.538878f, -9.785231f, 8.551986f, -9.768609f, 8.538878f, -9.746908f)
            poly[1269] = TzPolygon(
                7.077782f, -8.301022f, 7.087964f, -8.304675f, 7.182125f, -8.281116f, 7.246788f, -8.369097f, 7.272830f, -8.355716f,
                7.328065f, -8.395801f, 7.532628f, -8.424368f, 7.531077f, -8.453217f, 7.557172f, -8.471017f, 7.628078f, -8.397063f,
                7.593105f, -8.382240f, 7.612193f, -8.307922f, 7.585010f, -8.297981f, 7.556444f, -8.245860f, 7.077782f, -8.245860f
            )
            poly[1270] = TzPolygon(
                8.538878f, -8.245860f, 7.554576f, -8.245860f, 7.585010f, -8.297981f, 7.612193f, -8.307922f, 7.587915f, -8.360238f,
                7.628078f, -8.397063f, 7.557172f, -8.471017f, 7.631502f, -8.569942f, 7.695752f, -8.553885f, 7.695744f, -8.676459f,
                7.641369f, -8.714162f, 7.556031f, -8.725855f, 7.515144f, -8.706389f, 7.348944f, -8.853597f, 7.276366f, -8.837304f,
                7.255804f, -8.905104f, 7.295203f, -8.916573f, 7.290569f, -8.940855f, 7.265285f, -8.943858f, 7.247000f, -9.025236f,
                7.198511f, -9.069882f, 7.210499f, -9.095943f, 7.190605f, -9.108189f, 7.273515f, -9.124398f, 8.538878f, -9.124398f
            )
            poly[1271] = TzPolygon(
                8.538878f, -7.684003f, 8.496617f, -7.658928f, 8.441261f, -7.678094f, 8.380320f, -7.638199f, 8.377334f, -7.740485f,
                8.474476f, -7.786696f, 8.495360f, -7.823946f, 8.437291f, -7.828238f, 8.422009f, -7.878706f, 8.441366f, -7.879221f,
                8.456139f, -7.919218f, 8.490266f, -7.907889f, 8.508772f, -7.932779f, 8.488568f, -7.985308f, 8.510817f, -8.088201f,
                8.479977f, -8.109535f, 8.506428f, -8.188253f, 8.459659f, -8.237937f, 8.357937f, -8.214965f, 8.235372f, -8.243449f,
                8.184833f, -8.173607f, 8.181849f, -8.099919f, 8.154895f, -8.052692f, 8.194630f, -8.034691f, 8.179825f, -8.019564f,
                8.192830f, -7.981026f, 8.102008f, -8.012981f, 8.090208f, -7.975662f, 8.017109f, -7.943015f, 8.017062f, -7.980815f,
                8.048560f, -7.996697f, 8.036965f, -8.062147f, 7.883110f, -8.134847f, 7.797761f, -8.091256f, 7.657397f, -8.144591f,
                7.608218f, -8.184913f, 7.584276f, -8.170411f, 7.561416f, -8.183195f, 7.538724f, -8.218713f, 7.554576f, -8.245860f,
                8.538878f, -8.245860f
            )
            poly[1272] = TzPolygon(
                9.999973f, -8.140173f, 9.983245f, -8.147105f, 9.979639f, -8.114620f, 9.962030f, -8.112053f, 9.950539f, -8.163334f,
                9.909014f, -8.151473f, 9.904096f, -8.121459f, 9.868941f, -8.138987f, 9.873563f, -8.103153f, 9.833266f, -8.092317f,
                9.806046f, -8.111899f, 9.762599f, -8.101751f, 9.759569f, -8.121897f, 9.653693f, -8.115101f, 9.624851f, -8.144905f,
                9.549601f, -8.143753f, 9.461665f, -8.102079f, 9.395482f, -8.035085f, 9.421289f, -7.848958f, 9.339614f, -7.881989f,
                9.298997f, -7.873934f, 9.213204f, -7.923058f, 9.161609f, -7.882640f, 9.176020f, -7.823357f, 9.106207f, -7.782297f,
                9.072677f, -7.726566f, 9.066225f, -7.840262f, 9.032525f, -7.856740f, 9.025193f, -7.898678f, 8.987946f, -7.934001f,
                8.936633f, -7.916443f, 8.900458f, -7.942366f, 8.884126f, -7.925087f, 8.849049f, -7.937639f, 8.829746f, -7.974708f,
                8.776612f, -7.931540f, 8.791417f, -7.877295f, 8.757368f, -7.831257f, 8.767450f, -7.787564f, 8.741906f, -7.791301f,
                8.730895f, -7.761474f, 8.658844f, -7.732688f, 8.647130f, -7.688983f, 8.618032f, -7.671642f, 8.559728f, -7.696374f,
                8.538878f, -7.684003f, 8.538878f, -9.124398f, 9.999973f, -9.124398f
            )
            poly[1273] = TzPolygon(
                9.999973f, -8.140366f, 10.056258f, -8.117690f, 10.097318f, -8.008806f, 10.134687f, -8.014238f, 10.173500f, -7.989511f,
                10.153077f, -7.936037f, 10.200211f, -7.892721f, 10.213245f, -7.833935f, 10.306107f, -7.748024f, 10.310432f, -7.772628f,
                10.344594f, -7.753215f, 10.346662f, -7.722573f, 10.373129f, -7.739448f, 10.462040f, -7.626121f, 10.411919f, -7.548070f,
                10.459645f, -7.518974f, 10.453334f, -7.457228f, 10.341932f, -7.435175f, 10.352537f, -7.391514f, 10.337964f, -7.367323f,
                10.271946f, -7.367323f, 10.258989f, -7.389089f, 10.245365f, -7.377723f, 10.242986f, -7.367323f, 9.999973f, -7.367323f
            )
            poly[1274] = TzPolygon(
                9.999973f, -11.208071f, 9.999973f, -14.395621f, 10.011000f, -14.408190f, 10.015000f, -14.507029f, 10.060000f, -14.590367f,
                10.173000f, -14.664172f, 10.253000f, -14.683399f, 10.282000f, -14.765661f, 10.345000f, -14.830337f, 10.462040f, -14.855785f,
                10.462040f, -8.241570f, 10.419884f, -8.231183f, 10.414881f, -8.182569f, 10.449110f, -8.098713f, 10.393421f, -8.105054f,
                10.354318f, -8.082277f, 10.331409f, -8.052522f, 10.346286f, -7.988536f, 10.252545f, -7.945088f, 10.134687f, -8.014238f,
                10.097318f, -8.008806f, 10.058185f, -8.116052f, 9.999973f, -8.140173f
            )
            poly[1275] = TzPolygon(
                10.462040f, -15.487632f, 10.483267f, -15.517969f, 10.538795f, -15.552878f, 10.631383f, -15.568051f, 10.666667f, -15.561771f,
                10.666667f, -15.341667f, 10.884419f, -15.101679f, 10.977044f, -14.957673f, 11.364614f, -14.772313f, 11.504958f, -14.663604f,
                11.500663f, -14.586488f, 10.462040f, -14.586488f, 10.462040f, -14.855785f, 10.531000f, -14.870779f, 10.573000f, -14.914423f,
                10.582000f, -15.053476f, 10.629253f, -15.148679f, 10.565629f, -15.157531f, 10.482806f, -15.208200f, 10.462040f, -15.238664f
            )
            poly[1276] = TzPolygon(
                12.686238f, -16.985033f, 12.686238f, -15.163646f, 12.613723f, -15.337639f, 12.537045f, -15.429051f, 12.424853f, -15.683065f,
                12.442799f, -15.953417f, 12.472449f, -16.038821f, 12.449675f, -16.162611f, 12.461253f, -16.202766f, 12.362526f, -16.381002f,
                12.359202f, -16.689724f, 12.237284f, -16.894523f, 12.321000f, -16.957292f, 12.437000f, -16.992877f, 12.577000f, -16.973236f
            )
            poly[1277] = TzPolygon(12.681999f, -14.586488f, 12.686238f, -15.163646f, 12.686238f, -14.586488f)
            poly[1278] = TzPolygon(
                12.682026f, -14.586488f, 12.675615f, -13.708148f, 12.607889f, -13.709542f, 12.489885f, -13.641637f, 12.430171f, -13.634878f,
                12.405487f, -13.666319f, 12.319961f, -13.658163f, 12.310637f, -13.686146f, 12.249019f, -13.717877f, 12.277139f, -13.759555f,
                12.251633f, -13.799938f, 12.297280f, -13.800325f, 12.258186f, -13.822354f, 12.283243f, -13.831120f, 12.281348f, -13.855269f,
                12.242291f, -13.857077f, 12.234614f, -13.919187f, 12.199802f, -13.957084f, 12.144907f, -13.937796f, 12.136924f, -13.875451f,
                12.107841f, -13.868168f, 12.092841f, -13.809603f, 12.048205f, -13.789223f, 12.008197f, -13.696349f, 11.707412f, -13.708167f,
                11.682585f, -13.775727f, 11.693774f, -13.798187f, 11.717533f, -13.795444f, 11.704219f, -13.820634f, 11.734663f, -13.823871f,
                11.747154f, -13.854383f, 11.729758f, -13.863718f, 11.716951f, -13.845641f, 11.659303f, -13.873299f, 11.685015f, -13.922119f,
                11.654852f, -13.936302f, 11.654801f, -14.039105f, 11.626110f, -14.082562f, 11.664702f, -14.135062f, 11.677024f, -14.267145f,
                11.602356f, -14.319521f, 11.496490f, -14.511552f, 11.500663f, -14.586488f
            )
            poly[1279] = TzPolygon(12.663650f, -13.383294f, 12.673900f, -13.483647f, 12.681999f, -14.586488f, 12.686238f, -14.586488f, 12.686238f, -13.383294f)
            poly[1280] = TzPolygon(
                12.663650f, -13.383294f, 12.686238f, -13.383294f, 12.686238f, -12.180100f, 12.359674f, -12.180100f, 12.334759f, -12.282213f,
                12.350657f, -12.302219f, 12.314428f, -12.362077f, 12.385185f, -12.403218f, 12.409620f, -12.495844f, 12.366222f, -12.564676f,
                12.408356f, -12.583388f, 12.435902f, -12.626558f, 12.433511f, -12.765245f, 12.467693f, -12.750831f, 12.493359f, -12.845049f,
                12.517313f, -12.834324f, 12.555151f, -12.893055f, 12.527449f, -12.949487f, 12.475614f, -12.944720f, 12.484881f, -13.061397f,
                12.537982f, -13.071130f, 12.587196f, -13.045762f, 12.644052f, -13.063378f, 12.627009f, -13.179054f, 12.654162f, -13.207883f,
                12.641702f, -13.319079f, 12.658362f, -13.331516f
            )
            poly[1281] = TzPolygon(
                12.686238f, -11.578503f, 12.440931f, -11.578503f, 12.433769f, -11.641329f, 12.381908f, -11.770085f, 12.403361f, -11.804864f,
                12.392930f, -11.847518f, 12.449131f, -11.899895f, 12.405456f, -11.968085f, 12.402339f, -12.015019f, 12.433291f, -12.062134f,
                12.417435f, -12.112764f, 12.360285f, -12.177595f, 12.359674f, -12.180100f, 12.686238f, -12.180100f
            )
            poly[1282] = TzPolygon(
                12.436188f, -11.578503f, 12.441798f, -11.432808f, 12.396858f, -11.364931f, 12.388857f, -11.432783f, 12.353546f, -11.449076f,
                12.282924f, -11.430278f, 12.231525f, -11.486291f, 12.184802f, -11.496682f, 12.134093f, -11.454564f, 12.107568f, -11.366777f,
                12.062805f, -11.356431f, 12.023905f, -11.310762f, 11.998042f, -11.225089f, 12.019844f, -11.211694f, 12.018918f, -11.180417f,
                12.066296f, -11.137812f, 12.101563f, -11.141231f, 12.099426f, -11.113588f, 12.130845f, -11.101049f, 12.141176f, -11.067777f,
                12.221613f, -11.047472f, 12.227873f, -10.976906f, 11.574139f, -10.976906f, 11.574139f, -11.578503f
            )
            poly[1283] = TzPolygon(
                12.686238f, -11.442712f, 12.673314f, -11.448167f, 12.651880f, -11.414452f, 12.609682f, -11.423315f, 12.588186f, -11.404208f,
                12.548480f, -11.447957f, 12.521956f, -11.409891f, 12.541353f, -11.407487f, 12.538480f, -11.386855f, 12.491791f, -11.383035f,
                12.510025f, -11.363741f, 12.493371f, -11.354120f, 12.421500f, -11.367413f, 12.404033f, -11.389033f, 12.434552f, -11.413993f,
                12.452642f, -11.475776f, 12.440931f, -11.578503f, 12.686238f, -11.578503f
            )
            poly[1284] = TzPolygon(
                12.227873f, -10.976906f, 12.231666f, -10.934141f, 12.209863f, -10.895629f, 12.142653f, -10.859139f, 12.115530f, -10.792080f,
                12.041576f, -10.801596f, 11.971627f, -10.764991f, 11.941797f, -10.773229f, 11.897751f, -10.657181f, 11.908862f, -10.631902f,
                11.975856f, -10.608221f, 11.990615f, -10.566568f, 12.023941f, -10.580976f, 12.047559f, -10.519115f, 12.125401f, -10.513999f,
                12.121790f, -10.447644f, 12.144958f, -10.409841f, 12.178864f, -10.408965f, 12.168458f, -10.376699f, 12.197554f, -10.359164f,
                12.193399f, -10.332519f, 12.226930f, -10.339639f, 12.223301f, -10.308897f, 12.192032f, -10.297729f, 12.217977f, -10.249694f,
                12.200292f, -10.242544f, 12.205314f, -10.192500f, 12.176449f, -10.148942f, 12.188194f, -10.091264f, 12.150953f, -10.093460f,
                12.137411f, -10.064699f, 12.154466f, -10.060472f, 12.103152f, -9.968570f, 12.103907f, -9.914239f, 12.057483f, -9.871559f,
                12.066505f, -9.816981f, 12.038226f, -9.780678f, 12.037168f, -9.773711f, 10.462040f, -9.773711f, 10.462040f, -10.976906f
            )
            poly[1285] = TzPolygon(
                12.037168f, -9.773711f, 12.027946f, -9.712972f, 12.034946f, -9.688370f, 12.118433f, -9.683118f, 12.175298f, -9.635399f,
                12.197452f, -9.533995f, 12.259934f, -9.473517f, 12.248481f, -9.340687f, 12.362284f, -9.297739f, 12.381514f, -9.339077f,
                12.452081f, -9.380567f, 12.462207f, -9.407189f, 12.500906f, -9.357702f, 12.479101f, -9.335184f, 12.506235f, -9.314579f,
                12.485579f, -9.283777f, 12.506174f, -9.251390f, 12.489574f, -9.157560f, 12.420428f, -9.014583f, 12.324808f, -8.933353f,
                12.218807f, -8.992267f, 12.223904f, -8.978790f, 12.186168f, -8.965911f, 12.204700f, -8.918527f, 12.151440f, -8.883686f,
                12.093662f, -8.911946f, 12.045462f, -8.908053f, 12.025974f, -8.867342f, 12.047450f, -8.826588f, 11.976816f, -8.772223f,
                11.828695f, -8.798470f, 11.800488f, -8.830702f, 11.654723f, -8.848837f, 11.633918f, -8.760626f, 11.610313f, -8.745767f,
                11.645562f, -8.701281f, 11.549798f, -8.641344f, 11.522426f, -8.654728f, 11.476332f, -8.614932f, 11.463346f, -8.570517f,
                11.136030f, -8.570517f, 11.130352f, -8.604308f, 11.095749f, -8.600959f, 11.002089f, -8.675935f, 10.962388f, -8.671910f,
                10.959861f, -8.581695f, 10.966113f, -8.570517f, 10.462040f, -8.570517f, 10.462040f, -9.773711f
            )
            poly[1286] = TzPolygon(
                11.463346f, -8.570517f, 11.462186f, -8.566550f, 11.493949f, -8.529791f, 11.416539f, -8.498133f, 11.428529f, -8.473679f,
                11.376309f, -8.352726f, 11.348490f, -8.408154f, 11.329242f, -8.397951f, 11.325982f, -8.354592f, 11.282912f, -8.367135f,
                11.288907f, -8.469683f, 11.228588f, -8.476519f, 11.211549f, -8.550616f, 11.137925f, -8.559240f, 11.136030f, -8.570517f
            )
            poly[1287] = TzPolygon(
                10.966113f, -8.570517f, 10.999039f, -8.511648f, 11.071400f, -8.481146f, 11.071663f, -8.362034f, 11.018655f, -8.288725f,
                10.895173f, -8.256857f, 10.856466f, -8.305966f, 10.817890f, -8.303464f, 10.788134f, -8.331245f, 10.752192f, -8.289114f,
                10.698738f, -8.288587f, 10.670958f, -8.322687f, 10.591041f, -8.325320f, 10.595386f, -8.287402f, 10.575374f, -8.269496f,
                10.462040f, -8.241570f, 10.462040f, -8.570517f
            )
            poly[1288] = TzPolygon(
                13.777134f, -15.181512f, 13.539917f, -15.181512f, 13.529483f, -15.197261f, 13.419121f, -15.228762f, 13.365534f, -15.299813f,
                13.355788f, -15.379644f, 13.395286f, -15.498566f, 13.350655f, -15.582941f, 13.371262f, -15.680466f, 13.349468f, -15.805110f,
                13.167101f, -15.803606f, 13.168850f, -16.685105f, 13.154292f, -16.709422f, 13.110263f, -16.716385f, 13.111893f, -16.735633f,
                13.080553f, -16.729236f, 13.061111f, -16.748611f, 13.061000f, -16.976144f, 13.381000f, -17.028825f, 13.502000f, -16.988531f,
                13.603001f, -16.858020f, 13.587041f, -16.816933f, 13.584183f, -15.477372f, 13.704900f, -15.436954f, 13.781389f, -15.364444f,
                13.789327f, -15.302330f, 13.740974f, -15.264985f
            )
            poly[1289] = TzPolygon(
                16.581749f, -15.181512f, 16.552261f, -15.231094f, 16.573978f, -15.309362f, 16.534592f, -15.404317f, 16.590825f, -15.469273f,
                16.560256f, -15.515102f, 16.520773f, -15.514748f, 16.524616f, -15.623057f, 16.491811f, -15.628230f, 16.470133f, -15.699359f,
                16.507080f, -15.812614f, 16.490766f, -15.859284f, 16.515607f, -15.886641f, 16.483023f, -15.963398f, 16.500811f, -16.002295f,
                16.477238f, -16.052796f, 16.555258f, -16.115129f, 16.513093f, -16.189762f, 16.524865f, -16.259075f, 16.398588f, -16.331599f,
                16.347617f, -16.332650f, 16.316726f, -16.365662f, 16.275188f, -16.353213f, 16.234525f, -16.371233f, 16.184683f, -16.453415f,
                16.083415f, -16.454485f, 16.055311f, -16.487204f, 16.073960f, -16.496951f, 16.080690f, -16.741203f, 16.289994f, -16.728266f,
                16.677579f, -16.650708f, 17.407117f, -16.329951f, 17.407117f, -15.181512f
            )
            poly[1290] = TzPolygon(
                13.777134f, -15.181512f, 13.825314f, -15.070290f, 13.793755f, -14.985752f, 13.804702f, -14.927194f, 13.783906f, -14.865165f,
                13.744998f, -14.818562f, 13.653333f, -14.791944f, 13.611944f, -14.718611f, 13.654706f, -14.629616f, 13.647916f, -14.530232f,
                13.608333f, -14.490000f, 13.534843f, -14.472065f, 13.453889f, -14.337778f, 13.478333f, -14.240833f, 13.512532f, -14.204876f,
                13.560086f, -14.080439f, 13.556114f, -14.030554f, 13.583059f, -13.973331f, 13.545559f, -13.886109f, 13.453056f, -13.808056f,
                13.406667f, -13.797778f, 13.322778f, -13.867222f, 13.286389f, -14.113889f, 13.229431f, -14.193652f, 13.246784f, -14.266641f,
                13.229704f, -14.358868f, 13.300203f, -14.459510f, 13.313134f, -14.532671f, 13.358741f, -14.578074f, 13.344260f, -14.672630f,
                13.375291f, -14.732259f, 13.417420f, -14.760497f, 13.418207f, -14.813971f, 13.478569f, -14.974859f, 13.535243f, -15.050941f,
                13.600463f, -15.090123f, 13.539917f, -15.181512f
            )
            poly[1291] = TzPolygon(15.045738f, -12.576783f, 15.046677f, -12.578086f, 15.046677f, -12.576783f)
            poly[1292] = TzPolygon(
                16.195089f, -13.879147f, 16.195541f, -13.911664f, 16.230227f, -13.920780f, 16.223352f, -13.974130f, 16.270222f, -13.951951f,
                16.275246f, -13.987297f, 16.303817f, -13.990939f, 16.308484f, -13.958029f, 16.331336f, -13.967945f, 16.348843f, -14.030146f,
                16.454587f, -14.139163f, 16.477466f, -14.133217f, 16.509906f, -14.201022f, 16.531516f, -14.200001f, 16.545820f, -14.246848f,
                16.513604f, -14.256220f, 16.584248f, -14.277949f, 16.566396f, -14.330834f, 16.641649f, -14.335425f, 16.632059f, -14.404657f,
                16.652348f, -14.421231f, 16.623285f, -14.447287f, 16.613703f, -14.497336f, 16.643663f, -14.544603f, 16.616799f, -14.556957f,
                16.616945f, -14.638604f, 16.649173f, -14.644764f, 16.646671f, -14.725859f, 16.618280f, -14.737210f, 16.655647f, -14.765829f,
                16.628820f, -14.788987f, 16.653700f, -14.813226f, 16.636166f, -14.861364f, 16.660166f, -14.879744f, 16.630241f, -14.897076f,
                16.648455f, -14.913677f, 16.630649f, -14.937777f, 16.677097f, -14.952648f, 16.691971f, -14.985333f, 16.641365f, -15.004410f,
                16.627456f, -15.052129f, 16.675835f, -15.099495f, 16.639750f, -15.119726f, 16.619407f, -15.077964f, 16.578862f, -15.116138f,
                16.589523f, -15.168440f, 16.581749f, -15.181512f, 17.407117f, -15.181512f, 17.407117f, -13.879147f
            )
            poly[1293] = TzPolygon(
                15.046677f, -12.576783f, 15.109561f, -12.665310f, 15.084717f, -12.693530f, 15.151848f, -12.790722f, 15.214373f, -12.802807f,
                15.201861f, -12.852940f, 15.259901f, -12.899850f, 15.253500f, -12.850826f, 15.284323f, -12.833820f, 15.316825f, -12.851855f,
                15.357995f, -12.944614f, 15.416372f, -12.947983f, 15.441623f, -12.924924f, 15.443939f, -12.960002f, 15.500130f, -12.964898f,
                15.477553f, -13.046710f, 15.495629f, -13.099337f, 15.582097f, -13.088047f, 15.626371f, -13.186724f, 15.615193f, -13.230504f,
                15.671454f, -13.252521f, 15.695383f, -13.207811f, 15.766543f, -13.292199f, 15.789754f, -13.287726f, 15.789379f, -13.265245f,
                15.819478f, -13.298428f, 15.871618f, -13.300597f, 15.894273f, -13.334930f, 15.923978f, -13.312603f, 15.971858f, -13.364698f,
                16.055620f, -13.376766f, 16.108950f, -13.459762f, 16.077833f, -13.491211f, 16.092033f, -13.510835f, 16.144957f, -13.480695f,
                16.094625f, -13.680590f, 16.132025f, -13.716428f, 16.182109f, -13.715864f, 16.106667f, -13.848516f, 16.154643f, -13.878527f,
                16.195040f, -13.875648f, 16.195089f, -13.879147f, 17.407117f, -13.879147f, 17.407117f, -12.576783f
            )
            poly[1294] = TzPolygon(
                13.866458f, -12.576783f, 13.866458f, -11.941225f, 13.807322f, -11.949643f, 13.721053f, -12.072629f, 13.624906f, -12.038122f,
                13.534496f, -11.969058f, 13.461680f, -11.869919f, 13.386699f, -11.888037f, 13.329950f, -11.829010f, 13.309664f, -11.831728f,
                13.339637f, -11.768386f, 13.415188f, -11.732834f, 13.412795f, -11.703320f, 13.389548f, -11.693064f, 13.394717f, -11.627531f,
                13.364023f, -11.637797f, 13.366301f, -11.597229f, 13.309439f, -11.590393f, 13.257932f, -11.524072f, 13.211098f, -11.543216f,
                13.194119f, -11.501851f, 13.148196f, -11.515070f, 13.098512f, -11.474958f, 13.083819f, -11.426697f, 13.058486f, -11.435917f,
                13.010608f, -11.395261f, 12.999758f, -11.415576f, 12.969604f, -11.410907f, 12.967103f, -11.383369f, 12.992325f, -11.367488f,
                12.941549f, -11.345900f, 12.927481f, -11.399590f, 12.905893f, -11.386234f, 12.843860f, -11.409965f, 12.829803f, -11.381975f,
                12.773831f, -11.397958f, 12.737001f, -11.365809f, 12.728041f, -11.425068f, 12.686238f, -11.442712f, 12.686238f, -12.576783f
            )
            poly[1295] = TzPolygon(
                13.866458f, -11.941225f, 13.924322f, -11.932988f, 13.988534f, -12.010035f, 14.185191f, -11.974678f, 14.288338f, -12.026857f,
                14.305737f, -12.102518f, 14.371516f, -12.098269f, 14.406427f, -12.200721f, 14.439448f, -12.188748f, 14.491302f, -12.221037f,
                14.548890f, -12.216727f, 14.555869f, -12.186100f, 14.647400f, -12.144617f, 14.665584f, -12.177274f, 14.688480f, -12.160413f,
                14.702915f, -12.212665f, 14.764719f, -12.240283f, 14.775982f, -12.130075f, 14.720991f, -12.055338f, 14.768118f, -12.042322f,
                14.767020f, -11.960718f, 14.786649f, -11.932882f, 14.819365f, -11.931107f, 14.820288f, -11.925600f, 13.866458f, -11.925600f
            )
            poly[1296] = TzPolygon(
                15.046677f, -11.925600f, 14.820288f, -11.925600f, 14.819365f, -11.931107f, 14.786649f, -11.932882f, 14.767020f, -11.960718f,
                14.768118f, -12.042322f, 14.720991f, -12.055338f, 14.775982f, -12.130075f, 14.761156f, -12.172842f, 14.771455f, -12.278353f,
                14.826353f, -12.327346f, 14.828852f, -12.370621f, 14.892599f, -12.453344f, 14.980071f, -12.461419f, 15.014562f, -12.492310f,
                15.041779f, -12.571291f, 15.046677f, -12.576783f
            )
            poly[1297] = TzPolygon(
                15.046677f, -11.839351f, 15.041999f, -11.841888f, 15.046677f, -11.814767f, 15.046677f, -11.805851f, 15.029799f, -11.788766f,
                14.940468f, -11.816436f, 14.895998f, -11.798026f, 14.895221f, -11.824310f, 14.857404f, -11.839836f, 14.826241f, -11.890074f,
                14.820288f, -11.925600f, 15.046677f, -11.925600f
            )
            poly[1298] = TzPolygon(
                15.046677f, -11.805851f, 15.047987f, -11.807176f, 15.046677f, -11.814767f, 15.046677f, -11.839351f, 15.066951f, -11.828358f,
                15.096118f, -11.844549f, 15.139148f, -11.809837f, 15.174081f, -11.837452f, 15.227894f, -11.800597f, 15.320358f, -11.793174f,
                15.346117f, -11.760714f, 15.456213f, -11.745515f, 15.491814f, -11.704350f, 15.537373f, -11.707811f, 15.527248f, -11.616073f,
                15.593398f, -11.546669f, 15.613304f, -11.493382f, 15.640753f, -11.515285f, 15.636065f, -11.409779f, 15.531247f, -11.358859f,
                15.419339f, -11.251729f, 15.231773f, -10.992992f, 15.109710f, -10.900492f, 15.198413f, -10.867003f, 15.214667f, -10.832907f,
                15.285116f, -10.821834f, 15.371172f, -10.715326f, 15.442252f, -10.720920f, 15.420146f, -10.637064f, 15.422110f, -10.575136f,
                15.451214f, -10.518879f, 15.432908f, -10.419483f, 15.443602f, -10.308482f, 15.361625f, -10.064754f, 15.386666f, -9.972053f,
                15.046677f, -9.972053f
            )
            poly[1299] = TzPolygon(
                15.500783f, -7.367323f, 15.501607f, -9.331251f, 15.693527f, -9.309575f, 15.702785f, -9.331025f, 15.605695f, -9.446854f,
                15.438838f, -9.401019f, 15.427097f, -9.685061f, 15.407679f, -9.722090f, 15.419649f, -9.753881f, 15.389191f, -9.799068f,
                15.400078f, -9.922402f, 15.386666f, -9.972053f, 17.407117f, -9.972053f, 17.407117f, -7.367323f
            )
        }
    }

    private object Initializer14 {
        fun init() {
            poly[1300] = TzPolygon(26.529692f, -7.367323f, 27.314942f, -8.668117f, 27.433543f, -8.668212f, 27.433543f, -7.367323f)
            poly[1301] = TzPolygon(
                17.407117f, -16.329951f, 17.480306f, -16.297772f, 17.611813f, -16.266786f, 18.006344f, -16.233667f, 18.234513f, -16.245587f,
                18.431719f, -16.266508f, 18.624067f, -16.334851f, 18.867757f, -16.451646f, 19.187900f, -16.706182f, 19.408228f, -16.793636f,
                19.467184f, -16.771558f, 19.509296f, -16.684400f, 19.560382f, -16.663068f, 19.814459f, -16.667874f, 19.905801f, -16.630899f,
                20.086833f, -16.507886f, 20.195174f, -16.487006f, 20.312378f, -16.561444f, 20.542095f, -16.844342f, 20.565884f, -16.899274f,
                20.562373f, -17.010244f, 20.885333f, -17.068081f, 21.334174f, -16.948486f, 21.336718f, -12.999637f, 22.536674f, -13.083986f,
                22.757513f, -13.150290f, 22.893056f, -13.105278f, 23.024722f, -12.998333f, 23.291389f, -12.571389f, 23.318611f, -12.365833f,
                23.416389f, -12.155833f, 23.454444f, -12.000278f, 26.000000f, -12.000556f, 26.000278f, -8.666944f, 27.314942f, -8.668117f,
                26.529692f, -7.367323f, 17.407117f, -7.367323f
            )
            poly[1302] = TzPolygon(
                48.481700f, -71.405337f, 45.235236f, -71.405337f, 45.238293f, -71.442824f, 45.209630f, -71.405337f, 45.182982f, -71.405337f,
                45.123685f, -71.428400f, 45.070188f, -71.498042f, 45.013446f, -71.501019f, 45.015962f, -73.065362f, 44.991369f, -74.150149f,
                45.006285f, -74.670529f, 44.990472f, -74.730944f, 45.006278f, -74.790449f, 48.481700f, -74.790449f
            )
            poly[1303] = TzPolygon(
                46.047443f, -71.405337f, 46.047443f, -70.287751f, 46.019081f, -70.317997f, 45.995491f, -70.283941f, 45.962992f, -70.315860f,
                45.943945f, -70.239134f, 45.891169f, -70.258804f, 45.795534f, -70.416872f, 45.734570f, -70.383841f, 45.719727f, -70.400350f,
                45.666477f, -70.558582f, 45.569426f, -70.687692f, 45.486473f, -70.716397f, 45.402736f, -70.621269f, 45.377672f, -70.658769f,
                45.428312f, -70.754585f, 45.426508f, -70.798106f, 45.400259f, -70.825744f, 45.365679f, -70.802532f, 45.234620f, -70.838072f,
                45.240326f, -70.895058f, 45.311724f, -70.917836f, 45.347667f, -71.010378f, 45.319239f, -71.008519f, 45.301675f, -71.098211f,
                45.239438f, -71.147568f, 45.249416f, -71.230897f, 45.299144f, -71.296242f, 45.233508f, -71.384144f, 45.235236f, -71.405337f
            )
            poly[1304] = TzPolygon(45.209630f, -71.405337f, 45.203522f, -71.397348f, 45.182982f, -71.405337f)
            poly[1305] = TzPolygon(
                47.235028f, -68.020224f, 47.355301f, -68.234471f, 47.354657f, -68.363132f, 47.287375f, -68.377856f, 47.287115f, -68.580047f,
                47.243373f, -68.617512f, 47.240581f, -68.717016f, 47.177741f, -68.900033f, 47.245011f, -69.040900f, 47.297180f, -69.053466f,
                47.348942f, -68.799628f, 47.427124f, -68.569275f, 47.553199f, -68.383493f, 47.916117f, -68.382334f, 47.916319f, -68.122793f,
                47.999843f, -68.122604f, 47.999863f, -68.020224f
            )
            poly[1306] = TzPolygon(
                46.047443f, -70.287751f, 46.056291f, -70.278316f, 46.064201f, -70.310950f, 46.082369f, -70.301905f, 46.100128f, -70.253113f,
                46.145241f, -70.236282f, 46.191474f, -70.292693f, 46.350225f, -70.191184f, 46.415581f, -70.056503f, 46.695523f, -69.997123f,
                47.459840f, -69.224470f, 47.426784f, -69.043216f, 47.256480f, -69.050745f, 47.177741f, -68.900033f, 47.240581f, -68.717016f,
                47.243373f, -68.617512f, 47.287115f, -68.580047f, 47.287375f, -68.377856f, 47.354657f, -68.363132f, 47.355301f, -68.234471f,
                47.235028f, -68.020224f, 46.047443f, -68.020224f
            )
            poly[1307] = TzPolygon(
                43.592924f, -66.327668f, 43.753000f, -66.440375f, 43.977000f, -66.448826f, 44.032000f, -66.482035f, 44.126000f, -66.632341f,
                44.245000f, -66.677995f, 44.348000f, -66.639733f, 44.448000f, -66.516448f, 44.683322f, -66.327668f
            )
            poly[1308] = TzPolygon(
                45.838850f, -66.327668f, 44.682597f, -66.327668f, 44.482000f, -66.487800f, 44.414000f, -66.580223f, 44.371000f, -66.717744f,
                44.385443f, -66.870965f, 44.322045f, -66.972284f, 44.299667f, -67.100293f, 44.332091f, -67.253941f, 44.359687f, -67.301231f,
                44.393389f, -67.303917f, 44.497000f, -67.251972f, 44.582583f, -67.156944f, 44.624251f, -67.038888f, 44.794192f, -66.885416f,
                44.841611f, -66.974861f, 44.910389f, -66.968722f, 45.162000f, -67.158778f, 45.163417f, -67.227278f, 45.191861f, -67.283361f,
                45.148561f, -67.295208f, 45.125028f, -67.340861f, 45.193472f, -67.429278f, 45.282139f, -67.489667f, 45.377111f, -67.419250f,
                45.486694f, -67.503722f, 45.508361f, -67.463583f, 45.501306f, -67.416222f, 45.602466f, -67.450019f, 45.587683f, -67.519241f,
                45.613339f, -67.645567f, 45.681327f, -67.709572f, 45.688921f, -67.734550f, 45.662640f, -67.727229f, 45.693722f, -67.818111f,
                45.729447f, -67.809721f, 45.731080f, -67.781986f, 45.794406f, -67.806482f, 45.823350f, -67.755318f, 45.838850f, -67.767966f
            )
            poly[1309] = TzPolygon(
                45.628084f, -64.635112f, 45.380000f, -65.130000f, 45.200000f, -65.300000f, 44.830000f, -66.210000f, 44.682597f, -66.327668f,
                45.838850f, -66.327668f, 45.838850f, -64.635112f
            )
            poly[1310] = TzPolygon(
                47.235028f, -68.020224f, 47.199694f, -67.957283f, 47.104403f, -67.882917f, 47.067225f, -67.790198f, 45.943451f, -67.781257f,
                45.917636f, -67.750629f, 45.882897f, -67.803909f, 45.838850f, -67.767966f, 45.838850f, -68.020224f
            )
            poly[1311] = TzPolygon(
                48.128022f, -64.635112f, 47.921103f, -65.111678f, 47.828607f, -65.536139f, 47.933611f, -65.606408f, 48.022234f, -65.858146f,
                48.048998f, -66.160878f, 48.032830f, -66.303484f, 48.089246f, -66.392042f, 48.081750f, -66.487605f, 48.048121f, -66.530069f,
                48.011188f, -66.681820f, 48.029000f, -66.723000f, 48.102200f, -66.756000f, 48.086000f, -66.802000f, 48.007420f, -66.716544f,
                47.984347f, -66.921410f, 47.941403f, -66.964684f, 47.892562f, -66.955300f, 47.935402f, -67.059691f, 47.875655f, -67.210286f,
                47.895801f, -67.348037f, 47.871853f, -67.336695f, 47.843957f, -67.374196f, 47.902781f, -67.481706f, 47.924627f, -67.593550f,
                47.999945f, -67.597744f, 47.999863f, -68.020224f, 48.481700f, -68.020224f, 48.481700f, -64.635112f
            )
            poly[1312] = TzPolygon(
                48.128022f, -64.635112f, 48.220568f, -64.421965f, 48.220564f, -63.791667f, 47.659416f, -63.371080f, 47.070000f, -64.460000f,
                46.690000f, -64.580000f, 46.600000f, -64.560000f, 46.360000f, -64.340000f, 46.229546f, -63.749119f, 46.093097f, -63.614712f,
                46.022532f, -64.025375f, 45.976873f, -64.046892f, 45.975308f, -64.159145f, 45.832613f, -64.278729f, 45.853035f, -64.352043f,
                45.702958f, -64.485751f, 45.628084f, -64.635112f
            )
            poly[1313] = TzPolygon(
                48.128022f, -64.635112f, 48.481700f, -64.635112f, 48.481700f, -61.250000f, 47.658453f, -63.370366f, 48.220564f, -63.791667f,
                48.220568f, -64.421965f
            )
            poly[1314] = TzPolygon(52.133449f, -66.327668f, 52.143261f, -66.352341f, 52.143261f, -66.327668f)
            poly[1315] = TzPolygon(
                52.824650f, -67.173946f, 52.877711f, -67.268533f, 52.877826f, -67.324580f, 52.936666f, -67.351937f, 52.965406f, -67.321476f,
                52.979519f, -67.244521f, 52.996192f, -67.363425f, 53.131979f, -67.385379f, 53.117737f, -67.342758f, 53.181291f, -67.262968f,
                53.149664f, -67.217695f, 53.143461f, -67.173946f
            )
            poly[1316] = TzPolygon(
                52.753522f, -67.173946f, 52.753522f, -67.041611f, 52.747016f, -67.034304f, 52.753522f, -66.990488f, 52.753522f, -66.945563f,
                52.676675f, -66.894772f, 52.674786f, -66.851191f, 52.727457f, -66.897894f, 52.717308f, -66.855992f, 52.753522f, -66.858960f,
                52.753522f, -66.846333f, 52.666249f, -66.764988f, 52.751502f, -66.754059f, 52.753522f, -66.755512f, 52.753522f, -66.327668f,
                52.701124f, -66.327668f, 52.684632f, -66.339085f, 52.671595f, -66.327668f, 52.622572f, -66.327668f, 52.682284f, -66.388657f,
                52.636400f, -66.440276f, 52.552043f, -66.371111f, 52.530897f, -66.368092f, 52.528774f, -66.399214f, 52.473221f, -66.355584f,
                52.476112f, -66.393105f, 52.360415f, -66.344042f, 52.383023f, -66.419876f, 52.341638f, -66.490517f, 52.266174f, -66.432892f,
                52.255655f, -66.470423f, 52.176603f, -66.356840f, 52.152816f, -66.376366f, 52.143261f, -66.352341f, 52.143261f, -67.173946f
            )
            poly[1317] = TzPolygon(52.753522f, -66.327668f, 52.753522f, -66.329376f, 52.858338f, -66.416593f, 52.877483f, -66.379734f, 52.858950f, -66.327668f)
            poly[1318] = TzPolygon(
                52.753522f, -66.846333f, 52.768376f, -66.860178f, 52.753522f, -66.858960f, 52.753522f, -66.945563f, 52.759596f, -66.949578f,
                52.753522f, -66.990488f, 52.753522f, -67.041611f, 52.777738f, -67.068812f, 52.875457f, -67.063151f, 52.854443f, -67.149495f,
                52.817460f, -67.161129f, 52.824650f, -67.173946f, 53.143461f, -67.173946f, 53.137861f, -67.134446f, 53.105112f, -67.116202f,
                53.139549f, -67.048923f, 53.078875f, -67.068491f, 53.084357f, -66.989531f, 53.137110f, -66.958695f, 53.160025f, -67.013530f,
                53.181693f, -66.959617f, 53.290412f, -66.953371f, 53.334646f, -67.027051f, 53.363782f, -67.008405f, 53.363782f, -66.327668f,
                52.973447f, -66.327668f, 53.024773f, -66.370585f, 53.055187f, -66.459532f, 52.946370f, -66.501088f, 52.963955f, -66.520339f,
                52.937000f, -66.570284f, 52.954258f, -66.625868f, 52.897560f, -66.632729f, 52.890326f, -66.663606f, 52.783657f, -66.647410f,
                52.791061f, -66.680504f, 52.763714f, -66.686625f, 52.763576f, -66.719670f, 52.797433f, -66.787109f, 52.753522f, -66.755512f
            )
            poly[1319] = TzPolygon(
                52.133449f, -66.327668f, 52.131818f, -66.323567f, 52.143261f, -66.289254f, 52.143261f, -66.078798f, 52.086571f, -66.092635f,
                52.097770f, -66.066311f, 52.054737f, -65.996196f, 52.056503f, -65.970401f, 52.104636f, -65.961285f, 52.076067f, -65.897710f,
                52.110405f, -65.876989f, 52.118561f, -65.805336f, 52.082871f, -65.733940f, 52.117275f, -65.668256f, 52.080921f, -65.648562f,
                52.007681f, -65.677371f, 51.986809f, -65.650175f, 52.043011f, -65.620542f, 52.044560f, -65.539896f, 52.110453f, -65.499325f,
                52.050206f, -65.496077f, 52.011087f, -65.456185f, 51.965553f, -65.399755f, 51.967345f, -65.371217f, 51.995878f, -65.371224f,
                51.981102f, -65.359087f, 51.942417f, -65.349333f, 51.901895f, -65.399502f, 51.822753f, -65.359760f, 51.870033f, -65.323299f,
                51.873847f, -65.283536f, 51.861475f, -65.253870f, 51.822384f, -65.258890f, 51.822079f, -65.169615f, 51.765620f, -65.180418f,
                51.745972f, -65.091154f, 51.765140f, -65.010035f, 51.714284f, -64.937568f, 51.736670f, -64.909847f, 51.777859f, -64.924675f,
                51.755954f, -64.709751f, 51.707555f, -64.691615f, 51.705033f, -64.639878f, 51.681957f, -64.635112f, 50.922741f, -64.635112f,
                50.922741f, -66.327668f
            )
            poly[1320] = TzPolygon(52.965367f, -66.327668f, 52.869113f, -66.258131f, 52.860135f, -66.294943f, 52.833395f, -66.283550f, 52.853618f, -66.327668f)
            poly[1321] = TzPolygon(52.763965f, -66.327668f, 52.728606f, -66.308644f, 52.701124f, -66.327668f)
            poly[1322] = TzPolygon(52.671595f, -66.327668f, 52.617413f, -66.280219f, 52.604590f, -66.309302f, 52.622572f, -66.327668f)
            poly[1323] = TzPolygon(
                52.143261f, -66.289254f, 52.150369f, -66.267942f, 52.285518f, -66.312569f, 52.310078f, -66.266696f, 52.226990f, -66.200791f,
                52.213465f, -66.172306f, 52.230504f, -66.152103f, 52.198504f, -66.103917f, 52.155030f, -66.075926f, 52.143261f, -66.078798f
            )
            poly[1324] = TzPolygon(
                51.681957f, -64.635112f, 51.628985f, -64.624172f, 51.573897f, -64.548503f, 51.624623f, -64.455327f, 51.676101f, -64.422997f,
                51.665295f, -64.337125f, 51.742294f, -64.274037f, 51.849276f, -64.352703f, 52.005492f, -64.361046f, 51.977960f, -64.237105f,
                52.077649f, -64.291866f, 52.079747f, -64.251538f, 52.143261f, -64.249962f, 52.143261f, -64.246386f, 52.112937f, -64.172987f,
                52.143261f, -64.161810f, 52.143261f, -63.700691f, 52.087616f, -63.702006f, 52.042403f, -63.646380f, 52.084733f, -63.823977f,
                51.997849f, -63.808111f, 51.997391f, -62.942556f, 50.922741f, -62.942556f, 50.922741f, -64.635112f
            )
            poly[1325] = TzPolygon(52.143261f, -64.249962f, 52.144724f, -64.249926f, 52.143261f, -64.246386f)
            poly[1326] = TzPolygon(
                52.143261f, -64.161810f, 52.146011f, -64.160797f, 52.275397f, -64.246561f, 52.284544f, -64.209814f, 52.313028f, -64.216224f,
                52.289698f, -64.191571f, 52.306655f, -64.169456f, 52.363064f, -64.165287f, 52.394057f, -64.109229f, 52.519923f, -64.151949f,
                52.581982f, -64.225699f, 52.603433f, -64.154550f, 52.677627f, -64.170854f, 52.686423f, -64.127658f, 52.732048f, -64.124224f,
                52.726625f, -63.969405f, 52.773962f, -63.872941f, 52.758531f, -63.818975f, 52.770312f, -63.721486f, 52.801530f, -63.717537f,
                52.823760f, -63.644122f, 52.852057f, -63.676560f, 52.844160f, -63.609964f, 52.877406f, -63.619888f, 52.839549f, -63.587062f,
                52.774184f, -63.616533f, 52.713556f, -63.450049f, 52.659363f, -63.383817f, 52.605683f, -63.939727f, 52.568330f, -64.032599f,
                52.466073f, -64.093516f, 52.362590f, -64.012720f, 52.322500f, -63.873214f, 52.313089f, -63.742847f, 52.314028f, -63.837389f,
                52.260655f, -63.751569f, 52.165459f, -63.700166f, 52.143261f, -63.700691f
            )
            poly[1327] = TzPolygon(51.997391f, -62.942556f, 51.996496f, -61.250000f, 50.922741f, -61.250000f, 50.922741f, -62.942556f)
            poly[1328] = TzPolygon(
                46.471002f, -60.089546f, 46.339000f, -59.637405f, 46.142000f, -59.441901f, 46.044000f, -59.405974f, 45.938000f, -59.443552f,
                45.874000f, -59.500373f, 45.788000f, -59.647293f, 45.754000f, -59.779093f, 45.650024f, -59.918258f, 45.834498f, -60.740907f,
                45.802501f, -60.808902f, 45.939339f, -60.811830f, 46.022361f, -60.732968f, 46.127404f, -60.510628f, 46.168666f, -60.480193f,
                46.190290f, -60.505894f, 46.268386f, -60.381191f, 46.360157f, -60.340865f
            )
            poly[1329] = TzPolygon(47.365000f, -59.345249f, 47.242403f, -59.592201f, 47.365000f, -59.784021f)
            poly[1330] = TzPolygon(
                46.774007f, -56.678682f, 46.881415f, -56.678682f, 46.942604f, -56.653363f, 47.033755f, -56.678682f, 47.171604f, -56.678682f,
                47.253553f, -56.618077f, 47.313230f, -56.506593f, 47.365000f, -56.494444f, 47.305278f, -56.255000f, 47.100556f, -56.105000f,
                46.931111f, -56.129722f, 46.860000f, -56.099444f, 46.802778f, -55.982500f, 46.646111f, -55.903333f, 46.577392f, -56.043555f,
                46.550717f, -56.218376f, 46.594849f, -56.449980f, 46.639642f, -56.558567f, 46.738408f, -56.668066f
            )
            poly[1331] = TzPolygon(
                51.998495f, -57.107759f, 51.656451f, -57.105486f, 51.202494f, -57.107482f, 50.998607f, -57.736137f, 49.848605f, -58.940371f,
                48.781380f, -60.476820f, 48.481700f, -61.250000f, 51.996496f, -61.250000f
            )
            poly[1332] = TzPolygon(53.363782f, -55.406679f, 53.200000f, -56.590000f, 51.998495f, -57.107759f, 51.998096f, -61.250000f, 53.363782f, -61.250000f)
            poly[1333] = TzPolygon(48.481700f, -61.250000f, 48.781380f, -60.476820f, 47.761099f, -60.403772f, 47.365000f, -59.784021f, 47.365000f, -61.250000f)
            poly[1334] = TzPolygon(54.007589f, -67.774405f, 54.025702f, -67.821685f, 54.074678f, -67.774405f)
            poly[1335] = TzPolygon(54.103014f, -67.774405f, 54.128133f, -67.810252f, 54.151019f, -67.774405f)
            poly[1336] = TzPolygon(
                62.208265f, -74.790449f, 62.220049f, -74.731981f, 62.257946f, -74.700745f, 62.245660f, -74.479169f, 62.259911f, -74.376778f,
                62.331120f, -74.212596f, 62.357121f, -74.049355f, 62.462082f, -73.839638f, 62.477734f, -73.666557f, 62.386754f, -73.546328f,
                62.386965f, -73.468661f, 62.314991f, -73.186516f, 62.280056f, -73.190567f, 62.180688f, -72.993960f, 62.139980f, -72.870334f,
                62.146900f, -72.712585f, 62.124331f, -72.625533f, 61.950699f, -72.561096f, 61.876296f, -72.219008f, 61.727933f, -72.008509f,
                61.632042f, -71.580627f, 61.569046f, -71.529114f, 61.541618f, -71.790880f, 61.476647f, -71.749608f, 61.428808f, -71.865497f,
                61.393089f, -71.646667f, 61.300360f, -71.713634f, 61.246695f, -71.573455f, 61.215677f, -71.572984f, 61.223445f, -71.438215f,
                61.175274f, -71.397110f, 61.162447f, -71.282427f, 58.184022f, -71.282427f, 58.184022f, -74.790449f
            )
            poly[1337] = TzPolygon(
                59.348181f, -69.528416f, 59.344179f, -69.540332f, 59.348469f, -69.601793f, 59.430955f, -69.605680f, 59.515298f, -69.676903f,
                59.559176f, -69.638768f, 59.596057f, -69.530207f, 59.598596f, -69.528416f
            )
            poly[1338] = TzPolygon(
                59.677762f, -69.528416f, 59.704103f, -69.613299f, 59.757374f, -69.539849f, 59.867412f, -69.530333f, 59.914709f, -69.703269f,
                59.965989f, -69.699671f, 59.976750f, -69.755089f, 60.068988f, -69.836843f, 60.052622f, -69.738541f, 60.083309f, -69.590378f,
                60.198269f, -69.546896f, 60.303639f, -69.750001f, 60.357989f, -69.668099f, 60.419477f, -69.759823f, 60.455689f, -69.716934f,
                60.524921f, -69.803858f, 60.584000f, -69.626946f, 60.594142f, -69.633539f, 60.594142f, -69.528416f
            )
            poly[1339] = TzPolygon(
                59.348181f, -69.528416f, 59.598596f, -69.528416f, 59.663541f, -69.482588f, 59.677762f, -69.528416f, 60.594142f, -69.528416f,
                60.594142f, -67.999997f, 58.587462f, -68.000000f, 58.562488f, -68.124185f, 58.603484f, -68.276148f, 58.693510f, -68.348308f,
                58.771568f, -68.314442f, 58.816117f, -68.338905f, 58.909527f, -68.576449f, 58.927642f, -68.819261f, 58.897339f, -68.912726f,
                58.926950f, -69.169860f, 58.971986f, -69.198538f, 59.057596f, -69.081717f, 59.096402f, -69.147109f, 59.147624f, -69.154980f,
                59.173485f, -69.243692f, 59.143063f, -69.436938f, 59.173478f, -69.481719f, 59.193718f, -69.450983f, 59.188333f, -69.315385f,
                59.221521f, -69.222856f, 59.333672f, -69.236031f, 59.328217f, -69.330338f, 59.372026f, -69.457424f
            )
            poly[1340] = TzPolygon(
                60.594142f, -67.999997f, 60.594142f, -67.774405f, 58.476965f, -67.774405f, 58.481296f, -67.808073f, 58.391117f, -67.867297f,
                58.392427f, -67.924770f, 58.494228f, -67.899203f, 58.587462f, -68.000000f
            )
            poly[1341] = TzPolygon(60.594142f, -67.999997f, 63.004262f, -67.999992f, 63.004262f, -67.774405f, 60.594142f, -67.774405f)
            poly[1342] = TzPolygon(
                61.162447f, -71.282427f, 61.130970f, -71.000996f, 61.058785f, -70.648430f, 61.071313f, -70.428444f, 61.090834f, -70.408829f,
                61.095123f, -70.153435f, 61.064674f, -70.104126f, 60.999833f, -70.140976f, 60.875043f, -70.074499f, 60.812754f, -69.882738f,
                60.889413f, -69.828054f, 60.941060f, -69.675234f, 60.989856f, -69.682991f, 61.083936f, -69.613501f, 61.078110f, -69.512107f,
                60.951823f, -69.432600f, 60.920524f, -69.372846f, 60.807594f, -69.363411f, 60.690578f, -69.696230f, 60.594142f, -69.633539f,
                60.594142f, -71.282427f
            )
            poly[1343] = TzPolygon(
                53.966312f, -67.774405f, 53.966312f, -67.679653f, 53.930284f, -67.669259f, 53.921695f, -67.596306f, 53.869247f, -67.609119f,
                53.841143f, -67.569071f, 53.836691f, -67.497790f, 53.801209f, -67.536033f, 53.795465f, -67.602227f, 53.780289f, -67.557282f,
                53.762699f, -67.603306f, 53.757267f, -67.500000f, 53.728744f, -67.515968f, 53.708883f, -67.465109f, 53.725138f, -67.417791f,
                53.614654f, -67.394731f, 53.584152f, -67.313550f, 53.552965f, -67.318661f, 53.557389f, -67.257406f, 53.530340f, -67.218769f,
                53.553034f, -67.180015f, 53.530209f, -67.129887f, 53.528758f, -67.035928f, 53.496146f, -66.985629f, 53.464240f, -66.995822f,
                53.473137f, -66.937916f, 53.418661f, -66.924448f, 53.414253f, -66.897399f, 53.408405f, -66.897399f, 53.364622f, -66.966103f,
                53.367966f, -67.005727f, 53.363782f, -67.008405f, 53.363782f, -67.774405f
            )
            poly[1344] = TzPolygon(
                54.568842f, -67.774405f, 54.568842f, -67.524326f, 54.527411f, -67.474122f, 54.481507f, -67.500405f, 54.494109f, -67.581658f,
                54.465766f, -67.609474f, 54.509387f, -67.647430f, 54.453842f, -67.667812f, 54.436814f, -67.766965f, 54.386856f, -67.724698f,
                54.350261f, -67.748037f, 54.311924f, -67.679956f, 54.246991f, -67.680828f, 54.195756f, -67.615618f, 54.188575f, -67.653355f,
                54.160807f, -67.644409f, 54.157000f, -67.765037f, 54.151019f, -67.774405f
            )
            poly[1345] = TzPolygon(
                54.568842f, -67.270133f, 54.565173f, -67.268503f, 54.555879f, -67.302704f, 54.519560f, -67.226832f, 54.486629f, -67.272574f,
                54.568842f, -67.455916f
            )
            poly[1346] = TzPolygon(54.103014f, -67.774405f, 54.091580f, -67.758087f, 54.072906f, -67.774405f)
            poly[1347] = TzPolygon(54.004055f, -67.774405f, 53.971910f, -67.681268f, 53.966312f, -67.679653f, 53.966312f, -67.774405f)
            poly[1348] = TzPolygon(53.414253f, -66.897399f, 53.413062f, -66.890091f, 53.408405f, -66.897399f)
            poly[1349] = TzPolygon(54.568842f, -67.524326f, 54.570951f, -67.526882f, 54.584910f, -67.491749f, 54.568842f, -67.455916f)
            poly[1350] = TzPolygon(
                54.568842f, -67.270133f, 54.591792f, -67.280327f, 54.584417f, -67.232833f, 54.615191f, -67.229516f, 54.624539f, -67.138551f,
                54.692933f, -67.062901f, 54.957859f, -67.399756f, 55.062857f, -67.463704f, 55.088633f, -67.409632f, 55.076427f, -67.272812f,
                55.051228f, -67.233979f, 55.024212f, -67.272792f, 54.861948f, -67.033043f, 54.802173f, -66.927045f, 54.816010f, -66.875663f,
                54.711048f, -66.667282f, 54.809081f, -66.739997f, 54.770218f, -66.659428f, 54.813506f, -66.602651f, 55.000017f, -66.765990f,
                54.983873f, -66.625612f, 55.044053f, -66.735038f, 55.090602f, -66.753627f, 55.069517f, -66.694863f, 55.118414f, -66.788673f,
                55.153178f, -66.745729f, 55.214994f, -66.755201f, 55.177485f, -66.670363f, 55.306970f, -66.823726f, 55.355314f, -66.818741f,
                55.312040f, -66.700288f, 55.255145f, -66.658637f, 55.278151f, -66.618035f, 55.195322f, -66.516417f, 55.205107f, -66.495338f,
                54.975469f, -66.246