![Feature graphic](fastlane//metadata/android/en-US/images/featureGraphic.png)

## A private photo album that saves and shares your precious moments
<a href='https://f-droid.org/packages/site.leos.apps.lespas/'><img alt='Get it on F-Droid' src='https://fdroid.gitlab.io/artwork/badge/get-it-on.png' width="150"></a>
<a href='https://github.com/scubajeff/lespas/releases/'><img alt='Get it on Github' src='https://ultrasonic.github.io/assets/img/get-it-on-github.png' width="150"></a>

***Google Play latest developer policy requires the hand-in of the developer's home address. As an open-source, free app developer, I strongly disagree with this. That's why I have terminated my developer account, and the update to Les Pas will no longer be available from Google Play.***

***You can still get the latest version from F-Droid and here on GitHub. The GitHub version has the same app signing key as the Google Play version, hence you will have no problem installing the updates. If you choose the F-Droid update channel, you will need to uninstall the Google Play version first and reinstall from F-Droid. Don't worry, Les Pas has a solid backup/restore mechanism, and your data and settings won't be lost in the process.***


Les Pas, is a free, modern, lightweight and fast gallery app. Organize your photos, GIFs and videos into albums for easy viewing and sharing. With built-in two-way sync with your Nextcloud server, your files are kept private, secure and safe.

Although it use Nextcloud as storage backend, you don't have to install any Nextcloud app on server for Les Pas to function. It's a perfect solution if you have limited knowledge or authorization to alter your Nextcloud configuration.

Features:
- ***Managing, Syncing and Archiving***
    * Organize your media files in albums
    * Support standard media format plus Panorama Photo Sphere, RAW and HDR photos, Google Motion Photo
    * Manage media files in your phone's gallery and auto backup to server, each media folder in your phone has its own backup setting
    * Synchronization works with Nextcloud server and among multiple devices, edit albums on Nextcloud server and on all your mobile devices simultaneously
    * Support Remote Album, which have all its media files stored in Nextcloud server only, freeing up Phone's storage
    * Run on Android TV for big-screen viewing pleasure
    * Integrate with [Snapseed](https://play.google.com/store/apps/details?id=com.niksoftware.snapseed) for photo editing
    * Support adding caption to photo
    * Search for photos by objects with AI
    * Search photos by location
    * Support GPX importing, so that you can easily add GPS location data to pictures shot on your digital camera
    * Support Nextcloud's external storage
    * Beautiful theme inspired by the works of Wes Anderson
- ***Sharing***
    * Share albums and album slideshow with other Nextcloud users, groups and circles
    * Unique 'Joint Album' feature, which you and other Nextcloud users can edit together
    * Export GPX file from album, you can share your adventure with others
- ***Privacy focus***
    * Media files and thumbnails are all saved in App's private storage, stop being scanned by malicious apps
    * Option provided to strip photo's EXIF before sharing to other social networks
    * Option to hide album both in Phone and on server
    * Authenticate on your Nextcloud server with your Nextcloud's credential
    * Opensource
- Any apps that can do the above is merely a media file manager with a fancy UI. Les Pas does not stop here, it strives to provide ways of utilizing your photos. ***The past shouldn't be resting in the hard-drive, make all those memories shine***.
    *  Integrate with <a href=https://github.com/muzei/muzei>Muzei Live Wallpaper</a> app, deliver 'Today in History' pictures right on your phone's desktop
    *  Album slideshow, with background music
    *  Unique 'Slideshow on Map' feature which runs album slideshow on Map
    *  Support photo blogging in three ready-made templates. With the selected pictures and captions you added, you can share your stories with the world. Refer to this [instruction](https://github.com/scubajeff/pico_lespas) for details.


<p float="left">
  <img alt="Welcome Page" title="Welcome Page" src="fastlane/metadata/android/en-US/images/phoneScreenshots/01_Welcome.png" width="200" />
  <img alt="Albums List" title="List of Albums" src="fastlane/metadata/android/en-US/images/phoneScreenshots/02_album.png" width="200" />
  <img alt="Album Detail" title="Album Detail" src="fastlane//metadata/android/en-US/images/phoneScreenshots/03_album_detail.png" width="200" />
  <img alt="Photo Viewer" title="Photo Viewer" src="fastlane//metadata/android/en-US/images/phoneScreenshots/04_photo.png" width="200" />
</p>

<p float="left">
  <img alt="Adding Photo" title="Adding Photos" src="fastlane/metadata/android/en-US/images/phoneScreenshots/05_adding_photos.png" width="200" />
  <img alt="Browsing Camera Roll" title="Manage Device Gallery" src="fastlane/metadata/android/en-US/images/phoneScreenshots/06_device_gallery.png" width="200" />
  <img alt="Publishing Album" title="Publishing Album" src="fastlane//metadata/android/en-US/images/phoneScreenshots/07_publish.png" width="200" />
  <img alt="Search by Objects" title="AI Search" src="fastlane//metadata/android/en-US/images/phoneScreenshots/08_search.png" width="200" />
</p>

<p float="left">
  <img alt="Search by Location" title="Search by Location" src="fastlane/metadata/android/en-US/images/phoneScreenshots/09_by_location.png" width="200" />
  <img alt="Show Album on Map" title="Show Album on Map" src="fastlane/metadata/android/en-US/images/phoneScreenshots/10_in_map.png" width="200" />
  <img alt="Show Photo with Map" title="Show Photo with Map" src="fastlane/metadata/android/en-US/images/phoneScreenshots/11_with_map.png" width="200" />
  <img alt="Manage Photo Blog" title="Manage Photo Blog" src="fastlane/metadata/android/en-US/images/phoneScreenshots/12_blog.png" width="200" />
</p>

<p float="left">
  <img alt="Geotagging with GPX" title="Geotagging with GPX" src="fastlane/metadata/android/en-US/images/phoneScreenshots/13_geotagging.png" width="200" />
  <img alt="Settings" title="Settings" src="fastlane/metadata/android/en-US/images/phoneScreenshots/99_setting.png" width="200" />
</p>

<p float="left">
  <img alt="TV welcome screen" title="TV welcome screen" src="fastlane/metadata/android/en-US/images/tvScreenshots/01_welcome_screen.png" width="800" />
</p>

<p float="left">
  <img alt="TV home screen" title="TV home screen" src="fastlane/metadata/android/en-US/images/tvScreenshots/03_home.png" width="800" />
</p>

<p float="left">
  <img alt="TV meta data" title="TV meta data" src="fastlane/metadata/android/en-US/images/tvScreenshots/05_meta_data.png" width="800" />
</p>

Here is a short video demonstrating how the slideshow on the map works:



https://user-images.githubusercontent.com/458032/176358778-e67fd157-bc3b-4af9-94aa-b18fcd628cc8.mp4


This project is built using the following open-source software:
- <a href=https://square.github.io/okhttp>OkHttp</a>
- <a href=https://github.com/chrisbanes/PhotoView>PhotoView</a>
- <a href=https://github.com/osmdroid/osmdroid>osmdroid</a>
- <a href=https://www.tensorflow.org>TensorFlow</a>
- <a href=https://www.openstreetmap.org>OpenStreetMap</a>
- <a href=https://github.com/hannesa2/panoramagl>Panoramagl</a>

<a id="faq"></a>
## Faq
### Why organize by album?
I believe when someone starts searching his/her memory for a moment in the past, it's hard for him/her to recall the exact date or exact location, but rather easy to remember what was happening during that period of time, like kid's birthday or a family trip to Paris. So, organizing photos by events is probably the best way for most people, therefore grouping photos by event into an album is the best choice.

### Why use folder but not tag to group photos?
Les Pas uses folders to group photos on the server, e.g., each album in Les Pas app has a one-to-one relationship with a folder on your Nextcloud server. You can manage your photo collection by working with folders/files on server side or albums/photos on your phone, Les Pas will sync changes from both sides. But how about tags? Yes, tagging is much more flexible than folders, and Nextcloud has its own file tagging support too. But not every picture format supports tagging, which makes tagging picture file a feature that relies heavily on platform-specific functions. I would like my data (and yours, too) to be platform-neutral instead.

### I have a huge photo collection organized in nested folders, Les Pas only supports a flat folder structure.
There is a very cool [scripts](https://gitlab.com/steviehs/digipics) made by [@steviehs](https://github.com/steviehs) to help you out.

### Why does Les Pas use a lot of storage space?
If you set the album as Local Album, Les Pas stores photos in its app private storage, so if you have a large collection of photos, you will find that it uses a lot of storage space in Android's settings menu.<br>
There are two reasons why Les Pas uses private storage. First, Android introduced Scope Storage Policy recently, highly recommending apps to stay out of the Share Storage Area. Second, storing photos in the app's private storage area can prevent scanning of malicious apps, and uploading your photo secretly in the background. Yes, they love your pictures so much, especially those with your face in them.<br>
**For privacy's sake, stop using "/Pictures" folder in your phone's internal/external storage.**<br><br>
Since release 2.5.0, Les Pas supports managing albums remotely. With Remote Album, all photos and videos' media files are stored in Nextcloud server, which will dramatically reduce the app's storage footprint on mobile devices.<br>

### It's very slow loading photos from the server, and the waiting seems forever.
Nextcloud has a reputation for sluggish image processing. To make Remote Album work, you need to set up Nextcloud [Preview Generator](https://apps.nextcloud.com/apps/previewgenerator) app to automatically generate aspect ratio preview files of size 1024x1024. Here is an [excellent document](https://rayagainstthemachine.net/linux%20administration/nextcloud-photos/) on how to do it. You should make sure Les Pas's specific size is taken into account by:
```
sudo -u www-data php /var/www/html/nextcloud/occ config:app:set --value="256 384 1024" previewgenerator widthSizes
sudo -u www-data php /var/www/html/nextcloud/occ config:app:set --value="256 1024" previewgenerator heightSizes
```

### Why is there no QR code scanning button on the Login screen like in the screenshot?
Les Pas supports scanning QR code of server access token generated by Nextcloud server, by using external QR code scanner apps. This app should be compatible with ZXing, which will expose a standard API for Les Pas to call. Make sure your install a compatible scanner app before your start Les Pas for the first time, then you will see the scanning button.

### How to install on Android TV?
As you know, Les Pas is not hosted on Google Play anymore. To install on Android TV, you need to install f-droid app first and then search and install Les Pas. Or you can download Les Pas's apk, then use tools like [Send files to TV](https://play.google.com/store/apps/details?id=com.yablio.sendfilestotv&hl=en-US) to sideload it.  

### How to navigate on Android TV?
Les Pas supports Android TV since release 2.10. Navigation on home screen is trivial, but it gets a little bit tricky when you start browsing in an album. Here's the cheatsheet

| Key pressed | Action                                                                            |
|-------------|-----------------------------------------------------------------------------------|
| Left, Right | Move to prev, next photo                                                          |
| Select      | Toggle meta data panel on the right                                               |
| Up          | Show caption if any                                                               |
| Down        | If caption is showing, hide caption.                                              |
| Long press on Left or Right | Activate fast scroll                                              |
| Up, Down    | When in fast scroll mode, move to next/prev date if album is sorted by date       |

### About synchronization
Les Pas does two types of sync in the background. A two-way sync of your albums and a one-way backup of your phone's camera roll.<br>
Whenever you do something with your albums on your phone, Les Pas will synchronize the changes to your server immediately. Since Nextcloud's push notification only works with Google Firebase Cloud Messaging, which Les Pas decided not to support due to privacy concerns, any changes you make to your albums on the server side will be synced to your phone during the next synchronization cycle.<br>
Upon opening Les Pas app, it will sync with the server once. If you enable the periodic sync setting, Les Pas will synchronize with your server every 6 hours in the background.<br>
One-way backup of phone's camera roll is a background job that also happens every 6 hours. So don't delete photos from your camera roll too fast too soon.
If synchronization doesn't seem to work, especially when your phone is a Chinese OEM model, like Huawei, Xiaomi, Oppo, etc, please allow Les Pas app to auto start and opt out battery optimization.

### Checklist for enabling sharing on Nextcloud server
To enable publishing (e.g. sharing album with other users on Nextcloud server), there are several things you need to take care of beforehand:
- Make sure you are using LesPas version 2.4.1+ (scroll to the bottom of the Settings page to find out)
- Set up groups on Nextcloud server and add users who wish to share LesPas albums to the group. A user not belong to any group can not download the sharee list from server, this is a limitation of Nextcloud Sharee API
- Optionally, but highly recommended for the sake of a smooth user experience, set up Nextcloud [Preview Generator](https://apps.nextcloud.com/apps/previewgenerator) app to automatically generate aspect ratio preview files of size 1024x1024, LesPas will use those files to populate shared album list on phone.
- Optionally, set up a specific "shared_with_me" folder to house all the shares you received, otherwise, Nextcloud will dump all the shares you received into your root folder. This can be done by adding the line `'share_folder' => 'shared_with_me'` into Nextcloud's `config.php` file. Refer to nextcloud [documentation](https://docs.nextcloud.com/server/latest/admin_manual/configuration_server/config_sample_php_parameters.html) for details. If you don't like Nextcloud's dumping behavior at all, a Nextcloud server app [Mv Shared Pics](https://gitlab.com/frederikb96/nextcloud-mvsharedpics), created by [@frederikb96](https://github.com/frederikb96), can be used to automatically move folders a user received via a share, which contain files with a specific mime type (e.g. pictures) to a configurable destination. This is useful in combination with albums shared via Les Pas since they will be automatically moved to the desired location, such that the default folder where shares are received is kept clean.