#include "toast.h"
#include "color.h"
#include "consts.h"
#include "draw.h"
#include "font.h"
#include "text.h"
#include <SDL3/SDL.h>

Toast toast;

void toast_show(const char *message, float duration) {
	toast = (Toast){message, 2, duration, 0.0f, 1.0f, true};
}

void toast_update(float dt) {
	if (!toast.active) return;

	toast.timer += dt;
	if (toast.timer >= toast.duration) {
		toast.active = false;
		return;
	}

	// Start fading out in the last 1 second
	float remaining = toast.duration - toast.timer;
	toast.alpha = remaining < 1.0f ? remaining : 1.0f;
}

void toast_draw(void) {
	if (!toast.active) return;

	SDL_FRect text_rect = text_calc_rect(toast.message, toast.scale);
	SDL_FRect box_rect = {0, 0, text_rect.w + 24, text_rect.h + 12};

	box_rect.x = (SCREEN_W - box_rect.w) / 2;
	box_rect.y = SCREEN_H * 0.75f - box_rect.h / 2;

	draw_set_blend(true);
	SDL_SetRenderDrawColor(renderer, 13, 13, 13, (toast.alpha * 235));
	draw_fill_rect(&box_rect);
	draw_set_blend(false);

	font_set_color(CLR_WHITE);
	text_draw_shadow_centered(toast.message, &box_rect, toast.scale);
}
