#include "slider.h"
#include "consts.h"
#include "draw.h"
#include "mouse.h"
#include "text.h"

bool calculate_handle_pos(const SDL_Event *ev, Slider *slider) {
	slider->_pos = ev->motion.x - slider->rect.x - ((float)slider->_handle_width/2);
	slider->_pos = SDL_clamp(slider->_pos, 0, slider->rect.w - slider->_handle_width);

	int old_value = slider->value;

	slider->value = slider->min + SDL_round(slider->_pos / ((slider->rect.w - slider->_handle_width) / (slider->max - slider->min)));

	return old_value != slider->value;

	// Trying to make it snap to each integer value...
	//slider->_pos = SDL_round(slider->_pos / ((slider->rect->w - slider->_handle_width) / (slider->max-slider->min)));
	//slider->_pos = slider->_pos * (slider->rect->w / (slider->max-slider->min+1));
}

void slider_init(Slider *slider) {

}

bool slider_event(const SDL_Event *ev, Slider *slider) {

	if (ev->type == SDL_EVENT_MOUSE_BUTTON_DOWN) {
		if (SDL_PointInRectFloat(&POINT(ev->motion.x, ev->motion.y), &slider->rect)) {
			slider->_dragging = true;
			return calculate_handle_pos(ev, slider);
		}
	} else if (ev->type == SDL_EVENT_MOUSE_MOTION) {
		if (slider->_dragging)
			return calculate_handle_pos(ev, slider);

	} else if (ev->type == SDL_EVENT_MOUSE_BUTTON_UP)
		slider->_dragging = false;

	return false;
}

void slider(Slider *slider) {

	SDL_FRect rect = slider->rect;

	slider->_handle_width = rect.w / (slider->max - slider->min);

	draw_set_color(0x2A2A2A);
	draw_fill_rect(&rect);

	SDL_FPoint mouse;
	int clicked = mouse_get_state_scaled(&mouse);

	SDL_FRect handle_rect = {rect.x+slider->_pos, rect.y, slider->_handle_width, rect.h};

	if (SDL_PointInRectFloat(&mouse, &rect)) {
		if (clicked & SDL_BUTTON_MASK(SDL_BUTTON_LEFT))
			draw_box_active(&handle_rect);
		else
			draw_box_hover(&handle_rect);
	} else
		draw_box(&handle_rect);

	FMT_STRING(dbg, 512, "%d", slider->value);
	text_draw(dbg, rect.x + rect.w + 10, rect.y, 2);
}
