#include "debug.h"
#include "color.h"
#include "consts.h"
#include "draw.h"
#include "font.h"
#include "mouse.h"
#include "text.h"
#include <stdbool.h>
#include <stdio.h>

static bool debug = false;

void debug_event(const SDL_Event *ev) {
	if (ev->type == SDL_EVENT_KEY_DOWN && ev->key.scancode == SDL_SCANCODE_F3)
		debug = !debug;

	if (!debug)
		return;

	switch (ev->type) {
		case SDL_EVENT_KEY_DOWN:
			SDL_Log("SDL_KEYDOWN event: Scancode %d, Keycode %d\n", ev->key.scancode, ev->key.key);
			break;
		case SDL_EVENT_KEY_UP:
			SDL_Log("SDL_KEYUP event: Scancode %d, Keycode %d\n", ev->key.scancode, ev->key.key);
			break;
		case SDL_EVENT_MOUSE_BUTTON_DOWN:
			SDL_Log("SDL_MOUSEBUTTONDOWN event: Button %d at (%f, %f)\n", ev->button.button, ev->button.x, ev->button.y);
			break;
		case SDL_EVENT_MOUSE_BUTTON_UP:
			SDL_Log("SDL_MOUSEBUTTONUP event: Button %d at (%f, %f)\n", ev->button.button, ev->button.x, ev->button.y);
			break;
		case SDL_EVENT_MOUSE_MOTION:
			//SDL_Log("SDL_MOUSEMOTION event: Moved to (%f, %f)\n", ev->motion.x, ev->motion.y);
			break;
		default:
			SDL_Log("Other event: %d\n", ev->type);
			break;
	}
}

void debug_draw(void) {
	if (!debug)
		return;

	font_set_color(CLR_WHITE);

	draw_set_color_alpha(0xFFFFFF30);
	draw_set_blend(true);

	int cellSize = 20;

	for (size_t x = 0; x < SCREEN_W; x += cellSize)
		draw_line(x, 0, x, SCREEN_H);

	for (size_t y = 0; y < SCREEN_H; y += cellSize)
		draw_line(0, y, SCREEN_W, y);

	SDL_FPoint mouse;
	mouse_get_state_scaled(&mouse);
	draw_set_color(0xFFFF00);
	draw_line(mouse.x, 0, mouse.x, SCREEN_H);
	draw_line(0, mouse.y, SCREEN_W, mouse.y);

	FMT_STRING(text, 1024, "%s, using %s driver, cursor pos (%f,%f)",
		SDL_GetPlatform(), SDL_GetRendererName(renderer), mouse.x, mouse.y);
	text_draw_shadow(text, 0, 0, 1);
}
