
set(DEP_SDL_MIXER_VER "6cdf58a7918f588031366c8c960f8015cc8202bb")
download_dep_tarball(
	"SDL_mixer"
	"${DEP_SDL_MIXER_VER}"
	"https://github.com/libsdl-org/SDL_mixer/archive/${DEP_SDL_MIXER_VER}.tar.gz"
	"eae9bbe567ebbcf1c7ec5298bdbbe0c64d409ce1ba00fe69d02f799ddf3452e4"
)

file(REMOVE_RECURSE "${CMAKE_SOURCE_DIR}/lib/SDL_mixer/external/libxmp")
file(CREATE_LINK
	"${CMAKE_SOURCE_DIR}/lib/libxmp"
	"${CMAKE_SOURCE_DIR}/lib/SDL_mixer/external/libxmp"
	SYMBOLIC
)

set(BUILD_SHARED_LIBS OFF CACHE BOOL "" FORCE)

foreach(feature AIFF AU FLAC_DRFLAC FLAC_LIBFLAC GME MIDI_FLUIDSYNTH MIDI_TIMIDITY MP3_DRMP3 MP3_MPG123 OPUS VOC VORBIS_TREMOR VORBIS_VORBISFILE WAVPACK WAVPACK_DSD SAMPLES)
	set(SDLMIXER_${feature} OFF CACHE BOOL "" FORCE)
endforeach()

set(SDLMIXER_MOD_XMP ON CACHE BOOL "" FORCE)
set(SDLMIXER_MOD_XMP_SHARED OFF CACHE BOOL "" FORCE)
set(SDLMIXER_VENDORED ON CACHE BOOL "" FORCE)

add_subdirectory(lib/SDL_mixer EXCLUDE_FROM_ALL)
