/* eslint-disable sort-keys */
/**
 * Official Emojibase emoticons list.
 *
 * NAMING GUIDELINES
 *
 *  - Only 1 emoticon per emoji. There's enough emoji
 *    to go around, so no need to stack multiple
 *    emoticons on a single emoji.
 *
 *  - Only use ")" and "(" when dealing with happy
 *    and sad emoticons. The equivalent bracket and
 *    curly brace variants are automatically generated.
 *
 *  - Only use "/". The opposite "\" variant is
 *    automatically generated.
 *
 *  - Only use ":" for eyes. The alternate "=" variant
 *    is automatically generated.
 *
 *  - Lowercase all letters excluding "D". Uppercase
 *    variants are automatically generated.
 */

import type { EmoticonMap } from '../types';

export const emoticons: EmoticonMap = {
  // HAPPY
  // 🙂 slightly smiling face
  '1F642': ':)',
  // 😄 grinning face
  '1F604': ':D',
  // 😊 smiling face with smiling eyes
  '1F60A': ':>',
  // 😉 winking face
  '1F609': ';)',
  // 😎 smiling face with sunglasses
  '1F60E': '8)',
  // 😬 grimacing face
  '1F62C': '8D',
  // 😇 smiling face with halo
  '1F607': ['o:)', 'O:)'],
  // 😈 smiling face with horns
  '1F608': '>:)',

  // PLAYFUL
  // 😂 face with tears of joy
  '1F602': ":')",
  // 🤣 rolling on the floor laughing
  '1F923': ":'D",
  // 😆 smiling face with open mouth & closed eyes
  '1F606': ['xD', 'XD'],
  // 😛 face with stuck-out tongue
  '1F61B': [':p', ':P'],
  // 😜 face with stuck-out tongue & winking eye
  '1F61C': [';p', ';P'],
  // 😝 face with stuck-out tongue & closed eyes
  '1F61D': ['xp', 'xP', 'XP'],
  // 😏 smirking face
  '1F60F': ':j',

  // FLIRTY
  // 😽 kissing cat face with closed eyes
  '1F63D': ':3',
  // 😚 kissing face with closed eyes
  '1F61A': ':*',
  // 😘 face blowing a kiss
  '1F618': [':x', ':X'],

  // NEUTRAL
  // 😐️ neutral face
  '1F610': ':|',
  // 😕 confused face
  '1F615': ':/',
  // 😒 unamused face
  '1F612': ':?',
  // 😓 face with cold sweat
  '1F613': ':<',
  // 🤐 zipper-mouth face
  '1F910': [':z', ':Z'],

  // SAD
  // 🙁 frowning face
  '2639': ':(',
  // 😧 anguished face
  '1F627': [':s', ':S'],
  // 😖 confounded face
  '1F616': ['x(', 'X('],
  // 😢 crying face
  '1F622': ":'(",
  // 😭 loudly crying face
  '1F62D': ":'o",
  // 😩 weary face
  '1F629': 'D:',
  // 😱 face screaming in fear
  '1F631': 'Dx',
  // 😡 pouting face
  '1F621': '>:/',
  // 👿 angry face with horns
  '1F47F': '>:(',
  // 😫 tired face
  '1F62B': [':c', ':C'],
  // woozy face
  '1F974': ':&',

  // MISC
  // 🤔 thinking face
  '1F914': [':l', ':L'],
  // 😲 astonished face
  '1F632': [':o', ':O'],
  // 😵 dizzy face
  '1F635': ['xo', 'XO'],
  // 🤬 face with symbols over mouth
  '1F92C': ':@',
  // 🤢 nauseated face
  '1F922': '%(',
  // 😳 flushed face
  '1F633': ':$',
  // 😶 face without mouth
  '1F636': ':#',

  // SPECIAL
  // 🤓 nerd face
  '1F913': ':B',
  // 🧙‍♂️ man mage
  '1F9D9-200D-2642-FE0F': ':{>',
  // 🧛 vampire
  '1F9DB': ':E',
  // 🧟 zombie
  '1F9DF': '8#',
  // 👹 ogre
  '1F479': '>0)',

  // SYMBOLS
  // ❤️ red heart
  '2764': '<3',
  // 💔 broken heart
  '1F494': '</3',
  // 🤘 sign of the horns
  '1F918': [String.raw`\m/`, String.raw`\M/`],
};
