VERSION 5.00
Begin VB.Form ATest 
   Caption         =   "SDL2 Mixer Ext test"
   ClientHeight    =   5055
   ClientLeft      =   5490
   ClientTop       =   5460
   ClientWidth     =   5130
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   8.25
      Charset         =   204
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "ATest.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5055
   ScaleWidth      =   5130
   Begin VB.CommandButton UnloadSFXes 
      Caption         =   "Unload SFX-es"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2040
      TabIndex        =   23
      Top             =   3000
      Width           =   1695
   End
   Begin VB.CommandButton ShutUpSFX 
      Caption         =   "Shut UP!"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1560
      TabIndex        =   22
      Top             =   4560
      Width           =   1815
   End
   Begin VB.CommandButton sfx4a 
      Caption         =   "4"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3000
      TabIndex        =   21
      Top             =   4080
      Width           =   375
   End
   Begin VB.CommandButton sfx3a 
      Caption         =   "3"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2520
      TabIndex        =   20
      Top             =   4080
      Width           =   375
   End
   Begin VB.CommandButton sfx2a 
      Caption         =   "2"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2040
      TabIndex        =   19
      Top             =   4080
      Width           =   375
   End
   Begin VB.CommandButton sfx1a 
      Caption         =   "1"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1560
      TabIndex        =   18
      Top             =   4080
      Width           =   375
   End
   Begin VB.CommandButton sfx4n 
      Caption         =   "4"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3000
      TabIndex        =   17
      Top             =   3600
      Width           =   375
   End
   Begin VB.CommandButton sfx3n 
      Caption         =   "3"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2520
      TabIndex        =   16
      Top             =   3600
      Width           =   375
   End
   Begin VB.CommandButton sfx2n 
      Caption         =   "2"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2040
      TabIndex        =   15
      Top             =   3600
      Width           =   375
   End
   Begin VB.CommandButton sfx1n 
      Caption         =   "1"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1560
      TabIndex        =   14
      Top             =   3600
      Width           =   375
   End
   Begin VB.CommandButton InitChunks 
      Caption         =   "Load SFX-es"
      Height          =   375
      Left            =   240
      TabIndex        =   11
      Top             =   3000
      Width           =   1455
   End
   Begin VB.CommandButton FadeOut2 
      Caption         =   "Fade Out"
      Height          =   375
      Left            =   3840
      TabIndex        =   9
      Top             =   2040
      Width           =   735
   End
   Begin VB.CommandButton FadeOut1 
      Caption         =   "Fade Out"
      Height          =   375
      Left            =   3840
      TabIndex        =   8
      Top             =   1560
      Width           =   735
   End
   Begin VB.CommandButton FadeIn2 
      Caption         =   "Fade IN"
      Height          =   375
      Left            =   3000
      TabIndex        =   7
      Top             =   2040
      Width           =   735
   End
   Begin VB.CommandButton FadeIn1 
      Caption         =   "Fade IN"
      Height          =   375
      Left            =   3000
      TabIndex        =   6
      Top             =   1560
      Width           =   735
   End
   Begin VB.CommandButton PlayMus2 
      Caption         =   "Play iceow_2.mid music"
      Height          =   375
      Left            =   240
      TabIndex        =   5
      Top             =   2040
      Width           =   2655
   End
   Begin VB.CommandButton Pause 
      Caption         =   "Pause"
      Height          =   375
      Left            =   1800
      TabIndex        =   4
      Top             =   360
      Width           =   1335
   End
   Begin VB.HScrollBar Volume 
      Height          =   255
      Left            =   240
      Max             =   128
      TabIndex        =   2
      Top             =   1200
      Value           =   64
      Width           =   4095
   End
   Begin VB.CommandButton Stop 
      Caption         =   "Stop"
      Height          =   375
      Left            =   3240
      TabIndex        =   1
      Top             =   360
      Width           =   1335
   End
   Begin VB.CommandButton PlayMus1 
      Caption         =   "Play spy_game.spc music"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   1560
      Width           =   2655
   End
   Begin VB.Label Label6 
      Caption         =   "(Try to spam those buttons with lots of clicks and you will feel difference!)"
      Height          =   855
      Left            =   3480
      TabIndex        =   25
      Top             =   3600
      Width           =   1575
   End
   Begin VB.Label Label5 
      Caption         =   "MUSIC"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   24
      Top             =   0
      Width           =   1575
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Any Free"
      Height          =   375
      Left            =   120
      TabIndex        =   13
      Top             =   4080
      Width           =   1335
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Single channel"
      Height          =   375
      Left            =   360
      TabIndex        =   12
      Top             =   3600
      Width           =   1095
   End
   Begin VB.Label LAbel2 
      Caption         =   "SFX Chunks"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   10
      Top             =   2640
      Width           =   3375
   End
   Begin VB.Label Label1 
      Caption         =   "Music volume"
      Height          =   375
      Left            =   240
      TabIndex        =   3
      Top             =   840
      Width           =   3135
   End
End
Attribute VB_Name = "ATest"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim music As Long  'Long here is equivalent of C's Mix_Music* pointer

Dim sfx_are_loaded As Boolean
Dim mysfx1 As Long 'Long here is equivalent of C's Mix_Chunk* pointer
Dim mysfx2 As Long
Dim mysfx3 As Long
Dim mysfx4 As Long


Private Sub Form_Load()
    sfx_are_loaded = False
    mysfx1 = 0
    mysfx2 = 0
    mysfx3 = 0
    mysfx4 = 0
    If SDL_InitAudio < 0 Then         'Initialize SDL Library first
        MsgBox "SDL Error: " & SDL_GetError, vbOKOnly + vbExclamation
        Exit Sub
    End If
    Mix_Init '0                                   'Init SDL Mixer itself
    Mix_OpenAudio 44100, AUDIO_S16LSB, 2, 2048   'Init Open audio stream
    Mix_VolumeMusic Me.Volume.Value                'Set current volume
    ' Use custom bank file in ADLMIDI
    ' (Can be changed while runtime, result appears after song reopen)
    Mix_ADLMIDI_setCustomBankFile "./example_media/Wolfinstein.wopl"
End Sub

Private Sub Form_Unload(Cancel As Integer)
    If sfx_are_loaded Then ' Unload SFXes if there are loaded
        Mix_FreeChunk mysfx1
        Mix_FreeChunk mysfx2
        Mix_FreeChunk mysfx3
        Mix_FreeChunk mysfx4
    End If
    Mix_CloseAudio
    Mix_Quit
    SDL_Quit
End Sub


Private Sub FadeIn1_Click()
    Me.Pause.Caption = "Pause"
    
    'Loading of a music track
    Mix_HaltMusic 'Stop previous
    Mix_FreeMusic music                 'Destroy previous
    music = Mix_LoadMUS("example_media/spy_game.spc")
    
    Mix_FadeInMusic music, -1, 3000
End Sub

Private Sub FadeIn2_Click()
    Me.Pause.Caption = "Pause"
    
    'Loading of a music track
    Mix_HaltMusic 'Stop previous
    Mix_FreeMusic music                 'Destroy previous
    music = Mix_LoadMUS("example_media/iceow_2.mid")
    
    Mix_FadeInMusic music, -1, 3000
End Sub

Private Sub FadeOut1_Click()
    Mix_FadeOutMusic 3000   'Trigger fadeout
End Sub

Private Sub FadeOut2_Click()
    Mix_FadeOutMusic 3000   'Trigger fadeout
End Sub




Private Sub Pause_Click()
    If Mix_PlayingMusic = 1 And Mix_PausedMusic = 0 Then
        Mix_PauseMusic
        Me.Pause.Caption = "Resume"
    ElseIf Mix_PausedMusic = 1 Then
        Mix_ResumeMusic
        Me.Pause.Caption = "Pause"
    End If
End Sub

Private Sub PlayMus1_Click()
    Me.Pause.Caption = "Pause"
    'Loading of a music track
    Mix_HaltMusic                       'Stop previous
    Mix_FreeMusic music
    music = Mix_LoadMUS("example_media/spy_game.spc") 'Open new music
    'Starting of music playback
    Mix_PlayMusic music, -1
End Sub

Private Sub PlayMus2_Click()
    Me.Pause.Caption = "Pause"
    'Loading of a music track
    Mix_HaltMusic                       'Stop previous
    Mix_FreeMusic music                 'Destroy previous
    music = Mix_LoadMUS("example_media/iceow_2.mid")  'Open new music
    'Starting of music playback
    Mix_PlayMusic music, -1
End Sub

Private Sub sfx1a_Click()
    Mix_PlayChannelVol -1, mysfx1, 0, 128
End Sub

Private Sub sfx1n_Click()
    Mix_PlayChannelVol 0, mysfx1, 0, 12
End Sub

Private Sub sfx2a_Click()
    Mix_PlayChannel -1, mysfx2, 0
End Sub

Private Sub sfx2n_Click()
    Mix_PlayChannel 1, mysfx2, 0
End Sub

Private Sub sfx3a_Click()
    Mix_PlayChannel -1, mysfx3, 0
End Sub

Private Sub sfx3n_Click()
    Mix_PlayChannel 2, mysfx3, 0
End Sub

Private Sub sfx4a_Click()
    Mix_PlayChannel -1, mysfx4, 0
End Sub

Private Sub sfx4n_Click()
    Mix_PlayChannel 3, mysfx4, 0
End Sub

Private Sub ShutUpSFX_Click()
    Mix_HaltChannel -1 ' Halt all SFX-es!
End Sub

Private Sub Stop_Click()
    Me.Pause.Caption = "Pause"
    Mix_HaltMusic
End Sub

Private Sub Volume_Change()
    Mix_VolumeMusic Me.Volume.Value
End Sub


Private Sub InitChunks_Click()
    mysfx1 = 0
    Dim rwops As Long
    mysfx1 = Mix_LoadWAV("example_media/grab.ogg")
    mysfx2 = Mix_LoadWAV("example_media/climbing.ogg")
    mysfx3 = Mix_LoadWAV("example_media/smash.ogg")
    mysfx4 = Mix_LoadWAV("example_media/coin.ogg")
    
    Mix_AllocateChannels 32 'Totally 32 channels for everything, include mixed repeating playback
    Mix_ReserveChannels 4   'Reserve 4 channels for non-merging playback

    sfx_are_loaded = True
    
    Me.InitChunks.Enabled = False
    Me.UnloadSFXes.Enabled = True
    Me.sfx1a.Enabled = True
    Me.sfx2a.Enabled = True
    Me.sfx3a.Enabled = True
    Me.sfx4a.Enabled = True
    Me.sfx1n.Enabled = True
    Me.sfx2n.Enabled = True
    Me.sfx3n.Enabled = True
    Me.sfx4n.Enabled = True
    Me.ShutUpSFX.Enabled = True
End Sub

Private Sub UnloadSFXes_Click()
    
    Mix_FreeChunk mysfx1
    mysfx1 = 0
    Mix_FreeChunk mysfx2
    mysfx2 = 0
    Mix_FreeChunk mysfx3
    mysfx3 = 0
    Mix_FreeChunk mysfx4
    mysfx4 = 0
    
    Mix_AllocateChannels 0
    
    Me.InitChunks.Enabled = True
    Me.UnloadSFXes.Enabled = False
    Me.sfx1a.Enabled = False
    Me.sfx2a.Enabled = False
    Me.sfx3a.Enabled = False
    Me.sfx4a.Enabled = False
    Me.sfx1n.Enabled = False
    Me.sfx2n.Enabled = False
    Me.sfx3n.Enabled = False
    Me.sfx4n.Enabled = False
    Me.ShutUpSFX.Enabled = False
End Sub

