/*
 * TheXTech - A platform game engine ported from old source code for VB6
 *
 * Copyright (c) 2009-2011 Andrew Spinks, original VB6 code
 * Copyright (c) 2020-2025 Vitaly Novichkov <admin@wohlnet.ru>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "sdl_proxy/mixer.h"

#include "../sound.h"
#include "sound_msgsnd.h"

extern bool g_mixerLoaded;

static unsigned char s_sndGlas[] =
{
    0x4d, 0x54, 0x68, 0x64, 0x00, 0x00, 0x00, 0x06, 0x00, 0x01, 0x00, 0x05,
    0x03, 0xc0, 0x4d, 0x54, 0x72, 0x6b, 0x00, 0x00, 0x00, 0x57, 0x00, 0xff,
    0x03, 0x08, 0x75, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x00, 0xff,
    0x02, 0x1a, 0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20,
    0xa9, 0x20, 0x32, 0x30, 0x30, 0x31, 0x20, 0x62, 0x79, 0x20, 0x3c, 0x6e,
    0x61, 0x6d, 0x65, 0x3e, 0x00, 0xff, 0x01, 0x10, 0x56, 0x69, 0x74, 0x61,
    0x6c, 0x79, 0x20, 0x4e, 0x6f, 0x76, 0x69, 0x63, 0x68, 0x6b, 0x6f, 0x76,
    0x00, 0xff, 0x58, 0x04, 0x04, 0x02, 0x18, 0x08, 0x00, 0xff, 0x59, 0x02,
    0x00, 0x00, 0x00, 0xff, 0x51, 0x03, 0x09, 0x27, 0xc0, 0x00, 0xff, 0x2f,
    0x00, 0x4d, 0x54, 0x72, 0x6b, 0x00, 0x00, 0x00, 0x1b, 0x00, 0xc0, 0x74,
    0x00, 0x90, 0x28, 0x64, 0x00, 0x27, 0x64, 0x00, 0x25, 0x64, 0x87, 0x40,
    0x25, 0x00, 0x00, 0x27, 0x00, 0x00, 0x28, 0x00, 0x00, 0xff, 0x2f, 0x00,
    0x4d, 0x54, 0x72, 0x6b, 0x00, 0x00, 0x00, 0x1b, 0x00, 0xc1, 0x7f, 0x00,
    0x91, 0x44, 0x64, 0x00, 0x40, 0x64, 0x00, 0x37, 0x64, 0x87, 0x40, 0x37,
    0x00, 0x00, 0x40, 0x00, 0x00, 0x44, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x4d,
    0x54, 0x72, 0x6b, 0x00, 0x00, 0x01, 0x66, 0x00, 0xc2, 0x71, 0x00, 0x92,
    0x66, 0x7f, 0x00, 0x61, 0x7f, 0x00, 0x57, 0x7f, 0x00, 0x58, 0x7f, 0x00,
    0x5a, 0x7f, 0x00, 0x55, 0x7f, 0x00, 0x64, 0x7f, 0x00, 0x60, 0x7f, 0x00,
    0x5d, 0x7f, 0x00, 0x6a, 0x7f, 0x26, 0x63, 0x67, 0x1a, 0x5f, 0x68, 0x19,
    0x5c, 0x6a, 0x1f, 0x55, 0x00, 0x00, 0x58, 0x00, 0x00, 0x66, 0x00, 0x00,
    0x57, 0x00, 0x00, 0x5a, 0x00, 0x00, 0x61, 0x00, 0x00, 0x5e, 0x6b, 0x00,
    0x62, 0x6b, 0x26, 0x63, 0x00, 0x1a, 0x5f, 0x00, 0x19, 0x5c, 0x00, 0x1f,
    0x5e, 0x00, 0x00, 0x62, 0x00, 0x00, 0x5f, 0x62, 0x00, 0x5b, 0x62, 0x00,
    0x65, 0x62, 0x78, 0x65, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x5b, 0x00, 0x00,
    0x66, 0x69, 0x24, 0x5e, 0x69, 0x1a, 0x62, 0x69, 0x3a, 0x66, 0x00, 0x00,
    0x61, 0x70, 0x00, 0x63, 0x70, 0x24, 0x5e, 0x00, 0x1a, 0x62, 0x00, 0x2e,
    0x58, 0x73, 0x0c, 0x63, 0x00, 0x00, 0x61, 0x00, 0x00, 0x5c, 0x35, 0x00,
    0x60, 0x35, 0x28, 0x5e, 0x01, 0x19, 0x66, 0x01, 0x2b, 0x58, 0x00, 0x08,
    0x5f, 0x01, 0x04, 0x60, 0x00, 0x00, 0x5c, 0x00, 0x28, 0x5e, 0x00, 0x19,
    0x66, 0x00, 0x33, 0x5f, 0x00, 0x04, 0x66, 0x18, 0x00, 0x62, 0x18, 0x6b,
    0x57, 0x45, 0x0d, 0x62, 0x00, 0x00, 0x60, 0x00, 0x00, 0x5d, 0x00, 0x00,
    0x64, 0x00, 0x00, 0x6a, 0x00, 0x00, 0x66, 0x00, 0x40, 0x60, 0x1a, 0x19,
    0x5d, 0x4e, 0x12, 0x57, 0x00, 0x3b, 0x62, 0x67, 0x12, 0x60, 0x00, 0x19,
    0x5d, 0x00, 0x1f, 0x60, 0x67, 0x00, 0x63, 0x67, 0x2e, 0x62, 0x00, 0x4a,
    0x63, 0x00, 0x00, 0x60, 0x00, 0x3e, 0x5a, 0x43, 0x10, 0x5f, 0x66, 0x00,
    0x65, 0x66, 0x00, 0x60, 0x66, 0x56, 0x5d, 0x59, 0x12, 0x5a, 0x00, 0x10,
    0x60, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x65, 0x00, 0x2a, 0x63, 0x2c, 0x00,
    0x61, 0x2c, 0x0e, 0x5f, 0x7f, 0x1e, 0x5d, 0x00, 0x4c, 0x63, 0x00, 0x00,
    0x61, 0x00, 0x0e, 0x5f, 0x00, 0x62, 0x61, 0x70, 0x78, 0x61, 0x00, 0x08,
    0x5d, 0x2f, 0x00, 0x62, 0x2f, 0x78, 0x62, 0x00, 0x00, 0x5d, 0x00, 0x00,
    0x5f, 0x6d, 0x54, 0x62, 0x77, 0x24, 0x5f, 0x00, 0x1c, 0x64, 0x7c, 0x38,
    0x62, 0x00, 0x40, 0x64, 0x00, 0x5c, 0x5e, 0x64, 0x13, 0x5f, 0x5d, 0x26,
    0x62, 0x76, 0x3f, 0x5e, 0x00, 0x13, 0x5f, 0x00, 0x26, 0x62, 0x00, 0x08,
    0x62, 0x65, 0x78, 0x62, 0x00, 0x81, 0x62, 0x5e, 0x36, 0x00, 0x62, 0x36,
    0x78, 0x62, 0x00, 0x00, 0x5e, 0x00, 0x81, 0x2e, 0x5e, 0x2b, 0x78, 0x5e,
    0x00, 0x00, 0xff, 0x2f, 0x00, 0x4d, 0x54, 0x72, 0x6b, 0x00, 0x00, 0x00,
    0x04, 0x00, 0xff, 0x2f, 0x00,
    0x00
};

static unsigned char s_sndMsg[] =
{
    0x4d, 0x54, 0x68, 0x64, 0x00, 0x00, 0x00, 0x06, 0x00, 0x01, 0x00, 0x03,
    0x03, 0xc0, 0x4d, 0x54, 0x72, 0x6b, 0x00, 0x00, 0x00, 0x57, 0x00, 0xff,
    0x03, 0x08, 0x75, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x00, 0xff,
    0x02, 0x1a, 0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20,
    0xa9, 0x20, 0x32, 0x30, 0x30, 0x31, 0x20, 0x62, 0x79, 0x20, 0x3c, 0x6e,
    0x61, 0x6d, 0x65, 0x3e, 0x00, 0xff, 0x01, 0x10, 0x56, 0x69, 0x74, 0x61,
    0x6c, 0x79, 0x20, 0x4e, 0x6f, 0x76, 0x69, 0x63, 0x68, 0x6b, 0x6f, 0x76,
    0x00, 0xff, 0x58, 0x04, 0x04, 0x02, 0x18, 0x08, 0x00, 0xff, 0x59, 0x02,
    0x00, 0x00, 0x00, 0xff, 0x51, 0x03, 0x06, 0x8a, 0x1b, 0x00, 0xff, 0x2f,
    0x00, 0x4d, 0x54, 0x72, 0x6b, 0x00, 0x00, 0x00, 0x22, 0x00, 0xc0, 0x0a,
    0x00, 0x90, 0x48, 0x64, 0x00, 0x54, 0x64, 0x87, 0x40, 0x48, 0x64, 0x00,
    0x3c, 0x64, 0x88, 0x38, 0x54, 0x00, 0x00, 0x48, 0x00, 0x78, 0x48, 0x00,
    0x00, 0x3c, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x4d, 0x54, 0x72, 0x6b, 0x00,
    0x00, 0x00, 0x04, 0x00, 0xff, 0x2f, 0x00,
    0x00
};

#ifndef CUSTOM_AUDIO
void playFallbackSfx(int sfxId, int loops, int volume)
{
    if(!g_mixerLoaded)
        return;

    SDL_RWops *sfx = nullptr;

    switch(sfxId)
    {
    case SFX_Message:
        sfx = SDL_RWFromConstMem(s_sndMsg, sizeof(s_sndMsg));
        break;
    case SFX_SMGlass:
        sfx = SDL_RWFromConstMem(s_sndGlas, sizeof(s_sndGlas));
        break;
    }

    if(sfx)
    {
        Mix_Music *sfxF = Mix_LoadMUS_RW_ARG(sfx, 1, "s0;b58;e0;c1;");
        if(!sfxF)
        {
            SDL_RWclose(sfx);
            return;
        }

        Mix_VolumeMusicStream(sfxF, volume);
        Mix_PlayMusicStream(sfxF, loops + 1);
        Mix_SetFreeOnStop(sfxF, 1);
    }
}
#else
void playFallbackSfx(int, int, int) {}
#endif
