/*
 * TheXTech - A platform game engine ported from old source code for VB6
 *
 * Copyright (c) 2009-2011 Andrew Spinks, original VB6 code
 * Copyright (c) 2020-2025 Vitaly Novichkov <admin@wohlnet.ru>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// this module handles the control recording and playback functions
// and the gameplay stats recording functions

#pragma once
#ifndef RECORD_H
#define RECORD_H

#include <string>

namespace Record
{

// public to allow other systems to spy on status of the Record system
extern FILE* record_file;
extern FILE* replay_file;

void LoadReplay(const std::string &recording_path, const std::string &level_path);

void InitRecording();

void Sync();

void EndRecording();

} // namespace Record

#endif // #ifndef RECORD_H
