/*
 * Moondust, a free game engine for platform game making
 * Copyright (c) 2014-2025 Vitaly Novichkov <admin@wohlnet.ru>
 *
 * This software is licensed under a dual license system (MIT or GPL version 3 or later).
 * This means you are free to choose with which of both licenses (MIT or GPL version 3 or later)
 * you want to use this software.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You can see text of MIT license in the LICENSE.mit file you can see in Engine folder,
 * or see https://mit-license.org/.
 *
 * You can see text of GPLv3 license in the LICENSE.gpl3 file you can see in Engine folder,
 * or see <http://www.gnu.org/licenses/>.
 */

#ifndef CRASHHANDLER_H
#define CRASHHANDLER_H

#include <string>

class CrashHandler
{
public:
    CrashHandler() = default;
    typedef void (*MsgBoxHook_t)(const std::string &title, const std::string &message);
    static void setCrashMsgBoxHook(MsgBoxHook_t hook);
    static void crashByUnhandledException();
    static void crashByFlood();
    static void initSigs();
#ifndef THEXTECH_NO_SDL_BUILD
    static void logAssertInfo(const void *data);
#endif
    static void logAssertInfo(const char *condition, const char *file, const char *func, int line_number);
};

#endif // CRASHHANDLER_H
