<p align="center">
<a href="https://github.com/Wohlstand/TheXTech/releases"><img src="https://raw.githubusercontent.com/Wohlstand/TheXTech/master/resources/icon/thextech_512.png" alt="TheXTech"></a>
</p>

# TheXTech

SMBX-движок, переписанный на C++ с VisualBasic 6

| <!-- -->      | <!-- -->        | <!-- -->      |
|:-------------:|:---------------:|:-------------:|
| [English](README.md) | Русский | [Español](README.ESP.md) |

-----------


# Часто задаваемые вопросы

## Что это такое?
Это прямое продолжение старого движка SMBX 1.3. Изначально движок был написан на VB6 под Windows, а позже был портирован/переписан на C++: и с тех пор движок стал кросс-платформенным. Он полностью повторяет старый движок (кроме редактора), включая множество логических багов (часть багов была исправлена, первым делом те, которые ломают игру), а также содержит множество обновлений и новых возможностей.


## Зачем ты это сделал?
Зачем? У меня имеется несколько целей, почему я это сделал:
- Это - очень удобная живая модель для исследований, которую я хочу использовать для разработки Moondust-движка.
- Чтобы предоставить полностью совместимую со старым SMBX-движком игру для современных платформ, чтобы можно было играть старые уровни и эпизоды, сохранив первозданную атмосферу оригинальной игры SMBX, писанной на VB6.
- Чтобы игра работала на не-Windows платформах без необходимости использовать Wine, а также запускать игру на других процессорах, отличных от x86 (например ARM).
- Чтобы была возможность оптимизировать игру, используя меньше аппаратных ресурсов, в отличии от оригинальной игры, основанной на VB6.


## У тебя есть Moondust-движок, зачем ты портатил больше месяца на то, чтобы создать эту вещь?
Мне оно нужно для разработки Moondust-движка напрямую. С ним мне намного проще исследовать и экспериментировать, чем через старую и неудобную среду VB6.


## Какое будущее у движка Mooddust (ранее PGE) с тех пор как существует TheXTech?
Я продолжу разработку Moondust-движка, поскльку мне всё равно надо исполнить вторую цель Moondust Project.
С момента основания у Moondust Project было две цели: 1) спасти SMBX; 2) предоставить гибкий набор для создания новых игр-платформеров. Открытие исходников SMBX и связанное с этим появление TheXTech, полностью исполнило первую цель: SMBX спасён, и теперь это свободное ПО с открытым исходным кодом. Moondust-движок останется для исполнения второй цели - предоставить набор для новых игр. В отличии от TheXTech, Moondust-движок даёт максимальную гибкость, которая позволяет каждому создать что-либо с нуля, без необходимости наследовать старую игровую базу. Однако, TheXTech нужен для Moondust-движка в качестве модели для исследований, чтобы разработать новый движок. В итоге, результат будет схож с портами игры Doom: GZDoom и Chocolate Doom. GZDoom - мощный и функциональный движок, лучший выбор для моддеров. Chocolate Doom - это высокоточный порт оригинальной игры на современные платформы с целью предоставить оригинальную игру, включая даже баги. Moondust-движок стремится быть похожим на GZDoom в то время, как TheXTech будет аналогом Chocolate Doom с целью повторить оригинальную игру на современных платформах.


## Смогут ли уровни и эпизоды с LunaDLL Autocode работать в этой игре?
Да, смогут. Начиная с версии TheXTech 1.3.6, имеется встроенная реализация скриптового языка LunaDLL Autocode, именуемая LunaScript. С этой системой можно запускать LunaDLL-эпизоды на любом оборудовании, даже с процессорной архитектурой, отличной от x86.


## Сможет LunaLua работать в этой игре?
Нет, LunaLua не сможет работать: данный проект бинарно несовместим с LunaLua. Это ещё значит, что контент, предназначенный для SMBX2, также будет несовместим. Планируемая скриптовая система на языке lua не сможет гарантировать совместимость. Поэтому, после возможного появления поддержки lua-скриптов, будет целесообразно портировать, либо создавать с нуля конкретно для TheXTech.


## Почему здесь такой плохой код?
Изначально, большинство кода в папке "src" было написано на VB6 его изначальным автором. Я сделал полное преобразование кода с упором на максимально точное воспроизведение игры. То есть, большинство кода практически идентично тому, что было изначально написано на VB6. Платформа VB6 имела огромное количество всевозможных трудностей и ограничений:
- Все переменные глобальны и доступны из каждого модуля и формы по умолчанию, без каких-либо включений или импортов. Это и есть причина, почему существует "globals.h": этот файл содержит в себе весь полный список глобально доступных переменных.
- Ограниченная и неудобная поддержка классов, почему большая часть кода нагло злоупотребляла большим колличеством глобальных переменных и массивов (также свою лепту привнесло отсутствие опыта у изначального автора, которое стало дополнительным фактором существования всего этого безобразия).
- Все функции во всех модулях глобальны, и могут вызываться из кажого модуля напрямую (за исключением вызовов, помеченных как "приватные"). Из-за чего мне пришлось проделать дополнительную работу по включению заголовков в файлы, где эти вызовы применялись.
- Почему так много `if-elseif-elseif-elseif-elseif-....`? Да, здесь, скорее всего, было бы правильно использовать оператор `switch()` (аналог в VB6: `Select Case`). Ещё одна причина, которая объясняет, что у изначального автора на тот момент времени не хватало опыта, пока он работал над этим проектом.
- Почему такие глубокие лазаньи из `if() { if {} if { .... } }`? На то есть две причины: 1) мало опыта у изначального автора, 2) костыль, предназначенный для того, чтобы не проверять все условия логического выражения в случаях, способных вызвать крэш. В C++, множество условий, разделённых с помощью оператора `&&`, никогда не будут проверены, если одно из них даёт отрицательный результат. В VB6 наборот, ВСЕ узлы выражения исполняются, не зависимо от их реузльтата. Эта разница даёт следующее: в VB6, выражение `if A < 5 And Array(A) = 1 Then` спровоцирует ошибку, если A будет больше пяти. В C++, аналогичное выражение `if(A < 5 && Array[A] == 1)` никогда не спровоцирует ошибку, потому что вторая часть выражения никогда не проверяется, если первая дала отрицательный результат.
- Почему такие длинные выражения по типу `if(id == 1 || id == 3 || id == 4 || ... id == N)`? Вместо того, чтобы создавать кучи подобных выражений, было бы лучше использовать классы и полиморфизм с отдельной логикой для каждого объекта между разными классами. Это также должно решаться с помощью указателей на функции (которые невозможны в VB6 без костылей, однако легко возможны в C++). Однако снова, отсутствие опыта у изначального автора одновременно с огромной кучей ограничений VB6 спровоцировало появление подобных конструкций.



## Как пользоваться игрой?
Имеется несколько способов, как пользоваться этой игрой:
- Имеются уже готовые к работе сборки, просто взять использовать также, как SMBX.
- [Пропустить этот пункт пользователям macOS]: Смешать исполняемый файл игры с существующими игровыми ресурсами: положить исполняемый файл в кореневую папку ресурсов совместно с INI-файлом "thextech.ini", содержащим следующий текст:
```ini
[Main]
force-portable = true
```
, файлами "music.ini", "sounds.ini" и с дополнительной папкой "graphics/ui".
Важно: вся штатная графика должна быть преобразована в PNG. Используйте утилиту GIFs2PNG из комплекта Moondust Project, применив на папке "graphics" с флагом "-d". Не используйте флаг "-r", чтобы сохранить исходные GIF-файлы совместно с новоиспечёнными PNG, если есть в планах продолжить использовать оригинальную игру, написанную на VB6.
- Использовать это в отладочном режиме: в Вашем домашнем каталоге, создайте папку `.PGE_Project` (обязательно должно начинаться с точки), и затем внутри `.PGE_Project`, создать папку "thextech" (на macOS вместо этого нужно создать путь "`~/TheXTech Games/Debug Assets/`"). Это отладочный корень игры, в коротом необходимо разместить полный комплект ресурсов игры и данные эпизодов. Этот каталог будет действовать аналогично корневому каталогу оригинальной игры. Этот режим позволяет запускать исполняемый файл игры из абсолютно любого места на Вашем компьютере, и при этом использовать одно общее местоположение игровых ресурсов для всех сборок (за исключением тех, которые были помечены как портативные с помощью INI-файла).


## Как добавить сторонние эпизоды в версии для macOS?
Если у вас укомплектованная сборка TheXTech, то все встроенные ресурсы находятся внутри вашего .app: "Content/Resources/assets/". Можно изменить содержиеме, однако, этого не рекомендуется делать! Вместо этого, после первого запуска игры в вашем домашнем каталоге появятся следующая директория:

```
   ~/TheXTech Games/<имя игры>/
```
Внутри этой директории будут две пустые папки: "battle" и "worlds", в которые вы сможете положить ваши эпизоды. В подпапку "settings" будут сохранены настройки и сохранения игры.
Логи будут сохранены в папке "`~/Library/Application Support/PGE Project/thextech`".
Если же вы хотите заменить встроенные ресурсы на собственные, можно изменить содержимое пакета приложения, или собрать новую сборку с указанием необходимых флагов CMake, с помощью которых вы сможете упаковать ваш собственный набор ресурсов и иконку для нового пакета, либо же сделать безресурсную сборку (по умолчанию, если не указать никаких аргументов, будет собираться безресурсная сборка по-умолчанию). Поэтому вам нужно разместить полный комплект игровых ресурсов в папку "`~/TheXTech Games/Debug Assets/`", включая все основные ресурсы (графику, музыку, звуки, вводный и завершающий уровни, уровни битв и папки миров по умолчанию).


## В чём разница между этой и оригинальной сборкой игры, созданной на VB6?
- Первым делом, эта игра написана на C++, когда оригинал (как мы уже знаем) был создан на VisualBasic6.
- До выпуска 1.3.6, редактор полностью отсутствовал. Начиная с 1.3.6 имеет встроенный мобильный редактор, работающий в полноэкранном режиме. Им можно управлять не только клавиатурой и мышкой, но и геймпадов или сенсорным экраном. Также, игра имеет глубокую интеграцию с редактором Moondust, которая позволяет использовать игру с той же функциональностью, что и через оригинальный редактор (Была сохранена функциональность "волшебной руки", которая позволяет редактировать уровень в реальном времени во время тестирования).
- Полная поддержка UTF-8 в именах файлов, путях и внутренних текстовых ресурсах (оригинальная игра поддерживала только 8битные кодировки ANSI).
- Игра использует SDL2 для графики и управления в то время, как оригинальная игра использовала вызовы WinAPI и библиотеки GDI.
- Игра использует библиотеку PGE-FL для улучшенной поддержки форматов файлов.
- Имеется поддержка карт мира WLDX, которые позволяют сохранять неограниченное число строк титров, а также встроенная поддежка использования сторонней музыки без необходимости использовать music.ini.
- В игре работают некоторые уникальные возможности уровней LVLX: вертикальное соединение; двунаправленные проходы; возможность указать собственное сообщение, чтобы рассказать о необходимом числе звёзд для взода в проход; событие входа в проход; возможность отключить отображение числа звёзд над определёнными дверями в корридорных мирах; возможность отключить входной экран при переходе между уровнями через проход.
- Встроенная поддержка файлов "music.ini" и "sounds.ini" для замены музыки и звуков на отдельных уровнях, и даже в целых эпизодах.
- Карты мира отныне поддерживают собственную директорию, чтобы размещать в ней любые специфичные ресурсы (ландшафт, декорации, пути, уровни), и при этом больше не засорять корневую папкпу эпизода ресурсами карты мира.
- Формат настроек теперь INI, старый формат config.dat больше не поддерживается, первым делом из-за несовместимых форматов кодов клавиш (SDL_Scancode против VirtualKeys из Windows API).
- Сохранения игры отныне используют формат SAVX вместо классического SAV. Однако, если у вас уже имеется старое сохранение, вы всё ещё можете продожить игру, используя новый движок (при следующем сохранеии игры, будет создан файл в новом SAVX-формате, старое сохранение игры останется нетронутым).
- Встроенная поддкржика PNG для сторонней и встроенной графики. Масковые GIF по прежнему поддерживаются для обратной совместимости, однако, без автопреобразований, как это обычно делает SMBX-38A.
- Контрольные точки отныне можно использовать по много раз! Вы сможете использовать их на ваших уровнях по несколько раз без каких либо ограничений!
- Игра использует алгоритм ленивой распаковки, чтобы ускорить время загрузки игры и уменьшить использование памяти.
- Был полностью переработан алгоритм поиска объектов, чего позволило полностью решить проблему сильного замедления на слабых машинах из-за горизонтального движения слоёв (См. подробное описание проблемы тут: [Проблема Доктора Пеппера](https://wohlsoft.ru/pgewiki/DrPepper_Problem/ru))
- Игра использует библиотеку MixerX для звука и музыки, которая поддерживает огрномное число различных аудиоформатов!
- Игра не внедряет в сборку какую-либо графику: отныне в игре больше НИКАКИХ истинно "внедрённых" ресурсов, теперь вся графика представлена в виде внешних ресурсов!
- Расширены некоторые встроенные ограничения.
- Встроення запись GIF с помощью клавиши F11 (на macOS используется клавиша F10, F11 используется системой, чтобы показать/скрыть рабочий сто).
- Игра запускается быстрее: игра загружается почти мгновенно (зависит от компьютера и производительности его диска).
- Игра использует меньше оперативной памяти (вместо 600...800 мегабайт, игра теперь в среднем использует 80...150 мегабайт), а также, она теперь чиста от утечек в памяти, вызванных MCI-интерфейсом, который использовался в оригинальной игре.
- Игра больше не перегружает процессор до 100% (проблема была из-за неправильного способа обработки вечных циклов, я также исправил этот деффект и в VB6-сборке в ветке "smbx-experiments").
- Игра способна работать даже на "тостере" (старом/слабом компьютере) в то время как VB6-SMBX не можеты.
- Игра полностью кросс-платформенна, и больше не зависит от Windows, а также больше не зависит от процессоров x86: игра сможет работать на ARM и MIPS-процессорах тоже (VB6-SMBX зависит от Windows и x86).


## Как собрать игру?
Вы можете почитать подробно инструкцию сборки этого проекта из исходников тут: https://github.com/Wohlstand/TheXTech/wiki/Building-the-game

Чтобы собрать игру, нужно иметь несколько вещей:
- CMake
- Ninja, не обязательно (чтобы ускорить процесс сборки)
- Совместимый компилятор C/C++ (GCC, Clang, MinGW, MSVC 2017 и 2019, вожможно будет собираться и в MSVC 2015, но не проверено)
- Git (нужен для загрузки подмодулей и клонирования исходников зависисимых библиотек для их сборки на месте)
- Mercurial (необходим для загрузки исходников с официального репозитория SDL2, чтобы собрать его на месте)
- Не обязательно: зависимости, установленные в систему: SDL2, libFreeImageLite (модифицированная реализация FreeImage), звуковая библиотека MixerX, коллекция библиотек AudioCodecs. Если все эти зависимости установлены в системе, процесс сборки будет идти значительно быстрее. Однако, возможно собирать все зависимости прямо на месте, но при этом сборка будет идти дольше.


## Локализация
Некоторые части TheXTech можно локазиловать (напримет, загрузчик на Android), Вы можете помочь перевести их, используя платформу WebLate: https://hosted.weblate.org/projects/thextech/


## Используемые инструменты
* GCC, MinGW-w64 и Clang - основные компиляторы, используемые во время разработки игры. Редко MSVC, который используется исключительно для Windows-сборок под процессоры ARM64.
* [Qt Creator](https://www.qt.io/product/development-tools) - среда разработки из комплекта Qt, в основном используемя при разработке.
* [JetBrans CLion](https://www.jetbrains.com/ru-ru/clion/) - среда разработки для C/C++ на базе Intelliji Idea, бесплатна по [лицензии для СПО](https://www.jetbrains.com/ru-ru/community/opensource/).
* [PVS-Studio](https://pvs-studio.com/ru/pvs-studio/?utm_source=website&utm_medium=github&utm_campaign=open_source) - статический анализатор кода для C, C++, C# и Java. Используется для периодических проверок кода на возможные ошибки. Бесплатен по [лицензии для СПО](https://pvs-studio.com/ru/order/open-source-license/).
